/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import java.io.Reader;
import java.io.StringReader;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.TimeZone;
import org.traccar.BaseHttpProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class DmtHttpProtocolDecoder
extends BaseHttpProtocolDecoder {
    public DmtHttpProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        FullHttpRequest request = (FullHttpRequest)msg;
        JsonObject root = Json.createReader((Reader)new StringReader(request.content().toString(StandardCharsets.US_ASCII))).readObject();
        Object result = root.containsKey((Object)"device") ? this.decodeEdge(channel, remoteAddress, root) : this.decodeTraditional(channel, remoteAddress, root);
        this.sendResponse(channel, result != null ? HttpResponseStatus.OK : HttpResponseStatus.BAD_REQUEST);
        return result;
    }

    private Collection<Position> decodeTraditional(Channel channel, SocketAddress remoteAddress, JsonObject root) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, root.getString("IMEI"));
        if (deviceSession == null) {
            return null;
        }
        LinkedList<Position> positions = new LinkedList<Position>();
        JsonArray records = root.getJsonArray("Records");
        for (int i = 0; i < records.size(); ++i) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            JsonObject record = records.getJsonObject(i);
            position.set("index", record.getInt("SeqNo"));
            position.set("event", record.getInt("Reason"));
            position.setDeviceTime(dateFormat.parse(record.getString("DateUTC")));
            JsonArray fields = record.getJsonArray("Fields");
            block6: for (int j = 0; j < fields.size(); ++j) {
                JsonObject field = fields.getJsonObject(j);
                switch (field.getInt("FType")) {
                    case 0: {
                        position.setFixTime(dateFormat.parse(field.getString("GpsUTC")));
                        position.setLatitude(field.getJsonNumber("Lat").doubleValue());
                        position.setLongitude(field.getJsonNumber("Long").doubleValue());
                        position.setAltitude(field.getInt("Alt"));
                        position.setSpeed(UnitsConverter.knotsFromCps(field.getInt("Spd")));
                        position.setCourse(field.getInt("Head"));
                        position.setAccuracy(field.getInt("PosAcc"));
                        position.setValid(field.getInt("GpsStat") > 0);
                        continue block6;
                    }
                    case 2: {
                        int input = field.getInt("DIn");
                        int output = field.getInt("DOut");
                        position.set("ignition", BitUtil.check(input, 0));
                        position.set("input", input);
                        position.set("output", output);
                        position.set("status", field.getInt("DevStat"));
                        continue block6;
                    }
                    case 6: {
                        JsonObject adc = field.getJsonObject("AnalogueData");
                        if (adc.containsKey((Object)"1")) {
                            position.set("battery", (double)adc.getInt("1") * 0.001);
                        }
                        if (adc.containsKey((Object)"2")) {
                            position.set("power", (double)adc.getInt("2") * 0.01);
                        }
                        if (adc.containsKey((Object)"3")) {
                            position.set("deviceTemp", (double)adc.getInt("3") * 0.01);
                        }
                        if (adc.containsKey((Object)"4")) {
                            position.set("rssi", adc.getInt("4"));
                        }
                        if (!adc.containsKey((Object)"5")) continue block6;
                        position.set("solarPower", (double)adc.getInt("5") * 0.001);
                        continue block6;
                    }
                }
            }
            positions.add(position);
        }
        return positions;
    }

    private Position decodeEdge(Channel channel, SocketAddress remoteAddress, JsonObject root) {
        int i;
        JsonObject device = root.getJsonObject("device");
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, device.getString("imei"));
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        Date time = new Date(OffsetDateTime.parse(root.getString("date")).toInstant().toEpochMilli());
        if (root.containsKey((Object)"lat") && root.containsKey((Object)"lng")) {
            position.setValid(true);
            position.setTime(time);
            position.setLatitude(root.getJsonNumber("lat").doubleValue());
            position.setLongitude(root.getJsonNumber("lng").doubleValue());
            position.setAccuracy(root.getJsonNumber("posAcc").doubleValue());
        } else {
            this.getLastLocation(position, time);
        }
        position.set("index", root.getInt("sqn"));
        position.set("event", root.getInt("reason"));
        if (root.containsKey((Object)"analogues")) {
            JsonArray analogues = root.getJsonArray("analogues");
            for (i = 0; i < analogues.size(); ++i) {
                JsonObject adc = analogues.getJsonObject(i);
                position.set("adc" + adc.getInt("id"), adc.getInt("val"));
            }
        }
        if (root.containsKey((Object)"inputs")) {
            int input = root.getInt("inputs");
            position.set("ignition", BitUtil.check(input, 0));
            position.set("input", input);
        }
        if (root.containsKey((Object)"outputs")) {
            position.set("output", root.getInt("outputs"));
        }
        if (root.containsKey((Object)"status")) {
            position.set("status", root.getInt("status"));
        }
        if (root.containsKey((Object)"counters")) {
            JsonArray counters = root.getJsonArray("counters");
            block5: for (i = 0; i < counters.size(); ++i) {
                JsonObject counter = counters.getJsonObject(i);
                switch (counter.getInt("id")) {
                    case 0: {
                        position.set("battery", (double)counter.getInt("val") * 0.001);
                        continue block5;
                    }
                    case 1: {
                        position.set("batteryLevel", (double)counter.getInt("val") * 0.01);
                        continue block5;
                    }
                    default: {
                        position.set("counter" + counter.getInt("id"), counter.getInt("val"));
                    }
                }
            }
        }
        return position;
    }
}

