/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.Date;
import java.util.LinkedList;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class Dsf22ProtocolDecoder
extends BaseProtocolDecoder {
    public Dsf22ProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.skipBytes(2);
        String id = String.valueOf(buf.readUnsignedShortLE());
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, id);
        if (deviceSession == null) {
            return null;
        }
        LinkedList<Position> positions = new LinkedList<Position>();
        int count = buf.readUnsignedByte();
        for (int i = 0; i < count; ++i) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            position.setValid(true);
            position.setLatitude((double)buf.readIntLE() / 1.0E7);
            position.setLongitude((double)buf.readIntLE() / 1.0E7);
            position.setTime(new Date(buf.readUnsignedIntLE() * 1000L));
            position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedByte()));
            position.set("fuel", (double)buf.readUnsignedShortLE() * 0.001);
            short status = buf.readUnsignedByte();
            position.set("ignition", BitUtil.check(status, 0));
            position.set("in1", BitUtil.check(status, 1));
            position.set("out1", BitUtil.check(status, 4));
            position.addAlarm(BitUtil.check(status, 6) ? "jamming" : null);
            position.set("status", Integer.valueOf(status));
            positions.add(position);
        }
        if (channel != null) {
            byte[] response = new byte[]{1};
            channel.writeAndFlush((Object)new NetworkMessage(Unpooled.wrappedBuffer((byte[])response), remoteAddress));
        }
        return positions;
    }
}

