/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class Pt502ProtocolDecoder
extends BaseProtocolDecoder {
    private static final int MAX_CHUNK_SIZE = 960;
    private ByteBuf photo;
    private static final Pattern PATTERN = new PatternBuilder().any().text("$").expression("([^,]+),").number("(d+),").number("(dd)(dd)(dd).(ddd),").expression("([AV]),").number("(d+)(dd.dddd),").expression("([NS]),").number("(d+)(dd.dddd),").expression("([EW]),").number("(d+.d+)?,").number("(d+.d+)?,").number("(dd)(dd)(dd),,,?").expression(".?/").expression("([01])+,").expression("([01])+/").expression("([^/]+)?/").number("(d+)").expression("/([^/]+)?/").number("(xxx)").optional(2).any().compile();

    public Pt502ProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private String decodeAlarm(String value) {
        return switch (value) {
            case "IN1" -> "sos";
            case "GOF" -> "geofence";
            case "TOW" -> "tow";
            case "HDA" -> "hardAcceleration";
            case "HDB" -> "hardBraking";
            case "FDA" -> "fatigueDriving";
            case "SKA" -> "vibration";
            case "PMA" -> "movement";
            case "CPA" -> "powerCut";
            default -> null;
        };
    }

    private Position decodePosition(Channel channel, SocketAddress remoteAddress, String sentence) {
        Parser parser = new Parser(PATTERN, sentence);
        if (!parser.matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.addAlarm(this.decodeAlarm(parser.next()));
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        position.setDeviceId(deviceSession.getDeviceId());
        DateBuilder dateBuilder = new DateBuilder().setTime(parser.nextInt(), parser.nextInt(), parser.nextInt(), parser.nextInt());
        position.setValid(parser.next().equals("A"));
        position.setLatitude(parser.nextCoordinate());
        position.setLongitude(parser.nextCoordinate());
        position.setSpeed(parser.nextDouble(0.0));
        position.setCourse(parser.nextDouble(0.0));
        dateBuilder.setDateReverse(parser.nextInt(), parser.nextInt(), parser.nextInt());
        position.setTime(dateBuilder.getDate());
        position.set("input", parser.next());
        position.set("output", parser.next());
        if (parser.hasNext()) {
            String[] values = parser.next().split(",");
            for (int i = 0; i < values.length; ++i) {
                position.set("adc" + (i + 1), Integer.parseInt(values[i], 16));
            }
        }
        position.set("odometer", parser.nextInt(0));
        position.set("driverUniqueId", parser.next());
        if (parser.hasNext()) {
            int value = parser.nextHexInt(0);
            position.set("battery", value >> 8);
            position.set("rssi", value >> 4 & 0xF);
            position.set("sat", value & 0xF);
        }
        return position;
    }

    private void requestPhotoFragment(Channel channel) {
        if (channel != null) {
            int offset = this.photo.writerIndex();
            int size = Math.min(this.photo.writableBytes(), 960);
            channel.writeAndFlush((Object)new NetworkMessage("#PHD" + offset + "," + size + "\r\n", channel.remoteAddress()));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        int typeEndIndex = buf.indexOf(buf.readerIndex(), buf.writerIndex(), (byte)44);
        String type = buf.toString(buf.readerIndex(), typeEndIndex - buf.readerIndex(), StandardCharsets.US_ASCII);
        if (!type.startsWith("$PHD")) {
            if (!type.startsWith("$PHO")) return this.decodePosition(channel, remoteAddress, buf.toString(StandardCharsets.US_ASCII));
            int size = Integer.parseInt(type.split("-")[0].substring(4));
            if (size <= 0) return this.decodePosition(channel, remoteAddress, buf.toString(StandardCharsets.US_ASCII));
            this.photo = Unpooled.buffer((int)size);
            this.requestPhotoFragment(channel);
            return this.decodePosition(channel, remoteAddress, buf.toString(StandardCharsets.US_ASCII));
        }
        int dataIndex = buf.indexOf(typeEndIndex + 1, buf.writerIndex(), (byte)44) + 1;
        buf.readerIndex(dataIndex);
        if (this.photo == null) return null;
        this.photo.writeBytes(buf.readSlice(buf.readableBytes()));
        if (this.photo.writableBytes() > 0) {
            this.requestPhotoFragment(channel);
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        this.getLastLocation(position, null);
        position.set("image", this.writeMediaFile(deviceSession.getUniqueId(), this.photo, "jpg"));
        this.photo.release();
        this.photo = null;
        return position;
    }
}

