/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.utils;

import java.util.ArrayList;

public final class Strings {
    private static final char CHAR_0 = '0';
    private static final char CHAR_1 = '1';
    private static final char CHAR_9 = '9';
    private static final char MINUS = '-';
    private static final char PLUS = '+';
    private static final char DOT = '.';
    private static final char CHAR_E = 'E';
    private static final char CHAR_e = 'e';

    private Strings() {
    }

    public static boolean isInteger(String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        int i = 0;
        if (string.charAt(0) == '-' || string.charAt(0) == '+') {
            if (string.length() == 1) {
                return false;
            }
            i = 1;
        }
        while (i < string.length()) {
            char c = string.charAt(i);
            if (c < '0' || c > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isBoolean(String string) {
        return "true".equals(string) || "false".equals(string);
    }

    public static boolean isNumeric(String string) {
        char character;
        if (string == null || string.isEmpty()) {
            return false;
        }
        int i = 0;
        int len = string.length();
        if (string.charAt(i) == '-' || string.charAt(i) == '+') {
            if (string.length() == 1) {
                return false;
            }
            i = 1;
        }
        if ((character = string.charAt(i++)) == '0') {
            if (i < len && (character = string.charAt(i++)) != '.' && character != 'E' && character != 'e') {
                return false;
            }
        } else if ('1' <= character && character <= '9') {
            while (i < len && '0' <= character && character <= '9') {
                character = string.charAt(i++);
            }
        } else {
            return false;
        }
        if (character == '.') {
            if (i >= len) {
                return false;
            }
            character = string.charAt(i++);
            while (i < len && '0' <= character && character <= '9') {
                character = string.charAt(i++);
            }
        }
        if (character == 'E' || character == 'e') {
            if (i >= len) {
                return false;
            }
            if ((character = string.charAt(i++)) == '+' || character == '-') {
                if (i >= len) {
                    return false;
                }
                character = string.charAt(i++);
            }
            while (i < len && '0' <= character && character <= '9') {
                character = string.charAt(i++);
            }
        }
        return i >= len && '0' <= character && character <= '9';
    }

    public static boolean isBlank(String string) {
        return null == string || string.trim().isEmpty();
    }

    public static String[] split(String text, char delimiter) {
        if (text == null) {
            return new String[0];
        }
        if (text.isEmpty()) {
            return new String[]{""};
        }
        ArrayList<String> segments = new ArrayList<String>();
        int start = 0;
        while (start <= text.length()) {
            int end = text.indexOf(delimiter, start);
            if (end == -1) {
                end = text.length();
            }
            String segment = text.substring(start, end);
            segments.add(segment);
            if (end == text.length()) break;
            start = end + 1;
        }
        return segments.toArray(new String[segments.size()]);
    }
}

