/*
 * Decompiled with CFR 0.152.
 */
package org.openide.windows;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class OpenComponentAction
implements ActionListener {
    private TopComponent component;
    private final Map<?, ?> map;

    OpenComponentAction(TopComponent topComponent) {
        assert (topComponent != null);
        this.component = topComponent;
        this.map = null;
    }

    OpenComponentAction(Map<?, ?> map) {
        this.map = map;
    }

    private TopComponent getTopComponent() {
        assert (EventQueue.isDispatchThread());
        if (this.component != null) {
            return this.component;
        }
        TopComponent topComponent = null;
        Object obj = this.map.get("preferredID");
        if (obj instanceof String) {
            topComponent = WindowManager.getDefault().findTopComponent((String)obj);
        }
        if (topComponent == null) {
            topComponent = (TopComponent)this.map.get("component");
        }
        if (obj != null) {
            this.component = topComponent;
        }
        return topComponent;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        TopComponent topComponent = this.getTopComponent();
        if (null == topComponent) {
            throw new IllegalStateException("Cannot find TopComponent with preferredID " + this.map.get("preferredID") + ", see IDE log for more details.");
        }
        topComponent.open();
        topComponent.requestActive();
    }
}

