/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.atsc;

import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.atsc.ATSCStyle;
import org.w3c.css.properties.atsc.CssBackgroundATSC;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssColor;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;

public class CssBackgroundColorATSC
extends CssProperty {
    CssValue color;
    static CssIdent transparent = new CssIdent("transparent");

    public CssBackgroundColorATSC() {
        this.color = transparent;
    }

    public CssBackgroundColorATSC(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        if (check && expression.getCount() > 1) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        CssValue val = expression.getValue();
        if (val instanceof CssColor) {
            this.color = val;
            expression.next();
        } else if (val instanceof CssIdent) {
            if (val.equals(transparent)) {
                this.color = transparent;
                expression.next();
            } else if (val.equals(inherit)) {
                this.color = inherit;
                expression.next();
            } else {
                this.color = new CssColor(ac, (String)val.get());
                expression.next();
            }
        } else {
            throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
        }
    }

    public CssBackgroundColorATSC(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    @Override
    public Object get() {
        return this.color;
    }

    public final CssValue getColor() {
        return this.color;
    }

    @Override
    public boolean isSoftlyInherited() {
        return this.color.equals(inherit);
    }

    @Override
    public String toString() {
        return this.color.toString();
    }

    @Override
    public void addToStyle(ApplContext ac, CssStyle style) {
        CssBackgroundATSC cssBackground = ((ATSCStyle)style).cssBackgroundATSC;
        if (cssBackground.color != null) {
            style.addRedefinitionWarning(ac, this);
        }
        cssBackground.color = this;
    }

    @Override
    public CssProperty getPropertyInStyle(CssStyle style, boolean resolve) {
        if (resolve) {
            return ((ATSCStyle)style).getBackgroundColorATSC();
        }
        return ((ATSCStyle)style).cssBackgroundATSC.color;
    }

    @Override
    public boolean equals(CssProperty property) {
        return property instanceof CssBackgroundColorATSC && this.color.equals(((CssBackgroundColorATSC)property).color);
    }

    @Override
    public String getPropertyName() {
        return "background-color";
    }

    @Override
    public boolean isDefault() {
        return this.color == transparent;
    }
}

