/*-------------------------------------------------------------------------
 *
 * fmgroids.h
 *    Macros that define the OIDs of built-in functions.
 *
 * These macros can be used to avoid a catalog lookup when a specific
 * fmgr-callable function needs to be referenced.
 *
 * Portions Copyright (c) 1996-2025, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * NOTES
 *	******************************
 *	*** DO NOT EDIT THIS FILE! ***
 *	******************************
 *
 *	It has been GENERATED by src/backend/utils/Gen_fmgrtab.pl
 *
 *-------------------------------------------------------------------------
 */
#ifndef FMGROIDS_H
#define FMGROIDS_H

/*
 *	Constant macros for the OIDs of entries in pg_proc.
 *
 *	F_XXX macros are named after the proname field; if that is not unique,
 *	we append the proargtypes field, replacing spaces with underscores.
 *	For example, we have F_OIDEQ because that proname is unique, but
 *	F_POW_FLOAT8_FLOAT8 (among others) because that proname is not.
 */
#define F_HEAP_TABLEAM_HANDLER 3
#define F_BYTEAOUT 31
#define F_CHAROUT 33
#define F_NAMEIN 34
#define F_NAMEOUT 35
#define F_INT2IN 38
#define F_INT2OUT 39
#define F_INT2VECTORIN 40
#define F_INT2VECTOROUT 41
#define F_INT4IN 42
#define F_INT4OUT 43
#define F_REGPROCIN 44
#define F_REGPROCOUT 45
#define F_TEXTIN 46
#define F_TEXTOUT 47
#define F_TIDIN 48
#define F_TIDOUT 49
#define F_XIDIN 50
#define F_XIDOUT 51
#define F_CIDIN 52
#define F_CIDOUT 53
#define F_OIDVECTORIN 54
#define F_OIDVECTOROUT 55
#define F_BOOLLT 56
#define F_BOOLGT 57
#define F_BOOLEQ 60
#define F_CHAREQ 61
#define F_NAMEEQ 62
#define F_INT2EQ 63
#define F_INT2LT 64
#define F_INT4EQ 65
#define F_INT4LT 66
#define F_TEXTEQ 67
#define F_XIDEQ 68
#define F_CIDEQ 69
#define F_CHARNE 70
#define F_CHARLE 72
#define F_CHARGT 73
#define F_CHARGE 74
#define F_INT4_CHAR 77
#define F_CHAR_INT4 78
#define F_NAMEREGEXEQ 79
#define F_BOOLNE 84
#define F_PG_DDL_COMMAND_IN 86
#define F_PG_DDL_COMMAND_OUT 87
#define F_PG_DDL_COMMAND_RECV 88
#define F_VERSION 89
#define F_PG_DDL_COMMAND_SEND 90
#define F_EQSEL 101
#define F_NEQSEL 102
#define F_SCALARLTSEL 103
#define F_SCALARGTSEL 104
#define F_EQJOINSEL 105
#define F_NEQJOINSEL 106
#define F_SCALARLTJOINSEL 107
#define F_SCALARGTJOINSEL 108
#define F_UNKNOWNIN 109
#define F_UNKNOWNOUT 110
#define F_BOX_ABOVE_EQ 115
#define F_BOX_BELOW_EQ 116
#define F_POINT_IN 117
#define F_POINT_OUT 118
#define F_LSEG_IN 119
#define F_LSEG_OUT 120
#define F_PATH_IN 121
#define F_PATH_OUT 122
#define F_BOX_IN 123
#define F_BOX_OUT 124
#define F_BOX_OVERLAP 125
#define F_BOX_GE 126
#define F_BOX_GT 127
#define F_BOX_EQ 128
#define F_BOX_LT 129
#define F_BOX_LE 130
#define F_POINT_ABOVE 131
#define F_POINT_LEFT 132
#define F_POINT_RIGHT 133
#define F_POINT_BELOW 134
#define F_POINT_EQ 135
#define F_ON_PB 136
#define F_ON_PPATH 137
#define F_BOX_CENTER 138
#define F_AREASEL 139
#define F_AREAJOINSEL 140
#define F_INT4MUL 141
#define F_INT4NE 144
#define F_INT2NE 145
#define F_INT2GT 146
#define F_INT4GT 147
#define F_INT2LE 148
#define F_INT4LE 149
#define F_INT4GE 150
#define F_INT2GE 151
#define F_INT2MUL 152
#define F_INT2DIV 153
#define F_INT4DIV 154
#define F_INT2MOD 155
#define F_INT4MOD 156
#define F_TEXTNE 157
#define F_INT24EQ 158
#define F_INT42EQ 159
#define F_INT24LT 160
#define F_INT42LT 161
#define F_INT24GT 162
#define F_INT42GT 163
#define F_INT24NE 164
#define F_INT42NE 165
#define F_INT24LE 166
#define F_INT42LE 167
#define F_INT24GE 168
#define F_INT42GE 169
#define F_INT24MUL 170
#define F_INT42MUL 171
#define F_INT24DIV 172
#define F_INT42DIV 173
#define F_INT2PL 176
#define F_INT4PL 177
#define F_INT24PL 178
#define F_INT42PL 179
#define F_INT2MI 180
#define F_INT4MI 181
#define F_INT24MI 182
#define F_INT42MI 183
#define F_OIDEQ 184
#define F_OIDNE 185
#define F_BOX_SAME 186
#define F_BOX_CONTAIN 187
#define F_BOX_LEFT 188
#define F_BOX_OVERLEFT 189
#define F_BOX_OVERRIGHT 190
#define F_BOX_RIGHT 191
#define F_BOX_CONTAINED 192
#define F_BOX_CONTAIN_PT 193
#define F_PG_NODE_TREE_IN 195
#define F_PG_NODE_TREE_OUT 196
#define F_PG_NODE_TREE_RECV 197
#define F_PG_NODE_TREE_SEND 198
#define F_FLOAT4IN 200
#define F_FLOAT4OUT 201
#define F_FLOAT4MUL 202
#define F_FLOAT4DIV 203
#define F_FLOAT4PL 204
#define F_FLOAT4MI 205
#define F_FLOAT4UM 206
#define F_FLOAT4ABS 207
#define F_FLOAT4_ACCUM 208
#define F_FLOAT4LARGER 209
#define F_FLOAT4SMALLER 211
#define F_INT4UM 212
#define F_INT2UM 213
#define F_FLOAT8IN 214
#define F_FLOAT8OUT 215
#define F_FLOAT8MUL 216
#define F_FLOAT8DIV 217
#define F_FLOAT8PL 218
#define F_FLOAT8MI 219
#define F_FLOAT8UM 220
#define F_FLOAT8ABS 221
#define F_FLOAT8_ACCUM 222
#define F_FLOAT8LARGER 223
#define F_FLOAT8SMALLER 224
#define F_LSEG_CENTER 225
#define F_POLY_CENTER 227
#define F_DROUND 228
#define F_DTRUNC 229
#define F_DSQRT 230
#define F_DCBRT 231
#define F_DPOW 232
#define F_DEXP 233
#define F_DLOG1 234
#define F_FLOAT8_INT2 235
#define F_FLOAT4_INT2 236
#define F_INT2_FLOAT8 237
#define F_INT2_FLOAT4 238
#define F_LINE_DISTANCE 239
#define F_NAMEEQTEXT 240
#define F_NAMELTTEXT 241
#define F_NAMELETEXT 242
#define F_NAMEGETEXT 243
#define F_NAMEGTTEXT 244
#define F_NAMENETEXT 245
#define F_BTNAMETEXTCMP 246
#define F_TEXTEQNAME 247
#define F_TEXTLTNAME 248
#define F_TEXTLENAME 249
#define F_TEXTGENAME 250
#define F_TEXTGTNAME 251
#define F_TEXTNENAME 252
#define F_BTTEXTNAMECMP 253
#define F_NAMECONCATOID 266
#define F_TABLE_AM_HANDLER_IN 267
#define F_TABLE_AM_HANDLER_OUT 268
#define F_TIMEOFDAY 274
#define F_PG_NEXTOID 275
#define F_FLOAT8_COMBINE 276
#define F_INTER_SL 277
#define F_INTER_LB 278
#define F_FLOAT48MUL 279
#define F_FLOAT48DIV 280
#define F_FLOAT48PL 281
#define F_FLOAT48MI 282
#define F_FLOAT84MUL 283
#define F_FLOAT84DIV 284
#define F_FLOAT84PL 285
#define F_FLOAT84MI 286
#define F_FLOAT4EQ 287
#define F_FLOAT4NE 288
#define F_FLOAT4LT 289
#define F_FLOAT4LE 290
#define F_FLOAT4GT 291
#define F_FLOAT4GE 292
#define F_FLOAT8EQ 293
#define F_FLOAT8NE 294
#define F_FLOAT8LT 295
#define F_FLOAT8LE 296
#define F_FLOAT8GT 297
#define F_FLOAT8GE 298
#define F_FLOAT48EQ 299
#define F_FLOAT48NE 300
#define F_FLOAT48LT 301
#define F_FLOAT48LE 302
#define F_FLOAT48GT 303
#define F_FLOAT48GE 304
#define F_FLOAT84EQ 305
#define F_FLOAT84NE 306
#define F_FLOAT84LT 307
#define F_FLOAT84LE 308
#define F_FLOAT84GT 309
#define F_FLOAT84GE 310
#define F_FLOAT8_FLOAT4 311
#define F_FLOAT4_FLOAT8 312
#define F_INT4_INT2 313
#define F_INT2_INT4 314
#define F_PG_JIT_AVAILABLE 315
#define F_FLOAT8_INT4 316
#define F_INT4_FLOAT8 317
#define F_FLOAT4_INT4 318
#define F_INT4_FLOAT4 319
#define F_WIDTH_BUCKET_FLOAT8_FLOAT8_FLOAT8_INT4 320
#define F_JSON_IN 321
#define F_JSON_OUT 322
#define F_JSON_RECV 323
#define F_JSON_SEND 324
#define F_INDEX_AM_HANDLER_IN 326
#define F_INDEX_AM_HANDLER_OUT 327
#define F_HASHMACADDR8 328
#define F_HASH_ACLITEM 329
#define F_BTHANDLER 330
#define F_HASHHANDLER 331
#define F_GISTHANDLER 332
#define F_GINHANDLER 333
#define F_SPGHANDLER 334
#define F_BRINHANDLER 335
#define F_SCALARLESEL 336
#define F_SCALARGESEL 337
#define F_AMVALIDATE 338
#define F_POLY_SAME 339
#define F_POLY_CONTAIN 340
#define F_POLY_LEFT 341
#define F_POLY_OVERLEFT 342
#define F_POLY_OVERRIGHT 343
#define F_POLY_RIGHT 344
#define F_POLY_CONTAINED 345
#define F_POLY_OVERLAP 346
#define F_POLY_IN 347
#define F_POLY_OUT 348
#define F_BTINT2CMP 350
#define F_BTINT4CMP 351
#define F_BTFLOAT4CMP 354
#define F_BTFLOAT8CMP 355
#define F_BTOIDCMP 356
#define F_DIST_BP 357
#define F_BTCHARCMP 358
#define F_BTNAMECMP 359
#define F_BTTEXTCMP 360
#define F_LSEG_DISTANCE 361
#define F_LSEG_INTERPT 362
#define F_DIST_PS 363
#define F_DIST_PB 364
#define F_DIST_SB 365
#define F_CLOSE_PS 366
#define F_CLOSE_PB 367
#define F_CLOSE_SB 368
#define F_ON_PS 369
#define F_PATH_DISTANCE 370
#define F_DIST_PPATH 371
#define F_ON_SB 372
#define F_INTER_SB 373
#define F_STRING_TO_ARRAY_TEXT_TEXT_TEXT 376
#define F_CASH_CMP 377
#define F_ARRAY_APPEND 378
#define F_ARRAY_PREPEND 379
#define F_DIST_SP 380
#define F_DIST_BS 381
#define F_BTARRAYCMP 382
#define F_ARRAY_CAT 383
#define F_ARRAY_TO_STRING_ANYARRAY_TEXT_TEXT 384
#define F_SCALARLEJOINSEL 386
#define F_ARRAY_NE 390
#define F_ARRAY_LT 391
#define F_ARRAY_GT 392
#define F_ARRAY_LE 393
#define F_STRING_TO_ARRAY_TEXT_TEXT 394
#define F_ARRAY_TO_STRING_ANYARRAY_TEXT 395
#define F_ARRAY_GE 396
#define F_SCALARGEJOINSEL 398
#define F_HASHMACADDR 399
#define F_HASHTEXT 400
#define F_TEXT_BPCHAR 401
#define F_BTOIDVECTORCMP 404
#define F_TEXT_NAME 406
#define F_NAME_TEXT 407
#define F_BPCHAR_NAME 408
#define F_NAME_BPCHAR 409
#define F_DIST_PATHP 421
#define F_HASHINET 422
#define F_HASHINT4EXTENDED 425
#define F_HASH_NUMERIC 432
#define F_MACADDR_IN 436
#define F_MACADDR_OUT 437
#define F_NUM_NULLS 438
#define F_NUM_NONNULLS 440
#define F_HASHINT2EXTENDED 441
#define F_HASHINT8EXTENDED 442
#define F_HASHFLOAT4EXTENDED 443
#define F_HASHFLOAT8EXTENDED 444
#define F_HASHOIDEXTENDED 445
#define F_HASHCHAREXTENDED 446
#define F_HASHNAMEEXTENDED 447
#define F_HASHTEXTEXTENDED 448
#define F_HASHINT2 449
#define F_HASHINT4 450
#define F_HASHFLOAT4 451
#define F_HASHFLOAT8 452
#define F_HASHOID 453
#define F_HASHCHAR 454
#define F_HASHNAME 455
#define F_HASHVARLENA 456
#define F_HASHOIDVECTOR 457
#define F_TEXT_LARGER 458
#define F_TEXT_SMALLER 459
#define F_INT8IN 460
#define F_INT8OUT 461
#define F_INT8UM 462
#define F_INT8PL 463
#define F_INT8MI 464
#define F_INT8MUL 465
#define F_INT8DIV 466
#define F_INT8EQ 467
#define F_INT8NE 468
#define F_INT8LT 469
#define F_INT8GT 470
#define F_INT8LE 471
#define F_INT8GE 472
#define F_INT84EQ 474
#define F_INT84NE 475
#define F_INT84LT 476
#define F_INT84GT 477
#define F_INT84LE 478
#define F_INT84GE 479
#define F_INT4_INT8 480
#define F_INT8_INT4 481
#define F_FLOAT8_INT8 482
#define F_INT8_FLOAT8 483
#define F_ARRAY_LARGER 515
#define F_ARRAY_SMALLER 516
#define F_ABBREV_INET 598
#define F_ABBREV_CIDR 599
#define F_SET_MASKLEN_INET_INT4 605
#define F_OIDVECTORNE 619
#define F_HASH_ARRAY 626
#define F_SET_MASKLEN_CIDR_INT4 635
#define F_PG_INDEXAM_HAS_PROPERTY 636
#define F_PG_INDEX_HAS_PROPERTY 637
#define F_PG_INDEX_COLUMN_HAS_PROPERTY 638
#define F_FLOAT4_INT8 652
#define F_INT8_FLOAT4 653
#define F_NAMELT 655
#define F_NAMELE 656
#define F_NAMEGT 657
#define F_NAMEGE 658
#define F_NAMENE 659
#define F_BPCHAR_BPCHAR_INT4_BOOL 668
#define F_VARCHAR_VARCHAR_INT4_BOOL 669
#define F_PG_INDEXAM_PROGRESS_PHASENAME 676
#define F_OIDVECTORLT 677
#define F_OIDVECTORLE 678
#define F_OIDVECTOREQ 679
#define F_OIDVECTORGE 680
#define F_OIDVECTORGT 681
#define F_NETWORK 683
#define F_NETMASK 696
#define F_MASKLEN 697
#define F_BROADCAST 698
#define F_HOST 699
#define F_DIST_LP 702
#define F_DIST_LS 704
#define F_GETPGUSERNAME 710
#define F_FAMILY 711
#define F_INT2_INT8 714
#define F_LO_CREATE 715
#define F_OIDLT 716
#define F_OIDLE 717
#define F_OCTET_LENGTH_BYTEA 720
#define F_GET_BYTE 721
#define F_SET_BYTE 722
#define F_GET_BIT_BYTEA_INT8 723
#define F_SET_BIT_BYTEA_INT8_INT4 724
#define F_DIST_PL 725
#define F_DIST_SL 727
#define F_DIST_CPOLY 728
#define F_POLY_DISTANCE 729
#define F_TEXT_INET 730
#define F_TEXT_LT 740
#define F_TEXT_LE 741
#define F_TEXT_GT 742
#define F_TEXT_GE 743
#define F_ARRAY_EQ 744
#define F_CURRENT_USER 745
#define F_SESSION_USER 746
#define F_ARRAY_DIMS 747
#define F_ARRAY_NDIMS 748
#define F_OVERLAY_BYTEA_BYTEA_INT4_INT4 749
#define F_ARRAY_IN 750
#define F_ARRAY_OUT 751
#define F_OVERLAY_BYTEA_BYTEA_INT4 752
#define F_TRUNC_MACADDR 753
#define F_INT8_INT2 754
#define F_LO_IMPORT_TEXT 764
#define F_LO_EXPORT 765
#define F_INT4INC 766
#define F_LO_IMPORT_TEXT_OID 767
#define F_INT4LARGER 768
#define F_INT4SMALLER 769
#define F_INT2LARGER 770
#define F_INT2SMALLER 771
#define F_HASHVARLENAEXTENDED 772
#define F_HASHOIDVECTOREXTENDED 776
#define F_HASH_ACLITEM_EXTENDED 777
#define F_HASHMACADDREXTENDED 778
#define F_HASHINETEXTENDED 779
#define F_HASH_NUMERIC_EXTENDED 780
#define F_HASHMACADDR8EXTENDED 781
#define F_HASH_ARRAY_EXTENDED 782
#define F_DIST_POLYC 785
#define F_PG_CLIENT_ENCODING 810
#define F_CURRENT_QUERY 817
#define F_MACADDR_EQ 830
#define F_MACADDR_LT 831
#define F_MACADDR_LE 832
#define F_MACADDR_GT 833
#define F_MACADDR_GE 834
#define F_MACADDR_NE 835
#define F_MACADDR_CMP 836
#define F_INT82PL 837
#define F_INT82MI 838
#define F_INT82MUL 839
#define F_INT82DIV 840
#define F_INT28PL 841
#define F_BTINT8CMP 842
#define F_CASH_MUL_FLT4 846
#define F_CASH_DIV_FLT4 847
#define F_FLT4_MUL_CASH 848
#define F_POSITION_TEXT_TEXT 849
#define F_TEXTLIKE 850
#define F_TEXTNLIKE 851
#define F_INT48EQ 852
#define F_INT48NE 853
#define F_INT48LT 854
#define F_INT48GT 855
#define F_INT48LE 856
#define F_INT48GE 857
#define F_NAMELIKE 858
#define F_NAMENLIKE 859
#define F_BPCHAR_CHAR 860
#define F_CURRENT_DATABASE 861
#define F_INT4_MUL_CASH 862
#define F_INT2_MUL_CASH 863
#define F_CASH_MUL_INT4 864
#define F_CASH_DIV_INT4 865
#define F_CASH_MUL_INT2 866
#define F_CASH_DIV_INT2 867
#define F_STRPOS 868
#define F_LOWER_TEXT 870
#define F_UPPER_TEXT 871
#define F_INITCAP 872
#define F_LPAD_TEXT_INT4_TEXT 873
#define F_RPAD_TEXT_INT4_TEXT 874
#define F_LTRIM_TEXT_TEXT 875
#define F_RTRIM_TEXT_TEXT 876
#define F_SUBSTR_TEXT_INT4_INT4 877
#define F_TRANSLATE 878
#define F_LPAD_TEXT_INT4 879
#define F_RPAD_TEXT_INT4 880
#define F_LTRIM_TEXT 881
#define F_RTRIM_TEXT 882
#define F_SUBSTR_TEXT_INT4 883
#define F_BTRIM_TEXT_TEXT 884
#define F_BTRIM_TEXT 885
#define F_CASH_IN 886
#define F_CASH_OUT 887
#define F_CASH_EQ 888
#define F_CASH_NE 889
#define F_CASH_LT 890
#define F_CASH_LE 891
#define F_CASH_GT 892
#define F_CASH_GE 893
#define F_CASH_PL 894
#define F_CASH_MI 895
#define F_CASH_MUL_FLT8 896
#define F_CASH_DIV_FLT8 897
#define F_CASHLARGER 898
#define F_CASHSMALLER 899
#define F_INET_IN 910
#define F_INET_OUT 911
#define F_FLT8_MUL_CASH 919
#define F_NETWORK_EQ 920
#define F_NETWORK_LT 921
#define F_NETWORK_LE 922
#define F_NETWORK_GT 923
#define F_NETWORK_GE 924
#define F_NETWORK_NE 925
#define F_NETWORK_CMP 926
#define F_NETWORK_SUB 927
#define F_NETWORK_SUBEQ 928
#define F_NETWORK_SUP 929
#define F_NETWORK_SUPEQ 930
#define F_CASH_WORDS 935
#define F_SUBSTRING_TEXT_INT4_INT4 936
#define F_SUBSTRING_TEXT_INT4 937
#define F_GENERATE_SERIES_TIMESTAMP_TIMESTAMP_INTERVAL 938
#define F_GENERATE_SERIES_TIMESTAMPTZ_TIMESTAMPTZ_INTERVAL 939
#define F_MOD_INT2_INT2 940
#define F_MOD_INT4_INT4 941
#define F_INT28MI 942
#define F_INT28MUL 943
#define F_CHAR_TEXT 944
#define F_INT8MOD 945
#define F_TEXT_CHAR 946
#define F_MOD_INT8_INT8 947
#define F_INT28DIV 948
#define F_HASHINT8 949
#define F_LO_OPEN 952
#define F_LO_CLOSE 953
#define F_LOREAD 954
#define F_LOWRITE 955
#define F_LO_LSEEK 956
#define F_LO_CREAT 957
#define F_LO_TELL 958
#define F_ON_PL 959
#define F_ON_SL 960
#define F_CLOSE_PL 961
#define F_LO_UNLINK 964
#define F_HASHBPCHAREXTENDED 972
#define F_PATH_INTER 973
#define F_AREA_BOX 975
#define F_WIDTH 976
#define F_HEIGHT 977
#define F_BOX_DISTANCE 978
#define F_AREA_PATH 979
#define F_BOX_INTERSECT 980
#define F_DIAGONAL 981
#define F_PATH_N_LT 982
#define F_PATH_N_GT 983
#define F_PATH_N_EQ 984
#define F_PATH_N_LE 985
#define F_PATH_N_GE 986
#define F_PATH_LENGTH 987
#define F_POINT_NE 988
#define F_POINT_VERT 989
#define F_POINT_HORIZ 990
#define F_POINT_DISTANCE 991
#define F_SLOPE 992
#define F_LSEG_POINT_POINT 993
#define F_LSEG_INTERSECT 994
#define F_LSEG_PARALLEL 995
#define F_LSEG_PERP 996
#define F_LSEG_VERTICAL 997
#define F_LSEG_HORIZONTAL 998
#define F_LSEG_EQ 999
#define F_LO_TRUNCATE 1004
#define F_TEXTLIKE_SUPPORT 1023
#define F_TEXTICREGEXEQ_SUPPORT 1024
#define F_TEXTICLIKE_SUPPORT 1025
#define F_TIMEZONE_INTERVAL_TIMESTAMPTZ 1026
#define F_GIST_POINT_COMPRESS 1030
#define F_ACLITEMIN 1031
#define F_ACLITEMOUT 1032
#define F_ACLINSERT 1035
#define F_ACLREMOVE 1036
#define F_ACLCONTAINS 1037
#define F_GETDATABASEENCODING 1039
#define F_BPCHARIN 1044
#define F_BPCHAROUT 1045
#define F_VARCHARIN 1046
#define F_VARCHAROUT 1047
#define F_BPCHAREQ 1048
#define F_BPCHARLT 1049
#define F_BPCHARLE 1050
#define F_BPCHARGT 1051
#define F_BPCHARGE 1052
#define F_BPCHARNE 1053
#define F_ACLITEMEQ 1062
#define F_BPCHAR_LARGER 1063
#define F_BPCHAR_SMALLER 1064
#define F_PG_PREPARED_XACT 1065
#define F_GENERATE_SERIES_INT4_INT4_INT4 1066
#define F_GENERATE_SERIES_INT4_INT4 1067
#define F_GENERATE_SERIES_INT8_INT8_INT8 1068
#define F_GENERATE_SERIES_INT8_INT8 1069
#define F_BPCHARCMP 1078
#define F_REGCLASS 1079
#define F_HASHBPCHAR 1080
#define F_FORMAT_TYPE 1081
#define F_DATE_IN 1084
#define F_DATE_OUT 1085
#define F_DATE_EQ 1086
#define F_DATE_LT 1087
#define F_DATE_LE 1088
#define F_DATE_GT 1089
#define F_DATE_GE 1090
#define F_DATE_NE 1091
#define F_DATE_CMP 1092
#define F_TIME_LT 1102
#define F_TIME_LE 1103
#define F_TIME_GT 1104
#define F_TIME_GE 1105
#define F_TIME_NE 1106
#define F_TIME_CMP 1107
#define F_PG_STAT_GET_WAL 1136
#define F_PG_GET_WAL_REPLAY_PAUSE_STATE 1137
#define F_DATE_LARGER 1138
#define F_DATE_SMALLER 1139
#define F_DATE_MI 1140
#define F_DATE_PLI 1141
#define F_DATE_MII 1142
#define F_TIME_IN 1143
#define F_TIME_OUT 1144
#define F_TIME_EQ 1145
#define F_CIRCLE_ADD_PT 1146
#define F_CIRCLE_SUB_PT 1147
#define F_CIRCLE_MUL_PT 1148
#define F_CIRCLE_DIV_PT 1149
#define F_TIMESTAMPTZ_IN 1150
#define F_TIMESTAMPTZ_OUT 1151
#define F_TIMESTAMPTZ_EQ 1152
#define F_TIMESTAMPTZ_NE 1153
#define F_TIMESTAMPTZ_LT 1154
#define F_TIMESTAMPTZ_LE 1155
#define F_TIMESTAMPTZ_GE 1156
#define F_TIMESTAMPTZ_GT 1157
#define F_TO_TIMESTAMP_FLOAT8 1158
#define F_TIMEZONE_TEXT_TIMESTAMPTZ 1159
#define F_INTERVAL_IN 1160
#define F_INTERVAL_OUT 1161
#define F_INTERVAL_EQ 1162
#define F_INTERVAL_NE 1163
#define F_INTERVAL_LT 1164
#define F_INTERVAL_LE 1165
#define F_INTERVAL_GE 1166
#define F_INTERVAL_GT 1167
#define F_INTERVAL_UM 1168
#define F_INTERVAL_PL 1169
#define F_INTERVAL_MI 1170
#define F_DATE_PART_TEXT_TIMESTAMPTZ 1171
#define F_DATE_PART_TEXT_INTERVAL 1172
#define F_NETWORK_SUBSET_SUPPORT 1173
#define F_TIMESTAMPTZ_DATE 1174
#define F_JUSTIFY_HOURS 1175
#define F_TIMESTAMPTZ_DATE_TIME 1176
#define F_JSONB_PATH_EXISTS_TZ 1177
#define F_DATE_TIMESTAMPTZ 1178
#define F_JSONB_PATH_QUERY_TZ 1179
#define F_JSONB_PATH_QUERY_ARRAY_TZ 1180
#define F_AGE_XID 1181
#define F_TIMESTAMPTZ_MI 1188
#define F_TIMESTAMPTZ_PL_INTERVAL 1189
#define F_TIMESTAMPTZ_MI_INTERVAL 1190
#define F_GENERATE_SUBSCRIPTS_ANYARRAY_INT4_BOOL 1191
#define F_GENERATE_SUBSCRIPTS_ANYARRAY_INT4 1192
#define F_ARRAY_FILL_ANYELEMENT__INT4 1193
#define F_LOG10_FLOAT8 1194
#define F_TIMESTAMPTZ_SMALLER 1195
#define F_TIMESTAMPTZ_LARGER 1196
#define F_INTERVAL_SMALLER 1197
#define F_INTERVAL_LARGER 1198
#define F_AGE_TIMESTAMPTZ_TIMESTAMPTZ 1199
#define F_INTERVAL_INTERVAL_INT4 1200
#define F_OBJ_DESCRIPTION_OID_NAME 1215
#define F_COL_DESCRIPTION 1216
#define F_DATE_TRUNC_TEXT_TIMESTAMPTZ 1217
#define F_DATE_TRUNC_TEXT_INTERVAL 1218
#define F_INT8INC 1219
#define F_INT8ABS 1230
#define F_INT8LARGER 1236
#define F_INT8SMALLER 1237
#define F_TEXTICREGEXEQ 1238
#define F_TEXTICREGEXNE 1239
#define F_NAMEICREGEXEQ 1240
#define F_NAMEICREGEXNE 1241
#define F_BOOLIN 1242
#define F_BOOLOUT 1243
#define F_BYTEAIN 1244
#define F_CHARIN 1245
#define F_CHARLT 1246
#define F_UNIQUE_KEY_RECHECK 1250
#define F_INT4ABS 1251
#define F_NAMEREGEXNE 1252
#define F_INT2ABS 1253
#define F_TEXTREGEXEQ 1254
#define F_TEXTREGEXNE 1256
#define F_TEXTLEN 1257
#define F_TEXTCAT 1258
#define F_PG_CHAR_TO_ENCODING 1264
#define F_TIDNE 1265
#define F_CIDR_IN 1267
#define F_PARSE_IDENT 1268
#define F_PG_COLUMN_SIZE 1269
#define F_OVERLAPS_TIMETZ_TIMETZ_TIMETZ_TIMETZ 1271
#define F_DATETIME_PL 1272
#define F_DATE_PART_TEXT_TIMETZ 1273
#define F_INT84PL 1274
#define F_INT84MI 1275
#define F_INT84MUL 1276
#define F_INT84DIV 1277
#define F_INT48PL 1278
#define F_INT48MI 1279
#define F_INT48MUL 1280
#define F_INT48DIV 1281
#define F_QUOTE_IDENT 1282
#define F_QUOTE_LITERAL_TEXT 1283
#define F_DATE_TRUNC_TEXT_TIMESTAMPTZ_TEXT 1284
#define F_QUOTE_LITERAL_ANYELEMENT 1285
#define F_ARRAY_FILL_ANYELEMENT__INT4__INT4 1286
#define F_OID 1287
#define F_INT8_OID 1288
#define F_QUOTE_NULLABLE_TEXT 1289
#define F_QUOTE_NULLABLE_ANYELEMENT 1290
#define F_SUPPRESS_REDUNDANT_UPDATES_TRIGGER 1291
#define F_TIDEQ 1292
#define F_UNNEST_ANYMULTIRANGE 1293
#define F_CURRTID2 1294
#define F_JUSTIFY_DAYS 1295
#define F_TIMEDATE_PL 1296
#define F_DATETIMETZ_PL 1297
#define F_TIMETZDATE_PL 1298
#define F_NOW 1299
#define F_POSITIONSEL 1300
#define F_POSITIONJOINSEL 1301
#define F_CONTSEL 1302
#define F_CONTJOINSEL 1303
#define F_OVERLAPS_TIMESTAMPTZ_TIMESTAMPTZ_TIMESTAMPTZ_TIMESTAMPTZ 1304
#define F_OVERLAPS_TIMESTAMPTZ_INTERVAL_TIMESTAMPTZ_INTERVAL 1305
#define F_OVERLAPS_TIMESTAMPTZ_TIMESTAMPTZ_TIMESTAMPTZ_INTERVAL 1306
#define F_OVERLAPS_TIMESTAMPTZ_INTERVAL_TIMESTAMPTZ_TIMESTAMPTZ 1307
#define F_OVERLAPS_TIME_TIME_TIME_TIME 1308
#define F_OVERLAPS_TIME_INTERVAL_TIME_INTERVAL 1309
#define F_OVERLAPS_TIME_TIME_TIME_INTERVAL 1310
#define F_OVERLAPS_TIME_INTERVAL_TIME_TIME 1311
#define F_TIMESTAMP_IN 1312
#define F_TIMESTAMP_OUT 1313
#define F_TIMESTAMPTZ_CMP 1314
#define F_INTERVAL_CMP 1315
#define F_TIME_TIMESTAMP 1316
#define F_LENGTH_TEXT 1317
#define F_LENGTH_BPCHAR 1318
#define F_XIDEQINT4 1319
#define F_INTERVAL_DIV 1326
#define F_DLOG10 1339
#define F_LOG_FLOAT8 1340
#define F_LN_FLOAT8 1341
#define F_ROUND_FLOAT8 1342
#define F_TRUNC_FLOAT8 1343
#define F_SQRT_FLOAT8 1344
#define F_CBRT 1345
#define F_POW_FLOAT8_FLOAT8 1346
#define F_EXP_FLOAT8 1347
#define F_OBJ_DESCRIPTION_OID 1348
#define F_OIDVECTORTYPES 1349
#define F_TIMETZ_IN 1350
#define F_TIMETZ_OUT 1351
#define F_TIMETZ_EQ 1352
#define F_TIMETZ_NE 1353
#define F_TIMETZ_LT 1354
#define F_TIMETZ_LE 1355
#define F_TIMETZ_GE 1356
#define F_TIMETZ_GT 1357
#define F_TIMETZ_CMP 1358
#define F_TIMESTAMPTZ_DATE_TIMETZ 1359
#define F_HOSTMASK 1362
#define F_TEXTREGEXEQ_SUPPORT 1364
#define F_MAKEACLITEM 1365
#define F_CHARACTER_LENGTH_BPCHAR 1367
#define F_POWER_FLOAT8_FLOAT8 1368
#define F_CHARACTER_LENGTH_TEXT 1369
#define F_INTERVAL_TIME 1370
#define F_PG_LOCK_STATUS 1371
#define F_CHAR_LENGTH_BPCHAR 1372
#define F_ISFINITE_DATE 1373
#define F_OCTET_LENGTH_TEXT 1374
#define F_OCTET_LENGTH_BPCHAR 1375
#define F_FACTORIAL 1376
#define F_TIME_LARGER 1377
#define F_TIME_SMALLER 1378
#define F_TIMETZ_LARGER 1379
#define F_TIMETZ_SMALLER 1380
#define F_CHAR_LENGTH_TEXT 1381
#define F_DATE_PART_TEXT_DATE 1384
#define F_DATE_PART_TEXT_TIME 1385
#define F_AGE_TIMESTAMPTZ 1386
#define F_PG_GET_CONSTRAINTDEF_OID 1387
#define F_TIMETZ_TIMESTAMPTZ 1388
#define F_ISFINITE_TIMESTAMPTZ 1389
#define F_ISFINITE_INTERVAL 1390
#define F_PG_STAT_GET_BACKEND_START 1391
#define F_PG_STAT_GET_BACKEND_CLIENT_ADDR 1392
#define F_PG_STAT_GET_BACKEND_CLIENT_PORT 1393
#define F_ABS_FLOAT4 1394
#define F_ABS_FLOAT8 1395
#define F_ABS_INT8 1396
#define F_ABS_INT4 1397
#define F_ABS_INT2 1398
#define F_NAME_VARCHAR 1400
#define F_VARCHAR_NAME 1401
#define F_CURRENT_SCHEMA 1402
#define F_CURRENT_SCHEMAS 1403
#define F_OVERLAY_TEXT_TEXT_INT4_INT4 1404
#define F_OVERLAY_TEXT_TEXT_INT4 1405
#define F_ISVERTICAL_POINT_POINT 1406
#define F_ISHORIZONTAL_POINT_POINT 1407
#define F_ISPARALLEL_LSEG_LSEG 1408
#define F_ISPERP_LSEG_LSEG 1409
#define F_ISVERTICAL_LSEG 1410
#define F_ISHORIZONTAL_LSEG 1411
#define F_ISPARALLEL_LINE_LINE 1412
#define F_ISPERP_LINE_LINE 1413
#define F_ISVERTICAL_LINE 1414
#define F_ISHORIZONTAL_LINE 1415
#define F_POINT_CIRCLE 1416
#define F_TIME_INTERVAL 1419
#define F_BOX_POINT_POINT 1421
#define F_BOX_ADD 1422
#define F_BOX_SUB 1423
#define F_BOX_MUL 1424
#define F_BOX_DIV 1425
#define F_PATH_CONTAIN_PT 1426
#define F_CIDR_OUT 1427
#define F_POLY_CONTAIN_PT 1428
#define F_PT_CONTAINED_POLY 1429
#define F_ISCLOSED 1430
#define F_ISOPEN 1431
#define F_PATH_NPOINTS 1432
#define F_PCLOSE 1433
#define F_POPEN 1434
#define F_PATH_ADD 1435
#define F_PATH_ADD_PT 1436
#define F_PATH_SUB_PT 1437
#define F_PATH_MUL_PT 1438
#define F_PATH_DIV_PT 1439
#define F_POINT_FLOAT8_FLOAT8 1440
#define F_POINT_ADD 1441
#define F_POINT_SUB 1442
#define F_POINT_MUL 1443
#define F_POINT_DIV 1444
#define F_POLY_NPOINTS 1445
#define F_BOX_POLYGON 1446
#define F_PATH 1447
#define F_POLYGON_BOX 1448
#define F_POLYGON_PATH 1449
#define F_CIRCLE_IN 1450
#define F_CIRCLE_OUT 1451
#define F_CIRCLE_SAME 1452
#define F_CIRCLE_CONTAIN 1453
#define F_CIRCLE_LEFT 1454
#define F_CIRCLE_OVERLEFT 1455
#define F_CIRCLE_OVERRIGHT 1456
#define F_CIRCLE_RIGHT 1457
#define F_CIRCLE_CONTAINED 1458
#define F_CIRCLE_OVERLAP 1459
#define F_CIRCLE_BELOW 1460
#define F_CIRCLE_ABOVE 1461
#define F_CIRCLE_EQ 1462
#define F_CIRCLE_NE 1463
#define F_CIRCLE_LT 1464
#define F_CIRCLE_GT 1465
#define F_CIRCLE_LE 1466
#define F_CIRCLE_GE 1467
#define F_AREA_CIRCLE 1468
#define F_DIAMETER 1469
#define F_RADIUS 1470
#define F_CIRCLE_DISTANCE 1471
#define F_CIRCLE_CENTER 1472
#define F_CIRCLE_POINT_FLOAT8 1473
#define F_CIRCLE_POLYGON 1474
#define F_POLYGON_INT4_CIRCLE 1475
#define F_DIST_PC 1476
#define F_CIRCLE_CONTAIN_PT 1477
#define F_PT_CONTAINED_CIRCLE 1478
#define F_CIRCLE_BOX 1479
#define F_BOX_CIRCLE 1480
#define F_LOG10_NUMERIC 1481
#define F_LSEG_NE 1482
#define F_LSEG_LT 1483
#define F_LSEG_LE 1484
#define F_LSEG_GT 1485
#define F_LSEG_GE 1486
#define F_LSEG_LENGTH 1487
#define F_CLOSE_LS 1488
#define F_CLOSE_LSEG 1489
#define F_LINE_IN 1490
#define F_LINE_OUT 1491
#define F_LINE_EQ 1492
#define F_LINE 1493
#define F_LINE_INTERPT 1494
#define F_LINE_INTERSECT 1495
#define F_LINE_PARALLEL 1496
#define F_LINE_PERP 1497
#define F_LINE_VERTICAL 1498
#define F_LINE_HORIZONTAL 1499
#define F_LENGTH_LSEG 1530
#define F_LENGTH_PATH 1531
#define F_POINT_LSEG 1532
#define F_POINT_BOX 1534
#define F_POINT_POLYGON 1540
#define F_LSEG_BOX 1541
#define F_CENTER_BOX 1542
#define F_CENTER_CIRCLE 1543
#define F_POLYGON_CIRCLE 1544
#define F_NPOINTS_PATH 1545
#define F_NPOINTS_POLYGON 1556
#define F_BIT_IN 1564
#define F_BIT_OUT 1565
#define F_LIKE_TEXT_TEXT 1569
#define F_NOTLIKE_TEXT_TEXT 1570
#define F_LIKE_NAME_TEXT 1571
#define F_NOTLIKE_NAME_TEXT 1572
#define F_PG_GET_RULEDEF_OID 1573
#define F_NEXTVAL 1574
#define F_CURRVAL 1575
#define F_SETVAL_REGCLASS_INT8 1576
#define F_VARBIT_IN 1579
#define F_VARBIT_OUT 1580
#define F_BITEQ 1581
#define F_BITNE 1582
#define F_BITGE 1592
#define F_BITGT 1593
#define F_BITLE 1594
#define F_BITLT 1595
#define F_BITCMP 1596
#define F_PG_ENCODING_TO_CHAR 1597
#define F_RANDOM_ 1598
#define F_SETSEED 1599
#define F_ASIN 1600
#define F_ACOS 1601
#define F_ATAN 1602
#define F_ATAN2 1603
#define F_SIN 1604
#define F_COS 1605
#define F_TAN 1606
#define F_COT 1607
#define F_DEGREES 1608
#define F_RADIANS 1609
#define F_PI 1610
#define F_INTERVAL_MUL 1618
#define F_PG_TYPEOF 1619
#define F_ASCII 1620
#define F_CHR 1621
#define F_REPEAT 1622
#define F_SIMILAR_ESCAPE 1623
#define F_MUL_D_INTERVAL 1624
#define F_BPCHARLIKE 1631
#define F_BPCHARNLIKE 1632
#define F_TEXTICLIKE 1633
#define F_TEXTICNLIKE 1634
#define F_NAMEICLIKE 1635
#define F_NAMEICNLIKE 1636
#define F_LIKE_ESCAPE_TEXT_TEXT 1637
#define F_OIDGT 1638
#define F_OIDGE 1639
#define F_PG_GET_VIEWDEF_TEXT 1640
#define F_PG_GET_VIEWDEF_OID 1641
#define F_PG_GET_USERBYID 1642
#define F_PG_GET_INDEXDEF_OID 1643
#define F_RI_FKEY_CHECK_INS 1644
#define F_RI_FKEY_CHECK_UPD 1645
#define F_RI_FKEY_CASCADE_DEL 1646
#define F_RI_FKEY_CASCADE_UPD 1647
#define F_RI_FKEY_RESTRICT_DEL 1648
#define F_RI_FKEY_RESTRICT_UPD 1649
#define F_RI_FKEY_SETNULL_DEL 1650
#define F_RI_FKEY_SETNULL_UPD 1651
#define F_RI_FKEY_SETDEFAULT_DEL 1652
#define F_RI_FKEY_SETDEFAULT_UPD 1653
#define F_RI_FKEY_NOACTION_DEL 1654
#define F_RI_FKEY_NOACTION_UPD 1655
#define F_BPCHARICREGEXEQ 1656
#define F_BPCHARICREGEXNE 1657
#define F_BPCHARREGEXEQ 1658
#define F_BPCHARREGEXNE 1659
#define F_BPCHARICLIKE 1660
#define F_BPCHARICNLIKE 1661
#define F_PG_GET_TRIGGERDEF_OID 1662
#define F_PG_GET_SERIAL_SEQUENCE 1665
#define F_VARBITEQ 1666
#define F_VARBITNE 1667
#define F_VARBITGE 1668
#define F_VARBITGT 1669
#define F_VARBITLE 1670
#define F_VARBITLT 1671
#define F_VARBITCMP 1672
#define F_BITAND 1673
#define F_BITOR 1674
#define F_BITXOR 1675
#define F_BITNOT 1676
#define F_BITSHIFTLEFT 1677
#define F_BITSHIFTRIGHT 1678
#define F_BITCAT 1679
#define F_SUBSTRING_BIT_INT4_INT4 1680
#define F_LENGTH_BIT 1681
#define F_OCTET_LENGTH_BIT 1682
#define F_BIT_INT4_INT4 1683
#define F_INT4_BIT 1684
#define F_BIT_BIT_INT4_BOOL 1685
#define F_PG_GET_KEYWORDS 1686
#define F_VARBIT 1687
#define F_TIME_HASH 1688
#define F_ACLEXPLODE 1689
#define F_TIME_MI_TIME 1690
#define F_BOOLLE 1691
#define F_BOOLGE 1692
#define F_BTBOOLCMP 1693
#define F_TIMETZ_HASH 1696
#define F_INTERVAL_HASH 1697
#define F_POSITION_BIT_BIT 1698
#define F_SUBSTRING_BIT_INT4 1699
#define F_NUMERIC_IN 1701
#define F_NUMERIC_OUT 1702
#define F_NUMERIC_NUMERIC_INT4 1703
#define F_NUMERIC_ABS 1704
#define F_ABS_NUMERIC 1705
#define F_SIGN_NUMERIC 1706
#define F_ROUND_NUMERIC_INT4 1707
#define F_ROUND_NUMERIC 1708
#define F_TRUNC_NUMERIC_INT4 1709
#define F_TRUNC_NUMERIC 1710
#define F_CEIL_NUMERIC 1711
#define F_FLOOR_NUMERIC 1712
#define F_LENGTH_BYTEA_NAME 1713
#define F_CONVERT_FROM 1714
#define F_CIDR 1715
#define F_PG_GET_EXPR_PG_NODE_TREE_OID 1716
#define F_CONVERT_TO 1717
#define F_NUMERIC_EQ 1718
#define F_NUMERIC_NE 1719
#define F_NUMERIC_GT 1720
#define F_NUMERIC_GE 1721
#define F_NUMERIC_LT 1722
#define F_NUMERIC_LE 1723
#define F_NUMERIC_ADD 1724
#define F_NUMERIC_SUB 1725
#define F_NUMERIC_MUL 1726
#define F_NUMERIC_DIV 1727
#define F_MOD_NUMERIC_NUMERIC 1728
#define F_NUMERIC_MOD 1729
#define F_SQRT_NUMERIC 1730
#define F_NUMERIC_SQRT 1731
#define F_EXP_NUMERIC 1732
#define F_NUMERIC_EXP 1733
#define F_LN_NUMERIC 1734
#define F_NUMERIC_LN 1735
#define F_LOG_NUMERIC_NUMERIC 1736
#define F_NUMERIC_LOG 1737
#define F_POW_NUMERIC_NUMERIC 1738
#define F_NUMERIC_POWER 1739
#define F_NUMERIC_INT4 1740
#define F_LOG_NUMERIC 1741
#define F_NUMERIC_FLOAT4 1742
#define F_NUMERIC_FLOAT8 1743
#define F_INT4_NUMERIC 1744
#define F_FLOAT4_NUMERIC 1745
#define F_FLOAT8_NUMERIC 1746
#define F_TIME_PL_INTERVAL 1747
#define F_TIME_MI_INTERVAL 1748
#define F_TIMETZ_PL_INTERVAL 1749
#define F_TIMETZ_MI_INTERVAL 1750
#define F_NUMERIC_INC 1764
#define F_SETVAL_REGCLASS_INT8_BOOL 1765
#define F_NUMERIC_SMALLER 1766
#define F_NUMERIC_LARGER 1767
#define F_TO_CHAR_INTERVAL_TEXT 1768
#define F_NUMERIC_CMP 1769
#define F_TO_CHAR_TIMESTAMPTZ_TEXT 1770
#define F_NUMERIC_UMINUS 1771
#define F_TO_CHAR_NUMERIC_TEXT 1772
#define F_TO_CHAR_INT4_TEXT 1773
#define F_TO_CHAR_INT8_TEXT 1774
#define F_TO_CHAR_FLOAT4_TEXT 1775
#define F_TO_CHAR_FLOAT8_TEXT 1776
#define F_TO_NUMBER 1777
#define F_TO_TIMESTAMP_TEXT_TEXT 1778
#define F_INT8_NUMERIC 1779
#define F_TO_DATE 1780
#define F_NUMERIC_INT8 1781
#define F_NUMERIC_INT2 1782
#define F_INT2_NUMERIC 1783
#define F_OIDIN 1798
#define F_OIDOUT 1799
#define F_BIT_LENGTH_BYTEA 1810
#define F_BIT_LENGTH_TEXT 1811
#define F_BIT_LENGTH_BIT 1812
#define F_CONVERT 1813
#define F_ICLIKESEL 1814
#define F_ICNLIKESEL 1815
#define F_ICLIKEJOINSEL 1816
#define F_ICNLIKEJOINSEL 1817
#define F_REGEXEQSEL 1818
#define F_LIKESEL 1819
#define F_ICREGEXEQSEL 1820
#define F_REGEXNESEL 1821
#define F_NLIKESEL 1822
#define F_ICREGEXNESEL 1823
#define F_REGEXEQJOINSEL 1824
#define F_LIKEJOINSEL 1825
#define F_ICREGEXEQJOINSEL 1826
#define F_REGEXNEJOINSEL 1827
#define F_NLIKEJOINSEL 1828
#define F_ICREGEXNEJOINSEL 1829
#define F_FLOAT8_AVG 1830
#define F_FLOAT8_VAR_SAMP 1831
#define F_FLOAT8_STDDEV_SAMP 1832
#define F_NUMERIC_ACCUM 1833
#define F_INT2_ACCUM 1834
#define F_INT4_ACCUM 1835
#define F_INT8_ACCUM 1836
#define F_NUMERIC_AVG 1837
#define F_NUMERIC_VAR_SAMP 1838
#define F_NUMERIC_STDDEV_SAMP 1839
#define F_INT2_SUM 1840
#define F_INT4_SUM 1841
#define F_INT8_SUM 1842
#define F_INTERVAL_AVG_ACCUM 1843
#define F_INTERVAL_AVG 1844
#define F_TO_ASCII_TEXT 1845
#define F_TO_ASCII_TEXT_INT4 1846
#define F_TO_ASCII_TEXT_NAME 1847
#define F_INTERVAL_PL_TIME 1848
#define F_INT28EQ 1850
#define F_INT28NE 1851
#define F_INT28LT 1852
#define F_INT28GT 1853
#define F_INT28LE 1854
#define F_INT28GE 1855
#define F_INT82EQ 1856
#define F_INT82NE 1857
#define F_INT82LT 1858
#define F_INT82GT 1859
#define F_INT82LE 1860
#define F_INT82GE 1861
#define F_INT2AND 1892
#define F_INT2OR 1893
#define F_INT2XOR 1894
#define F_INT2NOT 1895
#define F_INT2SHL 1896
#define F_INT2SHR 1897
#define F_INT4AND 1898
#define F_INT4OR 1899
#define F_INT4XOR 1900
#define F_INT4NOT 1901
#define F_INT4SHL 1902
#define F_INT4SHR 1903
#define F_INT8AND 1904
#define F_INT8OR 1905
#define F_INT8XOR 1906
#define F_INT8NOT 1907
#define F_INT8SHL 1908
#define F_INT8SHR 1909
#define F_INT8UP 1910
#define F_INT2UP 1911
#define F_INT4UP 1912
#define F_FLOAT4UP 1913
#define F_FLOAT8UP 1914
#define F_NUMERIC_UPLUS 1915
#define F_HAS_TABLE_PRIVILEGE_NAME_TEXT_TEXT 1922
#define F_HAS_TABLE_PRIVILEGE_NAME_OID_TEXT 1923
#define F_HAS_TABLE_PRIVILEGE_OID_TEXT_TEXT 1924
#define F_HAS_TABLE_PRIVILEGE_OID_OID_TEXT 1925
#define F_HAS_TABLE_PRIVILEGE_TEXT_TEXT 1926
#define F_HAS_TABLE_PRIVILEGE_OID_TEXT 1927
#define F_PG_STAT_GET_NUMSCANS 1928
#define F_PG_STAT_GET_TUPLES_RETURNED 1929
#define F_PG_STAT_GET_TUPLES_FETCHED 1930
#define F_PG_STAT_GET_TUPLES_INSERTED 1931
#define F_PG_STAT_GET_TUPLES_UPDATED 1932
#define F_PG_STAT_GET_TUPLES_DELETED 1933
#define F_PG_STAT_GET_BLOCKS_FETCHED 1934
#define F_PG_STAT_GET_BLOCKS_HIT 1935
#define F_PG_STAT_GET_BACKEND_IDSET 1936
#define F_PG_STAT_GET_BACKEND_PID 1937
#define F_PG_STAT_GET_BACKEND_DBID 1938
#define F_PG_STAT_GET_BACKEND_USERID 1939
#define F_PG_STAT_GET_BACKEND_ACTIVITY 1940
#define F_PG_STAT_GET_DB_NUMBACKENDS 1941
#define F_PG_STAT_GET_DB_XACT_COMMIT 1942
#define F_PG_STAT_GET_DB_XACT_ROLLBACK 1943
#define F_PG_STAT_GET_DB_BLOCKS_FETCHED 1944
#define F_PG_STAT_GET_DB_BLOCKS_HIT 1945
#define F_ENCODE 1946
#define F_DECODE 1947
#define F_BYTEAEQ 1948
#define F_BYTEALT 1949
#define F_BYTEALE 1950
#define F_BYTEAGT 1951
#define F_BYTEAGE 1952
#define F_BYTEANE 1953
#define F_BYTEACMP 1954
#define F_TIMESTAMP_TIMESTAMP_INT4 1961
#define F_INT2_AVG_ACCUM 1962
#define F_INT4_AVG_ACCUM 1963
#define F_INT8_AVG 1964
#define F_OIDLARGER 1965
#define F_OIDSMALLER 1966
#define F_TIMESTAMPTZ_TIMESTAMPTZ_INT4 1967
#define F_TIME_TIME_INT4 1968
#define F_TIMETZ_TIMETZ_INT4 1969
#define F_PG_STAT_GET_TUPLES_HOT_UPDATED 1972
#define F_DIV 1973
#define F_NUMERIC_DIV_TRUNC 1980
#define F_SIMILAR_TO_ESCAPE_TEXT_TEXT 1986
#define F_SIMILAR_TO_ESCAPE_TEXT 1987
#define F_SHOBJ_DESCRIPTION 1993
#define F_TEXTANYCAT 2003
#define F_ANYTEXTCAT 2004
#define F_BYTEALIKE 2005
#define F_BYTEANLIKE 2006
#define F_LIKE_BYTEA_BYTEA 2007
#define F_NOTLIKE_BYTEA_BYTEA 2008
#define F_LIKE_ESCAPE_BYTEA_BYTEA 2009
#define F_LENGTH_BYTEA 2010
#define F_BYTEACAT 2011
#define F_SUBSTRING_BYTEA_INT4_INT4 2012
#define F_SUBSTRING_BYTEA_INT4 2013
#define F_POSITION_BYTEA_BYTEA 2014
#define F_BTRIM_BYTEA_BYTEA 2015
#define F_TIME_TIMESTAMPTZ 2019
#define F_DATE_TRUNC_TEXT_TIMESTAMP 2020
#define F_DATE_PART_TEXT_TIMESTAMP 2021
#define F_PG_STAT_GET_ACTIVITY 2022
#define F_JSONB_PATH_QUERY_FIRST_TZ 2023
#define F_TIMESTAMP_DATE 2024
#define F_TIMESTAMP_DATE_TIME 2025
#define F_PG_BACKEND_PID 2026
#define F_TIMESTAMP_TIMESTAMPTZ 2027
#define F_TIMESTAMPTZ_TIMESTAMP 2028
#define F_DATE_TIMESTAMP 2029
#define F_JSONB_PATH_MATCH_TZ 2030
#define F_TIMESTAMP_MI 2031
#define F_TIMESTAMP_PL_INTERVAL 2032
#define F_TIMESTAMP_MI_INTERVAL 2033
#define F_PG_CONF_LOAD_TIME 2034
#define F_TIMESTAMP_SMALLER 2035
#define F_TIMESTAMP_LARGER 2036
#define F_TIMEZONE_TEXT_TIMETZ 2037
#define F_TIMEZONE_INTERVAL_TIMETZ 2038
#define F_TIMESTAMP_HASH 2039
#define F_OVERLAPS_TIMESTAMP_TIMESTAMP_TIMESTAMP_TIMESTAMP 2041
#define F_OVERLAPS_TIMESTAMP_INTERVAL_TIMESTAMP_INTERVAL 2042
#define F_OVERLAPS_TIMESTAMP_TIMESTAMP_TIMESTAMP_INTERVAL 2043
#define F_OVERLAPS_TIMESTAMP_INTERVAL_TIMESTAMP_TIMESTAMP 2044
#define F_TIMESTAMP_CMP 2045
#define F_TIME_TIMETZ 2046
#define F_TIMETZ_TIME 2047
#define F_ISFINITE_TIMESTAMP 2048
#define F_TO_CHAR_TIMESTAMP_TEXT 2049
#define F_MAX_ANYARRAY 2050
#define F_MIN_ANYARRAY 2051
#define F_TIMESTAMP_EQ 2052
#define F_TIMESTAMP_NE 2053
#define F_TIMESTAMP_LT 2054
#define F_TIMESTAMP_LE 2055
#define F_TIMESTAMP_GE 2056
#define F_TIMESTAMP_GT 2057
#define F_AGE_TIMESTAMP_TIMESTAMP 2058
#define F_AGE_TIMESTAMP 2059
#define F_TIMEZONE_TEXT_TIMESTAMP 2069
#define F_TIMEZONE_INTERVAL_TIMESTAMP 2070
#define F_DATE_PL_INTERVAL 2071
#define F_DATE_MI_INTERVAL 2072
#define F_SUBSTRING_TEXT_TEXT 2073
#define F_SUBSTRING_TEXT_TEXT_TEXT 2074
#define F_BIT_INT8_INT4 2075
#define F_INT8_BIT 2076
#define F_CURRENT_SETTING_TEXT 2077
#define F_SET_CONFIG 2078
#define F_PG_TABLE_IS_VISIBLE 2079
#define F_PG_TYPE_IS_VISIBLE 2080
#define F_PG_FUNCTION_IS_VISIBLE 2081
#define F_PG_OPERATOR_IS_VISIBLE 2082
#define F_PG_OPCLASS_IS_VISIBLE 2083
#define F_PG_SHOW_ALL_SETTINGS 2084
#define F_SUBSTR_BYTEA_INT4_INT4 2085
#define F_SUBSTR_BYTEA_INT4 2086
#define F_REPLACE 2087
#define F_SPLIT_PART 2088
#define F_TO_HEX_INT4 2089
#define F_TO_HEX_INT8 2090
#define F_ARRAY_LOWER 2091
#define F_ARRAY_UPPER 2092
#define F_PG_CONVERSION_IS_VISIBLE 2093
#define F_PG_STAT_GET_BACKEND_ACTIVITY_START 2094
#define F_PG_TERMINATE_BACKEND 2096
#define F_PG_GET_FUNCTIONDEF 2098
#define F_AVG_INT8 2100
#define F_AVG_INT4 2101
#define F_AVG_INT2 2102
#define F_AVG_NUMERIC 2103
#define F_AVG_FLOAT4 2104
#define F_AVG_FLOAT8 2105
#define F_AVG_INTERVAL 2106
#define F_SUM_INT8 2107
#define F_SUM_INT4 2108
#define F_SUM_INT2 2109
#define F_SUM_FLOAT4 2110
#define F_SUM_FLOAT8 2111
#define F_SUM_MONEY 2112
#define F_SUM_INTERVAL 2113
#define F_SUM_NUMERIC 2114
#define F_MAX_INT8 2115
#define F_MAX_INT4 2116
#define F_MAX_INT2 2117
#define F_MAX_OID 2118
#define F_MAX_FLOAT4 2119
#define F_MAX_FLOAT8 2120
#define F_PG_COLUMN_COMPRESSION 2121
#define F_MAX_DATE 2122
#define F_MAX_TIME 2123
#define F_MAX_TIMETZ 2124
#define F_MAX_MONEY 2125
#define F_MAX_TIMESTAMP 2126
#define F_MAX_TIMESTAMPTZ 2127
#define F_MAX_INTERVAL 2128
#define F_MAX_TEXT 2129
#define F_MAX_NUMERIC 2130
#define F_MIN_INT8 2131
#define F_MIN_INT4 2132
#define F_MIN_INT2 2133
#define F_MIN_OID 2134
#define F_MIN_FLOAT4 2135
#define F_MIN_FLOAT8 2136
#define F_PG_STAT_FORCE_NEXT_FLUSH 2137
#define F_MIN_DATE 2138
#define F_MIN_TIME 2139
#define F_MIN_TIMETZ 2140
#define F_MIN_MONEY 2141
#define F_MIN_TIMESTAMP 2142
#define F_MIN_TIMESTAMPTZ 2143
#define F_MIN_INTERVAL 2144
#define F_MIN_TEXT 2145
#define F_MIN_NUMERIC 2146
#define F_COUNT_ANY 2147
#define F_VARIANCE_INT8 2148
#define F_VARIANCE_INT4 2149
#define F_VARIANCE_INT2 2150
#define F_VARIANCE_FLOAT4 2151
#define F_VARIANCE_FLOAT8 2152
#define F_VARIANCE_NUMERIC 2153
#define F_STDDEV_INT8 2154
#define F_STDDEV_INT4 2155
#define F_STDDEV_INT2 2156
#define F_STDDEV_FLOAT4 2157
#define F_STDDEV_FLOAT8 2158
#define F_STDDEV_NUMERIC 2159
#define F_TEXT_PATTERN_LT 2160
#define F_TEXT_PATTERN_LE 2161
#define F_PG_GET_FUNCTION_ARGUMENTS 2162
#define F_TEXT_PATTERN_GE 2163
#define F_TEXT_PATTERN_GT 2164
#define F_PG_GET_FUNCTION_RESULT 2165
#define F_BTTEXT_PATTERN_CMP 2166
#define F_CEILING_NUMERIC 2167
#define F_PG_DATABASE_SIZE_NAME 2168
#define F_POWER_NUMERIC_NUMERIC 2169
#define F_WIDTH_BUCKET_NUMERIC_NUMERIC_NUMERIC_INT4 2170
#define F_PG_CANCEL_BACKEND 2171
#define F_PG_BACKUP_START 2172
#define F_BPCHAR_PATTERN_LT 2174
#define F_BPCHAR_PATTERN_LE 2175
#define F_ARRAY_LENGTH 2176
#define F_BPCHAR_PATTERN_GE 2177
#define F_BPCHAR_PATTERN_GT 2178
#define F_GIST_POINT_CONSISTENT 2179
#define F_BTBPCHAR_PATTERN_CMP 2180
#define F_HAS_SEQUENCE_PRIVILEGE_NAME_TEXT_TEXT 2181
#define F_HAS_SEQUENCE_PRIVILEGE_NAME_OID_TEXT 2182
#define F_HAS_SEQUENCE_PRIVILEGE_OID_TEXT_TEXT 2183
#define F_HAS_SEQUENCE_PRIVILEGE_OID_OID_TEXT 2184
#define F_HAS_SEQUENCE_PRIVILEGE_TEXT_TEXT 2185
#define F_HAS_SEQUENCE_PRIVILEGE_OID_TEXT 2186
#define F_BTINT48CMP 2188
#define F_BTINT84CMP 2189
#define F_BTINT24CMP 2190
#define F_BTINT42CMP 2191
#define F_BTINT28CMP 2192
#define F_BTINT82CMP 2193
#define F_BTFLOAT48CMP 2194
#define F_BTFLOAT84CMP 2195
#define F_INET_CLIENT_ADDR 2196
#define F_INET_CLIENT_PORT 2197
#define F_INET_SERVER_ADDR 2198
#define F_INET_SERVER_PORT 2199
#define F_REGPROCEDUREIN 2212
#define F_REGPROCEDUREOUT 2213
#define F_REGOPERIN 2214
#define F_REGOPEROUT 2215
#define F_REGOPERATORIN 2216
#define F_REGOPERATOROUT 2217
#define F_REGCLASSIN 2218
#define F_REGCLASSOUT 2219
#define F_REGTYPEIN 2220
#define F_REGTYPEOUT 2221
#define F_PG_STAT_CLEAR_SNAPSHOT 2230
#define F_PG_GET_FUNCTION_IDENTITY_ARGUMENTS 2232
#define F_HASHTID 2233
#define F_HASHTIDEXTENDED 2234
#define F_BIT_AND_INT2 2236
#define F_BIT_OR_INT2 2237
#define F_BIT_AND_INT4 2238
#define F_BIT_OR_INT4 2239
#define F_BIT_AND_INT8 2240
#define F_BIT_OR_INT8 2241
#define F_BIT_AND_BIT 2242
#define F_BIT_OR_BIT 2243
#define F_MAX_BPCHAR 2244
#define F_MIN_BPCHAR 2245
#define F_FMGR_INTERNAL_VALIDATOR 2246
#define F_FMGR_C_VALIDATOR 2247
#define F_FMGR_SQL_VALIDATOR 2248
#define F_HAS_DATABASE_PRIVILEGE_NAME_TEXT_TEXT 2250
#define F_HAS_DATABASE_PRIVILEGE_NAME_OID_TEXT 2251
#define F_HAS_DATABASE_PRIVILEGE_OID_TEXT_TEXT 2252
#define F_HAS_DATABASE_PRIVILEGE_OID_OID_TEXT 2253
#define F_HAS_DATABASE_PRIVILEGE_TEXT_TEXT 2254
#define F_HAS_DATABASE_PRIVILEGE_OID_TEXT 2255
#define F_HAS_FUNCTION_PRIVILEGE_NAME_TEXT_TEXT 2256
#define F_HAS_FUNCTION_PRIVILEGE_NAME_OID_TEXT 2257
#define F_HAS_FUNCTION_PRIVILEGE_OID_TEXT_TEXT 2258
#define F_HAS_FUNCTION_PRIVILEGE_OID_OID_TEXT 2259
#define F_HAS_FUNCTION_PRIVILEGE_TEXT_TEXT 2260
#define F_HAS_FUNCTION_PRIVILEGE_OID_TEXT 2261
#define F_HAS_LANGUAGE_PRIVILEGE_NAME_TEXT_TEXT 2262
#define F_HAS_LANGUAGE_PRIVILEGE_NAME_OID_TEXT 2263
#define F_HAS_LANGUAGE_PRIVILEGE_OID_TEXT_TEXT 2264
#define F_HAS_LANGUAGE_PRIVILEGE_OID_OID_TEXT 2265
#define F_HAS_LANGUAGE_PRIVILEGE_TEXT_TEXT 2266
#define F_HAS_LANGUAGE_PRIVILEGE_OID_TEXT 2267
#define F_HAS_SCHEMA_PRIVILEGE_NAME_TEXT_TEXT 2268
#define F_HAS_SCHEMA_PRIVILEGE_NAME_OID_TEXT 2269
#define F_HAS_SCHEMA_PRIVILEGE_OID_TEXT_TEXT 2270
#define F_HAS_SCHEMA_PRIVILEGE_OID_OID_TEXT 2271
#define F_HAS_SCHEMA_PRIVILEGE_TEXT_TEXT 2272
#define F_HAS_SCHEMA_PRIVILEGE_OID_TEXT 2273
#define F_PG_STAT_RESET 2274
#define F_PG_GET_BACKEND_MEMORY_CONTEXTS 2282
#define F_REGEXP_REPLACE_TEXT_TEXT_TEXT 2284
#define F_REGEXP_REPLACE_TEXT_TEXT_TEXT_TEXT 2285
#define F_PG_TOTAL_RELATION_SIZE 2286
#define F_PG_SIZE_PRETTY_INT8 2288
#define F_PG_OPTIONS_TO_TABLE 2289
#define F_RECORD_IN 2290
#define F_RECORD_OUT 2291
#define F_CSTRING_IN 2292
#define F_CSTRING_OUT 2293
#define F_ANY_IN 2294
#define F_ANY_OUT 2295
#define F_ANYARRAY_IN 2296
#define F_ANYARRAY_OUT 2297
#define F_VOID_IN 2298
#define F_VOID_OUT 2299
#define F_TRIGGER_IN 2300
#define F_TRIGGER_OUT 2301
#define F_LANGUAGE_HANDLER_IN 2302
#define F_LANGUAGE_HANDLER_OUT 2303
#define F_INTERNAL_IN 2304
#define F_INTERNAL_OUT 2305
#define F_PG_STAT_GET_SLRU 2306
#define F_PG_STAT_RESET_SLRU 2307
#define F_CEIL_FLOAT8 2308
#define F_FLOOR_FLOAT8 2309
#define F_SIGN_FLOAT8 2310
#define F_MD5_TEXT 2311
#define F_ANYELEMENT_IN 2312
#define F_ANYELEMENT_OUT 2313
#define F_POSTGRESQL_FDW_VALIDATOR 2316
#define F_PG_ENCODING_MAX_LENGTH 2319
#define F_CEILING_FLOAT8 2320
#define F_MD5_BYTEA 2321
#define F_PG_TABLESPACE_SIZE_OID 2322
#define F_PG_TABLESPACE_SIZE_NAME 2323
#define F_PG_DATABASE_SIZE_OID 2324
#define F_PG_RELATION_SIZE_REGCLASS 2325
#define F_UNNEST_ANYARRAY 2331
#define F_PG_RELATION_SIZE_REGCLASS_TEXT 2332
#define F_ARRAY_AGG_TRANSFN 2333
#define F_ARRAY_AGG_FINALFN 2334
#define F_ARRAY_AGG_ANYNONARRAY 2335
#define F_DATE_LT_TIMESTAMP 2338
#define F_DATE_LE_TIMESTAMP 2339
#define F_DATE_EQ_TIMESTAMP 2340
#define F_DATE_GT_TIMESTAMP 2341
#define F_DATE_GE_TIMESTAMP 2342
#define F_DATE_NE_TIMESTAMP 2343
#define F_DATE_CMP_TIMESTAMP 2344
#define F_DATE_LT_TIMESTAMPTZ 2351
#define F_DATE_LE_TIMESTAMPTZ 2352
#define F_DATE_EQ_TIMESTAMPTZ 2353
#define F_DATE_GT_TIMESTAMPTZ 2354
#define F_DATE_GE_TIMESTAMPTZ 2355
#define F_DATE_NE_TIMESTAMPTZ 2356
#define F_DATE_CMP_TIMESTAMPTZ 2357
#define F_TIMESTAMP_LT_DATE 2364
#define F_TIMESTAMP_LE_DATE 2365
#define F_TIMESTAMP_EQ_DATE 2366
#define F_TIMESTAMP_GT_DATE 2367
#define F_TIMESTAMP_GE_DATE 2368
#define F_TIMESTAMP_NE_DATE 2369
#define F_TIMESTAMP_CMP_DATE 2370
#define F_TIMESTAMPTZ_LT_DATE 2377
#define F_TIMESTAMPTZ_LE_DATE 2378
#define F_TIMESTAMPTZ_EQ_DATE 2379
#define F_TIMESTAMPTZ_GT_DATE 2380
#define F_TIMESTAMPTZ_GE_DATE 2381
#define F_TIMESTAMPTZ_NE_DATE 2382
#define F_TIMESTAMPTZ_CMP_DATE 2383
#define F_HAS_TABLESPACE_PRIVILEGE_NAME_TEXT_TEXT 2390
#define F_HAS_TABLESPACE_PRIVILEGE_NAME_OID_TEXT 2391
#define F_HAS_TABLESPACE_PRIVILEGE_OID_TEXT_TEXT 2392
#define F_HAS_TABLESPACE_PRIVILEGE_OID_OID_TEXT 2393
#define F_HAS_TABLESPACE_PRIVILEGE_TEXT_TEXT 2394
#define F_HAS_TABLESPACE_PRIVILEGE_OID_TEXT 2395
#define F_SHELL_IN 2398
#define F_SHELL_OUT 2399
#define F_ARRAY_RECV 2400
#define F_ARRAY_SEND 2401
#define F_RECORD_RECV 2402
#define F_RECORD_SEND 2403
#define F_INT2RECV 2404
#define F_INT2SEND 2405
#define F_INT4RECV 2406
#define F_INT4SEND 2407
#define F_INT8RECV 2408
#define F_INT8SEND 2409
#define F_INT2VECTORRECV 2410
#define F_INT2VECTORSEND 2411
#define F_BYTEARECV 2412
#define F_BYTEASEND 2413
#define F_TEXTRECV 2414
#define F_TEXTSEND 2415
#define F_UNKNOWNRECV 2416
#define F_UNKNOWNSEND 2417
#define F_OIDRECV 2418
#define F_OIDSEND 2419
#define F_OIDVECTORRECV 2420
#define F_OIDVECTORSEND 2421
#define F_NAMERECV 2422
#define F_NAMESEND 2423
#define F_FLOAT4RECV 2424
#define F_FLOAT4SEND 2425
#define F_FLOAT8RECV 2426
#define F_FLOAT8SEND 2427
#define F_POINT_RECV 2428
#define F_POINT_SEND 2429
#define F_BPCHARRECV 2430
#define F_BPCHARSEND 2431
#define F_VARCHARRECV 2432
#define F_VARCHARSEND 2433
#define F_CHARRECV 2434
#define F_CHARSEND 2435
#define F_BOOLRECV 2436
#define F_BOOLSEND 2437
#define F_TIDRECV 2438
#define F_TIDSEND 2439
#define F_XIDRECV 2440
#define F_XIDSEND 2441
#define F_CIDRECV 2442
#define F_CIDSEND 2443
#define F_REGPROCRECV 2444
#define F_REGPROCSEND 2445
#define F_REGPROCEDURERECV 2446
#define F_REGPROCEDURESEND 2447
#define F_REGOPERRECV 2448
#define F_REGOPERSEND 2449
#define F_REGOPERATORRECV 2450
#define F_REGOPERATORSEND 2451
#define F_REGCLASSRECV 2452
#define F_REGCLASSSEND 2453
#define F_REGTYPERECV 2454
#define F_REGTYPESEND 2455
#define F_BIT_RECV 2456
#define F_BIT_SEND 2457
#define F_VARBIT_RECV 2458
#define F_VARBIT_SEND 2459
#define F_NUMERIC_RECV 2460
#define F_NUMERIC_SEND 2461
#define F_SINH 2462
#define F_COSH 2463
#define F_TANH 2464
#define F_ASINH 2465
#define F_ACOSH 2466
#define F_ATANH 2467
#define F_DATE_RECV 2468
#define F_DATE_SEND 2469
#define F_TIME_RECV 2470
#define F_TIME_SEND 2471
#define F_TIMETZ_RECV 2472
#define F_TIMETZ_SEND 2473
#define F_TIMESTAMP_RECV 2474
#define F_TIMESTAMP_SEND 2475
#define F_TIMESTAMPTZ_RECV 2476
#define F_TIMESTAMPTZ_SEND 2477
#define F_INTERVAL_RECV 2478
#define F_INTERVAL_SEND 2479
#define F_LSEG_RECV 2480
#define F_LSEG_SEND 2481
#define F_PATH_RECV 2482
#define F_PATH_SEND 2483
#define F_BOX_RECV 2484
#define F_BOX_SEND 2485
#define F_POLY_RECV 2486
#define F_POLY_SEND 2487
#define F_LINE_RECV 2488
#define F_LINE_SEND 2489
#define F_CIRCLE_RECV 2490
#define F_CIRCLE_SEND 2491
#define F_CASH_RECV 2492
#define F_CASH_SEND 2493
#define F_MACADDR_RECV 2494
#define F_MACADDR_SEND 2495
#define F_INET_RECV 2496
#define F_INET_SEND 2497
#define F_CIDR_RECV 2498
#define F_CIDR_SEND 2499
#define F_CSTRING_RECV 2500
#define F_CSTRING_SEND 2501
#define F_ANYARRAY_RECV 2502
#define F_ANYARRAY_SEND 2503
#define F_PG_GET_RULEDEF_OID_BOOL 2504
#define F_PG_GET_VIEWDEF_TEXT_BOOL 2505
#define F_PG_GET_VIEWDEF_OID_BOOL 2506
#define F_PG_GET_INDEXDEF_OID_INT4_BOOL 2507
#define F_PG_GET_CONSTRAINTDEF_OID_BOOL 2508
#define F_PG_GET_EXPR_PG_NODE_TREE_OID_BOOL 2509
#define F_PG_PREPARED_STATEMENT 2510
#define F_PG_CURSOR 2511
#define F_FLOAT8_VAR_POP 2512
#define F_FLOAT8_STDDEV_POP 2513
#define F_NUMERIC_VAR_POP 2514
#define F_BOOLAND_STATEFUNC 2515
#define F_BOOLOR_STATEFUNC 2516
#define F_BOOL_AND 2517
#define F_BOOL_OR 2518
#define F_EVERY 2519
#define F_TIMESTAMP_LT_TIMESTAMPTZ 2520
#define F_TIMESTAMP_LE_TIMESTAMPTZ 2521
#define F_TIMESTAMP_EQ_TIMESTAMPTZ 2522
#define F_TIMESTAMP_GT_TIMESTAMPTZ 2523
#define F_TIMESTAMP_GE_TIMESTAMPTZ 2524
#define F_TIMESTAMP_NE_TIMESTAMPTZ 2525
#define F_TIMESTAMP_CMP_TIMESTAMPTZ 2526
#define F_TIMESTAMPTZ_LT_TIMESTAMP 2527
#define F_TIMESTAMPTZ_LE_TIMESTAMP 2528
#define F_TIMESTAMPTZ_EQ_TIMESTAMP 2529
#define F_TIMESTAMPTZ_GT_TIMESTAMP 2530
#define F_TIMESTAMPTZ_GE_TIMESTAMP 2531
#define F_TIMESTAMPTZ_NE_TIMESTAMP 2532
#define F_TIMESTAMPTZ_CMP_TIMESTAMP 2533
#define F_INTERVAL_PL_DATE 2546
#define F_INTERVAL_PL_TIMETZ 2547
#define F_INTERVAL_PL_TIMESTAMP 2548
#define F_INTERVAL_PL_TIMESTAMPTZ 2549
#define F_INTEGER_PL_DATE 2550
#define F_PG_TABLESPACE_DATABASES 2556
#define F_BOOL_INT4 2557
#define F_INT4_BOOL 2558
#define F_LASTVAL 2559
#define F_PG_POSTMASTER_START_TIME 2560
#define F_PG_BLOCKING_PIDS 2561
#define F_BOX_BELOW 2562
#define F_BOX_OVERBELOW 2563
#define F_BOX_OVERABOVE 2564
#define F_BOX_ABOVE 2565
#define F_POLY_BELOW 2566
#define F_POLY_OVERBELOW 2567
#define F_POLY_OVERABOVE 2568
#define F_POLY_ABOVE 2569
#define F_GIST_BOX_CONSISTENT 2578
#define F_FLOAT8_JSONB 2580
#define F_GIST_BOX_PENALTY 2581
#define F_GIST_BOX_PICKSPLIT 2582
#define F_GIST_BOX_UNION 2583
#define F_GIST_BOX_SAME 2584
#define F_GIST_POLY_CONSISTENT 2585
#define F_GIST_POLY_COMPRESS 2586
#define F_CIRCLE_OVERBELOW 2587
#define F_CIRCLE_OVERABOVE 2588
#define F_GIST_CIRCLE_CONSISTENT 2591
#define F_GIST_CIRCLE_COMPRESS 2592
#define F_NUMERIC_STDDEV_POP 2596
#define F_DOMAIN_IN 2597
#define F_DOMAIN_RECV 2598
#define F_PG_TIMEZONE_ABBREVS_ABBREVS 2599
#define F_XMLEXISTS 2614
#define F_PG_RELOAD_CONF 2621
#define F_PG_ROTATE_LOGFILE 2622
#define F_PG_STAT_FILE_TEXT 2623
#define F_PG_READ_FILE_TEXT_INT8_INT8 2624
#define F_PG_LS_DIR_TEXT 2625
#define F_PG_SLEEP 2626
#define F_INETNOT 2627
#define F_INETAND 2628
#define F_INETOR 2629
#define F_INETPL 2630
#define F_INT8PL_INET 2631
#define F_INETMI_INT8 2632
#define F_INETMI 2633
#define F_VAR_SAMP_INT8 2641
#define F_VAR_SAMP_INT4 2642
#define F_VAR_SAMP_INT2 2643
#define F_VAR_SAMP_FLOAT4 2644
#define F_VAR_SAMP_FLOAT8 2645
#define F_VAR_SAMP_NUMERIC 2646
#define F_TRANSACTION_TIMESTAMP 2647
#define F_STATEMENT_TIMESTAMP 2648
#define F_CLOCK_TIMESTAMP 2649
#define F_GIN_CMP_PREFIX 2700
#define F_PG_HAS_ROLE_NAME_NAME_TEXT 2705
#define F_PG_HAS_ROLE_NAME_OID_TEXT 2706
#define F_PG_HAS_ROLE_OID_NAME_TEXT 2707
#define F_PG_HAS_ROLE_OID_OID_TEXT 2708
#define F_PG_HAS_ROLE_NAME_TEXT 2709
#define F_PG_HAS_ROLE_OID_TEXT 2710
#define F_JUSTIFY_INTERVAL 2711
#define F_STDDEV_SAMP_INT8 2712
#define F_STDDEV_SAMP_INT4 2713
#define F_STDDEV_SAMP_INT2 2714
#define F_STDDEV_SAMP_FLOAT4 2715
#define F_STDDEV_SAMP_FLOAT8 2716
#define F_STDDEV_SAMP_NUMERIC 2717
#define F_VAR_POP_INT8 2718
#define F_VAR_POP_INT4 2719
#define F_VAR_POP_INT2 2720
#define F_VAR_POP_FLOAT4 2721
#define F_VAR_POP_FLOAT8 2722
#define F_VAR_POP_NUMERIC 2723
#define F_STDDEV_POP_INT8 2724
#define F_STDDEV_POP_INT4 2725
#define F_STDDEV_POP_INT2 2726
#define F_STDDEV_POP_FLOAT4 2727
#define F_STDDEV_POP_FLOAT8 2728
#define F_STDDEV_POP_NUMERIC 2729
#define F_PG_GET_TRIGGERDEF_OID_BOOL 2730
#define F_ASIND 2731
#define F_ACOSD 2732
#define F_ATAND 2733
#define F_ATAN2D 2734
#define F_SIND 2735
#define F_COSD 2736
#define F_TAND 2737
#define F_COTD 2738
#define F_PG_BACKUP_STOP 2739
#define F_NUMERIC_AVG_SERIALIZE 2740
#define F_NUMERIC_AVG_DESERIALIZE 2741
#define F_GINARRAYEXTRACT_ANYARRAY_INTERNAL_INTERNAL 2743
#define F_GINARRAYCONSISTENT 2744
#define F_INT8_AVG_ACCUM 2746
#define F_ARRAYOVERLAP 2747
#define F_ARRAYCONTAINS 2748
#define F_ARRAYCONTAINED 2749
#define F_PG_STAT_GET_DB_TUPLES_RETURNED 2758
#define F_PG_STAT_GET_DB_TUPLES_FETCHED 2759
#define F_PG_STAT_GET_DB_TUPLES_INSERTED 2760
#define F_PG_STAT_GET_DB_TUPLES_UPDATED 2761
#define F_PG_STAT_GET_DB_TUPLES_DELETED 2762
#define F_REGEXP_MATCHES_TEXT_TEXT 2763
#define F_REGEXP_MATCHES_TEXT_TEXT_TEXT 2764
#define F_REGEXP_SPLIT_TO_TABLE_TEXT_TEXT 2765
#define F_REGEXP_SPLIT_TO_TABLE_TEXT_TEXT_TEXT 2766
#define F_REGEXP_SPLIT_TO_ARRAY_TEXT_TEXT 2767
#define F_REGEXP_SPLIT_TO_ARRAY_TEXT_TEXT_TEXT 2768
#define F_PG_STAT_GET_CHECKPOINTER_NUM_TIMED 2769
#define F_PG_STAT_GET_CHECKPOINTER_NUM_REQUESTED 2770
#define F_PG_STAT_GET_CHECKPOINTER_BUFFERS_WRITTEN 2771
#define F_PG_STAT_GET_BGWRITER_BUF_WRITTEN_CLEAN 2772
#define F_PG_STAT_GET_BGWRITER_MAXWRITTEN_CLEAN 2773
#define F_GINQUERYARRAYEXTRACT 2774
#define F_ANYNONARRAY_IN 2777
#define F_ANYNONARRAY_OUT 2778
#define F_PG_STAT_GET_LAST_VACUUM_TIME 2781
#define F_PG_STAT_GET_LAST_AUTOVACUUM_TIME 2782
#define F_PG_STAT_GET_LAST_ANALYZE_TIME 2783
#define F_PG_STAT_GET_LAST_AUTOANALYZE_TIME 2784
#define F_INT8_AVG_COMBINE 2785
#define F_INT8_AVG_SERIALIZE 2786
#define F_INT8_AVG_DESERIALIZE 2787
#define F_PG_STAT_GET_BACKEND_WAIT_EVENT_TYPE 2788
#define F_TIDGT 2790
#define F_TIDLT 2791
#define F_TIDGE 2792
#define F_TIDLE 2793
#define F_BTTIDCMP 2794
#define F_TIDLARGER 2795
#define F_TIDSMALLER 2796
#define F_MAX_TID 2797
#define F_MIN_TID 2798
#define F_COUNT_ 2803
#define F_INT8INC_ANY 2804
#define F_INT8INC_FLOAT8_FLOAT8 2805
#define F_FLOAT8_REGR_ACCUM 2806
#define F_FLOAT8_REGR_SXX 2807
#define F_FLOAT8_REGR_SYY 2808
#define F_FLOAT8_REGR_SXY 2809
#define F_FLOAT8_REGR_AVGX 2810
#define F_FLOAT8_REGR_AVGY 2811
#define F_FLOAT8_REGR_R2 2812
#define F_FLOAT8_REGR_SLOPE 2813
#define F_FLOAT8_REGR_INTERCEPT 2814
#define F_FLOAT8_COVAR_POP 2815
#define F_FLOAT8_COVAR_SAMP 2816
#define F_FLOAT8_CORR 2817
#define F_REGR_COUNT 2818
#define F_REGR_SXX 2819
#define F_REGR_SYY 2820
#define F_REGR_SXY 2821
#define F_REGR_AVGX 2822
#define F_REGR_AVGY 2823
#define F_REGR_R2 2824
#define F_REGR_SLOPE 2825
#define F_REGR_INTERCEPT 2826
#define F_COVAR_POP 2827
#define F_COVAR_SAMP 2828
#define F_CORR 2829
#define F_PG_STAT_GET_DB_BLK_READ_TIME 2844
#define F_PG_STAT_GET_DB_BLK_WRITE_TIME 2845
#define F_PG_SWITCH_WAL 2848
#define F_PG_CURRENT_WAL_LSN 2849
#define F_PG_WALFILE_NAME_OFFSET 2850
#define F_PG_WALFILE_NAME 2851
#define F_PG_CURRENT_WAL_INSERT_LSN 2852
#define F_PG_STAT_GET_BACKEND_WAIT_EVENT 2853
#define F_PG_MY_TEMP_SCHEMA 2854
#define F_PG_IS_OTHER_TEMP_SCHEMA 2855
#define F_PG_TIMEZONE_NAMES 2856
#define F_PG_STAT_GET_BACKEND_XACT_START 2857
#define F_NUMERIC_AVG_ACCUM 2858
#define F_PG_STAT_GET_BUF_ALLOC 2859
#define F_PG_STAT_GET_LIVE_TUPLES 2878
#define F_PG_STAT_GET_DEAD_TUPLES 2879
#define F_PG_ADVISORY_LOCK_INT8 2880
#define F_PG_ADVISORY_LOCK_SHARED_INT8 2881
#define F_PG_TRY_ADVISORY_LOCK_INT8 2882
#define F_PG_TRY_ADVISORY_LOCK_SHARED_INT8 2883
#define F_PG_ADVISORY_UNLOCK_INT8 2884
#define F_PG_ADVISORY_UNLOCK_SHARED_INT8 2885
#define F_PG_ADVISORY_LOCK_INT4_INT4 2886
#define F_PG_ADVISORY_LOCK_SHARED_INT4_INT4 2887
#define F_PG_TRY_ADVISORY_LOCK_INT4_INT4 2888
#define F_PG_TRY_ADVISORY_LOCK_SHARED_INT4_INT4 2889
#define F_PG_ADVISORY_UNLOCK_INT4_INT4 2890
#define F_PG_ADVISORY_UNLOCK_SHARED_INT4_INT4 2891
#define F_PG_ADVISORY_UNLOCK_ALL 2892
#define F_XML_IN 2893
#define F_XML_OUT 2894
#define F_XMLCOMMENT 2895
#define F_XML 2896
#define F_XMLVALIDATE 2897
#define F_XML_RECV 2898
#define F_XML_SEND 2899
#define F_XMLCONCAT2 2900
#define F_XMLAGG 2901
#define F_VARBITTYPMODIN 2902
#define F_INTERVALTYPMODIN 2903
#define F_INTERVALTYPMODOUT 2904
#define F_TIMESTAMPTYPMODIN 2905
#define F_TIMESTAMPTYPMODOUT 2906
#define F_TIMESTAMPTZTYPMODIN 2907
#define F_TIMESTAMPTZTYPMODOUT 2908
#define F_TIMETYPMODIN 2909
#define F_TIMETYPMODOUT 2910
#define F_TIMETZTYPMODIN 2911
#define F_TIMETZTYPMODOUT 2912
#define F_BPCHARTYPMODIN 2913
#define F_BPCHARTYPMODOUT 2914
#define F_VARCHARTYPMODIN 2915
#define F_VARCHARTYPMODOUT 2916
#define F_NUMERICTYPMODIN 2917
#define F_NUMERICTYPMODOUT 2918
#define F_BITTYPMODIN 2919
#define F_BITTYPMODOUT 2920
#define F_VARBITTYPMODOUT 2921
#define F_TEXT_XML 2922
#define F_TABLE_TO_XML 2923
#define F_QUERY_TO_XML 2924
#define F_CURSOR_TO_XML 2925
#define F_TABLE_TO_XMLSCHEMA 2926
#define F_QUERY_TO_XMLSCHEMA 2927
#define F_CURSOR_TO_XMLSCHEMA 2928
#define F_TABLE_TO_XML_AND_XMLSCHEMA 2929
#define F_QUERY_TO_XML_AND_XMLSCHEMA 2930
#define F_XPATH_TEXT_XML__TEXT 2931
#define F_XPATH_TEXT_XML 2932
#define F_SCHEMA_TO_XML 2933
#define F_SCHEMA_TO_XMLSCHEMA 2934
#define F_SCHEMA_TO_XML_AND_XMLSCHEMA 2935
#define F_DATABASE_TO_XML 2936
#define F_DATABASE_TO_XMLSCHEMA 2937
#define F_DATABASE_TO_XML_AND_XMLSCHEMA 2938
#define F_TXID_SNAPSHOT_IN 2939
#define F_TXID_SNAPSHOT_OUT 2940
#define F_TXID_SNAPSHOT_RECV 2941
#define F_TXID_SNAPSHOT_SEND 2942
#define F_TXID_CURRENT 2943
#define F_TXID_CURRENT_SNAPSHOT 2944
#define F_TXID_SNAPSHOT_XMIN 2945
#define F_TXID_SNAPSHOT_XMAX 2946
#define F_TXID_SNAPSHOT_XIP 2947
#define F_TXID_VISIBLE_IN_SNAPSHOT 2948
#define F_UUID_IN 2952
#define F_UUID_OUT 2953
#define F_UUID_LT 2954
#define F_UUID_LE 2955
#define F_UUID_EQ 2956
#define F_UUID_GE 2957
#define F_UUID_GT 2958
#define F_UUID_NE 2959
#define F_UUID_CMP 2960
#define F_UUID_RECV 2961
#define F_UUID_SEND 2962
#define F_UUID_HASH 2963
#define F_TEXT_BOOL 2971
#define F_PG_STAT_GET_FUNCTION_CALLS 2978
#define F_PG_STAT_GET_FUNCTION_TOTAL_TIME 2979
#define F_PG_STAT_GET_FUNCTION_SELF_TIME 2980
#define F_RECORD_EQ 2981
#define F_RECORD_NE 2982
#define F_RECORD_LT 2983
#define F_RECORD_GT 2984
#define F_RECORD_LE 2985
#define F_RECORD_GE 2986
#define F_BTRECORDCMP 2987
#define F_PG_TABLE_SIZE 2997
#define F_PG_INDEXES_SIZE 2998
#define F_PG_RELATION_FILENODE 2999
#define F_HAS_FOREIGN_DATA_WRAPPER_PRIVILEGE_NAME_TEXT_TEXT 3000
#define F_HAS_FOREIGN_DATA_WRAPPER_PRIVILEGE_NAME_OID_TEXT 3001
#define F_HAS_FOREIGN_DATA_WRAPPER_PRIVILEGE_OID_TEXT_TEXT 3002
#define F_HAS_FOREIGN_DATA_WRAPPER_PRIVILEGE_OID_OID_TEXT 3003
#define F_HAS_FOREIGN_DATA_WRAPPER_PRIVILEGE_TEXT_TEXT 3004
#define F_HAS_FOREIGN_DATA_WRAPPER_PRIVILEGE_OID_TEXT 3005
#define F_HAS_SERVER_PRIVILEGE_NAME_TEXT_TEXT 3006
#define F_HAS_SERVER_PRIVILEGE_NAME_OID_TEXT 3007
#define F_HAS_SERVER_PRIVILEGE_OID_TEXT_TEXT 3008
#define F_HAS_SERVER_PRIVILEGE_OID_OID_TEXT 3009
#define F_HAS_SERVER_PRIVILEGE_TEXT_TEXT 3010
#define F_HAS_SERVER_PRIVILEGE_OID_TEXT 3011
#define F_HAS_COLUMN_PRIVILEGE_NAME_TEXT_TEXT_TEXT 3012
#define F_HAS_COLUMN_PRIVILEGE_NAME_TEXT_INT2_TEXT 3013
#define F_HAS_COLUMN_PRIVILEGE_NAME_OID_TEXT_TEXT 3014
#define F_HAS_COLUMN_PRIVILEGE_NAME_OID_INT2_TEXT 3015
#define F_HAS_COLUMN_PRIVILEGE_OID_TEXT_TEXT_TEXT 3016
#define F_HAS_COLUMN_PRIVILEGE_OID_TEXT_INT2_TEXT 3017
#define F_HAS_COLUMN_PRIVILEGE_OID_OID_TEXT_TEXT 3018
#define F_HAS_COLUMN_PRIVILEGE_OID_OID_INT2_TEXT 3019
#define F_HAS_COLUMN_PRIVILEGE_TEXT_TEXT_TEXT 3020
#define F_HAS_COLUMN_PRIVILEGE_TEXT_INT2_TEXT 3021
#define F_HAS_COLUMN_PRIVILEGE_OID_TEXT_TEXT 3022
#define F_HAS_COLUMN_PRIVILEGE_OID_INT2_TEXT 3023
#define F_HAS_ANY_COLUMN_PRIVILEGE_NAME_TEXT_TEXT 3024
#define F_HAS_ANY_COLUMN_PRIVILEGE_NAME_OID_TEXT 3025
#define F_HAS_ANY_COLUMN_PRIVILEGE_OID_TEXT_TEXT 3026
#define F_HAS_ANY_COLUMN_PRIVILEGE_OID_OID_TEXT 3027
#define F_HAS_ANY_COLUMN_PRIVILEGE_TEXT_TEXT 3028
#define F_HAS_ANY_COLUMN_PRIVILEGE_OID_TEXT 3029
#define F_OVERLAY_BIT_BIT_INT4_INT4 3030
#define F_OVERLAY_BIT_BIT_INT4 3031
#define F_GET_BIT_BIT_INT4 3032
#define F_SET_BIT_BIT_INT4_INT4 3033
#define F_PG_RELATION_FILEPATH 3034
#define F_PG_LISTENING_CHANNELS 3035
#define F_PG_NOTIFY 3036
#define F_PG_STAT_GET_XACT_NUMSCANS 3037
#define F_PG_STAT_GET_XACT_TUPLES_RETURNED 3038
#define F_PG_STAT_GET_XACT_TUPLES_FETCHED 3039
#define F_PG_STAT_GET_XACT_TUPLES_INSERTED 3040
#define F_PG_STAT_GET_XACT_TUPLES_UPDATED 3041
#define F_PG_STAT_GET_XACT_TUPLES_DELETED 3042
#define F_PG_STAT_GET_XACT_TUPLES_HOT_UPDATED 3043
#define F_PG_STAT_GET_XACT_BLOCKS_FETCHED 3044
#define F_PG_STAT_GET_XACT_BLOCKS_HIT 3045
#define F_PG_STAT_GET_XACT_FUNCTION_CALLS 3046
#define F_PG_STAT_GET_XACT_FUNCTION_TOTAL_TIME 3047
#define F_PG_STAT_GET_XACT_FUNCTION_SELF_TIME 3048
#define F_XPATH_EXISTS_TEXT_XML__TEXT 3049
#define F_XPATH_EXISTS_TEXT_XML 3050
#define F_XML_IS_WELL_FORMED 3051
#define F_XML_IS_WELL_FORMED_DOCUMENT 3052
#define F_XML_IS_WELL_FORMED_CONTENT 3053
#define F_PG_STAT_GET_VACUUM_COUNT 3054
#define F_PG_STAT_GET_AUTOVACUUM_COUNT 3055
#define F_PG_STAT_GET_ANALYZE_COUNT 3056
#define F_PG_STAT_GET_AUTOANALYZE_COUNT 3057
#define F_CONCAT 3058
#define F_CONCAT_WS 3059
#define F_LEFT 3060
#define F_RIGHT 3061
#define F_REVERSE_TEXT 3062
#define F_GIST_POINT_DISTANCE 3064
#define F_PG_STAT_GET_DB_CONFLICT_TABLESPACE 3065
#define F_PG_STAT_GET_DB_CONFLICT_LOCK 3066
#define F_PG_STAT_GET_DB_CONFLICT_SNAPSHOT 3067
#define F_PG_STAT_GET_DB_CONFLICT_BUFFERPIN 3068
#define F_PG_STAT_GET_DB_CONFLICT_STARTUP_DEADLOCK 3069
#define F_PG_STAT_GET_DB_CONFLICT_ALL 3070
#define F_PG_WAL_REPLAY_PAUSE 3071
#define F_PG_WAL_REPLAY_RESUME 3072
#define F_PG_IS_WAL_REPLAY_PAUSED 3073
#define F_PG_STAT_GET_DB_STAT_RESET_TIME 3074
#define F_PG_STAT_GET_BGWRITER_STAT_RESET_TIME 3075
#define F_GINARRAYEXTRACT_ANYARRAY_INTERNAL 3076
#define F_GIN_EXTRACT_TSVECTOR_TSVECTOR_INTERNAL 3077
#define F_PG_SEQUENCE_PARAMETERS 3078
#define F_PG_AVAILABLE_EXTENSIONS 3082
#define F_PG_AVAILABLE_EXTENSION_VERSIONS 3083
#define F_PG_EXTENSION_UPDATE_PATHS 3084
#define F_PG_EXTENSION_CONFIG_DUMP 3086
#define F_GIN_EXTRACT_TSQUERY_TSQUERY_INTERNAL_INT2_INTERNAL_INTERNAL 3087
#define F_GIN_TSQUERY_CONSISTENT_INTERNAL_INT2_TSQUERY_INT4_INTERNAL_INTERNAL 3088
#define F_PG_ADVISORY_XACT_LOCK_INT8 3089
#define F_PG_ADVISORY_XACT_LOCK_SHARED_INT8 3090
#define F_PG_TRY_ADVISORY_XACT_LOCK_INT8 3091
#define F_PG_TRY_ADVISORY_XACT_LOCK_SHARED_INT8 3092
#define F_PG_ADVISORY_XACT_LOCK_INT4_INT4 3093
#define F_PG_ADVISORY_XACT_LOCK_SHARED_INT4_INT4 3094
#define F_PG_TRY_ADVISORY_XACT_LOCK_INT4_INT4 3095
#define F_PG_TRY_ADVISORY_XACT_LOCK_SHARED_INT4_INT4 3096
#define F_VARCHAR_SUPPORT 3097
#define F_PG_CREATE_RESTORE_POINT 3098
#define F_PG_STAT_GET_WAL_SENDERS 3099
#define F_ROW_NUMBER 3100
#define F_RANK_ 3101
#define F_DENSE_RANK_ 3102
#define F_PERCENT_RANK_ 3103
#define F_CUME_DIST_ 3104
#define F_NTILE 3105
#define F_LAG_ANYELEMENT 3106
#define F_LAG_ANYELEMENT_INT4 3107
#define F_LAG_ANYCOMPATIBLE_INT4_ANYCOMPATIBLE 3108
#define F_LEAD_ANYELEMENT 3109
#define F_LEAD_ANYELEMENT_INT4 3110
#define F_LEAD_ANYCOMPATIBLE_INT4_ANYCOMPATIBLE 3111
#define F_FIRST_VALUE 3112
#define F_LAST_VALUE 3113
#define F_NTH_VALUE 3114
#define F_FDW_HANDLER_IN 3116
#define F_FDW_HANDLER_OUT 3117
#define F_VOID_RECV 3120
#define F_VOID_SEND 3121
#define F_BTINT2SORTSUPPORT 3129
#define F_BTINT4SORTSUPPORT 3130
#define F_BTINT8SORTSUPPORT 3131
#define F_BTFLOAT4SORTSUPPORT 3132
#define F_BTFLOAT8SORTSUPPORT 3133
#define F_BTOIDSORTSUPPORT 3134
#define F_BTNAMESORTSUPPORT 3135
#define F_DATE_SORTSUPPORT 3136
#define F_TIMESTAMP_SORTSUPPORT 3137
#define F_HAS_TYPE_PRIVILEGE_NAME_TEXT_TEXT 3138
#define F_HAS_TYPE_PRIVILEGE_NAME_OID_TEXT 3139
#define F_HAS_TYPE_PRIVILEGE_OID_TEXT_TEXT 3140
#define F_HAS_TYPE_PRIVILEGE_OID_OID_TEXT 3141
#define F_HAS_TYPE_PRIVILEGE_TEXT_TEXT 3142
#define F_HAS_TYPE_PRIVILEGE_OID_TEXT 3143
#define F_MACADDR_NOT 3144
#define F_MACADDR_AND 3145
#define F_MACADDR_OR 3146
#define F_PG_STAT_GET_DB_TEMP_FILES 3150
#define F_PG_STAT_GET_DB_TEMP_BYTES 3151
#define F_PG_STAT_GET_DB_DEADLOCKS 3152
#define F_ARRAY_TO_JSON_ANYARRAY 3153
#define F_ARRAY_TO_JSON_ANYARRAY_BOOL 3154
#define F_ROW_TO_JSON_RECORD 3155
#define F_ROW_TO_JSON_RECORD_BOOL 3156
#define F_NUMERIC_SUPPORT 3157
#define F_VARBIT_SUPPORT 3158
#define F_PG_GET_VIEWDEF_OID_INT4 3159
#define F_PG_STAT_GET_CHECKPOINTER_WRITE_TIME 3160
#define F_PG_STAT_GET_CHECKPOINTER_SYNC_TIME 3161
#define F_PG_COLLATION_FOR 3162
#define F_PG_TRIGGER_DEPTH 3163
#define F_PG_WAL_LSN_DIFF 3165
#define F_PG_SIZE_PRETTY_NUMERIC 3166
#define F_ARRAY_REMOVE 3167
#define F_ARRAY_REPLACE 3168
#define F_RANGESEL 3169
#define F_LO_LSEEK64 3170
#define F_LO_TELL64 3171
#define F_LO_TRUNCATE64 3172
#define F_JSON_AGG_TRANSFN 3173
#define F_JSON_AGG_FINALFN 3174
#define F_JSON_AGG 3175
#define F_TO_JSON 3176
#define F_PG_STAT_GET_MOD_SINCE_ANALYZE 3177
#define F_NUMERIC_SUM 3178
#define F_CARDINALITY 3179
#define F_JSON_OBJECT_AGG_TRANSFN 3180
#define F_RECORD_IMAGE_EQ 3181
#define F_RECORD_IMAGE_NE 3182
#define F_RECORD_IMAGE_LT 3183
#define F_RECORD_IMAGE_GT 3184
#define F_RECORD_IMAGE_LE 3185
#define F_RECORD_IMAGE_GE 3186
#define F_BTRECORDIMAGECMP 3187
#define F_PG_STAT_GET_ARCHIVER 3195
#define F_JSON_OBJECT_AGG_FINALFN 3196
#define F_JSON_OBJECT_AGG 3197
#define F_JSON_BUILD_ARRAY_ANY 3198
#define F_JSON_BUILD_ARRAY_ 3199
#define F_JSON_BUILD_OBJECT_ANY 3200
#define F_JSON_BUILD_OBJECT_ 3201
#define F_JSON_OBJECT__TEXT 3202
#define F_JSON_OBJECT__TEXT__TEXT 3203
#define F_JSON_TO_RECORD 3204
#define F_JSON_TO_RECORDSET 3205
#define F_JSONB_ARRAY_LENGTH 3207
#define F_JSONB_EACH 3208
#define F_JSONB_POPULATE_RECORD 3209
#define F_JSONB_TYPEOF 3210
#define F_JSONB_OBJECT_FIELD_TEXT 3214
#define F_JSONB_ARRAY_ELEMENT 3215
#define F_JSONB_ARRAY_ELEMENT_TEXT 3216
#define F_JSONB_EXTRACT_PATH 3217
#define F_WIDTH_BUCKET_ANYCOMPATIBLE_ANYCOMPATIBLEARRAY 3218
#define F_JSONB_ARRAY_ELEMENTS 3219
#define F_PG_LSN_IN 3229
#define F_PG_LSN_OUT 3230
#define F_PG_LSN_LT 3231
#define F_PG_LSN_LE 3232
#define F_PG_LSN_EQ 3233
#define F_PG_LSN_GE 3234
#define F_PG_LSN_GT 3235
#define F_PG_LSN_NE 3236
#define F_PG_LSN_MI 3237
#define F_PG_LSN_RECV 3238
#define F_PG_LSN_SEND 3239
#define F_PG_LSN_CMP 3251
#define F_PG_LSN_HASH 3252
#define F_BTTEXTSORTSUPPORT 3255
#define F_GENERATE_SERIES_NUMERIC_NUMERIC_NUMERIC 3259
#define F_GENERATE_SERIES_NUMERIC_NUMERIC 3260
#define F_JSON_STRIP_NULLS 3261
#define F_JSONB_STRIP_NULLS 3262
#define F_JSONB_OBJECT__TEXT 3263
#define F_JSONB_OBJECT__TEXT__TEXT 3264
#define F_JSONB_AGG_TRANSFN 3265
#define F_JSONB_AGG_FINALFN 3266
#define F_JSONB_AGG 3267
#define F_JSONB_OBJECT_AGG_TRANSFN 3268
#define F_JSONB_OBJECT_AGG_FINALFN 3269
#define F_JSONB_OBJECT_AGG 3270
#define F_JSONB_BUILD_ARRAY_ANY 3271
#define F_JSONB_BUILD_ARRAY_ 3272
#define F_JSONB_BUILD_OBJECT_ANY 3273
#define F_JSONB_BUILD_OBJECT_ 3274
#define F_DIST_PPOLY 3275
#define F_ARRAY_POSITION_ANYCOMPATIBLEARRAY_ANYCOMPATIBLE 3277
#define F_ARRAY_POSITION_ANYCOMPATIBLEARRAY_ANYCOMPATIBLE_INT4 3278
#define F_ARRAY_POSITIONS 3279
#define F_GIST_CIRCLE_DISTANCE 3280
#define F_SCALE 3281
#define F_GIST_POINT_FETCH 3282
#define F_NUMERIC_SORTSUPPORT 3283
#define F_GIST_POLY_DISTANCE 3288
#define F_DIST_CPOINT 3290
#define F_DIST_POLYP 3292
#define F_PG_READ_FILE_TEXT_INT8_INT8_BOOL 3293
#define F_CURRENT_SETTING_TEXT_BOOL 3294
#define F_PG_READ_BINARY_FILE_TEXT_INT8_INT8_BOOL 3295
#define F_PG_NOTIFICATION_QUEUE_USAGE 3296
#define F_PG_LS_DIR_TEXT_BOOL_BOOL 3297
#define F_ROW_SECURITY_ACTIVE_OID 3298
#define F_ROW_SECURITY_ACTIVE_TEXT 3299
#define F_UUID_SORTSUPPORT 3300
#define F_JSONB_CONCAT 3301
#define F_JSONB_DELETE_JSONB_TEXT 3302
#define F_JSONB_DELETE_JSONB_INT4 3303
#define F_JSONB_DELETE_PATH 3304
#define F_JSONB_SET 3305
#define F_JSONB_PRETTY 3306
#define F_PG_STAT_FILE_TEXT_BOOL 3307
#define F_XIDNEQ 3308
#define F_XIDNEQINT4 3309
#define F_TSM_HANDLER_IN 3311
#define F_TSM_HANDLER_OUT 3312
#define F_BERNOULLI 3313
#define F_SYSTEM 3314
#define F_PG_STAT_GET_WAL_RECEIVER 3317
#define F_PG_STAT_GET_PROGRESS_INFO 3318
#define F_TS_FILTER 3319
#define F_SETWEIGHT_TSVECTOR_CHAR__TEXT 3320
#define F_TS_DELETE_TSVECTOR_TEXT 3321
#define F_UNNEST_TSVECTOR 3322
#define F_TS_DELETE_TSVECTOR__TEXT 3323
#define F_INT4_AVG_COMBINE 3324
#define F_INTERVAL_AVG_COMBINE 3325
#define F_TSVECTOR_TO_ARRAY 3326
#define F_ARRAY_TO_TSVECTOR 3327
#define F_BPCHAR_SORTSUPPORT 3328
#define F_PG_SHOW_ALL_FILE_SETTINGS 3329
#define F_PG_CURRENT_WAL_FLUSH_LSN 3330
#define F_BYTEA_SORTSUPPORT 3331
#define F_BTTEXT_PATTERN_SORTSUPPORT 3332
#define F_BTBPCHAR_PATTERN_SORTSUPPORT 3333
#define F_PG_SIZE_BYTES 3334
#define F_NUMERIC_SERIALIZE 3335
#define F_NUMERIC_DESERIALIZE 3336
#define F_NUMERIC_AVG_COMBINE 3337
#define F_NUMERIC_POLY_COMBINE 3338
#define F_NUMERIC_POLY_SERIALIZE 3339
#define F_NUMERIC_POLY_DESERIALIZE 3340
#define F_NUMERIC_COMBINE 3341
#define F_FLOAT8_REGR_COMBINE 3342
#define F_JSONB_DELETE_JSONB__TEXT 3343
#define F_CASH_MUL_INT8 3344
#define F_CASH_DIV_INT8 3345
#define F_TXID_CURRENT_IF_ASSIGNED 3348
#define F_PG_GET_PARTKEYDEF 3352
#define F_PG_LS_LOGDIR 3353
#define F_PG_LS_WALDIR 3354
#define F_PG_NDISTINCT_IN 3355
#define F_PG_NDISTINCT_OUT 3356
#define F_PG_NDISTINCT_RECV 3357
#define F_PG_NDISTINCT_SEND 3358
#define F_MACADDR_SORTSUPPORT 3359
#define F_TXID_STATUS 3360
#define F_PG_SAFE_SNAPSHOT_BLOCKING_PIDS 3376
#define F_PG_ISOLATION_TEST_SESSION_IS_BLOCKED 3378
#define F_PG_IDENTIFY_OBJECT_AS_ADDRESS 3382
#define F_BRIN_MINMAX_OPCINFO 3383
#define F_BRIN_MINMAX_ADD_VALUE 3384
#define F_BRIN_MINMAX_CONSISTENT 3385
#define F_BRIN_MINMAX_UNION 3386
#define F_INT8_AVG_ACCUM_INV 3387
#define F_NUMERIC_POLY_SUM 3388
#define F_NUMERIC_POLY_AVG 3389
#define F_NUMERIC_POLY_VAR_POP 3390
#define F_NUMERIC_POLY_VAR_SAMP 3391
#define F_NUMERIC_POLY_STDDEV_POP 3392
#define F_NUMERIC_POLY_STDDEV_SAMP 3393
#define F_REGEXP_MATCH_TEXT_TEXT 3396
#define F_REGEXP_MATCH_TEXT_TEXT_TEXT 3397
#define F_INT8_MUL_CASH 3399
#define F_PG_CONFIG 3400
#define F_PG_HBA_FILE_RULES 3401
#define F_PG_STATISTICS_OBJ_IS_VISIBLE 3403
#define F_PG_DEPENDENCIES_IN 3404
#define F_PG_DEPENDENCIES_OUT 3405
#define F_PG_DEPENDENCIES_RECV 3406
#define F_PG_DEPENDENCIES_SEND 3407
#define F_PG_GET_PARTITION_CONSTRAINTDEF 3408
#define F_TIME_HASH_EXTENDED 3409
#define F_TIMETZ_HASH_EXTENDED 3410
#define F_TIMESTAMP_HASH_EXTENDED 3411
#define F_UUID_HASH_EXTENDED 3412
#define F_PG_LSN_HASH_EXTENDED 3413
#define F_HASHENUMEXTENDED 3414
#define F_PG_GET_STATISTICSOBJDEF 3415
#define F_JSONB_HASH_EXTENDED 3416
#define F_HASH_RANGE_EXTENDED 3417
#define F_INTERVAL_HASH_EXTENDED 3418
#define F_SHA224 3419
#define F_SHA256 3420
#define F_SHA384 3421
#define F_SHA512 3422
#define F_PG_PARTITION_TREE 3423
#define F_PG_PARTITION_ROOT 3424
#define F_PG_PARTITION_ANCESTORS 3425
#define F_PG_STAT_GET_DB_CHECKSUM_FAILURES 3426
#define F_PG_MCV_LIST_ITEMS 3427
#define F_PG_STAT_GET_DB_CHECKSUM_LAST_FAILURE 3428
#define F_GEN_RANDOM_UUID 3432
#define F_GTSVECTOR_OPTIONS 3434
#define F_GIST_POINT_SORTSUPPORT 3435
#define F_PG_PROMOTE 3436
#define F_PREFIXSEL 3437
#define F_PREFIXJOINSEL 3438
#define F_PG_CONTROL_SYSTEM 3441
#define F_PG_CONTROL_CHECKPOINT 3442
#define F_PG_CONTROL_RECOVERY 3443
#define F_PG_CONTROL_INIT 3444
#define F_PG_IMPORT_SYSTEM_COLLATIONS 3445
#define F_MACADDR8_RECV 3446
#define F_MACADDR8_SEND 3447
#define F_PG_COLLATION_ACTUAL_VERSION 3448
#define F_NUMERIC_JSONB 3449
#define F_INT2_JSONB 3450
#define F_INT4_JSONB 3451
#define F_INT8_JSONB 3452
#define F_FLOAT4_JSONB 3453
#define F_PG_FILENODE_RELATION 3454
#define F_LO_FROM_BYTEA 3457
#define F_LO_GET_OID 3458
#define F_LO_GET_OID_INT8_INT4 3459
#define F_LO_PUT 3460
#define F_MAKE_TIMESTAMP 3461
#define F_MAKE_TIMESTAMPTZ_INT4_INT4_INT4_INT4_INT4_FLOAT8 3462
#define F_MAKE_TIMESTAMPTZ_INT4_INT4_INT4_INT4_INT4_FLOAT8_TEXT 3463
#define F_MAKE_INTERVAL 3464
#define F_JSONB_ARRAY_ELEMENTS_TEXT 3465
#define F_SPG_RANGE_QUAD_CONFIG 3469
#define F_SPG_RANGE_QUAD_CHOOSE 3470
#define F_SPG_RANGE_QUAD_PICKSPLIT 3471
#define F_SPG_RANGE_QUAD_INNER_CONSISTENT 3472
#define F_SPG_RANGE_QUAD_LEAF_CONSISTENT 3473
#define F_JSONB_POPULATE_RECORDSET 3475
#define F_TO_REGOPERATOR 3476
#define F_JSONB_OBJECT_FIELD 3478
#define F_TO_REGPROCEDURE 3479
#define F_GIN_COMPARE_JSONB 3480
#define F_GIN_EXTRACT_JSONB 3482
#define F_GIN_EXTRACT_JSONB_QUERY 3483
#define F_GIN_CONSISTENT_JSONB 3484
#define F_GIN_EXTRACT_JSONB_PATH 3485
#define F_GIN_EXTRACT_JSONB_QUERY_PATH 3486
#define F_GIN_CONSISTENT_JSONB_PATH 3487
#define F_GIN_TRICONSISTENT_JSONB 3488
#define F_GIN_TRICONSISTENT_JSONB_PATH 3489
#define F_JSONB_TO_RECORD 3490
#define F_JSONB_TO_RECORDSET 3491
#define F_TO_REGOPER 3492
#define F_TO_REGTYPE 3493
#define F_TO_REGPROC 3494
#define F_TO_REGCLASS 3495
#define F_BOOL_ACCUM 3496
#define F_BOOL_ACCUM_INV 3497
#define F_BOOL_ALLTRUE 3498
#define F_BOOL_ANYTRUE 3499
#define F_ANYENUM_IN 3504
#define F_ANYENUM_OUT 3505
#define F_ENUM_IN 3506
#define F_ENUM_OUT 3507
#define F_ENUM_EQ 3508
#define F_ENUM_NE 3509
#define F_ENUM_LT 3510
#define F_ENUM_GT 3511
#define F_ENUM_LE 3512
#define F_ENUM_GE 3513
#define F_ENUM_CMP 3514
#define F_HASHENUM 3515
#define F_ENUM_SMALLER 3524
#define F_ENUM_LARGER 3525
#define F_MAX_ANYENUM 3526
#define F_MIN_ANYENUM 3527
#define F_ENUM_FIRST 3528
#define F_ENUM_LAST 3529
#define F_ENUM_RANGE_ANYENUM_ANYENUM 3530
#define F_ENUM_RANGE_ANYENUM 3531
#define F_ENUM_RECV 3532
#define F_ENUM_SEND 3533
#define F_STRING_AGG_TRANSFN 3535
#define F_STRING_AGG_FINALFN 3536
#define F_PG_DESCRIBE_OBJECT 3537
#define F_STRING_AGG_TEXT_TEXT 3538
#define F_FORMAT_TEXT_ANY 3539
#define F_FORMAT_TEXT 3540
#define F_BYTEA_STRING_AGG_TRANSFN 3543
#define F_BYTEA_STRING_AGG_FINALFN 3544
#define F_STRING_AGG_BYTEA_BYTEA 3545
#define F_INT8DEC 3546
#define F_INT8DEC_ANY 3547
#define F_NUMERIC_ACCUM_INV 3548
#define F_INTERVAL_AVG_ACCUM_INV 3549
#define F_NETWORK_OVERLAP 3551
#define F_INET_GIST_CONSISTENT 3553
#define F_INET_GIST_UNION 3554
#define F_INET_GIST_COMPRESS 3555
#define F_BOOL_JSONB 3556
#define F_INET_GIST_PENALTY 3557
#define F_INET_GIST_PICKSPLIT 3558
#define F_INET_GIST_SAME 3559
#define F_NETWORKSEL 3560
#define F_NETWORKJOINSEL 3561
#define F_NETWORK_LARGER 3562
#define F_NETWORK_SMALLER 3563
#define F_MAX_INET 3564
#define F_MIN_INET 3565
#define F_PG_EVENT_TRIGGER_DROPPED_OBJECTS 3566
#define F_INT2_ACCUM_INV 3567
#define F_INT4_ACCUM_INV 3568
#define F_INT8_ACCUM_INV 3569
#define F_INT2_AVG_ACCUM_INV 3570
#define F_INT4_AVG_ACCUM_INV 3571
#define F_INT2INT4_SUM 3572
#define F_INET_GIST_FETCH 3573
#define F_PG_LOGICAL_EMIT_MESSAGE_BOOL_TEXT_TEXT_BOOL 3577
#define F_PG_LOGICAL_EMIT_MESSAGE_BOOL_TEXT_BYTEA_BOOL 3578
#define F_JSONB_INSERT 3579
#define F_PG_XACT_COMMIT_TIMESTAMP 3581
#define F_BINARY_UPGRADE_SET_NEXT_PG_TYPE_OID 3582
#define F_PG_LAST_COMMITTED_XACT 3583
#define F_BINARY_UPGRADE_SET_NEXT_ARRAY_PG_TYPE_OID 3584
#define F_BINARY_UPGRADE_SET_NEXT_HEAP_PG_CLASS_OID 3586
#define F_BINARY_UPGRADE_SET_NEXT_INDEX_PG_CLASS_OID 3587
#define F_BINARY_UPGRADE_SET_NEXT_TOAST_PG_CLASS_OID 3588
#define F_BINARY_UPGRADE_SET_NEXT_PG_ENUM_OID 3589
#define F_BINARY_UPGRADE_SET_NEXT_PG_AUTHID_OID 3590
#define F_BINARY_UPGRADE_CREATE_EMPTY_EXTENSION 3591
#define F_EVENT_TRIGGER_IN 3594
#define F_EVENT_TRIGGER_OUT 3595
#define F_TSVECTORIN 3610
#define F_TSVECTOROUT 3611
#define F_TSQUERYIN 3612
#define F_TSQUERYOUT 3613
#define F_TSVECTOR_LT 3616
#define F_TSVECTOR_LE 3617
#define F_TSVECTOR_EQ 3618
#define F_TSVECTOR_NE 3619
#define F_TSVECTOR_GE 3620
#define F_TSVECTOR_GT 3621
#define F_TSVECTOR_CMP 3622
#define F_STRIP 3623
#define F_SETWEIGHT_TSVECTOR_CHAR 3624
#define F_TSVECTOR_CONCAT 3625
#define F_TS_MATCH_VQ 3634
#define F_TS_MATCH_QV 3635
#define F_TSVECTORSEND 3638
#define F_TSVECTORRECV 3639
#define F_TSQUERYSEND 3640
#define F_TSQUERYRECV 3641
#define F_GTSVECTORIN 3646
#define F_GTSVECTOROUT 3647
#define F_GTSVECTOR_COMPRESS 3648
#define F_GTSVECTOR_DECOMPRESS 3649
#define F_GTSVECTOR_PICKSPLIT 3650
#define F_GTSVECTOR_UNION 3651
#define F_GTSVECTOR_SAME 3652
#define F_GTSVECTOR_PENALTY 3653
#define F_GTSVECTOR_CONSISTENT_INTERNAL_TSVECTOR_INT2_OID_INTERNAL 3654
#define F_GIN_EXTRACT_TSVECTOR_TSVECTOR_INTERNAL_INTERNAL 3656
#define F_GIN_EXTRACT_TSQUERY_TSVECTOR_INTERNAL_INT2_INTERNAL_INTERNAL_INTERNAL_INTERNAL 3657
#define F_GIN_TSQUERY_CONSISTENT_INTERNAL_INT2_TSVECTOR_INT4_INTERNAL_INTERNAL_INTERNAL_INTERNAL 3658
#define F_TSQUERY_LT 3662
#define F_TSQUERY_LE 3663
#define F_TSQUERY_EQ 3664
#define F_TSQUERY_NE 3665
#define F_TSQUERY_GE 3666
#define F_TSQUERY_GT 3667
#define F_TSQUERY_CMP 3668
#define F_TSQUERY_AND 3669
#define F_TSQUERY_OR 3670
#define F_TSQUERY_NOT 3671
#define F_NUMNODE 3672
#define F_QUERYTREE 3673
#define F_TS_REWRITE_TSQUERY_TSQUERY_TSQUERY 3684
#define F_TS_REWRITE_TSQUERY_TEXT 3685
#define F_TSMATCHSEL 3686
#define F_TSMATCHJOINSEL 3687
#define F_TS_TYPANALYZE 3688
#define F_TS_STAT_TEXT 3689
#define F_TS_STAT_TEXT_TEXT 3690
#define F_TSQ_MCONTAINS 3691
#define F_TSQ_MCONTAINED 3692
#define F_GTSQUERY_COMPRESS 3695
#define F_STARTS_WITH 3696
#define F_GTSQUERY_PICKSPLIT 3697
#define F_GTSQUERY_UNION 3698
#define F_GTSQUERY_SAME 3699
#define F_GTSQUERY_PENALTY 3700
#define F_GTSQUERY_CONSISTENT_INTERNAL_TSQUERY_INT2_OID_INTERNAL 3701
#define F_TS_RANK__FLOAT4_TSVECTOR_TSQUERY_INT4 3703
#define F_TS_RANK__FLOAT4_TSVECTOR_TSQUERY 3704
#define F_TS_RANK_TSVECTOR_TSQUERY_INT4 3705
#define F_TS_RANK_TSVECTOR_TSQUERY 3706
#define F_TS_RANK_CD__FLOAT4_TSVECTOR_TSQUERY_INT4 3707
#define F_TS_RANK_CD__FLOAT4_TSVECTOR_TSQUERY 3708
#define F_TS_RANK_CD_TSVECTOR_TSQUERY_INT4 3709
#define F_TS_RANK_CD_TSVECTOR_TSQUERY 3710
#define F_LENGTH_TSVECTOR 3711
#define F_TS_TOKEN_TYPE_OID 3713
#define F_TS_TOKEN_TYPE_TEXT 3714
#define F_TS_PARSE_OID_TEXT 3715
#define F_TS_PARSE_TEXT_TEXT 3716
#define F_PRSD_START 3717
#define F_PRSD_NEXTTOKEN 3718
#define F_PRSD_END 3719
#define F_PRSD_HEADLINE 3720
#define F_PRSD_LEXTYPE 3721
#define F_TS_LEXIZE 3723
#define F_GIN_CMP_TSLEXEME 3724
#define F_DSIMPLE_INIT 3725
#define F_DSIMPLE_LEXIZE 3726
#define F_DSYNONYM_INIT 3728
#define F_DSYNONYM_LEXIZE 3729
#define F_DISPELL_INIT 3731
#define F_DISPELL_LEXIZE 3732
#define F_REGCONFIGIN 3736
#define F_REGCONFIGOUT 3737
#define F_REGCONFIGRECV 3738
#define F_REGCONFIGSEND 3739
#define F_THESAURUS_INIT 3740
#define F_THESAURUS_LEXIZE 3741
#define F_TS_HEADLINE_REGCONFIG_TEXT_TSQUERY_TEXT 3743
#define F_TS_HEADLINE_REGCONFIG_TEXT_TSQUERY 3744
#define F_TO_TSVECTOR_REGCONFIG_TEXT 3745
#define F_TO_TSQUERY_REGCONFIG_TEXT 3746
#define F_PLAINTO_TSQUERY_REGCONFIG_TEXT 3747
#define F_TO_TSVECTOR_TEXT 3749
#define F_TO_TSQUERY_TEXT 3750
#define F_PLAINTO_TSQUERY_TEXT 3751
#define F_TSVECTOR_UPDATE_TRIGGER 3752
#define F_TSVECTOR_UPDATE_TRIGGER_COLUMN 3753
#define F_TS_HEADLINE_TEXT_TSQUERY_TEXT 3754
#define F_TS_HEADLINE_TEXT_TSQUERY 3755
#define F_PG_TS_PARSER_IS_VISIBLE 3756
#define F_PG_TS_DICT_IS_VISIBLE 3757
#define F_PG_TS_CONFIG_IS_VISIBLE 3758
#define F_GET_CURRENT_TS_CONFIG 3759
#define F_TS_MATCH_TT 3760
#define F_TS_MATCH_TQ 3761
#define F_PG_TS_TEMPLATE_IS_VISIBLE 3768
#define F_REGDICTIONARYIN 3771
#define F_REGDICTIONARYOUT 3772
#define F_REGDICTIONARYRECV 3773
#define F_REGDICTIONARYSEND 3774
#define F_PG_STAT_RESET_SHARED 3775
#define F_PG_STAT_RESET_SINGLE_TABLE_COUNTERS 3776
#define F_PG_STAT_RESET_SINGLE_FUNCTION_COUNTERS 3777
#define F_PG_TABLESPACE_LOCATION 3778
#define F_PG_CREATE_PHYSICAL_REPLICATION_SLOT 3779
#define F_PG_DROP_REPLICATION_SLOT 3780
#define F_PG_GET_REPLICATION_SLOTS 3781
#define F_PG_LOGICAL_SLOT_GET_CHANGES 3782
#define F_PG_LOGICAL_SLOT_GET_BINARY_CHANGES 3783
#define F_PG_LOGICAL_SLOT_PEEK_CHANGES 3784
#define F_PG_LOGICAL_SLOT_PEEK_BINARY_CHANGES 3785
#define F_PG_CREATE_LOGICAL_REPLICATION_SLOT 3786
#define F_TO_JSONB 3787
#define F_PG_STAT_GET_SNAPSHOT_TIMESTAMP 3788
#define F_GIN_CLEAN_PENDING_LIST 3789
#define F_GTSVECTOR_CONSISTENT_INTERNAL_GTSVECTOR_INT4_OID_INTERNAL 3790
#define F_GIN_EXTRACT_TSQUERY_TSQUERY_INTERNAL_INT2_INTERNAL_INTERNAL_INTERNAL_INTERNAL 3791
#define F_GIN_TSQUERY_CONSISTENT_INTERNAL_INT2_TSQUERY_INT4_INTERNAL_INTERNAL_INTERNAL_INTERNAL 3792
#define F_GTSQUERY_CONSISTENT_INTERNAL_INTERNAL_INT4_OID_INTERNAL 3793
#define F_INET_SPG_CONFIG 3795
#define F_INET_SPG_CHOOSE 3796
#define F_INET_SPG_PICKSPLIT 3797
#define F_INET_SPG_INNER_CONSISTENT 3798
#define F_INET_SPG_LEAF_CONSISTENT 3799
#define F_PG_CURRENT_LOGFILE_ 3800
#define F_PG_CURRENT_LOGFILE_TEXT 3801
#define F_JSONB_SEND 3803
#define F_JSONB_OUT 3804
#define F_JSONB_RECV 3805
#define F_JSONB_IN 3806
#define F_PG_GET_FUNCTION_ARG_DEFAULT 3808
#define F_PG_EXPORT_SNAPSHOT 3809
#define F_PG_IS_IN_RECOVERY 3810
#define F_MONEY_INT4 3811
#define F_MONEY_INT8 3812
#define F_XMLTEXT 3813
#define F_PG_COLLATION_IS_VISIBLE 3815
#define F_ARRAY_TYPANALYZE 3816
#define F_ARRAYCONTSEL 3817
#define F_ARRAYCONTJOINSEL 3818
#define F_PG_GET_MULTIXACT_MEMBERS 3819
#define F_PG_LAST_WAL_RECEIVE_LSN 3820
#define F_PG_LAST_WAL_REPLAY_LSN 3821
#define F_CASH_DIV_CASH 3822
#define F_NUMERIC_MONEY 3823
#define F_MONEY_NUMERIC 3824
#define F_PG_READ_FILE_TEXT 3826
#define F_PG_READ_BINARY_FILE_TEXT_INT8_INT8 3827
#define F_PG_READ_BINARY_FILE_TEXT 3828
#define F_PG_OPFAMILY_IS_VISIBLE 3829
#define F_PG_LAST_XACT_REPLAY_TIMESTAMP 3830
#define F_ANYRANGE_IN 3832
#define F_ANYRANGE_OUT 3833
#define F_RANGE_IN 3834
#define F_RANGE_OUT 3835
#define F_RANGE_RECV 3836
#define F_RANGE_SEND 3837
#define F_PG_IDENTIFY_OBJECT 3839
#define F_INT4RANGE_INT4_INT4 3840
#define F_INT4RANGE_INT4_INT4_TEXT 3841
#define F_PG_RELATION_IS_UPDATABLE 3842
#define F_PG_COLUMN_IS_UPDATABLE 3843
#define F_NUMRANGE_NUMERIC_NUMERIC 3844
#define F_NUMRANGE_NUMERIC_NUMERIC_TEXT 3845
#define F_MAKE_DATE 3846
#define F_MAKE_TIME 3847
#define F_LOWER_ANYRANGE 3848
#define F_UPPER_ANYRANGE 3849
#define F_ISEMPTY_ANYRANGE 3850
#define F_LOWER_INC_ANYRANGE 3851
#define F_UPPER_INC_ANYRANGE 3852
#define F_LOWER_INF_ANYRANGE 3853
#define F_UPPER_INF_ANYRANGE 3854
#define F_RANGE_EQ 3855
#define F_RANGE_NE 3856
#define F_RANGE_OVERLAPS 3857
#define F_RANGE_CONTAINS_ELEM 3858
#define F_RANGE_CONTAINS 3859
#define F_ELEM_CONTAINED_BY_RANGE 3860
#define F_RANGE_CONTAINED_BY 3861
#define F_RANGE_ADJACENT 3862
#define F_RANGE_BEFORE 3863
#define F_RANGE_AFTER 3864
#define F_RANGE_OVERLEFT 3865
#define F_RANGE_OVERRIGHT 3866
#define F_RANGE_UNION 3867
#define F_RANGE_INTERSECT 3868
#define F_RANGE_MINUS 3869
#define F_RANGE_CMP 3870
#define F_RANGE_LT 3871
#define F_RANGE_LE 3872
#define F_RANGE_GE 3873
#define F_RANGE_GT 3874
#define F_RANGE_GIST_CONSISTENT 3875
#define F_RANGE_GIST_UNION 3876
#define F_PG_REPLICATION_SLOT_ADVANCE 3878
#define F_RANGE_GIST_PENALTY 3879
#define F_RANGE_GIST_PICKSPLIT 3880
#define F_RANGE_GIST_SAME 3881
#define F_HASH_RANGE 3902
#define F_INT4RANGE_CANONICAL 3914
#define F_DATERANGE_CANONICAL 3915
#define F_RANGE_TYPANALYZE 3916
#define F_TIMESTAMP_SUPPORT 3917
#define F_INTERVAL_SUPPORT 3918
#define F_GINARRAYTRICONSISTENT 3920
#define F_GIN_TSQUERY_TRICONSISTENT 3921
#define F_INT4RANGE_SUBDIFF 3922
#define F_INT8RANGE_SUBDIFF 3923
#define F_NUMRANGE_SUBDIFF 3924
#define F_DATERANGE_SUBDIFF 3925
#define F_INT8RANGE_CANONICAL 3928
#define F_TSRANGE_SUBDIFF 3929
#define F_TSTZRANGE_SUBDIFF 3930
#define F_JSONB_OBJECT_KEYS 3931
#define F_JSONB_EACH_TEXT 3932
#define F_TSRANGE_TIMESTAMP_TIMESTAMP 3933
#define F_TSRANGE_TIMESTAMP_TIMESTAMP_TEXT 3934
#define F_PG_SLEEP_FOR 3935
#define F_PG_SLEEP_UNTIL 3936
#define F_TSTZRANGE_TIMESTAMPTZ_TIMESTAMPTZ 3937
#define F_TSTZRANGE_TIMESTAMPTZ_TIMESTAMPTZ_TEXT 3938
#define F_MXID_AGE 3939
#define F_JSONB_EXTRACT_PATH_TEXT 3940
#define F_DATERANGE_DATE_DATE 3941
#define F_DATERANGE_DATE_DATE_TEXT 3942
#define F_ACLDEFAULT 3943
#define F_TIME_SUPPORT 3944
#define F_INT8RANGE_INT8_INT8 3945
#define F_INT8RANGE_INT8_INT8_TEXT 3946
#define F_JSON_OBJECT_FIELD 3947
#define F_JSON_OBJECT_FIELD_TEXT 3948
#define F_JSON_ARRAY_ELEMENT 3949
#define F_JSON_ARRAY_ELEMENT_TEXT 3950
#define F_JSON_EXTRACT_PATH 3951
#define F_BRIN_SUMMARIZE_NEW_VALUES 3952
#define F_JSON_EXTRACT_PATH_TEXT 3953
#define F_PG_GET_OBJECT_ADDRESS 3954
#define F_JSON_ARRAY_ELEMENTS 3955
#define F_JSON_ARRAY_LENGTH 3956
#define F_JSON_OBJECT_KEYS 3957
#define F_JSON_EACH 3958
#define F_JSON_EACH_TEXT 3959
#define F_JSON_POPULATE_RECORD 3960
#define F_JSON_POPULATE_RECORDSET 3961
#define F_JSON_TYPEOF 3968
#define F_JSON_ARRAY_ELEMENTS_TEXT 3969
#define F_ORDERED_SET_TRANSITION 3970
#define F_ORDERED_SET_TRANSITION_MULTI 3971
#define F_PERCENTILE_DISC_FLOAT8_ANYELEMENT 3972
#define F_PERCENTILE_DISC_FINAL 3973
#define F_PERCENTILE_CONT_FLOAT8_FLOAT8 3974
#define F_PERCENTILE_CONT_FLOAT8_FINAL 3975
#define F_PERCENTILE_CONT_FLOAT8_INTERVAL 3976
#define F_PERCENTILE_CONT_INTERVAL_FINAL 3977
#define F_PERCENTILE_DISC__FLOAT8_ANYELEMENT 3978
#define F_PERCENTILE_DISC_MULTI_FINAL 3979
#define F_PERCENTILE_CONT__FLOAT8_FLOAT8 3980
#define F_PERCENTILE_CONT_FLOAT8_MULTI_FINAL 3981
#define F_PERCENTILE_CONT__FLOAT8_INTERVAL 3982
#define F_PERCENTILE_CONT_INTERVAL_MULTI_FINAL 3983
#define F_MODE 3984
#define F_MODE_FINAL 3985
#define F_RANK_ANY 3986
#define F_RANK_FINAL 3987
#define F_PERCENT_RANK_ANY 3988
#define F_PERCENT_RANK_FINAL 3989
#define F_CUME_DIST_ANY 3990
#define F_CUME_DIST_FINAL 3991
#define F_DENSE_RANK_ANY 3992
#define F_DENSE_RANK_FINAL 3993
#define F_GENERATE_SERIES_INT4_SUPPORT 3994
#define F_GENERATE_SERIES_INT8_SUPPORT 3995
#define F_ARRAY_UNNEST_SUPPORT 3996
#define F_GIST_BOX_DISTANCE 3998
#define F_BRIN_SUMMARIZE_RANGE 3999
#define F_JSONPATH_IN 4001
#define F_JSONPATH_RECV 4002
#define F_JSONPATH_OUT 4003
#define F_JSONPATH_SEND 4004
#define F_JSONB_PATH_EXISTS 4005
#define F_JSONB_PATH_QUERY 4006
#define F_JSONB_PATH_QUERY_ARRAY 4007
#define F_JSONB_PATH_QUERY_FIRST 4008
#define F_JSONB_PATH_MATCH 4009
#define F_JSONB_PATH_EXISTS_OPR 4010
#define F_JSONB_PATH_MATCH_OPR 4011
#define F_BRIN_DESUMMARIZE_RANGE 4014
#define F_SPG_QUAD_CONFIG 4018
#define F_SPG_QUAD_CHOOSE 4019
#define F_SPG_QUAD_PICKSPLIT 4020
#define F_SPG_QUAD_INNER_CONSISTENT 4021
#define F_SPG_QUAD_LEAF_CONSISTENT 4022
#define F_SPG_KD_CONFIG 4023
#define F_SPG_KD_CHOOSE 4024
#define F_SPG_KD_PICKSPLIT 4025
#define F_SPG_KD_INNER_CONSISTENT 4026
#define F_SPG_TEXT_CONFIG 4027
#define F_SPG_TEXT_CHOOSE 4028
#define F_SPG_TEXT_PICKSPLIT 4029
#define F_SPG_TEXT_INNER_CONSISTENT 4030
#define F_SPG_TEXT_LEAF_CONSISTENT 4031
#define F_PG_SEQUENCE_LAST_VALUE 4032
#define F_JSONB_NE 4038
#define F_JSONB_LT 4039
#define F_JSONB_GT 4040
#define F_JSONB_LE 4041
#define F_JSONB_GE 4042
#define F_JSONB_EQ 4043
#define F_JSONB_CMP 4044
#define F_JSONB_HASH 4045
#define F_JSONB_CONTAINS 4046
#define F_JSONB_EXISTS 4047
#define F_JSONB_EXISTS_ANY 4048
#define F_JSONB_EXISTS_ALL 4049
#define F_JSONB_CONTAINED 4050
#define F_ARRAY_AGG_ARRAY_TRANSFN 4051
#define F_ARRAY_AGG_ARRAY_FINALFN 4052
#define F_ARRAY_AGG_ANYARRAY 4053
#define F_RANGE_MERGE_ANYRANGE_ANYRANGE 4057
#define F_INET_MERGE 4063
#define F_BOUND_BOX 4067
#define F_INET_SAME_FAMILY 4071
#define F_BINARY_UPGRADE_SET_RECORD_INIT_PRIVS 4083
#define F_REGNAMESPACEIN 4084
#define F_REGNAMESPACEOUT 4085
#define F_TO_REGNAMESPACE 4086
#define F_REGNAMESPACERECV 4087
#define F_REGNAMESPACESEND 4088
#define F_BOX_POINT 4091
#define F_REGROLEOUT 4092
#define F_TO_REGROLE 4093
#define F_REGROLERECV 4094
#define F_REGROLESEND 4095
#define F_REGROLEIN 4098
#define F_PG_NUMA_AVAILABLE 4099
#define F_PG_GET_SHMEM_ALLOCATIONS_NUMA 4100
#define F_BINARY_UPGRADE_SET_MISSING_VALUE 4101
#define F_BRIN_INCLUSION_OPCINFO 4105
#define F_BRIN_INCLUSION_ADD_VALUE 4106
#define F_BRIN_INCLUSION_CONSISTENT 4107
#define F_BRIN_INCLUSION_UNION 4108
#define F_MACADDR8_IN 4110
#define F_MACADDR8_OUT 4111
#define F_TRUNC_MACADDR8 4112
#define F_MACADDR8_EQ 4113
#define F_MACADDR8_LT 4114
#define F_MACADDR8_LE 4115
#define F_MACADDR8_GT 4116
#define F_MACADDR8_GE 4117
#define F_MACADDR8_NE 4118
#define F_MACADDR8_CMP 4119
#define F_MACADDR8_NOT 4120
#define F_MACADDR8_AND 4121
#define F_MACADDR8_OR 4122
#define F_MACADDR8 4123
#define F_MACADDR 4124
#define F_MACADDR8_SET7BIT 4125
#define F_IN_RANGE_INT8_INT8_INT8_BOOL_BOOL 4126
#define F_IN_RANGE_INT4_INT4_INT8_BOOL_BOOL 4127
#define F_IN_RANGE_INT4_INT4_INT4_BOOL_BOOL 4128
#define F_IN_RANGE_INT4_INT4_INT2_BOOL_BOOL 4129
#define F_IN_RANGE_INT2_INT2_INT8_BOOL_BOOL 4130
#define F_IN_RANGE_INT2_INT2_INT4_BOOL_BOOL 4131
#define F_IN_RANGE_INT2_INT2_INT2_BOOL_BOOL 4132
#define F_IN_RANGE_DATE_DATE_INTERVAL_BOOL_BOOL 4133
#define F_IN_RANGE_TIMESTAMP_TIMESTAMP_INTERVAL_BOOL_BOOL 4134
#define F_IN_RANGE_TIMESTAMPTZ_TIMESTAMPTZ_INTERVAL_BOOL_BOOL 4135
#define F_IN_RANGE_INTERVAL_INTERVAL_INTERVAL_BOOL_BOOL 4136
#define F_IN_RANGE_TIME_TIME_INTERVAL_BOOL_BOOL 4137
#define F_IN_RANGE_TIMETZ_TIMETZ_INTERVAL_BOOL_BOOL 4138
#define F_IN_RANGE_FLOAT8_FLOAT8_FLOAT8_BOOL_BOOL 4139
#define F_IN_RANGE_FLOAT4_FLOAT4_FLOAT8_BOOL_BOOL 4140
#define F_IN_RANGE_NUMERIC_NUMERIC_NUMERIC_BOOL_BOOL 4141
#define F_PG_LSN_LARGER 4187
#define F_PG_LSN_SMALLER 4188
#define F_MAX_PG_LSN 4189
#define F_MIN_PG_LSN 4190
#define F_REGCOLLATIONIN 4193
#define F_REGCOLLATIONOUT 4194
#define F_TO_REGCOLLATION 4195
#define F_REGCOLLATIONRECV 4196
#define F_REGCOLLATIONSEND 4197
#define F_TS_HEADLINE_REGCONFIG_JSONB_TSQUERY_TEXT 4201
#define F_TS_HEADLINE_REGCONFIG_JSONB_TSQUERY 4202
#define F_TS_HEADLINE_JSONB_TSQUERY_TEXT 4203
#define F_TS_HEADLINE_JSONB_TSQUERY 4204
#define F_TS_HEADLINE_REGCONFIG_JSON_TSQUERY_TEXT 4205
#define F_TS_HEADLINE_REGCONFIG_JSON_TSQUERY 4206
#define F_TS_HEADLINE_JSON_TSQUERY_TEXT 4207
#define F_TS_HEADLINE_JSON_TSQUERY 4208
#define F_TO_TSVECTOR_JSONB 4209
#define F_TO_TSVECTOR_JSON 4210
#define F_TO_TSVECTOR_REGCONFIG_JSONB 4211
#define F_TO_TSVECTOR_REGCONFIG_JSON 4212
#define F_JSONB_TO_TSVECTOR_JSONB_JSONB 4213
#define F_JSONB_TO_TSVECTOR_REGCONFIG_JSONB_JSONB 4214
#define F_JSON_TO_TSVECTOR_JSON_JSONB 4215
#define F_JSON_TO_TSVECTOR_REGCONFIG_JSON_JSONB 4216
#define F_PG_COPY_PHYSICAL_REPLICATION_SLOT_NAME_NAME_BOOL 4220
#define F_PG_COPY_PHYSICAL_REPLICATION_SLOT_NAME_NAME 4221
#define F_PG_COPY_LOGICAL_REPLICATION_SLOT_NAME_NAME_BOOL_NAME 4222
#define F_PG_COPY_LOGICAL_REPLICATION_SLOT_NAME_NAME_BOOL 4223
#define F_PG_COPY_LOGICAL_REPLICATION_SLOT_NAME_NAME 4224
#define F_ANYCOMPATIBLEMULTIRANGE_IN 4226
#define F_ANYCOMPATIBLEMULTIRANGE_OUT 4227
#define F_RANGE_MERGE_ANYMULTIRANGE 4228
#define F_ANYMULTIRANGE_IN 4229
#define F_ANYMULTIRANGE_OUT 4230
#define F_MULTIRANGE_IN 4231
#define F_MULTIRANGE_OUT 4232
#define F_MULTIRANGE_RECV 4233
#define F_MULTIRANGE_SEND 4234
#define F_LOWER_ANYMULTIRANGE 4235
#define F_UPPER_ANYMULTIRANGE 4236
#define F_ISEMPTY_ANYMULTIRANGE 4237
#define F_LOWER_INC_ANYMULTIRANGE 4238
#define F_UPPER_INC_ANYMULTIRANGE 4239
#define F_LOWER_INF_ANYMULTIRANGE 4240
#define F_UPPER_INF_ANYMULTIRANGE 4241
#define F_MULTIRANGE_TYPANALYZE 4242
#define F_MULTIRANGESEL 4243
#define F_MULTIRANGE_EQ 4244
#define F_MULTIRANGE_NE 4245
#define F_RANGE_OVERLAPS_MULTIRANGE 4246
#define F_MULTIRANGE_OVERLAPS_RANGE 4247
#define F_MULTIRANGE_OVERLAPS_MULTIRANGE 4248
#define F_MULTIRANGE_CONTAINS_ELEM 4249
#define F_MULTIRANGE_CONTAINS_RANGE 4250
#define F_MULTIRANGE_CONTAINS_MULTIRANGE 4251
#define F_ELEM_CONTAINED_BY_MULTIRANGE 4252
#define F_RANGE_CONTAINED_BY_MULTIRANGE 4253
#define F_MULTIRANGE_CONTAINED_BY_MULTIRANGE 4254
#define F_RANGE_ADJACENT_MULTIRANGE 4255
#define F_MULTIRANGE_ADJACENT_MULTIRANGE 4256
#define F_MULTIRANGE_ADJACENT_RANGE 4257
#define F_RANGE_BEFORE_MULTIRANGE 4258
#define F_MULTIRANGE_BEFORE_RANGE 4259
#define F_MULTIRANGE_BEFORE_MULTIRANGE 4260
#define F_RANGE_AFTER_MULTIRANGE 4261
#define F_MULTIRANGE_AFTER_RANGE 4262
#define F_MULTIRANGE_AFTER_MULTIRANGE 4263
#define F_RANGE_OVERLEFT_MULTIRANGE 4264
#define F_MULTIRANGE_OVERLEFT_RANGE 4265
#define F_MULTIRANGE_OVERLEFT_MULTIRANGE 4266
#define F_RANGE_OVERRIGHT_MULTIRANGE 4267
#define F_MULTIRANGE_OVERRIGHT_RANGE 4268
#define F_MULTIRANGE_OVERRIGHT_MULTIRANGE 4269
#define F_MULTIRANGE_UNION 4270
#define F_MULTIRANGE_MINUS 4271
#define F_MULTIRANGE_INTERSECT 4272
#define F_MULTIRANGE_CMP 4273
#define F_MULTIRANGE_LT 4274
#define F_MULTIRANGE_LE 4275
#define F_MULTIRANGE_GE 4276
#define F_MULTIRANGE_GT 4277
#define F_HASH_MULTIRANGE 4278
#define F_HASH_MULTIRANGE_EXTENDED 4279
#define F_INT4MULTIRANGE_ 4280
#define F_INT4MULTIRANGE_INT4RANGE 4281
#define F_INT4MULTIRANGE__INT4RANGE 4282
#define F_NUMMULTIRANGE_ 4283
#define F_NUMMULTIRANGE_NUMRANGE 4284
#define F_NUMMULTIRANGE__NUMRANGE 4285
#define F_TSMULTIRANGE_ 4286
#define F_TSMULTIRANGE_TSRANGE 4287
#define F_TSMULTIRANGE__TSRANGE 4288
#define F_TSTZMULTIRANGE_ 4289
#define F_TSTZMULTIRANGE_TSTZRANGE 4290
#define F_TSTZMULTIRANGE__TSTZRANGE 4291
#define F_DATEMULTIRANGE_ 4292
#define F_DATEMULTIRANGE_DATERANGE 4293
#define F_DATEMULTIRANGE__DATERANGE 4294
#define F_INT8MULTIRANGE_ 4295
#define F_INT8MULTIRANGE_INT8RANGE 4296
#define F_INT8MULTIRANGE__INT8RANGE 4297
#define F_MULTIRANGE 4298
#define F_RANGE_AGG_TRANSFN 4299
#define F_RANGE_AGG_FINALFN 4300
#define F_RANGE_AGG_ANYRANGE 4301
#define F_KOI8R_TO_MIC 4302
#define F_MIC_TO_KOI8R 4303
#define F_ISO_TO_MIC 4304
#define F_MIC_TO_ISO 4305
#define F_WIN1251_TO_MIC 4306
#define F_MIC_TO_WIN1251 4307
#define F_WIN866_TO_MIC 4308
#define F_MIC_TO_WIN866 4309
#define F_KOI8R_TO_WIN1251 4310
#define F_WIN1251_TO_KOI8R 4311
#define F_KOI8R_TO_WIN866 4312
#define F_WIN866_TO_KOI8R 4313
#define F_WIN866_TO_WIN1251 4314
#define F_WIN1251_TO_WIN866 4315
#define F_ISO_TO_KOI8R 4316
#define F_KOI8R_TO_ISO 4317
#define F_ISO_TO_WIN1251 4318
#define F_WIN1251_TO_ISO 4319
#define F_ISO_TO_WIN866 4320
#define F_WIN866_TO_ISO 4321
#define F_EUC_CN_TO_MIC 4322
#define F_MIC_TO_EUC_CN 4323
#define F_EUC_JP_TO_SJIS 4324
#define F_SJIS_TO_EUC_JP 4325
#define F_EUC_JP_TO_MIC 4326
#define F_SJIS_TO_MIC 4327
#define F_MIC_TO_EUC_JP 4328
#define F_MIC_TO_SJIS 4329
#define F_EUC_KR_TO_MIC 4330
#define F_MIC_TO_EUC_KR 4331
#define F_EUC_TW_TO_BIG5 4332
#define F_BIG5_TO_EUC_TW 4333
#define F_EUC_TW_TO_MIC 4334
#define F_BIG5_TO_MIC 4335
#define F_MIC_TO_EUC_TW 4336
#define F_MIC_TO_BIG5 4337
#define F_LATIN2_TO_MIC 4338
#define F_MIC_TO_LATIN2 4339
#define F_WIN1250_TO_MIC 4340
#define F_MIC_TO_WIN1250 4341
#define F_LATIN2_TO_WIN1250 4342
#define F_WIN1250_TO_LATIN2 4343
#define F_LATIN1_TO_MIC 4344
#define F_MIC_TO_LATIN1 4345
#define F_LATIN3_TO_MIC 4346
#define F_MIC_TO_LATIN3 4347
#define F_LATIN4_TO_MIC 4348
#define F_MIC_TO_LATIN4 4349
#define F_NORMALIZE 4350
#define F_IS_NORMALIZED 4351
#define F_BIG5_TO_UTF8 4352
#define F_UTF8_TO_BIG5 4353
#define F_UTF8_TO_KOI8R 4354
#define F_KOI8R_TO_UTF8 4355
#define F_UTF8_TO_KOI8U 4356
#define F_KOI8U_TO_UTF8 4357
#define F_UTF8_TO_WIN 4358
#define F_WIN_TO_UTF8 4359
#define F_EUC_CN_TO_UTF8 4360
#define F_UTF8_TO_EUC_CN 4361
#define F_EUC_JP_TO_UTF8 4362
#define F_UTF8_TO_EUC_JP 4363
#define F_EUC_KR_TO_UTF8 4364
#define F_UTF8_TO_EUC_KR 4365
#define F_EUC_TW_TO_UTF8 4366
#define F_UTF8_TO_EUC_TW 4367
#define F_GB18030_TO_UTF8 4368
#define F_UTF8_TO_GB18030 4369
#define F_GBK_TO_UTF8 4370
#define F_UTF8_TO_GBK 4371
#define F_UTF8_TO_ISO8859 4372
#define F_ISO8859_TO_UTF8 4373
#define F_ISO8859_1_TO_UTF8 4374
#define F_UTF8_TO_ISO8859_1 4375
#define F_JOHAB_TO_UTF8 4376
#define F_UTF8_TO_JOHAB 4377
#define F_SJIS_TO_UTF8 4378
#define F_UTF8_TO_SJIS 4379
#define F_UHC_TO_UTF8 4380
#define F_UTF8_TO_UHC 4381
#define F_EUC_JIS_2004_TO_UTF8 4382
#define F_UTF8_TO_EUC_JIS_2004 4383
#define F_SHIFT_JIS_2004_TO_UTF8 4384
#define F_UTF8_TO_SHIFT_JIS_2004 4385
#define F_EUC_JIS_2004_TO_SHIFT_JIS_2004 4386
#define F_SHIFT_JIS_2004_TO_EUC_JIS_2004 4387
#define F_MULTIRANGE_INTERSECT_AGG_TRANSFN 4388
#define F_RANGE_INTERSECT_AGG_ANYMULTIRANGE 4389
#define F_BINARY_UPGRADE_SET_NEXT_MULTIRANGE_PG_TYPE_OID 4390
#define F_BINARY_UPGRADE_SET_NEXT_MULTIRANGE_ARRAY_PG_TYPE_OID 4391
#define F_RANGE_INTERSECT_AGG_TRANSFN 4401
#define F_RANGE_INTERSECT_AGG_ANYRANGE 4450
#define F_RANGE_CONTAINS_MULTIRANGE 4541
#define F_MULTIRANGE_CONTAINED_BY_RANGE 4542
#define F_PG_LOG_BACKEND_MEMORY_CONTEXTS 4543
#define F_BINARY_UPGRADE_SET_NEXT_HEAP_RELFILENODE 4545
#define F_BINARY_UPGRADE_SET_NEXT_INDEX_RELFILENODE 4546
#define F_BINARY_UPGRADE_SET_NEXT_TOAST_RELFILENODE 4547
#define F_BINARY_UPGRADE_SET_NEXT_PG_TABLESPACE_OID 4548
#define F_UNICODE_VERSION 4549
#define F_PG_EVENT_TRIGGER_TABLE_REWRITE_OID 4566
#define F_PG_EVENT_TRIGGER_TABLE_REWRITE_REASON 4567
#define F_PG_EVENT_TRIGGER_DDL_COMMANDS 4568
#define F_BRIN_BLOOM_OPCINFO 4591
#define F_BRIN_BLOOM_ADD_VALUE 4592
#define F_BRIN_BLOOM_CONSISTENT 4593
#define F_BRIN_BLOOM_UNION 4594
#define F_BRIN_BLOOM_OPTIONS 4595
#define F_BRIN_BLOOM_SUMMARY_IN 4596
#define F_BRIN_BLOOM_SUMMARY_OUT 4597
#define F_BRIN_BLOOM_SUMMARY_RECV 4598
#define F_BRIN_BLOOM_SUMMARY_SEND 4599
#define F_BRIN_MINMAX_MULTI_OPCINFO 4616
#define F_BRIN_MINMAX_MULTI_ADD_VALUE 4617
#define F_BRIN_MINMAX_MULTI_CONSISTENT 4618
#define F_BRIN_MINMAX_MULTI_UNION 4619
#define F_BRIN_MINMAX_MULTI_OPTIONS 4620
#define F_BRIN_MINMAX_MULTI_DISTANCE_INT2 4621
#define F_BRIN_MINMAX_MULTI_DISTANCE_INT4 4622
#define F_BRIN_MINMAX_MULTI_DISTANCE_INT8 4623
#define F_BRIN_MINMAX_MULTI_DISTANCE_FLOAT4 4624
#define F_BRIN_MINMAX_MULTI_DISTANCE_FLOAT8 4625
#define F_BRIN_MINMAX_MULTI_DISTANCE_NUMERIC 4626
#define F_BRIN_MINMAX_MULTI_DISTANCE_TID 4627
#define F_BRIN_MINMAX_MULTI_DISTANCE_UUID 4628
#define F_BRIN_MINMAX_MULTI_DISTANCE_DATE 4629
#define F_BRIN_MINMAX_MULTI_DISTANCE_TIME 4630
#define F_BRIN_MINMAX_MULTI_DISTANCE_INTERVAL 4631
#define F_BRIN_MINMAX_MULTI_DISTANCE_TIMETZ 4632
#define F_BRIN_MINMAX_MULTI_DISTANCE_PG_LSN 4633
#define F_BRIN_MINMAX_MULTI_DISTANCE_MACADDR 4634
#define F_BRIN_MINMAX_MULTI_DISTANCE_MACADDR8 4635
#define F_BRIN_MINMAX_MULTI_DISTANCE_INET 4636
#define F_BRIN_MINMAX_MULTI_DISTANCE_TIMESTAMP 4637
#define F_BRIN_MINMAX_MULTI_SUMMARY_IN 4638
#define F_BRIN_MINMAX_MULTI_SUMMARY_OUT 4639
#define F_BRIN_MINMAX_MULTI_SUMMARY_RECV 4640
#define F_BRIN_MINMAX_MULTI_SUMMARY_SEND 4641
#define F_PHRASETO_TSQUERY_TEXT 5001
#define F_TSQUERY_PHRASE_TSQUERY_TSQUERY 5003
#define F_TSQUERY_PHRASE_TSQUERY_TSQUERY_INT4 5004
#define F_PHRASETO_TSQUERY_REGCONFIG_TEXT 5006
#define F_WEBSEARCH_TO_TSQUERY_REGCONFIG_TEXT 5007
#define F_WEBSEARCH_TO_TSQUERY_TEXT 5009
#define F_SPG_BBOX_QUAD_CONFIG 5010
#define F_SPG_POLY_QUAD_COMPRESS 5011
#define F_SPG_BOX_QUAD_CONFIG 5012
#define F_SPG_BOX_QUAD_CHOOSE 5013
#define F_SPG_BOX_QUAD_PICKSPLIT 5014
#define F_SPG_BOX_QUAD_INNER_CONSISTENT 5015
#define F_SPG_BOX_QUAD_LEAF_CONSISTENT 5016
#define F_PG_MCV_LIST_IN 5018
#define F_PG_MCV_LIST_OUT 5019
#define F_PG_MCV_LIST_RECV 5020
#define F_PG_MCV_LIST_SEND 5021
#define F_PG_LSN_PLI 5022
#define F_NUMERIC_PL_PG_LSN 5023
#define F_PG_LSN_MII 5024
#define F_SATISFIES_HASH_PARTITION 5028
#define F_PG_LS_TMPDIR_ 5029
#define F_PG_LS_TMPDIR_OID 5030
#define F_PG_LS_ARCHIVE_STATUSDIR 5031
#define F_NETWORK_SORTSUPPORT 5033
#define F_XID8LT 5034
#define F_XID8GT 5035
#define F_XID8LE 5036
#define F_XID8GE 5037
#define F_MATCHINGSEL 5040
#define F_MATCHINGJOINSEL 5041
#define F_MIN_SCALE 5042
#define F_TRIM_SCALE 5043
#define F_GCD_INT4_INT4 5044
#define F_GCD_INT8_INT8 5045
#define F_LCM_INT4_INT4 5046
#define F_LCM_INT8_INT8 5047
#define F_GCD_NUMERIC_NUMERIC 5048
#define F_LCM_NUMERIC_NUMERIC 5049
#define F_BTVARSTREQUALIMAGE 5050
#define F_BTEQUALIMAGE 5051
#define F_PG_GET_SHMEM_ALLOCATIONS 5052
#define F_PG_STAT_GET_INS_SINCE_VACUUM 5053
#define F_JSONB_SET_LAX 5054
#define F_PG_SNAPSHOT_IN 5055
#define F_PG_SNAPSHOT_OUT 5056
#define F_PG_SNAPSHOT_RECV 5057
#define F_PG_SNAPSHOT_SEND 5058
#define F_PG_CURRENT_XACT_ID 5059
#define F_PG_CURRENT_XACT_ID_IF_ASSIGNED 5060
#define F_PG_CURRENT_SNAPSHOT 5061
#define F_PG_SNAPSHOT_XMIN 5062
#define F_PG_SNAPSHOT_XMAX 5063
#define F_PG_SNAPSHOT_XIP 5064
#define F_PG_VISIBLE_IN_SNAPSHOT 5065
#define F_PG_XACT_STATUS 5066
#define F_XID8IN 5070
#define F_XID 5071
#define F_XID8OUT 5081
#define F_XID8RECV 5082
#define F_XID8SEND 5083
#define F_XID8EQ 5084
#define F_XID8NE 5085
#define F_ANYCOMPATIBLE_IN 5086
#define F_ANYCOMPATIBLE_OUT 5087
#define F_ANYCOMPATIBLEARRAY_IN 5088
#define F_ANYCOMPATIBLEARRAY_OUT 5089
#define F_ANYCOMPATIBLEARRAY_RECV 5090
#define F_ANYCOMPATIBLEARRAY_SEND 5091
#define F_ANYCOMPATIBLENONARRAY_IN 5092
#define F_ANYCOMPATIBLENONARRAY_OUT 5093
#define F_ANYCOMPATIBLERANGE_IN 5094
#define F_ANYCOMPATIBLERANGE_OUT 5095
#define F_XID8CMP 5096
#define F_XID8_LARGER 5097
#define F_XID8_SMALLER 5098
#define F_MAX_XID8 5099
#define F_MIN_XID8 5100
#define F_PG_REPLICATION_ORIGIN_CREATE 6003
#define F_PG_REPLICATION_ORIGIN_DROP 6004
#define F_PG_REPLICATION_ORIGIN_OID 6005
#define F_PG_REPLICATION_ORIGIN_SESSION_SETUP 6006
#define F_PG_REPLICATION_ORIGIN_SESSION_RESET 6007
#define F_PG_REPLICATION_ORIGIN_SESSION_IS_SETUP 6008
#define F_PG_REPLICATION_ORIGIN_SESSION_PROGRESS 6009
#define F_PG_REPLICATION_ORIGIN_XACT_SETUP 6010
#define F_PG_REPLICATION_ORIGIN_XACT_RESET 6011
#define F_PG_REPLICATION_ORIGIN_ADVANCE 6012
#define F_PG_REPLICATION_ORIGIN_PROGRESS 6013
#define F_PG_SHOW_REPLICATION_ORIGIN_STATUS 6014
#define F_JSONB_SUBSCRIPT_HANDLER 6098
#define F_ICU_UNICODE_VERSION 6099
#define F_PG_LSN 6103
#define F_UNICODE_ASSIGNED 6105
#define F_PG_STAT_GET_BACKEND_SUBXACT 6107
#define F_PG_STAT_GET_SUBSCRIPTION 6118
#define F_PG_GET_PUBLICATION_TABLES 6119
#define F_PG_GET_REPLICA_IDENTITY_INDEX 6120
#define F_PG_RELATION_IS_PUBLISHABLE 6121
#define F_MULTIRANGE_GIST_CONSISTENT 6154
#define F_MULTIRANGE_GIST_COMPRESS 6156
#define F_PG_GET_CATALOG_FOREIGN_KEYS 6159
#define F_STRING_TO_TABLE_TEXT_TEXT 6160
#define F_STRING_TO_TABLE_TEXT_TEXT_TEXT 6161
#define F_BIT_COUNT_BIT 6162
#define F_BIT_COUNT_BYTEA 6163
#define F_BIT_XOR_INT2 6164
#define F_BIT_XOR_INT4 6165
#define F_BIT_XOR_INT8 6166
#define F_BIT_XOR_BIT 6167
#define F_PG_XACT_COMMIT_TIMESTAMP_ORIGIN 6168
#define F_PG_STAT_GET_REPLICATION_SLOT 6169
#define F_PG_STAT_RESET_REPLICATION_SLOT 6170
#define F_TRIM_ARRAY 6172
#define F_PG_GET_STATISTICSOBJDEF_EXPRESSIONS 6173
#define F_PG_GET_STATISTICSOBJDEF_COLUMNS 6174
#define F_DATE_BIN_INTERVAL_TIMESTAMP_TIMESTAMP 6177
#define F_DATE_BIN_INTERVAL_TIMESTAMPTZ_TIMESTAMPTZ 6178
#define F_ARRAY_SUBSCRIPT_HANDLER 6179
#define F_RAW_ARRAY_SUBSCRIPT_HANDLER 6180
#define F_TS_DEBUG_REGCONFIG_TEXT 6183
#define F_TS_DEBUG_TEXT 6184
#define F_PG_STAT_GET_DB_SESSION_TIME 6185
#define F_PG_STAT_GET_DB_ACTIVE_TIME 6186
#define F_PG_STAT_GET_DB_IDLE_IN_TRANSACTION_TIME 6187
#define F_PG_STAT_GET_DB_SESSIONS 6188
#define F_PG_STAT_GET_DB_SESSIONS_ABANDONED 6189
#define F_PG_STAT_GET_DB_SESSIONS_FATAL 6190
#define F_PG_STAT_GET_DB_SESSIONS_KILLED 6191
#define F_HASH_RECORD 6192
#define F_HASH_RECORD_EXTENDED 6193
#define F_LTRIM_BYTEA_BYTEA 6195
#define F_RTRIM_BYTEA_BYTEA 6196
#define F_PG_GET_FUNCTION_SQLBODY 6197
#define F_UNISTR 6198
#define F_EXTRACT_TEXT_DATE 6199
#define F_EXTRACT_TEXT_TIME 6200
#define F_EXTRACT_TEXT_TIMETZ 6201
#define F_EXTRACT_TEXT_TIMESTAMP 6202
#define F_EXTRACT_TEXT_TIMESTAMPTZ 6203
#define F_EXTRACT_TEXT_INTERVAL 6204
#define F_HAS_PARAMETER_PRIVILEGE_NAME_TEXT_TEXT 6205
#define F_HAS_PARAMETER_PRIVILEGE_OID_TEXT_TEXT 6206
#define F_HAS_PARAMETER_PRIVILEGE_TEXT_TEXT 6207
#define F_PG_READ_FILE_TEXT_BOOL 6208
#define F_PG_READ_BINARY_FILE_TEXT_BOOL 6209
#define F_PG_INPUT_IS_VALID 6210
#define F_PG_INPUT_ERROR_INFO 6211
#define F_RANDOM_NORMAL 6212
#define F_PG_SPLIT_WALFILE_NAME 6213
#define F_PG_STAT_GET_IO 6214
#define F_ARRAY_SHUFFLE 6215
#define F_ARRAY_SAMPLE 6216
#define F_PG_STAT_GET_TUPLES_NEWPAGE_UPDATED 6217
#define F_PG_STAT_GET_XACT_TUPLES_NEWPAGE_UPDATED 6218
#define F_ERF 6219
#define F_ERFC 6220
#define F_DATE_ADD_TIMESTAMPTZ_INTERVAL 6221
#define F_DATE_ADD_TIMESTAMPTZ_INTERVAL_TEXT 6222
#define F_DATE_SUBTRACT_TIMESTAMPTZ_INTERVAL 6223
#define F_PG_GET_WAL_RESOURCE_MANAGERS 6224
#define F_MULTIRANGE_AGG_TRANSFN 6225
#define F_MULTIRANGE_AGG_FINALFN 6226
#define F_RANGE_AGG_ANYMULTIRANGE 6227
#define F_PG_STAT_HAVE_STATS 6230
#define F_PG_STAT_GET_SUBSCRIPTION_STATS 6231
#define F_PG_STAT_RESET_SUBSCRIPTION_STATS 6232
#define F_WINDOW_ROW_NUMBER_SUPPORT 6233
#define F_WINDOW_RANK_SUPPORT 6234
#define F_WINDOW_DENSE_RANK_SUPPORT 6235
#define F_INT8INC_SUPPORT 6236
#define F_PG_SETTINGS_GET_FLAGS 6240
#define F_PG_STOP_MAKING_PINNED_OBJECTS 6241
#define F_TEXT_STARTS_WITH_SUPPORT 6242
#define F_PG_STAT_GET_RECOVERY_PREFETCH 6248
#define F_PG_DATABASE_COLLATION_ACTUAL_VERSION 6249
#define F_PG_IDENT_FILE_MAPPINGS 6250
#define F_REGEXP_REPLACE_TEXT_TEXT_TEXT_INT4_INT4_TEXT 6251
#define F_REGEXP_REPLACE_TEXT_TEXT_TEXT_INT4_INT4 6252
#define F_REGEXP_REPLACE_TEXT_TEXT_TEXT_INT4 6253
#define F_REGEXP_COUNT_TEXT_TEXT 6254
#define F_REGEXP_COUNT_TEXT_TEXT_INT4 6255
#define F_REGEXP_COUNT_TEXT_TEXT_INT4_TEXT 6256
#define F_REGEXP_INSTR_TEXT_TEXT 6257
#define F_REGEXP_INSTR_TEXT_TEXT_INT4 6258
#define F_REGEXP_INSTR_TEXT_TEXT_INT4_INT4 6259
#define F_REGEXP_INSTR_TEXT_TEXT_INT4_INT4_INT4 6260
#define F_REGEXP_INSTR_TEXT_TEXT_INT4_INT4_INT4_TEXT 6261
#define F_REGEXP_INSTR_TEXT_TEXT_INT4_INT4_INT4_TEXT_INT4 6262
#define F_REGEXP_LIKE_TEXT_TEXT 6263
#define F_REGEXP_LIKE_TEXT_TEXT_TEXT 6264
#define F_REGEXP_SUBSTR_TEXT_TEXT 6265
#define F_REGEXP_SUBSTR_TEXT_TEXT_INT4 6266
#define F_REGEXP_SUBSTR_TEXT_TEXT_INT4_INT4 6267
#define F_REGEXP_SUBSTR_TEXT_TEXT_INT4_INT4_TEXT 6268
#define F_REGEXP_SUBSTR_TEXT_TEXT_INT4_INT4_TEXT_INT4 6269
#define F_PG_LS_LOGICALSNAPDIR 6270
#define F_PG_LS_LOGICALMAPDIR 6271
#define F_PG_LS_REPLSLOTDIR 6272
#define F_DATE_SUBTRACT_TIMESTAMPTZ_INTERVAL_TEXT 6273
#define F_GENERATE_SERIES_TIMESTAMPTZ_TIMESTAMPTZ_INTERVAL_TEXT 6274
#define F_JSON_AGG_STRICT_TRANSFN 6275
#define F_JSON_AGG_STRICT 6276
#define F_JSON_OBJECT_AGG_STRICT_TRANSFN 6277
#define F_JSON_OBJECT_AGG_UNIQUE_TRANSFN 6278
#define F_JSON_OBJECT_AGG_UNIQUE_STRICT_TRANSFN 6279
#define F_JSON_OBJECT_AGG_STRICT 6280
#define F_JSON_OBJECT_AGG_UNIQUE 6281
#define F_JSON_OBJECT_AGG_UNIQUE_STRICT 6282
#define F_JSONB_AGG_STRICT_TRANSFN 6283
#define F_JSONB_AGG_STRICT 6284
#define F_JSONB_OBJECT_AGG_STRICT_TRANSFN 6285
#define F_JSONB_OBJECT_AGG_UNIQUE_TRANSFN 6286
#define F_JSONB_OBJECT_AGG_UNIQUE_STRICT_TRANSFN 6287
#define F_JSONB_OBJECT_AGG_STRICT 6288
#define F_JSONB_OBJECT_AGG_UNIQUE 6289
#define F_JSONB_OBJECT_AGG_UNIQUE_STRICT 6290
#define F_ANY_VALUE 6291
#define F_ANY_VALUE_TRANSFN 6292
#define F_ARRAY_AGG_COMBINE 6293
#define F_ARRAY_AGG_SERIALIZE 6294
#define F_ARRAY_AGG_DESERIALIZE 6295
#define F_ARRAY_AGG_ARRAY_COMBINE 6296
#define F_ARRAY_AGG_ARRAY_SERIALIZE 6297
#define F_ARRAY_AGG_ARRAY_DESERIALIZE 6298
#define F_STRING_AGG_COMBINE 6299
#define F_STRING_AGG_SERIALIZE 6300
#define F_STRING_AGG_DESERIALIZE 6301
#define F_PG_LOG_STANDBY_SNAPSHOT 6305
#define F_WINDOW_PERCENT_RANK_SUPPORT 6306
#define F_WINDOW_CUME_DIST_SUPPORT 6307
#define F_WINDOW_NTILE_SUPPORT 6308
#define F_PG_STAT_GET_DB_CONFLICT_LOGICALSLOT 6309
#define F_PG_STAT_GET_LASTSCAN 6310
#define F_SYSTEM_USER 6311
#define F_BINARY_UPGRADE_LOGICAL_SLOT_HAS_CAUGHT_UP 6312
#define F_PG_STAT_GET_BACKEND_WAL 6313
#define F_PG_STAT_GET_CHECKPOINTER_STAT_RESET_TIME 6314
#define F_PG_BASETYPE 6315
#define F_PG_COLUMN_TOAST_CHUNK_ID 6316
#define F_TO_REGTYPEMOD 6317
#define F_PG_GET_WAIT_EVENTS 6318
#define F_BINARY_UPGRADE_ADD_SUB_REL_STATE 6319
#define F_BINARY_UPGRADE_REPLORIGIN_ADVANCE 6320
#define F_PG_AVAILABLE_WAL_SUMMARIES 6321
#define F_PG_WAL_SUMMARY_CONTENTS 6322
#define F_PG_GET_WAL_SUMMARIZER_STATE 6323
#define F_INTERVAL_AVG_SERIALIZE 6324
#define F_INTERVAL_AVG_DESERIALIZE 6325
#define F_INTERVAL_SUM 6326
#define F_PG_STAT_GET_CHECKPOINTER_RESTARTPOINTS_TIMED 6327
#define F_PG_STAT_GET_CHECKPOINTER_RESTARTPOINTS_REQUESTED 6328
#define F_PG_STAT_GET_CHECKPOINTER_RESTARTPOINTS_PERFORMED 6329
#define F_TO_BIN_INT4 6330
#define F_TO_BIN_INT8 6331
#define F_TO_OCT_INT4 6332
#define F_TO_OCT_INT8 6333
#define F_TIMEZONE_TIMESTAMPTZ 6334
#define F_TIMEZONE_TIMESTAMP 6335
#define F_TIMEZONE_TIMETZ 6336
#define F_JSONB_POPULATE_RECORD_VALID 6338
#define F_RANDOM_INT4_INT4 6339
#define F_RANDOM_INT8_INT8 6340
#define F_RANDOM_NUMERIC_NUMERIC 6341
#define F_UUID_EXTRACT_TIMESTAMP 6342
#define F_UUID_EXTRACT_VERSION 6343
#define F_PG_SYNC_REPLICATION_SLOTS 6344
#define F_RANGE_CONTAINS_ELEM_SUPPORT 6345
#define F_ELEM_CONTAINED_BY_RANGE_SUPPORT 6346
#define F_GIST_TRANSLATE_CMPTYPE_COMMON 6347
#define F_HAS_LARGEOBJECT_PRIVILEGE_NAME_OID_TEXT 6348
#define F_HAS_LARGEOBJECT_PRIVILEGE_OID_TEXT 6349
#define F_HAS_LARGEOBJECT_PRIVILEGE_OID_OID_TEXT 6350
#define F_PG_GET_LOADED_MODULES 6353
#define F_GENERATE_SERIES_TIMESTAMP_SUPPORT 6354
#define F_PG_STAT_GET_DB_PARALLEL_WORKERS_TO_LAUNCH 6355
#define F_PG_STAT_GET_DB_PARALLEL_WORKERS_LAUNCHED 6356
#define F_GENERATE_SERIES_NUMERIC_SUPPORT 6357
#define F_PG_STAT_GET_TOTAL_VACUUM_TIME 6358
#define F_PG_STAT_GET_TOTAL_AUTOVACUUM_TIME 6359
#define F_PG_STAT_GET_TOTAL_ANALYZE_TIME 6360
#define F_PG_STAT_GET_TOTAL_AUTOANALYZE_TIME 6361
#define F_PG_RESTORE_RELATION_STATS 6362
#define F_PG_RESTORE_ATTRIBUTE_STATS 6363
#define F_CRC32 6364
#define F_CRC32C 6365
#define F_PG_STAT_GET_CHECKPOINTER_SLRU_WRITTEN 6366
#define F_BYTEA_INT2 6367
#define F_BYTEA_INT4 6368
#define F_BYTEA_INT8 6369
#define F_INT2_BYTEA 6370
#define F_INT4_BYTEA 6371
#define F_INT8_BYTEA 6372
#define F_MAX_RECORD 6373
#define F_MIN_RECORD 6374
#define F_RECORD_LARGER 6375
#define F_RECORD_SMALLER 6376
#define F_PG_STAT_GET_CHECKPOINTER_NUM_PERFORMED 6377
#define F_ARRAY_APPEND_SUPPORT 6378
#define F_ARRAY_PREPEND_SUPPORT 6379
#define F_ARRAY_SUBSCRIPT_HANDLER_SUPPORT 6380
#define F_ARRAY_REVERSE 6381
#define F_REVERSE_BYTEA 6382
#define F_GAMMA 6383
#define F_LGAMMA 6384
#define F_PG_GET_ACL 6385
#define F_PG_STAT_GET_BACKEND_IO 6386
#define F_PG_STAT_RESET_BACKEND_STATS 6387
#define F_ARRAY_SORT_ANYARRAY 6388
#define F_ARRAY_SORT_ANYARRAY_BOOL 6389
#define F_ARRAY_SORT_ANYARRAY_BOOL_BOOL 6390
#define F_RANGE_SORTSUPPORT 6391
#define F_BYTEA_LARGER 6393
#define F_BYTEA_SMALLER 6394
#define F_MAX_BYTEA 6395
#define F_MIN_BYTEA 6396
#define F_PG_CLEAR_RELATION_STATS 6397
#define F_PG_CLEAR_ATTRIBUTE_STATS 6398
#define F_PG_GET_AIOS 6399
#define F_PG_LS_SUMMARIESDIR 6400
#define F_PG_TIMEZONE_ABBREVS_ZONE 6401
#define F_BTINT2SKIPSUPPORT 6402
#define F_BTINT4SKIPSUPPORT 6403
#define F_BTINT8SKIPSUPPORT 6404
#define F_BTOIDSKIPSUPPORT 6405
#define F_BTCHARSKIPSUPPORT 6406
#define F_DATE_SKIPSUPPORT 6407
#define F_BTBOOLSKIPSUPPORT 6408
#define F_TIMESTAMP_SKIPSUPPORT 6409
#define F_UUID_SKIPSUPPORT 6410
#define F_CASEFOLD 6412
#define F_HASHBYTEA 6413
#define F_HASHBYTEAEXTENDED 6414
#define F_HASHDATE 6415
#define F_HASHDATEEXTENDED 6416
#define F_HASHBOOL 6417
#define F_HASHBOOLEXTENDED 6418
#define F_HASHXID 6419
#define F_HASHXIDEXTENDED 6420
#define F_HASHXID8 6421
#define F_HASHXID8EXTENDED 6422
#define F_HASHCID 6423
#define F_HASHCIDEXTENDED 6424
#define F_TIMESTAMPTZ_HASH 6425
#define F_TIMESTAMPTZ_HASH_EXTENDED 6426
#define F_PG_GET_SEQUENCE_DATA 6427
#define F_UUIDV4 6428
#define F_UUIDV7_ 6429
#define F_UUIDV7_INTERVAL 6430

#endif							/* FMGROIDS_H */
