/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.VolatileImage;
import java.awt.image.WritableRaster;
import sun.awt.X11ComponentPeer;
import sun.awt.X11GraphicsConfig;
import sun.awt.X11GraphicsDevice;
import sun.awt.X11GraphicsEnvironment;
import sun.awt.image.OffScreenImage;
import sun.awt.image.SunVolatileImage;
import sun.awt.image.SurfaceManager;
import sun.java2d.SunGraphics2D;
import sun.java2d.Surface;
import sun.java2d.SurfaceData;
import sun.java2d.opengl.GLXSurfaceData;
import sun.java2d.opengl.OGLContext;
import sun.java2d.opengl.OGLGraphicsConfig;
import sun.java2d.opengl.OGLRenderQueue;
import sun.java2d.opengl.OGLSurfaceData;
import sun.java2d.pipe.hw.AccelDeviceEventListener;
import sun.java2d.pipe.hw.AccelDeviceEventNotifier;
import sun.java2d.pipe.hw.AccelSurface;
import sun.java2d.pipe.hw.AccelTypedVolatileImage;
import sun.java2d.pipe.hw.ContextCapabilities;

public class GLXGraphicsConfig
extends X11GraphicsConfig
implements OGLGraphicsConfig {
    private static ImageCapabilities imageCaps = new GLXImageCaps();
    private BufferCapabilities bufferCaps;
    private long pConfigInfo;
    private ContextCapabilities oglCaps;
    private OGLContext context;

    private static native long getGLXConfigInfo(int var0, int var1);

    private static native int getOGLCapabilities(long var0);

    private native void initConfig(long var1, long var3);

    private GLXGraphicsConfig(X11GraphicsDevice x11GraphicsDevice, int n, long l, ContextCapabilities contextCapabilities) {
        super(x11GraphicsDevice, n, 0, 0, (contextCapabilities.getCaps() & 0x10000) != 0);
        this.pConfigInfo = l;
        this.initConfig(this.getAData(), l);
        this.oglCaps = contextCapabilities;
        this.context = new OGLContext(OGLRenderQueue.getInstance(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GLXGraphicsConfig getConfig(X11GraphicsDevice x11GraphicsDevice, int n) {
        if (!X11GraphicsEnvironment.isGLXAvailable()) {
            return null;
        }
        long l = 0L;
        final String[] stringArray = new String[1];
        OGLRenderQueue oGLRenderQueue = OGLRenderQueue.getInstance();
        oGLRenderQueue.lock();
        try {
            OGLContext.invalidateCurrentContext();
            GLXGetConfigInfo gLXGetConfigInfo = new GLXGetConfigInfo(x11GraphicsDevice.getScreen(), n);
            oGLRenderQueue.flushAndInvokeNow(gLXGetConfigInfo);
            l = gLXGetConfigInfo.getConfigInfo();
            if (l != 0L) {
                OGLContext.setScratchSurface(l);
                oGLRenderQueue.flushAndInvokeNow(new Runnable(){

                    public void run() {
                        stringArray[0] = OGLContext.getOGLIdString();
                    }
                });
            }
        }
        finally {
            oGLRenderQueue.unlock();
        }
        if (l == 0L) {
            return null;
        }
        int n2 = GLXGraphicsConfig.getOGLCapabilities(l);
        OGLContext.OGLContextCaps oGLContextCaps = new OGLContext.OGLContextCaps(n2, stringArray[0]);
        return new GLXGraphicsConfig(x11GraphicsDevice, n, l, oGLContextCaps);
    }

    public final boolean isCapPresent(int n) {
        return (this.oglCaps.getCaps() & n) != 0;
    }

    public final long getNativeConfigInfo() {
        return this.pConfigInfo;
    }

    public final OGLContext getContext() {
        return this.context;
    }

    public BufferedImage createCompatibleImage(int n, int n2) {
        DirectColorModel directColorModel = new DirectColorModel(24, 0xFF0000, 65280, 255);
        WritableRaster writableRaster = ((ColorModel)directColorModel).createCompatibleWritableRaster(n, n2);
        return new BufferedImage(directColorModel, writableRaster, directColorModel.isAlphaPremultiplied(), null);
    }

    public ColorModel getColorModel(int n) {
        switch (n) {
            case 1: {
                return new DirectColorModel(24, 0xFF0000, 65280, 255);
            }
            case 2: {
                return new DirectColorModel(25, 0xFF0000, 65280, 255, 0x1000000);
            }
            case 3: {
                ColorSpace colorSpace = ColorSpace.getInstance(1000);
                return new DirectColorModel(colorSpace, 32, 0xFF0000, 65280, 255, -16777216, true, 3);
            }
        }
        return null;
    }

    public String toString() {
        return "GLXGraphicsConfig[dev=" + this.screen + ",vis=0x" + Integer.toHexString(this.visual) + "]";
    }

    public SurfaceData createSurfaceData(X11ComponentPeer x11ComponentPeer) {
        return GLXSurfaceData.createData(x11ComponentPeer);
    }

    public Image createAcceleratedImage(Component component, int n, int n2) {
        ColorModel colorModel = this.getColorModel(1);
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n, n2);
        return new OffScreenImage(component, colorModel, writableRaster, colorModel.isAlphaPremultiplied());
    }

    public long createBackBuffer(X11ComponentPeer x11ComponentPeer, int n, BufferCapabilities bufferCapabilities) throws AWTException {
        if (n > 2) {
            throw new AWTException("Only double or single buffering is supported");
        }
        BufferCapabilities bufferCapabilities2 = this.getBufferCapabilities();
        if (!bufferCapabilities2.isPageFlipping()) {
            throw new AWTException("Page flipping is not supported");
        }
        if (bufferCapabilities.getFlipContents() == BufferCapabilities.FlipContents.PRIOR) {
            throw new AWTException("FlipContents.PRIOR is not supported");
        }
        return 1L;
    }

    public void destroyBackBuffer(long l) {
    }

    public VolatileImage createBackBufferImage(Component component, long l) {
        return new SunVolatileImage(component, component.getWidth(), component.getHeight(), Boolean.TRUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flip(X11ComponentPeer x11ComponentPeer, Component component, VolatileImage volatileImage, int n, int n2, int n3, int n4, BufferCapabilities.FlipContents flipContents) {
        Object object;
        if (flipContents == BufferCapabilities.FlipContents.COPIED) {
            object = SurfaceManager.getManager(volatileImage);
            SurfaceData surfaceData = ((SurfaceManager)object).getDestSurfaceData();
            if (surfaceData instanceof GLXSurfaceData.GLXVSyncOffScreenSurfaceData) {
                GLXSurfaceData.GLXVSyncOffScreenSurfaceData gLXVSyncOffScreenSurfaceData = (GLXSurfaceData.GLXVSyncOffScreenSurfaceData)surfaceData;
                SurfaceData surfaceData2 = gLXVSyncOffScreenSurfaceData.getFlipSurface();
                SunGraphics2D sunGraphics2D = new SunGraphics2D(surfaceData2, Color.black, Color.white, null);
                try {
                    ((Graphics)sunGraphics2D).drawImage(volatileImage, 0, 0, null);
                }
                finally {
                    ((Graphics)sunGraphics2D).dispose();
                }
            }
            Graphics graphics = x11ComponentPeer.getGraphics();
            try {
                graphics.drawImage(volatileImage, n, n2, n3, n4, n, n2, n3, n4, null);
            }
            finally {
                graphics.dispose();
            }
            return;
        }
        if (flipContents == BufferCapabilities.FlipContents.PRIOR) {
            return;
        }
        OGLSurfaceData.swapBuffers(x11ComponentPeer.getContentWindow());
        if (flipContents == BufferCapabilities.FlipContents.BACKGROUND) {
            object = volatileImage.getGraphics();
            try {
                ((Graphics)object).setColor(component.getBackground());
                ((Graphics)object).fillRect(0, 0, volatileImage.getWidth(), volatileImage.getHeight());
            }
            finally {
                ((Graphics)object).dispose();
            }
        }
    }

    public BufferCapabilities getBufferCapabilities() {
        if (this.bufferCaps == null) {
            this.bufferCaps = new GLXBufferCaps(this.isDoubleBuffered());
        }
        return this.bufferCaps;
    }

    public ImageCapabilities getImageCapabilities() {
        return imageCaps;
    }

    public VolatileImage createCompatibleVolatileImage(int n, int n2, int n3, int n4) {
        AccelTypedVolatileImage accelTypedVolatileImage;
        Surface surface;
        if (n4 == 4 || n4 == 1 || n4 == 0 || n3 == 2) {
            return null;
        }
        if (n4 == 5) {
            if (!this.isCapPresent(12)) {
                return null;
            }
        } else if (n4 == 2) {
            boolean bl;
            boolean bl2 = bl = n3 == 1;
            if (!bl && !this.isCapPresent(2)) {
                return null;
            }
        }
        if (!((surface = (accelTypedVolatileImage = new AccelTypedVolatileImage((GraphicsConfiguration)this, n, n2, n3, n4)).getDestSurface()) instanceof AccelSurface) || ((AccelSurface)surface).getType() != n4) {
            accelTypedVolatileImage.flush();
            accelTypedVolatileImage = null;
        }
        return accelTypedVolatileImage;
    }

    public ContextCapabilities getContextCapabilities() {
        return this.oglCaps;
    }

    public void addDeviceEventListener(AccelDeviceEventListener accelDeviceEventListener) {
        AccelDeviceEventNotifier.addListener(accelDeviceEventListener, this.screen.getScreen());
    }

    public void removeDeviceEventListener(AccelDeviceEventListener accelDeviceEventListener) {
        AccelDeviceEventNotifier.removeListener(accelDeviceEventListener);
    }

    private static class GLXBufferCaps
    extends BufferCapabilities {
        public GLXBufferCaps(boolean bl) {
            super(imageCaps, imageCaps, bl ? BufferCapabilities.FlipContents.UNDEFINED : null);
        }
    }

    private static class GLXGetConfigInfo
    implements Runnable {
        private int screen;
        private int visual;
        private long cfginfo;

        private GLXGetConfigInfo(int n, int n2) {
            this.screen = n;
            this.visual = n2;
        }

        public void run() {
            this.cfginfo = GLXGraphicsConfig.getGLXConfigInfo(this.screen, this.visual);
        }

        public long getConfigInfo() {
            return this.cfginfo;
        }
    }

    private static class GLXImageCaps
    extends ImageCapabilities {
        private GLXImageCaps() {
            super(true);
        }

        public boolean isTrueVolatile() {
            return true;
        }
    }
}

