/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.cache.DeployCacheRequest;
import com.sun.deploy.cache.DeployCacheResponse;
import com.sun.deploy.cache.DeploySecureCacheResponse;
import com.sun.deploy.config.Config;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.HttpUtils;
import com.sun.deploy.net.offline.DeployOfflineManager;
import com.sun.deploy.util.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.CacheRequest;
import java.net.CacheResponse;
import java.net.HttpURLConnection;
import java.net.ResponseCache;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.Map;
import sun.awt.AppContext;

public class DeployCacheHandler
extends ResponseCache {
    private boolean inCacheHandler = false;
    private boolean _downloading = false;
    private static HashSet isNotCacheable = new HashSet();
    private static final ThreadLocal isDeployPackURL = new ThreadLocal();

    public static void setDeployPackURL(URL uRL) {
        isDeployPackURL.set(uRL);
    }

    public static void clearDeployPackURL() {
        isDeployPackURL.set(null);
    }

    public static void reset() {
        ResponseCache.setDefault(new DeployCacheHandler());
        DeployCacheHandler.clearDeployPackURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CacheResponse get(URI uRI, String string, Map map) throws IOException {
        CacheResponse cacheResponse;
        block15: {
            cacheResponse = null;
            if (!Cache.isCacheEnabled() || !string.equals("GET")) {
                return null;
            }
            boolean bl = false;
            if (!this.inCacheHandler) {
                try {
                    String string2;
                    URL uRL;
                    URL uRL2;
                    File file;
                    block14: {
                        this.inCacheHandler = true;
                        file = null;
                        boolean bl2 = false;
                        URL uRL3 = (URL)isDeployPackURL.get();
                        if (uRL3 != null) {
                            bl2 = true;
                        }
                        uRL2 = bl2 ? uRL3 : uRI.toURL();
                        uRL = HttpUtils.removeQueryStringFromURL(uRL2);
                        string2 = (String)AppContext.getAppContext().get(Config.getAppContextKeyPrefix() + uRL);
                        boolean bl3 = DeployOfflineManager.isGlobalOffline() ? false : DownloadEngine.isUpdateAvailable(uRL2, string2, bl2, map);
                        if (!bl3) {
                            try {
                                file = (File)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                    public Object run() throws IOException {
                                        CacheEntry cacheEntry = Cache.getCacheEntry(string2 == null ? uRL2 : uRL, null, string2);
                                        if (cacheEntry != null) {
                                            return new File(cacheEntry.getResourceFilename());
                                        }
                                        return null;
                                    }
                                });
                            }
                            catch (PrivilegedActionException privilegedActionException) {
                                if (!(privilegedActionException.getException() instanceof IOException)) break block14;
                                bl = true;
                            }
                        }
                    }
                    if (file == null) {
                        CacheResponse cacheResponse2 = null;
                        return cacheResponse2;
                    }
                    InputStream inputStream = null;
                    final File file2 = file;
                    if (file2 == null) break block15;
                    try {
                        inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws IOException {
                                return new FileInputStream(file2);
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Trace.ignoredException(privilegedActionException);
                    }
                    if (inputStream != null) {
                        Map map2 = DownloadEngine.getCachedHeaders(string2 == null ? uRL2 : uRL, null, string2, null, false);
                        cacheResponse = uRI.getScheme().equals("https") ? new DeploySecureCacheResponse(inputStream, map2) : new DeployCacheResponse(inputStream, map2);
                    }
                }
                finally {
                    this.inCacheHandler = false;
                }
            }
        }
        return cacheResponse;
    }

    private static boolean isResourceCacheable(String string, URLConnection uRLConnection) {
        if (!Cache.isCacheEnabled() || !uRLConnection.getUseCaches() && !DownloadEngine.isAlwaysCached(string)) {
            return false;
        }
        if (uRLConnection instanceof HttpURLConnection && !((HttpURLConnection)uRLConnection).getRequestMethod().equals("GET")) {
            return false;
        }
        if (uRLConnection.getHeaderField("content-range") != null) {
            return false;
        }
        String string2 = uRLConnection.getHeaderField("cache-control");
        if (string2 != null && string2.toLowerCase().indexOf("no-store") != -1) {
            return false;
        }
        if (uRLConnection.getLastModified() == 0L && uRLConnection.getExpiration() == 0L) {
            isNotCacheable.add(string);
            return false;
        }
        return true;
    }

    public static boolean resourceNotCached(String string) {
        return isNotCacheable.contains(string);
    }

    public synchronized CacheRequest put(URI uRI, URLConnection uRLConnection) throws IOException {
        if (!DeployCacheHandler.isResourceCacheable(uRI.toString(), uRLConnection)) {
            return null;
        }
        URL uRL = (URL)isDeployPackURL.get();
        boolean bl = false;
        if (uRL != null) {
            bl = true;
        }
        URL uRL2 = bl ? uRL : uRI.toURL();
        return new DeployCacheRequest(uRL2, uRLConnection, bl);
    }
}

