/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.protocol.giopmsgheaders;

import com.sun.corba.se.impl.encoding.CDRInputStream;
import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.impl.protocol.giopmsgheaders.AddressingDispositionHelper;
import com.sun.corba.se.impl.protocol.giopmsgheaders.LocateReplyMessage;
import com.sun.corba.se.impl.protocol.giopmsgheaders.MessageBase;
import com.sun.corba.se.impl.protocol.giopmsgheaders.MessageHandler;
import com.sun.corba.se.impl.protocol.giopmsgheaders.Message_1_2;
import com.sun.corba.se.spi.ior.IOR;
import com.sun.corba.se.spi.ior.IORFactories;
import com.sun.corba.se.spi.ior.iiop.GIOPVersion;
import com.sun.corba.se.spi.orb.ORB;
import java.io.IOException;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public final class LocateReplyMessage_1_2
extends Message_1_2
implements LocateReplyMessage {
    private ORB orb = null;
    private ORBUtilSystemException wrapper = null;
    private int reply_status = 0;
    private IOR ior = null;
    private String exClassName = null;
    private int minorCode = 0;
    private CompletionStatus completionStatus = null;
    private short addrDisposition = 0;

    LocateReplyMessage_1_2(ORB oRB) {
        this.orb = oRB;
        this.wrapper = ORBUtilSystemException.get(oRB, "rpc.protocol");
    }

    LocateReplyMessage_1_2(ORB oRB, int n, int n2, IOR iOR) {
        super(1195986768, GIOPVersion.V1_2, (byte)0, (byte)4, 0);
        this.orb = oRB;
        this.wrapper = ORBUtilSystemException.get(oRB, "rpc.protocol");
        this.request_id = n;
        this.reply_status = n2;
        this.ior = iOR;
    }

    public int getRequestId() {
        return this.request_id;
    }

    public int getReplyStatus() {
        return this.reply_status;
    }

    public short getAddrDisposition() {
        return this.addrDisposition;
    }

    public SystemException getSystemException(String string) {
        return MessageBase.getSystemException(this.exClassName, this.minorCode, this.completionStatus, string, this.wrapper);
    }

    public IOR getIOR() {
        return this.ior;
    }

    public void read(InputStream inputStream) {
        super.read(inputStream);
        this.request_id = inputStream.read_ulong();
        this.reply_status = inputStream.read_long();
        LocateReplyMessage_1_2.isValidReplyStatus(this.reply_status);
        if (this.reply_status == 4) {
            String string = inputStream.read_string();
            this.exClassName = ORBUtility.classNameOf(string);
            this.minorCode = inputStream.read_long();
            int n = inputStream.read_long();
            switch (n) {
                case 0: {
                    this.completionStatus = CompletionStatus.COMPLETED_YES;
                    break;
                }
                case 1: {
                    this.completionStatus = CompletionStatus.COMPLETED_NO;
                    break;
                }
                case 2: {
                    this.completionStatus = CompletionStatus.COMPLETED_MAYBE;
                    break;
                }
                default: {
                    throw this.wrapper.badCompletionStatusInLocateReply(CompletionStatus.COMPLETED_MAYBE, (Object)new Integer(n));
                }
            }
        } else if (this.reply_status == 2 || this.reply_status == 3) {
            CDRInputStream cDRInputStream = (CDRInputStream)inputStream;
            this.ior = IORFactories.makeIOR(cDRInputStream);
        } else if (this.reply_status == 5) {
            this.addrDisposition = AddressingDispositionHelper.read(inputStream);
        }
    }

    public void write(OutputStream outputStream) {
        super.write(outputStream);
        outputStream.write_ulong(this.request_id);
        outputStream.write_long(this.reply_status);
    }

    public static void isValidReplyStatus(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                ORBUtilSystemException oRBUtilSystemException = ORBUtilSystemException.get("rpc.protocol");
                throw oRBUtilSystemException.illegalReplyStatus(CompletionStatus.COMPLETED_MAYBE);
            }
        }
    }

    public void callback(MessageHandler messageHandler) throws IOException {
        messageHandler.handleInput(this);
    }
}

