/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.messaging.saaj.packaging.mime.internet;

import com.sun.xml.internal.messaging.saaj.packaging.mime.MessagingException;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.ContentDisposition;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.ContentType;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.HeaderTokenizer;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.InternetHeaders;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.MimeMultipart;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.MimePartDataSource;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.MimeUtility;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.ParseException;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.SharedInputStream;
import com.sun.xml.internal.messaging.saaj.packaging.mime.util.OutputUtil;
import com.sun.xml.internal.messaging.saaj.util.ByteOutputStream;
import com.sun.xml.internal.messaging.saaj.util.FinalArrayList;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.activation.DataHandler;

public final class MimeBodyPart {
    public static final String ATTACHMENT = "attachment";
    public static final String INLINE = "inline";
    private static boolean setDefaultTextCharset = true;
    private DataHandler dh;
    private byte[] content;
    private int contentLength;
    private int start = 0;
    private InputStream contentStream;
    private final InternetHeaders headers;
    private MimeMultipart parent;

    public MimeBodyPart() {
        this.headers = new InternetHeaders();
    }

    public MimeBodyPart(InputStream inputStream) throws MessagingException {
        if (!(inputStream instanceof ByteArrayInputStream || inputStream instanceof BufferedInputStream || inputStream instanceof SharedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        this.headers = new InternetHeaders(inputStream);
        if (inputStream instanceof SharedInputStream) {
            SharedInputStream sharedInputStream = (SharedInputStream)((Object)inputStream);
            this.contentStream = sharedInputStream.newStream(sharedInputStream.getPosition(), -1L);
        } else {
            try {
                ByteOutputStream byteOutputStream = new ByteOutputStream();
                byteOutputStream.write(inputStream);
                this.content = byteOutputStream.getBytes();
                this.contentLength = byteOutputStream.getCount();
            }
            catch (IOException iOException) {
                throw new MessagingException("Error reading input stream", iOException);
            }
        }
    }

    public MimeBodyPart(InternetHeaders internetHeaders, byte[] byArray, int n) {
        this.headers = internetHeaders;
        this.content = byArray;
        this.contentLength = n;
    }

    public MimeBodyPart(InternetHeaders internetHeaders, byte[] byArray, int n, int n2) {
        this.headers = internetHeaders;
        this.content = byArray;
        this.start = n;
        this.contentLength = n2;
    }

    public MimeMultipart getParent() {
        return this.parent;
    }

    public void setParent(MimeMultipart mimeMultipart) {
        this.parent = mimeMultipart;
    }

    public int getSize() {
        if (this.content != null) {
            return this.contentLength;
        }
        if (this.contentStream != null) {
            try {
                int n = this.contentStream.available();
                if (n > 0) {
                    return n;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return -1;
    }

    public int getLineCount() {
        return -1;
    }

    public String getContentType() {
        String string = this.getHeader("Content-Type", null);
        if (string == null) {
            string = "text/plain";
        }
        return string;
    }

    public boolean isMimeType(String string) {
        boolean bl;
        try {
            ContentType contentType = new ContentType(this.getContentType());
            bl = contentType.match(string);
        }
        catch (ParseException parseException) {
            bl = this.getContentType().equalsIgnoreCase(string);
        }
        return bl;
    }

    public String getDisposition() throws MessagingException {
        String string = this.getHeader("Content-Disposition", null);
        if (string == null) {
            return null;
        }
        ContentDisposition contentDisposition = new ContentDisposition(string);
        return contentDisposition.getDisposition();
    }

    public void setDisposition(String string) throws MessagingException {
        if (string == null) {
            this.removeHeader("Content-Disposition");
        } else {
            String string2 = this.getHeader("Content-Disposition", null);
            if (string2 != null) {
                ContentDisposition contentDisposition = new ContentDisposition(string2);
                contentDisposition.setDisposition(string);
                string = contentDisposition.toString();
            }
            this.setHeader("Content-Disposition", string);
        }
    }

    public String getEncoding() throws MessagingException {
        HeaderTokenizer.Token token;
        int n;
        String string = this.getHeader("Content-Transfer-Encoding", null);
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).equalsIgnoreCase("7bit") || string.equalsIgnoreCase("8bit") || string.equalsIgnoreCase("quoted-printable") || string.equalsIgnoreCase("base64")) {
            return string;
        }
        HeaderTokenizer headerTokenizer = new HeaderTokenizer(string, "()<>@,;:\\\"\t []/?=");
        while ((n = (token = headerTokenizer.next()).getType()) != -4) {
            if (n != -1) continue;
            return token.getValue();
        }
        return string;
    }

    public String getContentID() {
        return this.getHeader("Content-ID", null);
    }

    public void setContentID(String string) {
        if (string == null) {
            this.removeHeader("Content-ID");
        } else {
            this.setHeader("Content-ID", string);
        }
    }

    public String getContentMD5() {
        return this.getHeader("Content-MD5", null);
    }

    public void setContentMD5(String string) {
        this.setHeader("Content-MD5", string);
    }

    public String[] getContentLanguage() throws MessagingException {
        HeaderTokenizer.Token token;
        int n;
        String string = this.getHeader("Content-Language", null);
        if (string == null) {
            return null;
        }
        HeaderTokenizer headerTokenizer = new HeaderTokenizer(string, "()<>@,;:\\\"\t []/?=");
        FinalArrayList finalArrayList = new FinalArrayList();
        while ((n = (token = headerTokenizer.next()).getType()) != -4) {
            if (n != -1) continue;
            finalArrayList.add(token.getValue());
        }
        if (finalArrayList.size() == 0) {
            return null;
        }
        return finalArrayList.toArray(new String[finalArrayList.size()]);
    }

    public void setContentLanguage(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuffer.append(',').append(stringArray[i]);
        }
        this.setHeader("Content-Language", stringBuffer.toString());
    }

    public String getDescription() {
        String string = this.getHeader("Content-Description", null);
        if (string == null) {
            return null;
        }
        try {
            return MimeUtility.decodeText(MimeUtility.unfold(string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    public void setDescription(String string) throws MessagingException {
        this.setDescription(string, null);
    }

    public void setDescription(String string, String string2) throws MessagingException {
        if (string == null) {
            this.removeHeader("Content-Description");
            return;
        }
        try {
            this.setHeader("Content-Description", MimeUtility.fold(21, MimeUtility.encodeText(string, string2, null)));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new MessagingException("Encoding error", unsupportedEncodingException);
        }
    }

    public String getFileName() throws MessagingException {
        Object object;
        String string = null;
        String string2 = this.getHeader("Content-Disposition", null);
        if (string2 != null) {
            object = new ContentDisposition(string2);
            string = ((ContentDisposition)object).getParameter("filename");
        }
        if (string == null && (string2 = this.getHeader("Content-Type", null)) != null) {
            try {
                object = new ContentType(string2);
                string = ((ContentType)object).getParameter("name");
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return string;
    }

    public void setFileName(String string) throws MessagingException {
        String string2 = this.getHeader("Content-Disposition", null);
        ContentDisposition contentDisposition = new ContentDisposition(string2 == null ? ATTACHMENT : string2);
        contentDisposition.setParameter("filename", string);
        this.setHeader("Content-Disposition", contentDisposition.toString());
        string2 = this.getHeader("Content-Type", null);
        if (string2 != null) {
            try {
                ContentType contentType = new ContentType(string2);
                contentType.setParameter("name", string);
                this.setHeader("Content-Type", contentType.toString());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    public InputStream getInputStream() throws IOException {
        return this.getDataHandler().getInputStream();
    }

    InputStream getContentStream() throws MessagingException {
        if (this.contentStream != null) {
            return ((SharedInputStream)((Object)this.contentStream)).newStream(0L, -1L);
        }
        if (this.content != null) {
            return new ByteArrayInputStream(this.content, this.start, this.contentLength);
        }
        throw new MessagingException("No content");
    }

    public InputStream getRawInputStream() throws MessagingException {
        return this.getContentStream();
    }

    public DataHandler getDataHandler() {
        if (this.dh == null) {
            this.dh = new DataHandler(new MimePartDataSource(this));
        }
        return this.dh;
    }

    public Object getContent() throws IOException {
        return this.getDataHandler().getContent();
    }

    public void setDataHandler(DataHandler dataHandler) {
        this.dh = dataHandler;
        this.content = null;
        this.contentStream = null;
        this.removeHeader("Content-Type");
        this.removeHeader("Content-Transfer-Encoding");
    }

    public void setContent(Object object, String string) {
        if (object instanceof MimeMultipart) {
            this.setContent((MimeMultipart)object);
        } else {
            this.setDataHandler(new DataHandler(object, string));
        }
    }

    public void setText(String string) {
        this.setText(string, null);
    }

    public void setText(String string, String string2) {
        if (string2 == null) {
            string2 = MimeUtility.checkAscii(string) != 1 ? MimeUtility.getDefaultMIMECharset() : "us-ascii";
        }
        this.setContent(string, "text/plain; charset=" + MimeUtility.quote(string2, "()<>@,;:\\\"\t []/?="));
    }

    public void setContent(MimeMultipart mimeMultipart) {
        this.setDataHandler(new DataHandler(mimeMultipart, mimeMultipart.getContentType().toString()));
        mimeMultipart.setParent(this);
    }

    public void writeTo(OutputStream outputStream) throws IOException, MessagingException {
        List list = this.headers.getAllHeaderLines();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            OutputUtil.writeln((String)list.get(i), outputStream);
        }
        OutputUtil.writeln(outputStream);
        if (this.contentStream != null) {
            ((SharedInputStream)((Object)this.contentStream)).writeTo(0L, -1L, outputStream);
        } else if (this.content != null) {
            outputStream.write(this.content, this.start, this.contentLength);
        } else if (this.dh != null) {
            OutputStream outputStream2 = MimeUtility.encode(outputStream, this.getEncoding());
            this.getDataHandler().writeTo(outputStream2);
            if (outputStream != outputStream2) {
                outputStream2.flush();
            }
        } else {
            throw new MessagingException("no content");
        }
    }

    public String[] getHeader(String string) {
        return this.headers.getHeader(string);
    }

    public String getHeader(String string, String string2) {
        return this.headers.getHeader(string, string2);
    }

    public void setHeader(String string, String string2) {
        this.headers.setHeader(string, string2);
    }

    public void addHeader(String string, String string2) {
        this.headers.addHeader(string, string2);
    }

    public void removeHeader(String string) {
        this.headers.removeHeader(string);
    }

    public FinalArrayList getAllHeaders() {
        return this.headers.getAllHeaders();
    }

    public void addHeaderLine(String string) {
        this.headers.addHeaderLine(string);
    }

    protected void updateHeaders() throws MessagingException {
        DataHandler dataHandler = this.getDataHandler();
        if (dataHandler == null) {
            return;
        }
        try {
            Object object;
            Object object2;
            String string = dataHandler.getContentType();
            boolean bl = false;
            boolean bl2 = this.getHeader("Content-Type") == null;
            ContentType contentType = new ContentType(string);
            if (contentType.match("multipart/*")) {
                bl = true;
                object2 = dataHandler.getContent();
                ((MimeMultipart)object2).updateHeaders();
            } else if (contentType.match("message/rfc822")) {
                bl = true;
            }
            if (!bl) {
                if (this.getHeader("Content-Transfer-Encoding") == null) {
                    this.setEncoding(MimeUtility.getEncoding(dataHandler));
                }
                if (bl2 && setDefaultTextCharset && contentType.match("text/*") && contentType.getParameter("charset") == null) {
                    object = this.getEncoding();
                    object2 = object != null && ((String)object).equalsIgnoreCase("7bit") ? "us-ascii" : MimeUtility.getDefaultMIMECharset();
                    contentType.setParameter("charset", (String)object2);
                    string = contentType.toString();
                }
            }
            if (bl2) {
                String string2;
                object2 = this.getHeader("Content-Disposition", null);
                if (object2 != null && (string2 = ((ContentDisposition)(object = new ContentDisposition((String)object2))).getParameter("filename")) != null) {
                    contentType.setParameter("name", string2);
                    string = contentType.toString();
                }
                this.setHeader("Content-Type", string);
            }
        }
        catch (IOException iOException) {
            throw new MessagingException("IOException updating headers", iOException);
        }
    }

    private void setEncoding(String string) {
        this.setHeader("Content-Transfer-Encoding", string);
    }

    static {
        try {
            String string = System.getProperty("mail.mime.setdefaulttextcharset");
            setDefaultTextCharset = string == null || !string.equalsIgnoreCase("false");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

