/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.setup.Panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.openoffice.setup.InstallData;
import org.openoffice.setup.PanelHelper.PanelLabel;
import org.openoffice.setup.PanelHelper.PanelTitle;
import org.openoffice.setup.ResourceManager;

public class ChooseDirectory
extends JPanel
implements ActionListener {
    private JFileChooser directoryChooser;
    private JFileChooser directoryChooserRootdir;
    private JButton directoryButton;
    private JButton directoryButtonRootdir;
    private JTextField directoryField;
    private JTextField directoryFieldRootdir;
    private PanelLabel databaseProgress;
    private PanelTitle titleBox;

    public ChooseDirectory() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
        String titleText = ResourceManager.getString("String_ChooseDirectory1");
        String subtitleText = ResourceManager.getString("String_ChooseDirectory2");
        this.titleBox = new PanelTitle(titleText, subtitleText);
        this.titleBox.addVerticalStrut(10);
        this.add((Component)this.titleBox, "North");
        Box contentBox = new Box(1);
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new GridBagLayout());
        this.directoryChooser = new JFileChooser();
        this.directoryChooser.setFileSelectionMode(1);
        String browseText = ResourceManager.getString("String_ChooseDirectory3");
        this.directoryButton = new JButton(browseText);
        this.directoryButton.addActionListener(this);
        this.directoryField = new JTextField();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        contentPanel.add((Component)this.directoryField, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        contentPanel.add((Component)this.directoryButton, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        constraints.fill = 3;
        contentPanel.add((Component)new JPanel(), constraints);
        contentBox.add(contentPanel);
        InstallData data = InstallData.getInstance();
        if (data.isSolarisUserInstallation()) {
            Box contentBoxSolarisUser = new Box(1);
            JPanel titlePanel = new JPanel();
            String subtitleTextRootdir = ResourceManager.getString("String_ChooseDirectory6");
            PanelLabel subTitleLabel = new PanelLabel(subtitleTextRootdir);
            titlePanel.setLayout(new FlowLayout(0, 0, 0));
            titlePanel.add(subTitleLabel);
            contentBoxSolarisUser.add(titlePanel);
            contentBoxSolarisUser.add(Box.createVerticalStrut(10));
            JPanel contentPanelRootdir = new JPanel();
            contentPanelRootdir.setLayout(new GridBagLayout());
            this.directoryChooserRootdir = new JFileChooser();
            this.directoryChooserRootdir.setFileSelectionMode(1);
            String browseTextRootdir = ResourceManager.getString("String_ChooseDirectory3");
            this.directoryButtonRootdir = new JButton(browseTextRootdir);
            this.directoryButtonRootdir.addActionListener(this);
            this.directoryFieldRootdir = new JTextField();
            GridBagConstraints constraintsRootdir = new GridBagConstraints();
            constraintsRootdir.gridx = 0;
            constraintsRootdir.gridy = 0;
            constraintsRootdir.weightx = 1.0;
            constraintsRootdir.weighty = 0.0;
            constraintsRootdir.fill = 2;
            contentPanelRootdir.add((Component)this.directoryFieldRootdir, constraintsRootdir);
            constraintsRootdir.gridx = 1;
            constraintsRootdir.gridy = 0;
            constraintsRootdir.weightx = 0.0;
            constraintsRootdir.weighty = 0.0;
            constraintsRootdir.fill = 2;
            contentPanelRootdir.add((Component)this.directoryButtonRootdir, constraintsRootdir);
            constraintsRootdir.gridx = 0;
            constraintsRootdir.gridy = 1;
            constraintsRootdir.weightx = 0.0;
            constraintsRootdir.weighty = 1.0;
            constraintsRootdir.fill = 3;
            contentPanelRootdir.add((Component)new JPanel(), constraintsRootdir);
            contentBoxSolarisUser.add(contentPanelRootdir);
            contentBox.add(contentBoxSolarisUser);
        }
        this.databaseProgress = new PanelLabel("");
        contentBox.add(this.databaseProgress);
        this.add((Component)contentBox, "Center");
    }

    public void setDatabaseText(String s) {
        this.databaseProgress.setText(s);
    }

    public void setTitleText(String s) {
        this.titleBox.setTitle(s);
    }

    public void setDirectory(String dir) {
        this.directoryField.setText(dir);
    }

    public void disableDirectoryField() {
        this.directoryField.setEditable(false);
    }

    public void disableBrowseButton() {
        this.directoryButton.setEnabled(false);
    }

    public void enableDirectoryField() {
        this.directoryField.setEditable(true);
    }

    public String getDirectory() {
        return this.directoryField.getText();
    }

    public void setRootDirectory(String dir) {
        this.directoryFieldRootdir.setText(dir);
    }

    public String getRootDirectory() {
        return this.directoryFieldRootdir.getText();
    }

    public void actionPerformed(ActionEvent e) {
        File file;
        int ReturnValue;
        if (e.getSource() == this.directoryButton && (ReturnValue = this.directoryChooser.showOpenDialog(this)) == 0) {
            file = this.directoryChooser.getSelectedFile();
            this.directoryField.setText(file.getAbsolutePath());
        }
        if (e.getSource() == this.directoryButtonRootdir && (ReturnValue = this.directoryChooserRootdir.showOpenDialog(this)) == 0) {
            file = this.directoryChooserRootdir.getSelectedFile();
            this.directoryFieldRootdir.setText(file.getAbsolutePath());
        }
    }
}

