/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.v2.util;

public class EditDistance {
    private int[] cost;
    private int[] back;
    private final String a;
    private final String b;

    public static int editDistance(String string, String string2) {
        return new EditDistance(string, string2).calc();
    }

    public static String findNearest(String string, String[] stringArray) {
        int n = Integer.MAX_VALUE;
        String string2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            int n2 = EditDistance.editDistance(string, stringArray[i]);
            if (n <= n2) continue;
            n = n2;
            string2 = stringArray[i];
        }
        return string2;
    }

    private EditDistance(String string, String string2) {
        this.a = string;
        this.b = string2;
        this.cost = new int[string.length() + 1];
        this.back = new int[string.length() + 1];
        for (int i = 0; i <= string.length(); ++i) {
            this.cost[i] = i;
        }
    }

    private void flip() {
        int[] nArray = this.cost;
        this.cost = this.back;
        this.back = nArray;
    }

    private int min(int n, int n2, int n3) {
        return Math.min(n, Math.min(n2, n3));
    }

    private int calc() {
        for (int i = 0; i < this.b.length(); ++i) {
            this.flip();
            this.cost[0] = i + 1;
            for (int j = 0; j < this.a.length(); ++j) {
                int n = this.a.charAt(j) == this.b.charAt(i) ? 0 : 1;
                this.cost[j + 1] = this.min(this.back[j] + n, this.cost[j] + 1, this.back[j + 1] + 1);
            }
        }
        return this.cost[this.a.length()];
    }
}

