/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.im.spi.InputMethodContext;
import java.awt.peer.ComponentPeer;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;
import sun.awt.X11InputMethod;

public class XInputMethod
extends X11InputMethod {
    private static final Logger log = Logger.getLogger("sun.awt.X11.XInputMethod");
    private static volatile long xicFocus = 0L;

    public void setInputMethodContext(InputMethodContext inputMethodContext) {
        inputMethodContext.enableClientWindowNotification(this, true);
    }

    public void notifyClientWindowChange(Rectangle rectangle) {
        XComponentPeer xComponentPeer = (XComponentPeer)this.getPeer(this.clientComponentWindow);
        if (xComponentPeer != null) {
            this.adjustStatusWindow(xComponentPeer.getContentWindow());
        }
    }

    protected boolean openXIM() {
        return this.openXIMNative(XToolkit.getDisplay());
    }

    protected boolean createXIC() {
        XComponentPeer xComponentPeer = (XComponentPeer)this.getPeer(this.clientComponentWindow);
        if (xComponentPeer == null) {
            return false;
        }
        return this.createXICNative(xComponentPeer.getContentWindow());
    }

    protected void setXICFocus(ComponentPeer componentPeer, boolean bl, boolean bl2) {
        if (componentPeer == null) {
            return;
        }
        xicFocus = ((XComponentPeer)componentPeer).getContentWindow();
        this.setXICFocusNative(((XComponentPeer)componentPeer).getContentWindow(), bl, bl2);
    }

    public static long getXICFocus() {
        return xicFocus;
    }

    protected Container getParent(Component component) {
        return component.getParent();
    }

    protected ComponentPeer getPeer(Component component) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Client is " + component);
        }
        XComponentPeer xComponentPeer = (XComponentPeer)XToolkit.targetToPeer(component);
        while (component != null && xComponentPeer == null) {
            component = this.getParent(component);
            xComponentPeer = (XComponentPeer)XToolkit.targetToPeer(component);
        }
        log.log(Level.FINE, "Peer is {0}, client is {1}", new Object[]{xComponentPeer, component});
        if (xComponentPeer != null) {
            return xComponentPeer;
        }
        return null;
    }

    protected synchronized void disposeImpl() {
        super.disposeImpl();
        this.clientComponentWindow = null;
    }

    protected void awtLock() {
        XToolkit.awtLock();
    }

    protected void awtUnlock() {
        XToolkit.awtUnlock();
    }

    long getCurrentParentWindow() {
        return ((XWindow)((Object)this.clientComponentWindow.getPeer())).getContentWindow();
    }

    private native boolean openXIMNative(long var1);

    private native boolean createXICNative(long var1);

    private native void setXICFocusNative(long var1, boolean var3, boolean var4);

    private native void adjustStatusWindow(long var1);
}

