/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Semaphore
implements Serializable {
    private static final long serialVersionUID = -3222578661600680210L;
    private final Sync sync;

    public Semaphore(int n) {
        this.sync = new NonfairSync(n);
    }

    public Semaphore(int n, boolean bl) {
        this.sync = bl ? new FairSync(n) : new NonfairSync(n);
    }

    public void acquire() throws InterruptedException {
        this.sync.acquireSharedInterruptibly(1);
    }

    public void acquireUninterruptibly() {
        this.sync.acquireShared(1);
    }

    public boolean tryAcquire() {
        return this.sync.nonfairTryAcquireShared(1) >= 0;
    }

    public boolean tryAcquire(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.sync.tryAcquireSharedNanos(1, timeUnit.toNanos(l));
    }

    public void release() {
        this.sync.releaseShared(1);
    }

    public void acquire(int n) throws InterruptedException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.sync.acquireSharedInterruptibly(n);
    }

    public void acquireUninterruptibly(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.sync.acquireShared(n);
    }

    public boolean tryAcquire(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        return this.sync.nonfairTryAcquireShared(n) >= 0;
    }

    public boolean tryAcquire(int n, long l, TimeUnit timeUnit) throws InterruptedException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        return this.sync.tryAcquireSharedNanos(n, timeUnit.toNanos(l));
    }

    public void release(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.sync.releaseShared(n);
    }

    public int availablePermits() {
        return this.sync.getPermits();
    }

    public int drainPermits() {
        return this.sync.drainPermits();
    }

    protected void reducePermits(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.sync.reducePermits(n);
    }

    public boolean isFair() {
        return this.sync instanceof FairSync;
    }

    public final boolean hasQueuedThreads() {
        return this.sync.hasQueuedThreads();
    }

    public final int getQueueLength() {
        return this.sync.getQueueLength();
    }

    protected Collection<Thread> getQueuedThreads() {
        return this.sync.getQueuedThreads();
    }

    public String toString() {
        return super.toString() + "[Permits = " + this.sync.getPermits() + "]";
    }

    static final class FairSync
    extends Sync {
        private static final long serialVersionUID = 2014338818796000944L;

        FairSync(int n) {
            super(n);
        }

        protected int tryAcquireShared(int n) {
            int n2;
            int n3;
            Thread thread = Thread.currentThread();
            do {
                Thread thread2;
                if ((thread2 = this.getFirstQueuedThread()) == null || thread2 == thread) continue;
                return -1;
            } while ((n3 = (n2 = this.getState()) - n) >= 0 && !this.compareAndSetState(n2, n3));
            return n3;
        }
    }

    static final class NonfairSync
    extends Sync {
        private static final long serialVersionUID = -2694183684443567898L;

        NonfairSync(int n) {
            super(n);
        }

        protected int tryAcquireShared(int n) {
            return this.nonfairTryAcquireShared(n);
        }
    }

    static abstract class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 1192457210091910933L;

        Sync(int n) {
            this.setState(n);
        }

        final int getPermits() {
            return this.getState();
        }

        final int nonfairTryAcquireShared(int n) {
            int n2;
            int n3;
            while ((n3 = (n2 = this.getState()) - n) >= 0 && !this.compareAndSetState(n2, n3)) {
            }
            return n3;
        }

        protected final boolean tryReleaseShared(int n) {
            int n2;
            while (!this.compareAndSetState(n2 = this.getState(), n2 + n)) {
            }
            return true;
        }

        final void reducePermits(int n) {
            int n2;
            int n3;
            while (!this.compareAndSetState(n3 = this.getState(), n2 = n3 - n)) {
            }
        }

        final int drainPermits() {
            int n;
            while ((n = this.getState()) != 0 && !this.compareAndSetState(n, 0)) {
            }
            return n;
        }
    }
}

