/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.setup.Panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.openoffice.setup.PanelHelper.PanelLabel;
import org.openoffice.setup.PanelHelper.PanelTitle;
import org.openoffice.setup.PanelHelper.TreeNodeRenderer;
import org.openoffice.setup.ResourceManager;
import org.openoffice.setup.SetupData.DisplayPackageDescription;
import org.openoffice.setup.SetupData.SetupDataProvider;

public class ChooseComponents
extends JPanel
implements MouseListener,
KeyListener,
TreeSelectionListener {
    private JTree componentTree;
    private PanelLabel descriptionLabel;
    private PanelLabel sizeLabel;
    private String sizeString;
    private PanelTitle titleBox;

    public ChooseComponents() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
        String titleText = ResourceManager.getString("String_ChooseComponents1");
        String subtitleText = ResourceManager.getString("String_ChooseComponents2");
        this.titleBox = new PanelTitle(titleText, subtitleText, 2, 40);
        this.titleBox.addVerticalStrut(20);
        this.add((Component)this.titleBox, "North");
        DefaultMutableTreeNode root = SetupDataProvider.createTree();
        this.componentTree = new JTree(root);
        this.componentTree.setShowsRootHandles(true);
        this.componentTree.setRootVisible(false);
        this.componentTree.setVisibleRowCount(3);
        this.componentTree.setCellRenderer(new TreeNodeRenderer());
        this.componentTree.addMouseListener(this);
        this.componentTree.addKeyListener(this);
        this.componentTree.getSelectionModel().setSelectionMode(1);
        this.componentTree.addTreeSelectionListener(this);
        String BorderTitle = ResourceManager.getString("String_ChooseComponents3");
        TitledBorder PanelBorder = BorderFactory.createTitledBorder(BorderTitle);
        BorderLayout PanelLayout = new BorderLayout();
        PanelLayout.setHgap(20);
        JPanel DescriptionPanel = new JPanel();
        DescriptionPanel.setBorder(PanelBorder);
        DescriptionPanel.setLayout(PanelLayout);
        String DescriptionText = "";
        this.descriptionLabel = new PanelLabel(DescriptionText, 3, 20);
        this.sizeString = ResourceManager.getString("String_ChooseComponents4");
        this.sizeLabel = new PanelLabel(this.sizeString, 1, 5);
        DescriptionPanel.add((Component)this.descriptionLabel, "Center");
        DescriptionPanel.add((Component)this.sizeLabel, "East");
        this.add((Component)new JScrollPane(this.componentTree), "Center");
        this.add((Component)DescriptionPanel, "South");
    }

    public void setTitleText(String s) {
        this.titleBox.setTitle(s);
    }

    private void updateNode(DefaultMutableTreeNode node) {
        if (node != null) {
            DisplayPackageDescription nodeInfo = (DisplayPackageDescription)node.getUserObject();
            nodeInfo.toggleState(node);
            DefaultTreeModel model = (DefaultTreeModel)this.componentTree.getModel();
            model.nodeStructureChanged(node);
            this.descriptionLabel.setText(nodeInfo.getDescription());
            this.sizeLabel.setText(this.sizeString + nodeInfo.getSize());
        }
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
        TreePath selPath = this.componentTree.getPathForLocation(event.getX(), event.getY());
        if (selPath != null && this.componentTree.getPathBounds(selPath).getX() + 20.0 >= (double)event.getX()) {
            this.updateNode((DefaultMutableTreeNode)selPath.getLastPathComponent());
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void keyPressed(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
    }

    public void keyTyped(KeyEvent event) {
        TreePath selPath;
        if (event.getKeyChar() == ' ' && (selPath = this.componentTree.getAnchorSelectionPath()) != null) {
            this.updateNode((DefaultMutableTreeNode)selPath.getLastPathComponent());
        }
    }

    public void valueChanged(TreeSelectionEvent event) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.componentTree.getLastSelectedPathComponent();
        if (node == null) {
            this.descriptionLabel.setText("");
            this.sizeLabel.setText("");
        } else {
            DisplayPackageDescription nodeInfo = (DisplayPackageDescription)node.getUserObject();
            nodeInfo.updateSize(node);
            DefaultTreeModel model = (DefaultTreeModel)this.componentTree.getModel();
            model.nodeChanged(node);
            this.descriptionLabel.setText(nodeInfo.getDescription());
            this.sizeLabel.setText(this.sizeString + nodeInfo.getSize());
        }
    }
}

