/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xalan.internal.xsltc.trax;

import com.sun.org.apache.xalan.internal.xsltc.dom.SAXImpl;
import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.ext.Locator2;
import org.xml.sax.helpers.AttributesImpl;

public class StAXStream2SAX
implements XMLReader,
Locator {
    private final XMLStreamReader staxStreamReader;
    private ContentHandler _sax = null;
    private LexicalHandler _lex = null;
    private SAXImpl _saxImpl = null;

    public StAXStream2SAX(XMLStreamReader xMLStreamReader) {
        this.staxStreamReader = xMLStreamReader;
    }

    public ContentHandler getContentHandler() {
        return this._sax;
    }

    public void setContentHandler(ContentHandler contentHandler) throws NullPointerException {
        this._sax = contentHandler;
        if (contentHandler instanceof LexicalHandler) {
            this._lex = (LexicalHandler)((Object)contentHandler);
        }
        if (contentHandler instanceof SAXImpl) {
            this._saxImpl = (SAXImpl)contentHandler;
        }
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
        try {
            this.bridge();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SAXException(xMLStreamException);
        }
    }

    public void parse() throws IOException, SAXException, XMLStreamException {
        this.bridge();
    }

    public void parse(String string) throws IOException, SAXException {
        throw new IOException("This method is not yet implemented.");
    }

    public void bridge() throws XMLStreamException {
        try {
            int n = 0;
            int n2 = this.staxStreamReader.getEventType();
            if (n2 == 7) {
                n2 = this.staxStreamReader.nextTag();
            }
            if (n2 != 1) {
                throw new IllegalStateException("The current event is not START_ELEMENT\n but" + n2);
            }
            this.handleStartDocument();
            do {
                switch (n2) {
                    case 1: {
                        ++n;
                        this.handleStartElement();
                        break;
                    }
                    case 2: {
                        this.handleEndElement();
                        --n;
                        break;
                    }
                    case 4: {
                        this.handleCharacters();
                        break;
                    }
                    case 9: {
                        this.handleEntityReference();
                        break;
                    }
                    case 3: {
                        this.handlePI();
                        break;
                    }
                    case 5: {
                        this.handleComment();
                        break;
                    }
                    case 11: {
                        this.handleDTD();
                        break;
                    }
                    case 10: {
                        this.handleAttribute();
                        break;
                    }
                    case 13: {
                        this.handleNamespace();
                        break;
                    }
                    case 12: {
                        this.handleCDATA();
                        break;
                    }
                    case 15: {
                        this.handleEntityDecl();
                        break;
                    }
                    case 14: {
                        this.handleNotationDecl();
                        break;
                    }
                    case 6: {
                        this.handleSpace();
                        break;
                    }
                    default: {
                        throw new InternalError("processing event: " + n2);
                    }
                }
                n2 = this.staxStreamReader.next();
            } while (n != 0);
            this.handleEndDocument();
        }
        catch (SAXException sAXException) {
            throw new XMLStreamException(sAXException);
        }
    }

    private void handleEndDocument() throws SAXException {
        this._sax.endDocument();
    }

    private void handleStartDocument() throws SAXException {
        this._sax.setDocumentLocator(new Locator2(){

            public int getColumnNumber() {
                return StAXStream2SAX.this.staxStreamReader.getLocation().getColumnNumber();
            }

            public int getLineNumber() {
                return StAXStream2SAX.this.staxStreamReader.getLocation().getLineNumber();
            }

            public String getPublicId() {
                return StAXStream2SAX.this.staxStreamReader.getLocation().getPublicId();
            }

            public String getSystemId() {
                return StAXStream2SAX.this.staxStreamReader.getLocation().getSystemId();
            }

            public String getXMLVersion() {
                return StAXStream2SAX.this.staxStreamReader.getVersion();
            }

            public String getEncoding() {
                return StAXStream2SAX.this.staxStreamReader.getEncoding();
            }
        });
        this._sax.startDocument();
    }

    private void handlePI() throws XMLStreamException {
        try {
            this._sax.processingInstruction(this.staxStreamReader.getPITarget(), this.staxStreamReader.getPIData());
        }
        catch (SAXException sAXException) {
            throw new XMLStreamException(sAXException);
        }
    }

    private void handleCharacters() throws XMLStreamException {
        int n = this.staxStreamReader.getTextLength();
        char[] cArray = new char[n];
        this.staxStreamReader.getTextCharacters(0, cArray, 0, n);
        try {
            this._sax.characters(cArray, 0, cArray.length);
        }
        catch (SAXException sAXException) {
            throw new XMLStreamException(sAXException);
        }
    }

    private void handleEndElement() throws XMLStreamException {
        QName qName = this.staxStreamReader.getName();
        try {
            String string = "";
            if (qName.getPrefix() != null && qName.getPrefix().trim().length() != 0) {
                string = qName.getPrefix() + ":";
            }
            string = string + qName.getLocalPart();
            this._sax.endElement(qName.getNamespaceURI(), qName.getLocalPart(), string);
            int n = this.staxStreamReader.getNamespaceCount();
            for (int i = n - 1; i >= 0; --i) {
                String string2 = this.staxStreamReader.getNamespacePrefix(i);
                if (string2 == null) {
                    string2 = "";
                }
                this._sax.endPrefixMapping(string2);
            }
        }
        catch (SAXException sAXException) {
            throw new XMLStreamException(sAXException);
        }
    }

    private void handleStartElement() throws XMLStreamException {
        try {
            String string;
            int n = this.staxStreamReader.getNamespaceCount();
            for (int i = 0; i < n; ++i) {
                string = this.staxStreamReader.getNamespacePrefix(i);
                if (string == null) {
                    string = "";
                }
                this._sax.startPrefixMapping(string, this.staxStreamReader.getNamespaceURI(i));
            }
            QName qName = this.staxStreamReader.getName();
            string = qName.getPrefix();
            String string2 = string == null || string.length() == 0 ? qName.getLocalPart() : string + ':' + qName.getLocalPart();
            Attributes attributes = this.getAttributes();
            this._sax.startElement(qName.getNamespaceURI(), qName.getLocalPart(), string2, attributes);
        }
        catch (SAXException sAXException) {
            throw new XMLStreamException(sAXException);
        }
    }

    private Attributes getAttributes() {
        AttributesImpl attributesImpl = new AttributesImpl();
        int n = this.staxStreamReader.getEventType();
        if (n != 10 && n != 1) {
            throw new InternalError("getAttributes() attempting to process: " + n);
        }
        for (int i = 0; i < this.staxStreamReader.getAttributeCount(); ++i) {
            String string = this.staxStreamReader.getAttributeNamespace(i);
            if (string == null) {
                string = "";
            }
            String string2 = this.staxStreamReader.getAttributeLocalName(i);
            String string3 = this.staxStreamReader.getAttributePrefix(i);
            String string4 = string3 == null || string3.length() == 0 ? string2 : string3 + ':' + string2;
            String string5 = this.staxStreamReader.getAttributeType(i);
            String string6 = this.staxStreamReader.getAttributeValue(i);
            attributesImpl.addAttribute(string, string2, string4, string5, string6);
        }
        return attributesImpl;
    }

    private void handleNamespace() {
    }

    private void handleAttribute() {
    }

    private void handleDTD() {
    }

    private void handleComment() {
    }

    private void handleEntityReference() {
    }

    private void handleSpace() {
    }

    private void handleNotationDecl() {
    }

    private void handleEntityDecl() {
    }

    private void handleCDATA() {
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public void setDTDHandler(DTDHandler dTDHandler) throws NullPointerException {
    }

    public void setEntityResolver(EntityResolver entityResolver) throws NullPointerException {
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setErrorHandler(ErrorHandler errorHandler) throws NullPointerException {
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    public int getColumnNumber() {
        return 0;
    }

    public int getLineNumber() {
        return 0;
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return null;
    }
}

