/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.transport.http.server;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpsExchange;
import com.sun.xml.internal.ws.handler.MessageContextImpl;
import com.sun.xml.internal.ws.handler.MessageContextUtil;
import com.sun.xml.internal.ws.server.DocInfo;
import com.sun.xml.internal.ws.server.RuntimeEndpointInfo;
import com.sun.xml.internal.ws.server.Tie;
import com.sun.xml.internal.ws.server.WSDLPatcher;
import com.sun.xml.internal.ws.spi.runtime.WSConnection;
import com.sun.xml.internal.ws.spi.runtime.WebServiceContext;
import com.sun.xml.internal.ws.transport.Headers;
import com.sun.xml.internal.ws.transport.http.server.ServerConnectionImpl;
import com.sun.xml.internal.ws.util.localization.LocalizableMessageFactory;
import com.sun.xml.internal.ws.util.localization.Localizer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.logging.Logger;

public class WSHttpHandler
implements HttpHandler {
    private static final String GET_METHOD = "GET";
    private static final String POST_METHOD = "POST";
    private static final String HEAD_METHOD = "HEAD";
    private static final String PUT_METHOD = "PUT";
    private static final String DELETE_METHOD = "DELETE";
    private static final String HTML_CONTENT_TYPE = "text/html";
    private static final String XML_CONTENT_TYPE = "text/xml";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.server.http");
    private static final Localizer localizer = new Localizer();
    private static final LocalizableMessageFactory messageFactory = new LocalizableMessageFactory("com.sun.xml.internal.ws.resources.httpserver");
    private final RuntimeEndpointInfo endpointInfo;
    private final Tie tie;
    private final Executor executor;

    public WSHttpHandler(Tie tie, RuntimeEndpointInfo runtimeEndpointInfo, Executor executor) {
        this.tie = tie;
        this.endpointInfo = runtimeEndpointInfo;
        this.executor = executor;
    }

    public void handle(HttpExchange httpExchange) {
        logger.fine("Received HTTP request:" + httpExchange.getRequestURI());
        if (this.executor != null) {
            this.executor.execute(new HttpHandlerRunnable(httpExchange));
        } else {
            this.handleExchange(httpExchange);
        }
    }

    private void handleExchange(HttpExchange httpExchange) {
        try {
            String string = httpExchange.getRequestMethod();
            if (string.equals(GET_METHOD)) {
                String string2 = httpExchange.getRequestURI().getQuery();
                logger.fine("Query String for request =" + string2);
                if (string2 != null && (string2.equals("WSDL") || string2.equals("wsdl") || string2.startsWith("wsdl=") || string2.startsWith("xsd="))) {
                    this.processDocRequest(httpExchange);
                } else {
                    this.process(httpExchange);
                }
            } else if (string.equals(POST_METHOD) || string.equals(HEAD_METHOD) || string.equals(PUT_METHOD) || string.equals(DELETE_METHOD)) {
                this.process(httpExchange);
            } else {
                logger.warning(localizer.localize(messageFactory.getMessage("unexpected.http.method", string)));
                httpExchange.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(HttpExchange httpExchange) {
        ServerConnectionImpl serverConnectionImpl = new ServerConnectionImpl(httpExchange);
        try {
            MessageContextImpl messageContextImpl = new MessageContextImpl();
            WebServiceContext webServiceContext = this.endpointInfo.getWebServiceContext();
            webServiceContext.setMessageContext(messageContextImpl);
            MessageContextUtil.setHttpRequestMethod(messageContextImpl, httpExchange.getRequestMethod());
            MessageContextUtil.setHttpRequestHeaders(messageContextImpl, serverConnectionImpl.getHeaders());
            MessageContextUtil.setHttpExchange(messageContextImpl, httpExchange);
            URI uRI = httpExchange.getRequestURI();
            String string = uRI.getQuery();
            if (string != null) {
                MessageContextUtil.setQueryString(messageContextImpl, string);
            }
            String string2 = uRI.getPath();
            String string3 = httpExchange.getHttpContext().getPath();
            if (string2.length() > string3.length()) {
                String string4 = string2.substring(string3.length());
                MessageContextUtil.setPathInfo(messageContextImpl, string4);
            }
            this.tie.handle(serverConnectionImpl, this.endpointInfo);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            serverConnectionImpl.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDocRequest(HttpExchange httpExchange) {
        ServerConnectionImpl serverConnectionImpl = new ServerConnectionImpl(httpExchange);
        try {
            serverConnectionImpl.getInput();
            String string = httpExchange.getRequestURI().getQuery();
            String string2 = this.endpointInfo.getPath(string);
            if (string2 == null) {
                String string3 = localizer.localize(messageFactory.getMessage("html.notFound", "Invalid Request =" + httpExchange.getRequestURI()));
                this.writeErrorPage(serverConnectionImpl, 404, string3);
                return;
            }
            DocInfo docInfo = this.endpointInfo.getDocMetadata().get(string2);
            if (docInfo == null) {
                String string4 = localizer.localize(messageFactory.getMessage("html.notFound", "Invalid Request =" + httpExchange.getRequestURI()));
                this.writeErrorPage(serverConnectionImpl, 404, string4);
                return;
            }
            InputStream inputStream = null;
            try {
                Map<String, List<String>> map = serverConnectionImpl.getHeaders();
                List<String> list = map.get("Host");
                Headers headers = new Headers();
                headers.add(CONTENT_TYPE_HEADER, XML_CONTENT_TYPE);
                serverConnectionImpl.setHeaders(headers);
                serverConnectionImpl.setStatus(200);
                OutputStream outputStream = serverConnectionImpl.getOutput();
                ArrayList<RuntimeEndpointInfo> arrayList = new ArrayList<RuntimeEndpointInfo>();
                arrayList.add(this.endpointInfo);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(httpExchange instanceof HttpsExchange ? "https" : "http");
                stringBuffer.append("://");
                if (list != null) {
                    stringBuffer.append(list.get(0));
                } else {
                    stringBuffer.append(httpExchange.getLocalAddress().getHostName());
                    stringBuffer.append(":");
                    stringBuffer.append(httpExchange.getLocalAddress().getPort());
                }
                stringBuffer.append(httpExchange.getRequestURI().getPath());
                String string5 = stringBuffer.toString();
                logger.fine("Address =" + string5);
                WSDLPatcher wSDLPatcher = new WSDLPatcher(docInfo, string5, this.endpointInfo, arrayList);
                inputStream = docInfo.getDoc();
                wSDLPatcher.patchDoc(inputStream, outputStream);
            }
            catch (Throwable throwable) {
                WSHttpHandler.closeInputStream(inputStream);
                serverConnectionImpl.closeOutput();
                throw throwable;
            }
            WSHttpHandler.closeInputStream(inputStream);
            serverConnectionImpl.closeOutput();
        }
        finally {
            serverConnectionImpl.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeErrorPage(WSConnection wSConnection, int n, String string) {
        try {
            HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(HTML_CONTENT_TYPE);
            hashMap.put(CONTENT_TYPE_HEADER, arrayList);
            wSConnection.setHeaders(hashMap);
            wSConnection.setStatus(n);
            OutputStream outputStream = wSConnection.getOutput();
            PrintWriter printWriter = new PrintWriter(outputStream);
            printWriter.println("<html><head><title>");
            printWriter.println(localizer.localize(messageFactory.getMessage("html.title", new Object[0])));
            printWriter.println("</title></head><body>");
            printWriter.println(string);
            printWriter.println("</body></html>");
            printWriter.close();
        }
        finally {
            wSConnection.closeOutput();
        }
    }

    private static void closeInputStream(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    class HttpHandlerRunnable
    implements Runnable {
        final HttpExchange msg;

        HttpHandlerRunnable(HttpExchange httpExchange) {
            this.msg = httpExchange;
        }

        public void run() {
            WSHttpHandler.this.handleExchange(this.msg);
        }
    }
}

