/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.xml;

import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.deploy.xml.BadTokenException;
import com.sun.deploy.xml.GeneralEntity;
import com.sun.deploy.xml.XMLAttribute;
import com.sun.deploy.xml.XMLNode;

public class XMLParser {
    public XMLNode _root;
    public String _source;
    public String _current;
    public int _tokenType;
    public String _tokenData;
    public static final int TOKEN_EOF = 1;
    public static final int TOKEN_END_TAG = 2;
    public static final int TOKEN_BEGIN_TAG = 3;
    public static final int TOKEN_CLOSE_TAG = 4;
    public static final int TOKEN_EMPTY_CLOSE_TAG = 5;
    public static final int TOKEN_PCDATA = 6;
    public static final GeneralEntity[] REQUIRED_CHARACTER_REFERENCES = new GeneralEntity[]{new GeneralEntity("quot", "\""), new GeneralEntity("amp", "&"), new GeneralEntity("apos", "'"), new GeneralEntity("lt", "<"), new GeneralEntity("gt", ">")};
    private static final String CDStart = "<![CDATA[";
    private static final String CDEnd = "]]>";

    public XMLParser(String string) {
        Trace.println("new XMLParser with source:", TraceLevel.TEMP);
        Trace.println(string, TraceLevel.TEMP);
        this._source = string;
        this._current = string;
        this._root = null;
        this._tokenData = null;
    }

    public XMLNode parse() throws BadTokenException {
        try {
            this.nextToken(this._current);
            this._root = this.parseXMLElement(this._current);
        }
        catch (NullPointerException nullPointerException) {
            Trace.println("NULL Pointer Exception: " + nullPointerException, TraceLevel.TEMP);
            throw nullPointerException;
        }
        catch (BadTokenException badTokenException) {
            Trace.println("JNLP Parse Exception: " + badTokenException, TraceLevel.TEMP);
            throw badTokenException;
        }
        if (Trace.isTraceLevelEnabled(TraceLevel.TEMP)) {
            Trace.println("\n\nreturning ROOT as follows:\n" + this._root, TraceLevel.TEMP);
        }
        return this._root;
    }

    private void nextToken(String string) throws BadTokenException {
        this._current = this.skipFilling(string);
        if (this._current == null) {
            this._tokenType = 1;
        } else if (this._current.startsWith(CDStart)) {
            this._tokenType = 6;
            this._current = this.skipPCData(string, '<');
        } else if (this._current.startsWith("</")) {
            this._tokenType = 2;
            this._current = this.skipXMLName(this.skipForward(this._current, 2, 0));
        } else if (this._current.startsWith("<")) {
            this._tokenType = 3;
            this._current = this.skipXMLName(this.skipForward(this._current, 1, 0));
        } else if (this._current.startsWith(">")) {
            this._tokenType = 4;
            this._current = this.skipForward(this._current, 1, 0);
        } else if (this._current.startsWith("/>")) {
            this._tokenType = 5;
            this._current = this.skipForward(this._current, 2, 0);
        } else {
            this._tokenType = 6;
            this._current = this.skipPCData(string, '<');
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private String skipPCData(String string, char c) throws BadTokenException {
        int n = string.indexOf(c);
        String string2 = null;
        if (n < 0) {
            if (string.trim().length() == 0) return string2;
            this._current = string;
            throw new BadTokenException("Failed to find the '" + c + "' charater that marks the end of a CDATA element.", this._source, this.getLineNumber());
        }
        int n2 = string.indexOf(CDStart);
        if (n2 >= 0 && n2 <= n) {
            String string3 = this.parseCharacterReferences(string.substring(0, n2));
            String string4 = string.substring(n2 + CDStart.length());
            int n3 = string4.indexOf(CDEnd);
            if (n3 >= 0) {
                string2 = this.skipPCData(string4.substring(n3 + CDEnd.length()), c);
                this._tokenData = string3 + string4.substring(0, n3) + this._tokenData;
                return string2;
            }
            this._current = string4;
            throw new BadTokenException("Found the start of a PCDATA element with no end marker.", this._source, this.getLineNumber());
        }
        this._tokenData = this.parseCharacterReferences(string.substring(0, n));
        return string.substring(n);
    }

    private XMLNode parseXMLElement(String string) throws BadTokenException {
        if (this._tokenType == 3) {
            XMLAttribute xMLAttribute;
            String string2 = this._tokenData;
            XMLAttribute xMLAttribute2 = xMLAttribute = this.parseXMLAttribute(this._current);
            while (xMLAttribute2 != null) {
                XMLAttribute xMLAttribute3 = this.parseXMLAttribute(this._current);
                xMLAttribute2.setNext(xMLAttribute3);
                xMLAttribute2 = xMLAttribute3;
            }
            XMLNode xMLNode = new XMLNode(string2, xMLAttribute);
            this.nextToken(this._current);
            if (this._tokenType != 5 && this._tokenType != 4 && this._tokenType != 1) {
                throw new BadTokenException(this._source, this.getLineNumber());
            }
            if (this._tokenType == 5) {
                this.nextToken(this._current);
            } else if (this._tokenType == 4) {
                this.nextToken(this._current);
                XMLNode xMLNode2 = this.parseXMLElement(this._current);
                if (xMLNode2 != null) {
                    xMLNode.setNested(xMLNode2);
                    xMLNode2.setParent(xMLNode);
                }
                if (this._tokenType == 2) {
                    do {
                        this.nextToken(this._current);
                    } while (this._tokenType != 1 && this._tokenType != 4);
                    this.nextToken(this._current);
                }
            }
            if (this._tokenType != 1) {
                XMLNode xMLNode3 = this.parseXMLElement(this._current);
                xMLNode.setNext(xMLNode3);
            }
            return xMLNode;
        }
        if (this._tokenType == 6) {
            XMLNode xMLNode = new XMLNode(this._tokenData);
            this.nextToken(this._current);
            return xMLNode;
        }
        return null;
    }

    private XMLAttribute parseXMLAttribute(String string) throws BadTokenException {
        String string2;
        if (string == null) {
            return null;
        }
        this._current = this.skipFilling(string);
        if (this._current == null || this._current.startsWith(">") || this._current.startsWith("/>")) {
            return null;
        }
        this._current = this.skipAttributeName(this._current);
        String string3 = this._tokenData;
        this._current = this.skipFilling(this._current);
        if (!this._current.startsWith("=")) {
            if (string.equals(this._current)) {
                this._current = this.skipForward(this._current, 1, 0);
            }
            return this.parseXMLAttribute(this._current);
        }
        this._current = this.skipForward(this._current, 1, 0);
        this._current = this.skipWhitespace(this._current);
        if (this._current.startsWith("\"") || this._current.startsWith("'")) {
            char c = this._current.charAt(0);
            this._current = this.skipForward(this._current, 1, 0);
            this._current = this.skipPCData(this._current, c);
            string2 = this._tokenData;
            this._current = this.skipForward(this._current, 1, 0);
        } else {
            this._current = this.skipNonSpace(this._current);
            string2 = this._tokenData;
        }
        if (string2 != null) {
            string2 = string2.trim();
        }
        return new XMLAttribute(string3, string2);
    }

    private String parseCharacterReferences(String string) {
        String string2 = string;
        int n = string.indexOf("&");
        if (n >= 0) {
            String string3 = string.substring(0, n);
            String string4 = "&";
            String string5 = string.substring(n + 1);
            int n2 = string.indexOf(";", n);
            if (n2 > n) {
                boolean bl = false;
                string4 = string.substring(n + 1, n2);
                string5 = string.substring(n2 + 1);
                if (string4.startsWith("#")) {
                    try {
                        int n3 = 10;
                        int n4 = 1;
                        char[] cArray = new char[]{'\u0000'};
                        if (string4.startsWith("#x")) {
                            n3 = 16;
                            n4 = 2;
                        }
                        cArray[0] = (char)Integer.parseInt(string4.substring(n4), n3);
                        string4 = new String(cArray);
                        bl = true;
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    for (int i = 0; i < REQUIRED_CHARACTER_REFERENCES.length; ++i) {
                        if (!REQUIRED_CHARACTER_REFERENCES[i].equals(string4)) continue;
                        string4 = REQUIRED_CHARACTER_REFERENCES[i].getValue();
                        bl = true;
                        break;
                    }
                }
                if (!bl) {
                    string4 = "&" + string4 + ";";
                    Trace.println("Unrecognized character entity reference: " + string4, TraceLevel.BASIC);
                }
            }
            string2 = string3 + string4 + this.parseCharacterReferences(string5);
        }
        return string2;
    }

    private String skipForward(String string, int n, int n2) {
        if (n < 0 || n + n2 >= string.length()) {
            return null;
        }
        return string.substring(n + n2);
    }

    private String skipNonSpace(String string) throws BadTokenException {
        int n;
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        for (n = 0; n < n2 && !Character.isWhitespace(string.charAt(n)); ++n) {
        }
        return this.skipPCData(string, string.charAt(n));
    }

    private String skipWhitespace(String string) {
        int n;
        if (string == null) {
            return null;
        }
        for (n = 0; n < string.length() && Character.isWhitespace(string.charAt(n)); ++n) {
        }
        return string.substring(n);
    }

    private boolean legalTokenStartChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == ':';
    }

    private boolean legalTokenChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == ':' || c == '.' || c == '-';
    }

    private String skipAttributeName(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf("=");
        if (n >= 0) {
            this._tokenData = string.substring(0, n);
            if (this._tokenData != null) {
                this._tokenData = this._tokenData.trim();
            }
        } else {
            this._tokenData = null;
        }
        return this.skipForward(string, n, 0);
    }

    private String skipXMLName(String string) {
        int n = 0;
        if (string == null) {
            return null;
        }
        if (this.legalTokenStartChar(string.charAt(0))) {
            for (n = 1; n < string.length() && this.legalTokenChar(string.charAt(n)); ++n) {
            }
        }
        this._tokenData = string.substring(0, n);
        if (this._tokenData != null) {
            this._tokenData = this._tokenData.trim();
        }
        return this.skipForward(string, n, 0);
    }

    private String skipXMLComment(String string) {
        if (string != null && string.startsWith("<!--")) {
            int n = string.indexOf("-->", 4);
            return this.skipForward(string, n, 3);
        }
        return string;
    }

    private String skipXMLDocType(String string) {
        if (string != null && string.startsWith("<!") && !string.startsWith(CDStart)) {
            int n = string.indexOf(">", 2);
            return this.skipForward(string, n, 1);
        }
        return string;
    }

    private String skipXMLProlog(String string) {
        if (string != null && string.startsWith("<?")) {
            int n = string.indexOf("?>", 2);
            return this.skipForward(string, n, 2);
        }
        return string;
    }

    private String skipFilling(String string) {
        String string2;
        String string3 = string;
        do {
            string2 = string3;
            string3 = this.skipWhitespace(string3);
            string3 = this.skipXMLComment(string3);
            string3 = this.skipXMLDocType(string3);
        } while ((string3 = this.skipXMLProlog(string3)) != string2);
        return string3;
    }

    private int getLineNumber() {
        int n = this._current == null ? this._source.length() : this._source.indexOf(this._current);
        int n2 = 0;
        int n3 = 0;
        while (n3 < n && n3 != -1) {
            if ((n3 = this._source.indexOf("\n", n3)) < 0) continue;
            ++n3;
            ++n2;
        }
        return n2;
    }
}

