/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.util.xml;

import com.sun.istack.internal.Nullable;
import com.sun.org.apache.xml.internal.resolver.CatalogManager;
import com.sun.org.apache.xml.internal.resolver.tools.CatalogResolver;
import com.sun.xml.internal.ws.server.ServerRtException;
import com.sun.xml.internal.ws.util.ByteArrayBuffer;
import com.sun.xml.internal.ws.util.xml.NamedNodeMapIterator;
import com.sun.xml.internal.ws.util.xml.NodeListIterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.ws.WebServiceException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlUtil {
    static final TransformerFactory transformerFactory = TransformerFactory.newInstance();
    public static final ErrorHandler DRACONIAN_ERROR_HANDLER = new ErrorHandler(){

        public void warning(SAXParseException sAXParseException) {
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }
    };

    public static String getPrefix(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            return null;
        }
        return string.substring(0, n);
    }

    public static String getLocalPart(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static String getAttributeOrNull(Element element, String string) {
        Attr attr = element.getAttributeNode(string);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    public static String getAttributeNSOrNull(Element element, String string, String string2) {
        Attr attr = element.getAttributeNodeNS(string2, string);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    public static String getAttributeNSOrNull(Element element, QName qName) {
        Attr attr = element.getAttributeNodeNS(qName.getNamespaceURI(), qName.getLocalPart());
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    public static Iterator getAllChildren(Element element) {
        return new NodeListIterator(element.getChildNodes());
    }

    public static Iterator getAllAttributes(Element element) {
        return new NamedNodeMapIterator(element.getAttributes());
    }

    public static List<String> parseTokenList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    public static String getTextForNode(Node node) {
        StringBuffer stringBuffer = new StringBuffer();
        NodeList nodeList = node.getChildNodes();
        if (nodeList.getLength() == 0) {
            return null;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2 instanceof Text) {
                stringBuffer.append(node2.getNodeValue());
                continue;
            }
            if (node2 instanceof EntityReference) {
                String string = XmlUtil.getTextForNode(node2);
                if (string == null) {
                    return null;
                }
                stringBuffer.append(string);
                continue;
            }
            return null;
        }
        return stringBuffer.toString();
    }

    public static InputStream getUTF8Stream(String string) {
        try {
            ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayBuffer, "utf-8");
            outputStreamWriter.write(string);
            ((Writer)outputStreamWriter).close();
            return byteArrayBuffer.newInputStream();
        }
        catch (IOException iOException) {
            throw new RuntimeException("should not happen");
        }
    }

    public static Transformer newTransformer() {
        try {
            return transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new IllegalStateException("Unable to create a JAXP transformer");
        }
    }

    public static EntityResolver createEntityResolver(@Nullable URL uRL) {
        CatalogManager catalogManager = new CatalogManager();
        catalogManager.setIgnoreMissingProperties(true);
        try {
            if (uRL != null) {
                catalogManager.getCatalog().parseCatalog(uRL);
            }
        }
        catch (IOException iOException) {
            throw new ServerRtException("server.rt.err", new Object[]{iOException});
        }
        return new CatalogResolver(catalogManager);
    }

    public static EntityResolver createDefaultCatalogResolver() {
        CatalogManager catalogManager = new CatalogManager();
        catalogManager.setIgnoreMissingProperties(true);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Enumeration<URL> enumeration = classLoader == null ? ClassLoader.getSystemResources("META-INF/jax-ws-catalog.xml") : classLoader.getResources("META-INF/jax-ws-catalog.xml");
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                catalogManager.getCatalog().parseCatalog(uRL);
            }
        }
        catch (IOException iOException) {
            throw new WebServiceException(iOException);
        }
        return new CatalogResolver(catalogManager);
    }
}

