/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleStateSet;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.KeyboardManager;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SingleSelectionModel;
import javax.swing.UIManager;
import javax.swing.plaf.MenuBarUI;

public class JMenuBar
extends JComponent
implements Accessible,
MenuElement {
    private static final String uiClassID = "MenuBarUI";
    private transient SingleSelectionModel selectionModel;
    private boolean paintBorder = true;
    private Insets margin = null;
    private static final boolean TRACE = false;
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = false;

    public JMenuBar() {
        this.setFocusTraversalKeysEnabled(false);
        this.setSelectionModel(new DefaultSingleSelectionModel());
        this.updateUI();
    }

    public MenuBarUI getUI() {
        return (MenuBarUI)this.ui;
    }

    public void setUI(MenuBarUI menuBarUI) {
        super.setUI(menuBarUI);
    }

    public void updateUI() {
        this.setUI((MenuBarUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public SingleSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(SingleSelectionModel singleSelectionModel) {
        SingleSelectionModel singleSelectionModel2 = this.selectionModel;
        this.selectionModel = singleSelectionModel;
        this.firePropertyChange("selectionModel", singleSelectionModel2, this.selectionModel);
    }

    public JMenu add(JMenu jMenu) {
        super.add(jMenu);
        return jMenu;
    }

    public JMenu getMenu(int n) {
        Component component = this.getComponentAtIndex(n);
        if (component instanceof JMenu) {
            return (JMenu)component;
        }
        return null;
    }

    public int getMenuCount() {
        return this.getComponentCount();
    }

    public void setHelpMenu(JMenu jMenu) {
        throw new Error("setHelpMenu() not yet implemented.");
    }

    public JMenu getHelpMenu() {
        throw new Error("getHelpMenu() not yet implemented.");
    }

    @Deprecated
    public Component getComponentAtIndex(int n) {
        if (n < 0 || n >= this.getComponentCount()) {
            return null;
        }
        return this.getComponent(n);
    }

    public int getComponentIndex(Component component) {
        int n = this.getComponentCount();
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < n; ++i) {
            Component component2 = componentArray[i];
            if (component2 != component) continue;
            return i;
        }
        return -1;
    }

    public void setSelected(Component component) {
        SingleSelectionModel singleSelectionModel = this.getSelectionModel();
        int n = this.getComponentIndex(component);
        singleSelectionModel.setSelectedIndex(n);
    }

    public boolean isSelected() {
        return this.selectionModel.isSelected();
    }

    public boolean isBorderPainted() {
        return this.paintBorder;
    }

    public void setBorderPainted(boolean bl) {
        boolean bl2 = this.paintBorder;
        this.paintBorder = bl;
        this.firePropertyChange("borderPainted", bl2, this.paintBorder);
        if (bl != bl2) {
            this.revalidate();
            this.repaint();
        }
    }

    protected void paintBorder(Graphics graphics) {
        if (this.isBorderPainted()) {
            super.paintBorder(graphics);
        }
    }

    public void setMargin(Insets insets) {
        Insets insets2 = this.margin;
        this.margin = insets;
        this.firePropertyChange("margin", insets2, insets);
        if (insets2 == null || !insets2.equals(insets)) {
            this.revalidate();
            this.repaint();
        }
    }

    public Insets getMargin() {
        if (this.margin == null) {
            return new Insets(0, 0, 0, 0);
        }
        return this.margin;
    }

    public void processMouseEvent(MouseEvent mouseEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
    }

    public void processKeyEvent(KeyEvent keyEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
    }

    public void menuSelectionChanged(boolean bl) {
    }

    public MenuElement[] getSubElements() {
        int n;
        Vector<Component> vector = new Vector<Component>();
        int n2 = this.getComponentCount();
        for (n = 0; n < n2; ++n) {
            Component component = this.getComponent(n);
            if (!(component instanceof MenuElement)) continue;
            vector.addElement(component);
        }
        MenuElement[] menuElementArray = new MenuElement[vector.size()];
        n2 = vector.size();
        for (n = 0; n < n2; ++n) {
            menuElementArray[n] = (MenuElement)vector.elementAt(n);
        }
        return menuElementArray;
    }

    public Component getComponent() {
        return this;
    }

    protected String paramString() {
        String string = this.paintBorder ? "true" : "false";
        String string2 = this.margin != null ? this.margin.toString() : "";
        return super.paramString() + ",margin=" + string2 + ",paintBorder=" + string;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJMenuBar();
        }
        return this.accessibleContext;
    }

    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        boolean bl2 = super.processKeyBinding(keyStroke, keyEvent, n, bl);
        if (!bl2) {
            MenuElement[] menuElementArray = this.getSubElements();
            for (int i = 0; i < menuElementArray.length; ++i) {
                if (!JMenuBar.processBindingForKeyStrokeRecursive(menuElementArray[i], keyStroke, keyEvent, n, bl)) continue;
                return true;
            }
        }
        return bl2;
    }

    static boolean processBindingForKeyStrokeRecursive(MenuElement menuElement, KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        if (menuElement == null) {
            return false;
        }
        Component component = menuElement.getComponent();
        if (!component.isVisible() && !(component instanceof JPopupMenu) || !component.isEnabled()) {
            return false;
        }
        if (component != null && component instanceof JComponent && ((JComponent)component).processKeyBinding(keyStroke, keyEvent, n, bl)) {
            return true;
        }
        MenuElement[] menuElementArray = menuElement.getSubElements();
        for (int i = 0; i < menuElementArray.length; ++i) {
            if (!JMenuBar.processBindingForKeyStrokeRecursive(menuElementArray[i], keyStroke, keyEvent, n, bl)) continue;
            return true;
        }
        return false;
    }

    public void addNotify() {
        super.addNotify();
        KeyboardManager.getCurrentManager().registerMenuBar(this);
    }

    public void removeNotify() {
        super.removeNotify();
        KeyboardManager.getCurrentManager().unregisterMenuBar(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
        Object[] objectArray = new Object[4];
        int n = 0;
        if (this.selectionModel instanceof Serializable) {
            objectArray[n++] = "selectionModel";
            objectArray[n++] = this.selectionModel;
        }
        objectOutputStream.writeObject(objectArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Object[] objectArray = (Object[])objectInputStream.readObject();
        for (int i = 0; i < objectArray.length && objectArray[i] != null; i += 2) {
            if (!objectArray[i].equals("selectionModel")) continue;
            this.selectionModel = (SingleSelectionModel)objectArray[i + 1];
        }
    }

    protected class AccessibleJMenuBar
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection {
        protected AccessibleJMenuBar() {
            super(JMenuBar.this);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            return accessibleStateSet;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU_BAR;
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public int getAccessibleSelectionCount() {
            if (JMenuBar.this.isSelected()) {
                return 1;
            }
            return 0;
        }

        public Accessible getAccessibleSelection(int n) {
            if (JMenuBar.this.isSelected()) {
                if (n != 0) {
                    return null;
                }
                int n2 = JMenuBar.this.getSelectionModel().getSelectedIndex();
                if (JMenuBar.this.getComponentAtIndex(n2) instanceof Accessible) {
                    return (Accessible)((Object)JMenuBar.this.getComponentAtIndex(n2));
                }
            }
            return null;
        }

        public boolean isAccessibleChildSelected(int n) {
            return n == JMenuBar.this.getSelectionModel().getSelectedIndex();
        }

        public void addAccessibleSelection(int n) {
            JMenu jMenu;
            int n2 = JMenuBar.this.getSelectionModel().getSelectedIndex();
            if (n == n2) {
                return;
            }
            if (n2 >= 0 && n2 < JMenuBar.this.getMenuCount() && (jMenu = JMenuBar.this.getMenu(n2)) != null) {
                MenuSelectionManager.defaultManager().setSelectedPath(null);
            }
            JMenuBar.this.getSelectionModel().setSelectedIndex(n);
            jMenu = JMenuBar.this.getMenu(n);
            if (jMenu != null) {
                MenuElement[] menuElementArray = new MenuElement[]{JMenuBar.this, jMenu, jMenu.getPopupMenu()};
                MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
            }
        }

        public void removeAccessibleSelection(int n) {
            if (n >= 0 && n < JMenuBar.this.getMenuCount()) {
                JMenu jMenu = JMenuBar.this.getMenu(n);
                if (jMenu != null) {
                    MenuSelectionManager.defaultManager().setSelectedPath(null);
                }
                JMenuBar.this.getSelectionModel().setSelectedIndex(-1);
            }
        }

        public void clearAccessibleSelection() {
            JMenu jMenu;
            int n = JMenuBar.this.getSelectionModel().getSelectedIndex();
            if (n >= 0 && n < JMenuBar.this.getMenuCount() && (jMenu = JMenuBar.this.getMenu(n)) != null) {
                MenuSelectionManager.defaultManager().setSelectedPath(null);
            }
            JMenuBar.this.getSelectionModel().setSelectedIndex(-1);
        }

        public void selectAllAccessibleSelection() {
        }
    }
}

