/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.demo;

import com.jrefinery.data.AbstractSeriesDataset;
import com.jrefinery.data.DomainInfo;
import com.jrefinery.data.Range;
import com.jrefinery.data.RangeInfo;
import com.jrefinery.data.XYDataset;

public class SampleXYDataset2
extends AbstractSeriesDataset
implements XYDataset,
DomainInfo,
RangeInfo {
    private static final int SERIES_COUNT = 4;
    private static final int ITEM_COUNT = 100;
    private static final double RANGE = 200.0;
    private Double[][] xValues = new Double[4][100];
    private Double[][] yValues = new Double[4][100];
    private Number domainMin;
    private Number domainMax;
    private Number rangeMin;
    private Number rangeMax;
    private Range domainRange;
    private Range range;

    public SampleXYDataset2() {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        int n = 0;
        while (n < 4) {
            int n2 = 0;
            while (n2 < 100) {
                double d5 = (Math.random() - 0.5) * 200.0;
                this.xValues[n][n2] = new Double(d5);
                if (d5 < d) {
                    d = d5;
                }
                if (d5 > d2) {
                    d2 = d5;
                }
                double d6 = (Math.random() + 0.5) * 6.0 * d5 + d5;
                this.yValues[n][n2] = new Double(d6);
                if (d6 < d3) {
                    d3 = d6;
                }
                if (d6 > d4) {
                    d4 = d6;
                }
                ++n2;
            }
            ++n;
        }
        this.domainMin = new Double(d);
        this.domainMax = new Double(d2);
        this.domainRange = new Range(d, d2);
        this.rangeMin = new Double(d3);
        this.rangeMax = new Double(d4);
        this.range = new Range(d3, d4);
    }

    public Number getXValue(int n, int n2) {
        return this.xValues[n][n2];
    }

    public Number getYValue(int n, int n2) {
        return this.yValues[n][n2];
    }

    public int getSeriesCount() {
        return 4;
    }

    public String getSeriesName(int n) {
        return "Sample " + n;
    }

    public int getItemCount(int n) {
        return 100;
    }

    public Number getMinimumDomainValue() {
        return this.domainMin;
    }

    public Number getMaximumDomainValue() {
        return this.domainMax;
    }

    public Range getDomainRange() {
        return this.domainRange;
    }

    public Number getMinimumRangeValue() {
        return this.rangeMin;
    }

    public Number getMaximumRangeValue() {
        return this.rangeMax;
    }

    public Range getValueRange() {
        return this.range;
    }
}

