/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: passwd.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: hr $ $Date: 2007/06/27 23:14:59 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sfx2.hxx"

// Include ---------------------------------------------------------------

#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif
#ifndef GCC
#endif

#include <sfx2/passwd.hxx>
#include "sfxtypes.hxx"
#include "sfxresid.hxx"

#include "dialog.hrc"
#include "passwd.hrc"

// -----------------------------------------------------------------------

#if (SUPD < 555)
void SfxPasswordDialog::SetConfirm()
{
	SetText( maConfirmStr );
	maPasswordED.SetText( String() );
	maPasswordED.GrabFocus();
}
#endif

// -----------------------------------------------------------------------

IMPL_LINK_INLINE_START( SfxPasswordDialog, EditModifyHdl, Edit *, EMPTYARG )
{
	maOKBtn.Enable( maPasswordED.GetText().Len() >= mnMinLen );
	return 0;
}
IMPL_LINK_INLINE_END( SfxPasswordDialog, EditModifyHdl, Edit *, EMPTYARG )

// -----------------------------------------------------------------------

IMPL_LINK( SfxPasswordDialog, OKHdl, OKButton *, EMPTYARG )
{
	if ( ( ( mnExtras & SHOWEXTRAS_CONFIRM ) == SHOWEXTRAS_CONFIRM ) &&
		 ( GetConfirm() != GetPassword() ) )
	{
		ErrorBox aBox( this, SfxResId( MSG_ERROR_WRONG_CONFIRM ) );
		aBox.Execute();
		maConfirmED.SetText( String() );
		maConfirmED.GrabFocus();
	}
	else
		EndDialog( RET_OK );
	return 0;
}

// CTOR / DTOR -----------------------------------------------------------

SfxPasswordDialog::SfxPasswordDialog( Window* pParent, const String* pGroupText ) :

	ModalDialog( pParent, SfxResId ( DLG_PASSWD ) ),

	maUserFT		( this, SfxResId( FT_PASSWD_USER ) ),
	maUserED		( this, SfxResId( ED_PASSWD_USER ) ),
	maPasswordFT	( this, SfxResId( FT_PASSWD_PASSWORD ) ),
	maPasswordED	( this, SfxResId( ED_PASSWD_PASSWORD ) ),
	maConfirmFT		( this, SfxResId( FT_PASSWD_CONFIRM ) ),
	maConfirmED		( this, SfxResId( ED_PASSWD_CONFIRM ) ),
	maPasswordBox	( this, SfxResId( GB_PASSWD_PASSWORD ) ),
	maOKBtn			( this, SfxResId( BTN_PASSWD_OK ) ),
	maCancelBtn		( this, SfxResId( BTN_PASSWD_CANCEL ) ),
	maHelpBtn		( this, SfxResId( BTN_PASSWD_HELP ) ),
	maConfirmStr	( 		SfxResId( STR_PASSWD_CONFIRM ) ),

	mnMinLen		( 5 ),
	mnExtras		( 0 )

{
	FreeResource();

	Link aLink = LINK( this, SfxPasswordDialog, EditModifyHdl );
	maPasswordED.SetModifyHdl( aLink );
	aLink = LINK( this, SfxPasswordDialog, OKHdl );
	maOKBtn.SetClickHdl( aLink );

	if ( pGroupText )
		  maPasswordBox.SetText( *pGroupText );
}

// -----------------------------------------------------------------------

void SfxPasswordDialog::SetMinLen( USHORT nLen )
{
	mnMinLen = nLen;
	EditModifyHdl( NULL );
}

// -----------------------------------------------------------------------

short SfxPasswordDialog::Execute()
{
	if ( mnExtras < SHOWEXTRAS_ALL )
	{
		Size a3Size = LogicToPixel( Size( 3, 3 ), MAP_APPFONT );
		Size a6Size = LogicToPixel( Size( 6, 6 ), MAP_APPFONT );
		long nMinHeight = maHelpBtn.GetPosPixel().Y() +
						  maHelpBtn.GetSizePixel().Height() + a6Size.Height();
		USHORT nRowHided = 1;

		if ( SHOWEXTRAS_NONE == mnExtras )
		{
			maUserFT.Hide();
			maUserED.Hide();
			maConfirmFT.Hide();
			maConfirmED.Hide();
			maPasswordFT.Hide();

			Point aPos = maUserFT.GetPosPixel();
			long nEnd = maUserED.GetPosPixel().X() + maUserED.GetSizePixel().Width();
			maPasswordED.SetPosPixel( aPos );
			Size aSize = maPasswordED.GetSizePixel();
			aSize.Width() = nEnd - aPos.X();
			maPasswordED.SetSizePixel( aSize );

			nRowHided = 2;
		}
		else if ( SHOWEXTRAS_USER == mnExtras )
		{
			maConfirmFT.Hide();
			maConfirmED.Hide();
		}
		else if ( SHOWEXTRAS_CONFIRM == mnExtras )
		{
			maUserFT.Hide();
			maUserED.Hide();

			Point aPwdPos1 = maPasswordFT.GetPosPixel();
			Point aPwdPos2 = maPasswordED.GetPosPixel();

			Point aPos = maUserFT.GetPosPixel();
			maPasswordFT.SetPosPixel( aPos );
			aPos = maUserED.GetPosPixel();
			maPasswordED.SetPosPixel( aPos );

			maConfirmFT.SetPosPixel( aPwdPos1 );
			maConfirmED.SetPosPixel( aPwdPos2 );
		}

		Size aBoxSize = maPasswordBox.GetSizePixel();
		aBoxSize.Height() -= ( nRowHided * maUserED.GetSizePixel().Height() );
		aBoxSize.Height() -= ( nRowHided * a3Size.Height() );
		maPasswordBox.SetSizePixel( aBoxSize );

		long nDlgHeight = maPasswordBox.GetPosPixel().Y() + aBoxSize.Height() + a6Size.Height();
		if ( nDlgHeight < nMinHeight )
			nDlgHeight = nMinHeight;
		Size aDlgSize = GetOutputSizePixel();
		aDlgSize.Height() = nDlgHeight;
		SetOutputSizePixel( aDlgSize );
	}

	return ModalDialog::Execute();
}


