/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: salsound.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: vg $ $Date: 2007/03/26 14:40:21 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_vcl.hxx"

#define INCLUDE_MMSYSTEM

// ------------
// - Includes -
// ------------

#ifndef _SVWIN_H
#include <tools/svwin.h>
#endif

#ifndef _SV_SALDATA_HXX
#include <saldata.hxx>
#endif
#ifndef _SV_SALINST_H
#include <salinst.h>
#endif
#ifndef _SV_SALSOUND_H
#include <salsound.h>
#endif

// ---------
// - Names -
// ---------

#define SOUND_LIBNAME		"WINMM.DLL"
#define SOUND_PROCNAMEA 	"mciSendCommandA"
#define SOUND_PROCNAMEW 	"mciSendCommandW"
#define SOUND_WINDOWCLASSA	"SALSOUNDWND"
#define SOUND_WINDOWCLASSW	L"SALSOUNDWND"

// ------------
// - Fnc cast -
// ------------

#define __MCI_CALL __stdcall

#define MCIFNC ((DWORD( __MCI_CALL * )( UINT, UINT, DWORD, DWORD )) WinSalSound::mpMCIFnc)

// -----------------
// - Statics init. -
// -----------------

oslModule	WinSalSound::mhMCILib = 0;
ULONG		WinSalSound::mnSoundState = SOUND_STATE_UNLOADED;
void*		WinSalSound::mpMCIFnc = NULL;

// -------------------
// - Window-Callback -
// -------------------

void ImplSalHandleMCINotify( HWND hWnd, WPARAM nPar1, LPARAM )
{
	SoundNotification	eNotification = SOUND_NOTIFY_SUCCESS;
	BOOL				bNotify = TRUE;

	switch ( nPar1 )
	{
		case( MCI_NOTIFY_SUCCESSFUL ):
			eNotification = SOUND_NOTIFY_SUCCESS;
			break;

		case( MCI_NOTIFY_ABORTED ):
			eNotification = SOUND_NOTIFY_ABORTED;
			break;

		case( MCI_NOTIFY_FAILURE ):
			eNotification = SOUND_NOTIFY_ERROR;
			break;

		default:
			bNotify = FALSE;
	}

	if ( bNotify )
		((WinSalSound*)GetWindowLong( hWnd, 0 ) )->ImplNotify( eNotification, 0 );
}

LRESULT CALLBACK SalSoundWndProcA( HWND hWnd, UINT nMsg, WPARAM nPar1, LPARAM nPar2 )
{
	if ( MM_MCINOTIFY == nMsg )
		ImplSalHandleMCINotify( hWnd, nPar1, nPar2 );
	return DefWindowProcA( hWnd, nMsg, nPar1, nPar2 );
}

LRESULT CALLBACK SalSoundWndProcW( HWND hWnd, UINT nMsg, WPARAM nPar1, LPARAM nPar2 )
{
	if ( MM_MCINOTIFY == nMsg )
		ImplSalHandleMCINotify( hWnd, nPar1, nPar2 );
	return DefWindowProcW( hWnd, nMsg, nPar1, nPar2 );
}

// ------------
// - SalSound -
// ------------

WinSalSound::WinSalSound() :
	mhSoundWnd		( 0 ),
	mnDeviceId		( 0 ),
	mbLoop			( FALSE ),
	mbPaused		( FALSE )
{
}

// ------------------------------------------------------------------------

WinSalSound::~WinSalSound()
{
	Stop();

	if ( mnDeviceId )
	{
		// close device
		MCI_GENERIC_PARMS aGenericParams;
		aGenericParams.dwCallback = (DWORD) mhSoundWnd;
		MCIFNC( mnDeviceId, MCI_CLOSE, MCI_WAIT, (DWORD)&aGenericParams );
	}

	// Call Destroy in the main thread, because Create is also called in
	// the main thread and if we don't call this also in the main thread
	// windows doesn't destroy the window
	WinSalInstance* pInst = GetSalData()->mpFirstInstance;
	if ( pInst )
	{
		ImplSendMessage( pInst->mhComWnd, SAL_MSG_DESTROYSOUND,
						 0, (LPARAM)this );
	}
	else
		ImplDestroy();
}

// ------------------------------------------------------------------------

void WinSalSound::ImplSetError( DWORD nMciErr )
{
	struct aMapper { DWORD nMci; ULONG nSv; };

	ULONG			nError = SOUNDERR_GENERAL_ERROR;
	static aMapper	aErrArr[] =
	{
		{ 0, SOUNDERR_SUCCESS },
		{ MCIERR_CANNOT_LOAD_DRIVER, SOUNDERR_CANNOT_LOAD_DRIVER },
		{ MCIERR_DEVICE_LOCKED, SOUNDERR_DEVICE_LOCKED },
		{ MCIERR_DEVICE_NOT_INSTALLED, SOUNDERR_DEVICE_NOT_FOUND },
		{ MCIERR_DEVICE_NOT_READY, SOUNDERR_DEVICE_NOT_READY },
		{ MCIERR_DEVICE_TYPE_REQUIRED, SOUNDERR_DEVICE_NOT_FOUND },
		{ MCIERR_DRIVER, SOUNDERR_CANNOT_LOAD_DRIVER },
		{ MCIERR_DRIVER_INTERNAL, SOUNDERR_CANNOT_LOAD_DRIVER  },
		{ MCIERR_EXTENSION_NOT_FOUND, SOUNDERR_SOUND_NOT_FOUND },
		{ MCIERR_FILE_NOT_FOUND, SOUNDERR_SOUND_NOT_FOUND },
		{ MCIERR_FILE_READ, SOUNDERR_CANNOT_READ_SOUND },
		{ MCIERR_FILENAME_REQUIRED, SOUNDERR_SOUND_NOT_FOUND },
		{ MCIERR_HARDWARE, SOUNDERR_HARDWARE_ERROR },
		{ MCIERR_INVALID_DEVICE_NAME, SOUNDERR_DEVICE_NOT_FOUND },
		{ MCIERR_INVALID_FILE, SOUNDERR_INVALID_FILE },
		{ MCIERR_OUT_OF_MEMORY, SOUNDERR_OUT_OF_MEMORY },
		{ MCIERR_UNSUPPORTED_FUNCTION, SOUNDERR_UNSUPPORTED_FUNCTION }
	};

	for ( USHORT n=0; n < (sizeof( aErrArr ) / sizeof( aMapper ) ); n++ )
	{
		if ( aErrArr[ n ].nMci == nMciErr )
		{
			nError = aErrArr[ n ].nSv;
			break;
		}
	}

	if ( nError )
		ImplNotify( SOUND_NOTIFY_ERROR, nError );
}

// ------------------------------------------------------------------------

void WinSalSound::ImplNotify( SoundNotification eNotification, ULONG nError )
{
	if ( mbLoop && (SOUND_NOTIFY_SUCCESS == eNotification) && !nError )
		Play( mnStartTime, mnPlayLen, TRUE );

    CallNotifyProc( eNotification, nError );
}

// ------------------------------------------------------------------------

bool WinSalSound::ImplCreate()
{
	SalData*	pData = GetSalData();
	bool		bRet = FALSE;

	if ( SOUND_STATE_UNLOADED == WinSalSound::mnSoundState )
	{
		// load library and init fncpointer
		if ( aSalShlData.mbWNT )
		{
            OUString aLibraryName( RTL_CONSTASCII_USTRINGPARAM( SOUND_LIBNAME ) );
            OUString queryFuncName( RTL_CONSTASCII_USTRINGPARAM( SOUND_PROCNAMEW ) );
            if ( (WinSalSound::mhMCILib = osl_loadModule( aLibraryName.pData, SAL_LOADMODULE_DEFAULT )) != 0 &&
				 (WinSalSound::mpMCIFnc = (void*)osl_getSymbol( WinSalSound::mhMCILib, queryFuncName.pData )) != 0 )
			{
				WNDCLASSEXW aWndClass;

				memset( &aWndClass, 0, sizeof( aWndClass ) );
				aWndClass.cbSize		= sizeof( aWndClass );
				aWndClass.lpfnWndProc	= SalSoundWndProcW;
				aWndClass.cbWndExtra	= sizeof( SalSound* );
				aWndClass.hInstance 	= pData->mhInst;
				aWndClass.lpszClassName = SOUND_WINDOWCLASSW;
				if ( RegisterClassExW( &aWndClass ) )
				{
					WinSalSound::mnSoundState = SOUND_STATE_VALID;
					bRet = TRUE;
				}
			}
		}
		else
		{
            OUString aLibraryName( RTL_CONSTASCII_USTRINGPARAM( SOUND_LIBNAME ) );
            OUString queryFuncName( RTL_CONSTASCII_USTRINGPARAM( SOUND_PROCNAMEA ) );
            if ( (WinSalSound::mhMCILib = osl_loadModule( aLibraryName.pData, SAL_LOADMODULE_DEFAULT )) != 0 &&
				 (WinSalSound::mpMCIFnc = (void*)osl_getSymbol( WinSalSound::mhMCILib, queryFuncName.pData )) != 0 )
			{
				WNDCLASSEXA aWndClass;

				memset( &aWndClass, 0, sizeof( aWndClass ) );
				aWndClass.cbSize		= sizeof( aWndClass );
				aWndClass.lpfnWndProc	= SalSoundWndProcA;
				aWndClass.cbWndExtra	= sizeof( SalSound* );
				aWndClass.hInstance 	= pData->mhInst;
				aWndClass.lpszClassName = SOUND_WINDOWCLASSA;
				if ( RegisterClassExA( &aWndClass ) )
				{
					WinSalSound::mnSoundState = SOUND_STATE_VALID;
					bRet = TRUE;
				}
			}
		}

		if ( !bRet )
		{
			if ( WinSalSound::mhMCILib )
            {
				osl_unloadModule( WinSalSound::mhMCILib );
                WinSalSound::mhMCILib = NULL;
            }

			WinSalSound::mnSoundState = SOUND_STATE_INVALID;
			ImplNotify( SOUND_NOTIFY_ERROR, SOUNDERR_CANNOT_LOAD_DRIVER );
		}
	}
	else if ( SOUND_STATE_VALID == WinSalSound::mnSoundState )
		bRet = TRUE;

	if ( bRet )
	{
		// Create message window
		if ( aSalShlData.mbWNT )
		{
			mhSoundWnd = CreateWindowExW( 0, SOUND_WINDOWCLASSW, L"", 0, 0, 0, 0, 0,
										  HWND_DESKTOP, NULL, pData->mhInst, 0 );
		}
		else
		{
			mhSoundWnd = CreateWindowExA( 0, SOUND_WINDOWCLASSA, "", 0, 0, 0, 0, 0,
										  HWND_DESKTOP, NULL, pData->mhInst, 0 );
		}
		SetWindowLong( mhSoundWnd, 0, (LONG)this );
	}
	else
		mhSoundWnd = 0;

	return bRet;
}

// ------------------------------------------------------------------------

bool WinSalSound::IsValid()
{
	// Call Create in the main thread, because in the other case the
	// Sound stop, if the calling thread dies.
	WinSalInstance* pInst = GetSalData()->mpFirstInstance;
	if ( pInst )
	{
		return (BOOL)ImplSendMessage( pInst->mhComWnd, SAL_MSG_CREATESOUND,
									  0, (LPARAM)this );
	}
	else
		return ImplCreate();
}

// ------------------------------------------------------------------------

void WinSalSound::ImplDestroy()
{
	if ( mhSoundWnd )
		DestroyWindow( mhSoundWnd );
	mhSoundWnd = 0;
}

// ------------------------------------------------------------------------

void WinSalSound::Release()
{
	// free library
	if ( WinSalSound::mhMCILib )
    {
		osl_unloadModule( WinSalSound::mhMCILib );
        WinSalSound::mhMCILib = NULL;
    }

	WinSalSound::mnSoundState = SOUND_STATE_UNLOADED;
}

// ------------------------------------------------------------------------

bool WinSalSound::Init( const XubString& rSoundName, ULONG& rSoundLen )
{
	DWORD nMciErr = 0;
	rSoundLen = 0;

	// clear old device
	if ( mnDeviceId )
	{
		Stop();

		MCI_GENERIC_PARMS aGenericParams;
		aGenericParams.dwCallback = (DWORD) mhSoundWnd;
		nMciErr = MCIFNC( mnDeviceId, MCI_CLOSE, MCI_WAIT, (DWORD) &aGenericParams );
		mnDeviceId = 0;
	}

	if ( rSoundName.Len() )
	{
		UINT nDeviceId;
		if ( aSalShlData.mbWNT )
		{
			MCI_OPEN_PARMSW aOpenParams;
			aOpenParams.dwCallback = (DWORD)mhSoundWnd;
			aOpenParams.lpstrElementName =  reinterpret_cast<LPCWSTR>(rSoundName.GetBuffer());
			aOpenParams.wDeviceID = 0;
			aOpenParams.lpstrDeviceType = 0;
			aOpenParams.lpstrAlias = 0;
			nMciErr = MCIFNC( 0, MCI_OPEN, MCI_WAIT | MCI_OPEN_ELEMENT, (DWORD)&aOpenParams );
			nDeviceId = aOpenParams.wDeviceID;
		}
		else
		{
			ByteString aSoundName( ImplSalGetWinAnsiString( rSoundName, TRUE ) );
			MCI_OPEN_PARMSA aOpenParams;
			aOpenParams.dwCallback = (DWORD)mhSoundWnd;
			aOpenParams.lpstrElementName = aSoundName.GetBuffer();
			aOpenParams.wDeviceID = 0;
			aOpenParams.lpstrDeviceType = 0;
			aOpenParams.lpstrAlias = 0;
			nMciErr = MCIFNC( 0, MCI_OPEN, MCI_WAIT | MCI_OPEN_ELEMENT, (DWORD)&aOpenParams );
			nDeviceId = aOpenParams.wDeviceID;
		}

		if ( !nMciErr )
		{
			// set time format
			MCI_SET_PARMS aSetParams;
			mnDeviceId = nDeviceId;
			aSetParams.dwTimeFormat = MCI_FORMAT_MILLISECONDS;
			nMciErr = MCIFNC( mnDeviceId, MCI_SET, MCI_WAIT | MCI_SET_TIME_FORMAT, (DWORD)&aSetParams );

			if ( !nMciErr )
			{
				// get length of sound
				MCI_STATUS_PARMS aStatus;
				aStatus.dwItem = MCI_STATUS_LENGTH;
				nMciErr = MCIFNC( mnDeviceId, MCI_STATUS, MCI_WAIT | MCI_STATUS_ITEM, (DWORD)&aStatus );

				if ( !nMciErr )
					rSoundLen = (ULONG)aStatus.dwReturn;
			}
		}
	}

	if ( nMciErr )
		ImplSetError( nMciErr );

	return (nMciErr ? false : true);
}

// ------------------------------------------------------------------------

void WinSalSound::Play( ULONG nStartTime, ULONG nPlayLen, bool bLoop )
{
	if ( mnDeviceId )
	{
		DWORD nMciErr = 0;

		if ( !mbPaused )
		{
			MCI_SEEK_PARMS aSeekParams;
			aSeekParams.dwCallback = (DWORD) mhSoundWnd;
			aSeekParams.dwTo = 0;
			nMciErr = MCIFNC( mnDeviceId, MCI_SEEK,MCI_WAIT | MCI_TO, (DWORD) &aSeekParams );
		}

		mnStartTime = nStartTime;
		mnPlayLen = nPlayLen;
		mbLoop = bLoop;
		mbPaused = false;

		if( !nMciErr )
		{
			MCI_PLAY_PARMS	aPlayParams;
			DWORD			nFlags = MCI_NOTIFY;

			aPlayParams.dwCallback = (DWORD)mhSoundWnd;

			if ( nStartTime )
			{
				aPlayParams.dwFrom = nStartTime;
				nFlags |= MCI_FROM;
			}

			if ( nPlayLen != SOUND_PLAYALL )
			{
				aPlayParams.dwTo = nStartTime + nPlayLen;
				nFlags |= MCI_TO;
			}

			nMciErr = MCIFNC( mnDeviceId, MCI_PLAY, nFlags, (DWORD) &aPlayParams );

			if ( !nMciErr )
				mbPaused = FALSE;
		}

		if ( nMciErr )
			ImplSetError( nMciErr );
	}
	else
		ImplSetError( MCIERR_INVALID_FILE );
}

// ------------------------------------------------------------------------

void WinSalSound::Stop()
{
	if ( mnDeviceId )
	{
		MCI_GENERIC_PARMS aGenericParams;
		aGenericParams.dwCallback = (DWORD)mhSoundWnd;
		mbLoop = mbPaused = false;
		MCIFNC( mnDeviceId, MCI_STOP, MCI_WAIT, (DWORD) &aGenericParams );
	}
}

// ------------------------------------------------------------------------

void WinSalSound::Pause()
{
	if ( mnDeviceId )
	{
		MCI_GENERIC_PARMS aGenericParams;
		aGenericParams.dwCallback = (DWORD)mhSoundWnd;
		mbPaused = true;
		MCIFNC( mnDeviceId, MCI_PAUSE, MCI_WAIT, (DWORD) &aGenericParams );
	}
}

// ------------------------------------------------------------------------

void WinSalSound::Continue()
{
    Play( 0, 0, mbLoop );
}

// ------------------------------------------------------------------------

bool WinSalSound::IsLoopMode() const
{
    return mbLoop;
}

// ------------------------------------------------------------------------

bool WinSalSound::IsPlaying() const
{
    return !mbPaused;
}

// ------------------------------------------------------------------------

bool WinSalSound::IsPaused() const
{
    return mbPaused;
}
