/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.security.provider.certpath.DistributionPointFetcher;
import sun.security.provider.certpath.LDAPCertStore;
import sun.security.provider.certpath.State;
import sun.security.util.Debug;
import sun.security.x509.AccessDescription;
import sun.security.x509.GeneralNameInterface;
import sun.security.x509.GeneralNames;
import sun.security.x509.GeneralSubtrees;
import sun.security.x509.NameConstraintsExtension;
import sun.security.x509.SubjectAlternativeNameExtension;
import sun.security.x509.URIName;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Builder {
    private static final Debug debug = Debug.getInstance("certpath");
    final PKIXBuilderParameters buildParams;
    final X500Principal targetSubjectDN;
    static final boolean USE_AIA = DistributionPointFetcher.getBooleanProperty("com.sun.security.enableAIAcaIssuers", false);

    Builder(PKIXBuilderParameters pKIXBuilderParameters, X500Principal x500Principal) {
        this.buildParams = pKIXBuilderParameters;
        this.targetSubjectDN = x500Principal;
    }

    abstract Collection<X509Certificate> getMatchingCerts(State var1, List<CertStore> var2) throws CertStoreException, CertificateException, IOException;

    abstract void verifyCert(X509Certificate var1, State var2, List<X509Certificate> var3) throws GeneralSecurityException;

    abstract boolean isPathCompleted(X509Certificate var1);

    abstract void addCertToPath(X509Certificate var1, LinkedList<X509Certificate> var2);

    abstract void removeFinalCertFromPath(LinkedList<X509Certificate> var1);

    static int distance(GeneralNameInterface generalNameInterface, GeneralNameInterface generalNameInterface2) throws IOException {
        switch (generalNameInterface.constrains(generalNameInterface2)) {
            case -1: {
                throw new IOException("Names are different types");
            }
            case 3: {
                throw new IOException("Names are same type but in different subtrees");
            }
            case 0: {
                return 0;
            }
            case 2: {
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new IOException("Unknown name relationship");
            }
        }
        return generalNameInterface2.subtreeDepth() - generalNameInterface.subtreeDepth();
    }

    static int hops(GeneralNameInterface generalNameInterface, GeneralNameInterface generalNameInterface2) throws IOException {
        int n = generalNameInterface.constrains(generalNameInterface2);
        switch (n) {
            case -1: {
                throw new IOException("Names are different types");
            }
            case 3: {
                break;
            }
            case 0: {
                return 0;
            }
            case 2: {
                return generalNameInterface2.subtreeDepth() - generalNameInterface.subtreeDepth();
            }
            case 1: {
                return generalNameInterface2.subtreeDepth() - generalNameInterface.subtreeDepth();
            }
            default: {
                throw new IOException("Unknown name relationship");
            }
        }
        if (generalNameInterface.getType() != 4) {
            throw new IOException("hopDistance not implemented for this name type");
        }
        X500Name x500Name = (X500Name)generalNameInterface;
        X500Name x500Name2 = (X500Name)generalNameInterface2;
        X500Name x500Name3 = x500Name.commonAncestor(x500Name2);
        if (x500Name3 == null) {
            throw new IOException("Names are in different namespaces");
        }
        int n2 = x500Name3.subtreeDepth();
        int n3 = x500Name.subtreeDepth();
        int n4 = x500Name2.subtreeDepth();
        return n3 + n4 - 2 * n2;
    }

    static int targetDistance(NameConstraintsExtension nameConstraintsExtension, X509Certificate x509Certificate, GeneralNameInterface generalNameInterface) throws IOException {
        Object object;
        X509CertImpl x509CertImpl;
        if (nameConstraintsExtension != null && !nameConstraintsExtension.verify(x509Certificate)) {
            throw new IOException("certificate does not satisfy existing name constraints");
        }
        try {
            x509CertImpl = X509CertImpl.toImpl(x509Certificate);
        }
        catch (CertificateException certificateException) {
            throw (IOException)new IOException("Invalid certificate").initCause(certificateException);
        }
        X500Name x500Name = X500Name.asX500Name(x509CertImpl.getSubjectX500Principal());
        if (x500Name.equals(generalNameInterface)) {
            return 0;
        }
        SubjectAlternativeNameExtension subjectAlternativeNameExtension = x509CertImpl.getSubjectAlternativeNameExtension();
        if (subjectAlternativeNameExtension != null) {
            object = (GeneralNames)subjectAlternativeNameExtension.get("subject_name");
            if (object != null) {
                int n = ((GeneralNames)object).size();
                for (int i = 0; i < n; ++i) {
                    GeneralNameInterface generalNameInterface2 = ((GeneralNames)object).get(i).getName();
                    if (!generalNameInterface2.equals(generalNameInterface)) continue;
                    return 0;
                }
            }
        }
        if ((object = x509CertImpl.getNameConstraintsExtension()) == null) {
            return -1;
        }
        if (nameConstraintsExtension != null) {
            nameConstraintsExtension.merge((NameConstraintsExtension)object);
        } else {
            nameConstraintsExtension = (NameConstraintsExtension)((NameConstraintsExtension)object).clone();
        }
        if (debug != null) {
            debug.println("Builder.targetDistance() merged constraints: " + String.valueOf(nameConstraintsExtension));
        }
        GeneralSubtrees generalSubtrees = (GeneralSubtrees)nameConstraintsExtension.get("permitted_subtrees");
        GeneralSubtrees generalSubtrees2 = (GeneralSubtrees)nameConstraintsExtension.get("excluded_subtrees");
        if (generalSubtrees != null) {
            generalSubtrees.reduce(generalSubtrees2);
        }
        if (debug != null) {
            debug.println("Builder.targetDistance() reduced constraints: " + generalSubtrees);
        }
        if (!nameConstraintsExtension.verify(generalNameInterface)) {
            throw new IOException("New certificate not allowed to sign certificate for target");
        }
        if (generalSubtrees == null) {
            return -1;
        }
        int n = generalSubtrees.size();
        for (int i = 0; i < n; ++i) {
            GeneralNameInterface generalNameInterface3 = generalSubtrees.get(i).getName().getName();
            try {
                int n2 = Builder.distance(generalNameInterface3, generalNameInterface);
                if (n2 < 0) continue;
                return n2 + 1;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return -1;
    }

    Set<String> getMatchingPolicies() {
        Set<String> set = this.buildParams.getInitialPolicies();
        if (!set.isEmpty() && !set.contains("2.5.29.32.0") && this.buildParams.isPolicyMappingInhibited()) {
            set.add("2.5.29.32.0");
            return set;
        }
        return new HashSet<String>();
    }

    void addMatchingCerts(X509CertSelector x509CertSelector, Collection<CertStore> collection, Collection<X509Certificate> collection2, boolean bl) {
        X509Certificate x509Certificate = x509CertSelector.getCertificate();
        if (x509Certificate != null) {
            if (x509CertSelector.match(x509Certificate) && !X509CertImpl.isSelfSigned(x509Certificate, this.buildParams.getSigProvider())) {
                collection2.add(x509Certificate);
            }
            if (debug != null) {
                debug.println("Builder.addMatchingCerts: adding target cert");
            }
            return;
        }
        for (CertStore certStore : collection) {
            try {
                Collection<? extends Certificate> collection3 = certStore.getCertificates(x509CertSelector);
                for (X509Certificate x509Certificate2 : collection3) {
                    if (X509CertImpl.isSelfSigned(x509Certificate2, this.buildParams.getSigProvider())) continue;
                    collection2.add(x509Certificate2);
                }
                if (bl || collection2.isEmpty()) continue;
                return;
            }
            catch (CertStoreException certStoreException) {
                if (debug == null) continue;
                debug.println("Builder.addMatchingCerts, non-fatal exception retrieving certs: " + certStoreException);
                certStoreException.printStackTrace();
            }
        }
    }

    static CertStore createCertStore(AccessDescription accessDescription) {
        if (!accessDescription.getAccessMethod().equals(AccessDescription.Ad_CAISSUERS_Id)) {
            return null;
        }
        GeneralNameInterface generalNameInterface = accessDescription.getAccessLocation().getName();
        if (!(generalNameInterface instanceof URIName)) {
            return null;
        }
        URI uRI = ((URIName)generalNameInterface).getURI();
        if (debug != null) {
            debug.println("AIA URI:" + uRI);
        }
        if (!uRI.getScheme().equals("ldap")) {
            return null;
        }
        try {
            return LDAPCertStore.getInstance(LDAPCertStore.getParameters(uRI));
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.println("Builder.createCertStore(AccessDescription): non-fatal exception creating CertStore: " + exception);
            }
            return null;
        }
    }

    static boolean isLocalCertStore(CertStore certStore) {
        return certStore.getType().equals("Collection") || certStore.getCertStoreParameters() instanceof CollectionCertStoreParameters;
    }
}

