/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal;

import sun.org.mozilla.javascript.internal.Context;
import sun.org.mozilla.javascript.internal.IdFunctionObject;
import sun.org.mozilla.javascript.internal.IdScriptableObject;
import sun.org.mozilla.javascript.internal.RegExpProxy;
import sun.org.mozilla.javascript.internal.ScriptRuntime;
import sun.org.mozilla.javascript.internal.Scriptable;
import sun.org.mozilla.javascript.internal.Undefined;

final class NativeString
extends IdScriptableObject {
    static final long serialVersionUID = 920268368584188687L;
    private static final Object STRING_TAG = new Object();
    private static final int Id_length = 1;
    private static final int MAX_INSTANCE_ID = 1;
    private static final int ConstructorId_fromCharCode = -1;
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toSource = 3;
    private static final int Id_valueOf = 4;
    private static final int Id_charAt = 5;
    private static final int Id_charCodeAt = 6;
    private static final int Id_indexOf = 7;
    private static final int Id_lastIndexOf = 8;
    private static final int Id_split = 9;
    private static final int Id_substring = 10;
    private static final int Id_toLowerCase = 11;
    private static final int Id_toUpperCase = 12;
    private static final int Id_substr = 13;
    private static final int Id_concat = 14;
    private static final int Id_slice = 15;
    private static final int Id_bold = 16;
    private static final int Id_italics = 17;
    private static final int Id_fixed = 18;
    private static final int Id_strike = 19;
    private static final int Id_small = 20;
    private static final int Id_big = 21;
    private static final int Id_blink = 22;
    private static final int Id_sup = 23;
    private static final int Id_sub = 24;
    private static final int Id_fontsize = 25;
    private static final int Id_fontcolor = 26;
    private static final int Id_link = 27;
    private static final int Id_anchor = 28;
    private static final int Id_equals = 29;
    private static final int Id_equalsIgnoreCase = 30;
    private static final int Id_match = 31;
    private static final int Id_search = 32;
    private static final int Id_replace = 33;
    private static final int MAX_PROTOTYPE_ID = 33;
    private String string;

    static void init(Scriptable scriptable, boolean bl) {
        NativeString nativeString = new NativeString("");
        nativeString.exportAsJSClass(33, scriptable, bl);
    }

    private NativeString(String string) {
        this.string = string;
    }

    public String getClassName() {
        return "String";
    }

    protected int getMaxInstanceId() {
        return 1;
    }

    protected int findInstanceIdInfo(String string) {
        if (string.equals("length")) {
            return NativeString.instanceIdInfo(7, 1);
        }
        return super.findInstanceIdInfo(string);
    }

    protected String getInstanceIdName(int n) {
        if (n == 1) {
            return "length";
        }
        return super.getInstanceIdName(n);
    }

    protected Object getInstanceIdValue(int n) {
        if (n == 1) {
            return ScriptRuntime.wrapInt(this.string.length());
        }
        return super.getInstanceIdValue(n);
    }

    protected void fillConstructorProperties(IdFunctionObject idFunctionObject) {
        this.addIdFunctionProperty(idFunctionObject, STRING_TAG, -1, "fromCharCode", 1);
        super.fillConstructorProperties(idFunctionObject);
    }

    protected void initPrototypeId(int n) {
        String string;
        int n2;
        switch (n) {
            case 1: {
                n2 = 1;
                string = "constructor";
                break;
            }
            case 2: {
                n2 = 0;
                string = "toString";
                break;
            }
            case 3: {
                n2 = 0;
                string = "toSource";
                break;
            }
            case 4: {
                n2 = 0;
                string = "valueOf";
                break;
            }
            case 5: {
                n2 = 1;
                string = "charAt";
                break;
            }
            case 6: {
                n2 = 1;
                string = "charCodeAt";
                break;
            }
            case 7: {
                n2 = 1;
                string = "indexOf";
                break;
            }
            case 8: {
                n2 = 1;
                string = "lastIndexOf";
                break;
            }
            case 9: {
                n2 = 2;
                string = "split";
                break;
            }
            case 10: {
                n2 = 2;
                string = "substring";
                break;
            }
            case 11: {
                n2 = 0;
                string = "toLowerCase";
                break;
            }
            case 12: {
                n2 = 0;
                string = "toUpperCase";
                break;
            }
            case 13: {
                n2 = 2;
                string = "substr";
                break;
            }
            case 14: {
                n2 = 1;
                string = "concat";
                break;
            }
            case 15: {
                n2 = 2;
                string = "slice";
                break;
            }
            case 16: {
                n2 = 0;
                string = "bold";
                break;
            }
            case 17: {
                n2 = 0;
                string = "italics";
                break;
            }
            case 18: {
                n2 = 0;
                string = "fixed";
                break;
            }
            case 19: {
                n2 = 0;
                string = "strike";
                break;
            }
            case 20: {
                n2 = 0;
                string = "small";
                break;
            }
            case 21: {
                n2 = 0;
                string = "big";
                break;
            }
            case 22: {
                n2 = 0;
                string = "blink";
                break;
            }
            case 23: {
                n2 = 0;
                string = "sup";
                break;
            }
            case 24: {
                n2 = 0;
                string = "sub";
                break;
            }
            case 25: {
                n2 = 0;
                string = "fontsize";
                break;
            }
            case 26: {
                n2 = 0;
                string = "fontcolor";
                break;
            }
            case 27: {
                n2 = 0;
                string = "link";
                break;
            }
            case 28: {
                n2 = 0;
                string = "anchor";
                break;
            }
            case 29: {
                n2 = 1;
                string = "equals";
                break;
            }
            case 30: {
                n2 = 1;
                string = "equalsIgnoreCase";
                break;
            }
            case 31: {
                n2 = 1;
                string = "match";
                break;
            }
            case 32: {
                n2 = 1;
                string = "search";
                break;
            }
            case 33: {
                n2 = 1;
                string = "replace";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(STRING_TAG, n, string, n2);
    }

    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(STRING_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        switch (n) {
            case -1: {
                int n2 = objectArray.length;
                if (n2 < 1) {
                    return "";
                }
                StringBuffer stringBuffer = new StringBuffer(n2);
                for (int i = 0; i != n2; ++i) {
                    stringBuffer.append(ScriptRuntime.toUint16(objectArray[i]));
                }
                return stringBuffer.toString();
            }
            case 1: {
                String string;
                String string2 = string = objectArray.length >= 1 ? ScriptRuntime.toString(objectArray[0]) : "";
                if (scriptable2 == null) {
                    return new NativeString(string);
                }
                return string;
            }
            case 2: 
            case 4: {
                return NativeString.realThis((Scriptable)scriptable2, (IdFunctionObject)idFunctionObject).string;
            }
            case 3: {
                String string = NativeString.realThis((Scriptable)scriptable2, (IdFunctionObject)idFunctionObject).string;
                return "(new String(\"" + ScriptRuntime.escapeString(string) + "\"))";
            }
            case 5: 
            case 6: {
                String string = ScriptRuntime.toString(scriptable2);
                double d = ScriptRuntime.toInteger(objectArray, 0);
                if (d < 0.0 || d >= (double)string.length()) {
                    if (n == 5) {
                        return "";
                    }
                    return ScriptRuntime.NaNobj;
                }
                char c = string.charAt((int)d);
                if (n == 5) {
                    return String.valueOf(c);
                }
                return ScriptRuntime.wrapInt(c);
            }
            case 7: {
                return ScriptRuntime.wrapInt(NativeString.js_indexOf(ScriptRuntime.toString(scriptable2), objectArray));
            }
            case 8: {
                return ScriptRuntime.wrapInt(NativeString.js_lastIndexOf(ScriptRuntime.toString(scriptable2), objectArray));
            }
            case 9: {
                return NativeString.js_split(context, scriptable, ScriptRuntime.toString(scriptable2), objectArray);
            }
            case 10: {
                return NativeString.js_substring(context, ScriptRuntime.toString(scriptable2), objectArray);
            }
            case 11: {
                return ScriptRuntime.toString(scriptable2).toLowerCase();
            }
            case 12: {
                return ScriptRuntime.toString(scriptable2).toUpperCase();
            }
            case 13: {
                return NativeString.js_substr(ScriptRuntime.toString(scriptable2), objectArray);
            }
            case 14: {
                return NativeString.js_concat(ScriptRuntime.toString(scriptable2), objectArray);
            }
            case 15: {
                return NativeString.js_slice(ScriptRuntime.toString(scriptable2), objectArray);
            }
            case 16: {
                return NativeString.tagify(scriptable2, "b", null, null);
            }
            case 17: {
                return NativeString.tagify(scriptable2, "i", null, null);
            }
            case 18: {
                return NativeString.tagify(scriptable2, "tt", null, null);
            }
            case 19: {
                return NativeString.tagify(scriptable2, "strike", null, null);
            }
            case 20: {
                return NativeString.tagify(scriptable2, "small", null, null);
            }
            case 21: {
                return NativeString.tagify(scriptable2, "big", null, null);
            }
            case 22: {
                return NativeString.tagify(scriptable2, "blink", null, null);
            }
            case 23: {
                return NativeString.tagify(scriptable2, "sup", null, null);
            }
            case 24: {
                return NativeString.tagify(scriptable2, "sub", null, null);
            }
            case 25: {
                return NativeString.tagify(scriptable2, "font", "size", objectArray);
            }
            case 26: {
                return NativeString.tagify(scriptable2, "font", "color", objectArray);
            }
            case 27: {
                return NativeString.tagify(scriptable2, "a", "href", objectArray);
            }
            case 28: {
                return NativeString.tagify(scriptable2, "a", "name", objectArray);
            }
            case 29: 
            case 30: {
                String string = ScriptRuntime.toString(scriptable2);
                String string3 = ScriptRuntime.toString(objectArray, 0);
                return ScriptRuntime.wrapBoolean(n == 29 ? string.equals(string3) : string.equalsIgnoreCase(string3));
            }
            case 31: 
            case 32: 
            case 33: {
                int n3 = n == 31 ? 1 : (n == 32 ? 3 : 2);
                return ScriptRuntime.checkRegExpProxy(context).action(context, scriptable, scriptable2, objectArray, n3);
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    private static NativeString realThis(Scriptable scriptable, IdFunctionObject idFunctionObject) {
        if (!(scriptable instanceof NativeString)) {
            throw NativeString.incompatibleCallError(idFunctionObject);
        }
        return (NativeString)scriptable;
    }

    private static String tagify(Object object, String string, String string2, Object[] objectArray) {
        String string3 = ScriptRuntime.toString(object);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('<');
        stringBuffer.append(string);
        if (string2 != null) {
            stringBuffer.append(' ');
            stringBuffer.append(string2);
            stringBuffer.append("=\"");
            stringBuffer.append(ScriptRuntime.toString(objectArray, 0));
            stringBuffer.append('\"');
        }
        stringBuffer.append('>');
        stringBuffer.append(string3);
        stringBuffer.append("</");
        stringBuffer.append(string);
        stringBuffer.append('>');
        return stringBuffer.toString();
    }

    public String toString() {
        return this.string;
    }

    public Object get(int n, Scriptable scriptable) {
        if (0 <= n && n < this.string.length()) {
            return this.string.substring(n, n + 1);
        }
        return super.get(n, scriptable);
    }

    public void put(int n, Scriptable scriptable, Object object) {
        if (0 <= n && n < this.string.length()) {
            return;
        }
        super.put(n, scriptable, object);
    }

    private static int js_indexOf(String string, Object[] objectArray) {
        String string2 = ScriptRuntime.toString(objectArray, 0);
        double d = ScriptRuntime.toInteger(objectArray, 1);
        if (d > (double)string.length()) {
            return -1;
        }
        if (d < 0.0) {
            d = 0.0;
        }
        return string.indexOf(string2, (int)d);
    }

    private static int js_lastIndexOf(String string, Object[] objectArray) {
        String string2 = ScriptRuntime.toString(objectArray, 0);
        double d = ScriptRuntime.toNumber(objectArray, 1);
        if (d != d || d > (double)string.length()) {
            d = string.length();
        } else if (d < 0.0) {
            d = 0.0;
        }
        return string.lastIndexOf(string2, (int)d);
    }

    private static int find_split(Context context, Scriptable scriptable, String string, String string2, int n, RegExpProxy regExpProxy, Scriptable scriptable2, int[] nArray, int[] nArray2, boolean[] blArray, String[][] stringArray) {
        int n2;
        int n3 = string.length();
        if (n == 120 && scriptable2 == null && string2.length() == 1 && string2.charAt(0) == ' ') {
            int n4;
            if (n2 == 0) {
                for (n2 = nArray[0]; n2 < n3 && Character.isWhitespace(string.charAt(n2)); ++n2) {
                }
                nArray[0] = n2;
            }
            if (n2 == n3) {
                return -1;
            }
            while (n2 < n3 && !Character.isWhitespace(string.charAt(n2))) {
                ++n2;
            }
            for (n4 = n2; n4 < n3 && Character.isWhitespace(string.charAt(n4)); ++n4) {
            }
            nArray2[0] = n4 - n2;
            return n2;
        }
        if (n2 > n3) {
            return -1;
        }
        if (scriptable2 != null) {
            return regExpProxy.find_split(context, scriptable, string, string2, scriptable2, nArray, nArray2, blArray, stringArray);
        }
        if (n != 0 && n < 130 && n3 == 0) {
            return -1;
        }
        if (string2.length() == 0) {
            if (n == 120) {
                if (n2 == n3) {
                    nArray2[0] = 1;
                    return n2;
                }
                return n2 + 1;
            }
            return n2 == n3 ? -1 : n2 + 1;
        }
        if (nArray[0] >= n3) {
            return n3;
        }
        n2 = string.indexOf(string2, nArray[0]);
        return n2 != -1 ? n2 : n3;
    }

    private static Object js_split(Context context, Scriptable scriptable, String string, Object[] objectArray) {
        int n;
        Object object;
        Scriptable scriptable2 = NativeString.getTopLevelScope(scriptable);
        Scriptable scriptable3 = ScriptRuntime.newObject(context, scriptable2, "Array", null);
        if (objectArray.length < 1) {
            scriptable3.put(0, scriptable3, (Object)string);
            return scriptable3;
        }
        boolean bl = objectArray.length > 1 && objectArray[1] != Undefined.instance;
        long l = 0L;
        if (bl && (l = ScriptRuntime.toUint32(objectArray[1])) > (long)string.length()) {
            l = 1 + string.length();
        }
        String string2 = null;
        int[] nArray = new int[1];
        Object object2 = null;
        RegExpProxy regExpProxy = null;
        if (objectArray[0] instanceof Scriptable && (regExpProxy = ScriptRuntime.getRegExpProxy(context)) != null && regExpProxy.isRegExp((Scriptable)(object = (Object)((Scriptable)objectArray[0])))) {
            object2 = object;
        }
        if (object2 == null) {
            string2 = ScriptRuntime.toString(objectArray[0]);
            nArray[0] = string2.length();
        }
        object = new int[]{0};
        int n2 = 0;
        boolean[] blArray = new boolean[]{false};
        String[][] stringArray = new String[][]{null};
        int n3 = context.getLanguageVersion();
        while (!((n = NativeString.find_split(context, scriptable, string, string2, n3, regExpProxy, (Scriptable)object2, object, nArray, blArray, stringArray)) < 0 || bl && (long)n2 >= l || n > string.length())) {
            String string3 = string.length() == 0 ? string : string.substring(object[0], n);
            scriptable3.put(n2, scriptable3, (Object)string3);
            ++n2;
            if (object2 != null && blArray[0]) {
                int n4 = stringArray[0].length;
                for (int i = 0; !(i >= n4 || bl && (long)n2 >= l); ++i) {
                    scriptable3.put(n2, scriptable3, (Object)stringArray[0][i]);
                    ++n2;
                }
                blArray[0] = false;
            }
            object[0] = n + nArray[0];
            if (n3 >= 130 || n3 == 0 || bl || object[0] != string.length()) continue;
            break;
        }
        return scriptable3;
    }

    private static String js_substring(Context context, String string, Object[] objectArray) {
        double d;
        int n = string.length();
        double d2 = ScriptRuntime.toInteger(objectArray, 0);
        if (d2 < 0.0) {
            d2 = 0.0;
        } else if (d2 > (double)n) {
            d2 = n;
        }
        if (objectArray.length <= 1 || objectArray[1] == Undefined.instance) {
            d = n;
        } else {
            d = ScriptRuntime.toInteger(objectArray[1]);
            if (d < 0.0) {
                d = 0.0;
            } else if (d > (double)n) {
                d = n;
            }
            if (d < d2) {
                if (context.getLanguageVersion() != 120) {
                    double d3 = d2;
                    d2 = d;
                    d = d3;
                } else {
                    d = d2;
                }
            }
        }
        return string.substring((int)d2, (int)d);
    }

    int getLength() {
        return this.string.length();
    }

    private static String js_substr(String string, Object[] objectArray) {
        double d;
        if (objectArray.length < 1) {
            return string;
        }
        double d2 = ScriptRuntime.toInteger(objectArray[0]);
        int n = string.length();
        if (d2 < 0.0) {
            if ((d2 += (double)n) < 0.0) {
                d2 = 0.0;
            }
        } else if (d2 > (double)n) {
            d2 = n;
        }
        if (objectArray.length == 1) {
            d = n;
        } else {
            d = ScriptRuntime.toInteger(objectArray[1]);
            if (d < 0.0) {
                d = 0.0;
            }
            if ((d += d2) > (double)n) {
                d = n;
            }
        }
        return string.substring((int)d2, (int)d);
    }

    private static String js_concat(String string, Object[] objectArray) {
        int n = objectArray.length;
        if (n == 0) {
            return string;
        }
        if (n == 1) {
            String string2 = ScriptRuntime.toString(objectArray[0]);
            return string.concat(string2);
        }
        int n2 = string.length();
        String[] stringArray = new String[n];
        for (int i = 0; i != n; ++i) {
            String string3;
            stringArray[i] = string3 = ScriptRuntime.toString(objectArray[i]);
            n2 += string3.length();
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        stringBuffer.append(string);
        for (int i = 0; i != n; ++i) {
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    private static String js_slice(String string, Object[] objectArray) {
        if (objectArray.length != 0) {
            double d;
            double d2 = ScriptRuntime.toInteger(objectArray[0]);
            int n = string.length();
            if (d2 < 0.0) {
                if ((d2 += (double)n) < 0.0) {
                    d2 = 0.0;
                }
            } else if (d2 > (double)n) {
                d2 = n;
            }
            if (objectArray.length == 1) {
                d = n;
            } else {
                d = ScriptRuntime.toInteger(objectArray[1]);
                if (d < 0.0) {
                    if ((d += (double)n) < 0.0) {
                        d = 0.0;
                    }
                } else if (d > (double)n) {
                    d = n;
                }
                if (d < d2) {
                    d = d2;
                }
            }
            return string.substring((int)d2, (int)d);
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int findPrototypeId(String string) {
        int n = 0;
        String string2 = null;
        block0 : switch (string.length()) {
            case 3: {
                char c = string.charAt(2);
                if (c == 'b') {
                    if (string.charAt(0) != 's' || string.charAt(1) != 'u') break;
                    return 24;
                }
                if (c == 'g') {
                    if (string.charAt(0) != 'b' || string.charAt(1) != 'i') break;
                    return 21;
                }
                if (c != 'p' || string.charAt(0) != 's' || string.charAt(1) != 'u') break;
                return 23;
            }
            case 4: {
                char c = string.charAt(0);
                if (c == 'b') {
                    string2 = "bold";
                    n = 16;
                    break;
                }
                if (c != 'l') break;
                string2 = "link";
                n = 27;
                break;
            }
            case 5: {
                switch (string.charAt(4)) {
                    case 'd': {
                        string2 = "fixed";
                        n = 18;
                        break block0;
                    }
                    case 'e': {
                        string2 = "slice";
                        n = 15;
                        break block0;
                    }
                    case 'h': {
                        string2 = "match";
                        n = 31;
                        break block0;
                    }
                    case 'k': {
                        string2 = "blink";
                        n = 22;
                        break block0;
                    }
                    case 'l': {
                        string2 = "small";
                        n = 20;
                        break block0;
                    }
                    case 't': {
                        string2 = "split";
                        n = 9;
                        break block0;
                    }
                }
                break;
            }
            case 6: {
                switch (string.charAt(1)) {
                    case 'e': {
                        string2 = "search";
                        n = 32;
                        break block0;
                    }
                    case 'h': {
                        string2 = "charAt";
                        n = 5;
                        break block0;
                    }
                    case 'n': {
                        string2 = "anchor";
                        n = 28;
                        break block0;
                    }
                    case 'o': {
                        string2 = "concat";
                        n = 14;
                        break block0;
                    }
                    case 'q': {
                        string2 = "equals";
                        n = 29;
                        break block0;
                    }
                    case 't': {
                        string2 = "strike";
                        n = 19;
                        break block0;
                    }
                    case 'u': {
                        string2 = "substr";
                        n = 13;
                        break block0;
                    }
                }
                break;
            }
            case 7: {
                switch (string.charAt(1)) {
                    case 'a': {
                        string2 = "valueOf";
                        n = 4;
                        break block0;
                    }
                    case 'e': {
                        string2 = "replace";
                        n = 33;
                        break block0;
                    }
                    case 'n': {
                        string2 = "indexOf";
                        n = 7;
                        break block0;
                    }
                    case 't': {
                        string2 = "italics";
                        n = 17;
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                char c = string.charAt(4);
                if (c == 'r') {
                    string2 = "toString";
                    n = 2;
                    break;
                }
                if (c == 's') {
                    string2 = "fontsize";
                    n = 25;
                    break;
                }
                if (c != 'u') break;
                string2 = "toSource";
                n = 3;
                break;
            }
            case 9: {
                char c = string.charAt(0);
                if (c == 'f') {
                    string2 = "fontcolor";
                    n = 26;
                    break;
                }
                if (c != 's') break;
                string2 = "substring";
                n = 10;
                break;
            }
            case 10: {
                string2 = "charCodeAt";
                n = 6;
                break;
            }
            case 11: {
                switch (string.charAt(2)) {
                    case 'L': {
                        string2 = "toLowerCase";
                        n = 11;
                        break block0;
                    }
                    case 'U': {
                        string2 = "toUpperCase";
                        n = 12;
                        break block0;
                    }
                    case 'n': {
                        string2 = "constructor";
                        n = 1;
                        break block0;
                    }
                    case 's': {
                        string2 = "lastIndexOf";
                        n = 8;
                        break block0;
                    }
                }
                break;
            }
            case 16: {
                string2 = "equalsIgnoreCase";
                n = 30;
            }
        }
        if (string2 == null) return n;
        if (string2 == string) return n;
        if (string2.equals(string)) return n;
        return 0;
    }
}

