/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import sun.security.pkcs.ParsingException;
import sun.security.util.Debug;
import sun.security.util.ManifestDigester;
import sun.security.util.ManifestEntryVerifier;
import sun.security.util.SignatureFileVerifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JarVerifier {
    static final Debug debug = Debug.getInstance("jar");
    private Hashtable verifiedSigners;
    private Hashtable sigFileSigners;
    private Hashtable sigFileData;
    private ArrayList pendingBlocks;
    private ArrayList signerCache;
    private boolean parsingBlockOrSF = false;
    private boolean parsingMeta = true;
    private boolean anyToVerify = true;
    private ByteArrayOutputStream baos;
    private ManifestDigester manDig;
    byte[] manifestRawBytes = null;
    boolean eagerValidation;
    private Object csdomain = new Object();
    private List manifestDigests;
    private Map urlToCodeSourceMap = new HashMap();
    private Map signerToCodeSource = new HashMap();
    private URL lastURL;
    private Map lastURLMap;
    private CodeSigner[] emptySigner = new CodeSigner[0];
    private Map signerMap;
    private Enumeration emptyEnumeration = new Enumeration<String>(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public String nextElement() {
            throw new NoSuchElementException();
        }
    };
    private List jarCodeSigners;

    public JarVerifier(byte[] byArray) {
        this.manifestRawBytes = byArray;
        this.sigFileSigners = new Hashtable();
        this.verifiedSigners = new Hashtable();
        this.sigFileData = new Hashtable(11);
        this.pendingBlocks = new ArrayList();
        this.baos = new ByteArrayOutputStream();
        this.manifestDigests = new ArrayList();
    }

    public void beginEntry(JarEntry jarEntry, ManifestEntryVerifier manifestEntryVerifier) throws IOException {
        String string;
        if (jarEntry == null) {
            return;
        }
        if (debug != null) {
            debug.println("beginEntry " + jarEntry.getName());
        }
        String string2 = jarEntry.getName();
        if (this.parsingMeta && ((string = string2.toUpperCase(Locale.ENGLISH)).startsWith("META-INF/") || string.startsWith("/META-INF/"))) {
            if (jarEntry.isDirectory()) {
                manifestEntryVerifier.setEntry(null, jarEntry);
                return;
            }
            if (SignatureFileVerifier.isBlockOrSF(string)) {
                this.parsingBlockOrSF = true;
                this.baos.reset();
                manifestEntryVerifier.setEntry(null, jarEntry);
            }
            return;
        }
        if (this.parsingMeta) {
            this.doneWithMeta();
        }
        if (jarEntry.isDirectory()) {
            manifestEntryVerifier.setEntry(null, jarEntry);
            return;
        }
        if (string2.startsWith("./")) {
            string2 = string2.substring(2);
        }
        if (string2.startsWith("/")) {
            string2 = string2.substring(1);
        }
        if (this.sigFileSigners.get(string2) != null) {
            manifestEntryVerifier.setEntry(string2, jarEntry);
            return;
        }
        manifestEntryVerifier.setEntry(null, jarEntry);
    }

    public void update(int n, ManifestEntryVerifier manifestEntryVerifier) throws IOException {
        if (n != -1) {
            if (this.parsingBlockOrSF) {
                this.baos.write(n);
            } else {
                manifestEntryVerifier.update((byte)n);
            }
        } else {
            this.processEntry(manifestEntryVerifier);
        }
    }

    public void update(int n, byte[] byArray, int n2, int n3, ManifestEntryVerifier manifestEntryVerifier) throws IOException {
        if (n != -1) {
            if (this.parsingBlockOrSF) {
                this.baos.write(byArray, n2, n);
            } else {
                manifestEntryVerifier.update(byArray, n2, n);
            }
        } else {
            this.processEntry(manifestEntryVerifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void processEntry(ManifestEntryVerifier manifestEntryVerifier) throws IOException {
        if (!this.parsingBlockOrSF) {
            JarEntry jarEntry = manifestEntryVerifier.getEntry();
            if (jarEntry == null) return;
            if (jarEntry.signers != null) return;
            jarEntry.signers = manifestEntryVerifier.verify(this.verifiedSigners, this.sigFileSigners);
            jarEntry.certs = JarVerifier.mapSignersToCertArray(jarEntry.signers);
            return;
        }
        try {
            Object object;
            String string;
            this.parsingBlockOrSF = false;
            if (debug != null) {
                debug.println("processEntry: processing block");
            }
            if ((string = manifestEntryVerifier.getEntry().getName().toUpperCase(Locale.ENGLISH)).endsWith(".SF")) {
                String string2 = string.substring(0, string.length() - 3);
                byte[] byArray = this.baos.toByteArray();
                this.sigFileData.put(string2, byArray);
                Iterator iterator = this.pendingBlocks.iterator();
                while (iterator.hasNext()) {
                    SignatureFileVerifier signatureFileVerifier = (SignatureFileVerifier)iterator.next();
                    if (!signatureFileVerifier.needSignatureFile(string2)) continue;
                    if (debug != null) {
                        debug.println("processEntry: processing pending block");
                    }
                    signatureFileVerifier.setSignatureFile(byArray);
                    signatureFileVerifier.process(this.sigFileSigners, this.manifestDigests);
                }
                return;
            }
            String string3 = string.substring(0, string.lastIndexOf("."));
            if (this.signerCache == null) {
                this.signerCache = new ArrayList();
            }
            if (this.manDig == null) {
                object = this.manifestRawBytes;
                // MONITORENTER : this.manifestRawBytes
                if (this.manDig == null) {
                    this.manDig = new ManifestDigester(this.manifestRawBytes);
                    this.manifestRawBytes = null;
                }
                // MONITOREXIT : object
            }
            if (((SignatureFileVerifier)(object = (Object)new SignatureFileVerifier(this.signerCache, this.manDig, string, this.baos.toByteArray()))).needSignatureFileBytes()) {
                byte[] byArray = (byte[])this.sigFileData.get(string3);
                if (byArray == null) {
                    if (debug != null) {
                        debug.println("adding pending block");
                    }
                    this.pendingBlocks.add(object);
                    return;
                }
                ((SignatureFileVerifier)object).setSignatureFile(byArray);
            }
            ((SignatureFileVerifier)object).process(this.sigFileSigners, this.manifestDigests);
            return;
        }
        catch (ParsingException parsingException) {
            if (debug == null) return;
            debug.println("processEntry caught: " + parsingException);
            return;
        }
        catch (IOException iOException) {
            if (debug == null) return;
            debug.println("processEntry caught: " + iOException);
            return;
        }
        catch (SignatureException signatureException) {
            if (debug == null) return;
            debug.println("processEntry caught: " + signatureException);
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (debug == null) return;
            debug.println("processEntry caught: " + noSuchAlgorithmException);
            return;
        }
        catch (CertificateException certificateException) {
            if (debug == null) return;
            debug.println("processEntry caught: " + certificateException);
        }
    }

    public Certificate[] getCerts(String string) {
        return JarVerifier.mapSignersToCertArray(this.getCodeSigners(string));
    }

    public Certificate[] getCerts(JarFile jarFile, JarEntry jarEntry) {
        return JarVerifier.mapSignersToCertArray(this.getCodeSigners(jarFile, jarEntry));
    }

    public CodeSigner[] getCodeSigners(String string) {
        return (CodeSigner[])this.verifiedSigners.get(string);
    }

    public CodeSigner[] getCodeSigners(JarFile jarFile, JarEntry jarEntry) {
        String string = jarEntry.getName();
        if (this.eagerValidation && this.sigFileSigners.get(string) != null) {
            try {
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                byte[] byArray = new byte[1024];
                int n = byArray.length;
                while (n != -1) {
                    n = inputStream.read(byArray, 0, byArray.length);
                }
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.getCodeSigners(string);
    }

    private static Certificate[] mapSignersToCertArray(CodeSigner[] codeSignerArray) {
        if (codeSignerArray != null) {
            ArrayList<? extends Certificate> arrayList = new ArrayList<Certificate>();
            for (int i = 0; i < codeSignerArray.length; ++i) {
                arrayList.addAll(codeSignerArray[i].getSignerCertPath().getCertificates());
            }
            return arrayList.toArray(new Certificate[arrayList.size()]);
        }
        return null;
    }

    boolean nothingToVerify() {
        return !this.anyToVerify;
    }

    void doneWithMeta() {
        this.parsingMeta = false;
        this.anyToVerify = !this.sigFileSigners.isEmpty();
        this.baos = null;
        this.sigFileData = null;
        this.pendingBlocks = null;
        this.signerCache = null;
        this.manDig = null;
    }

    private synchronized CodeSource mapSignersToCodeSource(URL uRL, CodeSigner[] codeSignerArray) {
        Map map;
        if (uRL == this.lastURL) {
            map = this.lastURLMap;
        } else {
            map = (Map)this.urlToCodeSourceMap.get(uRL);
            if (map == null) {
                map = new HashMap();
                this.urlToCodeSourceMap.put(uRL, map);
            }
            this.lastURLMap = map;
            this.lastURL = uRL;
        }
        CodeSource codeSource = (CodeSource)map.get(codeSignerArray);
        if (codeSource == null) {
            codeSource = new VerifierCodeSource(this.csdomain, uRL, codeSignerArray);
            this.signerToCodeSource.put(codeSignerArray, codeSource);
        }
        return codeSource;
    }

    private CodeSource[] mapSignersToCodeSources(URL uRL, List list, boolean bl) {
        ArrayList<CodeSource> arrayList = new ArrayList<CodeSource>();
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(this.mapSignersToCodeSource(uRL, (CodeSigner[])list.get(i)));
        }
        if (bl) {
            arrayList.add(this.mapSignersToCodeSource(uRL, null));
        }
        return arrayList.toArray(new CodeSource[arrayList.size()]);
    }

    private CodeSigner[] findMatchingSigners(CodeSource codeSource) {
        int n;
        CodeSource[] codeSourceArray;
        if (codeSource instanceof VerifierCodeSource && (codeSourceArray = (CodeSource[])codeSource).isSameDomain(this.csdomain)) {
            return ((VerifierCodeSource)codeSource).getPrivateSigners();
        }
        codeSourceArray = this.mapSignersToCodeSources(codeSource.getLocation(), this.getJarCodeSigners(), true);
        ArrayList<CodeSource> arrayList = new ArrayList<CodeSource>();
        for (n = 0; n < codeSourceArray.length; ++n) {
            arrayList.add(codeSourceArray[n]);
        }
        n = arrayList.indexOf(codeSource);
        if (n != -1) {
            CodeSigner[] codeSignerArray = ((VerifierCodeSource)arrayList.get(n)).getPrivateSigners();
            if (codeSignerArray == null) {
                codeSignerArray = this.emptySigner;
            }
            return codeSignerArray;
        }
        return null;
    }

    private synchronized Map signerMap() {
        if (this.signerMap == null) {
            this.signerMap = new HashMap(this.verifiedSigners.size() + this.sigFileSigners.size());
            this.signerMap.putAll(this.verifiedSigners);
            this.signerMap.putAll(this.sigFileSigners);
        }
        return this.signerMap;
    }

    public synchronized Enumeration<String> entryNames(JarFile jarFile, CodeSource[] codeSourceArray) {
        Object object;
        Map map = this.signerMap();
        final Iterator iterator = map.entrySet().iterator();
        boolean bl = false;
        ArrayList<CodeSigner[]> arrayList = new ArrayList<CodeSigner[]>(codeSourceArray.length);
        for (int i = 0; i < codeSourceArray.length; ++i) {
            object = this.findMatchingSigners(codeSourceArray[i]);
            if (object == null) continue;
            if (((CodeSigner[])object).length > 0) {
                arrayList.add((CodeSigner[])object);
                continue;
            }
            bl = true;
        }
        final ArrayList<CodeSigner[]> arrayList2 = arrayList;
        object = bl ? this.unsignedEntryNames(jarFile) : this.emptyEnumeration;
        return new Enumeration<String>((Enumeration)object){
            String name;
            final /* synthetic */ Enumeration val$enum2;
            {
                this.val$enum2 = enumeration;
            }

            @Override
            public boolean hasMoreElements() {
                if (this.name != null) {
                    return true;
                }
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    if (!arrayList2.contains((CodeSigner[])entry.getValue())) continue;
                    this.name = (String)entry.getKey();
                    return true;
                }
                if (this.val$enum2.hasMoreElements()) {
                    this.name = (String)this.val$enum2.nextElement();
                    return true;
                }
                return false;
            }

            @Override
            public String nextElement() {
                if (this.hasMoreElements()) {
                    String string = this.name;
                    this.name = null;
                    return string;
                }
                throw new NoSuchElementException();
            }
        };
    }

    public Enumeration<JarEntry> entries2(final JarFile jarFile, Enumeration enumeration) {
        final HashMap hashMap = new HashMap();
        hashMap.putAll(this.signerMap());
        final Enumeration enumeration2 = enumeration;
        return new Enumeration<JarEntry>(){
            Enumeration signers = null;
            JarEntry entry;

            @Override
            public boolean hasMoreElements() {
                Object object;
                if (this.entry != null) {
                    return true;
                }
                while (enumeration2.hasMoreElements()) {
                    object = (ZipEntry)enumeration2.nextElement();
                    if (JarVerifier.isSigningRelated(((ZipEntry)object).getName())) continue;
                    this.entry = jarFile.newEntry((ZipEntry)object);
                    return true;
                }
                if (this.signers == null) {
                    this.signers = Collections.enumeration(hashMap.keySet());
                }
                if (this.signers.hasMoreElements()) {
                    object = (String)this.signers.nextElement();
                    this.entry = jarFile.newEntry(new ZipEntry((String)object));
                    return true;
                }
                return false;
            }

            @Override
            public JarEntry nextElement() {
                if (this.hasMoreElements()) {
                    JarEntry jarEntry = this.entry;
                    hashMap.remove(jarEntry.getName());
                    this.entry = null;
                    return jarEntry;
                }
                throw new NoSuchElementException();
            }
        };
    }

    static boolean isSigningRelated(String string) {
        if (!(string = string.toUpperCase(Locale.ENGLISH)).startsWith("META-INF/")) {
            return false;
        }
        if ((string = string.substring(9)).indexOf(47) != -1) {
            return false;
        }
        return string.endsWith(".DSA") || string.endsWith(".RSA") || string.endsWith(".SF") || string.endsWith(".EC") || string.startsWith("SIG-") || string.equals("MANIFEST.MF");
    }

    private Enumeration<String> unsignedEntryNames(JarFile jarFile) {
        final Map map = this.signerMap();
        final Enumeration<JarEntry> enumeration = jarFile.entries();
        return new Enumeration<String>(){
            String name;

            @Override
            public boolean hasMoreElements() {
                if (this.name != null) {
                    return true;
                }
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
                    String string = zipEntry.getName();
                    if (zipEntry.isDirectory() || JarVerifier.isSigningRelated(string) || map.get(string) != null) continue;
                    this.name = string;
                    return true;
                }
                return false;
            }

            @Override
            public String nextElement() {
                if (this.hasMoreElements()) {
                    String string = this.name;
                    this.name = null;
                    return string;
                }
                throw new NoSuchElementException();
            }
        };
    }

    private synchronized List getJarCodeSigners() {
        if (this.jarCodeSigners == null) {
            HashSet hashSet = new HashSet();
            hashSet.addAll(this.signerMap().values());
            this.jarCodeSigners = new ArrayList();
            this.jarCodeSigners.addAll(hashSet);
        }
        return this.jarCodeSigners;
    }

    public synchronized CodeSource[] getCodeSources(JarFile jarFile, URL uRL) {
        boolean bl = this.unsignedEntryNames(jarFile).hasMoreElements();
        return this.mapSignersToCodeSources(uRL, this.getJarCodeSigners(), bl);
    }

    public CodeSource getCodeSource(URL uRL, String string) {
        CodeSigner[] codeSignerArray = (CodeSigner[])this.signerMap().get(string);
        return this.mapSignersToCodeSource(uRL, codeSignerArray);
    }

    public CodeSource getCodeSource(URL uRL, JarFile jarFile, JarEntry jarEntry) {
        return this.mapSignersToCodeSource(uRL, this.getCodeSigners(jarFile, jarEntry));
    }

    public void setEagerValidation(boolean bl) {
        this.eagerValidation = bl;
    }

    public synchronized List getManifestDigests() {
        return Collections.unmodifiableList(this.manifestDigests);
    }

    static CodeSource getUnsignedCS(URL uRL) {
        return new VerifierCodeSource(null, uRL, (Certificate[])null);
    }

    private static class VerifierCodeSource
    extends CodeSource {
        URL vlocation;
        CodeSigner[] vsigners;
        Certificate[] vcerts;
        Object csdomain;

        VerifierCodeSource(Object object, URL uRL, CodeSigner[] codeSignerArray) {
            super(uRL, codeSignerArray);
            this.csdomain = object;
            this.vlocation = uRL;
            this.vsigners = codeSignerArray;
        }

        VerifierCodeSource(Object object, URL uRL, Certificate[] certificateArray) {
            super(uRL, certificateArray);
            this.csdomain = object;
            this.vlocation = uRL;
            this.vcerts = certificateArray;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof VerifierCodeSource) {
                VerifierCodeSource verifierCodeSource = (VerifierCodeSource)object;
                if (this.isSameDomain(verifierCodeSource.csdomain)) {
                    if (verifierCodeSource.vsigners != this.vsigners || verifierCodeSource.vcerts != this.vcerts) {
                        return false;
                    }
                    if (verifierCodeSource.vlocation != null) {
                        return verifierCodeSource.vlocation.equals(this.vlocation);
                    }
                    if (this.vlocation != null) {
                        return this.vlocation.equals(verifierCodeSource.vlocation);
                    }
                    return true;
                }
            }
            return super.equals(object);
        }

        boolean isSameDomain(Object object) {
            return this.csdomain == object;
        }

        private CodeSigner[] getPrivateSigners() {
            return this.vsigners;
        }

        private Certificate[] getPrivateCertificates() {
            return this.vcerts;
        }
    }

    static class VerifierStream
    extends InputStream {
        private InputStream is;
        private JarVerifier jv;
        private ManifestEntryVerifier mev;
        private long numLeft;

        VerifierStream(Manifest manifest, JarEntry jarEntry, InputStream inputStream, JarVerifier jarVerifier) throws IOException {
            this.is = inputStream;
            this.jv = jarVerifier;
            this.mev = new ManifestEntryVerifier(manifest);
            this.jv.beginEntry(jarEntry, this.mev);
            this.numLeft = jarEntry.getSize();
            if (this.numLeft == 0L) {
                this.jv.update(-1, this.mev);
            }
        }

        public int read() throws IOException {
            if (this.numLeft > 0L) {
                int n = this.is.read();
                this.jv.update(n, this.mev);
                --this.numLeft;
                if (this.numLeft == 0L) {
                    this.jv.update(-1, this.mev);
                }
                return n;
            }
            return -1;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.numLeft > 0L && this.numLeft < (long)n2) {
                n2 = (int)this.numLeft;
            }
            if (this.numLeft > 0L) {
                int n3 = this.is.read(byArray, n, n2);
                this.jv.update(n3, byArray, n, n2, this.mev);
                this.numLeft -= (long)n3;
                if (this.numLeft == 0L) {
                    this.jv.update(-1, byArray, n, n2, this.mev);
                }
                return n3;
            }
            return -1;
        }

        public void close() throws IOException {
            if (this.is != null) {
                this.is.close();
            }
            this.is = null;
            this.mev = null;
            this.jv = null;
        }

        public int available() throws IOException {
            return this.is.available();
        }
    }
}

