/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Component;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthBorder;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLabelUI;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import sun.swing.plaf.synth.SynthUI;
import sun.swing.table.DefaultTableCellHeaderRenderer;

class SynthTableHeaderUI
extends BasicTableHeaderUI
implements PropertyChangeListener,
SynthUI {
    private TableCellRenderer prevRenderer = null;
    private SynthStyle style;

    SynthTableHeaderUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthTableHeaderUI();
    }

    protected void installDefaults() {
        this.prevRenderer = this.header.getDefaultRenderer();
        if (this.prevRenderer instanceof UIResource) {
            this.header.setDefaultRenderer(new HeaderRenderer());
        }
        this.updateStyle(this.header);
    }

    private void updateStyle(JTableHeader jTableHeader) {
        SynthContext synthContext = this.getContext(jTableHeader, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle && synthStyle != null) {
            this.uninstallKeyboardActions();
            this.installKeyboardActions();
        }
        synthContext.dispose();
    }

    protected void installListeners() {
        super.installListeners();
        this.header.addPropertyChangeListener(this);
    }

    protected void uninstallDefaults() {
        if (this.header.getDefaultRenderer() instanceof HeaderRenderer) {
            this.header.setDefaultRenderer(this.prevRenderer);
        }
        SynthContext synthContext = this.getContext(this.header, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
    }

    protected void uninstallListeners() {
        this.header.removePropertyChangeListener(this);
        super.uninstallListeners();
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        synthContext.getPainter().paintTableHeaderBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        super.paint(graphics, synthContext.getComponent());
    }

    public void paintBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        synthContext.getPainter().paintTableHeaderBorder(synthContext, graphics, n, n2, n3, n4);
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateStyle((JTableHeader)propertyChangeEvent.getSource());
        }
    }

    protected void rolloverColumnUpdated(int n, int n2) {
        this.header.repaint(this.header.getHeaderRect(n));
        this.header.repaint(this.header.getHeaderRect(n2));
    }

    private class HeaderRenderer
    extends DefaultTableCellHeaderRenderer {
        HeaderRenderer() {
            this.setHorizontalAlignment(10);
            this.setName("TableHeader.renderer");
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            block8: {
                block7: {
                    List<RowSorter.SortKey> list;
                    boolean bl3;
                    boolean bl4 = bl3 = n2 == SynthTableHeaderUI.this.getRolloverColumn();
                    if (bl || bl3 || bl2) {
                        SynthLookAndFeel.setSelectedUI((SynthLabelUI)SynthLookAndFeel.getUIOfType(this.getUI(), SynthLabelUI.class), bl, bl2, jTable.isEnabled(), bl3);
                    } else {
                        SynthLookAndFeel.resetSelectedUI();
                    }
                    RowSorter<? extends TableModel> rowSorter = jTable == null ? null : jTable.getRowSorter();
                    List<RowSorter.SortKey> list2 = list = rowSorter == null ? null : rowSorter.getSortKeys();
                    if (list == null || list.size() <= 0 || list.get(0).getColumn() != jTable.convertColumnIndexToModel(n2)) break block7;
                    switch (list.get(0).getSortOrder()) {
                        case ASCENDING: {
                            this.putClientProperty("Table.sortOrder", "ASCENDING");
                            break block8;
                        }
                        case DESCENDING: {
                            this.putClientProperty("Table.sortOrder", "DESCENDING");
                            break block8;
                        }
                        case UNSORTED: {
                            this.putClientProperty("Table.sortOrder", "UNSORTED");
                            break block8;
                        }
                        default: {
                            throw new AssertionError((Object)"Cannot happen");
                        }
                    }
                }
                this.putClientProperty("Table.sortOrder", "UNSORTED");
            }
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            return this;
        }

        public void setBorder(Border border) {
            if (border instanceof SynthBorder) {
                super.setBorder(border);
            }
        }
    }
}

