/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import com.sun.beans.ObjectHandler;
import java.beans.ExceptionListener;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import sun.reflect.misc.ConstructorUtil;
import sun.reflect.misc.MethodUtil;
import sun.reflect.misc.ReflectUtil;

class ReflectionUtils {
    private static Reference methodCacheRef;

    ReflectionUtils() {
    }

    public static Class typeToClass(Class clazz) {
        return clazz.isPrimitive() ? ObjectHandler.typeNameToClass(clazz.getName()) : clazz;
    }

    public static boolean isPrimitive(Class clazz) {
        return ReflectionUtils.primitiveTypeFor(clazz) != null;
    }

    public static Class primitiveTypeFor(Class clazz) {
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        if (clazz == Byte.class) {
            return Byte.TYPE;
        }
        if (clazz == Character.class) {
            return Character.TYPE;
        }
        if (clazz == Short.class) {
            return Short.TYPE;
        }
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        if (clazz == Void.class) {
            return Void.TYPE;
        }
        return null;
    }

    private static boolean matchArguments(Class[] classArray, Class[] classArray2) {
        return ReflectionUtils.matchArguments(classArray, classArray2, false);
    }

    private static boolean matchExplicitArguments(Class[] classArray, Class[] classArray2) {
        return ReflectionUtils.matchArguments(classArray, classArray2, true);
    }

    private static boolean matchArguments(Class[] classArray, Class[] classArray2, boolean bl) {
        boolean bl2 = classArray.length == classArray2.length;
        for (int i = 0; i < classArray.length && bl2; ++i) {
            Class clazz = classArray2[i];
            if (clazz.isPrimitive()) {
                clazz = ReflectionUtils.typeToClass(clazz);
            }
            if (bl) {
                if (classArray[i] == clazz) continue;
                bl2 = false;
                continue;
            }
            if (classArray[i] == null || clazz.isAssignableFrom(classArray[i])) continue;
            bl2 = false;
        }
        return bl2;
    }

    static Method getPublicMethod(Class clazz, String string, Class[] classArray) throws NoSuchMethodException {
        Method method = ReflectionUtils.findPublicMethod(clazz, string, classArray);
        if (method == null) {
            throw new NoSuchMethodException(clazz.getName() + "." + string);
        }
        return method;
    }

    public static Method findPublicMethod(Class clazz, String string, Class[] classArray) {
        Method method;
        if (classArray.length == 0) {
            try {
                return MethodUtil.getMethod(clazz, string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        Method[] methodArray = MethodUtil.getPublicMethods(clazz);
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (int i = 0; i < methodArray.length; ++i) {
            method = methodArray[i];
            if (!method.getName().equals(string) || !ReflectionUtils.matchArguments(classArray, method.getParameterTypes())) continue;
            arrayList.add(method);
        }
        if (arrayList.size() > 0) {
            if (arrayList.size() == 1) {
                return (Method)arrayList.get(0);
            }
            ListIterator listIterator = arrayList.listIterator();
            while (listIterator.hasNext()) {
                method = (Method)listIterator.next();
                if (!ReflectionUtils.matchExplicitArguments(classArray, method.getParameterTypes())) continue;
                return method;
            }
            return ReflectionUtils.getMostSpecificMethod(arrayList, classArray);
        }
        return null;
    }

    private static Method getMostSpecificMethod(List list, Class[] classArray) {
        int n;
        Method method = null;
        int n2 = n = 0;
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Method method2 = (Method)listIterator.next();
            Class<?>[] classArray2 = method2.getParameterTypes();
            n = 0;
            for (int i = 0; i < classArray.length; ++i) {
                Class clazz = classArray2[i];
                if (clazz.isPrimitive()) {
                    clazz = ReflectionUtils.typeToClass(clazz);
                }
                if (classArray[i] != clazz) continue;
                ++n;
            }
            if (n == 0 && n2 == 0) {
                if (method == null) {
                    method = method2;
                    continue;
                }
                if (ReflectionUtils.matchArguments(method.getParameterTypes(), method2.getParameterTypes())) continue;
                method = method2;
                continue;
            }
            if (n > n2) {
                n2 = n;
                method = method2;
                continue;
            }
            if (n != n2) continue;
            method = null;
        }
        return method;
    }

    public static Method findMethod(Class clazz, String string, Class[] classArray) {
        Method method = ReflectionUtils.findPublicMethod(clazz, string, classArray);
        if (method != null && Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            return method;
        }
        for (Class clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            Class<?>[] classArray2 = clazz2.getInterfaces();
            for (int i = 0; i < classArray2.length; ++i) {
                method = ReflectionUtils.findPublicMethod(classArray2[i], string, classArray);
                if (method == null) continue;
                return method;
            }
        }
        return null;
    }

    public static synchronized Method getMethod(Class clazz, String string, Class[] classArray) {
        Signature signature = new Signature(clazz, string, classArray);
        Method method = null;
        HashMap<Signature, Method> hashMap = null;
        boolean bl = false;
        if (ReflectUtil.isPackageAccessible(clazz)) {
            bl = true;
        }
        if (bl && methodCacheRef != null && (hashMap = (HashMap<Signature, Method>)methodCacheRef.get()) != null && (method = (Method)hashMap.get(signature)) != null) {
            return method;
        }
        method = ReflectionUtils.findMethod(clazz, string, classArray);
        if (bl && method != null) {
            if (hashMap == null) {
                hashMap = new HashMap<Signature, Method>();
                methodCacheRef = new SoftReference(hashMap);
            }
            hashMap.put(signature, method);
        }
        return method;
    }

    public static Constructor getConstructor(Class clazz, Class[] classArray) {
        Constructor constructor = null;
        Constructor[] constructorArray = ConstructorUtil.getConstructors(clazz);
        for (int i = 0; i < constructorArray.length; ++i) {
            if (!ReflectionUtils.matchArguments(classArray, constructorArray[i].getParameterTypes())) continue;
            constructor = constructorArray[i];
        }
        return constructor;
    }

    public static Object getPrivateField(Object object, Class clazz, String string) {
        return ReflectionUtils.getPrivateField(object, clazz, string, null);
    }

    public static Object getPrivateField(Object object, Class clazz, String string, ExceptionListener exceptionListener) {
        try {
            Field field = clazz.getDeclaredField(string);
            field.setAccessible(true);
            return field.get(object);
        }
        catch (Exception exception) {
            if (exceptionListener != null) {
                exceptionListener.exceptionThrown(exception);
            }
            return null;
        }
    }

    private static class Signature {
        private Class targetClass;
        private String methodName;
        private Class[] argClasses;
        private volatile int hashCode = 0;

        public Signature(Class clazz, String string, Class[] classArray) {
            this.targetClass = clazz;
            this.methodName = string;
            this.argClasses = classArray;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            Signature signature = (Signature)object;
            if (this.targetClass != signature.targetClass) {
                return false;
            }
            if (!this.methodName.equals(signature.methodName)) {
                return false;
            }
            if (this.argClasses.length != signature.argClasses.length) {
                return false;
            }
            for (int i = 0; i < this.argClasses.length; ++i) {
                if (this.argClasses[i] == signature.argClasses[i]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int n = 17;
                n = 37 * n + this.targetClass.hashCode();
                n = 37 * n + this.methodName.hashCode();
                if (this.argClasses != null) {
                    for (int i = 0; i < this.argClasses.length; ++i) {
                        n = 37 * n + (this.argClasses[i] == null ? 0 : this.argClasses[i].hashCode());
                    }
                }
                this.hashCode = n;
            }
            return this.hashCode;
        }
    }
}

