/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.panel;

import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertStore;
import com.sun.deploy.security.DeployClientAuthCertStore;
import com.sun.deploy.security.DeploySSLCertStore;
import com.sun.deploy.security.DeploySigningCertStore;
import com.sun.deploy.security.RootCertStore;
import com.sun.deploy.security.SSLRootCertStore;
import com.sun.deploy.util.Trace;
import java.security.Key;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.LinkedHashMap;
import javax.swing.JDialog;

class CertificatesInfo {
    private LinkedHashMap activeTrustedCertsMap = new LinkedHashMap();
    private LinkedHashMap activeHttpsCertsMap = new LinkedHashMap();
    private LinkedHashMap activeRootCACertsMap = new LinkedHashMap();
    private LinkedHashMap activeHttpsRootCACertsMap = new LinkedHashMap();
    private LinkedHashMap activeClientAuthCertsMap = new LinkedHashMap();
    private LinkedHashMap activeSysTrustedCertsMap = new LinkedHashMap();
    private LinkedHashMap activeSysHttpsCertsMap = new LinkedHashMap();
    private LinkedHashMap activeSysRootCACertsMap = new LinkedHashMap();
    private LinkedHashMap activeSysHttpsRootCACertsMap = new LinkedHashMap();
    private LinkedHashMap activeSysClientAuthCertsMap = new LinkedHashMap();

    public CertificatesInfo() {
        this.reset();
    }

    public Collection getTrustedCertificates(int n) {
        if (n == 0) {
            return this.activeTrustedCertsMap.keySet();
        }
        return this.activeSysTrustedCertsMap.keySet();
    }

    public Collection getHttpsCertificates(int n) {
        if (n == 0) {
            return this.activeHttpsCertsMap.keySet();
        }
        return this.activeSysHttpsCertsMap.keySet();
    }

    public Collection getRootCACertificates(int n) {
        if (n == 0) {
            return this.activeRootCACertsMap.keySet();
        }
        return this.activeSysRootCACertsMap.keySet();
    }

    public Collection getHttpsRootCACertificates(int n) {
        if (n == 0) {
            return this.activeHttpsRootCACertsMap.keySet();
        }
        return this.activeSysHttpsRootCACertsMap.keySet();
    }

    public Collection getClientAuthCertificates(int n) {
        if (n == 0) {
            return this.activeClientAuthCertsMap.keySet();
        }
        return this.activeSysClientAuthCertsMap.keySet();
    }

    public void removeTrustedCertificate(Certificate certificate) {
        CertStore certStore = DeploySigningCertStore.getUserCertStore();
        try {
            certStore.load(true);
            if (certStore.remove(certificate)) {
                certStore.save();
                Object v = this.activeTrustedCertsMap.remove(certificate);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
    }

    public void removeHttpsCertificate(Certificate certificate) {
        CertStore certStore = DeploySSLCertStore.getUserCertStore();
        try {
            certStore.load(true);
            if (certStore.remove(certificate)) {
                certStore.save();
                Object v = this.activeHttpsCertsMap.remove(certificate);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
    }

    public void removeRootCACertificate(Certificate certificate) {
        CertStore certStore = RootCertStore.getUserCertStore();
        try {
            certStore.load(true);
            if (certStore.remove(certificate)) {
                certStore.save();
                Object v = this.activeRootCACertsMap.remove(certificate);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
    }

    public void removeHttpsRootCACertificate(Certificate certificate) {
        CertStore certStore = SSLRootCertStore.getUserCertStore();
        try {
            certStore.load(true);
            if (certStore.remove(certificate)) {
                certStore.save();
                Object v = this.activeHttpsRootCACertsMap.remove(certificate);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
    }

    public void removeClientAuthCertificate(JDialog jDialog, Certificate[][] certificateArray) {
        DeployClientAuthCertStore deployClientAuthCertStore = DeployClientAuthCertStore.getUserCertStore(jDialog);
        Certificate[] certificateArray2 = new Certificate[certificateArray.length];
        try {
            int n;
            deployClientAuthCertStore.load(true);
            for (n = 0; n < certificateArray.length; ++n) {
                certificateArray2[n] = certificateArray[n][0];
            }
            n = deployClientAuthCertStore.remove(certificateArray2) ? 1 : 0;
            if (n != 0) {
                deployClientAuthCertStore.save();
                for (int i = 0; i < certificateArray.length; ++i) {
                    this.activeClientAuthCertsMap.remove(certificateArray[i]);
                }
            }
        }
        catch (Exception exception) {
            Trace.printException(jDialog, exception);
        }
    }

    public void addTrustedCertificate(Certificate certificate) {
        CertStore certStore = DeploySigningCertStore.getUserCertStore();
        try {
            certStore.load(true);
            if (certStore.add(certificate)) {
                certStore.save();
                this.activeTrustedCertsMap.put(certificate, certificate);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
    }

    public void addHttpsCertificate(Certificate certificate) {
        CertStore certStore = DeploySSLCertStore.getUserCertStore();
        try {
            certStore.load(true);
            if (certStore.add(certificate)) {
                certStore.save();
                this.activeHttpsCertsMap.put(certificate, certificate);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
    }

    public void addCACertificate(Certificate certificate) {
        CertStore certStore = RootCertStore.getUserCertStore();
        try {
            certStore.load(true);
            if (certStore.add(certificate)) {
                certStore.save();
                this.activeRootCACertsMap.put(certificate, certificate);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
    }

    public void addHttpsCACertificate(Certificate certificate) {
        CertStore certStore = SSLRootCertStore.getUserCertStore();
        try {
            certStore.load(true);
            if (certStore.add(certificate)) {
                certStore.save();
                this.activeHttpsRootCACertsMap.put(certificate, certificate);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
    }

    public void addClientAuthCertChain(JDialog jDialog, Certificate[] certificateArray, Key key) {
        DeployClientAuthCertStore deployClientAuthCertStore = DeployClientAuthCertStore.getUserCertStore(jDialog);
        try {
            deployClientAuthCertStore.load(true);
            boolean bl = deployClientAuthCertStore.addCertKey(certificateArray, key);
            if (bl) {
                deployClientAuthCertStore.save();
                this.activeClientAuthCertsMap.put(certificateArray, certificateArray);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
    }

    public void reset() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        Object object10;
        this.activeTrustedCertsMap.clear();
        this.activeHttpsCertsMap.clear();
        this.activeRootCACertsMap.clear();
        this.activeHttpsRootCACertsMap.clear();
        this.activeClientAuthCertsMap.clear();
        this.activeSysTrustedCertsMap.clear();
        this.activeSysHttpsCertsMap.clear();
        this.activeSysRootCACertsMap.clear();
        this.activeSysHttpsRootCACertsMap.clear();
        this.activeSysClientAuthCertsMap.clear();
        CertStore certStore = DeploySigningCertStore.getUserCertStore();
        try {
            certStore.load();
            object10 = certStore.getCertificates().iterator();
            while (object10.hasNext()) {
                object9 = (X509Certificate)object10.next();
                this.activeTrustedCertsMap.put(object9, object9);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
        object10 = DeploySigningCertStore.getSystemCertStore();
        try {
            object10.load();
            object9 = object10.getCertificates().iterator();
            while (object9.hasNext()) {
                object8 = (X509Certificate)object9.next();
                this.activeSysTrustedCertsMap.put(object8, object8);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
        object9 = DeploySSLCertStore.getUserCertStore();
        try {
            object9.load();
            object8 = object9.getCertificates().iterator();
            while (object8.hasNext()) {
                object7 = (X509Certificate)object8.next();
                this.activeHttpsCertsMap.put(object7, object7);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
        object8 = DeploySSLCertStore.getSystemCertStore();
        try {
            object8.load();
            object7 = object8.getCertificates().iterator();
            while (object7.hasNext()) {
                object6 = (X509Certificate)object7.next();
                this.activeSysHttpsCertsMap.put(object6, object6);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
        object7 = RootCertStore.getUserCertStore();
        try {
            object7.load();
            object6 = object7.getCertificates().iterator();
            while (object6.hasNext()) {
                object5 = (X509Certificate)object6.next();
                this.activeRootCACertsMap.put(object5, object5);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
        object6 = RootCertStore.getSystemCertStore();
        try {
            object6.load();
            object5 = object6.getCertificates().iterator();
            while (object5.hasNext()) {
                object4 = (X509Certificate)object5.next();
                this.activeSysRootCACertsMap.put(object4, object4);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
        object5 = SSLRootCertStore.getUserCertStore();
        try {
            object5.load();
            object4 = object5.getCertificates().iterator();
            while (object4.hasNext()) {
                object3 = (X509Certificate)object4.next();
                this.activeHttpsRootCACertsMap.put(object3, object3);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
        object4 = SSLRootCertStore.getSystemCertStore();
        try {
            object4.load();
            object3 = object4.getCertificates().iterator();
            while (object3.hasNext()) {
                object2 = (X509Certificate)object3.next();
                this.activeSysHttpsRootCACertsMap.put(object2, object2);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
        object3 = DeployClientAuthCertStore.getUserCertStore(null);
        try {
            object3.load();
            object2 = object3.getCertificates().iterator();
            while (object2.hasNext()) {
                object = (Certificate[])object2.next();
                this.activeClientAuthCertsMap.put(object, object);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
        object2 = DeployClientAuthCertStore.getSystemCertStore(null);
        try {
            object2.load();
            object = object2.getCertificates().iterator();
            while (object.hasNext()) {
                Certificate[] certificateArray = (Certificate[])object.next();
                this.activeSysClientAuthCertsMap.put(certificateArray, certificateArray);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
    }

    private static String getMessage(String string) {
        return ResourceManager.getMessage(string);
    }
}

