/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import sun.security.action.GetPropertyAction;
import sun.security.jgss.GSSExceptionImpl;
import sun.security.jgss.GSSUtil;
import sun.security.jgss.spi.MechanismFactory;
import sun.security.jgss.wrapper.NativeGSSFactory;
import sun.security.jgss.wrapper.SunNativeProvider;

public final class ProviderList {
    private static final String PROV_PROP_PREFIX = "GssApiMechanism.";
    private static final int PROV_PROP_PREFIX_LEN = "GssApiMechanism.".length();
    private static final String SPI_MECH_FACTORY_TYPE = "sun.security.jgss.spi.MechanismFactory";
    private static final String DEFAULT_MECH_PROP = "sun.security.jgss.mechanism";
    public static final Oid DEFAULT_MECH_OID;
    private ArrayList preferences = new ArrayList(5);
    private HashMap factories = new HashMap(5);
    private HashSet mechs = new HashSet(5);
    private final int caller;

    public ProviderList(int n, boolean bl) {
        this.caller = n;
        Provider[] providerArray = bl ? new Provider[]{new SunNativeProvider()} : Security.getProviders();
        for (int i = 0; i < providerArray.length; ++i) {
            Provider provider = providerArray[i];
            try {
                this.addProviderAtEnd(provider, null);
                continue;
            }
            catch (GSSException gSSException) {
                GSSUtil.debug("Error in adding provider " + provider.getName() + ": " + gSSException);
            }
        }
    }

    private boolean isMechFactoryProperty(String string) {
        return string.startsWith(PROV_PROP_PREFIX) || string.regionMatches(true, 0, PROV_PROP_PREFIX, 0, PROV_PROP_PREFIX_LEN);
    }

    private Oid getOidFromMechFactoryProperty(String string) throws GSSException {
        String string2 = string.substring(PROV_PROP_PREFIX_LEN);
        return new Oid(string2);
    }

    public synchronized MechanismFactory getMechFactory(Oid oid) throws GSSException {
        if (oid == null) {
            oid = DEFAULT_MECH_OID;
        }
        return this.getMechFactory(oid, null);
    }

    public synchronized MechanismFactory getMechFactory(Oid oid, Provider provider) throws GSSException {
        if (oid == null) {
            oid = DEFAULT_MECH_OID;
        }
        if (provider == null) {
            for (PreferencesEntry preferencesEntry : this.preferences) {
                MechanismFactory mechanismFactory;
                if (!preferencesEntry.impliesMechanism(oid) || (mechanismFactory = this.getMechFactory(preferencesEntry, oid)) == null) continue;
                return mechanismFactory;
            }
            throw new GSSExceptionImpl(2, oid);
        }
        PreferencesEntry preferencesEntry = new PreferencesEntry(provider, oid);
        return this.getMechFactory(preferencesEntry, oid);
    }

    private MechanismFactory getMechFactory(PreferencesEntry preferencesEntry, Oid oid) throws GSSException {
        Provider provider = preferencesEntry.getProvider();
        PreferencesEntry preferencesEntry2 = new PreferencesEntry(provider, oid);
        MechanismFactory mechanismFactory = (MechanismFactory)this.factories.get(preferencesEntry2);
        if (mechanismFactory == null) {
            String string = PROV_PROP_PREFIX + oid.toString();
            String string2 = provider.getProperty(string);
            if (string2 != null) {
                mechanismFactory = ProviderList.getMechFactoryImpl(provider, string2, oid, this.caller);
                this.factories.put(preferencesEntry2, mechanismFactory);
            } else if (preferencesEntry.getOid() != null) {
                throw new GSSExceptionImpl(2, "Provider " + provider.getName() + " does not support mechanism " + oid);
            }
        }
        return mechanismFactory;
    }

    private static MechanismFactory getMechFactoryImpl(Provider provider, String string, Oid oid, int n) throws GSSException {
        try {
            Class<?> clazz = Class.forName(SPI_MECH_FACTORY_TYPE);
            ClassLoader classLoader = provider.getClass().getClassLoader();
            Class<?> clazz2 = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
            if (clazz.isAssignableFrom(clazz2)) {
                Constructor<?> constructor = clazz2.getConstructor(Integer.TYPE);
                MechanismFactory mechanismFactory = (MechanismFactory)constructor.newInstance(n);
                if (mechanismFactory instanceof NativeGSSFactory) {
                    ((NativeGSSFactory)mechanismFactory).setMech(oid);
                }
                return mechanismFactory;
            }
            throw ProviderList.createGSSException(provider, string, "is not a sun.security.jgss.spi.MechanismFactory", null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw ProviderList.createGSSException(provider, string, "cannot be created", classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw ProviderList.createGSSException(provider, string, "cannot be created", noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw ProviderList.createGSSException(provider, string, "cannot be created", invocationTargetException);
        }
        catch (InstantiationException instantiationException) {
            throw ProviderList.createGSSException(provider, string, "cannot be created", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw ProviderList.createGSSException(provider, string, "cannot be created", illegalAccessException);
        }
        catch (SecurityException securityException) {
            throw ProviderList.createGSSException(provider, string, "cannot be created", securityException);
        }
    }

    private static GSSException createGSSException(Provider provider, String string, String string2, Exception exception) {
        String string3 = string + " configured by " + provider.getName() + " for GSS-API Mechanism Factory ";
        return new GSSExceptionImpl(2, string3 + string2, exception);
    }

    public Oid[] getMechs() {
        return this.mechs.toArray(new Oid[0]);
    }

    public synchronized void addProviderAtFront(Provider provider, Oid oid) throws GSSException {
        boolean bl;
        PreferencesEntry preferencesEntry = new PreferencesEntry(provider, oid);
        Iterator iterator = this.preferences.iterator();
        while (iterator.hasNext()) {
            PreferencesEntry preferencesEntry2 = (PreferencesEntry)iterator.next();
            if (!preferencesEntry.implies(preferencesEntry2)) continue;
            iterator.remove();
        }
        if (oid == null) {
            bl = this.addAllMechsFromProvider(provider);
        } else {
            String string = oid.toString();
            if (provider.getProperty(PROV_PROP_PREFIX + string) == null) {
                throw new GSSExceptionImpl(2, "Provider " + provider.getName() + " does not support " + string);
            }
            this.mechs.add(oid);
            bl = true;
        }
        if (bl) {
            this.preferences.add(0, preferencesEntry);
        }
    }

    public synchronized void addProviderAtEnd(Provider provider, Oid oid) throws GSSException {
        boolean bl;
        PreferencesEntry preferencesEntry = new PreferencesEntry(provider, oid);
        for (PreferencesEntry preferencesEntry2 : this.preferences) {
            if (!preferencesEntry2.implies(preferencesEntry)) continue;
            return;
        }
        if (oid == null) {
            bl = this.addAllMechsFromProvider(provider);
        } else {
            String string = oid.toString();
            if (provider.getProperty(PROV_PROP_PREFIX + string) == null) {
                throw new GSSExceptionImpl(2, "Provider " + provider.getName() + " does not support " + string);
            }
            this.mechs.add(oid);
            bl = true;
        }
        if (bl) {
            this.preferences.add(preferencesEntry);
        }
    }

    private boolean addAllMechsFromProvider(Provider provider) {
        boolean bl = false;
        Enumeration<Object> enumeration = provider.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!this.isMechFactoryProperty(string)) continue;
            try {
                Oid oid = this.getOidFromMechFactoryProperty(string);
                this.mechs.add(oid);
                bl = true;
            }
            catch (GSSException gSSException) {
                GSSUtil.debug("Ignore the invalid property " + string + " from provider " + provider.getName());
            }
        }
        return bl;
    }

    static {
        Oid oid = null;
        String string = AccessController.doPrivileged(new GetPropertyAction(DEFAULT_MECH_PROP));
        if (string != null) {
            oid = GSSUtil.createOid(string);
        }
        DEFAULT_MECH_OID = oid == null ? GSSUtil.GSS_KRB5_MECH_OID : oid;
    }

    private static final class PreferencesEntry {
        private Provider p;
        private Oid oid;

        PreferencesEntry(Provider provider, Oid oid) {
            this.p = provider;
            this.oid = oid;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof PreferencesEntry)) {
                return false;
            }
            PreferencesEntry preferencesEntry = (PreferencesEntry)object;
            if (this.p.getName().equals(preferencesEntry.p.getName())) {
                if (this.oid != null && preferencesEntry.oid != null) {
                    return this.oid.equals(preferencesEntry.oid);
                }
                return this.oid == null && preferencesEntry.oid == null;
            }
            return false;
        }

        public int hashCode() {
            int n = 17;
            n = 37 * n + this.p.getName().hashCode();
            if (this.oid != null) {
                n = 37 * n + this.oid.hashCode();
            }
            return n;
        }

        boolean implies(Object object) {
            if (object instanceof PreferencesEntry) {
                PreferencesEntry preferencesEntry = (PreferencesEntry)object;
                return this.equals(preferencesEntry) || this.p.getName().equals(preferencesEntry.p.getName()) && this.oid == null;
            }
            return false;
        }

        Provider getProvider() {
            return this.p;
        }

        Oid getOid() {
            return this.oid;
        }

        boolean impliesMechanism(Oid oid) {
            return this.oid == null || this.oid.equals(oid);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("<");
            stringBuffer.append(this.p.getName());
            stringBuffer.append(", ");
            stringBuffer.append(this.oid);
            stringBuffer.append(">");
            return stringBuffer.toString();
        }
    }
}

