/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xalan.internal.xsltc.trax;

import com.sun.org.apache.xalan.internal.xsltc.trax.SAX2StAXBaseWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.Locator2;

public class SAX2StAXEventWriter
extends SAX2StAXBaseWriter {
    private XMLEventWriter writer;
    private XMLEventFactory eventFactory;
    private List namespaceStack = new ArrayList();
    private boolean needToCallStartDocument = false;

    public SAX2StAXEventWriter() {
        this.eventFactory = XMLEventFactory.newInstance();
    }

    public SAX2StAXEventWriter(XMLEventWriter xMLEventWriter) {
        this.writer = xMLEventWriter;
        this.eventFactory = XMLEventFactory.newInstance();
    }

    public SAX2StAXEventWriter(XMLEventWriter xMLEventWriter, XMLEventFactory xMLEventFactory) {
        this.writer = xMLEventWriter;
        this.eventFactory = xMLEventFactory != null ? xMLEventFactory : XMLEventFactory.newInstance();
    }

    public XMLEventWriter getEventWriter() {
        return this.writer;
    }

    public void setEventWriter(XMLEventWriter xMLEventWriter) {
        this.writer = xMLEventWriter;
    }

    public XMLEventFactory getEventFactory() {
        return this.eventFactory;
    }

    public void setEventFactory(XMLEventFactory xMLEventFactory) {
        this.eventFactory = xMLEventFactory;
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        this.namespaceStack.clear();
        this.eventFactory.setLocation(this.getCurrentLocation());
        this.needToCallStartDocument = true;
    }

    private void writeStartDocument() throws SAXException {
        try {
            if (this.docLocator == null) {
                this.writer.add(this.eventFactory.createStartDocument());
            } else {
                try {
                    this.writer.add(this.eventFactory.createStartDocument(((Locator2)this.docLocator).getEncoding(), ((Locator2)this.docLocator).getXMLVersion()));
                }
                catch (ClassCastException classCastException) {
                    this.writer.add(this.eventFactory.createStartDocument());
                }
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SAXException(xMLStreamException);
        }
        this.needToCallStartDocument = false;
    }

    public void endDocument() throws SAXException {
        this.eventFactory.setLocation(this.getCurrentLocation());
        try {
            this.writer.add(this.eventFactory.createEndDocument());
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SAXException(xMLStreamException);
        }
        super.endDocument();
        this.namespaceStack.clear();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.needToCallStartDocument) {
            this.writeStartDocument();
        }
        this.eventFactory.setLocation(this.getCurrentLocation());
        Collection[] collectionArray = new Collection[]{null, null};
        this.createStartEvents(attributes, collectionArray);
        this.namespaceStack.add(collectionArray[0]);
        try {
            String[] stringArray = new String[]{null, null};
            SAX2StAXEventWriter.parseQName(string3, stringArray);
            this.writer.add(this.eventFactory.createStartElement(stringArray[0], string, stringArray[1], collectionArray[1].iterator(), collectionArray[0].iterator()));
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SAXException(xMLStreamException);
        }
        finally {
            super.startElement(string, string2, string3, attributes);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        super.endElement(string, string2, string3);
        this.eventFactory.setLocation(this.getCurrentLocation());
        String[] stringArray = new String[]{null, null};
        SAX2StAXEventWriter.parseQName(string3, stringArray);
        Collection collection = (Collection)this.namespaceStack.remove(this.namespaceStack.size() - 1);
        Iterator iterator = collection.iterator();
        try {
            this.writer.add(this.eventFactory.createEndElement(stringArray[0], string, stringArray[1], iterator));
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SAXException(xMLStreamException);
        }
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (this.needToCallStartDocument) {
            this.writeStartDocument();
        }
        super.comment(cArray, n, n2);
        this.eventFactory.setLocation(this.getCurrentLocation());
        try {
            this.writer.add(this.eventFactory.createComment(new String(cArray, n, n2)));
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SAXException(xMLStreamException);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        super.characters(cArray, n, n2);
        try {
            if (!this.isCDATA) {
                this.eventFactory.setLocation(this.getCurrentLocation());
                this.writer.add(this.eventFactory.createCharacters(new String(cArray, n, n2)));
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SAXException(xMLStreamException);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        super.ignorableWhitespace(cArray, n, n2);
        this.characters(cArray, n, n2);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.needToCallStartDocument) {
            this.writeStartDocument();
        }
        super.processingInstruction(string, string2);
        try {
            this.writer.add(this.eventFactory.createProcessingInstruction(string, string2));
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SAXException(xMLStreamException);
        }
    }

    public void endCDATA() throws SAXException {
        this.eventFactory.setLocation(this.getCurrentLocation());
        try {
            this.writer.add(this.eventFactory.createCData(this.CDATABuffer.toString()));
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SAXException(xMLStreamException);
        }
        super.endCDATA();
    }

    protected void createStartEvents(Attributes attributes, Collection[] collectionArray) {
        Object object;
        String string;
        int n;
        HashMap<String, Namespace> hashMap = null;
        ArrayList<Namespace> arrayList = null;
        if (this.namespaces != null) {
            int n2 = this.namespaces.size();
            for (n = 0; n < n2; ++n) {
                String string2 = (String)this.namespaces.elementAt(n++);
                string = (String)this.namespaces.elementAt(n);
                object = this.createNamespace(string2, string);
                if (hashMap == null) {
                    hashMap = new HashMap<String, Namespace>();
                }
                hashMap.put(string2, (Namespace)object);
            }
        }
        String[] stringArray = new String[]{null, null};
        int n3 = attributes.getLength();
        for (n = 0; n < n3; ++n) {
            Attribute attribute;
            SAX2StAXEventWriter.parseQName(attributes.getQName(n), stringArray);
            string = stringArray[0];
            object = stringArray[1];
            String string3 = attributes.getQName(n);
            String string4 = attributes.getValue(n);
            String string5 = attributes.getURI(n);
            if ("xmlns".equals(string3) || "xmlns".equals(string)) {
                if (hashMap == null) {
                    hashMap = new HashMap();
                }
                if (hashMap.containsKey(object)) continue;
                attribute = this.createNamespace((String)object, string4);
                hashMap.put((String)object, (Namespace)attribute);
                continue;
            }
            attribute = string.length() > 0 ? this.eventFactory.createAttribute(string, string5, (String)object, string4) : this.eventFactory.createAttribute((String)object, string4);
            if (arrayList == null) {
                arrayList = new ArrayList<Namespace>();
            }
            arrayList.add((Namespace)attribute);
        }
        collectionArray[0] = hashMap == null ? Collections.EMPTY_LIST : hashMap.values();
        collectionArray[1] = arrayList == null ? Collections.EMPTY_LIST : arrayList;
    }

    protected Namespace createNamespace(String string, String string2) {
        if (string == null || string.length() == 0) {
            return this.eventFactory.createNamespace(string2);
        }
        return this.eventFactory.createNamespace(string, string2);
    }
}

