/*
 * Decompiled with CFR 0.152.
 */
package sun.text.normalizer;

import sun.text.normalizer.Replaceable;
import sun.text.normalizer.ReplaceableString;
import sun.text.normalizer.UCharacterIterator;

public class ReplaceableUCharacterIterator
extends UCharacterIterator {
    private Replaceable replaceable;
    private int currentIndex;

    public ReplaceableUCharacterIterator(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.replaceable = new ReplaceableString(string);
        this.currentIndex = 0;
    }

    public ReplaceableUCharacterIterator(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            throw new IllegalArgumentException();
        }
        this.replaceable = new ReplaceableString(stringBuffer);
        this.currentIndex = 0;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public int current() {
        if (this.currentIndex < this.replaceable.length()) {
            return this.replaceable.charAt(this.currentIndex);
        }
        return -1;
    }

    public int getLength() {
        return this.replaceable.length();
    }

    public int getIndex() {
        return this.currentIndex;
    }

    public int next() {
        if (this.currentIndex < this.replaceable.length()) {
            return this.replaceable.charAt(this.currentIndex++);
        }
        return -1;
    }

    public int previous() {
        if (this.currentIndex > 0) {
            return this.replaceable.charAt(--this.currentIndex);
        }
        return -1;
    }

    public void setIndex(int n) {
        if (n < 0 || n > this.replaceable.length()) {
            throw new IllegalArgumentException();
        }
        this.currentIndex = n;
    }

    public int getText(char[] cArray, int n) {
        int n2 = this.replaceable.length();
        if (n < 0 || n + n2 > cArray.length) {
            throw new IndexOutOfBoundsException(Integer.toString(n2));
        }
        this.replaceable.getChars(0, n2, cArray, n);
        return n2;
    }
}

