/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import sun.font.CharToGlyphMapper;
import sun.font.FontManager;
import sun.font.Type1Font;

public final class Type1GlyphMapper
extends CharToGlyphMapper {
    Type1Font font;

    public Type1GlyphMapper(Type1Font type1Font) {
        this.font = type1Font;
        this.initMapper();
    }

    private void initMapper() {
        if (this.font.pScaler == 0L) {
            this.font.getScaler();
        }
        this.missingGlyph = this.font.getMissingGlyphCode(this.font.pScaler);
    }

    public int getNumGlyphs() {
        return this.font.getNumGlyphs(this.font.pScaler);
    }

    public int getMissingGlyphCode() {
        return this.missingGlyph;
    }

    public boolean canDisplay(char c) {
        return this.font.getGlyphCode(this.font.pScaler, c) != this.missingGlyph;
    }

    public int charToGlyph(char c) {
        return this.font.getGlyphCode(this.font.pScaler, c);
    }

    public int charToGlyph(int n) {
        if (n < 0 || n > 65535) {
            return this.missingGlyph;
        }
        return this.font.getGlyphCode(this.font.pScaler, (char)n);
    }

    public void charsToGlyphs(int n, char[] cArray, int[] nArray) {
        for (int i = 0; i < n; ++i) {
            char c;
            int n2 = cArray[i];
            if (n2 >= 55296 && n2 <= 56319 && i < n - 1 && (c = cArray[i + 1]) >= '\udc00' && c <= '\udfff') {
                n2 = (n2 - 55296) * 1024 + c - 56320 + 65536;
                nArray[i + 1] = 65535;
            }
            nArray[i] = n2 < 0 || n2 > 65535 ? this.missingGlyph : this.font.getGlyphCode(this.font.pScaler, (char)n2);
            if (n2 < 65536) continue;
            ++i;
        }
    }

    public void charsToGlyphs(int n, int[] nArray, int[] nArray2) {
        for (int i = 0; i < n; ++i) {
            nArray2[i] = nArray[i] < 0 || nArray[i] > 65535 ? this.missingGlyph : this.font.getGlyphCode(this.font.pScaler, (char)nArray[i]);
        }
    }

    public boolean charsToGlyphsNS(int n, char[] cArray, int[] nArray) {
        for (int i = 0; i < n; ++i) {
            char c;
            int n2 = cArray[i];
            if (n2 >= 55296 && n2 <= 56319 && i < n - 1 && (c = cArray[i + 1]) >= '\udc00' && c <= '\udfff') {
                n2 = (n2 - 55296) * 1024 + c - 56320 + 65536;
                nArray[i + 1] = 65535;
            }
            nArray[i] = n2 < 0 || n2 > 65535 ? this.missingGlyph : this.font.getGlyphCode(this.font.pScaler, (char)n2);
            if (n2 < 768) continue;
            if (FontManager.isComplexCharCode(n2)) {
                return true;
            }
            if (n2 < 65536) continue;
            ++i;
        }
        return false;
    }
}

