from yum.plugins import PluginYumExit
from yum.misc import unique
from yum.packages import YumInstalledPackage

requires_api_version = '2.1'

knames = ['kernel', 'kernel-smp', 'kernel-hugemem', 'kernel-largesmp', 'kernel-xenU' ]

def kunamer(kernel):
    ksuff = ""
    tmp = kernel.name.split('-')
    if len(tmp) > 1:
        ksuff = tmp[1]
    return "%s-%s%s" % (kernel.version, kernel.release, ksuff)

def find_kmodules(availpkgs, provides, kernels):
    matches = []
    for pkg in availpkgs:
        for kern in kernels:
            for prov in provides:
                if pkg.name == "%s-%s" % (prov, kunamer(kern)):
                    matches.append(pkg)
    return unique(matches)

def preresolve_hook(conduit):
    ts = conduit.getTsInfo()
    kernels = []
    for tsmem in ts.getMembers():
        if tsmem.ts_state == 'u' and tsmem.name in knames:
            kernels.append(tsmem.po)

    # pkgSack isn't populated on removals so this could traceback
    try:
        pkgs = conduit.getPackages()
    except AttributeError:
        return

    instpkgs = []
    for hdr in conduit.getRpmDB().getHdrList():
        po = YumInstalledPackage(hdr)
        instpkgs.append(po)

    kmodprovides = []
    for pkg in instpkgs:
        if pkg.name.startswith('kernel-module'):
            for prov in pkg.tagByName('providename'):
                kmodprovides.append(prov)

    mods = find_kmodules(pkgs, kmodprovides, kernels)
    for pkg in mods:
        conduit.info(2, 'Adding kernel module %s to transaction' % pkg.name)
        ts.addInstall(pkg)

# vim:ts=4:expandtab
