# /* **************************************************************************
#  *                                                                          *
#  *     (C) Copyright Edward Diener 2011.
#  *     Distributed under the Boost Software License, Version 1.0. (See
#  *     accompanying file LICENSE_1_0.txt or copy at
#  *     http://www.boost.org/LICENSE_1_0.txt)
#  *                                                                          *
#  ************************************************************************** */
#
# /* See http://www.boost.org for most recent version. */
#
# include <boost/preprocessor/config/limits.hpp>
# include <boost/preprocessor/variadic.hpp>
# include <boost/preprocessor/array/size.hpp>
# include <boost/preprocessor/array/elem.hpp>
# include <boost/preprocessor/list/at.hpp>
# include <boost/preprocessor/list/size.hpp>
# include <boost/preprocessor/seq/elem.hpp>
# include <boost/preprocessor/seq/size.hpp>
# include <boost/preprocessor/tuple/size.hpp>
# include <boost/preprocessor/tuple/elem.hpp>
# include "test.h"

#define VDATA 0,1,2,3,4,5,6
#define VDATA_LARGE 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32
#define VDATA_VERY_LARGE 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63

#if BOOST_PP_VARIADIC_HAS_OPT()

#define VDATA_EMPTY

#endif

#if BOOST_PP_LIMIT_VARIADIC > 64

#define VDATA_LARGE_128 \
    0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, \
    64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95
 
#define VDATA_VERY_LARGE_128 \
    0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, \
    64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127
    
#endif
 
#if BOOST_PP_LIMIT_VARIADIC > 128

#define VDATA_LARGE_256 \
    0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, \
    64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, \
    128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138

#define VDATA_VERY_LARGE_256 \
    0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, \
    64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, \
    128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, \
    192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255

#endif

BEGIN BOOST_PP_VARIADIC_ELEM(4,VDATA) == 4 END
BEGIN BOOST_PP_VARIADIC_ELEM(6,7,11,3,8,14,85,56,92,165) == 56 END
BEGIN BOOST_PP_VARIADIC_ELEM(29,VDATA_LARGE) == 29 END
BEGIN BOOST_PP_VARIADIC_ELEM(57,VDATA_VERY_LARGE) == 57 END
BEGIN BOOST_PP_VARIADIC_ELEM(35, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63) == 35 END
BEGIN BOOST_PP_VARIADIC_SIZE(VDATA) == 7 END
BEGIN BOOST_PP_VARIADIC_SIZE(7,11,3,8,14,85,56,92,165) == 9 END
BEGIN BOOST_PP_VARIADIC_SIZE(VDATA_LARGE) == 33 END
BEGIN BOOST_PP_VARIADIC_SIZE(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32) == 33 END
BEGIN BOOST_PP_VARIADIC_SIZE(VDATA_VERY_LARGE) == 64 END

#if BOOST_PP_VARIADIC_HAS_OPT()

BEGIN BOOST_PP_VARIADIC_SIZE(VDATA_EMPTY) == 0 END
BEGIN BOOST_PP_VARIADIC_SIZE() == 0 END

#endif

BEGIN BOOST_PP_ARRAY_SIZE(BOOST_PP_VARIADIC_TO_ARRAY(VDATA)) == 7 END
BEGIN BOOST_PP_ARRAY_SIZE(BOOST_PP_VARIADIC_TO_ARRAY(VDATA_VERY_LARGE)) == 64 END
BEGIN BOOST_PP_ARRAY_ELEM(4,BOOST_PP_VARIADIC_TO_ARRAY(7,11,3,8,14,85,56,92,165)) == 14 END
BEGIN BOOST_PP_ARRAY_ELEM(30,BOOST_PP_VARIADIC_TO_ARRAY(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32)) == 30 END
BEGIN BOOST_PP_LIST_AT(BOOST_PP_VARIADIC_TO_LIST(VDATA),3) == 3 END
BEGIN BOOST_PP_LIST_AT(BOOST_PP_VARIADIC_TO_LIST(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63),49) == 49 END
BEGIN BOOST_PP_LIST_SIZE(BOOST_PP_VARIADIC_TO_LIST(7,11,3,8,14,85,56,92,165)) == 9 END
BEGIN BOOST_PP_LIST_SIZE(BOOST_PP_VARIADIC_TO_LIST(VDATA_LARGE)) == 33 END
BEGIN BOOST_PP_SEQ_ELEM(5,BOOST_PP_VARIADIC_TO_SEQ(VDATA)) == 5 END
BEGIN BOOST_PP_SEQ_ELEM(16,BOOST_PP_VARIADIC_TO_SEQ(VDATA_LARGE)) == 16 END
BEGIN BOOST_PP_SEQ_SIZE(BOOST_PP_VARIADIC_TO_SEQ(3,78,22,11,3)) == 5 END
BEGIN BOOST_PP_SEQ_SIZE(BOOST_PP_VARIADIC_TO_SEQ(VDATA_VERY_LARGE)) == 64 END
BEGIN BOOST_PP_TUPLE_SIZE(BOOST_PP_VARIADIC_TO_TUPLE(VDATA)) == 7 END
BEGIN BOOST_PP_TUPLE_SIZE(BOOST_PP_VARIADIC_TO_TUPLE(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63)) == 64 END
BEGIN BOOST_PP_TUPLE_ELEM(8,BOOST_PP_VARIADIC_TO_TUPLE(7,11,3,8,14,85,56,92,165)) == 165 END
BEGIN BOOST_PP_TUPLE_ELEM(27,BOOST_PP_VARIADIC_TO_TUPLE(VDATA_LARGE)) == 27 END

#if BOOST_PP_LIMIT_VARIADIC > 64

BEGIN BOOST_PP_VARIADIC_ELEM(47,VDATA_LARGE_128) == 47 END
BEGIN BOOST_PP_VARIADIC_ELEM(81,VDATA_LARGE_128) == 81 END
BEGIN BOOST_PP_VARIADIC_ELEM(29,VDATA_VERY_LARGE_128) == 29 END
BEGIN BOOST_PP_VARIADIC_ELEM(112,VDATA_VERY_LARGE_128) == 112 END
BEGIN BOOST_PP_VARIADIC_SIZE(VDATA_LARGE_128) == 96 END
BEGIN BOOST_PP_VARIADIC_SIZE(VDATA_VERY_LARGE_128) == 128 END

#if BOOST_PP_LIMIT_TUPLE > 64

BEGIN BOOST_PP_ARRAY_SIZE(BOOST_PP_VARIADIC_TO_ARRAY(VDATA_LARGE_128)) == 96 END
BEGIN BOOST_PP_ARRAY_SIZE(BOOST_PP_VARIADIC_TO_ARRAY(VDATA_VERY_LARGE_128)) == 128 END
BEGIN BOOST_PP_ARRAY_ELEM(83,BOOST_PP_VARIADIC_TO_ARRAY(VDATA_LARGE_128)) == 83 END
BEGIN BOOST_PP_ARRAY_ELEM(117,BOOST_PP_VARIADIC_TO_ARRAY(VDATA_VERY_LARGE_128)) == 117 END

#endif

BEGIN BOOST_PP_LIST_AT(BOOST_PP_VARIADIC_TO_LIST(VDATA_LARGE_128),79) == 79 END
BEGIN BOOST_PP_LIST_SIZE(BOOST_PP_VARIADIC_TO_LIST(VDATA_VERY_LARGE_128)) == 128 END
BEGIN BOOST_PP_SEQ_ELEM(113,BOOST_PP_VARIADIC_TO_SEQ(VDATA_VERY_LARGE_128)) == 113 END
BEGIN BOOST_PP_SEQ_ELEM(82,BOOST_PP_VARIADIC_TO_SEQ(VDATA_LARGE_128)) == 82 END
BEGIN BOOST_PP_SEQ_SIZE(BOOST_PP_VARIADIC_TO_SEQ(VDATA_LARGE_128)) == 96 END

#if BOOST_PP_LIMIT_TUPLE > 64

BEGIN BOOST_PP_TUPLE_SIZE(BOOST_PP_VARIADIC_TO_TUPLE(VDATA_VERY_LARGE_128)) == 128 END
BEGIN BOOST_PP_TUPLE_ELEM(77,BOOST_PP_VARIADIC_TO_TUPLE(VDATA_LARGE_128)) == 77 END

#endif

#endif

#if BOOST_PP_LIMIT_VARIADIC > 128

BEGIN BOOST_PP_VARIADIC_ELEM(47,VDATA_LARGE_256) == 47 END
BEGIN BOOST_PP_VARIADIC_ELEM(110,VDATA_LARGE_256) == 110 END
BEGIN BOOST_PP_VARIADIC_ELEM(135,VDATA_LARGE_256) == 135 END
BEGIN BOOST_PP_VARIADIC_ELEM(36,VDATA_VERY_LARGE_256) == 36 END
BEGIN BOOST_PP_VARIADIC_ELEM(95,VDATA_VERY_LARGE_256) == 95 END
BEGIN BOOST_PP_VARIADIC_ELEM(161,VDATA_VERY_LARGE_256) == 161 END
BEGIN BOOST_PP_VARIADIC_ELEM(217,VDATA_VERY_LARGE_256) == 217 END
BEGIN BOOST_PP_VARIADIC_SIZE(VDATA_LARGE_256) == 139 END
BEGIN BOOST_PP_VARIADIC_SIZE(VDATA_VERY_LARGE_256) == 256 END

#if BOOST_PP_LIMIT_TUPLE > 128

BEGIN BOOST_PP_ARRAY_SIZE(BOOST_PP_VARIADIC_TO_ARRAY(VDATA_LARGE_256)) == 139 END
BEGIN BOOST_PP_ARRAY_SIZE(BOOST_PP_VARIADIC_TO_ARRAY(VDATA_VERY_LARGE_256)) == 256 END
BEGIN BOOST_PP_ARRAY_ELEM(133,BOOST_PP_VARIADIC_TO_ARRAY(VDATA_LARGE_256)) == 133 END
BEGIN BOOST_PP_ARRAY_ELEM(203,BOOST_PP_VARIADIC_TO_ARRAY(VDATA_VERY_LARGE_256)) == 203 END

#endif

BEGIN BOOST_PP_LIST_AT(BOOST_PP_VARIADIC_TO_LIST(VDATA_LARGE_256),137) == 137 END
BEGIN BOOST_PP_LIST_SIZE(BOOST_PP_VARIADIC_TO_LIST(VDATA_VERY_LARGE_256)) == 256 END
BEGIN BOOST_PP_SEQ_ELEM(212,BOOST_PP_VARIADIC_TO_SEQ(VDATA_VERY_LARGE_256)) == 212 END
BEGIN BOOST_PP_SEQ_ELEM(129,BOOST_PP_VARIADIC_TO_SEQ(VDATA_LARGE_256)) == 129 END
BEGIN BOOST_PP_SEQ_SIZE(BOOST_PP_VARIADIC_TO_SEQ(VDATA_LARGE_256)) == 139 END

#if BOOST_PP_LIMIT_TUPLE > 128

BEGIN BOOST_PP_TUPLE_SIZE(BOOST_PP_VARIADIC_TO_TUPLE(VDATA_VERY_LARGE_256)) == 256 END
BEGIN BOOST_PP_TUPLE_ELEM(133,BOOST_PP_VARIADIC_TO_TUPLE(VDATA_LARGE_256)) == 133 END

#endif

#endif
