#ifndef __VMLINUX_H__
#define __VMLINUX_H__

#ifndef BPF_NO_PRESERVE_ACCESS_INDEX
#pragma clang attribute push (__attribute__((preserve_access_index)), apply_to = record)
#endif

typedef signed char __s8;

typedef unsigned char __u8;

typedef short int __s16;

typedef short unsigned int __u16;

typedef int __s32;

typedef unsigned int __u32;

typedef long long int __s64;

typedef long long unsigned int __u64;

typedef __s8 s8;

typedef __u8 u8;

typedef __s16 s16;

typedef __u16 u16;

typedef __s32 s32;

typedef __u32 u32;

typedef __s64 s64;

typedef __u64 u64;

typedef struct {
	__u32 u[4];
} __vector128;

typedef __vector128 vector128;

enum {
	false = 0,
	true = 1,
};

typedef long int __kernel_long_t;

typedef long unsigned int __kernel_ulong_t;

typedef int __kernel_pid_t;

typedef unsigned int __kernel_uid32_t;

typedef unsigned int __kernel_gid32_t;

typedef __kernel_ulong_t __kernel_size_t;

typedef __kernel_long_t __kernel_ssize_t;

typedef long long int __kernel_loff_t;

typedef long long int __kernel_time64_t;

typedef __kernel_long_t __kernel_clock_t;

typedef int __kernel_timer_t;

typedef int __kernel_clockid_t;

typedef __u16 __le16;

typedef __u16 __be16;

typedef __u32 __le32;

typedef __u32 __be32;

typedef __u64 __le64;

typedef __u64 __be64;

typedef unsigned int __poll_t;

typedef u32 __kernel_dev_t;

typedef __kernel_dev_t dev_t;

typedef short unsigned int umode_t;

typedef __kernel_pid_t pid_t;

typedef __kernel_clockid_t clockid_t;

typedef _Bool bool;

typedef __kernel_uid32_t uid_t;

typedef __kernel_gid32_t gid_t;

typedef __kernel_loff_t loff_t;

typedef __kernel_size_t size_t;

typedef __kernel_ssize_t ssize_t;

typedef long unsigned int ulong;

typedef s32 int32_t;

typedef u32 uint32_t;

typedef u64 sector_t;

typedef u64 blkcnt_t;

typedef u64 dma_addr_t;

typedef unsigned int gfp_t;

typedef unsigned int fmode_t;

typedef struct {
	int counter;
} atomic_t;

typedef struct {
	s64 counter;
} atomic64_t;

struct list_head {
	struct list_head *next;
	struct list_head *prev;
};

struct hlist_node;

struct hlist_head {
	struct hlist_node *first;
};

struct hlist_node {
	struct hlist_node *next;
	struct hlist_node **pprev;
};

struct callback_head {
	struct callback_head *next;
	void (*func)(struct callback_head *);
};

struct user_pt_regs {
	long unsigned int gpr[32];
	long unsigned int nip;
	long unsigned int msr;
	long unsigned int orig_gpr3;
	long unsigned int ctr;
	long unsigned int link;
	long unsigned int xer;
	long unsigned int ccr;
	long unsigned int softe;
	long unsigned int trap;
	long unsigned int dar;
	long unsigned int dsisr;
	long unsigned int result;
};

struct pt_regs {
	union {
		struct user_pt_regs user_regs;
		struct {
			long unsigned int gpr[32];
			long unsigned int nip;
			long unsigned int msr;
			long unsigned int orig_gpr3;
			long unsigned int ctr;
			long unsigned int link;
			long unsigned int xer;
			long unsigned int ccr;
			long unsigned int softe;
			long unsigned int trap;
			union {
				long unsigned int dar;
				long unsigned int dear;
			};
			union {
				long unsigned int dsisr;
				long unsigned int esr;
			};
			long unsigned int result;
		};
	};
	union {
		struct {
			long unsigned int ppr;
			long unsigned int exit_result;
			union {
				long unsigned int kuap;
				long unsigned int amr;
			};
			long unsigned int iamr;
		};
		long unsigned int __pad[4];
	};
};

struct lock_class_key {};

struct fs_context;

struct fs_parameter_spec;

struct dentry;

struct super_block;

struct module;

struct file_system_type {
	const char *name;
	int fs_flags;
	int (*init_fs_context)(struct fs_context *);
	const struct fs_parameter_spec *parameters;
	struct dentry * (*mount)(struct file_system_type *, int, const char *, void *);
	void (*kill_sb)(struct super_block *);
	struct module *owner;
	struct file_system_type *next;
	struct hlist_head fs_supers;
	struct lock_class_key s_lock_key;
	struct lock_class_key s_umount_key;
	struct lock_class_key s_vfs_rename_key;
	struct lock_class_key s_writers_key[3];
	struct lock_class_key i_lock_key;
	struct lock_class_key i_mutex_key;
	struct lock_class_key invalidate_lock_key;
	struct lock_class_key i_mutex_dir_key;
};

struct obs_kernel_param {
	const char *str;
	int (*setup_func)(char *);
	int early;
};

struct qspinlock {
	union {
		u32 val;
		struct {
			u16 locked;
			u8 reserved[2];
		};
	};
};

typedef struct qspinlock arch_spinlock_t;

struct qrwlock {
	union {
		atomic_t cnts;
		struct {
			u8 wlocked;
			u8 __lstate[3];
		};
	};
	arch_spinlock_t wait_lock;
};

typedef struct qrwlock arch_rwlock_t;

struct lockdep_map {};

struct raw_spinlock {
	arch_spinlock_t raw_lock;
};

typedef struct raw_spinlock raw_spinlock_t;

struct ratelimit_state {
	raw_spinlock_t lock;
	int interval;
	int burst;
	int printed;
	int missed;
	long unsigned int begin;
	long unsigned int flags;
};

typedef void *fl_owner_t;

struct file;

struct kiocb;

struct iov_iter;

struct io_comp_batch;

struct dir_context;

struct poll_table_struct;

struct vm_area_struct;

struct inode;

struct file_lock;

struct pipe_inode_info;

struct seq_file;

struct io_uring_cmd;

struct file_operations {
	struct module *owner;
	loff_t (*llseek)(struct file *, loff_t, int);
	ssize_t (*read)(struct file *, char *, size_t, loff_t *);
	ssize_t (*write)(struct file *, const char *, size_t, loff_t *);
	ssize_t (*read_iter)(struct kiocb *, struct iov_iter *);
	ssize_t (*write_iter)(struct kiocb *, struct iov_iter *);
	int (*iopoll)(struct kiocb *, struct io_comp_batch *, unsigned int);
	int (*iterate_shared)(struct file *, struct dir_context *);
	__poll_t (*poll)(struct file *, struct poll_table_struct *);
	long int (*unlocked_ioctl)(struct file *, unsigned int, long unsigned int);
	long int (*compat_ioctl)(struct file *, unsigned int, long unsigned int);
	int (*mmap)(struct file *, struct vm_area_struct *);
	long unsigned int mmap_supported_flags;
	int (*open)(struct inode *, struct file *);
	int (*flush)(struct file *, fl_owner_t);
	int (*release)(struct inode *, struct file *);
	int (*fsync)(struct file *, loff_t, loff_t, int);
	int (*fasync)(int, struct file *, int);
	int (*lock)(struct file *, int, struct file_lock *);
	long unsigned int (*get_unmapped_area)(struct file *, long unsigned int, long unsigned int, long unsigned int, long unsigned int);
	int (*check_flags)(int);
	int (*flock)(struct file *, int, struct file_lock *);
	ssize_t (*splice_write)(struct pipe_inode_info *, struct file *, loff_t *, size_t, unsigned int);
	ssize_t (*splice_read)(struct file *, loff_t *, struct pipe_inode_info *, size_t, unsigned int);
	void (*splice_eof)(struct file *);
	int (*setlease)(struct file *, int, struct file_lock **, void **);
	long int (*fallocate)(struct file *, int, loff_t, loff_t);
	void (*show_fdinfo)(struct seq_file *, struct file *);
	ssize_t (*copy_file_range)(struct file *, loff_t, struct file *, loff_t, size_t, unsigned int);
	loff_t (*remap_file_range)(struct file *, loff_t, struct file *, loff_t, loff_t, unsigned int);
	int (*fadvise)(struct file *, loff_t, loff_t, int);
	int (*uring_cmd)(struct io_uring_cmd *, unsigned int);
	int (*uring_cmd_iopoll)(struct io_uring_cmd *, struct io_comp_batch *, unsigned int);
};

struct static_call_key {
	void *func;
};

struct bug_entry {
	int bug_addr_disp;
	int file_disp;
	short unsigned int line;
	short unsigned int flags;
};

typedef __s64 time64_t;

struct __kernel_timespec {
	__kernel_time64_t tv_sec;
	long long int tv_nsec;
};

struct timespec64 {
	time64_t tv_sec;
	long int tv_nsec;
};

enum timespec_type {
	TT_NONE = 0,
	TT_NATIVE = 1,
	TT_COMPAT = 2,
};

typedef s32 old_time32_t;

struct old_timespec32 {
	old_time32_t tv_sec;
	s32 tv_nsec;
};

struct pollfd {
	int fd;
	short int events;
	short int revents;
};

struct restart_block {
	long unsigned int arch_data;
	long int (*fn)(struct restart_block *);
	union {
		struct {
			u32 *uaddr;
			u32 val;
			u32 flags;
			u32 bitset;
			u64 time;
			u32 *uaddr2;
		} futex;
		struct {
			clockid_t clockid;
			enum timespec_type type;
			union {
				struct __kernel_timespec *rmtp;
				struct old_timespec32 *compat_rmtp;
			};
			u64 expires;
		} nanosleep;
		struct {
			struct pollfd *ufds;
			int nfds;
			int has_timeout;
			long unsigned int tv_sec;
			long unsigned int tv_nsec;
		} poll;
	};
};

typedef struct {
	__be64 pte;
} pte_t;

typedef struct {
	__be64 pmd;
} pmd_t;

typedef struct {
	__be64 pud;
} pud_t;

typedef struct {
	__be64 pgd;
} pgd_t;

typedef struct {
	long unsigned int pgprot;
} pgprot_t;

typedef pte_t *pgtable_t;

struct jump_entry {
	s32 code;
	s32 target;
	long int key;
};

struct static_key_mod;

struct static_key {
	atomic_t enabled;
	union {
		long unsigned int type;
		struct jump_entry *entries;
		struct static_key_mod *next;
	};
};

typedef atomic64_t atomic_long_t;

struct address_space;

struct page_pool;

struct dev_pagemap;

struct page {
	long unsigned int flags;
	union {
		struct {
			union {
				struct list_head lru;
				struct {
					void *__filler;
					unsigned int mlock_count;
				};
				struct list_head buddy_list;
				struct list_head pcp_list;
			};
			struct address_space *mapping;
			union {
				long unsigned int index;
				long unsigned int share;
			};
			long unsigned int private;
		};
		struct {
			long unsigned int pp_magic;
			struct page_pool *pp;
			long unsigned int _pp_mapping_pad;
			long unsigned int dma_addr;
			union {
				long unsigned int dma_addr_upper;
				atomic_long_t pp_frag_count;
			};
		};
		struct {
			long unsigned int compound_head;
		};
		struct {
			struct dev_pagemap *pgmap;
			void *zone_device_data;
		};
		struct callback_head callback_head;
	};
	union {
		atomic_t _mapcount;
		unsigned int page_type;
	};
	atomic_t _refcount;
	long unsigned int memcg_data;
};

struct slb_entry {
	u64 esid;
	u64 vsid;
};

struct slice_mask {
	u64 low_slices;
	long unsigned int high_slices[64];
};

struct hash_mm_context {
	u16 user_psize;
	unsigned char low_slices_psize[8];
	unsigned char high_slices_psize[2048];
	long unsigned int slb_addr_limit;
	struct slice_mask mask_64k;
	struct slice_mask mask_4k;
	struct slice_mask mask_16m;
	struct slice_mask mask_16g;
};

typedef long unsigned int mm_context_id_t;

typedef struct {
	union {
		mm_context_id_t id;
		mm_context_id_t extended_id[8];
	};
	atomic_t active_cpus;
	atomic_t copros;
	atomic_t vas_windows;
	struct hash_mm_context *hash_context;
	void *vdso;
	void *pte_frag;
	void *pmd_frag;
	struct list_head iommu_group_mem_list;
	u32 pkey_allocation_map;
	s16 execute_only_pkey;
} mm_context_t;

struct kvmppc_vcore;

struct kvm_split_mode {
	long unsigned int rpr;
	long unsigned int pmmar;
	long unsigned int ldbar;
	u8 subcore_size;
	u8 do_nap;
	u8 napped[8];
	struct kvmppc_vcore *vc[4];
};

struct kvm_vcpu;

struct kvmppc_host_state {
	ulong host_r1;
	ulong host_r2;
	ulong host_msr;
	ulong vmhandler;
	ulong scratch0;
	ulong scratch1;
	ulong scratch2;
	u8 in_guest;
	u8 restore_hid5;
	u8 napping;
	u8 hwthread_req;
	u8 hwthread_state;
	u8 host_ipi;
	u8 ptid;
	u8 fake_suspend;
	struct kvm_vcpu *kvm_vcpu;
	struct kvmppc_vcore *kvm_vcore;
	void *xics_phys;
	void *xive_tima_phys;
	void *xive_tima_virt;
	u32 saved_xirr;
	u64 dabr;
	u64 host_mmcr[7];
	u32 host_pmc[8];
	u64 host_purr;
	u64 host_spurr;
	u64 host_dscr;
	u64 dec_expires;
	struct kvm_split_mode *kvm_split_mode;
	u64 cfar;
	u64 ppr;
	u64 host_fscr;
};

struct cpu_accounting_data {
	long unsigned int utime;
	long unsigned int stime;
	long unsigned int gtime;
	long unsigned int hardirq_time;
	long unsigned int softirq_time;
	long unsigned int steal_time;
	long unsigned int idle_time;
	long unsigned int starttime;
	long unsigned int starttime_user;
};

struct sibling_subcore_state {
	long unsigned int flags;
	u8 in_guest[4];
};

enum MCE_Version {
	MCE_V1 = 1,
};

enum MCE_Severity {
	MCE_SEV_NO_ERROR = 0,
	MCE_SEV_WARNING = 1,
	MCE_SEV_SEVERE = 2,
	MCE_SEV_FATAL = 3,
};

enum MCE_Disposition {
	MCE_DISPOSITION_RECOVERED = 0,
	MCE_DISPOSITION_NOT_RECOVERED = 1,
};

enum MCE_Initiator {
	MCE_INITIATOR_UNKNOWN = 0,
	MCE_INITIATOR_CPU = 1,
	MCE_INITIATOR_PCI = 2,
	MCE_INITIATOR_ISA = 3,
	MCE_INITIATOR_MEMORY = 4,
	MCE_INITIATOR_POWERMGM = 5,
};

enum MCE_ErrorType {
	MCE_ERROR_TYPE_UNKNOWN = 0,
	MCE_ERROR_TYPE_UE = 1,
	MCE_ERROR_TYPE_SLB = 2,
	MCE_ERROR_TYPE_ERAT = 3,
	MCE_ERROR_TYPE_TLB = 4,
	MCE_ERROR_TYPE_USER = 5,
	MCE_ERROR_TYPE_RA = 6,
	MCE_ERROR_TYPE_LINK = 7,
	MCE_ERROR_TYPE_DCACHE = 8,
	MCE_ERROR_TYPE_ICACHE = 9,
};

enum MCE_ErrorClass {
	MCE_ECLASS_UNKNOWN = 0,
	MCE_ECLASS_HARDWARE = 1,
	MCE_ECLASS_HARD_INDETERMINATE = 2,
	MCE_ECLASS_SOFTWARE = 3,
	MCE_ECLASS_SOFT_INDETERMINATE = 4,
};

enum MCE_UeErrorType {
	MCE_UE_ERROR_INDETERMINATE = 0,
	MCE_UE_ERROR_IFETCH = 1,
	MCE_UE_ERROR_PAGE_TABLE_WALK_IFETCH = 2,
	MCE_UE_ERROR_LOAD_STORE = 3,
	MCE_UE_ERROR_PAGE_TABLE_WALK_LOAD_STORE = 4,
};

enum MCE_SlbErrorType {
	MCE_SLB_ERROR_INDETERMINATE = 0,
	MCE_SLB_ERROR_PARITY = 1,
	MCE_SLB_ERROR_MULTIHIT = 2,
};

enum MCE_EratErrorType {
	MCE_ERAT_ERROR_INDETERMINATE = 0,
	MCE_ERAT_ERROR_PARITY = 1,
	MCE_ERAT_ERROR_MULTIHIT = 2,
};

enum MCE_TlbErrorType {
	MCE_TLB_ERROR_INDETERMINATE = 0,
	MCE_TLB_ERROR_PARITY = 1,
	MCE_TLB_ERROR_MULTIHIT = 2,
};

enum MCE_UserErrorType {
	MCE_USER_ERROR_INDETERMINATE = 0,
	MCE_USER_ERROR_TLBIE = 1,
	MCE_USER_ERROR_SCV = 2,
};

enum MCE_RaErrorType {
	MCE_RA_ERROR_INDETERMINATE = 0,
	MCE_RA_ERROR_IFETCH = 1,
	MCE_RA_ERROR_IFETCH_FOREIGN = 2,
	MCE_RA_ERROR_PAGE_TABLE_WALK_IFETCH = 3,
	MCE_RA_ERROR_PAGE_TABLE_WALK_IFETCH_FOREIGN = 4,
	MCE_RA_ERROR_LOAD = 5,
	MCE_RA_ERROR_STORE = 6,
	MCE_RA_ERROR_PAGE_TABLE_WALK_LOAD_STORE = 7,
	MCE_RA_ERROR_PAGE_TABLE_WALK_LOAD_STORE_FOREIGN = 8,
	MCE_RA_ERROR_LOAD_STORE_FOREIGN = 9,
};

enum MCE_LinkErrorType {
	MCE_LINK_ERROR_INDETERMINATE = 0,
	MCE_LINK_ERROR_IFETCH_TIMEOUT = 1,
	MCE_LINK_ERROR_PAGE_TABLE_WALK_IFETCH_TIMEOUT = 2,
	MCE_LINK_ERROR_LOAD_TIMEOUT = 3,
	MCE_LINK_ERROR_STORE_TIMEOUT = 4,
	MCE_LINK_ERROR_PAGE_TABLE_WALK_LOAD_STORE_TIMEOUT = 5,
};

struct machine_check_event {
	enum MCE_Version version: 8;
	u8 in_use;
	enum MCE_Severity severity: 8;
	enum MCE_Initiator initiator: 8;
	enum MCE_ErrorType error_type: 8;
	enum MCE_ErrorClass error_class: 8;
	enum MCE_Disposition disposition: 8;
	bool sync_error;
	u16 cpu;
	u64 gpr3;
	u64 srr0;
	u64 srr1;
	union {
		struct {
			enum MCE_UeErrorType ue_error_type: 8;
			u8 effective_address_provided;
			u8 physical_address_provided;
			u8 ignore_event;
			u8 reserved_1[4];
			u64 effective_address;
			u64 physical_address;
			u8 reserved_2[8];
		} ue_error;
		struct {
			enum MCE_SlbErrorType slb_error_type: 8;
			u8 effective_address_provided;
			u8 reserved_1[6];
			u64 effective_address;
			u8 reserved_2[16];
		} slb_error;
		struct {
			enum MCE_EratErrorType erat_error_type: 8;
			u8 effective_address_provided;
			u8 reserved_1[6];
			u64 effective_address;
			u8 reserved_2[16];
		} erat_error;
		struct {
			enum MCE_TlbErrorType tlb_error_type: 8;
			u8 effective_address_provided;
			u8 reserved_1[6];
			u64 effective_address;
			u8 reserved_2[16];
		} tlb_error;
		struct {
			enum MCE_UserErrorType user_error_type: 8;
			u8 effective_address_provided;
			u8 reserved_1[6];
			u64 effective_address;
			u8 reserved_2[16];
		} user_error;
		struct {
			enum MCE_RaErrorType ra_error_type: 8;
			u8 effective_address_provided;
			u8 reserved_1[6];
			u64 effective_address;
			u8 reserved_2[16];
		} ra_error;
		struct {
			enum MCE_LinkErrorType link_error_type: 8;
			u8 effective_address_provided;
			u8 reserved_1[6];
			u64 effective_address;
			u8 reserved_2[16];
		} link_error;
	} u;
};

struct mce_info {
	int mce_nest_count;
	struct machine_check_event mce_event[10];
	int mce_queue_count;
	struct machine_check_event mce_event_queue[10];
	int mce_ue_count;
	struct machine_check_event mce_ue_event_queue[10];
};

struct mmiowb_state {
	u16 nesting_count;
	u16 mmiowb_pending;
};

struct lppaca;

struct slb_shadow;

struct dtl_entry;

struct task_struct;

struct paca_struct {
	struct lppaca *lppaca_ptr;
	u16 paca_index;
	u16 lock_token;
	u64 kernel_toc;
	u64 kernelbase;
	u64 kernel_msr;
	void *emergency_sp;
	u64 data_offset;
	s16 hw_cpu_id;
	u8 cpu_start;
	u8 kexec_state;
	struct slb_shadow *slb_shadow_ptr;
	struct dtl_entry *dispatch_log;
	struct dtl_entry *dispatch_log_end;
	u64 dscr_default;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	u64 exgen[10];
	u16 vmalloc_sllp;
	u8 slb_cache_ptr;
	u8 stab_rr;
	u8 in_kernel_slb_handler;
	u32 slb_used_bitmap;
	u32 slb_kern_bitmap;
	u32 slb_cache[8];
	unsigned char mm_ctx_low_slices_psize[8];
	unsigned char mm_ctx_high_slices_psize[2048];
	struct task_struct *__current;
	u64 kstack;
	u64 saved_r1;
	u64 saved_msr;
	u64 exit_save_r1;
	u8 hsrr_valid;
	u8 srr_valid;
	u8 irq_soft_mask;
	u8 irq_happened;
	u8 irq_work_pending;
	u8 pmcregs_in_use;
	u64 sprg_vdso;
	u64 tm_scratch;
	long unsigned int idle_lock;
	long unsigned int idle_state;
	union {
		struct {
			u8 thread_idle_state;
			u8 subcore_sibling_mask;
		};
		struct {
			u64 requested_psscr;
			atomic_t dont_stop;
		};
	};
	u64 exnmi[10];
	u64 exmc[10];
	void *nmi_emergency_sp;
	void *mc_emergency_sp;
	u16 in_nmi;
	u16 in_mce;
	u8 hmi_event_available;
	u8 hmi_p9_special_emu;
	u32 hmi_irqs;
	u8 ftrace_enabled;
	struct cpu_accounting_data accounting;
	u64 dtl_ridx;
	struct dtl_entry *dtl_curr;
	struct kvmppc_host_state kvm_hstate;
	struct sibling_subcore_state *sibling_subcore_state;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	u64 exrfi[10];
	void *rfi_flush_fallback_area;
	u64 l1d_flush_size;
	u8 *mce_data_buf;
	struct slb_entry *mce_faulty_slbs;
	u16 slb_save_cache_ptr;
	long unsigned int canary;
	struct mmiowb_state mmiowb_state;
	struct mce_info *mce_info;
	u8 mce_pending_irq_work;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct lppaca {
	__be32 desc;
	__be16 size;
	u8 reserved1[3];
	u8 __old_status;
	u8 reserved3[14];
	volatile __be32 dyn_hw_node_id;
	volatile __be32 dyn_hw_proc_id;
	u8 reserved4[56];
	volatile u8 vphn_assoc_counts[8];
	u8 reserved5[32];
	u8 reserved6[48];
	u8 cede_latency_hint;
	u8 ebb_regs_in_use;
	u8 reserved7[6];
	u8 dtl_enable_mask;
	u8 donate_dedicated_cpu;
	u8 fpregs_in_use;
	u8 pmcregs_in_use;
	u8 reserved8[28];
	__be64 wait_state_cycles;
	u8 reserved9[28];
	__be16 slb_count;
	u8 idle;
	u8 vmxregs_in_use;
	volatile __be32 yield_count;
	volatile __be32 dispersion_count;
	volatile __be64 cmo_faults;
	volatile __be64 cmo_fault_time;
	u8 reserved10[64];
	volatile __be64 enqueue_dispatch_tb;
	volatile __be64 ready_enqueue_tb;
	volatile __be64 wait_ready_tb;
	u8 reserved11[16];
	__be32 page_ins;
	u8 reserved12[148];
	volatile __be64 dtl_idx;
	u8 reserved13[96];
};

struct slb_shadow {
	__be32 persistent;
	__be32 buffer_length;
	__be64 reserved;
	struct {
		__be64 esid;
		__be64 vsid;
	} save_area[2];
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct thread_info {
	int preempt_count;
	unsigned int cpu;
	long unsigned int local_flags;
	unsigned char slb_preload_nr;
	unsigned char slb_preload_tail;
	u32 slb_preload_esid[16];
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long unsigned int flags;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct refcount_struct {
	atomic_t refs;
};

typedef struct refcount_struct refcount_t;

struct llist_node {
	struct llist_node *next;
};

struct __call_single_node {
	struct llist_node llist;
	union {
		unsigned int u_flags;
		atomic_t a_flags;
	};
	u16 src;
	u16 dst;
};

struct load_weight {
	long unsigned int weight;
	u32 inv_weight;
};

struct rb_node {
	long unsigned int __rb_parent_color;
	struct rb_node *rb_right;
	struct rb_node *rb_left;
};

struct util_est {
	unsigned int enqueued;
	unsigned int ewma;
};

struct sched_avg {
	u64 last_update_time;
	u64 load_sum;
	u64 runnable_sum;
	u32 util_sum;
	u32 period_contrib;
	long unsigned int load_avg;
	long unsigned int runnable_avg;
	long unsigned int util_avg;
	struct util_est util_est;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct cfs_rq;

struct sched_entity {
	struct load_weight load;
	struct rb_node run_node;
	u64 deadline;
	u64 min_deadline;
	struct list_head group_node;
	unsigned int on_rq;
	u64 exec_start;
	u64 sum_exec_runtime;
	u64 prev_sum_exec_runtime;
	u64 vruntime;
	s64 vlag;
	u64 slice;
	u64 nr_migrations;
	int depth;
	struct sched_entity *parent;
	struct cfs_rq *cfs_rq;
	struct cfs_rq *my_q;
	long unsigned int runnable_weight;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct sched_avg avg;
};

struct sched_rt_entity {
	struct list_head run_list;
	long unsigned int timeout;
	long unsigned int watchdog_stamp;
	unsigned int time_slice;
	short unsigned int on_rq;
	short unsigned int on_list;
	struct sched_rt_entity *back;
};

typedef s64 ktime_t;

struct timerqueue_node {
	struct rb_node node;
	ktime_t expires;
};

enum hrtimer_restart {
	HRTIMER_NORESTART = 0,
	HRTIMER_RESTART = 1,
};

struct hrtimer_clock_base;

struct hrtimer {
	struct timerqueue_node node;
	ktime_t _softexpires;
	enum hrtimer_restart (*function)(struct hrtimer *);
	struct hrtimer_clock_base *base;
	u8 state;
	u8 is_rel;
	u8 is_soft;
	u8 is_hard;
};

struct sched_dl_entity {
	struct rb_node rb_node;
	u64 dl_runtime;
	u64 dl_deadline;
	u64 dl_period;
	u64 dl_bw;
	u64 dl_density;
	s64 runtime;
	u64 deadline;
	unsigned int flags;
	unsigned int dl_throttled: 1;
	unsigned int dl_yielded: 1;
	unsigned int dl_non_contending: 1;
	unsigned int dl_overrun: 1;
	struct hrtimer dl_timer;
	struct hrtimer inactive_timer;
	struct sched_dl_entity *pi_se;
};

struct sched_statistics {
	u64 wait_start;
	u64 wait_max;
	u64 wait_count;
	u64 wait_sum;
	u64 iowait_count;
	u64 iowait_sum;
	u64 sleep_start;
	u64 sleep_max;
	s64 sum_sleep_runtime;
	u64 block_start;
	u64 block_max;
	s64 sum_block_runtime;
	u64 exec_max;
	u64 slice_max;
	u64 nr_migrations_cold;
	u64 nr_failed_migrations_affine;
	u64 nr_failed_migrations_running;
	u64 nr_failed_migrations_hot;
	u64 nr_forced_migrations;
	u64 nr_wakeups;
	u64 nr_wakeups_sync;
	u64 nr_wakeups_migrate;
	u64 nr_wakeups_local;
	u64 nr_wakeups_remote;
	u64 nr_wakeups_affine;
	u64 nr_wakeups_affine_attempts;
	u64 nr_wakeups_passive;
	u64 nr_wakeups_idle;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct cpumask {
	long unsigned int bits[32];
};

typedef struct cpumask cpumask_t;

union rcu_special {
	struct {
		u8 blocked;
		u8 need_qs;
		u8 exp_hint;
		u8 need_mb;
	} b;
	u32 s;
};

struct sched_info {
	long unsigned int pcount;
	long long unsigned int run_delay;
	long long unsigned int last_arrival;
	long long unsigned int last_queued;
};

struct plist_node {
	int prio;
	struct list_head prio_list;
	struct list_head node_list;
};

struct prev_cputime {
	u64 utime;
	u64 stime;
	raw_spinlock_t lock;
};

struct seqcount {
	unsigned int sequence;
};

typedef struct seqcount seqcount_t;

enum vtime_state {
	VTIME_INACTIVE = 0,
	VTIME_IDLE = 1,
	VTIME_SYS = 2,
	VTIME_USER = 3,
	VTIME_GUEST = 4,
};

struct vtime {
	seqcount_t seqcount;
	long long unsigned int starttime;
	enum vtime_state state;
	unsigned int cpu;
	u64 utime;
	u64 stime;
	u64 gtime;
};

struct rb_root {
	struct rb_node *rb_node;
};

struct rb_root_cached {
	struct rb_root rb_root;
	struct rb_node *rb_leftmost;
};

struct timerqueue_head {
	struct rb_root_cached rb_root;
};

struct posix_cputimer_base {
	u64 nextevt;
	struct timerqueue_head tqhead;
};

struct posix_cputimers {
	struct posix_cputimer_base bases[3];
	unsigned int timers_active;
	unsigned int expiry_active;
};

struct sem_undo_list;

struct sysv_sem {
	struct sem_undo_list *undo_list;
};

struct sysv_shm {
	struct list_head shm_clist;
};

typedef struct {
	long unsigned int sig[1];
} sigset_t;

struct sigpending {
	struct list_head list;
	sigset_t signal;
};

typedef struct {
	uid_t val;
} kuid_t;

struct seccomp_filter;

struct seccomp {
	int mode;
	atomic_t filter_count;
	struct seccomp_filter *filter;
};

struct syscall_user_dispatch {};

struct spinlock {
	union {
		struct raw_spinlock rlock;
	};
};

typedef struct spinlock spinlock_t;

struct wake_q_node {
	struct wake_q_node *next;
};

struct task_io_accounting {
	u64 rchar;
	u64 wchar;
	u64 syscr;
	u64 syscw;
	u64 read_bytes;
	u64 write_bytes;
	u64 cancelled_write_bytes;
};

typedef struct {
	long unsigned int bits[4];
} nodemask_t;

struct seqcount_spinlock {
	seqcount_t seqcount;
};

typedef struct seqcount_spinlock seqcount_spinlock_t;

struct optimistic_spin_queue {
	atomic_t tail;
};

struct mutex {
	atomic_long_t owner;
	raw_spinlock_t wait_lock;
	struct optimistic_spin_queue osq;
	struct list_head wait_list;
	void *magic;
};

struct tlbflush_unmap_batch {};

struct page_frag {
	struct page *page;
	__u32 offset;
	__u32 size;
};

struct kmap_ctrl {};

struct timer_list {
	struct hlist_node entry;
	long unsigned int expires;
	void (*function)(struct timer_list *);
	u32 flags;
};

struct llist_head {
	struct llist_node *first;
};

struct debug_reg {};

struct thread_fp_state {
	u64 fpr[64];
	u64 fpscr;
	long: 64;
};

struct arch_hw_breakpoint {
	long unsigned int address;
	u16 type;
	u16 len;
	u16 hw_len;
	u8 flags;
	bool perf_single_step;
};

struct thread_vr_state {
	vector128 vr[32];
	vector128 vscr;
};

struct perf_event;

struct thread_struct {
	long unsigned int ksp;
	long unsigned int ksp_vsid;
	struct pt_regs *regs;
	struct debug_reg debug;
	long: 64;
	struct thread_fp_state fp_state;
	struct thread_fp_state *fp_save_area;
	int fpexc_mode;
	unsigned int align_ctl;
	struct perf_event *ptrace_bps[2];
	struct arch_hw_breakpoint hw_brk[2];
	long unsigned int trap_nr;
	u8 load_slb;
	u8 load_fp;
	u8 load_vec;
	long: 0;
	struct thread_vr_state vr_state;
	struct thread_vr_state *vr_save_area;
	long unsigned int vrsave;
	int used_vr;
	int used_vsr;
	u8 load_tm;
	u64 tm_tfhar;
	u64 tm_texasr;
	u64 tm_tfiar;
	struct pt_regs ckpt_regs;
	long unsigned int tm_tar;
	long unsigned int tm_ppr;
	long unsigned int tm_dscr;
	long unsigned int tm_amr;
	long: 64;
	struct thread_fp_state ckfp_state;
	struct thread_vr_state ckvr_state;
	long unsigned int ckvrsave;
	long unsigned int dscr;
	long unsigned int fscr;
	int dscr_inherit;
	long unsigned int tidr;
	long unsigned int tar;
	long unsigned int ebbrr;
	long unsigned int ebbhr;
	long unsigned int bescr;
	long unsigned int siar;
	long unsigned int sdar;
	long unsigned int sier;
	long unsigned int mmcr2;
	unsigned int mmcr0;
	unsigned int used_ebb;
	long unsigned int mmcr3;
	long unsigned int sier2;
	long unsigned int sier3;
	long unsigned int hashkeyr;
};

struct sched_class;

struct task_group;

struct mm_struct;

struct pid;

struct completion;

struct cred;

struct key;

struct nameidata;

struct fs_struct;

struct files_struct;

struct io_uring_task;

struct nsproxy;

struct signal_struct;

struct sighand_struct;

struct audit_context;

struct rt_mutex_waiter;

struct mutex_waiter;

struct bio_list;

struct blk_plug;

struct reclaim_state;

struct io_context;

struct capture_control;

struct kernel_siginfo;

typedef struct kernel_siginfo kernel_siginfo_t;

struct css_set;

struct robust_list_head;

struct futex_pi_state;

struct perf_event_context;

struct mempolicy;

struct numa_group;

struct rseq;

struct task_delay_info;

struct kunit;

struct ftrace_ret_stack;

struct mem_cgroup;

struct gendisk;

struct uprobe_task;

struct bpf_local_storage;

struct bpf_run_ctx;

struct task_struct {
	struct thread_info thread_info;
	unsigned int __state;
	void *stack;
	refcount_t usage;
	unsigned int flags;
	unsigned int ptrace;
	int on_cpu;
	struct __call_single_node wake_entry;
	unsigned int wakee_flips;
	long unsigned int wakee_flip_decay_ts;
	struct task_struct *last_wakee;
	int recent_used_cpu;
	int wake_cpu;
	int on_rq;
	int prio;
	int static_prio;
	int normal_prio;
	unsigned int rt_priority;
	long: 64;
	long: 64;
	long: 64;
	struct sched_entity se;
	struct sched_rt_entity rt;
	struct sched_dl_entity dl;
	const struct sched_class *sched_class;
	struct task_group *sched_task_group;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct sched_statistics stats;
	struct hlist_head preempt_notifiers;
	unsigned int btrace_seq;
	unsigned int policy;
	int nr_cpus_allowed;
	const cpumask_t *cpus_ptr;
	cpumask_t *user_cpus_ptr;
	cpumask_t cpus_mask;
	void *migration_pending;
	short unsigned int migration_disabled;
	short unsigned int migration_flags;
	int trc_reader_nesting;
	int trc_ipi_to_cpu;
	union rcu_special trc_reader_special;
	struct list_head trc_holdout_list;
	struct list_head trc_blkd_node;
	int trc_blkd_cpu;
	struct sched_info sched_info;
	struct list_head tasks;
	struct plist_node pushable_tasks;
	struct rb_node pushable_dl_tasks;
	struct mm_struct *mm;
	struct mm_struct *active_mm;
	int exit_state;
	int exit_code;
	int exit_signal;
	int pdeath_signal;
	long unsigned int jobctl;
	unsigned int personality;
	unsigned int sched_reset_on_fork: 1;
	unsigned int sched_contributes_to_load: 1;
	unsigned int sched_migrated: 1;
	long: 29;
	unsigned int sched_remote_wakeup: 1;
	unsigned int in_execve: 1;
	unsigned int in_iowait: 1;
	unsigned int restore_sigmask: 1;
	unsigned int in_user_fault: 1;
	unsigned int no_cgroup_migration: 1;
	unsigned int frozen: 1;
	unsigned int use_memdelay: 1;
	unsigned int in_memstall: 1;
	unsigned int in_page_owner: 1;
	unsigned int in_eventfd: 1;
	unsigned int in_thrashing: 1;
	long unsigned int atomic_flags;
	struct restart_block restart_block;
	pid_t pid;
	pid_t tgid;
	long unsigned int stack_canary;
	struct task_struct *real_parent;
	struct task_struct *parent;
	struct list_head children;
	struct list_head sibling;
	struct task_struct *group_leader;
	struct list_head ptraced;
	struct list_head ptrace_entry;
	struct pid *thread_pid;
	struct hlist_node pid_links[4];
	struct list_head thread_group;
	struct list_head thread_node;
	struct completion *vfork_done;
	int *set_child_tid;
	int *clear_child_tid;
	void *worker_private;
	u64 utime;
	u64 stime;
	u64 gtime;
	struct prev_cputime prev_cputime;
	struct vtime vtime;
	atomic_t tick_dep_mask;
	long unsigned int nvcsw;
	long unsigned int nivcsw;
	u64 start_time;
	u64 start_boottime;
	long unsigned int min_flt;
	long unsigned int maj_flt;
	struct posix_cputimers posix_cputimers;
	const struct cred *ptracer_cred;
	const struct cred *real_cred;
	const struct cred *cred;
	struct key *cached_requested_key;
	char comm[16];
	struct nameidata *nameidata;
	struct sysv_sem sysvsem;
	struct sysv_shm sysvshm;
	long unsigned int last_switch_count;
	long unsigned int last_switch_time;
	struct fs_struct *fs;
	struct files_struct *files;
	struct io_uring_task *io_uring;
	struct nsproxy *nsproxy;
	struct signal_struct *signal;
	struct sighand_struct *sighand;
	sigset_t blocked;
	sigset_t real_blocked;
	sigset_t saved_sigmask;
	struct sigpending pending;
	long unsigned int sas_ss_sp;
	size_t sas_ss_size;
	unsigned int sas_ss_flags;
	struct callback_head *task_works;
	struct audit_context *audit_context;
	kuid_t loginuid;
	unsigned int sessionid;
	struct seccomp seccomp;
	struct syscall_user_dispatch syscall_dispatch;
	u64 parent_exec_id;
	u64 self_exec_id;
	spinlock_t alloc_lock;
	raw_spinlock_t pi_lock;
	struct wake_q_node wake_q;
	struct rb_root_cached pi_waiters;
	struct task_struct *pi_top_task;
	struct rt_mutex_waiter *pi_blocked_on;
	struct mutex_waiter *blocked_on;
	void *journal_info;
	struct bio_list *bio_list;
	struct blk_plug *plug;
	struct reclaim_state *reclaim_state;
	struct io_context *io_context;
	struct capture_control *capture_control;
	long unsigned int ptrace_message;
	kernel_siginfo_t *last_siginfo;
	struct task_io_accounting ioac;
	unsigned int psi_flags;
	u64 acct_rss_mem1;
	u64 acct_vm_mem1;
	u64 acct_timexpd;
	nodemask_t mems_allowed;
	seqcount_spinlock_t mems_allowed_seq;
	int cpuset_mem_spread_rotor;
	int cpuset_slab_spread_rotor;
	struct css_set *cgroups;
	struct list_head cg_list;
	struct robust_list_head *robust_list;
	struct list_head pi_state_list;
	struct futex_pi_state *pi_state_cache;
	struct mutex futex_exit_mutex;
	unsigned int futex_state;
	struct perf_event_context *perf_event_ctxp;
	struct mutex perf_event_mutex;
	struct list_head perf_event_list;
	struct mempolicy *mempolicy;
	short int il_prev;
	short int pref_node_fork;
	int numa_scan_seq;
	unsigned int numa_scan_period;
	unsigned int numa_scan_period_max;
	int numa_preferred_nid;
	long unsigned int numa_migrate_retry;
	u64 node_stamp;
	u64 last_task_numa_placement;
	u64 last_sum_exec_runtime;
	struct callback_head numa_work;
	struct numa_group *numa_group;
	long unsigned int *numa_faults;
	long unsigned int total_numa_faults;
	long unsigned int numa_faults_locality[3];
	long unsigned int numa_pages_migrated;
	struct rseq *rseq;
	u32 rseq_len;
	u32 rseq_sig;
	long unsigned int rseq_event_mask;
	int mm_cid;
	int last_mm_cid;
	int migrate_from_cpu;
	int mm_cid_active;
	struct callback_head cid_work;
	struct tlbflush_unmap_batch tlb_ubc;
	struct pipe_inode_info *splice_pipe;
	struct page_frag task_frag;
	struct task_delay_info *delays;
	int nr_dirtied;
	int nr_dirtied_pause;
	long unsigned int dirty_paused_when;
	u64 timer_slack_ns;
	u64 default_timer_slack_ns;
	struct kunit *kunit_test;
	int curr_ret_stack;
	int curr_ret_depth;
	struct ftrace_ret_stack *ret_stack;
	long long unsigned int ftrace_timestamp;
	atomic_t trace_overrun;
	atomic_t tracing_graph_pause;
	long unsigned int trace_recursion;
	struct mem_cgroup *memcg_in_oom;
	gfp_t memcg_oom_gfp_mask;
	int memcg_oom_order;
	unsigned int memcg_nr_pages_over_high;
	struct mem_cgroup *active_memcg;
	struct gendisk *throttle_disk;
	struct uprobe_task *utask;
	struct kmap_ctrl kmap_ctrl;
	struct callback_head rcu;
	refcount_t rcu_users;
	int pagefault_disabled;
	struct task_struct *oom_reaper_list;
	struct timer_list oom_reaper_timer;
	refcount_t stack_refcount;
	void *security;
	struct bpf_local_storage *bpf_storage;
	struct bpf_run_ctx *bpf_ctx;
	struct llist_head kretprobe_instances;
	struct thread_struct thread;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct device;

struct attribute_group;

struct perf_cpu_pmu_context;

struct perf_event_pmu_context;

struct kmem_cache;

struct perf_output_handle;

struct pmu {
	struct list_head entry;
	struct module *module;
	struct device *dev;
	struct device *parent;
	const struct attribute_group **attr_groups;
	const struct attribute_group **attr_update;
	const char *name;
	int type;
	int capabilities;
	int *pmu_disable_count;
	struct perf_cpu_pmu_context *cpu_pmu_context;
	atomic_t exclusive_cnt;
	int task_ctx_nr;
	int hrtimer_interval_ms;
	unsigned int nr_addr_filters;
	void (*pmu_enable)(struct pmu *);
	void (*pmu_disable)(struct pmu *);
	int (*event_init)(struct perf_event *);
	void (*event_mapped)(struct perf_event *, struct mm_struct *);
	void (*event_unmapped)(struct perf_event *, struct mm_struct *);
	int (*add)(struct perf_event *, int);
	void (*del)(struct perf_event *, int);
	void (*start)(struct perf_event *, int);
	void (*stop)(struct perf_event *, int);
	void (*read)(struct perf_event *);
	void (*start_txn)(struct pmu *, unsigned int);
	int (*commit_txn)(struct pmu *);
	void (*cancel_txn)(struct pmu *);
	int (*event_idx)(struct perf_event *);
	void (*sched_task)(struct perf_event_pmu_context *, bool);
	struct kmem_cache *task_ctx_cache;
	void (*swap_task_ctx)(struct perf_event_pmu_context *, struct perf_event_pmu_context *);
	void * (*setup_aux)(struct perf_event *, void **, int, bool);
	void (*free_aux)(void *);
	long int (*snapshot_aux)(struct perf_event *, struct perf_output_handle *, long unsigned int);
	int (*addr_filters_validate)(struct list_head *);
	void (*addr_filters_sync)(struct perf_event *);
	int (*aux_output_match)(struct perf_event *);
	bool (*filter)(struct pmu *, int);
	int (*check_period)(struct perf_event *, u64);
};

enum perf_event_state {
	PERF_EVENT_STATE_DEAD = -4,
	PERF_EVENT_STATE_EXIT = -3,
	PERF_EVENT_STATE_ERROR = -2,
	PERF_EVENT_STATE_OFF = -1,
	PERF_EVENT_STATE_INACTIVE = 0,
	PERF_EVENT_STATE_ACTIVE = 1,
};

typedef struct {
	long int v;
} local_t;

typedef struct {
	local_t a;
} local64_t;

struct perf_event_attr {
	__u32 type;
	__u32 size;
	__u64 config;
	union {
		__u64 sample_period;
		__u64 sample_freq;
	};
	__u64 sample_type;
	__u64 read_format;
	__u64 disabled: 1;
	__u64 inherit: 1;
	__u64 pinned: 1;
	__u64 exclusive: 1;
	__u64 exclude_user: 1;
	__u64 exclude_kernel: 1;
	__u64 exclude_hv: 1;
	__u64 exclude_idle: 1;
	__u64 mmap: 1;
	__u64 comm: 1;
	__u64 freq: 1;
	__u64 inherit_stat: 1;
	__u64 enable_on_exec: 1;
	__u64 task: 1;
	__u64 watermark: 1;
	__u64 precise_ip: 2;
	__u64 mmap_data: 1;
	__u64 sample_id_all: 1;
	__u64 exclude_host: 1;
	__u64 exclude_guest: 1;
	__u64 exclude_callchain_kernel: 1;
	__u64 exclude_callchain_user: 1;
	__u64 mmap2: 1;
	__u64 comm_exec: 1;
	__u64 use_clockid: 1;
	__u64 context_switch: 1;
	__u64 write_backward: 1;
	__u64 namespaces: 1;
	__u64 ksymbol: 1;
	__u64 bpf_event: 1;
	__u64 aux_output: 1;
	__u64 cgroup: 1;
	__u64 text_poke: 1;
	__u64 build_id: 1;
	__u64 inherit_thread: 1;
	__u64 remove_on_exec: 1;
	__u64 sigtrap: 1;
	__u64 __reserved_1: 26;
	union {
		__u32 wakeup_events;
		__u32 wakeup_watermark;
	};
	__u32 bp_type;
	union {
		__u64 bp_addr;
		__u64 kprobe_func;
		__u64 uprobe_path;
		__u64 config1;
	};
	union {
		__u64 bp_len;
		__u64 kprobe_addr;
		__u64 probe_offset;
		__u64 config2;
	};
	__u64 branch_sample_type;
	__u64 sample_regs_user;
	__u32 sample_stack_user;
	__s32 clockid;
	__u64 sample_regs_intr;
	__u32 aux_watermark;
	__u16 sample_max_stack;
	__u16 __reserved_2;
	__u32 aux_sample_size;
	__u32 __reserved_3;
	__u64 sig_data;
	__u64 config3;
};

struct hw_perf_event_extra {
	u64 config;
	unsigned int reg;
	int alloc;
	int idx;
};

struct rhash_head {
	struct rhash_head *next;
};

struct rhlist_head {
	struct rhash_head rhead;
	struct rhlist_head *next;
};

struct hw_perf_event {
	union {
		struct {
			u64 config;
			u64 last_tag;
			long unsigned int config_base;
			long unsigned int event_base;
			int event_base_rdpmc;
			int idx;
			int last_cpu;
			int flags;
			struct hw_perf_event_extra extra_reg;
			struct hw_perf_event_extra branch_reg;
		};
		struct {
			struct hrtimer hrtimer;
		};
		struct {
			struct list_head tp_list;
		};
		struct {
			u64 pwr_acc;
			u64 ptsc;
		};
		struct {
			struct arch_hw_breakpoint info;
			struct rhlist_head bp_list;
		};
		struct {
			u8 iommu_bank;
			u8 iommu_cntr;
			u16 padding;
			u64 conf;
			u64 conf1;
		};
	};
	struct task_struct *target;
	void *addr_filters;
	long unsigned int addr_filters_gen;
	int state;
	local64_t prev_count;
	u64 sample_period;
	union {
		struct {
			u64 last_period;
			local64_t period_left;
		};
		struct {
			u64 saved_metric;
			u64 saved_slots;
		};
	};
	u64 interrupts_seq;
	u64 interrupts;
	u64 freq_time_stamp;
	u64 freq_count_stamp;
};

struct wait_queue_head {
	spinlock_t lock;
	struct list_head head;
};

typedef struct wait_queue_head wait_queue_head_t;

struct rcuwait {
	struct task_struct *task;
};

struct irq_work {
	struct __call_single_node node;
	void (*func)(struct irq_work *);
	struct rcuwait irqwait;
};

struct perf_addr_filters_head {
	struct list_head list;
	raw_spinlock_t lock;
	unsigned int nr_file_filters;
};

struct perf_sample_data;

typedef void (*perf_overflow_handler_t)(struct perf_event *, struct perf_sample_data *, struct pt_regs *);

struct ftrace_ops;

struct ftrace_regs;

typedef void (*ftrace_func_t)(long unsigned int, long unsigned int, struct ftrace_ops *, struct ftrace_regs *);

struct ftrace_hash;

struct ftrace_ops_hash {
	struct ftrace_hash *notrace_hash;
	struct ftrace_hash *filter_hash;
	struct mutex regex_lock;
};

enum ftrace_ops_cmd {
	FTRACE_OPS_CMD_ENABLE_SHARE_IPMODIFY_SELF = 0,
	FTRACE_OPS_CMD_ENABLE_SHARE_IPMODIFY_PEER = 1,
	FTRACE_OPS_CMD_DISABLE_SHARE_IPMODIFY_PEER = 2,
};

typedef int (*ftrace_ops_func_t)(struct ftrace_ops *, enum ftrace_ops_cmd);

struct ftrace_ops {
	ftrace_func_t func;
	struct ftrace_ops *next;
	long unsigned int flags;
	void *private;
	ftrace_func_t saved_func;
	struct ftrace_ops_hash local_hash;
	struct ftrace_ops_hash *func_hash;
	struct ftrace_ops_hash old_hash;
	long unsigned int trampoline;
	long unsigned int trampoline_size;
	struct list_head list;
	ftrace_ops_func_t ops_func;
};

struct perf_buffer;

struct fasync_struct;

struct perf_addr_filter_range;

struct pid_namespace;

struct bpf_prog;

struct trace_event_call;

struct event_filter;

struct perf_cgroup;

struct perf_event {
	struct list_head event_entry;
	struct list_head sibling_list;
	struct list_head active_list;
	struct rb_node group_node;
	u64 group_index;
	struct list_head migrate_entry;
	struct hlist_node hlist_entry;
	struct list_head active_entry;
	int nr_siblings;
	int event_caps;
	int group_caps;
	unsigned int group_generation;
	struct perf_event *group_leader;
	struct pmu *pmu;
	void *pmu_private;
	enum perf_event_state state;
	unsigned int attach_state;
	local64_t count;
	atomic64_t child_count;
	u64 total_time_enabled;
	u64 total_time_running;
	u64 tstamp;
	struct perf_event_attr attr;
	u16 header_size;
	u16 id_header_size;
	u16 read_size;
	struct hw_perf_event hw;
	struct perf_event_context *ctx;
	struct perf_event_pmu_context *pmu_ctx;
	atomic_long_t refcount;
	atomic64_t child_total_time_enabled;
	atomic64_t child_total_time_running;
	struct mutex child_mutex;
	struct list_head child_list;
	struct perf_event *parent;
	int oncpu;
	int cpu;
	struct list_head owner_entry;
	struct task_struct *owner;
	struct mutex mmap_mutex;
	atomic_t mmap_count;
	struct perf_buffer *rb;
	struct list_head rb_entry;
	long unsigned int rcu_batches;
	int rcu_pending;
	wait_queue_head_t waitq;
	struct fasync_struct *fasync;
	unsigned int pending_wakeup;
	unsigned int pending_kill;
	unsigned int pending_disable;
	unsigned int pending_sigtrap;
	long unsigned int pending_addr;
	struct irq_work pending_irq;
	struct callback_head pending_task;
	unsigned int pending_work;
	atomic_t event_limit;
	struct perf_addr_filters_head addr_filters;
	struct perf_addr_filter_range *addr_filter_ranges;
	long unsigned int addr_filters_gen;
	struct perf_event *aux_event;
	void (*destroy)(struct perf_event *);
	struct callback_head callback_head;
	struct pid_namespace *ns;
	u64 id;
	atomic64_t lost_samples;
	u64 (*clock)();
	perf_overflow_handler_t overflow_handler;
	void *overflow_handler_context;
	perf_overflow_handler_t orig_overflow_handler;
	struct bpf_prog *prog;
	u64 bpf_cookie;
	struct trace_event_call *tp_event;
	struct event_filter *filter;
	struct ftrace_ops ftrace_ops;
	struct perf_cgroup *cgrp;
	void *security;
	struct list_head sb_list;
	__u32 orig_type;
};

struct exception_table_entry {
	int insn;
	int fixup;
};

typedef struct cpumask cpumask_var_t[1];

typedef struct {
	arch_rwlock_t raw_lock;
} rwlock_t;

struct hlist_bl_node;

struct hlist_bl_head {
	struct hlist_bl_node *first;
};

struct hlist_bl_node {
	struct hlist_bl_node *next;
	struct hlist_bl_node **pprev;
};

struct seqcount_raw_spinlock {
	seqcount_t seqcount;
};

typedef struct seqcount_raw_spinlock seqcount_raw_spinlock_t;

typedef struct {
	seqcount_spinlock_t seqcount;
	spinlock_t lock;
} seqlock_t;

struct lockref {
	union {
		__u64 lock_count;
		struct {
			spinlock_t lock;
			int count;
		};
	};
};

struct qstr {
	union {
		struct {
			u32 hash;
			u32 len;
		};
		u64 hash_len;
	};
	const unsigned char *name;
};

struct dentry_operations;

struct dentry {
	unsigned int d_flags;
	seqcount_spinlock_t d_seq;
	struct hlist_bl_node d_hash;
	struct dentry *d_parent;
	struct qstr d_name;
	struct inode *d_inode;
	unsigned char d_iname[32];
	struct lockref d_lockref;
	const struct dentry_operations *d_op;
	struct super_block *d_sb;
	long unsigned int d_time;
	void *d_fsdata;
	union {
		struct list_head d_lru;
		wait_queue_head_t *d_wait;
	};
	struct list_head d_child;
	struct list_head d_subdirs;
	union {
		struct hlist_node d_alias;
		struct hlist_bl_node d_in_lookup_hash;
		struct callback_head d_rcu;
	} d_u;
};

typedef struct {
	gid_t val;
} kgid_t;

struct rw_semaphore {
	atomic_long_t count;
	atomic_long_t owner;
	struct optimistic_spin_queue osq;
	raw_spinlock_t wait_lock;
	struct list_head wait_list;
};

struct xarray {
	spinlock_t xa_lock;
	gfp_t xa_flags;
	void *xa_head;
};

typedef u32 errseq_t;

struct address_space_operations;

struct address_space {
	struct inode *host;
	struct xarray i_pages;
	struct rw_semaphore invalidate_lock;
	gfp_t gfp_mask;
	atomic_t i_mmap_writable;
	struct rb_root_cached i_mmap;
	long unsigned int nrpages;
	long unsigned int writeback_index;
	const struct address_space_operations *a_ops;
	long unsigned int flags;
	struct rw_semaphore i_mmap_rwsem;
	errseq_t wb_err;
	spinlock_t private_lock;
	struct list_head private_list;
	void *private_data;
};

struct posix_acl;

struct inode_operations;

struct bdi_writeback;

struct file_lock_context;

struct cdev;

struct fsnotify_mark_connector;

struct inode {
	umode_t i_mode;
	short unsigned int i_opflags;
	kuid_t i_uid;
	kgid_t i_gid;
	unsigned int i_flags;
	struct posix_acl *i_acl;
	struct posix_acl *i_default_acl;
	const struct inode_operations *i_op;
	struct super_block *i_sb;
	struct address_space *i_mapping;
	void *i_security;
	long unsigned int i_ino;
	union {
		const unsigned int i_nlink;
		unsigned int __i_nlink;
	};
	dev_t i_rdev;
	loff_t i_size;
	struct timespec64 i_atime;
	struct timespec64 i_mtime;
	struct timespec64 __i_ctime;
	spinlock_t i_lock;
	short unsigned int i_bytes;
	u8 i_blkbits;
	u8 i_write_hint;
	blkcnt_t i_blocks;
	long unsigned int i_state;
	struct rw_semaphore i_rwsem;
	long unsigned int dirtied_when;
	long unsigned int dirtied_time_when;
	struct hlist_node i_hash;
	struct list_head i_io_list;
	struct bdi_writeback *i_wb;
	int i_wb_frn_winner;
	u16 i_wb_frn_avg_time;
	u16 i_wb_frn_history;
	struct list_head i_lru;
	struct list_head i_sb_list;
	struct list_head i_wb_list;
	union {
		struct hlist_head i_dentry;
		struct callback_head i_rcu;
	};
	atomic64_t i_version;
	atomic64_t i_sequence;
	atomic_t i_count;
	atomic_t i_dio_count;
	atomic_t i_writecount;
	atomic_t i_readcount;
	union {
		const struct file_operations *i_fop;
		void (*free_inode)(struct inode *);
	};
	struct file_lock_context *i_flctx;
	struct address_space i_data;
	struct list_head i_devices;
	union {
		struct pipe_inode_info *i_pipe;
		struct cdev *i_cdev;
		char *i_link;
		unsigned int i_dir_seq;
	};
	__u32 i_generation;
	__u32 i_fsnotify_mask;
	struct fsnotify_mark_connector *i_fsnotify_marks;
	void *i_private;
};

struct vfsmount;

struct path;

struct dentry_operations {
	int (*d_revalidate)(struct dentry *, unsigned int);
	int (*d_weak_revalidate)(struct dentry *, unsigned int);
	int (*d_hash)(const struct dentry *, struct qstr *);
	int (*d_compare)(const struct dentry *, unsigned int, const char *, const struct qstr *);
	int (*d_delete)(const struct dentry *);
	int (*d_init)(struct dentry *);
	void (*d_release)(struct dentry *);
	void (*d_prune)(struct dentry *);
	void (*d_iput)(struct dentry *, struct inode *);
	char * (*d_dname)(struct dentry *, char *, int);
	struct vfsmount * (*d_automount)(struct path *);
	int (*d_manage)(const struct path *, bool);
	struct dentry * (*d_real)(struct dentry *, const struct inode *);
	long: 64;
	long: 64;
	long: 64;
};

struct mtd_info;

typedef long long int qsize_t;

struct quota_format_type;

struct mem_dqinfo {
	struct quota_format_type *dqi_format;
	int dqi_fmt_id;
	struct list_head dqi_dirty_list;
	long unsigned int dqi_flags;
	unsigned int dqi_bgrace;
	unsigned int dqi_igrace;
	qsize_t dqi_max_spc_limit;
	qsize_t dqi_max_ino_limit;
	void *dqi_priv;
};

struct quota_format_ops;

struct quota_info {
	unsigned int flags;
	struct rw_semaphore dqio_sem;
	struct inode *files[3];
	struct mem_dqinfo info[3];
	const struct quota_format_ops *ops[3];
};

struct rcu_sync {
	int gp_state;
	int gp_count;
	wait_queue_head_t gp_wait;
	struct callback_head cb_head;
};

struct percpu_rw_semaphore {
	struct rcu_sync rss;
	unsigned int *read_count;
	struct rcuwait writer;
	wait_queue_head_t waiters;
	atomic_t block;
};

struct sb_writers {
	short unsigned int frozen;
	short unsigned int freeze_holders;
	struct percpu_rw_semaphore rw_sem[3];
};

typedef struct {
	__u8 b[16];
} uuid_t;

struct shrink_control;

struct shrinker {
	long unsigned int (*count_objects)(struct shrinker *, struct shrink_control *);
	long unsigned int (*scan_objects)(struct shrinker *, struct shrink_control *);
	long int batch;
	int seeks;
	unsigned int flags;
	struct list_head list;
	int id;
	atomic_long_t *nr_deferred;
};

struct list_lru_node;

struct list_lru {
	struct list_lru_node *node;
	struct list_head list;
	int shrinker_id;
	bool memcg_aware;
	struct xarray xa;
};

struct work_struct;

typedef void (*work_func_t)(struct work_struct *);

struct work_struct {
	atomic_long_t data;
	struct list_head entry;
	work_func_t func;
};

struct super_operations;

struct dquot_operations;

struct quotactl_ops;

struct export_operations;

struct xattr_handler;

struct block_device;

struct backing_dev_info;

struct workqueue_struct;

struct user_namespace;

struct super_block {
	struct list_head s_list;
	dev_t s_dev;
	unsigned char s_blocksize_bits;
	long unsigned int s_blocksize;
	loff_t s_maxbytes;
	struct file_system_type *s_type;
	const struct super_operations *s_op;
	const struct dquot_operations *dq_op;
	const struct quotactl_ops *s_qcop;
	const struct export_operations *s_export_op;
	long unsigned int s_flags;
	long unsigned int s_iflags;
	long unsigned int s_magic;
	struct dentry *s_root;
	struct rw_semaphore s_umount;
	int s_count;
	atomic_t s_active;
	void *s_security;
	const struct xattr_handler **s_xattr;
	struct hlist_bl_head s_roots;
	struct list_head s_mounts;
	struct block_device *s_bdev;
	struct backing_dev_info *s_bdi;
	struct mtd_info *s_mtd;
	struct hlist_node s_instances;
	unsigned int s_quota_types;
	struct quota_info s_dquot;
	struct sb_writers s_writers;
	void *s_fs_info;
	u32 s_time_gran;
	time64_t s_time_min;
	time64_t s_time_max;
	__u32 s_fsnotify_mask;
	struct fsnotify_mark_connector *s_fsnotify_marks;
	char s_id[32];
	uuid_t s_uuid;
	unsigned int s_max_links;
	struct mutex s_vfs_rename_mutex;
	const char *s_subtype;
	const struct dentry_operations *s_d_op;
	struct shrinker s_shrink;
	atomic_long_t s_remove_count;
	atomic_long_t s_fsnotify_connectors;
	int s_readonly_remount;
	errseq_t s_wb_err;
	struct workqueue_struct *s_dio_done_wq;
	struct hlist_head s_pins;
	struct user_namespace *s_user_ns;
	struct list_lru s_dentry_lru;
	struct list_lru s_inode_lru;
	struct callback_head rcu;
	struct work_struct destroy_work;
	struct mutex s_sync_lock;
	int s_stack_depth;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	spinlock_t s_inode_list_lock;
	struct list_head s_inodes;
	spinlock_t s_inode_wblist_lock;
	struct list_head s_inodes_wb;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct mnt_idmap;

struct vfsmount {
	struct dentry *mnt_root;
	struct super_block *mnt_sb;
	int mnt_flags;
	struct mnt_idmap *mnt_idmap;
};

struct path {
	struct vfsmount *mnt;
	struct dentry *dentry;
};

struct uid_gid_extent {
	u32 first;
	u32 lower_first;
	u32 count;
};

struct uid_gid_map {
	u32 nr_extents;
	union {
		struct uid_gid_extent extent[5];
		struct {
			struct uid_gid_extent *forward;
			struct uid_gid_extent *reverse;
		};
	};
};

struct proc_ns_operations;

struct ns_common {
	atomic_long_t stashed;
	const struct proc_ns_operations *ops;
	unsigned int inum;
	refcount_t count;
};

struct ctl_table;

struct ctl_table_root;

struct ctl_table_set;

struct ctl_dir;

struct ctl_node;

struct ctl_table_header {
	union {
		struct {
			struct ctl_table *ctl_table;
			int ctl_table_size;
			int used;
			int count;
			int nreg;
		};
		struct callback_head rcu;
	};
	struct completion *unregistering;
	struct ctl_table *ctl_table_arg;
	struct ctl_table_root *root;
	struct ctl_table_set *set;
	struct ctl_dir *parent;
	struct ctl_node *node;
	struct hlist_head inodes;
};

struct ctl_dir {
	struct ctl_table_header header;
	struct rb_root root;
};

struct ctl_table_set {
	int (*is_seen)(struct ctl_table_set *);
	struct ctl_dir dir;
};

struct ucounts;

struct user_namespace {
	struct uid_gid_map uid_map;
	struct uid_gid_map gid_map;
	struct uid_gid_map projid_map;
	struct user_namespace *parent;
	int level;
	kuid_t owner;
	kgid_t group;
	struct ns_common ns;
	long unsigned int flags;
	bool parent_could_setfcap;
	struct list_head keyring_name_list;
	struct key *user_keyring_register;
	struct rw_semaphore keyring_sem;
	struct work_struct work;
	struct ctl_table_set set;
	struct ctl_table_header *sysctls;
	struct ucounts *ucounts;
	long int ucount_max[10];
	long int rlimit_max[4];
};

struct kstat {
	u32 result_mask;
	umode_t mode;
	unsigned int nlink;
	uint32_t blksize;
	u64 attributes;
	u64 attributes_mask;
	u64 ino;
	dev_t dev;
	dev_t rdev;
	kuid_t uid;
	kgid_t gid;
	loff_t size;
	struct timespec64 atime;
	struct timespec64 mtime;
	struct timespec64 ctime;
	struct timespec64 btime;
	u64 blocks;
	u64 mnt_id;
	u32 dio_mem_align;
	u32 dio_offset_align;
	u64 change_cookie;
};

struct shrink_control {
	gfp_t gfp_mask;
	int nid;
	long unsigned int nr_to_scan;
	long unsigned int nr_scanned;
	struct mem_cgroup *memcg;
};

struct kref {
	refcount_t refcount;
};

typedef struct {} lockdep_map_p;

struct maple_tree {
	union {
		spinlock_t ma_lock;
		lockdep_map_p ma_external_lock;
	};
	unsigned int ma_flags;
	void *ma_root;
};

struct swait_queue_head {
	raw_spinlock_t lock;
	struct list_head task_list;
};

struct completion {
	unsigned int done;
	struct swait_queue_head wait;
};

struct percpu_counter {
	raw_spinlock_t lock;
	s64 count;
	struct list_head list;
	s32 *counters;
};

struct xol_area;

struct uprobes_state {
	struct xol_area *xol_area;
};

struct mm_cid;

struct linux_binfmt;

struct kioctx_table;

struct mmu_notifier_subscriptions;

struct mm_struct {
	struct {
		struct {
			atomic_t mm_count;
			long: 64;
			long: 64;
			long: 64;
			long: 64;
			long: 64;
			long: 64;
			long: 64;
			long: 64;
			long: 64;
			long: 64;
			long: 64;
			long: 64;
			long: 64;
			long: 64;
			long: 64;
		};
		struct maple_tree mm_mt;
		long unsigned int (*get_unmapped_area)(struct file *, long unsigned int, long unsigned int, long unsigned int, long unsigned int);
		long unsigned int mmap_base;
		long unsigned int mmap_legacy_base;
		long unsigned int task_size;
		pgd_t *pgd;
		atomic_t membarrier_state;
		atomic_t mm_users;
		struct mm_cid *pcpu_cid;
		long unsigned int mm_cid_next_scan;
		atomic_long_t pgtables_bytes;
		int map_count;
		spinlock_t page_table_lock;
		struct rw_semaphore mmap_lock;
		struct list_head mmlist;
		int mm_lock_seq;
		long unsigned int hiwater_rss;
		long unsigned int hiwater_vm;
		long unsigned int total_vm;
		long unsigned int locked_vm;
		atomic64_t pinned_vm;
		long unsigned int data_vm;
		long unsigned int exec_vm;
		long unsigned int stack_vm;
		long unsigned int def_flags;
		seqcount_t write_protect_seq;
		spinlock_t arg_lock;
		long unsigned int start_code;
		long unsigned int end_code;
		long unsigned int start_data;
		long unsigned int end_data;
		long unsigned int start_brk;
		long unsigned int brk;
		long unsigned int start_stack;
		long unsigned int arg_start;
		long unsigned int arg_end;
		long unsigned int env_start;
		long unsigned int env_end;
		long unsigned int saved_auxv[76];
		struct percpu_counter rss_stat[4];
		struct linux_binfmt *binfmt;
		mm_context_t context;
		long unsigned int flags;
		spinlock_t ioctx_lock;
		struct kioctx_table *ioctx_table;
		struct task_struct *owner;
		struct user_namespace *user_ns;
		struct file *exe_file;
		struct mmu_notifier_subscriptions *notifier_subscriptions;
		long unsigned int numa_next_scan;
		long unsigned int numa_scan_offset;
		int numa_scan_seq;
		atomic_t tlb_flush_pending;
		struct uprobes_state uprobes_state;
		atomic_long_t hugetlb_usage;
		struct work_struct async_put_work;
		long unsigned int ksm_merging_pages;
		long unsigned int ksm_rmap_items;
		long unsigned int ksm_zero_pages;
		long: 64;
		long: 64;
	};
	long unsigned int cpu_bitmap[0];
};

struct delayed_work {
	struct work_struct work;
	struct timer_list timer;
	struct workqueue_struct *wq;
	int cpu;
};

struct rcu_work {
	struct work_struct work;
	struct callback_head rcu;
	struct workqueue_struct *wq;
};

struct rcu_segcblist {
	struct callback_head *head;
	struct callback_head **tails[4];
	long unsigned int gp_seq[4];
	atomic_long_t len;
	long int seglen[4];
	u8 flags;
};

struct srcu_node;

struct srcu_struct;

struct srcu_data {
	atomic_long_t srcu_lock_count[2];
	atomic_long_t srcu_unlock_count[2];
	int srcu_nmi_safety;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	spinlock_t lock;
	struct rcu_segcblist srcu_cblist;
	long unsigned int srcu_gp_seq_needed;
	long unsigned int srcu_gp_seq_needed_exp;
	bool srcu_cblist_invoking;
	struct timer_list delay_work;
	struct work_struct work;
	struct callback_head srcu_barrier_head;
	struct srcu_node *mynode;
	long unsigned int grpmask;
	int cpu;
	struct srcu_struct *ssp;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct srcu_node {
	spinlock_t lock;
	long unsigned int srcu_have_cbs[4];
	long unsigned int srcu_data_have_cbs[4];
	long unsigned int srcu_gp_seq_needed_exp;
	struct srcu_node *srcu_parent;
	int grplo;
	int grphi;
};

struct srcu_usage;

struct srcu_struct {
	unsigned int srcu_idx;
	struct srcu_data *sda;
	struct lockdep_map dep_map;
	struct srcu_usage *srcu_sup;
};

struct srcu_usage {
	struct srcu_node *node;
	struct srcu_node *level[4];
	int srcu_size_state;
	struct mutex srcu_cb_mutex;
	spinlock_t lock;
	struct mutex srcu_gp_mutex;
	long unsigned int srcu_gp_seq;
	long unsigned int srcu_gp_seq_needed;
	long unsigned int srcu_gp_seq_needed_exp;
	long unsigned int srcu_gp_start;
	long unsigned int srcu_last_gp_end;
	long unsigned int srcu_size_jiffies;
	long unsigned int srcu_n_lock_retries;
	long unsigned int srcu_n_exp_nodelay;
	bool sda_is_static;
	long unsigned int srcu_barrier_seq;
	struct mutex srcu_barrier_mutex;
	struct completion srcu_barrier_completion;
	atomic_t srcu_barrier_cpu_cnt;
	long unsigned int reschedule_jiffies;
	long unsigned int reschedule_count;
	struct delayed_work work;
	struct srcu_struct *srcu_ssp;
};

struct arch_uprobe_task {
	long unsigned int saved_trap_nr;
};

enum uprobe_task_state {
	UTASK_RUNNING = 0,
	UTASK_SSTEP = 1,
	UTASK_SSTEP_ACK = 2,
	UTASK_SSTEP_TRAPPED = 3,
};

struct uprobe;

struct return_instance;

struct uprobe_task {
	enum uprobe_task_state state;
	union {
		struct {
			struct arch_uprobe_task autask;
			long unsigned int vaddr;
		};
		struct {
			struct callback_head dup_xol_work;
			long unsigned int dup_xol_addr;
		};
	};
	struct uprobe *active_uprobe;
	long unsigned int xol_vaddr;
	struct return_instance *return_instances;
	unsigned int depth;
};

struct return_instance {
	struct uprobe *uprobe;
	long unsigned int func;
	long unsigned int stack;
	long unsigned int orig_ret_vaddr;
	bool chained;
	struct return_instance *next;
};

struct vmem_altmap {
	long unsigned int base_pfn;
	const long unsigned int end_pfn;
	const long unsigned int reserve;
	long unsigned int free;
	long unsigned int align;
	long unsigned int alloc;
};

struct percpu_ref_data;

struct percpu_ref {
	long unsigned int percpu_count_ptr;
	struct percpu_ref_data *data;
};

enum memory_type {
	MEMORY_DEVICE_PRIVATE = 1,
	MEMORY_DEVICE_COHERENT = 2,
	MEMORY_DEVICE_FS_DAX = 3,
	MEMORY_DEVICE_GENERIC = 4,
	MEMORY_DEVICE_PCI_P2PDMA = 5,
};

struct range {
	u64 start;
	u64 end;
};

struct dev_pagemap_ops;

struct dev_pagemap {
	struct vmem_altmap altmap;
	struct percpu_ref ref;
	struct completion done;
	enum memory_type type;
	unsigned int flags;
	long unsigned int vmemmap_shift;
	const struct dev_pagemap_ops *ops;
	void *owner;
	int nr_range;
	union {
		struct range range;
		struct {
			struct {} __empty_ranges;
			struct range ranges[0];
		};
	};
};

typedef struct {
	long unsigned int val;
} swp_entry_t;

struct folio {
	union {
		struct {
			long unsigned int flags;
			union {
				struct list_head lru;
				struct {
					void *__filler;
					unsigned int mlock_count;
				};
			};
			struct address_space *mapping;
			long unsigned int index;
			union {
				void *private;
				swp_entry_t swap;
			};
			atomic_t _mapcount;
			atomic_t _refcount;
			long unsigned int memcg_data;
		};
		struct page page;
	};
	union {
		struct {
			long unsigned int _flags_1;
			long unsigned int _head_1;
			long unsigned int _folio_avail;
			atomic_t _entire_mapcount;
			atomic_t _nr_pages_mapped;
			atomic_t _pincount;
			unsigned int _folio_nr_pages;
		};
		struct page __page_1;
	};
	union {
		struct {
			long unsigned int _flags_2;
			long unsigned int _head_2;
			void *_hugetlb_subpool;
			void *_hugetlb_cgroup;
			void *_hugetlb_cgroup_rsvd;
			void *_hugetlb_hwpoison;
		};
		struct {
			long unsigned int _flags_2a;
			long unsigned int _head_2a;
			struct list_head _deferred_list;
		};
		struct page __page_2;
	};
};

typedef long unsigned int vm_flags_t;

enum pid_type {
	PIDTYPE_PID = 0,
	PIDTYPE_TGID = 1,
	PIDTYPE_PGID = 2,
	PIDTYPE_SID = 3,
	PIDTYPE_MAX = 4,
};

struct fown_struct {
	rwlock_t lock;
	struct pid *pid;
	enum pid_type pid_type;
	kuid_t uid;
	kuid_t euid;
	int signum;
};

struct file_ra_state {
	long unsigned int start;
	unsigned int size;
	unsigned int async_size;
	unsigned int ra_pages;
	unsigned int mmap_miss;
	loff_t prev_pos;
};

struct file {
	union {
		struct llist_node f_llist;
		struct callback_head f_rcuhead;
		unsigned int f_iocb_flags;
	};
	spinlock_t f_lock;
	fmode_t f_mode;
	atomic_long_t f_count;
	struct mutex f_pos_lock;
	loff_t f_pos;
	unsigned int f_flags;
	struct fown_struct f_owner;
	const struct cred *f_cred;
	struct file_ra_state f_ra;
	struct path f_path;
	struct inode *f_inode;
	const struct file_operations *f_op;
	u64 f_version;
	void *f_security;
	void *private_data;
	struct hlist_head *f_ep;
	struct address_space *f_mapping;
	errseq_t f_wb_err;
	errseq_t f_sb_err;
};

struct vm_userfaultfd_ctx {};

struct vma_lock {
	struct rw_semaphore lock;
};

struct vma_numab_state {
	long unsigned int next_scan;
	long unsigned int next_pid_reset;
	long unsigned int access_pids[2];
};

struct anon_vma;

struct vm_operations_struct;

struct vm_area_struct {
	union {
		struct {
			long unsigned int vm_start;
			long unsigned int vm_end;
		};
		struct callback_head vm_rcu;
	};
	struct mm_struct *vm_mm;
	pgprot_t vm_page_prot;
	union {
		const vm_flags_t vm_flags;
		vm_flags_t __vm_flags;
	};
	int vm_lock_seq;
	struct vma_lock *vm_lock;
	bool detached;
	struct {
		struct rb_node rb;
		long unsigned int rb_subtree_last;
	} shared;
	struct list_head anon_vma_chain;
	struct anon_vma *anon_vma;
	const struct vm_operations_struct *vm_ops;
	long unsigned int vm_pgoff;
	struct file *vm_file;
	void *vm_private_data;
	atomic_long_t swap_readahead_info;
	struct mempolicy *vm_policy;
	struct vma_numab_state *numab_state;
	struct vm_userfaultfd_ctx vm_userfaultfd_ctx;
};

typedef unsigned int vm_fault_t;

struct vm_fault;

struct vm_operations_struct {
	void (*open)(struct vm_area_struct *);
	void (*close)(struct vm_area_struct *);
	int (*may_split)(struct vm_area_struct *, long unsigned int);
	int (*mremap)(struct vm_area_struct *);
	int (*mprotect)(struct vm_area_struct *, long unsigned int, long unsigned int, long unsigned int);
	vm_fault_t (*fault)(struct vm_fault *);
	vm_fault_t (*huge_fault)(struct vm_fault *, unsigned int);
	vm_fault_t (*map_pages)(struct vm_fault *, long unsigned int, long unsigned int);
	long unsigned int (*pagesize)(struct vm_area_struct *);
	vm_fault_t (*page_mkwrite)(struct vm_fault *);
	vm_fault_t (*pfn_mkwrite)(struct vm_fault *);
	int (*access)(struct vm_area_struct *, long unsigned int, void *, int, int);
	const char * (*name)(struct vm_area_struct *);
	int (*set_policy)(struct vm_area_struct *, struct mempolicy *);
	struct mempolicy * (*get_policy)(struct vm_area_struct *, long unsigned int);
	struct page * (*find_special_page)(struct vm_area_struct *, long unsigned int);
};

struct mm_cid {
	u64 time;
	int cid;
};

enum fault_flag {
	FAULT_FLAG_WRITE = 1,
	FAULT_FLAG_MKWRITE = 2,
	FAULT_FLAG_ALLOW_RETRY = 4,
	FAULT_FLAG_RETRY_NOWAIT = 8,
	FAULT_FLAG_KILLABLE = 16,
	FAULT_FLAG_TRIED = 32,
	FAULT_FLAG_USER = 64,
	FAULT_FLAG_REMOTE = 128,
	FAULT_FLAG_INSTRUCTION = 256,
	FAULT_FLAG_INTERRUPTIBLE = 512,
	FAULT_FLAG_UNSHARE = 1024,
	FAULT_FLAG_ORIG_PTE_VALID = 2048,
	FAULT_FLAG_VMA_LOCK = 4096,
};

struct vm_fault {
	const struct {
		struct vm_area_struct *vma;
		gfp_t gfp_mask;
		long unsigned int pgoff;
		long unsigned int address;
		long unsigned int real_address;
	};
	enum fault_flag flags;
	pmd_t *pmd;
	pud_t *pud;
	union {
		pte_t orig_pte;
		pmd_t orig_pmd;
	};
	struct page *cow_page;
	struct page *page;
	pte_t *pte;
	spinlock_t *ptl;
	pgtable_t prealloc_pte;
};

struct upid {
	int nr;
	struct pid_namespace *ns;
};

struct idr {
	struct xarray idr_rt;
	unsigned int idr_base;
	unsigned int idr_next;
};

struct fs_pin;

struct pid_namespace {
	struct idr idr;
	struct callback_head rcu;
	unsigned int pid_allocated;
	struct task_struct *child_reaper;
	struct kmem_cache *pid_cachep;
	unsigned int level;
	struct pid_namespace *parent;
	struct fs_pin *bacct;
	struct user_namespace *user_ns;
	struct ucounts *ucounts;
	int reboot;
	struct ns_common ns;
	int memfd_noexec_scope;
};

struct pid {
	refcount_t count;
	unsigned int level;
	spinlock_t lock;
	struct hlist_head tasks[4];
	struct hlist_head inodes;
	wait_queue_head_t wait_pidfd;
	struct callback_head rcu;
	struct upid numbers[0];
};

struct hrtimer_cpu_base;

struct hrtimer_clock_base {
	struct hrtimer_cpu_base *cpu_base;
	unsigned int index;
	clockid_t clockid;
	seqcount_raw_spinlock_t seq;
	struct hrtimer *running;
	struct timerqueue_head active;
	ktime_t (*get_time)();
	ktime_t offset;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct hrtimer_cpu_base {
	raw_spinlock_t lock;
	unsigned int cpu;
	unsigned int active_bases;
	unsigned int clock_was_set_seq;
	unsigned int hres_active: 1;
	unsigned int in_hrtirq: 1;
	unsigned int hang_detected: 1;
	unsigned int softirq_activated: 1;
	unsigned int nr_events;
	short unsigned int nr_retries;
	short unsigned int nr_hangs;
	unsigned int max_hang_time;
	ktime_t expires_next;
	struct hrtimer *next_timer;
	ktime_t softirq_expires_next;
	struct hrtimer *softirq_next_timer;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct hrtimer_clock_base clock_base[8];
};

struct rlimit {
	__kernel_ulong_t rlim_cur;
	__kernel_ulong_t rlim_max;
};

struct task_cputime {
	u64 stime;
	u64 utime;
	long long unsigned int sum_exec_runtime;
};

typedef void __signalfn_t(int);

typedef __signalfn_t *__sighandler_t;

typedef void __restorefn_t();

typedef __restorefn_t *__sigrestore_t;

union sigval {
	int sival_int;
	void *sival_ptr;
};

typedef union sigval sigval_t;

union __sifields {
	struct {
		__kernel_pid_t _pid;
		__kernel_uid32_t _uid;
	} _kill;
	struct {
		__kernel_timer_t _tid;
		int _overrun;
		sigval_t _sigval;
		int _sys_private;
	} _timer;
	struct {
		__kernel_pid_t _pid;
		__kernel_uid32_t _uid;
		sigval_t _sigval;
	} _rt;
	struct {
		__kernel_pid_t _pid;
		__kernel_uid32_t _uid;
		int _status;
		__kernel_clock_t _utime;
		__kernel_clock_t _stime;
	} _sigchld;
	struct {
		void *_addr;
		union {
			int _trapno;
			short int _addr_lsb;
			struct {
				char _dummy_bnd[8];
				void *_lower;
				void *_upper;
			} _addr_bnd;
			struct {
				char _dummy_pkey[8];
				__u32 _pkey;
			} _addr_pkey;
			struct {
				long unsigned int _data;
				__u32 _type;
				__u32 _flags;
			} _perf;
		};
	} _sigfault;
	struct {
		long int _band;
		int _fd;
	} _sigpoll;
	struct {
		void *_call_addr;
		int _syscall;
		unsigned int _arch;
	} _sigsys;
};

struct kernel_siginfo {
	struct {
		int si_signo;
		int si_errno;
		int si_code;
		union __sifields _sifields;
	};
};

struct ucounts {
	struct hlist_node node;
	struct user_namespace *ns;
	kuid_t uid;
	atomic_t count;
	atomic_long_t ucount[10];
	atomic_long_t rlimit[4];
};

struct sigaction {
	__sighandler_t sa_handler;
	long unsigned int sa_flags;
	__sigrestore_t sa_restorer;
	sigset_t sa_mask;
};

struct k_sigaction {
	struct sigaction sa;
};

struct cpu_itimer {
	u64 expires;
	u64 incr;
};

struct task_cputime_atomic {
	atomic64_t utime;
	atomic64_t stime;
	atomic64_t sum_exec_runtime;
};

struct thread_group_cputimer {
	struct task_cputime_atomic cputime_atomic;
};

struct pacct_struct {
	int ac_flag;
	long int ac_exitcode;
	long unsigned int ac_mem;
	u64 ac_utime;
	u64 ac_stime;
	long unsigned int ac_minflt;
	long unsigned int ac_majflt;
};

struct core_state;

struct tty_struct;

struct autogroup;

struct taskstats;

struct tty_audit_buf;

struct signal_struct {
	refcount_t sigcnt;
	atomic_t live;
	int nr_threads;
	int quick_threads;
	struct list_head thread_head;
	wait_queue_head_t wait_chldexit;
	struct task_struct *curr_target;
	struct sigpending shared_pending;
	struct hlist_head multiprocess;
	int group_exit_code;
	int notify_count;
	struct task_struct *group_exec_task;
	int group_stop_count;
	unsigned int flags;
	struct core_state *core_state;
	unsigned int is_child_subreaper: 1;
	unsigned int has_child_subreaper: 1;
	unsigned int next_posix_timer_id;
	struct list_head posix_timers;
	struct hrtimer real_timer;
	ktime_t it_real_incr;
	struct cpu_itimer it[2];
	struct thread_group_cputimer cputimer;
	struct posix_cputimers posix_cputimers;
	struct pid *pids[4];
	atomic_t tick_dep_mask;
	struct pid *tty_old_pgrp;
	int leader;
	struct tty_struct *tty;
	struct autogroup *autogroup;
	seqlock_t stats_lock;
	u64 utime;
	u64 stime;
	u64 cutime;
	u64 cstime;
	u64 gtime;
	u64 cgtime;
	struct prev_cputime prev_cputime;
	long unsigned int nvcsw;
	long unsigned int nivcsw;
	long unsigned int cnvcsw;
	long unsigned int cnivcsw;
	long unsigned int min_flt;
	long unsigned int maj_flt;
	long unsigned int cmin_flt;
	long unsigned int cmaj_flt;
	long unsigned int inblock;
	long unsigned int oublock;
	long unsigned int cinblock;
	long unsigned int coublock;
	long unsigned int maxrss;
	long unsigned int cmaxrss;
	struct task_io_accounting ioac;
	long long unsigned int sum_sched_runtime;
	struct rlimit rlim[16];
	struct pacct_struct pacct;
	struct taskstats *stats;
	unsigned int audit_tty;
	struct tty_audit_buf *tty_audit_buf;
	bool oom_flag_origin;
	short int oom_score_adj;
	short int oom_score_adj_min;
	struct mm_struct *oom_mm;
	struct mutex cred_guard_mutex;
	struct rw_semaphore exec_update_lock;
};

struct rseq {
	__u32 cpu_id_start;
	__u32 cpu_id;
	__u64 rseq_cs;
	__u32 flags;
	__u32 node_id;
	__u32 mm_cid;
	char end[0];
};

struct rq;

struct rq_flags;

struct affinity_context;

struct sched_class {
	void (*enqueue_task)(struct rq *, struct task_struct *, int);
	void (*dequeue_task)(struct rq *, struct task_struct *, int);
	void (*yield_task)(struct rq *);
	bool (*yield_to_task)(struct rq *, struct task_struct *);
	void (*check_preempt_curr)(struct rq *, struct task_struct *, int);
	struct task_struct * (*pick_next_task)(struct rq *);
	void (*put_prev_task)(struct rq *, struct task_struct *);
	void (*set_next_task)(struct rq *, struct task_struct *, bool);
	int (*balance)(struct rq *, struct task_struct *, struct rq_flags *);
	int (*select_task_rq)(struct task_struct *, int, int);
	struct task_struct * (*pick_task)(struct rq *);
	void (*migrate_task_rq)(struct task_struct *, int);
	void (*task_woken)(struct rq *, struct task_struct *);
	void (*set_cpus_allowed)(struct task_struct *, struct affinity_context *);
	void (*rq_online)(struct rq *);
	void (*rq_offline)(struct rq *);
	struct rq * (*find_lock_rq)(struct task_struct *, struct rq *);
	void (*task_tick)(struct rq *, struct task_struct *, int);
	void (*task_fork)(struct task_struct *);
	void (*task_dead)(struct task_struct *);
	void (*switched_from)(struct rq *, struct task_struct *);
	void (*switched_to)(struct rq *, struct task_struct *);
	void (*prio_changed)(struct rq *, struct task_struct *, int);
	unsigned int (*get_rr_interval)(struct rq *, struct task_struct *);
	void (*update_curr)(struct rq *);
	void (*task_change_group)(struct task_struct *);
};

typedef struct {
	u64 val;
} kernel_cap_t;

struct user_struct;

struct group_info;

struct cred {
	atomic_t usage;
	kuid_t uid;
	kgid_t gid;
	kuid_t suid;
	kgid_t sgid;
	kuid_t euid;
	kgid_t egid;
	kuid_t fsuid;
	kgid_t fsgid;
	unsigned int securebits;
	kernel_cap_t cap_inheritable;
	kernel_cap_t cap_permitted;
	kernel_cap_t cap_effective;
	kernel_cap_t cap_bset;
	kernel_cap_t cap_ambient;
	unsigned char jit_keyring;
	struct key *session_keyring;
	struct key *process_keyring;
	struct key *thread_keyring;
	struct key *request_key_auth;
	void *security;
	struct user_struct *user;
	struct user_namespace *user_ns;
	struct ucounts *ucounts;
	struct group_info *group_info;
	union {
		int non_rcu;
		struct callback_head rcu;
	};
};

typedef int32_t key_serial_t;

typedef uint32_t key_perm_t;

struct key_type;

struct key_tag;

struct keyring_index_key {
	long unsigned int hash;
	union {
		struct {
			u16 desc_len;
			char desc[6];
		};
		long unsigned int x;
	};
	struct key_type *type;
	struct key_tag *domain_tag;
	const char *description;
};

union key_payload {
	void *rcu_data0;
	void *data[4];
};

struct assoc_array_ptr;

struct assoc_array {
	struct assoc_array_ptr *root;
	long unsigned int nr_leaves_on_tree;
};

struct key_user;

struct key_restriction;

struct key {
	refcount_t usage;
	key_serial_t serial;
	union {
		struct list_head graveyard_link;
		struct rb_node serial_node;
	};
	struct rw_semaphore sem;
	struct key_user *user;
	void *security;
	union {
		time64_t expiry;
		time64_t revoked_at;
	};
	time64_t last_used_at;
	kuid_t uid;
	kgid_t gid;
	key_perm_t perm;
	short unsigned int quotalen;
	short unsigned int datalen;
	short int state;
	long unsigned int flags;
	union {
		struct keyring_index_key index_key;
		struct {
			long unsigned int hash;
			long unsigned int len_desc;
			struct key_type *type;
			struct key_tag *domain_tag;
			char *description;
		};
	};
	union {
		union key_payload payload;
		struct {
			struct list_head name_link;
			struct assoc_array keys;
		};
	};
	struct key_restriction *restrict_link;
};

struct uts_namespace;

struct ipc_namespace;

struct mnt_namespace;

struct net;

struct time_namespace;

struct cgroup_namespace;

struct nsproxy {
	refcount_t count;
	struct uts_namespace *uts_ns;
	struct ipc_namespace *ipc_ns;
	struct mnt_namespace *mnt_ns;
	struct pid_namespace *pid_ns_for_children;
	struct net *net_ns;
	struct time_namespace *time_ns;
	struct time_namespace *time_ns_for_children;
	struct cgroup_namespace *cgroup_ns;
};

struct sighand_struct {
	spinlock_t siglock;
	refcount_t count;
	wait_queue_head_t signalfd_wqh;
	struct k_sigaction action[64];
};

struct bio;

struct bio_list {
	struct bio *head;
	struct bio *tail;
};

struct request;

struct blk_plug {
	struct request *mq_list;
	struct request *cached_rq;
	short unsigned int nr_ios;
	short unsigned int rq_count;
	bool multiple_queues;
	bool has_elevator;
	struct list_head cb_list;
};

struct io_context {
	atomic_long_t refcount;
	atomic_t active_ref;
	short unsigned int ioprio;
};

struct cgroup_subsys_state;

struct cgroup;

struct css_set {
	struct cgroup_subsys_state *subsys[11];
	refcount_t refcount;
	struct css_set *dom_cset;
	struct cgroup *dfl_cgrp;
	int nr_tasks;
	struct list_head tasks;
	struct list_head mg_tasks;
	struct list_head dying_tasks;
	struct list_head task_iters;
	struct list_head e_cset_node[11];
	struct list_head threaded_csets;
	struct list_head threaded_csets_node;
	struct hlist_node hlist;
	struct list_head cgrp_links;
	struct list_head mg_src_preload_node;
	struct list_head mg_dst_preload_node;
	struct list_head mg_node;
	struct cgroup *mg_src_cgrp;
	struct cgroup *mg_dst_cgrp;
	struct css_set *mg_dst_cset;
	bool dead;
	struct callback_head callback_head;
};

struct perf_event_groups {
	struct rb_root tree;
	u64 index;
};

struct perf_event_context {
	raw_spinlock_t lock;
	struct mutex mutex;
	struct list_head pmu_ctx_list;
	struct perf_event_groups pinned_groups;
	struct perf_event_groups flexible_groups;
	struct list_head event_list;
	int nr_events;
	int nr_user;
	int is_active;
	int nr_task_data;
	int nr_stat;
	int nr_freq;
	int rotate_disable;
	refcount_t refcount;
	struct task_struct *task;
	u64 time;
	u64 timestamp;
	u64 timeoffset;
	struct perf_event_context *parent_ctx;
	u64 parent_gen;
	u64 generation;
	int pin_count;
	int nr_cgroups;
	struct callback_head callback_head;
	local_t nr_pending;
};

struct ftrace_ret_stack {
	long unsigned int ret;
	long unsigned int func;
	long long unsigned int calltime;
	long unsigned int *retp;
};

typedef void *mempool_alloc_t(gfp_t, void *);

typedef void mempool_free_t(void *, void *);

struct mempool_s {
	spinlock_t lock;
	int min_nr;
	int curr_nr;
	void **elements;
	void *pool_data;
	mempool_alloc_t *alloc;
	mempool_free_t *free;
	wait_queue_head_t wait;
};

typedef struct mempool_s mempool_t;

struct bio_alloc_cache;

struct bio_set {
	struct kmem_cache *bio_slab;
	unsigned int front_pad;
	struct bio_alloc_cache *cache;
	mempool_t bio_pool;
	mempool_t bvec_pool;
	unsigned int back_pad;
	spinlock_t rescue_lock;
	struct bio_list rescue_list;
	struct work_struct rescue_work;
	struct workqueue_struct *rescue_workqueue;
	struct hlist_node cpuhp_dead;
};

struct kset;

struct kobj_type;

struct kernfs_node;

struct kobject {
	const char *name;
	struct list_head entry;
	struct kobject *parent;
	struct kset *kset;
	const struct kobj_type *ktype;
	struct kernfs_node *sd;
	struct kref kref;
	unsigned int state_initialized: 1;
	unsigned int state_in_sysfs: 1;
	unsigned int state_add_uevent_sent: 1;
	unsigned int state_remove_uevent_sent: 1;
	unsigned int uevent_suppress: 1;
};

typedef unsigned int blk_mode_t;

struct block_device_operations;

struct request_queue;

struct timer_rand_state;

struct disk_events;

struct cdrom_device_info;

struct badblocks;

struct blk_independent_access_ranges;

struct gendisk {
	int major;
	int first_minor;
	int minors;
	char disk_name[32];
	short unsigned int events;
	short unsigned int event_flags;
	struct xarray part_tbl;
	struct block_device *part0;
	const struct block_device_operations *fops;
	struct request_queue *queue;
	void *private_data;
	struct bio_set bio_split;
	int flags;
	long unsigned int state;
	struct mutex open_mutex;
	unsigned int open_partitions;
	struct backing_dev_info *bdi;
	struct kobject queue_kobj;
	struct kobject *slave_dir;
	struct list_head slave_bdevs;
	struct timer_rand_state *random;
	atomic_t sync_io;
	struct disk_events *ev;
	struct cdrom_device_info *cdi;
	int node_id;
	struct badblocks *bb;
	struct lockdep_map lockdep_map;
	u64 diskseq;
	blk_mode_t open_mode;
	struct blk_independent_access_ranges *ia_ranges;
};

struct list_lru_one {
	struct list_head list;
	long int nr_items;
};

struct list_lru_node {
	spinlock_t lock;
	struct list_lru_one lru;
	long int nr_items;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

enum migrate_mode {
	MIGRATE_ASYNC = 0,
	MIGRATE_SYNC_LIGHT = 1,
	MIGRATE_SYNC = 2,
	MIGRATE_SYNC_NO_COPY = 3,
};

struct tracepoint_func {
	void *func;
	void *data;
	int prio;
};

struct tracepoint {
	const char *name;
	struct static_key key;
	struct static_call_key *static_call_key;
	void *static_call_tramp;
	void *iterator;
	void *probestub;
	int (*regfunc)();
	void (*unregfunc)();
	struct tracepoint_func *funcs;
};

typedef struct tracepoint * const tracepoint_ptr_t;

struct bpf_raw_event_map {
	struct tracepoint *tp;
	void *bpf_func;
	u32 num_args;
	u32 writable_size;
	long: 64;
};

struct cgroup_subsys;

struct cgroup_subsys_state {
	struct cgroup *cgroup;
	struct cgroup_subsys *ss;
	struct percpu_ref refcnt;
	struct list_head sibling;
	struct list_head children;
	struct list_head rstat_css_node;
	int id;
	unsigned int flags;
	u64 serial_nr;
	atomic_t online_cnt;
	struct work_struct destroy_work;
	struct rcu_work destroy_rwork;
	struct cgroup_subsys_state *parent;
};

struct cgroup_file {
	struct kernfs_node *kn;
	long unsigned int notified_at;
	struct timer_list notify_timer;
};

struct cgroup_base_stat {
	struct task_cputime cputime;
};

struct bpf_prog_array;

struct cgroup_bpf {
	struct bpf_prog_array *effective[33];
	struct hlist_head progs[33];
	u8 flags[33];
	struct list_head storages;
	struct bpf_prog_array *inactive;
	struct percpu_ref refcnt;
	struct work_struct release_work;
};

struct cgroup_freezer_state {
	bool freeze;
	int e_freeze;
	int nr_frozen_descendants;
	int nr_frozen_tasks;
};

struct cgroup_root;

struct cgroup_rstat_cpu;

struct psi_group;

struct cgroup {
	struct cgroup_subsys_state self;
	long unsigned int flags;
	int level;
	int max_depth;
	int nr_descendants;
	int nr_dying_descendants;
	int max_descendants;
	int nr_populated_csets;
	int nr_populated_domain_children;
	int nr_populated_threaded_children;
	int nr_threaded_children;
	struct kernfs_node *kn;
	struct cgroup_file procs_file;
	struct cgroup_file events_file;
	struct cgroup_file psi_files[3];
	u16 subtree_control;
	u16 subtree_ss_mask;
	u16 old_subtree_control;
	u16 old_subtree_ss_mask;
	struct cgroup_subsys_state *subsys[11];
	struct cgroup_root *root;
	struct list_head cset_links;
	struct list_head e_csets[11];
	struct cgroup *dom_cgrp;
	struct cgroup *old_dom_cgrp;
	struct cgroup_rstat_cpu *rstat_cpu;
	struct list_head rstat_css_list;
	struct cgroup_base_stat last_bstat;
	struct cgroup_base_stat bstat;
	struct prev_cputime prev_cputime;
	struct list_head pidlists;
	struct mutex pidlist_mutex;
	wait_queue_head_t offline_waitq;
	struct work_struct release_agent_work;
	struct psi_group *psi;
	struct cgroup_bpf bpf;
	atomic_t congestion_count;
	struct cgroup_freezer_state freezer;
	struct bpf_local_storage *bpf_cgrp_storage;
	struct cgroup *ancestors[0];
};

typedef int proc_handler(struct ctl_table *, int, void *, size_t *, loff_t *);

struct ctl_table_poll;

struct ctl_table {
	const char *procname;
	void *data;
	int maxlen;
	umode_t mode;
	enum {
		SYSCTL_TABLE_TYPE_DEFAULT = 0,
		SYSCTL_TABLE_TYPE_PERMANENTLY_EMPTY = 1,
	} type;
	proc_handler *proc_handler;
	struct ctl_table_poll *poll;
	void *extra1;
	void *extra2;
};

struct ctl_table_poll {
	atomic_t event;
	wait_queue_head_t wait;
};

struct ctl_node {
	struct rb_node node;
	struct ctl_table_header *header;
};

struct ctl_table_root {
	struct ctl_table_set default_set;
	struct ctl_table_set * (*lookup)(struct ctl_table_root *);
	void (*set_ownership)(struct ctl_table_header *, struct ctl_table *, kuid_t *, kgid_t *);
	int (*permissions)(struct ctl_table_header *, struct ctl_table *);
};

struct key_tag {
	struct callback_head rcu;
	refcount_t usage;
	bool removed;
};

typedef int (*request_key_actor_t)(struct key *, void *);

struct key_preparsed_payload;

struct key_match_data;

struct kernel_pkey_params;

struct kernel_pkey_query;

struct key_type {
	const char *name;
	size_t def_datalen;
	unsigned int flags;
	int (*vet_description)(const char *);
	int (*preparse)(struct key_preparsed_payload *);
	void (*free_preparse)(struct key_preparsed_payload *);
	int (*instantiate)(struct key *, struct key_preparsed_payload *);
	int (*update)(struct key *, struct key_preparsed_payload *);
	int (*match_preparse)(struct key_match_data *);
	void (*match_free)(struct key_match_data *);
	void (*revoke)(struct key *);
	void (*destroy)(struct key *);
	void (*describe)(const struct key *, struct seq_file *);
	long int (*read)(const struct key *, char *, size_t);
	request_key_actor_t request_key;
	struct key_restriction * (*lookup_restriction)(const char *);
	int (*asym_query)(const struct kernel_pkey_params *, struct kernel_pkey_query *);
	int (*asym_eds_op)(struct kernel_pkey_params *, const void *, void *);
	int (*asym_verify_signature)(struct kernel_pkey_params *, const void *, const void *);
	struct list_head link;
	struct lock_class_key lock_class;
};

typedef int (*key_restrict_link_func_t)(struct key *, const struct key_type *, const union key_payload *, struct key *);

struct key_restriction {
	key_restrict_link_func_t check;
	struct key *key;
	struct key_type *keytype;
};

struct user_struct {
	refcount_t __count;
	struct percpu_counter epoll_watches;
	long unsigned int unix_inflight;
	atomic_long_t pipe_bufs;
	struct hlist_node uidhash_node;
	kuid_t uid;
	atomic_long_t locked_vm;
	struct ratelimit_state ratelimit;
};

struct group_info {
	atomic_t usage;
	int ngroups;
	kgid_t gid[0];
};

struct core_thread {
	struct task_struct *task;
	struct core_thread *next;
};

struct core_state {
	atomic_t nr_threads;
	struct core_thread dumper;
	struct completion startup;
};

struct taskstats {
	__u16 version;
	__u32 ac_exitcode;
	__u8 ac_flag;
	__u8 ac_nice;
	__u64 cpu_count;
	__u64 cpu_delay_total;
	__u64 blkio_count;
	__u64 blkio_delay_total;
	__u64 swapin_count;
	__u64 swapin_delay_total;
	__u64 cpu_run_real_total;
	__u64 cpu_run_virtual_total;
	char ac_comm[32];
	__u8 ac_sched;
	__u8 ac_pad[3];
	long: 0;
	__u32 ac_uid;
	__u32 ac_gid;
	__u32 ac_pid;
	__u32 ac_ppid;
	__u32 ac_btime;
	__u64 ac_etime;
	__u64 ac_utime;
	__u64 ac_stime;
	__u64 ac_minflt;
	__u64 ac_majflt;
	__u64 coremem;
	__u64 virtmem;
	__u64 hiwater_rss;
	__u64 hiwater_vm;
	__u64 read_char;
	__u64 write_char;
	__u64 read_syscalls;
	__u64 write_syscalls;
	__u64 read_bytes;
	__u64 write_bytes;
	__u64 cancelled_write_bytes;
	__u64 nvcsw;
	__u64 nivcsw;
	__u64 ac_utimescaled;
	__u64 ac_stimescaled;
	__u64 cpu_scaled_run_real_total;
	__u64 freepages_count;
	__u64 freepages_delay_total;
	__u64 thrashing_count;
	__u64 thrashing_delay_total;
	__u64 ac_btime64;
	__u64 compact_count;
	__u64 compact_delay_total;
	__u32 ac_tgid;
	__u64 ac_tgetime;
	__u64 ac_exe_dev;
	__u64 ac_exe_inode;
	__u64 wpcopy_count;
	__u64 wpcopy_delay_total;
	__u64 irq_count;
	__u64 irq_delay_total;
};

struct delayed_call {
	void (*fn)(void *);
	void *arg;
};

enum rpm_status {
	RPM_INVALID = -1,
	RPM_ACTIVE = 0,
	RPM_RESUMING = 1,
	RPM_SUSPENDED = 2,
	RPM_SUSPENDING = 3,
};

enum blk_bounce {
	BLK_BOUNCE_NONE = 0,
	BLK_BOUNCE_HIGH = 1,
};

enum blk_zoned_model {
	BLK_ZONED_NONE = 0,
	BLK_ZONED_HA = 1,
	BLK_ZONED_HM = 2,
};

struct queue_limits {
	enum blk_bounce bounce;
	long unsigned int seg_boundary_mask;
	long unsigned int virt_boundary_mask;
	unsigned int max_hw_sectors;
	unsigned int max_dev_sectors;
	unsigned int chunk_sectors;
	unsigned int max_sectors;
	unsigned int max_user_sectors;
	unsigned int max_segment_size;
	unsigned int physical_block_size;
	unsigned int logical_block_size;
	unsigned int alignment_offset;
	unsigned int io_min;
	unsigned int io_opt;
	unsigned int max_discard_sectors;
	unsigned int max_hw_discard_sectors;
	unsigned int max_secure_erase_sectors;
	unsigned int max_write_zeroes_sectors;
	unsigned int max_zone_append_sectors;
	unsigned int discard_granularity;
	unsigned int discard_alignment;
	unsigned int zone_write_granularity;
	short unsigned int max_segments;
	short unsigned int max_integrity_segments;
	short unsigned int max_discard_segments;
	unsigned char misaligned;
	unsigned char discard_misaligned;
	unsigned char raid_partial_stripes_expensive;
	enum blk_zoned_model zoned;
	unsigned int dma_alignment;
};

struct elevator_queue;

struct blk_queue_stats;

struct rq_qos;

struct blk_mq_ops;

struct blk_mq_ctx;

struct blk_mq_tags;

struct blkcg_gq;

struct blk_trace;

struct blk_flush_queue;

struct blk_mq_tag_set;

struct request_queue {
	struct request *last_merge;
	struct elevator_queue *elevator;
	struct percpu_ref q_usage_counter;
	struct blk_queue_stats *stats;
	struct rq_qos *rq_qos;
	struct mutex rq_qos_mutex;
	const struct blk_mq_ops *mq_ops;
	struct blk_mq_ctx *queue_ctx;
	unsigned int queue_depth;
	struct xarray hctx_table;
	unsigned int nr_hw_queues;
	void *queuedata;
	long unsigned int queue_flags;
	atomic_t pm_only;
	int id;
	spinlock_t queue_lock;
	struct gendisk *disk;
	refcount_t refs;
	struct kobject *mq_kobj;
	struct device *dev;
	enum rpm_status rpm_status;
	long unsigned int nr_requests;
	unsigned int dma_pad_mask;
	unsigned int rq_timeout;
	struct timer_list timeout;
	struct work_struct timeout_work;
	atomic_t nr_active_requests_shared_tags;
	struct blk_mq_tags *sched_shared_tags;
	struct list_head icq_list;
	long unsigned int blkcg_pols[1];
	struct blkcg_gq *root_blkg;
	struct list_head blkg_list;
	struct mutex blkcg_mutex;
	struct queue_limits limits;
	unsigned int required_elevator_features;
	int node;
	struct blk_trace *blk_trace;
	struct blk_flush_queue *fq;
	struct list_head flush_list;
	struct list_head requeue_list;
	spinlock_t requeue_lock;
	struct delayed_work requeue_work;
	struct mutex sysfs_lock;
	struct mutex sysfs_dir_lock;
	struct list_head unused_hctx_list;
	spinlock_t unused_hctx_lock;
	int mq_freeze_depth;
	struct callback_head callback_head;
	wait_queue_head_t mq_freeze_wq;
	struct mutex mq_freeze_lock;
	int quiesce_depth;
	struct blk_mq_tag_set *tag_set;
	struct list_head tag_set_list;
	struct dentry *debugfs_dir;
	struct dentry *sched_debugfs_dir;
	struct dentry *rqos_debugfs_dir;
	struct mutex debugfs_mutex;
	bool mq_sysfs_init_done;
};

typedef struct {
	uid_t val;
} vfsuid_t;

typedef struct {
	gid_t val;
} vfsgid_t;

typedef void percpu_ref_func_t(struct percpu_ref *);

struct percpu_ref_data {
	atomic_long_t count;
	percpu_ref_func_t *release;
	percpu_ref_func_t *confirm_switch;
	bool force_atomic: 1;
	bool allow_reinit: 1;
	struct callback_head rcu;
	struct percpu_ref *ref;
};

enum kmalloc_cache_type {
	KMALLOC_NORMAL = 0,
	KMALLOC_DMA = 0,
	KMALLOC_RANDOM_START = 0,
	KMALLOC_RANDOM_END = 0,
	KMALLOC_RECLAIM = 1,
	KMALLOC_CGROUP = 2,
	NR_KMALLOC_TYPES = 3,
};

struct wait_page_queue;

struct kiocb {
	struct file *ki_filp;
	loff_t ki_pos;
	void (*ki_complete)(struct kiocb *, long int);
	void *private;
	int ki_flags;
	u16 ki_ioprio;
	union {
		struct wait_page_queue *ki_waitq;
		ssize_t (*dio_complete)(void *);
	};
};

struct iattr {
	unsigned int ia_valid;
	umode_t ia_mode;
	union {
		kuid_t ia_uid;
		vfsuid_t ia_vfsuid;
	};
	union {
		kgid_t ia_gid;
		vfsgid_t ia_vfsgid;
	};
	loff_t ia_size;
	struct timespec64 ia_atime;
	struct timespec64 ia_mtime;
	struct timespec64 ia_ctime;
	struct file *ia_file;
};

typedef __kernel_uid32_t projid_t;

typedef struct {
	projid_t val;
} kprojid_t;

enum quota_type {
	USRQUOTA = 0,
	GRPQUOTA = 1,
	PRJQUOTA = 2,
};

struct kqid {
	union {
		kuid_t uid;
		kgid_t gid;
		kprojid_t projid;
	};
	enum quota_type type;
};

struct mem_dqblk {
	qsize_t dqb_bhardlimit;
	qsize_t dqb_bsoftlimit;
	qsize_t dqb_curspace;
	qsize_t dqb_rsvspace;
	qsize_t dqb_ihardlimit;
	qsize_t dqb_isoftlimit;
	qsize_t dqb_curinodes;
	time64_t dqb_btime;
	time64_t dqb_itime;
};

struct dquot {
	struct hlist_node dq_hash;
	struct list_head dq_inuse;
	struct list_head dq_free;
	struct list_head dq_dirty;
	struct mutex dq_lock;
	spinlock_t dq_dqb_lock;
	atomic_t dq_count;
	struct super_block *dq_sb;
	struct kqid dq_id;
	loff_t dq_off;
	long unsigned int dq_flags;
	struct mem_dqblk dq_dqb;
};

struct quota_format_type {
	int qf_fmt_id;
	const struct quota_format_ops *qf_ops;
	struct module *qf_owner;
	struct quota_format_type *qf_next;
};

struct quota_format_ops {
	int (*check_quota_file)(struct super_block *, int);
	int (*read_file_info)(struct super_block *, int);
	int (*write_file_info)(struct super_block *, int);
	int (*free_file_info)(struct super_block *, int);
	int (*read_dqblk)(struct dquot *);
	int (*commit_dqblk)(struct dquot *);
	int (*release_dqblk)(struct dquot *);
	int (*get_next_id)(struct super_block *, struct kqid *);
};

struct dquot_operations {
	int (*write_dquot)(struct dquot *);
	struct dquot * (*alloc_dquot)(struct super_block *, int);
	void (*destroy_dquot)(struct dquot *);
	int (*acquire_dquot)(struct dquot *);
	int (*release_dquot)(struct dquot *);
	int (*mark_dirty)(struct dquot *);
	int (*write_info)(struct super_block *, int);
	qsize_t * (*get_reserved_space)(struct inode *);
	int (*get_projid)(struct inode *, kprojid_t *);
	int (*get_inode_usage)(struct inode *, qsize_t *);
	int (*get_next_id)(struct super_block *, struct kqid *);
};

struct qc_dqblk {
	int d_fieldmask;
	u64 d_spc_hardlimit;
	u64 d_spc_softlimit;
	u64 d_ino_hardlimit;
	u64 d_ino_softlimit;
	u64 d_space;
	u64 d_ino_count;
	s64 d_ino_timer;
	s64 d_spc_timer;
	int d_ino_warns;
	int d_spc_warns;
	u64 d_rt_spc_hardlimit;
	u64 d_rt_spc_softlimit;
	u64 d_rt_space;
	s64 d_rt_spc_timer;
	int d_rt_spc_warns;
};

struct qc_type_state {
	unsigned int flags;
	unsigned int spc_timelimit;
	unsigned int ino_timelimit;
	unsigned int rt_spc_timelimit;
	unsigned int spc_warnlimit;
	unsigned int ino_warnlimit;
	unsigned int rt_spc_warnlimit;
	long long unsigned int ino;
	blkcnt_t blocks;
	blkcnt_t nextents;
};

struct qc_state {
	unsigned int s_incoredqs;
	struct qc_type_state s_state[3];
};

struct qc_info {
	int i_fieldmask;
	unsigned int i_flags;
	unsigned int i_spc_timelimit;
	unsigned int i_ino_timelimit;
	unsigned int i_rt_spc_timelimit;
	unsigned int i_spc_warnlimit;
	unsigned int i_ino_warnlimit;
	unsigned int i_rt_spc_warnlimit;
};

struct quotactl_ops {
	int (*quota_on)(struct super_block *, int, int, const struct path *);
	int (*quota_off)(struct super_block *, int);
	int (*quota_enable)(struct super_block *, unsigned int);
	int (*quota_disable)(struct super_block *, unsigned int);
	int (*quota_sync)(struct super_block *, int);
	int (*set_info)(struct super_block *, int, struct qc_info *);
	int (*get_dqblk)(struct super_block *, struct kqid, struct qc_dqblk *);
	int (*get_nextdqblk)(struct super_block *, struct kqid *, struct qc_dqblk *);
	int (*set_dqblk)(struct super_block *, struct kqid, struct qc_dqblk *);
	int (*get_state)(struct super_block *, struct qc_state *);
	int (*rm_xquota)(struct super_block *, unsigned int);
};

enum module_state {
	MODULE_STATE_LIVE = 0,
	MODULE_STATE_COMING = 1,
	MODULE_STATE_GOING = 2,
	MODULE_STATE_UNFORMED = 3,
};

struct module_param_attrs;

struct module_kobject {
	struct kobject kobj;
	struct module *mod;
	struct kobject *drivers_dir;
	struct module_param_attrs *mp;
	struct completion *kobj_completion;
};

struct latch_tree_node {
	struct rb_node node[2];
};

struct mod_tree_node {
	struct module *mod;
	struct latch_tree_node node;
};

struct module_memory {
	void *base;
	unsigned int size;
	struct mod_tree_node mtn;
};

struct mod_arch_specific {
	unsigned int stubs_section;
	unsigned int toc_section;
	bool toc_fixed;
	long unsigned int start_opd;
	long unsigned int end_opd;
	long unsigned int tramp;
	long unsigned int tramp_regs;
	struct list_head bug_list;
	struct bug_entry *bug_table;
	unsigned int num_bugs;
};

struct elf64_sym;

typedef struct elf64_sym Elf64_Sym;

struct mod_kallsyms {
	Elf64_Sym *symtab;
	unsigned int num_symtab;
	char *strtab;
	char *typetab;
};

struct module_attribute;

struct kernel_symbol;

struct kernel_param;

struct module_sect_attrs;

struct module_notes_attrs;

struct trace_eval_map;

struct kunit_suite;

struct module {
	enum module_state state;
	struct list_head list;
	char name[56];
	struct module_kobject mkobj;
	struct module_attribute *modinfo_attrs;
	const char *version;
	const char *srcversion;
	struct kobject *holders_dir;
	const struct kernel_symbol *syms;
	const s32 *crcs;
	unsigned int num_syms;
	struct mutex param_lock;
	struct kernel_param *kp;
	unsigned int num_kp;
	unsigned int num_gpl_syms;
	const struct kernel_symbol *gpl_syms;
	const s32 *gpl_crcs;
	bool using_gplonly_symbols;
	bool sig_ok;
	bool async_probe_requested;
	unsigned int num_exentries;
	struct exception_table_entry *extable;
	int (*init)();
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct module_memory mem[7];
	struct mod_arch_specific arch;
	long unsigned int taints;
	unsigned int num_bugs;
	struct list_head bug_list;
	struct bug_entry *bug_table;
	struct mod_kallsyms *kallsyms;
	struct mod_kallsyms core_kallsyms;
	struct module_sect_attrs *sect_attrs;
	struct module_notes_attrs *notes_attrs;
	char *args;
	void *percpu;
	unsigned int percpu_size;
	void *noinstr_text_start;
	unsigned int noinstr_text_size;
	unsigned int num_tracepoints;
	tracepoint_ptr_t *tracepoints_ptrs;
	unsigned int num_srcu_structs;
	struct srcu_struct **srcu_struct_ptrs;
	unsigned int num_bpf_raw_events;
	struct bpf_raw_event_map *bpf_raw_events;
	unsigned int btf_data_size;
	void *btf_data;
	struct jump_entry *jump_entries;
	unsigned int num_jump_entries;
	unsigned int num_trace_bprintk_fmt;
	const char **trace_bprintk_fmt_start;
	struct trace_event_call **trace_events;
	unsigned int num_trace_events;
	struct trace_eval_map **trace_evals;
	unsigned int num_trace_evals;
	unsigned int num_ftrace_callsites;
	long unsigned int *ftrace_callsites;
	void *kprobes_text_start;
	unsigned int kprobes_text_size;
	long unsigned int *kprobe_blacklist;
	unsigned int num_kprobe_blacklist;
	int num_kunit_suites;
	struct kunit_suite **kunit_suites;
	struct list_head source_list;
	struct list_head target_list;
	void (*exit)();
	atomic_t refcnt;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct writeback_control;

struct readahead_control;

struct swap_info_struct;

struct address_space_operations {
	int (*writepage)(struct page *, struct writeback_control *);
	int (*read_folio)(struct file *, struct folio *);
	int (*writepages)(struct address_space *, struct writeback_control *);
	bool (*dirty_folio)(struct address_space *, struct folio *);
	void (*readahead)(struct readahead_control *);
	int (*write_begin)(struct file *, struct address_space *, loff_t, unsigned int, struct page **, void **);
	int (*write_end)(struct file *, struct address_space *, loff_t, unsigned int, unsigned int, struct page *, void *);
	sector_t (*bmap)(struct address_space *, sector_t);
	void (*invalidate_folio)(struct folio *, size_t, size_t);
	bool (*release_folio)(struct folio *, gfp_t);
	void (*free_folio)(struct folio *);
	ssize_t (*direct_IO)(struct kiocb *, struct iov_iter *);
	int (*migrate_folio)(struct address_space *, struct folio *, struct folio *, enum migrate_mode);
	int (*launder_folio)(struct folio *);
	bool (*is_partially_uptodate)(struct folio *, size_t, size_t);
	void (*is_dirty_writeback)(struct folio *, bool *, bool *);
	int (*error_remove_page)(struct address_space *, struct page *);
	int (*swap_activate)(struct swap_info_struct *, struct file *, sector_t *);
	void (*swap_deactivate)(struct file *);
	int (*swap_rw)(struct kiocb *, struct iov_iter *);
};

struct iovec {
	void *iov_base;
	__kernel_size_t iov_len;
};

struct kvec;

struct bio_vec;

struct iov_iter {
	u8 iter_type;
	bool copy_mc;
	bool nofault;
	bool data_source;
	bool user_backed;
	union {
		size_t iov_offset;
		int last_offset;
	};
	union {
		struct iovec __ubuf_iovec;
		struct {
			union {
				const struct iovec *__iov;
				const struct kvec *kvec;
				const struct bio_vec *bvec;
				struct xarray *xarray;
				void *ubuf;
			};
			size_t count;
		};
	};
	union {
		long unsigned int nr_segs;
		loff_t xarray_start;
	};
};

struct fiemap_extent_info;

struct fileattr;

struct offset_ctx;

struct inode_operations {
	struct dentry * (*lookup)(struct inode *, struct dentry *, unsigned int);
	const char * (*get_link)(struct dentry *, struct inode *, struct delayed_call *);
	int (*permission)(struct mnt_idmap *, struct inode *, int);
	struct posix_acl * (*get_inode_acl)(struct inode *, int, bool);
	int (*readlink)(struct dentry *, char *, int);
	int (*create)(struct mnt_idmap *, struct inode *, struct dentry *, umode_t, bool);
	int (*link)(struct dentry *, struct inode *, struct dentry *);
	int (*unlink)(struct inode *, struct dentry *);
	int (*symlink)(struct mnt_idmap *, struct inode *, struct dentry *, const char *);
	int (*mkdir)(struct mnt_idmap *, struct inode *, struct dentry *, umode_t);
	int (*rmdir)(struct inode *, struct dentry *);
	int (*mknod)(struct mnt_idmap *, struct inode *, struct dentry *, umode_t, dev_t);
	int (*rename)(struct mnt_idmap *, struct inode *, struct dentry *, struct inode *, struct dentry *, unsigned int);
	int (*setattr)(struct mnt_idmap *, struct dentry *, struct iattr *);
	int (*getattr)(struct mnt_idmap *, const struct path *, struct kstat *, u32, unsigned int);
	ssize_t (*listxattr)(struct dentry *, char *, size_t);
	int (*fiemap)(struct inode *, struct fiemap_extent_info *, u64, u64);
	int (*update_time)(struct inode *, int);
	int (*atomic_open)(struct inode *, struct dentry *, struct file *, unsigned int, umode_t);
	int (*tmpfile)(struct mnt_idmap *, struct inode *, struct file *, umode_t);
	struct posix_acl * (*get_acl)(struct mnt_idmap *, struct dentry *, int);
	int (*set_acl)(struct mnt_idmap *, struct dentry *, struct posix_acl *, int);
	int (*fileattr_set)(struct mnt_idmap *, struct dentry *, struct fileattr *);
	int (*fileattr_get)(struct dentry *, struct fileattr *);
	struct offset_ctx * (*get_offset_ctx)(struct inode *);
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct fasync_struct {
	rwlock_t fa_lock;
	int magic;
	int fa_fd;
	struct fasync_struct *fa_next;
	struct file *fa_file;
	struct callback_head fa_rcu;
};

enum freeze_holder {
	FREEZE_HOLDER_KERNEL = 1,
	FREEZE_HOLDER_USERSPACE = 2,
};

struct kstatfs;

struct super_operations {
	struct inode * (*alloc_inode)(struct super_block *);
	void (*destroy_inode)(struct inode *);
	void (*free_inode)(struct inode *);
	void (*dirty_inode)(struct inode *, int);
	int (*write_inode)(struct inode *, struct writeback_control *);
	int (*drop_inode)(struct inode *);
	void (*evict_inode)(struct inode *);
	void (*put_super)(struct super_block *);
	int (*sync_fs)(struct super_block *, int);
	int (*freeze_super)(struct super_block *, enum freeze_holder);
	int (*freeze_fs)(struct super_block *);
	int (*thaw_super)(struct super_block *, enum freeze_holder);
	int (*unfreeze_fs)(struct super_block *);
	int (*statfs)(struct dentry *, struct kstatfs *);
	int (*remount_fs)(struct super_block *, int *, char *);
	void (*umount_begin)(struct super_block *);
	int (*show_options)(struct seq_file *, struct dentry *);
	int (*show_devname)(struct seq_file *, struct dentry *);
	int (*show_path)(struct seq_file *, struct dentry *);
	int (*show_stats)(struct seq_file *, struct dentry *);
	long int (*nr_cached_objects)(struct super_block *, struct shrink_control *);
	long int (*free_cached_objects)(struct super_block *, struct shrink_control *);
	void (*shutdown)(struct super_block *);
};

struct fid;

struct iomap;

struct export_operations {
	int (*encode_fh)(struct inode *, __u32 *, int *, struct inode *);
	struct dentry * (*fh_to_dentry)(struct super_block *, struct fid *, int, int);
	struct dentry * (*fh_to_parent)(struct super_block *, struct fid *, int, int);
	int (*get_name)(struct dentry *, char *, struct dentry *);
	struct dentry * (*get_parent)(struct dentry *);
	int (*commit_metadata)(struct inode *);
	int (*get_uuid)(struct super_block *, u8 *, u32 *, u64 *);
	int (*map_blocks)(struct inode *, loff_t, u64, struct iomap *, bool, u32 *);
	int (*commit_blocks)(struct inode *, struct iomap *, int, struct iattr *);
	long unsigned int flags;
};

struct xattr_handler {
	const char *name;
	const char *prefix;
	int flags;
	bool (*list)(struct dentry *);
	int (*get)(const struct xattr_handler *, struct dentry *, struct inode *, const char *, void *, size_t);
	int (*set)(const struct xattr_handler *, struct mnt_idmap *, struct dentry *, struct inode *, const char *, const void *, size_t, int);
};

enum dl_dev_state {
	DL_DEV_NO_DRIVER = 0,
	DL_DEV_PROBING = 1,
	DL_DEV_DRIVER_BOUND = 2,
	DL_DEV_UNBINDING = 3,
};

struct dev_links_info {
	struct list_head suppliers;
	struct list_head consumers;
	struct list_head defer_sync;
	enum dl_dev_state status;
};

struct pm_message {
	int event;
};

typedef struct pm_message pm_message_t;

enum rpm_request {
	RPM_REQ_NONE = 0,
	RPM_REQ_IDLE = 1,
	RPM_REQ_SUSPEND = 2,
	RPM_REQ_AUTOSUSPEND = 3,
	RPM_REQ_RESUME = 4,
};

struct wakeup_source;

struct wake_irq;

struct pm_subsys_data;

struct dev_pm_qos;

struct dev_pm_info {
	pm_message_t power_state;
	unsigned int can_wakeup: 1;
	unsigned int async_suspend: 1;
	bool in_dpm_list: 1;
	bool is_prepared: 1;
	bool is_suspended: 1;
	bool is_noirq_suspended: 1;
	bool is_late_suspended: 1;
	bool no_pm: 1;
	bool early_init: 1;
	bool direct_complete: 1;
	u32 driver_flags;
	spinlock_t lock;
	struct list_head entry;
	struct completion completion;
	struct wakeup_source *wakeup;
	bool wakeup_path: 1;
	bool syscore: 1;
	bool no_pm_callbacks: 1;
	unsigned int must_resume: 1;
	unsigned int may_skip_resume: 1;
	struct hrtimer suspend_timer;
	u64 timer_expires;
	struct work_struct work;
	wait_queue_head_t wait_queue;
	struct wake_irq *wakeirq;
	atomic_t usage_count;
	atomic_t child_count;
	unsigned int disable_depth: 3;
	unsigned int idle_notification: 1;
	unsigned int request_pending: 1;
	unsigned int deferred_resume: 1;
	unsigned int needs_force_resume: 1;
	unsigned int runtime_auto: 1;
	bool ignore_children: 1;
	unsigned int no_callbacks: 1;
	unsigned int irq_safe: 1;
	unsigned int use_autosuspend: 1;
	unsigned int timer_autosuspends: 1;
	unsigned int memalloc_noio: 1;
	unsigned int links_count;
	enum rpm_request request;
	enum rpm_status runtime_status;
	enum rpm_status last_status;
	int runtime_error;
	int autosuspend_delay;
	u64 last_busy;
	u64 active_time;
	u64 suspended_time;
	u64 accounting_timestamp;
	struct pm_subsys_data *subsys_data;
	void (*set_latency_tolerance)(struct device *, s32);
	struct dev_pm_qos *qos;
};

struct irq_domain;

struct msi_device_data;

struct dev_msi_info {
	struct irq_domain *domain;
	struct msi_device_data *data;
};

struct iommu_table;

struct pci_dn;

struct eeh_dev;

struct cxl_context;

struct dev_archdata {
	dma_addr_t dma_offset;
	struct iommu_table *iommu_table_base;
	struct pci_dn *pci_data;
	struct eeh_dev *edev;
	struct cxl_context *cxl_ctx;
};

enum device_removable {
	DEVICE_REMOVABLE_NOT_SUPPORTED = 0,
	DEVICE_REMOVABLE_UNKNOWN = 1,
	DEVICE_FIXED = 2,
	DEVICE_REMOVABLE = 3,
};

struct device_private;

struct device_type;

struct bus_type;

struct device_driver;

struct dev_pm_domain;

struct dma_map_ops;

struct bus_dma_region;

struct device_dma_parameters;

struct dma_coherent_mem;

struct io_tlb_mem;

struct device_node;

struct fwnode_handle;

struct class;

struct iommu_group;

struct dev_iommu;

struct device_physical_location;

struct device {
	struct kobject kobj;
	struct device *parent;
	struct device_private *p;
	const char *init_name;
	const struct device_type *type;
	const struct bus_type *bus;
	struct device_driver *driver;
	void *platform_data;
	void *driver_data;
	struct mutex mutex;
	struct dev_links_info links;
	struct dev_pm_info power;
	struct dev_pm_domain *pm_domain;
	struct dev_msi_info msi;
	const struct dma_map_ops *dma_ops;
	u64 *dma_mask;
	u64 coherent_dma_mask;
	u64 bus_dma_limit;
	const struct bus_dma_region *dma_range_map;
	struct device_dma_parameters *dma_parms;
	struct list_head dma_pools;
	struct dma_coherent_mem *dma_mem;
	struct io_tlb_mem *dma_io_tlb_mem;
	struct dev_archdata archdata;
	struct device_node *of_node;
	struct fwnode_handle *fwnode;
	int numa_node;
	dev_t devt;
	u32 id;
	spinlock_t devres_lock;
	struct list_head devres_head;
	const struct class *class;
	const struct attribute_group **groups;
	void (*release)(struct device *);
	struct iommu_group *iommu_group;
	struct dev_iommu *iommu;
	struct device_physical_location *physical_location;
	enum device_removable removable;
	bool offline_disabled: 1;
	bool offline: 1;
	bool of_node_reused: 1;
	bool state_synced: 1;
	bool can_match: 1;
	bool dma_ops_bypass: 1;
};

struct disk_stats;

struct blk_holder_ops;

struct partition_meta_info;

struct block_device {
	sector_t bd_start_sect;
	sector_t bd_nr_sectors;
	struct gendisk *bd_disk;
	struct request_queue *bd_queue;
	struct disk_stats *bd_stats;
	long unsigned int bd_stamp;
	bool bd_read_only;
	u8 bd_partno;
	bool bd_write_holder;
	bool bd_has_submit_bio;
	dev_t bd_dev;
	atomic_t bd_openers;
	spinlock_t bd_size_lock;
	struct inode *bd_inode;
	void *bd_claiming;
	void *bd_holder;
	const struct blk_holder_ops *bd_holder_ops;
	struct mutex bd_holder_lock;
	int bd_fsfreeze_count;
	int bd_holders;
	struct kobject *bd_holder_dir;
	struct mutex bd_fsfreeze_mutex;
	struct super_block *bd_fsfreeze_sb;
	struct partition_meta_info *bd_meta_info;
	struct device bd_device;
};

typedef bool (*filldir_t)(struct dir_context *, const char *, int, loff_t, u64, unsigned int);

struct dir_context {
	filldir_t actor;
	loff_t pos;
};

struct io_comp_batch {
	struct request *req_list;
	bool need_ts;
	void (*complete)(struct io_comp_batch *);
};

typedef void (*poll_queue_proc)(struct file *, wait_queue_head_t *, struct poll_table_struct *);

struct poll_table_struct {
	poll_queue_proc _qproc;
	__poll_t _key;
};

struct seq_operations;

struct seq_file {
	char *buf;
	size_t size;
	size_t from;
	size_t count;
	size_t pad_until;
	loff_t index;
	loff_t read_pos;
	struct mutex lock;
	const struct seq_operations *op;
	int poll_event;
	const struct file *file;
	void *private;
};

struct offset_ctx {
	struct xarray xa;
	u32 next_offset;
};

struct p_log;

struct fs_parameter;

struct fs_parse_result;

typedef int fs_param_type(struct p_log *, const struct fs_parameter_spec *, struct fs_parameter *, struct fs_parse_result *);

struct fs_parameter_spec {
	const char *name;
	fs_param_type *type;
	u8 opt;
	short unsigned int flags;
	const void *data;
};

typedef __u32 blk_opf_t;

typedef u8 blk_status_t;

struct bvec_iter {
	sector_t bi_sector;
	unsigned int bi_size;
	unsigned int bi_idx;
	unsigned int bi_bvec_done;
} __attribute__((packed));

typedef unsigned int blk_qc_t;

typedef void bio_end_io_t(struct bio *);

struct bio_issue {
	u64 value;
};

struct bio_vec {
	struct page *bv_page;
	unsigned int bv_len;
	unsigned int bv_offset;
};

struct bio {
	struct bio *bi_next;
	struct block_device *bi_bdev;
	blk_opf_t bi_opf;
	short unsigned int bi_flags;
	short unsigned int bi_ioprio;
	blk_status_t bi_status;
	atomic_t __bi_remaining;
	struct bvec_iter bi_iter;
	blk_qc_t bi_cookie;
	bio_end_io_t *bi_end_io;
	void *bi_private;
	struct blkcg_gq *bi_blkg;
	struct bio_issue bi_issue;
	union {};
	short unsigned int bi_vcnt;
	short unsigned int bi_max_vecs;
	atomic_t __bi_cnt;
	struct bio_vec *bi_io_vec;
	struct bio_set *bi_pool;
	struct bio_vec bi_inline_vecs[0];
};

struct minix_super_block {
	__u16 s_ninodes;
	__u16 s_nzones;
	__u16 s_imap_blocks;
	__u16 s_zmap_blocks;
	__u16 s_firstdatazone;
	__u16 s_log_zone_size;
	__u32 s_max_size;
	__u16 s_magic;
	__u16 s_state;
	__u32 s_zones;
};

struct romfs_super_block {
	__be32 word0;
	__be32 word1;
	__be32 size;
	__be32 checksum;
	char name[0];
};

struct cramfs_inode {
	__u32 mode: 16;
	__u32 uid: 16;
	__u32 size: 24;
	__u32 gid: 8;
	__u32 namelen: 6;
	__u32 offset: 26;
};

struct cramfs_info {
	__u32 crc;
	__u32 edition;
	__u32 blocks;
	__u32 files;
};

struct cramfs_super {
	__u32 magic;
	__u32 size;
	__u32 flags;
	__u32 future;
	__u8 signature[16];
	struct cramfs_info fsid;
	__u8 name[16];
	struct cramfs_inode root;
};

struct dev_pagemap_ops {
	void (*page_free)(struct page *);
	vm_fault_t (*migrate_to_ram)(struct vm_fault *);
	int (*memory_failure)(struct dev_pagemap *, long unsigned int, long unsigned int, int);
};

struct kernfs_root;

struct kernfs_elem_dir {
	long unsigned int subdirs;
	struct rb_root children;
	struct kernfs_root *root;
	long unsigned int rev;
};

struct kernfs_elem_symlink {
	struct kernfs_node *target_kn;
};

struct kernfs_ops;

struct kernfs_open_node;

struct kernfs_elem_attr {
	const struct kernfs_ops *ops;
	struct kernfs_open_node *open;
	loff_t size;
	struct kernfs_node *notify_next;
};

struct kernfs_iattrs;

struct kernfs_node {
	atomic_t count;
	atomic_t active;
	struct kernfs_node *parent;
	const char *name;
	struct rb_node rb;
	const void *ns;
	unsigned int hash;
	union {
		struct kernfs_elem_dir dir;
		struct kernfs_elem_symlink symlink;
		struct kernfs_elem_attr attr;
	};
	void *priv;
	u64 id;
	short unsigned int flags;
	umode_t mode;
	struct kernfs_iattrs *iattr;
};

struct kernfs_open_file;

struct kernfs_ops {
	int (*open)(struct kernfs_open_file *);
	void (*release)(struct kernfs_open_file *);
	int (*seq_show)(struct seq_file *, void *);
	void * (*seq_start)(struct seq_file *, loff_t *);
	void * (*seq_next)(struct seq_file *, void *, loff_t *);
	void (*seq_stop)(struct seq_file *, void *);
	ssize_t (*read)(struct kernfs_open_file *, char *, size_t, loff_t);
	size_t atomic_write_len;
	bool prealloc;
	ssize_t (*write)(struct kernfs_open_file *, char *, size_t, loff_t);
	__poll_t (*poll)(struct kernfs_open_file *, struct poll_table_struct *);
	int (*mmap)(struct kernfs_open_file *, struct vm_area_struct *);
};

struct kernfs_open_file {
	struct kernfs_node *kn;
	struct file *file;
	struct seq_file *seq_file;
	void *priv;
	struct mutex mutex;
	struct mutex prealloc_mutex;
	int event;
	struct list_head list;
	char *prealloc_buf;
	size_t atomic_write_len;
	bool mmapped: 1;
	bool released: 1;
	const struct vm_operations_struct *vm_ops;
};

enum kobj_ns_type {
	KOBJ_NS_TYPE_NONE = 0,
	KOBJ_NS_TYPE_NET = 1,
	KOBJ_NS_TYPES = 2,
};

struct sock;

struct kobj_ns_type_operations {
	enum kobj_ns_type type;
	bool (*current_may_mount)();
	void * (*grab_current_ns)();
	const void * (*netlink_ns)(struct sock *);
	const void * (*initial_ns)();
	void (*drop_ns)(void *);
};

struct attribute {
	const char *name;
	umode_t mode;
};

struct bin_attribute;

struct attribute_group {
	const char *name;
	umode_t (*is_visible)(struct kobject *, struct attribute *, int);
	umode_t (*is_bin_visible)(struct kobject *, struct bin_attribute *, int);
	struct attribute **attrs;
	struct bin_attribute **bin_attrs;
};

struct bin_attribute {
	struct attribute attr;
	size_t size;
	void *private;
	struct address_space * (*f_mapping)();
	ssize_t (*read)(struct file *, struct kobject *, struct bin_attribute *, char *, loff_t, size_t);
	ssize_t (*write)(struct file *, struct kobject *, struct bin_attribute *, char *, loff_t, size_t);
	int (*mmap)(struct file *, struct kobject *, struct bin_attribute *, struct vm_area_struct *);
};

struct sysfs_ops {
	ssize_t (*show)(struct kobject *, struct attribute *, char *);
	ssize_t (*store)(struct kobject *, struct attribute *, const char *, size_t);
};

struct kset_uevent_ops;

struct kset {
	struct list_head list;
	spinlock_t list_lock;
	struct kobject kobj;
	const struct kset_uevent_ops *uevent_ops;
};

struct kobj_type {
	void (*release)(struct kobject *);
	const struct sysfs_ops *sysfs_ops;
	const struct attribute_group **default_groups;
	const struct kobj_ns_type_operations * (*child_ns_type)(const struct kobject *);
	const void * (*namespace)(const struct kobject *);
	void (*get_ownership)(const struct kobject *, kuid_t *, kgid_t *);
};

struct kobj_uevent_env {
	char *argv[3];
	char *envp[64];
	int envp_idx;
	char buf[2048];
	int buflen;
};

struct kset_uevent_ops {
	int (* const filter)(const struct kobject *);
	const char * (* const name)(const struct kobject *);
	int (* const uevent)(const struct kobject *, struct kobj_uevent_env *);
};

struct dev_pm_ops {
	int (*prepare)(struct device *);
	void (*complete)(struct device *);
	int (*suspend)(struct device *);
	int (*resume)(struct device *);
	int (*freeze)(struct device *);
	int (*thaw)(struct device *);
	int (*poweroff)(struct device *);
	int (*restore)(struct device *);
	int (*suspend_late)(struct device *);
	int (*resume_early)(struct device *);
	int (*freeze_late)(struct device *);
	int (*thaw_early)(struct device *);
	int (*poweroff_late)(struct device *);
	int (*restore_early)(struct device *);
	int (*suspend_noirq)(struct device *);
	int (*resume_noirq)(struct device *);
	int (*freeze_noirq)(struct device *);
	int (*thaw_noirq)(struct device *);
	int (*poweroff_noirq)(struct device *);
	int (*restore_noirq)(struct device *);
	int (*runtime_suspend)(struct device *);
	int (*runtime_resume)(struct device *);
	int (*runtime_idle)(struct device *);
};

struct pm_subsys_data {
	spinlock_t lock;
	unsigned int refcount;
};

struct wakeup_source {
	const char *name;
	int id;
	struct list_head entry;
	spinlock_t lock;
	struct wake_irq *wakeirq;
	struct timer_list timer;
	long unsigned int timer_expires;
	ktime_t total_time;
	ktime_t max_time;
	ktime_t last_time;
	ktime_t start_prevent_time;
	ktime_t prevent_sleep_time;
	long unsigned int event_count;
	long unsigned int active_count;
	long unsigned int relax_count;
	long unsigned int expire_count;
	long unsigned int wakeup_count;
	struct device *dev;
	bool active: 1;
	bool autosleep_enabled: 1;
};

struct dev_pm_domain {
	struct dev_pm_ops ops;
	int (*start)(struct device *);
	void (*detach)(struct device *, bool);
	int (*activate)(struct device *);
	void (*sync)(struct device *);
	void (*dismiss)(struct device *);
};

struct iommu_ops;

struct bus_type {
	const char *name;
	const char *dev_name;
	const struct attribute_group **bus_groups;
	const struct attribute_group **dev_groups;
	const struct attribute_group **drv_groups;
	int (*match)(struct device *, struct device_driver *);
	int (*uevent)(const struct device *, struct kobj_uevent_env *);
	int (*probe)(struct device *);
	void (*sync_state)(struct device *);
	void (*remove)(struct device *);
	void (*shutdown)(struct device *);
	int (*online)(struct device *);
	int (*offline)(struct device *);
	int (*suspend)(struct device *, pm_message_t);
	int (*resume)(struct device *);
	int (*num_vf)(struct device *);
	int (*dma_configure)(struct device *);
	void (*dma_cleanup)(struct device *);
	const struct dev_pm_ops *pm;
	const struct iommu_ops *iommu_ops;
	bool need_parent_lock;
};

enum probe_type {
	PROBE_DEFAULT_STRATEGY = 0,
	PROBE_PREFER_ASYNCHRONOUS = 1,
	PROBE_FORCE_SYNCHRONOUS = 2,
};

struct of_device_id;

struct acpi_device_id;

struct driver_private;

struct device_driver {
	const char *name;
	const struct bus_type *bus;
	struct module *owner;
	const char *mod_name;
	bool suppress_bind_attrs;
	enum probe_type probe_type;
	const struct of_device_id *of_match_table;
	const struct acpi_device_id *acpi_match_table;
	int (*probe)(struct device *);
	void (*sync_state)(struct device *);
	int (*remove)(struct device *);
	void (*shutdown)(struct device *);
	int (*suspend)(struct device *, pm_message_t);
	int (*resume)(struct device *);
	const struct attribute_group **groups;
	const struct attribute_group **dev_groups;
	const struct dev_pm_ops *pm;
	void (*coredump)(struct device *);
	struct driver_private *p;
};

enum iommu_cap {
	IOMMU_CAP_CACHE_COHERENCY = 0,
	IOMMU_CAP_NOEXEC = 1,
	IOMMU_CAP_PRE_BOOT_PROTECTION = 2,
	IOMMU_CAP_ENFORCE_CACHE_COHERENCY = 3,
	IOMMU_CAP_DEFERRED_FLUSH = 4,
};

enum iommu_dev_features {
	IOMMU_DEV_FEAT_SVA = 0,
	IOMMU_DEV_FEAT_IOPF = 1,
};

typedef unsigned int ioasid_t;

struct iommu_domain;

struct iommu_device;

struct of_phandle_args;

struct iommu_fault_event;

struct iommu_page_response;

struct iommu_domain_ops;

struct iommu_ops {
	bool (*capable)(struct device *, enum iommu_cap);
	void * (*hw_info)(struct device *, u32 *, u32 *);
	struct iommu_domain * (*domain_alloc)(unsigned int);
	struct iommu_device * (*probe_device)(struct device *);
	void (*release_device)(struct device *);
	void (*probe_finalize)(struct device *);
	void (*set_platform_dma_ops)(struct device *);
	struct iommu_group * (*device_group)(struct device *);
	void (*get_resv_regions)(struct device *, struct list_head *);
	int (*of_xlate)(struct device *, struct of_phandle_args *);
	bool (*is_attach_deferred)(struct device *);
	int (*dev_enable_feat)(struct device *, enum iommu_dev_features);
	int (*dev_disable_feat)(struct device *, enum iommu_dev_features);
	int (*page_response)(struct device *, struct iommu_fault_event *, struct iommu_page_response *);
	int (*def_domain_type)(struct device *);
	void (*remove_dev_pasid)(struct device *, ioasid_t);
	const struct iommu_domain_ops *default_domain_ops;
	long unsigned int pgsize_bitmap;
	struct module *owner;
};

struct class {
	const char *name;
	const struct attribute_group **class_groups;
	const struct attribute_group **dev_groups;
	int (*dev_uevent)(const struct device *, struct kobj_uevent_env *);
	char * (*devnode)(const struct device *, umode_t *);
	void (*class_release)(const struct class *);
	void (*dev_release)(struct device *);
	int (*shutdown_pre)(struct device *);
	const struct kobj_ns_type_operations *ns_type;
	const void * (*namespace)(const struct device *);
	void (*get_ownership)(const struct device *, kuid_t *, kgid_t *);
	const struct dev_pm_ops *pm;
};

struct device_type {
	const char *name;
	const struct attribute_group **groups;
	int (*uevent)(const struct device *, struct kobj_uevent_env *);
	char * (*devnode)(const struct device *, umode_t *, kuid_t *, kgid_t *);
	void (*release)(struct device *);
	const struct dev_pm_ops *pm;
};

typedef __u64 Elf64_Addr;

typedef __u16 Elf64_Half;

typedef __u32 Elf64_Word;

typedef __u64 Elf64_Xword;

struct elf64_sym {
	Elf64_Word st_name;
	unsigned char st_info;
	unsigned char st_other;
	Elf64_Half st_shndx;
	Elf64_Addr st_value;
	Elf64_Xword st_size;
};

struct kernel_param_ops {
	unsigned int flags;
	int (*set)(const char *, const struct kernel_param *);
	int (*get)(char *, const struct kernel_param *);
	void (*free)(void *);
};

struct kparam_string;

struct kparam_array;

struct kernel_param {
	const char *name;
	struct module *mod;
	const struct kernel_param_ops *ops;
	const u16 perm;
	s8 level;
	u8 flags;
	union {
		void *arg;
		const struct kparam_string *str;
		const struct kparam_array *arr;
	};
};

struct kparam_string {
	unsigned int maxlen;
	char *string;
};

struct kparam_array {
	unsigned int max;
	unsigned int elemsize;
	unsigned int *num;
	const struct kernel_param_ops *ops;
	void *elem;
};

struct module_attribute {
	struct attribute attr;
	ssize_t (*show)(struct module_attribute *, struct module_kobject *, char *);
	ssize_t (*store)(struct module_attribute *, struct module_kobject *, const char *, size_t);
	void (*setup)(struct module *, const char *);
	int (*test)(struct module *);
	void (*free)(struct module *);
};

struct kernel_symbol {
	long unsigned int value;
	const char *name;
	const char *namespace;
};

struct trace_event_functions;

struct trace_event {
	struct hlist_node node;
	int type;
	struct trace_event_functions *funcs;
};

struct trace_event_class;

struct trace_event_call {
	struct list_head list;
	struct trace_event_class *class;
	union {
		char *name;
		struct tracepoint *tp;
	};
	struct trace_event event;
	char *print_fmt;
	struct event_filter *filter;
	union {
		void *module;
		atomic_t refcnt;
	};
	void *data;
	int flags;
	int perf_refcount;
	struct hlist_head *perf_events;
	struct bpf_prog_array *prog_array;
	int (*perf_perm)(struct trace_event_call *, struct perf_event *);
};

struct trace_eval_map {
	const char *system;
	const char *eval_string;
	long unsigned int eval_value;
};

struct of_device_id {
	char name[32];
	char type[32];
	char compatible[128];
	const void *data;
};

typedef long unsigned int kernel_ulong_t;

struct acpi_device_id {
	__u8 id[16];
	kernel_ulong_t driver_data;
	__u32 cls;
	__u32 cls_msk;
};

struct pci_controller;

struct eeh_pe;

struct pci_dev;

struct eeh_dev {
	int mode;
	int bdfn;
	struct pci_controller *controller;
	int pe_config_addr;
	u32 config_space[16];
	int pcix_cap;
	int pcie_cap;
	int aer_cap;
	int af_cap;
	struct eeh_pe *pe;
	struct list_head entry;
	struct list_head rmv_entry;
	struct pci_dn *pdn;
	struct pci_dev *pdev;
	bool in_error;
	struct pci_dev *physfn;
	int vf_index;
};

struct device_dma_parameters {
	unsigned int max_segment_size;
	unsigned int min_align_mask;
	long unsigned int segment_boundary_mask;
};

enum device_physical_location_panel {
	DEVICE_PANEL_TOP = 0,
	DEVICE_PANEL_BOTTOM = 1,
	DEVICE_PANEL_LEFT = 2,
	DEVICE_PANEL_RIGHT = 3,
	DEVICE_PANEL_FRONT = 4,
	DEVICE_PANEL_BACK = 5,
	DEVICE_PANEL_UNKNOWN = 6,
};

enum device_physical_location_vertical_position {
	DEVICE_VERT_POS_UPPER = 0,
	DEVICE_VERT_POS_CENTER = 1,
	DEVICE_VERT_POS_LOWER = 2,
};

enum device_physical_location_horizontal_position {
	DEVICE_HORI_POS_LEFT = 0,
	DEVICE_HORI_POS_CENTER = 1,
	DEVICE_HORI_POS_RIGHT = 2,
};

struct device_physical_location {
	enum device_physical_location_panel panel;
	enum device_physical_location_vertical_position vertical_position;
	enum device_physical_location_horizontal_position horizontal_position;
	bool dock;
	bool lid;
};

enum dma_data_direction {
	DMA_BIDIRECTIONAL = 0,
	DMA_TO_DEVICE = 1,
	DMA_FROM_DEVICE = 2,
	DMA_NONE = 3,
};

typedef u64 phys_addr_t;

struct sg_table;

struct scatterlist;

struct dma_map_ops {
	unsigned int flags;
	void * (*alloc)(struct device *, size_t, dma_addr_t *, gfp_t, long unsigned int);
	void (*free)(struct device *, size_t, void *, dma_addr_t, long unsigned int);
	struct page * (*alloc_pages)(struct device *, size_t, dma_addr_t *, enum dma_data_direction, gfp_t);
	void (*free_pages)(struct device *, size_t, struct page *, dma_addr_t, enum dma_data_direction);
	struct sg_table * (*alloc_noncontiguous)(struct device *, size_t, enum dma_data_direction, gfp_t, long unsigned int);
	void (*free_noncontiguous)(struct device *, size_t, struct sg_table *, enum dma_data_direction);
	int (*mmap)(struct device *, struct vm_area_struct *, void *, dma_addr_t, size_t, long unsigned int);
	int (*get_sgtable)(struct device *, struct sg_table *, void *, dma_addr_t, size_t, long unsigned int);
	dma_addr_t (*map_page)(struct device *, struct page *, long unsigned int, size_t, enum dma_data_direction, long unsigned int);
	void (*unmap_page)(struct device *, dma_addr_t, size_t, enum dma_data_direction, long unsigned int);
	int (*map_sg)(struct device *, struct scatterlist *, int, enum dma_data_direction, long unsigned int);
	void (*unmap_sg)(struct device *, struct scatterlist *, int, enum dma_data_direction, long unsigned int);
	dma_addr_t (*map_resource)(struct device *, phys_addr_t, size_t, enum dma_data_direction, long unsigned int);
	void (*unmap_resource)(struct device *, dma_addr_t, size_t, enum dma_data_direction, long unsigned int);
	void (*sync_single_for_cpu)(struct device *, dma_addr_t, size_t, enum dma_data_direction);
	void (*sync_single_for_device)(struct device *, dma_addr_t, size_t, enum dma_data_direction);
	void (*sync_sg_for_cpu)(struct device *, struct scatterlist *, int, enum dma_data_direction);
	void (*sync_sg_for_device)(struct device *, struct scatterlist *, int, enum dma_data_direction);
	void (*cache_sync)(struct device *, void *, size_t, enum dma_data_direction);
	int (*dma_supported)(struct device *, u64);
	u64 (*get_required_mask)(struct device *);
	size_t (*max_mapping_size)(struct device *);
	size_t (*opt_mapping_size)();
	long unsigned int (*get_merge_boundary)(struct device *);
};

struct bus_dma_region {
	phys_addr_t cpu_start;
	dma_addr_t dma_start;
	u64 size;
	u64 offset;
};

struct fwnode_operations;

struct fwnode_handle {
	struct fwnode_handle *secondary;
	const struct fwnode_operations *ops;
	struct device *dev;
	struct list_head suppliers;
	struct list_head consumers;
	u8 flags;
};

struct pci_bus;

struct eeh_pe {
	int type;
	int state;
	int addr;
	struct pci_controller *phb;
	struct pci_bus *bus;
	int check_count;
	int freeze_count;
	time64_t tstamp;
	int false_positives;
	atomic_t pass_dev_cnt;
	struct eeh_pe *parent;
	void *data;
	struct list_head child_list;
	struct list_head child;
	struct list_head edevs;
	long unsigned int stack_trace[64];
	int trace_entries;
};

enum dev_dma_attr {
	DEV_DMA_NOT_SUPPORTED = 0,
	DEV_DMA_NON_COHERENT = 1,
	DEV_DMA_COHERENT = 2,
};

struct fwnode_reference_args;

struct fwnode_endpoint;

struct fwnode_operations {
	struct fwnode_handle * (*get)(struct fwnode_handle *);
	void (*put)(struct fwnode_handle *);
	bool (*device_is_available)(const struct fwnode_handle *);
	const void * (*device_get_match_data)(const struct fwnode_handle *, const struct device *);
	bool (*device_dma_supported)(const struct fwnode_handle *);
	enum dev_dma_attr (*device_get_dma_attr)(const struct fwnode_handle *);
	bool (*property_present)(const struct fwnode_handle *, const char *);
	int (*property_read_int_array)(const struct fwnode_handle *, const char *, unsigned int, void *, size_t);
	int (*property_read_string_array)(const struct fwnode_handle *, const char *, const char **, size_t);
	const char * (*get_name)(const struct fwnode_handle *);
	const char * (*get_name_prefix)(const struct fwnode_handle *);
	struct fwnode_handle * (*get_parent)(const struct fwnode_handle *);
	struct fwnode_handle * (*get_next_child_node)(const struct fwnode_handle *, struct fwnode_handle *);
	struct fwnode_handle * (*get_named_child_node)(const struct fwnode_handle *, const char *);
	int (*get_reference_args)(const struct fwnode_handle *, const char *, const char *, unsigned int, unsigned int, struct fwnode_reference_args *);
	struct fwnode_handle * (*graph_get_next_endpoint)(const struct fwnode_handle *, struct fwnode_handle *);
	struct fwnode_handle * (*graph_get_remote_endpoint)(const struct fwnode_handle *);
	struct fwnode_handle * (*graph_get_port_parent)(struct fwnode_handle *);
	int (*graph_parse_endpoint)(const struct fwnode_handle *, struct fwnode_endpoint *);
	void * (*iomap)(struct fwnode_handle *, int);
	int (*irq_get)(const struct fwnode_handle *, unsigned int);
	int (*add_links)(struct fwnode_handle *);
};

struct fwnode_endpoint {
	unsigned int port;
	unsigned int id;
	const struct fwnode_handle *local_fwnode;
};

struct fwnode_reference_args {
	struct fwnode_handle *fwnode;
	unsigned int nargs;
	u64 args[8];
};

struct blk_holder_ops {
	void (*mark_dead)(struct block_device *, bool);
	void (*sync)(struct block_device *);
};

struct partition_meta_info {
	char uuid[37];
	u8 volname[64];
};

struct kvec {
	void *iov_base;
	size_t iov_len;
};

struct blk_zone {
	__u64 start;
	__u64 len;
	__u64 wp;
	__u8 type;
	__u8 cond;
	__u8 non_seq;
	__u8 reset;
	__u8 resv[4];
	__u64 capacity;
	__u8 reserved[24];
};

typedef int (*report_zones_cb)(struct blk_zone *, unsigned int, void *);

enum blk_unique_id {
	BLK_UID_T10 = 1,
	BLK_UID_EUI64 = 2,
	BLK_UID_NAA = 3,
};

struct hd_geometry;

struct pr_ops;

struct block_device_operations {
	void (*submit_bio)(struct bio *);
	int (*poll_bio)(struct bio *, struct io_comp_batch *, unsigned int);
	int (*open)(struct gendisk *, blk_mode_t);
	void (*release)(struct gendisk *);
	int (*ioctl)(struct block_device *, blk_mode_t, unsigned int, long unsigned int);
	int (*compat_ioctl)(struct block_device *, blk_mode_t, unsigned int, long unsigned int);
	unsigned int (*check_events)(struct gendisk *, unsigned int);
	void (*unlock_native_capacity)(struct gendisk *);
	int (*getgeo)(struct block_device *, struct hd_geometry *);
	int (*set_read_only)(struct block_device *, bool);
	void (*free_disk)(struct gendisk *);
	void (*swap_slot_free_notify)(struct block_device *, long unsigned int);
	int (*report_zones)(struct gendisk *, sector_t, unsigned int, report_zones_cb, void *);
	char * (*devnode)(struct gendisk *, umode_t *);
	int (*get_unique_id)(struct gendisk *, u8 *, enum blk_unique_id);
	struct module *owner;
	const struct pr_ops *pr_ops;
	int (*alternative_gpt_sector)(struct gendisk *, sector_t *);
};

struct blk_independent_access_range {
	struct kobject kobj;
	sector_t sector;
	sector_t nr_sectors;
};

struct blk_independent_access_ranges {
	struct kobject kobj;
	bool sysfs_registered;
	unsigned int nr_ia_ranges;
	struct blk_independent_access_range ia_range[0];
};

enum blk_eh_timer_return {
	BLK_EH_DONE = 0,
	BLK_EH_RESET_TIMER = 1,
};

struct blk_mq_hw_ctx;

struct blk_mq_queue_data;

struct blk_mq_ops {
	blk_status_t (*queue_rq)(struct blk_mq_hw_ctx *, const struct blk_mq_queue_data *);
	void (*commit_rqs)(struct blk_mq_hw_ctx *);
	void (*queue_rqs)(struct request **);
	int (*get_budget)(struct request_queue *);
	void (*put_budget)(struct request_queue *, int);
	void (*set_rq_budget_token)(struct request *, int);
	int (*get_rq_budget_token)(struct request *);
	enum blk_eh_timer_return (*timeout)(struct request *);
	int (*poll)(struct blk_mq_hw_ctx *, struct io_comp_batch *);
	void (*complete)(struct request *);
	int (*init_hctx)(struct blk_mq_hw_ctx *, void *, unsigned int);
	void (*exit_hctx)(struct blk_mq_hw_ctx *, unsigned int);
	int (*init_request)(struct blk_mq_tag_set *, struct request *, unsigned int, unsigned int);
	void (*exit_request)(struct blk_mq_tag_set *, struct request *, unsigned int);
	void (*cleanup_rq)(struct request *);
	bool (*busy)(struct request_queue *);
	void (*map_queues)(struct blk_mq_tag_set *);
	void (*show_rq)(struct seq_file *, struct request *);
};

enum pr_type {
	PR_WRITE_EXCLUSIVE = 1,
	PR_EXCLUSIVE_ACCESS = 2,
	PR_WRITE_EXCLUSIVE_REG_ONLY = 3,
	PR_EXCLUSIVE_ACCESS_REG_ONLY = 4,
	PR_WRITE_EXCLUSIVE_ALL_REGS = 5,
	PR_EXCLUSIVE_ACCESS_ALL_REGS = 6,
};

struct pr_keys;

struct pr_held_reservation;

struct pr_ops {
	int (*pr_register)(struct block_device *, u64, u64, u32);
	int (*pr_reserve)(struct block_device *, u64, enum pr_type, u32);
	int (*pr_release)(struct block_device *, u64, enum pr_type);
	int (*pr_preempt)(struct block_device *, u64, u64, enum pr_type, bool);
	int (*pr_clear)(struct block_device *, u64);
	int (*pr_read_keys)(struct block_device *, struct pr_keys *);
	int (*pr_read_reservation)(struct block_device *, struct pr_held_reservation *);
};

struct seq_operations {
	void * (*start)(struct seq_file *, loff_t *);
	void (*stop)(struct seq_file *, void *);
	void * (*next)(struct seq_file *, void *, loff_t *);
	int (*show)(struct seq_file *, void *);
};

struct seq_buf {
	char *buffer;
	size_t size;
	size_t len;
	loff_t readpos;
};

struct trace_seq {
	char buffer[65536];
	struct seq_buf seq;
	int full;
};

enum perf_sw_ids {
	PERF_COUNT_SW_CPU_CLOCK = 0,
	PERF_COUNT_SW_TASK_CLOCK = 1,
	PERF_COUNT_SW_PAGE_FAULTS = 2,
	PERF_COUNT_SW_CONTEXT_SWITCHES = 3,
	PERF_COUNT_SW_CPU_MIGRATIONS = 4,
	PERF_COUNT_SW_PAGE_FAULTS_MIN = 5,
	PERF_COUNT_SW_PAGE_FAULTS_MAJ = 6,
	PERF_COUNT_SW_ALIGNMENT_FAULTS = 7,
	PERF_COUNT_SW_EMULATION_FAULTS = 8,
	PERF_COUNT_SW_DUMMY = 9,
	PERF_COUNT_SW_BPF_OUTPUT = 10,
	PERF_COUNT_SW_CGROUP_SWITCHES = 11,
	PERF_COUNT_SW_MAX = 12,
};

union perf_mem_data_src {
	__u64 val;
	struct {
		__u64 mem_op: 5;
		__u64 mem_lvl: 14;
		__u64 mem_snoop: 5;
		__u64 mem_lock: 2;
		__u64 mem_dtlb: 7;
		__u64 mem_lvl_num: 4;
		__u64 mem_remote: 1;
		__u64 mem_snoopx: 2;
		__u64 mem_blk: 3;
		__u64 mem_hops: 3;
		__u64 mem_rsvd: 18;
	};
};

struct perf_branch_entry {
	__u64 from;
	__u64 to;
	__u64 mispred: 1;
	__u64 predicted: 1;
	__u64 in_tx: 1;
	__u64 abort: 1;
	__u64 cycles: 16;
	__u64 type: 4;
	__u64 spec: 2;
	__u64 new_type: 4;
	__u64 priv: 3;
	__u64 reserved: 31;
};

union perf_sample_weight {
	__u64 full;
	struct {
		__u32 var1_dw;
		__u16 var2_w;
		__u16 var3_w;
	};
};

struct cgroup_namespace {
	struct ns_common ns;
	struct user_namespace *user_ns;
	struct ucounts *ucounts;
	struct css_set *root_cset;
};

struct nsset;

struct proc_ns_operations {
	const char *name;
	const char *real_ns_name;
	int type;
	struct ns_common * (*get)(struct task_struct *);
	void (*put)(struct ns_common *);
	int (*install)(struct nsset *, struct ns_common *);
	struct user_namespace * (*owner)(struct ns_common *);
	struct ns_common * (*get_parent)(struct ns_common *);
};

struct ftrace_regs {
	struct pt_regs regs;
};

struct perf_regs {
	__u64 abi;
	struct pt_regs *regs;
};

struct u64_stats_sync {};

struct psi_group_cpu {
	seqcount_t seq;
	unsigned int tasks[4];
	u32 state_mask;
	u32 times[7];
	u64 state_start;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	u32 times_prev[14];
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct psi_group {
	struct psi_group *parent;
	bool enabled;
	struct mutex avgs_lock;
	struct psi_group_cpu *pcpu;
	u64 avg_total[6];
	u64 avg_last_update;
	u64 avg_next_update;
	struct delayed_work avgs_work;
	struct list_head avg_triggers;
	u32 avg_nr_triggers[6];
	u64 total[12];
	long unsigned int avg[18];
	struct task_struct *rtpoll_task;
	struct timer_list rtpoll_timer;
	wait_queue_head_t rtpoll_wait;
	atomic_t rtpoll_wakeup;
	atomic_t rtpoll_scheduled;
	struct mutex rtpoll_trigger_lock;
	struct list_head rtpoll_triggers;
	u32 rtpoll_nr_triggers[6];
	u32 rtpoll_states;
	u64 rtpoll_min_period;
	u64 rtpoll_total[6];
	u64 rtpoll_next_update;
	u64 rtpoll_until;
};

struct cgroup_taskset;

struct cftype;

struct cgroup_subsys {
	struct cgroup_subsys_state * (*css_alloc)(struct cgroup_subsys_state *);
	int (*css_online)(struct cgroup_subsys_state *);
	void (*css_offline)(struct cgroup_subsys_state *);
	void (*css_released)(struct cgroup_subsys_state *);
	void (*css_free)(struct cgroup_subsys_state *);
	void (*css_reset)(struct cgroup_subsys_state *);
	void (*css_rstat_flush)(struct cgroup_subsys_state *, int);
	int (*css_extra_stat_show)(struct seq_file *, struct cgroup_subsys_state *);
	int (*css_local_stat_show)(struct seq_file *, struct cgroup_subsys_state *);
	int (*can_attach)(struct cgroup_taskset *);
	void (*cancel_attach)(struct cgroup_taskset *);
	void (*attach)(struct cgroup_taskset *);
	void (*post_attach)();
	int (*can_fork)(struct task_struct *, struct css_set *);
	void (*cancel_fork)(struct task_struct *, struct css_set *);
	void (*fork)(struct task_struct *);
	void (*exit)(struct task_struct *);
	void (*release)(struct task_struct *);
	void (*bind)(struct cgroup_subsys_state *);
	bool early_init: 1;
	bool implicit_on_dfl: 1;
	bool threaded: 1;
	int id;
	const char *name;
	const char *legacy_name;
	struct cgroup_root *root;
	struct idr css_idr;
	struct list_head cfts;
	struct cftype *dfl_cftypes;
	struct cftype *legacy_cftypes;
	unsigned int depends_on;
};

struct cgroup_rstat_cpu {
	struct u64_stats_sync bsync;
	struct cgroup_base_stat bstat;
	struct cgroup_base_stat last_bstat;
	struct cgroup_base_stat subtree_bstat;
	struct cgroup_base_stat last_subtree_bstat;
	struct cgroup *updated_children;
	struct cgroup *updated_next;
};

struct cgroup_root {
	struct kernfs_root *kf_root;
	unsigned int subsys_mask;
	int hierarchy_id;
	struct cgroup cgrp;
	struct cgroup *cgrp_ancestor_storage;
	atomic_t nr_cgrps;
	struct list_head root_list;
	unsigned int flags;
	char release_agent_path[4096];
	char name[64];
};

struct cftype {
	char name[64];
	long unsigned int private;
	size_t max_write_len;
	unsigned int flags;
	unsigned int file_offset;
	struct cgroup_subsys *ss;
	struct list_head node;
	struct kernfs_ops *kf_ops;
	int (*open)(struct kernfs_open_file *);
	void (*release)(struct kernfs_open_file *);
	u64 (*read_u64)(struct cgroup_subsys_state *, struct cftype *);
	s64 (*read_s64)(struct cgroup_subsys_state *, struct cftype *);
	int (*seq_show)(struct seq_file *, void *);
	void * (*seq_start)(struct seq_file *, loff_t *);
	void * (*seq_next)(struct seq_file *, void *, loff_t *);
	void (*seq_stop)(struct seq_file *, void *);
	int (*write_u64)(struct cgroup_subsys_state *, struct cftype *, u64);
	int (*write_s64)(struct cgroup_subsys_state *, struct cftype *, s64);
	ssize_t (*write)(struct kernfs_open_file *, char *, size_t, loff_t);
	__poll_t (*poll)(struct kernfs_open_file *, struct poll_table_struct *);
};

struct perf_callchain_entry {
	__u64 nr;
	__u64 ip[0];
};

typedef long unsigned int (*perf_copy_f)(void *, const void *, long unsigned int, long unsigned int);

struct perf_raw_frag {
	union {
		struct perf_raw_frag *next;
		long unsigned int pad;
	};
	perf_copy_f copy;
	void *data;
	u32 size;
} __attribute__((packed));

struct perf_raw_record {
	struct perf_raw_frag frag;
	u32 size;
};

struct perf_branch_stack {
	__u64 nr;
	__u64 hw_idx;
	struct perf_branch_entry entries[0];
};

struct perf_event_pmu_context {
	struct pmu *pmu;
	struct perf_event_context *ctx;
	struct list_head pmu_ctx_entry;
	struct list_head pinned_active;
	struct list_head flexible_active;
	unsigned int embedded: 1;
	unsigned int nr_events;
	atomic_t refcount;
	struct callback_head callback_head;
	void *task_ctx_data;
	int rotate_necessary;
};

struct perf_cpu_pmu_context {
	struct perf_event_pmu_context epc;
	struct perf_event_pmu_context *task_epc;
	struct list_head sched_cb_entry;
	int sched_cb_usage;
	int active_oncpu;
	int exclusive;
	raw_spinlock_t hrtimer_lock;
	struct hrtimer hrtimer;
	ktime_t hrtimer_interval;
	unsigned int hrtimer_active;
};

struct perf_output_handle {
	struct perf_event *event;
	struct perf_buffer *rb;
	long unsigned int wakeup;
	long unsigned int size;
	u64 aux_flags;
	union {
		void *addr;
		long unsigned int head;
	};
	int page;
};

struct perf_addr_filter_range {
	long unsigned int start;
	long unsigned int size;
};

struct perf_sample_data {
	u64 sample_flags;
	u64 period;
	u64 dyn_size;
	u64 type;
	struct {
		u32 pid;
		u32 tid;
	} tid_entry;
	u64 time;
	u64 id;
	struct {
		u32 cpu;
		u32 reserved;
	} cpu_entry;
	u64 ip;
	struct perf_callchain_entry *callchain;
	struct perf_raw_record *raw;
	struct perf_branch_stack *br_stack;
	union perf_sample_weight weight;
	union perf_mem_data_src data_src;
	u64 txn;
	struct perf_regs regs_user;
	struct perf_regs regs_intr;
	u64 stack_user_size;
	u64 stream_id;
	u64 cgroup;
	u64 addr;
	u64 phys_addr;
	u64 data_page_size;
	u64 code_page_size;
	u64 aux_size;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct perf_cgroup_info;

struct perf_cgroup {
	struct cgroup_subsys_state css;
	struct perf_cgroup_info *info;
};

struct perf_cgroup_info {
	u64 time;
	u64 timestamp;
	u64 timeoffset;
	int active;
};

struct trace_entry {
	short unsigned int type;
	unsigned char flags;
	unsigned char preempt_count;
	int pid;
};

struct trace_array;

struct tracer;

struct array_buffer;

struct ring_buffer_iter;

struct trace_iterator {
	struct trace_array *tr;
	struct tracer *trace;
	struct array_buffer *array_buffer;
	void *private;
	int cpu_file;
	struct mutex mutex;
	struct ring_buffer_iter **buffer_iter;
	long unsigned int iter_flags;
	void *temp;
	unsigned int temp_size;
	char *fmt;
	unsigned int fmt_size;
	long int wait_index;
	struct trace_seq tmp_seq;
	cpumask_var_t started;
	bool snapshot;
	struct trace_seq seq;
	struct trace_entry *ent;
	long unsigned int lost_events;
	int leftover;
	int ent_size;
	int cpu;
	u64 ts;
	loff_t pos;
	long int idx;
};

enum print_line_t {
	TRACE_TYPE_PARTIAL_LINE = 0,
	TRACE_TYPE_HANDLED = 1,
	TRACE_TYPE_UNHANDLED = 2,
	TRACE_TYPE_NO_CONSUME = 3,
};

typedef enum print_line_t (*trace_print_func)(struct trace_iterator *, int, struct trace_event *);

struct trace_event_functions {
	trace_print_func trace;
	trace_print_func raw;
	trace_print_func hex;
	trace_print_func binary;
};

enum trace_reg {
	TRACE_REG_REGISTER = 0,
	TRACE_REG_UNREGISTER = 1,
	TRACE_REG_PERF_REGISTER = 2,
	TRACE_REG_PERF_UNREGISTER = 3,
	TRACE_REG_PERF_OPEN = 4,
	TRACE_REG_PERF_CLOSE = 5,
	TRACE_REG_PERF_ADD = 6,
	TRACE_REG_PERF_DEL = 7,
};

struct trace_event_fields {
	const char *type;
	union {
		struct {
			const char *name;
			const int size;
			const int align;
			const int is_signed;
			const int filter_type;
			const int len;
		};
		int (*define_fields)(struct trace_event_call *);
	};
};

struct trace_event_class {
	const char *system;
	void *probe;
	void *perf_probe;
	int (*reg)(struct trace_event_call *, enum trace_reg, void *);
	struct trace_event_fields *fields_array;
	struct list_head * (*get_fields)(struct trace_event_call *);
	struct list_head fields;
	int (*raw_init)(struct trace_event_call *);
};

enum {
	TRACE_EVENT_FL_FILTERED_BIT = 0,
	TRACE_EVENT_FL_CAP_ANY_BIT = 1,
	TRACE_EVENT_FL_NO_SET_FILTER_BIT = 2,
	TRACE_EVENT_FL_IGNORE_ENABLE_BIT = 3,
	TRACE_EVENT_FL_TRACEPOINT_BIT = 4,
	TRACE_EVENT_FL_DYNAMIC_BIT = 5,
	TRACE_EVENT_FL_KPROBE_BIT = 6,
	TRACE_EVENT_FL_UPROBE_BIT = 7,
	TRACE_EVENT_FL_EPROBE_BIT = 8,
	TRACE_EVENT_FL_FPROBE_BIT = 9,
	TRACE_EVENT_FL_CUSTOM_BIT = 10,
};

enum {
	EVENT_FILE_FL_ENABLED_BIT = 0,
	EVENT_FILE_FL_RECORDED_CMD_BIT = 1,
	EVENT_FILE_FL_RECORDED_TGID_BIT = 2,
	EVENT_FILE_FL_FILTERED_BIT = 3,
	EVENT_FILE_FL_NO_SET_FILTER_BIT = 4,
	EVENT_FILE_FL_SOFT_MODE_BIT = 5,
	EVENT_FILE_FL_SOFT_DISABLED_BIT = 6,
	EVENT_FILE_FL_TRIGGER_MODE_BIT = 7,
	EVENT_FILE_FL_TRIGGER_COND_BIT = 8,
	EVENT_FILE_FL_PID_FILTER_BIT = 9,
	EVENT_FILE_FL_WAS_ENABLED_BIT = 10,
};

struct squashfs_super_block {
	__le32 s_magic;
	__le32 inodes;
	__le32 mkfs_time;
	__le32 block_size;
	__le32 fragments;
	__le16 compression;
	__le16 block_log;
	__le16 flags;
	__le16 no_ids;
	__le16 s_major;
	__le16 s_minor;
	__le64 root_inode;
	__le64 bytes_used;
	__le64 id_table_start;
	__le64 xattr_id_table_start;
	__le64 inode_table_start;
	__le64 directory_table_start;
	__le64 fragment_table_start;
	__le64 lookup_table_start;
};

typedef int (*decompress_fn)(unsigned char *, long int, long int (*)(void *, long unsigned int), long int (*)(void *, long unsigned int), unsigned char *, long int *, void (*)(char *));

typedef int (*initcall_t)();

struct subprocess_info {
	struct work_struct work;
	struct completion *complete;
	const char *path;
	char **argv;
	char **envp;
	int wait;
	int retval;
	int (*init)(struct subprocess_info *, struct cred *);
	void (*cleanup)(struct subprocess_info *);
	void *data;
};

enum {
	Root_NFS = 255,
	Root_CIFS = 254,
	Root_Generic = 253,
	Root_RAM0 = 1048576,
};

struct cpu_spec;

typedef void (*cpu_setup_t)(long unsigned int, struct cpu_spec *);

enum powerpc_pmc_type {
	PPC_PMC_DEFAULT = 0,
	PPC_PMC_IBM = 1,
	PPC_PMC_PA6T = 2,
	PPC_PMC_G4 = 3,
};

typedef void (*cpu_restore_t)();

struct cpu_spec {
	unsigned int pvr_mask;
	unsigned int pvr_value;
	char *cpu_name;
	long unsigned int cpu_features;
	unsigned int cpu_user_features;
	unsigned int cpu_user_features2;
	unsigned int mmu_features;
	unsigned int icache_bsize;
	unsigned int dcache_bsize;
	void (*cpu_down_flush)();
	unsigned int num_pmcs;
	enum powerpc_pmc_type pmc_type;
	cpu_setup_t cpu_setup;
	cpu_restore_t cpu_restore;
	char *platform;
	int (*machine_check)(struct pt_regs *);
	long int (*machine_check_early)(struct pt_regs *);
};

struct static_key_true {
	struct static_key key;
};

enum pcpu_fc {
	PCPU_FC_AUTO = 0,
	PCPU_FC_EMBED = 1,
	PCPU_FC_PAGE = 2,
	PCPU_FC_NR = 3,
};

enum hrtimer_base_type {
	HRTIMER_BASE_MONOTONIC = 0,
	HRTIMER_BASE_REALTIME = 1,
	HRTIMER_BASE_BOOTTIME = 2,
	HRTIMER_BASE_TAI = 3,
	HRTIMER_BASE_MONOTONIC_SOFT = 4,
	HRTIMER_BASE_REALTIME_SOFT = 5,
	HRTIMER_BASE_BOOTTIME_SOFT = 6,
	HRTIMER_BASE_TAI_SOFT = 7,
	HRTIMER_MAX_CLOCK_BASES = 8,
};

enum node_states {
	N_POSSIBLE = 0,
	N_ONLINE = 1,
	N_NORMAL_MEMORY = 2,
	N_HIGH_MEMORY = 2,
	N_MEMORY = 3,
	N_CPU = 4,
	N_GENERIC_INITIATOR = 5,
	NR_NODE_STATES = 6,
};

enum {
	MM_FILEPAGES = 0,
	MM_ANONPAGES = 1,
	MM_SWAPENTS = 2,
	MM_SHMEMPAGES = 3,
	NR_MM_COUNTERS = 4,
};

enum rseq_cs_flags_bit {
	RSEQ_CS_FLAG_NO_RESTART_ON_PREEMPT_BIT = 0,
	RSEQ_CS_FLAG_NO_RESTART_ON_SIGNAL_BIT = 1,
	RSEQ_CS_FLAG_NO_RESTART_ON_MIGRATE_BIT = 2,
};

enum {
	TASK_COMM_LEN = 16,
};

enum rseq_event_mask_bits {
	RSEQ_EVENT_PREEMPT_BIT = 0,
	RSEQ_EVENT_SIGNAL_BIT = 1,
	RSEQ_EVENT_MIGRATE_BIT = 2,
};

enum migratetype {
	MIGRATE_UNMOVABLE = 0,
	MIGRATE_MOVABLE = 1,
	MIGRATE_RECLAIMABLE = 2,
	MIGRATE_PCPTYPES = 3,
	MIGRATE_HIGHATOMIC = 3,
	MIGRATE_CMA = 4,
	MIGRATE_ISOLATE = 5,
	MIGRATE_TYPES = 6,
};

enum numa_stat_item {
	NUMA_HIT = 0,
	NUMA_MISS = 1,
	NUMA_FOREIGN = 2,
	NUMA_INTERLEAVE_HIT = 3,
	NUMA_LOCAL = 4,
	NUMA_OTHER = 5,
	NR_VM_NUMA_EVENT_ITEMS = 6,
};

enum zone_stat_item {
	NR_FREE_PAGES = 0,
	NR_ZONE_LRU_BASE = 1,
	NR_ZONE_INACTIVE_ANON = 1,
	NR_ZONE_ACTIVE_ANON = 2,
	NR_ZONE_INACTIVE_FILE = 3,
	NR_ZONE_ACTIVE_FILE = 4,
	NR_ZONE_UNEVICTABLE = 5,
	NR_ZONE_WRITE_PENDING = 6,
	NR_MLOCK = 7,
	NR_BOUNCE = 8,
	NR_ZSPAGES = 9,
	NR_FREE_CMA_PAGES = 10,
	NR_VM_ZONE_STAT_ITEMS = 11,
};

enum node_stat_item {
	NR_LRU_BASE = 0,
	NR_INACTIVE_ANON = 0,
	NR_ACTIVE_ANON = 1,
	NR_INACTIVE_FILE = 2,
	NR_ACTIVE_FILE = 3,
	NR_UNEVICTABLE = 4,
	NR_SLAB_RECLAIMABLE_B = 5,
	NR_SLAB_UNRECLAIMABLE_B = 6,
	NR_ISOLATED_ANON = 7,
	NR_ISOLATED_FILE = 8,
	WORKINGSET_NODES = 9,
	WORKINGSET_REFAULT_BASE = 10,
	WORKINGSET_REFAULT_ANON = 10,
	WORKINGSET_REFAULT_FILE = 11,
	WORKINGSET_ACTIVATE_BASE = 12,
	WORKINGSET_ACTIVATE_ANON = 12,
	WORKINGSET_ACTIVATE_FILE = 13,
	WORKINGSET_RESTORE_BASE = 14,
	WORKINGSET_RESTORE_ANON = 14,
	WORKINGSET_RESTORE_FILE = 15,
	WORKINGSET_NODERECLAIM = 16,
	NR_ANON_MAPPED = 17,
	NR_FILE_MAPPED = 18,
	NR_FILE_PAGES = 19,
	NR_FILE_DIRTY = 20,
	NR_WRITEBACK = 21,
	NR_WRITEBACK_TEMP = 22,
	NR_SHMEM = 23,
	NR_SHMEM_THPS = 24,
	NR_SHMEM_PMDMAPPED = 25,
	NR_FILE_THPS = 26,
	NR_FILE_PMDMAPPED = 27,
	NR_ANON_THPS = 28,
	NR_VMSCAN_WRITE = 29,
	NR_VMSCAN_IMMEDIATE = 30,
	NR_DIRTIED = 31,
	NR_WRITTEN = 32,
	NR_THROTTLED_WRITTEN = 33,
	NR_KERNEL_MISC_RECLAIMABLE = 34,
	NR_FOLL_PIN_ACQUIRED = 35,
	NR_FOLL_PIN_RELEASED = 36,
	NR_KERNEL_STACK_KB = 37,
	NR_PAGETABLE = 38,
	NR_SECONDARY_PAGETABLE = 39,
	NR_SWAPCACHE = 40,
	PGPROMOTE_SUCCESS = 41,
	PGPROMOTE_CANDIDATE = 42,
	NR_VM_NODE_STAT_ITEMS = 43,
};

enum lru_list {
	LRU_INACTIVE_ANON = 0,
	LRU_ACTIVE_ANON = 1,
	LRU_INACTIVE_FILE = 2,
	LRU_ACTIVE_FILE = 3,
	LRU_UNEVICTABLE = 4,
	NR_LRU_LISTS = 5,
};

enum vmscan_throttle_state {
	VMSCAN_THROTTLE_WRITEBACK = 0,
	VMSCAN_THROTTLE_ISOLATED = 1,
	VMSCAN_THROTTLE_NOPROGRESS = 2,
	VMSCAN_THROTTLE_CONGESTED = 3,
	NR_VMSCAN_THROTTLE = 4,
};

enum zone_watermarks {
	WMARK_MIN = 0,
	WMARK_LOW = 1,
	WMARK_HIGH = 2,
	WMARK_PROMO = 3,
	NR_WMARK = 4,
};

enum {
	ZONELIST_FALLBACK = 0,
	ZONELIST_NOFALLBACK = 1,
	MAX_ZONELISTS = 2,
};

enum {
	MMU_FTRS_POSSIBLE = 4261477953,
};

struct static_key_false {
	struct static_key key;
};

typedef struct {
	u32 val;
	u32 suffix;
} ppc_inst_t;

struct ppc_emulated_entry {
	const char *name;
	atomic_t val;
};

struct ppc_emulated {
	struct ppc_emulated_entry altivec;
	struct ppc_emulated_entry dcba;
	struct ppc_emulated_entry dcbz;
	struct ppc_emulated_entry fp_pair;
	struct ppc_emulated_entry isel;
	struct ppc_emulated_entry mcrxr;
	struct ppc_emulated_entry mfpvr;
	struct ppc_emulated_entry multiple;
	struct ppc_emulated_entry popcntb;
	struct ppc_emulated_entry spe;
	struct ppc_emulated_entry string;
	struct ppc_emulated_entry sync;
	struct ppc_emulated_entry unaligned;
	struct ppc_emulated_entry vsx;
	struct ppc_emulated_entry mfdscr;
	struct ppc_emulated_entry mtdscr;
	struct ppc_emulated_entry lq_stq;
	struct ppc_emulated_entry lxvw4x;
	struct ppc_emulated_entry lxvh8x;
	struct ppc_emulated_entry lxvd2x;
	struct ppc_emulated_entry lxvb16x;
};

enum instruction_type {
	COMPUTE = 0,
	LOAD = 1,
	LOAD_MULTI = 2,
	LOAD_FP = 3,
	LOAD_VMX = 4,
	LOAD_VSX = 5,
	STORE = 6,
	STORE_MULTI = 7,
	STORE_FP = 8,
	STORE_VMX = 9,
	STORE_VSX = 10,
	LARX = 11,
	STCX = 12,
	BRANCH = 13,
	MFSPR = 14,
	MTSPR = 15,
	CACHEOP = 16,
	BARRIER = 17,
	SYSCALL = 18,
	SYSCALL_VECTORED_0 = 19,
	MFMSR = 20,
	MTMSR = 21,
	RFI = 22,
	INTERRUPT = 23,
	UNKNOWN = 24,
};

struct instruction_op {
	int type;
	int reg;
	long unsigned int val;
	long unsigned int ea;
	int update_reg;
	int spr;
	u32 ccval;
	u32 xerval;
	u8 element_size;
	u8 vsx_flags;
};

typedef phys_addr_t resource_size_t;

enum idle_boot_override {
	IDLE_NO_OVERRIDE = 0,
	IDLE_POWERSAVE_OFF = 1,
};

enum cpu_idle_type {
	CPU_IDLE = 0,
	CPU_NOT_IDLE = 1,
	CPU_NEWLY_IDLE = 2,
	CPU_MAX_IDLE_TYPES = 3,
};

enum {
	__SD_BALANCE_NEWIDLE = 0,
	__SD_BALANCE_EXEC = 1,
	__SD_BALANCE_FORK = 2,
	__SD_BALANCE_WAKE = 3,
	__SD_WAKE_AFFINE = 4,
	__SD_ASYM_CPUCAPACITY = 5,
	__SD_ASYM_CPUCAPACITY_FULL = 6,
	__SD_SHARE_CPUCAPACITY = 7,
	__SD_SHARE_PKG_RESOURCES = 8,
	__SD_SERIALIZE = 9,
	__SD_ASYM_PACKING = 10,
	__SD_PREFER_SIBLING = 11,
	__SD_OVERLAP = 12,
	__SD_NUMA = 13,
	__SD_FLAG_CNT = 14,
};

enum mod_mem_type {
	MOD_TEXT = 0,
	MOD_DATA = 1,
	MOD_RODATA = 2,
	MOD_RO_AFTER_INIT = 3,
	MOD_INIT_TEXT = 4,
	MOD_INIT_DATA = 5,
	MOD_INIT_RODATA = 6,
	MOD_MEM_NUM_TYPES = 7,
	MOD_INVALID = -1,
};

typedef u32 phandle;

struct property;

struct device_node {
	const char *name;
	phandle phandle;
	const char *full_name;
	struct fwnode_handle fwnode;
	struct property *properties;
	struct property *deadprops;
	struct device_node *parent;
	struct device_node *child;
	struct device_node *sibling;
	struct kobject kobj;
	long unsigned int _flags;
	void *data;
};

struct property {
	char *name;
	int length;
	void *value;
	struct property *next;
	long unsigned int _flags;
	struct bin_attribute attr;
};

enum {
	DQF_ROOT_SQUASH_B = 0,
	DQF_SYS_FILE_B = 16,
	DQF_PRIVATE = 17,
};

enum {
	DQST_LOOKUPS = 0,
	DQST_DROPS = 1,
	DQST_READS = 2,
	DQST_WRITES = 3,
	DQST_CACHE_HITS = 4,
	DQST_ALLOC_DQUOTS = 5,
	DQST_FREE_DQUOTS = 6,
	DQST_SYNCS = 7,
	_DQST_DQSTAT_LAST = 8,
};

enum {
	SB_UNFROZEN = 0,
	SB_FREEZE_WRITE = 1,
	SB_FREEZE_PAGEFAULT = 2,
	SB_FREEZE_FS = 3,
	SB_FREEZE_COMPLETE = 4,
};

enum vm_event_item {
	PGPGIN = 0,
	PGPGOUT = 1,
	PSWPIN = 2,
	PSWPOUT = 3,
	PGALLOC_NORMAL = 4,
	PGALLOC_MOVABLE = 5,
	PGALLOC_DEVICE = 6,
	ALLOCSTALL_NORMAL = 7,
	ALLOCSTALL_MOVABLE = 8,
	ALLOCSTALL_DEVICE = 9,
	PGSCAN_SKIP_NORMAL = 10,
	PGSCAN_SKIP_MOVABLE = 11,
	PGSCAN_SKIP_DEVICE = 12,
	PGFREE = 13,
	PGACTIVATE = 14,
	PGDEACTIVATE = 15,
	PGLAZYFREE = 16,
	PGFAULT = 17,
	PGMAJFAULT = 18,
	PGLAZYFREED = 19,
	PGREFILL = 20,
	PGREUSE = 21,
	PGSTEAL_KSWAPD = 22,
	PGSTEAL_DIRECT = 23,
	PGSTEAL_KHUGEPAGED = 24,
	PGDEMOTE_KSWAPD = 25,
	PGDEMOTE_DIRECT = 26,
	PGDEMOTE_KHUGEPAGED = 27,
	PGSCAN_KSWAPD = 28,
	PGSCAN_DIRECT = 29,
	PGSCAN_KHUGEPAGED = 30,
	PGSCAN_DIRECT_THROTTLE = 31,
	PGSCAN_ANON = 32,
	PGSCAN_FILE = 33,
	PGSTEAL_ANON = 34,
	PGSTEAL_FILE = 35,
	PGSCAN_ZONE_RECLAIM_FAILED = 36,
	PGINODESTEAL = 37,
	SLABS_SCANNED = 38,
	KSWAPD_INODESTEAL = 39,
	KSWAPD_LOW_WMARK_HIT_QUICKLY = 40,
	KSWAPD_HIGH_WMARK_HIT_QUICKLY = 41,
	PAGEOUTRUN = 42,
	PGROTATED = 43,
	DROP_PAGECACHE = 44,
	DROP_SLAB = 45,
	OOM_KILL = 46,
	NUMA_PTE_UPDATES = 47,
	NUMA_HUGE_PTE_UPDATES = 48,
	NUMA_HINT_FAULTS = 49,
	NUMA_HINT_FAULTS_LOCAL = 50,
	NUMA_PAGE_MIGRATE = 51,
	PGMIGRATE_SUCCESS = 52,
	PGMIGRATE_FAIL = 53,
	THP_MIGRATION_SUCCESS = 54,
	THP_MIGRATION_FAIL = 55,
	THP_MIGRATION_SPLIT = 56,
	COMPACTMIGRATE_SCANNED = 57,
	COMPACTFREE_SCANNED = 58,
	COMPACTISOLATED = 59,
	COMPACTSTALL = 60,
	COMPACTFAIL = 61,
	COMPACTSUCCESS = 62,
	KCOMPACTD_WAKE = 63,
	KCOMPACTD_MIGRATE_SCANNED = 64,
	KCOMPACTD_FREE_SCANNED = 65,
	HTLB_BUDDY_PGALLOC = 66,
	HTLB_BUDDY_PGALLOC_FAIL = 67,
	CMA_ALLOC_SUCCESS = 68,
	CMA_ALLOC_FAIL = 69,
	UNEVICTABLE_PGCULLED = 70,
	UNEVICTABLE_PGSCANNED = 71,
	UNEVICTABLE_PGRESCUED = 72,
	UNEVICTABLE_PGMLOCKED = 73,
	UNEVICTABLE_PGMUNLOCKED = 74,
	UNEVICTABLE_PGCLEARED = 75,
	UNEVICTABLE_PGSTRANDED = 76,
	THP_FAULT_ALLOC = 77,
	THP_FAULT_FALLBACK = 78,
	THP_FAULT_FALLBACK_CHARGE = 79,
	THP_COLLAPSE_ALLOC = 80,
	THP_COLLAPSE_ALLOC_FAILED = 81,
	THP_FILE_ALLOC = 82,
	THP_FILE_FALLBACK = 83,
	THP_FILE_FALLBACK_CHARGE = 84,
	THP_FILE_MAPPED = 85,
	THP_SPLIT_PAGE = 86,
	THP_SPLIT_PAGE_FAILED = 87,
	THP_DEFERRED_SPLIT_PAGE = 88,
	THP_SPLIT_PMD = 89,
	THP_SCAN_EXCEED_NONE_PTE = 90,
	THP_SCAN_EXCEED_SWAP_PTE = 91,
	THP_SCAN_EXCEED_SHARED_PTE = 92,
	THP_SPLIT_PUD = 93,
	THP_ZERO_PAGE_ALLOC = 94,
	THP_ZERO_PAGE_ALLOC_FAILED = 95,
	THP_SWPOUT = 96,
	THP_SWPOUT_FALLBACK = 97,
	BALLOON_INFLATE = 98,
	BALLOON_DEFLATE = 99,
	BALLOON_MIGRATE = 100,
	SWAP_RA = 101,
	SWAP_RA_HIT = 102,
	KSM_SWPIN_COPY = 103,
	COW_KSM = 104,
	ZSWPIN = 105,
	ZSWPOUT = 106,
	NR_VM_EVENT_ITEMS = 107,
};

struct pci_host_bridge;

struct rtc_time;

struct kimage;

struct machdep_calls {
	const char *name;
	const char *compatible;
	void (*iommu_restore)();
	long unsigned int (*memory_block_size)();
	void (*dma_set_mask)(struct device *, u64);
	int (*probe)();
	void (*setup_arch)();
	void (*show_cpuinfo)(struct seq_file *);
	long unsigned int (*get_proc_freq)(unsigned int);
	void (*init_IRQ)();
	unsigned int (*get_irq)();
	void (*pcibios_fixup)();
	void (*pci_irq_fixup)(struct pci_dev *);
	int (*pcibios_root_bridge_prepare)(struct pci_host_bridge *);
	void (*discover_phbs)();
	int (*pci_setup_phb)(struct pci_controller *);
	void (*restart)(char *);
	void (*halt)();
	void (*panic)(char *);
	long int (*time_init)();
	int (*set_rtc_time)(struct rtc_time *);
	void (*get_rtc_time)(struct rtc_time *);
	time64_t (*get_boot_time)();
	void (*calibrate_decr)();
	void (*progress)(char *, short unsigned int);
	void (*log_error)(char *, unsigned int, int);
	unsigned char (*nvram_read_val)(int);
	void (*nvram_write_val)(int, unsigned char);
	ssize_t (*nvram_write)(char *, size_t, loff_t *);
	ssize_t (*nvram_read)(char *, size_t, loff_t *);
	ssize_t (*nvram_size)();
	void (*nvram_sync)();
	int (*system_reset_exception)(struct pt_regs *);
	int (*machine_check_exception)(struct pt_regs *);
	int (*handle_hmi_exception)(struct pt_regs *);
	int (*hmi_exception_early)(struct pt_regs *);
	long int (*machine_check_early)(struct pt_regs *);
	bool (*mce_check_early_recovery)(struct pt_regs *);
	void (*machine_check_log_err)();
	long int (*feature_call)(unsigned int, ...);
	int (*pci_get_legacy_ide_irq)(struct pci_dev *, int);
	pgprot_t (*phys_mem_access_prot)(struct file *, long unsigned int, long unsigned int, pgprot_t);
	void (*power_save)();
	void (*enable_pmcs)();
	int (*set_dabr)(long unsigned int, long unsigned int);
	int (*set_dawr)(int, long unsigned int, long unsigned int);
	int (*pci_exclude_device)(struct pci_controller *, unsigned char, unsigned char);
	void (*pcibios_fixup_resources)(struct pci_dev *);
	void (*pcibios_fixup_bus)(struct pci_bus *);
	void (*pcibios_fixup_phb)(struct pci_controller *);
	void (*pcibios_bus_add_device)(struct pci_dev *);
	resource_size_t (*pcibios_default_alignment)();
	void (*machine_shutdown)();
	void (*kexec_cpu_down)(int, int);
	void (*machine_kexec)(struct kimage *);
	void (*suspend_disable_irqs)();
	void (*suspend_enable_irqs)();
	ssize_t (*cpu_probe)(const char *, size_t);
	ssize_t (*cpu_release)(const char *, size_t);
	int (*get_random_seed)(long unsigned int *);
};

typedef long unsigned int uintptr_t;

typedef u64 uint64_t;

struct cacheline_padding {
	char x[0];
};

struct timezone {
	int tz_minuteswest;
	int tz_dsttime;
};

enum {
	FW_FEATURE_PSERIES_POSSIBLE = 35183556296703ULL,
	FW_FEATURE_PSERIES_ALWAYS = 0ULL,
	FW_FEATURE_POWERNV_POSSIBLE = 275146342400ULL,
	FW_FEATURE_POWERNV_ALWAYS = 0ULL,
	FW_FEATURE_PS3_POSSIBLE = 12582912ULL,
	FW_FEATURE_PS3_ALWAYS = 12582912ULL,
	FW_FEATURE_NATIVE_POSSIBLE = 0ULL,
	FW_FEATURE_NATIVE_ALWAYS = 0ULL,
	FW_FEATURE_POSSIBLE = 35183824732159ULL,
	FW_FEATURE_ALWAYS = 0ULL,
};

struct wait_queue_entry;

typedef int (*wait_queue_func_t)(struct wait_queue_entry *, unsigned int, int, void *);

struct wait_queue_entry {
	unsigned int flags;
	void *private;
	wait_queue_func_t func;
	struct list_head entry;
};

typedef struct wait_queue_entry wait_queue_entry_t;

struct timens_offset {
	s64 sec;
	u64 nsec;
};

enum clocksource_ids {
	CSID_GENERIC = 0,
	CSID_ARM_ARCH_COUNTER = 1,
	CSID_MAX = 2,
};

enum vdso_clock_mode {
	VDSO_CLOCKMODE_NONE = 0,
	VDSO_CLOCKMODE_ARCHTIMER = 1,
	VDSO_CLOCKMODE_MAX = 2,
	VDSO_CLOCKMODE_TIMENS = 2147483647,
};

struct clocksource {
	u64 (*read)(struct clocksource *);
	u64 mask;
	u32 mult;
	u32 shift;
	u64 max_idle_ns;
	u32 maxadj;
	u32 uncertainty_margin;
	u64 max_cycles;
	const char *name;
	struct list_head list;
	int rating;
	enum clocksource_ids id;
	enum vdso_clock_mode vdso_clock_mode;
	long unsigned int flags;
	int (*enable)(struct clocksource *);
	void (*disable)(struct clocksource *);
	void (*suspend)(struct clocksource *);
	void (*resume)(struct clocksource *);
	void (*mark_unstable)(struct clocksource *);
	void (*tick_stable)(struct clocksource *);
	struct module *owner;
};

struct reclaim_state {
	long unsigned int reclaimed;
};

struct mem_cgroup_id {
	int id;
	refcount_t ref;
};

struct page_counter {
	atomic_long_t usage;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct cacheline_padding _pad1_;
	long unsigned int emin;
	atomic_long_t min_usage;
	atomic_long_t children_min_usage;
	long unsigned int elow;
	atomic_long_t low_usage;
	atomic_long_t children_low_usage;
	long unsigned int watermark;
	long unsigned int failcnt;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct cacheline_padding _pad2_;
	long unsigned int min;
	long unsigned int low;
	long unsigned int high;
	long unsigned int max;
	struct page_counter *parent;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct vmpressure {
	long unsigned int scanned;
	long unsigned int reclaimed;
	long unsigned int tree_scanned;
	long unsigned int tree_reclaimed;
	spinlock_t sr_lock;
	struct list_head events;
	struct mutex events_lock;
	struct work_struct work;
};

struct mem_cgroup_threshold_ary;

struct mem_cgroup_thresholds {
	struct mem_cgroup_threshold_ary *primary;
	struct mem_cgroup_threshold_ary *spare;
};

struct fprop_global {
	struct percpu_counter events;
	unsigned int period;
	seqcount_t sequence;
};

struct wb_domain {
	spinlock_t lock;
	struct fprop_global completions;
	struct timer_list period_timer;
	long unsigned int period_time;
	long unsigned int dirty_limit_tstamp;
	long unsigned int dirty_limit;
};

struct wb_completion {
	atomic_t cnt;
	wait_queue_head_t *waitq;
};

struct memcg_cgwb_frn {
	u64 bdi_id;
	int memcg_id;
	u64 at;
	struct wb_completion done;
};

struct deferred_split {
	spinlock_t split_queue_lock;
	struct list_head split_queue;
	long unsigned int split_queue_len;
};

struct memcg_vmstats;

struct obj_cgroup;

struct memcg_vmstats_percpu;

struct mem_cgroup_per_node;

struct mem_cgroup {
	struct cgroup_subsys_state css;
	struct mem_cgroup_id id;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct page_counter memory;
	union {
		struct page_counter swap;
		struct page_counter memsw;
	};
	struct page_counter kmem;
	struct page_counter tcpmem;
	struct work_struct high_work;
	long unsigned int zswap_max;
	long unsigned int soft_limit;
	struct vmpressure vmpressure;
	bool oom_group;
	bool oom_lock;
	int under_oom;
	int swappiness;
	int oom_kill_disable;
	struct cgroup_file events_file;
	struct cgroup_file events_local_file;
	struct cgroup_file swap_events_file;
	struct mutex thresholds_lock;
	struct mem_cgroup_thresholds thresholds;
	struct mem_cgroup_thresholds memsw_thresholds;
	struct list_head oom_notify;
	long unsigned int move_charge_at_immigrate;
	spinlock_t move_lock;
	long unsigned int move_lock_flags;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct cacheline_padding _pad1_;
	struct memcg_vmstats *vmstats;
	atomic_long_t memory_events[9];
	atomic_long_t memory_events_local[9];
	long unsigned int socket_pressure;
	bool tcpmem_active;
	int tcpmem_pressure;
	int kmemcg_id;
	struct obj_cgroup *objcg;
	struct list_head objcg_list;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct cacheline_padding _pad2_;
	atomic_t moving_account;
	struct task_struct *move_lock_task;
	struct memcg_vmstats_percpu *vmstats_percpu;
	struct list_head cgwb_list;
	struct wb_domain cgwb_domain;
	struct memcg_cgwb_frn cgwb_frn[4];
	struct list_head event_list;
	spinlock_t event_list_lock;
	struct deferred_split deferred_split_queue;
	struct mem_cgroup_per_node *nodeinfo[0];
	long: 64;
};

struct free_area {
	struct list_head free_list[6];
	long unsigned int nr_free;
};

struct pglist_data;

struct lruvec {
	struct list_head lists[5];
	spinlock_t lru_lock;
	long unsigned int anon_cost;
	long unsigned int file_cost;
	atomic_long_t nonresident_age;
	long unsigned int refaults[2];
	long unsigned int flags;
	struct pglist_data *pgdat;
};

struct per_cpu_pages;

struct per_cpu_zonestat;

struct zone {
	long unsigned int _watermark[4];
	long unsigned int watermark_boost;
	long unsigned int nr_reserved_highatomic;
	long int lowmem_reserve[3];
	int node;
	struct pglist_data *zone_pgdat;
	struct per_cpu_pages *per_cpu_pageset;
	struct per_cpu_zonestat *per_cpu_zonestats;
	int pageset_high;
	int pageset_batch;
	long unsigned int zone_start_pfn;
	atomic_long_t managed_pages;
	long unsigned int spanned_pages;
	long unsigned int present_pages;
	long unsigned int present_early_pages;
	long unsigned int cma_pages;
	const char *name;
	long unsigned int nr_isolate_pageblock;
	seqlock_t span_seqlock;
	int initialized;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct cacheline_padding _pad1_;
	struct free_area free_area[9];
	long unsigned int flags;
	spinlock_t lock;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct cacheline_padding _pad2_;
	long unsigned int percpu_drift_mark;
	long unsigned int compact_cached_free_pfn;
	long unsigned int compact_cached_migrate_pfn[2];
	long unsigned int compact_init_migrate_pfn;
	long unsigned int compact_init_free_pfn;
	unsigned int compact_considered;
	unsigned int compact_defer_shift;
	int compact_order_failed;
	bool compact_blockskip_flush;
	bool contiguous;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct cacheline_padding _pad3_;
	atomic_long_t vm_stat[11];
	atomic_long_t vm_numa_event[6];
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct zoneref {
	struct zone *zone;
	int zone_idx;
};

struct zonelist {
	struct zoneref _zonerefs[769];
};

enum zone_type {
	ZONE_NORMAL = 0,
	ZONE_MOVABLE = 1,
	ZONE_DEVICE = 2,
	__MAX_NR_ZONES = 3,
};

struct per_cpu_nodestat;

struct memory_tier;

struct pglist_data {
	struct zone node_zones[3];
	struct zonelist node_zonelists[2];
	int nr_zones;
	spinlock_t node_size_lock;
	long unsigned int node_start_pfn;
	long unsigned int node_present_pages;
	long unsigned int node_spanned_pages;
	int node_id;
	wait_queue_head_t kswapd_wait;
	wait_queue_head_t pfmemalloc_wait;
	wait_queue_head_t reclaim_wait[4];
	atomic_t nr_writeback_throttled;
	long unsigned int nr_reclaim_start;
	struct mutex kswapd_lock;
	struct task_struct *kswapd;
	int kswapd_order;
	enum zone_type kswapd_highest_zoneidx;
	int kswapd_failures;
	int kcompactd_max_order;
	enum zone_type kcompactd_highest_zoneidx;
	wait_queue_head_t kcompactd_wait;
	struct task_struct *kcompactd;
	bool proactive_compact_trigger;
	long unsigned int totalreserve_pages;
	long unsigned int min_unmapped_pages;
	long unsigned int min_slab_pages;
	long: 64;
	long: 64;
	struct cacheline_padding _pad1_;
	struct deferred_split deferred_split_queue;
	unsigned int nbp_rl_start;
	long unsigned int nbp_rl_nr_cand;
	unsigned int nbp_threshold;
	unsigned int nbp_th_start;
	long unsigned int nbp_th_nr_cand;
	struct lruvec __lruvec;
	long unsigned int flags;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct cacheline_padding _pad2_;
	struct per_cpu_nodestat *per_cpu_nodestats;
	atomic_long_t vm_stat[43];
	struct memory_tier *memtier;
	long: 64;
	long: 64;
	long: 64;
};

struct per_cpu_pages {
	spinlock_t lock;
	int count;
	int high;
	int batch;
	short int free_factor;
	short int expire;
	struct list_head lists[13];
	long: 64;
	long: 64;
	long: 64;
};

struct per_cpu_zonestat {
	s8 vm_stat_diff[11];
	s8 stat_threshold;
	long unsigned int vm_numa_event[6];
};

struct per_cpu_nodestat {
	s8 stat_threshold;
	s8 vm_node_stat_diff[43];
};

struct wait_page_queue {
	struct folio *folio;
	int bit_nr;
	wait_queue_entry_t wait;
};

enum writeback_sync_modes {
	WB_SYNC_NONE = 0,
	WB_SYNC_ALL = 1,
};

struct swap_iocb;

struct writeback_control {
	long int nr_to_write;
	long int pages_skipped;
	loff_t range_start;
	loff_t range_end;
	enum writeback_sync_modes sync_mode;
	unsigned int for_kupdate: 1;
	unsigned int for_background: 1;
	unsigned int tagged_writepages: 1;
	unsigned int for_reclaim: 1;
	unsigned int range_cyclic: 1;
	unsigned int for_sync: 1;
	unsigned int unpinned_fscache_wb: 1;
	unsigned int no_cgroup_owner: 1;
	struct swap_iocb **swap_plug;
	struct bdi_writeback *wb;
	struct inode *inode;
	int wb_id;
	int wb_lcand_id;
	int wb_tcand_id;
	size_t wb_bytes;
	size_t wb_lcand_bytes;
	size_t wb_tcand_bytes;
};

struct readahead_control {
	struct file *file;
	struct address_space *mapping;
	struct file_ra_state *ra;
	long unsigned int _index;
	unsigned int _nr_pages;
	unsigned int _batch_count;
	bool _workingset;
	long unsigned int _pflags;
};

struct swap_cluster_info {
	spinlock_t lock;
	unsigned int data: 24;
	unsigned int flags: 8;
};

struct swap_cluster_list {
	struct swap_cluster_info head;
	struct swap_cluster_info tail;
};

struct percpu_cluster;

struct swap_info_struct {
	struct percpu_ref users;
	long unsigned int flags;
	short int prio;
	struct plist_node list;
	signed char type;
	unsigned int max;
	unsigned char *swap_map;
	struct swap_cluster_info *cluster_info;
	struct swap_cluster_list free_clusters;
	unsigned int lowest_bit;
	unsigned int highest_bit;
	unsigned int pages;
	unsigned int inuse_pages;
	unsigned int cluster_next;
	unsigned int cluster_nr;
	unsigned int *cluster_next_cpu;
	struct percpu_cluster *percpu_cluster;
	struct rb_root swap_extent_root;
	struct block_device *bdev;
	struct file *swap_file;
	unsigned int old_block_size;
	struct completion comp;
	spinlock_t lock;
	spinlock_t cont_lock;
	struct work_struct discard_work;
	struct swap_cluster_list discard_clusters;
	struct plist_node avail_lists[0];
};

struct cdev {
	struct kobject kobj;
	struct module *owner;
	const struct file_operations *ops;
	struct list_head list;
	dev_t dev;
	unsigned int count;
};

struct fprop_local_percpu {
	struct percpu_counter events;
	unsigned int period;
	raw_spinlock_t lock;
};

enum wb_reason {
	WB_REASON_BACKGROUND = 0,
	WB_REASON_VMSCAN = 1,
	WB_REASON_SYNC = 2,
	WB_REASON_PERIODIC = 3,
	WB_REASON_LAPTOP_TIMER = 4,
	WB_REASON_FS_FREE_SPACE = 5,
	WB_REASON_FORKER_THREAD = 6,
	WB_REASON_FOREIGN_FLUSH = 7,
	WB_REASON_MAX = 8,
};

struct bdi_writeback {
	struct backing_dev_info *bdi;
	long unsigned int state;
	long unsigned int last_old_flush;
	struct list_head b_dirty;
	struct list_head b_io;
	struct list_head b_more_io;
	struct list_head b_dirty_time;
	spinlock_t list_lock;
	atomic_t writeback_inodes;
	struct percpu_counter stat[4];
	long unsigned int bw_time_stamp;
	long unsigned int dirtied_stamp;
	long unsigned int written_stamp;
	long unsigned int write_bandwidth;
	long unsigned int avg_write_bandwidth;
	long unsigned int dirty_ratelimit;
	long unsigned int balanced_dirty_ratelimit;
	struct fprop_local_percpu completions;
	int dirty_exceeded;
	enum wb_reason start_all_reason;
	spinlock_t work_lock;
	struct list_head work_list;
	struct delayed_work dwork;
	struct delayed_work bw_dwork;
	long unsigned int dirty_sleep;
	struct list_head bdi_node;
	struct percpu_ref refcnt;
	struct fprop_local_percpu memcg_completions;
	struct cgroup_subsys_state *memcg_css;
	struct cgroup_subsys_state *blkcg_css;
	struct list_head memcg_node;
	struct list_head blkcg_node;
	struct list_head b_attached;
	struct list_head offline_node;
	union {
		struct work_struct release_work;
		struct callback_head rcu;
	};
};

struct backing_dev_info {
	u64 id;
	struct rb_node rb_node;
	struct list_head bdi_list;
	long unsigned int ra_pages;
	long unsigned int io_pages;
	struct kref refcnt;
	unsigned int capabilities;
	unsigned int min_ratio;
	unsigned int max_ratio;
	unsigned int max_prop_frac;
	atomic_long_t tot_write_bandwidth;
	struct bdi_writeback wb;
	struct list_head wb_list;
	struct xarray cgwb_tree;
	struct mutex cgwb_release_mutex;
	struct rw_semaphore wb_switch_rwsem;
	wait_queue_head_t wb_waitq;
	struct device *dev;
	char dev_name[64];
	struct device *owner;
	struct timer_list laptop_mode_wb_timer;
	struct dentry *debug_dir;
};

enum ctx_state {
	CONTEXT_DISABLED = -1,
	CONTEXT_KERNEL = 0,
	CONTEXT_IDLE = 1,
	CONTEXT_USER = 2,
	CONTEXT_GUEST = 3,
	CONTEXT_MAX = 4,
};

struct context_tracking {
	bool active;
	int recursion;
	atomic_t state;
	long int dynticks_nesting;
	long int dynticks_nmi_nesting;
};

enum clock_event_state {
	CLOCK_EVT_STATE_DETACHED = 0,
	CLOCK_EVT_STATE_SHUTDOWN = 1,
	CLOCK_EVT_STATE_PERIODIC = 2,
	CLOCK_EVT_STATE_ONESHOT = 3,
	CLOCK_EVT_STATE_ONESHOT_STOPPED = 4,
};

struct clock_event_device {
	void (*event_handler)(struct clock_event_device *);
	int (*set_next_event)(long unsigned int, struct clock_event_device *);
	int (*set_next_ktime)(ktime_t, struct clock_event_device *);
	ktime_t next_event;
	u64 max_delta_ns;
	u64 min_delta_ns;
	u32 mult;
	u32 shift;
	enum clock_event_state state_use_accessors;
	unsigned int features;
	long unsigned int retries;
	int (*set_state_periodic)(struct clock_event_device *);
	int (*set_state_oneshot)(struct clock_event_device *);
	int (*set_state_oneshot_stopped)(struct clock_event_device *);
	int (*set_state_shutdown)(struct clock_event_device *);
	int (*tick_resume)(struct clock_event_device *);
	void (*broadcast)(const struct cpumask *);
	void (*suspend)(struct clock_event_device *);
	void (*resume)(struct clock_event_device *);
	long unsigned int min_delta_ticks;
	long unsigned int max_delta_ticks;
	const char *name;
	int rating;
	int irq;
	int bound_on;
	const struct cpumask *cpumask;
	struct list_head list;
	struct module *owner;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct div_result {
	u64 result_high;
	u64 result_low;
};

typedef struct {
	unsigned int __softirq_pending;
	unsigned int timer_irqs_event;
	unsigned int broadcast_irqs_event;
	unsigned int timer_irqs_others;
	unsigned int pmu_irqs;
	unsigned int mce_exceptions;
	unsigned int spurious_irqs;
	unsigned int sreset_irqs;
	unsigned int soft_nmi_irqs;
	unsigned int doorbell_irqs;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
} irq_cpustat_t;

enum cpu_usage_stat {
	CPUTIME_USER = 0,
	CPUTIME_NICE = 1,
	CPUTIME_SYSTEM = 2,
	CPUTIME_SOFTIRQ = 3,
	CPUTIME_IRQ = 4,
	CPUTIME_IDLE = 5,
	CPUTIME_IOWAIT = 6,
	CPUTIME_STEAL = 7,
	CPUTIME_GUEST = 8,
	CPUTIME_GUEST_NICE = 9,
	NR_STATS = 10,
};

struct kernel_cpustat {
	u64 cpustat[10];
};

struct rtc_time {
	int tm_sec;
	int tm_min;
	int tm_hour;
	int tm_mday;
	int tm_mon;
	int tm_year;
	int tm_wday;
	int tm_yday;
	int tm_isdst;
};

enum {
	TASKSTATS_CMD_UNSPEC = 0,
	TASKSTATS_CMD_GET = 1,
	TASKSTATS_CMD_NEW = 2,
	__TASKSTATS_CMD_MAX = 3,
};

enum ucount_type {
	UCOUNT_USER_NAMESPACES = 0,
	UCOUNT_PID_NAMESPACES = 1,
	UCOUNT_UTS_NAMESPACES = 2,
	UCOUNT_IPC_NAMESPACES = 3,
	UCOUNT_NET_NAMESPACES = 4,
	UCOUNT_MNT_NAMESPACES = 5,
	UCOUNT_CGROUP_NAMESPACES = 6,
	UCOUNT_TIME_NAMESPACES = 7,
	UCOUNT_INOTIFY_INSTANCES = 8,
	UCOUNT_INOTIFY_WATCHES = 9,
	UCOUNT_COUNTS = 10,
};

enum rlimit_type {
	UCOUNT_RLIMIT_NPROC = 0,
	UCOUNT_RLIMIT_MSGQUEUE = 1,
	UCOUNT_RLIMIT_SIGPENDING = 2,
	UCOUNT_RLIMIT_MEMLOCK = 3,
	UCOUNT_RLIMIT_COUNTS = 4,
};

enum cgroup_bpf_attach_type {
	CGROUP_BPF_ATTACH_TYPE_INVALID = -1,
	CGROUP_INET_INGRESS = 0,
	CGROUP_INET_EGRESS = 1,
	CGROUP_INET_SOCK_CREATE = 2,
	CGROUP_SOCK_OPS = 3,
	CGROUP_DEVICE = 4,
	CGROUP_INET4_BIND = 5,
	CGROUP_INET6_BIND = 6,
	CGROUP_INET4_CONNECT = 7,
	CGROUP_INET6_CONNECT = 8,
	CGROUP_INET4_POST_BIND = 9,
	CGROUP_INET6_POST_BIND = 10,
	CGROUP_UDP4_SENDMSG = 11,
	CGROUP_UDP6_SENDMSG = 12,
	CGROUP_SYSCTL = 13,
	CGROUP_UDP4_RECVMSG = 14,
	CGROUP_UDP6_RECVMSG = 15,
	CGROUP_GETSOCKOPT = 16,
	CGROUP_SETSOCKOPT = 17,
	CGROUP_INET4_GETPEERNAME = 18,
	CGROUP_INET6_GETPEERNAME = 19,
	CGROUP_INET4_GETSOCKNAME = 20,
	CGROUP_INET6_GETSOCKNAME = 21,
	CGROUP_INET_SOCK_RELEASE = 22,
	CGROUP_LSM_START = 23,
	CGROUP_LSM_END = 32,
	MAX_CGROUP_BPF_ATTACH_TYPE = 33,
};

enum psi_task_count {
	NR_IOWAIT = 0,
	NR_MEMSTALL = 1,
	NR_RUNNING = 2,
	NR_MEMSTALL_RUNNING = 3,
	NR_PSI_TASK_COUNTS = 4,
};

enum psi_res {
	PSI_IO = 0,
	PSI_MEM = 1,
	PSI_CPU = 2,
	NR_PSI_RESOURCES = 3,
};

enum psi_states {
	PSI_IO_SOME = 0,
	PSI_IO_FULL = 1,
	PSI_MEM_SOME = 2,
	PSI_MEM_FULL = 3,
	PSI_CPU_SOME = 4,
	PSI_CPU_FULL = 5,
	PSI_NONIDLE = 6,
	NR_PSI_STATES = 7,
};

enum psi_aggregators {
	PSI_AVGS = 0,
	PSI_POLL = 1,
	NR_PSI_AGGREGATORS = 2,
};

enum cgroup_subsys_id {
	cpuset_cgrp_id = 0,
	cpu_cgrp_id = 1,
	cpuacct_cgrp_id = 2,
	io_cgrp_id = 3,
	memory_cgrp_id = 4,
	devices_cgrp_id = 5,
	freezer_cgrp_id = 6,
	perf_event_cgrp_id = 7,
	hugetlb_cgrp_id = 8,
	pids_cgrp_id = 9,
	misc_cgrp_id = 10,
	CGROUP_SUBSYS_COUNT = 11,
};

enum wb_stat_item {
	WB_RECLAIMABLE = 0,
	WB_WRITEBACK = 1,
	WB_DIRTIED = 2,
	WB_WRITTEN = 3,
	NR_WB_STAT_ITEMS = 4,
};

enum memcg_memory_event {
	MEMCG_LOW = 0,
	MEMCG_HIGH = 1,
	MEMCG_MAX = 2,
	MEMCG_OOM = 3,
	MEMCG_OOM_KILL = 4,
	MEMCG_OOM_GROUP_KILL = 5,
	MEMCG_SWAP_HIGH = 6,
	MEMCG_SWAP_MAX = 7,
	MEMCG_SWAP_FAIL = 8,
	MEMCG_NR_MEMORY_EVENTS = 9,
};

struct mem_cgroup_reclaim_iter {
	struct mem_cgroup *position;
	unsigned int generation;
};

struct shrinker_info {
	struct callback_head rcu;
	atomic_long_t *nr_deferred;
	long unsigned int *map;
	int map_nr_max;
};

struct lruvec_stats_percpu {
	long int state[43];
	long int state_prev[43];
};

struct lruvec_stats {
	long int state[43];
	long int state_local[43];
	long int state_pending[43];
};

struct mem_cgroup_per_node {
	struct lruvec lruvec;
	struct lruvec_stats_percpu *lruvec_stats_percpu;
	struct lruvec_stats lruvec_stats;
	long unsigned int lru_zone_size[15];
	struct mem_cgroup_reclaim_iter iter;
	struct shrinker_info *shrinker_info;
	struct rb_node tree_node;
	long unsigned int usage_in_excess;
	bool on_tree;
	struct mem_cgroup *memcg;
};

struct eventfd_ctx;

struct mem_cgroup_threshold {
	struct eventfd_ctx *eventfd;
	long unsigned int threshold;
};

struct mem_cgroup_threshold_ary {
	int current_threshold;
	unsigned int size;
	struct mem_cgroup_threshold entries[0];
};

struct obj_cgroup {
	struct percpu_ref refcnt;
	struct mem_cgroup *memcg;
	atomic_t nr_charged_bytes;
	union {
		struct list_head list;
		struct callback_head rcu;
	};
};

struct percpu_cluster {
	struct swap_cluster_info index;
	unsigned int next;
};

struct arch_vdso_data {};

struct vdso_timestamp {
	u64 sec;
	u64 nsec;
};

struct vdso_data {
	u32 seq;
	s32 clock_mode;
	u64 cycle_last;
	u64 mask;
	u32 mult;
	u32 shift;
	union {
		struct vdso_timestamp basetime[12];
		struct timens_offset offset[12];
	};
	s32 tz_minuteswest;
	s32 tz_dsttime;
	u32 hrtimer_res;
	u32 __unused;
	struct arch_vdso_data arch_data;
};

struct vdso_arch_data {
	__u8 eye_catcher[16];
	struct {
		__u32 major;
		__u32 minor;
	} version;
	__u32 platform;
	__u32 processor;
	__u64 processorCount;
	__u64 physicalMemorySize;
	__u64 tb_orig_stamp;
	__u64 tb_ticks_per_sec;
	__u64 tb_to_xs;
	__u64 stamp_xsec;
	__u64 tb_update_count;
	__u32 tz_minuteswest;
	__u32 tz_dsttime;
	__u32 dcache_size;
	__u32 dcache_line_size;
	__u32 icache_size;
	__u32 icache_line_size;
	__u32 dcache_block_size;
	__u32 icache_block_size;
	__u32 dcache_log_block_size;
	__u32 icache_log_block_size;
	__u32 syscall_map[15];
	__u32 compat_syscall_map[15];
	struct vdso_data data[2];
};

struct mem_section_usage {
	long unsigned int subsection_map[1];
	long unsigned int pageblock_flags[0];
};

struct page_ext;

struct mem_section {
	long unsigned int section_mem_map;
	struct mem_section_usage *usage;
	struct page_ext *page_ext;
	long unsigned int pad;
};

struct page_ext {
	long unsigned int flags;
};

enum {
	SECTION_MARKED_PRESENT_BIT = 0,
	SECTION_HAS_MEM_MAP_BIT = 1,
	SECTION_IS_ONLINE_BIT = 2,
	SECTION_IS_EARLY_BIT = 3,
	SECTION_TAINT_ZONE_DEVICE_BIT = 4,
	SECTION_MAP_LAST_BIT = 5,
};

typedef bool (*stack_trace_consume_fn)(void *, long unsigned int);

struct ppc_debug_info {
	__u32 version;
	__u32 num_instruction_bps;
	__u32 num_data_bps;
	__u32 num_condition_regs;
	__u32 data_bp_alignment;
	__u32 sizeof_condition;
	__u64 features;
};

struct ppc_hw_breakpoint {
	__u32 version;
	__u32 trigger_type;
	__u32 addr_mode;
	__u32 condition_mode;
	__u64 addr;
	__u64 addr2;
	__u64 condition_value;
};

enum perf_type_id {
	PERF_TYPE_HARDWARE = 0,
	PERF_TYPE_SOFTWARE = 1,
	PERF_TYPE_TRACEPOINT = 2,
	PERF_TYPE_HW_CACHE = 3,
	PERF_TYPE_RAW = 4,
	PERF_TYPE_BREAKPOINT = 5,
	PERF_TYPE_MAX = 6,
};

struct mce_error_info {
	enum MCE_ErrorType error_type: 8;
	union {
		enum MCE_UeErrorType ue_error_type: 8;
		enum MCE_SlbErrorType slb_error_type: 8;
		enum MCE_EratErrorType erat_error_type: 8;
		enum MCE_TlbErrorType tlb_error_type: 8;
		enum MCE_UserErrorType user_error_type: 8;
		enum MCE_RaErrorType ra_error_type: 8;
		enum MCE_LinkErrorType link_error_type: 8;
	} u;
	enum MCE_Severity severity: 8;
	enum MCE_Initiator initiator: 8;
	enum MCE_ErrorClass error_class: 8;
	bool sync_error;
	bool ignore_event;
};

enum {
	TLB_INVAL_SCOPE_GLOBAL = 0,
	TLB_INVAL_SCOPE_LPID = 1,
};

struct mce_ierror_table {
	long unsigned int srr1_mask;
	long unsigned int srr1_value;
	bool nip_valid;
	unsigned int error_type;
	unsigned int error_subtype;
	unsigned int error_class;
	unsigned int initiator;
	unsigned int severity;
	bool sync_error;
};

struct mce_derror_table {
	long unsigned int dsisr_value;
	bool dar_valid;
	unsigned int error_type;
	unsigned int error_subtype;
	unsigned int error_class;
	unsigned int initiator;
	unsigned int severity;
	bool sync_error;
};

struct proc_ops {
	unsigned int proc_flags;
	int (*proc_open)(struct inode *, struct file *);
	ssize_t (*proc_read)(struct file *, char *, size_t, loff_t *);
	ssize_t (*proc_read_iter)(struct kiocb *, struct iov_iter *);
	ssize_t (*proc_write)(struct file *, const char *, size_t, loff_t *);
	loff_t (*proc_lseek)(struct file *, loff_t, int);
	int (*proc_release)(struct inode *, struct file *);
	__poll_t (*proc_poll)(struct file *, struct poll_table_struct *);
	long int (*proc_ioctl)(struct file *, unsigned int, long unsigned int);
	int (*proc_mmap)(struct file *, struct vm_area_struct *);
	long unsigned int (*proc_get_unmapped_area)(struct file *, long unsigned int, long unsigned int, long unsigned int, long unsigned int);
};

enum {
	HI_SOFTIRQ = 0,
	TIMER_SOFTIRQ = 1,
	NET_TX_SOFTIRQ = 2,
	NET_RX_SOFTIRQ = 3,
	BLOCK_SOFTIRQ = 4,
	IRQ_POLL_SOFTIRQ = 5,
	TASKLET_SOFTIRQ = 6,
	SCHED_SOFTIRQ = 7,
	HRTIMER_SOFTIRQ = 8,
	RCU_SOFTIRQ = 9,
	NR_SOFTIRQS = 10,
};

enum rtas_function_index {
	RTAS_FNIDX__CHECK_EXCEPTION = 0,
	RTAS_FNIDX__DISPLAY_CHARACTER = 1,
	RTAS_FNIDX__EVENT_SCAN = 2,
	RTAS_FNIDX__FREEZE_TIME_BASE = 3,
	RTAS_FNIDX__GET_POWER_LEVEL = 4,
	RTAS_FNIDX__GET_SENSOR_STATE = 5,
	RTAS_FNIDX__GET_TERM_CHAR = 6,
	RTAS_FNIDX__GET_TIME_OF_DAY = 7,
	RTAS_FNIDX__IBM_ACTIVATE_FIRMWARE = 8,
	RTAS_FNIDX__IBM_CBE_START_PTCAL = 9,
	RTAS_FNIDX__IBM_CBE_STOP_PTCAL = 10,
	RTAS_FNIDX__IBM_CHANGE_MSI = 11,
	RTAS_FNIDX__IBM_CLOSE_ERRINJCT = 12,
	RTAS_FNIDX__IBM_CONFIGURE_BRIDGE = 13,
	RTAS_FNIDX__IBM_CONFIGURE_CONNECTOR = 14,
	RTAS_FNIDX__IBM_CONFIGURE_KERNEL_DUMP = 15,
	RTAS_FNIDX__IBM_CONFIGURE_PE = 16,
	RTAS_FNIDX__IBM_CREATE_PE_DMA_WINDOW = 17,
	RTAS_FNIDX__IBM_DISPLAY_MESSAGE = 18,
	RTAS_FNIDX__IBM_ERRINJCT = 19,
	RTAS_FNIDX__IBM_EXTI2C = 20,
	RTAS_FNIDX__IBM_GET_CONFIG_ADDR_INFO = 21,
	RTAS_FNIDX__IBM_GET_CONFIG_ADDR_INFO2 = 22,
	RTAS_FNIDX__IBM_GET_DYNAMIC_SENSOR_STATE = 23,
	RTAS_FNIDX__IBM_GET_INDICES = 24,
	RTAS_FNIDX__IBM_GET_RIO_TOPOLOGY = 25,
	RTAS_FNIDX__IBM_GET_SYSTEM_PARAMETER = 26,
	RTAS_FNIDX__IBM_GET_VPD = 27,
	RTAS_FNIDX__IBM_GET_XIVE = 28,
	RTAS_FNIDX__IBM_INT_OFF = 29,
	RTAS_FNIDX__IBM_INT_ON = 30,
	RTAS_FNIDX__IBM_IO_QUIESCE_ACK = 31,
	RTAS_FNIDX__IBM_LPAR_PERFTOOLS = 32,
	RTAS_FNIDX__IBM_MANAGE_FLASH_IMAGE = 33,
	RTAS_FNIDX__IBM_MANAGE_STORAGE_PRESERVATION = 34,
	RTAS_FNIDX__IBM_NMI_INTERLOCK = 35,
	RTAS_FNIDX__IBM_NMI_REGISTER = 36,
	RTAS_FNIDX__IBM_OPEN_ERRINJCT = 37,
	RTAS_FNIDX__IBM_OPEN_SRIOV_ALLOW_UNFREEZE = 38,
	RTAS_FNIDX__IBM_OPEN_SRIOV_MAP_PE_NUMBER = 39,
	RTAS_FNIDX__IBM_OS_TERM = 40,
	RTAS_FNIDX__IBM_PARTNER_CONTROL = 41,
	RTAS_FNIDX__IBM_PHYSICAL_ATTESTATION = 42,
	RTAS_FNIDX__IBM_PLATFORM_DUMP = 43,
	RTAS_FNIDX__IBM_POWER_OFF_UPS = 44,
	RTAS_FNIDX__IBM_QUERY_INTERRUPT_SOURCE_NUMBER = 45,
	RTAS_FNIDX__IBM_QUERY_PE_DMA_WINDOW = 46,
	RTAS_FNIDX__IBM_READ_PCI_CONFIG = 47,
	RTAS_FNIDX__IBM_READ_SLOT_RESET_STATE = 48,
	RTAS_FNIDX__IBM_READ_SLOT_RESET_STATE2 = 49,
	RTAS_FNIDX__IBM_REMOVE_PE_DMA_WINDOW = 50,
	RTAS_FNIDX__IBM_RESET_PE_DMA_WINDOWS = 51,
	RTAS_FNIDX__IBM_SCAN_LOG_DUMP = 52,
	RTAS_FNIDX__IBM_SET_DYNAMIC_INDICATOR = 53,
	RTAS_FNIDX__IBM_SET_EEH_OPTION = 54,
	RTAS_FNIDX__IBM_SET_SLOT_RESET = 55,
	RTAS_FNIDX__IBM_SET_SYSTEM_PARAMETER = 56,
	RTAS_FNIDX__IBM_SET_XIVE = 57,
	RTAS_FNIDX__IBM_SLOT_ERROR_DETAIL = 58,
	RTAS_FNIDX__IBM_SUSPEND_ME = 59,
	RTAS_FNIDX__IBM_TUNE_DMA_PARMS = 60,
	RTAS_FNIDX__IBM_UPDATE_FLASH_64_AND_REBOOT = 61,
	RTAS_FNIDX__IBM_UPDATE_NODES = 62,
	RTAS_FNIDX__IBM_UPDATE_PROPERTIES = 63,
	RTAS_FNIDX__IBM_VALIDATE_FLASH_IMAGE = 64,
	RTAS_FNIDX__IBM_WRITE_PCI_CONFIG = 65,
	RTAS_FNIDX__NVRAM_FETCH = 66,
	RTAS_FNIDX__NVRAM_STORE = 67,
	RTAS_FNIDX__POWER_OFF = 68,
	RTAS_FNIDX__PUT_TERM_CHAR = 69,
	RTAS_FNIDX__QUERY_CPU_STOPPED_STATE = 70,
	RTAS_FNIDX__READ_PCI_CONFIG = 71,
	RTAS_FNIDX__RTAS_LAST_ERROR = 72,
	RTAS_FNIDX__SET_INDICATOR = 73,
	RTAS_FNIDX__SET_POWER_LEVEL = 74,
	RTAS_FNIDX__SET_TIME_FOR_POWER_ON = 75,
	RTAS_FNIDX__SET_TIME_OF_DAY = 76,
	RTAS_FNIDX__START_CPU = 77,
	RTAS_FNIDX__STOP_SELF = 78,
	RTAS_FNIDX__SYSTEM_REBOOT = 79,
	RTAS_FNIDX__THAW_TIME_BASE = 80,
	RTAS_FNIDX__WRITE_PCI_CONFIG = 81,
};

typedef struct {
	const enum rtas_function_index index;
} rtas_fn_handle_t;

struct individual_sensor {
	unsigned int token;
	unsigned int quant;
};

struct rtas_sensors {
	struct individual_sensor sensor[17];
	unsigned int quant;
};

enum pageflags {
	PG_locked = 0,
	PG_writeback = 1,
	PG_referenced = 2,
	PG_uptodate = 3,
	PG_dirty = 4,
	PG_lru = 5,
	PG_head = 6,
	PG_waiters = 7,
	PG_active = 8,
	PG_workingset = 9,
	PG_error = 10,
	PG_slab = 11,
	PG_owner_priv_1 = 12,
	PG_arch_1 = 13,
	PG_reserved = 14,
	PG_private = 15,
	PG_private_2 = 16,
	PG_mappedtodisk = 17,
	PG_reclaim = 18,
	PG_swapbacked = 19,
	PG_unevictable = 20,
	PG_mlocked = 21,
	__NR_PAGEFLAGS = 22,
	PG_readahead = 18,
	PG_anon_exclusive = 17,
	PG_checked = 12,
	PG_swapcache = 12,
	PG_fscache = 16,
	PG_pinned = 12,
	PG_savepinned = 4,
	PG_foreign = 12,
	PG_xen_remapped = 12,
	PG_isolated = 18,
	PG_reported = 3,
	PG_vmemmap_self_hosted = 12,
	PG_has_hwpoisoned = 10,
	PG_hugetlb = 8,
	PG_large_rmappable = 9,
};

struct rtas_t {
	long unsigned int entry;
	long unsigned int base;
	long unsigned int size;
	struct device_node *dev;
};

enum jump_label_type {
	JUMP_LABEL_NOP = 0,
	JUMP_LABEL_JMP = 1,
};

enum {
	TRACE_FTRACE_BIT = 0,
	TRACE_FTRACE_NMI_BIT = 1,
	TRACE_FTRACE_IRQ_BIT = 2,
	TRACE_FTRACE_SIRQ_BIT = 3,
	TRACE_FTRACE_TRANSITION_BIT = 4,
	TRACE_INTERNAL_BIT = 5,
	TRACE_INTERNAL_NMI_BIT = 6,
	TRACE_INTERNAL_IRQ_BIT = 7,
	TRACE_INTERNAL_SIRQ_BIT = 8,
	TRACE_INTERNAL_TRANSITION_BIT = 9,
	TRACE_BRANCH_BIT = 10,
	TRACE_IRQ_BIT = 11,
	TRACE_GRAPH_BIT = 12,
	TRACE_GRAPH_DEPTH_START_BIT = 13,
	TRACE_GRAPH_DEPTH_END_BIT = 14,
	TRACE_GRAPH_NOTRACE_BIT = 15,
	TRACE_RECORD_RECURSION_BIT = 16,
};

enum {
	TRACE_CTX_NMI = 0,
	TRACE_CTX_IRQ = 1,
	TRACE_CTX_SOFTIRQ = 2,
	TRACE_CTX_NORMAL = 3,
	TRACE_CTX_TRANSITION = 4,
};

typedef u32 kprobe_opcode_t;

struct arch_specific_insn {
	kprobe_opcode_t *insn;
	int boostable;
};

struct kprobe;

struct prev_kprobe {
	struct kprobe *kp;
	long unsigned int status;
	long unsigned int saved_msr;
};

typedef int (*kprobe_pre_handler_t)(struct kprobe *, struct pt_regs *);

typedef void (*kprobe_post_handler_t)(struct kprobe *, struct pt_regs *, long unsigned int);

struct kprobe {
	struct hlist_node hlist;
	struct list_head list;
	long unsigned int nmissed;
	kprobe_opcode_t *addr;
	const char *symbol_name;
	unsigned int offset;
	kprobe_pre_handler_t pre_handler;
	kprobe_post_handler_t post_handler;
	kprobe_opcode_t opcode;
	struct arch_specific_insn ainsn;
	u32 flags;
};

struct kprobe_ctlblk {
	long unsigned int kprobe_status;
	long unsigned int kprobe_saved_msr;
	struct prev_kprobe prev_kprobe;
};

struct pci_device_id {
	__u32 vendor;
	__u32 device;
	__u32 subvendor;
	__u32 subdevice;
	__u32 class;
	__u32 class_mask;
	kernel_ulong_t driver_data;
	__u32 override_only;
};

struct resource {
	resource_size_t start;
	resource_size_t end;
	const char *name;
	long unsigned int flags;
	long unsigned int desc;
	struct resource *parent;
	struct resource *sibling;
	struct resource *child;
};

struct iommu_table_group;

struct pci_dn {
	int flags;
	int busno;
	int devfn;
	int vendor_id;
	int device_id;
	int class_code;
	struct pci_dn *parent;
	struct pci_controller *phb;
	struct iommu_table_group *table_group;
	int pci_ext_config_space;
	struct eeh_dev *edev;
	unsigned int pe_number;
	int mps;
	struct list_head child_list;
	struct list_head list;
	struct resource holes[6];
};

struct iopf_device_param;

struct iommu_fault_param;

struct iommu_fwspec;

struct dev_iommu {
	struct mutex lock;
	struct iommu_fault_param *fault_param;
	struct iopf_device_param *iopf_param;
	struct iommu_fwspec *fwspec;
	struct iommu_device *iommu_dev;
	void *priv;
	u32 max_pasids;
	u32 attach_deferred: 1;
	u32 pci_32bit_workaround: 1;
	u32 require_direct: 1;
};

typedef int pci_power_t;

typedef unsigned int pci_channel_state_t;

typedef short unsigned int pci_dev_flags_t;

struct pci_vpd {
	struct mutex lock;
	unsigned int len;
	u8 cap;
};

struct proc_dir_entry;

struct pci_slot;

struct pci_driver;

struct pcie_link_state;

struct pci_dev {
	struct list_head bus_list;
	struct pci_bus *bus;
	struct pci_bus *subordinate;
	void *sysdata;
	struct proc_dir_entry *procent;
	struct pci_slot *slot;
	unsigned int devfn;
	short unsigned int vendor;
	short unsigned int device;
	short unsigned int subsystem_vendor;
	short unsigned int subsystem_device;
	unsigned int class;
	u8 revision;
	u8 hdr_type;
	u32 devcap;
	u8 pcie_cap;
	u8 msi_cap;
	u8 msix_cap;
	u8 pcie_mpss: 3;
	u8 rom_base_reg;
	u8 pin;
	u16 pcie_flags_reg;
	long unsigned int *dma_alias_mask;
	struct pci_driver *driver;
	u64 dma_mask;
	struct device_dma_parameters dma_parms;
	pci_power_t current_state;
	u8 pm_cap;
	unsigned int imm_ready: 1;
	unsigned int pme_support: 5;
	unsigned int pme_poll: 1;
	unsigned int d1_support: 1;
	unsigned int d2_support: 1;
	unsigned int no_d1d2: 1;
	unsigned int no_d3cold: 1;
	unsigned int bridge_d3: 1;
	unsigned int d3cold_allowed: 1;
	unsigned int mmio_always_on: 1;
	unsigned int wakeup_prepared: 1;
	unsigned int skip_bus_pm: 1;
	unsigned int ignore_hotplug: 1;
	unsigned int hotplug_user_indicators: 1;
	unsigned int clear_retrain_link: 1;
	unsigned int d3hot_delay;
	unsigned int d3cold_delay;
	struct pcie_link_state *link_state;
	u16 l1ss;
	unsigned int ltr_path: 1;
	unsigned int pasid_no_tlp: 1;
	unsigned int eetlp_prefix_path: 1;
	pci_channel_state_t error_state;
	struct device dev;
	int cfg_size;
	unsigned int irq;
	struct resource resource[11];
	struct resource driver_exclusive_resource;
	bool match_driver;
	unsigned int transparent: 1;
	unsigned int io_window: 1;
	unsigned int pref_window: 1;
	unsigned int pref_64_window: 1;
	unsigned int multifunction: 1;
	unsigned int is_busmaster: 1;
	unsigned int no_msi: 1;
	unsigned int no_64bit_msi: 1;
	unsigned int block_cfg_access: 1;
	unsigned int broken_parity_status: 1;
	unsigned int irq_reroute_variant: 2;
	unsigned int msi_enabled: 1;
	unsigned int msix_enabled: 1;
	unsigned int ari_enabled: 1;
	unsigned int ats_enabled: 1;
	unsigned int pasid_enabled: 1;
	unsigned int pri_enabled: 1;
	unsigned int is_managed: 1;
	unsigned int is_msi_managed: 1;
	unsigned int needs_freset: 1;
	unsigned int state_saved: 1;
	unsigned int is_physfn: 1;
	unsigned int is_virtfn: 1;
	unsigned int is_hotplug_bridge: 1;
	unsigned int shpc_managed: 1;
	unsigned int is_thunderbolt: 1;
	unsigned int untrusted: 1;
	unsigned int external_facing: 1;
	unsigned int broken_intx_masking: 1;
	unsigned int io_window_1k: 1;
	unsigned int irq_managed: 1;
	unsigned int non_compliant_bars: 1;
	unsigned int is_probed: 1;
	unsigned int link_active_reporting: 1;
	unsigned int no_vf_scan: 1;
	unsigned int no_command_memory: 1;
	unsigned int rom_bar_overlap: 1;
	unsigned int rom_attr_enabled: 1;
	pci_dev_flags_t dev_flags;
	atomic_t enable_cnt;
	spinlock_t pcie_cap_lock;
	u32 saved_config_space[16];
	struct hlist_head saved_cap_space;
	struct bin_attribute *res_attr[11];
	struct bin_attribute *res_attr_wc[11];
	void *msix_base;
	raw_spinlock_t msi_lock;
	struct pci_vpd vpd;
	u16 acs_cap;
	phys_addr_t rom;
	size_t romlen;
	const char *driver_override;
	long unsigned int priv_flags;
	u8 reset_methods[7];
};

struct pci_controller_ops {
	void (*dma_dev_setup)(struct pci_dev *);
	void (*dma_bus_setup)(struct pci_bus *);
	bool (*iommu_bypass_supported)(struct pci_dev *, u64);
	int (*probe_mode)(struct pci_bus *);
	bool (*enable_device_hook)(struct pci_dev *);
	void (*disable_device)(struct pci_dev *);
	void (*release_device)(struct pci_dev *);
	resource_size_t (*window_alignment)(struct pci_bus *, long unsigned int);
	void (*setup_bridge)(struct pci_bus *, long unsigned int);
	void (*reset_secondary_bus)(struct pci_dev *);
	int (*setup_msi_irqs)(struct pci_dev *, int, int);
	void (*teardown_msi_irqs)(struct pci_dev *);
	void (*shutdown)(struct pci_controller *);
	struct iommu_group * (*device_group)(struct pci_controller *, struct pci_dev *);
};

struct iommu_device {
	struct list_head list;
	const struct iommu_ops *ops;
	struct fwnode_handle *fwnode;
	struct device *dev;
	u32 max_pasids;
};

struct pci_ops;

struct pci_controller {
	struct pci_bus *bus;
	char is_dynamic;
	int node;
	struct device_node *dn;
	struct list_head list_node;
	struct device *parent;
	int first_busno;
	int last_busno;
	int self_busno;
	struct resource busn;
	void *io_base_virt;
	void *io_base_alloc;
	resource_size_t io_base_phys;
	resource_size_t pci_io_size;
	resource_size_t isa_mem_phys;
	resource_size_t isa_mem_size;
	struct pci_controller_ops controller_ops;
	struct pci_ops *ops;
	unsigned int *cfg_addr;
	void *cfg_data;
	u32 indirect_type;
	struct resource io_resource;
	struct resource mem_resources[3];
	resource_size_t mem_offset[3];
	int global_number;
	resource_size_t dma_window_base_cur;
	resource_size_t dma_window_size;
	long unsigned int buid;
	struct pci_dn *pci_data;
	void *private_data;
	struct irq_domain *dev_domain;
	struct irq_domain *msi_domain;
	struct fwnode_handle *fwnode;
	struct iommu_device iommu;
};

typedef short unsigned int pci_bus_flags_t;

struct pci_bus {
	struct list_head node;
	struct pci_bus *parent;
	struct list_head children;
	struct list_head devices;
	struct pci_dev *self;
	struct list_head slots;
	struct resource *resource[4];
	struct list_head resources;
	struct resource busn_res;
	struct pci_ops *ops;
	void *sysdata;
	struct proc_dir_entry *procdir;
	unsigned char number;
	unsigned char primary;
	unsigned char max_bus_speed;
	unsigned char cur_bus_speed;
	char name[48];
	short unsigned int bridge_ctl;
	pci_bus_flags_t bus_flags;
	struct device *bridge;
	struct device dev;
	struct bin_attribute *legacy_io;
	struct bin_attribute *legacy_mem;
	unsigned int is_added: 1;
	unsigned int unsafe_warn: 1;
};

struct hotplug_slot;

struct pci_slot {
	struct pci_bus *bus;
	struct list_head list;
	struct hotplug_slot *hotplug;
	unsigned char number;
	struct kobject kobj;
};

enum {
	PCI_STD_RESOURCES = 0,
	PCI_STD_RESOURCE_END = 5,
	PCI_ROM_RESOURCE = 6,
	PCI_BRIDGE_RESOURCES = 7,
	PCI_BRIDGE_RESOURCE_END = 10,
	PCI_NUM_RESOURCES = 11,
	DEVICE_COUNT_RESOURCE = 11,
};

typedef unsigned int pcie_reset_state_t;

struct pci_dynids {
	spinlock_t lock;
	struct list_head list;
};

struct pci_error_handlers;

struct pci_driver {
	struct list_head node;
	const char *name;
	const struct pci_device_id *id_table;
	int (*probe)(struct pci_dev *, const struct pci_device_id *);
	void (*remove)(struct pci_dev *);
	int (*suspend)(struct pci_dev *, pm_message_t);
	int (*resume)(struct pci_dev *);
	void (*shutdown)(struct pci_dev *);
	int (*sriov_configure)(struct pci_dev *, int);
	int (*sriov_set_msix_vec_count)(struct pci_dev *, int);
	u32 (*sriov_get_vf_total_msix)(struct pci_dev *);
	const struct pci_error_handlers *err_handler;
	const struct attribute_group **groups;
	const struct attribute_group **dev_groups;
	struct device_driver driver;
	struct pci_dynids dynids;
	bool driver_managed_dma;
};

struct pci_ops {
	int (*add_bus)(struct pci_bus *);
	void (*remove_bus)(struct pci_bus *);
	void * (*map_bus)(struct pci_bus *, unsigned int, int);
	int (*read)(struct pci_bus *, unsigned int, int, int, u32 *);
	int (*write)(struct pci_bus *, unsigned int, int, int, u32);
};

typedef unsigned int pci_ers_result_t;

struct pci_error_handlers {
	pci_ers_result_t (*error_detected)(struct pci_dev *, pci_channel_state_t);
	pci_ers_result_t (*mmio_enabled)(struct pci_dev *);
	pci_ers_result_t (*slot_reset)(struct pci_dev *);
	void (*reset_prepare)(struct pci_dev *);
	void (*reset_done)(struct pci_dev *);
	void (*resume)(struct pci_dev *);
	void (*cor_error_detected)(struct pci_dev *);
};

struct scatterlist {
	long unsigned int page_link;
	unsigned int offset;
	unsigned int length;
	dma_addr_t dma_address;
	unsigned int dma_length;
};

struct sg_table {
	struct scatterlist *sgl;
	unsigned int nents;
	unsigned int orig_nents;
};

struct of_phandle_args {
	struct device_node *np;
	int args_count;
	uint32_t args[16];
};

struct iommu_fault_unrecoverable {
	__u32 reason;
	__u32 flags;
	__u32 pasid;
	__u32 perm;
	__u64 addr;
	__u64 fetch_addr;
};

struct iommu_fault_page_request {
	__u32 flags;
	__u32 pasid;
	__u32 grpid;
	__u32 perm;
	__u64 addr;
	__u64 private_data[2];
};

struct iommu_fault {
	__u32 type;
	__u32 padding;
	union {
		struct iommu_fault_unrecoverable event;
		struct iommu_fault_page_request prm;
		__u8 padding2[56];
	};
};

enum iommu_page_response_code {
	IOMMU_PAGE_RESP_SUCCESS = 0,
	IOMMU_PAGE_RESP_INVALID = 1,
	IOMMU_PAGE_RESP_FAILURE = 2,
};

struct iommu_page_response {
	__u32 argsz;
	__u32 version;
	__u32 flags;
	__u32 pasid;
	__u32 grpid;
	__u32 code;
};

typedef int (*iommu_fault_handler_t)(struct iommu_domain *, struct device *, long unsigned int, int, void *);

struct iommu_domain_geometry {
	dma_addr_t aperture_start;
	dma_addr_t aperture_end;
	bool force_aperture;
};

struct iommu_dma_cookie;

struct iommu_domain {
	unsigned int type;
	const struct iommu_domain_ops *ops;
	long unsigned int pgsize_bitmap;
	struct iommu_domain_geometry geometry;
	struct iommu_dma_cookie *iova_cookie;
	enum iommu_page_response_code (*iopf_handler)(struct iommu_fault *, void *);
	void *fault_data;
	union {
		struct {
			iommu_fault_handler_t handler;
			void *handler_token;
		};
		struct {
			struct mm_struct *mm;
			int users;
		};
	};
};

typedef int (*iommu_dev_fault_handler_t)(struct iommu_fault *, void *);

struct iommu_iotlb_gather;

struct iommu_domain_ops {
	int (*attach_dev)(struct iommu_domain *, struct device *);
	int (*set_dev_pasid)(struct iommu_domain *, struct device *, ioasid_t);
	int (*map)(struct iommu_domain *, long unsigned int, phys_addr_t, size_t, int, gfp_t);
	int (*map_pages)(struct iommu_domain *, long unsigned int, phys_addr_t, size_t, size_t, int, gfp_t, size_t *);
	size_t (*unmap)(struct iommu_domain *, long unsigned int, size_t, struct iommu_iotlb_gather *);
	size_t (*unmap_pages)(struct iommu_domain *, long unsigned int, size_t, size_t, struct iommu_iotlb_gather *);
	void (*flush_iotlb_all)(struct iommu_domain *);
	void (*iotlb_sync_map)(struct iommu_domain *, long unsigned int, size_t);
	void (*iotlb_sync)(struct iommu_domain *, struct iommu_iotlb_gather *);
	phys_addr_t (*iova_to_phys)(struct iommu_domain *, dma_addr_t);
	bool (*enforce_cache_coherency)(struct iommu_domain *);
	int (*enable_nesting)(struct iommu_domain *);
	int (*set_pgtable_quirks)(struct iommu_domain *, long unsigned int);
	void (*free)(struct iommu_domain *);
};

struct iommu_iotlb_gather {
	long unsigned int start;
	long unsigned int end;
	size_t pgsize;
	struct list_head freelist;
	bool queued;
};

struct iommu_fault_event {
	struct iommu_fault fault;
	struct list_head list;
};

struct iommu_fault_param {
	iommu_dev_fault_handler_t handler;
	void *data;
	struct list_head faults;
	struct mutex lock;
};

struct iommu_fwspec {
	const struct iommu_ops *ops;
	struct fwnode_handle *iommu_fwnode;
	u32 flags;
	unsigned int num_ids;
	u32 ids[0];
};

struct mhp_params {
	struct vmem_altmap *altmap;
	pgprot_t pgprot;
	struct dev_pagemap *pgmap;
};

struct io_tlb_area;

struct io_tlb_slot;

struct io_tlb_pool {
	phys_addr_t start;
	phys_addr_t end;
	void *vaddr;
	long unsigned int nslabs;
	bool late_alloc;
	unsigned int nareas;
	unsigned int area_nslabs;
	struct io_tlb_area *areas;
	struct io_tlb_slot *slots;
};

struct io_tlb_mem {
	struct io_tlb_pool defpool;
	long unsigned int nslabs;
	struct dentry *debugfs;
	bool force_bounce;
	bool for_alloc;
	atomic_long_t total_used;
	atomic_long_t used_hiwater;
};

enum memblock_flags {
	MEMBLOCK_NONE = 0,
	MEMBLOCK_HOTPLUG = 1,
	MEMBLOCK_MIRROR = 2,
	MEMBLOCK_NOMAP = 4,
	MEMBLOCK_DRIVER_MANAGED = 8,
};

struct memblock_region {
	phys_addr_t base;
	phys_addr_t size;
	enum memblock_flags flags;
	int nid;
};

struct memblock_type {
	long unsigned int cnt;
	long unsigned int max;
	phys_addr_t total_size;
	struct memblock_region *regions;
	char *name;
};

struct memblock {
	bool bottom_up;
	phys_addr_t current_limit;
	struct memblock_type memory;
	struct memblock_type reserved;
};

typedef unsigned int slab_flags_t;

typedef u8 uint8_t;

typedef struct {
	pte_t pte;
	long unsigned int hidx;
} real_pte_t;

struct mmu_psize_def {
	unsigned int shift;
	int penc[16];
	unsigned int tlbiel;
	long unsigned int avpnm;
	long unsigned int h_rpt_pgsize;
	union {
		long unsigned int sllp;
		long unsigned int ap;
	};
};

struct mmu_hash_ops {
	void (*hpte_invalidate)(long unsigned int, long unsigned int, int, int, int, int);
	long int (*hpte_updatepp)(long unsigned int, long unsigned int, long unsigned int, int, int, int, long unsigned int);
	void (*hpte_updateboltedpp)(long unsigned int, long unsigned int, int, int);
	long int (*hpte_insert)(long unsigned int, long unsigned int, long unsigned int, long unsigned int, long unsigned int, int, int, int);
	long int (*hpte_remove)(long unsigned int);
	int (*hpte_removebolted)(long unsigned int, int, int);
	void (*flush_hash_range)(long unsigned int, int);
	void (*hugepage_invalidate)(long unsigned int, long unsigned int, unsigned char *, int, int, int);
	int (*resize_hpt)(long unsigned int);
	void (*hpte_clear_all)();
};

struct hash_pte {
	__be64 v;
	__be64 r;
};

struct patb_entry {
	__be64 patb0;
	__be64 patb1;
};

struct mempolicy {
	atomic_t refcnt;
	short unsigned int mode;
	short unsigned int flags;
	nodemask_t nodes;
	int home_node;
	union {
		nodemask_t cpuset_mems_allowed;
		nodemask_t user_nodemask;
	} w;
};

struct ppc64_tlb_batch {
	int active;
	long unsigned int index;
	struct mm_struct *mm;
	real_pte_t pte[192];
	long unsigned int vpn[192];
	unsigned int psize;
	int ssize;
};

struct stress_hpt_struct {
	long unsigned int last_group[16];
};

typedef void (*rcu_callback_t)(struct callback_head *);

enum {
	FOLL_WRITE = 1,
	FOLL_GET = 2,
	FOLL_DUMP = 4,
	FOLL_FORCE = 8,
	FOLL_NOWAIT = 16,
	FOLL_NOFAULT = 32,
	FOLL_HWPOISON = 64,
	FOLL_ANON = 128,
	FOLL_LONGTERM = 256,
	FOLL_SPLIT_PMD = 512,
	FOLL_PCI_P2PDMA = 1024,
	FOLL_INTERRUPTIBLE = 2048,
	FOLL_HONOR_NUMA_FAULT = 4096,
};

enum migrate_reason {
	MR_COMPACTION = 0,
	MR_MEMORY_FAILURE = 1,
	MR_MEMORY_HOTPLUG = 2,
	MR_SYSCALL = 3,
	MR_MEMPOLICY_MBIND = 4,
	MR_NUMA_MISPLACED = 5,
	MR_CONTIG_RANGE = 6,
	MR_LONGTERM_PIN = 7,
	MR_DEMOTION = 8,
	MR_TYPES = 9,
};

struct mm_iommu_table_group_mem_t {
	struct list_head next;
	struct callback_head rcu;
	long unsigned int used;
	atomic64_t mapped;
	unsigned int pageshift;
	u64 ua;
	u64 entries;
	union {
		struct page **hpages;
		phys_addr_t *hpas;
	};
	u64 dev_hpa;
};

typedef long unsigned int pte_basic_t;

typedef struct {
	pgd_t pgd;
} p4d_t;

struct encoded_page;

struct vm_struct {
	struct vm_struct *next;
	void *addr;
	long unsigned int size;
	long unsigned int flags;
	struct page **pages;
	unsigned int page_order;
	unsigned int nr_pages;
	phys_addr_t phys_addr;
	const void *caller;
};

enum cpuhp_state {
	CPUHP_INVALID = -1,
	CPUHP_OFFLINE = 0,
	CPUHP_CREATE_THREADS = 1,
	CPUHP_PERF_PREPARE = 2,
	CPUHP_PERF_X86_PREPARE = 3,
	CPUHP_PERF_X86_AMD_UNCORE_PREP = 4,
	CPUHP_PERF_POWER = 5,
	CPUHP_PERF_SUPERH = 6,
	CPUHP_X86_HPET_DEAD = 7,
	CPUHP_X86_APB_DEAD = 8,
	CPUHP_X86_MCE_DEAD = 9,
	CPUHP_VIRT_NET_DEAD = 10,
	CPUHP_IBMVNIC_DEAD = 11,
	CPUHP_SLUB_DEAD = 12,
	CPUHP_DEBUG_OBJ_DEAD = 13,
	CPUHP_MM_WRITEBACK_DEAD = 14,
	CPUHP_MM_DEMOTION_DEAD = 15,
	CPUHP_MM_VMSTAT_DEAD = 16,
	CPUHP_SOFTIRQ_DEAD = 17,
	CPUHP_NET_MVNETA_DEAD = 18,
	CPUHP_CPUIDLE_DEAD = 19,
	CPUHP_ARM64_FPSIMD_DEAD = 20,
	CPUHP_ARM_OMAP_WAKE_DEAD = 21,
	CPUHP_IRQ_POLL_DEAD = 22,
	CPUHP_BLOCK_SOFTIRQ_DEAD = 23,
	CPUHP_BIO_DEAD = 24,
	CPUHP_ACPI_CPUDRV_DEAD = 25,
	CPUHP_S390_PFAULT_DEAD = 26,
	CPUHP_BLK_MQ_DEAD = 27,
	CPUHP_FS_BUFF_DEAD = 28,
	CPUHP_PRINTK_DEAD = 29,
	CPUHP_MM_MEMCQ_DEAD = 30,
	CPUHP_PERCPU_CNT_DEAD = 31,
	CPUHP_RADIX_DEAD = 32,
	CPUHP_PAGE_ALLOC = 33,
	CPUHP_NET_DEV_DEAD = 34,
	CPUHP_PCI_XGENE_DEAD = 35,
	CPUHP_IOMMU_IOVA_DEAD = 36,
	CPUHP_LUSTRE_CFS_DEAD = 37,
	CPUHP_AP_ARM_CACHE_B15_RAC_DEAD = 38,
	CPUHP_PADATA_DEAD = 39,
	CPUHP_AP_DTPM_CPU_DEAD = 40,
	CPUHP_RANDOM_PREPARE = 41,
	CPUHP_WORKQUEUE_PREP = 42,
	CPUHP_POWER_NUMA_PREPARE = 43,
	CPUHP_HRTIMERS_PREPARE = 44,
	CPUHP_PROFILE_PREPARE = 45,
	CPUHP_X2APIC_PREPARE = 46,
	CPUHP_SMPCFD_PREPARE = 47,
	CPUHP_RELAY_PREPARE = 48,
	CPUHP_SLAB_PREPARE = 49,
	CPUHP_MD_RAID5_PREPARE = 50,
	CPUHP_RCUTREE_PREP = 51,
	CPUHP_CPUIDLE_COUPLED_PREPARE = 52,
	CPUHP_POWERPC_PMAC_PREPARE = 53,
	CPUHP_POWERPC_MMU_CTX_PREPARE = 54,
	CPUHP_XEN_PREPARE = 55,
	CPUHP_XEN_EVTCHN_PREPARE = 56,
	CPUHP_ARM_SHMOBILE_SCU_PREPARE = 57,
	CPUHP_SH_SH3X_PREPARE = 58,
	CPUHP_NET_FLOW_PREPARE = 59,
	CPUHP_TOPOLOGY_PREPARE = 60,
	CPUHP_NET_IUCV_PREPARE = 61,
	CPUHP_ARM_BL_PREPARE = 62,
	CPUHP_TRACE_RB_PREPARE = 63,
	CPUHP_MM_ZS_PREPARE = 64,
	CPUHP_MM_ZSWP_MEM_PREPARE = 65,
	CPUHP_MM_ZSWP_POOL_PREPARE = 66,
	CPUHP_KVM_PPC_BOOK3S_PREPARE = 67,
	CPUHP_ZCOMP_PREPARE = 68,
	CPUHP_TIMERS_PREPARE = 69,
	CPUHP_MIPS_SOC_PREPARE = 70,
	CPUHP_BP_PREPARE_DYN = 71,
	CPUHP_BP_PREPARE_DYN_END = 91,
	CPUHP_BP_KICK_AP = 92,
	CPUHP_BRINGUP_CPU = 93,
	CPUHP_AP_IDLE_DEAD = 94,
	CPUHP_AP_OFFLINE = 95,
	CPUHP_AP_CACHECTRL_STARTING = 96,
	CPUHP_AP_SCHED_STARTING = 97,
	CPUHP_AP_RCUTREE_DYING = 98,
	CPUHP_AP_CPU_PM_STARTING = 99,
	CPUHP_AP_IRQ_GIC_STARTING = 100,
	CPUHP_AP_IRQ_HIP04_STARTING = 101,
	CPUHP_AP_IRQ_APPLE_AIC_STARTING = 102,
	CPUHP_AP_IRQ_ARMADA_XP_STARTING = 103,
	CPUHP_AP_IRQ_BCM2836_STARTING = 104,
	CPUHP_AP_IRQ_MIPS_GIC_STARTING = 105,
	CPUHP_AP_IRQ_RISCV_STARTING = 106,
	CPUHP_AP_IRQ_LOONGARCH_STARTING = 107,
	CPUHP_AP_IRQ_SIFIVE_PLIC_STARTING = 108,
	CPUHP_AP_ARM_MVEBU_COHERENCY = 109,
	CPUHP_AP_MICROCODE_LOADER = 110,
	CPUHP_AP_PERF_X86_AMD_UNCORE_STARTING = 111,
	CPUHP_AP_PERF_X86_STARTING = 112,
	CPUHP_AP_PERF_X86_AMD_IBS_STARTING = 113,
	CPUHP_AP_PERF_X86_CQM_STARTING = 114,
	CPUHP_AP_PERF_X86_CSTATE_STARTING = 115,
	CPUHP_AP_PERF_XTENSA_STARTING = 116,
	CPUHP_AP_MIPS_OP_LOONGSON3_STARTING = 117,
	CPUHP_AP_ARM_VFP_STARTING = 118,
	CPUHP_AP_ARM64_DEBUG_MONITORS_STARTING = 119,
	CPUHP_AP_PERF_ARM_HW_BREAKPOINT_STARTING = 120,
	CPUHP_AP_PERF_ARM_ACPI_STARTING = 121,
	CPUHP_AP_PERF_ARM_STARTING = 122,
	CPUHP_AP_PERF_RISCV_STARTING = 123,
	CPUHP_AP_ARM_L2X0_STARTING = 124,
	CPUHP_AP_EXYNOS4_MCT_TIMER_STARTING = 125,
	CPUHP_AP_ARM_ARCH_TIMER_STARTING = 126,
	CPUHP_AP_ARM_GLOBAL_TIMER_STARTING = 127,
	CPUHP_AP_JCORE_TIMER_STARTING = 128,
	CPUHP_AP_ARM_TWD_STARTING = 129,
	CPUHP_AP_QCOM_TIMER_STARTING = 130,
	CPUHP_AP_TEGRA_TIMER_STARTING = 131,
	CPUHP_AP_ARMADA_TIMER_STARTING = 132,
	CPUHP_AP_MARCO_TIMER_STARTING = 133,
	CPUHP_AP_MIPS_GIC_TIMER_STARTING = 134,
	CPUHP_AP_ARC_TIMER_STARTING = 135,
	CPUHP_AP_RISCV_TIMER_STARTING = 136,
	CPUHP_AP_CLINT_TIMER_STARTING = 137,
	CPUHP_AP_CSKY_TIMER_STARTING = 138,
	CPUHP_AP_TI_GP_TIMER_STARTING = 139,
	CPUHP_AP_HYPERV_TIMER_STARTING = 140,
	CPUHP_AP_DUMMY_TIMER_STARTING = 141,
	CPUHP_AP_ARM_XEN_STARTING = 142,
	CPUHP_AP_ARM_CORESIGHT_STARTING = 143,
	CPUHP_AP_ARM_CORESIGHT_CTI_STARTING = 144,
	CPUHP_AP_ARM64_ISNDEP_STARTING = 145,
	CPUHP_AP_SMPCFD_DYING = 146,
	CPUHP_AP_X86_TBOOT_DYING = 147,
	CPUHP_AP_ARM_CACHE_B15_RAC_DYING = 148,
	CPUHP_AP_ONLINE = 149,
	CPUHP_TEARDOWN_CPU = 150,
	CPUHP_AP_ONLINE_IDLE = 151,
	CPUHP_AP_HYPERV_ONLINE = 152,
	CPUHP_AP_KVM_ONLINE = 153,
	CPUHP_AP_SCHED_WAIT_EMPTY = 154,
	CPUHP_AP_SMPBOOT_THREADS = 155,
	CPUHP_AP_X86_VDSO_VMA_ONLINE = 156,
	CPUHP_AP_IRQ_AFFINITY_ONLINE = 157,
	CPUHP_AP_BLK_MQ_ONLINE = 158,
	CPUHP_AP_ARM_MVEBU_SYNC_CLOCKS = 159,
	CPUHP_AP_X86_INTEL_EPB_ONLINE = 160,
	CPUHP_AP_PERF_ONLINE = 161,
	CPUHP_AP_PERF_X86_ONLINE = 162,
	CPUHP_AP_PERF_X86_UNCORE_ONLINE = 163,
	CPUHP_AP_PERF_X86_AMD_UNCORE_ONLINE = 164,
	CPUHP_AP_PERF_X86_AMD_POWER_ONLINE = 165,
	CPUHP_AP_PERF_X86_RAPL_ONLINE = 166,
	CPUHP_AP_PERF_X86_CQM_ONLINE = 167,
	CPUHP_AP_PERF_X86_CSTATE_ONLINE = 168,
	CPUHP_AP_PERF_X86_IDXD_ONLINE = 169,
	CPUHP_AP_PERF_S390_CF_ONLINE = 170,
	CPUHP_AP_PERF_S390_SF_ONLINE = 171,
	CPUHP_AP_PERF_ARM_CCI_ONLINE = 172,
	CPUHP_AP_PERF_ARM_CCN_ONLINE = 173,
	CPUHP_AP_PERF_ARM_HISI_CPA_ONLINE = 174,
	CPUHP_AP_PERF_ARM_HISI_DDRC_ONLINE = 175,
	CPUHP_AP_PERF_ARM_HISI_HHA_ONLINE = 176,
	CPUHP_AP_PERF_ARM_HISI_L3_ONLINE = 177,
	CPUHP_AP_PERF_ARM_HISI_PA_ONLINE = 178,
	CPUHP_AP_PERF_ARM_HISI_SLLC_ONLINE = 179,
	CPUHP_AP_PERF_ARM_HISI_PCIE_PMU_ONLINE = 180,
	CPUHP_AP_PERF_ARM_HNS3_PMU_ONLINE = 181,
	CPUHP_AP_PERF_ARM_L2X0_ONLINE = 182,
	CPUHP_AP_PERF_ARM_QCOM_L2_ONLINE = 183,
	CPUHP_AP_PERF_ARM_QCOM_L3_ONLINE = 184,
	CPUHP_AP_PERF_ARM_APM_XGENE_ONLINE = 185,
	CPUHP_AP_PERF_ARM_CAVIUM_TX2_UNCORE_ONLINE = 186,
	CPUHP_AP_PERF_ARM_MARVELL_CN10K_DDR_ONLINE = 187,
	CPUHP_AP_PERF_POWERPC_NEST_IMC_ONLINE = 188,
	CPUHP_AP_PERF_POWERPC_CORE_IMC_ONLINE = 189,
	CPUHP_AP_PERF_POWERPC_THREAD_IMC_ONLINE = 190,
	CPUHP_AP_PERF_POWERPC_TRACE_IMC_ONLINE = 191,
	CPUHP_AP_PERF_POWERPC_HV_24x7_ONLINE = 192,
	CPUHP_AP_PERF_POWERPC_HV_GPCI_ONLINE = 193,
	CPUHP_AP_PERF_CSKY_ONLINE = 194,
	CPUHP_AP_WATCHDOG_ONLINE = 195,
	CPUHP_AP_WORKQUEUE_ONLINE = 196,
	CPUHP_AP_RANDOM_ONLINE = 197,
	CPUHP_AP_RCUTREE_ONLINE = 198,
	CPUHP_AP_BASE_CACHEINFO_ONLINE = 199,
	CPUHP_AP_ONLINE_DYN = 200,
	CPUHP_AP_ONLINE_DYN_END = 230,
	CPUHP_AP_MM_DEMOTION_ONLINE = 231,
	CPUHP_AP_X86_HPET_ONLINE = 232,
	CPUHP_AP_X86_KVM_CLK_ONLINE = 233,
	CPUHP_AP_ACTIVE = 234,
	CPUHP_ONLINE = 235,
};

struct mmu_table_batch {
	struct callback_head rcu;
	unsigned int nr;
	void *tables[0];
};

struct mmu_gather_batch {
	struct mmu_gather_batch *next;
	unsigned int nr;
	unsigned int max;
	struct encoded_page *encoded_pages[0];
};

struct mmu_gather {
	struct mm_struct *mm;
	struct mmu_table_batch *batch;
	long unsigned int start;
	long unsigned int end;
	unsigned int fullmm: 1;
	unsigned int need_flush_all: 1;
	unsigned int freed_tables: 1;
	unsigned int delayed_rmap: 1;
	unsigned int cleared_ptes: 1;
	unsigned int cleared_pmds: 1;
	unsigned int cleared_puds: 1;
	unsigned int cleared_p4ds: 1;
	unsigned int vma_exec: 1;
	unsigned int vma_huge: 1;
	unsigned int vma_pfn: 1;
	unsigned int batch_count;
	struct mmu_gather_batch *active;
	struct mmu_gather_batch local;
	struct page *__pages[8];
	unsigned int page_size;
};

struct patch_context {
	union {
		struct vm_struct *area;
		struct mm_struct *mm;
	};
	long unsigned int addr;
	pte_t *pte;
};

typedef long unsigned int irq_hw_number_t;

enum irqreturn {
	IRQ_NONE = 0,
	IRQ_HANDLED = 1,
	IRQ_WAKE_THREAD = 2,
};

typedef enum irqreturn irqreturn_t;

struct smp_ops_t {
	void (*message_pass)(int, int);
	void (*cause_ipi)(int);
	int (*cause_nmi_ipi)(int);
	void (*probe)();
	int (*kick_cpu)(int);
	int (*prepare_cpu)(int);
	void (*setup_cpu)(int);
	void (*bringup_done)();
	void (*take_timebase)();
	void (*give_timebase)();
	int (*cpu_disable)();
	void (*cpu_die)(unsigned int);
	int (*cpu_bootable)(unsigned int);
	void (*cpu_offline_self)();
};

struct irq_desc;

typedef void (*irq_flow_handler_t)(struct irq_desc *);

struct msi_desc;

struct irq_common_data {
	unsigned int state_use_accessors;
	unsigned int node;
	void *handler_data;
	struct msi_desc *msi_desc;
	cpumask_var_t affinity;
};

struct irq_chip;

struct irq_data {
	u32 mask;
	unsigned int irq;
	long unsigned int hwirq;
	struct irq_common_data *common;
	struct irq_chip *chip;
	struct irq_domain *domain;
	struct irq_data *parent_data;
	void *chip_data;
};

struct irqaction;

struct irq_affinity_notify;

struct irq_desc {
	struct irq_common_data irq_common_data;
	struct irq_data irq_data;
	unsigned int *kstat_irqs;
	irq_flow_handler_t handle_irq;
	struct irqaction *action;
	unsigned int status_use_accessors;
	unsigned int core_internal_state__do_not_mess_with_it;
	unsigned int depth;
	unsigned int wake_depth;
	unsigned int tot_count;
	unsigned int irq_count;
	long unsigned int last_unhandled;
	unsigned int irqs_unhandled;
	atomic_t threads_handled;
	int threads_handled_last;
	raw_spinlock_t lock;
	struct cpumask *percpu_enabled;
	const struct cpumask *percpu_affinity;
	const struct cpumask *affinity_hint;
	struct irq_affinity_notify *affinity_notify;
	long unsigned int threads_oneshot;
	atomic_t threads_active;
	wait_queue_head_t wait_for_threads;
	unsigned int nr_actions;
	unsigned int no_suspend_depth;
	unsigned int cond_suspend_depth;
	unsigned int force_resume_depth;
	struct proc_dir_entry *dir;
	struct callback_head rcu;
	struct kobject kobj;
	struct mutex request_mutex;
	int parent_irq;
	struct module *owner;
	const char *name;
	struct hlist_node resend_node;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

enum irq_domain_bus_token {
	DOMAIN_BUS_ANY = 0,
	DOMAIN_BUS_WIRED = 1,
	DOMAIN_BUS_GENERIC_MSI = 2,
	DOMAIN_BUS_PCI_MSI = 3,
	DOMAIN_BUS_PLATFORM_MSI = 4,
	DOMAIN_BUS_NEXUS = 5,
	DOMAIN_BUS_IPI = 6,
	DOMAIN_BUS_FSL_MC_MSI = 7,
	DOMAIN_BUS_TI_SCI_INTA_MSI = 8,
	DOMAIN_BUS_WAKEUP = 9,
	DOMAIN_BUS_VMD_MSI = 10,
	DOMAIN_BUS_PCI_DEVICE_MSI = 11,
	DOMAIN_BUS_PCI_DEVICE_MSIX = 12,
	DOMAIN_BUS_DMAR = 13,
	DOMAIN_BUS_AMDVI = 14,
	DOMAIN_BUS_PCI_DEVICE_IMS = 15,
};

struct irq_domain_ops;

struct irq_domain_chip_generic;

struct msi_parent_ops;

struct irq_domain {
	struct list_head link;
	const char *name;
	const struct irq_domain_ops *ops;
	void *host_data;
	unsigned int flags;
	unsigned int mapcount;
	struct mutex mutex;
	struct irq_domain *root;
	struct fwnode_handle *fwnode;
	enum irq_domain_bus_token bus_token;
	struct irq_domain_chip_generic *gc;
	struct device *dev;
	struct device *pm_dev;
	struct irq_domain *parent;
	const struct msi_parent_ops *msi_parent_ops;
	irq_hw_number_t hwirq_max;
	unsigned int revmap_size;
	struct xarray revmap_tree;
	struct irq_data *revmap[0];
};

enum {
	IRQ_TYPE_NONE = 0,
	IRQ_TYPE_EDGE_RISING = 1,
	IRQ_TYPE_EDGE_FALLING = 2,
	IRQ_TYPE_EDGE_BOTH = 3,
	IRQ_TYPE_LEVEL_HIGH = 4,
	IRQ_TYPE_LEVEL_LOW = 8,
	IRQ_TYPE_LEVEL_MASK = 12,
	IRQ_TYPE_SENSE_MASK = 15,
	IRQ_TYPE_DEFAULT = 15,
	IRQ_TYPE_PROBE = 16,
	IRQ_LEVEL = 256,
	IRQ_PER_CPU = 512,
	IRQ_NOPROBE = 1024,
	IRQ_NOREQUEST = 2048,
	IRQ_NOAUTOEN = 4096,
	IRQ_NO_BALANCING = 8192,
	IRQ_MOVE_PCNTXT = 16384,
	IRQ_NESTED_THREAD = 32768,
	IRQ_NOTHREAD = 65536,
	IRQ_PER_CPU_DEVID = 131072,
	IRQ_IS_POLLED = 262144,
	IRQ_DISABLE_UNLAZY = 524288,
	IRQ_HIDDEN = 1048576,
	IRQ_NO_DEBUG = 2097152,
};

enum {
	IRQ_SET_MASK_OK = 0,
	IRQ_SET_MASK_OK_NOCOPY = 1,
	IRQ_SET_MASK_OK_DONE = 2,
};

enum irqchip_irq_state {
	IRQCHIP_STATE_PENDING = 0,
	IRQCHIP_STATE_ACTIVE = 1,
	IRQCHIP_STATE_MASKED = 2,
	IRQCHIP_STATE_LINE_LEVEL = 3,
};

struct msi_msg;

struct irq_chip {
	const char *name;
	unsigned int (*irq_startup)(struct irq_data *);
	void (*irq_shutdown)(struct irq_data *);
	void (*irq_enable)(struct irq_data *);
	void (*irq_disable)(struct irq_data *);
	void (*irq_ack)(struct irq_data *);
	void (*irq_mask)(struct irq_data *);
	void (*irq_mask_ack)(struct irq_data *);
	void (*irq_unmask)(struct irq_data *);
	void (*irq_eoi)(struct irq_data *);
	int (*irq_set_affinity)(struct irq_data *, const struct cpumask *, bool);
	int (*irq_retrigger)(struct irq_data *);
	int (*irq_set_type)(struct irq_data *, unsigned int);
	int (*irq_set_wake)(struct irq_data *, unsigned int);
	void (*irq_bus_lock)(struct irq_data *);
	void (*irq_bus_sync_unlock)(struct irq_data *);
	void (*irq_suspend)(struct irq_data *);
	void (*irq_resume)(struct irq_data *);
	void (*irq_pm_shutdown)(struct irq_data *);
	void (*irq_calc_mask)(struct irq_data *);
	void (*irq_print_chip)(struct irq_data *, struct seq_file *);
	int (*irq_request_resources)(struct irq_data *);
	void (*irq_release_resources)(struct irq_data *);
	void (*irq_compose_msi_msg)(struct irq_data *, struct msi_msg *);
	void (*irq_write_msi_msg)(struct irq_data *, struct msi_msg *);
	int (*irq_get_irqchip_state)(struct irq_data *, enum irqchip_irq_state, bool *);
	int (*irq_set_irqchip_state)(struct irq_data *, enum irqchip_irq_state, bool);
	int (*irq_set_vcpu_affinity)(struct irq_data *, void *);
	void (*ipi_send_single)(struct irq_data *, unsigned int);
	void (*ipi_send_mask)(struct irq_data *, const struct cpumask *);
	int (*irq_nmi_setup)(struct irq_data *);
	void (*irq_nmi_teardown)(struct irq_data *);
	long unsigned int flags;
};

enum {
	IRQD_TRIGGER_MASK = 15,
	IRQD_SETAFFINITY_PENDING = 256,
	IRQD_ACTIVATED = 512,
	IRQD_NO_BALANCING = 1024,
	IRQD_PER_CPU = 2048,
	IRQD_AFFINITY_SET = 4096,
	IRQD_LEVEL = 8192,
	IRQD_WAKEUP_STATE = 16384,
	IRQD_MOVE_PCNTXT = 32768,
	IRQD_IRQ_DISABLED = 65536,
	IRQD_IRQ_MASKED = 131072,
	IRQD_IRQ_INPROGRESS = 262144,
	IRQD_WAKEUP_ARMED = 524288,
	IRQD_FORWARDED_TO_VCPU = 1048576,
	IRQD_AFFINITY_MANAGED = 2097152,
	IRQD_IRQ_STARTED = 4194304,
	IRQD_MANAGED_SHUTDOWN = 8388608,
	IRQD_SINGLE_TARGET = 16777216,
	IRQD_DEFAULT_TRIGGER_SET = 33554432,
	IRQD_CAN_RESERVE = 67108864,
	IRQD_MSI_NOMASK_QUIRK = 134217728,
	IRQD_HANDLE_ENFORCE_IRQCTX = 268435456,
	IRQD_AFFINITY_ON_ACTIVATE = 536870912,
	IRQD_IRQ_ENABLED_ON_SUSPEND = 1073741824,
	IRQD_RESEND_WHEN_IN_PROGRESS = 2147483648,
};

typedef irqreturn_t (*irq_handler_t)(int, void *);

struct irqaction {
	irq_handler_t handler;
	void *dev_id;
	void *percpu_dev_id;
	struct irqaction *next;
	irq_handler_t thread_fn;
	struct task_struct *thread;
	struct irqaction *secondary;
	unsigned int irq;
	unsigned int flags;
	long unsigned int thread_flags;
	long unsigned int thread_mask;
	const char *name;
	struct proc_dir_entry *dir;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct irq_affinity_notify {
	unsigned int irq;
	struct kref kref;
	struct work_struct work;
	void (*notify)(struct irq_affinity_notify *, const cpumask_t *);
	void (*release)(struct kref *);
};

struct irq_chip_regs {
	long unsigned int enable;
	long unsigned int disable;
	long unsigned int mask;
	long unsigned int ack;
	long unsigned int eoi;
	long unsigned int type;
	long unsigned int polarity;
};

struct irq_chip_type {
	struct irq_chip chip;
	struct irq_chip_regs regs;
	irq_flow_handler_t handler;
	u32 type;
	u32 mask_cache_priv;
	u32 *mask_cache;
};

struct irq_chip_generic {
	raw_spinlock_t lock;
	void *reg_base;
	u32 (*reg_readl)(void *);
	void (*reg_writel)(u32, void *);
	void (*suspend)(struct irq_chip_generic *);
	void (*resume)(struct irq_chip_generic *);
	unsigned int irq_base;
	unsigned int irq_cnt;
	u32 mask_cache;
	u32 type_cache;
	u32 polarity_cache;
	u32 wake_enabled;
	u32 wake_active;
	unsigned int num_ct;
	void *private;
	long unsigned int installed;
	long unsigned int unused;
	struct irq_domain *domain;
	struct list_head list;
	struct irq_chip_type chip_types[0];
};

enum irq_gc_flags {
	IRQ_GC_INIT_MASK_CACHE = 1,
	IRQ_GC_INIT_NESTED_LOCK = 2,
	IRQ_GC_MASK_CACHE_PER_TYPE = 4,
	IRQ_GC_NO_MASK = 8,
	IRQ_GC_BE_IO = 16,
};

struct irq_domain_chip_generic {
	unsigned int irqs_per_chip;
	unsigned int num_chips;
	unsigned int irq_flags_to_clear;
	unsigned int irq_flags_to_set;
	enum irq_gc_flags gc_flags;
	struct irq_chip_generic *gc[0];
};

struct irq_fwspec {
	struct fwnode_handle *fwnode;
	int param_count;
	u32 param[16];
};

struct irq_domain_ops {
	int (*match)(struct irq_domain *, struct device_node *, enum irq_domain_bus_token);
	int (*select)(struct irq_domain *, struct irq_fwspec *, enum irq_domain_bus_token);
	int (*map)(struct irq_domain *, unsigned int, irq_hw_number_t);
	void (*unmap)(struct irq_domain *, unsigned int);
	int (*xlate)(struct irq_domain *, struct device_node *, const u32 *, unsigned int, long unsigned int *, unsigned int *);
	int (*alloc)(struct irq_domain *, unsigned int, unsigned int, void *);
	void (*free)(struct irq_domain *, unsigned int, unsigned int);
	int (*activate)(struct irq_domain *, struct irq_data *, bool);
	void (*deactivate)(struct irq_domain *, struct irq_data *);
	int (*translate)(struct irq_domain *, struct irq_fwspec *, long unsigned int *, unsigned int *);
};

struct msi_domain_info;

struct msi_parent_ops {
	u32 supported_flags;
	const char *prefix;
	bool (*init_dev_msi_info)(struct device *, struct irq_domain *, struct irq_domain *, struct msi_domain_info *);
};

enum {
	IRQCHIP_FWNODE_REAL = 0,
	IRQCHIP_FWNODE_NAMED = 1,
	IRQCHIP_FWNODE_NAMED_ID = 2,
};

struct irq_affinity_desc {
	struct cpumask mask;
	unsigned int is_managed: 1;
};

struct icp_ops {
	unsigned int (*get_irq)();
	void (*eoi)(struct irq_data *);
	void (*set_priority)(unsigned char);
	void (*teardown_cpu)();
	void (*flush_ipi)();
	void (*cause_ipi)(int);
	irq_handler_t ipi_action;
};

struct ics {
	struct list_head link;
	int (*check)(struct ics *, unsigned int);
	void (*mask_unknown)(struct ics *, long unsigned int);
	long int (*get_server)(struct ics *, long unsigned int);
	int (*host_match)(struct ics *, struct device_node *);
	struct irq_chip *chip;
	char data[0];
};

struct xics_cppr {
	unsigned char stack[3];
	int index;
};

typedef s64 int64_t;

struct kvm;

struct kvmppc_vcore {
	int n_runnable;
	int num_threads;
	int entry_exit_map;
	int napping_threads;
	int first_vcpuid;
	u16 pcpu;
	u16 last_cpu;
	u8 vcore_state;
	u8 in_guest;
	struct kvm_vcpu *runnable_threads[8];
	struct list_head preempt_list;
	spinlock_t lock;
	struct rcuwait wait;
	spinlock_t stoltb_lock;
	u64 stolen_tb;
	u64 preempt_tb;
	struct kvm_vcpu *runner;
	struct kvm *kvm;
	u64 tb_offset;
	u64 tb_offset_applied;
	ulong lpcr;
	u32 arch_compat;
	ulong pcr;
	ulong dpdes;
	ulong vtb;
	ulong conferring_threads;
	unsigned int halt_poll_ns;
	atomic_t online_count;
};

struct preempt_ops;

struct preempt_notifier {
	struct hlist_node link;
	struct preempt_ops *ops;
};

typedef u64 gpa_t;

struct kvm_mmio_fragment {
	gpa_t gpa;
	void *data;
	unsigned int len;
};

struct kvmppc_slb {
	u64 esid;
	u64 vsid;
	u64 orige;
	u64 origv;
	bool valid: 1;
	bool Ks: 1;
	bool Kp: 1;
	bool nx: 1;
	bool large: 1;
	bool tb: 1;
	bool class: 1;
	u8 base_page_size;
};

typedef long unsigned int gva_t;

struct kvmppc_pte;

struct kvmppc_mmu {
	void (*slbmte)(struct kvm_vcpu *, u64, u64);
	u64 (*slbmfee)(struct kvm_vcpu *, u64);
	u64 (*slbmfev)(struct kvm_vcpu *, u64);
	int (*slbfee)(struct kvm_vcpu *, gva_t, ulong *);
	void (*slbie)(struct kvm_vcpu *, u64);
	void (*slbia)(struct kvm_vcpu *);
	void (*mtsrin)(struct kvm_vcpu *, u32, ulong);
	u32 (*mfsrin)(struct kvm_vcpu *, u32);
	int (*xlate)(struct kvm_vcpu *, gva_t, struct kvmppc_pte *, bool, bool);
	void (*tlbie)(struct kvm_vcpu *, ulong, bool);
	int (*esid_to_vsid)(struct kvm_vcpu *, ulong, u64 *);
	u64 (*ea_to_vp)(struct kvm_vcpu *, gva_t, bool);
	bool (*is_dcbz32)(struct kvm_vcpu *);
};

struct openpic;

union xive_tma_w01 {
	struct {
		u8 nsr;
		u8 cppr;
		u8 ipb;
		u8 lsmfb;
		u8 ack;
		u8 inc;
		u8 age;
		u8 pipr;
	};
	__be64 w01;
};

struct kvm_vcpu_arch_shared {
	__u64 scratch1;
	__u64 scratch2;
	__u64 scratch3;
	__u64 critical;
	__u64 sprg0;
	__u64 sprg1;
	__u64 sprg2;
	__u64 sprg3;
	__u64 srr0;
	__u64 srr1;
	__u64 dar;
	__u64 msr;
	__u32 dsisr;
	__u32 int_pending;
	__u32 sr[16];
	__u32 mas0;
	__u32 mas1;
	__u64 mas7_3;
	__u64 mas2;
	__u32 mas4;
	__u32 mas6;
	__u32 esr;
	__u32 pir;
	__u64 sprg4;
	__u64 sprg5;
	__u64 sprg6;
	__u64 sprg7;
};

struct mmio_hpte_cache_entry {
	long unsigned int hpte_v;
	long unsigned int hpte_r;
	long unsigned int rpte;
	long unsigned int pte_index;
	long unsigned int eaddr;
	long unsigned int slb_v;
	long int mmio_update;
	unsigned int slb_base_pshift;
};

struct mmio_hpte_cache {
	struct mmio_hpte_cache_entry entry[4];
	unsigned int index;
};

struct kvmppc_vpa {
	long unsigned int gpa;
	void *pinned_addr;
	void *pinned_end;
	long unsigned int next_gpa;
	long unsigned int len;
	u8 update_pending;
	bool dirty;
};

struct kvmppc_vcpu_book3s;

struct kvmppc_icp;

struct kvmppc_xive_vcpu;

struct kvm_nested_guest;

struct kvm_vcpu_arch {
	ulong host_stack;
	u32 host_pid;
	struct kvmppc_slb slb[64];
	int slb_max;
	int slb_nr;
	struct kvmppc_mmu mmu;
	struct kvmppc_vcpu_book3s *book3s;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct pt_regs regs;
	struct thread_fp_state fp;
	struct thread_vr_state vr;
	u32 qpr[32];
	ulong tar;
	ulong hflags;
	ulong guest_owned_ext;
	ulong purr;
	ulong spurr;
	ulong ic;
	ulong dscr;
	ulong amr;
	ulong uamor;
	ulong iamr;
	u32 ctrl;
	u32 dabrx;
	ulong dabr;
	ulong dawr0;
	ulong dawrx0;
	ulong dawr1;
	ulong dawrx1;
	ulong ciabr;
	ulong cfar;
	ulong ppr;
	u32 pspb;
	u8 load_ebb;
	u8 load_tm;
	ulong fscr;
	ulong shadow_fscr;
	ulong ebbhr;
	ulong ebbrr;
	ulong bescr;
	ulong csigr;
	ulong tacr;
	ulong tcscr;
	ulong acop;
	ulong wort;
	ulong tid;
	ulong psscr;
	ulong hfscr;
	ulong shadow_srr1;
	u32 vrsave;
	u32 mmucr;
	ulong shadow_msr;
	ulong csrr0;
	ulong csrr1;
	ulong dsrr0;
	ulong dsrr1;
	ulong mcsrr0;
	ulong mcsrr1;
	ulong mcsr;
	ulong dec;
	u64 entry_tb;
	u64 entry_vtb;
	u64 entry_ic;
	u32 tcr;
	ulong tsr;
	u32 ivor[64];
	ulong ivpr;
	u32 pvr;
	u32 shadow_pid;
	u32 shadow_pid1;
	u32 pid;
	u32 swap_pid;
	u32 ccr0;
	u32 ccr1;
	u32 dbsr;
	u64 mmcr[4];
	u64 mmcra;
	u64 mmcrs;
	u32 pmc[8];
	u32 spmc[2];
	u64 siar;
	u64 sdar;
	u64 sier[3];
	u64 tfhar;
	u64 texasr;
	u64 tfiar;
	u64 orig_texasr;
	u32 cr_tm;
	u64 xer_tm;
	u64 lr_tm;
	u64 ctr_tm;
	u64 amr_tm;
	u64 ppr_tm;
	u64 dscr_tm;
	u64 tar_tm;
	ulong gpr_tm[32];
	struct thread_fp_state fp_tm;
	struct thread_vr_state vr_tm;
	u32 vrsave_tm;
	ulong fault_dar;
	u32 fault_dsisr;
	long unsigned int intr_msr;
	ulong fault_gpa;
	gpa_t paddr_accessed;
	gva_t vaddr_accessed;
	pgd_t *pgdir;
	u16 io_gpr;
	u8 mmio_host_swabbed;
	u8 mmio_sign_extend;
	u8 mmio_sp64_extend;
	u8 mmio_vsx_copy_nums;
	u8 mmio_vsx_offset;
	u8 mmio_vmx_copy_nums;
	u8 mmio_vmx_offset;
	u8 mmio_copy_type;
	u8 osi_needed;
	u8 osi_enabled;
	u8 papr_enabled;
	u8 watchdog_enabled;
	u8 sane;
	u8 cpu_type;
	u8 hcall_needed;
	u8 epr_flags;
	u8 epr_needed;
	u8 external_oneshot;
	u32 cpr0_cfgaddr;
	struct hrtimer dec_timer;
	u64 dec_jiffies;
	u64 dec_expires;
	long unsigned int pending_exceptions;
	u8 ceded;
	u8 prodded;
	u8 doorbell_request;
	u8 irq_pending;
	long unsigned int last_inst;
	struct rcuwait wait;
	struct rcuwait *waitp;
	struct kvmppc_vcore *vcore;
	int ret;
	int trap;
	int state;
	int ptid;
	int thread_cpu;
	int prev_cpu;
	bool timer_running;
	wait_queue_head_t cpu_run;
	struct machine_check_event mce_evt;
	struct kvm_vcpu_arch_shared *shared;
	long unsigned int magic_page_pa;
	long unsigned int magic_page_ea;
	bool disable_kernel_nx;
	int irq_type;
	int irq_cpu_id;
	struct openpic *mpic;
	struct kvmppc_icp *icp;
	struct kvmppc_xive_vcpu *xive_vcpu;
	__be32 xive_cam_word;
	u8 xive_pushed;
	u8 xive_esc_on;
	union xive_tma_w01 xive_saved_state;
	u64 xive_esc_raddr;
	u64 xive_esc_vaddr;
	struct kvm_vcpu_arch_shared shregs;
	struct mmio_hpte_cache mmio_cache;
	long unsigned int pgfault_addr;
	long int pgfault_index;
	long unsigned int pgfault_hpte[2];
	struct mmio_hpte_cache_entry *pgfault_cache;
	struct task_struct *run_task;
	spinlock_t vpa_update_lock;
	struct kvmppc_vpa vpa;
	struct kvmppc_vpa dtl;
	struct dtl_entry *dtl_ptr;
	long unsigned int dtl_index;
	u64 stolen_logged;
	struct kvmppc_vpa slb_shadow;
	spinlock_t tbacct_lock;
	u64 busy_stolen;
	u64 busy_preempt;
	u64 emul_inst;
	u32 online;
	u64 hfscr_permitted;
	struct kvm_nested_guest *nested;
	u64 nested_hfscr;
	u32 nested_vcpu_id;
	gpa_t nested_io_gpr;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct kvm_vcpu_stat_generic {
	u64 halt_successful_poll;
	u64 halt_attempted_poll;
	u64 halt_poll_invalid;
	u64 halt_wakeup;
	u64 halt_poll_success_ns;
	u64 halt_poll_fail_ns;
	u64 halt_wait_ns;
	u64 halt_poll_success_hist[32];
	u64 halt_poll_fail_hist[32];
	u64 halt_wait_hist[32];
	u64 blocking;
};

struct kvm_vcpu_stat {
	struct kvm_vcpu_stat_generic generic;
	u64 sum_exits;
	u64 mmio_exits;
	u64 signal_exits;
	u64 light_exits;
	u64 itlb_real_miss_exits;
	u64 itlb_virt_miss_exits;
	u64 dtlb_real_miss_exits;
	u64 dtlb_virt_miss_exits;
	u64 syscall_exits;
	u64 isi_exits;
	u64 dsi_exits;
	u64 emulated_inst_exits;
	u64 dec_exits;
	u64 ext_intr_exits;
	u64 halt_successful_wait;
	u64 dbell_exits;
	u64 gdbell_exits;
	u64 ld;
	u64 st;
	u64 pf_storage;
	u64 pf_instruc;
	u64 sp_storage;
	u64 sp_instruc;
	u64 queue_intr;
	u64 ld_slow;
	u64 st_slow;
	u64 pthru_all;
	u64 pthru_host;
	u64 pthru_bad_aff;
};

struct kvm_dirty_gfn;

struct kvm_dirty_ring {
	u32 dirty_index;
	u32 reset_index;
	u32 size;
	u32 soft_limit;
	struct kvm_dirty_gfn *dirty_gfns;
	int index;
};

struct kvm_run;

struct kvm_memory_slot;

struct kvm_vcpu {
	struct kvm *kvm;
	struct preempt_notifier preempt_notifier;
	int cpu;
	int vcpu_id;
	int vcpu_idx;
	int ____srcu_idx;
	int mode;
	u64 requests;
	long unsigned int guest_debug;
	struct mutex mutex;
	struct kvm_run *run;
	struct pid *pid;
	int sigset_active;
	sigset_t sigset;
	unsigned int halt_poll_ns;
	bool valid_wakeup;
	int mmio_needed;
	int mmio_read_completed;
	int mmio_is_write;
	int mmio_cur_fragment;
	int mmio_nr_fragments;
	struct kvm_mmio_fragment mmio_fragments[2];
	bool preempted;
	bool ready;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct kvm_vcpu_arch arch;
	struct kvm_vcpu_stat stat;
	char stats_id[48];
	struct kvm_dirty_ring dirty_ring;
	struct kvm_memory_slot *last_used_slot;
	u64 last_used_slot_gen;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct preempt_ops {
	void (*sched_in)(struct preempt_notifier *, int);
	void (*sched_out)(struct preempt_notifier *, struct task_struct *);
};

struct device_attribute {
	struct attribute attr;
	ssize_t (*show)(struct device *, struct device_attribute *, char *);
	ssize_t (*store)(struct device *, struct device_attribute *, const char *, size_t);
};

struct msi_dev_domain {
	struct xarray store;
	struct irq_domain *domain;
};

struct platform_msi_priv_data;

struct msi_device_data {
	long unsigned int properties;
	struct platform_msi_priv_data *platform_data;
	struct mutex mutex;
	struct msi_dev_domain __domains[2];
	long unsigned int __iter_idx;
};

struct interval_tree_node {
	struct rb_node rb;
	long unsigned int start;
	long unsigned int last;
	long unsigned int __subtree_last;
};

enum mmu_notifier_event {
	MMU_NOTIFY_UNMAP = 0,
	MMU_NOTIFY_CLEAR = 1,
	MMU_NOTIFY_PROTECTION_VMA = 2,
	MMU_NOTIFY_PROTECTION_PAGE = 3,
	MMU_NOTIFY_SOFT_DIRTY = 4,
	MMU_NOTIFY_RELEASE = 5,
	MMU_NOTIFY_MIGRATE = 6,
	MMU_NOTIFY_EXCLUSIVE = 7,
};

struct mmu_notifier;

struct mmu_notifier_range;

struct mmu_notifier_ops {
	void (*release)(struct mmu_notifier *, struct mm_struct *);
	int (*clear_flush_young)(struct mmu_notifier *, struct mm_struct *, long unsigned int, long unsigned int);
	int (*clear_young)(struct mmu_notifier *, struct mm_struct *, long unsigned int, long unsigned int);
	int (*test_young)(struct mmu_notifier *, struct mm_struct *, long unsigned int);
	void (*change_pte)(struct mmu_notifier *, struct mm_struct *, long unsigned int, pte_t);
	int (*invalidate_range_start)(struct mmu_notifier *, const struct mmu_notifier_range *);
	void (*invalidate_range_end)(struct mmu_notifier *, const struct mmu_notifier_range *);
	void (*arch_invalidate_secondary_tlbs)(struct mmu_notifier *, struct mm_struct *, long unsigned int, long unsigned int);
	struct mmu_notifier * (*alloc_notifier)(struct mm_struct *);
	void (*free_notifier)(struct mmu_notifier *);
};

struct mmu_notifier {
	struct hlist_node hlist;
	const struct mmu_notifier_ops *ops;
	struct mm_struct *mm;
	struct callback_head rcu;
	unsigned int users;
};

struct mmu_notifier_range {
	struct mm_struct *mm;
	long unsigned int start;
	long unsigned int end;
	unsigned int flags;
	enum mmu_notifier_event event;
	void *owner;
};

struct arch_msi_msg_addr_lo {
	u32 address_lo;
};

typedef struct arch_msi_msg_addr_lo arch_msi_msg_addr_lo_t;

struct arch_msi_msg_addr_hi {
	u32 address_hi;
};

typedef struct arch_msi_msg_addr_hi arch_msi_msg_addr_hi_t;

struct arch_msi_msg_data {
	u32 data;
};

typedef struct arch_msi_msg_data arch_msi_msg_data_t;

struct msi_msg {
	union {
		u32 address_lo;
		arch_msi_msg_addr_lo_t arch_addr_lo;
	};
	union {
		u32 address_hi;
		arch_msi_msg_addr_hi_t arch_addr_hi;
	};
	union {
		u32 data;
		arch_msi_msg_data_t arch_data;
	};
};

struct pci_msi_desc {
	union {
		u32 msi_mask;
		u32 msix_ctrl;
	};
	struct {
		u8 is_msix: 1;
		u8 multiple: 3;
		u8 multi_cap: 3;
		u8 can_mask: 1;
		u8 is_64: 1;
		u8 is_virtual: 1;
		unsigned int default_irq;
	} msi_attrib;
	union {
		u8 mask_pos;
		void *mask_base;
	};
};

union msi_domain_cookie {
	u64 value;
	void *ptr;
	void *iobase;
};

union msi_instance_cookie {
	u64 value;
	void *ptr;
};

struct msi_desc_data {
	union msi_domain_cookie dcookie;
	union msi_instance_cookie icookie;
};

struct msi_desc {
	unsigned int irq;
	unsigned int nvec_used;
	struct device *dev;
	struct msi_msg msg;
	struct irq_affinity_desc *affinity;
	struct device_attribute *sysfs_attrs;
	void (*write_msi_msg)(struct msi_desc *, void *);
	void *write_msi_msg_data;
	u16 msi_index;
	union {
		struct pci_msi_desc pci;
		struct msi_desc_data data;
	};
};

enum {
	OPAL_P7IOC_NUM_PEST_REGS = 128,
	OPAL_PHB3_NUM_PEST_REGS = 256,
	OPAL_PHB4_NUM_PEST_REGS = 512,
};

enum {
	OPAL_XIVE_MODE_EMU = 0,
	OPAL_XIVE_MODE_EXPL = 1,
};

enum {
	OPAL_XIVE_IRQ_TRIGGER_PAGE = 1,
	OPAL_XIVE_IRQ_STORE_EOI = 2,
	OPAL_XIVE_IRQ_LSI = 4,
	OPAL_XIVE_IRQ_SHIFT_BUG = 8,
	OPAL_XIVE_IRQ_MASK_VIA_FW = 16,
	OPAL_XIVE_IRQ_EOI_VIA_FW = 32,
	OPAL_XIVE_IRQ_STORE_EOI2 = 64,
};

enum {
	OPAL_XIVE_EQ_ENABLED = 1,
	OPAL_XIVE_EQ_ALWAYS_NOTIFY = 2,
	OPAL_XIVE_EQ_ESCALATE = 4,
};

enum {
	OPAL_XIVE_VP_ENABLED = 1,
	OPAL_XIVE_VP_SINGLE_ESCALATION = 2,
};

enum {
	XIVE_SYNC_EAS = 1,
	XIVE_SYNC_QUEUE = 2,
};

struct xive_irq_data {
	u64 flags;
	u64 eoi_page;
	void *eoi_mmio;
	u64 trig_page;
	void *trig_mmio;
	u32 esb_shift;
	int src_chip;
	u32 hw_irq;
	int target;
	bool saved_p;
	bool stale_p;
};

struct xive_q {
	__be32 *qpage;
	u32 msk;
	u32 idx;
	u32 toggle;
	u64 eoi_phys;
	u32 esc_irq;
	atomic_t count;
	atomic_t pending_count;
	u64 guest_qaddr;
	u32 guest_qshift;
};

typedef u64 gfn_t;

struct kvm_arch_memory_slot {
	long unsigned int *rmap;
};

struct kvm_memory_slot {
	struct hlist_node id_node[2];
	struct interval_tree_node hva_node[2];
	struct rb_node gfn_node[2];
	gfn_t base_gfn;
	long unsigned int npages;
	long unsigned int *dirty_bitmap;
	struct kvm_arch_memory_slot arch;
	long unsigned int userspace_addr;
	u32 flags;
	short int id;
	u16 as_id;
};

struct kvm_memslots {
	u64 generation;
	atomic_long_t last_used_slot;
	struct rb_root_cached hva_tree;
	struct rb_root gfn_tree;
	struct hlist_head id_hash[128];
	int node_idx;
};

struct kvm_vm_stat_generic {
	u64 remote_tlb_flush;
	u64 remote_tlb_flush_requests;
};

struct kvm_vm_stat {
	struct kvm_vm_stat_generic generic;
	u64 num_2M_pages;
	u64 num_1G_pages;
};

struct revmap_entry;

struct kvm_hpt_info {
	long unsigned int virt;
	struct revmap_entry *rev;
	u32 order;
	int cma;
};

struct kvm_resize_hpt;

struct kvmppc_xics;

struct kvmppc_xive;

struct kvmppc_passthru_irqmap;

struct kvmppc_ops;

struct kvm_arch {
	unsigned int lpid;
	unsigned int smt_mode;
	unsigned int emul_smt_mode;
	unsigned int tlb_sets;
	struct kvm_hpt_info hpt;
	atomic64_t mmio_update;
	unsigned int host_lpid;
	long unsigned int host_lpcr;
	long unsigned int sdr1;
	long unsigned int host_sdr1;
	long unsigned int lpcr;
	long unsigned int vrma_slb_v;
	int mmu_ready;
	atomic_t vcpus_running;
	u32 online_vcores;
	atomic_t hpte_mod_interest;
	cpumask_t need_tlb_flush;
	u8 radix;
	u8 fwnmi_enabled;
	u8 secure_guest;
	u8 svm_enabled;
	bool nested_enable;
	bool dawr1_enabled;
	pgd_t *pgtable;
	u64 process_table;
	struct kvm_resize_hpt *resize_hpt;
	struct list_head spapr_tce_tables;
	struct list_head rtas_tokens;
	struct mutex rtas_token_lock;
	long unsigned int enabled_hcalls[5];
	struct kvmppc_xics *xics;
	struct kvmppc_xics *xics_device;
	struct kvmppc_xive *xive;
	struct {
		struct kvmppc_xive *native;
		struct kvmppc_xive *xics_on_xive;
	} xive_devices;
	struct kvmppc_passthru_irqmap *pimap;
	struct kvmppc_ops *kvm_ops;
	struct mutex uvmem_lock;
	struct list_head uvmem_pfns;
	struct mutex mmu_setup_lock;
	u64 l1_ptcr;
	struct idr kvm_nested_guest_idr;
	struct kvmppc_vcore *vcores[2048];
};

struct kvm_irq_routing_table;

struct kvm_io_bus;

struct kvm_stat_data;

struct kvm {
	spinlock_t mmu_lock;
	struct mutex slots_lock;
	struct mutex slots_arch_lock;
	struct mm_struct *mm;
	long unsigned int nr_memslot_pages;
	struct kvm_memslots __memslots[2];
	struct kvm_memslots *memslots[1];
	struct xarray vcpu_array;
	atomic_t nr_memslots_dirty_logging;
	spinlock_t mn_invalidate_lock;
	long unsigned int mn_active_invalidate_count;
	struct rcuwait mn_memslots_update_rcuwait;
	spinlock_t gpc_lock;
	struct list_head gpc_list;
	atomic_t online_vcpus;
	int max_vcpus;
	int created_vcpus;
	int last_boosted_vcpu;
	struct list_head vm_list;
	struct mutex lock;
	struct kvm_io_bus *buses[4];
	struct {
		spinlock_t lock;
		struct list_head items;
		struct list_head resampler_list;
		struct mutex resampler_lock;
	} irqfds;
	struct list_head ioeventfds;
	struct kvm_vm_stat stat;
	struct kvm_arch arch;
	refcount_t users_count;
	struct mutex irq_lock;
	struct kvm_irq_routing_table *irq_routing;
	struct hlist_head irq_ack_notifier_list;
	struct mmu_notifier mmu_notifier;
	long unsigned int mmu_invalidate_seq;
	long int mmu_invalidate_in_progress;
	long unsigned int mmu_invalidate_range_start;
	long unsigned int mmu_invalidate_range_end;
	struct list_head devices;
	u64 manual_dirty_log_protect;
	struct dentry *debugfs_dentry;
	struct kvm_stat_data **debugfs_stat_data;
	struct srcu_struct srcu;
	struct srcu_struct irq_srcu;
	pid_t userspace_pid;
	bool override_halt_poll_ns;
	unsigned int max_halt_poll_ns;
	u32 dirty_ring_size;
	bool dirty_ring_with_bitmap;
	bool vm_bugged;
	bool vm_dead;
	char stats_id[48];
};

enum msi_domain_ids {
	MSI_DEFAULT_DOMAIN = 0,
	MSI_SECONDARY_DOMAIN = 1,
	MSI_MAX_DEVICE_IRQDOMAINS = 2,
};

struct irq_bypass_consumer;

struct irq_bypass_producer {
	struct list_head node;
	void *token;
	int irq;
	int (*add_consumer)(struct irq_bypass_producer *, struct irq_bypass_consumer *);
	void (*del_consumer)(struct irq_bypass_producer *, struct irq_bypass_consumer *);
	void (*stop)(struct irq_bypass_producer *);
	void (*start)(struct irq_bypass_producer *);
};

struct irq_bypass_consumer {
	struct list_head node;
	void *token;
	int (*add_producer)(struct irq_bypass_consumer *, struct irq_bypass_producer *);
	void (*del_producer)(struct irq_bypass_consumer *, struct irq_bypass_producer *);
	void (*stop)(struct irq_bypass_consumer *);
	void (*start)(struct irq_bypass_consumer *);
};

struct kvm_sregs {
	__u32 pvr;
	union {
		struct {
			__u64 sdr1;
			struct {
				struct {
					__u64 slbe;
					__u64 slbv;
				} slb[64];
			} ppc64;
			struct {
				__u32 sr[16];
				__u64 ibat[8];
				__u64 dbat[8];
			} ppc32;
		} s;
		struct {
			union {
				struct {
					__u32 features;
					__u32 svr;
					__u64 mcar;
					__u32 hid0;
					__u32 pid1;
					__u32 pid2;
				} fsl;
				__u8 pad[256];
			} impl;
			__u32 features;
			__u32 impl_id;
			__u32 update_special;
			__u32 pir;
			__u64 sprg8;
			__u64 sprg9;
			__u64 csrr0;
			__u64 dsrr0;
			__u64 mcsrr0;
			__u32 csrr1;
			__u32 dsrr1;
			__u32 mcsrr1;
			__u32 esr;
			__u64 dear;
			__u64 ivpr;
			__u64 mcivpr;
			__u64 mcsr;
			__u32 tsr;
			__u32 tcr;
			__u32 decar;
			__u32 dec;
			__u64 tb;
			__u32 dbsr;
			__u32 dbcr[3];
			__u32 iac[4];
			__u32 dac[2];
			__u32 dvc[2];
			__u8 num_iac;
			__u8 num_dac;
			__u8 num_dvc;
			__u8 pad;
			__u32 epr;
			__u32 vrsave;
			__u32 epcr;
			__u32 mas0;
			__u32 mas1;
			__u64 mas2;
			__u64 mas7_3;
			__u32 mas4;
			__u32 mas6;
			__u32 ivor_low[16];
			__u32 ivor_high[18];
			__u32 mmucfg;
			__u32 eptcfg;
			__u32 tlbcfg[4];
			__u32 tlbps[4];
			__u32 eplc;
			__u32 epsc;
		} e;
		__u8 pad[1020];
	} u;
};

struct kvm_debug_exit_arch {
	__u64 address;
	__u32 status;
	__u32 reserved;
};

struct kvm_sync_regs {};

struct kvm_ppc_mmuv3_cfg {
	__u64 flags;
	__u64 process_table;
};

struct kvm_ppc_radix_geom {
	__u8 page_shift;
	__u8 level_bits[4];
	__u8 pad[3];
};

struct kvm_ppc_rmmu_info {
	struct kvm_ppc_radix_geom geometries[8];
	__u32 ap_encodings[8];
};

struct kvm_hyperv_exit {
	__u32 type;
	__u32 pad1;
	union {
		struct {
			__u32 msr;
			__u32 pad2;
			__u64 control;
			__u64 evt_page;
			__u64 msg_page;
		} synic;
		struct {
			__u64 input;
			__u64 result;
			__u64 params[2];
		} hcall;
		struct {
			__u32 msr;
			__u32 pad2;
			__u64 control;
			__u64 status;
			__u64 send_page;
			__u64 recv_page;
			__u64 pending_page;
		} syndbg;
	} u;
};

struct kvm_xen_exit {
	__u32 type;
	union {
		struct {
			__u32 longmode;
			__u32 cpl;
			__u64 input;
			__u64 result;
			__u64 params[6];
		} hcall;
	} u;
};

struct kvm_run {
	__u8 request_interrupt_window;
	__u8 immediate_exit;
	__u8 padding1[6];
	__u32 exit_reason;
	__u8 ready_for_interrupt_injection;
	__u8 if_flag;
	__u16 flags;
	__u64 cr8;
	__u64 apic_base;
	union {
		struct {
			__u64 hardware_exit_reason;
		} hw;
		struct {
			__u64 hardware_entry_failure_reason;
			__u32 cpu;
		} fail_entry;
		struct {
			__u32 exception;
			__u32 error_code;
		} ex;
		struct {
			__u8 direction;
			__u8 size;
			__u16 port;
			__u32 count;
			__u64 data_offset;
		} io;
		struct {
			struct kvm_debug_exit_arch arch;
		} debug;
		struct {
			__u64 phys_addr;
			__u8 data[8];
			__u32 len;
			__u8 is_write;
		} mmio;
		struct {
			__u64 nr;
			__u64 args[6];
			__u64 ret;
			union {
				__u64 flags;
			};
		} hypercall;
		struct {
			__u64 rip;
			__u32 is_write;
			__u32 pad;
		} tpr_access;
		struct {
			__u8 icptcode;
			__u16 ipa;
			__u32 ipb;
		} s390_sieic;
		__u64 s390_reset_flags;
		struct {
			__u64 trans_exc_code;
			__u32 pgm_code;
		} s390_ucontrol;
		struct {
			__u32 dcrn;
			__u32 data;
			__u8 is_write;
		} dcr;
		struct {
			__u32 suberror;
			__u32 ndata;
			__u64 data[16];
		} internal;
		struct {
			__u32 suberror;
			__u32 ndata;
			__u64 flags;
			union {
				struct {
					__u8 insn_size;
					__u8 insn_bytes[15];
				};
			};
		} emulation_failure;
		struct {
			__u64 gprs[32];
		} osi;
		struct {
			__u64 nr;
			__u64 ret;
			__u64 args[9];
		} papr_hcall;
		struct {
			__u16 subchannel_id;
			__u16 subchannel_nr;
			__u32 io_int_parm;
			__u32 io_int_word;
			__u32 ipb;
			__u8 dequeued;
		} s390_tsch;
		struct {
			__u32 epr;
		} epr;
		struct {
			__u32 type;
			__u32 ndata;
			union {
				__u64 data[16];
			};
		} system_event;
		struct {
			__u64 addr;
			__u8 ar;
			__u8 reserved;
			__u8 fc;
			__u8 sel1;
			__u16 sel2;
		} s390_stsi;
		struct {
			__u8 vector;
		} eoi;
		struct kvm_hyperv_exit hyperv;
		struct {
			__u64 esr_iss;
			__u64 fault_ipa;
		} arm_nisv;
		struct {
			__u8 error;
			__u8 pad[7];
			__u32 reason;
			__u32 index;
			__u64 data;
		} msr;
		struct kvm_xen_exit xen;
		struct {
			long unsigned int extension_id;
			long unsigned int function_id;
			long unsigned int args[6];
			long unsigned int ret[2];
		} riscv_sbi;
		struct {
			long unsigned int csr_num;
			long unsigned int new_value;
			long unsigned int write_mask;
			long unsigned int ret_value;
		} riscv_csr;
		struct {
			__u32 flags;
		} notify;
		char padding[256];
	};
	__u64 kvm_valid_regs;
	__u64 kvm_dirty_regs;
	union {
		struct kvm_sync_regs regs;
		char padding[2048];
	} s;
};

struct kvm_dirty_log {
	__u32 slot;
	__u32 padding1;
	union {
		void *dirty_bitmap;
		__u64 padding2;
	};
};

struct kvm_ppc_one_page_size {
	__u32 page_shift;
	__u32 pte_enc;
};

struct kvm_ppc_one_seg_page_size {
	__u32 page_shift;
	__u32 slb_enc;
	struct kvm_ppc_one_page_size enc[8];
};

struct kvm_ppc_smmu_info {
	__u64 flags;
	__u32 slb_size;
	__u16 data_keys;
	__u16 instr_keys;
	struct kvm_ppc_one_seg_page_size sps[8];
};

struct kvm_dirty_gfn {
	__u32 flags;
	__u32 slot;
	__u64 offset;
};

struct kvm_stats_desc {
	__u32 flags;
	__s16 exponent;
	__u16 size;
	__u32 offset;
	__u32 bucket_size;
	char name[0];
};

struct revmap_entry {
	long unsigned int guest_rpte;
	unsigned int forw;
	unsigned int back;
};

struct kvmppc_irq_map {
	u32 r_hwirq;
	u32 v_hwirq;
	struct irq_desc *desc;
};

struct kvmppc_passthru_irqmap {
	int n_mapped;
	struct kvmppc_irq_map mapped[1024];
};

enum kvm_mr_change {
	KVM_MR_CREATE = 0,
	KVM_MR_DELETE = 1,
	KVM_MR_MOVE = 2,
	KVM_MR_FLAGS_ONLY = 3,
};

union kvmppc_one_reg;

struct kvm_gfn_range;

struct kvmppc_ops {
	struct module *owner;
	int (*get_sregs)(struct kvm_vcpu *, struct kvm_sregs *);
	int (*set_sregs)(struct kvm_vcpu *, struct kvm_sregs *);
	int (*get_one_reg)(struct kvm_vcpu *, u64, union kvmppc_one_reg *);
	int (*set_one_reg)(struct kvm_vcpu *, u64, union kvmppc_one_reg *);
	void (*vcpu_load)(struct kvm_vcpu *, int);
	void (*vcpu_put)(struct kvm_vcpu *);
	void (*inject_interrupt)(struct kvm_vcpu *, int, u64);
	void (*set_msr)(struct kvm_vcpu *, u64);
	int (*vcpu_run)(struct kvm_vcpu *);
	int (*vcpu_create)(struct kvm_vcpu *);
	void (*vcpu_free)(struct kvm_vcpu *);
	int (*check_requests)(struct kvm_vcpu *);
	int (*get_dirty_log)(struct kvm *, struct kvm_dirty_log *);
	void (*flush_memslot)(struct kvm *, struct kvm_memory_slot *);
	int (*prepare_memory_region)(struct kvm *, const struct kvm_memory_slot *, struct kvm_memory_slot *, enum kvm_mr_change);
	void (*commit_memory_region)(struct kvm *, struct kvm_memory_slot *, const struct kvm_memory_slot *, enum kvm_mr_change);
	bool (*unmap_gfn_range)(struct kvm *, struct kvm_gfn_range *);
	bool (*age_gfn)(struct kvm *, struct kvm_gfn_range *);
	bool (*test_age_gfn)(struct kvm *, struct kvm_gfn_range *);
	bool (*set_spte_gfn)(struct kvm *, struct kvm_gfn_range *);
	void (*free_memslot)(struct kvm_memory_slot *);
	int (*init_vm)(struct kvm *);
	void (*destroy_vm)(struct kvm *);
	int (*get_smmu_info)(struct kvm *, struct kvm_ppc_smmu_info *);
	int (*emulate_op)(struct kvm_vcpu *, unsigned int, int *);
	int (*emulate_mtspr)(struct kvm_vcpu *, int, ulong);
	int (*emulate_mfspr)(struct kvm_vcpu *, int, ulong *);
	void (*fast_vcpu_kick)(struct kvm_vcpu *);
	int (*arch_vm_ioctl)(struct file *, unsigned int, long unsigned int);
	int (*hcall_implemented)(long unsigned int);
	int (*irq_bypass_add_producer)(struct irq_bypass_consumer *, struct irq_bypass_producer *);
	void (*irq_bypass_del_producer)(struct irq_bypass_consumer *, struct irq_bypass_producer *);
	int (*configure_mmu)(struct kvm *, struct kvm_ppc_mmuv3_cfg *);
	int (*get_rmmu_info)(struct kvm *, struct kvm_ppc_rmmu_info *);
	int (*set_smt_mode)(struct kvm *, long unsigned int, long unsigned int);
	void (*giveup_ext)(struct kvm_vcpu *, ulong);
	int (*enable_nested)(struct kvm *);
	int (*load_from_eaddr)(struct kvm_vcpu *, ulong *, void *, int);
	int (*store_to_eaddr)(struct kvm_vcpu *, ulong *, void *, int);
	int (*enable_svm)(struct kvm *);
	int (*svm_off)(struct kvm *);
	int (*enable_dawr1)(struct kvm *);
	bool (*hash_v3_possible)();
	int (*create_vm_debugfs)(struct kvm *);
	int (*create_vcpu_debugfs)(struct kvm_vcpu *, struct dentry *);
};

struct kvmppc_pte {
	ulong eaddr;
	u64 vpage;
	ulong raddr;
	bool may_read: 1;
	bool may_write: 1;
	bool may_execute: 1;
	long unsigned int wimg;
	long unsigned int rc;
	u8 page_size;
	u8 page_shift;
};

struct kvmppc_sid_map {
	u64 guest_vsid;
	u64 guest_esid;
	u64 host_vsid;
	bool valid: 1;
};

struct kvmppc_bat {
	u64 raw;
	u32 bepi;
	u32 bepi_mask;
	u32 brpn;
	u8 wimg;
	u8 pp;
	bool vs: 1;
	bool vp: 1;
};

struct kvmppc_vcpu_book3s {
	struct kvmppc_sid_map sid_map[512];
	struct {
		u64 esid;
		u64 vsid;
	} slb_shadow[64];
	u8 slb_shadow_max;
	struct kvmppc_bat ibat[8];
	struct kvmppc_bat dbat[8];
	u64 hid[6];
	u64 gqr[8];
	u64 sdr1;
	u64 hior;
	u64 msr_mask;
	u64 vtb;
	u64 proto_vsid_first;
	u64 proto_vsid_max;
	u64 proto_vsid_next;
	int context_id[1];
	bool hior_explicit;
	struct hlist_head hpte_hash_pte[8192];
	struct hlist_head hpte_hash_pte_long[4096];
	struct hlist_head hpte_hash_vpte[8192];
	struct hlist_head hpte_hash_vpte_long[32];
	struct hlist_head hpte_hash_vpte_64k[2048];
	int hpte_cache_count;
	spinlock_t mmu_lock;
};

struct kvm_nested_guest {
	struct kvm *l1_host;
	int l1_lpid;
	int shadow_lpid;
	pgd_t *shadow_pgtable;
	u64 l1_gr_to_hr;
	u64 process_table;
	long int refcnt;
	struct mutex tlb_lock;
	struct kvm_nested_guest *next;
	cpumask_t need_tlb_flush;
	short int prev_cpu[2048];
	u8 radix;
};

struct kvm_io_device;

struct kvm_io_range {
	gpa_t addr;
	int len;
	struct kvm_io_device *dev;
};

struct kvm_io_bus {
	int dev_count;
	int ioeventfd_count;
	struct kvm_io_range range[0];
};

enum kvm_bus {
	KVM_MMIO_BUS = 0,
	KVM_PIO_BUS = 1,
	KVM_VIRTIO_CCW_NOTIFY_BUS = 2,
	KVM_FAST_MMIO_BUS = 3,
	KVM_NR_BUSES = 4,
};

union kvm_mmu_notifier_arg {
	pte_t pte;
};

struct kvm_gfn_range {
	struct kvm_memory_slot *slot;
	gfn_t start;
	gfn_t end;
	union kvm_mmu_notifier_arg arg;
	bool may_block;
};

enum kvm_stat_kind {
	KVM_STAT_VM = 0,
	KVM_STAT_VCPU = 1,
};

struct _kvm_stats_desc;

struct kvm_stat_data {
	struct kvm *kvm;
	const struct _kvm_stats_desc *desc;
	enum kvm_stat_kind kind;
};

struct _kvm_stats_desc {
	struct kvm_stats_desc desc;
	char name[48];
};

union kvmppc_one_reg {
	u32 wval;
	u64 dval;
	vector128 vval;
	u64 vsxval[2];
	u32 vsx32val[4];
	u16 vsx16val[8];
	u8 vsx8val[16];
	struct {
		u64 addr;
		u64 length;
	} vpaval;
	u64 xive_timaval[2];
};

struct xive_cpu {
	u32 hw_ipi;
	struct xive_irq_data ipi_data;
	int chip_id;
	struct xive_q queue[8];
	u8 pending_prio;
	u8 cppr;
};

struct xive_ops {
	int (*populate_irq_data)(u32, struct xive_irq_data *);
	int (*configure_irq)(u32, u32, u8, u32);
	int (*get_irq_config)(u32, u32 *, u8 *, u32 *);
	int (*setup_queue)(unsigned int, struct xive_cpu *, u8);
	void (*cleanup_queue)(unsigned int, struct xive_cpu *, u8);
	void (*prepare_cpu)(unsigned int, struct xive_cpu *);
	void (*setup_cpu)(unsigned int, struct xive_cpu *);
	void (*teardown_cpu)(unsigned int, struct xive_cpu *);
	bool (*match)(struct device_node *);
	void (*shutdown)();
	void (*update_pending)(struct xive_cpu *);
	void (*sync_source)(u32);
	u64 (*esb_rw)(u32, u32, u64, bool);
	int (*get_ipi)(unsigned int, struct xive_cpu *);
	void (*put_ipi)(unsigned int, struct xive_cpu *);
	int (*debug_show)(struct seq_file *, void *);
	int (*debug_create)(struct dentry *);
	const char *name;
};

struct ppc_pci_io {
	u8 (*readb)(const volatile void *);
	u16 (*readw)(const volatile void *);
	u32 (*readl)(const volatile void *);
	u16 (*readw_be)(const volatile void *);
	u32 (*readl_be)(const volatile void *);
	void (*writeb)(u8, volatile void *);
	void (*writew)(u16, volatile void *);
	void (*writel)(u32, volatile void *);
	void (*writew_be)(u16, volatile void *);
	void (*writel_be)(u32, volatile void *);
	u64 (*readq)(const volatile void *);
	u64 (*readq_be)(const volatile void *);
	void (*writeq)(u64, volatile void *);
	void (*writeq_be)(u64, volatile void *);
	u8 (*inb)(long unsigned int);
	u16 (*inw)(long unsigned int);
	u32 (*inl)(long unsigned int);
	void (*outb)(u8, long unsigned int);
	void (*outw)(u16, long unsigned int);
	void (*outl)(u32, long unsigned int);
	void (*readsb)(const volatile void *, void *, long unsigned int);
	void (*readsw)(const volatile void *, void *, long unsigned int);
	void (*readsl)(const volatile void *, void *, long unsigned int);
	void (*writesb)(volatile void *, const void *, long unsigned int);
	void (*writesw)(volatile void *, const void *, long unsigned int);
	void (*writesl)(volatile void *, const void *, long unsigned int);
	void (*insb)(long unsigned int, void *, long unsigned int);
	void (*insw)(long unsigned int, void *, long unsigned int);
	void (*insl)(long unsigned int, void *, long unsigned int);
	void (*outsb)(long unsigned int, const void *, long unsigned int);
	void (*outsw)(long unsigned int, const void *, long unsigned int);
	void (*outsl)(long unsigned int, const void *, long unsigned int);
	void (*memset_io)(volatile void *, int, long unsigned int);
	void (*memcpy_fromio)(void *, const volatile void *, long unsigned int);
	void (*memcpy_toio)(volatile void *, const void *, long unsigned int);
};

enum OpalLPCAddressType {
	OPAL_LPC_MEM = 0,
	OPAL_LPC_IO = 1,
	OPAL_LPC_FW = 2,
};

struct lpc_debugfs_entry {
	enum OpalLPCAddressType lpc_type;
};

enum {
	WORK_STRUCT_PENDING_BIT = 0,
	WORK_STRUCT_INACTIVE_BIT = 1,
	WORK_STRUCT_PWQ_BIT = 2,
	WORK_STRUCT_LINKED_BIT = 3,
	WORK_STRUCT_COLOR_SHIFT = 4,
	WORK_STRUCT_COLOR_BITS = 4,
	WORK_STRUCT_PENDING = 1,
	WORK_STRUCT_INACTIVE = 2,
	WORK_STRUCT_PWQ = 4,
	WORK_STRUCT_LINKED = 8,
	WORK_STRUCT_STATIC = 0,
	WORK_NR_COLORS = 16,
	WORK_CPU_UNBOUND = 2048,
	WORK_STRUCT_FLAG_BITS = 8,
	WORK_OFFQ_FLAG_BASE = 4,
	__WORK_OFFQ_CANCELING = 4,
	WORK_OFFQ_FLAG_BITS = 1,
	WORK_OFFQ_POOL_SHIFT = 5,
	WORK_OFFQ_LEFT = 59,
	WORK_OFFQ_POOL_BITS = 31,
	WORK_BUSY_PENDING = 1,
	WORK_BUSY_RUNNING = 2,
	WORKER_DESC_LEN = 24,
};

struct notifier_block;

typedef int (*notifier_fn_t)(struct notifier_block *, long unsigned int, void *);

struct notifier_block {
	notifier_fn_t notifier_call;
	struct notifier_block *next;
	int priority;
};

enum opal_msg_type {
	OPAL_MSG_ASYNC_COMP = 0,
	OPAL_MSG_MEM_ERR = 1,
	OPAL_MSG_EPOW = 2,
	OPAL_MSG_SHUTDOWN = 3,
	OPAL_MSG_HMI_EVT = 4,
	OPAL_MSG_DPO = 5,
	OPAL_MSG_PRD = 6,
	OPAL_MSG_OCC = 7,
	OPAL_MSG_PRD2 = 8,
	OPAL_MSG_TYPE_MAX = 9,
};

struct opal_msg {
	__be32 msg_type;
	__be32 reserved;
	__be64 params[8];
};

enum OpalHMI_Version {
	OpalHMIEvt_V1 = 1,
	OpalHMIEvt_V2 = 2,
};

enum OpalHMI_Severity {
	OpalHMI_SEV_NO_ERROR = 0,
	OpalHMI_SEV_WARNING = 1,
	OpalHMI_SEV_ERROR_SYNC = 2,
	OpalHMI_SEV_FATAL = 3,
};

enum OpalHMI_Disposition {
	OpalHMI_DISPOSITION_RECOVERED = 0,
	OpalHMI_DISPOSITION_NOT_RECOVERED = 1,
};

enum OpalHMI_ErrType {
	OpalHMI_ERROR_MALFUNC_ALERT = 0,
	OpalHMI_ERROR_PROC_RECOV_DONE = 1,
	OpalHMI_ERROR_PROC_RECOV_DONE_AGAIN = 2,
	OpalHMI_ERROR_PROC_RECOV_MASKED = 3,
	OpalHMI_ERROR_TFAC = 4,
	OpalHMI_ERROR_TFMR_PARITY = 5,
	OpalHMI_ERROR_HA_OVERFLOW_WARN = 6,
	OpalHMI_ERROR_XSCOM_FAIL = 7,
	OpalHMI_ERROR_XSCOM_DONE = 8,
	OpalHMI_ERROR_SCOM_FIR = 9,
	OpalHMI_ERROR_DEBUG_TRIG_FIR = 10,
	OpalHMI_ERROR_HYP_RESOURCE = 11,
	OpalHMI_ERROR_CAPP_RECOVERY = 12,
};

enum OpalHMI_XstopType {
	CHECKSTOP_TYPE_UNKNOWN = 0,
	CHECKSTOP_TYPE_CORE = 1,
	CHECKSTOP_TYPE_NX = 2,
	CHECKSTOP_TYPE_NPU = 3,
};

enum OpalHMI_CoreXstopReason {
	CORE_CHECKSTOP_IFU_REGFILE = 1,
	CORE_CHECKSTOP_IFU_LOGIC = 2,
	CORE_CHECKSTOP_PC_DURING_RECOV = 4,
	CORE_CHECKSTOP_ISU_REGFILE = 8,
	CORE_CHECKSTOP_ISU_LOGIC = 16,
	CORE_CHECKSTOP_FXU_LOGIC = 32,
	CORE_CHECKSTOP_VSU_LOGIC = 64,
	CORE_CHECKSTOP_PC_RECOV_IN_MAINT_MODE = 128,
	CORE_CHECKSTOP_LSU_REGFILE = 256,
	CORE_CHECKSTOP_PC_FWD_PROGRESS = 512,
	CORE_CHECKSTOP_LSU_LOGIC = 1024,
	CORE_CHECKSTOP_PC_LOGIC = 2048,
	CORE_CHECKSTOP_PC_HYP_RESOURCE = 4096,
	CORE_CHECKSTOP_PC_HANG_RECOV_FAILED = 8192,
	CORE_CHECKSTOP_PC_AMBI_HANG_DETECTED = 16384,
	CORE_CHECKSTOP_PC_DEBUG_TRIG_ERR_INJ = 32768,
	CORE_CHECKSTOP_PC_SPRD_HYP_ERR_INJ = 65536,
};

enum OpalHMI_NestAccelXstopReason {
	NX_CHECKSTOP_SHM_INVAL_STATE_ERR = 1,
	NX_CHECKSTOP_DMA_INVAL_STATE_ERR_1 = 2,
	NX_CHECKSTOP_DMA_INVAL_STATE_ERR_2 = 4,
	NX_CHECKSTOP_DMA_CH0_INVAL_STATE_ERR = 8,
	NX_CHECKSTOP_DMA_CH1_INVAL_STATE_ERR = 16,
	NX_CHECKSTOP_DMA_CH2_INVAL_STATE_ERR = 32,
	NX_CHECKSTOP_DMA_CH3_INVAL_STATE_ERR = 64,
	NX_CHECKSTOP_DMA_CH4_INVAL_STATE_ERR = 128,
	NX_CHECKSTOP_DMA_CH5_INVAL_STATE_ERR = 256,
	NX_CHECKSTOP_DMA_CH6_INVAL_STATE_ERR = 512,
	NX_CHECKSTOP_DMA_CH7_INVAL_STATE_ERR = 1024,
	NX_CHECKSTOP_DMA_CRB_UE = 2048,
	NX_CHECKSTOP_DMA_CRB_SUE = 4096,
	NX_CHECKSTOP_PBI_ISN_UE = 8192,
};

struct OpalHMIEvent {
	uint8_t version;
	uint8_t severity;
	uint8_t type;
	uint8_t disposition;
	uint8_t reserved_1[4];
	__be64 hmer;
	__be64 tfmr;
	union {
		struct {
			uint8_t xstop_type;
			uint8_t reserved_1[3];
			__be32 xstop_reason;
			union {
				__be32 pir;
				__be32 chip_id;
			} u;
		} xstop_error;
	} u;
};

struct OpalHmiEvtNode {
	struct list_head list;
	struct OpalHMIEvent hmi_evt;
};

struct xstop_reason {
	uint32_t xstop_reason;
	const char *unit_failed;
	const char *description;
};

typedef char *va_list;

typedef u16 uint16_t;

struct va_format {
	const char *fmt;
	va_list *va;
};

typedef __u64 Elf64_Off;

struct elf64_hdr {
	unsigned char e_ident[16];
	Elf64_Half e_type;
	Elf64_Half e_machine;
	Elf64_Word e_version;
	Elf64_Addr e_entry;
	Elf64_Off e_phoff;
	Elf64_Off e_shoff;
	Elf64_Word e_flags;
	Elf64_Half e_ehsize;
	Elf64_Half e_phentsize;
	Elf64_Half e_phnum;
	Elf64_Half e_shentsize;
	Elf64_Half e_shnum;
	Elf64_Half e_shstrndx;
};

typedef struct elf64_hdr Elf64_Ehdr;

struct elf64_shdr {
	Elf64_Word sh_name;
	Elf64_Word sh_type;
	Elf64_Xword sh_flags;
	Elf64_Addr sh_addr;
	Elf64_Off sh_offset;
	Elf64_Xword sh_size;
	Elf64_Word sh_link;
	Elf64_Word sh_info;
	Elf64_Xword sh_addralign;
	Elf64_Xword sh_entsize;
};

typedef struct elf64_shdr Elf64_Shdr;

struct iommu_pool {
	long unsigned int start;
	long unsigned int end;
	long unsigned int hint;
	spinlock_t lock;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct iommu_table_ops;

struct iommu_table {
	long unsigned int it_busno;
	long unsigned int it_size;
	long unsigned int it_indirect_levels;
	long unsigned int it_level_size;
	long unsigned int it_allocated_size;
	long unsigned int it_offset;
	long unsigned int it_base;
	long unsigned int it_index;
	long unsigned int it_type;
	long unsigned int it_blocksize;
	long unsigned int poolsize;
	long unsigned int nr_pools;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct iommu_pool large_pool;
	struct iommu_pool pools[4];
	long unsigned int *it_map;
	long unsigned int it_page_shift;
	struct list_head it_group_list;
	__be64 *it_userspace;
	struct iommu_table_ops *it_ops;
	struct kref it_kref;
	int it_nid;
	long unsigned int it_reserved_start;
	long unsigned int it_reserved_end;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct hotplug_slot_ops;

struct hotplug_slot {
	const struct hotplug_slot_ops *ops;
	struct list_head slot_list;
	struct pci_slot *pci_slot;
	struct module *owner;
	const char *mod_name;
};

struct pci_host_bridge {
	struct device dev;
	struct pci_bus *bus;
	struct pci_ops *ops;
	struct pci_ops *child_ops;
	void *sysdata;
	int busnr;
	int domain_nr;
	struct list_head windows;
	struct list_head dma_ranges;
	u8 (*swizzle_irq)(struct pci_dev *, u8 *);
	int (*map_irq)(const struct pci_dev *, u8, u8);
	void (*release_fn)(struct pci_host_bridge *);
	void *release_data;
	unsigned int ignore_reset_delay: 1;
	unsigned int no_ext_tags: 1;
	unsigned int no_inc_mrrs: 1;
	unsigned int native_aer: 1;
	unsigned int native_pcie_hotplug: 1;
	unsigned int native_shpc_hotplug: 1;
	unsigned int native_pme: 1;
	unsigned int native_ltr: 1;
	unsigned int native_dpc: 1;
	unsigned int native_cxl_error: 1;
	unsigned int preserve_config: 1;
	unsigned int size_windows: 1;
	unsigned int msi_domain: 1;
	resource_size_t (*align_resource)(struct pci_dev *, const struct resource *, resource_size_t, resource_size_t, resource_size_t);
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long unsigned int private[0];
};

typedef u64 pci_bus_addr_t;

struct pci_bus_region {
	pci_bus_addr_t start;
	pci_bus_addr_t end;
};

enum {
	PCI_REASSIGN_ALL_RSRC = 1,
	PCI_REASSIGN_ALL_BUS = 2,
	PCI_PROBE_ONLY = 4,
	PCI_CAN_SKIP_ISA_ALIGN = 8,
	PCI_ENABLE_PROC_DOMAINS = 16,
	PCI_COMPAT_DOMAIN_0 = 32,
	PCI_SCAN_ALL_PCIE_DEVS = 64,
};

typedef long unsigned int kimage_entry_t;

struct kexec_segment {
	union {
		void *buf;
		void *kbuf;
	};
	size_t bufsz;
	long unsigned int mem;
	size_t memsz;
};

struct crash_mem;

struct kimage_arch {
	struct crash_mem *exclude_ranges;
	long unsigned int backup_start;
	void *backup_buf;
	void *fdt;
};

struct purgatory_info {
	const Elf64_Ehdr *ehdr;
	Elf64_Shdr *sechdrs;
	void *purgatory_buf;
};

struct kexec_file_ops;

struct kimage {
	kimage_entry_t head;
	kimage_entry_t *entry;
	kimage_entry_t *last_entry;
	long unsigned int start;
	struct page *control_code_page;
	struct page *swap_page;
	void *vmcoreinfo_data_copy;
	long unsigned int nr_segments;
	struct kexec_segment segment[16];
	struct list_head control_pages;
	struct list_head dest_pages;
	struct list_head unusable_pages;
	long unsigned int control_page;
	unsigned int type: 1;
	unsigned int preserve_context: 1;
	unsigned int file_mode: 1;
	struct kimage_arch arch;
	void *kernel_buf;
	long unsigned int kernel_buf_len;
	void *initrd_buf;
	long unsigned int initrd_buf_len;
	char *cmdline_buf;
	long unsigned int cmdline_buf_len;
	const struct kexec_file_ops *fops;
	void *image_loader_data;
	struct purgatory_info purgatory_info;
	void *ima_buffer;
	phys_addr_t ima_buffer_addr;
	size_t ima_buffer_size;
	void *elf_headers;
	long unsigned int elf_headers_sz;
	long unsigned int elf_load_addr;
};

struct iommu_table_group_ops;

struct iommu_table_group {
	__u32 tce32_start;
	__u32 tce32_size;
	__u64 pgsizes;
	__u32 max_dynamic_windows_supported;
	__u32 max_levels;
	struct iommu_group *group;
	struct iommu_table *tables[2];
	struct iommu_table_group_ops *ops;
};

struct pci_fixup {
	u16 vendor;
	u16 device;
	u32 class;
	unsigned int class_shift;
	void (*hook)(struct pci_dev *);
};

struct crash_mem {
	unsigned int max_nr_ranges;
	unsigned int nr_ranges;
	struct range ranges[0];
};

enum key_being_used_for {
	VERIFYING_MODULE_SIGNATURE = 0,
	VERIFYING_FIRMWARE_SIGNATURE = 1,
	VERIFYING_KEXEC_PE_SIGNATURE = 2,
	VERIFYING_KEY_SIGNATURE = 3,
	VERIFYING_KEY_SELF_SIGNATURE = 4,
	VERIFYING_UNSPECIFIED_SIGNATURE = 5,
	NR__KEY_BEING_USED_FOR = 6,
};

typedef int kexec_probe_t(const char *, long unsigned int);

typedef void *kexec_load_t(struct kimage *, char *, long unsigned int, char *, long unsigned int, char *, long unsigned int);

typedef int kexec_cleanup_t(void *);

struct kexec_file_ops {
	kexec_probe_t *probe;
	kexec_load_t *load;
	kexec_cleanup_t *cleanup;
};

struct msi_alloc_info {
	struct msi_desc *desc;
	irq_hw_number_t hwirq;
	long unsigned int flags;
	union {
		long unsigned int ul;
		void *ptr;
	} scratchpad[2];
};

typedef struct msi_alloc_info msi_alloc_info_t;

struct msi_domain_ops {
	irq_hw_number_t (*get_hwirq)(struct msi_domain_info *, msi_alloc_info_t *);
	int (*msi_init)(struct irq_domain *, struct msi_domain_info *, unsigned int, irq_hw_number_t, msi_alloc_info_t *);
	void (*msi_free)(struct irq_domain *, struct msi_domain_info *, unsigned int);
	int (*msi_prepare)(struct irq_domain *, struct device *, int, msi_alloc_info_t *);
	void (*prepare_desc)(struct irq_domain *, msi_alloc_info_t *, struct msi_desc *);
	void (*set_desc)(msi_alloc_info_t *, struct msi_desc *);
	int (*domain_alloc_irqs)(struct irq_domain *, struct device *, int);
	void (*domain_free_irqs)(struct irq_domain *, struct device *);
	void (*msi_post_free)(struct irq_domain *, struct device *);
};

struct msi_domain_info {
	u32 flags;
	enum irq_domain_bus_token bus_token;
	unsigned int hwsize;
	struct msi_domain_ops *ops;
	struct irq_chip *chip;
	void *chip_data;
	irq_flow_handler_t handler;
	void *handler_data;
	const char *handler_name;
	void *data;
};

enum {
	MSI_FLAG_USE_DEF_DOM_OPS = 1,
	MSI_FLAG_USE_DEF_CHIP_OPS = 2,
	MSI_FLAG_ACTIVATE_EARLY = 4,
	MSI_FLAG_MUST_REACTIVATE = 8,
	MSI_FLAG_DEV_SYSFS = 16,
	MSI_FLAG_ALLOC_SIMPLE_MSI_DESCS = 32,
	MSI_FLAG_FREE_MSI_DESCS = 64,
	MSI_FLAG_NOMASK_QUIRK = 128,
	MSI_GENERIC_FLAGS_MASK = 65535,
	MSI_DOMAIN_FLAGS_MASK = 4294901760,
	MSI_FLAG_MULTI_PCI_MSI = 65536,
	MSI_FLAG_PCI_MSIX = 131072,
	MSI_FLAG_LEVEL_CAPABLE = 262144,
	MSI_FLAG_MSIX_CONTIGUOUS = 524288,
	MSI_FLAG_PCI_MSIX_ALLOC_DYN = 1048576,
	MSI_FLAG_PCI_IMS = 2097152,
};

struct msi_bitmap {
	struct device_node *of_node;
	long unsigned int *bitmap;
	spinlock_t lock;
	unsigned int irq_count;
	bool bitmap_from_slab;
};

enum OpalFreezeState {
	OPAL_EEH_STOPPED_NOT_FROZEN = 0,
	OPAL_EEH_STOPPED_MMIO_FREEZE = 1,
	OPAL_EEH_STOPPED_DMA_FREEZE = 2,
	OPAL_EEH_STOPPED_MMIO_DMA_FREEZE = 3,
	OPAL_EEH_STOPPED_RESET = 4,
	OPAL_EEH_STOPPED_TEMP_UNAVAIL = 5,
	OPAL_EEH_STOPPED_PERM_UNAVAIL = 6,
};

enum OpalEehFreezeActionToken {
	OPAL_EEH_ACTION_CLEAR_FREEZE_MMIO = 1,
	OPAL_EEH_ACTION_CLEAR_FREEZE_DMA = 2,
	OPAL_EEH_ACTION_CLEAR_FREEZE_ALL = 3,
	OPAL_EEH_ACTION_SET_FREEZE_MMIO = 1,
	OPAL_EEH_ACTION_SET_FREEZE_DMA = 2,
	OPAL_EEH_ACTION_SET_FREEZE_ALL = 3,
};

enum OpalMmioWindowType {
	OPAL_M32_WINDOW_TYPE = 1,
	OPAL_M64_WINDOW_TYPE = 2,
	OPAL_IO_WINDOW_TYPE = 3,
};

enum OpalPciBusCompare {
	OpalPciBusAny = 0,
	OpalPciBus3Bits = 2,
	OpalPciBus4Bits = 3,
	OpalPciBus5Bits = 4,
	OpalPciBus6Bits = 5,
	OpalPciBus7Bits = 6,
	OpalPciBusAll = 7,
};

enum OpalDeviceCompare {
	OPAL_IGNORE_RID_DEVICE_NUMBER = 0,
	OPAL_COMPARE_RID_DEVICE_NUMBER = 1,
};

enum OpalFuncCompare {
	OPAL_IGNORE_RID_FUNCTION_NUMBER = 0,
	OPAL_COMPARE_RID_FUNCTION_NUMBER = 1,
};

enum OpalPeAction {
	OPAL_UNMAP_PE = 0,
	OPAL_MAP_PE = 1,
};

enum OpalPeltvAction {
	OPAL_REMOVE_PE_FROM_DOMAIN = 0,
	OPAL_ADD_PE_TO_DOMAIN = 1,
};

enum OpalM64Action {
	OPAL_DISABLE_M64 = 0,
	OPAL_ENABLE_M64_SPLIT = 1,
	OPAL_ENABLE_M64_NON_SPLIT = 2,
};

enum OpalPciResetScope {
	OPAL_RESET_PHB_COMPLETE = 1,
	OPAL_RESET_PCI_LINK = 2,
	OPAL_RESET_PHB_ERROR = 3,
	OPAL_RESET_PCI_HOT = 4,
	OPAL_RESET_PCI_FUNDAMENTAL = 5,
	OPAL_RESET_PCI_IODA_TABLE = 6,
};

enum OpalPciResetState {
	OPAL_DEASSERT_RESET = 0,
	OPAL_ASSERT_RESET = 1,
};

enum {
	OPAL_PCI_TCE_KILL_PAGES = 0,
	OPAL_PCI_TCE_KILL_PE = 1,
	OPAL_PCI_TCE_KILL_ALL = 2,
};

struct iommu_table_ops {
	int (*set)(struct iommu_table *, long int, long int, long unsigned int, enum dma_data_direction, long unsigned int);
	int (*xchg_no_kill)(struct iommu_table *, long int, long unsigned int *, enum dma_data_direction *);
	void (*tce_kill)(struct iommu_table *, long unsigned int, long unsigned int);
	__be64 * (*useraddrptr)(struct iommu_table *, long int, bool);
	void (*clear)(struct iommu_table *, long int, long int);
	long unsigned int (*get)(struct iommu_table *, long int);
	void (*flush)(struct iommu_table *);
	void (*free)(struct iommu_table *);
};

struct iommu_table_group_ops {
	long unsigned int (*get_table_size)(__u32, __u64, __u32);
	long int (*create_table)(struct iommu_table_group *, int, __u32, __u64, __u32, struct iommu_table **);
	long int (*set_window)(struct iommu_table_group *, int, struct iommu_table *);
	long int (*unset_window)(struct iommu_table_group *, int);
	long int (*take_ownership)(struct iommu_table_group *);
	void (*release_ownership)(struct iommu_table_group *);
};

struct iommu_table_group_link {
	struct list_head next;
	struct callback_head rcu;
	struct iommu_table_group *table_group;
};

struct hotplug_slot_ops {
	int (*enable_slot)(struct hotplug_slot *);
	int (*disable_slot)(struct hotplug_slot *);
	int (*set_attention_status)(struct hotplug_slot *, u8);
	int (*hardware_test)(struct hotplug_slot *, u32);
	int (*get_power_status)(struct hotplug_slot *, u8 *);
	int (*get_attention_status)(struct hotplug_slot *, u8 *);
	int (*get_latch_status)(struct hotplug_slot *, u8 *);
	int (*get_adapter_status)(struct hotplug_slot *, u8 *);
	int (*reset_slot)(struct hotplug_slot *, bool);
};

enum pnv_phb_type {
	PNV_PHB_IODA2 = 0,
	PNV_PHB_NPU_OCAPI = 1,
};

enum pnv_phb_model {
	PNV_PHB_MODEL_UNKNOWN = 0,
	PNV_PHB_MODEL_P7IOC = 1,
	PNV_PHB_MODEL_PHB3 = 2,
};

struct pnv_phb;

struct pnv_ioda_pe {
	long unsigned int flags;
	struct pnv_phb *phb;
	int device_count;
	struct pci_dev *pdev;
	struct pci_bus *pbus;
	unsigned int rid;
	unsigned int pe_number;
	struct iommu_table_group table_group;
	bool tce_bypass_enabled;
	uint64_t tce_bypass_base;
	bool dma_setup_done;
	int mve_number;
	struct pnv_ioda_pe *master;
	struct list_head slaves;
	struct list_head list;
};

struct pnv_phb {
	struct pci_controller *hose;
	enum pnv_phb_type type;
	enum pnv_phb_model model;
	u64 hub_id;
	u64 opal_id;
	int flags;
	void *regs;
	u64 regs_phys;
	spinlock_t lock;
	int has_dbgfs;
	struct dentry *dbgfs;
	unsigned int msi_base;
	struct msi_bitmap msi_bmp;
	int (*init_m64)(struct pnv_phb *);
	int (*get_pe_state)(struct pnv_phb *, int);
	void (*freeze_pe)(struct pnv_phb *, int);
	int (*unfreeze_pe)(struct pnv_phb *, int, int);
	struct {
		unsigned int total_pe_num;
		unsigned int reserved_pe_idx;
		unsigned int root_pe_idx;
		unsigned int m32_size;
		unsigned int m32_segsize;
		unsigned int m32_pci_base;
		unsigned int m64_bar_idx;
		long unsigned int m64_size;
		long unsigned int m64_segsize;
		long unsigned int m64_base;
		long unsigned int m64_bar_alloc;
		unsigned int io_size;
		unsigned int io_segsize;
		unsigned int io_pci_base;
		struct mutex pe_alloc_mutex;
		long unsigned int *pe_alloc;
		struct pnv_ioda_pe *pe_array;
		unsigned int *m64_segmap;
		unsigned int *m32_segmap;
		unsigned int *io_segmap;
		int irq_chip_init;
		struct irq_chip irq_chip;
		struct list_head pe_list;
		struct mutex pe_list_mutex;
		unsigned int pe_rmap[65536];
	} ioda;
	unsigned int diag_data_size;
	u8 *diag_data;
};

struct hvcall_mpp_data {
	long unsigned int entitled_mem;
	long unsigned int mapped_mem;
	short unsigned int group_num;
	short unsigned int pool_num;
	unsigned char mem_weight;
	unsigned char unallocated_mem_weight;
	long unsigned int unallocated_entitlement;
	long unsigned int pool_size;
	long int loan_request;
	long unsigned int backing_mem;
};

struct hvcall_mpp_x_data {
	long unsigned int coalesced_bytes;
	long unsigned int pool_coalesced_bytes;
	long unsigned int pool_purr_cycles;
	long unsigned int pool_spurr_cycles;
	long unsigned int reserved[3];
};

struct prtb_entry {
	__be64 prtb0;
	__be64 prtb1;
};

struct dtl_entry {
	u8 dispatch_reason;
	u8 preempt_reason;
	__be16 processor_id;
	__be32 enqueue_to_dispatch_time;
	__be32 ready_to_enqueue_time;
	__be32 waiting_to_ready_time;
	__be64 timebase;
	__be64 fault_addr;
	__be64 srr0;
	__be64 srr1;
};

typedef int (*cpu_stop_fn_t)(void *);

typedef struct {
	const u32 token;
} papr_sysparm_t;

enum {
	PAPR_SYSPARM_MAX_INPUT = 1024,
	PAPR_SYSPARM_MAX_OUTPUT = 4000,
};

struct papr_sysparm_buf {
	__be16 len;
	char val[4000];
};

struct dtl_worker {
	struct delayed_work work;
	int cpu;
};

struct vcpu_dispatch_data {
	int last_disp_cpu;
	int total_disp;
	int same_cpu_disp;
	int same_chip_disp;
	int diff_chip_disp;
	int far_chip_disp;
	int numa_home_disp;
	int numa_remote_disp;
	int numa_far_disp;
};

struct hpt_resize_state {
	long unsigned int shift;
	int commit_rc;
};

struct class_attribute {
	struct attribute attr;
	ssize_t (*show)(const struct class *, const struct class_attribute *, char *);
	ssize_t (*store)(const struct class *, const struct class_attribute *, const char *, size_t);
};

struct class_attribute_string {
	struct class_attribute attr;
	char *str;
};

enum vas_migrate_action {
	VAS_SUSPEND = 0,
	VAS_RESUME = 1,
};

struct update_props_workarea {
	__be32 phandle;
	__be32 state;
	__be64 reserved;
	__be32 nprops;
} __attribute__((packed));

struct pseries_suspend_info {
	atomic_t counter;
	bool done;
};

enum vasi_aborting_entity {
	ORCHESTRATOR = 1,
	VSP_SOURCE = 2,
	PARTITION_FIRMWARE = 3,
	PLATFORM_FIRMWARE = 4,
	VSP_TARGET = 5,
	MIGRATING_PARTITION = 6,
};

struct atomic_notifier_head {
	spinlock_t lock;
	struct notifier_block *head;
};

struct rtas_error_log {
	u8 byte0;
	u8 byte1;
	u8 byte2;
	u8 byte3;
	__be32 extended_log_length;
	unsigned char buffer[1];
};

struct pseries_errorlog {
	__be16 id;
	__be16 length;
	u8 version;
	u8 subtype;
	__be16 creator_component;
	u8 data[0];
};

struct pseries_io_event {
	uint8_t event_type;
	uint8_t rpc_data_len;
	uint8_t scope;
	uint8_t event_subtype;
	uint32_t drc_index;
	uint8_t rpc_data[216];
};

typedef int suspend_state_t;

struct platform_suspend_ops {
	int (*valid)(suspend_state_t);
	int (*begin)(suspend_state_t);
	int (*prepare)();
	int (*prepare_late)();
	int (*enter)(suspend_state_t);
	void (*wake)();
	void (*finish)();
	bool (*suspend_again)();
	void (*end)();
	void (*recover)();
};

struct p9_host_os_sprs {
	long unsigned int iamr;
	long unsigned int amr;
	unsigned int pmc1;
	unsigned int pmc2;
	unsigned int pmc3;
	unsigned int pmc4;
	unsigned int pmc5;
	unsigned int pmc6;
	long unsigned int mmcr0;
	long unsigned int mmcr1;
	long unsigned int mmcr2;
	long unsigned int mmcr3;
	long unsigned int mmcra;
	long unsigned int siar;
	long unsigned int sier1;
	long unsigned int sier2;
	long unsigned int sier3;
	long unsigned int sdar;
};

struct sigaltstack {
	void *ss_sp;
	int ss_flags;
	__kernel_size_t ss_size;
};

typedef struct sigaltstack stack_t;

struct siginfo {
	union {
		struct {
			int si_signo;
			int si_errno;
			int si_code;
			union __sifields _sifields;
		};
		int _si_pad[32];
	};
};

enum perf_callchain_context {
	PERF_CONTEXT_HV = 18446744073709551584ULL,
	PERF_CONTEXT_KERNEL = 18446744073709551488ULL,
	PERF_CONTEXT_USER = 18446744073709551104ULL,
	PERF_CONTEXT_GUEST = 18446744073709549568ULL,
	PERF_CONTEXT_GUEST_KERNEL = 18446744073709549440ULL,
	PERF_CONTEXT_GUEST_USER = 18446744073709549056ULL,
	PERF_CONTEXT_MAX = 18446744073709547521ULL,
};

typedef long unsigned int elf_greg_t64;

typedef elf_greg_t64 elf_gregset_t64[48];

typedef elf_gregset_t64 elf_gregset_t;

typedef double elf_fpreg_t;

typedef elf_fpreg_t elf_fpregset_t[33];

typedef __vector128 elf_vrreg_t;

struct perf_callchain_entry_ctx {
	struct perf_callchain_entry *entry;
	u32 max_stack;
	u32 nr;
	short int contexts;
	bool contexts_maxed;
};

struct sigcontext {
	long unsigned int _unused[4];
	int signal;
	int _pad0;
	long unsigned int handler;
	long unsigned int oldmask;
	struct user_pt_regs *regs;
	elf_gregset_t gp_regs;
	elf_fpregset_t fp_regs;
	elf_vrreg_t *v_regs;
	long int vmx_reserve[101];
};

struct ucontext {
	long unsigned int uc_flags;
	struct ucontext *uc_link;
	stack_t uc_stack;
	sigset_t uc_sigmask;
	sigset_t __unused[15];
	struct sigcontext uc_mcontext;
};

struct signal_frame_64 {
	char dummy[128];
	struct ucontext uc;
	long unsigned int unused[2];
	unsigned int tramp[6];
	struct siginfo *pinfo;
	void *puc;
	struct siginfo info;
	char abigap[288];
};

enum perf_hw_id {
	PERF_COUNT_HW_CPU_CYCLES = 0,
	PERF_COUNT_HW_INSTRUCTIONS = 1,
	PERF_COUNT_HW_CACHE_REFERENCES = 2,
	PERF_COUNT_HW_CACHE_MISSES = 3,
	PERF_COUNT_HW_BRANCH_INSTRUCTIONS = 4,
	PERF_COUNT_HW_BRANCH_MISSES = 5,
	PERF_COUNT_HW_BUS_CYCLES = 6,
	PERF_COUNT_HW_STALLED_CYCLES_FRONTEND = 7,
	PERF_COUNT_HW_STALLED_CYCLES_BACKEND = 8,
	PERF_COUNT_HW_REF_CPU_CYCLES = 9,
	PERF_COUNT_HW_MAX = 10,
};

enum perf_hw_cache_id {
	PERF_COUNT_HW_CACHE_L1D = 0,
	PERF_COUNT_HW_CACHE_L1I = 1,
	PERF_COUNT_HW_CACHE_LL = 2,
	PERF_COUNT_HW_CACHE_DTLB = 3,
	PERF_COUNT_HW_CACHE_ITLB = 4,
	PERF_COUNT_HW_CACHE_BPU = 5,
	PERF_COUNT_HW_CACHE_NODE = 6,
	PERF_COUNT_HW_CACHE_MAX = 7,
};

enum perf_hw_cache_op_id {
	PERF_COUNT_HW_CACHE_OP_READ = 0,
	PERF_COUNT_HW_CACHE_OP_WRITE = 1,
	PERF_COUNT_HW_CACHE_OP_PREFETCH = 2,
	PERF_COUNT_HW_CACHE_OP_MAX = 3,
};

enum perf_hw_cache_op_result_id {
	PERF_COUNT_HW_CACHE_RESULT_ACCESS = 0,
	PERF_COUNT_HW_CACHE_RESULT_MISS = 1,
	PERF_COUNT_HW_CACHE_RESULT_MAX = 2,
};

enum perf_branch_sample_type_shift {
	PERF_SAMPLE_BRANCH_USER_SHIFT = 0,
	PERF_SAMPLE_BRANCH_KERNEL_SHIFT = 1,
	PERF_SAMPLE_BRANCH_HV_SHIFT = 2,
	PERF_SAMPLE_BRANCH_ANY_SHIFT = 3,
	PERF_SAMPLE_BRANCH_ANY_CALL_SHIFT = 4,
	PERF_SAMPLE_BRANCH_ANY_RETURN_SHIFT = 5,
	PERF_SAMPLE_BRANCH_IND_CALL_SHIFT = 6,
	PERF_SAMPLE_BRANCH_ABORT_TX_SHIFT = 7,
	PERF_SAMPLE_BRANCH_IN_TX_SHIFT = 8,
	PERF_SAMPLE_BRANCH_NO_TX_SHIFT = 9,
	PERF_SAMPLE_BRANCH_COND_SHIFT = 10,
	PERF_SAMPLE_BRANCH_CALL_STACK_SHIFT = 11,
	PERF_SAMPLE_BRANCH_IND_JUMP_SHIFT = 12,
	PERF_SAMPLE_BRANCH_CALL_SHIFT = 13,
	PERF_SAMPLE_BRANCH_NO_FLAGS_SHIFT = 14,
	PERF_SAMPLE_BRANCH_NO_CYCLES_SHIFT = 15,
	PERF_SAMPLE_BRANCH_TYPE_SAVE_SHIFT = 16,
	PERF_SAMPLE_BRANCH_HW_INDEX_SHIFT = 17,
	PERF_SAMPLE_BRANCH_PRIV_SAVE_SHIFT = 18,
	PERF_SAMPLE_BRANCH_MAX_SHIFT = 19,
};

struct mmcr_regs {
	long unsigned int mmcr0;
	long unsigned int mmcr1;
	long unsigned int mmcr2;
	long unsigned int mmcra;
	long unsigned int mmcr3;
};

struct power_pmu {
	const char *name;
	int n_counter;
	int max_alternatives;
	long unsigned int add_fields;
	long unsigned int test_adder;
	int (*compute_mmcr)(u64 *, int, unsigned int *, struct mmcr_regs *, struct perf_event **, u32);
	int (*get_constraint)(u64, long unsigned int *, long unsigned int *, u64);
	int (*get_alternatives)(u64, unsigned int, u64 *);
	void (*get_mem_data_src)(union perf_mem_data_src *, u32, struct pt_regs *);
	void (*get_mem_weight)(u64 *, u64);
	long unsigned int group_constraint_mask;
	long unsigned int group_constraint_val;
	u64 (*bhrb_filter_map)(u64);
	void (*config_bhrb)(u64);
	void (*disable_pmc)(unsigned int, struct mmcr_regs *);
	int (*limited_pmc_event)(u64);
	u32 flags;
	const struct attribute_group **attr_groups;
	int n_generic;
	int *generic_events;
	u64 (*cache_events)[42];
	int n_blacklist_ev;
	int *blacklist_ev;
	int bhrb_nr;
	int capabilities;
	int (*check_attr_config)(struct perf_event *);
};

enum perf_branch_sample_type {
	PERF_SAMPLE_BRANCH_USER = 1,
	PERF_SAMPLE_BRANCH_KERNEL = 2,
	PERF_SAMPLE_BRANCH_HV = 4,
	PERF_SAMPLE_BRANCH_ANY = 8,
	PERF_SAMPLE_BRANCH_ANY_CALL = 16,
	PERF_SAMPLE_BRANCH_ANY_RETURN = 32,
	PERF_SAMPLE_BRANCH_IND_CALL = 64,
	PERF_SAMPLE_BRANCH_ABORT_TX = 128,
	PERF_SAMPLE_BRANCH_IN_TX = 256,
	PERF_SAMPLE_BRANCH_NO_TX = 512,
	PERF_SAMPLE_BRANCH_COND = 1024,
	PERF_SAMPLE_BRANCH_CALL_STACK = 2048,
	PERF_SAMPLE_BRANCH_IND_JUMP = 4096,
	PERF_SAMPLE_BRANCH_CALL = 8192,
	PERF_SAMPLE_BRANCH_NO_FLAGS = 16384,
	PERF_SAMPLE_BRANCH_NO_CYCLES = 32768,
	PERF_SAMPLE_BRANCH_TYPE_SAVE = 65536,
	PERF_SAMPLE_BRANCH_HW_INDEX = 131072,
	PERF_SAMPLE_BRANCH_PRIV_SAVE = 262144,
	PERF_SAMPLE_BRANCH_MAX = 524288,
};

struct perf_pmu_events_attr {
	struct device_attribute attr;
	u64 id;
	const char *event_str;
};

enum {
	PM_CYC = 30,
	PM_GCT_NOSLOT_CYC = 65784,
	PM_CMPLU_STALL = 262154,
	PM_INST_CMPL = 2,
	PM_BRU_FIN = 65640,
	PM_BR_MPRED_CMPL = 262390,
	PM_LD_REF_L1 = 65774,
	PM_LD_MISS_L1 = 254036,
	PM_ST_MISS_L1 = 196848,
	PM_L1_PREF = 55480,
	PM_INST_FROM_L1 = 16512,
	PM_L1_ICACHE_MISS = 131325,
	PM_L1_DEMAND_WRITE = 16524,
	PM_IC_PREF_WRITE = 16526,
	PM_DATA_FROM_L3 = 311362,
	PM_DATA_FROM_L3MISS = 196862,
	PM_L2_ST = 94336,
	PM_L2_ST_MISS = 94338,
	PM_L3_PREF_ALL = 319570,
	PM_DTLB_MISS = 196860,
	PM_ITLB_MISS = 262396,
	PM_RUN_INST_CMPL = 327930,
	PM_RUN_INST_CMPL_ALT = 262394,
	PM_RUN_CYC = 393460,
	PM_RUN_CYC_ALT = 131316,
	PM_MRK_ST_CMPL = 65844,
	PM_MRK_ST_CMPL_ALT = 197090,
	PM_BR_MRK_2PATH = 65848,
	PM_BR_MRK_2PATH_ALT = 262456,
	PM_L3_CO_MEPF = 98434,
	PM_L3_CO_MEPF_ALT = 254046,
	PM_MRK_DATA_FROM_L2MISS = 119118,
	PM_MRK_DATA_FROM_L2MISS_ALT = 262632,
	PM_CMPLU_STALL_ALT = 122964,
	PM_BR_2PATH = 131126,
	PM_BR_2PATH_ALT = 262198,
	PM_INST_DISP = 131314,
	PM_INST_DISP_ALT = 196850,
	PM_MRK_FILT_MATCH = 131388,
	PM_MRK_FILT_MATCH_ALT = 196910,
	PM_LD_MISS_L1_ALT = 262384,
	MEM_ACCESS = 17039840,
};

typedef void (*swap_func_t)(void *, void *, int);

typedef int (*cmp_func_t)(const void *, const void *);

typedef __u32 __wsum;

struct __kernel_old_timeval {
	__kernel_long_t tv_sec;
	__kernel_long_t tv_usec;
};

enum refcount_saturation_type {
	REFCOUNT_ADD_NOT_ZERO_OVF = 0,
	REFCOUNT_ADD_OVF = 1,
	REFCOUNT_ADD_UAF = 2,
	REFCOUNT_SUB_UAF = 3,
	REFCOUNT_DEC_LEAK = 4,
};

struct blocking_notifier_head {
	struct rw_semaphore rwsem;
	struct notifier_block *head;
};

struct raw_notifier_head {
	struct notifier_block *head;
};

struct linux_binprm;

struct coredump_params;

struct linux_binfmt {
	struct list_head lh;
	struct module *module;
	int (*load_binary)(struct linux_binprm *);
	int (*load_shlib)(struct file *);
	int (*core_dump)(struct coredump_params *);
	long unsigned int min_coredump;
};

struct rusage {
	struct __kernel_old_timeval ru_utime;
	struct __kernel_old_timeval ru_stime;
	__kernel_long_t ru_maxrss;
	__kernel_long_t ru_ixrss;
	__kernel_long_t ru_idrss;
	__kernel_long_t ru_isrss;
	__kernel_long_t ru_minflt;
	__kernel_long_t ru_majflt;
	__kernel_long_t ru_nswap;
	__kernel_long_t ru_inblock;
	__kernel_long_t ru_oublock;
	__kernel_long_t ru_msgsnd;
	__kernel_long_t ru_msgrcv;
	__kernel_long_t ru_nsignals;
	__kernel_long_t ru_nvcsw;
	__kernel_long_t ru_nivcsw;
};

struct rhashtable;

struct rhashtable_compare_arg {
	struct rhashtable *ht;
	const void *key;
};

typedef u32 (*rht_hashfn_t)(const void *, u32, u32);

typedef u32 (*rht_obj_hashfn_t)(const void *, u32, u32);

typedef int (*rht_obj_cmpfn_t)(struct rhashtable_compare_arg *, const void *);

struct rhashtable_params {
	u16 nelem_hint;
	u16 key_len;
	u16 key_offset;
	u16 head_offset;
	unsigned int max_size;
	u16 min_size;
	bool automatic_shrinking;
	rht_hashfn_t hashfn;
	rht_obj_hashfn_t obj_hashfn;
	rht_obj_cmpfn_t obj_cmpfn;
};

struct bucket_table;

struct rhashtable {
	struct bucket_table *tbl;
	unsigned int key_len;
	unsigned int max_elems;
	struct rhashtable_params p;
	bool rhlist;
	struct work_struct run_work;
	struct mutex mutex;
	spinlock_t lock;
	atomic_t nelems;
};

struct fs_struct {
	int users;
	spinlock_t lock;
	seqcount_spinlock_t seq;
	int umask;
	int in_exec;
	struct path root;
	struct path pwd;
};

struct fdtable {
	unsigned int max_fds;
	struct file **fd;
	long unsigned int *close_on_exec;
	long unsigned int *open_fds;
	long unsigned int *full_fds_bits;
	struct callback_head rcu;
};

struct files_struct {
	atomic_t count;
	bool resize_in_progress;
	wait_queue_head_t resize_wait;
	struct fdtable *fdt;
	struct fdtable fdtab;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	spinlock_t file_lock;
	unsigned int next_fd;
	long unsigned int close_on_exec_init[1];
	long unsigned int open_fds_init[1];
	long unsigned int full_fds_bits_init[1];
	struct file *fd_array[64];
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct robust_list {
	struct robust_list *next;
};

struct robust_list_head {
	struct robust_list list;
	long int futex_offset;
	struct robust_list *list_op_pending;
};

struct pipe_buffer;

struct pipe_inode_info {
	struct mutex mutex;
	wait_queue_head_t rd_wait;
	wait_queue_head_t wr_wait;
	unsigned int head;
	unsigned int tail;
	unsigned int max_usage;
	unsigned int ring_size;
	unsigned int nr_accounted;
	unsigned int readers;
	unsigned int writers;
	unsigned int files;
	unsigned int r_counter;
	unsigned int w_counter;
	bool poll_usage;
	struct page *tmp_page;
	struct fasync_struct *fasync_readers;
	struct fasync_struct *fasync_writers;
	struct pipe_buffer *bufs;
	struct user_struct *user;
};

struct task_delay_info {
	raw_spinlock_t lock;
	u64 blkio_start;
	u64 blkio_delay;
	u64 swapin_start;
	u64 swapin_delay;
	u32 blkio_count;
	u32 swapin_count;
	u64 freepages_start;
	u64 freepages_delay;
	u64 thrashing_start;
	u64 thrashing_delay;
	u64 compact_start;
	u64 compact_delay;
	u64 wpcopy_start;
	u64 wpcopy_delay;
	u64 irq_delay;
	u32 freepages_count;
	u32 thrashing_count;
	u32 compact_count;
	u32 wpcopy_count;
	u32 irq_count;
};

struct ld_semaphore {
	atomic_long_t count;
	raw_spinlock_t wait_lock;
	unsigned int wait_readers;
	struct list_head read_wait;
	struct list_head write_wait;
};

typedef unsigned int tcflag_t;

typedef unsigned char cc_t;

typedef unsigned int speed_t;

struct ktermios {
	tcflag_t c_iflag;
	tcflag_t c_oflag;
	tcflag_t c_cflag;
	tcflag_t c_lflag;
	cc_t c_cc[19];
	cc_t c_line;
	speed_t c_ispeed;
	speed_t c_ospeed;
};

struct winsize {
	short unsigned int ws_row;
	short unsigned int ws_col;
	short unsigned int ws_xpixel;
	short unsigned int ws_ypixel;
};

struct tty_driver;

struct tty_port;

struct tty_operations;

struct tty_ldisc;

struct tty_struct {
	struct kref kref;
	int index;
	struct device *dev;
	struct tty_driver *driver;
	struct tty_port *port;
	const struct tty_operations *ops;
	struct tty_ldisc *ldisc;
	struct ld_semaphore ldisc_sem;
	struct mutex atomic_write_lock;
	struct mutex legacy_mutex;
	struct mutex throttle_mutex;
	struct rw_semaphore termios_rwsem;
	struct mutex winsize_mutex;
	struct ktermios termios;
	struct ktermios termios_locked;
	char name[64];
	long unsigned int flags;
	int count;
	unsigned int receive_room;
	struct winsize winsize;
	struct {
		spinlock_t lock;
		bool stopped;
		bool tco_stopped;
		long unsigned int unused[0];
	} flow;
	struct {
		struct pid *pgrp;
		struct pid *session;
		spinlock_t lock;
		unsigned char pktstatus;
		bool packet;
		long unsigned int unused[0];
	} ctrl;
	bool hw_stopped;
	bool closing;
	int flow_change;
	struct tty_struct *link;
	struct fasync_struct *fasync;
	wait_queue_head_t write_wait;
	wait_queue_head_t read_wait;
	struct work_struct hangup_work;
	void *disc_data;
	void *driver_data;
	spinlock_t files_lock;
	int write_cnt;
	unsigned char *write_buf;
	struct list_head tty_files;
	struct work_struct SAK_work;
};

typedef int __kernel_rwf_t;

struct io_uring_sqe;

struct io_uring_cmd {
	struct file *file;
	const struct io_uring_sqe *sqe;
	union {
		void (*task_work_cb)(struct io_uring_cmd *, unsigned int);
		void *cookie;
	};
	u32 cmd_op;
	u32 flags;
	u8 pdu[32];
};

struct kobj_attribute {
	struct attribute attr;
	ssize_t (*show)(struct kobject *, struct kobj_attribute *, char *);
	ssize_t (*store)(struct kobject *, struct kobj_attribute *, const char *, size_t);
};

struct tty_buffer {
	union {
		struct tty_buffer *next;
		struct llist_node free;
	};
	unsigned int used;
	unsigned int size;
	unsigned int commit;
	unsigned int lookahead;
	unsigned int read;
	bool flags;
	long: 0;
	u8 data[0];
};

struct tty_bufhead {
	struct tty_buffer *head;
	struct work_struct work;
	struct mutex lock;
	atomic_t priority;
	struct tty_buffer sentinel;
	struct llist_head free;
	atomic_t mem_used;
	int mem_limit;
	struct tty_buffer *tail;
};

struct serial_icounter_struct;

struct serial_struct;

struct tty_operations {
	struct tty_struct * (*lookup)(struct tty_driver *, struct file *, int);
	int (*install)(struct tty_driver *, struct tty_struct *);
	void (*remove)(struct tty_driver *, struct tty_struct *);
	int (*open)(struct tty_struct *, struct file *);
	void (*close)(struct tty_struct *, struct file *);
	void (*shutdown)(struct tty_struct *);
	void (*cleanup)(struct tty_struct *);
	ssize_t (*write)(struct tty_struct *, const u8 *, size_t);
	int (*put_char)(struct tty_struct *, u8);
	void (*flush_chars)(struct tty_struct *);
	unsigned int (*write_room)(struct tty_struct *);
	unsigned int (*chars_in_buffer)(struct tty_struct *);
	int (*ioctl)(struct tty_struct *, unsigned int, long unsigned int);
	long int (*compat_ioctl)(struct tty_struct *, unsigned int, long unsigned int);
	void (*set_termios)(struct tty_struct *, const struct ktermios *);
	void (*throttle)(struct tty_struct *);
	void (*unthrottle)(struct tty_struct *);
	void (*stop)(struct tty_struct *);
	void (*start)(struct tty_struct *);
	void (*hangup)(struct tty_struct *);
	int (*break_ctl)(struct tty_struct *, int);
	void (*flush_buffer)(struct tty_struct *);
	void (*set_ldisc)(struct tty_struct *);
	void (*wait_until_sent)(struct tty_struct *, int);
	void (*send_xchar)(struct tty_struct *, char);
	int (*tiocmget)(struct tty_struct *);
	int (*tiocmset)(struct tty_struct *, unsigned int, unsigned int);
	int (*resize)(struct tty_struct *, struct winsize *);
	int (*get_icount)(struct tty_struct *, struct serial_icounter_struct *);
	int (*get_serial)(struct tty_struct *, struct serial_struct *);
	int (*set_serial)(struct tty_struct *, struct serial_struct *);
	void (*show_fdinfo)(struct tty_struct *, struct seq_file *);
	int (*proc_show)(struct seq_file *, void *);
};

struct tty_driver {
	struct kref kref;
	struct cdev **cdevs;
	struct module *owner;
	const char *driver_name;
	const char *name;
	int name_base;
	int major;
	int minor_start;
	unsigned int num;
	short int type;
	short int subtype;
	struct ktermios init_termios;
	long unsigned int flags;
	struct proc_dir_entry *proc_entry;
	struct tty_driver *other;
	struct tty_struct **ttys;
	struct tty_port **ports;
	struct ktermios **termios;
	void *driver_state;
	const struct tty_operations *ops;
	struct list_head tty_drivers;
};

struct __kfifo {
	unsigned int in;
	unsigned int out;
	unsigned int mask;
	unsigned int esize;
	void *data;
};

struct tty_port_operations;

struct tty_port_client_operations;

struct tty_port {
	struct tty_bufhead buf;
	struct tty_struct *tty;
	struct tty_struct *itty;
	const struct tty_port_operations *ops;
	const struct tty_port_client_operations *client_ops;
	spinlock_t lock;
	int blocked_open;
	int count;
	wait_queue_head_t open_wait;
	wait_queue_head_t delta_msr_wait;
	long unsigned int flags;
	long unsigned int iflags;
	unsigned char console: 1;
	struct mutex mutex;
	struct mutex buf_mutex;
	unsigned char *xmit_buf;
	struct {
		union {
			struct __kfifo kfifo;
			unsigned char *type;
			const unsigned char *const_type;
			char (*rectype)[0];
			unsigned char *ptr;
			const unsigned char *ptr_const;
		};
		unsigned char buf[0];
	} xmit_fifo;
	unsigned int close_delay;
	unsigned int closing_wait;
	int drain_delay;
	struct kref kref;
	void *client_data;
};

struct tty_ldisc_ops {
	char *name;
	int num;
	int (*open)(struct tty_struct *);
	void (*close)(struct tty_struct *);
	void (*flush_buffer)(struct tty_struct *);
	ssize_t (*read)(struct tty_struct *, struct file *, u8 *, size_t, void **, long unsigned int);
	ssize_t (*write)(struct tty_struct *, struct file *, const u8 *, size_t);
	int (*ioctl)(struct tty_struct *, unsigned int, long unsigned int);
	int (*compat_ioctl)(struct tty_struct *, unsigned int, long unsigned int);
	void (*set_termios)(struct tty_struct *, const struct ktermios *);
	__poll_t (*poll)(struct tty_struct *, struct file *, struct poll_table_struct *);
	void (*hangup)(struct tty_struct *);
	void (*receive_buf)(struct tty_struct *, const u8 *, const u8 *, size_t);
	void (*write_wakeup)(struct tty_struct *);
	void (*dcd_change)(struct tty_struct *, bool);
	size_t (*receive_buf2)(struct tty_struct *, const u8 *, const u8 *, size_t);
	void (*lookahead_buf)(struct tty_struct *, const u8 *, const u8 *, size_t);
	struct module *owner;
};

struct tty_ldisc {
	struct tty_ldisc_ops *ops;
	struct tty_struct *tty;
};

struct tty_port_operations {
	bool (*carrier_raised)(struct tty_port *);
	void (*dtr_rts)(struct tty_port *, bool);
	void (*shutdown)(struct tty_port *);
	int (*activate)(struct tty_port *, struct tty_struct *);
	void (*destruct)(struct tty_port *);
};

struct tty_port_client_operations {
	size_t (*receive_buf)(struct tty_port *, const u8 *, const u8 *, size_t);
	void (*lookahead_buf)(struct tty_port *, const u8 *, const u8 *, size_t);
	void (*write_wakeup)(struct tty_port *);
};

struct linux_binprm {
	struct vm_area_struct *vma;
	long unsigned int vma_pages;
	struct mm_struct *mm;
	long unsigned int p;
	long unsigned int argmin;
	unsigned int have_execfd: 1;
	unsigned int execfd_creds: 1;
	unsigned int secureexec: 1;
	unsigned int point_of_no_return: 1;
	struct file *executable;
	struct file *interpreter;
	struct file *file;
	struct cred *cred;
	int unsafe;
	unsigned int per_clear;
	int argc;
	int envc;
	const char *filename;
	const char *interp;
	const char *fdpath;
	unsigned int interp_flags;
	int execfd;
	long unsigned int loader;
	long unsigned int exec;
	struct rlimit rlim_stack;
	char buf[256];
};

struct new_utsname {
	char sysname[65];
	char nodename[65];
	char release[65];
	char version[65];
	char machine[65];
	char domainname[65];
};

struct uts_namespace {
	struct new_utsname name;
	struct user_namespace *user_ns;
	struct ucounts *ucounts;
	struct ns_common ns;
};

struct ref_tracker_dir {
	spinlock_t lock;
	unsigned int quarantine_avail;
	refcount_t untracked;
	refcount_t no_tracker;
	bool dead;
	struct list_head list;
	struct list_head quarantine;
	char name[32];
};

struct prot_inuse;

struct netns_core {
	struct ctl_table_header *sysctl_hdr;
	int sysctl_somaxconn;
	u8 sysctl_txrehash;
	struct prot_inuse *prot_inuse;
	struct cpumask *rps_default_mask;
};

struct ipstats_mib;

struct tcp_mib;

struct linux_mib;

struct udp_mib;

struct icmp_mib;

struct icmpmsg_mib;

struct icmpv6_mib;

struct icmpv6msg_mib;

struct netns_mib {
	struct ipstats_mib *ip_statistics;
	struct ipstats_mib *ipv6_statistics;
	struct tcp_mib *tcp_statistics;
	struct linux_mib *net_statistics;
	struct udp_mib *udp_statistics;
	struct udp_mib *udp_stats_in6;
	struct udp_mib *udplite_statistics;
	struct udp_mib *udplite_stats_in6;
	struct icmp_mib *icmp_statistics;
	struct icmpmsg_mib *icmpmsg_statistics;
	struct icmpv6_mib *icmpv6_statistics;
	struct icmpv6msg_mib *icmpv6msg_statistics;
	struct proc_dir_entry *proc_net_devsnmp6;
};

struct netns_packet {
	struct mutex sklist_lock;
	struct hlist_head sklist;
};

struct unix_table {
	spinlock_t *locks;
	struct hlist_head *buckets;
};

struct netns_unix {
	struct unix_table table;
	int sysctl_max_dgram_qlen;
	struct ctl_table_header *ctl;
};

struct netns_nexthop {
	struct rb_root rb_root;
	struct hlist_head *devhash;
	unsigned int seq;
	u32 last_id_allocated;
	struct blocking_notifier_head notifier_chain;
};

struct inet_hashinfo;

struct inet_timewait_death_row {
	refcount_t tw_refcount;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct inet_hashinfo *hashinfo;
	int sysctl_max_tw_buckets;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct local_ports {
	seqlock_t lock;
	int range[2];
	bool warned;
};

struct ping_group_range {
	seqlock_t lock;
	kgid_t range[2];
};

typedef struct {
	u64 key[2];
} siphash_key_t;

struct udp_table;

struct ipv4_devconf;

struct ip_ra_chain;

struct inet_peer_base;

struct fqdir;

struct tcp_congestion_ops;

struct tcp_fastopen_context;

struct fib_notifier_ops;

struct netns_ipv4 {
	struct inet_timewait_death_row tcp_death_row;
	struct udp_table *udp_table;
	struct ctl_table_header *forw_hdr;
	struct ctl_table_header *frags_hdr;
	struct ctl_table_header *ipv4_hdr;
	struct ctl_table_header *route_hdr;
	struct ctl_table_header *xfrm4_hdr;
	struct ipv4_devconf *devconf_all;
	struct ipv4_devconf *devconf_dflt;
	struct ip_ra_chain *ra_chain;
	struct mutex ra_mutex;
	bool fib_has_custom_local_routes;
	bool fib_offload_disabled;
	u8 sysctl_tcp_shrink_window;
	struct hlist_head *fib_table_hash;
	struct sock *fibnl;
	struct sock *mc_autojoin_sk;
	struct inet_peer_base *peers;
	struct fqdir *fqdir;
	u8 sysctl_icmp_echo_ignore_all;
	u8 sysctl_icmp_echo_enable_probe;
	u8 sysctl_icmp_echo_ignore_broadcasts;
	u8 sysctl_icmp_ignore_bogus_error_responses;
	u8 sysctl_icmp_errors_use_inbound_ifaddr;
	int sysctl_icmp_ratelimit;
	int sysctl_icmp_ratemask;
	u32 ip_rt_min_pmtu;
	int ip_rt_mtu_expires;
	int ip_rt_min_advmss;
	struct local_ports ip_local_ports;
	u8 sysctl_tcp_ecn;
	u8 sysctl_tcp_ecn_fallback;
	u8 sysctl_ip_default_ttl;
	u8 sysctl_ip_no_pmtu_disc;
	u8 sysctl_ip_fwd_use_pmtu;
	u8 sysctl_ip_fwd_update_priority;
	u8 sysctl_ip_nonlocal_bind;
	u8 sysctl_ip_autobind_reuse;
	u8 sysctl_ip_dynaddr;
	u8 sysctl_ip_early_demux;
	u8 sysctl_tcp_early_demux;
	u8 sysctl_udp_early_demux;
	u8 sysctl_nexthop_compat_mode;
	u8 sysctl_fwmark_reflect;
	u8 sysctl_tcp_fwmark_accept;
	u8 sysctl_tcp_mtu_probing;
	int sysctl_tcp_mtu_probe_floor;
	int sysctl_tcp_base_mss;
	int sysctl_tcp_min_snd_mss;
	int sysctl_tcp_probe_threshold;
	u32 sysctl_tcp_probe_interval;
	int sysctl_tcp_keepalive_time;
	int sysctl_tcp_keepalive_intvl;
	u8 sysctl_tcp_keepalive_probes;
	u8 sysctl_tcp_syn_retries;
	u8 sysctl_tcp_synack_retries;
	u8 sysctl_tcp_syncookies;
	u8 sysctl_tcp_migrate_req;
	u8 sysctl_tcp_comp_sack_nr;
	int sysctl_tcp_reordering;
	u8 sysctl_tcp_retries1;
	u8 sysctl_tcp_retries2;
	u8 sysctl_tcp_orphan_retries;
	u8 sysctl_tcp_tw_reuse;
	int sysctl_tcp_fin_timeout;
	unsigned int sysctl_tcp_notsent_lowat;
	u8 sysctl_tcp_sack;
	u8 sysctl_tcp_window_scaling;
	u8 sysctl_tcp_timestamps;
	u8 sysctl_tcp_early_retrans;
	u8 sysctl_tcp_recovery;
	u8 sysctl_tcp_thin_linear_timeouts;
	u8 sysctl_tcp_slow_start_after_idle;
	u8 sysctl_tcp_retrans_collapse;
	u8 sysctl_tcp_stdurg;
	u8 sysctl_tcp_rfc1337;
	u8 sysctl_tcp_abort_on_overflow;
	u8 sysctl_tcp_fack;
	int sysctl_tcp_max_reordering;
	int sysctl_tcp_adv_win_scale;
	u8 sysctl_tcp_dsack;
	u8 sysctl_tcp_app_win;
	u8 sysctl_tcp_frto;
	u8 sysctl_tcp_nometrics_save;
	u8 sysctl_tcp_no_ssthresh_metrics_save;
	u8 sysctl_tcp_moderate_rcvbuf;
	u8 sysctl_tcp_tso_win_divisor;
	u8 sysctl_tcp_workaround_signed_windows;
	int sysctl_tcp_limit_output_bytes;
	int sysctl_tcp_challenge_ack_limit;
	int sysctl_tcp_min_rtt_wlen;
	u8 sysctl_tcp_min_tso_segs;
	u8 sysctl_tcp_tso_rtt_log;
	u8 sysctl_tcp_autocorking;
	u8 sysctl_tcp_reflect_tos;
	int sysctl_tcp_invalid_ratelimit;
	int sysctl_tcp_pacing_ss_ratio;
	int sysctl_tcp_pacing_ca_ratio;
	int sysctl_tcp_wmem[3];
	int sysctl_tcp_rmem[3];
	unsigned int sysctl_tcp_child_ehash_entries;
	long unsigned int sysctl_tcp_comp_sack_delay_ns;
	long unsigned int sysctl_tcp_comp_sack_slack_ns;
	int sysctl_max_syn_backlog;
	int sysctl_tcp_fastopen;
	const struct tcp_congestion_ops *tcp_congestion_control;
	struct tcp_fastopen_context *tcp_fastopen_ctx;
	unsigned int sysctl_tcp_fastopen_blackhole_timeout;
	atomic_t tfo_active_disable_times;
	long unsigned int tfo_active_disable_stamp;
	u32 tcp_challenge_timestamp;
	u32 tcp_challenge_count;
	u8 sysctl_tcp_plb_enabled;
	u8 sysctl_tcp_plb_idle_rehash_rounds;
	u8 sysctl_tcp_plb_rehash_rounds;
	u8 sysctl_tcp_plb_suspend_rto_sec;
	int sysctl_tcp_plb_cong_thresh;
	int sysctl_udp_wmem_min;
	int sysctl_udp_rmem_min;
	u8 sysctl_fib_notify_on_flag_change;
	u8 sysctl_tcp_syn_linear_timeouts;
	u8 sysctl_igmp_llm_reports;
	int sysctl_igmp_max_memberships;
	int sysctl_igmp_max_msf;
	int sysctl_igmp_qrv;
	struct ping_group_range ping_group_range;
	atomic_t dev_addr_genid;
	unsigned int sysctl_udp_child_hash_entries;
	long unsigned int *sysctl_local_reserved_ports;
	int sysctl_ip_prot_sock;
	struct fib_notifier_ops *notifier_ops;
	unsigned int fib_seq;
	struct fib_notifier_ops *ipmr_notifier_ops;
	unsigned int ipmr_seq;
	atomic_t rt_genid;
	siphash_key_t ip_id_key;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct dst_entry;

struct net_device;

struct sk_buff;

struct neighbour;

struct dst_ops {
	short unsigned int family;
	unsigned int gc_thresh;
	void (*gc)(struct dst_ops *);
	struct dst_entry * (*check)(struct dst_entry *, __u32);
	unsigned int (*default_advmss)(const struct dst_entry *);
	unsigned int (*mtu)(const struct dst_entry *);
	u32 * (*cow_metrics)(struct dst_entry *, long unsigned int);
	void (*destroy)(struct dst_entry *);
	void (*ifdown)(struct dst_entry *, struct net_device *);
	struct dst_entry * (*negative_advice)(struct dst_entry *);
	void (*link_failure)(struct sk_buff *);
	void (*update_pmtu)(struct dst_entry *, struct sock *, struct sk_buff *, u32, bool);
	void (*redirect)(struct dst_entry *, struct sock *, struct sk_buff *);
	int (*local_out)(struct net *, struct sock *, struct sk_buff *);
	struct neighbour * (*neigh_lookup)(const struct dst_entry *, struct sk_buff *, const void *);
	void (*confirm_neigh)(const struct dst_entry *, const void *);
	struct kmem_cache *kmem_cachep;
	struct percpu_counter pcpuc_entries;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct netns_sysctl_ipv6 {
	struct ctl_table_header *hdr;
	struct ctl_table_header *route_hdr;
	struct ctl_table_header *icmp_hdr;
	struct ctl_table_header *frags_hdr;
	struct ctl_table_header *xfrm6_hdr;
	int flush_delay;
	int ip6_rt_max_size;
	int ip6_rt_gc_min_interval;
	int ip6_rt_gc_timeout;
	int ip6_rt_gc_interval;
	int ip6_rt_gc_elasticity;
	int ip6_rt_mtu_expires;
	int ip6_rt_min_advmss;
	u32 multipath_hash_fields;
	u8 multipath_hash_policy;
	u8 bindv6only;
	u8 flowlabel_consistency;
	u8 auto_flowlabels;
	int icmpv6_time;
	u8 icmpv6_echo_ignore_all;
	u8 icmpv6_echo_ignore_multicast;
	u8 icmpv6_echo_ignore_anycast;
	long unsigned int icmpv6_ratemask[4];
	long unsigned int *icmpv6_ratemask_ptr;
	u8 anycast_src_echo_reply;
	u8 ip_nonlocal_bind;
	u8 fwmark_reflect;
	u8 flowlabel_state_ranges;
	int idgen_retries;
	int idgen_delay;
	int flowlabel_reflect;
	int max_dst_opts_cnt;
	int max_hbh_opts_cnt;
	int max_dst_opts_len;
	int max_hbh_opts_len;
	int seg6_flowlabel;
	u32 ioam6_id;
	u64 ioam6_id_wide;
	u8 skip_notify_on_dev_down;
	u8 fib_notify_on_flag_change;
	u8 icmpv6_error_anycast_as_unicast;
};

struct ipv6_devconf;

struct fib6_info;

struct rt6_info;

struct rt6_statistics;

struct fib6_table;

struct seg6_pernet_data;

struct ioam6_pernet_data;

struct netns_ipv6 {
	struct dst_ops ip6_dst_ops;
	struct netns_sysctl_ipv6 sysctl;
	struct ipv6_devconf *devconf_all;
	struct ipv6_devconf *devconf_dflt;
	struct inet_peer_base *peers;
	struct fqdir *fqdir;
	struct fib6_info *fib6_null_entry;
	struct rt6_info *ip6_null_entry;
	struct rt6_statistics *rt6_stats;
	struct timer_list ip6_fib_timer;
	struct hlist_head *fib_table_hash;
	struct fib6_table *fib6_main_tbl;
	struct list_head fib6_walkers;
	rwlock_t fib6_walker_lock;
	spinlock_t fib6_gc_lock;
	atomic_t ip6_rt_gc_expire;
	long unsigned int ip6_rt_last_gc;
	unsigned char flowlabel_has_excl;
	struct sock *ndisc_sk;
	struct sock *tcp_sk;
	struct sock *igmp_sk;
	struct sock *mc_autojoin_sk;
	struct hlist_head *inet6_addr_lst;
	spinlock_t addrconf_hash_lock;
	struct delayed_work addr_chk_work;
	atomic_t dev_addr_genid;
	atomic_t fib6_sernum;
	struct seg6_pernet_data *seg6_data;
	struct fib_notifier_ops *notifier_ops;
	struct fib_notifier_ops *ip6mr_notifier_ops;
	unsigned int ipmr_seq;
	struct {
		struct hlist_head head;
		spinlock_t lock;
		u32 seq;
	} ip6addrlbl_table;
	struct ioam6_pernet_data *ioam6_data;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct nf_logger;

struct nf_hook_entries;

struct netns_nf {
	struct proc_dir_entry *proc_netfilter;
	const struct nf_logger *nf_loggers[11];
	struct ctl_table_header *nf_log_dir_header;
	struct nf_hook_entries *hooks_ipv4[5];
	struct nf_hook_entries *hooks_ipv6[5];
	unsigned int defrag_ipv4_users;
	unsigned int defrag_ipv6_users;
};

struct nf_ct_event_notifier;

struct nf_generic_net {
	unsigned int timeout;
};

struct nf_tcp_net {
	unsigned int timeouts[14];
	u8 tcp_loose;
	u8 tcp_be_liberal;
	u8 tcp_max_retrans;
	u8 tcp_ignore_invalid_rst;
};

struct nf_udp_net {
	unsigned int timeouts[2];
};

struct nf_icmp_net {
	unsigned int timeout;
};

struct nf_ip_net {
	struct nf_generic_net generic;
	struct nf_tcp_net tcp;
	struct nf_udp_net udp;
	struct nf_icmp_net icmp;
	struct nf_icmp_net icmpv6;
};

struct ip_conntrack_stat;

struct netns_ct {
	u8 sysctl_log_invalid;
	u8 sysctl_events;
	u8 sysctl_acct;
	u8 sysctl_tstamp;
	u8 sysctl_checksum;
	struct ip_conntrack_stat *stat;
	struct nf_ct_event_notifier *nf_conntrack_event_cb;
	struct nf_ip_net nf_ct_proto;
};

struct netns_bpf {
	struct bpf_prog_array *run_array[2];
	struct bpf_prog *progs[2];
	struct list_head links[2];
};

struct xfrm_policy_hash {
	struct hlist_head *table;
	unsigned int hmask;
	u8 dbits4;
	u8 sbits4;
	u8 dbits6;
	u8 sbits6;
};

struct xfrm_policy_hthresh {
	struct work_struct work;
	seqlock_t lock;
	u8 lbits4;
	u8 rbits4;
	u8 lbits6;
	u8 rbits6;
};

struct netns_xfrm {
	struct list_head state_all;
	struct hlist_head *state_bydst;
	struct hlist_head *state_bysrc;
	struct hlist_head *state_byspi;
	struct hlist_head *state_byseq;
	unsigned int state_hmask;
	unsigned int state_num;
	struct work_struct state_hash_work;
	struct list_head policy_all;
	struct hlist_head *policy_byidx;
	unsigned int policy_idx_hmask;
	unsigned int idx_generator;
	struct hlist_head policy_inexact[3];
	struct xfrm_policy_hash policy_bydst[3];
	unsigned int policy_count[6];
	struct work_struct policy_hash_work;
	struct xfrm_policy_hthresh policy_hthresh;
	struct list_head inexact_bins;
	struct sock *nlsk;
	struct sock *nlsk_stash;
	u32 sysctl_aevent_etime;
	u32 sysctl_aevent_rseqth;
	int sysctl_larval_drop;
	u32 sysctl_acq_expires;
	u8 policy_default[3];
	struct ctl_table_header *sysctl_hdr;
	long: 64;
	long: 64;
	long: 64;
	struct dst_ops xfrm4_dst_ops;
	struct dst_ops xfrm6_dst_ops;
	spinlock_t xfrm_state_lock;
	seqcount_spinlock_t xfrm_state_hash_generation;
	seqcount_spinlock_t xfrm_policy_hash_generation;
	spinlock_t xfrm_policy_lock;
	struct mutex xfrm_cfg_mutex;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct uevent_sock;

struct net_generic;

struct net {
	refcount_t passive;
	spinlock_t rules_mod_lock;
	atomic_t dev_unreg_count;
	unsigned int dev_base_seq;
	u32 ifindex;
	spinlock_t nsid_lock;
	atomic_t fnhe_genid;
	struct list_head list;
	struct list_head exit_list;
	struct llist_node cleanup_list;
	struct key_tag *key_domain;
	struct user_namespace *user_ns;
	struct ucounts *ucounts;
	struct idr netns_ids;
	struct ns_common ns;
	struct ref_tracker_dir refcnt_tracker;
	struct ref_tracker_dir notrefcnt_tracker;
	struct list_head dev_base_head;
	struct proc_dir_entry *proc_net;
	struct proc_dir_entry *proc_net_stat;
	struct ctl_table_set sysctls;
	struct sock *rtnl;
	struct sock *genl_sock;
	struct uevent_sock *uevent_sock;
	struct hlist_head *dev_name_head;
	struct hlist_head *dev_index_head;
	struct xarray dev_by_index;
	struct raw_notifier_head netdev_chain;
	u32 hash_mix;
	struct net_device *loopback_dev;
	struct list_head rules_ops;
	struct netns_core core;
	struct netns_mib mib;
	struct netns_packet packet;
	struct netns_unix unx;
	struct netns_nexthop nexthop;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct netns_ipv4 ipv4;
	struct netns_ipv6 ipv6;
	struct netns_nf nf;
	struct netns_ct ct;
	struct net_generic *gen;
	struct netns_bpf bpf;
	long: 64;
	long: 64;
	struct netns_xfrm xfrm;
	u64 net_cookie;
	struct sock *diag_nlsk;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

enum {
	TRACE_EVENT_FL_FILTERED = 1,
	TRACE_EVENT_FL_CAP_ANY = 2,
	TRACE_EVENT_FL_NO_SET_FILTER = 4,
	TRACE_EVENT_FL_IGNORE_ENABLE = 8,
	TRACE_EVENT_FL_TRACEPOINT = 16,
	TRACE_EVENT_FL_DYNAMIC = 32,
	TRACE_EVENT_FL_KPROBE = 64,
	TRACE_EVENT_FL_UPROBE = 128,
	TRACE_EVENT_FL_EPROBE = 256,
	TRACE_EVENT_FL_FPROBE = 512,
	TRACE_EVENT_FL_CUSTOM = 1024,
};

struct syscall_metadata {
	const char *name;
	int syscall_nr;
	int nb_args;
	const char **types;
	const char **args;
	struct list_head enter_fields;
	struct trace_event_call *enter_event;
	struct trace_event_call *exit_event;
};

struct pipe_buf_operations;

struct pipe_buffer {
	struct page *page;
	unsigned int offset;
	unsigned int len;
	const struct pipe_buf_operations *ops;
	unsigned int flags;
	long unsigned int private;
};

struct pipe_buf_operations {
	int (*confirm)(struct pipe_inode_info *, struct pipe_buffer *);
	void (*release)(struct pipe_inode_info *, struct pipe_buffer *);
	bool (*try_steal)(struct pipe_inode_info *, struct pipe_buffer *);
	bool (*get)(struct pipe_inode_info *, struct pipe_buffer *);
};

enum audit_ntp_type {
	AUDIT_NTP_OFFSET = 0,
	AUDIT_NTP_FREQ = 1,
	AUDIT_NTP_STATUS = 2,
	AUDIT_NTP_TAI = 3,
	AUDIT_NTP_TICK = 4,
	AUDIT_NTP_ADJUST = 5,
	AUDIT_NTP_NVALS = 6,
};

struct in6_addr {
	union {
		__u8 u6_addr8[16];
		__be16 u6_addr16[8];
		__be32 u6_addr32[4];
	} in6_u;
};

enum {
	IPSTATS_MIB_NUM = 0,
	IPSTATS_MIB_INPKTS = 1,
	IPSTATS_MIB_INOCTETS = 2,
	IPSTATS_MIB_INDELIVERS = 3,
	IPSTATS_MIB_OUTFORWDATAGRAMS = 4,
	IPSTATS_MIB_OUTPKTS = 5,
	IPSTATS_MIB_OUTOCTETS = 6,
	IPSTATS_MIB_INHDRERRORS = 7,
	IPSTATS_MIB_INTOOBIGERRORS = 8,
	IPSTATS_MIB_INNOROUTES = 9,
	IPSTATS_MIB_INADDRERRORS = 10,
	IPSTATS_MIB_INUNKNOWNPROTOS = 11,
	IPSTATS_MIB_INTRUNCATEDPKTS = 12,
	IPSTATS_MIB_INDISCARDS = 13,
	IPSTATS_MIB_OUTDISCARDS = 14,
	IPSTATS_MIB_OUTNOROUTES = 15,
	IPSTATS_MIB_REASMTIMEOUT = 16,
	IPSTATS_MIB_REASMREQDS = 17,
	IPSTATS_MIB_REASMOKS = 18,
	IPSTATS_MIB_REASMFAILS = 19,
	IPSTATS_MIB_FRAGOKS = 20,
	IPSTATS_MIB_FRAGFAILS = 21,
	IPSTATS_MIB_FRAGCREATES = 22,
	IPSTATS_MIB_INMCASTPKTS = 23,
	IPSTATS_MIB_OUTMCASTPKTS = 24,
	IPSTATS_MIB_INBCASTPKTS = 25,
	IPSTATS_MIB_OUTBCASTPKTS = 26,
	IPSTATS_MIB_INMCASTOCTETS = 27,
	IPSTATS_MIB_OUTMCASTOCTETS = 28,
	IPSTATS_MIB_INBCASTOCTETS = 29,
	IPSTATS_MIB_OUTBCASTOCTETS = 30,
	IPSTATS_MIB_CSUMERRORS = 31,
	IPSTATS_MIB_NOECTPKTS = 32,
	IPSTATS_MIB_ECT1PKTS = 33,
	IPSTATS_MIB_ECT0PKTS = 34,
	IPSTATS_MIB_CEPKTS = 35,
	IPSTATS_MIB_REASM_OVERLAPS = 36,
	__IPSTATS_MIB_MAX = 37,
};

enum {
	ICMP_MIB_NUM = 0,
	ICMP_MIB_INMSGS = 1,
	ICMP_MIB_INERRORS = 2,
	ICMP_MIB_INDESTUNREACHS = 3,
	ICMP_MIB_INTIMEEXCDS = 4,
	ICMP_MIB_INPARMPROBS = 5,
	ICMP_MIB_INSRCQUENCHS = 6,
	ICMP_MIB_INREDIRECTS = 7,
	ICMP_MIB_INECHOS = 8,
	ICMP_MIB_INECHOREPS = 9,
	ICMP_MIB_INTIMESTAMPS = 10,
	ICMP_MIB_INTIMESTAMPREPS = 11,
	ICMP_MIB_INADDRMASKS = 12,
	ICMP_MIB_INADDRMASKREPS = 13,
	ICMP_MIB_OUTMSGS = 14,
	ICMP_MIB_OUTERRORS = 15,
	ICMP_MIB_OUTDESTUNREACHS = 16,
	ICMP_MIB_OUTTIMEEXCDS = 17,
	ICMP_MIB_OUTPARMPROBS = 18,
	ICMP_MIB_OUTSRCQUENCHS = 19,
	ICMP_MIB_OUTREDIRECTS = 20,
	ICMP_MIB_OUTECHOS = 21,
	ICMP_MIB_OUTECHOREPS = 22,
	ICMP_MIB_OUTTIMESTAMPS = 23,
	ICMP_MIB_OUTTIMESTAMPREPS = 24,
	ICMP_MIB_OUTADDRMASKS = 25,
	ICMP_MIB_OUTADDRMASKREPS = 26,
	ICMP_MIB_CSUMERRORS = 27,
	ICMP_MIB_RATELIMITGLOBAL = 28,
	ICMP_MIB_RATELIMITHOST = 29,
	__ICMP_MIB_MAX = 30,
};

enum {
	ICMP6_MIB_NUM = 0,
	ICMP6_MIB_INMSGS = 1,
	ICMP6_MIB_INERRORS = 2,
	ICMP6_MIB_OUTMSGS = 3,
	ICMP6_MIB_OUTERRORS = 4,
	ICMP6_MIB_CSUMERRORS = 5,
	ICMP6_MIB_RATELIMITHOST = 6,
	__ICMP6_MIB_MAX = 7,
};

enum {
	TCP_MIB_NUM = 0,
	TCP_MIB_RTOALGORITHM = 1,
	TCP_MIB_RTOMIN = 2,
	TCP_MIB_RTOMAX = 3,
	TCP_MIB_MAXCONN = 4,
	TCP_MIB_ACTIVEOPENS = 5,
	TCP_MIB_PASSIVEOPENS = 6,
	TCP_MIB_ATTEMPTFAILS = 7,
	TCP_MIB_ESTABRESETS = 8,
	TCP_MIB_CURRESTAB = 9,
	TCP_MIB_INSEGS = 10,
	TCP_MIB_OUTSEGS = 11,
	TCP_MIB_RETRANSSEGS = 12,
	TCP_MIB_INERRS = 13,
	TCP_MIB_OUTRSTS = 14,
	TCP_MIB_CSUMERRORS = 15,
	__TCP_MIB_MAX = 16,
};

enum {
	UDP_MIB_NUM = 0,
	UDP_MIB_INDATAGRAMS = 1,
	UDP_MIB_NOPORTS = 2,
	UDP_MIB_INERRORS = 3,
	UDP_MIB_OUTDATAGRAMS = 4,
	UDP_MIB_RCVBUFERRORS = 5,
	UDP_MIB_SNDBUFERRORS = 6,
	UDP_MIB_CSUMERRORS = 7,
	UDP_MIB_IGNOREDMULTI = 8,
	UDP_MIB_MEMERRORS = 9,
	__UDP_MIB_MAX = 10,
};

enum {
	LINUX_MIB_NUM = 0,
	LINUX_MIB_SYNCOOKIESSENT = 1,
	LINUX_MIB_SYNCOOKIESRECV = 2,
	LINUX_MIB_SYNCOOKIESFAILED = 3,
	LINUX_MIB_EMBRYONICRSTS = 4,
	LINUX_MIB_PRUNECALLED = 5,
	LINUX_MIB_RCVPRUNED = 6,
	LINUX_MIB_OFOPRUNED = 7,
	LINUX_MIB_OUTOFWINDOWICMPS = 8,
	LINUX_MIB_LOCKDROPPEDICMPS = 9,
	LINUX_MIB_ARPFILTER = 10,
	LINUX_MIB_TIMEWAITED = 11,
	LINUX_MIB_TIMEWAITRECYCLED = 12,
	LINUX_MIB_TIMEWAITKILLED = 13,
	LINUX_MIB_PAWSACTIVEREJECTED = 14,
	LINUX_MIB_PAWSESTABREJECTED = 15,
	LINUX_MIB_DELAYEDACKS = 16,
	LINUX_MIB_DELAYEDACKLOCKED = 17,
	LINUX_MIB_DELAYEDACKLOST = 18,
	LINUX_MIB_LISTENOVERFLOWS = 19,
	LINUX_MIB_LISTENDROPS = 20,
	LINUX_MIB_TCPHPHITS = 21,
	LINUX_MIB_TCPPUREACKS = 22,
	LINUX_MIB_TCPHPACKS = 23,
	LINUX_MIB_TCPRENORECOVERY = 24,
	LINUX_MIB_TCPSACKRECOVERY = 25,
	LINUX_MIB_TCPSACKRENEGING = 26,
	LINUX_MIB_TCPSACKREORDER = 27,
	LINUX_MIB_TCPRENOREORDER = 28,
	LINUX_MIB_TCPTSREORDER = 29,
	LINUX_MIB_TCPFULLUNDO = 30,
	LINUX_MIB_TCPPARTIALUNDO = 31,
	LINUX_MIB_TCPDSACKUNDO = 32,
	LINUX_MIB_TCPLOSSUNDO = 33,
	LINUX_MIB_TCPLOSTRETRANSMIT = 34,
	LINUX_MIB_TCPRENOFAILURES = 35,
	LINUX_MIB_TCPSACKFAILURES = 36,
	LINUX_MIB_TCPLOSSFAILURES = 37,
	LINUX_MIB_TCPFASTRETRANS = 38,
	LINUX_MIB_TCPSLOWSTARTRETRANS = 39,
	LINUX_MIB_TCPTIMEOUTS = 40,
	LINUX_MIB_TCPLOSSPROBES = 41,
	LINUX_MIB_TCPLOSSPROBERECOVERY = 42,
	LINUX_MIB_TCPRENORECOVERYFAIL = 43,
	LINUX_MIB_TCPSACKRECOVERYFAIL = 44,
	LINUX_MIB_TCPRCVCOLLAPSED = 45,
	LINUX_MIB_TCPDSACKOLDSENT = 46,
	LINUX_MIB_TCPDSACKOFOSENT = 47,
	LINUX_MIB_TCPDSACKRECV = 48,
	LINUX_MIB_TCPDSACKOFORECV = 49,
	LINUX_MIB_TCPABORTONDATA = 50,
	LINUX_MIB_TCPABORTONCLOSE = 51,
	LINUX_MIB_TCPABORTONMEMORY = 52,
	LINUX_MIB_TCPABORTONTIMEOUT = 53,
	LINUX_MIB_TCPABORTONLINGER = 54,
	LINUX_MIB_TCPABORTFAILED = 55,
	LINUX_MIB_TCPMEMORYPRESSURES = 56,
	LINUX_MIB_TCPMEMORYPRESSURESCHRONO = 57,
	LINUX_MIB_TCPSACKDISCARD = 58,
	LINUX_MIB_TCPDSACKIGNOREDOLD = 59,
	LINUX_MIB_TCPDSACKIGNOREDNOUNDO = 60,
	LINUX_MIB_TCPSPURIOUSRTOS = 61,
	LINUX_MIB_TCPMD5NOTFOUND = 62,
	LINUX_MIB_TCPMD5UNEXPECTED = 63,
	LINUX_MIB_TCPMD5FAILURE = 64,
	LINUX_MIB_SACKSHIFTED = 65,
	LINUX_MIB_SACKMERGED = 66,
	LINUX_MIB_SACKSHIFTFALLBACK = 67,
	LINUX_MIB_TCPBACKLOGDROP = 68,
	LINUX_MIB_PFMEMALLOCDROP = 69,
	LINUX_MIB_TCPMINTTLDROP = 70,
	LINUX_MIB_TCPDEFERACCEPTDROP = 71,
	LINUX_MIB_IPRPFILTER = 72,
	LINUX_MIB_TCPTIMEWAITOVERFLOW = 73,
	LINUX_MIB_TCPREQQFULLDOCOOKIES = 74,
	LINUX_MIB_TCPREQQFULLDROP = 75,
	LINUX_MIB_TCPRETRANSFAIL = 76,
	LINUX_MIB_TCPRCVCOALESCE = 77,
	LINUX_MIB_TCPBACKLOGCOALESCE = 78,
	LINUX_MIB_TCPOFOQUEUE = 79,
	LINUX_MIB_TCPOFODROP = 80,
	LINUX_MIB_TCPOFOMERGE = 81,
	LINUX_MIB_TCPCHALLENGEACK = 82,
	LINUX_MIB_TCPSYNCHALLENGE = 83,
	LINUX_MIB_TCPFASTOPENACTIVE = 84,
	LINUX_MIB_TCPFASTOPENACTIVEFAIL = 85,
	LINUX_MIB_TCPFASTOPENPASSIVE = 86,
	LINUX_MIB_TCPFASTOPENPASSIVEFAIL = 87,
	LINUX_MIB_TCPFASTOPENLISTENOVERFLOW = 88,
	LINUX_MIB_TCPFASTOPENCOOKIEREQD = 89,
	LINUX_MIB_TCPFASTOPENBLACKHOLE = 90,
	LINUX_MIB_TCPSPURIOUS_RTX_HOSTQUEUES = 91,
	LINUX_MIB_BUSYPOLLRXPACKETS = 92,
	LINUX_MIB_TCPAUTOCORKING = 93,
	LINUX_MIB_TCPFROMZEROWINDOWADV = 94,
	LINUX_MIB_TCPTOZEROWINDOWADV = 95,
	LINUX_MIB_TCPWANTZEROWINDOWADV = 96,
	LINUX_MIB_TCPSYNRETRANS = 97,
	LINUX_MIB_TCPORIGDATASENT = 98,
	LINUX_MIB_TCPHYSTARTTRAINDETECT = 99,
	LINUX_MIB_TCPHYSTARTTRAINCWND = 100,
	LINUX_MIB_TCPHYSTARTDELAYDETECT = 101,
	LINUX_MIB_TCPHYSTARTDELAYCWND = 102,
	LINUX_MIB_TCPACKSKIPPEDSYNRECV = 103,
	LINUX_MIB_TCPACKSKIPPEDPAWS = 104,
	LINUX_MIB_TCPACKSKIPPEDSEQ = 105,
	LINUX_MIB_TCPACKSKIPPEDFINWAIT2 = 106,
	LINUX_MIB_TCPACKSKIPPEDTIMEWAIT = 107,
	LINUX_MIB_TCPACKSKIPPEDCHALLENGE = 108,
	LINUX_MIB_TCPWINPROBE = 109,
	LINUX_MIB_TCPKEEPALIVE = 110,
	LINUX_MIB_TCPMTUPFAIL = 111,
	LINUX_MIB_TCPMTUPSUCCESS = 112,
	LINUX_MIB_TCPDELIVERED = 113,
	LINUX_MIB_TCPDELIVEREDCE = 114,
	LINUX_MIB_TCPACKCOMPRESSED = 115,
	LINUX_MIB_TCPZEROWINDOWDROP = 116,
	LINUX_MIB_TCPRCVQDROP = 117,
	LINUX_MIB_TCPWQUEUETOOBIG = 118,
	LINUX_MIB_TCPFASTOPENPASSIVEALTKEY = 119,
	LINUX_MIB_TCPTIMEOUTREHASH = 120,
	LINUX_MIB_TCPDUPLICATEDATAREHASH = 121,
	LINUX_MIB_TCPDSACKRECVSEGS = 122,
	LINUX_MIB_TCPDSACKIGNOREDDUBIOUS = 123,
	LINUX_MIB_TCPMIGRATEREQSUCCESS = 124,
	LINUX_MIB_TCPMIGRATEREQFAILURE = 125,
	LINUX_MIB_TCPPLBREHASH = 126,
	__LINUX_MIB_MAX = 127,
};

enum {
	LINUX_MIB_XFRMNUM = 0,
	LINUX_MIB_XFRMINERROR = 1,
	LINUX_MIB_XFRMINBUFFERERROR = 2,
	LINUX_MIB_XFRMINHDRERROR = 3,
	LINUX_MIB_XFRMINNOSTATES = 4,
	LINUX_MIB_XFRMINSTATEPROTOERROR = 5,
	LINUX_MIB_XFRMINSTATEMODEERROR = 6,
	LINUX_MIB_XFRMINSTATESEQERROR = 7,
	LINUX_MIB_XFRMINSTATEEXPIRED = 8,
	LINUX_MIB_XFRMINSTATEMISMATCH = 9,
	LINUX_MIB_XFRMINSTATEINVALID = 10,
	LINUX_MIB_XFRMINTMPLMISMATCH = 11,
	LINUX_MIB_XFRMINNOPOLS = 12,
	LINUX_MIB_XFRMINPOLBLOCK = 13,
	LINUX_MIB_XFRMINPOLERROR = 14,
	LINUX_MIB_XFRMOUTERROR = 15,
	LINUX_MIB_XFRMOUTBUNDLEGENERROR = 16,
	LINUX_MIB_XFRMOUTBUNDLECHECKERROR = 17,
	LINUX_MIB_XFRMOUTNOSTATES = 18,
	LINUX_MIB_XFRMOUTSTATEPROTOERROR = 19,
	LINUX_MIB_XFRMOUTSTATEMODEERROR = 20,
	LINUX_MIB_XFRMOUTSTATESEQERROR = 21,
	LINUX_MIB_XFRMOUTSTATEEXPIRED = 22,
	LINUX_MIB_XFRMOUTPOLBLOCK = 23,
	LINUX_MIB_XFRMOUTPOLDEAD = 24,
	LINUX_MIB_XFRMOUTPOLERROR = 25,
	LINUX_MIB_XFRMFWDHDRERROR = 26,
	LINUX_MIB_XFRMOUTSTATEINVALID = 27,
	LINUX_MIB_XFRMACQUIREERROR = 28,
	__LINUX_MIB_XFRMMAX = 29,
};

enum {
	LINUX_MIB_TLSNUM = 0,
	LINUX_MIB_TLSCURRTXSW = 1,
	LINUX_MIB_TLSCURRRXSW = 2,
	LINUX_MIB_TLSCURRTXDEVICE = 3,
	LINUX_MIB_TLSCURRRXDEVICE = 4,
	LINUX_MIB_TLSTXSW = 5,
	LINUX_MIB_TLSRXSW = 6,
	LINUX_MIB_TLSTXDEVICE = 7,
	LINUX_MIB_TLSRXDEVICE = 8,
	LINUX_MIB_TLSDECRYPTERROR = 9,
	LINUX_MIB_TLSRXDEVICERESYNC = 10,
	LINUX_MIB_TLSDECRYPTRETRY = 11,
	LINUX_MIB_TLSRXNOPADVIOL = 12,
	__LINUX_MIB_TLSMAX = 13,
};

struct ipstats_mib {
	u64 mibs[37];
	struct u64_stats_sync syncp;
};

struct icmp_mib {
	long unsigned int mibs[30];
};

struct icmpmsg_mib {
	atomic_long_t mibs[512];
};

struct icmpv6_mib {
	long unsigned int mibs[7];
};

struct icmpv6msg_mib {
	atomic_long_t mibs[512];
};

struct tcp_mib {
	long unsigned int mibs[16];
};

struct udp_mib {
	long unsigned int mibs[10];
};

struct linux_mib {
	long unsigned int mibs[127];
};

struct inet_frags;

struct fqdir {
	long int high_thresh;
	long int low_thresh;
	int timeout;
	int max_dist;
	struct inet_frags *f;
	struct net *net;
	bool dead;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct rhashtable rhashtable;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	atomic_long_t mem;
	struct work_struct destroy_work;
	struct llist_node free_list;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct inet_frag_queue;

struct inet_frags {
	unsigned int qsize;
	void (*constructor)(struct inet_frag_queue *, const void *);
	void (*destructor)(struct inet_frag_queue *);
	void (*frag_expire)(struct timer_list *);
	struct kmem_cache *frags_cachep;
	const char *frags_cache_name;
	struct rhashtable_params rhash_params;
	refcount_t refcnt;
	struct completion completion;
};

struct frag_v4_compare_key {
	__be32 saddr;
	__be32 daddr;
	u32 user;
	u32 vif;
	__be16 id;
	u16 protocol;
};

struct frag_v6_compare_key {
	struct in6_addr saddr;
	struct in6_addr daddr;
	u32 user;
	__be32 id;
	u32 iif;
};

struct inet_frag_queue {
	struct rhash_head node;
	union {
		struct frag_v4_compare_key v4;
		struct frag_v6_compare_key v6;
	} key;
	struct timer_list timer;
	spinlock_t lock;
	refcount_t refcnt;
	struct rb_root rb_fragments;
	struct sk_buff *fragments_tail;
	struct sk_buff *last_run_head;
	ktime_t stamp;
	int len;
	int meat;
	u8 mono_delivery_time;
	__u8 flags;
	u16 max_size;
	struct fqdir *fqdir;
	struct callback_head rcu;
};

typedef unsigned int sk_buff_data_t;

struct skb_ext;

struct sk_buff {
	union {
		struct {
			struct sk_buff *next;
			struct sk_buff *prev;
			union {
				struct net_device *dev;
				long unsigned int dev_scratch;
			};
		};
		struct rb_node rbnode;
		struct list_head list;
		struct llist_node ll_node;
	};
	union {
		struct sock *sk;
		int ip_defrag_offset;
	};
	union {
		ktime_t tstamp;
		u64 skb_mstamp_ns;
	};
	char cb[48];
	union {
		struct {
			long unsigned int _skb_refdst;
			void (*destructor)(struct sk_buff *);
		};
		struct list_head tcp_tsorted_anchor;
		long unsigned int _sk_redir;
	};
	long unsigned int _nfct;
	unsigned int len;
	unsigned int data_len;
	__u16 mac_len;
	__u16 hdr_len;
	__u16 queue_mapping;
	__u8 __cloned_offset[0];
	__u8 cloned: 1;
	__u8 nohdr: 1;
	__u8 fclone: 2;
	__u8 peeked: 1;
	__u8 head_frag: 1;
	__u8 pfmemalloc: 1;
	__u8 pp_recycle: 1;
	__u8 active_extensions;
	union {
		struct {
			__u8 __pkt_type_offset[0];
			__u8 pkt_type: 3;
			__u8 ignore_df: 1;
			__u8 dst_pending_confirm: 1;
			__u8 ip_summed: 2;
			__u8 ooo_okay: 1;
			__u8 __mono_tc_offset[0];
			__u8 mono_delivery_time: 1;
			__u8 tc_at_ingress: 1;
			__u8 tc_skip_classify: 1;
			__u8 remcsum_offload: 1;
			__u8 csum_complete_sw: 1;
			__u8 csum_level: 2;
			__u8 inner_protocol_type: 1;
			__u8 l4_hash: 1;
			__u8 sw_hash: 1;
			__u8 wifi_acked_valid: 1;
			__u8 wifi_acked: 1;
			__u8 no_fcs: 1;
			__u8 encapsulation: 1;
			__u8 encap_hdr_csum: 1;
			__u8 csum_valid: 1;
			__u8 ndisc_nodetype: 2;
			__u8 redirected: 1;
			__u8 nf_skip_egress: 1;
			__u8 slow_gro: 1;
			__u16 tc_index;
			u16 alloc_cpu;
			union {
				__wsum csum;
				struct {
					__u16 csum_start;
					__u16 csum_offset;
				};
			};
			__u32 priority;
			int skb_iif;
			__u32 hash;
			union {
				u32 vlan_all;
				struct {
					__be16 vlan_proto;
					__u16 vlan_tci;
				};
			};
			union {
				unsigned int napi_id;
				unsigned int sender_cpu;
			};
			__u32 secmark;
			union {
				__u32 mark;
				__u32 reserved_tailroom;
			};
			union {
				__be16 inner_protocol;
				__u8 inner_ipproto;
			};
			__u16 inner_transport_header;
			__u16 inner_network_header;
			__u16 inner_mac_header;
			__be16 protocol;
			__u16 transport_header;
			__u16 network_header;
			__u16 mac_header;
		};
		struct {
			__u8 __pkt_type_offset[0];
			__u8 pkt_type: 3;
			__u8 ignore_df: 1;
			__u8 dst_pending_confirm: 1;
			__u8 ip_summed: 2;
			__u8 ooo_okay: 1;
			__u8 __mono_tc_offset[0];
			__u8 mono_delivery_time: 1;
			__u8 tc_at_ingress: 1;
			__u8 tc_skip_classify: 1;
			__u8 remcsum_offload: 1;
			__u8 csum_complete_sw: 1;
			__u8 csum_level: 2;
			__u8 inner_protocol_type: 1;
			__u8 l4_hash: 1;
			__u8 sw_hash: 1;
			__u8 wifi_acked_valid: 1;
			__u8 wifi_acked: 1;
			__u8 no_fcs: 1;
			__u8 encapsulation: 1;
			__u8 encap_hdr_csum: 1;
			__u8 csum_valid: 1;
			__u8 ndisc_nodetype: 2;
			__u8 redirected: 1;
			__u8 nf_skip_egress: 1;
			__u8 slow_gro: 1;
			__u16 tc_index;
			u16 alloc_cpu;
			union {
				__wsum csum;
				struct {
					__u16 csum_start;
					__u16 csum_offset;
				};
			};
			__u32 priority;
			int skb_iif;
			__u32 hash;
			union {
				u32 vlan_all;
				struct {
					__be16 vlan_proto;
					__u16 vlan_tci;
				};
			};
			union {
				unsigned int napi_id;
				unsigned int sender_cpu;
			};
			__u32 secmark;
			union {
				__u32 mark;
				__u32 reserved_tailroom;
			};
			union {
				__be16 inner_protocol;
				__u8 inner_ipproto;
			};
			__u16 inner_transport_header;
			__u16 inner_network_header;
			__u16 inner_mac_header;
			__be16 protocol;
			__u16 transport_header;
			__u16 network_header;
			__u16 mac_header;
		} headers;
	};
	sk_buff_data_t tail;
	sk_buff_data_t end;
	unsigned char *head;
	unsigned char *data;
	unsigned int truesize;
	refcount_t users;
	struct skb_ext *extensions;
};

enum tcp_ca_event {
	CA_EVENT_TX_START = 0,
	CA_EVENT_CWND_RESTART = 1,
	CA_EVENT_COMPLETE_CWR = 2,
	CA_EVENT_LOSS = 3,
	CA_EVENT_ECN_NO_CE = 4,
	CA_EVENT_ECN_IS_CE = 5,
};

struct ack_sample;

struct rate_sample;

union tcp_cc_info;

struct tcp_congestion_ops {
	u32 (*ssthresh)(struct sock *);
	void (*cong_avoid)(struct sock *, u32, u32);
	void (*set_state)(struct sock *, u8);
	void (*cwnd_event)(struct sock *, enum tcp_ca_event);
	void (*in_ack_event)(struct sock *, u32);
	void (*pkts_acked)(struct sock *, const struct ack_sample *);
	u32 (*min_tso_segs)(struct sock *);
	void (*cong_control)(struct sock *, const struct rate_sample *);
	u32 (*undo_cwnd)(struct sock *);
	u32 (*sndbuf_expand)(struct sock *);
	size_t (*get_info)(struct sock *, u32, int *, union tcp_cc_info *);
	char name[16];
	struct module *owner;
	struct list_head list;
	u32 key;
	u32 flags;
	void (*init)(struct sock *);
	void (*release)(struct sock *);
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

typedef struct {
	atomic_t refcnt;
} rcuref_t;

typedef struct {} netdevice_tracker;

struct xfrm_state;

struct uncached_list;

struct lwtunnel_state;

struct dst_entry {
	struct net_device *dev;
	struct dst_ops *ops;
	long unsigned int _metrics;
	long unsigned int expires;
	struct xfrm_state *xfrm;
	int (*input)(struct sk_buff *);
	int (*output)(struct net *, struct sock *, struct sk_buff *);
	short unsigned int flags;
	short int obsolete;
	short unsigned int header_len;
	short unsigned int trailer_len;
	rcuref_t __rcuref;
	int __use;
	long unsigned int lastuse;
	struct callback_head callback_head;
	short int error;
	short int __pad;
	__u32 tclassid;
	netdevice_tracker dev_tracker;
	struct list_head rt_uncached;
	struct uncached_list *rt_uncached_list;
	struct lwtunnel_state *lwtstate;
};

enum nf_inet_hooks {
	NF_INET_PRE_ROUTING = 0,
	NF_INET_LOCAL_IN = 1,
	NF_INET_FORWARD = 2,
	NF_INET_LOCAL_OUT = 3,
	NF_INET_POST_ROUTING = 4,
	NF_INET_NUMHOOKS = 5,
	NF_INET_INGRESS = 5,
};

enum {
	NFPROTO_UNSPEC = 0,
	NFPROTO_INET = 1,
	NFPROTO_IPV4 = 2,
	NFPROTO_ARP = 3,
	NFPROTO_NETDEV = 5,
	NFPROTO_BRIDGE = 7,
	NFPROTO_IPV6 = 10,
	NFPROTO_NUMPROTO = 11,
};

enum nf_log_type {
	NF_LOG_TYPE_LOG = 0,
	NF_LOG_TYPE_ULOG = 1,
	NF_LOG_TYPE_MAX = 2,
};

typedef u8 u_int8_t;

struct nf_loginfo;

typedef void nf_logfn(struct net *, u_int8_t, unsigned int, const struct sk_buff *, const struct net_device *, const struct net_device *, const struct nf_loginfo *, const char *);

struct nf_logger {
	char *name;
	enum nf_log_type type;
	nf_logfn *logfn;
	struct module *me;
};

enum tcp_conntrack {
	TCP_CONNTRACK_NONE = 0,
	TCP_CONNTRACK_SYN_SENT = 1,
	TCP_CONNTRACK_SYN_RECV = 2,
	TCP_CONNTRACK_ESTABLISHED = 3,
	TCP_CONNTRACK_FIN_WAIT = 4,
	TCP_CONNTRACK_CLOSE_WAIT = 5,
	TCP_CONNTRACK_LAST_ACK = 6,
	TCP_CONNTRACK_TIME_WAIT = 7,
	TCP_CONNTRACK_CLOSE = 8,
	TCP_CONNTRACK_LISTEN = 9,
	TCP_CONNTRACK_MAX = 10,
	TCP_CONNTRACK_IGNORE = 11,
	TCP_CONNTRACK_RETRANS = 12,
	TCP_CONNTRACK_UNACK = 13,
	TCP_CONNTRACK_TIMEOUT_MAX = 14,
};

enum udp_conntrack {
	UDP_CT_UNREPLIED = 0,
	UDP_CT_REPLIED = 1,
	UDP_CT_MAX = 2,
};

struct ip_conntrack_stat {
	unsigned int found;
	unsigned int invalid;
	unsigned int insert;
	unsigned int insert_failed;
	unsigned int clash_resolve;
	unsigned int drop;
	unsigned int early_drop;
	unsigned int error;
	unsigned int expect_new;
	unsigned int expect_create;
	unsigned int expect_delete;
	unsigned int search_restart;
	unsigned int chaintoolong;
};

enum {
	XFRM_POLICY_IN = 0,
	XFRM_POLICY_OUT = 1,
	XFRM_POLICY_FWD = 2,
	XFRM_POLICY_MASK = 3,
	XFRM_POLICY_MAX = 3,
};

enum netns_bpf_attach_type {
	NETNS_BPF_INVALID = -1,
	NETNS_BPF_FLOW_DISSECTOR = 0,
	NETNS_BPF_SK_LOOKUP = 1,
	MAX_NETNS_BPF_ATTACH_TYPE = 2,
};

enum flow_dissector_key_id {
	FLOW_DISSECTOR_KEY_CONTROL = 0,
	FLOW_DISSECTOR_KEY_BASIC = 1,
	FLOW_DISSECTOR_KEY_IPV4_ADDRS = 2,
	FLOW_DISSECTOR_KEY_IPV6_ADDRS = 3,
	FLOW_DISSECTOR_KEY_PORTS = 4,
	FLOW_DISSECTOR_KEY_PORTS_RANGE = 5,
	FLOW_DISSECTOR_KEY_ICMP = 6,
	FLOW_DISSECTOR_KEY_ETH_ADDRS = 7,
	FLOW_DISSECTOR_KEY_TIPC = 8,
	FLOW_DISSECTOR_KEY_ARP = 9,
	FLOW_DISSECTOR_KEY_VLAN = 10,
	FLOW_DISSECTOR_KEY_FLOW_LABEL = 11,
	FLOW_DISSECTOR_KEY_GRE_KEYID = 12,
	FLOW_DISSECTOR_KEY_MPLS_ENTROPY = 13,
	FLOW_DISSECTOR_KEY_ENC_KEYID = 14,
	FLOW_DISSECTOR_KEY_ENC_IPV4_ADDRS = 15,
	FLOW_DISSECTOR_KEY_ENC_IPV6_ADDRS = 16,
	FLOW_DISSECTOR_KEY_ENC_CONTROL = 17,
	FLOW_DISSECTOR_KEY_ENC_PORTS = 18,
	FLOW_DISSECTOR_KEY_MPLS = 19,
	FLOW_DISSECTOR_KEY_TCP = 20,
	FLOW_DISSECTOR_KEY_IP = 21,
	FLOW_DISSECTOR_KEY_CVLAN = 22,
	FLOW_DISSECTOR_KEY_ENC_IP = 23,
	FLOW_DISSECTOR_KEY_ENC_OPTS = 24,
	FLOW_DISSECTOR_KEY_META = 25,
	FLOW_DISSECTOR_KEY_CT = 26,
	FLOW_DISSECTOR_KEY_HASH = 27,
	FLOW_DISSECTOR_KEY_NUM_OF_VLANS = 28,
	FLOW_DISSECTOR_KEY_PPPOE = 29,
	FLOW_DISSECTOR_KEY_L2TPV3 = 30,
	FLOW_DISSECTOR_KEY_CFM = 31,
	FLOW_DISSECTOR_KEY_IPSEC = 32,
	FLOW_DISSECTOR_KEY_MAX = 33,
};

struct skb_ext {
	refcount_t refcnt;
	u8 offset[1];
	u8 chunks;
	long: 0;
	char data[0];
};

enum skb_ext_id {
	SKB_EXT_SEC_PATH = 0,
	SKB_EXT_NUM = 1,
};

struct io_uring_sqe {
	__u8 opcode;
	__u8 flags;
	__u16 ioprio;
	__s32 fd;
	union {
		__u64 off;
		__u64 addr2;
		struct {
			__u32 cmd_op;
			__u32 __pad1;
		};
	};
	union {
		__u64 addr;
		__u64 splice_off_in;
	};
	__u32 len;
	union {
		__kernel_rwf_t rw_flags;
		__u32 fsync_flags;
		__u16 poll_events;
		__u32 poll32_events;
		__u32 sync_range_flags;
		__u32 msg_flags;
		__u32 timeout_flags;
		__u32 accept_flags;
		__u32 cancel_flags;
		__u32 open_flags;
		__u32 statx_flags;
		__u32 fadvise_advice;
		__u32 splice_flags;
		__u32 rename_flags;
		__u32 unlink_flags;
		__u32 hardlink_flags;
		__u32 xattr_flags;
		__u32 msg_ring_flags;
		__u32 uring_cmd_flags;
	};
	__u64 user_data;
	union {
		__u16 buf_index;
		__u16 buf_group;
	};
	__u16 personality;
	union {
		__s32 splice_fd_in;
		__u32 file_index;
		struct {
			__u16 addr_len;
			__u16 __pad3[1];
		};
	};
	union {
		struct {
			__u64 addr3;
			__u64 __pad2[1];
		};
		__u8 cmd[0];
	};
};

struct waitid_info {
	pid_t pid;
	uid_t uid;
	int status;
	int cause;
};

struct wait_opts {
	enum pid_type wo_type;
	int wo_flags;
	struct pid *wo_pid;
	struct waitid_info *wo_info;
	int wo_stat;
	struct rusage *wo_rusage;
	wait_queue_entry_t child_wait;
	int notask_error;
};

struct wq_flusher;

struct worker;

struct workqueue_attrs;

struct pool_workqueue;

struct wq_device;

struct workqueue_struct {
	struct list_head pwqs;
	struct list_head list;
	struct mutex mutex;
	int work_color;
	int flush_color;
	atomic_t nr_pwqs_to_flush;
	struct wq_flusher *first_flusher;
	struct list_head flusher_queue;
	struct list_head flusher_overflow;
	struct list_head maydays;
	struct worker *rescuer;
	int nr_drainers;
	int saved_max_active;
	struct workqueue_attrs *unbound_attrs;
	struct pool_workqueue *dfl_pwq;
	struct wq_device *wq_dev;
	char name[24];
	struct callback_head rcu;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	unsigned int flags;
	struct pool_workqueue **cpu_pwq;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

enum wq_affn_scope {
	WQ_AFFN_DFL = 0,
	WQ_AFFN_CPU = 1,
	WQ_AFFN_SMT = 2,
	WQ_AFFN_CACHE = 3,
	WQ_AFFN_NUMA = 4,
	WQ_AFFN_SYSTEM = 5,
	WQ_AFFN_NR_TYPES = 6,
};

struct workqueue_attrs {
	int nice;
	cpumask_var_t cpumask;
	cpumask_var_t __pod_cpumask;
	bool affn_strict;
	enum wq_affn_scope affn_scope;
	bool ordered;
};

struct execute_work {
	struct work_struct work;
};

enum {
	WQ_UNBOUND = 2,
	WQ_FREEZABLE = 4,
	WQ_MEM_RECLAIM = 8,
	WQ_HIGHPRI = 16,
	WQ_CPU_INTENSIVE = 32,
	WQ_SYSFS = 64,
	WQ_POWER_EFFICIENT = 128,
	__WQ_DESTROYING = 32768,
	__WQ_DRAINING = 65536,
	__WQ_ORDERED = 131072,
	__WQ_LEGACY = 262144,
	__WQ_ORDERED_EXPLICIT = 524288,
	WQ_MAX_ACTIVE = 512,
	WQ_UNBOUND_MAX_ACTIVE = 512,
	WQ_DFL_ACTIVE = 256,
};

typedef unsigned int xa_mark_t;

enum xa_lock_type {
	XA_LOCK_IRQ = 1,
	XA_LOCK_BH = 2,
};

struct ida {
	struct xarray xa;
};

enum kobject_action {
	KOBJ_ADD = 0,
	KOBJ_REMOVE = 1,
	KOBJ_CHANGE = 2,
	KOBJ_MOVE = 3,
	KOBJ_ONLINE = 4,
	KOBJ_OFFLINE = 5,
	KOBJ_BIND = 6,
	KOBJ_UNBIND = 7,
};

struct kthread_work;

typedef void (*kthread_work_func_t)(struct kthread_work *);

struct kthread_worker;

struct kthread_work {
	struct list_head node;
	kthread_work_func_t func;
	struct kthread_worker *worker;
	int canceling;
};

struct kthread_worker {
	unsigned int flags;
	raw_spinlock_t lock;
	struct list_head work_list;
	struct list_head delayed_work_list;
	struct task_struct *task;
	struct kthread_work *current_work;
};

struct __una_u32 {
	u32 x;
};

enum hk_type {
	HK_TYPE_TIMER = 0,
	HK_TYPE_RCU = 1,
	HK_TYPE_MISC = 2,
	HK_TYPE_SCHED = 3,
	HK_TYPE_TICK = 4,
	HK_TYPE_DOMAIN = 5,
	HK_TYPE_WQ = 6,
	HK_TYPE_MANAGED_IRQ = 7,
	HK_TYPE_KTHREAD = 8,
	HK_TYPE_MAX = 9,
};

struct worker_pool;

struct worker {
	union {
		struct list_head entry;
		struct hlist_node hentry;
	};
	struct work_struct *current_work;
	work_func_t current_func;
	struct pool_workqueue *current_pwq;
	u64 current_at;
	unsigned int current_color;
	int sleeping;
	work_func_t last_func;
	struct list_head scheduled;
	struct task_struct *task;
	struct worker_pool *pool;
	struct list_head node;
	long unsigned int last_active;
	unsigned int flags;
	int id;
	char desc[24];
	struct workqueue_struct *rescue_wq;
};

struct pool_workqueue {
	struct worker_pool *pool;
	struct workqueue_struct *wq;
	int work_color;
	int flush_color;
	int refcnt;
	int nr_in_flight[16];
	int nr_active;
	int max_active;
	struct list_head inactive_works;
	struct list_head pwqs_node;
	struct list_head mayday_node;
	u64 stats[8];
	struct kthread_work release_work;
	struct callback_head rcu;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct worker_pool {
	raw_spinlock_t lock;
	int cpu;
	int node;
	int id;
	unsigned int flags;
	long unsigned int watchdog_ts;
	bool cpu_stall;
	int nr_running;
	struct list_head worklist;
	int nr_workers;
	int nr_idle;
	struct list_head idle_list;
	struct timer_list idle_timer;
	struct work_struct idle_cull_work;
	struct timer_list mayday_timer;
	struct hlist_head busy_hash[64];
	struct worker *manager;
	struct list_head workers;
	struct list_head dying_workers;
	struct completion *detach_completion;
	struct ida worker_ida;
	struct workqueue_attrs *attrs;
	struct hlist_node hash_node;
	int refcnt;
	struct callback_head rcu;
};

enum {
	POOL_MANAGER_ACTIVE = 1,
	POOL_DISASSOCIATED = 4,
	WORKER_DIE = 2,
	WORKER_IDLE = 4,
	WORKER_PREP = 8,
	WORKER_CPU_INTENSIVE = 64,
	WORKER_UNBOUND = 128,
	WORKER_REBOUND = 256,
	WORKER_NOT_RUNNING = 456,
	NR_STD_WORKER_POOLS = 2,
	UNBOUND_POOL_HASH_ORDER = 6,
	BUSY_WORKER_HASH_ORDER = 6,
	MAX_IDLE_WORKERS_RATIO = 4,
	IDLE_WORKER_TIMEOUT = 30000,
	MAYDAY_INITIAL_TIMEOUT = 2,
	MAYDAY_INTERVAL = 10,
	CREATE_COOLDOWN = 100,
	RESCUER_NICE_LEVEL = -20,
	HIGHPRI_NICE_LEVEL = -20,
	WQ_NAME_LEN = 24,
};

enum pool_workqueue_stats {
	PWQ_STAT_STARTED = 0,
	PWQ_STAT_COMPLETED = 1,
	PWQ_STAT_CPU_TIME = 2,
	PWQ_STAT_CPU_INTENSIVE = 3,
	PWQ_STAT_CM_WAKEUP = 4,
	PWQ_STAT_REPATRIATED = 5,
	PWQ_STAT_MAYDAY = 6,
	PWQ_STAT_RESCUED = 7,
	PWQ_NR_STATS = 8,
};

struct wq_flusher {
	struct list_head list;
	int flush_color;
	struct completion done;
};

struct wq_device {
	struct workqueue_struct *wq;
	struct device dev;
};

struct wq_pod_type {
	int nr_pods;
	cpumask_var_t *pod_cpus;
	int *pod_node;
	int *cpu_pod;
};

struct ring_buffer_event {
	u32 type_len: 5;
	u32 time_delta: 27;
	u32 array[0];
};

struct trace_buffer;

struct trace_event_file;

struct trace_event_buffer {
	struct trace_buffer *buffer;
	struct ring_buffer_event *event;
	struct trace_event_file *trace_file;
	void *entry;
	unsigned int trace_ctx;
	struct pt_regs *regs;
};

struct eventfs_file;

struct trace_subsystem_dir;

struct trace_event_file {
	struct list_head list;
	struct trace_event_call *event_call;
	struct event_filter *filter;
	struct eventfs_file *ef;
	struct trace_array *tr;
	struct trace_subsystem_dir *system;
	struct list_head triggers;
	long unsigned int flags;
	atomic_t sm_ref;
	atomic_t tm_ref;
};

enum {
	EVENT_FILE_FL_ENABLED = 1,
	EVENT_FILE_FL_RECORDED_CMD = 2,
	EVENT_FILE_FL_RECORDED_TGID = 4,
	EVENT_FILE_FL_FILTERED = 8,
	EVENT_FILE_FL_NO_SET_FILTER = 16,
	EVENT_FILE_FL_SOFT_MODE = 32,
	EVENT_FILE_FL_SOFT_DISABLED = 64,
	EVENT_FILE_FL_TRIGGER_MODE = 128,
	EVENT_FILE_FL_TRIGGER_COND = 256,
	EVENT_FILE_FL_PID_FILTER = 512,
	EVENT_FILE_FL_WAS_ENABLED = 1024,
};

enum {
	FILTER_OTHER = 0,
	FILTER_STATIC_STRING = 1,
	FILTER_DYN_STRING = 2,
	FILTER_RDYN_STRING = 3,
	FILTER_PTR_STRING = 4,
	FILTER_TRACE_FN = 5,
	FILTER_CPUMASK = 6,
	FILTER_COMM = 7,
	FILTER_CPU = 8,
	FILTER_STACKTRACE = 9,
};

struct trace_event_raw_workqueue_queue_work {
	struct trace_entry ent;
	void *work;
	void *function;
	u32 __data_loc_workqueue;
	int req_cpu;
	int cpu;
	char __data[0];
};

struct trace_event_raw_workqueue_activate_work {
	struct trace_entry ent;
	void *work;
	char __data[0];
};

struct trace_event_raw_workqueue_execute_start {
	struct trace_entry ent;
	void *work;
	void *function;
	char __data[0];
};

struct trace_event_raw_workqueue_execute_end {
	struct trace_entry ent;
	void *work;
	void *function;
	char __data[0];
};

struct trace_event_data_offsets_workqueue_queue_work {
	u32 workqueue;
};

struct trace_event_data_offsets_workqueue_activate_work {};

struct trace_event_data_offsets_workqueue_execute_start {};

struct trace_event_data_offsets_workqueue_execute_end {};

typedef void (*btf_trace_workqueue_queue_work)(void *, int, struct pool_workqueue *, struct work_struct *);

typedef void (*btf_trace_workqueue_activate_work)(void *, struct work_struct *);

typedef void (*btf_trace_workqueue_execute_start)(void *, struct work_struct *);

typedef void (*btf_trace_workqueue_execute_end)(void *, struct work_struct *, work_func_t);

struct wq_barrier {
	struct work_struct work;
	struct completion done;
	struct task_struct *task;
};

struct cwt_wait {
	wait_queue_entry_t wait;
	struct work_struct *work;
};

struct apply_wqattrs_ctx {
	struct workqueue_struct *wq;
	struct workqueue_attrs *attrs;
	struct list_head list;
	struct pool_workqueue *dfl_pwq;
	struct pool_workqueue *pwq_tbl[0];
};

struct pr_cont_work_struct {
	bool comma;
	work_func_t func;
	long int ctr;
};

struct work_for_cpu {
	struct work_struct work;
	long int (*fn)(void *);
	void *arg;
	long int ret;
};

struct smp_hotplug_thread {
	struct task_struct **store;
	struct list_head list;
	int (*thread_should_run)(unsigned int);
	void (*thread_fn)(unsigned int);
	void (*create)(unsigned int);
	void (*setup)(unsigned int);
	void (*cleanup)(unsigned int, bool);
	void (*park)(unsigned int);
	void (*unpark)(unsigned int);
	bool selfparking;
	const char *thread_comm;
};

struct smpboot_thread_data {
	unsigned int cpu;
	unsigned int status;
	struct smp_hotplug_thread *ht;
};

enum {
	HP_THREAD_NONE = 0,
	HP_THREAD_ACTIVE = 1,
	HP_THREAD_PARKED = 2,
};

struct ksignal {
	struct k_sigaction ka;
	kernel_siginfo_t info;
	int sig;
};

struct kernel_clone_args {
	u64 flags;
	int *pidfd;
	int *child_tid;
	int *parent_tid;
	const char *name;
	int exit_signal;
	u32 kthread: 1;
	u32 io_thread: 1;
	u32 user_worker: 1;
	u32 no_files: 1;
	long unsigned int stack;
	long unsigned int stack_size;
	long unsigned int tls;
	pid_t *set_tid;
	size_t set_tid_size;
	int cgroup;
	int idle;
	int (*fn)(void *);
	void *fn_arg;
	struct cgroup *cgrp;
	struct css_set *cset;
};

enum vhost_task_flags {
	VHOST_TASK_FLAGS_STOP = 0,
};

struct vhost_task {
	bool (*fn)(void *);
	void *data;
	struct completion exited;
	long unsigned int flags;
	struct task_struct *task;
};

struct ww_class {
	atomic_long_t stamp;
	struct lock_class_key acquire_key;
	struct lock_class_key mutex_key;
	const char *acquire_name;
	const char *mutex_name;
	unsigned int is_wait_die;
};

struct ww_acquire_ctx;

struct ww_mutex {
	struct mutex base;
	struct ww_acquire_ctx *ctx;
	struct ww_class *ww_class;
};

struct ww_acquire_ctx {
	struct task_struct *task;
	long unsigned int stamp;
	unsigned int acquired;
	short unsigned int wounded;
	short unsigned int is_wait_die;
	unsigned int done_acquire;
	struct ww_class *ww_class;
	void *contending_lock;
};

struct mutex_waiter {
	struct list_head list;
	struct task_struct *task;
	struct ww_acquire_ctx *ww_ctx;
	void *magic;
};

struct trace_print_flags {
	long unsigned int mask;
	const char *name;
};

struct wake_q_head {
	struct wake_q_node *first;
	struct wake_q_node **lastp;
};

struct trace_event_raw_contention_begin {
	struct trace_entry ent;
	void *lock_addr;
	unsigned int flags;
	char __data[0];
};

struct trace_event_raw_contention_end {
	struct trace_entry ent;
	void *lock_addr;
	int ret;
	char __data[0];
};

struct trace_event_data_offsets_contention_begin {};

struct trace_event_data_offsets_contention_end {};

typedef void (*btf_trace_contention_begin)(void *, void *, unsigned int);

typedef void (*btf_trace_contention_end)(void *, void *, int);

struct plist_head {
	struct list_head node_list;
};

enum pm_qos_type {
	PM_QOS_UNITIALIZED = 0,
	PM_QOS_MAX = 1,
	PM_QOS_MIN = 2,
};

struct pm_qos_constraints {
	struct plist_head list;
	s32 target_value;
	s32 default_value;
	s32 no_constraint_value;
	enum pm_qos_type type;
	struct blocking_notifier_head *notifiers;
};

struct freq_constraints {
	struct pm_qos_constraints min_freq;
	struct blocking_notifier_head min_freq_notifiers;
	struct pm_qos_constraints max_freq;
	struct blocking_notifier_head max_freq_notifiers;
};

struct pm_qos_flags {
	struct list_head list;
	s32 effective_flags;
};

struct dev_pm_qos_request;

struct dev_pm_qos {
	struct pm_qos_constraints resume_latency;
	struct pm_qos_constraints latency_tolerance;
	struct freq_constraints freq;
	struct pm_qos_flags flags;
	struct dev_pm_qos_request *resume_latency_req;
	struct dev_pm_qos_request *latency_tolerance_req;
	struct dev_pm_qos_request *flags_req;
};

struct pm_qos_request {
	struct plist_node node;
	struct pm_qos_constraints *qos;
};

struct pm_qos_flags_request {
	struct list_head node;
	s32 flags;
};

enum freq_qos_req_type {
	FREQ_QOS_MIN = 1,
	FREQ_QOS_MAX = 2,
};

struct freq_qos_request {
	enum freq_qos_req_type type;
	struct plist_node pnode;
	struct freq_constraints *qos;
};

enum dev_pm_qos_req_type {
	DEV_PM_QOS_RESUME_LATENCY = 1,
	DEV_PM_QOS_LATENCY_TOLERANCE = 2,
	DEV_PM_QOS_MIN_FREQUENCY = 3,
	DEV_PM_QOS_MAX_FREQUENCY = 4,
	DEV_PM_QOS_FLAGS = 5,
};

struct dev_pm_qos_request {
	enum dev_pm_qos_req_type type;
	union {
		struct plist_node pnode;
		struct pm_qos_flags_request flr;
		struct freq_qos_request freq;
	} data;
	struct device *dev;
};

enum pm_qos_req_action {
	PM_QOS_ADD_REQ = 0,
	PM_QOS_UPDATE_REQ = 1,
	PM_QOS_REMOVE_REQ = 2,
};

struct miscdevice {
	int minor;
	const char *name;
	const struct file_operations *fops;
	struct list_head list;
	struct device *parent;
	struct device *this_device;
	const struct attribute_group **groups;
	const char *nodename;
	umode_t mode;
};

struct sysrq_key_op {
	void (* const handler)(u8);
	const char * const help_msg;
	const char * const action_msg;
	const int enable_mask;
};

typedef unsigned int uint;

typedef initcall_t initcall_entry_t;

enum {
	CSD_FLAG_LOCK = 1,
	IRQ_WORK_PENDING = 1,
	IRQ_WORK_BUSY = 2,
	IRQ_WORK_LAZY = 4,
	IRQ_WORK_HARD_IRQ = 8,
	IRQ_WORK_CLAIMED = 3,
	CSD_TYPE_ASYNC = 0,
	CSD_TYPE_SYNC = 16,
	CSD_TYPE_IRQ_WORK = 32,
	CSD_TYPE_TTWU = 48,
	CSD_FLAG_TYPE_MASK = 240,
};

typedef struct {
	seqcount_t seqcount;
} seqcount_latch_t;

struct semaphore {
	raw_spinlock_t lock;
	unsigned int count;
	struct list_head wait_list;
};

struct dev_printk_info {
	char subsystem[16];
	char device[48];
};

enum cons_flags {
	CON_PRINTBUFFER = 1,
	CON_CONSDEV = 2,
	CON_ENABLED = 4,
	CON_BOOT = 8,
	CON_ANYTIME = 16,
	CON_BRL = 32,
	CON_EXTENDED = 64,
	CON_SUSPENDED = 128,
};

struct console {
	char name[16];
	void (*write)(struct console *, const char *, unsigned int);
	int (*read)(struct console *, char *, unsigned int);
	struct tty_driver * (*device)(struct console *, int *);
	void (*unblank)();
	int (*setup)(struct console *, char *);
	int (*exit)(struct console *);
	int (*match)(struct console *, char *, int, char *);
	short int flags;
	short int index;
	int cflag;
	uint ispeed;
	uint ospeed;
	u64 seq;
	long unsigned int dropped;
	void *data;
	struct hlist_node node;
};

enum con_flush_mode {
	CONSOLE_FLUSH_PENDING = 0,
	CONSOLE_REPLAY_ALL = 1,
};

enum {
	UNAME26 = 131072,
	ADDR_NO_RANDOMIZE = 262144,
	FDPIC_FUNCPTRS = 524288,
	MMAP_PAGE_ZERO = 1048576,
	ADDR_COMPAT_LAYOUT = 2097152,
	READ_IMPLIES_EXEC = 4194304,
	ADDR_LIMIT_32BIT = 8388608,
	SHORT_INODE = 16777216,
	WHOLE_SECONDS = 33554432,
	STICKY_TIMEOUTS = 67108864,
	ADDR_LIMIT_3GB = 134217728,
};

typedef struct poll_table_struct poll_table;

enum kmsg_dump_reason {
	KMSG_DUMP_UNDEF = 0,
	KMSG_DUMP_PANIC = 1,
	KMSG_DUMP_OOPS = 2,
	KMSG_DUMP_EMERG = 3,
	KMSG_DUMP_SHUTDOWN = 4,
	KMSG_DUMP_MAX = 5,
};

struct kmsg_dump_iter {
	u64 cur_seq;
	u64 next_seq;
};

struct kmsg_dumper {
	struct list_head list;
	void (*dump)(struct kmsg_dumper *, enum kmsg_dump_reason);
	enum kmsg_dump_reason max_reason;
	bool registered;
};

struct trace_event_raw_console {
	struct trace_entry ent;
	u32 __data_loc_msg;
	char __data[0];
};

struct trace_event_data_offsets_console {
	u32 msg;
};

typedef void (*btf_trace_console)(void *, const char *, size_t);

struct printk_info {
	u64 seq;
	u64 ts_nsec;
	u16 text_len;
	u8 facility;
	u8 flags: 5;
	u8 level: 3;
	u32 caller_id;
	struct dev_printk_info dev_info;
};

struct printk_record {
	struct printk_info *info;
	char *text_buf;
	unsigned int text_buf_size;
};

struct prb_data_blk_lpos {
	long unsigned int begin;
	long unsigned int next;
};

struct prb_desc {
	atomic_long_t state_var;
	struct prb_data_blk_lpos text_blk_lpos;
};

struct prb_data_ring {
	unsigned int size_bits;
	char *data;
	atomic_long_t head_lpos;
	atomic_long_t tail_lpos;
};

struct prb_desc_ring {
	unsigned int count_bits;
	struct prb_desc *descs;
	struct printk_info *infos;
	atomic_long_t head_id;
	atomic_long_t tail_id;
	atomic_long_t last_finalized_id;
};

struct printk_ringbuffer {
	struct prb_desc_ring desc_ring;
	struct prb_data_ring text_data_ring;
	atomic_long_t fail;
};

struct prb_reserved_entry {
	struct printk_ringbuffer *rb;
	long unsigned int irqflags;
	long unsigned int id;
	unsigned int text_space;
};

enum desc_state {
	desc_miss = -1,
	desc_reserved = 0,
	desc_committed = 1,
	desc_finalized = 2,
	desc_reusable = 3,
};

struct console_cmdline {
	char name[16];
	int index;
	bool user_specified;
	char *options;
};

enum printk_info_flags {
	LOG_NEWLINE = 2,
	LOG_CONT = 8,
};

struct printk_buffers {
	char outbuf[2048];
	char scratchbuf[1024];
};

struct printk_message {
	struct printk_buffers *pbufs;
	unsigned int outbuf_len;
	u64 seq;
	long unsigned int dropped;
};

enum devkmsg_log_bits {
	__DEVKMSG_LOG_BIT_ON = 0,
	__DEVKMSG_LOG_BIT_OFF = 1,
	__DEVKMSG_LOG_BIT_LOCK = 2,
};

enum devkmsg_log_masks {
	DEVKMSG_LOG_MASK_ON = 1,
	DEVKMSG_LOG_MASK_OFF = 2,
	DEVKMSG_LOG_MASK_LOCK = 4,
};

enum con_msg_format_flags {
	MSG_FORMAT_DEFAULT = 0,
	MSG_FORMAT_SYSLOG = 1,
};

struct latched_seq {
	seqcount_latch_t latch;
	u64 val[2];
};

struct devkmsg_user {
	atomic64_t seq;
	struct ratelimit_state rs;
	struct mutex lock;
	struct printk_buffers pbufs;
};

enum {
	IRQCHIP_SET_TYPE_MASKED = 1,
	IRQCHIP_EOI_IF_HANDLED = 2,
	IRQCHIP_MASK_ON_SUSPEND = 4,
	IRQCHIP_ONOFFLINE_ENABLED = 8,
	IRQCHIP_SKIP_SET_WAKE = 16,
	IRQCHIP_ONESHOT_SAFE = 32,
	IRQCHIP_EOI_THREADED = 64,
	IRQCHIP_SUPPORTS_LEVEL_MSI = 128,
	IRQCHIP_SUPPORTS_NMI = 256,
	IRQCHIP_ENABLE_WAKEUP_ON_SUSPEND = 512,
	IRQCHIP_AFFINITY_PRE_STARTUP = 1024,
	IRQCHIP_IMMUTABLE = 2048,
};

struct syscore_ops {
	struct list_head node;
	int (*suspend)();
	void (*resume)();
	void (*shutdown)();
};

enum {
	IRQS_AUTODETECT = 1,
	IRQS_SPURIOUS_DISABLED = 2,
	IRQS_POLL_INPROGRESS = 8,
	IRQS_ONESHOT = 32,
	IRQS_REPLAY = 64,
	IRQS_WAITING = 128,
	IRQS_PENDING = 512,
	IRQS_SUSPENDED = 2048,
	IRQS_TIMINGS = 4096,
	IRQS_NMI = 8192,
	IRQS_SYSFS = 16384,
};

enum {
	_IRQ_DEFAULT_INIT_FLAGS = 2048,
	_IRQ_PER_CPU = 512,
	_IRQ_LEVEL = 256,
	_IRQ_NOPROBE = 1024,
	_IRQ_NOREQUEST = 2048,
	_IRQ_NOTHREAD = 65536,
	_IRQ_NOAUTOEN = 4096,
	_IRQ_MOVE_PCNTXT = 16384,
	_IRQ_NO_BALANCING = 8192,
	_IRQ_NESTED_THREAD = 32768,
	_IRQ_PER_CPU_DEVID = 131072,
	_IRQ_IS_POLLED = 262144,
	_IRQ_DISABLE_UNLAZY = 524288,
	_IRQ_HIDDEN = 1048576,
	_IRQ_NO_DEBUG = 2097152,
	_IRQF_MODIFY_MASK = 2096911,
};

struct module_use {
	struct list_head source_list;
	struct list_head target_list;
	struct module *source;
	struct module *target;
};

enum {
	PROC_ENTRY_PERMANENT = 1,
};

struct stacktrace_cookie {
	long unsigned int *store;
	unsigned int size;
	unsigned int skip;
	unsigned int len;
};

typedef __u64 timeu64_t;

struct __kernel_timex_timeval {
	__kernel_time64_t tv_sec;
	long long int tv_usec;
};

struct __kernel_timex {
	unsigned int modes;
	long long int offset;
	long long int freq;
	long long int maxerror;
	long long int esterror;
	int status;
	long long int constant;
	long long int precision;
	long long int tolerance;
	struct __kernel_timex_timeval time;
	long long int tick;
	long long int ppsfreq;
	long long int jitter;
	int shift;
	long long int stabil;
	long long int jitcnt;
	long long int calcnt;
	long long int errcnt;
	long long int stbcnt;
	int tai;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

enum hrtimer_mode {
	HRTIMER_MODE_ABS = 0,
	HRTIMER_MODE_REL = 1,
	HRTIMER_MODE_PINNED = 2,
	HRTIMER_MODE_SOFT = 4,
	HRTIMER_MODE_HARD = 8,
	HRTIMER_MODE_ABS_PINNED = 2,
	HRTIMER_MODE_REL_PINNED = 3,
	HRTIMER_MODE_ABS_SOFT = 4,
	HRTIMER_MODE_REL_SOFT = 5,
	HRTIMER_MODE_ABS_PINNED_SOFT = 6,
	HRTIMER_MODE_REL_PINNED_SOFT = 7,
	HRTIMER_MODE_ABS_HARD = 8,
	HRTIMER_MODE_REL_HARD = 9,
	HRTIMER_MODE_ABS_PINNED_HARD = 10,
	HRTIMER_MODE_REL_PINNED_HARD = 11,
};

struct rtc_wkalrm {
	unsigned char enabled;
	unsigned char pending;
	struct rtc_time time;
};

struct rtc_param {
	__u64 param;
	union {
		__u64 uvalue;
		__s64 svalue;
		__u64 ptr;
	};
	__u32 index;
	__u32 __pad;
};

struct rtc_class_ops {
	int (*ioctl)(struct device *, unsigned int, long unsigned int);
	int (*read_time)(struct device *, struct rtc_time *);
	int (*set_time)(struct device *, struct rtc_time *);
	int (*read_alarm)(struct device *, struct rtc_wkalrm *);
	int (*set_alarm)(struct device *, struct rtc_wkalrm *);
	int (*proc)(struct device *, struct seq_file *);
	int (*alarm_irq_enable)(struct device *, unsigned int);
	int (*read_offset)(struct device *, long int *);
	int (*set_offset)(struct device *, long int);
	int (*param_get)(struct device *, struct rtc_param *);
	int (*param_set)(struct device *, struct rtc_param *);
};

struct rtc_device;

struct rtc_timer {
	struct timerqueue_node node;
	ktime_t period;
	void (*func)(struct rtc_device *);
	struct rtc_device *rtc;
	int enabled;
};

struct rtc_device {
	struct device dev;
	struct module *owner;
	int id;
	const struct rtc_class_ops *ops;
	struct mutex ops_lock;
	struct cdev char_dev;
	long unsigned int flags;
	long unsigned int irq_data;
	spinlock_t irq_lock;
	wait_queue_head_t irq_queue;
	struct fasync_struct *async_queue;
	int irq_freq;
	int max_user_freq;
	struct timerqueue_head timerqueue;
	struct rtc_timer aie_timer;
	struct rtc_timer uie_rtctimer;
	struct hrtimer pie_timer;
	int pie_enabled;
	struct work_struct irqwork;
	long unsigned int set_offset_nsec;
	long unsigned int features[1];
	time64_t range_min;
	timeu64_t range_max;
	timeu64_t alarm_offset_max;
	time64_t start_secs;
	time64_t offset_secs;
	bool set_start_time;
};

struct audit_ntp_val {
	long long int oldval;
	long long int newval;
};

struct audit_ntp_data {
	struct audit_ntp_val vals[6];
};

struct __kernel_old_itimerval {
	struct __kernel_old_timeval it_interval;
	struct __kernel_old_timeval it_value;
};

struct itimerspec64 {
	struct timespec64 it_interval;
	struct timespec64 it_value;
};

struct tk_read_base {
	struct clocksource *clock;
	u64 mask;
	u64 cycle_last;
	u32 mult;
	u32 shift;
	u64 xtime_nsec;
	ktime_t base;
	u64 base_real;
};

struct timekeeper {
	struct tk_read_base tkr_mono;
	struct tk_read_base tkr_raw;
	u64 xtime_sec;
	long unsigned int ktime_sec;
	struct timespec64 wall_to_monotonic;
	ktime_t offs_real;
	ktime_t offs_boot;
	ktime_t offs_tai;
	s32 tai_offset;
	unsigned int clock_was_set_seq;
	u8 cs_was_changed_seq;
	ktime_t next_leap_ktime;
	u64 raw_sec;
	struct timespec64 monotonic_to_boot;
	u64 cycle_interval;
	u64 xtime_interval;
	s64 xtime_remainder;
	u64 raw_interval;
	u64 ntp_tick;
	s64 ntp_error;
	u32 ntp_error_shift;
	u32 ntp_err_mult;
	u32 skip_second_overflow;
};

struct hrtimer_sleeper {
	struct hrtimer timer;
	struct task_struct *task;
};

struct rt_mutex_base {
	raw_spinlock_t wait_lock;
	struct rb_root_cached waiters;
	struct task_struct *owner;
};

union futex_key {
	struct {
		u64 i_seq;
		long unsigned int pgoff;
		unsigned int offset;
	} shared;
	struct {
		union {
			struct mm_struct *mm;
			u64 __tmp;
		};
		long unsigned int address;
		unsigned int offset;
	} private;
	struct {
		u64 ptr;
		long unsigned int word;
		unsigned int offset;
	} both;
};

struct futex_pi_state {
	struct list_head list;
	struct rt_mutex_base pi_mutex;
	struct task_struct *owner;
	refcount_t refcount;
	union futex_key key;
};

struct futex_waitv {
	__u64 val;
	__u64 uaddr;
	__u32 flags;
	__u32 __reserved;
};

struct futex_hash_bucket {
	atomic_t waiters;
	spinlock_t lock;
	struct plist_head chain;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct futex_q {
	struct plist_node list;
	struct task_struct *task;
	spinlock_t *lock_ptr;
	union futex_key key;
	struct futex_pi_state *pi_state;
	struct rt_mutex_waiter *rt_waiter;
	union futex_key *requeue_pi_key;
	u32 bitset;
	atomic_t requeue_state;
};

enum futex_access {
	FUTEX_READ = 0,
	FUTEX_WRITE = 1,
};

struct futex_vector {
	struct futex_waitv w;
	struct futex_q q;
};

struct ppc_cache_info {
	u32 size;
	u32 line_size;
	u32 block_size;
	u32 log_block_size;
	u32 blocks_per_page;
	u32 sets;
	u32 assoc;
};

struct ppc64_caches {
	struct ppc_cache_info l1d;
	struct ppc_cache_info l1i;
	struct ppc_cache_info l2;
	struct ppc_cache_info l3;
};

enum {
	IORES_DESC_NONE = 0,
	IORES_DESC_CRASH_KERNEL = 1,
	IORES_DESC_ACPI_TABLES = 2,
	IORES_DESC_ACPI_NV_STORAGE = 3,
	IORES_DESC_PERSISTENT_MEMORY = 4,
	IORES_DESC_PERSISTENT_MEMORY_LEGACY = 5,
	IORES_DESC_DEVICE_PRIVATE_MEMORY = 6,
	IORES_DESC_RESERVED = 7,
	IORES_DESC_SOFT_RESERVED = 8,
	IORES_DESC_CXL = 9,
};

struct elf_siginfo {
	int si_signo;
	int si_code;
	int si_errno;
};

struct elf_prstatus_common {
	struct elf_siginfo pr_info;
	short int pr_cursig;
	long unsigned int pr_sigpend;
	long unsigned int pr_sighold;
	pid_t pr_pid;
	pid_t pr_ppid;
	pid_t pr_pgrp;
	pid_t pr_sid;
	struct __kernel_old_timeval pr_utime;
	struct __kernel_old_timeval pr_stime;
	struct __kernel_old_timeval pr_cutime;
	struct __kernel_old_timeval pr_cstime;
};

struct elf_prstatus {
	struct elf_prstatus_common common;
	elf_gregset_t pr_reg;
	int pr_fpvalid;
};

typedef u32 note_buf_t[134];

struct kexec_load_limit {
	struct mutex mutex;
	int limit;
};

enum {
	CFTYPE_ONLY_ON_ROOT = 1,
	CFTYPE_NOT_ON_ROOT = 2,
	CFTYPE_NS_DELEGATABLE = 4,
	CFTYPE_NO_PREFIX = 8,
	CFTYPE_WORLD_WRITABLE = 16,
	CFTYPE_DEBUG = 32,
	__CFTYPE_ONLY_ON_DFL = 65536,
	__CFTYPE_NOT_ON_DFL = 131072,
	__CFTYPE_ADDED = 262144,
};

struct pids_cgroup {
	struct cgroup_subsys_state css;
	atomic64_t counter;
	atomic64_t limit;
	int64_t watermark;
	struct cgroup_file events_file;
	atomic64_t events_limit;
};

struct nsset {
	unsigned int flags;
	struct nsproxy *nsproxy;
	struct fs_struct *fs;
	const struct cred *cred;
};

typedef int __kernel_mqd_t;

typedef struct {
	int val[2];
} __kernel_fsid_t;

typedef __kernel_mqd_t mqd_t;

enum audit_state {
	AUDIT_STATE_DISABLED = 0,
	AUDIT_STATE_BUILD = 1,
	AUDIT_STATE_RECORD = 2,
};

struct audit_cap_data {
	kernel_cap_t permitted;
	kernel_cap_t inheritable;
	union {
		unsigned int fE;
		kernel_cap_t effective;
	};
	kernel_cap_t ambient;
	kuid_t rootid;
};

struct filename;

struct audit_names {
	struct list_head list;
	struct filename *name;
	int name_len;
	bool hidden;
	long unsigned int ino;
	dev_t dev;
	umode_t mode;
	kuid_t uid;
	kgid_t gid;
	dev_t rdev;
	u32 osid;
	struct audit_cap_data fcap;
	unsigned int fcap_ver;
	unsigned char type;
	bool should_free;
};

struct mq_attr {
	__kernel_long_t mq_flags;
	__kernel_long_t mq_maxmsg;
	__kernel_long_t mq_msgsize;
	__kernel_long_t mq_curmsgs;
	__kernel_long_t __reserved[4];
};

struct open_how {
	__u64 flags;
	__u64 mode;
	__u64 resolve;
};

struct audit_proctitle {
	int len;
	char *value;
};

struct audit_aux_data;

struct __kernel_sockaddr_storage;

struct audit_tree_refs;

struct audit_context {
	int dummy;
	enum {
		AUDIT_CTX_UNUSED = 0,
		AUDIT_CTX_SYSCALL = 1,
		AUDIT_CTX_URING = 2,
	} context;
	enum audit_state state;
	enum audit_state current_state;
	unsigned int serial;
	int major;
	int uring_op;
	struct timespec64 ctime;
	long unsigned int argv[4];
	long int return_code;
	u64 prio;
	int return_valid;
	struct audit_names preallocated_names[5];
	int name_count;
	struct list_head names_list;
	char *filterkey;
	struct path pwd;
	struct audit_aux_data *aux;
	struct audit_aux_data *aux_pids;
	struct __kernel_sockaddr_storage *sockaddr;
	size_t sockaddr_len;
	pid_t ppid;
	kuid_t uid;
	kuid_t euid;
	kuid_t suid;
	kuid_t fsuid;
	kgid_t gid;
	kgid_t egid;
	kgid_t sgid;
	kgid_t fsgid;
	long unsigned int personality;
	int arch;
	pid_t target_pid;
	kuid_t target_auid;
	kuid_t target_uid;
	unsigned int target_sessionid;
	u32 target_sid;
	char target_comm[16];
	struct audit_tree_refs *trees;
	struct audit_tree_refs *first_trees;
	struct list_head killed_trees;
	int tree_count;
	int type;
	union {
		struct {
			int nargs;
			long int args[6];
		} socketcall;
		struct {
			kuid_t uid;
			kgid_t gid;
			umode_t mode;
			u32 osid;
			int has_perm;
			uid_t perm_uid;
			gid_t perm_gid;
			umode_t perm_mode;
			long unsigned int qbytes;
		} ipc;
		struct {
			mqd_t mqdes;
			struct mq_attr mqstat;
		} mq_getsetattr;
		struct {
			mqd_t mqdes;
			int sigev_signo;
		} mq_notify;
		struct {
			mqd_t mqdes;
			size_t msg_len;
			unsigned int msg_prio;
			struct timespec64 abs_timeout;
		} mq_sendrecv;
		struct {
			int oflag;
			umode_t mode;
			struct mq_attr attr;
		} mq_open;
		struct {
			pid_t pid;
			struct audit_cap_data cap;
		} capset;
		struct {
			int fd;
			int flags;
		} mmap;
		struct open_how openat2;
		struct {
			int argc;
		} execve;
		struct {
			char *name;
		} module;
		struct {
			struct audit_ntp_data ntp_data;
			struct timespec64 tk_injoffset;
		} time;
	};
	int fds[2];
	struct audit_proctitle proctitle;
};

typedef struct fsnotify_mark_connector *fsnotify_connp_t;

struct fsnotify_mark_connector {
	spinlock_t lock;
	short unsigned int type;
	short unsigned int flags;
	__kernel_fsid_t fsid;
	union {
		fsnotify_connp_t *obj;
		struct fsnotify_mark_connector *destroy_next;
	};
	struct hlist_head list;
};

struct filename {
	const char *name;
	const char *uptr;
	atomic_t refcnt;
	struct audit_names *aname;
	const char iname[0];
};

struct audit_field;

struct audit_watch;

struct audit_tree;

struct audit_fsnotify_mark;

struct audit_krule {
	u32 pflags;
	u32 flags;
	u32 listnr;
	u32 action;
	u32 mask[64];
	u32 buflen;
	u32 field_count;
	char *filterkey;
	struct audit_field *fields;
	struct audit_field *arch_f;
	struct audit_field *inode_f;
	struct audit_watch *watch;
	struct audit_tree *tree;
	struct audit_fsnotify_mark *exe;
	struct list_head rlist;
	struct list_head list;
	u64 prio;
};

struct audit_field {
	u32 type;
	union {
		u32 val;
		kuid_t uid;
		kgid_t gid;
		struct {
			char *lsm_str;
			void *lsm_rule;
		};
	};
	u32 op;
};

struct fsnotify_group;

struct fsnotify_mark {
	__u32 mask;
	refcount_t refcnt;
	struct fsnotify_group *group;
	struct list_head g_list;
	spinlock_t lock;
	struct hlist_node obj_list;
	struct fsnotify_mark_connector *connector;
	__u32 ignore_mask;
	unsigned int flags;
};

struct audit_fsnotify_mark {
	dev_t dev;
	long unsigned int ino;
	char *path;
	struct fsnotify_mark mark;
	struct audit_krule *rule;
};

struct fsnotify_iter_info;

struct fsnotify_event;

struct fsnotify_ops {
	int (*handle_event)(struct fsnotify_group *, u32, const void *, int, struct inode *, const struct qstr *, u32, struct fsnotify_iter_info *);
	int (*handle_inode_event)(struct fsnotify_mark *, u32, struct inode *, struct inode *, const struct qstr *, u32);
	void (*free_group_priv)(struct fsnotify_group *);
	void (*freeing_mark)(struct fsnotify_mark *, struct fsnotify_group *);
	void (*free_event)(struct fsnotify_group *, struct fsnotify_event *);
	void (*free_mark)(struct fsnotify_mark *);
};

struct inotify_group_private_data {
	spinlock_t idr_lock;
	struct idr idr;
	struct ucounts *ucounts;
};

struct fsnotify_group {
	const struct fsnotify_ops *ops;
	refcount_t refcnt;
	spinlock_t notification_lock;
	struct list_head notification_list;
	wait_queue_head_t notification_waitq;
	unsigned int q_len;
	unsigned int max_events;
	unsigned int priority;
	bool shutdown;
	int flags;
	unsigned int owner_flags;
	struct mutex mark_mutex;
	atomic_t user_waits;
	struct list_head marks_list;
	struct fasync_struct *fsn_fa;
	struct fsnotify_event *overflow_event;
	struct mem_cgroup *memcg;
	union {
		void *private;
		struct inotify_group_private_data inotify_data;
	};
};

struct fsnotify_iter_info {
	struct fsnotify_mark *marks[5];
	struct fsnotify_group *current_group;
	unsigned int report_mask;
	int srcu_idx;
};

struct fsnotify_event {
	struct list_head list;
};

enum fsnotify_obj_type {
	FSNOTIFY_OBJ_TYPE_ANY = -1,
	FSNOTIFY_OBJ_TYPE_INODE = 0,
	FSNOTIFY_OBJ_TYPE_VFSMOUNT = 1,
	FSNOTIFY_OBJ_TYPE_SB = 2,
	FSNOTIFY_OBJ_TYPE_COUNT = 3,
	FSNOTIFY_OBJ_TYPE_DETACHED = 3,
};

typedef short unsigned int __kernel_sa_family_t;

struct __kernel_sockaddr_storage {
	union {
		struct {
			__kernel_sa_family_t ss_family;
			char __data[126];
		};
		void *__align;
	};
};

struct audit_entry {
	struct list_head list;
	struct callback_head rcu;
	struct audit_krule rule;
};

struct audit_buffer;

enum lockdep_ok {
	LOCKDEP_STILL_OK = 0,
	LOCKDEP_NOW_UNRELIABLE = 1,
};

struct cpu_stop_done;

struct cpu_stop_work {
	struct list_head list;
	cpu_stop_fn_t fn;
	long unsigned int caller;
	void *arg;
	struct cpu_stop_done *done;
};

enum lockdown_reason {
	LOCKDOWN_NONE = 0,
	LOCKDOWN_MODULE_SIGNATURE = 1,
	LOCKDOWN_DEV_MEM = 2,
	LOCKDOWN_EFI_TEST = 3,
	LOCKDOWN_KEXEC = 4,
	LOCKDOWN_HIBERNATION = 5,
	LOCKDOWN_PCI_ACCESS = 6,
	LOCKDOWN_IOPORT = 7,
	LOCKDOWN_MSR = 8,
	LOCKDOWN_ACPI_TABLES = 9,
	LOCKDOWN_DEVICE_TREE = 10,
	LOCKDOWN_PCMCIA_CIS = 11,
	LOCKDOWN_TIOCSSERIAL = 12,
	LOCKDOWN_MODULE_PARAMETERS = 13,
	LOCKDOWN_MMIOTRACE = 14,
	LOCKDOWN_DEBUGFS = 15,
	LOCKDOWN_XMON_WR = 16,
	LOCKDOWN_BPF_WRITE_USER = 17,
	LOCKDOWN_DBG_WRITE_KERNEL = 18,
	LOCKDOWN_RTAS_ERROR_INJECTION = 19,
	LOCKDOWN_INTEGRITY_MAX = 20,
	LOCKDOWN_KCORE = 21,
	LOCKDOWN_KPROBES = 22,
	LOCKDOWN_BPF_READ_KERNEL = 23,
	LOCKDOWN_DBG_READ_KERNEL = 24,
	LOCKDOWN_PERF = 25,
	LOCKDOWN_TRACEFS = 26,
	LOCKDOWN_XMON_RW = 27,
	LOCKDOWN_XFRM_SECRET = 28,
	LOCKDOWN_CONFIDENTIALITY_MAX = 29,
};

struct tracer_stat {
	const char *name;
	void * (*stat_start)(struct tracer_stat *);
	void * (*stat_next)(void *, int);
	cmp_func_t stat_cmp;
	int (*stat_show)(struct seq_file *, void *);
	void (*stat_release)(void *);
	int (*stat_headers)(struct seq_file *);
};

struct ftrace_hash {
	long unsigned int size_bits;
	struct hlist_head *buckets;
	long unsigned int count;
	long unsigned int flags;
	struct callback_head rcu;
};

struct prog_entry;

struct event_filter {
	struct prog_entry *prog;
	char *filter_string;
};

struct trace_array_cpu;

struct array_buffer {
	struct trace_array *tr;
	struct trace_buffer *buffer;
	struct trace_array_cpu *data;
	u64 time_start;
	int cpu;
};

struct trace_pid_list;

struct trace_options;

struct cond_snapshot;

struct trace_func_repeats;

struct trace_array {
	struct list_head list;
	char *name;
	struct array_buffer array_buffer;
	struct array_buffer max_buffer;
	bool allocated_snapshot;
	long unsigned int max_latency;
	struct dentry *d_max_latency;
	struct work_struct fsnotify_work;
	struct irq_work fsnotify_irqwork;
	struct trace_pid_list *filtered_pids;
	struct trace_pid_list *filtered_no_pids;
	arch_spinlock_t max_lock;
	int buffer_disabled;
	int sys_refcount_enter;
	int sys_refcount_exit;
	struct trace_event_file *enter_syscall_files[453];
	struct trace_event_file *exit_syscall_files[453];
	int stop_count;
	int clock_id;
	int nr_topts;
	bool clear_trace;
	int buffer_percent;
	unsigned int n_err_log_entries;
	struct tracer *current_trace;
	unsigned int trace_flags;
	unsigned char trace_flags_index[32];
	unsigned int flags;
	raw_spinlock_t start_lock;
	struct list_head err_log;
	struct dentry *dir;
	struct dentry *options;
	struct dentry *percpu_dir;
	struct dentry *event_dir;
	struct trace_options *topts;
	struct list_head systems;
	struct list_head events;
	struct trace_event_file *trace_marker_file;
	cpumask_var_t tracing_cpumask;
	cpumask_var_t pipe_cpumask;
	int ref;
	int trace_ref;
	struct ftrace_ops *ops;
	struct trace_pid_list *function_pids;
	struct trace_pid_list *function_no_pids;
	struct list_head func_probes;
	struct list_head mod_trace;
	struct list_head mod_notrace;
	int function_enabled;
	int no_filter_buffering_ref;
	struct list_head hist_vars;
	struct cond_snapshot *cond_snapshot;
	struct trace_func_repeats *last_func_repeats;
};

struct tracer_flags;

struct tracer {
	const char *name;
	int (*init)(struct trace_array *);
	void (*reset)(struct trace_array *);
	void (*start)(struct trace_array *);
	void (*stop)(struct trace_array *);
	int (*update_thresh)(struct trace_array *);
	void (*open)(struct trace_iterator *);
	void (*pipe_open)(struct trace_iterator *);
	void (*close)(struct trace_iterator *);
	void (*pipe_close)(struct trace_iterator *);
	ssize_t (*read)(struct trace_iterator *, struct file *, char *, size_t, loff_t *);
	ssize_t (*splice_read)(struct trace_iterator *, struct file *, loff_t *, struct pipe_inode_info *, size_t, unsigned int);
	void (*print_header)(struct seq_file *);
	enum print_line_t (*print_line)(struct trace_iterator *);
	int (*set_flag)(struct trace_array *, u32, u32, int);
	int (*flag_changed)(struct trace_array *, u32, int);
	struct tracer *next;
	struct tracer_flags *flags;
	int enabled;
	bool print_max;
	bool allow_instances;
	bool use_max_tr;
	bool noboot;
};

struct event_subsystem;

struct trace_subsystem_dir {
	struct list_head list;
	struct event_subsystem *subsystem;
	struct trace_array *tr;
	struct eventfs_file *ef;
	int ref_count;
	int nr_events;
};

union lower_chunk {
	union lower_chunk *next;
	long unsigned int data[256];
};

union upper_chunk {
	union upper_chunk *next;
	union lower_chunk *data[256];
};

struct trace_pid_list {
	raw_spinlock_t lock;
	struct irq_work refill_irqwork;
	union upper_chunk *upper[256];
	union upper_chunk *upper_list;
	union lower_chunk *lower_list;
	int free_upper_chunks;
	int free_lower_chunks;
};

struct trace_array_cpu {
	atomic_t disabled;
	void *buffer_page;
	long unsigned int entries;
	long unsigned int saved_latency;
	long unsigned int critical_start;
	long unsigned int critical_end;
	long unsigned int critical_sequence;
	long unsigned int nice;
	long unsigned int policy;
	long unsigned int rt_priority;
	long unsigned int skipped_entries;
	u64 preempt_timestamp;
	pid_t pid;
	kuid_t uid;
	char comm[16];
	int ftrace_ignore_pid;
	bool ignore_pid;
};

struct trace_option_dentry;

struct trace_options {
	struct tracer *tracer;
	struct trace_option_dentry *topts;
};

struct tracer_opt;

struct trace_option_dentry {
	struct tracer_opt *opt;
	struct tracer_flags *flags;
	struct trace_array *tr;
	struct dentry *entry;
};

typedef bool (*cond_update_fn_t)(struct trace_array *, void *);

struct cond_snapshot {
	void *cond_data;
	cond_update_fn_t update;
};

struct trace_func_repeats {
	long unsigned int ip;
	long unsigned int parent_ip;
	long unsigned int count;
	u64 ts_last_call;
};

struct tracer_opt {
	const char *name;
	u32 bit;
};

struct tracer_flags {
	u32 val;
	struct tracer_opt *opts;
	struct tracer *trace;
};

enum trace_iterator_bits {
	TRACE_ITER_PRINT_PARENT_BIT = 0,
	TRACE_ITER_SYM_OFFSET_BIT = 1,
	TRACE_ITER_SYM_ADDR_BIT = 2,
	TRACE_ITER_VERBOSE_BIT = 3,
	TRACE_ITER_RAW_BIT = 4,
	TRACE_ITER_HEX_BIT = 5,
	TRACE_ITER_BIN_BIT = 6,
	TRACE_ITER_BLOCK_BIT = 7,
	TRACE_ITER_FIELDS_BIT = 8,
	TRACE_ITER_PRINTK_BIT = 9,
	TRACE_ITER_ANNOTATE_BIT = 10,
	TRACE_ITER_USERSTACKTRACE_BIT = 11,
	TRACE_ITER_SYM_USEROBJ_BIT = 12,
	TRACE_ITER_PRINTK_MSGONLY_BIT = 13,
	TRACE_ITER_CONTEXT_INFO_BIT = 14,
	TRACE_ITER_LATENCY_FMT_BIT = 15,
	TRACE_ITER_RECORD_CMD_BIT = 16,
	TRACE_ITER_RECORD_TGID_BIT = 17,
	TRACE_ITER_OVERWRITE_BIT = 18,
	TRACE_ITER_STOP_ON_FREE_BIT = 19,
	TRACE_ITER_IRQ_INFO_BIT = 20,
	TRACE_ITER_MARKERS_BIT = 21,
	TRACE_ITER_EVENT_FORK_BIT = 22,
	TRACE_ITER_PAUSE_ON_TRACE_BIT = 23,
	TRACE_ITER_HASH_PTR_BIT = 24,
	TRACE_ITER_FUNCTION_BIT = 25,
	TRACE_ITER_FUNC_FORK_BIT = 26,
	TRACE_ITER_DISPLAY_GRAPH_BIT = 27,
	TRACE_ITER_STACKTRACE_BIT = 28,
	TRACE_ITER_LAST_BIT = 29,
};

struct event_subsystem {
	struct list_head list;
	const char *name;
	struct event_filter *filter;
	int ref_count;
};

struct stat_node {
	struct rb_node node;
	void *stat;
};

struct stat_session {
	struct list_head session_list;
	struct tracer_stat *ts;
	struct rb_root stat_root;
	struct mutex stat_mutex;
	struct dentry *file;
};

struct ftrace_func_entry {
	struct hlist_node hlist;
	long unsigned int ip;
	long unsigned int direct;
};

struct ftrace_graph_ent {
	long unsigned int func;
	int depth;
} __attribute__((packed));

struct ftrace_graph_ret {
	long unsigned int func;
	int depth;
	unsigned int overrun;
	long long unsigned int calltime;
	long long unsigned int rettime;
};

typedef void (*trace_func_graph_ret_t)(struct ftrace_graph_ret *);

typedef int (*trace_func_graph_ent_t)(struct ftrace_graph_ent *);

struct fgraph_ops {
	trace_func_graph_ent_t entryfunc;
	trace_func_graph_ret_t retfunc;
};

enum trace_flag_type {
	TRACE_FLAG_IRQS_OFF = 1,
	TRACE_FLAG_IRQS_NOSUPPORT = 2,
	TRACE_FLAG_NEED_RESCHED = 4,
	TRACE_FLAG_HARDIRQ = 8,
	TRACE_FLAG_SOFTIRQ = 16,
	TRACE_FLAG_PREEMPT_RESCHED = 32,
	TRACE_FLAG_NMI = 64,
	TRACE_FLAG_BH_OFF = 128,
};

enum trace_type {
	__TRACE_FIRST_TYPE = 0,
	TRACE_FN = 1,
	TRACE_CTX = 2,
	TRACE_WAKE = 3,
	TRACE_STACK = 4,
	TRACE_PRINT = 5,
	TRACE_BPRINT = 6,
	TRACE_MMIO_RW = 7,
	TRACE_MMIO_MAP = 8,
	TRACE_BRANCH = 9,
	TRACE_GRAPH_RET = 10,
	TRACE_GRAPH_ENT = 11,
	TRACE_USER_STACK = 12,
	TRACE_BLK = 13,
	TRACE_BPUTS = 14,
	TRACE_HWLAT = 15,
	TRACE_OSNOISE = 16,
	TRACE_TIMERLAT = 17,
	TRACE_RAW_DATA = 18,
	TRACE_FUNC_REPEATS = 19,
	__TRACE_LAST_TYPE = 20,
};

struct ctx_switch_entry {
	struct trace_entry ent;
	unsigned int prev_pid;
	unsigned int next_pid;
	unsigned int next_cpu;
	unsigned char prev_prio;
	unsigned char prev_state;
	unsigned char next_prio;
	unsigned char next_state;
};

enum {
	FTRACE_HASH_FL_MOD = 1,
};

enum trace_iterator_flags {
	TRACE_ITER_PRINT_PARENT = 1,
	TRACE_ITER_SYM_OFFSET = 2,
	TRACE_ITER_SYM_ADDR = 4,
	TRACE_ITER_VERBOSE = 8,
	TRACE_ITER_RAW = 16,
	TRACE_ITER_HEX = 32,
	TRACE_ITER_BIN = 64,
	TRACE_ITER_BLOCK = 128,
	TRACE_ITER_FIELDS = 256,
	TRACE_ITER_PRINTK = 512,
	TRACE_ITER_ANNOTATE = 1024,
	TRACE_ITER_USERSTACKTRACE = 2048,
	TRACE_ITER_SYM_USEROBJ = 4096,
	TRACE_ITER_PRINTK_MSGONLY = 8192,
	TRACE_ITER_CONTEXT_INFO = 16384,
	TRACE_ITER_LATENCY_FMT = 32768,
	TRACE_ITER_RECORD_CMD = 65536,
	TRACE_ITER_RECORD_TGID = 131072,
	TRACE_ITER_OVERWRITE = 262144,
	TRACE_ITER_STOP_ON_FREE = 524288,
	TRACE_ITER_IRQ_INFO = 1048576,
	TRACE_ITER_MARKERS = 2097152,
	TRACE_ITER_EVENT_FORK = 4194304,
	TRACE_ITER_PAUSE_ON_TRACE = 8388608,
	TRACE_ITER_HASH_PTR = 16777216,
	TRACE_ITER_FUNCTION = 33554432,
	TRACE_ITER_FUNC_FORK = 67108864,
	TRACE_ITER_DISPLAY_GRAPH = 134217728,
	TRACE_ITER_STACKTRACE = 268435456,
};

enum perf_event_sample_format {
	PERF_SAMPLE_IP = 1,
	PERF_SAMPLE_TID = 2,
	PERF_SAMPLE_TIME = 4,
	PERF_SAMPLE_ADDR = 8,
	PERF_SAMPLE_READ = 16,
	PERF_SAMPLE_CALLCHAIN = 32,
	PERF_SAMPLE_ID = 64,
	PERF_SAMPLE_CPU = 128,
	PERF_SAMPLE_PERIOD = 256,
	PERF_SAMPLE_STREAM_ID = 512,
	PERF_SAMPLE_RAW = 1024,
	PERF_SAMPLE_BRANCH_STACK = 2048,
	PERF_SAMPLE_REGS_USER = 4096,
	PERF_SAMPLE_STACK_USER = 8192,
	PERF_SAMPLE_WEIGHT = 16384,
	PERF_SAMPLE_DATA_SRC = 32768,
	PERF_SAMPLE_IDENTIFIER = 65536,
	PERF_SAMPLE_TRANSACTION = 131072,
	PERF_SAMPLE_REGS_INTR = 262144,
	PERF_SAMPLE_PHYS_ADDR = 524288,
	PERF_SAMPLE_AUX = 1048576,
	PERF_SAMPLE_CGROUP = 2097152,
	PERF_SAMPLE_DATA_PAGE_SIZE = 4194304,
	PERF_SAMPLE_CODE_PAGE_SIZE = 8388608,
	PERF_SAMPLE_WEIGHT_STRUCT = 16777216,
	PERF_SAMPLE_MAX = 33554432,
};

struct ftrace_entry {
	struct trace_entry ent;
	long unsigned int ip;
	long unsigned int parent_ip;
};

typedef long unsigned int perf_trace_t[1024];

struct clk;

enum cpufreq_table_sorting {
	CPUFREQ_TABLE_UNSORTED = 0,
	CPUFREQ_TABLE_SORTED_ASCENDING = 1,
	CPUFREQ_TABLE_SORTED_DESCENDING = 2,
};

struct cpufreq_cpuinfo {
	unsigned int max_freq;
	unsigned int min_freq;
	unsigned int transition_latency;
};

struct cpufreq_stats;

struct cpufreq_governor;

struct cpufreq_frequency_table;

struct thermal_cooling_device;

struct cpufreq_policy {
	cpumask_var_t cpus;
	cpumask_var_t related_cpus;
	cpumask_var_t real_cpus;
	unsigned int shared_type;
	unsigned int cpu;
	struct clk *clk;
	struct cpufreq_cpuinfo cpuinfo;
	unsigned int min;
	unsigned int max;
	unsigned int cur;
	unsigned int suspend_freq;
	unsigned int policy;
	unsigned int last_policy;
	struct cpufreq_governor *governor;
	void *governor_data;
	char last_governor[16];
	struct work_struct update;
	struct freq_constraints constraints;
	struct freq_qos_request *min_freq_req;
	struct freq_qos_request *max_freq_req;
	struct cpufreq_frequency_table *freq_table;
	enum cpufreq_table_sorting freq_table_sorted;
	struct list_head policy_list;
	struct kobject kobj;
	struct completion kobj_unregister;
	struct rw_semaphore rwsem;
	bool fast_switch_possible;
	bool fast_switch_enabled;
	bool strict_target;
	bool efficiencies_available;
	unsigned int transition_delay_us;
	bool dvfs_possible_from_any_cpu;
	bool boost_enabled;
	unsigned int cached_target_freq;
	unsigned int cached_resolved_idx;
	bool transition_ongoing;
	spinlock_t transition_lock;
	wait_queue_head_t transition_wait;
	struct task_struct *transition_task;
	struct cpufreq_stats *stats;
	void *driver_data;
	struct thermal_cooling_device *cdev;
	struct notifier_block nb_min;
	struct notifier_block nb_max;
};

struct cpufreq_governor {
	char name[16];
	int (*init)(struct cpufreq_policy *);
	void (*exit)(struct cpufreq_policy *);
	int (*start)(struct cpufreq_policy *);
	void (*stop)(struct cpufreq_policy *);
	void (*limits)(struct cpufreq_policy *);
	ssize_t (*show_setspeed)(struct cpufreq_policy *, char *);
	int (*store_setspeed)(struct cpufreq_policy *, unsigned int);
	struct list_head governor_list;
	struct module *owner;
	u8 flags;
};

struct cpufreq_frequency_table {
	unsigned int flags;
	unsigned int driver_data;
	unsigned int frequency;
};

struct trace_event_raw_cpu {
	struct trace_entry ent;
	u32 state;
	u32 cpu_id;
	char __data[0];
};

struct trace_event_raw_cpu_idle_miss {
	struct trace_entry ent;
	u32 cpu_id;
	u32 state;
	bool below;
	char __data[0];
};

struct trace_event_raw_powernv_throttle {
	struct trace_entry ent;
	int chip_id;
	u32 __data_loc_reason;
	int pmax;
	char __data[0];
};

struct trace_event_raw_pstate_sample {
	struct trace_entry ent;
	u32 core_busy;
	u32 scaled_busy;
	u32 from;
	u32 to;
	u64 mperf;
	u64 aperf;
	u64 tsc;
	u32 freq;
	u32 io_boost;
	char __data[0];
};

struct trace_event_raw_cpu_frequency_limits {
	struct trace_entry ent;
	u32 min_freq;
	u32 max_freq;
	u32 cpu_id;
	char __data[0];
};

struct trace_event_raw_device_pm_callback_start {
	struct trace_entry ent;
	u32 __data_loc_device;
	u32 __data_loc_driver;
	u32 __data_loc_parent;
	u32 __data_loc_pm_ops;
	int event;
	char __data[0];
};

struct trace_event_raw_device_pm_callback_end {
	struct trace_entry ent;
	u32 __data_loc_device;
	u32 __data_loc_driver;
	int error;
	char __data[0];
};

struct trace_event_raw_suspend_resume {
	struct trace_entry ent;
	const char *action;
	int val;
	bool start;
	char __data[0];
};

struct trace_event_raw_wakeup_source {
	struct trace_entry ent;
	u32 __data_loc_name;
	u64 state;
	char __data[0];
};

struct trace_event_raw_clock {
	struct trace_entry ent;
	u32 __data_loc_name;
	u64 state;
	u64 cpu_id;
	char __data[0];
};

struct trace_event_raw_power_domain {
	struct trace_entry ent;
	u32 __data_loc_name;
	u64 state;
	u64 cpu_id;
	char __data[0];
};

struct trace_event_raw_cpu_latency_qos_request {
	struct trace_entry ent;
	s32 value;
	char __data[0];
};

struct trace_event_raw_pm_qos_update {
	struct trace_entry ent;
	enum pm_qos_req_action action;
	int prev_value;
	int curr_value;
	char __data[0];
};

struct trace_event_raw_dev_pm_qos_request {
	struct trace_entry ent;
	u32 __data_loc_name;
	enum dev_pm_qos_req_type type;
	s32 new_value;
	char __data[0];
};

struct trace_event_raw_guest_halt_poll_ns {
	struct trace_entry ent;
	bool grow;
	unsigned int new;
	unsigned int old;
	char __data[0];
};

struct trace_event_data_offsets_cpu {};

struct trace_event_data_offsets_cpu_idle_miss {};

struct trace_event_data_offsets_powernv_throttle {
	u32 reason;
};

struct trace_event_data_offsets_pstate_sample {};

struct trace_event_data_offsets_cpu_frequency_limits {};

struct trace_event_data_offsets_device_pm_callback_start {
	u32 device;
	u32 driver;
	u32 parent;
	u32 pm_ops;
};

struct trace_event_data_offsets_device_pm_callback_end {
	u32 device;
	u32 driver;
};

struct trace_event_data_offsets_suspend_resume {};

struct trace_event_data_offsets_wakeup_source {
	u32 name;
};

struct trace_event_data_offsets_clock {
	u32 name;
};

struct trace_event_data_offsets_power_domain {
	u32 name;
};

struct trace_event_data_offsets_cpu_latency_qos_request {};

struct trace_event_data_offsets_pm_qos_update {};

struct trace_event_data_offsets_dev_pm_qos_request {
	u32 name;
};

struct trace_event_data_offsets_guest_halt_poll_ns {};

typedef void (*btf_trace_cpu_idle)(void *, unsigned int, unsigned int);

typedef void (*btf_trace_cpu_idle_miss)(void *, unsigned int, unsigned int, bool);

typedef void (*btf_trace_powernv_throttle)(void *, int, const char *, int);

typedef void (*btf_trace_pstate_sample)(void *, u32, u32, u32, u32, u64, u64, u64, u32, u32);

typedef void (*btf_trace_cpu_frequency)(void *, unsigned int, unsigned int);

typedef void (*btf_trace_cpu_frequency_limits)(void *, struct cpufreq_policy *);

typedef void (*btf_trace_device_pm_callback_start)(void *, struct device *, const char *, int);

typedef void (*btf_trace_device_pm_callback_end)(void *, struct device *, int);

typedef void (*btf_trace_suspend_resume)(void *, const char *, int, bool);

typedef void (*btf_trace_wakeup_source_activate)(void *, const char *, unsigned int);

typedef void (*btf_trace_wakeup_source_deactivate)(void *, const char *, unsigned int);

typedef void (*btf_trace_clock_enable)(void *, const char *, unsigned int, unsigned int);

typedef void (*btf_trace_clock_disable)(void *, const char *, unsigned int, unsigned int);

typedef void (*btf_trace_clock_set_rate)(void *, const char *, unsigned int, unsigned int);

typedef void (*btf_trace_power_domain_target)(void *, const char *, unsigned int, unsigned int);

typedef void (*btf_trace_pm_qos_add_request)(void *, s32);

typedef void (*btf_trace_pm_qos_update_request)(void *, s32);

typedef void (*btf_trace_pm_qos_remove_request)(void *, s32);

typedef void (*btf_trace_pm_qos_update_target)(void *, enum pm_qos_req_action, int, int);

typedef void (*btf_trace_pm_qos_update_flags)(void *, enum pm_qos_req_action, int, int);

typedef void (*btf_trace_dev_pm_qos_add_request)(void *, const char *, enum dev_pm_qos_req_type, s32);

typedef void (*btf_trace_dev_pm_qos_update_request)(void *, const char *, enum dev_pm_qos_req_type, s32);

typedef void (*btf_trace_dev_pm_qos_remove_request)(void *, const char *, enum dev_pm_qos_req_type, s32);

typedef void (*btf_trace_guest_halt_poll_ns)(void *, bool, unsigned int, unsigned int);

enum {
	BPF_REG_0 = 0,
	BPF_REG_1 = 1,
	BPF_REG_2 = 2,
	BPF_REG_3 = 3,
	BPF_REG_4 = 4,
	BPF_REG_5 = 5,
	BPF_REG_6 = 6,
	BPF_REG_7 = 7,
	BPF_REG_8 = 8,
	BPF_REG_9 = 9,
	BPF_REG_10 = 10,
	__MAX_BPF_REG = 11,
};

struct bpf_insn {
	__u8 code;
	__u8 dst_reg: 4;
	__u8 src_reg: 4;
	__s16 off;
	__s32 imm;
};

struct bpf_cgroup_storage_key {
	__u64 cgroup_inode_id;
	__u32 attach_type;
};

enum bpf_cgroup_iter_order {
	BPF_CGROUP_ITER_ORDER_UNSPEC = 0,
	BPF_CGROUP_ITER_SELF_ONLY = 1,
	BPF_CGROUP_ITER_DESCENDANTS_PRE = 2,
	BPF_CGROUP_ITER_DESCENDANTS_POST = 3,
	BPF_CGROUP_ITER_ANCESTORS_UP = 4,
};

enum bpf_cmd {
	BPF_MAP_CREATE = 0,
	BPF_MAP_LOOKUP_ELEM = 1,
	BPF_MAP_UPDATE_ELEM = 2,
	BPF_MAP_DELETE_ELEM = 3,
	BPF_MAP_GET_NEXT_KEY = 4,
	BPF_PROG_LOAD = 5,
	BPF_OBJ_PIN = 6,
	BPF_OBJ_GET = 7,
	BPF_PROG_ATTACH = 8,
	BPF_PROG_DETACH = 9,
	BPF_PROG_TEST_RUN = 10,
	BPF_PROG_RUN = 10,
	BPF_PROG_GET_NEXT_ID = 11,
	BPF_MAP_GET_NEXT_ID = 12,
	BPF_PROG_GET_FD_BY_ID = 13,
	BPF_MAP_GET_FD_BY_ID = 14,
	BPF_OBJ_GET_INFO_BY_FD = 15,
	BPF_PROG_QUERY = 16,
	BPF_RAW_TRACEPOINT_OPEN = 17,
	BPF_BTF_LOAD = 18,
	BPF_BTF_GET_FD_BY_ID = 19,
	BPF_TASK_FD_QUERY = 20,
	BPF_MAP_LOOKUP_AND_DELETE_ELEM = 21,
	BPF_MAP_FREEZE = 22,
	BPF_BTF_GET_NEXT_ID = 23,
	BPF_MAP_LOOKUP_BATCH = 24,
	BPF_MAP_LOOKUP_AND_DELETE_BATCH = 25,
	BPF_MAP_UPDATE_BATCH = 26,
	BPF_MAP_DELETE_BATCH = 27,
	BPF_LINK_CREATE = 28,
	BPF_LINK_UPDATE = 29,
	BPF_LINK_GET_FD_BY_ID = 30,
	BPF_LINK_GET_NEXT_ID = 31,
	BPF_ENABLE_STATS = 32,
	BPF_ITER_CREATE = 33,
	BPF_LINK_DETACH = 34,
	BPF_PROG_BIND_MAP = 35,
};

enum bpf_map_type {
	BPF_MAP_TYPE_UNSPEC = 0,
	BPF_MAP_TYPE_HASH = 1,
	BPF_MAP_TYPE_ARRAY = 2,
	BPF_MAP_TYPE_PROG_ARRAY = 3,
	BPF_MAP_TYPE_PERF_EVENT_ARRAY = 4,
	BPF_MAP_TYPE_PERCPU_HASH = 5,
	BPF_MAP_TYPE_PERCPU_ARRAY = 6,
	BPF_MAP_TYPE_STACK_TRACE = 7,
	BPF_MAP_TYPE_CGROUP_ARRAY = 8,
	BPF_MAP_TYPE_LRU_HASH = 9,
	BPF_MAP_TYPE_LRU_PERCPU_HASH = 10,
	BPF_MAP_TYPE_LPM_TRIE = 11,
	BPF_MAP_TYPE_ARRAY_OF_MAPS = 12,
	BPF_MAP_TYPE_HASH_OF_MAPS = 13,
	BPF_MAP_TYPE_DEVMAP = 14,
	BPF_MAP_TYPE_SOCKMAP = 15,
	BPF_MAP_TYPE_CPUMAP = 16,
	BPF_MAP_TYPE_XSKMAP = 17,
	BPF_MAP_TYPE_SOCKHASH = 18,
	BPF_MAP_TYPE_CGROUP_STORAGE_DEPRECATED = 19,
	BPF_MAP_TYPE_CGROUP_STORAGE = 19,
	BPF_MAP_TYPE_REUSEPORT_SOCKARRAY = 20,
	BPF_MAP_TYPE_PERCPU_CGROUP_STORAGE = 21,
	BPF_MAP_TYPE_QUEUE = 22,
	BPF_MAP_TYPE_STACK = 23,
	BPF_MAP_TYPE_SK_STORAGE = 24,
	BPF_MAP_TYPE_DEVMAP_HASH = 25,
	BPF_MAP_TYPE_STRUCT_OPS = 26,
	BPF_MAP_TYPE_RINGBUF = 27,
	BPF_MAP_TYPE_INODE_STORAGE = 28,
	BPF_MAP_TYPE_TASK_STORAGE = 29,
	BPF_MAP_TYPE_BLOOM_FILTER = 30,
	BPF_MAP_TYPE_USER_RINGBUF = 31,
	BPF_MAP_TYPE_CGRP_STORAGE = 32,
};

enum bpf_prog_type {
	BPF_PROG_TYPE_UNSPEC = 0,
	BPF_PROG_TYPE_SOCKET_FILTER = 1,
	BPF_PROG_TYPE_KPROBE = 2,
	BPF_PROG_TYPE_SCHED_CLS = 3,
	BPF_PROG_TYPE_SCHED_ACT = 4,
	BPF_PROG_TYPE_TRACEPOINT = 5,
	BPF_PROG_TYPE_XDP = 6,
	BPF_PROG_TYPE_PERF_EVENT = 7,
	BPF_PROG_TYPE_CGROUP_SKB = 8,
	BPF_PROG_TYPE_CGROUP_SOCK = 9,
	BPF_PROG_TYPE_LWT_IN = 10,
	BPF_PROG_TYPE_LWT_OUT = 11,
	BPF_PROG_TYPE_LWT_XMIT = 12,
	BPF_PROG_TYPE_SOCK_OPS = 13,
	BPF_PROG_TYPE_SK_SKB = 14,
	BPF_PROG_TYPE_CGROUP_DEVICE = 15,
	BPF_PROG_TYPE_SK_MSG = 16,
	BPF_PROG_TYPE_RAW_TRACEPOINT = 17,
	BPF_PROG_TYPE_CGROUP_SOCK_ADDR = 18,
	BPF_PROG_TYPE_LWT_SEG6LOCAL = 19,
	BPF_PROG_TYPE_LIRC_MODE2 = 20,
	BPF_PROG_TYPE_SK_REUSEPORT = 21,
	BPF_PROG_TYPE_FLOW_DISSECTOR = 22,
	BPF_PROG_TYPE_CGROUP_SYSCTL = 23,
	BPF_PROG_TYPE_RAW_TRACEPOINT_WRITABLE = 24,
	BPF_PROG_TYPE_CGROUP_SOCKOPT = 25,
	BPF_PROG_TYPE_TRACING = 26,
	BPF_PROG_TYPE_STRUCT_OPS = 27,
	BPF_PROG_TYPE_EXT = 28,
	BPF_PROG_TYPE_LSM = 29,
	BPF_PROG_TYPE_SK_LOOKUP = 30,
	BPF_PROG_TYPE_SYSCALL = 31,
	BPF_PROG_TYPE_NETFILTER = 32,
};

enum bpf_attach_type {
	BPF_CGROUP_INET_INGRESS = 0,
	BPF_CGROUP_INET_EGRESS = 1,
	BPF_CGROUP_INET_SOCK_CREATE = 2,
	BPF_CGROUP_SOCK_OPS = 3,
	BPF_SK_SKB_STREAM_PARSER = 4,
	BPF_SK_SKB_STREAM_VERDICT = 5,
	BPF_CGROUP_DEVICE = 6,
	BPF_SK_MSG_VERDICT = 7,
	BPF_CGROUP_INET4_BIND = 8,
	BPF_CGROUP_INET6_BIND = 9,
	BPF_CGROUP_INET4_CONNECT = 10,
	BPF_CGROUP_INET6_CONNECT = 11,
	BPF_CGROUP_INET4_POST_BIND = 12,
	BPF_CGROUP_INET6_POST_BIND = 13,
	BPF_CGROUP_UDP4_SENDMSG = 14,
	BPF_CGROUP_UDP6_SENDMSG = 15,
	BPF_LIRC_MODE2 = 16,
	BPF_FLOW_DISSECTOR = 17,
	BPF_CGROUP_SYSCTL = 18,
	BPF_CGROUP_UDP4_RECVMSG = 19,
	BPF_CGROUP_UDP6_RECVMSG = 20,
	BPF_CGROUP_GETSOCKOPT = 21,
	BPF_CGROUP_SETSOCKOPT = 22,
	BPF_TRACE_RAW_TP = 23,
	BPF_TRACE_FENTRY = 24,
	BPF_TRACE_FEXIT = 25,
	BPF_MODIFY_RETURN = 26,
	BPF_LSM_MAC = 27,
	BPF_TRACE_ITER = 28,
	BPF_CGROUP_INET4_GETPEERNAME = 29,
	BPF_CGROUP_INET6_GETPEERNAME = 30,
	BPF_CGROUP_INET4_GETSOCKNAME = 31,
	BPF_CGROUP_INET6_GETSOCKNAME = 32,
	BPF_XDP_DEVMAP = 33,
	BPF_CGROUP_INET_SOCK_RELEASE = 34,
	BPF_XDP_CPUMAP = 35,
	BPF_SK_LOOKUP = 36,
	BPF_XDP = 37,
	BPF_SK_SKB_VERDICT = 38,
	BPF_SK_REUSEPORT_SELECT = 39,
	BPF_SK_REUSEPORT_SELECT_OR_MIGRATE = 40,
	BPF_PERF_EVENT = 41,
	BPF_TRACE_KPROBE_MULTI = 42,
	BPF_LSM_CGROUP = 43,
	BPF_STRUCT_OPS = 44,
	BPF_NETFILTER = 45,
	BPF_TCX_INGRESS = 46,
	BPF_TCX_EGRESS = 47,
	BPF_TRACE_UPROBE_MULTI = 48,
	__MAX_BPF_ATTACH_TYPE = 49,
};

enum bpf_link_type {
	BPF_LINK_TYPE_UNSPEC = 0,
	BPF_LINK_TYPE_RAW_TRACEPOINT = 1,
	BPF_LINK_TYPE_TRACING = 2,
	BPF_LINK_TYPE_CGROUP = 3,
	BPF_LINK_TYPE_ITER = 4,
	BPF_LINK_TYPE_NETNS = 5,
	BPF_LINK_TYPE_XDP = 6,
	BPF_LINK_TYPE_PERF_EVENT = 7,
	BPF_LINK_TYPE_KPROBE_MULTI = 8,
	BPF_LINK_TYPE_STRUCT_OPS = 9,
	BPF_LINK_TYPE_NETFILTER = 10,
	BPF_LINK_TYPE_TCX = 11,
	BPF_LINK_TYPE_UPROBE_MULTI = 12,
	MAX_BPF_LINK_TYPE = 13,
};

enum bpf_perf_event_type {
	BPF_PERF_EVENT_UNSPEC = 0,
	BPF_PERF_EVENT_UPROBE = 1,
	BPF_PERF_EVENT_URETPROBE = 2,
	BPF_PERF_EVENT_KPROBE = 3,
	BPF_PERF_EVENT_KRETPROBE = 4,
	BPF_PERF_EVENT_TRACEPOINT = 5,
	BPF_PERF_EVENT_EVENT = 6,
};

enum {
	BPF_ANY = 0,
	BPF_NOEXIST = 1,
	BPF_EXIST = 2,
	BPF_F_LOCK = 4,
};

enum {
	BPF_F_NO_PREALLOC = 1,
	BPF_F_NO_COMMON_LRU = 2,
	BPF_F_NUMA_NODE = 4,
	BPF_F_RDONLY = 8,
	BPF_F_WRONLY = 16,
	BPF_F_STACK_BUILD_ID = 32,
	BPF_F_ZERO_SEED = 64,
	BPF_F_RDONLY_PROG = 128,
	BPF_F_WRONLY_PROG = 256,
	BPF_F_CLONE = 512,
	BPF_F_MMAPABLE = 1024,
	BPF_F_PRESERVE_ELEMS = 2048,
	BPF_F_INNER_MAP = 4096,
	BPF_F_LINK = 8192,
	BPF_F_PATH_FD = 16384,
};

enum bpf_stats_type {
	BPF_STATS_RUN_TIME = 0,
};

union bpf_attr {
	struct {
		__u32 map_type;
		__u32 key_size;
		__u32 value_size;
		__u32 max_entries;
		__u32 map_flags;
		__u32 inner_map_fd;
		__u32 numa_node;
		char map_name[16];
		__u32 map_ifindex;
		__u32 btf_fd;
		__u32 btf_key_type_id;
		__u32 btf_value_type_id;
		__u32 btf_vmlinux_value_type_id;
		__u64 map_extra;
	};
	struct {
		__u32 map_fd;
		__u64 key;
		union {
			__u64 value;
			__u64 next_key;
		};
		__u64 flags;
	};
	struct {
		__u64 in_batch;
		__u64 out_batch;
		__u64 keys;
		__u64 values;
		__u32 count;
		__u32 map_fd;
		__u64 elem_flags;
		__u64 flags;
	} batch;
	struct {
		__u32 prog_type;
		__u32 insn_cnt;
		__u64 insns;
		__u64 license;
		__u32 log_level;
		__u32 log_size;
		__u64 log_buf;
		__u32 kern_version;
		__u32 prog_flags;
		char prog_name[16];
		__u32 prog_ifindex;
		__u32 expected_attach_type;
		__u32 prog_btf_fd;
		__u32 func_info_rec_size;
		__u64 func_info;
		__u32 func_info_cnt;
		__u32 line_info_rec_size;
		__u64 line_info;
		__u32 line_info_cnt;
		__u32 attach_btf_id;
		union {
			__u32 attach_prog_fd;
			__u32 attach_btf_obj_fd;
		};
		__u32 core_relo_cnt;
		__u64 fd_array;
		__u64 core_relos;
		__u32 core_relo_rec_size;
		__u32 log_true_size;
	};
	struct {
		__u64 pathname;
		__u32 bpf_fd;
		__u32 file_flags;
		__s32 path_fd;
	};
	struct {
		union {
			__u32 target_fd;
			__u32 target_ifindex;
		};
		__u32 attach_bpf_fd;
		__u32 attach_type;
		__u32 attach_flags;
		__u32 replace_bpf_fd;
		union {
			__u32 relative_fd;
			__u32 relative_id;
		};
		__u64 expected_revision;
	};
	struct {
		__u32 prog_fd;
		__u32 retval;
		__u32 data_size_in;
		__u32 data_size_out;
		__u64 data_in;
		__u64 data_out;
		__u32 repeat;
		__u32 duration;
		__u32 ctx_size_in;
		__u32 ctx_size_out;
		__u64 ctx_in;
		__u64 ctx_out;
		__u32 flags;
		__u32 cpu;
		__u32 batch_size;
	} test;
	struct {
		union {
			__u32 start_id;
			__u32 prog_id;
			__u32 map_id;
			__u32 btf_id;
			__u32 link_id;
		};
		__u32 next_id;
		__u32 open_flags;
	};
	struct {
		__u32 bpf_fd;
		__u32 info_len;
		__u64 info;
	} info;
	struct {
		union {
			__u32 target_fd;
			__u32 target_ifindex;
		};
		__u32 attach_type;
		__u32 query_flags;
		__u32 attach_flags;
		__u64 prog_ids;
		union {
			__u32 prog_cnt;
			__u32 count;
		};
		__u64 prog_attach_flags;
		__u64 link_ids;
		__u64 link_attach_flags;
		__u64 revision;
	} query;
	struct {
		__u64 name;
		__u32 prog_fd;
	} raw_tracepoint;
	struct {
		__u64 btf;
		__u64 btf_log_buf;
		__u32 btf_size;
		__u32 btf_log_size;
		__u32 btf_log_level;
		__u32 btf_log_true_size;
	};
	struct {
		__u32 pid;
		__u32 fd;
		__u32 flags;
		__u32 buf_len;
		__u64 buf;
		__u32 prog_id;
		__u32 fd_type;
		__u64 probe_offset;
		__u64 probe_addr;
	} task_fd_query;
	struct {
		union {
			__u32 prog_fd;
			__u32 map_fd;
		};
		union {
			__u32 target_fd;
			__u32 target_ifindex;
		};
		__u32 attach_type;
		__u32 flags;
		union {
			__u32 target_btf_id;
			struct {
				__u64 iter_info;
				__u32 iter_info_len;
			};
			struct {
				__u64 bpf_cookie;
			} perf_event;
			struct {
				__u32 flags;
				__u32 cnt;
				__u64 syms;
				__u64 addrs;
				__u64 cookies;
			} kprobe_multi;
			struct {
				__u32 target_btf_id;
				__u64 cookie;
			} tracing;
			struct {
				__u32 pf;
				__u32 hooknum;
				__s32 priority;
				__u32 flags;
			} netfilter;
			struct {
				union {
					__u32 relative_fd;
					__u32 relative_id;
				};
				__u64 expected_revision;
			} tcx;
			struct {
				__u64 path;
				__u64 offsets;
				__u64 ref_ctr_offsets;
				__u64 cookies;
				__u32 cnt;
				__u32 flags;
				__u32 pid;
			} uprobe_multi;
		};
	} link_create;
	struct {
		__u32 link_fd;
		union {
			__u32 new_prog_fd;
			__u32 new_map_fd;
		};
		__u32 flags;
		union {
			__u32 old_prog_fd;
			__u32 old_map_fd;
		};
	} link_update;
	struct {
		__u32 link_fd;
	} link_detach;
	struct {
		__u32 type;
	} enable_stats;
	struct {
		__u32 link_fd;
		__u32 flags;
	} iter_create;
	struct {
		__u32 prog_fd;
		__u32 map_fd;
		__u32 flags;
	} prog_bind_map;
};

enum bpf_func_id {
	BPF_FUNC_unspec = 0,
	BPF_FUNC_map_lookup_elem = 1,
	BPF_FUNC_map_update_elem = 2,
	BPF_FUNC_map_delete_elem = 3,
	BPF_FUNC_probe_read = 4,
	BPF_FUNC_ktime_get_ns = 5,
	BPF_FUNC_trace_printk = 6,
	BPF_FUNC_get_prandom_u32 = 7,
	BPF_FUNC_get_smp_processor_id = 8,
	BPF_FUNC_skb_store_bytes = 9,
	BPF_FUNC_l3_csum_replace = 10,
	BPF_FUNC_l4_csum_replace = 11,
	BPF_FUNC_tail_call = 12,
	BPF_FUNC_clone_redirect = 13,
	BPF_FUNC_get_current_pid_tgid = 14,
	BPF_FUNC_get_current_uid_gid = 15,
	BPF_FUNC_get_current_comm = 16,
	BPF_FUNC_get_cgroup_classid = 17,
	BPF_FUNC_skb_vlan_push = 18,
	BPF_FUNC_skb_vlan_pop = 19,
	BPF_FUNC_skb_get_tunnel_key = 20,
	BPF_FUNC_skb_set_tunnel_key = 21,
	BPF_FUNC_perf_event_read = 22,
	BPF_FUNC_redirect = 23,
	BPF_FUNC_get_route_realm = 24,
	BPF_FUNC_perf_event_output = 25,
	BPF_FUNC_skb_load_bytes = 26,
	BPF_FUNC_get_stackid = 27,
	BPF_FUNC_csum_diff = 28,
	BPF_FUNC_skb_get_tunnel_opt = 29,
	BPF_FUNC_skb_set_tunnel_opt = 30,
	BPF_FUNC_skb_change_proto = 31,
	BPF_FUNC_skb_change_type = 32,
	BPF_FUNC_skb_under_cgroup = 33,
	BPF_FUNC_get_hash_recalc = 34,
	BPF_FUNC_get_current_task = 35,
	BPF_FUNC_probe_write_user = 36,
	BPF_FUNC_current_task_under_cgroup = 37,
	BPF_FUNC_skb_change_tail = 38,
	BPF_FUNC_skb_pull_data = 39,
	BPF_FUNC_csum_update = 40,
	BPF_FUNC_set_hash_invalid = 41,
	BPF_FUNC_get_numa_node_id = 42,
	BPF_FUNC_skb_change_head = 43,
	BPF_FUNC_xdp_adjust_head = 44,
	BPF_FUNC_probe_read_str = 45,
	BPF_FUNC_get_socket_cookie = 46,
	BPF_FUNC_get_socket_uid = 47,
	BPF_FUNC_set_hash = 48,
	BPF_FUNC_setsockopt = 49,
	BPF_FUNC_skb_adjust_room = 50,
	BPF_FUNC_redirect_map = 51,
	BPF_FUNC_sk_redirect_map = 52,
	BPF_FUNC_sock_map_update = 53,
	BPF_FUNC_xdp_adjust_meta = 54,
	BPF_FUNC_perf_event_read_value = 55,
	BPF_FUNC_perf_prog_read_value = 56,
	BPF_FUNC_getsockopt = 57,
	BPF_FUNC_override_return = 58,
	BPF_FUNC_sock_ops_cb_flags_set = 59,
	BPF_FUNC_msg_redirect_map = 60,
	BPF_FUNC_msg_apply_bytes = 61,
	BPF_FUNC_msg_cork_bytes = 62,
	BPF_FUNC_msg_pull_data = 63,
	BPF_FUNC_bind = 64,
	BPF_FUNC_xdp_adjust_tail = 65,
	BPF_FUNC_skb_get_xfrm_state = 66,
	BPF_FUNC_get_stack = 67,
	BPF_FUNC_skb_load_bytes_relative = 68,
	BPF_FUNC_fib_lookup = 69,
	BPF_FUNC_sock_hash_update = 70,
	BPF_FUNC_msg_redirect_hash = 71,
	BPF_FUNC_sk_redirect_hash = 72,
	BPF_FUNC_lwt_push_encap = 73,
	BPF_FUNC_lwt_seg6_store_bytes = 74,
	BPF_FUNC_lwt_seg6_adjust_srh = 75,
	BPF_FUNC_lwt_seg6_action = 76,
	BPF_FUNC_rc_repeat = 77,
	BPF_FUNC_rc_keydown = 78,
	BPF_FUNC_skb_cgroup_id = 79,
	BPF_FUNC_get_current_cgroup_id = 80,
	BPF_FUNC_get_local_storage = 81,
	BPF_FUNC_sk_select_reuseport = 82,
	BPF_FUNC_skb_ancestor_cgroup_id = 83,
	BPF_FUNC_sk_lookup_tcp = 84,
	BPF_FUNC_sk_lookup_udp = 85,
	BPF_FUNC_sk_release = 86,
	BPF_FUNC_map_push_elem = 87,
	BPF_FUNC_map_pop_elem = 88,
	BPF_FUNC_map_peek_elem = 89,
	BPF_FUNC_msg_push_data = 90,
	BPF_FUNC_msg_pop_data = 91,
	BPF_FUNC_rc_pointer_rel = 92,
	BPF_FUNC_spin_lock = 93,
	BPF_FUNC_spin_unlock = 94,
	BPF_FUNC_sk_fullsock = 95,
	BPF_FUNC_tcp_sock = 96,
	BPF_FUNC_skb_ecn_set_ce = 97,
	BPF_FUNC_get_listener_sock = 98,
	BPF_FUNC_skc_lookup_tcp = 99,
	BPF_FUNC_tcp_check_syncookie = 100,
	BPF_FUNC_sysctl_get_name = 101,
	BPF_FUNC_sysctl_get_current_value = 102,
	BPF_FUNC_sysctl_get_new_value = 103,
	BPF_FUNC_sysctl_set_new_value = 104,
	BPF_FUNC_strtol = 105,
	BPF_FUNC_strtoul = 106,
	BPF_FUNC_sk_storage_get = 107,
	BPF_FUNC_sk_storage_delete = 108,
	BPF_FUNC_send_signal = 109,
	BPF_FUNC_tcp_gen_syncookie = 110,
	BPF_FUNC_skb_output = 111,
	BPF_FUNC_probe_read_user = 112,
	BPF_FUNC_probe_read_kernel = 113,
	BPF_FUNC_probe_read_user_str = 114,
	BPF_FUNC_probe_read_kernel_str = 115,
	BPF_FUNC_tcp_send_ack = 116,
	BPF_FUNC_send_signal_thread = 117,
	BPF_FUNC_jiffies64 = 118,
	BPF_FUNC_read_branch_records = 119,
	BPF_FUNC_get_ns_current_pid_tgid = 120,
	BPF_FUNC_xdp_output = 121,
	BPF_FUNC_get_netns_cookie = 122,
	BPF_FUNC_get_current_ancestor_cgroup_id = 123,
	BPF_FUNC_sk_assign = 124,
	BPF_FUNC_ktime_get_boot_ns = 125,
	BPF_FUNC_seq_printf = 126,
	BPF_FUNC_seq_write = 127,
	BPF_FUNC_sk_cgroup_id = 128,
	BPF_FUNC_sk_ancestor_cgroup_id = 129,
	BPF_FUNC_ringbuf_output = 130,
	BPF_FUNC_ringbuf_reserve = 131,
	BPF_FUNC_ringbuf_submit = 132,
	BPF_FUNC_ringbuf_discard = 133,
	BPF_FUNC_ringbuf_query = 134,
	BPF_FUNC_csum_level = 135,
	BPF_FUNC_skc_to_tcp6_sock = 136,
	BPF_FUNC_skc_to_tcp_sock = 137,
	BPF_FUNC_skc_to_tcp_timewait_sock = 138,
	BPF_FUNC_skc_to_tcp_request_sock = 139,
	BPF_FUNC_skc_to_udp6_sock = 140,
	BPF_FUNC_get_task_stack = 141,
	BPF_FUNC_load_hdr_opt = 142,
	BPF_FUNC_store_hdr_opt = 143,
	BPF_FUNC_reserve_hdr_opt = 144,
	BPF_FUNC_inode_storage_get = 145,
	BPF_FUNC_inode_storage_delete = 146,
	BPF_FUNC_d_path = 147,
	BPF_FUNC_copy_from_user = 148,
	BPF_FUNC_snprintf_btf = 149,
	BPF_FUNC_seq_printf_btf = 150,
	BPF_FUNC_skb_cgroup_classid = 151,
	BPF_FUNC_redirect_neigh = 152,
	BPF_FUNC_per_cpu_ptr = 153,
	BPF_FUNC_this_cpu_ptr = 154,
	BPF_FUNC_redirect_peer = 155,
	BPF_FUNC_task_storage_get = 156,
	BPF_FUNC_task_storage_delete = 157,
	BPF_FUNC_get_current_task_btf = 158,
	BPF_FUNC_bprm_opts_set = 159,
	BPF_FUNC_ktime_get_coarse_ns = 160,
	BPF_FUNC_ima_inode_hash = 161,
	BPF_FUNC_sock_from_file = 162,
	BPF_FUNC_check_mtu = 163,
	BPF_FUNC_for_each_map_elem = 164,
	BPF_FUNC_snprintf = 165,
	BPF_FUNC_sys_bpf = 166,
	BPF_FUNC_btf_find_by_name_kind = 167,
	BPF_FUNC_sys_close = 168,
	BPF_FUNC_timer_init = 169,
	BPF_FUNC_timer_set_callback = 170,
	BPF_FUNC_timer_start = 171,
	BPF_FUNC_timer_cancel = 172,
	BPF_FUNC_get_func_ip = 173,
	BPF_FUNC_get_attach_cookie = 174,
	BPF_FUNC_task_pt_regs = 175,
	BPF_FUNC_get_branch_snapshot = 176,
	BPF_FUNC_trace_vprintk = 177,
	BPF_FUNC_skc_to_unix_sock = 178,
	BPF_FUNC_kallsyms_lookup_name = 179,
	BPF_FUNC_find_vma = 180,
	BPF_FUNC_loop = 181,
	BPF_FUNC_strncmp = 182,
	BPF_FUNC_get_func_arg = 183,
	BPF_FUNC_get_func_ret = 184,
	BPF_FUNC_get_func_arg_cnt = 185,
	BPF_FUNC_get_retval = 186,
	BPF_FUNC_set_retval = 187,
	BPF_FUNC_xdp_get_buff_len = 188,
	BPF_FUNC_xdp_load_bytes = 189,
	BPF_FUNC_xdp_store_bytes = 190,
	BPF_FUNC_copy_from_user_task = 191,
	BPF_FUNC_skb_set_tstamp = 192,
	BPF_FUNC_ima_file_hash = 193,
	BPF_FUNC_kptr_xchg = 194,
	BPF_FUNC_map_lookup_percpu_elem = 195,
	BPF_FUNC_skc_to_mptcp_sock = 196,
	BPF_FUNC_dynptr_from_mem = 197,
	BPF_FUNC_ringbuf_reserve_dynptr = 198,
	BPF_FUNC_ringbuf_submit_dynptr = 199,
	BPF_FUNC_ringbuf_discard_dynptr = 200,
	BPF_FUNC_dynptr_read = 201,
	BPF_FUNC_dynptr_write = 202,
	BPF_FUNC_dynptr_data = 203,
	BPF_FUNC_tcp_raw_gen_syncookie_ipv4 = 204,
	BPF_FUNC_tcp_raw_gen_syncookie_ipv6 = 205,
	BPF_FUNC_tcp_raw_check_syncookie_ipv4 = 206,
	BPF_FUNC_tcp_raw_check_syncookie_ipv6 = 207,
	BPF_FUNC_ktime_get_tai_ns = 208,
	BPF_FUNC_user_ringbuf_drain = 209,
	BPF_FUNC_cgrp_storage_get = 210,
	BPF_FUNC_cgrp_storage_delete = 211,
	__BPF_FUNC_MAX_ID = 212,
};

struct xdp_md {
	__u32 data;
	__u32 data_end;
	__u32 data_meta;
	__u32 ingress_ifindex;
	__u32 rx_queue_index;
	__u32 egress_ifindex;
};

struct bpf_prog_info {
	__u32 type;
	__u32 id;
	__u8 tag[8];
	__u32 jited_prog_len;
	__u32 xlated_prog_len;
	__u64 jited_prog_insns;
	__u64 xlated_prog_insns;
	__u64 load_time;
	__u32 created_by_uid;
	__u32 nr_map_ids;
	__u64 map_ids;
	char name[16];
	__u32 ifindex;
	__u32 gpl_compatible: 1;
	__u64 netns_dev;
	__u64 netns_ino;
	__u32 nr_jited_ksyms;
	__u32 nr_jited_func_lens;
	__u64 jited_ksyms;
	__u64 jited_func_lens;
	__u32 btf_id;
	__u32 func_info_rec_size;
	__u64 func_info;
	__u32 nr_func_info;
	__u32 nr_line_info;
	__u64 line_info;
	__u64 jited_line_info;
	__u32 nr_jited_line_info;
	__u32 line_info_rec_size;
	__u32 jited_line_info_rec_size;
	__u32 nr_prog_tags;
	__u64 prog_tags;
	__u64 run_time_ns;
	__u64 run_cnt;
	__u64 recursion_misses;
	__u32 verified_insns;
	__u32 attach_btf_obj_id;
	__u32 attach_btf_id;
};

struct bpf_map_info {
	__u32 type;
	__u32 id;
	__u32 key_size;
	__u32 value_size;
	__u32 max_entries;
	__u32 map_flags;
	char name[16];
	__u32 ifindex;
	__u32 btf_vmlinux_value_type_id;
	__u64 netns_dev;
	__u64 netns_ino;
	__u32 btf_id;
	__u32 btf_key_type_id;
	__u32 btf_value_type_id;
	__u64 map_extra;
};

struct bpf_btf_info {
	__u64 btf;
	__u32 btf_size;
	__u32 id;
	__u64 name;
	__u32 name_len;
	__u32 kernel_btf;
};

struct bpf_link_info {
	__u32 type;
	__u32 id;
	__u32 prog_id;
	union {
		struct {
			__u64 tp_name;
			__u32 tp_name_len;
		} raw_tracepoint;
		struct {
			__u32 attach_type;
			__u32 target_obj_id;
			__u32 target_btf_id;
		} tracing;
		struct {
			__u64 cgroup_id;
			__u32 attach_type;
		} cgroup;
		struct {
			__u64 target_name;
			__u32 target_name_len;
			union {
				struct {
					__u32 map_id;
				} map;
			};
			union {
				struct {
					__u64 cgroup_id;
					__u32 order;
				} cgroup;
				struct {
					__u32 tid;
					__u32 pid;
				} task;
			};
		} iter;
		struct {
			__u32 netns_ino;
			__u32 attach_type;
		} netns;
		struct {
			__u32 ifindex;
		} xdp;
		struct {
			__u32 map_id;
		} struct_ops;
		struct {
			__u32 pf;
			__u32 hooknum;
			__s32 priority;
			__u32 flags;
		} netfilter;
		struct {
			__u64 addrs;
			__u32 count;
			__u32 flags;
		} kprobe_multi;
		struct {
			__u32 type;
			union {
				struct {
					__u64 file_name;
					__u32 name_len;
					__u32 offset;
				} uprobe;
				struct {
					__u64 func_name;
					__u32 name_len;
					__u32 offset;
					__u64 addr;
				} kprobe;
				struct {
					__u64 tp_name;
					__u32 name_len;
				} tracepoint;
				struct {
					__u64 config;
					__u32 type;
				} event;
			};
		} perf_event;
		struct {
			__u32 ifindex;
			__u32 attach_type;
		} tcx;
	};
};

enum bpf_task_fd_type {
	BPF_FD_TYPE_RAW_TRACEPOINT = 0,
	BPF_FD_TYPE_TRACEPOINT = 1,
	BPF_FD_TYPE_KPROBE = 2,
	BPF_FD_TYPE_KRETPROBE = 3,
	BPF_FD_TYPE_UPROBE = 4,
	BPF_FD_TYPE_URETPROBE = 5,
};

struct bpf_func_info {
	__u32 insn_off;
	__u32 type_id;
};

struct bpf_line_info {
	__u32 insn_off;
	__u32 file_name_off;
	__u32 line_off;
	__u32 line_col;
};

struct bpf_spin_lock {
	__u32 val;
};

struct sock_filter {
	__u16 code;
	__u8 jt;
	__u8 jf;
	__u32 k;
};

enum tk_offsets {
	TK_OFFS_REAL = 0,
	TK_OFFS_BOOT = 1,
	TK_OFFS_TAI = 2,
	TK_OFFS_MAX = 3,
};

struct fd {
	struct file *file;
	unsigned int flags;
};

struct hlist_nulls_node {
	struct hlist_nulls_node *next;
	struct hlist_nulls_node **pprev;
};

typedef struct {} local_lock_t;

struct rhash_lock_head;

struct bucket_table {
	unsigned int size;
	unsigned int nest;
	u32 hash_rnd;
	struct list_head walkers;
	struct callback_head rcu;
	struct bucket_table *future_tbl;
	struct lockdep_map dep_map;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct rhash_lock_head *buckets[0];
};

struct bpf_run_ctx {};

struct xa_node {
	unsigned char shift;
	unsigned char offset;
	unsigned char count;
	unsigned char nr_values;
	struct xa_node *parent;
	struct xarray *array;
	union {
		struct list_head private_list;
		struct callback_head callback_head;
	};
	void *slots[64];
	union {
		long unsigned int tags[3];
		long unsigned int marks[3];
	};
};

struct radix_tree_preload {
	local_lock_t lock;
	unsigned int nr;
	struct xa_node *nodes;
};

typedef __u64 __addrpair;

typedef __u32 __portpair;

typedef struct {
	struct net *net;
} possible_net_t;

struct proto;

struct sock_common {
	union {
		__addrpair skc_addrpair;
		struct {
			__be32 skc_daddr;
			__be32 skc_rcv_saddr;
		};
	};
	union {
		unsigned int skc_hash;
		__u16 skc_u16hashes[2];
	};
	union {
		__portpair skc_portpair;
		struct {
			__be16 skc_dport;
			__u16 skc_num;
		};
	};
	short unsigned int skc_family;
	volatile unsigned char skc_state;
	unsigned char skc_reuse: 4;
	unsigned char skc_reuseport: 1;
	unsigned char skc_ipv6only: 1;
	unsigned char skc_net_refcnt: 1;
	int skc_bound_dev_if;
	union {
		struct hlist_node skc_bind_node;
		struct hlist_node skc_portaddr_node;
	};
	struct proto *skc_prot;
	possible_net_t skc_net;
	struct in6_addr skc_v6_daddr;
	struct in6_addr skc_v6_rcv_saddr;
	atomic64_t skc_cookie;
	union {
		long unsigned int skc_flags;
		struct sock *skc_listener;
		struct inet_timewait_death_row *skc_tw_dr;
	};
	int skc_dontcopy_begin[0];
	union {
		struct hlist_node skc_node;
		struct hlist_nulls_node skc_nulls_node;
	};
	short unsigned int skc_tx_queue_mapping;
	short unsigned int skc_rx_queue_mapping;
	union {
		int skc_incoming_cpu;
		u32 skc_rcv_wnd;
		u32 skc_tw_rcv_nxt;
	};
	refcount_t skc_refcnt;
	int skc_dontcopy_end[0];
	union {
		u32 skc_rxhash;
		u32 skc_window_clamp;
		u32 skc_tw_snd_nxt;
	};
};

typedef struct {
	spinlock_t slock;
	int owned;
	wait_queue_head_t wq;
} socket_lock_t;

struct sk_buff_list {
	struct sk_buff *next;
	struct sk_buff *prev;
};

struct sk_buff_head {
	union {
		struct {
			struct sk_buff *next;
			struct sk_buff *prev;
		};
		struct sk_buff_list list;
	};
	__u32 qlen;
	spinlock_t lock;
};

typedef u64 netdev_features_t;

struct sock_cgroup_data {
	struct cgroup *cgroup;
};

typedef struct {} netns_tracker;

struct sk_filter;

struct socket_wq;

struct xfrm_policy;

struct socket;

struct sock_reuseport;

struct sock {
	struct sock_common __sk_common;
	struct dst_entry *sk_rx_dst;
	int sk_rx_dst_ifindex;
	u32 sk_rx_dst_cookie;
	socket_lock_t sk_lock;
	atomic_t sk_drops;
	int sk_rcvlowat;
	struct sk_buff_head sk_error_queue;
	struct sk_buff_head sk_receive_queue;
	struct {
		atomic_t rmem_alloc;
		int len;
		struct sk_buff *head;
		struct sk_buff *tail;
	} sk_backlog;
	int sk_forward_alloc;
	u32 sk_reserved_mem;
	unsigned int sk_ll_usec;
	unsigned int sk_napi_id;
	int sk_rcvbuf;
	int sk_disconnects;
	struct sk_filter *sk_filter;
	union {
		struct socket_wq *sk_wq;
		struct socket_wq *sk_wq_raw;
	};
	struct xfrm_policy *sk_policy[2];
	struct dst_entry *sk_dst_cache;
	atomic_t sk_omem_alloc;
	int sk_sndbuf;
	int sk_wmem_queued;
	refcount_t sk_wmem_alloc;
	long unsigned int sk_tsq_flags;
	union {
		struct sk_buff *sk_send_head;
		struct rb_root tcp_rtx_queue;
	};
	struct sk_buff_head sk_write_queue;
	__s32 sk_peek_off;
	int sk_write_pending;
	__u32 sk_dst_pending_confirm;
	u32 sk_pacing_status;
	long int sk_sndtimeo;
	struct timer_list sk_timer;
	__u32 sk_priority;
	__u32 sk_mark;
	long unsigned int sk_pacing_rate;
	long unsigned int sk_max_pacing_rate;
	struct page_frag sk_frag;
	netdev_features_t sk_route_caps;
	int sk_gso_type;
	unsigned int sk_gso_max_size;
	gfp_t sk_allocation;
	__u32 sk_txhash;
	u8 sk_gso_disabled: 1;
	u8 sk_kern_sock: 1;
	u8 sk_no_check_tx: 1;
	u8 sk_no_check_rx: 1;
	u8 sk_userlocks: 4;
	u8 sk_pacing_shift;
	u16 sk_type;
	u16 sk_protocol;
	u16 sk_gso_max_segs;
	long unsigned int sk_lingertime;
	struct proto *sk_prot_creator;
	rwlock_t sk_callback_lock;
	int sk_err;
	int sk_err_soft;
	u32 sk_ack_backlog;
	u32 sk_max_ack_backlog;
	kuid_t sk_uid;
	u8 sk_txrehash;
	u8 sk_prefer_busy_poll;
	u16 sk_busy_poll_budget;
	spinlock_t sk_peer_lock;
	int sk_bind_phc;
	struct pid *sk_peer_pid;
	const struct cred *sk_peer_cred;
	long int sk_rcvtimeo;
	ktime_t sk_stamp;
	atomic_t sk_tskey;
	atomic_t sk_zckey;
	u32 sk_tsflags;
	u8 sk_shutdown;
	u8 sk_clockid;
	u8 sk_txtime_deadline_mode: 1;
	u8 sk_txtime_report_errors: 1;
	u8 sk_txtime_unused: 6;
	bool sk_use_task_frag;
	struct socket *sk_socket;
	void *sk_user_data;
	void *sk_security;
	struct sock_cgroup_data sk_cgrp_data;
	struct mem_cgroup *sk_memcg;
	void (*sk_state_change)(struct sock *);
	void (*sk_data_ready)(struct sock *);
	void (*sk_write_space)(struct sock *);
	void (*sk_error_report)(struct sock *);
	int (*sk_backlog_rcv)(struct sock *, struct sk_buff *);
	void (*sk_destruct)(struct sock *);
	struct sock_reuseport *sk_reuseport_cb;
	struct bpf_local_storage *sk_bpf_storage;
	struct callback_head sk_rcu;
	netns_tracker ns_tracker;
	struct hlist_node sk_bind2_node;
};

enum {
	__PERCPU_REF_ATOMIC = 1,
	__PERCPU_REF_DEAD = 2,
	__PERCPU_REF_ATOMIC_DEAD = 3,
	__PERCPU_REF_FLAG_BITS = 2,
};

typedef struct {
	union {
		void *kernel;
		void *user;
	};
	bool is_kernel: 1;
} sockptr_t;

typedef sockptr_t bpfptr_t;

struct btf_type {
	__u32 name_off;
	__u32 info;
	union {
		__u32 size;
		__u32 type;
	};
};

struct bpf_prog_stats;

struct bpf_prog_aux;

struct sock_fprog_kern;

struct bpf_prog {
	u16 pages;
	u16 jited: 1;
	u16 jit_requested: 1;
	u16 gpl_compatible: 1;
	u16 cb_access: 1;
	u16 dst_needed: 1;
	u16 blinding_requested: 1;
	u16 blinded: 1;
	u16 is_func: 1;
	u16 kprobe_override: 1;
	u16 has_callchain_buf: 1;
	u16 enforce_expected_attach_type: 1;
	u16 call_get_stack: 1;
	u16 call_get_func_ip: 1;
	u16 tstamp_type_access: 1;
	enum bpf_prog_type type;
	enum bpf_attach_type expected_attach_type;
	u32 len;
	u32 jited_len;
	u8 tag[8];
	struct bpf_prog_stats *stats;
	int *active;
	unsigned int (*bpf_func)(const void *, const struct bpf_insn *);
	struct bpf_prog_aux *aux;
	struct sock_fprog_kern *orig_prog;
	union {
		struct {
			struct {} __empty_insns;
			struct sock_filter insns[0];
		};
		struct {
			struct {} __empty_insnsi;
			struct bpf_insn insnsi[0];
		};
	};
};

struct btf_record;

struct btf_struct_meta {
	u32 btf_id;
	struct btf_record *record;
};

enum btf_field_type {
	BPF_SPIN_LOCK = 1,
	BPF_TIMER = 2,
	BPF_KPTR_UNREF = 4,
	BPF_KPTR_REF = 8,
	BPF_KPTR = 12,
	BPF_LIST_HEAD = 16,
	BPF_LIST_NODE = 32,
	BPF_RB_ROOT = 64,
	BPF_RB_NODE = 128,
	BPF_GRAPH_NODE_OR_ROOT = 240,
	BPF_REFCOUNT = 256,
};

typedef void (*btf_dtor_kfunc_t)(void *);

struct btf;

struct btf_field_kptr {
	struct btf *btf;
	struct module *module;
	btf_dtor_kfunc_t dtor;
	u32 btf_id;
};

struct btf_field_graph_root {
	struct btf *btf;
	u32 value_btf_id;
	u32 node_offset;
	struct btf_record *value_rec;
};

struct btf_field {
	u32 offset;
	u32 size;
	enum btf_field_type type;
	union {
		struct btf_field_kptr kptr;
		struct btf_field_graph_root graph_root;
	};
};

struct btf_record {
	u32 cnt;
	u32 field_mask;
	int spin_lock_off;
	int timer_off;
	int refcount_off;
	struct btf_field fields[0];
};

typedef struct {
	local64_t v;
} u64_stats_t;

struct bpf_cgroup_storage;

struct bpf_prog_array_item {
	struct bpf_prog *prog;
	union {
		struct bpf_cgroup_storage *cgroup_storage[2];
		u64 bpf_cookie;
	};
};

struct bpf_prog_array {
	struct callback_head rcu;
	struct bpf_prog_array_item items[0];
};

enum {
	CSS_NO_REF = 1,
	CSS_ONLINE = 2,
	CSS_RELEASED = 4,
	CSS_VISIBLE = 8,
	CSS_DYING = 16,
};

typedef u64 (*bpf_callback_t)(u64, u64, u64, u64, u64);

struct bpf_iter_aux_info;

typedef int (*bpf_iter_init_seq_priv_t)(void *, struct bpf_iter_aux_info *);

enum bpf_iter_task_type {
	BPF_TASK_ITER_ALL = 0,
	BPF_TASK_ITER_TID = 1,
	BPF_TASK_ITER_TGID = 2,
};

struct bpf_map;

struct bpf_iter_aux_info {
	struct bpf_map *map;
	struct {
		struct cgroup *start;
		enum bpf_cgroup_iter_order order;
	} cgroup;
	struct {
		enum bpf_iter_task_type type;
		u32 pid;
	} task;
};

typedef void (*bpf_iter_fini_seq_priv_t)(void *);

typedef unsigned int (*bpf_func_t)(const void *, const struct bpf_insn *);

struct bpf_iter_seq_info {
	const struct seq_operations *seq_ops;
	bpf_iter_init_seq_priv_t init_seq_private;
	bpf_iter_fini_seq_priv_t fini_seq_private;
	u32 seq_priv_size;
};

struct bpf_local_storage_map;

struct bpf_verifier_env;

struct bpf_func_state;

struct bpf_map_ops {
	int (*map_alloc_check)(union bpf_attr *);
	struct bpf_map * (*map_alloc)(union bpf_attr *);
	void (*map_release)(struct bpf_map *, struct file *);
	void (*map_free)(struct bpf_map *);
	int (*map_get_next_key)(struct bpf_map *, void *, void *);
	void (*map_release_uref)(struct bpf_map *);
	void * (*map_lookup_elem_sys_only)(struct bpf_map *, void *);
	int (*map_lookup_batch)(struct bpf_map *, const union bpf_attr *, union bpf_attr *);
	int (*map_lookup_and_delete_elem)(struct bpf_map *, void *, void *, u64);
	int (*map_lookup_and_delete_batch)(struct bpf_map *, const union bpf_attr *, union bpf_attr *);
	int (*map_update_batch)(struct bpf_map *, struct file *, const union bpf_attr *, union bpf_attr *);
	int (*map_delete_batch)(struct bpf_map *, const union bpf_attr *, union bpf_attr *);
	void * (*map_lookup_elem)(struct bpf_map *, void *);
	long int (*map_update_elem)(struct bpf_map *, void *, void *, u64);
	long int (*map_delete_elem)(struct bpf_map *, void *);
	long int (*map_push_elem)(struct bpf_map *, void *, u64);
	long int (*map_pop_elem)(struct bpf_map *, void *);
	long int (*map_peek_elem)(struct bpf_map *, void *);
	void * (*map_lookup_percpu_elem)(struct bpf_map *, void *, u32);
	void * (*map_fd_get_ptr)(struct bpf_map *, struct file *, int);
	void (*map_fd_put_ptr)(void *);
	int (*map_gen_lookup)(struct bpf_map *, struct bpf_insn *);
	u32 (*map_fd_sys_lookup_elem)(void *);
	void (*map_seq_show_elem)(struct bpf_map *, void *, struct seq_file *);
	int (*map_check_btf)(const struct bpf_map *, const struct btf *, const struct btf_type *, const struct btf_type *);
	int (*map_poke_track)(struct bpf_map *, struct bpf_prog_aux *);
	void (*map_poke_untrack)(struct bpf_map *, struct bpf_prog_aux *);
	void (*map_poke_run)(struct bpf_map *, u32, struct bpf_prog *, struct bpf_prog *);
	int (*map_direct_value_addr)(const struct bpf_map *, u64 *, u32);
	int (*map_direct_value_meta)(const struct bpf_map *, u64, u32 *);
	int (*map_mmap)(struct bpf_map *, struct vm_area_struct *);
	__poll_t (*map_poll)(struct bpf_map *, struct file *, struct poll_table_struct *);
	int (*map_local_storage_charge)(struct bpf_local_storage_map *, void *, u32);
	void (*map_local_storage_uncharge)(struct bpf_local_storage_map *, void *, u32);
	struct bpf_local_storage ** (*map_owner_storage_ptr)(void *);
	long int (*map_redirect)(struct bpf_map *, u64, u64);
	bool (*map_meta_equal)(const struct bpf_map *, const struct bpf_map *);
	int (*map_set_for_each_callback_args)(struct bpf_verifier_env *, struct bpf_func_state *, struct bpf_func_state *);
	long int (*map_for_each_callback)(struct bpf_map *, bpf_callback_t, void *, u64);
	u64 (*map_mem_usage)(const struct bpf_map *);
	int *map_btf_id;
	const struct bpf_iter_seq_info *iter_seq_info;
};

struct bpf_map {
	const struct bpf_map_ops *ops;
	struct bpf_map *inner_map_meta;
	void *security;
	enum bpf_map_type map_type;
	u32 key_size;
	u32 value_size;
	u32 max_entries;
	u64 map_extra;
	u32 map_flags;
	u32 id;
	struct btf_record *record;
	int numa_node;
	u32 btf_key_type_id;
	u32 btf_value_type_id;
	u32 btf_vmlinux_value_type_id;
	struct btf *btf;
	struct obj_cgroup *objcg;
	char name[16];
	long: 64;
	long: 64;
	atomic64_t refcnt;
	atomic64_t usercnt;
	struct work_struct work;
	struct mutex freeze_mutex;
	atomic64_t writecnt;
	struct {
		spinlock_t lock;
		enum bpf_prog_type type;
		bool jited;
		bool xdp_has_frags;
	} owner;
	bool bypass_spec_v1;
	bool frozen;
	s64 *elem_count;
	long: 64;
};

struct btf_header {
	__u16 magic;
	__u8 version;
	__u8 flags;
	__u32 hdr_len;
	__u32 type_off;
	__u32 type_len;
	__u32 str_off;
	__u32 str_len;
};

struct btf_kfunc_set_tab;

struct btf_id_dtor_kfunc_tab;

struct btf_struct_metas;

struct btf {
	void *data;
	struct btf_type **types;
	u32 *resolved_ids;
	u32 *resolved_sizes;
	const char *strings;
	void *nohdr_data;
	struct btf_header hdr;
	u32 nr_types;
	u32 types_size;
	u32 data_size;
	refcount_t refcnt;
	u32 id;
	struct callback_head rcu;
	struct btf_kfunc_set_tab *kfunc_set_tab;
	struct btf_id_dtor_kfunc_tab *dtor_kfunc_tab;
	struct btf_struct_metas *struct_meta_tab;
	struct btf *base_btf;
	u32 start_id;
	u32 start_str_off;
	char name[56];
	bool kernel_btf;
};

struct bpf_ksym {
	long unsigned int start;
	long unsigned int end;
	char name[512];
	struct list_head lnode;
	struct latch_tree_node tnode;
	bool prog;
};

struct bpf_ctx_arg_aux;

struct bpf_trampoline;

struct bpf_jit_poke_descriptor;

struct bpf_kfunc_desc_tab;

struct bpf_kfunc_btf_tab;

struct bpf_prog_ops;

struct btf_mod_pair;

struct bpf_prog_offload;

struct bpf_func_info_aux;

struct bpf_prog_aux {
	atomic64_t refcnt;
	u32 used_map_cnt;
	u32 used_btf_cnt;
	u32 max_ctx_offset;
	u32 max_pkt_offset;
	u32 max_tp_access;
	u32 stack_depth;
	u32 id;
	u32 func_cnt;
	u32 func_idx;
	u32 attach_btf_id;
	u32 ctx_arg_info_size;
	u32 max_rdonly_access;
	u32 max_rdwr_access;
	struct btf *attach_btf;
	const struct bpf_ctx_arg_aux *ctx_arg_info;
	struct mutex dst_mutex;
	struct bpf_prog *dst_prog;
	struct bpf_trampoline *dst_trampoline;
	enum bpf_prog_type saved_dst_prog_type;
	enum bpf_attach_type saved_dst_attach_type;
	bool verifier_zext;
	bool dev_bound;
	bool offload_requested;
	bool attach_btf_trace;
	bool func_proto_unreliable;
	bool sleepable;
	bool tail_call_reachable;
	bool xdp_has_frags;
	const struct btf_type *attach_func_proto;
	const char *attach_func_name;
	struct bpf_prog **func;
	void *jit_data;
	struct bpf_jit_poke_descriptor *poke_tab;
	struct bpf_kfunc_desc_tab *kfunc_tab;
	struct bpf_kfunc_btf_tab *kfunc_btf_tab;
	u32 size_poke_tab;
	struct bpf_ksym ksym;
	const struct bpf_prog_ops *ops;
	struct bpf_map **used_maps;
	struct mutex used_maps_mutex;
	struct btf_mod_pair *used_btfs;
	struct bpf_prog *prog;
	struct user_struct *user;
	u64 load_time;
	u32 verified_insns;
	int cgroup_atype;
	struct bpf_map *cgroup_storage[2];
	char name[16];
	void *security;
	struct bpf_prog_offload *offload;
	struct btf *btf;
	struct bpf_func_info *func_info;
	struct bpf_func_info_aux *func_info_aux;
	struct bpf_line_info *linfo;
	void **jited_linfo;
	u32 func_info_cnt;
	u32 nr_linfo;
	u32 linfo_idx;
	struct module *mod;
	u32 num_exentries;
	struct exception_table_entry *extable;
	union {
		struct work_struct work;
		struct callback_head rcu;
	};
};

struct btf_mod_pair {
	struct btf *btf;
	struct module *module;
};

struct bpf_verifier_log {
	u64 start_pos;
	u64 end_pos;
	char *ubuf;
	u32 level;
	u32 len_total;
	u32 len_max;
	char kbuf[1024];
};

struct bpf_subprog_info {
	u32 start;
	u32 linfo_idx;
	u16 stack_depth;
	bool has_tail_call;
	bool tail_call_reachable;
	bool has_ld_abs;
	bool is_async_cb;
};

struct bpf_id_pair {
	u32 old;
	u32 cur;
};

struct bpf_idmap {
	u32 tmp_id_gen;
	struct bpf_id_pair map[600];
};

struct bpf_idset {
	u32 count;
	u32 ids[600];
};

struct backtrack_state {
	struct bpf_verifier_env *env;
	u32 frame;
	u32 reg_masks[8];
	u64 stack_masks[8];
};

struct bpf_verifier_ops;

struct bpf_verifier_stack_elem;

struct bpf_verifier_state;

struct bpf_verifier_state_list;

struct bpf_insn_aux_data;

struct bpf_verifier_env {
	u32 insn_idx;
	u32 prev_insn_idx;
	struct bpf_prog *prog;
	const struct bpf_verifier_ops *ops;
	struct bpf_verifier_stack_elem *head;
	int stack_size;
	bool strict_alignment;
	bool test_state_freq;
	struct bpf_verifier_state *cur_state;
	struct bpf_verifier_state_list **explored_states;
	struct bpf_verifier_state_list *free_list;
	struct bpf_map *used_maps[64];
	struct btf_mod_pair used_btfs[64];
	u32 used_map_cnt;
	u32 used_btf_cnt;
	u32 id_gen;
	bool explore_alu_limits;
	bool allow_ptr_leaks;
	bool allow_uninit_stack;
	bool bpf_capable;
	bool bypass_spec_v1;
	bool bypass_spec_v4;
	bool seen_direct_write;
	struct bpf_insn_aux_data *insn_aux_data;
	const struct bpf_line_info *prev_linfo;
	struct bpf_verifier_log log;
	struct bpf_subprog_info subprog_info[257];
	union {
		struct bpf_idmap idmap_scratch;
		struct bpf_idset idset_scratch;
	};
	struct {
		int *insn_state;
		int *insn_stack;
		int cur_stack;
	} cfg;
	struct backtrack_state bt;
	u32 pass_cnt;
	u32 subprog_cnt;
	u32 prev_insn_processed;
	u32 insn_processed;
	u32 prev_jmps_processed;
	u32 jmps_processed;
	u64 verification_time;
	u32 max_states_per_insn;
	u32 total_states;
	u32 peak_states;
	u32 longest_mark_read_walk;
	bpfptr_t fd_array;
	u32 scratched_regs;
	u64 scratched_stack_slots;
	u64 prev_log_pos;
	u64 prev_insn_print_pos;
	char tmp_str_buf[320];
};

enum bpf_reg_type {
	NOT_INIT = 0,
	SCALAR_VALUE = 1,
	PTR_TO_CTX = 2,
	CONST_PTR_TO_MAP = 3,
	PTR_TO_MAP_VALUE = 4,
	PTR_TO_MAP_KEY = 5,
	PTR_TO_STACK = 6,
	PTR_TO_PACKET_META = 7,
	PTR_TO_PACKET = 8,
	PTR_TO_PACKET_END = 9,
	PTR_TO_FLOW_KEYS = 10,
	PTR_TO_SOCKET = 11,
	PTR_TO_SOCK_COMMON = 12,
	PTR_TO_TCP_SOCK = 13,
	PTR_TO_TP_BUFFER = 14,
	PTR_TO_XDP_SOCK = 15,
	PTR_TO_BTF_ID = 16,
	PTR_TO_MEM = 17,
	PTR_TO_BUF = 18,
	PTR_TO_FUNC = 19,
	CONST_PTR_TO_DYNPTR = 20,
	__BPF_REG_TYPE_MAX = 21,
	PTR_TO_MAP_VALUE_OR_NULL = 260,
	PTR_TO_SOCKET_OR_NULL = 267,
	PTR_TO_SOCK_COMMON_OR_NULL = 268,
	PTR_TO_TCP_SOCK_OR_NULL = 269,
	PTR_TO_BTF_ID_OR_NULL = 272,
	__BPF_REG_TYPE_LIMIT = 33554431,
};

enum bpf_dynptr_type {
	BPF_DYNPTR_TYPE_INVALID = 0,
	BPF_DYNPTR_TYPE_LOCAL = 1,
	BPF_DYNPTR_TYPE_RINGBUF = 2,
	BPF_DYNPTR_TYPE_SKB = 3,
	BPF_DYNPTR_TYPE_XDP = 4,
};

enum bpf_iter_state {
	BPF_ITER_STATE_INVALID = 0,
	BPF_ITER_STATE_ACTIVE = 1,
	BPF_ITER_STATE_DRAINED = 2,
};

struct tnum {
	u64 value;
	u64 mask;
};

enum bpf_reg_liveness {
	REG_LIVE_NONE = 0,
	REG_LIVE_READ32 = 1,
	REG_LIVE_READ64 = 2,
	REG_LIVE_READ = 3,
	REG_LIVE_WRITTEN = 4,
	REG_LIVE_DONE = 8,
};

struct bpf_reg_state {
	enum bpf_reg_type type;
	s32 off;
	union {
		int range;
		struct {
			struct bpf_map *map_ptr;
			u32 map_uid;
		};
		struct {
			struct btf *btf;
			u32 btf_id;
		};
		struct {
			u32 mem_size;
			u32 dynptr_id;
		};
		struct {
			enum bpf_dynptr_type type;
			bool first_slot;
		} dynptr;
		struct {
			struct btf *btf;
			u32 btf_id;
			enum bpf_iter_state state: 2;
			int depth: 30;
		} iter;
		struct {
			long unsigned int raw1;
			long unsigned int raw2;
		} raw;
		u32 subprogno;
	};
	struct tnum var_off;
	s64 smin_value;
	s64 smax_value;
	u64 umin_value;
	u64 umax_value;
	s32 s32_min_value;
	s32 s32_max_value;
	u32 u32_min_value;
	u32 u32_max_value;
	u32 id;
	u32 ref_obj_id;
	struct bpf_reg_state *parent;
	u32 frameno;
	s32 subreg_def;
	enum bpf_reg_liveness live;
	bool precise;
};

struct bpf_reference_state;

struct bpf_stack_state;

struct bpf_func_state {
	struct bpf_reg_state regs[11];
	int callsite;
	u32 frameno;
	u32 subprogno;
	u32 async_entry_cnt;
	bool in_callback_fn;
	struct tnum callback_ret_range;
	bool in_async_callback_fn;
	int acquired_refs;
	struct bpf_reference_state *refs;
	int allocated_stack;
	struct bpf_stack_state *stack;
};

struct bpf_offloaded_map;

struct bpf_map_dev_ops {
	int (*map_get_next_key)(struct bpf_offloaded_map *, void *, void *);
	int (*map_lookup_elem)(struct bpf_offloaded_map *, void *, void *);
	int (*map_update_elem)(struct bpf_offloaded_map *, void *, void *, u64);
	int (*map_delete_elem)(struct bpf_offloaded_map *, void *);
};

struct bpf_offloaded_map {
	struct bpf_map map;
	struct net_device *netdev;
	const struct bpf_map_dev_ops *dev_ops;
	void *dev_priv;
	struct list_head offloads;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

typedef u32 xdp_features_t;

struct net_device_stats {
	union {
		long unsigned int rx_packets;
		atomic_long_t __rx_packets;
	};
	union {
		long unsigned int tx_packets;
		atomic_long_t __tx_packets;
	};
	union {
		long unsigned int rx_bytes;
		atomic_long_t __rx_bytes;
	};
	union {
		long unsigned int tx_bytes;
		atomic_long_t __tx_bytes;
	};
	union {
		long unsigned int rx_errors;
		atomic_long_t __rx_errors;
	};
	union {
		long unsigned int tx_errors;
		atomic_long_t __tx_errors;
	};
	union {
		long unsigned int rx_dropped;
		atomic_long_t __rx_dropped;
	};
	union {
		long unsigned int tx_dropped;
		atomic_long_t __tx_dropped;
	};
	union {
		long unsigned int multicast;
		atomic_long_t __multicast;
	};
	union {
		long unsigned int collisions;
		atomic_long_t __collisions;
	};
	union {
		long unsigned int rx_length_errors;
		atomic_long_t __rx_length_errors;
	};
	union {
		long unsigned int rx_over_errors;
		atomic_long_t __rx_over_errors;
	};
	union {
		long unsigned int rx_crc_errors;
		atomic_long_t __rx_crc_errors;
	};
	union {
		long unsigned int rx_frame_errors;
		atomic_long_t __rx_frame_errors;
	};
	union {
		long unsigned int rx_fifo_errors;
		atomic_long_t __rx_fifo_errors;
	};
	union {
		long unsigned int rx_missed_errors;
		atomic_long_t __rx_missed_errors;
	};
	union {
		long unsigned int tx_aborted_errors;
		atomic_long_t __tx_aborted_errors;
	};
	union {
		long unsigned int tx_carrier_errors;
		atomic_long_t __tx_carrier_errors;
	};
	union {
		long unsigned int tx_fifo_errors;
		atomic_long_t __tx_fifo_errors;
	};
	union {
		long unsigned int tx_heartbeat_errors;
		atomic_long_t __tx_heartbeat_errors;
	};
	union {
		long unsigned int tx_window_errors;
		atomic_long_t __tx_window_errors;
	};
	union {
		long unsigned int rx_compressed;
		atomic_long_t __rx_compressed;
	};
	union {
		long unsigned int tx_compressed;
		atomic_long_t __tx_compressed;
	};
};

struct netdev_hw_addr_list {
	struct list_head list;
	int count;
	struct rb_root tree;
};

enum rx_handler_result {
	RX_HANDLER_CONSUMED = 0,
	RX_HANDLER_ANOTHER = 1,
	RX_HANDLER_EXACT = 2,
	RX_HANDLER_PASS = 3,
};

typedef enum rx_handler_result rx_handler_result_t;

typedef rx_handler_result_t rx_handler_func_t(struct sk_buff **);

enum netdev_ml_priv_type {
	ML_PRIV_NONE = 0,
	ML_PRIV_CAN = 1,
};

struct pcpu_dstats;

struct netdev_tc_txq {
	u16 count;
	u16 offset;
};

struct sfp_bus;

struct udp_tunnel_nic;

struct bpf_xdp_link;

struct bpf_xdp_entity {
	struct bpf_prog *prog;
	struct bpf_xdp_link *link;
};

struct netdev_name_node;

struct dev_ifalias;

struct net_device_ops;

struct xdp_metadata_ops;

struct net_device_core_stats;

struct ethtool_ops;

struct ndisc_ops;

struct header_ops;

struct in_device;

struct inet6_dev;

struct vlan_info;

struct netdev_rx_queue;

struct bpf_mprog_entry;

struct netdev_queue;

struct cpu_rmap;

struct Qdisc;

struct xdp_dev_bulk_queue;

struct xps_dev_maps;

struct netpoll_info;

struct pcpu_lstats;

struct pcpu_sw_netstats;

struct rtnl_link_ops;

struct phy_device;

struct udp_tunnel_nic_info;

struct rtnl_hw_stats64;

struct devlink_port;

struct net_device {
	char name[16];
	struct netdev_name_node *name_node;
	struct dev_ifalias *ifalias;
	long unsigned int mem_end;
	long unsigned int mem_start;
	long unsigned int base_addr;
	long unsigned int state;
	struct list_head dev_list;
	struct list_head napi_list;
	struct list_head unreg_list;
	struct list_head close_list;
	struct list_head ptype_all;
	struct list_head ptype_specific;
	struct {
		struct list_head upper;
		struct list_head lower;
	} adj_list;
	unsigned int flags;
	xdp_features_t xdp_features;
	long long unsigned int priv_flags;
	const struct net_device_ops *netdev_ops;
	const struct xdp_metadata_ops *xdp_metadata_ops;
	int ifindex;
	short unsigned int gflags;
	short unsigned int hard_header_len;
	unsigned int mtu;
	short unsigned int needed_headroom;
	short unsigned int needed_tailroom;
	netdev_features_t features;
	netdev_features_t hw_features;
	netdev_features_t wanted_features;
	netdev_features_t vlan_features;
	netdev_features_t hw_enc_features;
	netdev_features_t mpls_features;
	netdev_features_t gso_partial_features;
	unsigned int min_mtu;
	unsigned int max_mtu;
	short unsigned int type;
	unsigned char min_header_len;
	unsigned char name_assign_type;
	int group;
	struct net_device_stats stats;
	struct net_device_core_stats *core_stats;
	atomic_t carrier_up_count;
	atomic_t carrier_down_count;
	const struct ethtool_ops *ethtool_ops;
	const struct ndisc_ops *ndisc_ops;
	const struct header_ops *header_ops;
	unsigned char operstate;
	unsigned char link_mode;
	unsigned char if_port;
	unsigned char dma;
	unsigned char perm_addr[32];
	unsigned char addr_assign_type;
	unsigned char addr_len;
	unsigned char upper_level;
	unsigned char lower_level;
	short unsigned int neigh_priv_len;
	short unsigned int dev_id;
	short unsigned int dev_port;
	short unsigned int padded;
	spinlock_t addr_list_lock;
	int irq;
	struct netdev_hw_addr_list uc;
	struct netdev_hw_addr_list mc;
	struct netdev_hw_addr_list dev_addrs;
	struct kset *queues_kset;
	unsigned int promiscuity;
	unsigned int allmulti;
	bool uc_promisc;
	struct in_device *ip_ptr;
	struct inet6_dev *ip6_ptr;
	struct vlan_info *vlan_info;
	const unsigned char *dev_addr;
	struct netdev_rx_queue *_rx;
	unsigned int num_rx_queues;
	unsigned int real_num_rx_queues;
	struct bpf_prog *xdp_prog;
	long unsigned int gro_flush_timeout;
	int napi_defer_hard_irqs;
	unsigned int gro_max_size;
	unsigned int gro_ipv4_max_size;
	unsigned int xdp_zc_max_segs;
	rx_handler_func_t *rx_handler;
	void *rx_handler_data;
	struct bpf_mprog_entry *tcx_ingress;
	struct netdev_queue *ingress_queue;
	struct nf_hook_entries *nf_hooks_ingress;
	unsigned char broadcast[32];
	struct cpu_rmap *rx_cpu_rmap;
	struct hlist_node index_hlist;
	long: 64;
	struct netdev_queue *_tx;
	unsigned int num_tx_queues;
	unsigned int real_num_tx_queues;
	struct Qdisc *qdisc;
	unsigned int tx_queue_len;
	spinlock_t tx_global_lock;
	struct xdp_dev_bulk_queue *xdp_bulkq;
	struct xps_dev_maps *xps_maps[2];
	struct bpf_mprog_entry *tcx_egress;
	struct nf_hook_entries *nf_hooks_egress;
	struct hlist_head qdisc_hash[16];
	struct timer_list watchdog_timer;
	int watchdog_timeo;
	u32 proto_down_reason;
	struct list_head todo_list;
	int *pcpu_refcnt;
	struct ref_tracker_dir refcnt_tracker;
	struct list_head link_watch_list;
	enum {
		NETREG_UNINITIALIZED = 0,
		NETREG_REGISTERED = 1,
		NETREG_UNREGISTERING = 2,
		NETREG_UNREGISTERED = 3,
		NETREG_RELEASED = 4,
		NETREG_DUMMY = 5,
	} reg_state: 8;
	bool dismantle;
	enum {
		RTNL_LINK_INITIALIZED = 0,
		RTNL_LINK_INITIALIZING = 1,
	} rtnl_link_state: 16;
	bool needs_free_netdev;
	void (*priv_destructor)(struct net_device *);
	struct netpoll_info *npinfo;
	possible_net_t nd_net;
	void *ml_priv;
	enum netdev_ml_priv_type ml_priv_type;
	union {
		struct pcpu_lstats *lstats;
		struct pcpu_sw_netstats *tstats;
		struct pcpu_dstats *dstats;
	};
	struct device dev;
	const struct attribute_group *sysfs_groups[4];
	const struct attribute_group *sysfs_rx_queue_group;
	const struct rtnl_link_ops *rtnl_link_ops;
	unsigned int gso_max_size;
	unsigned int tso_max_size;
	u16 gso_max_segs;
	u16 tso_max_segs;
	unsigned int gso_ipv4_max_size;
	s16 num_tc;
	struct netdev_tc_txq tc_to_txq[16];
	u8 prio_tc_map[16];
	struct phy_device *phydev;
	struct sfp_bus *sfp_bus;
	struct lock_class_key *qdisc_tx_busylock;
	bool proto_down;
	unsigned int wol_enabled: 1;
	unsigned int threaded: 1;
	struct list_head net_notifier_list;
	const struct udp_tunnel_nic_info *udp_tunnel_nic_info;
	struct udp_tunnel_nic *udp_tunnel_nic;
	struct bpf_xdp_entity xdp_state[3];
	u8 dev_addr_shadow[32];
	netdevice_tracker linkwatch_dev_tracker;
	netdevice_tracker watchdog_dev_tracker;
	netdevice_tracker dev_registered_tracker;
	struct rtnl_hw_stats64 *offload_xstats_l3;
	struct devlink_port *devlink_port;
	long: 64;
};

enum bpf_type_flag {
	PTR_MAYBE_NULL = 256,
	MEM_RDONLY = 512,
	MEM_RINGBUF = 1024,
	MEM_USER = 2048,
	MEM_PERCPU = 4096,
	OBJ_RELEASE = 8192,
	PTR_UNTRUSTED = 16384,
	MEM_UNINIT = 32768,
	DYNPTR_TYPE_LOCAL = 65536,
	DYNPTR_TYPE_RINGBUF = 131072,
	MEM_FIXED_SIZE = 262144,
	MEM_ALLOC = 524288,
	PTR_TRUSTED = 1048576,
	MEM_RCU = 2097152,
	NON_OWN_REF = 4194304,
	DYNPTR_TYPE_SKB = 8388608,
	DYNPTR_TYPE_XDP = 16777216,
	__BPF_TYPE_FLAG_MAX = 16777217,
	__BPF_TYPE_LAST_FLAG = 16777216,
};

enum bpf_arg_type {
	ARG_DONTCARE = 0,
	ARG_CONST_MAP_PTR = 1,
	ARG_PTR_TO_MAP_KEY = 2,
	ARG_PTR_TO_MAP_VALUE = 3,
	ARG_PTR_TO_MEM = 4,
	ARG_CONST_SIZE = 5,
	ARG_CONST_SIZE_OR_ZERO = 6,
	ARG_PTR_TO_CTX = 7,
	ARG_ANYTHING = 8,
	ARG_PTR_TO_SPIN_LOCK = 9,
	ARG_PTR_TO_SOCK_COMMON = 10,
	ARG_PTR_TO_INT = 11,
	ARG_PTR_TO_LONG = 12,
	ARG_PTR_TO_SOCKET = 13,
	ARG_PTR_TO_BTF_ID = 14,
	ARG_PTR_TO_RINGBUF_MEM = 15,
	ARG_CONST_ALLOC_SIZE_OR_ZERO = 16,
	ARG_PTR_TO_BTF_ID_SOCK_COMMON = 17,
	ARG_PTR_TO_PERCPU_BTF_ID = 18,
	ARG_PTR_TO_FUNC = 19,
	ARG_PTR_TO_STACK = 20,
	ARG_PTR_TO_CONST_STR = 21,
	ARG_PTR_TO_TIMER = 22,
	ARG_PTR_TO_KPTR = 23,
	ARG_PTR_TO_DYNPTR = 24,
	__BPF_ARG_TYPE_MAX = 25,
	ARG_PTR_TO_MAP_VALUE_OR_NULL = 259,
	ARG_PTR_TO_MEM_OR_NULL = 260,
	ARG_PTR_TO_CTX_OR_NULL = 263,
	ARG_PTR_TO_SOCKET_OR_NULL = 269,
	ARG_PTR_TO_STACK_OR_NULL = 276,
	ARG_PTR_TO_BTF_ID_OR_NULL = 270,
	ARG_PTR_TO_UNINIT_MEM = 32772,
	ARG_PTR_TO_FIXED_SIZE_MEM = 262148,
	__BPF_ARG_TYPE_LIMIT = 33554431,
};

enum bpf_return_type {
	RET_INTEGER = 0,
	RET_VOID = 1,
	RET_PTR_TO_MAP_VALUE = 2,
	RET_PTR_TO_SOCKET = 3,
	RET_PTR_TO_TCP_SOCK = 4,
	RET_PTR_TO_SOCK_COMMON = 5,
	RET_PTR_TO_MEM = 6,
	RET_PTR_TO_MEM_OR_BTF_ID = 7,
	RET_PTR_TO_BTF_ID = 8,
	__BPF_RET_TYPE_MAX = 9,
	RET_PTR_TO_MAP_VALUE_OR_NULL = 258,
	RET_PTR_TO_SOCKET_OR_NULL = 259,
	RET_PTR_TO_TCP_SOCK_OR_NULL = 260,
	RET_PTR_TO_SOCK_COMMON_OR_NULL = 261,
	RET_PTR_TO_RINGBUF_MEM_OR_NULL = 1286,
	RET_PTR_TO_DYNPTR_MEM_OR_NULL = 262,
	RET_PTR_TO_BTF_ID_OR_NULL = 264,
	RET_PTR_TO_BTF_ID_TRUSTED = 1048584,
	__BPF_RET_TYPE_LIMIT = 33554431,
};

struct bpf_func_proto {
	u64 (*func)(u64, u64, u64, u64, u64);
	bool gpl_only;
	bool pkt_access;
	bool might_sleep;
	enum bpf_return_type ret_type;
	union {
		struct {
			enum bpf_arg_type arg1_type;
			enum bpf_arg_type arg2_type;
			enum bpf_arg_type arg3_type;
			enum bpf_arg_type arg4_type;
			enum bpf_arg_type arg5_type;
		};
		enum bpf_arg_type arg_type[5];
	};
	union {
		struct {
			u32 *arg1_btf_id;
			u32 *arg2_btf_id;
			u32 *arg3_btf_id;
			u32 *arg4_btf_id;
			u32 *arg5_btf_id;
		};
		u32 *arg_btf_id[5];
		struct {
			size_t arg1_size;
			size_t arg2_size;
			size_t arg3_size;
			size_t arg4_size;
			size_t arg5_size;
		};
		size_t arg_size[5];
	};
	int *ret_btf_id;
	bool (*allowed)(const struct bpf_prog *);
};

enum bpf_access_type {
	BPF_READ = 1,
	BPF_WRITE = 2,
};

struct bpf_insn_access_aux {
	enum bpf_reg_type reg_type;
	union {
		int ctx_field_size;
		struct {
			struct btf *btf;
			u32 btf_id;
		};
	};
	struct bpf_verifier_log *log;
};

struct bpf_prog_ops {
	int (*test_run)(struct bpf_prog *, const union bpf_attr *, union bpf_attr *);
};

struct bpf_verifier_ops {
	const struct bpf_func_proto * (*get_func_proto)(enum bpf_func_id, const struct bpf_prog *);
	bool (*is_valid_access)(int, int, enum bpf_access_type, const struct bpf_prog *, struct bpf_insn_access_aux *);
	int (*gen_prologue)(struct bpf_insn *, bool, const struct bpf_prog *);
	int (*gen_ld_abs)(const struct bpf_insn *, struct bpf_insn *);
	u32 (*convert_ctx_access)(enum bpf_access_type, const struct bpf_insn *, struct bpf_insn *, struct bpf_prog *, u32 *);
	int (*btf_struct_access)(struct bpf_verifier_log *, const struct bpf_reg_state *, int, int);
};

struct bpf_offload_dev;

struct bpf_prog_offload {
	struct bpf_prog *prog;
	struct net_device *netdev;
	struct bpf_offload_dev *offdev;
	void *dev_priv;
	struct list_head offloads;
	bool dev_state;
	bool opt_failed;
	void *jited_image;
	u32 jited_len;
};

struct btf_func_model {
	u8 ret_size;
	u8 ret_flags;
	u8 nr_args;
	u8 arg_size[12];
	u8 arg_flags[12];
};

struct bpf_link_ops;

struct bpf_link {
	atomic64_t refcnt;
	u32 id;
	enum bpf_link_type type;
	const struct bpf_link_ops *ops;
	struct bpf_prog *prog;
	struct work_struct work;
};

struct bpf_tramp_link {
	struct bpf_link link;
	struct hlist_node tramp_hlist;
	u64 cookie;
};

struct bpf_tramp_run_ctx {
	struct bpf_run_ctx run_ctx;
	u64 bpf_cookie;
	struct bpf_run_ctx *saved_run_ctx;
};

struct bpf_tramp_image {
	void *image;
	struct bpf_ksym ksym;
	struct percpu_ref pcref;
	void *ip_after_call;
	void *ip_epilogue;
	union {
		struct callback_head rcu;
		struct work_struct work;
	};
};

struct bpf_trampoline {
	struct hlist_node hlist;
	struct ftrace_ops *fops;
	struct mutex mutex;
	refcount_t refcnt;
	u32 flags;
	u64 key;
	struct {
		struct btf_func_model model;
		void *addr;
		bool ftrace_managed;
	} func;
	struct bpf_prog *extension_prog;
	struct hlist_head progs_hlist[3];
	int progs_cnt[3];
	struct bpf_tramp_image *cur_image;
	struct module *mod;
};

struct bpf_attach_target_info {
	struct btf_func_model fmodel;
	long int tgt_addr;
	struct module *tgt_mod;
	const char *tgt_name;
	const struct btf_type *tgt_type;
};

struct bpf_func_info_aux {
	u16 linkage;
	bool unreliable;
};

struct bpf_jit_poke_descriptor {
	void *tailcall_target;
	void *tailcall_bypass;
	void *bypass_addr;
	void *aux;
	union {
		struct {
			struct bpf_map *map;
			u32 key;
		} tail_call;
	};
	bool tailcall_target_stable;
	u8 adj_off;
	u16 reason;
	u32 insn_idx;
};

struct bpf_ctx_arg_aux {
	u32 offset;
	enum bpf_reg_type reg_type;
	u32 btf_id;
};

struct bpf_prog_stats {
	u64_stats_t cnt;
	u64_stats_t nsecs;
	u64_stats_t misses;
	struct u64_stats_sync syncp;
	long: 64;
};

struct sock_fprog_kern {
	u16 len;
	struct sock_filter *filter;
};

struct bpf_link_ops {
	void (*release)(struct bpf_link *);
	void (*dealloc)(struct bpf_link *);
	int (*detach)(struct bpf_link *);
	int (*update_prog)(struct bpf_link *, struct bpf_prog *, struct bpf_prog *);
	void (*show_fdinfo)(const struct bpf_link *, struct seq_file *);
	int (*fill_link_info)(const struct bpf_link *, struct bpf_link_info *);
	int (*update_map)(struct bpf_link *, struct bpf_map *, struct bpf_map *);
};

struct bpf_tracing_link {
	struct bpf_tramp_link link;
	enum bpf_attach_type attach_type;
	struct bpf_trampoline *trampoline;
	struct bpf_prog *tgt_prog;
};

struct bpf_link_primer {
	struct bpf_link *link;
	struct file *file;
	int fd;
	u32 id;
};

struct bpf_storage_buffer;

struct bpf_cgroup_storage_map;

struct bpf_cgroup_storage {
	union {
		struct bpf_storage_buffer *buf;
		void *percpu_buf;
	};
	struct bpf_cgroup_storage_map *map;
	struct bpf_cgroup_storage_key key;
	struct list_head list_map;
	struct list_head list_cg;
	struct rb_node node;
	struct callback_head rcu;
};

struct dql {
	unsigned int num_queued;
	unsigned int adj_limit;
	unsigned int last_obj_cnt;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	unsigned int limit;
	unsigned int num_completed;
	unsigned int prev_ovlimit;
	unsigned int prev_num_queued;
	unsigned int prev_last_obj_cnt;
	unsigned int lowest_slack;
	long unsigned int slack_start_time;
	unsigned int max_limit;
	unsigned int min_limit;
	unsigned int slack_hold_time;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct prot_inuse {
	int all;
	int val[64];
};

struct netlink_ext_ack;

struct fib_notifier_ops {
	int family;
	struct list_head list;
	unsigned int (*fib_seq_read)(struct net *);
	int (*fib_dump)(struct net *, struct notifier_block *, struct netlink_ext_ack *);
	struct module *owner;
	struct callback_head rcu;
};

struct hh_cache {
	unsigned int hh_len;
	seqlock_t hh_lock;
	long unsigned int hh_data[12];
};

struct neigh_table;

struct neigh_parms;

struct neigh_ops;

struct neighbour {
	struct neighbour *next;
	struct neigh_table *tbl;
	struct neigh_parms *parms;
	long unsigned int confirmed;
	long unsigned int updated;
	rwlock_t lock;
	refcount_t refcnt;
	unsigned int arp_queue_len_bytes;
	struct sk_buff_head arp_queue;
	struct timer_list timer;
	long unsigned int used;
	atomic_t probes;
	u8 nud_state;
	u8 type;
	u8 dead;
	u8 protocol;
	u32 flags;
	seqlock_t ha_lock;
	long: 0;
	unsigned char ha[32];
	struct hh_cache hh;
	int (*output)(struct neighbour *, struct sk_buff *);
	const struct neigh_ops *ops;
	struct list_head gc_list;
	struct list_head managed_list;
	struct callback_head rcu;
	struct net_device *dev;
	netdevice_tracker dev_tracker;
	u8 primary_key[0];
};

typedef __kernel_sa_family_t sa_family_t;

struct sockaddr {
	sa_family_t sa_family;
	union {
		char sa_data_min[14];
		struct {
			struct {} __empty_sa_data;
			char sa_data[0];
		};
	};
};

struct ubuf_info;

struct msghdr {
	void *msg_name;
	int msg_namelen;
	int msg_inq;
	struct iov_iter msg_iter;
	union {
		void *msg_control;
		void *msg_control_user;
	};
	bool msg_control_is_user: 1;
	bool msg_get_inq: 1;
	unsigned int msg_flags;
	__kernel_size_t msg_controllen;
	struct kiocb *msg_iocb;
	struct ubuf_info *msg_ubuf;
	int (*sg_from_iter)(struct sock *, struct sk_buff *, struct iov_iter *, size_t);
};

struct ubuf_info {
	void (*callback)(struct sk_buff *, struct ubuf_info *, bool);
	refcount_t refcnt;
	u8 flags;
};

struct skb_shared_hwtstamps {
	union {
		ktime_t hwtstamp;
		void *netdev_data;
	};
};

typedef enum {
	SS_FREE = 0,
	SS_UNCONNECTED = 1,
	SS_CONNECTING = 2,
	SS_CONNECTED = 3,
	SS_DISCONNECTING = 4,
} socket_state;

struct socket_wq {
	wait_queue_head_t wait;
	struct fasync_struct *fasync_list;
	long unsigned int flags;
	struct callback_head rcu;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct proto_ops;

struct socket {
	socket_state state;
	short int type;
	long unsigned int flags;
	struct file *file;
	struct sock *sk;
	const struct proto_ops *ops;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct socket_wq wq;
};

typedef struct {
	size_t written;
	size_t count;
	union {
		char *buf;
		void *data;
	} arg;
	int error;
} read_descriptor_t;

typedef int (*sk_read_actor_t)(read_descriptor_t *, struct sk_buff *, unsigned int, size_t);

typedef int (*skb_read_actor_t)(struct sock *, struct sk_buff *);

struct proto_ops {
	int family;
	struct module *owner;
	int (*release)(struct socket *);
	int (*bind)(struct socket *, struct sockaddr *, int);
	int (*connect)(struct socket *, struct sockaddr *, int, int);
	int (*socketpair)(struct socket *, struct socket *);
	int (*accept)(struct socket *, struct socket *, int, bool);
	int (*getname)(struct socket *, struct sockaddr *, int);
	__poll_t (*poll)(struct file *, struct socket *, struct poll_table_struct *);
	int (*ioctl)(struct socket *, unsigned int, long unsigned int);
	int (*gettstamp)(struct socket *, void *, bool, bool);
	int (*listen)(struct socket *, int);
	int (*shutdown)(struct socket *, int);
	int (*setsockopt)(struct socket *, int, int, sockptr_t, unsigned int);
	int (*getsockopt)(struct socket *, int, int, char *, int *);
	void (*show_fdinfo)(struct seq_file *, struct socket *);
	int (*sendmsg)(struct socket *, struct msghdr *, size_t);
	int (*recvmsg)(struct socket *, struct msghdr *, size_t, int);
	int (*mmap)(struct file *, struct socket *, struct vm_area_struct *);
	ssize_t (*splice_read)(struct socket *, loff_t *, struct pipe_inode_info *, size_t, unsigned int);
	void (*splice_eof)(struct socket *);
	int (*set_peek_off)(struct sock *, int);
	int (*peek_len)(struct socket *);
	int (*read_sock)(struct sock *, read_descriptor_t *, sk_read_actor_t);
	int (*read_skb)(struct sock *, skb_read_actor_t);
	int (*sendmsg_locked)(struct sock *, struct msghdr *, size_t);
	int (*set_rcvlowat)(struct sock *, int);
};

typedef struct {
	unsigned int clock_rate;
	unsigned int clock_type;
	short unsigned int loopback;
} sync_serial_settings;

typedef struct {
	unsigned int clock_rate;
	unsigned int clock_type;
	short unsigned int loopback;
	unsigned int slot_map;
} te1_settings;

typedef struct {
	short unsigned int encoding;
	short unsigned int parity;
} raw_hdlc_proto;

typedef struct {
	unsigned int t391;
	unsigned int t392;
	unsigned int n391;
	unsigned int n392;
	unsigned int n393;
	short unsigned int lmi;
	short unsigned int dce;
} fr_proto;

typedef struct {
	unsigned int dlci;
} fr_proto_pvc;

typedef struct {
	unsigned int dlci;
	char master[16];
} fr_proto_pvc_info;

typedef struct {
	unsigned int interval;
	unsigned int timeout;
} cisco_proto;

typedef struct {
	short unsigned int dce;
	unsigned int modulo;
	unsigned int window;
	unsigned int t1;
	unsigned int t2;
	unsigned int n2;
} x25_hdlc_proto;

struct ifmap {
	long unsigned int mem_start;
	long unsigned int mem_end;
	short unsigned int base_addr;
	unsigned char irq;
	unsigned char dma;
	unsigned char port;
};

struct if_settings {
	unsigned int type;
	unsigned int size;
	union {
		raw_hdlc_proto *raw_hdlc;
		cisco_proto *cisco;
		fr_proto *fr;
		fr_proto_pvc *fr_pvc;
		fr_proto_pvc_info *fr_pvc_info;
		x25_hdlc_proto *x25;
		sync_serial_settings *sync;
		te1_settings *te1;
	} ifs_ifsu;
};

struct ifreq {
	union {
		char ifrn_name[16];
	} ifr_ifrn;
	union {
		struct sockaddr ifru_addr;
		struct sockaddr ifru_dstaddr;
		struct sockaddr ifru_broadaddr;
		struct sockaddr ifru_netmask;
		struct sockaddr ifru_hwaddr;
		short int ifru_flags;
		int ifru_ivalue;
		int ifru_mtu;
		struct ifmap ifru_map;
		char ifru_slave[16];
		char ifru_newname[16];
		void *ifru_data;
		struct if_settings ifru_settings;
	} ifr_ifru;
};

struct nlmsghdr {
	__u32 nlmsg_len;
	__u16 nlmsg_type;
	__u16 nlmsg_flags;
	__u32 nlmsg_seq;
	__u32 nlmsg_pid;
};

struct nlattr {
	__u16 nla_len;
	__u16 nla_type;
};

struct nla_policy;

struct netlink_ext_ack {
	const char *_msg;
	const struct nlattr *bad_attr;
	const struct nla_policy *policy;
	const struct nlattr *miss_nest;
	u16 miss_type;
	u8 cookie[20];
	u8 cookie_len;
	char _msg_buf[80];
};

struct netlink_range_validation;

struct netlink_range_validation_signed;

struct nla_policy {
	u8 type;
	u8 validation_type;
	u16 len;
	union {
		u16 strict_start_type;
		const u32 bitfield32_valid;
		const u32 mask;
		const char *reject_message;
		const struct nla_policy *nested_policy;
		struct netlink_range_validation *range;
		struct netlink_range_validation_signed *range_signed;
		struct {
			s16 min;
			s16 max;
		};
		int (*validate)(const struct nlattr *, struct netlink_ext_ack *);
	};
};

struct netlink_callback {
	struct sk_buff *skb;
	const struct nlmsghdr *nlh;
	int (*dump)(struct sk_buff *, struct netlink_callback *);
	int (*done)(struct netlink_callback *);
	void *data;
	struct module *module;
	struct netlink_ext_ack *extack;
	u16 family;
	u16 answer_flags;
	u32 min_dump_alloc;
	unsigned int prev_seq;
	unsigned int seq;
	bool strict_check;
	union {
		u8 ctx[48];
		long int args[6];
	};
};

struct ndmsg {
	__u8 ndm_family;
	__u8 ndm_pad1;
	__u16 ndm_pad2;
	__s32 ndm_ifindex;
	__u16 ndm_state;
	__u8 ndm_flags;
	__u8 ndm_type;
};

struct rtnl_link_stats64 {
	__u64 rx_packets;
	__u64 tx_packets;
	__u64 rx_bytes;
	__u64 tx_bytes;
	__u64 rx_errors;
	__u64 tx_errors;
	__u64 rx_dropped;
	__u64 tx_dropped;
	__u64 multicast;
	__u64 collisions;
	__u64 rx_length_errors;
	__u64 rx_over_errors;
	__u64 rx_crc_errors;
	__u64 rx_frame_errors;
	__u64 rx_fifo_errors;
	__u64 rx_missed_errors;
	__u64 tx_aborted_errors;
	__u64 tx_carrier_errors;
	__u64 tx_fifo_errors;
	__u64 tx_heartbeat_errors;
	__u64 tx_window_errors;
	__u64 rx_compressed;
	__u64 tx_compressed;
	__u64 rx_nohandler;
	__u64 rx_otherhost_dropped;
};

struct rtnl_hw_stats64 {
	__u64 rx_packets;
	__u64 tx_packets;
	__u64 rx_bytes;
	__u64 tx_bytes;
	__u64 rx_errors;
	__u64 tx_errors;
	__u64 rx_dropped;
	__u64 tx_dropped;
	__u64 multicast;
};

struct ifla_vf_guid {
	__u32 vf;
	__u64 guid;
};

struct ifla_vf_stats {
	__u64 rx_packets;
	__u64 tx_packets;
	__u64 rx_bytes;
	__u64 tx_bytes;
	__u64 broadcast;
	__u64 multicast;
	__u64 rx_dropped;
	__u64 tx_dropped;
};

struct ifla_vf_info {
	__u32 vf;
	__u8 mac[32];
	__u32 vlan;
	__u32 qos;
	__u32 spoofchk;
	__u32 linkstate;
	__u32 min_tx_rate;
	__u32 max_tx_rate;
	__u32 rss_query_en;
	__u32 trusted;
	__be16 vlan_proto;
};

struct tc_stats {
	__u64 bytes;
	__u32 packets;
	__u32 drops;
	__u32 overlimits;
	__u32 bps;
	__u32 pps;
	__u32 qlen;
	__u32 backlog;
};

struct tc_sizespec {
	unsigned char cell_log;
	unsigned char size_log;
	short int cell_align;
	int overhead;
	unsigned int linklayer;
	unsigned int mpu;
	unsigned int mtu;
	unsigned int tsize;
};

enum netdev_tx {
	__NETDEV_TX_MIN = -2147483648,
	NETDEV_TX_OK = 0,
	NETDEV_TX_BUSY = 16,
};

typedef enum netdev_tx netdev_tx_t;

struct net_device_core_stats {
	long unsigned int rx_dropped;
	long unsigned int tx_dropped;
	long unsigned int rx_nohandler;
	long unsigned int rx_otherhost_dropped;
};

struct header_ops {
	int (*create)(struct sk_buff *, struct net_device *, short unsigned int, const void *, const void *, unsigned int);
	int (*parse)(const struct sk_buff *, unsigned char *);
	int (*cache)(const struct neighbour *, struct hh_cache *, __be16);
	void (*cache_update)(struct hh_cache *, const struct net_device *, const unsigned char *);
	bool (*validate)(const char *, unsigned int);
	__be16 (*parse_protocol)(const struct sk_buff *);
};

struct netdev_queue {
	struct net_device *dev;
	netdevice_tracker dev_tracker;
	struct Qdisc *qdisc;
	struct Qdisc *qdisc_sleeping;
	struct kobject kobj;
	int numa_node;
	long unsigned int tx_maxrate;
	atomic_long_t trans_timeout;
	struct net_device *sb_dev;
	long: 64;
	spinlock_t _xmit_lock;
	int xmit_lock_owner;
	long unsigned int trans_start;
	long unsigned int state;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct dql dql;
};

struct net_rate_estimator;

struct qdisc_skb_head {
	struct sk_buff *head;
	struct sk_buff *tail;
	__u32 qlen;
	spinlock_t lock;
};

struct gnet_stats_basic_sync {
	u64_stats_t bytes;
	u64_stats_t packets;
	struct u64_stats_sync syncp;
};

struct gnet_stats_queue {
	__u32 qlen;
	__u32 backlog;
	__u32 drops;
	__u32 requeues;
	__u32 overlimits;
};

struct Qdisc_ops;

struct qdisc_size_table;

struct Qdisc {
	int (*enqueue)(struct sk_buff *, struct Qdisc *, struct sk_buff **);
	struct sk_buff * (*dequeue)(struct Qdisc *);
	unsigned int flags;
	u32 limit;
	const struct Qdisc_ops *ops;
	struct qdisc_size_table *stab;
	struct hlist_node hash;
	u32 handle;
	u32 parent;
	struct netdev_queue *dev_queue;
	struct net_rate_estimator *rate_est;
	struct gnet_stats_basic_sync *cpu_bstats;
	struct gnet_stats_queue *cpu_qstats;
	int pad;
	refcount_t refcnt;
	long: 64;
	long: 64;
	long: 64;
	struct sk_buff_head gso_skb;
	struct qdisc_skb_head q;
	struct gnet_stats_basic_sync bstats;
	struct gnet_stats_queue qstats;
	long unsigned int state;
	long unsigned int state2;
	struct Qdisc *next_sched;
	struct sk_buff_head skb_bad_txq;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	spinlock_t busylock;
	spinlock_t seqlock;
	struct callback_head rcu;
	netdevice_tracker dev_tracker;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long int privdata[0];
};

struct xps_map {
	unsigned int len;
	unsigned int alloc_len;
	struct callback_head rcu;
	u16 queues[0];
};

struct xps_dev_maps {
	struct callback_head rcu;
	unsigned int nr_ids;
	s16 num_tc;
	struct xps_map *attr_map[0];
};

struct netdev_phys_item_id {
	unsigned char id[32];
	unsigned char id_len;
};

enum net_device_path_type {
	DEV_PATH_ETHERNET = 0,
	DEV_PATH_VLAN = 1,
	DEV_PATH_BRIDGE = 2,
	DEV_PATH_PPPOE = 3,
	DEV_PATH_DSA = 4,
	DEV_PATH_MTK_WDMA = 5,
};

struct net_device_path {
	enum net_device_path_type type;
	const struct net_device *dev;
	union {
		struct {
			u16 id;
			__be16 proto;
			u8 h_dest[6];
		} encap;
		struct {
			enum {
				DEV_PATH_BR_VLAN_KEEP = 0,
				DEV_PATH_BR_VLAN_TAG = 1,
				DEV_PATH_BR_VLAN_UNTAG = 2,
				DEV_PATH_BR_VLAN_UNTAG_HW = 3,
			} vlan_mode;
			u16 vlan_id;
			__be16 vlan_proto;
		} bridge;
		struct {
			int port;
			u16 proto;
		} dsa;
		struct {
			u8 wdma_idx;
			u8 queue;
			u16 wcid;
			u8 bss;
		} mtk_wdma;
	};
};

struct net_device_path_ctx {
	const struct net_device *dev;
	u8 daddr[6];
	int num_vlans;
	struct {
		u16 id;
		__be16 proto;
	} vlan[2];
};

enum tc_setup_type {
	TC_QUERY_CAPS = 0,
	TC_SETUP_QDISC_MQPRIO = 1,
	TC_SETUP_CLSU32 = 2,
	TC_SETUP_CLSFLOWER = 3,
	TC_SETUP_CLSMATCHALL = 4,
	TC_SETUP_CLSBPF = 5,
	TC_SETUP_BLOCK = 6,
	TC_SETUP_QDISC_CBS = 7,
	TC_SETUP_QDISC_RED = 8,
	TC_SETUP_QDISC_PRIO = 9,
	TC_SETUP_QDISC_MQ = 10,
	TC_SETUP_QDISC_ETF = 11,
	TC_SETUP_ROOT_QDISC = 12,
	TC_SETUP_QDISC_GRED = 13,
	TC_SETUP_QDISC_TAPRIO = 14,
	TC_SETUP_FT = 15,
	TC_SETUP_QDISC_ETS = 16,
	TC_SETUP_QDISC_TBF = 17,
	TC_SETUP_QDISC_FIFO = 18,
	TC_SETUP_QDISC_HTB = 19,
	TC_SETUP_ACT = 20,
};

enum bpf_netdev_command {
	XDP_SETUP_PROG = 0,
	XDP_SETUP_PROG_HW = 1,
	BPF_OFFLOAD_MAP_ALLOC = 2,
	BPF_OFFLOAD_MAP_FREE = 3,
	XDP_SETUP_XSK_POOL = 4,
};

struct xsk_buff_pool;

struct netdev_bpf {
	enum bpf_netdev_command command;
	union {
		struct {
			u32 flags;
			struct bpf_prog *prog;
			struct netlink_ext_ack *extack;
		};
		struct {
			struct bpf_offloaded_map *offmap;
		};
		struct {
			struct xsk_buff_pool *pool;
			u16 queue_id;
		} xsk;
	};
};

struct dev_ifalias {
	struct callback_head rcuhead;
	char ifalias[0];
};

struct xdp_frame;

struct xdp_buff;

struct ip_tunnel_parm;

struct kernel_hwtstamp_config;

struct net_device_ops {
	int (*ndo_init)(struct net_device *);
	void (*ndo_uninit)(struct net_device *);
	int (*ndo_open)(struct net_device *);
	int (*ndo_stop)(struct net_device *);
	netdev_tx_t (*ndo_start_xmit)(struct sk_buff *, struct net_device *);
	netdev_features_t (*ndo_features_check)(struct sk_buff *, struct net_device *, netdev_features_t);
	u16 (*ndo_select_queue)(struct net_device *, struct sk_buff *, struct net_device *);
	void (*ndo_change_rx_flags)(struct net_device *, int);
	void (*ndo_set_rx_mode)(struct net_device *);
	int (*ndo_set_mac_address)(struct net_device *, void *);
	int (*ndo_validate_addr)(struct net_device *);
	int (*ndo_do_ioctl)(struct net_device *, struct ifreq *, int);
	int (*ndo_eth_ioctl)(struct net_device *, struct ifreq *, int);
	int (*ndo_siocbond)(struct net_device *, struct ifreq *, int);
	int (*ndo_siocwandev)(struct net_device *, struct if_settings *);
	int (*ndo_siocdevprivate)(struct net_device *, struct ifreq *, void *, int);
	int (*ndo_set_config)(struct net_device *, struct ifmap *);
	int (*ndo_change_mtu)(struct net_device *, int);
	int (*ndo_neigh_setup)(struct net_device *, struct neigh_parms *);
	void (*ndo_tx_timeout)(struct net_device *, unsigned int);
	void (*ndo_get_stats64)(struct net_device *, struct rtnl_link_stats64 *);
	bool (*ndo_has_offload_stats)(const struct net_device *, int);
	int (*ndo_get_offload_stats)(int, const struct net_device *, void *);
	struct net_device_stats * (*ndo_get_stats)(struct net_device *);
	int (*ndo_vlan_rx_add_vid)(struct net_device *, __be16, u16);
	int (*ndo_vlan_rx_kill_vid)(struct net_device *, __be16, u16);
	void (*ndo_poll_controller)(struct net_device *);
	int (*ndo_netpoll_setup)(struct net_device *, struct netpoll_info *);
	void (*ndo_netpoll_cleanup)(struct net_device *);
	int (*ndo_set_vf_mac)(struct net_device *, int, u8 *);
	int (*ndo_set_vf_vlan)(struct net_device *, int, u16, u8, __be16);
	int (*ndo_set_vf_rate)(struct net_device *, int, int, int);
	int (*ndo_set_vf_spoofchk)(struct net_device *, int, bool);
	int (*ndo_set_vf_trust)(struct net_device *, int, bool);
	int (*ndo_get_vf_config)(struct net_device *, int, struct ifla_vf_info *);
	int (*ndo_set_vf_link_state)(struct net_device *, int, int);
	int (*ndo_get_vf_stats)(struct net_device *, int, struct ifla_vf_stats *);
	int (*ndo_set_vf_port)(struct net_device *, int, struct nlattr **);
	int (*ndo_get_vf_port)(struct net_device *, int, struct sk_buff *);
	int (*ndo_get_vf_guid)(struct net_device *, int, struct ifla_vf_guid *, struct ifla_vf_guid *);
	int (*ndo_set_vf_guid)(struct net_device *, int, u64, int);
	int (*ndo_set_vf_rss_query_en)(struct net_device *, int, bool);
	int (*ndo_setup_tc)(struct net_device *, enum tc_setup_type, void *);
	int (*ndo_rx_flow_steer)(struct net_device *, const struct sk_buff *, u16, u32);
	int (*ndo_add_slave)(struct net_device *, struct net_device *, struct netlink_ext_ack *);
	int (*ndo_del_slave)(struct net_device *, struct net_device *);
	struct net_device * (*ndo_get_xmit_slave)(struct net_device *, struct sk_buff *, bool);
	struct net_device * (*ndo_sk_get_lower_dev)(struct net_device *, struct sock *);
	netdev_features_t (*ndo_fix_features)(struct net_device *, netdev_features_t);
	int (*ndo_set_features)(struct net_device *, netdev_features_t);
	int (*ndo_neigh_construct)(struct net_device *, struct neighbour *);
	void (*ndo_neigh_destroy)(struct net_device *, struct neighbour *);
	int (*ndo_fdb_add)(struct ndmsg *, struct nlattr **, struct net_device *, const unsigned char *, u16, u16, struct netlink_ext_ack *);
	int (*ndo_fdb_del)(struct ndmsg *, struct nlattr **, struct net_device *, const unsigned char *, u16, struct netlink_ext_ack *);
	int (*ndo_fdb_del_bulk)(struct ndmsg *, struct nlattr **, struct net_device *, u16, struct netlink_ext_ack *);
	int (*ndo_fdb_dump)(struct sk_buff *, struct netlink_callback *, struct net_device *, struct net_device *, int *);
	int (*ndo_fdb_get)(struct sk_buff *, struct nlattr **, struct net_device *, const unsigned char *, u16, u32, u32, struct netlink_ext_ack *);
	int (*ndo_mdb_add)(struct net_device *, struct nlattr **, u16, struct netlink_ext_ack *);
	int (*ndo_mdb_del)(struct net_device *, struct nlattr **, struct netlink_ext_ack *);
	int (*ndo_mdb_dump)(struct net_device *, struct sk_buff *, struct netlink_callback *);
	int (*ndo_bridge_setlink)(struct net_device *, struct nlmsghdr *, u16, struct netlink_ext_ack *);
	int (*ndo_bridge_getlink)(struct sk_buff *, u32, u32, struct net_device *, u32, int);
	int (*ndo_bridge_dellink)(struct net_device *, struct nlmsghdr *, u16);
	int (*ndo_change_carrier)(struct net_device *, bool);
	int (*ndo_get_phys_port_id)(struct net_device *, struct netdev_phys_item_id *);
	int (*ndo_get_port_parent_id)(struct net_device *, struct netdev_phys_item_id *);
	int (*ndo_get_phys_port_name)(struct net_device *, char *, size_t);
	void * (*ndo_dfwd_add_station)(struct net_device *, struct net_device *);
	void (*ndo_dfwd_del_station)(struct net_device *, void *);
	int (*ndo_set_tx_maxrate)(struct net_device *, int, u32);
	int (*ndo_get_iflink)(const struct net_device *);
	int (*ndo_fill_metadata_dst)(struct net_device *, struct sk_buff *);
	void (*ndo_set_rx_headroom)(struct net_device *, int);
	int (*ndo_bpf)(struct net_device *, struct netdev_bpf *);
	int (*ndo_xdp_xmit)(struct net_device *, int, struct xdp_frame **, u32);
	struct net_device * (*ndo_xdp_get_xmit_slave)(struct net_device *, struct xdp_buff *);
	int (*ndo_xsk_wakeup)(struct net_device *, u32, u32);
	int (*ndo_tunnel_ctl)(struct net_device *, struct ip_tunnel_parm *, int);
	struct net_device * (*ndo_get_peer_dev)(struct net_device *);
	int (*ndo_fill_forward_path)(struct net_device_path_ctx *, struct net_device_path *);
	ktime_t (*ndo_get_tstamp)(struct net_device *, const struct skb_shared_hwtstamps *, bool);
	int (*ndo_hwtstamp_get)(struct net_device *, struct kernel_hwtstamp_config *);
	int (*ndo_hwtstamp_set)(struct net_device *, struct kernel_hwtstamp_config *, struct netlink_ext_ack *);
};

struct neigh_parms {
	possible_net_t net;
	struct net_device *dev;
	netdevice_tracker dev_tracker;
	struct list_head list;
	int (*neigh_setup)(struct neighbour *);
	struct neigh_table *tbl;
	void *sysctl_table;
	int dead;
	refcount_t refcnt;
	struct callback_head callback_head;
	int reachable_time;
	u32 qlen;
	int data[14];
	long unsigned int data_state[1];
};

struct xdp_mem_info {
	u32 type;
	u32 id;
};

struct xdp_frame {
	void *data;
	u16 len;
	u16 headroom;
	u32 metasize;
	struct xdp_mem_info mem;
	struct net_device *dev_rx;
	u32 frame_sz;
	u32 flags;
};

struct xdp_rxq_info;

struct xdp_txq_info;

struct xdp_buff {
	void *data;
	void *data_end;
	void *data_meta;
	void *data_hard_start;
	struct xdp_rxq_info *rxq;
	struct xdp_txq_info *txq;
	u32 frame_sz;
	u32 flags;
};

enum hwtstamp_source {
	HWTSTAMP_SOURCE_NETDEV = 0,
	HWTSTAMP_SOURCE_PHYLIB = 1,
};

struct kernel_hwtstamp_config {
	int flags;
	int tx_type;
	int rx_filter;
	struct ifreq *ifr;
	bool copied_to_user;
	enum hwtstamp_source source;
};

struct pcpu_lstats {
	u64_stats_t packets;
	u64_stats_t bytes;
	struct u64_stats_sync syncp;
};

struct pcpu_sw_netstats {
	u64_stats_t rx_packets;
	u64_stats_t rx_bytes;
	u64_stats_t tx_packets;
	u64_stats_t tx_bytes;
	struct u64_stats_sync syncp;
};

enum xdp_rss_hash_type {
	XDP_RSS_L3_IPV4 = 1,
	XDP_RSS_L3_IPV6 = 2,
	XDP_RSS_L3_DYNHDR = 4,
	XDP_RSS_L4 = 8,
	XDP_RSS_L4_TCP = 16,
	XDP_RSS_L4_UDP = 32,
	XDP_RSS_L4_SCTP = 64,
	XDP_RSS_L4_IPSEC = 128,
	XDP_RSS_TYPE_NONE = 0,
	XDP_RSS_TYPE_L2 = 0,
	XDP_RSS_TYPE_L3_IPV4 = 1,
	XDP_RSS_TYPE_L3_IPV6 = 2,
	XDP_RSS_TYPE_L3_IPV4_OPT = 5,
	XDP_RSS_TYPE_L3_IPV6_EX = 6,
	XDP_RSS_TYPE_L4_ANY = 8,
	XDP_RSS_TYPE_L4_IPV4_TCP = 25,
	XDP_RSS_TYPE_L4_IPV4_UDP = 41,
	XDP_RSS_TYPE_L4_IPV4_SCTP = 73,
	XDP_RSS_TYPE_L4_IPV4_IPSEC = 137,
	XDP_RSS_TYPE_L4_IPV6_TCP = 26,
	XDP_RSS_TYPE_L4_IPV6_UDP = 42,
	XDP_RSS_TYPE_L4_IPV6_SCTP = 74,
	XDP_RSS_TYPE_L4_IPV6_IPSEC = 138,
	XDP_RSS_TYPE_L4_IPV6_TCP_EX = 30,
	XDP_RSS_TYPE_L4_IPV6_UDP_EX = 46,
	XDP_RSS_TYPE_L4_IPV6_SCTP_EX = 78,
};

struct xdp_metadata_ops {
	int (*xmo_rx_timestamp)(const struct xdp_md *, u64 *);
	int (*xmo_rx_hash)(const struct xdp_md *, u32 *, enum xdp_rss_hash_type *);
};

enum ethtool_phys_id_state {
	ETHTOOL_ID_INACTIVE = 0,
	ETHTOOL_ID_ACTIVE = 1,
	ETHTOOL_ID_ON = 2,
	ETHTOOL_ID_OFF = 3,
};

struct ethtool_drvinfo;

struct ethtool_regs;

struct ethtool_wolinfo;

struct ethtool_link_ext_state_info;

struct ethtool_link_ext_stats;

struct ethtool_eeprom;

struct ethtool_coalesce;

struct kernel_ethtool_coalesce;

struct ethtool_ringparam;

struct kernel_ethtool_ringparam;

struct ethtool_pause_stats;

struct ethtool_pauseparam;

struct ethtool_test;

struct ethtool_stats;

struct ethtool_rxnfc;

struct ethtool_flash;

struct ethtool_channels;

struct ethtool_dump;

struct ethtool_ts_info;

struct ethtool_modinfo;

struct ethtool_eee;

struct ethtool_tunable;

struct ethtool_link_ksettings;

struct ethtool_fec_stats;

struct ethtool_fecparam;

struct ethtool_module_eeprom;

struct ethtool_eth_phy_stats;

struct ethtool_eth_mac_stats;

struct ethtool_eth_ctrl_stats;

struct ethtool_rmon_stats;

struct ethtool_rmon_hist_range;

struct ethtool_module_power_mode_params;

struct ethtool_mm_state;

struct ethtool_mm_cfg;

struct ethtool_mm_stats;

struct ethtool_ops {
	u32 cap_link_lanes_supported: 1;
	u32 supported_coalesce_params;
	u32 supported_ring_params;
	void (*get_drvinfo)(struct net_device *, struct ethtool_drvinfo *);
	int (*get_regs_len)(struct net_device *);
	void (*get_regs)(struct net_device *, struct ethtool_regs *, void *);
	void (*get_wol)(struct net_device *, struct ethtool_wolinfo *);
	int (*set_wol)(struct net_device *, struct ethtool_wolinfo *);
	u32 (*get_msglevel)(struct net_device *);
	void (*set_msglevel)(struct net_device *, u32);
	int (*nway_reset)(struct net_device *);
	u32 (*get_link)(struct net_device *);
	int (*get_link_ext_state)(struct net_device *, struct ethtool_link_ext_state_info *);
	void (*get_link_ext_stats)(struct net_device *, struct ethtool_link_ext_stats *);
	int (*get_eeprom_len)(struct net_device *);
	int (*get_eeprom)(struct net_device *, struct ethtool_eeprom *, u8 *);
	int (*set_eeprom)(struct net_device *, struct ethtool_eeprom *, u8 *);
	int (*get_coalesce)(struct net_device *, struct ethtool_coalesce *, struct kernel_ethtool_coalesce *, struct netlink_ext_ack *);
	int (*set_coalesce)(struct net_device *, struct ethtool_coalesce *, struct kernel_ethtool_coalesce *, struct netlink_ext_ack *);
	void (*get_ringparam)(struct net_device *, struct ethtool_ringparam *, struct kernel_ethtool_ringparam *, struct netlink_ext_ack *);
	int (*set_ringparam)(struct net_device *, struct ethtool_ringparam *, struct kernel_ethtool_ringparam *, struct netlink_ext_ack *);
	void (*get_pause_stats)(struct net_device *, struct ethtool_pause_stats *);
	void (*get_pauseparam)(struct net_device *, struct ethtool_pauseparam *);
	int (*set_pauseparam)(struct net_device *, struct ethtool_pauseparam *);
	void (*self_test)(struct net_device *, struct ethtool_test *, u64 *);
	void (*get_strings)(struct net_device *, u32, u8 *);
	int (*set_phys_id)(struct net_device *, enum ethtool_phys_id_state);
	void (*get_ethtool_stats)(struct net_device *, struct ethtool_stats *, u64 *);
	int (*begin)(struct net_device *);
	void (*complete)(struct net_device *);
	u32 (*get_priv_flags)(struct net_device *);
	int (*set_priv_flags)(struct net_device *, u32);
	int (*get_sset_count)(struct net_device *, int);
	int (*get_rxnfc)(struct net_device *, struct ethtool_rxnfc *, u32 *);
	int (*set_rxnfc)(struct net_device *, struct ethtool_rxnfc *);
	int (*flash_device)(struct net_device *, struct ethtool_flash *);
	int (*reset)(struct net_device *, u32 *);
	u32 (*get_rxfh_key_size)(struct net_device *);
	u32 (*get_rxfh_indir_size)(struct net_device *);
	int (*get_rxfh)(struct net_device *, u32 *, u8 *, u8 *);
	int (*set_rxfh)(struct net_device *, const u32 *, const u8 *, const u8);
	int (*get_rxfh_context)(struct net_device *, u32 *, u8 *, u8 *, u32);
	int (*set_rxfh_context)(struct net_device *, const u32 *, const u8 *, const u8, u32 *, bool);
	void (*get_channels)(struct net_device *, struct ethtool_channels *);
	int (*set_channels)(struct net_device *, struct ethtool_channels *);
	int (*get_dump_flag)(struct net_device *, struct ethtool_dump *);
	int (*get_dump_data)(struct net_device *, struct ethtool_dump *, void *);
	int (*set_dump)(struct net_device *, struct ethtool_dump *);
	int (*get_ts_info)(struct net_device *, struct ethtool_ts_info *);
	int (*get_module_info)(struct net_device *, struct ethtool_modinfo *);
	int (*get_module_eeprom)(struct net_device *, struct ethtool_eeprom *, u8 *);
	int (*get_eee)(struct net_device *, struct ethtool_eee *);
	int (*set_eee)(struct net_device *, struct ethtool_eee *);
	int (*get_tunable)(struct net_device *, const struct ethtool_tunable *, void *);
	int (*set_tunable)(struct net_device *, const struct ethtool_tunable *, const void *);
	int (*get_per_queue_coalesce)(struct net_device *, u32, struct ethtool_coalesce *);
	int (*set_per_queue_coalesce)(struct net_device *, u32, struct ethtool_coalesce *);
	int (*get_link_ksettings)(struct net_device *, struct ethtool_link_ksettings *);
	int (*set_link_ksettings)(struct net_device *, const struct ethtool_link_ksettings *);
	void (*get_fec_stats)(struct net_device *, struct ethtool_fec_stats *);
	int (*get_fecparam)(struct net_device *, struct ethtool_fecparam *);
	int (*set_fecparam)(struct net_device *, struct ethtool_fecparam *);
	void (*get_ethtool_phy_stats)(struct net_device *, struct ethtool_stats *, u64 *);
	int (*get_phy_tunable)(struct net_device *, const struct ethtool_tunable *, void *);
	int (*set_phy_tunable)(struct net_device *, const struct ethtool_tunable *, const void *);
	int (*get_module_eeprom_by_page)(struct net_device *, const struct ethtool_module_eeprom *, struct netlink_ext_ack *);
	void (*get_eth_phy_stats)(struct net_device *, struct ethtool_eth_phy_stats *);
	void (*get_eth_mac_stats)(struct net_device *, struct ethtool_eth_mac_stats *);
	void (*get_eth_ctrl_stats)(struct net_device *, struct ethtool_eth_ctrl_stats *);
	void (*get_rmon_stats)(struct net_device *, struct ethtool_rmon_stats *, const struct ethtool_rmon_hist_range **);
	int (*get_module_power_mode)(struct net_device *, struct ethtool_module_power_mode_params *, struct netlink_ext_ack *);
	int (*set_module_power_mode)(struct net_device *, const struct ethtool_module_power_mode_params *, struct netlink_ext_ack *);
	int (*get_mm)(struct net_device *, struct ethtool_mm_state *);
	int (*set_mm)(struct net_device *, struct ethtool_mm_cfg *, struct netlink_ext_ack *);
	void (*get_mm_stats)(struct net_device *, struct ethtool_mm_stats *);
};

struct nd_opt_hdr;

struct ndisc_options;

struct prefix_info;

struct ndisc_ops {
	int (*is_useropt)(u8);
	int (*parse_options)(const struct net_device *, struct nd_opt_hdr *, struct ndisc_options *);
	void (*update)(const struct net_device *, struct neighbour *, u32, u8, const struct ndisc_options *);
	int (*opt_addr_space)(const struct net_device *, u8, struct neighbour *, u8 *, u8 **);
	void (*fill_addr_option)(const struct net_device *, struct sk_buff *, u8, const u8 *);
	void (*prefix_rcv_add_addr)(struct net *, struct net_device *, const struct prefix_info *, struct inet6_dev *, struct in6_addr *, int, u32, bool, bool, __u32, u32, bool);
};

struct bpf_mprog_fp {
	struct bpf_prog *prog;
};

struct bpf_mprog_bundle;

struct bpf_mprog_entry {
	struct bpf_mprog_fp fp_items[64];
	struct bpf_mprog_bundle *parent;
};

struct rtnl_link_ops {
	struct list_head list;
	const char *kind;
	size_t priv_size;
	struct net_device * (*alloc)(struct nlattr **, const char *, unsigned char, unsigned int, unsigned int);
	void (*setup)(struct net_device *);
	bool netns_refund;
	unsigned int maxtype;
	const struct nla_policy *policy;
	int (*validate)(struct nlattr **, struct nlattr **, struct netlink_ext_ack *);
	int (*newlink)(struct net *, struct net_device *, struct nlattr **, struct nlattr **, struct netlink_ext_ack *);
	int (*changelink)(struct net_device *, struct nlattr **, struct nlattr **, struct netlink_ext_ack *);
	void (*dellink)(struct net_device *, struct list_head *);
	size_t (*get_size)(const struct net_device *);
	int (*fill_info)(struct sk_buff *, const struct net_device *);
	size_t (*get_xstats_size)(const struct net_device *);
	int (*fill_xstats)(struct sk_buff *, const struct net_device *);
	unsigned int (*get_num_tx_queues)();
	unsigned int (*get_num_rx_queues)();
	unsigned int slave_maxtype;
	const struct nla_policy *slave_policy;
	int (*slave_changelink)(struct net_device *, struct net_device *, struct nlattr **, struct nlattr **, struct netlink_ext_ack *);
	size_t (*get_slave_size)(const struct net_device *, const struct net_device *);
	int (*fill_slave_info)(struct sk_buff *, const struct net_device *, const struct net_device *);
	struct net * (*get_link_net)(const struct net_device *);
	size_t (*get_linkxstats_size)(const struct net_device *, int);
	int (*fill_linkxstats)(struct sk_buff *, const struct net_device *, int *, int);
};

struct udp_tunnel_nic_table_info {
	unsigned int n_entries;
	unsigned int tunnel_types;
};

struct udp_tunnel_info;

struct udp_tunnel_nic_shared;

struct udp_tunnel_nic_info {
	int (*set_port)(struct net_device *, unsigned int, unsigned int, struct udp_tunnel_info *);
	int (*unset_port)(struct net_device *, unsigned int, unsigned int, struct udp_tunnel_info *);
	int (*sync_table)(struct net_device *, unsigned int);
	struct udp_tunnel_nic_shared *shared;
	unsigned int flags;
	struct udp_tunnel_nic_table_info tables[4];
};

struct tcmsg {
	unsigned char tcm_family;
	unsigned char tcm__pad1;
	short unsigned int tcm__pad2;
	int tcm_ifindex;
	__u32 tcm_handle;
	__u32 tcm_parent;
	__u32 tcm_info;
};

struct netlink_range_validation {
	u64 min;
	u64 max;
};

struct netlink_range_validation_signed {
	s64 min;
	s64 max;
};

struct pneigh_entry;

struct neigh_statistics;

struct neigh_hash_table;

struct neigh_table {
	int family;
	unsigned int entry_size;
	unsigned int key_len;
	__be16 protocol;
	__u32 (*hash)(const void *, const struct net_device *, __u32 *);
	bool (*key_eq)(const struct neighbour *, const void *);
	int (*constructor)(struct neighbour *);
	int (*pconstructor)(struct pneigh_entry *);
	void (*pdestructor)(struct pneigh_entry *);
	void (*proxy_redo)(struct sk_buff *);
	int (*is_multicast)(const void *);
	bool (*allow_add)(const struct net_device *, struct netlink_ext_ack *);
	char *id;
	struct neigh_parms parms;
	struct list_head parms_list;
	int gc_interval;
	int gc_thresh1;
	int gc_thresh2;
	int gc_thresh3;
	long unsigned int last_flush;
	struct delayed_work gc_work;
	struct delayed_work managed_work;
	struct timer_list proxy_timer;
	struct sk_buff_head proxy_queue;
	atomic_t entries;
	atomic_t gc_entries;
	struct list_head gc_list;
	struct list_head managed_list;
	rwlock_t lock;
	long unsigned int last_rand;
	struct neigh_statistics *stats;
	struct neigh_hash_table *nht;
	struct pneigh_entry **phash_buckets;
};

struct neigh_statistics {
	long unsigned int allocs;
	long unsigned int destroys;
	long unsigned int hash_grows;
	long unsigned int res_failed;
	long unsigned int lookups;
	long unsigned int hits;
	long unsigned int rcv_probes_mcast;
	long unsigned int rcv_probes_ucast;
	long unsigned int periodic_gc_runs;
	long unsigned int forced_gc_runs;
	long unsigned int unres_discards;
	long unsigned int table_fulls;
};

struct neigh_ops {
	int family;
	void (*solicit)(struct neighbour *, struct sk_buff *);
	void (*error_report)(struct neighbour *, struct sk_buff *);
	int (*output)(struct neighbour *, struct sk_buff *);
	int (*connected_output)(struct neighbour *, struct sk_buff *);
};

struct pneigh_entry {
	struct pneigh_entry *next;
	possible_net_t net;
	struct net_device *dev;
	netdevice_tracker dev_tracker;
	u32 flags;
	u8 protocol;
	u32 key[0];
};

struct neigh_hash_table {
	struct neighbour **hash_buckets;
	unsigned int hash_shift;
	__u32 hash_rnd[4];
	struct callback_head rcu;
};

struct smc_hashinfo;

struct sk_psock;

struct request_sock_ops;

struct timewait_sock_ops;

struct raw_hashinfo;

struct proto {
	void (*close)(struct sock *, long int);
	int (*pre_connect)(struct sock *, struct sockaddr *, int);
	int (*connect)(struct sock *, struct sockaddr *, int);
	int (*disconnect)(struct sock *, int);
	struct sock * (*accept)(struct sock *, int, int *, bool);
	int (*ioctl)(struct sock *, int, int *);
	int (*init)(struct sock *);
	void (*destroy)(struct sock *);
	void (*shutdown)(struct sock *, int);
	int (*setsockopt)(struct sock *, int, int, sockptr_t, unsigned int);
	int (*getsockopt)(struct sock *, int, int, char *, int *);
	void (*keepalive)(struct sock *, int);
	int (*sendmsg)(struct sock *, struct msghdr *, size_t);
	int (*recvmsg)(struct sock *, struct msghdr *, size_t, int, int *);
	void (*splice_eof)(struct socket *);
	int (*bind)(struct sock *, struct sockaddr *, int);
	int (*bind_add)(struct sock *, struct sockaddr *, int);
	int (*backlog_rcv)(struct sock *, struct sk_buff *);
	bool (*bpf_bypass_getsockopt)(int, int);
	void (*release_cb)(struct sock *);
	int (*hash)(struct sock *);
	void (*unhash)(struct sock *);
	void (*rehash)(struct sock *);
	int (*get_port)(struct sock *, short unsigned int);
	void (*put_port)(struct sock *);
	int (*psock_update_sk_prot)(struct sock *, struct sk_psock *, bool);
	unsigned int inuse_idx;
	bool (*stream_memory_free)(const struct sock *, int);
	bool (*sock_is_readable)(struct sock *);
	void (*enter_memory_pressure)(struct sock *);
	void (*leave_memory_pressure)(struct sock *);
	atomic_long_t *memory_allocated;
	int *per_cpu_fw_alloc;
	struct percpu_counter *sockets_allocated;
	long unsigned int *memory_pressure;
	long int *sysctl_mem;
	int *sysctl_wmem;
	int *sysctl_rmem;
	u32 sysctl_wmem_offset;
	u32 sysctl_rmem_offset;
	int max_header;
	bool no_autobind;
	struct kmem_cache *slab;
	unsigned int obj_size;
	unsigned int ipv6_pinfo_offset;
	slab_flags_t slab_flags;
	unsigned int useroffset;
	unsigned int usersize;
	unsigned int *orphan_count;
	struct request_sock_ops *rsk_prot;
	struct timewait_sock_ops *twsk_prot;
	union {
		struct inet_hashinfo *hashinfo;
		struct udp_table *udp_table;
		struct raw_hashinfo *raw_hash;
		struct smc_hashinfo *smc_hash;
	} h;
	struct module *owner;
	char name[32];
	struct list_head node;
	int (*diag_destroy)(struct sock *, int);
};

struct sk_filter {
	refcount_t refcnt;
	struct callback_head rcu;
	struct bpf_prog *prog;
};

struct bpf_storage_buffer {
	struct callback_head rcu;
	char data[0];
};

struct gnet_dump {
	spinlock_t *lock;
	struct sk_buff *skb;
	struct nlattr *tail;
	int compat_tc_stats;
	int compat_xstats;
	int padattr;
	void *xstats;
	int xstats_len;
	struct tc_stats tc_stats;
};

enum flow_action_hw_stats_bit {
	FLOW_ACTION_HW_STATS_IMMEDIATE_BIT = 0,
	FLOW_ACTION_HW_STATS_DELAYED_BIT = 1,
	FLOW_ACTION_HW_STATS_DISABLED_BIT = 2,
	FLOW_ACTION_HW_STATS_NUM_BITS = 3,
};

struct flow_block {
	struct list_head cb_list;
};

typedef int flow_setup_cb_t(enum tc_setup_type, void *, void *);

struct qdisc_size_table {
	struct callback_head rcu;
	struct list_head list;
	struct tc_sizespec szopts;
	int refcnt;
	u16 data[0];
};

struct Qdisc_class_ops;

struct Qdisc_ops {
	struct Qdisc_ops *next;
	const struct Qdisc_class_ops *cl_ops;
	char id[16];
	int priv_size;
	unsigned int static_flags;
	int (*enqueue)(struct sk_buff *, struct Qdisc *, struct sk_buff **);
	struct sk_buff * (*dequeue)(struct Qdisc *);
	struct sk_buff * (*peek)(struct Qdisc *);
	int (*init)(struct Qdisc *, struct nlattr *, struct netlink_ext_ack *);
	void (*reset)(struct Qdisc *);
	void (*destroy)(struct Qdisc *);
	int (*change)(struct Qdisc *, struct nlattr *, struct netlink_ext_ack *);
	void (*attach)(struct Qdisc *);
	int (*change_tx_queue_len)(struct Qdisc *, unsigned int);
	void (*change_real_num_tx)(struct Qdisc *, unsigned int);
	int (*dump)(struct Qdisc *, struct sk_buff *);
	int (*dump_stats)(struct Qdisc *, struct gnet_dump *);
	void (*ingress_block_set)(struct Qdisc *, u32);
	void (*egress_block_set)(struct Qdisc *, u32);
	u32 (*ingress_block_get)(struct Qdisc *);
	u32 (*egress_block_get)(struct Qdisc *);
	struct module *owner;
};

struct qdisc_walker;

struct tcf_block;

struct Qdisc_class_ops {
	unsigned int flags;
	struct netdev_queue * (*select_queue)(struct Qdisc *, struct tcmsg *);
	int (*graft)(struct Qdisc *, long unsigned int, struct Qdisc *, struct Qdisc **, struct netlink_ext_ack *);
	struct Qdisc * (*leaf)(struct Qdisc *, long unsigned int);
	void (*qlen_notify)(struct Qdisc *, long unsigned int);
	long unsigned int (*find)(struct Qdisc *, u32);
	int (*change)(struct Qdisc *, u32, u32, struct nlattr **, long unsigned int *, struct netlink_ext_ack *);
	int (*delete)(struct Qdisc *, long unsigned int, struct netlink_ext_ack *);
	void (*walk)(struct Qdisc *, struct qdisc_walker *);
	struct tcf_block * (*tcf_block)(struct Qdisc *, long unsigned int, struct netlink_ext_ack *);
	long unsigned int (*bind_tcf)(struct Qdisc *, long unsigned int, u32);
	void (*unbind_tcf)(struct Qdisc *, long unsigned int);
	int (*dump)(struct Qdisc *, long unsigned int, struct sk_buff *, struct tcmsg *);
	int (*dump_stats)(struct Qdisc *, long unsigned int, struct gnet_dump *);
};

struct tcf_chain;

struct tcf_block {
	struct mutex lock;
	struct list_head chain_list;
	u32 index;
	u32 classid;
	refcount_t refcnt;
	struct net *net;
	struct Qdisc *q;
	struct rw_semaphore cb_lock;
	struct flow_block flow_block;
	struct list_head owner_list;
	bool keep_dst;
	atomic_t offloadcnt;
	unsigned int nooffloaddevcnt;
	unsigned int lockeddevcnt;
	struct {
		struct tcf_chain *chain;
		struct list_head filter_chain_list;
	} chain0;
	struct callback_head rcu;
	struct hlist_head proto_destroy_ht[128];
	struct mutex proto_destroy_lock;
};

struct tcf_result;

struct tcf_proto_ops;

struct tcf_proto {
	struct tcf_proto *next;
	void *root;
	int (*classify)(struct sk_buff *, const struct tcf_proto *, struct tcf_result *);
	__be16 protocol;
	u32 prio;
	void *data;
	const struct tcf_proto_ops *ops;
	struct tcf_chain *chain;
	spinlock_t lock;
	bool deleting;
	refcount_t refcnt;
	struct callback_head rcu;
	struct hlist_node destroy_ht_node;
};

struct tcf_result {
	union {
		struct {
			long unsigned int class;
			u32 classid;
		};
		const struct tcf_proto *goto_tp;
	};
};

struct tcf_walker;

struct tcf_exts;

struct tcf_proto_ops {
	struct list_head head;
	char kind[16];
	int (*classify)(struct sk_buff *, const struct tcf_proto *, struct tcf_result *);
	int (*init)(struct tcf_proto *);
	void (*destroy)(struct tcf_proto *, bool, struct netlink_ext_ack *);
	void * (*get)(struct tcf_proto *, u32);
	void (*put)(struct tcf_proto *, void *);
	int (*change)(struct net *, struct sk_buff *, struct tcf_proto *, long unsigned int, u32, struct nlattr **, void **, u32, struct netlink_ext_ack *);
	int (*delete)(struct tcf_proto *, void *, bool *, bool, struct netlink_ext_ack *);
	bool (*delete_empty)(struct tcf_proto *);
	void (*walk)(struct tcf_proto *, struct tcf_walker *, bool);
	int (*reoffload)(struct tcf_proto *, bool, flow_setup_cb_t *, void *, struct netlink_ext_ack *);
	void (*hw_add)(struct tcf_proto *, void *);
	void (*hw_del)(struct tcf_proto *, void *);
	void (*bind_class)(void *, u32, long unsigned int, void *, long unsigned int);
	void * (*tmplt_create)(struct net *, struct tcf_chain *, struct nlattr **, struct netlink_ext_ack *);
	void (*tmplt_destroy)(void *);
	struct tcf_exts * (*get_exts)(const struct tcf_proto *, u32);
	int (*dump)(struct net *, struct tcf_proto *, void *, struct sk_buff *, struct tcmsg *, bool);
	int (*terse_dump)(struct net *, struct tcf_proto *, void *, struct sk_buff *, struct tcmsg *, bool);
	int (*tmplt_dump)(struct sk_buff *, struct net *, void *);
	struct module *owner;
	int flags;
};

struct tcf_chain {
	struct mutex filter_chain_lock;
	struct tcf_proto *filter_chain;
	struct list_head list;
	struct tcf_block *block;
	u32 index;
	unsigned int refcnt;
	unsigned int action_refcnt;
	bool explicitly_created;
	bool flushing;
	const struct tcf_proto_ops *tmplt_ops;
	void *tmplt_priv;
	struct callback_head rcu;
};

typedef unsigned int (*bpf_dispatcher_fn)(const void *, const struct bpf_insn *, unsigned int (*)(const void *, const struct bpf_insn *));

struct xdp_rxq_info {
	struct net_device *dev;
	u32 queue_index;
	u32 reg_state;
	struct xdp_mem_info mem;
	unsigned int napi_id;
	u32 frag_size;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct xdp_txq_info {
	struct net_device *dev;
};

struct rhash_lock_head {};

struct bpf_active_lock {
	void *ptr;
	u32 id;
};

struct bpf_stack_state {
	struct bpf_reg_state spilled_ptr;
	u8 slot_type[8];
};

struct bpf_reference_state {
	int id;
	int insn_idx;
	int callback_ref;
};

struct bpf_idx_pair {
	u32 prev_idx;
	u32 idx;
};

struct bpf_verifier_state {
	struct bpf_func_state *frame[8];
	struct bpf_verifier_state *parent;
	u32 branches;
	u32 insn_idx;
	u32 curframe;
	struct bpf_active_lock active_lock;
	bool speculative;
	bool active_rcu_lock;
	u32 first_insn_idx;
	u32 last_insn_idx;
	struct bpf_idx_pair *jmp_history;
	u32 jmp_history_cnt;
};

struct bpf_verifier_state_list {
	struct bpf_verifier_state state;
	struct bpf_verifier_state_list *next;
	int miss_cnt;
	int hit_cnt;
};

struct bpf_loop_inline_state {
	unsigned int initialized: 1;
	unsigned int fit_for_inline: 1;
	u32 callback_subprogno;
};

struct bpf_insn_aux_data {
	union {
		enum bpf_reg_type ptr_type;
		long unsigned int map_ptr_state;
		s32 call_imm;
		u32 alu_limit;
		struct {
			u32 map_index;
			u32 map_off;
		};
		struct {
			enum bpf_reg_type reg_type;
			union {
				struct {
					struct btf *btf;
					u32 btf_id;
				};
				u32 mem_size;
			};
		} btf_var;
		struct bpf_loop_inline_state loop_inline_state;
	};
	union {
		u64 obj_new_size;
		u64 insert_off;
	};
	struct btf_struct_meta *kptr_struct_meta;
	u64 map_key_state;
	int ctx_field_size;
	u32 seen;
	bool sanitize_stack_spill;
	bool zext_dst;
	bool storage_get_func_atomic;
	bool is_iter_next;
	u8 alu_state;
	unsigned int orig_idx;
	bool jmp_point;
	bool prune_point;
	bool force_checkpoint;
};

enum perf_bpf_event_type {
	PERF_BPF_EVENT_UNKNOWN = 0,
	PERF_BPF_EVENT_PROG_LOAD = 1,
	PERF_BPF_EVENT_PROG_UNLOAD = 2,
	PERF_BPF_EVENT_MAX = 3,
};

struct bpf_mprog_cp {
	struct bpf_link *link;
};

struct bpf_mprog_bundle {
	struct bpf_mprog_entry a;
	struct bpf_mprog_entry b;
	struct bpf_mprog_cp cp_items[64];
	struct bpf_prog *ref;
	atomic64_t revision;
	u32 count;
};

enum bpf_audit {
	BPF_AUDIT_LOAD = 0,
	BPF_AUDIT_UNLOAD = 1,
	BPF_AUDIT_MAX = 2,
};

struct bpf_prog_kstats {
	u64 nsecs;
	u64 cnt;
	u64 misses;
};

struct bpf_raw_tp_link {
	struct bpf_link link;
	struct bpf_raw_event_map *btp;
};

struct bpf_perf_link {
	struct bpf_link link;
	struct file *perf_file;
};

typedef u64 (*btf_bpf_sys_bpf)(int, union bpf_attr *, u32);

typedef u64 (*btf_bpf_sys_close)(u32);

typedef u64 (*btf_bpf_kallsyms_lookup_name)(const char *, int, int, u64 *);

struct bpf_lpm_trie_key {
	__u32 prefixlen;
	__u8 data[0];
};

enum {
	BTF_KIND_UNKN = 0,
	BTF_KIND_INT = 1,
	BTF_KIND_PTR = 2,
	BTF_KIND_ARRAY = 3,
	BTF_KIND_STRUCT = 4,
	BTF_KIND_UNION = 5,
	BTF_KIND_ENUM = 6,
	BTF_KIND_FWD = 7,
	BTF_KIND_TYPEDEF = 8,
	BTF_KIND_VOLATILE = 9,
	BTF_KIND_CONST = 10,
	BTF_KIND_RESTRICT = 11,
	BTF_KIND_FUNC = 12,
	BTF_KIND_FUNC_PROTO = 13,
	BTF_KIND_VAR = 14,
	BTF_KIND_DATASEC = 15,
	BTF_KIND_FLOAT = 16,
	BTF_KIND_DECL_TAG = 17,
	BTF_KIND_TYPE_TAG = 18,
	BTF_KIND_ENUM64 = 19,
	NR_BTF_KINDS = 20,
	BTF_KIND_MAX = 19,
};

struct ipv6_stable_secret {
	bool initialized;
	struct in6_addr secret;
};

struct ipv6_devconf {
	__s32 forwarding;
	__s32 hop_limit;
	__s32 mtu6;
	__s32 accept_ra;
	__s32 accept_redirects;
	__s32 autoconf;
	__s32 dad_transmits;
	__s32 rtr_solicits;
	__s32 rtr_solicit_interval;
	__s32 rtr_solicit_max_interval;
	__s32 rtr_solicit_delay;
	__s32 force_mld_version;
	__s32 mldv1_unsolicited_report_interval;
	__s32 mldv2_unsolicited_report_interval;
	__s32 use_tempaddr;
	__s32 temp_valid_lft;
	__s32 temp_prefered_lft;
	__s32 regen_max_retry;
	__s32 max_desync_factor;
	__s32 max_addresses;
	__s32 accept_ra_defrtr;
	__u32 ra_defrtr_metric;
	__s32 accept_ra_min_hop_limit;
	__s32 accept_ra_min_lft;
	__s32 accept_ra_pinfo;
	__s32 ignore_routes_with_linkdown;
	__s32 proxy_ndp;
	__s32 accept_source_route;
	__s32 accept_ra_from_local;
	__s32 disable_ipv6;
	__s32 drop_unicast_in_l2_multicast;
	__s32 accept_dad;
	__s32 force_tllao;
	__s32 ndisc_notify;
	__s32 suppress_frag_ndisc;
	__s32 accept_ra_mtu;
	__s32 drop_unsolicited_na;
	__s32 accept_untracked_na;
	struct ipv6_stable_secret stable_secret;
	__s32 use_oif_addrs_only;
	__s32 keep_addr_on_down;
	__s32 seg6_enabled;
	__u32 enhanced_dad;
	__u32 addr_gen_mode;
	__s32 disable_policy;
	__s32 ndisc_tclass;
	__s32 rpl_seg_enabled;
	__u32 ioam6_id;
	__u32 ioam6_id_wide;
	__u8 ioam6_enabled;
	__u8 ndisc_evict_nocarrier;
	struct ctl_table_header *sysctl_header;
};

struct icmpv6_mib_device {
	atomic_long_t mibs[7];
};

struct icmpv6msg_mib_device {
	atomic_long_t mibs[512];
};

enum {
	NAPI_STATE_SCHED = 0,
	NAPI_STATE_MISSED = 1,
	NAPI_STATE_DISABLE = 2,
	NAPI_STATE_NPSVC = 3,
	NAPI_STATE_LISTED = 4,
	NAPI_STATE_NO_BUSY_POLL = 5,
	NAPI_STATE_IN_BUSY_POLL = 6,
	NAPI_STATE_PREFER_BUSY_POLL = 7,
	NAPI_STATE_THREADED = 8,
	NAPI_STATE_SCHED_THREADED = 9,
};

enum xps_map_type {
	XPS_CPUS = 0,
	XPS_RXQS = 1,
	XPS_MAPS_MAX = 2,
};

enum bpf_xdp_mode {
	XDP_MODE_SKB = 0,
	XDP_MODE_DRV = 1,
	XDP_MODE_HW = 2,
	__MAX_XDP_MODE = 3,
};

struct ipv6_devstat {
	struct proc_dir_entry *proc_dir_entry;
	struct ipstats_mib *ipv6;
	struct icmpv6_mib_device *icmpv6dev;
	struct icmpv6msg_mib_device *icmpv6msgdev;
};

struct ifmcaddr6;

struct ifacaddr6;

struct inet6_dev {
	struct net_device *dev;
	netdevice_tracker dev_tracker;
	struct list_head addr_list;
	struct ifmcaddr6 *mc_list;
	struct ifmcaddr6 *mc_tomb;
	unsigned char mc_qrv;
	unsigned char mc_gq_running;
	unsigned char mc_ifc_count;
	unsigned char mc_dad_count;
	long unsigned int mc_v1_seen;
	long unsigned int mc_qi;
	long unsigned int mc_qri;
	long unsigned int mc_maxdelay;
	struct delayed_work mc_gq_work;
	struct delayed_work mc_ifc_work;
	struct delayed_work mc_dad_work;
	struct delayed_work mc_query_work;
	struct delayed_work mc_report_work;
	struct sk_buff_head mc_query_queue;
	struct sk_buff_head mc_report_queue;
	spinlock_t mc_query_lock;
	spinlock_t mc_report_lock;
	struct mutex mc_lock;
	struct ifacaddr6 *ac_list;
	rwlock_t lock;
	refcount_t refcnt;
	__u32 if_flags;
	int dead;
	u32 desync_factor;
	struct list_head tempaddr_list;
	struct in6_addr token;
	struct neigh_parms *nd_parms;
	struct ipv6_devconf cnf;
	struct ipv6_devstat stats;
	struct timer_list rs_timer;
	__s32 rs_interval;
	__u8 rs_probes;
	long unsigned int tstamp;
	struct callback_head rcu;
	unsigned int ra_mtu;
};

enum {
	NETIF_MSG_DRV_BIT = 0,
	NETIF_MSG_PROBE_BIT = 1,
	NETIF_MSG_LINK_BIT = 2,
	NETIF_MSG_TIMER_BIT = 3,
	NETIF_MSG_IFDOWN_BIT = 4,
	NETIF_MSG_IFUP_BIT = 5,
	NETIF_MSG_RX_ERR_BIT = 6,
	NETIF_MSG_TX_ERR_BIT = 7,
	NETIF_MSG_TX_QUEUED_BIT = 8,
	NETIF_MSG_INTR_BIT = 9,
	NETIF_MSG_TX_DONE_BIT = 10,
	NETIF_MSG_RX_STATUS_BIT = 11,
	NETIF_MSG_PKTDATA_BIT = 12,
	NETIF_MSG_HW_BIT = 13,
	NETIF_MSG_WOL_BIT = 14,
	NETIF_MSG_CLASS_COUNT = 15,
};

enum {
	RTAX_UNSPEC = 0,
	RTAX_LOCK = 1,
	RTAX_MTU = 2,
	RTAX_WINDOW = 3,
	RTAX_RTT = 4,
	RTAX_RTTVAR = 5,
	RTAX_SSTHRESH = 6,
	RTAX_CWND = 7,
	RTAX_ADVMSS = 8,
	RTAX_REORDERING = 9,
	RTAX_HOPLIMIT = 10,
	RTAX_INITCWND = 11,
	RTAX_FEATURES = 12,
	RTAX_RTO_MIN = 13,
	RTAX_INITRWND = 14,
	RTAX_QUICKACK = 15,
	RTAX_CC_ALGO = 16,
	RTAX_FASTOPEN_NO_COOKIE = 17,
	__RTAX_MAX = 18,
};

enum {
	NEIGH_VAR_MCAST_PROBES = 0,
	NEIGH_VAR_UCAST_PROBES = 1,
	NEIGH_VAR_APP_PROBES = 2,
	NEIGH_VAR_MCAST_REPROBES = 3,
	NEIGH_VAR_RETRANS_TIME = 4,
	NEIGH_VAR_BASE_REACHABLE_TIME = 5,
	NEIGH_VAR_DELAY_PROBE_TIME = 6,
	NEIGH_VAR_INTERVAL_PROBE_TIME_MS = 7,
	NEIGH_VAR_GC_STALETIME = 8,
	NEIGH_VAR_QUEUE_LEN_BYTES = 9,
	NEIGH_VAR_PROXY_QLEN = 10,
	NEIGH_VAR_ANYCAST_DELAY = 11,
	NEIGH_VAR_PROXY_DELAY = 12,
	NEIGH_VAR_LOCKTIME = 13,
	NEIGH_VAR_QUEUE_LEN = 14,
	NEIGH_VAR_RETRANS_TIME_MS = 15,
	NEIGH_VAR_BASE_REACHABLE_TIME_MS = 16,
	NEIGH_VAR_GC_INTERVAL = 17,
	NEIGH_VAR_GC_THRESH1 = 18,
	NEIGH_VAR_GC_THRESH2 = 19,
	NEIGH_VAR_GC_THRESH3 = 20,
	NEIGH_VAR_MAX = 21,
};

enum {
	TCP_ESTABLISHED = 1,
	TCP_SYN_SENT = 2,
	TCP_SYN_RECV = 3,
	TCP_FIN_WAIT1 = 4,
	TCP_FIN_WAIT2 = 5,
	TCP_TIME_WAIT = 6,
	TCP_CLOSE = 7,
	TCP_CLOSE_WAIT = 8,
	TCP_LAST_ACK = 9,
	TCP_LISTEN = 10,
	TCP_CLOSING = 11,
	TCP_NEW_SYN_RECV = 12,
	TCP_MAX_STATES = 13,
};

struct request_sock;

struct request_sock_ops {
	int family;
	unsigned int obj_size;
	struct kmem_cache *slab;
	char *slab_name;
	int (*rtx_syn_ack)(const struct sock *, struct request_sock *);
	void (*send_ack)(const struct sock *, struct sk_buff *, struct request_sock *);
	void (*send_reset)(const struct sock *, struct sk_buff *);
	void (*destructor)(struct request_sock *);
	void (*syn_ack_timeout)(const struct request_sock *);
};

struct timewait_sock_ops {
	struct kmem_cache *twsk_slab;
	char *twsk_slab_name;
	unsigned int twsk_obj_size;
	int (*twsk_unique)(struct sock *, struct sock *, void *);
	void (*twsk_destructor)(struct sock *);
};

struct saved_syn;

struct request_sock {
	struct sock_common __req_common;
	struct request_sock *dl_next;
	u16 mss;
	u8 num_retrans;
	u8 syncookie: 1;
	u8 num_timeout: 7;
	u32 ts_recent;
	struct timer_list rsk_timer;
	const struct request_sock_ops *rsk_ops;
	struct sock *sk;
	struct saved_syn *saved_syn;
	u32 secid;
	u32 peer_secid;
	u32 timeout;
};

struct saved_syn {
	u32 mac_hdrlen;
	u32 network_hdrlen;
	u32 tcp_hdrlen;
	u8 data[0];
};

enum tsq_enum {
	TSQ_THROTTLED = 0,
	TSQ_QUEUED = 1,
	TCP_TSQ_DEFERRED = 2,
	TCP_WRITE_TIMER_DEFERRED = 3,
	TCP_DELACK_TIMER_DEFERRED = 4,
	TCP_MTU_REDUCED_DEFERRED = 5,
};

struct ip6_sf_list {
	struct ip6_sf_list *sf_next;
	struct in6_addr sf_addr;
	long unsigned int sf_count[2];
	unsigned char sf_gsresp;
	unsigned char sf_oldin;
	unsigned char sf_crcount;
	struct callback_head rcu;
};

struct ifmcaddr6 {
	struct in6_addr mca_addr;
	struct inet6_dev *idev;
	struct ifmcaddr6 *next;
	struct ip6_sf_list *mca_sources;
	struct ip6_sf_list *mca_tomb;
	unsigned int mca_sfmode;
	unsigned char mca_crcount;
	long unsigned int mca_sfcount[2];
	struct delayed_work mca_work;
	unsigned int mca_flags;
	int mca_users;
	refcount_t mca_refcnt;
	long unsigned int mca_cstamp;
	long unsigned int mca_tstamp;
	struct callback_head rcu;
};

struct ifacaddr6 {
	struct in6_addr aca_addr;
	struct fib6_info *aca_rt;
	struct ifacaddr6 *aca_next;
	struct hlist_node aca_addr_lst;
	int aca_users;
	refcount_t aca_refcnt;
	long unsigned int aca_cstamp;
	long unsigned int aca_tstamp;
	struct callback_head rcu;
};

struct lpm_trie_node {
	struct callback_head rcu;
	struct lpm_trie_node *child[2];
	u32 prefixlen;
	u32 flags;
	u8 data[0];
};

struct lpm_trie {
	struct bpf_map map;
	struct lpm_trie_node *root;
	size_t n_entries;
	size_t max_prefixlen;
	size_t data_size;
	spinlock_t lock;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct bpf_tuple {
	struct bpf_prog *prog;
	struct bpf_link *link;
};

enum {
	BPF_F_BROADCAST = 8,
	BPF_F_EXCLUDE_INGRESS = 16,
};

enum xdp_action {
	XDP_ABORTED = 0,
	XDP_DROP = 1,
	XDP_PASS = 2,
	XDP_TX = 3,
	XDP_REDIRECT = 4,
};

struct bpf_devmap_val {
	__u32 ifindex;
	union {
		int fd;
		__u32 id;
	} bpf_prog;
};

enum net_device_flags {
	IFF_UP = 1,
	IFF_BROADCAST = 2,
	IFF_DEBUG = 4,
	IFF_LOOPBACK = 8,
	IFF_POINTOPOINT = 16,
	IFF_NOTRAILERS = 32,
	IFF_RUNNING = 64,
	IFF_NOARP = 128,
	IFF_PROMISC = 256,
	IFF_ALLMULTI = 512,
	IFF_MASTER = 1024,
	IFF_SLAVE = 2048,
	IFF_MULTICAST = 4096,
	IFF_PORTSEL = 8192,
	IFF_AUTOMEDIA = 16384,
	IFF_DYNAMIC = 32768,
	IFF_LOWER_UP = 65536,
	IFF_DORMANT = 131072,
	IFF_ECHO = 262144,
};

enum skb_drop_reason {
	SKB_NOT_DROPPED_YET = 0,
	SKB_CONSUMED = 1,
	SKB_DROP_REASON_NOT_SPECIFIED = 2,
	SKB_DROP_REASON_NO_SOCKET = 3,
	SKB_DROP_REASON_PKT_TOO_SMALL = 4,
	SKB_DROP_REASON_TCP_CSUM = 5,
	SKB_DROP_REASON_SOCKET_FILTER = 6,
	SKB_DROP_REASON_UDP_CSUM = 7,
	SKB_DROP_REASON_NETFILTER_DROP = 8,
	SKB_DROP_REASON_OTHERHOST = 9,
	SKB_DROP_REASON_IP_CSUM = 10,
	SKB_DROP_REASON_IP_INHDR = 11,
	SKB_DROP_REASON_IP_RPFILTER = 12,
	SKB_DROP_REASON_UNICAST_IN_L2_MULTICAST = 13,
	SKB_DROP_REASON_XFRM_POLICY = 14,
	SKB_DROP_REASON_IP_NOPROTO = 15,
	SKB_DROP_REASON_SOCKET_RCVBUFF = 16,
	SKB_DROP_REASON_PROTO_MEM = 17,
	SKB_DROP_REASON_TCP_MD5NOTFOUND = 18,
	SKB_DROP_REASON_TCP_MD5UNEXPECTED = 19,
	SKB_DROP_REASON_TCP_MD5FAILURE = 20,
	SKB_DROP_REASON_SOCKET_BACKLOG = 21,
	SKB_DROP_REASON_TCP_FLAGS = 22,
	SKB_DROP_REASON_TCP_ZEROWINDOW = 23,
	SKB_DROP_REASON_TCP_OLD_DATA = 24,
	SKB_DROP_REASON_TCP_OVERWINDOW = 25,
	SKB_DROP_REASON_TCP_OFOMERGE = 26,
	SKB_DROP_REASON_TCP_RFC7323_PAWS = 27,
	SKB_DROP_REASON_TCP_OLD_SEQUENCE = 28,
	SKB_DROP_REASON_TCP_INVALID_SEQUENCE = 29,
	SKB_DROP_REASON_TCP_RESET = 30,
	SKB_DROP_REASON_TCP_INVALID_SYN = 31,
	SKB_DROP_REASON_TCP_CLOSE = 32,
	SKB_DROP_REASON_TCP_FASTOPEN = 33,
	SKB_DROP_REASON_TCP_OLD_ACK = 34,
	SKB_DROP_REASON_TCP_TOO_OLD_ACK = 35,
	SKB_DROP_REASON_TCP_ACK_UNSENT_DATA = 36,
	SKB_DROP_REASON_TCP_OFO_QUEUE_PRUNE = 37,
	SKB_DROP_REASON_TCP_OFO_DROP = 38,
	SKB_DROP_REASON_IP_OUTNOROUTES = 39,
	SKB_DROP_REASON_BPF_CGROUP_EGRESS = 40,
	SKB_DROP_REASON_IPV6DISABLED = 41,
	SKB_DROP_REASON_NEIGH_CREATEFAIL = 42,
	SKB_DROP_REASON_NEIGH_FAILED = 43,
	SKB_DROP_REASON_NEIGH_QUEUEFULL = 44,
	SKB_DROP_REASON_NEIGH_DEAD = 45,
	SKB_DROP_REASON_TC_EGRESS = 46,
	SKB_DROP_REASON_QDISC_DROP = 47,
	SKB_DROP_REASON_CPU_BACKLOG = 48,
	SKB_DROP_REASON_XDP = 49,
	SKB_DROP_REASON_TC_INGRESS = 50,
	SKB_DROP_REASON_UNHANDLED_PROTO = 51,
	SKB_DROP_REASON_SKB_CSUM = 52,
	SKB_DROP_REASON_SKB_GSO_SEG = 53,
	SKB_DROP_REASON_SKB_UCOPY_FAULT = 54,
	SKB_DROP_REASON_DEV_HDR = 55,
	SKB_DROP_REASON_DEV_READY = 56,
	SKB_DROP_REASON_FULL_RING = 57,
	SKB_DROP_REASON_NOMEM = 58,
	SKB_DROP_REASON_HDR_TRUNC = 59,
	SKB_DROP_REASON_TAP_FILTER = 60,
	SKB_DROP_REASON_TAP_TXFILTER = 61,
	SKB_DROP_REASON_ICMP_CSUM = 62,
	SKB_DROP_REASON_INVALID_PROTO = 63,
	SKB_DROP_REASON_IP_INADDRERRORS = 64,
	SKB_DROP_REASON_IP_INNOROUTES = 65,
	SKB_DROP_REASON_PKT_TOO_BIG = 66,
	SKB_DROP_REASON_DUP_FRAG = 67,
	SKB_DROP_REASON_FRAG_REASM_TIMEOUT = 68,
	SKB_DROP_REASON_FRAG_TOO_FAR = 69,
	SKB_DROP_REASON_TCP_MINTTL = 70,
	SKB_DROP_REASON_IPV6_BAD_EXTHDR = 71,
	SKB_DROP_REASON_IPV6_NDISC_FRAG = 72,
	SKB_DROP_REASON_IPV6_NDISC_HOP_LIMIT = 73,
	SKB_DROP_REASON_IPV6_NDISC_BAD_CODE = 74,
	SKB_DROP_REASON_IPV6_NDISC_BAD_OPTIONS = 75,
	SKB_DROP_REASON_IPV6_NDISC_NS_OTHERHOST = 76,
	SKB_DROP_REASON_QUEUE_PURGE = 77,
	SKB_DROP_REASON_MAX = 78,
	SKB_DROP_REASON_SUBSYS_MASK = 4294901760,
};

typedef struct bio_vec skb_frag_t;

struct skb_shared_info {
	__u8 flags;
	__u8 meta_len;
	__u8 nr_frags;
	__u8 tx_flags;
	short unsigned int gso_size;
	short unsigned int gso_segs;
	struct sk_buff *frag_list;
	struct skb_shared_hwtstamps hwtstamps;
	unsigned int gso_type;
	u32 tskey;
	atomic_t dataref;
	unsigned int xdp_frags_size;
	void *destructor_arg;
	skb_frag_t frags[17];
};

enum netdev_xdp_act {
	NETDEV_XDP_ACT_BASIC = 1,
	NETDEV_XDP_ACT_REDIRECT = 2,
	NETDEV_XDP_ACT_NDO_XMIT = 4,
	NETDEV_XDP_ACT_XSK_ZEROCOPY = 8,
	NETDEV_XDP_ACT_HW_OFFLOAD = 16,
	NETDEV_XDP_ACT_RX_SG = 32,
	NETDEV_XDP_ACT_NDO_XMIT_SG = 64,
	NETDEV_XDP_ACT_MASK = 127,
};

enum netdev_priv_flags {
	IFF_802_1Q_VLAN = 1ULL,
	IFF_EBRIDGE = 2ULL,
	IFF_BONDING = 4ULL,
	IFF_ISATAP = 8ULL,
	IFF_WAN_HDLC = 16ULL,
	IFF_XMIT_DST_RELEASE = 32ULL,
	IFF_DONT_BRIDGE = 64ULL,
	IFF_DISABLE_NETPOLL = 128ULL,
	IFF_MACVLAN_PORT = 256ULL,
	IFF_BRIDGE_PORT = 512ULL,
	IFF_OVS_DATAPATH = 1024ULL,
	IFF_TX_SKB_SHARING = 2048ULL,
	IFF_UNICAST_FLT = 4096ULL,
	IFF_TEAM_PORT = 8192ULL,
	IFF_SUPP_NOFCS = 16384ULL,
	IFF_LIVE_ADDR_CHANGE = 32768ULL,
	IFF_MACVLAN = 65536ULL,
	IFF_XMIT_DST_RELEASE_PERM = 131072ULL,
	IFF_L3MDEV_MASTER = 262144ULL,
	IFF_NO_QUEUE = 524288ULL,
	IFF_OPENVSWITCH = 1048576ULL,
	IFF_L3MDEV_SLAVE = 2097152ULL,
	IFF_TEAM = 4194304ULL,
	IFF_RXFH_CONFIGURED = 8388608ULL,
	IFF_PHONY_HEADROOM = 16777216ULL,
	IFF_MACSEC = 33554432ULL,
	IFF_NO_RX_HANDLER = 67108864ULL,
	IFF_FAILOVER = 134217728ULL,
	IFF_FAILOVER_SLAVE = 268435456ULL,
	IFF_L3MDEV_RX_HANDLER = 536870912ULL,
	IFF_NO_ADDRCONF = 1073741824ULL,
	IFF_TX_SKB_NO_LINEAR = 2147483648ULL,
	IFF_CHANGE_PROTO_DOWN = 4294967296ULL,
	IFF_SEE_ALL_HWTSTAMP_REQUESTS = 8589934592ULL,
};

struct xdp_dev_bulk_queue {
	struct xdp_frame *q[16];
	struct list_head flush_node;
	struct net_device *dev;
	struct net_device *dev_rx;
	struct bpf_prog *xdp_prog;
	unsigned int count;
};

enum netdev_cmd {
	NETDEV_UP = 1,
	NETDEV_DOWN = 2,
	NETDEV_REBOOT = 3,
	NETDEV_CHANGE = 4,
	NETDEV_REGISTER = 5,
	NETDEV_UNREGISTER = 6,
	NETDEV_CHANGEMTU = 7,
	NETDEV_CHANGEADDR = 8,
	NETDEV_PRE_CHANGEADDR = 9,
	NETDEV_GOING_DOWN = 10,
	NETDEV_CHANGENAME = 11,
	NETDEV_FEAT_CHANGE = 12,
	NETDEV_BONDING_FAILOVER = 13,
	NETDEV_PRE_UP = 14,
	NETDEV_PRE_TYPE_CHANGE = 15,
	NETDEV_POST_TYPE_CHANGE = 16,
	NETDEV_POST_INIT = 17,
	NETDEV_PRE_UNINIT = 18,
	NETDEV_RELEASE = 19,
	NETDEV_NOTIFY_PEERS = 20,
	NETDEV_JOIN = 21,
	NETDEV_CHANGEUPPER = 22,
	NETDEV_RESEND_IGMP = 23,
	NETDEV_PRECHANGEMTU = 24,
	NETDEV_CHANGEINFODATA = 25,
	NETDEV_BONDING_INFO = 26,
	NETDEV_PRECHANGEUPPER = 27,
	NETDEV_CHANGELOWERSTATE = 28,
	NETDEV_UDP_TUNNEL_PUSH_INFO = 29,
	NETDEV_UDP_TUNNEL_DROP_INFO = 30,
	NETDEV_CHANGE_TX_QUEUE_LEN = 31,
	NETDEV_CVLAN_FILTER_PUSH_INFO = 32,
	NETDEV_CVLAN_FILTER_DROP_INFO = 33,
	NETDEV_SVLAN_FILTER_PUSH_INFO = 34,
	NETDEV_SVLAN_FILTER_DROP_INFO = 35,
	NETDEV_OFFLOAD_XSTATS_ENABLE = 36,
	NETDEV_OFFLOAD_XSTATS_DISABLE = 37,
	NETDEV_OFFLOAD_XSTATS_REPORT_USED = 38,
	NETDEV_OFFLOAD_XSTATS_REPORT_DELTA = 39,
	NETDEV_XDP_FEAT_CHANGE = 40,
};

struct netdev_notifier_info {
	struct net_device *dev;
	struct netlink_ext_ack *extack;
};

struct bpf_nh_params {
	u32 nh_family;
	union {
		u32 ipv4_nh;
		struct in6_addr ipv6_nh;
	};
};

struct bpf_redirect_info {
	u64 tgt_index;
	void *tgt_value;
	struct bpf_map *map;
	u32 flags;
	u32 kern_flags;
	u32 map_id;
	enum bpf_map_type map_type;
	struct bpf_nh_params nh;
};

enum xdp_buff_flags {
	XDP_FLAGS_HAS_FRAGS = 1,
	XDP_FLAGS_FRAGS_PF_MEMALLOC = 2,
};

struct bpf_dtab_netdev {
	struct net_device *dev;
	struct hlist_node index_hlist;
	struct bpf_prog *xdp_prog;
	struct callback_head rcu;
	unsigned int idx;
	struct bpf_devmap_val val;
};

struct bpf_dtab {
	struct bpf_map map;
	struct bpf_dtab_netdev **netdev_map;
	struct list_head list;
	struct hlist_head *dev_index_head;
	spinlock_t index_lock;
	unsigned int items;
	u32 n_buckets;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

enum {
	BPF_LOCAL_STORAGE_GET_F_CREATE = 1,
	BPF_SK_STORAGE_GET_F_CREATE = 1,
};

struct bpf_local_storage_data;

struct bpf_local_storage {
	struct bpf_local_storage_data *cache[16];
	struct bpf_local_storage_map *smap;
	struct hlist_head list;
	void *owner;
	struct callback_head rcu;
	raw_spinlock_t lock;
};

struct bpf_mem_caches;

struct bpf_mem_cache;

struct bpf_mem_alloc {
	struct bpf_mem_caches *caches;
	struct bpf_mem_cache *cache;
	struct work_struct work;
};

struct bpf_local_storage_map_bucket;

struct bpf_local_storage_map {
	struct bpf_map map;
	struct bpf_local_storage_map_bucket *buckets;
	u32 bucket_log;
	u16 elem_size;
	u16 cache_idx;
	struct bpf_mem_alloc selem_ma;
	struct bpf_mem_alloc storage_ma;
	bool bpf_ma;
	long: 64;
};

struct bpf_local_storage_map_bucket {
	struct hlist_head list;
	raw_spinlock_t lock;
};

struct bpf_local_storage_data {
	struct bpf_local_storage_map *smap;
	u8 data[0];
};

struct bpf_local_storage_elem {
	struct hlist_node map_node;
	struct hlist_node snode;
	struct bpf_local_storage *local_storage;
	struct callback_head rcu;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct bpf_local_storage_data sdata;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct bpf_local_storage_cache {
	spinlock_t idx_lock;
	u64 idx_usage_counts[16];
};

typedef u64 (*btf_bpf_cgrp_storage_get)(struct bpf_map *, struct cgroup *, void *, u64, gfp_t);

typedef u64 (*btf_bpf_cgrp_storage_delete)(struct bpf_map *, struct cgroup *);

struct perf_event_mmap_page {
	__u32 version;
	__u32 compat_version;
	__u32 lock;
	__u32 index;
	__s64 offset;
	__u64 time_enabled;
	__u64 time_running;
	union {
		__u64 capabilities;
		struct {
			__u64 cap_bit0: 1;
			__u64 cap_bit0_is_deprecated: 1;
			__u64 cap_user_rdpmc: 1;
			__u64 cap_user_time: 1;
			__u64 cap_user_time_zero: 1;
			__u64 cap_user_time_short: 1;
			__u64 cap_____res: 58;
		};
	};
	__u16 pmc_width;
	__u16 time_shift;
	__u32 time_mult;
	__u64 time_offset;
	__u64 time_zero;
	__u32 size;
	__u32 __reserved_1;
	__u64 time_cycles;
	__u64 time_mask;
	__u8 __reserved[928];
	__u64 data_head;
	__u64 data_tail;
	__u64 data_offset;
	__u64 data_size;
	__u64 aux_head;
	__u64 aux_tail;
	__u64 aux_offset;
	__u64 aux_size;
};

struct perf_event_header {
	__u32 type;
	__u16 misc;
	__u16 size;
};

enum perf_event_type {
	PERF_RECORD_MMAP = 1,
	PERF_RECORD_LOST = 2,
	PERF_RECORD_COMM = 3,
	PERF_RECORD_EXIT = 4,
	PERF_RECORD_THROTTLE = 5,
	PERF_RECORD_UNTHROTTLE = 6,
	PERF_RECORD_FORK = 7,
	PERF_RECORD_READ = 8,
	PERF_RECORD_SAMPLE = 9,
	PERF_RECORD_MMAP2 = 10,
	PERF_RECORD_AUX = 11,
	PERF_RECORD_ITRACE_START = 12,
	PERF_RECORD_LOST_SAMPLES = 13,
	PERF_RECORD_SWITCH = 14,
	PERF_RECORD_SWITCH_CPU_WIDE = 15,
	PERF_RECORD_NAMESPACES = 16,
	PERF_RECORD_KSYMBOL = 17,
	PERF_RECORD_BPF_EVENT = 18,
	PERF_RECORD_CGROUP = 19,
	PERF_RECORD_TEXT_POKE = 20,
	PERF_RECORD_AUX_OUTPUT_HW_ID = 21,
	PERF_RECORD_MAX = 22,
};

struct perf_buffer {
	refcount_t refcount;
	struct callback_head callback_head;
	int nr_pages;
	int overwrite;
	int paused;
	atomic_t poll;
	local_t head;
	unsigned int nest;
	local_t events;
	local_t wakeup;
	local_t lost;
	long int watermark;
	long int aux_watermark;
	spinlock_t event_lock;
	struct list_head event_list;
	atomic_t mmap_count;
	long unsigned int mmap_locked;
	struct user_struct *mmap_user;
	long int aux_head;
	unsigned int aux_nest;
	long int aux_wakeup;
	long unsigned int aux_pgoff;
	int aux_nr_pages;
	int aux_overwrite;
	atomic_t aux_mmap_count;
	long unsigned int aux_mmap_locked;
	void (*free_aux)(void *);
	refcount_t aux_refcount;
	int aux_in_sampling;
	void **aux_pages;
	void *aux_priv;
	struct perf_event_mmap_page *user_page;
	void *data_pages[0];
};

enum rseq_cpu_id_state {
	RSEQ_CPU_ID_UNINITIALIZED = -1,
	RSEQ_CPU_ID_REGISTRATION_FAILED = -2,
};

enum rseq_flags {
	RSEQ_FLAG_UNREGISTER = 1,
};

enum rseq_cs_flags {
	RSEQ_CS_FLAG_NO_RESTART_ON_PREEMPT = 1,
	RSEQ_CS_FLAG_NO_RESTART_ON_SIGNAL = 2,
	RSEQ_CS_FLAG_NO_RESTART_ON_MIGRATE = 4,
};

struct rseq_cs {
	__u32 version;
	__u32 flags;
	__u64 start_ip;
	__u64 post_commit_offset;
	__u64 abort_ip;
};

struct trace_event_raw_rseq_update {
	struct trace_entry ent;
	s32 cpu_id;
	s32 node_id;
	s32 mm_cid;
	char __data[0];
};

struct trace_event_raw_rseq_ip_fixup {
	struct trace_entry ent;
	long unsigned int regs_ip;
	long unsigned int start_ip;
	long unsigned int post_commit_offset;
	long unsigned int abort_ip;
	char __data[0];
};

struct trace_event_data_offsets_rseq_update {};

struct trace_event_data_offsets_rseq_ip_fixup {};

typedef void (*btf_trace_rseq_update)(void *, struct task_struct *);

typedef void (*btf_trace_rseq_ip_fixup)(void *, long unsigned int, long unsigned int, long unsigned int, long unsigned int);

struct anon_vma {
	struct anon_vma *root;
	struct rw_semaphore rwsem;
	atomic_t refcount;
	long unsigned int num_children;
	long unsigned int num_active_vmas;
	struct anon_vma *parent;
	struct rb_root_cached rb_root;
};

struct compact_control;

struct capture_control {
	struct compact_control *cc;
	struct page *page;
};

typedef unsigned int fgf_t;

struct compact_control {
	struct list_head freepages;
	struct list_head migratepages;
	unsigned int nr_freepages;
	unsigned int nr_migratepages;
	long unsigned int free_pfn;
	long unsigned int migrate_pfn;
	long unsigned int fast_start_pfn;
	struct zone *zone;
	long unsigned int total_migrate_scanned;
	long unsigned int total_free_scanned;
	short unsigned int fast_search_fail;
	short int search_order;
	const gfp_t gfp_mask;
	int order;
	int migratetype;
	const unsigned int alloc_flags;
	const int highest_zoneidx;
	enum migrate_mode mode;
	bool ignore_skip_hint;
	bool no_set_skip_hint;
	bool ignore_block_suitable;
	bool direct_compaction;
	bool proactive_compaction;
	bool whole_zone;
	bool contended;
	bool finish_pageblock;
	bool alloc_contig;
};

typedef __kernel_ulong_t ino_t;

struct wait_bit_key {
	void *flags;
	int bit_nr;
	long unsigned int timeout;
};

struct wait_bit_queue_entry {
	struct wait_bit_key key;
	struct wait_queue_entry wq_entry;
};

enum vm_fault_reason {
	VM_FAULT_OOM = 1,
	VM_FAULT_SIGBUS = 2,
	VM_FAULT_MAJOR = 4,
	VM_FAULT_HWPOISON = 16,
	VM_FAULT_HWPOISON_LARGE = 32,
	VM_FAULT_SIGSEGV = 64,
	VM_FAULT_NOPAGE = 256,
	VM_FAULT_LOCKED = 512,
	VM_FAULT_RETRY = 1024,
	VM_FAULT_FALLBACK = 2048,
	VM_FAULT_DONE_COW = 4096,
	VM_FAULT_NEEDDSYNC = 8192,
	VM_FAULT_COMPLETED = 16384,
	VM_FAULT_HINDEX_MASK = 983040,
};

typedef void (*xa_update_node_t)(struct xa_node *);

struct xa_state {
	struct xarray *xa;
	long unsigned int xa_index;
	unsigned char xa_shift;
	unsigned char xa_sibs;
	unsigned char xa_offset;
	unsigned char xa_pad;
	struct xa_node *xa_node;
	struct xa_node *xa_alloc;
	xa_update_node_t xa_update;
	struct list_lru *xa_lru;
};

enum positive_aop_returns {
	AOP_WRITEPAGE_ACTIVATE = 524288,
	AOP_TRUNCATED_PAGE = 524289,
};

struct posix_acl_entry {
	short int e_tag;
	short unsigned int e_perm;
	union {
		kuid_t e_uid;
		kgid_t e_gid;
	};
};

struct posix_acl {
	refcount_t a_refcount;
	struct callback_head a_rcu;
	unsigned int a_count;
	struct posix_acl_entry a_entries[0];
};

struct fileattr {
	u32 flags;
	u32 fsx_xflags;
	u32 fsx_extsize;
	u32 fsx_nextents;
	u32 fsx_projid;
	u32 fsx_cowextsize;
	bool flags_valid: 1;
	bool fsx_valid: 1;
};

struct kstatfs {
	long int f_type;
	long int f_bsize;
	u64 f_blocks;
	u64 f_bfree;
	u64 f_bavail;
	u64 f_files;
	u64 f_ffree;
	__kernel_fsid_t f_fsid;
	long int f_namelen;
	long int f_frsize;
	long int f_flags;
	long int f_spare[4];
};

struct fc_log;

struct p_log {
	const char *prefix;
	struct fc_log *log;
};

enum fs_context_purpose {
	FS_CONTEXT_FOR_MOUNT = 0,
	FS_CONTEXT_FOR_SUBMOUNT = 1,
	FS_CONTEXT_FOR_RECONFIGURE = 2,
};

enum fs_context_phase {
	FS_CONTEXT_CREATE_PARAMS = 0,
	FS_CONTEXT_CREATING = 1,
	FS_CONTEXT_AWAITING_MOUNT = 2,
	FS_CONTEXT_AWAITING_RECONF = 3,
	FS_CONTEXT_RECONF_PARAMS = 4,
	FS_CONTEXT_RECONFIGURING = 5,
	FS_CONTEXT_FAILED = 6,
};

struct fs_context_operations;

struct fs_context {
	const struct fs_context_operations *ops;
	struct mutex uapi_mutex;
	struct file_system_type *fs_type;
	void *fs_private;
	void *sget_key;
	struct dentry *root;
	struct user_namespace *user_ns;
	struct net *net_ns;
	const struct cred *cred;
	struct p_log log;
	const char *source;
	void *security;
	void *s_fs_info;
	unsigned int sb_flags;
	unsigned int sb_flags_mask;
	unsigned int s_iflags;
	enum fs_context_purpose purpose: 8;
	enum fs_context_phase phase: 8;
	bool need_free: 1;
	bool global: 1;
	bool oldapi: 1;
	bool exclusive: 1;
};

struct vm_event_state {
	long unsigned int event[107];
};

struct xattr;

typedef int (*initxattrs)(struct inode *, const struct xattr *, void *);

struct xattr {
	const char *name;
	void *value;
	size_t value_len;
};

enum fs_value_type {
	fs_value_is_undefined = 0,
	fs_value_is_flag = 1,
	fs_value_is_string = 2,
	fs_value_is_blob = 3,
	fs_value_is_filename = 4,
	fs_value_is_file = 5,
};

struct fs_parameter {
	const char *key;
	enum fs_value_type type: 8;
	union {
		char *string;
		void *blob;
		struct filename *name;
		struct file *file;
	};
	size_t size;
	int dirfd;
};

struct fc_log {
	refcount_t usage;
	u8 head;
	u8 tail;
	u8 need_free;
	struct module *owner;
	char *buffer[8];
};

struct fs_context_operations {
	void (*free)(struct fs_context *);
	int (*dup)(struct fs_context *, struct fs_context *);
	int (*parse_param)(struct fs_context *, struct fs_parameter *);
	int (*parse_monolithic)(struct fs_context *, void *);
	int (*get_tree)(struct fs_context *);
	int (*reconfigure)(struct fs_context *);
};

struct constant_table {
	const char *name;
	int value;
};

struct fs_parse_result {
	bool negated;
	union {
		bool boolean;
		int int_32;
		unsigned int uint_32;
		u64 uint_64;
	};
};

enum mapping_flags {
	AS_EIO = 0,
	AS_ENOSPC = 1,
	AS_MM_ALL_LOCKS = 2,
	AS_UNEVICTABLE = 3,
	AS_EXITING = 4,
	AS_NO_WRITEBACK_TAGS = 5,
	AS_LARGE_FOLIO_SUPPORT = 6,
	AS_RELEASE_ALWAYS = 7,
};

enum {
	MPOL_DEFAULT = 0,
	MPOL_PREFERRED = 1,
	MPOL_BIND = 2,
	MPOL_INTERLEAVE = 3,
	MPOL_LOCAL = 4,
	MPOL_PREFERRED_MANY = 5,
	MPOL_MAX = 6,
};

struct shared_policy {
	struct rb_root root;
	rwlock_t lock;
};

struct simple_xattrs {
	struct rb_root rb_root;
	rwlock_t lock;
};

struct simple_xattr {
	struct rb_node rb_node;
	char *name;
	size_t size;
	char value[0];
};

struct shmem_inode_info {
	spinlock_t lock;
	unsigned int seals;
	long unsigned int flags;
	long unsigned int alloced;
	long unsigned int swapped;
	long unsigned int fallocend;
	struct list_head shrinklist;
	struct list_head swaplist;
	struct shared_policy policy;
	struct simple_xattrs xattrs;
	atomic_t stop_eviction;
	struct timespec64 i_crtime;
	unsigned int fsflags;
	struct offset_ctx dir_offsets;
	struct inode vfs_inode;
};

struct shmem_quota_limits {
	qsize_t usrquota_bhardlimit;
	qsize_t usrquota_ihardlimit;
	qsize_t grpquota_bhardlimit;
	qsize_t grpquota_ihardlimit;
};

struct shmem_sb_info {
	long unsigned int max_blocks;
	struct percpu_counter used_blocks;
	long unsigned int max_inodes;
	long unsigned int free_ispace;
	raw_spinlock_t stat_lock;
	umode_t mode;
	unsigned char huge;
	kuid_t uid;
	kgid_t gid;
	bool full_inums;
	bool noswap;
	ino_t next_ino;
	ino_t *ino_batch;
	struct mempolicy *mpol;
	spinlock_t shrinklist_lock;
	struct list_head shrinklist;
	long unsigned int shrinklist_len;
	struct shmem_quota_limits qlimits;
};

enum sgp_type {
	SGP_READ = 0,
	SGP_NOALLOC = 1,
	SGP_CACHE = 2,
	SGP_WRITE = 3,
	SGP_FALLOC = 4,
};

typedef long unsigned int pte_marker;

enum fid_type {
	FILEID_ROOT = 0,
	FILEID_INO32_GEN = 1,
	FILEID_INO32_GEN_PARENT = 2,
	FILEID_BTRFS_WITHOUT_PARENT = 77,
	FILEID_BTRFS_WITH_PARENT = 78,
	FILEID_BTRFS_WITH_PARENT_ROOT = 79,
	FILEID_UDF_WITHOUT_PARENT = 81,
	FILEID_UDF_WITH_PARENT = 82,
	FILEID_NILFS_WITHOUT_PARENT = 97,
	FILEID_NILFS_WITH_PARENT = 98,
	FILEID_FAT_WITHOUT_PARENT = 113,
	FILEID_FAT_WITH_PARENT = 114,
	FILEID_LUSTRE = 151,
	FILEID_KERNFS = 254,
	FILEID_INVALID = 255,
};

struct fid {
	union {
		struct {
			u32 ino;
			u32 gen;
			u32 parent_ino;
			u32 parent_gen;
		} i32;
		struct {
			u32 block;
			u16 partref;
			u16 parent_partref;
			u32 generation;
			u32 parent_block;
			u32 parent_generation;
		} udf;
		struct {
			struct {} __empty_raw;
			__u32 raw[0];
		};
	};
};

struct folio_batch {
	unsigned char nr;
	bool percpu_pvec_drained;
	struct folio *folios[15];
};

struct shmem_falloc {
	wait_queue_head_t *waitq;
	long unsigned int start;
	long unsigned int next;
	long unsigned int nr_falloced;
	long unsigned int nr_unswapped;
};

struct shmem_options {
	long long unsigned int blocks;
	long long unsigned int inodes;
	struct mempolicy *mpol;
	kuid_t uid;
	kgid_t gid;
	umode_t mode;
	bool full_inums;
	int huge;
	int seen;
	bool noswap;
	short unsigned int quota_types;
	struct shmem_quota_limits qlimits;
};

enum shmem_param {
	Opt_gid = 0,
	Opt_huge = 1,
	Opt_mode = 2,
	Opt_mpol = 3,
	Opt_nr_blocks = 4,
	Opt_nr_inodes = 5,
	Opt_size = 6,
	Opt_uid = 7,
	Opt_inode32 = 8,
	Opt_inode64 = 9,
	Opt_noswap = 10,
	Opt_quota = 11,
	Opt_usrquota = 12,
	Opt_grpquota = 13,
	Opt_usrquota_block_hardlimit = 14,
	Opt_usrquota_inode_hardlimit = 15,
	Opt_grpquota_block_hardlimit = 16,
	Opt_grpquota_inode_hardlimit = 17,
};

struct anon_vma_chain {
	struct vm_area_struct *vma;
	struct anon_vma *anon_vma;
	struct list_head same_vma;
	struct rb_node rb;
	long unsigned int rb_subtree_last;
};

struct rb_augment_callbacks {
	void (*propagate)(struct rb_node *, struct rb_node *);
	void (*copy)(struct rb_node *, struct rb_node *);
	void (*rotate)(struct rb_node *, struct rb_node *);
};

struct maple_alloc {
	long unsigned int total;
	unsigned char node_count;
	unsigned int request_count;
	struct maple_alloc *slot[30];
};

struct maple_enode;

struct ma_state {
	struct maple_tree *tree;
	long unsigned int index;
	long unsigned int last;
	struct maple_enode *node;
	long unsigned int min;
	long unsigned int max;
	struct maple_alloc *alloc;
	unsigned char depth;
	unsigned char offset;
	unsigned char mas_flags;
};

struct anon_vma_name {
	struct kref kref;
	char name[0];
};

struct vma_iterator {
	struct ma_state mas;
};

enum page_walk_lock {
	PGWALK_RDLOCK = 0,
	PGWALK_WRLOCK = 1,
	PGWALK_WRLOCK_VERIFY = 2,
};

struct mm_walk;

struct mm_walk_ops {
	int (*pgd_entry)(pgd_t *, long unsigned int, long unsigned int, struct mm_walk *);
	int (*p4d_entry)(p4d_t *, long unsigned int, long unsigned int, struct mm_walk *);
	int (*pud_entry)(pud_t *, long unsigned int, long unsigned int, struct mm_walk *);
	int (*pmd_entry)(pmd_t *, long unsigned int, long unsigned int, struct mm_walk *);
	int (*pte_entry)(pte_t *, long unsigned int, long unsigned int, struct mm_walk *);
	int (*pte_hole)(long unsigned int, long unsigned int, int, struct mm_walk *);
	int (*hugetlb_entry)(pte_t *, long unsigned int, long unsigned int, long unsigned int, struct mm_walk *);
	int (*test_walk)(long unsigned int, long unsigned int, struct mm_walk *);
	int (*pre_vma)(long unsigned int, long unsigned int, struct mm_walk *);
	void (*post_vma)(struct mm_walk *);
	enum page_walk_lock walk_lock;
};

enum page_walk_action {
	ACTION_SUBTREE = 0,
	ACTION_CONTINUE = 1,
	ACTION_AGAIN = 2,
};

struct mm_walk {
	const struct mm_walk_ops *ops;
	struct mm_struct *mm;
	pgd_t *pgd;
	struct vm_area_struct *vma;
	enum page_walk_action action;
	bool no_vma;
	void *private;
};

enum tlb_flush_reason {
	TLB_FLUSH_ON_TASK_SWITCH = 0,
	TLB_REMOTE_SHOOTDOWN = 1,
	TLB_LOCAL_SHOOTDOWN = 2,
	TLB_LOCAL_MM_SHOOTDOWN = 3,
	TLB_REMOTE_SEND_IPI = 4,
	NR_TLB_FLUSH_REASONS = 5,
};

enum ttu_flags {
	TTU_SPLIT_HUGE_PMD = 4,
	TTU_IGNORE_MLOCK = 8,
	TTU_SYNC = 16,
	TTU_HWPOISON = 32,
	TTU_BATCH_FLUSH = 64,
	TTU_RMAP_LOCKED = 128,
};

typedef int rmap_t;

struct page_vma_mapped_walk {
	long unsigned int pfn;
	long unsigned int nr_pages;
	long unsigned int pgoff;
	struct vm_area_struct *vma;
	long unsigned int address;
	pmd_t *pmd;
	pte_t *pte;
	spinlock_t *ptl;
	unsigned int flags;
};

struct rmap_walk_control {
	void *arg;
	bool try_lock;
	bool contended;
	bool (*rmap_one)(struct folio *, struct vm_area_struct *, long unsigned int, void *);
	int (*done)(struct folio *);
	struct anon_vma * (*anon_lock)(struct folio *, struct rmap_walk_control *);
	bool (*invalid_vma)(struct vm_area_struct *, void *);
};

struct hstate;

struct hugepage_subpool {
	spinlock_t lock;
	long int count;
	long int max_hpages;
	long int used_hpages;
	struct hstate *hstate;
	long int min_hpages;
	long int rsv_hpages;
};

struct hstate {
	struct mutex resize_lock;
	int next_nid_to_alloc;
	int next_nid_to_free;
	unsigned int order;
	unsigned int demote_order;
	long unsigned int mask;
	long unsigned int max_huge_pages;
	long unsigned int nr_huge_pages;
	long unsigned int free_huge_pages;
	long unsigned int resv_huge_pages;
	long unsigned int surplus_huge_pages;
	long unsigned int nr_overcommit_huge_pages;
	struct list_head hugepage_activelist;
	struct list_head hugepage_freelists[256];
	unsigned int max_huge_pages_node[256];
	unsigned int nr_huge_pages_node[256];
	unsigned int free_huge_pages_node[256];
	unsigned int surplus_huge_pages_node[256];
	struct cftype cgroup_files_dfl[8];
	struct cftype cgroup_files_legacy[10];
	char name[32];
};

struct hugetlbfs_sb_info {
	long int max_inodes;
	long int free_inodes;
	spinlock_t stat_lock;
	struct hstate *hstate;
	struct hugepage_subpool *spool;
	kuid_t uid;
	kgid_t gid;
	umode_t mode;
};

enum hugetlb_page_flags {
	HPG_restore_reserve = 0,
	HPG_migratable = 1,
	HPG_temporary = 2,
	HPG_freed = 3,
	HPG_vmemmap_optimized = 4,
	HPG_raw_hwp_unreliable = 5,
	__NR_HPAGEFLAGS = 6,
};

struct trace_event_raw_tlb_flush {
	struct trace_entry ent;
	int reason;
	long unsigned int pages;
	char __data[0];
};

struct trace_event_data_offsets_tlb_flush {};

typedef void (*btf_trace_tlb_flush)(void *, int, long unsigned int);

struct trace_event_raw_mm_migrate_pages {
	struct trace_entry ent;
	long unsigned int succeeded;
	long unsigned int failed;
	long unsigned int thp_succeeded;
	long unsigned int thp_failed;
	long unsigned int thp_split;
	enum migrate_mode mode;
	int reason;
	char __data[0];
};

struct trace_event_raw_mm_migrate_pages_start {
	struct trace_entry ent;
	enum migrate_mode mode;
	int reason;
	char __data[0];
};

struct trace_event_raw_migration_pte {
	struct trace_entry ent;
	long unsigned int addr;
	long unsigned int pte;
	int order;
	char __data[0];
};

struct trace_event_data_offsets_mm_migrate_pages {};

struct trace_event_data_offsets_mm_migrate_pages_start {};

struct trace_event_data_offsets_migration_pte {};

typedef void (*btf_trace_mm_migrate_pages)(void *, long unsigned int, long unsigned int, long unsigned int, long unsigned int, long unsigned int, enum migrate_mode, int);

typedef void (*btf_trace_mm_migrate_pages_start)(void *, enum migrate_mode, int);

typedef void (*btf_trace_set_migration_pte)(void *, long unsigned int, long unsigned int, int);

typedef void (*btf_trace_remove_migration_pte)(void *, long unsigned int, long unsigned int, int);

struct folio_referenced_arg {
	int mapcount;
	int referenced;
	long unsigned int vm_flags;
	struct mem_cgroup *memcg;
};

struct swap_slots_cache {
	bool lock_initialized;
	struct mutex alloc_lock;
	swp_entry_t *slots;
	int nr;
	int cur;
	spinlock_t free_lock;
	swp_entry_t *slots_ret;
	int n_ret;
};

struct mmu_notifier_subscriptions {
	struct hlist_head list;
	bool has_itree;
	spinlock_t lock;
	long unsigned int invalidate_seq;
	long unsigned int active_invalidate_ranges;
	struct rb_root_cached itree;
	wait_queue_head_t wq;
	struct hlist_head deferred_list;
};

struct mmu_interval_notifier;

struct mmu_interval_notifier_ops {
	bool (*invalidate)(struct mmu_interval_notifier *, const struct mmu_notifier_range *, long unsigned int);
};

struct mmu_interval_notifier {
	struct interval_tree_node interval_tree;
	const struct mmu_interval_notifier_ops *ops;
	struct mm_struct *mm;
	struct hlist_node deferred_item;
	long unsigned int invalidate_seq;
};

struct memory_tier {
	struct list_head list;
	struct list_head memory_types;
	int adistance_start;
	struct device dev;
	nodemask_t lower_tier_mask;
};

typedef struct pglist_data pg_data_t;

struct memory_notify {
	long unsigned int start_pfn;
	long unsigned int nr_pages;
	int status_change_nid_normal;
	int status_change_nid;
};

struct memory_dev_type {
	struct list_head tier_sibiling;
	int adistance;
	nodemask_t nodes;
	struct kref kref;
};

struct demotion_nodes {
	nodemask_t preferred;
};

struct node_memory_type_map {
	struct memory_dev_type *memtype;
	int map_count;
};

enum vmpressure_levels {
	VMPRESSURE_LOW = 0,
	VMPRESSURE_MEDIUM = 1,
	VMPRESSURE_CRITICAL = 2,
	VMPRESSURE_NUM_LEVELS = 3,
};

enum vmpressure_modes {
	VMPRESSURE_NO_PASSTHROUGH = 0,
	VMPRESSURE_HIERARCHY = 1,
	VMPRESSURE_LOCAL = 2,
	VMPRESSURE_NUM_MODES = 3,
};

struct vmpressure_event {
	struct eventfd_ctx *efd;
	enum vmpressure_levels level;
	enum vmpressure_modes mode;
	struct list_head node;
};

struct trace_event_raw_test_pages_isolated {
	struct trace_entry ent;
	long unsigned int start_pfn;
	long unsigned int end_pfn;
	long unsigned int fin_pfn;
	char __data[0];
};

struct trace_event_data_offsets_test_pages_isolated {};

typedef void (*btf_trace_test_pages_isolated)(void *, long unsigned int, long unsigned int, long unsigned int);

enum {
	REGION_INTERSECTS = 0,
	REGION_DISJOINT = 1,
	REGION_MIXED = 2,
};

typedef __kernel_long_t __kernel_off_t;

typedef __kernel_off_t off_t;

enum iter_type {
	ITER_IOVEC = 0,
	ITER_KVEC = 1,
	ITER_BVEC = 2,
	ITER_XARRAY = 3,
	ITER_DISCARD = 4,
	ITER_UBUF = 5,
};

typedef __kernel_rwf_t rwf_t;

enum fsnotify_data_type {
	FSNOTIFY_EVENT_NONE = 0,
	FSNOTIFY_EVENT_PATH = 1,
	FSNOTIFY_EVENT_INODE = 2,
	FSNOTIFY_EVENT_DENTRY = 3,
	FSNOTIFY_EVENT_ERROR = 4,
};

struct linux_dirent64 {
	u64 d_ino;
	s64 d_off;
	short unsigned int d_reclen;
	unsigned char d_type;
	char d_name[0];
};

struct old_linux_dirent {
	long unsigned int d_ino;
	long unsigned int d_offset;
	short unsigned int d_namlen;
	char d_name[0];
};

struct readdir_callback {
	struct dir_context ctx;
	struct old_linux_dirent *dirent;
	int result;
};

struct linux_dirent {
	long unsigned int d_ino;
	long unsigned int d_off;
	short unsigned int d_reclen;
	char d_name[0];
};

struct getdents_callback {
	struct dir_context ctx;
	struct linux_dirent *current_dir;
	int prev_reclen;
	int count;
	int error;
};

struct getdents_callback64 {
	struct dir_context ctx;
	struct linux_dirent64 *current_dir;
	int prev_reclen;
	int count;
	int error;
};

typedef union {
} release_pages_arg;

struct splice_desc {
	size_t total_len;
	unsigned int len;
	unsigned int flags;
	union {
		void *userptr;
		struct file *file;
		void *data;
	} u;
	void (*splice_eof)(struct splice_desc *);
	loff_t pos;
	loff_t *opos;
	size_t num_spliced;
	bool need_wakeup;
};

struct partial_page {
	unsigned int offset;
	unsigned int len;
	long unsigned int private;
};

struct splice_pipe_desc {
	struct page **pages;
	struct partial_page *partial;
	int nr_pages;
	unsigned int nr_pages_max;
	const struct pipe_buf_operations *ops;
	void (*spd_release)(struct splice_pipe_desc *, unsigned int);
};

typedef int splice_actor(struct pipe_inode_info *, struct pipe_buffer *, struct splice_desc *);

typedef int splice_direct_actor(struct pipe_inode_info *, struct splice_desc *);

enum fsnotify_iter_type {
	FSNOTIFY_ITER_TYPE_INODE = 0,
	FSNOTIFY_ITER_TYPE_VFSMOUNT = 1,
	FSNOTIFY_ITER_TYPE_SB = 2,
	FSNOTIFY_ITER_TYPE_PARENT = 3,
	FSNOTIFY_ITER_TYPE_INODE2 = 4,
	FSNOTIFY_ITER_TYPE_COUNT = 5,
};

struct pseudo_fs_context {
	const struct super_operations *ops;
	const struct xattr_handler **xattr;
	const struct dentry_operations *dops;
	long unsigned int magic;
};

typedef struct ns_common *ns_get_path_helper_t(void *);

struct ns_get_path_task_args {
	const struct proc_ns_operations *ns_ops;
	struct task_struct *task;
};

struct mnt_idmap {
	struct user_namespace *owner;
	refcount_t count;
};

struct mount;

struct mnt_namespace {
	struct ns_common ns;
	struct mount *root;
	struct list_head list;
	spinlock_t ns_lock;
	struct user_namespace *user_ns;
	struct ucounts *ucounts;
	u64 seq;
	wait_queue_head_t poll;
	u64 event;
	unsigned int mounts;
	unsigned int pending_mounts;
};

struct fs_pin {
	wait_queue_head_t wait;
	int done;
	struct hlist_node s_list;
	struct hlist_node m_list;
	void (*kill)(struct fs_pin *);
};

struct mnt_pcp;

struct mountpoint;

struct mount {
	struct hlist_node mnt_hash;
	struct mount *mnt_parent;
	struct dentry *mnt_mountpoint;
	struct vfsmount mnt;
	union {
		struct callback_head mnt_rcu;
		struct llist_node mnt_llist;
	};
	struct mnt_pcp *mnt_pcp;
	struct list_head mnt_mounts;
	struct list_head mnt_child;
	struct list_head mnt_instance;
	const char *mnt_devname;
	struct list_head mnt_list;
	struct list_head mnt_expire;
	struct list_head mnt_share;
	struct list_head mnt_slave_list;
	struct list_head mnt_slave;
	struct mount *mnt_master;
	struct mnt_namespace *mnt_ns;
	struct mountpoint *mnt_mp;
	union {
		struct hlist_node mnt_mp_list;
		struct hlist_node mnt_umount;
	};
	struct list_head mnt_umounting;
	struct fsnotify_mark_connector *mnt_fsnotify_marks;
	__u32 mnt_fsnotify_mask;
	int mnt_id;
	int mnt_group_id;
	int mnt_expiry_mark;
	struct hlist_head mnt_pins;
	struct hlist_head mnt_stuck_children;
};

struct mnt_pcp {
	int mnt_count;
	int mnt_writers;
};

struct mountpoint {
	struct hlist_node m_hash;
	struct dentry *m_dentry;
	struct hlist_head m_list;
	int m_count;
};

struct inotify_event_info {
	struct fsnotify_event fse;
	u32 mask;
	int wd;
	u32 sync_cookie;
	int name_len;
	char name[0];
};

struct inotify_inode_mark {
	struct fsnotify_mark fsn_mark;
	int wd;
};

struct __kernel_itimerspec {
	struct __kernel_timespec it_interval;
	struct __kernel_timespec it_value;
};

enum alarmtimer_type {
	ALARM_REALTIME = 0,
	ALARM_BOOTTIME = 1,
	ALARM_NUMTYPE = 2,
	ALARM_REALTIME_FREEZER = 3,
	ALARM_BOOTTIME_FREEZER = 4,
};

enum alarmtimer_restart {
	ALARMTIMER_NORESTART = 0,
	ALARMTIMER_RESTART = 1,
};

struct alarm {
	struct timerqueue_node node;
	struct hrtimer timer;
	enum alarmtimer_restart (*function)(struct alarm *, ktime_t);
	enum alarmtimer_type type;
	int state;
	void *data;
};

struct timens_offsets {
	struct timespec64 monotonic;
	struct timespec64 boottime;
};

struct time_namespace {
	struct user_namespace *user_ns;
	struct ucounts *ucounts;
	struct ns_common ns;
	struct timens_offsets offsets;
	struct page *vvar_page;
	bool frozen_offsets;
};

struct timerfd_ctx {
	union {
		struct hrtimer tmr;
		struct alarm alarm;
	} t;
	ktime_t tintv;
	ktime_t moffs;
	wait_queue_head_t wqh;
	u64 ticks;
	int clockid;
	short unsigned int expired;
	short unsigned int settime_flags;
	struct callback_head rcu;
	struct list_head clist;
	spinlock_t cancel_lock;
	bool might_cancel;
};

struct file_lock_context {
	spinlock_t flc_lock;
	struct list_head flc_flock;
	struct list_head flc_posix;
	struct list_head flc_lease;
};

struct nlm_lockowner;

struct nfs_lock_info {
	u32 state;
	struct nlm_lockowner *owner;
	struct list_head list;
};

struct nfs4_lock_state;

struct nfs4_lock_info {
	struct nfs4_lock_state *owner;
};

struct file_lock_operations;

struct lock_manager_operations;

struct file_lock {
	struct file_lock *fl_blocker;
	struct list_head fl_list;
	struct hlist_node fl_link;
	struct list_head fl_blocked_requests;
	struct list_head fl_blocked_member;
	fl_owner_t fl_owner;
	unsigned int fl_flags;
	unsigned char fl_type;
	unsigned int fl_pid;
	int fl_link_cpu;
	wait_queue_head_t fl_wait;
	struct file *fl_file;
	loff_t fl_start;
	loff_t fl_end;
	struct fasync_struct *fl_fasync;
	long unsigned int fl_break_time;
	long unsigned int fl_downgrade_time;
	const struct file_lock_operations *fl_ops;
	const struct lock_manager_operations *fl_lmops;
	union {
		struct nfs_lock_info nfs_fl;
		struct nfs4_lock_info nfs4_fl;
		struct {
			struct list_head link;
			int state;
			unsigned int debug_id;
		} afs;
		struct {
			struct inode *inode;
		} ceph;
	} fl_u;
};

struct posix_acl_xattr_entry {
	__le16 e_tag;
	__le16 e_perm;
	__le32 e_id;
};

struct posix_acl_xattr_header {
	__le32 a_version;
};

struct file_lock_operations {
	void (*fl_copy_lock)(struct file_lock *, struct file_lock *);
	void (*fl_release_private)(struct file_lock *);
};

struct lock_manager_operations {
	void *lm_mod_owner;
	fl_owner_t (*lm_get_owner)(fl_owner_t);
	void (*lm_put_owner)(fl_owner_t);
	void (*lm_notify)(struct file_lock *);
	int (*lm_grant)(struct file_lock *, int);
	bool (*lm_break)(struct file_lock *);
	int (*lm_change)(struct file_lock *, int, struct list_head *);
	void (*lm_setup)(struct file_lock *, void **);
	bool (*lm_breaker_owns_lease)(struct file_lock *);
	bool (*lm_lock_expirable)(struct file_lock *);
	void (*lm_expire_lock)();
};

struct file_handle {
	__u32 handle_bytes;
	int handle_type;
	unsigned char f_handle[0];
};

typedef u32 nlink_t;

typedef int (*proc_write_t)(struct file *, char *, size_t);

struct proc_dir_entry {
	atomic_t in_use;
	refcount_t refcnt;
	struct list_head pde_openers;
	spinlock_t pde_unload_lock;
	struct completion *pde_unload_completion;
	const struct inode_operations *proc_iops;
	union {
		const struct proc_ops *proc_ops;
		const struct file_operations *proc_dir_ops;
	};
	const struct dentry_operations *proc_dops;
	union {
		const struct seq_operations *seq_ops;
		int (*single_show)(struct seq_file *, void *);
	};
	proc_write_t write;
	void *data;
	unsigned int state_size;
	unsigned int low_ino;
	nlink_t nlink;
	kuid_t uid;
	kgid_t gid;
	loff_t size;
	struct proc_dir_entry *parent;
	struct rb_root subdir;
	struct rb_node subdir_node;
	char *name;
	umode_t mode;
	u8 flags;
	u8 namelen;
	char inline_name[0];
};

union proc_op {
	int (*proc_get_link)(struct dentry *, struct path *);
	int (*proc_show)(struct seq_file *, struct pid_namespace *, struct pid *, struct task_struct *);
	const char *lsm;
};

struct proc_inode {
	struct pid *pid;
	unsigned int fd;
	union proc_op op;
	struct proc_dir_entry *pde;
	struct ctl_table_header *sysctl;
	struct ctl_table *sysctl_entry;
	struct hlist_node sibling_inodes;
	const struct proc_ns_operations *ns_ops;
	struct inode vfs_inode;
};

struct proc_maps_private {
	struct inode *inode;
	struct task_struct *task;
	struct mm_struct *mm;
	struct vma_iterator iter;
	struct mempolicy *task_mempolicy;
};

struct mem_size_stats {
	long unsigned int resident;
	long unsigned int shared_clean;
	long unsigned int shared_dirty;
	long unsigned int private_clean;
	long unsigned int private_dirty;
	long unsigned int referenced;
	long unsigned int anonymous;
	long unsigned int lazyfree;
	long unsigned int anonymous_thp;
	long unsigned int shmem_thp;
	long unsigned int file_thp;
	long unsigned int swap;
	long unsigned int shared_hugetlb;
	long unsigned int private_hugetlb;
	long unsigned int ksm;
	u64 pss;
	u64 pss_anon;
	u64 pss_file;
	u64 pss_shmem;
	u64 pss_dirty;
	u64 pss_locked;
	u64 swap_pss;
};

enum clear_refs_types {
	CLEAR_REFS_ALL = 1,
	CLEAR_REFS_ANON = 2,
	CLEAR_REFS_MAPPED = 3,
	CLEAR_REFS_SOFT_DIRTY = 4,
	CLEAR_REFS_MM_HIWATER_RSS = 5,
	CLEAR_REFS_LAST = 6,
};

struct clear_refs_private {
	enum clear_refs_types type;
};

typedef struct {
	u64 pme;
} pagemap_entry_t;

struct pagemapread {
	int pos;
	int len;
	pagemap_entry_t *buffer;
	bool show_pfn;
};

struct numa_maps {
	long unsigned int pages;
	long unsigned int anon;
	long unsigned int active;
	long unsigned int writeback;
	long unsigned int mapcount_max;
	long unsigned int dirty;
	long unsigned int swapcache;
	long unsigned int node[256];
};

struct numa_maps_private {
	struct proc_maps_private proc_maps;
	struct numa_maps md;
};

struct ipc_ids {
	int in_use;
	short unsigned int seq;
	struct rw_semaphore rwsem;
	struct idr ipcs_idr;
	int max_idx;
	int last_idx;
	int next_id;
	struct rhashtable key_ht;
};

struct ipc_namespace {
	struct ipc_ids ids[3];
	int sem_ctls[4];
	int used_sems;
	unsigned int msg_ctlmax;
	unsigned int msg_ctlmnb;
	unsigned int msg_ctlmni;
	struct percpu_counter percpu_msg_bytes;
	struct percpu_counter percpu_msg_hdrs;
	size_t shm_ctlmax;
	size_t shm_ctlall;
	long unsigned int shm_tot;
	int shm_ctlmni;
	int shm_rmid_forced;
	struct notifier_block ipcns_nb;
	struct vfsmount *mq_mnt;
	unsigned int mq_queues_count;
	unsigned int mq_queues_max;
	unsigned int mq_msg_max;
	unsigned int mq_msgsize_max;
	unsigned int mq_msg_default;
	unsigned int mq_msgsize_default;
	struct ctl_table_set mq_set;
	struct ctl_table_header *mq_sysctls;
	struct ctl_table_set ipc_set;
	struct ctl_table_header *ipc_sysctls;
	struct user_namespace *user_ns;
	struct ucounts *ucounts;
	struct llist_node mnt_llist;
	struct ns_common ns;
};

typedef struct dentry *instantiate_t(struct dentry *, struct task_struct *, const void *);

enum kernfs_node_type {
	KERNFS_DIR = 1,
	KERNFS_FILE = 2,
	KERNFS_LINK = 4,
};

enum kernfs_node_flag {
	KERNFS_ACTIVATED = 16,
	KERNFS_NS = 32,
	KERNFS_HAS_SEQ_SHOW = 64,
	KERNFS_HAS_MMAP = 128,
	KERNFS_LOCKDEP = 256,
	KERNFS_HIDDEN = 512,
	KERNFS_SUICIDAL = 1024,
	KERNFS_SUICIDED = 2048,
	KERNFS_EMPTY_DIR = 4096,
	KERNFS_HAS_RELEASE = 8192,
	KERNFS_REMOVING = 16384,
};

enum kernfs_root_flag {
	KERNFS_ROOT_CREATE_DEACTIVATED = 1,
	KERNFS_ROOT_EXTRA_OPEN_PERM_CHECK = 2,
	KERNFS_ROOT_SUPPORT_EXPORTOP = 4,
	KERNFS_ROOT_SUPPORT_USER_XATTR = 8,
};

struct kernfs_syscall_ops;

struct kernfs_root {
	struct kernfs_node *kn;
	unsigned int flags;
	struct idr ino_idr;
	u32 last_id_lowbits;
	u32 id_highbits;
	struct kernfs_syscall_ops *syscall_ops;
	struct list_head supers;
	wait_queue_head_t deactivate_waitq;
	struct rw_semaphore kernfs_rwsem;
	struct rw_semaphore kernfs_iattr_rwsem;
	struct rw_semaphore kernfs_supers_rwsem;
};

struct kernfs_iattrs {
	kuid_t ia_uid;
	kgid_t ia_gid;
	struct timespec64 ia_atime;
	struct timespec64 ia_mtime;
	struct timespec64 ia_ctime;
	struct simple_xattrs xattrs;
	atomic_t nr_user_xattrs;
	atomic_t user_xattr_size;
};

struct kernfs_syscall_ops {
	int (*show_options)(struct seq_file *, struct kernfs_root *);
	int (*mkdir)(struct kernfs_node *, const char *, umode_t);
	int (*rmdir)(struct kernfs_node *);
	int (*rename)(struct kernfs_node *, struct kernfs_node *, const char *);
	int (*show_path)(struct seq_file *, struct kernfs_node *, struct kernfs_root *);
};

struct kernfs_fs_context {
	struct kernfs_root *root;
	void *ns_tag;
	long unsigned int magic;
	bool new_sb_created;
};

struct buffer_head;

typedef void bh_end_io_t(struct buffer_head *, int);

struct buffer_head {
	long unsigned int b_state;
	struct buffer_head *b_this_page;
	union {
		struct page *b_page;
		struct folio *b_folio;
	};
	sector_t b_blocknr;
	size_t b_size;
	char *b_data;
	struct block_device *b_bdev;
	bh_end_io_t *b_end_io;
	void *b_private;
	struct list_head b_assoc_buffers;
	struct address_space *b_assoc_map;
	atomic_t b_count;
	spinlock_t b_uptodate_lock;
};

struct fiemap_extent;

struct fiemap_extent_info {
	unsigned int fi_flags;
	unsigned int fi_extents_mapped;
	unsigned int fi_extents_max;
	struct fiemap_extent *fi_extents_start;
};

typedef unsigned int tid_t;

struct transaction_chp_stats_s {
	long unsigned int cs_chp_time;
	__u32 cs_forced_to_close;
	__u32 cs_written;
	__u32 cs_dropped;
};

struct journal_s;

typedef struct journal_s journal_t;

struct journal_head;

struct transaction_s;

typedef struct transaction_s transaction_t;

struct transaction_s {
	journal_t *t_journal;
	tid_t t_tid;
	enum {
		T_RUNNING = 0,
		T_LOCKED = 1,
		T_SWITCH = 2,
		T_FLUSH = 3,
		T_COMMIT = 4,
		T_COMMIT_DFLUSH = 5,
		T_COMMIT_JFLUSH = 6,
		T_COMMIT_CALLBACK = 7,
		T_FINISHED = 8,
	} t_state;
	long unsigned int t_log_start;
	int t_nr_buffers;
	struct journal_head *t_reserved_list;
	struct journal_head *t_buffers;
	struct journal_head *t_forget;
	struct journal_head *t_checkpoint_list;
	struct journal_head *t_shadow_list;
	struct list_head t_inode_list;
	long unsigned int t_max_wait;
	long unsigned int t_start;
	long unsigned int t_requested;
	struct transaction_chp_stats_s t_chp_stats;
	atomic_t t_updates;
	atomic_t t_outstanding_credits;
	atomic_t t_outstanding_revokes;
	atomic_t t_handle_count;
	transaction_t *t_cpnext;
	transaction_t *t_cpprev;
	long unsigned int t_expires;
	ktime_t t_start_time;
	unsigned int t_synchronous_commit: 1;
	int t_need_data_flush;
	struct list_head t_private_list;
};

struct jbd2_buffer_trigger_type;

struct journal_head {
	struct buffer_head *b_bh;
	spinlock_t b_state_lock;
	int b_jcount;
	unsigned int b_jlist;
	unsigned int b_modified;
	char *b_frozen_data;
	char *b_committed_data;
	transaction_t *b_transaction;
	transaction_t *b_next_transaction;
	struct journal_head *b_tnext;
	struct journal_head *b_tprev;
	transaction_t *b_cp_transaction;
	struct journal_head *b_cpnext;
	struct journal_head *b_cpprev;
	struct jbd2_buffer_trigger_type *b_triggers;
	struct jbd2_buffer_trigger_type *b_frozen_triggers;
};

struct jbd2_buffer_trigger_type {
	void (*t_frozen)(struct jbd2_buffer_trigger_type *, struct buffer_head *, void *, size_t);
	void (*t_abort)(struct jbd2_buffer_trigger_type *, struct buffer_head *);
};

struct crypto_alg;

struct crypto_tfm {
	refcount_t refcnt;
	u32 crt_flags;
	int node;
	void (*exit)(struct crypto_tfm *);
	struct crypto_alg *__crt_alg;
	void *__crt_ctx[0];
};

struct cipher_alg {
	unsigned int cia_min_keysize;
	unsigned int cia_max_keysize;
	int (*cia_setkey)(struct crypto_tfm *, const u8 *, unsigned int);
	void (*cia_encrypt)(struct crypto_tfm *, u8 *, const u8 *);
	void (*cia_decrypt)(struct crypto_tfm *, u8 *, const u8 *);
};

struct compress_alg {
	int (*coa_compress)(struct crypto_tfm *, const u8 *, unsigned int, u8 *, unsigned int *);
	int (*coa_decompress)(struct crypto_tfm *, const u8 *, unsigned int, u8 *, unsigned int *);
};

struct crypto_type;

struct crypto_alg {
	struct list_head cra_list;
	struct list_head cra_users;
	u32 cra_flags;
	unsigned int cra_blocksize;
	unsigned int cra_ctxsize;
	unsigned int cra_alignmask;
	int cra_priority;
	refcount_t cra_refcnt;
	char cra_name[128];
	char cra_driver_name[128];
	const struct crypto_type *cra_type;
	union {
		struct cipher_alg cipher;
		struct compress_alg compress;
	} cra_u;
	int (*cra_init)(struct crypto_tfm *);
	void (*cra_exit)(struct crypto_tfm *);
	void (*cra_destroy)(struct crypto_alg *);
	struct module *cra_module;
};

struct crypto_instance;

struct crypto_type {
	unsigned int (*ctxsize)(struct crypto_alg *, u32, u32);
	unsigned int (*extsize)(struct crypto_alg *);
	int (*init_tfm)(struct crypto_tfm *);
	void (*show)(struct seq_file *, struct crypto_alg *);
	int (*report)(struct sk_buff *, struct crypto_alg *);
	void (*free)(struct crypto_instance *);
	unsigned int type;
	unsigned int maskclear;
	unsigned int maskset;
	unsigned int tfmsize;
};

struct crypto_shash {
	unsigned int descsize;
	struct crypto_tfm base;
};

struct transaction_run_stats_s {
	long unsigned int rs_wait;
	long unsigned int rs_request_delay;
	long unsigned int rs_running;
	long unsigned int rs_locked;
	long unsigned int rs_flushing;
	long unsigned int rs_logging;
	__u32 rs_handle_count;
	__u32 rs_blocks;
	__u32 rs_blocks_logged;
};

struct transaction_stats_s {
	long unsigned int ts_tid;
	long unsigned int ts_requested;
	struct transaction_run_stats_s run;
};

enum passtype {
	PASS_SCAN = 0,
	PASS_REVOKE = 1,
	PASS_REPLAY = 2,
};

struct journal_superblock_s;

typedef struct journal_superblock_s journal_superblock_t;

struct jbd2_revoke_table_s;

struct jbd2_inode;

struct journal_s {
	long unsigned int j_flags;
	long unsigned int j_atomic_flags;
	int j_errno;
	struct mutex j_abort_mutex;
	struct buffer_head *j_sb_buffer;
	journal_superblock_t *j_superblock;
	rwlock_t j_state_lock;
	int j_barrier_count;
	struct mutex j_barrier;
	transaction_t *j_running_transaction;
	transaction_t *j_committing_transaction;
	transaction_t *j_checkpoint_transactions;
	wait_queue_head_t j_wait_transaction_locked;
	wait_queue_head_t j_wait_done_commit;
	wait_queue_head_t j_wait_commit;
	wait_queue_head_t j_wait_updates;
	wait_queue_head_t j_wait_reserved;
	wait_queue_head_t j_fc_wait;
	struct mutex j_checkpoint_mutex;
	struct buffer_head *j_chkpt_bhs[64];
	struct shrinker j_shrinker;
	struct percpu_counter j_checkpoint_jh_count;
	transaction_t *j_shrink_transaction;
	long unsigned int j_head;
	long unsigned int j_tail;
	long unsigned int j_free;
	long unsigned int j_first;
	long unsigned int j_last;
	long unsigned int j_fc_first;
	long unsigned int j_fc_off;
	long unsigned int j_fc_last;
	struct block_device *j_dev;
	int j_blocksize;
	long long unsigned int j_blk_offset;
	char j_devname[56];
	struct block_device *j_fs_dev;
	unsigned int j_total_len;
	atomic_t j_reserved_credits;
	spinlock_t j_list_lock;
	struct inode *j_inode;
	tid_t j_tail_sequence;
	tid_t j_transaction_sequence;
	tid_t j_commit_sequence;
	tid_t j_commit_request;
	__u8 j_uuid[16];
	struct task_struct *j_task;
	int j_max_transaction_buffers;
	int j_revoke_records_per_block;
	long unsigned int j_commit_interval;
	struct timer_list j_commit_timer;
	spinlock_t j_revoke_lock;
	struct jbd2_revoke_table_s *j_revoke;
	struct jbd2_revoke_table_s *j_revoke_table[2];
	struct buffer_head **j_wbuf;
	struct buffer_head **j_fc_wbuf;
	int j_wbufsize;
	int j_fc_wbufsize;
	pid_t j_last_sync_writer;
	u64 j_average_commit_time;
	u32 j_min_batch_time;
	u32 j_max_batch_time;
	void (*j_commit_callback)(journal_t *, transaction_t *);
	int (*j_submit_inode_data_buffers)(struct jbd2_inode *);
	int (*j_finish_inode_data_buffers)(struct jbd2_inode *);
	spinlock_t j_history_lock;
	struct proc_dir_entry *j_proc_entry;
	struct transaction_stats_s j_stats;
	unsigned int j_failed_commit;
	void *j_private;
	struct crypto_shash *j_chksum_driver;
	__u32 j_csum_seed;
	void (*j_fc_cleanup_callback)(struct journal_s *, int, tid_t);
	int (*j_fc_replay_callback)(struct journal_s *, struct buffer_head *, enum passtype, int, tid_t);
	int (*j_bmap)(struct journal_s *, sector_t *);
};

struct journal_header_s {
	__be32 h_magic;
	__be32 h_blocktype;
	__be32 h_sequence;
};

typedef struct journal_header_s journal_header_t;

struct journal_superblock_s {
	journal_header_t s_header;
	__be32 s_blocksize;
	__be32 s_maxlen;
	__be32 s_first;
	__be32 s_sequence;
	__be32 s_start;
	__be32 s_errno;
	__be32 s_feature_compat;
	__be32 s_feature_incompat;
	__be32 s_feature_ro_compat;
	__u8 s_uuid[16];
	__be32 s_nr_users;
	__be32 s_dynsuper;
	__be32 s_max_transaction;
	__be32 s_max_trans_data;
	__u8 s_checksum_type;
	__u8 s_padding2[3];
	__be32 s_num_fc_blks;
	__be32 s_head;
	__u32 s_padding[40];
	__be32 s_checksum;
	__u8 s_users[768];
};

struct jbd2_inode {
	transaction_t *i_transaction;
	transaction_t *i_next_transaction;
	struct list_head i_list;
	struct inode *i_vfs_inode;
	long unsigned int i_flags;
	loff_t i_dirty_start;
	loff_t i_dirty_end;
};

struct bgl_lock {
	spinlock_t lock;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct blockgroup_lock {
	struct bgl_lock locks[128];
};

struct fiemap_extent {
	__u64 fe_logical;
	__u64 fe_physical;
	__u64 fe_length;
	__u64 fe_reserved64[2];
	__u32 fe_flags;
	__u32 fe_reserved[3];
};

struct fscrypt_dummy_policy {};

typedef int ext4_grpblk_t;

typedef long long unsigned int ext4_fsblk_t;

typedef __u32 ext4_lblk_t;

typedef unsigned int ext4_group_t;

struct ext4_system_blocks {
	struct rb_root root;
	struct callback_head rcu;
};

struct flex_groups {
	atomic64_t free_clusters;
	atomic_t free_inodes;
	atomic_t used_dirs;
};

enum {
	ES_WRITTEN_B = 0,
	ES_UNWRITTEN_B = 1,
	ES_DELAYED_B = 2,
	ES_HOLE_B = 3,
	ES_REFERENCED_B = 4,
	ES_FLAGS = 5,
};

struct extent_status {
	struct rb_node rb_node;
	ext4_lblk_t es_lblk;
	ext4_lblk_t es_len;
	ext4_fsblk_t es_pblk;
};

struct ext4_es_tree {
	struct rb_root root;
	struct extent_status *cache_es;
};

struct ext4_es_stats {
	long unsigned int es_stats_shrunk;
	struct percpu_counter es_stats_cache_hits;
	struct percpu_counter es_stats_cache_misses;
	u64 es_stats_scan_time;
	u64 es_stats_max_scan_time;
	struct percpu_counter es_stats_all_cnt;
	struct percpu_counter es_stats_shk_cnt;
};

struct pending_reservation {
	struct rb_node rb_node;
	ext4_lblk_t lclu;
};

struct ext4_pending_tree {
	struct rb_root root;
};

struct ext4_fc_stats {
	unsigned int fc_ineligible_reason_count[10];
	long unsigned int fc_num_commits;
	long unsigned int fc_ineligible_commits;
	long unsigned int fc_failed_commits;
	long unsigned int fc_skipped_commits;
	long unsigned int fc_numblks;
	u64 s_fc_avg_commit_time;
};

struct ext4_fc_alloc_region {
	ext4_lblk_t lblk;
	ext4_fsblk_t pblk;
	int ino;
	int len;
};

struct ext4_fc_replay_state {
	int fc_replay_num_tags;
	int fc_replay_expected_off;
	int fc_current_pass;
	int fc_cur_tag;
	int fc_crc;
	struct ext4_fc_alloc_region *fc_regions;
	int fc_regions_size;
	int fc_regions_used;
	int fc_regions_valid;
	int *fc_modified_inodes;
	int fc_modified_inodes_used;
	int fc_modified_inodes_size;
};

struct ext4_inode_info {
	__le32 i_data[15];
	__u32 i_dtime;
	ext4_fsblk_t i_file_acl;
	ext4_group_t i_block_group;
	ext4_lblk_t i_dir_start_lookup;
	long unsigned int i_flags;
	struct rw_semaphore xattr_sem;
	union {
		struct list_head i_orphan;
		unsigned int i_orphan_idx;
	};
	struct list_head i_fc_dilist;
	struct list_head i_fc_list;
	ext4_lblk_t i_fc_lblk_start;
	ext4_lblk_t i_fc_lblk_len;
	atomic_t i_fc_updates;
	wait_queue_head_t i_fc_wait;
	struct mutex i_fc_lock;
	loff_t i_disksize;
	struct rw_semaphore i_data_sem;
	struct inode vfs_inode;
	struct jbd2_inode *jinode;
	spinlock_t i_raw_lock;
	struct timespec64 i_crtime;
	atomic_t i_prealloc_active;
	struct rb_root i_prealloc_node;
	rwlock_t i_prealloc_lock;
	struct ext4_es_tree i_es_tree;
	rwlock_t i_es_lock;
	struct list_head i_es_list;
	unsigned int i_es_all_nr;
	unsigned int i_es_shk_nr;
	ext4_lblk_t i_es_shrink_lblk;
	ext4_group_t i_last_alloc_group;
	unsigned int i_reserved_data_blocks;
	struct ext4_pending_tree i_pending_tree;
	__u16 i_extra_isize;
	u16 i_inline_off;
	u16 i_inline_size;
	spinlock_t i_completed_io_lock;
	struct list_head i_rsv_conversion_list;
	struct work_struct i_rsv_conversion_work;
	atomic_t i_unwritten;
	spinlock_t i_block_reservation_lock;
	tid_t i_sync_tid;
	tid_t i_datasync_tid;
	__u32 i_csum_seed;
	kprojid_t i_projid;
};

struct ext4_super_block {
	__le32 s_inodes_count;
	__le32 s_blocks_count_lo;
	__le32 s_r_blocks_count_lo;
	__le32 s_free_blocks_count_lo;
	__le32 s_free_inodes_count;
	__le32 s_first_data_block;
	__le32 s_log_block_size;
	__le32 s_log_cluster_size;
	__le32 s_blocks_per_group;
	__le32 s_clusters_per_group;
	__le32 s_inodes_per_group;
	__le32 s_mtime;
	__le32 s_wtime;
	__le16 s_mnt_count;
	__le16 s_max_mnt_count;
	__le16 s_magic;
	__le16 s_state;
	__le16 s_errors;
	__le16 s_minor_rev_level;
	__le32 s_lastcheck;
	__le32 s_checkinterval;
	__le32 s_creator_os;
	__le32 s_rev_level;
	__le16 s_def_resuid;
	__le16 s_def_resgid;
	__le32 s_first_ino;
	__le16 s_inode_size;
	__le16 s_block_group_nr;
	__le32 s_feature_compat;
	__le32 s_feature_incompat;
	__le32 s_feature_ro_compat;
	__u8 s_uuid[16];
	char s_volume_name[16];
	char s_last_mounted[64];
	__le32 s_algorithm_usage_bitmap;
	__u8 s_prealloc_blocks;
	__u8 s_prealloc_dir_blocks;
	__le16 s_reserved_gdt_blocks;
	__u8 s_journal_uuid[16];
	__le32 s_journal_inum;
	__le32 s_journal_dev;
	__le32 s_last_orphan;
	__le32 s_hash_seed[4];
	__u8 s_def_hash_version;
	__u8 s_jnl_backup_type;
	__le16 s_desc_size;
	__le32 s_default_mount_opts;
	__le32 s_first_meta_bg;
	__le32 s_mkfs_time;
	__le32 s_jnl_blocks[17];
	__le32 s_blocks_count_hi;
	__le32 s_r_blocks_count_hi;
	__le32 s_free_blocks_count_hi;
	__le16 s_min_extra_isize;
	__le16 s_want_extra_isize;
	__le32 s_flags;
	__le16 s_raid_stride;
	__le16 s_mmp_update_interval;
	__le64 s_mmp_block;
	__le32 s_raid_stripe_width;
	__u8 s_log_groups_per_flex;
	__u8 s_checksum_type;
	__u8 s_encryption_level;
	__u8 s_reserved_pad;
	__le64 s_kbytes_written;
	__le32 s_snapshot_inum;
	__le32 s_snapshot_id;
	__le64 s_snapshot_r_blocks_count;
	__le32 s_snapshot_list;
	__le32 s_error_count;
	__le32 s_first_error_time;
	__le32 s_first_error_ino;
	__le64 s_first_error_block;
	__u8 s_first_error_func[32];
	__le32 s_first_error_line;
	__le32 s_last_error_time;
	__le32 s_last_error_ino;
	__le32 s_last_error_line;
	__le64 s_last_error_block;
	__u8 s_last_error_func[32];
	__u8 s_mount_opts[64];
	__le32 s_usr_quota_inum;
	__le32 s_grp_quota_inum;
	__le32 s_overhead_clusters;
	__le32 s_backup_bgs[2];
	__u8 s_encrypt_algos[4];
	__u8 s_encrypt_pw_salt[16];
	__le32 s_lpf_ino;
	__le32 s_prj_quota_inum;
	__le32 s_checksum_seed;
	__u8 s_wtime_hi;
	__u8 s_mtime_hi;
	__u8 s_mkfs_time_hi;
	__u8 s_lastcheck_hi;
	__u8 s_first_error_time_hi;
	__u8 s_last_error_time_hi;
	__u8 s_first_error_errcode;
	__u8 s_last_error_errcode;
	__le16 s_encoding;
	__le16 s_encoding_flags;
	__le32 s_orphan_file_inum;
	__le32 s_reserved[94];
	__le32 s_checksum;
};

struct ext4_journal_trigger {
	struct jbd2_buffer_trigger_type tr_triggers;
	struct super_block *sb;
};

struct ext4_orphan_block {
	atomic_t ob_free_entries;
	struct buffer_head *ob_bh;
};

struct ext4_orphan_info {
	int of_blocks;
	__u32 of_csum_seed;
	struct ext4_orphan_block *of_binfo;
};

struct mb_cache;

struct ext4_group_info;

struct ext4_locality_group;

struct ext4_li_request;

struct dax_device;

struct ext4_sb_info {
	long unsigned int s_desc_size;
	long unsigned int s_inodes_per_block;
	long unsigned int s_blocks_per_group;
	long unsigned int s_clusters_per_group;
	long unsigned int s_inodes_per_group;
	long unsigned int s_itb_per_group;
	long unsigned int s_gdb_count;
	long unsigned int s_desc_per_block;
	ext4_group_t s_groups_count;
	ext4_group_t s_blockfile_groups;
	long unsigned int s_overhead;
	unsigned int s_cluster_ratio;
	unsigned int s_cluster_bits;
	loff_t s_bitmap_maxbytes;
	struct buffer_head *s_sbh;
	struct ext4_super_block *s_es;
	struct buffer_head **s_group_desc;
	unsigned int s_mount_opt;
	unsigned int s_mount_opt2;
	long unsigned int s_mount_flags;
	unsigned int s_def_mount_opt;
	unsigned int s_def_mount_opt2;
	ext4_fsblk_t s_sb_block;
	atomic64_t s_resv_clusters;
	kuid_t s_resuid;
	kgid_t s_resgid;
	short unsigned int s_mount_state;
	short unsigned int s_pad;
	int s_addr_per_block_bits;
	int s_desc_per_block_bits;
	int s_inode_size;
	int s_first_ino;
	unsigned int s_inode_readahead_blks;
	unsigned int s_inode_goal;
	u32 s_hash_seed[4];
	int s_def_hash_version;
	int s_hash_unsigned;
	struct percpu_counter s_freeclusters_counter;
	struct percpu_counter s_freeinodes_counter;
	struct percpu_counter s_dirs_counter;
	struct percpu_counter s_dirtyclusters_counter;
	struct percpu_counter s_sra_exceeded_retry_limit;
	struct blockgroup_lock *s_blockgroup_lock;
	struct proc_dir_entry *s_proc;
	struct kobject s_kobj;
	struct completion s_kobj_unregister;
	struct super_block *s_sb;
	struct buffer_head *s_mmp_bh;
	struct journal_s *s_journal;
	long unsigned int s_ext4_flags;
	struct mutex s_orphan_lock;
	struct list_head s_orphan;
	struct ext4_orphan_info s_orphan_info;
	long unsigned int s_commit_interval;
	u32 s_max_batch_time;
	u32 s_min_batch_time;
	struct block_device *s_journal_bdev;
	unsigned int s_want_extra_isize;
	struct ext4_system_blocks *s_system_blks;
	struct ext4_group_info ***s_group_info;
	struct inode *s_buddy_cache;
	spinlock_t s_md_lock;
	short unsigned int *s_mb_offsets;
	unsigned int *s_mb_maxs;
	unsigned int s_group_info_size;
	unsigned int s_mb_free_pending;
	struct list_head s_freed_data_list;
	struct list_head s_discard_list;
	struct work_struct s_discard_work;
	atomic_t s_retry_alloc_pending;
	struct list_head *s_mb_avg_fragment_size;
	rwlock_t *s_mb_avg_fragment_size_locks;
	struct list_head *s_mb_largest_free_orders;
	rwlock_t *s_mb_largest_free_orders_locks;
	long unsigned int s_stripe;
	unsigned int s_mb_max_linear_groups;
	unsigned int s_mb_stream_request;
	unsigned int s_mb_max_to_scan;
	unsigned int s_mb_min_to_scan;
	unsigned int s_mb_stats;
	unsigned int s_mb_order2_reqs;
	unsigned int s_mb_group_prealloc;
	unsigned int s_max_dir_size_kb;
	long unsigned int s_mb_last_group;
	long unsigned int s_mb_last_start;
	unsigned int s_mb_prefetch;
	unsigned int s_mb_prefetch_limit;
	unsigned int s_mb_best_avail_max_trim_order;
	atomic_t s_bal_reqs;
	atomic_t s_bal_success;
	atomic_t s_bal_allocated;
	atomic_t s_bal_ex_scanned;
	atomic_t s_bal_cX_ex_scanned[5];
	atomic_t s_bal_groups_scanned;
	atomic_t s_bal_goals;
	atomic_t s_bal_len_goals;
	atomic_t s_bal_breaks;
	atomic_t s_bal_2orders;
	atomic_t s_bal_p2_aligned_bad_suggestions;
	atomic_t s_bal_goal_fast_bad_suggestions;
	atomic_t s_bal_best_avail_bad_suggestions;
	atomic64_t s_bal_cX_groups_considered[5];
	atomic64_t s_bal_cX_hits[5];
	atomic64_t s_bal_cX_failed[5];
	atomic_t s_mb_buddies_generated;
	atomic64_t s_mb_generation_time;
	atomic_t s_mb_lost_chunks;
	atomic_t s_mb_preallocated;
	atomic_t s_mb_discarded;
	atomic_t s_lock_busy;
	struct ext4_locality_group *s_locality_groups;
	long unsigned int s_sectors_written_start;
	u64 s_kbytes_written;
	unsigned int s_extent_max_zeroout_kb;
	unsigned int s_log_groups_per_flex;
	struct flex_groups **s_flex_groups;
	ext4_group_t s_flex_groups_allocated;
	struct workqueue_struct *rsv_conversion_wq;
	struct timer_list s_err_report;
	struct ext4_li_request *s_li_request;
	unsigned int s_li_wait_mult;
	struct task_struct *s_mmp_tsk;
	long unsigned int s_last_trim_minblks;
	struct crypto_shash *s_chksum_driver;
	__u32 s_csum_seed;
	struct shrinker s_es_shrinker;
	struct list_head s_es_list;
	long int s_es_nr_inode;
	struct ext4_es_stats s_es_stats;
	struct mb_cache *s_ea_block_cache;
	struct mb_cache *s_ea_inode_cache;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	spinlock_t s_es_lock;
	struct ext4_journal_trigger s_journal_triggers[1];
	struct ratelimit_state s_err_ratelimit_state;
	struct ratelimit_state s_warning_ratelimit_state;
	struct ratelimit_state s_msg_ratelimit_state;
	atomic_t s_warning_count;
	atomic_t s_msg_count;
	struct fscrypt_dummy_policy s_dummy_enc_policy;
	struct percpu_rw_semaphore s_writepages_rwsem;
	struct dax_device *s_daxdev;
	u64 s_dax_part_off;
	errseq_t s_bdev_wb_err;
	spinlock_t s_bdev_wb_lock;
	spinlock_t s_error_lock;
	int s_add_error_count;
	int s_first_error_code;
	__u32 s_first_error_line;
	__u32 s_first_error_ino;
	__u64 s_first_error_block;
	const char *s_first_error_func;
	time64_t s_first_error_time;
	int s_last_error_code;
	__u32 s_last_error_line;
	__u32 s_last_error_ino;
	__u64 s_last_error_block;
	const char *s_last_error_func;
	time64_t s_last_error_time;
	struct work_struct s_sb_upd_work;
	atomic_t s_fc_subtid;
	struct list_head s_fc_q[2];
	struct list_head s_fc_dentry_q[2];
	unsigned int s_fc_bytes;
	spinlock_t s_fc_lock;
	struct buffer_head *s_fc_bh;
	struct ext4_fc_stats s_fc_stats;
	tid_t s_fc_ineligible_tid;
	struct ext4_fc_replay_state s_fc_replay_state;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct ext4_group_info {
	long unsigned int bb_state;
	struct rb_root bb_free_root;
	ext4_grpblk_t bb_first_free;
	ext4_grpblk_t bb_free;
	ext4_grpblk_t bb_fragments;
	int bb_avg_fragment_size_order;
	ext4_grpblk_t bb_largest_free_order;
	ext4_group_t bb_group;
	struct list_head bb_prealloc_list;
	struct rw_semaphore alloc_sem;
	struct list_head bb_avg_fragment_size_node;
	struct list_head bb_largest_free_order_node;
	ext4_grpblk_t bb_counters[0];
};

enum ext4_li_mode {
	EXT4_LI_MODE_PREFETCH_BBITMAP = 0,
	EXT4_LI_MODE_ITABLE = 1,
};

struct ext4_li_request {
	struct super_block *lr_super;
	enum ext4_li_mode lr_mode;
	ext4_group_t lr_first_not_zeroed;
	ext4_group_t lr_next_group;
	struct list_head lr_request;
	long unsigned int lr_next_sched;
	long unsigned int lr_timeout;
};

enum {
	EXT4_STATE_NEW = 0,
	EXT4_STATE_XATTR = 1,
	EXT4_STATE_NO_EXPAND = 2,
	EXT4_STATE_DA_ALLOC_CLOSE = 3,
	EXT4_STATE_EXT_MIGRATE = 4,
	EXT4_STATE_NEWENTRY = 5,
	EXT4_STATE_MAY_INLINE_DATA = 6,
	EXT4_STATE_EXT_PRECACHED = 7,
	EXT4_STATE_LUSTRE_EA_INODE = 8,
	EXT4_STATE_VERITY_IN_PROGRESS = 9,
	EXT4_STATE_FC_COMMITTING = 10,
	EXT4_STATE_ORPHAN_FILE = 11,
};

struct rsvd_count {
	int ndelonly;
	bool first_do_lblk_found;
	ext4_lblk_t first_do_lblk;
	ext4_lblk_t last_do_lblk;
	struct extent_status *left_es;
	bool partial;
	ext4_lblk_t lclu;
};

typedef short unsigned int __kernel_uid16_t;

typedef short unsigned int __kernel_gid16_t;

typedef __kernel_uid16_t uid16_t;

typedef __kernel_gid16_t gid16_t;

typedef int get_block_t(struct inode *, sector_t, struct buffer_head *, int);

enum req_flag_bits {
	__REQ_FAILFAST_DEV = 8,
	__REQ_FAILFAST_TRANSPORT = 9,
	__REQ_FAILFAST_DRIVER = 10,
	__REQ_SYNC = 11,
	__REQ_META = 12,
	__REQ_PRIO = 13,
	__REQ_NOMERGE = 14,
	__REQ_IDLE = 15,
	__REQ_INTEGRITY = 16,
	__REQ_FUA = 17,
	__REQ_PREFLUSH = 18,
	__REQ_RAHEAD = 19,
	__REQ_BACKGROUND = 20,
	__REQ_NOWAIT = 21,
	__REQ_POLLED = 22,
	__REQ_ALLOC_CACHE = 23,
	__REQ_SWAP = 24,
	__REQ_DRV = 25,
	__REQ_FS_PRIVATE = 26,
	__REQ_NOUNMAP = 27,
	__REQ_NR_BITS = 28,
};

enum bh_state_bits {
	BH_Uptodate = 0,
	BH_Dirty = 1,
	BH_Lock = 2,
	BH_Req = 3,
	BH_Mapped = 4,
	BH_New = 5,
	BH_Async_Read = 6,
	BH_Async_Write = 7,
	BH_Delay = 8,
	BH_Boundary = 9,
	BH_Write_EIO = 10,
	BH_Unwritten = 11,
	BH_Quiet = 12,
	BH_Meta = 13,
	BH_Prio = 14,
	BH_Defer_Completion = 15,
	BH_PrivateStart = 16,
};

struct iomap_folio_ops;

struct iomap {
	u64 addr;
	loff_t offset;
	u64 length;
	u16 type;
	u16 flags;
	struct block_device *bdev;
	struct dax_device *dax_dev;
	void *inline_data;
	void *private;
	const struct iomap_folio_ops *folio_ops;
	u64 validity_cookie;
};

struct iomap_iter;

struct iomap_folio_ops {
	struct folio * (*get_folio)(struct iomap_iter *, loff_t, unsigned int);
	void (*put_folio)(struct inode *, loff_t, unsigned int, struct folio *);
	bool (*iomap_valid)(struct inode *, const struct iomap *);
};

struct iomap_iter {
	struct inode *inode;
	loff_t pos;
	u64 len;
	s64 processed;
	unsigned int flags;
	struct iomap iomap;
	struct iomap srcmap;
	void *private;
};

struct iomap_ops {
	int (*iomap_begin)(struct inode *, loff_t, loff_t, unsigned int, struct iomap *, struct iomap *);
	int (*iomap_end)(struct inode *, loff_t, loff_t, ssize_t, unsigned int, struct iomap *);
};

struct shash_desc {
	struct crypto_shash *tfm;
	void *__ctx[0];
};

struct jbd2_journal_handle;

typedef struct jbd2_journal_handle handle_t;

struct jbd2_journal_handle {
	union {
		transaction_t *h_transaction;
		journal_t *h_journal;
	};
	handle_t *h_rsv_handle;
	int h_total_credits;
	int h_revoke_credits;
	int h_revoke_credits_requested;
	int h_ref;
	int h_err;
	unsigned int h_sync: 1;
	unsigned int h_jdata: 1;
	unsigned int h_reserved: 1;
	unsigned int h_aborted: 1;
	unsigned int h_type: 8;
	unsigned int h_line_no: 16;
	long unsigned int h_start_jiffies;
	unsigned int h_requested_credits;
	unsigned int saved_alloc_context;
};

enum jbd_state_bits {
	BH_JBD = 16,
	BH_JWrite = 17,
	BH_Freed = 18,
	BH_Revoked = 19,
	BH_RevokeValid = 20,
	BH_JBDDirty = 21,
	BH_JournalHead = 22,
	BH_Shadow = 23,
	BH_Verified = 24,
	BH_JBDPrivateStart = 25,
};

struct ext4_map_blocks {
	ext4_fsblk_t m_pblk;
	ext4_lblk_t m_lblk;
	unsigned int m_len;
	unsigned int m_flags;
};

struct ext4_io_end_vec {
	struct list_head list;
	loff_t offset;
	ssize_t size;
};

struct ext4_io_end {
	struct list_head list;
	handle_t *handle;
	struct inode *inode;
	struct bio *bio;
	unsigned int flag;
	refcount_t count;
	struct list_head list_vec;
};

typedef struct ext4_io_end ext4_io_end_t;

struct ext4_io_submit {
	struct writeback_control *io_wbc;
	struct bio *io_bio;
	ext4_io_end_t *io_end;
	sector_t io_next_block;
};

struct ext4_group_desc {
	__le32 bg_block_bitmap_lo;
	__le32 bg_inode_bitmap_lo;
	__le32 bg_inode_table_lo;
	__le16 bg_free_blocks_count_lo;
	__le16 bg_free_inodes_count_lo;
	__le16 bg_used_dirs_count_lo;
	__le16 bg_flags;
	__le32 bg_exclude_bitmap_lo;
	__le16 bg_block_bitmap_csum_lo;
	__le16 bg_inode_bitmap_csum_lo;
	__le16 bg_itable_unused_lo;
	__le16 bg_checksum;
	__le32 bg_block_bitmap_hi;
	__le32 bg_inode_bitmap_hi;
	__le32 bg_inode_table_hi;
	__le16 bg_free_blocks_count_hi;
	__le16 bg_free_inodes_count_hi;
	__le16 bg_used_dirs_count_hi;
	__le16 bg_itable_unused_hi;
	__le32 bg_exclude_bitmap_hi;
	__le16 bg_block_bitmap_csum_hi;
	__le16 bg_inode_bitmap_csum_hi;
	__u32 bg_reserved;
};

enum {
	EXT4_INODE_SECRM = 0,
	EXT4_INODE_UNRM = 1,
	EXT4_INODE_COMPR = 2,
	EXT4_INODE_SYNC = 3,
	EXT4_INODE_IMMUTABLE = 4,
	EXT4_INODE_APPEND = 5,
	EXT4_INODE_NODUMP = 6,
	EXT4_INODE_NOATIME = 7,
	EXT4_INODE_DIRTY = 8,
	EXT4_INODE_COMPRBLK = 9,
	EXT4_INODE_NOCOMPR = 10,
	EXT4_INODE_ENCRYPT = 11,
	EXT4_INODE_INDEX = 12,
	EXT4_INODE_IMAGIC = 13,
	EXT4_INODE_JOURNAL_DATA = 14,
	EXT4_INODE_NOTAIL = 15,
	EXT4_INODE_DIRSYNC = 16,
	EXT4_INODE_TOPDIR = 17,
	EXT4_INODE_HUGE_FILE = 18,
	EXT4_INODE_EXTENTS = 19,
	EXT4_INODE_VERITY = 20,
	EXT4_INODE_EA_INODE = 21,
	EXT4_INODE_DAX = 25,
	EXT4_INODE_INLINE_DATA = 28,
	EXT4_INODE_PROJINHERIT = 29,
	EXT4_INODE_CASEFOLD = 30,
	EXT4_INODE_RESERVED = 31,
};

struct ext4_inode {
	__le16 i_mode;
	__le16 i_uid;
	__le32 i_size_lo;
	__le32 i_atime;
	__le32 i_ctime;
	__le32 i_mtime;
	__le32 i_dtime;
	__le16 i_gid;
	__le16 i_links_count;
	__le32 i_blocks_lo;
	__le32 i_flags;
	union {
		struct {
			__le32 l_i_version;
		} linux1;
		struct {
			__u32 h_i_translator;
		} hurd1;
		struct {
			__u32 m_i_reserved1;
		} masix1;
	} osd1;
	__le32 i_block[15];
	__le32 i_generation;
	__le32 i_file_acl_lo;
	__le32 i_size_high;
	__le32 i_obso_faddr;
	union {
		struct {
			__le16 l_i_blocks_high;
			__le16 l_i_file_acl_high;
			__le16 l_i_uid_high;
			__le16 l_i_gid_high;
			__le16 l_i_checksum_lo;
			__le16 l_i_reserved;
		} linux2;
		struct {
			__le16 h_i_reserved1;
			__u16 h_i_mode_high;
			__u16 h_i_uid_high;
			__u16 h_i_gid_high;
			__u32 h_i_author;
		} hurd2;
		struct {
			__le16 h_i_reserved1;
			__le16 m_i_file_acl_high;
			__u32 m_i_reserved2[2];
		} masix2;
	} osd2;
	__le16 i_extra_isize;
	__le16 i_checksum_hi;
	__le32 i_ctime_extra;
	__le32 i_mtime_extra;
	__le32 i_atime_extra;
	__le32 i_crtime;
	__le32 i_crtime_extra;
	__le32 i_version_hi;
	__le32 i_projid;
};

enum {
	EXT4_FC_REASON_XATTR = 0,
	EXT4_FC_REASON_CROSS_RENAME = 1,
	EXT4_FC_REASON_JOURNAL_FLAG_CHANGE = 2,
	EXT4_FC_REASON_NOMEM = 3,
	EXT4_FC_REASON_SWAP_BOOT = 4,
	EXT4_FC_REASON_RESIZE = 5,
	EXT4_FC_REASON_RENAME_DIR = 6,
	EXT4_FC_REASON_FALLOC_RANGE = 7,
	EXT4_FC_REASON_INODE_JOURNAL_DATA = 8,
	EXT4_FC_REASON_ENCRYPTED_FILENAME = 9,
	EXT4_FC_REASON_MAX = 10,
};

enum ext4_journal_trigger_type {
	EXT4_JTR_ORPHAN_FILE = 0,
	EXT4_JTR_NONE = 1,
};

struct ext4_iloc {
	struct buffer_head *bh;
	long unsigned int offset;
	ext4_group_t block_group;
};

typedef enum {
	EXT4_IGET_NORMAL = 0,
	EXT4_IGET_SPECIAL = 1,
	EXT4_IGET_HANDLE = 2,
	EXT4_IGET_BAD = 4,
	EXT4_IGET_EA_INODE = 8,
} ext4_iget_flags;

struct ext4_xattr_ibody_header {
	__le32 h_magic;
};

struct ext4_xattr_inode_array {
	unsigned int count;
	struct inode *inodes[0];
};

struct mpage_da_data {
	struct inode *inode;
	struct writeback_control *wbc;
	unsigned int can_map: 1;
	long unsigned int first_page;
	long unsigned int next_page;
	long unsigned int last_page;
	struct ext4_map_blocks map;
	struct ext4_io_submit io_submit;
	unsigned int do_map: 1;
	unsigned int scanned_until_end: 1;
	unsigned int journalled_more_data: 1;
};

struct fsverity_info;

struct fscrypt_info;

struct disk_stats {
	u64 nsecs[4];
	long unsigned int sectors[4];
	long unsigned int ios[4];
	long unsigned int merges[4];
	long unsigned int io_ticks;
	local_t in_flight[2];
};

enum stat_group {
	STAT_READ = 0,
	STAT_WRITE = 1,
	STAT_DISCARD = 2,
	STAT_FLUSH = 3,
	NR_STAT_GROUPS = 4,
};

enum {
	attr_noop = 0,
	attr_delayed_allocation_blocks = 1,
	attr_session_write_kbytes = 2,
	attr_lifetime_write_kbytes = 3,
	attr_reserved_clusters = 4,
	attr_sra_exceeded_retry_limit = 5,
	attr_inode_readahead = 6,
	attr_trigger_test_error = 7,
	attr_first_error_time = 8,
	attr_last_error_time = 9,
	attr_feature = 10,
	attr_pointer_ui = 11,
	attr_pointer_ul = 12,
	attr_pointer_u64 = 13,
	attr_pointer_u8 = 14,
	attr_pointer_string = 15,
	attr_pointer_atomic = 16,
	attr_journal_task = 17,
};

enum {
	ptr_explicit = 0,
	ptr_ext4_sb_info_offset = 1,
	ptr_ext4_super_block_offset = 2,
};

struct ext4_attr {
	struct attribute attr;
	short int attr_id;
	short int attr_ptr;
	short unsigned int attr_size;
	union {
		int offset;
		void *explicit_ptr;
	} u;
};

typedef struct {
	__le16 e_tag;
	__le16 e_perm;
	__le32 e_id;
} ext4_acl_entry;

typedef struct {
	__le32 a_version;
} ext4_acl_header;

struct ramfs_mount_opts {
	umode_t mode;
};

struct ramfs_fs_info {
	struct ramfs_mount_opts mount_opts;
};

enum ramfs_param {
	Opt_mode___2 = 0,
};

struct fstrim_range {
	__u64 start;
	__u64 len;
	__u64 minlen;
};

enum file_time_flags {
	S_ATIME = 1,
	S_MTIME = 2,
	S_CTIME = 4,
	S_VERSION = 8,
};

typedef u16 wchar_t;

struct nls_table {
	const char *charset;
	const char *alias;
	int (*uni2char)(wchar_t, unsigned char *, int);
	int (*char2uni)(const unsigned char *, int, wchar_t *);
	const unsigned char *charset2lower;
	const unsigned char *charset2upper;
	struct module *owner;
	struct nls_table *next;
};

struct fat_mount_options {
	kuid_t fs_uid;
	kgid_t fs_gid;
	short unsigned int fs_fmask;
	short unsigned int fs_dmask;
	short unsigned int codepage;
	int time_offset;
	char *iocharset;
	short unsigned int shortname;
	unsigned char name_check;
	unsigned char errors;
	unsigned char nfs;
	short unsigned int allow_utime;
	unsigned int quiet: 1;
	unsigned int showexec: 1;
	unsigned int sys_immutable: 1;
	unsigned int dotsOK: 1;
	unsigned int isvfat: 1;
	unsigned int utf8: 1;
	unsigned int unicode_xlate: 1;
	unsigned int numtail: 1;
	unsigned int flush: 1;
	unsigned int nocase: 1;
	unsigned int usefree: 1;
	unsigned int tz_set: 1;
	unsigned int rodir: 1;
	unsigned int discard: 1;
	unsigned int dos1xfloppy: 1;
};

struct fatent_operations;

struct msdos_sb_info {
	short unsigned int sec_per_clus;
	short unsigned int cluster_bits;
	unsigned int cluster_size;
	unsigned char fats;
	unsigned char fat_bits;
	short unsigned int fat_start;
	long unsigned int fat_length;
	long unsigned int dir_start;
	short unsigned int dir_entries;
	long unsigned int data_start;
	long unsigned int max_cluster;
	long unsigned int root_cluster;
	long unsigned int fsinfo_sector;
	struct mutex fat_lock;
	struct mutex nfs_build_inode_lock;
	struct mutex s_lock;
	unsigned int prev_free;
	unsigned int free_clusters;
	unsigned int free_clus_valid;
	struct fat_mount_options options;
	struct nls_table *nls_disk;
	struct nls_table *nls_io;
	const void *dir_ops;
	int dir_per_block;
	int dir_per_block_bits;
	unsigned int vol_id;
	int fatent_shift;
	const struct fatent_operations *fatent_ops;
	struct inode *fat_inode;
	struct inode *fsinfo_inode;
	struct ratelimit_state ratelimit;
	spinlock_t inode_hash_lock;
	struct hlist_head inode_hashtable[256];
	spinlock_t dir_hash_lock;
	struct hlist_head dir_hashtable[256];
	unsigned int dirty;
	struct callback_head rcu;
};

struct fat_entry;

struct fatent_operations {
	void (*ent_blocknr)(struct super_block *, int, int *, sector_t *);
	void (*ent_set_ptr)(struct fat_entry *, int);
	int (*ent_bread)(struct super_block *, struct fat_entry *, int, sector_t);
	int (*ent_get)(struct fat_entry *);
	void (*ent_put)(struct fat_entry *, int);
	int (*ent_next)(struct fat_entry *);
};

struct msdos_inode_info {
	spinlock_t cache_lru_lock;
	struct list_head cache_lru;
	int nr_caches;
	unsigned int cache_valid_id;
	loff_t mmu_private;
	int i_start;
	int i_logstart;
	int i_attrs;
	loff_t i_pos;
	struct hlist_node i_fat_hash;
	struct hlist_node i_dir_hash;
	struct rw_semaphore truncate_lock;
	struct timespec64 i_crtime;
	struct inode vfs_inode;
};

struct fat_entry {
	int entry;
	union {
		u8 *ent12_p[2];
		__le16 *ent16_p;
		__le32 *ent32_p;
	} u;
	int nr_bhs;
	struct buffer_head *bhs[2];
	struct inode *fat_inode;
};

typedef void (*exitcall_t)();

typedef int wait_bit_action_f(struct wait_bit_key *, int);

typedef u32 rpc_authflavor_t;

struct net_generic {
	union {
		struct {
			unsigned int len;
			struct callback_head rcu;
		} s;
		struct {
			struct {} __empty_ptr;
			void *ptr[0];
		};
	};
};

struct pernet_operations {
	struct list_head list;
	int (*init)(struct net *);
	void (*pre_exit)(struct net *);
	void (*exit)(struct net *);
	void (*exit_batch)(struct list_head *);
	unsigned int *id;
	size_t size;
};

struct xdr_buf {
	struct kvec head[1];
	struct kvec tail[1];
	struct bio_vec *bvec;
	struct page **pages;
	unsigned int page_base;
	unsigned int page_len;
	unsigned int flags;
	unsigned int buflen;
	unsigned int len;
};

struct rpc_rqst;

struct xdr_stream {
	__be32 *p;
	struct xdr_buf *buf;
	__be32 *end;
	struct kvec *iov;
	struct kvec scratch;
	struct page **page_ptr;
	void *page_kaddr;
	unsigned int nwords;
	struct rpc_rqst *rqst;
};

struct rpc_xprt;

struct rpc_task;

struct rpc_cred;

struct rpc_rqst {
	struct rpc_xprt *rq_xprt;
	struct xdr_buf rq_snd_buf;
	struct xdr_buf rq_rcv_buf;
	struct rpc_task *rq_task;
	struct rpc_cred *rq_cred;
	__be32 rq_xid;
	int rq_cong;
	u32 rq_seqno;
	int rq_enc_pages_num;
	struct page **rq_enc_pages;
	void (*rq_release_snd_buf)(struct rpc_rqst *);
	union {
		struct list_head rq_list;
		struct rb_node rq_recv;
	};
	struct list_head rq_xmit;
	struct list_head rq_xmit2;
	void *rq_buffer;
	size_t rq_callsize;
	void *rq_rbuffer;
	size_t rq_rcvsize;
	size_t rq_xmit_bytes_sent;
	size_t rq_reply_bytes_recvd;
	struct xdr_buf rq_private_buf;
	long unsigned int rq_majortimeo;
	long unsigned int rq_minortimeo;
	long unsigned int rq_timeout;
	ktime_t rq_rtt;
	unsigned int rq_retries;
	unsigned int rq_connect_cookie;
	atomic_t rq_pin;
	u32 rq_bytes_sent;
	ktime_t rq_xtime;
	int rq_ntrans;
};

typedef void (*kxdreproc_t)(struct rpc_rqst *, struct xdr_stream *, const void *);

typedef int (*kxdrdproc_t)(struct rpc_rqst *, struct xdr_stream *, void *);

struct rpc_procinfo;

struct rpc_message {
	const struct rpc_procinfo *rpc_proc;
	void *rpc_argp;
	void *rpc_resp;
	const struct cred *rpc_cred;
};

struct rpc_procinfo {
	u32 p_proc;
	kxdreproc_t p_encode;
	kxdrdproc_t p_decode;
	unsigned int p_arglen;
	unsigned int p_replen;
	unsigned int p_timer;
	u32 p_statidx;
	const char *p_name;
};

struct rpc_wait {
	struct list_head list;
	struct list_head links;
	struct list_head timer_list;
};

struct rpc_wait_queue;

struct rpc_call_ops;

struct rpc_clnt;

struct rpc_task {
	atomic_t tk_count;
	int tk_status;
	struct list_head tk_task;
	void (*tk_callback)(struct rpc_task *);
	void (*tk_action)(struct rpc_task *);
	long unsigned int tk_timeout;
	long unsigned int tk_runstate;
	struct rpc_wait_queue *tk_waitqueue;
	union {
		struct work_struct tk_work;
		struct rpc_wait tk_wait;
	} u;
	struct rpc_message tk_msg;
	void *tk_calldata;
	const struct rpc_call_ops *tk_ops;
	struct rpc_clnt *tk_client;
	struct rpc_xprt *tk_xprt;
	struct rpc_cred *tk_op_cred;
	struct rpc_rqst *tk_rqstp;
	struct workqueue_struct *tk_workqueue;
	ktime_t tk_start;
	pid_t tk_owner;
	int tk_rpc_status;
	short unsigned int tk_flags;
	short unsigned int tk_timeouts;
	short unsigned int tk_pid;
	unsigned char tk_priority: 2;
	unsigned char tk_garb_retry: 2;
	unsigned char tk_cred_retry: 2;
};

struct rpc_timer {
	struct list_head list;
	long unsigned int expires;
	struct delayed_work dwork;
};

struct rpc_wait_queue {
	spinlock_t lock;
	struct list_head tasks[4];
	unsigned char maxpriority;
	unsigned char priority;
	unsigned char nr;
	short unsigned int qlen;
	struct rpc_timer timer_list;
	const char *name;
};

struct rpc_call_ops {
	void (*rpc_call_prepare)(struct rpc_task *, void *);
	void (*rpc_call_done)(struct rpc_task *, void *);
	void (*rpc_count_stats)(struct rpc_task *, void *);
	void (*rpc_release)(void *);
};

enum xprtsec_policies {
	RPC_XPRTSEC_NONE = 0,
	RPC_XPRTSEC_TLS_ANON = 1,
	RPC_XPRTSEC_TLS_X509 = 2,
};

struct xprtsec_parms {
	enum xprtsec_policies policy;
	key_serial_t cert_serial;
	key_serial_t privkey_serial;
};

struct rpc_pipe_dir_head {
	struct list_head pdh_entries;
	struct dentry *pdh_dentry;
};

struct rpc_rtt {
	long unsigned int timeo;
	long unsigned int srtt[5];
	long unsigned int sdrtt[5];
	int ntimeouts[5];
};

struct rpc_timeout {
	long unsigned int to_initval;
	long unsigned int to_maxval;
	long unsigned int to_increment;
	unsigned int to_retries;
	unsigned char to_exponential;
};

struct rpc_xprt_switch;

struct rpc_xprt_iter_ops;

struct rpc_xprt_iter {
	struct rpc_xprt_switch *xpi_xpswitch;
	struct rpc_xprt *xpi_cursor;
	const struct rpc_xprt_iter_ops *xpi_ops;
};

struct rpc_auth;

struct rpc_stat;

struct rpc_iostats;

struct rpc_program;

struct rpc_sysfs_client;

struct rpc_clnt {
	refcount_t cl_count;
	unsigned int cl_clid;
	struct list_head cl_clients;
	struct list_head cl_tasks;
	atomic_t cl_pid;
	spinlock_t cl_lock;
	struct rpc_xprt *cl_xprt;
	const struct rpc_procinfo *cl_procinfo;
	u32 cl_prog;
	u32 cl_vers;
	u32 cl_maxproc;
	struct rpc_auth *cl_auth;
	struct rpc_stat *cl_stats;
	struct rpc_iostats *cl_metrics;
	unsigned int cl_softrtry: 1;
	unsigned int cl_softerr: 1;
	unsigned int cl_discrtry: 1;
	unsigned int cl_noretranstimeo: 1;
	unsigned int cl_autobind: 1;
	unsigned int cl_chatty: 1;
	unsigned int cl_shutdown: 1;
	struct xprtsec_parms cl_xprtsec;
	struct rpc_rtt *cl_rtt;
	const struct rpc_timeout *cl_timeout;
	atomic_t cl_swapper;
	int cl_nodelen;
	char cl_nodename[65];
	struct rpc_pipe_dir_head cl_pipedir_objects;
	struct rpc_clnt *cl_parent;
	struct rpc_rtt cl_rtt_default;
	struct rpc_timeout cl_timeout_default;
	const struct rpc_program *cl_program;
	const char *cl_principal;
	struct rpc_sysfs_client *cl_sysfs;
	union {
		struct rpc_xprt_iter cl_xpi;
		struct work_struct cl_work;
	};
	const struct cred *cl_cred;
	unsigned int cl_max_connect;
};

struct rpc_xprt_ops;

struct svc_xprt;

struct xprt_class;

struct rpc_sysfs_xprt;

struct rpc_xprt {
	struct kref kref;
	const struct rpc_xprt_ops *ops;
	unsigned int id;
	const struct rpc_timeout *timeout;
	struct __kernel_sockaddr_storage addr;
	size_t addrlen;
	int prot;
	long unsigned int cong;
	long unsigned int cwnd;
	size_t max_payload;
	struct rpc_wait_queue binding;
	struct rpc_wait_queue sending;
	struct rpc_wait_queue pending;
	struct rpc_wait_queue backlog;
	struct list_head free;
	unsigned int max_reqs;
	unsigned int min_reqs;
	unsigned int num_reqs;
	long unsigned int state;
	unsigned char resvport: 1;
	unsigned char reuseport: 1;
	atomic_t swapper;
	unsigned int bind_index;
	struct list_head xprt_switch;
	long unsigned int bind_timeout;
	long unsigned int reestablish_timeout;
	struct xprtsec_parms xprtsec;
	unsigned int connect_cookie;
	struct work_struct task_cleanup;
	struct timer_list timer;
	long unsigned int last_used;
	long unsigned int idle_timeout;
	long unsigned int connect_timeout;
	long unsigned int max_reconnect_timeout;
	atomic_long_t queuelen;
	spinlock_t transport_lock;
	spinlock_t reserve_lock;
	spinlock_t queue_lock;
	u32 xid;
	struct rpc_task *snd_task;
	struct list_head xmit_queue;
	atomic_long_t xmit_queuelen;
	struct svc_xprt *bc_xprt;
	struct rb_root recv_queue;
	struct {
		long unsigned int bind_count;
		long unsigned int connect_count;
		long unsigned int connect_start;
		long unsigned int connect_time;
		long unsigned int sends;
		long unsigned int recvs;
		long unsigned int bad_xids;
		long unsigned int max_slots;
		long long unsigned int req_u;
		long long unsigned int bklog_u;
		long long unsigned int sending_u;
		long long unsigned int pending_u;
	} stat;
	struct net *xprt_net;
	netns_tracker ns_tracker;
	const char *servername;
	const char *address_strings[6];
	struct callback_head rcu;
	const struct xprt_class *xprt_class;
	struct rpc_sysfs_xprt *xprt_sysfs;
	bool main;
};

struct rpc_credops;

struct rpc_cred {
	struct hlist_node cr_hash;
	struct list_head cr_lru;
	struct callback_head cr_rcu;
	struct rpc_auth *cr_auth;
	const struct rpc_credops *cr_ops;
	long unsigned int cr_expire;
	long unsigned int cr_flags;
	refcount_t cr_count;
	const struct cred *cr_cred;
};

struct rpc_task_setup {
	struct rpc_task *task;
	struct rpc_clnt *rpc_client;
	struct rpc_xprt *rpc_xprt;
	struct rpc_cred *rpc_op_cred;
	const struct rpc_message *rpc_message;
	const struct rpc_call_ops *callback_ops;
	void *callback_data;
	struct workqueue_struct *workqueue;
	short unsigned int flags;
	signed char priority;
};

struct rpc_xprt_ops {
	void (*set_buffer_size)(struct rpc_xprt *, size_t, size_t);
	int (*reserve_xprt)(struct rpc_xprt *, struct rpc_task *);
	void (*release_xprt)(struct rpc_xprt *, struct rpc_task *);
	void (*alloc_slot)(struct rpc_xprt *, struct rpc_task *);
	void (*free_slot)(struct rpc_xprt *, struct rpc_rqst *);
	void (*rpcbind)(struct rpc_task *);
	void (*set_port)(struct rpc_xprt *, short unsigned int);
	void (*connect)(struct rpc_xprt *, struct rpc_task *);
	int (*get_srcaddr)(struct rpc_xprt *, char *, size_t);
	short unsigned int (*get_srcport)(struct rpc_xprt *);
	int (*buf_alloc)(struct rpc_task *);
	void (*buf_free)(struct rpc_task *);
	int (*prepare_request)(struct rpc_rqst *, struct xdr_buf *);
	int (*send_request)(struct rpc_rqst *);
	void (*wait_for_reply_request)(struct rpc_task *);
	void (*timer)(struct rpc_xprt *, struct rpc_task *);
	void (*release_request)(struct rpc_task *);
	void (*close)(struct rpc_xprt *);
	void (*destroy)(struct rpc_xprt *);
	void (*set_connect_timeout)(struct rpc_xprt *, long unsigned int, long unsigned int);
	void (*print_stats)(struct rpc_xprt *, struct seq_file *);
	int (*enable_swap)(struct rpc_xprt *);
	void (*disable_swap)(struct rpc_xprt *);
	void (*inject_disconnect)(struct rpc_xprt *);
	int (*bc_setup)(struct rpc_xprt *, unsigned int);
	size_t (*bc_maxpayload)(struct rpc_xprt *);
	unsigned int (*bc_num_slots)(struct rpc_xprt *);
	void (*bc_free_rqst)(struct rpc_rqst *);
	void (*bc_destroy)(struct rpc_xprt *, unsigned int);
};

struct xprt_create;

struct xprt_class {
	struct list_head list;
	int ident;
	struct rpc_xprt * (*setup)(struct xprt_create *);
	struct module *owner;
	char name[32];
	const char *netid[0];
};

struct xprt_create {
	int ident;
	struct net *net;
	struct sockaddr *srcaddr;
	struct sockaddr *dstaddr;
	size_t addrlen;
	const char *servername;
	struct svc_xprt *bc_xprt;
	struct rpc_xprt_switch *bc_xps;
	unsigned int flags;
	struct xprtsec_parms xprtsec;
	long unsigned int connect_timeout;
	long unsigned int reconnect_timeout;
};

struct rpc_sysfs_xprt_switch;

struct rpc_xprt_switch {
	spinlock_t xps_lock;
	struct kref xps_kref;
	unsigned int xps_id;
	unsigned int xps_nxprts;
	unsigned int xps_nactive;
	unsigned int xps_nunique_destaddr_xprts;
	atomic_long_t xps_queuelen;
	struct list_head xps_xprt_list;
	struct net *xps_net;
	const struct rpc_xprt_iter_ops *xps_iter_ops;
	struct rpc_sysfs_xprt_switch *xps_sysfs;
	struct callback_head xps_rcu;
};

struct auth_cred {
	const struct cred *cred;
	const char *principal;
};

struct rpc_authops;

struct rpc_cred_cache;

struct rpc_auth {
	unsigned int au_cslack;
	unsigned int au_rslack;
	unsigned int au_verfsize;
	unsigned int au_ralign;
	long unsigned int au_flags;
	const struct rpc_authops *au_ops;
	rpc_authflavor_t au_flavor;
	refcount_t au_count;
	struct rpc_cred_cache *au_credcache;
};

struct rpc_credops {
	const char *cr_name;
	int (*cr_init)(struct rpc_auth *, struct rpc_cred *);
	void (*crdestroy)(struct rpc_cred *);
	int (*crmatch)(struct auth_cred *, struct rpc_cred *, int);
	int (*crmarshal)(struct rpc_task *, struct xdr_stream *);
	int (*crrefresh)(struct rpc_task *);
	int (*crvalidate)(struct rpc_task *, struct xdr_stream *);
	int (*crwrap_req)(struct rpc_task *, struct xdr_stream *);
	int (*crunwrap_resp)(struct rpc_task *, struct xdr_stream *);
	int (*crkey_timeout)(struct rpc_cred *);
	char * (*crstringify_acceptor)(struct rpc_cred *);
	bool (*crneed_reencode)(struct rpc_task *);
};

struct rpc_auth_create_args;

struct rpcsec_gss_info;

struct rpc_authops {
	struct module *owner;
	rpc_authflavor_t au_flavor;
	char *au_name;
	struct rpc_auth * (*create)(const struct rpc_auth_create_args *, struct rpc_clnt *);
	void (*destroy)(struct rpc_auth *);
	int (*hash_cred)(struct auth_cred *, unsigned int);
	struct rpc_cred * (*lookup_cred)(struct rpc_auth *, struct auth_cred *, int);
	struct rpc_cred * (*crcreate)(struct rpc_auth *, struct auth_cred *, int, gfp_t);
	rpc_authflavor_t (*info2flavor)(struct rpcsec_gss_info *);
	int (*flavor2info)(rpc_authflavor_t, struct rpcsec_gss_info *);
	int (*key_timeout)(struct rpc_auth *, struct rpc_cred *);
	int (*ping)(struct rpc_clnt *);
};

struct rpc_auth_create_args {
	rpc_authflavor_t pseudoflavor;
	const char *target_name;
};

struct rpcsec_gss_oid {
	unsigned int len;
	u8 data[32];
};

struct rpcsec_gss_info {
	struct rpcsec_gss_oid oid;
	u32 qop;
	u32 service;
};

struct rpc_stat {
	const struct rpc_program *program;
	unsigned int netcnt;
	unsigned int netudpcnt;
	unsigned int nettcpcnt;
	unsigned int nettcpconn;
	unsigned int netreconn;
	unsigned int rpccnt;
	unsigned int rpcretrans;
	unsigned int rpcauthrefresh;
	unsigned int rpcgarbage;
};

struct rpc_version;

struct rpc_program {
	const char *name;
	u32 number;
	unsigned int nrvers;
	const struct rpc_version **version;
	struct rpc_stat *stats;
	const char *pipe_dir_name;
};

struct rpc_xprt_iter_ops {
	void (*xpi_rewind)(struct rpc_xprt_iter *);
	struct rpc_xprt * (*xpi_xprt)(struct rpc_xprt_iter *);
	struct rpc_xprt * (*xpi_next)(struct rpc_xprt_iter *);
};

struct rpc_sysfs_client {
	struct kobject kobject;
	struct net *net;
	struct rpc_clnt *clnt;
	struct rpc_xprt_switch *xprt_switch;
};

struct rpc_iostats {
	spinlock_t om_lock;
	long unsigned int om_ops;
	long unsigned int om_ntrans;
	long unsigned int om_timeouts;
	long long unsigned int om_bytes_sent;
	long long unsigned int om_bytes_recv;
	ktime_t om_queue;
	ktime_t om_rtt;
	ktime_t om_execute;
	long unsigned int om_error_status;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct rpc_version {
	u32 number;
	unsigned int nrprocs;
	const struct rpc_procinfo *procs;
	unsigned int *counts;
};

struct nfs_fh {
	short unsigned int size;
	unsigned char data[128];
};

enum nfs3_stable_how {
	NFS_UNSTABLE = 0,
	NFS_DATA_SYNC = 1,
	NFS_FILE_SYNC = 2,
	NFS_INVALID_STABLE_HOW = -1,
};

struct nfs4_label {
	uint32_t lfs;
	uint32_t pi;
	u32 len;
	char *label;
};

typedef struct {
	char data[8];
} nfs4_verifier;

struct nfs4_stateid_struct {
	union {
		char data[16];
		struct {
			__be32 seqid;
			char other[12];
		};
	};
	enum {
		NFS4_INVALID_STATEID_TYPE = 0,
		NFS4_SPECIAL_STATEID_TYPE = 1,
		NFS4_OPEN_STATEID_TYPE = 2,
		NFS4_LOCK_STATEID_TYPE = 3,
		NFS4_DELEGATION_STATEID_TYPE = 4,
		NFS4_LAYOUT_STATEID_TYPE = 5,
		NFS4_PNFS_DS_STATEID_TYPE = 6,
		NFS4_REVOKED_STATEID_TYPE = 7,
	} type;
};

typedef struct nfs4_stateid_struct nfs4_stateid;

enum nfs_opnum4 {
	OP_ACCESS = 3,
	OP_CLOSE = 4,
	OP_COMMIT = 5,
	OP_CREATE = 6,
	OP_DELEGPURGE = 7,
	OP_DELEGRETURN = 8,
	OP_GETATTR = 9,
	OP_GETFH = 10,
	OP_LINK = 11,
	OP_LOCK = 12,
	OP_LOCKT = 13,
	OP_LOCKU = 14,
	OP_LOOKUP = 15,
	OP_LOOKUPP = 16,
	OP_NVERIFY = 17,
	OP_OPEN = 18,
	OP_OPENATTR = 19,
	OP_OPEN_CONFIRM = 20,
	OP_OPEN_DOWNGRADE = 21,
	OP_PUTFH = 22,
	OP_PUTPUBFH = 23,
	OP_PUTROOTFH = 24,
	OP_READ = 25,
	OP_READDIR = 26,
	OP_READLINK = 27,
	OP_REMOVE = 28,
	OP_RENAME = 29,
	OP_RENEW = 30,
	OP_RESTOREFH = 31,
	OP_SAVEFH = 32,
	OP_SECINFO = 33,
	OP_SETATTR = 34,
	OP_SETCLIENTID = 35,
	OP_SETCLIENTID_CONFIRM = 36,
	OP_VERIFY = 37,
	OP_WRITE = 38,
	OP_RELEASE_LOCKOWNER = 39,
	OP_BACKCHANNEL_CTL = 40,
	OP_BIND_CONN_TO_SESSION = 41,
	OP_EXCHANGE_ID = 42,
	OP_CREATE_SESSION = 43,
	OP_DESTROY_SESSION = 44,
	OP_FREE_STATEID = 45,
	OP_GET_DIR_DELEGATION = 46,
	OP_GETDEVICEINFO = 47,
	OP_GETDEVICELIST = 48,
	OP_LAYOUTCOMMIT = 49,
	OP_LAYOUTGET = 50,
	OP_LAYOUTRETURN = 51,
	OP_SECINFO_NO_NAME = 52,
	OP_SEQUENCE = 53,
	OP_SET_SSV = 54,
	OP_TEST_STATEID = 55,
	OP_WANT_DELEGATION = 56,
	OP_DESTROY_CLIENTID = 57,
	OP_RECLAIM_COMPLETE = 58,
	OP_ALLOCATE = 59,
	OP_COPY = 60,
	OP_COPY_NOTIFY = 61,
	OP_DEALLOCATE = 62,
	OP_IO_ADVISE = 63,
	OP_LAYOUTERROR = 64,
	OP_LAYOUTSTATS = 65,
	OP_OFFLOAD_CANCEL = 66,
	OP_OFFLOAD_STATUS = 67,
	OP_READ_PLUS = 68,
	OP_SEEK = 69,
	OP_WRITE_SAME = 70,
	OP_CLONE = 71,
	OP_GETXATTR = 72,
	OP_SETXATTR = 73,
	OP_LISTXATTRS = 74,
	OP_REMOVEXATTR = 75,
	OP_ILLEGAL = 10044,
};

enum nfs4_change_attr_type {
	NFS4_CHANGE_TYPE_IS_MONOTONIC_INCR = 0,
	NFS4_CHANGE_TYPE_IS_VERSION_COUNTER = 1,
	NFS4_CHANGE_TYPE_IS_VERSION_COUNTER_NOPNFS = 2,
	NFS4_CHANGE_TYPE_IS_TIME_METADATA = 3,
	NFS4_CHANGE_TYPE_IS_UNDEFINED = 4,
};

struct nfs4_string {
	unsigned int len;
	char *data;
};

struct nfs_fsid {
	uint64_t major;
	uint64_t minor;
};

struct nfs4_threshold {
	__u32 bm;
	__u32 l_type;
	__u64 rd_sz;
	__u64 wr_sz;
	__u64 rd_io_sz;
	__u64 wr_io_sz;
};

struct nfs_fattr {
	unsigned int valid;
	umode_t mode;
	__u32 nlink;
	kuid_t uid;
	kgid_t gid;
	dev_t rdev;
	__u64 size;
	union {
		struct {
			__u32 blocksize;
			__u32 blocks;
		} nfs2;
		struct {
			__u64 used;
		} nfs3;
	} du;
	struct nfs_fsid fsid;
	__u64 fileid;
	__u64 mounted_on_fileid;
	struct timespec64 atime;
	struct timespec64 mtime;
	struct timespec64 ctime;
	__u64 change_attr;
	__u64 pre_change_attr;
	__u64 pre_size;
	struct timespec64 pre_mtime;
	struct timespec64 pre_ctime;
	long unsigned int time_start;
	long unsigned int gencount;
	struct nfs4_string *owner_name;
	struct nfs4_string *group_name;
	struct nfs4_threshold *mdsthreshold;
	struct nfs4_label *label;
};

struct nfs_fsinfo {
	struct nfs_fattr *fattr;
	__u32 rtmax;
	__u32 rtpref;
	__u32 rtmult;
	__u32 wtmax;
	__u32 wtpref;
	__u32 wtmult;
	__u32 dtpref;
	__u64 maxfilesize;
	struct timespec64 time_delta;
	__u32 lease_time;
	__u32 nlayouttypes;
	__u32 layouttype[8];
	__u32 blksize;
	__u32 clone_blksize;
	enum nfs4_change_attr_type change_attr_type;
	__u32 xattr_support;
};

struct nfs_fsstat {
	struct nfs_fattr *fattr;
	__u64 tbytes;
	__u64 fbytes;
	__u64 abytes;
	__u64 tfiles;
	__u64 ffiles;
	__u64 afiles;
};

struct nfs_pathconf {
	struct nfs_fattr *fattr;
	__u32 max_link;
	__u32 max_namelen;
};

struct nfs4_change_info {
	u32 atomic;
	u64 before;
	u64 after;
};

struct nfs4_slot;

struct nfs4_sequence_args {
	struct nfs4_slot *sa_slot;
	u8 sa_cache_this: 1;
	u8 sa_privileged: 1;
};

struct nfs4_sequence_res {
	struct nfs4_slot *sr_slot;
	long unsigned int sr_timestamp;
	int sr_status;
	u32 sr_status_flags;
	u32 sr_highest_slotid;
	u32 sr_target_highest_slotid;
};

struct pnfs_layout_range {
	u32 iomode;
	u64 offset;
	u64 length;
};

struct nfs_open_context;

struct nfs_lock_context {
	refcount_t count;
	struct list_head list;
	struct nfs_open_context *open_context;
	fl_owner_t lockowner;
	atomic_t io_count;
	struct callback_head callback_head;
};

struct nfs4_state;

struct nfs_open_context {
	struct nfs_lock_context lock_context;
	fl_owner_t flock_owner;
	struct dentry *dentry;
	const struct cred *cred;
	struct rpc_cred *ll_cred;
	struct nfs4_state *state;
	fmode_t mode;
	long unsigned int flags;
	int error;
	struct list_head list;
	struct nfs4_threshold *mdsthreshold;
	struct callback_head callback_head;
};

struct pnfs_layout_hdr;

struct nfs_auth_info {
	unsigned int flavor_len;
	rpc_authflavor_t flavors[12];
};

struct pnfs_layoutdriver_type;

struct nfs_client;

struct nlm_host;

struct nfs_iostats;

struct nfs_server {
	struct nfs_client *nfs_client;
	struct list_head client_link;
	struct list_head master_link;
	struct rpc_clnt *client;
	struct rpc_clnt *client_acl;
	struct nlm_host *nlm_host;
	struct nfs_iostats *io_stats;
	atomic_long_t writeback;
	unsigned int write_congested;
	unsigned int flags;
	unsigned int fattr_valid;
	unsigned int caps;
	unsigned int rsize;
	unsigned int rpages;
	unsigned int wsize;
	unsigned int wpages;
	unsigned int wtmult;
	unsigned int dtsize;
	short unsigned int port;
	unsigned int bsize;
	unsigned int acregmin;
	unsigned int acregmax;
	unsigned int acdirmin;
	unsigned int acdirmax;
	unsigned int namelen;
	unsigned int options;
	unsigned int clone_blksize;
	enum nfs4_change_attr_type change_attr_type;
	struct nfs_fsid fsid;
	int s_sysfs_id;
	__u64 maxfilesize;
	struct timespec64 time_delta;
	long unsigned int mount_time;
	struct super_block *super;
	dev_t s_dev;
	struct nfs_auth_info auth_info;
	u32 pnfs_blksize;
	u32 attr_bitmask[3];
	u32 attr_bitmask_nl[3];
	u32 exclcreat_bitmask[3];
	u32 cache_consistency_bitmask[3];
	u32 acl_bitmask;
	u32 fh_expire_type;
	struct pnfs_layoutdriver_type *pnfs_curr_ld;
	struct rpc_wait_queue roc_rpcwaitq;
	void *pnfs_ld_data;
	struct rb_root state_owners;
	struct ida openowner_id;
	struct ida lockowner_id;
	struct list_head state_owners_lru;
	struct list_head layouts;
	struct list_head delegations;
	struct list_head ss_copies;
	long unsigned int mig_gen;
	long unsigned int mig_status;
	void (*destroy)(struct nfs_server *);
	atomic_t active;
	struct __kernel_sockaddr_storage mountd_address;
	size_t mountd_addrlen;
	u32 mountd_version;
	short unsigned int mountd_port;
	short unsigned int mountd_protocol;
	struct rpc_wait_queue uoc_rpcwaitq;
	unsigned int read_hdrsize;
	const struct cred *cred;
	bool has_sec_mnt_opts;
	struct kobject kobj;
};

struct nfs41_server_owner;

struct nfs41_server_scope;

struct nfs41_impl_id;

struct nfs_rpc_ops;

struct nfs_subversion;

struct idmap;

struct nfs4_minor_version_ops;

struct nfs4_slot_table;

struct nfs4_session;

struct nfs_client {
	refcount_t cl_count;
	atomic_t cl_mds_count;
	int cl_cons_state;
	long unsigned int cl_res_state;
	long unsigned int cl_flags;
	struct __kernel_sockaddr_storage cl_addr;
	size_t cl_addrlen;
	char *cl_hostname;
	char *cl_acceptor;
	struct list_head cl_share_link;
	struct list_head cl_superblocks;
	struct rpc_clnt *cl_rpcclient;
	const struct nfs_rpc_ops *rpc_ops;
	int cl_proto;
	struct nfs_subversion *cl_nfs_mod;
	u32 cl_minorversion;
	unsigned int cl_nconnect;
	unsigned int cl_max_connect;
	const char *cl_principal;
	struct xprtsec_parms cl_xprtsec;
	struct list_head cl_ds_clients;
	u64 cl_clientid;
	nfs4_verifier cl_confirm;
	long unsigned int cl_state;
	spinlock_t cl_lock;
	long unsigned int cl_lease_time;
	long unsigned int cl_last_renewal;
	struct delayed_work cl_renewd;
	struct rpc_wait_queue cl_rpcwaitq;
	struct idmap *cl_idmap;
	const char *cl_owner_id;
	u32 cl_cb_ident;
	const struct nfs4_minor_version_ops *cl_mvops;
	long unsigned int cl_mig_gen;
	struct nfs4_slot_table *cl_slot_tbl;
	u32 cl_seqid;
	u32 cl_exchange_flags;
	struct nfs4_session *cl_session;
	bool cl_preserve_clid;
	struct nfs41_server_owner *cl_serverowner;
	struct nfs41_server_scope *cl_serverscope;
	struct nfs41_impl_id *cl_implid;
	long unsigned int cl_sp4_flags;
	char cl_ipaddr[48];
	struct net *cl_net;
	struct list_head pending_cb_stateids;
};

struct pnfs_layout_segment {
	struct list_head pls_list;
	struct list_head pls_lc_list;
	struct list_head pls_commits;
	struct pnfs_layout_range pls_range;
	refcount_t pls_refcount;
	u32 pls_seq;
	long unsigned int pls_flags;
	struct pnfs_layout_hdr *pls_layout;
};

struct nfs_seqid_counter;

struct nfs_seqid {
	struct nfs_seqid_counter *sequence;
	struct list_head list;
	struct rpc_task *task;
};

struct nfs_write_verifier {
	char data[8];
};

struct nfs_writeverf {
	struct nfs_write_verifier verifier;
	enum nfs3_stable_how committed;
};

struct nfs_pgio_args {
	struct nfs4_sequence_args seq_args;
	struct nfs_fh *fh;
	struct nfs_open_context *context;
	struct nfs_lock_context *lock_context;
	nfs4_stateid stateid;
	__u64 offset;
	__u32 count;
	unsigned int pgbase;
	struct page **pages;
	union {
		unsigned int replen;
		struct {
			const u32 *bitmask;
			u32 bitmask_store[3];
			enum nfs3_stable_how stable;
		};
	};
};

struct nfs_pgio_res {
	struct nfs4_sequence_res seq_res;
	struct nfs_fattr *fattr;
	__u64 count;
	__u32 op_status;
	union {
		struct {
			unsigned int replen;
			int eof;
			void *scratch;
		};
		struct {
			struct nfs_writeverf *verf;
			const struct nfs_server *server;
		};
	};
};

struct nfs_commitargs {
	struct nfs4_sequence_args seq_args;
	struct nfs_fh *fh;
	__u64 offset;
	__u32 count;
	const u32 *bitmask;
};

struct nfs_commitres {
	struct nfs4_sequence_res seq_res;
	__u32 op_status;
	struct nfs_fattr *fattr;
	struct nfs_writeverf *verf;
	const struct nfs_server *server;
};

struct nfs_removeargs {
	struct nfs4_sequence_args seq_args;
	const struct nfs_fh *fh;
	struct qstr name;
};

struct nfs_removeres {
	struct nfs4_sequence_res seq_res;
	struct nfs_server *server;
	struct nfs_fattr *dir_attr;
	struct nfs4_change_info cinfo;
};

struct nfs_renameargs {
	struct nfs4_sequence_args seq_args;
	const struct nfs_fh *old_dir;
	const struct nfs_fh *new_dir;
	const struct qstr *old_name;
	const struct qstr *new_name;
};

struct nfs_renameres {
	struct nfs4_sequence_res seq_res;
	struct nfs_server *server;
	struct nfs4_change_info old_cinfo;
	struct nfs_fattr *old_fattr;
	struct nfs4_change_info new_cinfo;
	struct nfs_fattr *new_fattr;
};

struct nfs_entry {
	__u64 ino;
	__u64 cookie;
	const char *name;
	unsigned int len;
	int eof;
	struct nfs_fh *fh;
	struct nfs_fattr *fattr;
	unsigned char d_type;
	struct nfs_server *server;
};

struct nfs_readdir_arg {
	struct dentry *dentry;
	const struct cred *cred;
	__be32 *verf;
	u64 cookie;
	struct page **pages;
	unsigned int page_len;
	bool plus;
};

struct nfs_readdir_res {
	__be32 *verf;
};

struct nfs4_pathname {
	unsigned int ncomponents;
	struct nfs4_string components[512];
};

struct nfs4_fs_location {
	unsigned int nservers;
	struct nfs4_string servers[10];
	struct nfs4_pathname rootpath;
};

struct nfs4_fs_locations {
	struct nfs_fattr *fattr;
	const struct nfs_server *server;
	struct nfs4_pathname fs_path;
	int nlocations;
	struct nfs4_fs_location locations[10];
};

struct pnfs_ds_commit_info {};

struct nfs_page_array {
	struct page **pagevec;
	unsigned int npages;
	struct page *page_array[8];
};

struct nfs_page;

struct nfs_pgio_completion_ops;

struct nfs_rw_ops;

struct nfs_io_completion;

struct nfs_direct_req;

struct nfs_pgio_header {
	struct inode *inode;
	const struct cred *cred;
	struct list_head pages;
	struct nfs_page *req;
	struct nfs_writeverf verf;
	fmode_t rw_mode;
	struct pnfs_layout_segment *lseg;
	loff_t io_start;
	const struct rpc_call_ops *mds_ops;
	void (*release)(struct nfs_pgio_header *);
	const struct nfs_pgio_completion_ops *completion_ops;
	const struct nfs_rw_ops *rw_ops;
	struct nfs_io_completion *io_completion;
	struct nfs_direct_req *dreq;
	int pnfs_error;
	int error;
	unsigned int good_bytes;
	long unsigned int flags;
	struct rpc_task task;
	struct nfs_fattr fattr;
	struct nfs_pgio_args args;
	struct nfs_pgio_res res;
	long unsigned int timestamp;
	int (*pgio_done_cb)(struct rpc_task *, struct nfs_pgio_header *);
	__u64 mds_offset;
	struct nfs_page_array page_array;
	struct nfs_client *ds_clp;
	u32 ds_commit_idx;
	u32 pgio_mirror_idx;
};

struct nfs_page {
	struct list_head wb_list;
	union {
		struct page *wb_page;
		struct folio *wb_folio;
	};
	struct nfs_lock_context *wb_lock_context;
	long unsigned int wb_index;
	unsigned int wb_offset;
	unsigned int wb_pgbase;
	unsigned int wb_bytes;
	struct kref wb_kref;
	long unsigned int wb_flags;
	struct nfs_write_verifier wb_verf;
	struct nfs_page *wb_this_page;
	struct nfs_page *wb_head;
	short unsigned int wb_nio;
};

struct nfs_pgio_completion_ops {
	void (*error_cleanup)(struct list_head *, int);
	void (*init_hdr)(struct nfs_pgio_header *);
	void (*completion)(struct nfs_pgio_header *);
	void (*reschedule_io)(struct nfs_pgio_header *);
};

struct nfs_rw_ops {
	struct nfs_pgio_header * (*rw_alloc_header)();
	void (*rw_free_header)(struct nfs_pgio_header *);
	int (*rw_done)(struct rpc_task *, struct nfs_pgio_header *, struct inode *);
	void (*rw_result)(struct rpc_task *, struct nfs_pgio_header *);
	void (*rw_initiate)(struct nfs_pgio_header *, struct rpc_message *, const struct nfs_rpc_ops *, struct rpc_task_setup *, int);
};

struct nfs_mds_commit_info {
	atomic_t rpcs_out;
	atomic_long_t ncommit;
	struct list_head list;
};

struct nfs_direct_req {
	struct kref kref;
	struct nfs_open_context *ctx;
	struct nfs_lock_context *l_ctx;
	struct kiocb *iocb;
	struct inode *inode;
	atomic_t io_count;
	spinlock_t lock;
	loff_t io_start;
	ssize_t count;
	ssize_t max_count;
	ssize_t bytes_left;
	ssize_t error;
	struct completion completion;
	struct nfs_mds_commit_info mds_cinfo;
	struct pnfs_ds_commit_info ds_cinfo;
	struct work_struct work;
	int flags;
};

struct nfs_commit_data;

struct nfs_commit_info;

struct nfs_commit_completion_ops {
	void (*completion)(struct nfs_commit_data *);
	void (*resched_write)(struct nfs_commit_info *, struct nfs_page *);
};

struct nfs_commit_data {
	struct rpc_task task;
	struct inode *inode;
	const struct cred *cred;
	struct nfs_fattr fattr;
	struct nfs_writeverf verf;
	struct list_head pages;
	struct list_head list;
	struct nfs_direct_req *dreq;
	struct nfs_commitargs args;
	struct nfs_commitres res;
	struct nfs_open_context *context;
	struct pnfs_layout_segment *lseg;
	struct nfs_client *ds_clp;
	int ds_commit_index;
	loff_t lwb;
	const struct rpc_call_ops *mds_ops;
	const struct nfs_commit_completion_ops *completion_ops;
	int (*commit_done_cb)(struct rpc_task *, struct nfs_commit_data *);
	long unsigned int flags;
};

struct nfs_commit_info {
	struct inode *inode;
	struct nfs_mds_commit_info *mds;
	struct pnfs_ds_commit_info *ds;
	struct nfs_direct_req *dreq;
	const struct nfs_commit_completion_ops *completion_ops;
};

struct nfs_unlinkdata {
	struct nfs_removeargs args;
	struct nfs_removeres res;
	struct dentry *dentry;
	wait_queue_head_t wq;
	const struct cred *cred;
	struct nfs_fattr dir_attr;
	long int timeout;
};

struct nfs_renamedata {
	struct nfs_renameargs args;
	struct nfs_renameres res;
	struct rpc_task task;
	const struct cred *cred;
	struct inode *old_dir;
	struct dentry *old_dentry;
	struct nfs_fattr old_fattr;
	struct inode *new_dir;
	struct dentry *new_dentry;
	struct nfs_fattr new_fattr;
	void (*complete)(struct rpc_task *, struct nfs_renamedata *);
	long int timeout;
	bool cancelled;
};

struct nlmclnt_operations;

struct nfs_access_entry;

struct nfs_client_initdata;

struct nfs_rpc_ops {
	u32 version;
	const struct dentry_operations *dentry_ops;
	const struct inode_operations *dir_inode_ops;
	const struct inode_operations *file_inode_ops;
	const struct file_operations *file_ops;
	const struct nlmclnt_operations *nlmclnt_ops;
	int (*getroot)(struct nfs_server *, struct nfs_fh *, struct nfs_fsinfo *);
	int (*submount)(struct fs_context *, struct nfs_server *);
	int (*try_get_tree)(struct fs_context *);
	int (*getattr)(struct nfs_server *, struct nfs_fh *, struct nfs_fattr *, struct inode *);
	int (*setattr)(struct dentry *, struct nfs_fattr *, struct iattr *);
	int (*lookup)(struct inode *, struct dentry *, struct nfs_fh *, struct nfs_fattr *);
	int (*lookupp)(struct inode *, struct nfs_fh *, struct nfs_fattr *);
	int (*access)(struct inode *, struct nfs_access_entry *, const struct cred *);
	int (*readlink)(struct inode *, struct page *, unsigned int, unsigned int);
	int (*create)(struct inode *, struct dentry *, struct iattr *, int);
	int (*remove)(struct inode *, struct dentry *);
	void (*unlink_setup)(struct rpc_message *, struct dentry *, struct inode *);
	void (*unlink_rpc_prepare)(struct rpc_task *, struct nfs_unlinkdata *);
	int (*unlink_done)(struct rpc_task *, struct inode *);
	void (*rename_setup)(struct rpc_message *, struct dentry *, struct dentry *);
	void (*rename_rpc_prepare)(struct rpc_task *, struct nfs_renamedata *);
	int (*rename_done)(struct rpc_task *, struct inode *, struct inode *);
	int (*link)(struct inode *, struct inode *, const struct qstr *);
	int (*symlink)(struct inode *, struct dentry *, struct page *, unsigned int, struct iattr *);
	int (*mkdir)(struct inode *, struct dentry *, struct iattr *);
	int (*rmdir)(struct inode *, const struct qstr *);
	int (*readdir)(struct nfs_readdir_arg *, struct nfs_readdir_res *);
	int (*mknod)(struct inode *, struct dentry *, struct iattr *, dev_t);
	int (*statfs)(struct nfs_server *, struct nfs_fh *, struct nfs_fsstat *);
	int (*fsinfo)(struct nfs_server *, struct nfs_fh *, struct nfs_fsinfo *);
	int (*pathconf)(struct nfs_server *, struct nfs_fh *, struct nfs_pathconf *);
	int (*set_capabilities)(struct nfs_server *, struct nfs_fh *);
	int (*decode_dirent)(struct xdr_stream *, struct nfs_entry *, bool);
	int (*pgio_rpc_prepare)(struct rpc_task *, struct nfs_pgio_header *);
	void (*read_setup)(struct nfs_pgio_header *, struct rpc_message *);
	int (*read_done)(struct rpc_task *, struct nfs_pgio_header *);
	void (*write_setup)(struct nfs_pgio_header *, struct rpc_message *, struct rpc_clnt **);
	int (*write_done)(struct rpc_task *, struct nfs_pgio_header *);
	void (*commit_setup)(struct nfs_commit_data *, struct rpc_message *, struct rpc_clnt **);
	void (*commit_rpc_prepare)(struct rpc_task *, struct nfs_commit_data *);
	int (*commit_done)(struct rpc_task *, struct nfs_commit_data *);
	int (*lock)(struct file *, int, struct file_lock *);
	int (*lock_check_bounds)(const struct file_lock *);
	void (*clear_acl_cache)(struct inode *);
	void (*close_context)(struct nfs_open_context *, int);
	struct inode * (*open_context)(struct inode *, struct nfs_open_context *, int, struct iattr *, int *);
	int (*have_delegation)(struct inode *, fmode_t);
	struct nfs_client * (*alloc_client)(const struct nfs_client_initdata *);
	struct nfs_client * (*init_client)(struct nfs_client *, const struct nfs_client_initdata *);
	void (*free_client)(struct nfs_client *);
	struct nfs_server * (*create_server)(struct fs_context *);
	struct nfs_server * (*clone_server)(struct nfs_server *, struct nfs_fh *, struct nfs_fattr *, rpc_authflavor_t);
	int (*discover_trunking)(struct nfs_server *, struct nfs_fh *);
	void (*enable_swap)(struct inode *);
	void (*disable_swap)(struct inode *);
};

struct nlmclnt_operations {
	void (*nlmclnt_alloc_call)(void *);
	bool (*nlmclnt_unlock_prepare)(struct rpc_task *, void *);
	void (*nlmclnt_release_call)(void *);
};

struct nfs_access_entry {
	struct rb_node rb_node;
	struct list_head lru;
	kuid_t fsuid;
	kgid_t fsgid;
	struct group_info *group_info;
	u64 timestamp;
	__u32 mask;
	struct callback_head callback_head;
};

struct nfs_client_initdata {
	long unsigned int init_flags;
	const char *hostname;
	const struct __kernel_sockaddr_storage *addr;
	const char *nodename;
	const char *ip_addr;
	size_t addrlen;
	struct nfs_subversion *nfs_mod;
	int proto;
	u32 minorversion;
	unsigned int nconnect;
	unsigned int max_connect;
	struct net *net;
	const struct rpc_timeout *timeparms;
	const struct cred *cred;
	struct xprtsec_parms xprtsec;
	long unsigned int connect_timeout;
	long unsigned int reconnect_timeout;
};

struct nfs_subversion {
	struct module *owner;
	struct file_system_type *nfs_fs;
	const struct rpc_version *rpc_vers;
	const struct nfs_rpc_ops *rpc_ops;
	const struct super_operations *sops;
	const struct xattr_handler **xattr;
	struct list_head list;
};

struct nfs4_state_recovery_ops;

struct nfs4_state_maintenance_ops;

struct nfs4_mig_recovery_ops;

struct nfs4_minor_version_ops {
	u32 minor_version;
	unsigned int init_caps;
	int (*init_client)(struct nfs_client *);
	void (*shutdown_client)(struct nfs_client *);
	bool (*match_stateid)(const nfs4_stateid *, const nfs4_stateid *);
	int (*find_root_sec)(struct nfs_server *, struct nfs_fh *, struct nfs_fsinfo *);
	void (*free_lock_state)(struct nfs_server *, struct nfs4_lock_state *);
	int (*test_and_free_expired)(struct nfs_server *, nfs4_stateid *, const struct cred *);
	struct nfs_seqid * (*alloc_seqid)(struct nfs_seqid_counter *, gfp_t);
	void (*session_trunk)(struct rpc_clnt *, struct rpc_xprt *, void *);
	const struct rpc_call_ops *call_sync_ops;
	const struct nfs4_state_recovery_ops *reboot_recovery_ops;
	const struct nfs4_state_recovery_ops *nograce_recovery_ops;
	const struct nfs4_state_maintenance_ops *state_renewal_ops;
	const struct nfs4_mig_recovery_ops *mig_recovery_ops;
};

struct nfs_iostats {
	long long unsigned int bytes[8];
	long unsigned int events[27];
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct nfs4_state_owner;

struct nfs4_state {
	struct list_head open_states;
	struct list_head inode_states;
	struct list_head lock_states;
	struct nfs4_state_owner *owner;
	struct inode *inode;
	long unsigned int flags;
	spinlock_t state_lock;
	seqlock_t seqlock;
	nfs4_stateid stateid;
	nfs4_stateid open_stateid;
	unsigned int n_rdonly;
	unsigned int n_wronly;
	unsigned int n_rdwr;
	fmode_t state;
	refcount_t count;
	wait_queue_head_t waitq;
	struct callback_head callback_head;
};

struct nfs4_cached_acl;

struct nfs_delegation;

struct nfs_inode {
	__u64 fileid;
	struct nfs_fh fh;
	long unsigned int flags;
	long unsigned int cache_validity;
	long unsigned int read_cache_jiffies;
	long unsigned int attrtimeo;
	long unsigned int attrtimeo_timestamp;
	long unsigned int attr_gencount;
	struct rb_root access_cache;
	struct list_head access_cache_entry_lru;
	struct list_head access_cache_inode_lru;
	union {
		struct {
			long unsigned int cache_change_attribute;
			__be32 cookieverf[2];
			struct rw_semaphore rmdir_sem;
		};
		struct {
			atomic_long_t nrequests;
			atomic_long_t redirtied_pages;
			struct nfs_mds_commit_info commit_info;
			struct mutex commit_mutex;
		};
	};
	struct list_head open_files;
	struct {
		int cnt;
		struct {
			u64 start;
			u64 end;
		} gap[16];
	} *ooo;
	struct nfs4_cached_acl *nfs4_acl;
	struct list_head open_states;
	struct nfs_delegation *delegation;
	struct rw_semaphore rwsem;
	struct pnfs_layout_hdr *layout;
	__u64 write_io;
	__u64 read_io;
	union {
		struct inode vfs_inode;
	};
};

struct nfs_delegation {
	struct list_head super_list;
	const struct cred *cred;
	struct inode *inode;
	nfs4_stateid stateid;
	fmode_t type;
	long unsigned int pagemod_limit;
	__u64 change_attr;
	long unsigned int flags;
	refcount_t refcount;
	spinlock_t lock;
	struct callback_head rcu;
};

struct nfs_seqid_counter {
	ktime_t create_time;
	int owner_id;
	int flags;
	u32 counter;
	spinlock_t lock;
	struct list_head list;
	struct rpc_wait_queue wait;
};

struct nfs4_lock_state {
	struct list_head ls_locks;
	struct nfs4_state *ls_state;
	long unsigned int ls_flags;
	struct nfs_seqid_counter ls_seqid;
	nfs4_stateid ls_stateid;
	refcount_t ls_count;
	fl_owner_t ls_owner;
};

struct nfs4_state_recovery_ops {
	int owner_flag_bit;
	int state_flag_bit;
	int (*recover_open)(struct nfs4_state_owner *, struct nfs4_state *);
	int (*recover_lock)(struct nfs4_state *, struct file_lock *);
	int (*establish_clid)(struct nfs_client *, const struct cred *);
	int (*reclaim_complete)(struct nfs_client *, const struct cred *);
	int (*detect_trunking)(struct nfs_client *, struct nfs_client **, const struct cred *);
};

struct nfs4_state_maintenance_ops {
	int (*sched_state_renewal)(struct nfs_client *, const struct cred *, unsigned int);
	const struct cred * (*get_state_renewal_cred)(struct nfs_client *);
	int (*renew_lease)(struct nfs_client *, const struct cred *);
};

struct nfs4_mig_recovery_ops {
	int (*get_locations)(struct nfs_server *, struct nfs_fh *, struct nfs4_fs_locations *, struct page *, const struct cred *);
	int (*fsid_present)(struct inode *, const struct cred *);
};

struct nfs4_state_owner {
	struct nfs_server *so_server;
	struct list_head so_lru;
	long unsigned int so_expires;
	struct rb_node so_server_node;
	const struct cred *so_cred;
	spinlock_t so_lock;
	atomic_t so_count;
	long unsigned int so_flags;
	struct list_head so_states;
	struct nfs_seqid_counter so_seqid;
	seqcount_spinlock_t so_reclaim_seqcount;
	struct mutex so_delegreturn_mutex;
};

enum nfs_stat_bytecounters {
	NFSIOS_NORMALREADBYTES = 0,
	NFSIOS_NORMALWRITTENBYTES = 1,
	NFSIOS_DIRECTREADBYTES = 2,
	NFSIOS_DIRECTWRITTENBYTES = 3,
	NFSIOS_SERVERREADBYTES = 4,
	NFSIOS_SERVERWRITTENBYTES = 5,
	NFSIOS_READPAGES = 6,
	NFSIOS_WRITEPAGES = 7,
	__NFSIOS_BYTESMAX = 8,
};

enum nfs_stat_eventcounters {
	NFSIOS_INODEREVALIDATE = 0,
	NFSIOS_DENTRYREVALIDATE = 1,
	NFSIOS_DATAINVALIDATE = 2,
	NFSIOS_ATTRINVALIDATE = 3,
	NFSIOS_VFSOPEN = 4,
	NFSIOS_VFSLOOKUP = 5,
	NFSIOS_VFSACCESS = 6,
	NFSIOS_VFSUPDATEPAGE = 7,
	NFSIOS_VFSREADPAGE = 8,
	NFSIOS_VFSREADPAGES = 9,
	NFSIOS_VFSWRITEPAGE = 10,
	NFSIOS_VFSWRITEPAGES = 11,
	NFSIOS_VFSGETDENTS = 12,
	NFSIOS_VFSSETATTR = 13,
	NFSIOS_VFSFLUSH = 14,
	NFSIOS_VFSFSYNC = 15,
	NFSIOS_VFSLOCK = 16,
	NFSIOS_VFSRELEASE = 17,
	NFSIOS_CONGESTIONWAIT = 18,
	NFSIOS_SETATTRTRUNC = 19,
	NFSIOS_EXTENDWRITE = 20,
	NFSIOS_SILLYRENAME = 21,
	NFSIOS_SHORTREAD = 22,
	NFSIOS_SHORTWRITE = 23,
	NFSIOS_DELAY = 24,
	NFSIOS_PNFS_READ = 25,
	NFSIOS_PNFS_WRITE = 26,
	__NFSIOS_COUNTSMAX = 27,
};

struct nfs_find_desc {
	struct nfs_fh *fh;
	struct nfs_fattr *fattr;
};

enum {
	IPPROTO_IP = 0,
	IPPROTO_ICMP = 1,
	IPPROTO_IGMP = 2,
	IPPROTO_IPIP = 4,
	IPPROTO_TCP = 6,
	IPPROTO_EGP = 8,
	IPPROTO_PUP = 12,
	IPPROTO_UDP = 17,
	IPPROTO_IDP = 22,
	IPPROTO_TP = 29,
	IPPROTO_DCCP = 33,
	IPPROTO_IPV6 = 41,
	IPPROTO_RSVP = 46,
	IPPROTO_GRE = 47,
	IPPROTO_ESP = 50,
	IPPROTO_AH = 51,
	IPPROTO_MTP = 92,
	IPPROTO_BEETPH = 94,
	IPPROTO_ENCAP = 98,
	IPPROTO_PIM = 103,
	IPPROTO_COMP = 108,
	IPPROTO_L2TP = 115,
	IPPROTO_SCTP = 132,
	IPPROTO_UDPLITE = 136,
	IPPROTO_MPLS = 137,
	IPPROTO_ETHERNET = 143,
	IPPROTO_RAW = 255,
	IPPROTO_MPTCP = 262,
	IPPROTO_MAX = 263,
};

enum rpc_auth_flavors {
	RPC_AUTH_NULL = 0,
	RPC_AUTH_UNIX = 1,
	RPC_AUTH_SHORT = 2,
	RPC_AUTH_DES = 3,
	RPC_AUTH_KRB = 4,
	RPC_AUTH_GSS = 6,
	RPC_AUTH_TLS = 7,
	RPC_AUTH_MAXFLAVOR = 8,
	RPC_AUTH_GSS_KRB5 = 390003,
	RPC_AUTH_GSS_KRB5I = 390004,
	RPC_AUTH_GSS_KRB5P = 390005,
	RPC_AUTH_GSS_LKEY = 390006,
	RPC_AUTH_GSS_LKEYI = 390007,
	RPC_AUTH_GSS_LKEYP = 390008,
	RPC_AUTH_GSS_SPKM = 390009,
	RPC_AUTH_GSS_SPKMI = 390010,
	RPC_AUTH_GSS_SPKMP = 390011,
};

struct rpc_create_args {
	struct net *net;
	int protocol;
	struct sockaddr *address;
	size_t addrsize;
	struct sockaddr *saddress;
	const struct rpc_timeout *timeout;
	const char *servername;
	const char *nodename;
	const struct rpc_program *program;
	u32 prognumber;
	u32 version;
	rpc_authflavor_t authflavor;
	u32 nconnect;
	long unsigned int flags;
	char *client_name;
	struct svc_xprt *bc_xprt;
	const struct cred *cred;
	unsigned int max_connect;
	struct xprtsec_parms xprtsec;
	long unsigned int connect_timeout;
	long unsigned int reconnect_timeout;
};

struct nfs_mount_request {
	struct __kernel_sockaddr_storage *sap;
	size_t salen;
	char *hostname;
	char *dirpath;
	u32 version;
	short unsigned int protocol;
	struct nfs_fh *fh;
	int noresvport;
	unsigned int *auth_flav_len;
	rpc_authflavor_t *auth_flavs;
	struct net *net;
};

enum {
	MOUNTPROC_NULL = 0,
	MOUNTPROC_MNT = 1,
	MOUNTPROC_DUMP = 2,
	MOUNTPROC_UMNT = 3,
	MOUNTPROC_UMNTALL = 4,
	MOUNTPROC_EXPORT = 5,
};

enum {
	MOUNTPROC3_NULL = 0,
	MOUNTPROC3_MNT = 1,
	MOUNTPROC3_DUMP = 2,
	MOUNTPROC3_UMNT = 3,
	MOUNTPROC3_UMNTALL = 4,
	MOUNTPROC3_EXPORT = 5,
};

enum mountstat {
	MNT_OK = 0,
	MNT_EPERM = 1,
	MNT_ENOENT = 2,
	MNT_EACCES = 13,
	MNT_EINVAL = 22,
};

enum mountstat3 {
	MNT3_OK = 0,
	MNT3ERR_PERM = 1,
	MNT3ERR_NOENT = 2,
	MNT3ERR_IO = 5,
	MNT3ERR_ACCES = 13,
	MNT3ERR_NOTDIR = 20,
	MNT3ERR_INVAL = 22,
	MNT3ERR_NAMETOOLONG = 63,
	MNT3ERR_NOTSUPP = 10004,
	MNT3ERR_SERVERFAULT = 10006,
};

struct mountres {
	int errno;
	struct nfs_fh *fh;
	unsigned int *auth_count;
	rpc_authflavor_t *auth_flavors;
};

typedef void (*rpc_action)(struct rpc_task *);

enum rpc_display_format_t {
	RPC_DISPLAY_ADDR = 0,
	RPC_DISPLAY_PORT = 1,
	RPC_DISPLAY_PROTO = 2,
	RPC_DISPLAY_HEX_ADDR = 3,
	RPC_DISPLAY_HEX_PORT = 4,
	RPC_DISPLAY_NETID = 5,
	RPC_DISPLAY_MAX = 6,
};

struct rpc_pipe_msg {
	struct list_head list;
	void *data;
	size_t len;
	size_t copied;
	int errno;
};

struct rpc_pipe_ops {
	ssize_t (*upcall)(struct file *, struct rpc_pipe_msg *, char *, size_t);
	ssize_t (*downcall)(struct file *, const char *, size_t);
	void (*release_pipe)(struct inode *);
	int (*open_pipe)(struct inode *);
	void (*destroy_msg)(struct rpc_pipe_msg *);
};

struct rpc_pipe {
	struct list_head pipe;
	struct list_head in_upcall;
	struct list_head in_downcall;
	int pipelen;
	int nreaders;
	int nwriters;
	int flags;
	struct delayed_work queue_timeout;
	const struct rpc_pipe_ops *ops;
	spinlock_t lock;
	struct dentry *dentry;
};

struct rpc_add_xprt_test {
	void (*add_xprt_test)(struct rpc_clnt *, struct rpc_xprt *, void *);
	void *data;
};

enum nfsstat4 {
	NFS4_OK = 0,
	NFS4ERR_PERM = 1,
	NFS4ERR_NOENT = 2,
	NFS4ERR_IO = 5,
	NFS4ERR_NXIO = 6,
	NFS4ERR_ACCESS = 13,
	NFS4ERR_EXIST = 17,
	NFS4ERR_XDEV = 18,
	NFS4ERR_NOTDIR = 20,
	NFS4ERR_ISDIR = 21,
	NFS4ERR_INVAL = 22,
	NFS4ERR_FBIG = 27,
	NFS4ERR_NOSPC = 28,
	NFS4ERR_ROFS = 30,
	NFS4ERR_MLINK = 31,
	NFS4ERR_NAMETOOLONG = 63,
	NFS4ERR_NOTEMPTY = 66,
	NFS4ERR_DQUOT = 69,
	NFS4ERR_STALE = 70,
	NFS4ERR_BADHANDLE = 10001,
	NFS4ERR_BAD_COOKIE = 10003,
	NFS4ERR_NOTSUPP = 10004,
	NFS4ERR_TOOSMALL = 10005,
	NFS4ERR_SERVERFAULT = 10006,
	NFS4ERR_BADTYPE = 10007,
	NFS4ERR_DELAY = 10008,
	NFS4ERR_SAME = 10009,
	NFS4ERR_DENIED = 10010,
	NFS4ERR_EXPIRED = 10011,
	NFS4ERR_LOCKED = 10012,
	NFS4ERR_GRACE = 10013,
	NFS4ERR_FHEXPIRED = 10014,
	NFS4ERR_SHARE_DENIED = 10015,
	NFS4ERR_WRONGSEC = 10016,
	NFS4ERR_CLID_INUSE = 10017,
	NFS4ERR_RESOURCE = 10018,
	NFS4ERR_MOVED = 10019,
	NFS4ERR_NOFILEHANDLE = 10020,
	NFS4ERR_MINOR_VERS_MISMATCH = 10021,
	NFS4ERR_STALE_CLIENTID = 10022,
	NFS4ERR_STALE_STATEID = 10023,
	NFS4ERR_OLD_STATEID = 10024,
	NFS4ERR_BAD_STATEID = 10025,
	NFS4ERR_BAD_SEQID = 10026,
	NFS4ERR_NOT_SAME = 10027,
	NFS4ERR_LOCK_RANGE = 10028,
	NFS4ERR_SYMLINK = 10029,
	NFS4ERR_RESTOREFH = 10030,
	NFS4ERR_LEASE_MOVED = 10031,
	NFS4ERR_ATTRNOTSUPP = 10032,
	NFS4ERR_NO_GRACE = 10033,
	NFS4ERR_RECLAIM_BAD = 10034,
	NFS4ERR_RECLAIM_CONFLICT = 10035,
	NFS4ERR_BADXDR = 10036,
	NFS4ERR_LOCKS_HELD = 10037,
	NFS4ERR_OPENMODE = 10038,
	NFS4ERR_BADOWNER = 10039,
	NFS4ERR_BADCHAR = 10040,
	NFS4ERR_BADNAME = 10041,
	NFS4ERR_BAD_RANGE = 10042,
	NFS4ERR_LOCK_NOTSUPP = 10043,
	NFS4ERR_OP_ILLEGAL = 10044,
	NFS4ERR_DEADLOCK = 10045,
	NFS4ERR_FILE_OPEN = 10046,
	NFS4ERR_ADMIN_REVOKED = 10047,
	NFS4ERR_CB_PATH_DOWN = 10048,
	NFS4ERR_BADIOMODE = 10049,
	NFS4ERR_BADLAYOUT = 10050,
	NFS4ERR_BAD_SESSION_DIGEST = 10051,
	NFS4ERR_BADSESSION = 10052,
	NFS4ERR_BADSLOT = 10053,
	NFS4ERR_COMPLETE_ALREADY = 10054,
	NFS4ERR_CONN_NOT_BOUND_TO_SESSION = 10055,
	NFS4ERR_DELEG_ALREADY_WANTED = 10056,
	NFS4ERR_BACK_CHAN_BUSY = 10057,
	NFS4ERR_LAYOUTTRYLATER = 10058,
	NFS4ERR_LAYOUTUNAVAILABLE = 10059,
	NFS4ERR_NOMATCHING_LAYOUT = 10060,
	NFS4ERR_RECALLCONFLICT = 10061,
	NFS4ERR_UNKNOWN_LAYOUTTYPE = 10062,
	NFS4ERR_SEQ_MISORDERED = 10063,
	NFS4ERR_SEQUENCE_POS = 10064,
	NFS4ERR_REQ_TOO_BIG = 10065,
	NFS4ERR_REP_TOO_BIG = 10066,
	NFS4ERR_REP_TOO_BIG_TO_CACHE = 10067,
	NFS4ERR_RETRY_UNCACHED_REP = 10068,
	NFS4ERR_UNSAFE_COMPOUND = 10069,
	NFS4ERR_TOO_MANY_OPS = 10070,
	NFS4ERR_OP_NOT_IN_SESSION = 10071,
	NFS4ERR_HASH_ALG_UNSUPP = 10072,
	NFS4ERR_CLIENTID_BUSY = 10074,
	NFS4ERR_PNFS_IO_HOLE = 10075,
	NFS4ERR_SEQ_FALSE_RETRY = 10076,
	NFS4ERR_BAD_HIGH_SLOT = 10077,
	NFS4ERR_DEADSESSION = 10078,
	NFS4ERR_ENCR_ALG_UNSUPP = 10079,
	NFS4ERR_PNFS_NO_LAYOUT = 10080,
	NFS4ERR_NOT_ONLY_OP = 10081,
	NFS4ERR_WRONG_CRED = 10082,
	NFS4ERR_WRONG_TYPE = 10083,
	NFS4ERR_DIRDELEG_UNAVAIL = 10084,
	NFS4ERR_REJECT_DELEG = 10085,
	NFS4ERR_RETURNCONFLICT = 10086,
	NFS4ERR_DELEG_REVOKED = 10087,
	NFS4ERR_PARTNER_NOTSUPP = 10088,
	NFS4ERR_PARTNER_NO_AUTH = 10089,
	NFS4ERR_UNION_NOTSUPP = 10090,
	NFS4ERR_OFFLOAD_DENIED = 10091,
	NFS4ERR_WRONG_LFS = 10092,
	NFS4ERR_BADLABEL = 10093,
	NFS4ERR_OFFLOAD_NO_REQS = 10094,
	NFS4ERR_NOXATTR = 10095,
	NFS4ERR_XATTR2BIG = 10096,
};

enum nfs_ftype4 {
	NF4BAD = 0,
	NF4REG = 1,
	NF4DIR = 2,
	NF4BLK = 3,
	NF4CHR = 4,
	NF4LNK = 5,
	NF4SOCK = 6,
	NF4FIFO = 7,
	NF4ATTRDIR = 8,
	NF4NAMEDATTR = 9,
};

enum open_claim_type4 {
	NFS4_OPEN_CLAIM_NULL = 0,
	NFS4_OPEN_CLAIM_PREVIOUS = 1,
	NFS4_OPEN_CLAIM_DELEGATE_CUR = 2,
	NFS4_OPEN_CLAIM_DELEGATE_PREV = 3,
	NFS4_OPEN_CLAIM_FH = 4,
	NFS4_OPEN_CLAIM_DELEG_CUR_FH = 5,
	NFS4_OPEN_CLAIM_DELEG_PREV_FH = 6,
};

enum createmode4 {
	NFS4_CREATE_UNCHECKED = 0,
	NFS4_CREATE_GUARDED = 1,
	NFS4_CREATE_EXCLUSIVE = 2,
	NFS4_CREATE_EXCLUSIVE4_1 = 3,
};

enum {
	NFSPROC4_CLNT_NULL = 0,
	NFSPROC4_CLNT_READ = 1,
	NFSPROC4_CLNT_WRITE = 2,
	NFSPROC4_CLNT_COMMIT = 3,
	NFSPROC4_CLNT_OPEN = 4,
	NFSPROC4_CLNT_OPEN_CONFIRM = 5,
	NFSPROC4_CLNT_OPEN_NOATTR = 6,
	NFSPROC4_CLNT_OPEN_DOWNGRADE = 7,
	NFSPROC4_CLNT_CLOSE = 8,
	NFSPROC4_CLNT_SETATTR = 9,
	NFSPROC4_CLNT_FSINFO = 10,
	NFSPROC4_CLNT_RENEW = 11,
	NFSPROC4_CLNT_SETCLIENTID = 12,
	NFSPROC4_CLNT_SETCLIENTID_CONFIRM = 13,
	NFSPROC4_CLNT_LOCK = 14,
	NFSPROC4_CLNT_LOCKT = 15,
	NFSPROC4_CLNT_LOCKU = 16,
	NFSPROC4_CLNT_ACCESS = 17,
	NFSPROC4_CLNT_GETATTR = 18,
	NFSPROC4_CLNT_LOOKUP = 19,
	NFSPROC4_CLNT_LOOKUP_ROOT = 20,
	NFSPROC4_CLNT_REMOVE = 21,
	NFSPROC4_CLNT_RENAME = 22,
	NFSPROC4_CLNT_LINK = 23,
	NFSPROC4_CLNT_SYMLINK = 24,
	NFSPROC4_CLNT_CREATE = 25,
	NFSPROC4_CLNT_PATHCONF = 26,
	NFSPROC4_CLNT_STATFS = 27,
	NFSPROC4_CLNT_READLINK = 28,
	NFSPROC4_CLNT_READDIR = 29,
	NFSPROC4_CLNT_SERVER_CAPS = 30,
	NFSPROC4_CLNT_DELEGRETURN = 31,
	NFSPROC4_CLNT_GETACL = 32,
	NFSPROC4_CLNT_SETACL = 33,
	NFSPROC4_CLNT_FS_LOCATIONS = 34,
	NFSPROC4_CLNT_RELEASE_LOCKOWNER = 35,
	NFSPROC4_CLNT_SECINFO = 36,
	NFSPROC4_CLNT_FSID_PRESENT = 37,
	NFSPROC4_CLNT_EXCHANGE_ID = 38,
	NFSPROC4_CLNT_CREATE_SESSION = 39,
	NFSPROC4_CLNT_DESTROY_SESSION = 40,
	NFSPROC4_CLNT_SEQUENCE = 41,
	NFSPROC4_CLNT_GET_LEASE_TIME = 42,
	NFSPROC4_CLNT_RECLAIM_COMPLETE = 43,
	NFSPROC4_CLNT_LAYOUTGET = 44,
	NFSPROC4_CLNT_GETDEVICEINFO = 45,
	NFSPROC4_CLNT_LAYOUTCOMMIT = 46,
	NFSPROC4_CLNT_LAYOUTRETURN = 47,
	NFSPROC4_CLNT_SECINFO_NO_NAME = 48,
	NFSPROC4_CLNT_TEST_STATEID = 49,
	NFSPROC4_CLNT_FREE_STATEID = 50,
	NFSPROC4_CLNT_GETDEVICELIST = 51,
	NFSPROC4_CLNT_BIND_CONN_TO_SESSION = 52,
	NFSPROC4_CLNT_DESTROY_CLIENTID = 53,
	NFSPROC4_CLNT_SEEK = 54,
	NFSPROC4_CLNT_ALLOCATE = 55,
	NFSPROC4_CLNT_DEALLOCATE = 56,
	NFSPROC4_CLNT_LAYOUTSTATS = 57,
	NFSPROC4_CLNT_CLONE = 58,
	NFSPROC4_CLNT_COPY = 59,
	NFSPROC4_CLNT_OFFLOAD_CANCEL = 60,
	NFSPROC4_CLNT_LOOKUPP = 61,
	NFSPROC4_CLNT_LAYOUTERROR = 62,
	NFSPROC4_CLNT_COPY_NOTIFY = 63,
	NFSPROC4_CLNT_GETXATTR = 64,
	NFSPROC4_CLNT_SETXATTR = 65,
	NFSPROC4_CLNT_LISTXATTRS = 66,
	NFSPROC4_CLNT_REMOVEXATTR = 67,
	NFSPROC4_CLNT_READ_PLUS = 68,
};

struct nfs4_sessionid {
	unsigned char data[16];
};

struct nfs4_channel_attrs {
	u32 max_rqst_sz;
	u32 max_resp_sz;
	u32 max_resp_sz_cached;
	u32 max_ops;
	u32 max_reqs;
};

struct nfs4_slot {
	struct nfs4_slot_table *table;
	struct nfs4_slot *next;
	long unsigned int generation;
	u32 slot_nr;
	u32 seq_nr;
	u32 seq_nr_last_acked;
	u32 seq_nr_highest_sent;
	unsigned int privileged: 1;
	unsigned int seq_done: 1;
};

struct nfs4_get_lease_time_args {
	struct nfs4_sequence_args la_seq_args;
};

struct nfs4_get_lease_time_res {
	struct nfs4_sequence_res lr_seq_res;
	struct nfs_fsinfo *lr_fsinfo;
};

struct nfs4_xdr_opaque_data;

struct nfs4_xdr_opaque_ops {
	void (*encode)(struct xdr_stream *, const void *, const struct nfs4_xdr_opaque_data *);
	void (*free)(struct nfs4_xdr_opaque_data *);
};

struct nfs4_xdr_opaque_data {
	const struct nfs4_xdr_opaque_ops *ops;
	void *data;
};

struct nfs4_layoutdriver_data {
	struct page **pages;
	__u32 pglen;
	__u32 len;
};

struct nfs4_layoutget_args {
	struct nfs4_sequence_args seq_args;
	__u32 type;
	struct pnfs_layout_range range;
	__u64 minlength;
	__u32 maxcount;
	struct inode *inode;
	struct nfs_open_context *ctx;
	nfs4_stateid stateid;
	struct nfs4_layoutdriver_data layout;
};

struct nfs4_layoutget_res {
	struct nfs4_sequence_res seq_res;
	int status;
	__u32 return_on_close;
	struct pnfs_layout_range range;
	__u32 type;
	nfs4_stateid stateid;
	struct nfs4_layoutdriver_data *layoutp;
};

struct nfs4_layoutget {
	struct nfs4_layoutget_args args;
	struct nfs4_layoutget_res res;
	const struct cred *cred;
	struct pnfs_layout_hdr *lo;
	gfp_t gfp_flags;
};

struct nfs4_layoutreturn_args {
	struct nfs4_sequence_args seq_args;
	struct pnfs_layout_hdr *layout;
	struct inode *inode;
	struct pnfs_layout_range range;
	nfs4_stateid stateid;
	__u32 layout_type;
	struct nfs4_xdr_opaque_data *ld_private;
};

struct nfs4_layoutreturn_res {
	struct nfs4_sequence_res seq_res;
	u32 lrs_present;
	nfs4_stateid stateid;
};

struct stateowner_id {
	__u64 create_time;
	__u32 uniquifier;
};

struct nfs_openargs {
	struct nfs4_sequence_args seq_args;
	const struct nfs_fh *fh;
	struct nfs_seqid *seqid;
	int open_flags;
	fmode_t fmode;
	u32 share_access;
	u32 access;
	__u64 clientid;
	struct stateowner_id id;
	union {
		struct {
			struct iattr *attrs;
			nfs4_verifier verifier;
		};
		nfs4_stateid delegation;
		fmode_t delegation_type;
	} u;
	const struct qstr *name;
	const struct nfs_server *server;
	const u32 *bitmask;
	const u32 *open_bitmap;
	enum open_claim_type4 claim;
	enum createmode4 createmode;
	const struct nfs4_label *label;
	umode_t umask;
	struct nfs4_layoutget_args *lg_args;
};

struct nfs_openres {
	struct nfs4_sequence_res seq_res;
	nfs4_stateid stateid;
	struct nfs_fh fh;
	struct nfs4_change_info cinfo;
	__u32 rflags;
	struct nfs_fattr *f_attr;
	struct nfs_seqid *seqid;
	const struct nfs_server *server;
	fmode_t delegation_type;
	nfs4_stateid delegation;
	long unsigned int pagemod_limit;
	__u32 do_recall;
	__u32 attrset[3];
	struct nfs4_string *owner;
	struct nfs4_string *group_owner;
	__u32 access_request;
	__u32 access_supported;
	__u32 access_result;
	struct nfs4_layoutget_res *lg_res;
};

struct nfs_open_confirmargs {
	struct nfs4_sequence_args seq_args;
	const struct nfs_fh *fh;
	nfs4_stateid *stateid;
	struct nfs_seqid *seqid;
};

struct nfs_open_confirmres {
	struct nfs4_sequence_res seq_res;
	nfs4_stateid stateid;
	struct nfs_seqid *seqid;
};

struct nfs_closeargs {
	struct nfs4_sequence_args seq_args;
	struct nfs_fh *fh;
	nfs4_stateid stateid;
	struct nfs_seqid *seqid;
	fmode_t fmode;
	u32 share_access;
	const u32 *bitmask;
	u32 bitmask_store[3];
	struct nfs4_layoutreturn_args *lr_args;
};

struct nfs_closeres {
	struct nfs4_sequence_res seq_res;
	nfs4_stateid stateid;
	struct nfs_fattr *fattr;
	struct nfs_seqid *seqid;
	const struct nfs_server *server;
	struct nfs4_layoutreturn_res *lr_res;
	int lr_ret;
};

struct nfs_lowner {
	__u64 clientid;
	__u64 id;
	dev_t s_dev;
};

struct nfs_lock_args {
	struct nfs4_sequence_args seq_args;
	struct nfs_fh *fh;
	struct file_lock *fl;
	struct nfs_seqid *lock_seqid;
	nfs4_stateid lock_stateid;
	struct nfs_seqid *open_seqid;
	nfs4_stateid open_stateid;
	struct nfs_lowner lock_owner;
	unsigned char block: 1;
	unsigned char reclaim: 1;
	unsigned char new_lock: 1;
	unsigned char new_lock_owner: 1;
};

struct nfs_lock_res {
	struct nfs4_sequence_res seq_res;
	nfs4_stateid stateid;
	struct nfs_seqid *lock_seqid;
	struct nfs_seqid *open_seqid;
};

struct nfs_locku_args {
	struct nfs4_sequence_args seq_args;
	struct nfs_fh *fh;
	struct file_lock *fl;
	struct nfs_seqid *seqid;
	nfs4_stateid stateid;
};

struct nfs_locku_res {
	struct nfs4_sequence_res seq_res;
	nfs4_stateid stateid;
	struct nfs_seqid *seqid;
};

struct nfs_lockt_args {
	struct nfs4_sequence_args seq_args;
	struct nfs_fh *fh;
	struct file_lock *fl;
	struct nfs_lowner lock_owner;
};

struct nfs_lockt_res {
	struct nfs4_sequence_res seq_res;
	struct file_lock *denied;
};

struct nfs_release_lockowner_args {
	struct nfs4_sequence_args seq_args;
	struct nfs_lowner lock_owner;
};

struct nfs_release_lockowner_res {
	struct nfs4_sequence_res seq_res;
};

struct nfs4_delegreturnargs {
	struct nfs4_sequence_args seq_args;
	const struct nfs_fh *fhandle;
	const nfs4_stateid *stateid;
	const u32 *bitmask;
	u32 bitmask_store[3];
	struct nfs4_layoutreturn_args *lr_args;
};

struct nfs4_delegreturnres {
	struct nfs4_sequence_res seq_res;
	struct nfs_fattr *fattr;
	struct nfs_server *server;
	struct nfs4_layoutreturn_res *lr_res;
	int lr_ret;
};

struct nfs_setattrargs {
	struct nfs4_sequence_args seq_args;
	struct nfs_fh *fh;
	nfs4_stateid stateid;
	struct iattr *iap;
	const struct nfs_server *server;
	const u32 *bitmask;
	const struct nfs4_label *label;
};

enum nfs4_acl_type {
	NFS4ACL_NONE = 0,
	NFS4ACL_ACL = 1,
	NFS4ACL_DACL = 2,
	NFS4ACL_SACL = 3,
};

struct nfs_setaclargs {
	struct nfs4_sequence_args seq_args;
	struct nfs_fh *fh;
	enum nfs4_acl_type acl_type;
	size_t acl_len;
	struct page **acl_pages;
};

struct nfs_setaclres {
	struct nfs4_sequence_res seq_res;
};

struct nfs_getaclargs {
	struct nfs4_sequence_args seq_args;
	struct nfs_fh *fh;
	enum nfs4_acl_type acl_type;
	size_t acl_len;
	struct page **acl_pages;
};

struct nfs_getaclres {
	struct nfs4_sequence_res seq_res;
	enum nfs4_acl_type acl_type;
	size_t acl_len;
	size_t acl_data_offset;
	int acl_flags;
	struct page *acl_scratch;
};

struct nfs_setattrres {
	struct nfs4_sequence_res seq_res;
	struct nfs_fattr *fattr;
	const struct nfs_server *server;
};

typedef u64 clientid4;

struct nfs4_accessargs {
	struct nfs4_sequence_args seq_args;
	const struct nfs_fh *fh;
	const u32 *bitmask;
	u32 access;
};

struct nfs4_accessres {
	struct nfs4_sequence_res seq_res;
	const struct nfs_server *server;
	struct nfs_fattr *fattr;
	u32 supported;
	u32 access;
};

struct nfs4_create_arg {
	struct nfs4_sequence_args seq_args;
	u32 ftype;
	union {
		struct {
			struct page **pages;
			unsigned int len;
		} symlink;
		struct {
			u32 specdata1;
			u32 specdata2;
		} device;
	} u;
	const struct qstr *name;
	const struct nfs_server *server;
	const struct iattr *attrs;
	const struct nfs_fh *dir_fh;
	const u32 *bitmask;
	const struct nfs4_label *label;
	umode_t umask;
};

struct nfs4_create_res {
	struct nfs4_sequence_res seq_res;
	const struct nfs_server *server;
	struct nfs_fh *fh;
	struct nfs_fattr *fattr;
	struct nfs4_change_info dir_cinfo;
};

struct nfs4_fsinfo_arg {
	struct nfs4_sequence_args seq_args;
	const struct nfs_fh *fh;
	const u32 *bitmask;
};

struct nfs4_fsinfo_res {
	struct nfs4_sequence_res seq_res;
	struct nfs_fsinfo *fsinfo;
};

struct nfs4_getattr_arg {
	struct nfs4_sequence_args seq_args;
	const struct nfs_fh *fh;
	const u32 *bitmask;
};

struct nfs4_getattr_res {
	struct nfs4_sequence_res seq_res;
	const struct nfs_server *server;
	struct nfs_fattr *fattr;
};

struct nfs4_link_arg {
	struct nfs4_sequence_args seq_args;
	const struct nfs_fh *fh;
	const struct nfs_fh *dir_fh;
	const struct qstr *name;
	const u32 *bitmask;
};

struct nfs4_link_res {
	struct nfs4_sequence_res seq_res;
	const struct nfs_server *server;
	struct nfs_fattr *fattr;
	struct nfs4_change_info cinfo;
	struct nfs_fattr *dir_attr;
};

struct nfs4_lookup_arg {
	struct nfs4_sequence_args seq_args;
	const struct nfs_fh *dir_fh;
	const struct qstr *name;
	const u32 *bitmask;
};

struct nfs4_lookup_res {
	struct nfs4_sequence_res seq_res;
	const struct nfs_server *server;
	struct nfs_fattr *fattr;
	struct nfs_fh *fh;
};

struct nfs4_lookupp_arg {
	struct nfs4_sequence_args seq_args;
	const struct nfs_fh *fh;
	const u32 *bitmask;
};

struct nfs4_lookupp_res {
	struct nfs4_sequence_res seq_res;
	const struct nfs_server *server;
	struct nfs_fattr *fattr;
	struct nfs_fh *fh;
};

struct nfs4_lookup_root_arg {
	struct nfs4_sequence_args seq_args;
	const u32 *bitmask;
};

struct nfs4_pathconf_arg {
	struct nfs4_sequence_args seq_args;
	const struct nfs_fh *fh;
	const u32 *bitmask;
};

struct nfs4_pathconf_res {
	struct nfs4_sequence_res seq_res;
	struct nfs_pathconf *pathconf;
};

struct nfs4_readdir_arg {
	struct nfs4_sequence_args seq_args;
	const struct nfs_fh *fh;
	u64 cookie;
	nfs4_verifier verifier;
	u32 count;
	struct page **pages;
	unsigned int pgbase;
	const u32 *bitmask;
	bool plus;
};

struct nfs4_readdir_res {
	struct nfs4_sequence_res seq_res;
	nfs4_verifier verifier;
	unsigned int pgbase;
};

struct nfs4_readlink {
	struct nfs4_sequence_args seq_args;
	const struct nfs_fh *fh;
	unsigned int pgbase;
	unsigned int pglen;
	struct page **pages;
};

struct nfs4_readlink_res {
	struct nfs4_sequence_res seq_res;
};

struct nfs4_setclientid {
	const nfs4_verifier *sc_verifier;
	u32 sc_prog;
	unsigned int sc_netid_len;
	char sc_netid[6];
	unsigned int sc_uaddr_len;
	char sc_uaddr[58];
	struct nfs_client *sc_clnt;
	struct rpc_cred *sc_cred;
};

struct nfs4_setclientid_res {
	u64 clientid;
	nfs4_verifier confirm;
};

struct nfs4_statfs_arg {
	struct nfs4_sequence_args seq_args;
	const struct nfs_fh *fh;
	const u32 *bitmask;
};

struct nfs4_statfs_res {
	struct nfs4_sequence_res seq_res;
	struct nfs_fsstat *fsstat;
};

struct nfs4_server_caps_arg {
	struct nfs4_sequence_args seq_args;
	struct nfs_fh *fhandle;
	const u32 *bitmask;
};

struct nfs4_server_caps_res {
	struct nfs4_sequence_res seq_res;
	u32 attr_bitmask[3];
	u32 exclcreat_bitmask[3];
	u32 acl_bitmask;
	u32 has_links;
	u32 has_symlinks;
	u32 fh_expire_type;
	u32 case_insensitive;
	u32 case_preserving;
};

struct nfs4_fs_locations_arg {
	struct nfs4_sequence_args seq_args;
	const struct nfs_fh *dir_fh;
	const struct nfs_fh *fh;
	const struct qstr *name;
	struct page *page;
	const u32 *bitmask;
	clientid4 clientid;
	unsigned char migration: 1;
	unsigned char renew: 1;
};

struct nfs4_fs_locations_res {
	struct nfs4_sequence_res seq_res;
	struct nfs4_fs_locations *fs_locations;
	unsigned char migration: 1;
	unsigned char renew: 1;
};

struct nfs4_secinfo4 {
	u32 flavor;
	struct rpcsec_gss_info flavor_info;
};

struct nfs4_secinfo_flavors {
	unsigned int num_flavors;
	struct nfs4_secinfo4 flavors[0];
};

struct nfs4_secinfo_arg {
	struct nfs4_sequence_args seq_args;
	const struct nfs_fh *dir_fh;
	const struct qstr *name;
};

struct nfs4_secinfo_res {
	struct nfs4_sequence_res seq_res;
	struct nfs4_secinfo_flavors *flavors;
};

struct nfs4_fsid_present_arg {
	struct nfs4_sequence_args seq_args;
	const struct nfs_fh *fh;
	clientid4 clientid;
	unsigned char renew: 1;
};

struct nfs4_fsid_present_res {
	struct nfs4_sequence_res seq_res;
	struct nfs_fh *fh;
	unsigned char renew: 1;
};

struct nfs4_slot_table {
	struct nfs4_session *session;
	struct nfs4_slot *slots;
	long unsigned int used_slots[16];
	spinlock_t slot_tbl_lock;
	struct rpc_wait_queue slot_tbl_waitq;
	wait_queue_head_t slot_waitq;
	u32 max_slots;
	u32 max_slotid;
	u32 highest_used_slotid;
	u32 target_highest_slotid;
	u32 server_highest_slotid;
	s32 d_target_highest_slotid;
	s32 d2_target_highest_slotid;
	long unsigned int generation;
	struct completion complete;
	long unsigned int slot_tbl_state;
};

struct nfs4_session {
	struct nfs4_sessionid sess_id;
	u32 flags;
	long unsigned int session_state;
	u32 hash_alg;
	u32 ssv_len;
	struct nfs4_channel_attrs fc_attrs;
	struct nfs4_slot_table fc_slot_table;
	struct nfs4_channel_attrs bc_attrs;
	struct nfs4_slot_table bc_slot_table;
	struct nfs_client *clp;
};

struct nfs4_cached_acl {
	enum nfs4_acl_type type;
	int cached;
	size_t len;
	char data[0];
};

enum nfs4_client_state {
	NFS4CLNT_MANAGER_RUNNING = 0,
	NFS4CLNT_CHECK_LEASE = 1,
	NFS4CLNT_LEASE_EXPIRED = 2,
	NFS4CLNT_RECLAIM_REBOOT = 3,
	NFS4CLNT_RECLAIM_NOGRACE = 4,
	NFS4CLNT_DELEGRETURN = 5,
	NFS4CLNT_SESSION_RESET = 6,
	NFS4CLNT_LEASE_CONFIRM = 7,
	NFS4CLNT_SERVER_SCOPE_MISMATCH = 8,
	NFS4CLNT_PURGE_STATE = 9,
	NFS4CLNT_BIND_CONN_TO_SESSION = 10,
	NFS4CLNT_MOVED = 11,
	NFS4CLNT_LEASE_MOVED = 12,
	NFS4CLNT_DELEGATION_EXPIRED = 13,
	NFS4CLNT_RUN_MANAGER = 14,
	NFS4CLNT_MANAGER_AVAILABLE = 15,
	NFS4CLNT_RECALL_RUNNING = 16,
	NFS4CLNT_RECALL_ANY_LAYOUT_READ = 17,
	NFS4CLNT_RECALL_ANY_LAYOUT_RW = 18,
	NFS4CLNT_DELEGRETURN_DELAYED = 19,
};

enum {
	NFS_OWNER_RECLAIM_REBOOT = 0,
	NFS_OWNER_RECLAIM_NOGRACE = 1,
};

enum {
	LK_STATE_IN_USE = 0,
	NFS_DELEGATED_STATE = 1,
	NFS_OPEN_STATE = 2,
	NFS_O_RDONLY_STATE = 3,
	NFS_O_WRONLY_STATE = 4,
	NFS_O_RDWR_STATE = 5,
	NFS_STATE_RECLAIM_REBOOT = 6,
	NFS_STATE_RECLAIM_NOGRACE = 7,
	NFS_STATE_POSIX_LOCKS = 8,
	NFS_STATE_RECOVERY_FAILED = 9,
	NFS_STATE_MAY_NOTIFY_LOCK = 10,
	NFS_STATE_CHANGE_WAIT = 11,
	NFS_CLNT_DST_SSC_COPY_STATE = 12,
	NFS_CLNT_SRC_SSC_COPY_STATE = 13,
	NFS_SRV_SSC_COPY_STATE = 14,
};

struct nfs4_exception {
	struct nfs4_state *state;
	struct inode *inode;
	nfs4_stateid *stateid;
	long int timeout;
	unsigned char task_is_privileged: 1;
	unsigned char delay: 1;
	unsigned char recovering: 1;
	unsigned char retry: 1;
	bool interruptible;
};

struct nfs4_opendata {
	struct kref kref;
	struct nfs_openargs o_arg;
	struct nfs_openres o_res;
	struct nfs_open_confirmargs c_arg;
	struct nfs_open_confirmres c_res;
	struct nfs4_string owner_name;
	struct nfs4_string group_name;
	struct nfs4_label *a_label;
	struct nfs_fattr f_attr;
	struct dentry *dir;
	struct dentry *dentry;
	struct nfs4_state_owner *owner;
	struct nfs4_state *state;
	struct iattr attrs;
	struct nfs4_layoutget *lgp;
	long unsigned int timestamp;
	bool rpc_done;
	bool file_created;
	bool is_recover;
	bool cancelled;
	int rpc_status;
};

struct nfs4_add_xprt_data {
	struct nfs_client *clp;
	const struct cred *cred;
};

enum {
	NFS_DELEGATION_NEED_RECLAIM = 0,
	NFS_DELEGATION_RETURN = 1,
	NFS_DELEGATION_RETURN_IF_CLOSED = 2,
	NFS_DELEGATION_REFERENCED = 3,
	NFS_DELEGATION_RETURNING = 4,
	NFS_DELEGATION_REVOKED = 5,
	NFS_DELEGATION_TEST_EXPIRED = 6,
	NFS_DELEGATION_INODE_FREEING = 7,
	NFS_DELEGATION_RETURN_DELAYED = 8,
};

struct cache_head {
	struct hlist_node cache_list;
	time64_t expiry_time;
	time64_t last_refresh;
	struct kref ref;
	long unsigned int flags;
};

struct cache_detail {
	struct module *owner;
	int hash_size;
	struct hlist_head *hash_table;
	spinlock_t hash_lock;
	char *name;
	void (*cache_put)(struct kref *);
	int (*cache_upcall)(struct cache_detail *, struct cache_head *);
	void (*cache_request)(struct cache_detail *, struct cache_head *, char **, int *);
	int (*cache_parse)(struct cache_detail *, char *, int);
	int (*cache_show)(struct seq_file *, struct cache_detail *, struct cache_head *);
	void (*warn_no_listener)(struct cache_detail *, int);
	struct cache_head * (*alloc)();
	void (*flush)();
	int (*match)(struct cache_head *, struct cache_head *);
	void (*init)(struct cache_head *, struct cache_head *);
	void (*update)(struct cache_head *, struct cache_head *);
	time64_t flush_time;
	struct list_head others;
	time64_t nextcheck;
	int entries;
	struct list_head queue;
	atomic_t writers;
	time64_t last_close;
	time64_t last_warn;
	union {
		struct proc_dir_entry *procfs;
		struct dentry *pipefs;
	};
	struct net *net;
};

struct bl_dev_msg {
	int32_t status;
	uint32_t major;
	uint32_t minor;
};

struct nfs_netns_client;

struct nfs_net {
	struct cache_detail *nfs_dns_resolve;
	struct rpc_pipe *bl_device_pipe;
	struct bl_dev_msg bl_mount_reply;
	wait_queue_head_t bl_wq;
	struct mutex bl_mutex;
	struct list_head nfs_client_list;
	struct list_head nfs_volume_list;
	struct idr cb_ident_idr;
	short unsigned int nfs_callback_tcpport;
	short unsigned int nfs_callback_tcpport6;
	int cb_users[1];
	struct nfs_netns_client *nfs_client;
	spinlock_t nfs_client_lock;
	ktime_t boot_time;
	struct proc_dir_entry *proc_nfsfs;
};

struct nfs_netns_client {
	struct kobject kobject;
	struct kobject nfs_net_kobj;
	struct net *net;
	const char *identifier;
};

enum nfs4_slot_tbl_state {
	NFS4_SLOT_TBL_DRAINING = 0,
};

struct nfs4_call_sync_data {
	const struct nfs_server *seq_server;
	struct nfs4_sequence_args *seq_args;
	struct nfs4_sequence_res *seq_res;
};

struct nfs4_open_createattrs {
	struct nfs4_label *label;
	struct iattr *sattr;
	const __u32 verf[2];
};

struct nfs4_closedata {
	struct inode *inode;
	struct nfs4_state *state;
	struct nfs_closeargs arg;
	struct nfs_closeres res;
	struct {
		struct nfs4_layoutreturn_args arg;
		struct nfs4_layoutreturn_res res;
		struct nfs4_xdr_opaque_data ld_private;
		u32 roc_barrier;
		bool roc;
	} lr;
	struct nfs_fattr fattr;
	long unsigned int timestamp;
};

struct nfs4_createdata {
	struct rpc_message msg;
	struct nfs4_create_arg arg;
	struct nfs4_create_res res;
	struct nfs_fh fh;
	struct nfs_fattr fattr;
};

struct nfs4_renewdata {
	struct nfs_client *client;
	long unsigned int timestamp;
};

struct nfs4_delegreturndata {
	struct nfs4_delegreturnargs args;
	struct nfs4_delegreturnres res;
	struct nfs_fh fh;
	nfs4_stateid stateid;
	long unsigned int timestamp;
	struct {
		struct nfs4_layoutreturn_args arg;
		struct nfs4_layoutreturn_res res;
		struct nfs4_xdr_opaque_data ld_private;
		u32 roc_barrier;
		bool roc;
	} lr;
	struct nfs_fattr fattr;
	int rpc_status;
	struct inode *inode;
};

struct nfs4_unlockdata {
	struct nfs_locku_args arg;
	struct nfs_locku_res res;
	struct nfs4_lock_state *lsp;
	struct nfs_open_context *ctx;
	struct nfs_lock_context *l_ctx;
	struct file_lock fl;
	struct nfs_server *server;
	long unsigned int timestamp;
};

struct nfs4_lockdata {
	struct nfs_lock_args arg;
	struct nfs_lock_res res;
	struct nfs4_lock_state *lsp;
	struct nfs_open_context *ctx;
	struct file_lock fl;
	long unsigned int timestamp;
	int rpc_status;
	int cancelled;
	struct nfs_server *server;
};

struct nfs_release_lockowner_data {
	struct nfs4_lock_state *lsp;
	struct nfs_server *server;
	struct nfs_release_lockowner_args args;
	struct nfs_release_lockowner_res res;
	long unsigned int timestamp;
};

struct nfs4_get_lease_time_data {
	struct nfs4_get_lease_time_args *args;
	struct nfs4_get_lease_time_res *res;
	struct nfs_client *clp;
};

struct xdr_netobj {
	unsigned int len;
	u8 *data;
};

enum rpc_accept_stat {
	RPC_SUCCESS = 0,
	RPC_PROG_UNAVAIL = 1,
	RPC_PROG_MISMATCH = 2,
	RPC_PROC_UNAVAIL = 3,
	RPC_GARBAGE_ARGS = 4,
	RPC_SYSTEM_ERR = 5,
	RPC_DROP_REPLY = 60000,
};

enum rpc_auth_stat {
	RPC_AUTH_OK = 0,
	RPC_AUTH_BADCRED = 1,
	RPC_AUTH_REJECTEDCRED = 2,
	RPC_AUTH_BADVERF = 3,
	RPC_AUTH_REJECTEDVERF = 4,
	RPC_AUTH_TOOWEAK = 5,
	RPCSEC_GSS_CREDPROBLEM = 13,
	RPCSEC_GSS_CTXPROBLEM = 14,
};

struct cache_deferred_req;

struct cache_req {
	struct cache_deferred_req * (*defer)(struct cache_req *);
	long unsigned int thread_wait;
};

struct cache_deferred_req {
	struct hlist_node hash;
	struct list_head recent;
	struct cache_head *item;
	void *owner;
	void (*revisit)(struct cache_deferred_req *, int);
};

struct gss_api_mech;

struct gss_ctx {
	struct gss_api_mech *mech_type;
	void *internal_ctx_id;
	unsigned int slack;
	unsigned int align;
};

struct gss_api_ops;

struct pf_desc;

struct gss_api_mech {
	struct list_head gm_list;
	struct module *gm_owner;
	struct rpcsec_gss_oid gm_oid;
	char *gm_name;
	const struct gss_api_ops *gm_ops;
	int gm_pf_num;
	struct pf_desc *gm_pfs;
	const char *gm_upcall_enctypes;
};

struct auth_domain;

struct pf_desc {
	u32 pseudoflavor;
	u32 qop;
	u32 service;
	char *name;
	char *auth_domain_name;
	struct auth_domain *domain;
	bool datatouch;
};

struct auth_ops;

struct auth_domain {
	struct kref ref;
	struct hlist_node hash;
	char *name;
	struct auth_ops *flavour;
	struct callback_head callback_head;
};

struct gss_api_ops {
	int (*gss_import_sec_context)(const void *, size_t, struct gss_ctx *, time64_t *, gfp_t);
	u32 (*gss_get_mic)(struct gss_ctx *, struct xdr_buf *, struct xdr_netobj *);
	u32 (*gss_verify_mic)(struct gss_ctx *, struct xdr_buf *, struct xdr_netobj *);
	u32 (*gss_wrap)(struct gss_ctx *, int, struct xdr_buf *, struct page **);
	u32 (*gss_unwrap)(struct gss_ctx *, int, int, struct xdr_buf *);
	void (*gss_delete_sec_context)(void *);
};

struct svc_cred {
	kuid_t cr_uid;
	kgid_t cr_gid;
	struct group_info *cr_group_info;
	u32 cr_flavor;
	char *cr_raw_principal;
	char *cr_principal;
	char *cr_targ_princ;
	struct gss_api_mech *cr_gss_mech;
};

enum svc_auth_status {
	SVC_GARBAGE = 1,
	SVC_SYSERR = 2,
	SVC_VALID = 3,
	SVC_NEGATIVE = 4,
	SVC_OK = 5,
	SVC_DROP = 6,
	SVC_CLOSE = 7,
	SVC_DENIED = 8,
	SVC_PENDING = 9,
	SVC_COMPLETE = 10,
};

struct svc_rqst;

struct auth_ops {
	char *name;
	struct module *owner;
	int flavour;
	enum svc_auth_status (*accept)(struct svc_rqst *);
	int (*release)(struct svc_rqst *);
	void (*domain_release)(struct auth_domain *);
	enum svc_auth_status (*set_client)(struct svc_rqst *);
};

struct svc_serv;

struct svc_pool;

struct svc_procedure;

struct svc_deferred_req;

struct svc_rqst {
	struct list_head rq_all;
	struct callback_head rq_rcu_head;
	struct svc_xprt *rq_xprt;
	struct __kernel_sockaddr_storage rq_addr;
	size_t rq_addrlen;
	struct __kernel_sockaddr_storage rq_daddr;
	size_t rq_daddrlen;
	struct svc_serv *rq_server;
	struct svc_pool *rq_pool;
	const struct svc_procedure *rq_procinfo;
	struct auth_ops *rq_authop;
	struct svc_cred rq_cred;
	void *rq_xprt_ctxt;
	struct svc_deferred_req *rq_deferred;
	struct xdr_buf rq_arg;
	struct xdr_stream rq_arg_stream;
	struct xdr_stream rq_res_stream;
	struct page *rq_scratch_page;
	struct xdr_buf rq_res;
	struct page *rq_pages[20];
	struct page **rq_respages;
	struct page **rq_next_page;
	struct page **rq_page_end;
	struct folio_batch rq_fbatch;
	struct kvec rq_vec[19];
	struct bio_vec rq_bvec[19];
	__be32 rq_xid;
	u32 rq_prog;
	u32 rq_vers;
	u32 rq_proc;
	u32 rq_prot;
	int rq_cachetype;
	long unsigned int rq_flags;
	ktime_t rq_qtime;
	void *rq_argp;
	void *rq_resp;
	__be32 *rq_accept_statp;
	void *rq_auth_data;
	__be32 rq_auth_stat;
	int rq_auth_slack;
	int rq_reserved;
	ktime_t rq_stime;
	struct cache_req rq_chandle;
	struct auth_domain *rq_client;
	struct auth_domain *rq_gssclient;
	struct task_struct *rq_task;
	struct net *rq_bc_net;
	void **rq_lease_breaker;
};

struct svc_pool {
	unsigned int sp_id;
	spinlock_t sp_lock;
	struct list_head sp_sockets;
	unsigned int sp_nrthreads;
	struct list_head sp_all_threads;
	struct percpu_counter sp_messages_arrived;
	struct percpu_counter sp_sockets_queued;
	struct percpu_counter sp_threads_woken;
	long unsigned int sp_flags;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct svc_program;

struct svc_stat;

struct svc_serv {
	struct svc_program *sv_program;
	struct svc_stat *sv_stats;
	spinlock_t sv_lock;
	struct kref sv_refcnt;
	unsigned int sv_nrthreads;
	unsigned int sv_maxconn;
	unsigned int sv_max_payload;
	unsigned int sv_max_mesg;
	unsigned int sv_xdrsize;
	struct list_head sv_permsocks;
	struct list_head sv_tempsocks;
	int sv_tmpcnt;
	struct timer_list sv_temptimer;
	char *sv_name;
	unsigned int sv_nrpools;
	struct svc_pool *sv_pools;
	int (*sv_threadfn)(void *);
};

struct svc_version;

struct svc_process_info;

struct svc_program {
	struct svc_program *pg_next;
	u32 pg_prog;
	unsigned int pg_lovers;
	unsigned int pg_hivers;
	unsigned int pg_nvers;
	const struct svc_version **pg_vers;
	char *pg_name;
	char *pg_class;
	struct svc_stat *pg_stats;
	enum svc_auth_status (*pg_authenticate)(struct svc_rqst *);
	__be32 (*pg_init_request)(struct svc_rqst *, const struct svc_program *, struct svc_process_info *);
	int (*pg_rpcbind_set)(struct net *, const struct svc_program *, u32, int, short unsigned int, short unsigned int);
};

struct svc_stat {
	struct svc_program *program;
	unsigned int netcnt;
	unsigned int netudpcnt;
	unsigned int nettcpcnt;
	unsigned int nettcpconn;
	unsigned int rpccnt;
	unsigned int rpcbadfmt;
	unsigned int rpcbadauth;
	unsigned int rpcbadclnt;
};

struct svc_xprt_class;

struct svc_xprt_ops;

struct svc_xprt {
	struct svc_xprt_class *xpt_class;
	const struct svc_xprt_ops *xpt_ops;
	struct kref xpt_ref;
	struct list_head xpt_list;
	struct list_head xpt_ready;
	long unsigned int xpt_flags;
	struct svc_serv *xpt_server;
	atomic_t xpt_reserved;
	atomic_t xpt_nr_rqsts;
	struct mutex xpt_mutex;
	spinlock_t xpt_lock;
	void *xpt_auth_cache;
	struct list_head xpt_deferred;
	struct __kernel_sockaddr_storage xpt_local;
	size_t xpt_locallen;
	struct __kernel_sockaddr_storage xpt_remote;
	size_t xpt_remotelen;
	char xpt_remotebuf[58];
	struct list_head xpt_users;
	struct net *xpt_net;
	netns_tracker ns_tracker;
	const struct cred *xpt_cred;
	struct rpc_xprt *xpt_bc_xprt;
	struct rpc_xprt_switch *xpt_bc_xps;
};

struct svc_procedure {
	__be32 (*pc_func)(struct svc_rqst *);
	bool (*pc_decode)(struct svc_rqst *, struct xdr_stream *);
	bool (*pc_encode)(struct svc_rqst *, struct xdr_stream *);
	void (*pc_release)(struct svc_rqst *);
	unsigned int pc_argsize;
	unsigned int pc_argzero;
	unsigned int pc_ressize;
	unsigned int pc_cachetype;
	unsigned int pc_xdrressize;
	const char *pc_name;
};

struct svc_deferred_req {
	u32 prot;
	struct svc_xprt *xprt;
	struct __kernel_sockaddr_storage addr;
	size_t addrlen;
	struct __kernel_sockaddr_storage daddr;
	size_t daddrlen;
	void *xprt_ctxt;
	struct cache_deferred_req handle;
	int argslen;
	__be32 args[0];
};

struct svc_process_info {
	union {
		int (*dispatch)(struct svc_rqst *);
		struct {
			unsigned int lovers;
			unsigned int hivers;
		} mismatch;
	};
};

struct svc_version {
	u32 vs_vers;
	u32 vs_nproc;
	const struct svc_procedure *vs_proc;
	long unsigned int *vs_count;
	u32 vs_xdrsize;
	bool vs_hidden;
	bool vs_rpcb_optnl;
	bool vs_need_cong_ctrl;
	int (*vs_dispatch)(struct svc_rqst *);
};

enum nfs_stat {
	NFS_OK = 0,
	NFSERR_PERM = 1,
	NFSERR_NOENT = 2,
	NFSERR_IO = 5,
	NFSERR_NXIO = 6,
	NFSERR_EAGAIN = 11,
	NFSERR_ACCES = 13,
	NFSERR_EXIST = 17,
	NFSERR_XDEV = 18,
	NFSERR_NODEV = 19,
	NFSERR_NOTDIR = 20,
	NFSERR_ISDIR = 21,
	NFSERR_INVAL = 22,
	NFSERR_FBIG = 27,
	NFSERR_NOSPC = 28,
	NFSERR_ROFS = 30,
	NFSERR_MLINK = 31,
	NFSERR_OPNOTSUPP = 45,
	NFSERR_NAMETOOLONG = 63,
	NFSERR_NOTEMPTY = 66,
	NFSERR_DQUOT = 69,
	NFSERR_STALE = 70,
	NFSERR_REMOTE = 71,
	NFSERR_WFLUSH = 99,
	NFSERR_BADHANDLE = 10001,
	NFSERR_NOT_SYNC = 10002,
	NFSERR_BAD_COOKIE = 10003,
	NFSERR_NOTSUPP = 10004,
	NFSERR_TOOSMALL = 10005,
	NFSERR_SERVERFAULT = 10006,
	NFSERR_BADTYPE = 10007,
	NFSERR_JUKEBOX = 10008,
	NFSERR_SAME = 10009,
	NFSERR_DENIED = 10010,
	NFSERR_EXPIRED = 10011,
	NFSERR_LOCKED = 10012,
	NFSERR_GRACE = 10013,
	NFSERR_FHEXPIRED = 10014,
	NFSERR_SHARE_DENIED = 10015,
	NFSERR_WRONGSEC = 10016,
	NFSERR_CLID_INUSE = 10017,
	NFSERR_RESOURCE = 10018,
	NFSERR_MOVED = 10019,
	NFSERR_NOFILEHANDLE = 10020,
	NFSERR_MINOR_VERS_MISMATCH = 10021,
	NFSERR_STALE_CLIENTID = 10022,
	NFSERR_STALE_STATEID = 10023,
	NFSERR_OLD_STATEID = 10024,
	NFSERR_BAD_STATEID = 10025,
	NFSERR_BAD_SEQID = 10026,
	NFSERR_NOT_SAME = 10027,
	NFSERR_LOCK_RANGE = 10028,
	NFSERR_SYMLINK = 10029,
	NFSERR_RESTOREFH = 10030,
	NFSERR_LEASE_MOVED = 10031,
	NFSERR_ATTRNOTSUPP = 10032,
	NFSERR_NO_GRACE = 10033,
	NFSERR_RECLAIM_BAD = 10034,
	NFSERR_RECLAIM_CONFLICT = 10035,
	NFSERR_BAD_XDR = 10036,
	NFSERR_LOCKS_HELD = 10037,
	NFSERR_OPENMODE = 10038,
	NFSERR_BADOWNER = 10039,
	NFSERR_BADCHAR = 10040,
	NFSERR_BADNAME = 10041,
	NFSERR_BAD_RANGE = 10042,
	NFSERR_LOCK_NOTSUPP = 10043,
	NFSERR_OP_ILLEGAL = 10044,
	NFSERR_DEADLOCK = 10045,
	NFSERR_FILE_OPEN = 10046,
	NFSERR_ADMIN_REVOKED = 10047,
	NFSERR_CB_PATH_DOWN = 10048,
};

struct svc_xprt_ops {
	struct svc_xprt * (*xpo_create)(struct svc_serv *, struct net *, struct sockaddr *, int, int);
	struct svc_xprt * (*xpo_accept)(struct svc_xprt *);
	int (*xpo_has_wspace)(struct svc_xprt *);
	int (*xpo_recvfrom)(struct svc_rqst *);
	int (*xpo_sendto)(struct svc_rqst *);
	int (*xpo_result_payload)(struct svc_rqst *, unsigned int, unsigned int);
	void (*xpo_release_ctxt)(struct svc_xprt *, void *);
	void (*xpo_detach)(struct svc_xprt *);
	void (*xpo_free)(struct svc_xprt *);
	void (*xpo_kill_temp_xprt)(struct svc_xprt *);
	void (*xpo_handshake)(struct svc_xprt *);
};

struct svc_xprt_class {
	const char *xcl_name;
	struct module *xcl_owner;
	const struct svc_xprt_ops *xcl_ops;
	struct list_head xcl_list;
	u32 xcl_max_payload;
	int xcl_ident;
};

enum nfs4_callback_procnum {
	CB_NULL = 0,
	CB_COMPOUND = 1,
};

enum nfs4_callback_opnum {
	OP_CB_GETATTR = 3,
	OP_CB_RECALL = 4,
	OP_CB_LAYOUTRECALL = 5,
	OP_CB_NOTIFY = 6,
	OP_CB_PUSH_DELEG = 7,
	OP_CB_RECALL_ANY = 8,
	OP_CB_RECALLABLE_OBJ_AVAIL = 9,
	OP_CB_RECALL_SLOT = 10,
	OP_CB_SEQUENCE = 11,
	OP_CB_WANTS_CANCELLED = 12,
	OP_CB_NOTIFY_LOCK = 13,
	OP_CB_NOTIFY_DEVICEID = 14,
	OP_CB_OFFLOAD = 15,
	OP_CB_ILLEGAL = 10044,
};

struct cb_process_state {
	__be32 drc_status;
	struct nfs_client *clp;
	struct nfs4_slot *slot;
	u32 minorversion;
	struct net *net;
};

struct cb_compound_hdr_arg {
	unsigned int taglen;
	const char *tag;
	unsigned int minorversion;
	unsigned int cb_ident;
	unsigned int nops;
};

struct cb_compound_hdr_res {
	__be32 *status;
	unsigned int taglen;
	const char *tag;
	__be32 *nops;
};

struct cb_getattrargs {
	struct nfs_fh fh;
	uint32_t bitmap[2];
};

struct cb_getattrres {
	__be32 status;
	uint32_t bitmap[2];
	uint64_t size;
	uint64_t change_attr;
	struct timespec64 ctime;
	struct timespec64 mtime;
};

struct cb_recallargs {
	struct nfs_fh fh;
	nfs4_stateid stateid;
	uint32_t truncate;
};

struct callback_op {
	__be32 (*process_op)(void *, void *, struct cb_process_state *);
	__be32 (*decode_args)(struct svc_rqst *, struct xdr_stream *, void *);
	__be32 (*encode_res)(struct svc_rqst *, struct xdr_stream *, const void *);
	long int res_maxsize;
};

struct getdents_callback___2 {
	struct dir_context ctx;
	char *name;
	u64 ino;
	int found;
	int sequence;
};

struct in_addr {
	__be32 s_addr;
};

struct sockaddr_in {
	__kernel_sa_family_t sin_family;
	__be16 sin_port;
	struct in_addr sin_addr;
	unsigned char __pad[8];
};

struct sockaddr_in6 {
	short unsigned int sin6_family;
	__be16 sin6_port;
	__be32 sin6_flowinfo;
	struct in6_addr sin6_addr;
	__u32 sin6_scope_id;
};

enum {
	IPV4_DEVCONF_FORWARDING = 1,
	IPV4_DEVCONF_MC_FORWARDING = 2,
	IPV4_DEVCONF_PROXY_ARP = 3,
	IPV4_DEVCONF_ACCEPT_REDIRECTS = 4,
	IPV4_DEVCONF_SECURE_REDIRECTS = 5,
	IPV4_DEVCONF_SEND_REDIRECTS = 6,
	IPV4_DEVCONF_SHARED_MEDIA = 7,
	IPV4_DEVCONF_RP_FILTER = 8,
	IPV4_DEVCONF_ACCEPT_SOURCE_ROUTE = 9,
	IPV4_DEVCONF_BOOTP_RELAY = 10,
	IPV4_DEVCONF_LOG_MARTIANS = 11,
	IPV4_DEVCONF_TAG = 12,
	IPV4_DEVCONF_ARPFILTER = 13,
	IPV4_DEVCONF_MEDIUM_ID = 14,
	IPV4_DEVCONF_NOXFRM = 15,
	IPV4_DEVCONF_NOPOLICY = 16,
	IPV4_DEVCONF_FORCE_IGMP_VERSION = 17,
	IPV4_DEVCONF_ARP_ANNOUNCE = 18,
	IPV4_DEVCONF_ARP_IGNORE = 19,
	IPV4_DEVCONF_PROMOTE_SECONDARIES = 20,
	IPV4_DEVCONF_ARP_ACCEPT = 21,
	IPV4_DEVCONF_ARP_NOTIFY = 22,
	IPV4_DEVCONF_ACCEPT_LOCAL = 23,
	IPV4_DEVCONF_SRC_VMARK = 24,
	IPV4_DEVCONF_PROXY_ARP_PVLAN = 25,
	IPV4_DEVCONF_ROUTE_LOCALNET = 26,
	IPV4_DEVCONF_IGMPV2_UNSOLICITED_REPORT_INTERVAL = 27,
	IPV4_DEVCONF_IGMPV3_UNSOLICITED_REPORT_INTERVAL = 28,
	IPV4_DEVCONF_IGNORE_ROUTES_WITH_LINKDOWN = 29,
	IPV4_DEVCONF_DROP_UNICAST_IN_L2_MULTICAST = 30,
	IPV4_DEVCONF_DROP_GRATUITOUS_ARP = 31,
	IPV4_DEVCONF_BC_FORWARDING = 32,
	IPV4_DEVCONF_ARP_EVICT_NOCARRIER = 33,
	__IPV4_DEVCONF_MAX = 34,
};

struct ipv4_devconf {
	void *sysctl;
	int data[33];
	long unsigned int state[1];
};

struct ip_ra_chain {
	struct ip_ra_chain *next;
	struct sock *sk;
	union {
		void (*destructor)(struct sock *);
		struct sock *saved_sk;
	};
	struct callback_head rcu;
};

struct inet_peer_base {
	struct rb_root rb_root;
	seqlock_t lock;
	int total;
};

struct in_ifaddr;

struct ip_mc_list;

struct in_device {
	struct net_device *dev;
	netdevice_tracker dev_tracker;
	refcount_t refcnt;
	int dead;
	struct in_ifaddr *ifa_list;
	struct ip_mc_list *mc_list;
	struct ip_mc_list **mc_hash;
	int mc_count;
	spinlock_t mc_tomb_lock;
	struct ip_mc_list *mc_tomb;
	long unsigned int mr_v1_seen;
	long unsigned int mr_v2_seen;
	long unsigned int mr_maxdelay;
	long unsigned int mr_qi;
	long unsigned int mr_qri;
	unsigned char mr_qrv;
	unsigned char mr_gq_running;
	u32 mr_ifc_count;
	struct timer_list mr_gq_timer;
	struct timer_list mr_ifc_timer;
	struct neigh_parms *arp_parms;
	struct ipv4_devconf cnf;
	struct callback_head callback_head;
};

struct in_ifaddr {
	struct hlist_node hash;
	struct in_ifaddr *ifa_next;
	struct in_device *ifa_dev;
	struct callback_head callback_head;
	__be32 ifa_local;
	__be32 ifa_address;
	__be32 ifa_mask;
	__u32 ifa_rt_priority;
	__be32 ifa_broadcast;
	unsigned char ifa_scope;
	unsigned char ifa_prefixlen;
	unsigned char ifa_proto;
	__u32 ifa_flags;
	char ifa_label[16];
	__u32 ifa_valid_lft;
	__u32 ifa_preferred_lft;
	long unsigned int ifa_cstamp;
	long unsigned int ifa_tstamp;
};

struct lwtunnel_state {
	__u16 type;
	__u16 flags;
	__u16 headroom;
	atomic_t refcnt;
	int (*orig_output)(struct net *, struct sock *, struct sk_buff *);
	int (*orig_input)(struct sk_buff *);
	struct callback_head rcu;
	__u8 data[0];
};

struct inet6_ifaddr {
	struct in6_addr addr;
	__u32 prefix_len;
	__u32 rt_priority;
	__u32 valid_lft;
	__u32 prefered_lft;
	refcount_t refcnt;
	spinlock_t lock;
	int state;
	__u32 flags;
	__u8 dad_probes;
	__u8 stable_privacy_retry;
	__u16 scope;
	__u64 dad_nonce;
	long unsigned int cstamp;
	long unsigned int tstamp;
	struct delayed_work dad_work;
	struct inet6_dev *idev;
	struct fib6_info *rt;
	struct hlist_node addr_lst;
	struct list_head if_list;
	struct list_head if_list_aux;
	struct list_head tmp_list;
	struct inet6_ifaddr *ifpub;
	int regen_count;
	bool tokenized;
	u8 ifa_proto;
	struct callback_head rcu;
	struct in6_addr peer_addr;
};

enum {
	__ND_OPT_PREFIX_INFO_END = 0,
	ND_OPT_SOURCE_LL_ADDR = 1,
	ND_OPT_TARGET_LL_ADDR = 2,
	ND_OPT_PREFIX_INFO = 3,
	ND_OPT_REDIRECT_HDR = 4,
	ND_OPT_MTU = 5,
	ND_OPT_NONCE = 14,
	__ND_OPT_ARRAY_MAX = 15,
	ND_OPT_ROUTE_INFO = 24,
	ND_OPT_RDNSS = 25,
	ND_OPT_DNSSL = 31,
	ND_OPT_6CO = 34,
	ND_OPT_CAPTIVE_PORTAL = 37,
	ND_OPT_PREF64 = 38,
	__ND_OPT_MAX = 39,
};

struct nd_opt_hdr {
	__u8 nd_opt_type;
	__u8 nd_opt_len;
};

struct ndisc_options {
	struct nd_opt_hdr *nd_opt_array[15];
	struct nd_opt_hdr *nd_useropts;
	struct nd_opt_hdr *nd_useropts_end;
};

struct prefix_info {
	__u8 type;
	__u8 length;
	__u8 prefix_len;
	__u8 reserved: 6;
	__u8 autoconf: 1;
	__u8 onlink: 1;
	__be32 valid;
	__be32 prefered;
	__be32 reserved2;
	struct in6_addr prefix;
};

struct lock_manager {
	struct list_head list;
	bool block_opens;
};

struct nlm_lockowner {
	struct list_head list;
	refcount_t count;
	struct nlm_host *host;
	fl_owner_t owner;
	uint32_t pid;
};

struct nsm_private {
	unsigned char data[16];
};

struct nlmsvc_binding {
	__be32 (*fopen)(struct svc_rqst *, struct nfs_fh *, struct file **, int);
	void (*fclose)(struct file *);
};

struct nsm_handle;

struct nlm_host {
	struct hlist_node h_hash;
	struct __kernel_sockaddr_storage h_addr;
	size_t h_addrlen;
	struct __kernel_sockaddr_storage h_srcaddr;
	size_t h_srcaddrlen;
	struct rpc_clnt *h_rpcclnt;
	char *h_name;
	u32 h_version;
	short unsigned int h_proto;
	short unsigned int h_reclaiming: 1;
	short unsigned int h_server: 1;
	short unsigned int h_noresvport: 1;
	short unsigned int h_inuse: 1;
	wait_queue_head_t h_gracewait;
	struct rw_semaphore h_rwsem;
	u32 h_state;
	u32 h_nsmstate;
	u32 h_pidcount;
	refcount_t h_count;
	struct mutex h_mutex;
	long unsigned int h_nextrebind;
	long unsigned int h_expires;
	struct list_head h_lockowners;
	spinlock_t h_lock;
	struct list_head h_granted;
	struct list_head h_reclaim;
	struct nsm_handle *h_nsmhandle;
	char *h_addrbuf;
	struct net *net;
	const struct cred *h_cred;
	char nodename[65];
	const struct nlmclnt_operations *h_nlmclnt_ops;
};

struct nsm_handle {
	struct list_head sm_link;
	refcount_t sm_count;
	char *sm_mon_name;
	char *sm_name;
	struct __kernel_sockaddr_storage sm_addr;
	size_t sm_addrlen;
	unsigned int sm_monitored: 1;
	unsigned int sm_sticky: 1;
	struct nsm_private sm_priv;
	char sm_addrbuf[51];
};

struct lockd_net {
	unsigned int nlmsvc_users;
	long unsigned int next_gc;
	long unsigned int nrhosts;
	struct delayed_work grace_period_end;
	struct lock_manager lockd_manager;
	struct list_head nsm_handles;
};

enum {
	NLM_LCK_GRANTED = 0,
	NLM_LCK_DENIED = 1,
	NLM_LCK_DENIED_NOLOCKS = 2,
	NLM_LCK_BLOCKED = 3,
	NLM_LCK_DENIED_GRACE_PERIOD = 4,
	NLM_DEADLCK = 5,
	NLM_ROFS = 6,
	NLM_STALE_FH = 7,
	NLM_FBIG = 8,
	NLM_FAILED = 9,
};

struct nlm_lock {
	char *caller;
	unsigned int len;
	struct nfs_fh fh;
	struct xdr_netobj oh;
	u32 svid;
	u64 lock_start;
	u64 lock_len;
	struct file_lock fl;
};

struct nlm_cookie {
	unsigned char data[32];
	unsigned int len;
};

struct nlm_args {
	struct nlm_cookie cookie;
	struct nlm_lock lock;
	u32 block;
	u32 reclaim;
	u32 state;
	u32 monitor;
	u32 fsm_access;
	u32 fsm_mode;
};

struct nlm_res {
	struct nlm_cookie cookie;
	__be32 status;
	struct nlm_lock lock;
};

struct nlm_reboot {
	char *mon;
	unsigned int len;
	u32 state;
	struct nsm_private priv;
};

typedef s8 int8_t;

typedef long long unsigned int xfs_ino_t;

typedef __s64 xfs_daddr_t;

typedef uint32_t prid_t;

typedef uint32_t xfs_agblock_t;

typedef uint32_t xfs_agino_t;

typedef uint32_t xfs_extlen_t;

typedef uint32_t xfs_agnumber_t;

typedef uint64_t xfs_extnum_t;

typedef int64_t xfs_fsize_t;

typedef int64_t xfs_lsn_t;

typedef uint64_t xfs_fsblock_t;

typedef uint64_t xfs_rfsblock_t;

typedef uint64_t xfs_rtblock_t;

typedef uint64_t xfs_fileoff_t;

typedef uint64_t xfs_filblks_t;

typedef void *xfs_failaddr_t;

typedef enum {
	XFS_BTNUM_BNOi = 0,
	XFS_BTNUM_CNTi = 1,
	XFS_BTNUM_RMAPi = 2,
	XFS_BTNUM_BMAPi = 3,
	XFS_BTNUM_INOi = 4,
	XFS_BTNUM_FINOi = 5,
	XFS_BTNUM_REFCi = 6,
	XFS_BTNUM_MAX = 7,
} xfs_btnum_t;

enum xfs_ag_resv_type {
	XFS_AG_RESV_NONE = 0,
	XFS_AG_RESV_AGFL = 1,
	XFS_AG_RESV_METADATA = 2,
	XFS_AG_RESV_RMAPBT = 3,
};

typedef unsigned int xfs_km_flags_t;

typedef struct {
	struct rw_semaphore mr_lock;
} mrlock_t;

struct xfs_ag_geometry {
	uint32_t ag_number;
	uint32_t ag_length;
	uint32_t ag_freeblks;
	uint32_t ag_icount;
	uint32_t ag_ifree;
	uint32_t ag_sick;
	uint32_t ag_checked;
	uint32_t ag_flags;
	uint64_t ag_reserved[12];
};

struct __xfsstats {
	uint32_t xs_allocx;
	uint32_t xs_allocb;
	uint32_t xs_freex;
	uint32_t xs_freeb;
	uint32_t xs_abt_lookup;
	uint32_t xs_abt_compare;
	uint32_t xs_abt_insrec;
	uint32_t xs_abt_delrec;
	uint32_t xs_blk_mapr;
	uint32_t xs_blk_mapw;
	uint32_t xs_blk_unmap;
	uint32_t xs_add_exlist;
	uint32_t xs_del_exlist;
	uint32_t xs_look_exlist;
	uint32_t xs_cmp_exlist;
	uint32_t xs_bmbt_lookup;
	uint32_t xs_bmbt_compare;
	uint32_t xs_bmbt_insrec;
	uint32_t xs_bmbt_delrec;
	uint32_t xs_dir_lookup;
	uint32_t xs_dir_create;
	uint32_t xs_dir_remove;
	uint32_t xs_dir_getdents;
	uint32_t xs_trans_sync;
	uint32_t xs_trans_async;
	uint32_t xs_trans_empty;
	uint32_t xs_ig_attempts;
	uint32_t xs_ig_found;
	uint32_t xs_ig_frecycle;
	uint32_t xs_ig_missed;
	uint32_t xs_ig_dup;
	uint32_t xs_ig_reclaims;
	uint32_t xs_ig_attrchg;
	uint32_t xs_log_writes;
	uint32_t xs_log_blocks;
	uint32_t xs_log_noiclogs;
	uint32_t xs_log_force;
	uint32_t xs_log_force_sleep;
	uint32_t xs_try_logspace;
	uint32_t xs_sleep_logspace;
	uint32_t xs_push_ail;
	uint32_t xs_push_ail_success;
	uint32_t xs_push_ail_pushbuf;
	uint32_t xs_push_ail_pinned;
	uint32_t xs_push_ail_locked;
	uint32_t xs_push_ail_flushing;
	uint32_t xs_push_ail_restarts;
	uint32_t xs_push_ail_flush;
	uint32_t xs_xstrat_quick;
	uint32_t xs_xstrat_split;
	uint32_t xs_write_calls;
	uint32_t xs_read_calls;
	uint32_t xs_attr_get;
	uint32_t xs_attr_set;
	uint32_t xs_attr_remove;
	uint32_t xs_attr_list;
	uint32_t xs_iflush_count;
	uint32_t xs_icluster_flushcnt;
	uint32_t xs_icluster_flushinode;
	uint32_t vn_active;
	uint32_t vn_alloc;
	uint32_t vn_get;
	uint32_t vn_hold;
	uint32_t vn_rele;
	uint32_t vn_reclaim;
	uint32_t vn_remove;
	uint32_t vn_free;
	uint32_t xb_get;
	uint32_t xb_create;
	uint32_t xb_get_locked;
	uint32_t xb_get_locked_waited;
	uint32_t xb_busy_locked;
	uint32_t xb_miss_locked;
	uint32_t xb_page_retries;
	uint32_t xb_page_found;
	uint32_t xb_get_read;
	uint32_t xs_abtb_2[15];
	uint32_t xs_abtc_2[15];
	uint32_t xs_bmbt_2[15];
	uint32_t xs_ibt_2[15];
	uint32_t xs_fibt_2[15];
	uint32_t xs_rmap_2[15];
	uint32_t xs_refcbt_2[15];
	uint32_t xs_qm_dqreclaims;
	uint32_t xs_qm_dqreclaim_misses;
	uint32_t xs_qm_dquot_dups;
	uint32_t xs_qm_dqcachemisses;
	uint32_t xs_qm_dqcachehits;
	uint32_t xs_qm_dqwants;
	uint32_t xs_qm_dquot;
	uint32_t xs_qm_dquot_unused;
	uint64_t xs_xstrat_bytes;
	uint64_t xs_write_bytes;
	uint64_t xs_read_bytes;
	uint64_t defer_relog;
};

struct xfsstats {
	union {
		struct __xfsstats s;
		uint32_t a[187];
	};
};

struct xfs_kobj {
	struct kobject kobject;
	struct completion complete;
};

struct xstats {
	struct xfsstats *xs_stats;
	struct xfs_kobj xs_kobj;
};

typedef unsigned int xfs_buf_flags_t;

struct xfs_mount;

struct xfs_buftarg {
	dev_t bt_dev;
	struct block_device *bt_bdev;
	struct dax_device *bt_daxdev;
	u64 bt_dax_part_off;
	struct xfs_mount *bt_mount;
	unsigned int bt_meta_sectorsize;
	size_t bt_meta_sectormask;
	size_t bt_logical_sectorsize;
	size_t bt_logical_sectormask;
	struct shrinker bt_shrinker;
	struct list_lru bt_lru;
	struct percpu_counter bt_io_count;
	struct ratelimit_state bt_ioerror_rl;
};

struct xfs_sb {
	uint32_t sb_magicnum;
	uint32_t sb_blocksize;
	xfs_rfsblock_t sb_dblocks;
	xfs_rfsblock_t sb_rblocks;
	xfs_rtblock_t sb_rextents;
	uuid_t sb_uuid;
	xfs_fsblock_t sb_logstart;
	xfs_ino_t sb_rootino;
	xfs_ino_t sb_rbmino;
	xfs_ino_t sb_rsumino;
	xfs_agblock_t sb_rextsize;
	xfs_agblock_t sb_agblocks;
	xfs_agnumber_t sb_agcount;
	xfs_extlen_t sb_rbmblocks;
	xfs_extlen_t sb_logblocks;
	uint16_t sb_versionnum;
	uint16_t sb_sectsize;
	uint16_t sb_inodesize;
	uint16_t sb_inopblock;
	char sb_fname[12];
	uint8_t sb_blocklog;
	uint8_t sb_sectlog;
	uint8_t sb_inodelog;
	uint8_t sb_inopblog;
	uint8_t sb_agblklog;
	uint8_t sb_rextslog;
	uint8_t sb_inprogress;
	uint8_t sb_imax_pct;
	uint64_t sb_icount;
	uint64_t sb_ifree;
	uint64_t sb_fdblocks;
	uint64_t sb_frextents;
	xfs_ino_t sb_uquotino;
	xfs_ino_t sb_gquotino;
	uint16_t sb_qflags;
	uint8_t sb_flags;
	uint8_t sb_shared_vn;
	xfs_extlen_t sb_inoalignmt;
	uint32_t sb_unit;
	uint32_t sb_width;
	uint8_t sb_dirblklog;
	uint8_t sb_logsectlog;
	uint16_t sb_logsectsize;
	uint32_t sb_logsunit;
	uint32_t sb_features2;
	uint32_t sb_bad_features2;
	uint32_t sb_features_compat;
	uint32_t sb_features_ro_compat;
	uint32_t sb_features_incompat;
	uint32_t sb_features_log_incompat;
	uint32_t sb_crc;
	xfs_extlen_t sb_spino_align;
	xfs_ino_t sb_pquotino;
	xfs_lsn_t sb_lsn;
	uuid_t sb_meta_uuid;
};

typedef struct xfs_buftarg xfs_buftarg_t;

struct xfs_mru_cache;

struct xfs_ino_geometry {
	uint64_t maxicount;
	unsigned int inode_cluster_size;
	unsigned int inode_cluster_size_raw;
	unsigned int inodes_per_cluster;
	unsigned int blocks_per_cluster;
	unsigned int cluster_align;
	unsigned int cluster_align_inodes;
	unsigned int inoalign_mask;
	unsigned int inobt_mxr[2];
	unsigned int inobt_mnr[2];
	unsigned int inobt_maxlevels;
	unsigned int ialloc_inos;
	unsigned int ialloc_blks;
	unsigned int ialloc_min_blks;
	unsigned int ialloc_align;
	unsigned int agino_log;
	unsigned int attr_fork_offset;
	uint64_t new_diflags2;
};

struct xfs_trans_res {
	uint tr_logres;
	int tr_logcount;
	int tr_logflags;
};

struct xfs_trans_resv {
	struct xfs_trans_res tr_write;
	struct xfs_trans_res tr_itruncate;
	struct xfs_trans_res tr_rename;
	struct xfs_trans_res tr_link;
	struct xfs_trans_res tr_remove;
	struct xfs_trans_res tr_symlink;
	struct xfs_trans_res tr_create;
	struct xfs_trans_res tr_create_tmpfile;
	struct xfs_trans_res tr_mkdir;
	struct xfs_trans_res tr_ifree;
	struct xfs_trans_res tr_ichange;
	struct xfs_trans_res tr_growdata;
	struct xfs_trans_res tr_addafork;
	struct xfs_trans_res tr_writeid;
	struct xfs_trans_res tr_attrinval;
	struct xfs_trans_res tr_attrsetm;
	struct xfs_trans_res tr_attrsetrt;
	struct xfs_trans_res tr_attrrm;
	struct xfs_trans_res tr_clearagi;
	struct xfs_trans_res tr_growrtalloc;
	struct xfs_trans_res tr_growrtzero;
	struct xfs_trans_res tr_growrtfree;
	struct xfs_trans_res tr_qm_setqlim;
	struct xfs_trans_res tr_qm_dqalloc;
	struct xfs_trans_res tr_sb;
	struct xfs_trans_res tr_fsyncts;
};

struct xfs_error_cfg {
	struct xfs_kobj kobj;
	int max_retries;
	long int retry_timeout;
};

struct xfs_ail;

struct xfs_buf;

struct xfs_da_geometry;

struct xlog;

struct xfs_inode;

struct xfs_quotainfo;

struct xfs_mount {
	struct xfs_sb m_sb;
	struct super_block *m_super;
	struct xfs_ail *m_ail;
	struct xfs_buf *m_sb_bp;
	char *m_rtname;
	char *m_logname;
	struct xfs_da_geometry *m_dir_geo;
	struct xfs_da_geometry *m_attr_geo;
	struct xlog *m_log;
	struct xfs_inode *m_rbmip;
	struct xfs_inode *m_rsumip;
	struct xfs_inode *m_rootip;
	struct xfs_quotainfo *m_quotainfo;
	xfs_buftarg_t *m_ddev_targp;
	xfs_buftarg_t *m_logdev_targp;
	xfs_buftarg_t *m_rtdev_targp;
	void *m_inodegc;
	uint8_t *m_rsum_cache;
	struct xfs_mru_cache *m_filestream;
	struct workqueue_struct *m_buf_workqueue;
	struct workqueue_struct *m_unwritten_workqueue;
	struct workqueue_struct *m_reclaim_workqueue;
	struct workqueue_struct *m_sync_workqueue;
	struct workqueue_struct *m_blockgc_wq;
	struct workqueue_struct *m_inodegc_wq;
	int m_bsize;
	uint8_t m_blkbit_log;
	uint8_t m_blkbb_log;
	uint8_t m_agno_log;
	uint8_t m_sectbb_log;
	uint m_blockmask;
	uint m_blockwsize;
	uint m_blockwmask;
	uint m_alloc_mxr[2];
	uint m_alloc_mnr[2];
	uint m_bmap_dmxr[2];
	uint m_bmap_dmnr[2];
	uint m_rmap_mxr[2];
	uint m_rmap_mnr[2];
	uint m_refc_mxr[2];
	uint m_refc_mnr[2];
	uint m_alloc_maxlevels;
	uint m_bm_maxlevels[2];
	uint m_rmap_maxlevels;
	uint m_refc_maxlevels;
	unsigned int m_agbtree_maxlevels;
	xfs_extlen_t m_ag_prealloc_blocks;
	uint m_alloc_set_aside;
	uint m_ag_max_usable;
	int m_dalign;
	int m_swidth;
	xfs_agnumber_t m_maxagi;
	uint m_allocsize_log;
	uint m_allocsize_blocks;
	int m_logbufs;
	int m_logbsize;
	uint m_rsumlevels;
	uint m_rsumsize;
	int m_fixedfsid[2];
	uint m_qflags;
	uint64_t m_features;
	uint64_t m_low_space[5];
	uint64_t m_low_rtexts[5];
	struct xfs_ino_geometry m_ino_geo;
	struct xfs_trans_resv m_resv;
	long unsigned int m_opstate;
	bool m_always_cow;
	bool m_fail_unmount;
	bool m_finobt_nores;
	bool m_update_sb;
	uint8_t m_fs_checked;
	uint8_t m_fs_sick;
	uint8_t m_rt_checked;
	uint8_t m_rt_sick;
	long: 64;
	long: 64;
	long: 64;
	spinlock_t m_sb_lock;
	struct percpu_counter m_icount;
	struct percpu_counter m_ifree;
	struct percpu_counter m_fdblocks;
	struct percpu_counter m_frextents;
	struct percpu_counter m_delalloc_blks;
	atomic64_t m_allocbt_blks;
	struct xarray m_perag_tree;
	spinlock_t m_perag_lock;
	uint64_t m_resblks;
	uint64_t m_resblks_avail;
	uint64_t m_resblks_save;
	struct delayed_work m_reclaim_work;
	struct dentry *m_debugfs;
	struct xfs_kobj m_kobj;
	struct xfs_kobj m_error_kobj;
	struct xfs_kobj m_error_meta_kobj;
	struct xfs_error_cfg m_error_cfg[4];
	struct xstats m_stats;
	xfs_agnumber_t m_agfrotor;
	atomic_t m_agirotor;
	struct shrinker m_inodegc_shrinker;
	struct work_struct m_flush_inodes_work;
	uint32_t m_generation;
	struct mutex m_growlock;
	struct cpumask m_inodegc_cpumask;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct xfs_buf_map {
	xfs_daddr_t bm_bn;
	int bm_len;
	unsigned int bm_flags;
};

struct xfs_buf_ops {
	char *name;
	union {
		__be32 magic[2];
		__be16 magic16[2];
	};
	void (*verify_read)(struct xfs_buf *);
	void (*verify_write)(struct xfs_buf *);
	xfs_failaddr_t (*verify_struct)(struct xfs_buf *);
};

struct xfs_perag;

struct xfs_buf_log_item;

struct xfs_trans;

struct xfs_buf {
	struct rhash_head b_rhash_head;
	xfs_daddr_t b_rhash_key;
	int b_length;
	atomic_t b_hold;
	atomic_t b_lru_ref;
	xfs_buf_flags_t b_flags;
	struct semaphore b_sema;
	struct list_head b_lru;
	spinlock_t b_lock;
	unsigned int b_state;
	int b_io_error;
	wait_queue_head_t b_waiters;
	struct list_head b_list;
	struct xfs_perag *b_pag;
	struct xfs_mount *b_mount;
	struct xfs_buftarg *b_target;
	void *b_addr;
	struct work_struct b_ioend_work;
	struct completion b_iowait;
	struct xfs_buf_log_item *b_log_item;
	struct list_head b_li_list;
	struct xfs_trans *b_transp;
	struct page **b_pages;
	struct page *b_page_array[2];
	struct xfs_buf_map *b_maps;
	struct xfs_buf_map __b_map;
	int b_map_count;
	atomic_t b_pin_count;
	atomic_t b_io_remaining;
	unsigned int b_page_count;
	unsigned int b_offset;
	int b_error;
	int b_retries;
	long unsigned int b_first_retry_time;
	int b_last_error;
	const struct xfs_buf_ops *b_ops;
	struct callback_head b_rcu;
};

struct xfs_ag_resv {
	xfs_extlen_t ar_orig_reserved;
	xfs_extlen_t ar_reserved;
	xfs_extlen_t ar_asked;
};

struct xfs_defer_drain {};

struct xfs_perag {
	struct xfs_mount *pag_mount;
	xfs_agnumber_t pag_agno;
	atomic_t pag_ref;
	atomic_t pag_active_ref;
	wait_queue_head_t pag_active_wq;
	long unsigned int pag_opstate;
	uint8_t pagf_levels[3];
	uint32_t pagf_flcount;
	xfs_extlen_t pagf_freeblks;
	xfs_extlen_t pagf_longest;
	uint32_t pagf_btreeblks;
	xfs_agino_t pagi_freecount;
	xfs_agino_t pagi_count;
	xfs_agino_t pagl_pagino;
	xfs_agino_t pagl_leftrec;
	xfs_agino_t pagl_rightrec;
	int pagb_count;
	uint8_t pagf_refcount_level;
	struct xfs_ag_resv pag_meta_resv;
	struct xfs_ag_resv pag_rmapbt_resv;
	struct callback_head callback_head;
	xfs_agblock_t block_count;
	xfs_agblock_t min_block;
	xfs_agino_t agino_min;
	xfs_agino_t agino_max;
	uint16_t pag_checked;
	uint16_t pag_sick;
	spinlock_t pag_state_lock;
	spinlock_t pagb_lock;
	struct rb_root pagb_tree;
	unsigned int pagb_gen;
	wait_queue_head_t pagb_wait;
	atomic_t pagf_fstrms;
	spinlock_t pag_ici_lock;
	struct xarray pag_ici_root;
	int pag_ici_reclaimable;
	long unsigned int pag_ici_reclaim_cursor;
	spinlock_t pag_buf_lock;
	struct rhashtable pag_buf_hash;
	struct delayed_work pag_blockgc_work;
	struct xfs_defer_drain pag_intents_drain;
};

struct xlog_ticket;

struct xfs_dquot_acct;

struct xfs_trans {
	unsigned int t_magic;
	unsigned int t_log_res;
	unsigned int t_log_count;
	unsigned int t_blk_res;
	unsigned int t_blk_res_used;
	unsigned int t_rtx_res;
	unsigned int t_rtx_res_used;
	unsigned int t_flags;
	xfs_agnumber_t t_highest_agno;
	struct xlog_ticket *t_ticket;
	struct xfs_mount *t_mountp;
	struct xfs_dquot_acct *t_dqinfo;
	int64_t t_icount_delta;
	int64_t t_ifree_delta;
	int64_t t_fdblocks_delta;
	int64_t t_res_fdblocks_delta;
	int64_t t_frextents_delta;
	int64_t t_res_frextents_delta;
	int64_t t_dblocks_delta;
	int64_t t_agcount_delta;
	int64_t t_imaxpct_delta;
	int64_t t_rextsize_delta;
	int64_t t_rbmblocks_delta;
	int64_t t_rblocks_delta;
	int64_t t_rextents_delta;
	int64_t t_rextslog_delta;
	struct list_head t_items;
	struct list_head t_busy;
	struct list_head t_dfops;
	long unsigned int t_pflags;
};

struct xfs_dsb {
	__be32 sb_magicnum;
	__be32 sb_blocksize;
	__be64 sb_dblocks;
	__be64 sb_rblocks;
	__be64 sb_rextents;
	uuid_t sb_uuid;
	__be64 sb_logstart;
	__be64 sb_rootino;
	__be64 sb_rbmino;
	__be64 sb_rsumino;
	__be32 sb_rextsize;
	__be32 sb_agblocks;
	__be32 sb_agcount;
	__be32 sb_rbmblocks;
	__be32 sb_logblocks;
	__be16 sb_versionnum;
	__be16 sb_sectsize;
	__be16 sb_inodesize;
	__be16 sb_inopblock;
	char sb_fname[12];
	__u8 sb_blocklog;
	__u8 sb_sectlog;
	__u8 sb_inodelog;
	__u8 sb_inopblog;
	__u8 sb_agblklog;
	__u8 sb_rextslog;
	__u8 sb_inprogress;
	__u8 sb_imax_pct;
	__be64 sb_icount;
	__be64 sb_ifree;
	__be64 sb_fdblocks;
	__be64 sb_frextents;
	__be64 sb_uquotino;
	__be64 sb_gquotino;
	__be16 sb_qflags;
	__u8 sb_flags;
	__u8 sb_shared_vn;
	__be32 sb_inoalignmt;
	__be32 sb_unit;
	__be32 sb_width;
	__u8 sb_dirblklog;
	__u8 sb_logsectlog;
	__be16 sb_logsectsize;
	__be32 sb_logsunit;
	__be32 sb_features2;
	__be32 sb_bad_features2;
	__be32 sb_features_compat;
	__be32 sb_features_ro_compat;
	__be32 sb_features_incompat;
	__be32 sb_features_log_incompat;
	__le32 sb_crc;
	__be32 sb_spino_align;
	__be64 sb_pquotino;
	__be64 sb_lsn;
	uuid_t sb_meta_uuid;
};

struct xfs_agf {
	__be32 agf_magicnum;
	__be32 agf_versionnum;
	__be32 agf_seqno;
	__be32 agf_length;
	__be32 agf_roots[3];
	__be32 agf_levels[3];
	__be32 agf_flfirst;
	__be32 agf_fllast;
	__be32 agf_flcount;
	__be32 agf_freeblks;
	__be32 agf_longest;
	__be32 agf_btreeblks;
	uuid_t agf_uuid;
	__be32 agf_rmap_blocks;
	__be32 agf_refcount_blocks;
	__be32 agf_refcount_root;
	__be32 agf_refcount_level;
	__be64 agf_spare64[14];
	__be64 agf_lsn;
	__be32 agf_crc;
	__be32 agf_spare2;
};

struct xfs_agi {
	__be32 agi_magicnum;
	__be32 agi_versionnum;
	__be32 agi_seqno;
	__be32 agi_length;
	__be32 agi_count;
	__be32 agi_root;
	__be32 agi_level;
	__be32 agi_freecount;
	__be32 agi_newino;
	__be32 agi_dirino;
	__be32 agi_unlinked[64];
	uuid_t agi_uuid;
	__be32 agi_crc;
	__be32 agi_pad32;
	__be64 agi_lsn;
	__be32 agi_free_root;
	__be32 agi_free_level;
	__be32 agi_iblocks;
	__be32 agi_fblocks;
};

struct xfs_agfl {
	__be32 agfl_magicnum;
	__be32 agfl_seqno;
	uuid_t agfl_uuid;
	__be64 agfl_lsn;
	__be32 agfl_crc;
} __attribute__((packed));

struct xfs_alloc_rec {
	__be32 ar_startblock;
	__be32 ar_blockcount;
};

typedef struct xfs_alloc_rec xfs_alloc_rec_t;

struct xfs_owner_info {
	uint64_t oi_owner;
	xfs_fileoff_t oi_offset;
	unsigned int oi_flags;
};

struct xfs_rmap_rec {
	__be32 rm_startblock;
	__be32 rm_blockcount;
	__be64 rm_owner;
	__be64 rm_offset;
};

struct xfs_btree_block_shdr {
	__be32 bb_leftsib;
	__be32 bb_rightsib;
	__be64 bb_blkno;
	__be64 bb_lsn;
	uuid_t bb_uuid;
	__be32 bb_owner;
	__le32 bb_crc;
};

struct xfs_btree_block_lhdr {
	__be64 bb_leftsib;
	__be64 bb_rightsib;
	__be64 bb_blkno;
	__be64 bb_lsn;
	uuid_t bb_uuid;
	__be64 bb_owner;
	__le32 bb_crc;
	__be32 bb_pad;
};

struct xfs_btree_block {
	__be32 bb_magic;
	__be16 bb_level;
	__be16 bb_numrecs;
	union {
		struct xfs_btree_block_shdr s;
		struct xfs_btree_block_lhdr l;
	} bb_u;
};

struct xfs_imap {
	xfs_daddr_t im_blkno;
	short unsigned int im_len;
	short unsigned int im_boffset;
};

struct xfs_ifork {
	int64_t if_bytes;
	struct xfs_btree_block *if_broot;
	unsigned int if_seq;
	int if_height;
	union {
		void *if_root;
		char *if_data;
	} if_u1;
	xfs_extnum_t if_nextents;
	short int if_broot_bytes;
	int8_t if_format;
	uint8_t if_needextents;
};

struct xfs_dquot;

struct xfs_inode_log_item;

struct xfs_inode {
	struct xfs_mount *i_mount;
	struct xfs_dquot *i_udquot;
	struct xfs_dquot *i_gdquot;
	struct xfs_dquot *i_pdquot;
	xfs_ino_t i_ino;
	struct xfs_imap i_imap;
	struct xfs_ifork *i_cowfp;
	struct xfs_ifork i_df;
	struct xfs_ifork i_af;
	struct xfs_inode_log_item *i_itemp;
	mrlock_t i_lock;
	atomic_t i_pincount;
	struct llist_node i_gclist;
	uint16_t i_checked;
	uint16_t i_sick;
	spinlock_t i_flags_lock;
	long unsigned int i_flags;
	uint64_t i_delayed_blks;
	xfs_fsize_t i_disk_size;
	xfs_rfsblock_t i_nblocks;
	prid_t i_projid;
	xfs_extlen_t i_extsize;
	union {
		xfs_extlen_t i_cowextsize;
		uint16_t i_flushiter;
	};
	uint8_t i_forkoff;
	uint16_t i_diflags;
	uint64_t i_diflags2;
	struct timespec64 i_crtime;
	xfs_agino_t i_next_unlinked;
	xfs_agino_t i_prev_unlinked;
	struct inode i_vnode;
	spinlock_t i_ioend_lock;
	struct work_struct i_ioend_work;
	struct list_head i_ioend_list;
};

struct xfs_alloc_arg {
	struct xfs_trans *tp;
	struct xfs_mount *mp;
	struct xfs_buf *agbp;
	struct xfs_perag *pag;
	xfs_fsblock_t fsbno;
	xfs_agnumber_t agno;
	xfs_agblock_t agbno;
	xfs_extlen_t minlen;
	xfs_extlen_t maxlen;
	xfs_extlen_t mod;
	xfs_extlen_t prod;
	xfs_extlen_t minleft;
	xfs_extlen_t total;
	xfs_extlen_t alignment;
	xfs_extlen_t minalignslop;
	xfs_agblock_t min_agbno;
	xfs_agblock_t max_agbno;
	xfs_extlen_t len;
	int datatype;
	char wasdel;
	char wasfromfl;
	struct xfs_owner_info oinfo;
	enum xfs_ag_resv_type resv;
};

struct aghdr_init_data {
	xfs_agblock_t agno;
	xfs_extlen_t agsize;
	struct list_head buffer_list;
	xfs_rfsblock_t nfree;
	xfs_daddr_t daddr;
	size_t numblks;
	xfs_btnum_t type;
};

typedef struct xfs_trans xfs_trans_t;

typedef void (*aghdr_init_work_f)(struct xfs_mount *, struct xfs_buf *, struct aghdr_init_data *);

struct xfs_aghdr_grow_data {
	xfs_daddr_t daddr;
	size_t numblks;
	const struct xfs_buf_ops *ops;
	aghdr_init_work_f work;
	xfs_btnum_t type;
	bool need_init;
};

typedef __s64 xfs_off_t;

typedef __u32 xfs_nlink_t;

typedef int64_t xfs_csn_t;

typedef uint32_t xfs_dablk_t;

typedef uint32_t xfs_dahash_t;

typedef enum {
	XFS_LOOKUP_EQi = 0,
	XFS_LOOKUP_LEi = 1,
	XFS_LOOKUP_GEi = 2,
} xfs_lookup_t;

struct xfs_iext_leaf;

struct xfs_iext_cursor {
	struct xfs_iext_leaf *leaf;
	int pos;
};

typedef enum {
	XFS_EXT_NORM = 0,
	XFS_EXT_UNWRITTEN = 1,
} xfs_exntst_t;

struct xfs_bmbt_irec {
	xfs_fileoff_t br_startoff;
	xfs_fsblock_t br_startblock;
	xfs_filblks_t br_blockcount;
	xfs_exntst_t br_state;
};

typedef struct xfs_bmbt_irec xfs_bmbt_irec_t;

enum xfs_refc_domain {
	XFS_REFC_DOMAIN_SHARED = 0,
	XFS_REFC_DOMAIN_COW = 1,
};

struct xfs_refcount_irec {
	xfs_agblock_t rc_startblock;
	xfs_extlen_t rc_blockcount;
	xfs_nlink_t rc_refcount;
	enum xfs_refc_domain rc_domain;
};

struct xfs_rmap_irec {
	xfs_agblock_t rm_startblock;
	xfs_extlen_t rm_blockcount;
	uint64_t rm_owner;
	uint64_t rm_offset;
	unsigned int rm_flags;
};

enum {
	__XBTS_lookup = 0,
	__XBTS_compare = 1,
	__XBTS_insrec = 2,
	__XBTS_delrec = 3,
	__XBTS_newroot = 4,
	__XBTS_killroot = 5,
	__XBTS_increment = 6,
	__XBTS_decrement = 7,
	__XBTS_lshift = 8,
	__XBTS_rshift = 9,
	__XBTS_split = 10,
	__XBTS_join = 11,
	__XBTS_alloc = 12,
	__XBTS_free = 13,
	__XBTS_moves = 14,
	__XBTS_MAX = 15,
};

struct xfs_item_ops;

struct xfs_log_vec;

struct xfs_log_item {
	struct list_head li_ail;
	struct list_head li_trans;
	xfs_lsn_t li_lsn;
	struct xlog *li_log;
	struct xfs_ail *li_ailp;
	uint li_type;
	long unsigned int li_flags;
	struct xfs_buf *li_buf;
	struct list_head li_bio_list;
	const struct xfs_item_ops *li_ops;
	struct list_head li_cil;
	struct xfs_log_vec *li_lv;
	struct xfs_log_vec *li_lv_shadow;
	xfs_csn_t li_seq;
	uint32_t li_order_id;
};

struct xfs_buf_log_format {
	short unsigned int blf_type;
	short unsigned int blf_size;
	short unsigned int blf_flags;
	short unsigned int blf_len;
	int64_t blf_blkno;
	unsigned int blf_map_size;
	unsigned int blf_data_map[17];
};

struct xfs_buf_log_item {
	struct xfs_log_item bli_item;
	struct xfs_buf *bli_buf;
	unsigned int bli_flags;
	unsigned int bli_recur;
	atomic_t bli_refcount;
	int bli_format_count;
	struct xfs_buf_log_format *bli_formats;
	struct xfs_buf_log_format __bli_format;
};

enum xfs_dinode_fmt {
	XFS_DINODE_FMT_DEV = 0,
	XFS_DINODE_FMT_LOCAL = 1,
	XFS_DINODE_FMT_EXTENTS = 2,
	XFS_DINODE_FMT_BTREE = 3,
	XFS_DINODE_FMT_UUID = 4,
};

typedef struct xfs_alloc_rec xfs_alloc_key_t;

struct xfs_alloc_rec_incore {
	xfs_agblock_t ar_startblock;
	xfs_extlen_t ar_blockcount;
};

typedef uint64_t xfs_inofree_t;

struct xfs_inobt_rec {
	__be32 ir_startino;
	union {
		struct {
			__be32 ir_freecount;
		} f;
		struct {
			__be16 ir_holemask;
			__u8 ir_count;
			__u8 ir_freecount;
		} sp;
	} ir_u;
	__be64 ir_free;
};

struct xfs_inobt_rec_incore {
	xfs_agino_t ir_startino;
	uint16_t ir_holemask;
	uint8_t ir_count;
	uint8_t ir_freecount;
	xfs_inofree_t ir_free;
};

struct xfs_inobt_key {
	__be32 ir_startino;
};

struct xfs_rmap_key {
	__be32 rm_startblock;
	__be64 rm_owner;
	__be64 rm_offset;
} __attribute__((packed));

struct xfs_refcount_rec {
	__be32 rc_startblock;
	__be32 rc_blockcount;
	__be32 rc_refcount;
};

struct xfs_refcount_key {
	__be32 rc_startblock;
};

struct xfs_bmbt_rec {
	__be64 l0;
	__be64 l1;
};

typedef struct xfs_bmbt_rec xfs_bmbt_rec_t;

typedef xfs_bmbt_rec_t xfs_bmdr_rec_t;

struct xfs_bmbt_key {
	__be64 br_startoff;
};

typedef struct xfs_bmbt_key xfs_bmbt_key_t;

typedef struct xfs_bmbt_key xfs_bmdr_key_t;

typedef __be64 xfs_bmbt_ptr_t;

enum {
	XFS_LOWSP_1_PCNT = 0,
	XFS_LOWSP_2_PCNT = 1,
	XFS_LOWSP_3_PCNT = 2,
	XFS_LOWSP_4_PCNT = 3,
	XFS_LOWSP_5_PCNT = 4,
	XFS_LOWSP_MAX = 5,
};

enum {
	XFS_ERR_METADATA = 0,
	XFS_ERR_CLASS_MAX = 1,
};

enum {
	XFS_ERR_DEFAULT = 0,
	XFS_ERR_EIO = 1,
	XFS_ERR_ENOSPC = 2,
	XFS_ERR_ENODEV = 3,
	XFS_ERR_ERRNO_MAX = 4,
};

typedef uint xfs_dir2_data_aoff_t;

struct xfs_da_geometry {
	unsigned int blksize;
	unsigned int fsbcount;
	uint8_t fsblog;
	uint8_t blklog;
	unsigned int node_hdr_size;
	unsigned int node_ents;
	unsigned int magicpct;
	xfs_dablk_t datablk;
	unsigned int leaf_hdr_size;
	unsigned int leaf_max_ents;
	xfs_dablk_t leafblk;
	unsigned int free_hdr_size;
	unsigned int free_max_bests;
	xfs_dablk_t freeblk;
	xfs_extnum_t max_extents;
	xfs_dir2_data_aoff_t data_first_offset;
	size_t data_entry_offset;
};

typedef struct xfs_mount xfs_mount_t;

enum xfs_defer_ops_type {
	XFS_DEFER_OPS_TYPE_BMAP = 0,
	XFS_DEFER_OPS_TYPE_REFCOUNT = 1,
	XFS_DEFER_OPS_TYPE_RMAP = 2,
	XFS_DEFER_OPS_TYPE_FREE = 3,
	XFS_DEFER_OPS_TYPE_AGFL_FREE = 4,
	XFS_DEFER_OPS_TYPE_ATTR = 5,
	XFS_DEFER_OPS_TYPE_MAX = 6,
};

union xfs_btree_irec {
	struct xfs_alloc_rec_incore a;
	struct xfs_bmbt_irec b;
	struct xfs_inobt_rec_incore i;
	struct xfs_rmap_irec r;
	struct xfs_refcount_irec rc;
};

struct xbtree_afakeroot;

struct xfs_btree_cur_ag {
	struct xfs_perag *pag;
	union {
		struct xfs_buf *agbp;
		struct xbtree_afakeroot *afake;
	};
	union {
		struct {
			unsigned int nr_ops;
			unsigned int shape_changes;
		} refc;
		struct {
			bool active;
		} abt;
	};
};

struct xbtree_ifakeroot;

struct xfs_btree_cur_ino {
	struct xfs_inode *ip;
	struct xbtree_ifakeroot *ifake;
	int allocated;
	short int forksize;
	char whichfork;
	char flags;
};

struct xfs_btree_level {
	struct xfs_buf *bp;
	uint16_t ptr;
	uint16_t ra;
};

struct xfs_btree_ops;

struct xfs_btree_cur {
	struct xfs_trans *bc_tp;
	struct xfs_mount *bc_mp;
	const struct xfs_btree_ops *bc_ops;
	struct kmem_cache *bc_cache;
	unsigned int bc_flags;
	xfs_btnum_t bc_btnum;
	union xfs_btree_irec bc_rec;
	uint8_t bc_nlevels;
	uint8_t bc_maxlevels;
	int bc_statoff;
	union {
		struct xfs_btree_cur_ag bc_ag;
		struct xfs_btree_cur_ino bc_ino;
	};
	struct xfs_btree_level bc_levels[0];
};

enum xfs_dacmp {
	XFS_CMP_DIFFERENT = 0,
	XFS_CMP_EXACT = 1,
	XFS_CMP_CASE = 2,
};

struct xfs_da_args {
	struct xfs_da_geometry *geo;
	const uint8_t *name;
	int namelen;
	uint8_t filetype;
	void *value;
	int valuelen;
	unsigned int attr_filter;
	unsigned int attr_flags;
	xfs_dahash_t hashval;
	xfs_ino_t inumber;
	struct xfs_inode *dp;
	struct xfs_trans *trans;
	xfs_extlen_t total;
	int whichfork;
	xfs_dablk_t blkno;
	int index;
	xfs_dablk_t rmtblkno;
	int rmtblkcnt;
	int rmtvaluelen;
	xfs_dablk_t blkno2;
	int index2;
	xfs_dablk_t rmtblkno2;
	int rmtblkcnt2;
	int rmtvaluelen2;
	uint32_t op_flags;
	enum xfs_dacmp cmpresult;
};

typedef struct xfs_inode xfs_inode_t;

union xfs_btree_ptr {
	__be32 s;
	__be64 l;
};

union xfs_btree_key {
	struct xfs_bmbt_key bmbt;
	xfs_bmdr_key_t bmbr;
	xfs_alloc_key_t alloc;
	struct xfs_inobt_key inobt;
	struct xfs_rmap_key rmap;
	struct xfs_rmap_key __rmap_bigkey[2];
	struct xfs_refcount_key refc;
};

union xfs_btree_rec {
	struct xfs_bmbt_rec bmbt;
	xfs_bmdr_rec_t bmbr;
	struct xfs_alloc_rec alloc;
	struct xfs_inobt_rec inobt;
	struct xfs_rmap_rec rmap;
	struct xfs_refcount_rec refc;
};

enum xbtree_key_contig {
	XBTREE_KEY_GAP = 0,
	XBTREE_KEY_CONTIGUOUS = 1,
	XBTREE_KEY_OVERLAP = 2,
};

struct xfs_btree_ops {
	size_t key_len;
	size_t rec_len;
	struct xfs_btree_cur * (*dup_cursor)(struct xfs_btree_cur *);
	void (*update_cursor)(struct xfs_btree_cur *, struct xfs_btree_cur *);
	void (*set_root)(struct xfs_btree_cur *, const union xfs_btree_ptr *, int);
	int (*alloc_block)(struct xfs_btree_cur *, const union xfs_btree_ptr *, union xfs_btree_ptr *, int *);
	int (*free_block)(struct xfs_btree_cur *, struct xfs_buf *);
	void (*update_lastrec)(struct xfs_btree_cur *, const struct xfs_btree_block *, const union xfs_btree_rec *, int, int);
	int (*get_minrecs)(struct xfs_btree_cur *, int);
	int (*get_maxrecs)(struct xfs_btree_cur *, int);
	int (*get_dmaxrecs)(struct xfs_btree_cur *, int);
	void (*init_key_from_rec)(union xfs_btree_key *, const union xfs_btree_rec *);
	void (*init_rec_from_cur)(struct xfs_btree_cur *, union xfs_btree_rec *);
	void (*init_ptr_from_cur)(struct xfs_btree_cur *, union xfs_btree_ptr *);
	void (*init_high_key_from_rec)(union xfs_btree_key *, const union xfs_btree_rec *);
	int64_t (*key_diff)(struct xfs_btree_cur *, const union xfs_btree_key *);
	int64_t (*diff_two_keys)(struct xfs_btree_cur *, const union xfs_btree_key *, const union xfs_btree_key *, const union xfs_btree_key *);
	const struct xfs_buf_ops *buf_ops;
	int (*keys_inorder)(struct xfs_btree_cur *, const union xfs_btree_key *, const union xfs_btree_key *);
	int (*recs_inorder)(struct xfs_btree_cur *, const union xfs_btree_rec *, const union xfs_btree_rec *);
	enum xbtree_key_contig (*keys_contiguous)(struct xfs_btree_cur *, const union xfs_btree_key *, const union xfs_btree_key *, const union xfs_btree_key *);
};

typedef int (*xfs_btree_visit_blocks_fn)(struct xfs_btree_cur *, int, void *);

struct xfs_item_ops {
	unsigned int flags;
	void (*iop_size)(struct xfs_log_item *, int *, int *);
	void (*iop_format)(struct xfs_log_item *, struct xfs_log_vec *);
	void (*iop_pin)(struct xfs_log_item *);
	void (*iop_unpin)(struct xfs_log_item *, int);
	uint64_t (*iop_sort)(struct xfs_log_item *);
	int (*iop_precommit)(struct xfs_trans *, struct xfs_log_item *);
	void (*iop_committing)(struct xfs_log_item *, xfs_csn_t);
	xfs_lsn_t (*iop_committed)(struct xfs_log_item *, xfs_lsn_t);
	uint (*iop_push)(struct xfs_log_item *, struct list_head *);
	void (*iop_release)(struct xfs_log_item *);
	int (*iop_recover)(struct xfs_log_item *, struct list_head *);
	bool (*iop_match)(struct xfs_log_item *, uint64_t);
	struct xfs_log_item * (*iop_relog)(struct xfs_log_item *, struct xfs_trans *);
	struct xfs_log_item * (*iop_intent)(struct xfs_log_item *);
};

typedef struct xfs_alloc_arg xfs_alloc_arg_t;

struct xfs_bmalloca {
	struct xfs_trans *tp;
	struct xfs_inode *ip;
	struct xfs_bmbt_irec prev;
	struct xfs_bmbt_irec got;
	xfs_fileoff_t offset;
	xfs_extlen_t length;
	xfs_fsblock_t blkno;
	struct xfs_btree_cur *cur;
	struct xfs_iext_cursor icur;
	int nallocs;
	int logflags;
	xfs_extlen_t total;
	xfs_extlen_t minlen;
	xfs_extlen_t minleft;
	bool eof;
	bool wasdel;
	bool aeof;
	bool conv;
	int datatype;
	uint32_t flags;
};

enum xfs_bmap_intent_type {
	XFS_BMAP_MAP = 1,
	XFS_BMAP_UNMAP = 2,
};

struct xfs_bmap_intent {
	struct list_head bi_list;
	enum xfs_bmap_intent_type bi_type;
	int bi_whichfork;
	struct xfs_inode *bi_owner;
	struct xfs_perag *bi_pag;
	struct xfs_bmbt_irec bi_bmap;
};

struct xfs_iread_state {
	struct xfs_iext_cursor icur;
	xfs_extnum_t loaded;
};

enum xfs_blft {
	XFS_BLFT_UNKNOWN_BUF = 0,
	XFS_BLFT_UDQUOT_BUF = 1,
	XFS_BLFT_PDQUOT_BUF = 2,
	XFS_BLFT_GDQUOT_BUF = 3,
	XFS_BLFT_BTREE_BUF = 4,
	XFS_BLFT_AGF_BUF = 5,
	XFS_BLFT_AGFL_BUF = 6,
	XFS_BLFT_AGI_BUF = 7,
	XFS_BLFT_DINO_BUF = 8,
	XFS_BLFT_SYMLINK_BUF = 9,
	XFS_BLFT_DIR_BLOCK_BUF = 10,
	XFS_BLFT_DIR_DATA_BUF = 11,
	XFS_BLFT_DIR_FREE_BUF = 12,
	XFS_BLFT_DIR_LEAF1_BUF = 13,
	XFS_BLFT_DIR_LEAFN_BUF = 14,
	XFS_BLFT_DA_NODE_BUF = 15,
	XFS_BLFT_ATTR_LEAF_BUF = 16,
	XFS_BLFT_ATTR_RMT_BUF = 17,
	XFS_BLFT_SB_BUF = 18,
	XFS_BLFT_RTBITMAP_BUF = 19,
	XFS_BLFT_RTSUMMARY_BUF = 20,
	XFS_BLFT_MAX_BUF = 32,
};

struct xfs_da_blkinfo {
	__be32 forw;
	__be32 back;
	__be16 magic;
	__be16 pad;
};

typedef struct xfs_da_blkinfo xfs_da_blkinfo_t;

struct xfs_da3_blkinfo {
	struct xfs_da_blkinfo hdr;
	__be32 crc;
	__be64 blkno;
	__be64 lsn;
	uuid_t uuid;
	__be64 owner;
};

typedef uint16_t xfs_dir2_data_off_t;

typedef uint32_t xfs_dir2_dataptr_t;

typedef xfs_off_t xfs_dir2_off_t;

typedef uint32_t xfs_dir2_db_t;

struct xfs_dir2_data_free {
	__be16 offset;
	__be16 length;
};

typedef struct xfs_dir2_data_free xfs_dir2_data_free_t;

struct xfs_dir2_data_hdr {
	__be32 magic;
	xfs_dir2_data_free_t bestfree[3];
};

typedef struct xfs_dir2_data_hdr xfs_dir2_data_hdr_t;

struct xfs_dir2_data_entry {
	__be64 inumber;
	__u8 namelen;
	__u8 name[0];
};

typedef struct xfs_dir2_data_entry xfs_dir2_data_entry_t;

struct xfs_dir2_data_unused {
	__be16 freetag;
	__be16 length;
	__be16 tag;
};

typedef struct xfs_dir2_data_unused xfs_dir2_data_unused_t;

struct xfs_dir2_leaf_hdr {
	xfs_da_blkinfo_t info;
	__be16 count;
	__be16 stale;
};

typedef struct xfs_dir2_leaf_hdr xfs_dir2_leaf_hdr_t;

struct xfs_dir3_leaf_hdr {
	struct xfs_da3_blkinfo info;
	__be16 count;
	__be16 stale;
	__be32 pad;
};

struct xfs_dir2_leaf_entry {
	__be32 hashval;
	__be32 address;
};

typedef struct xfs_dir2_leaf_entry xfs_dir2_leaf_entry_t;

struct xfs_dir2_leaf_tail {
	__be32 bestcount;
};

typedef struct xfs_dir2_leaf_tail xfs_dir2_leaf_tail_t;

struct xfs_dir2_leaf {
	xfs_dir2_leaf_hdr_t hdr;
	xfs_dir2_leaf_entry_t __ents[0];
};

typedef struct xfs_dir2_leaf xfs_dir2_leaf_t;

struct xfs_dir3_leaf {
	struct xfs_dir3_leaf_hdr hdr;
	struct xfs_dir2_leaf_entry __ents[0];
};

struct xfs_dir2_free_hdr {
	__be32 magic;
	__be32 firstdb;
	__be32 nvalid;
	__be32 nused;
};

typedef struct xfs_dir2_free_hdr xfs_dir2_free_hdr_t;

struct xfs_dir2_free {
	xfs_dir2_free_hdr_t hdr;
	__be16 bests[0];
};

struct xfs_dir2_block_tail {
	__be32 count;
	__be32 stale;
};

typedef struct xfs_dir2_block_tail xfs_dir2_block_tail_t;

typedef struct xfs_da_args xfs_da_args_t;

struct xfs_da_state_blk {
	struct xfs_buf *bp;
	xfs_dablk_t blkno;
	xfs_daddr_t disk_blkno;
	int index;
	xfs_dahash_t hashval;
	int magic;
};

typedef struct xfs_da_state_blk xfs_da_state_blk_t;

struct xfs_da_state_path {
	int active;
	xfs_da_state_blk_t blk[5];
};

typedef struct xfs_da_state_path xfs_da_state_path_t;

struct xfs_da_state {
	xfs_da_args_t *args;
	struct xfs_mount *mp;
	xfs_da_state_path_t path;
	xfs_da_state_path_t altpath;
	unsigned char inleaf;
	unsigned char extravalid;
	unsigned char extraafter;
	xfs_da_state_blk_t extrablk;
};

typedef struct xfs_da_state xfs_da_state_t;

struct xfs_dir3_icleaf_hdr {
	uint32_t forw;
	uint32_t back;
	uint16_t magic;
	uint16_t count;
	uint16_t stale;
	struct xfs_dir2_leaf_entry *ents;
};

struct xfs_dir3_icfree_hdr {
	uint32_t magic;
	uint32_t firstdb;
	uint32_t nvalid;
	uint32_t nused;
	__be16 *bests;
};

typedef unsigned int __kernel_mode_t;

typedef __kernel_mode_t mode_t;

typedef __be64 xfs_timestamp_t;

struct xfs_legacy_timestamp {
	__be32 t_sec;
	__be32 t_nsec;
};

struct xfs_dinode {
	__be16 di_magic;
	__be16 di_mode;
	__u8 di_version;
	__u8 di_format;
	__be16 di_onlink;
	__be32 di_uid;
	__be32 di_gid;
	__be32 di_nlink;
	__be16 di_projid_lo;
	__be16 di_projid_hi;
	union {
		__be64 di_big_nextents;
		__be64 di_v3_pad;
		struct {
			__u8 di_v2_pad[6];
			__be16 di_flushiter;
		};
	};
	xfs_timestamp_t di_atime;
	xfs_timestamp_t di_mtime;
	xfs_timestamp_t di_ctime;
	__be64 di_size;
	__be64 di_nblocks;
	__be32 di_extsize;
	union {
		struct {
			__be32 di_nextents;
			__be16 di_anextents;
		} __attribute__((packed));
		struct {
			__be32 di_big_anextents;
			__be16 di_nrext64_pad;
		} __attribute__((packed));
	};
	__u8 di_forkoff;
	__s8 di_aformat;
	__be32 di_dmevmask;
	__be16 di_dmstate;
	__be16 di_flags;
	__be32 di_gen;
	__be32 di_next_unlinked;
	__le32 di_crc;
	__be64 di_changecount;
	__be64 di_lsn;
	__be64 di_flags2;
	__be32 di_cowextsize;
	__u8 di_pad2[12];
	xfs_timestamp_t di_crtime;
	__be64 di_ino;
	uuid_t di_uuid;
};

struct xfs_dsymlink_hdr {
	__be32 sl_magic;
	__be32 sl_offset;
	__be32 sl_bytes;
	__be32 sl_crc;
	uuid_t sl_uuid;
	__be64 sl_owner;
	__be64 sl_blkno;
	__be64 sl_lsn;
};

struct xfs_log_iovec {
	void *i_addr;
	int i_len;
	uint i_type;
};

struct xfs_log_vec {
	struct list_head lv_list;
	uint32_t lv_order_id;
	int lv_niovecs;
	struct xfs_log_iovec *lv_iovecp;
	struct xfs_log_item *lv_item;
	char *lv_buf;
	int lv_bytes;
	int lv_buf_len;
	int lv_size;
};

struct xfs_da_node_hdr {
	struct xfs_da_blkinfo info;
	__be16 __count;
	__be16 __level;
};

struct xfs_da_node_entry {
	__be32 hashval;
	__be32 before;
};

struct xfs_da_intnode {
	struct xfs_da_node_hdr hdr;
	struct xfs_da_node_entry __btree[0];
};

struct xfs_attr_sf_hdr {
	__be16 totsize;
	__u8 count;
	__u8 padding;
};

struct xfs_attr_sf_entry {
	uint8_t namelen;
	uint8_t valuelen;
	uint8_t flags;
	uint8_t nameval[0];
};

struct xfs_attr_shortform {
	struct xfs_attr_sf_hdr hdr;
	struct xfs_attr_sf_entry list[0];
};

struct xfs_attr_leaf_map {
	__be16 base;
	__be16 size;
};

typedef struct xfs_attr_leaf_map xfs_attr_leaf_map_t;

struct xfs_attr_leaf_hdr {
	xfs_da_blkinfo_t info;
	__be16 count;
	__be16 usedbytes;
	__be16 firstused;
	__u8 holes;
	__u8 pad1;
	xfs_attr_leaf_map_t freemap[3];
};

typedef struct xfs_attr_leaf_hdr xfs_attr_leaf_hdr_t;

struct xfs_attr_leaf_entry {
	__be32 hashval;
	__be16 nameidx;
	__u8 flags;
	__u8 pad2;
};

typedef struct xfs_attr_leaf_entry xfs_attr_leaf_entry_t;

struct xfs_attr_leaf_name_local {
	__be16 valuelen;
	__u8 namelen;
	__u8 nameval[0];
};

typedef struct xfs_attr_leaf_name_local xfs_attr_leaf_name_local_t;

struct xfs_attr_leaf_name_remote {
	__be32 valueblk;
	__be32 valuelen;
	__u8 namelen;
	__u8 name[0];
};

typedef struct xfs_attr_leaf_name_remote xfs_attr_leaf_name_remote_t;

struct xfs_attr_leafblock {
	xfs_attr_leaf_hdr_t hdr;
	xfs_attr_leaf_entry_t entries[0];
};

typedef struct xfs_attr_leafblock xfs_attr_leafblock_t;

struct xfs_attr3_leaf_hdr {
	struct xfs_da3_blkinfo info;
	__be16 count;
	__be16 usedbytes;
	__be16 firstused;
	__u8 holes;
	__u8 pad1;
	struct xfs_attr_leaf_map freemap[3];
	__be32 pad2;
};

struct xfs_attr3_leafblock {
	struct xfs_attr3_leaf_hdr hdr;
	struct xfs_attr_leaf_entry entries[0];
};

struct xfs_da3_icnode_hdr {
	uint32_t forw;
	uint32_t back;
	uint16_t magic;
	uint16_t count;
	uint16_t level;
	struct xfs_da_node_entry *btree;
};

struct xfs_attrlist_cursor_kern {
	__u32 hashval;
	__u32 blkno;
	__u32 offset;
	__u16 pad1;
	__u8 pad2;
	__u8 initted;
};

struct xfs_attr_list_context;

typedef void (*put_listent_func_t)(struct xfs_attr_list_context *, int, unsigned char *, int, int);

struct xfs_attr_list_context {
	struct xfs_trans *tp;
	struct xfs_inode *dp;
	struct xfs_attrlist_cursor_kern cursor;
	void *buffer;
	int seen_enough;
	bool allow_incomplete;
	ssize_t count;
	int dupcnt;
	int bufsize;
	int firstu;
	unsigned int attr_filter;
	int resynch;
	put_listent_func_t put_listent;
	int index;
};

struct xfs_attr_sf_sort {
	uint8_t entno;
	uint8_t namelen;
	uint8_t valuelen;
	uint8_t flags;
	xfs_dahash_t hash;
	unsigned char *name;
};

typedef struct xfs_attr_sf_sort xfs_attr_sf_sort_t;

struct xfs_attr3_icleaf_hdr {
	uint32_t forw;
	uint32_t back;
	uint16_t magic;
	uint16_t count;
	uint16_t usedbytes;
	uint32_t firstused;
	__u8 holes;
	struct {
		uint16_t base;
		uint16_t size;
	} freemap[3];
};

struct xfs_extent_busy {
	struct rb_node rb_node;
	struct list_head list;
	xfs_agnumber_t agno;
	xfs_agblock_t bno;
	xfs_extlen_t length;
	unsigned int flags;
};

struct fsxattr {
	__u32 fsx_xflags;
	__u32 fsx_extsize;
	__u32 fsx_nextents;
	__u32 fsx_projid;
	__u32 fsx_cowextsize;
	unsigned char fsx_pad[8];
};

struct dioattr {
	__u32 d_mem;
	__u32 d_miniosz;
	__u32 d_maxiosz;
};

struct getbmapx {
	__s64 bmv_offset;
	__s64 bmv_block;
	__s64 bmv_length;
	__s32 bmv_count;
	__s32 bmv_entries;
	__s32 bmv_iflags;
	__s32 bmv_oflags;
	__s32 bmv_unused1;
	__s32 bmv_unused2;
};

struct xfs_fsop_geom {
	__u32 blocksize;
	__u32 rtextsize;
	__u32 agblocks;
	__u32 agcount;
	__u32 logblocks;
	__u32 sectsize;
	__u32 inodesize;
	__u32 imaxpct;
	__u64 datablocks;
	__u64 rtblocks;
	__u64 rtextents;
	__u64 logstart;
	unsigned char uuid[16];
	__u32 sunit;
	__u32 swidth;
	__s32 version;
	__u32 flags;
	__u32 logsectsize;
	__u32 rtsectsize;
	__u32 dirblocksize;
	__u32 logsunit;
	uint32_t sick;
	uint32_t checked;
	__u64 reserved[17];
};

struct xfs_fsop_counts {
	__u64 freedata;
	__u64 freertx;
	__u64 freeino;
	__u64 allocino;
};

typedef struct xfs_fsop_counts xfs_fsop_counts_t;

struct xfs_fsop_resblks {
	__u64 resblks;
	__u64 resblks_avail;
};

typedef struct xfs_fsop_resblks xfs_fsop_resblks_t;

struct xfs_growfs_data {
	__u64 newblocks;
	__u32 imaxpct;
};

struct xfs_growfs_log {
	__u32 newblocks;
	__u32 isint;
};

struct xfs_growfs_rt {
	__u64 newblocks;
	__u32 extsize;
};

typedef struct xfs_growfs_rt xfs_growfs_rt_t;

struct xfs_bstime {
	__kernel_long_t tv_sec;
	__s32 tv_nsec;
};

typedef struct xfs_bstime xfs_bstime_t;

struct xfs_bstat {
	__u64 bs_ino;
	__u16 bs_mode;
	__u16 bs_nlink;
	__u32 bs_uid;
	__u32 bs_gid;
	__u32 bs_rdev;
	__s32 bs_blksize;
	__s64 bs_size;
	xfs_bstime_t bs_atime;
	xfs_bstime_t bs_mtime;
	xfs_bstime_t bs_ctime;
	int64_t bs_blocks;
	__u32 bs_xflags;
	__s32 bs_extsize;
	__s32 bs_extents;
	__u32 bs_gen;
	__u16 bs_projid_lo;
	__u16 bs_forkoff;
	__u16 bs_projid_hi;
	uint16_t bs_sick;
	uint16_t bs_checked;
	unsigned char bs_pad[2];
	__u32 bs_cowextsize;
	__u32 bs_dmevmask;
	__u16 bs_dmstate;
	__u16 bs_aextents;
};

struct xfs_bulkstat {
	uint64_t bs_ino;
	uint64_t bs_size;
	uint64_t bs_blocks;
	uint64_t bs_xflags;
	int64_t bs_atime;
	int64_t bs_mtime;
	int64_t bs_ctime;
	int64_t bs_btime;
	uint32_t bs_gen;
	uint32_t bs_uid;
	uint32_t bs_gid;
	uint32_t bs_projectid;
	uint32_t bs_atime_nsec;
	uint32_t bs_mtime_nsec;
	uint32_t bs_ctime_nsec;
	uint32_t bs_btime_nsec;
	uint32_t bs_blksize;
	uint32_t bs_rdev;
	uint32_t bs_cowextsize_blks;
	uint32_t bs_extsize_blks;
	uint32_t bs_nlink;
	uint32_t bs_extents;
	uint32_t bs_aextents;
	uint16_t bs_version;
	uint16_t bs_forkoff;
	uint16_t bs_sick;
	uint16_t bs_checked;
	uint16_t bs_mode;
	uint16_t bs_pad2;
	uint64_t bs_extents64;
	uint64_t bs_pad[6];
};

struct xfs_fsop_bulkreq {
	__u64 *lastip;
	__s32 icount;
	void *ubuffer;
	__s32 *ocount;
};

struct xfs_inogrp {
	__u64 xi_startino;
	__s32 xi_alloccount;
	__u64 xi_allocmask;
};

struct xfs_inumbers {
	uint64_t xi_startino;
	uint64_t xi_allocmask;
	uint8_t xi_alloccount;
	uint8_t xi_version;
	uint8_t xi_padding[6];
};

struct xfs_bulk_ireq {
	uint64_t ino;
	uint32_t flags;
	uint32_t icount;
	uint32_t ocount;
	uint32_t agno;
	uint64_t reserved[5];
};

struct xfs_bulkstat_req {
	struct xfs_bulk_ireq hdr;
	struct xfs_bulkstat bulkstat[0];
};

struct xfs_inumbers_req {
	struct xfs_bulk_ireq hdr;
	struct xfs_inumbers inumbers[0];
};

struct xfs_error_injection {
	__s32 fd;
	__s32 errtag;
};

typedef struct xfs_error_injection xfs_error_injection_t;

struct xfs_fs_eofblocks {
	__u32 eof_version;
	__u32 eof_flags;
	uid_t eof_uid;
	gid_t eof_gid;
	prid_t eof_prid;
	__u32 pad32;
	__u64 eof_min_file_size;
	__u64 pad64[12];
};

struct xfs_fsop_handlereq {
	__u32 fd;
	void *path;
	__u32 oflags;
	void *ihandle;
	__u32 ihandlen;
	void *ohandle;
	__u32 *ohandlen;
};

typedef struct xfs_fsop_handlereq xfs_fsop_handlereq_t;

struct xfs_attrlist_cursor {
	__u32 opaque[4];
};

struct xfs_attrlist {
	__s32 al_count;
	__s32 al_more;
	__s32 al_offset[0];
};

struct xfs_attrlist_ent {
	__u32 a_valuelen;
	char a_name[0];
};

struct xfs_fsop_attrlist_handlereq {
	struct xfs_fsop_handlereq hreq;
	struct xfs_attrlist_cursor pos;
	__u32 flags;
	__u32 buflen;
	void *buffer;
};

struct xfs_attr_multiop {
	__u32 am_opcode;
	__s32 am_error;
	void *am_attrname;
	void *am_attrvalue;
	__u32 am_length;
	__u32 am_flags;
};

typedef struct xfs_attr_multiop xfs_attr_multiop_t;

struct xfs_fsop_attrmulti_handlereq {
	struct xfs_fsop_handlereq hreq;
	__u32 opcount;
	struct xfs_attr_multiop *ops;
};

typedef struct xfs_fsop_attrmulti_handlereq xfs_fsop_attrmulti_handlereq_t;

typedef struct {
	__u32 val[2];
} xfs_fsid_t;

struct xfs_fid {
	__u16 fid_len;
	__u16 fid_pad;
	__u32 fid_gen;
	__u64 fid_ino;
};

typedef struct xfs_fid xfs_fid_t;

struct xfs_handle {
	union {
		__s64 align;
		xfs_fsid_t _ha_fsid;
	} ha_u;
	xfs_fid_t ha_fid;
};

typedef struct xfs_handle xfs_handle_t;

struct xfs_swapext {
	int64_t sx_version;
	int64_t sx_fdtarget;
	int64_t sx_fdtmp;
	xfs_off_t sx_offset;
	xfs_off_t sx_length;
	char sx_pad[16];
	struct xfs_bstat sx_stat;
};

typedef struct xfs_swapext xfs_swapext_t;

struct xfs_scrub_metadata {
	__u32 sm_type;
	__u32 sm_flags;
	__u64 sm_ino;
	__u32 sm_gen;
	__u32 sm_agno;
	__u64 sm_reserved[5];
};

struct xfs_ibulk {
	struct xfs_mount *mp;
	struct mnt_idmap *idmap;
	void *ubuffer;
	xfs_ino_t startino;
	unsigned int icount;
	unsigned int ocount;
	unsigned int flags;
};

typedef int (*bulkstat_one_fmt_pf)(struct xfs_ibulk *, const struct xfs_bulkstat *);

typedef int (*inumbers_fmt_pf)(struct xfs_ibulk *, const struct xfs_inumbers *);

struct kgetbmap {
	__s64 bmv_offset;
	__s64 bmv_block;
	__s64 bmv_length;
	__s32 bmv_oflags;
};

struct xfs_fid64 {
	u64 ino;
	u32 gen;
	u64 parent_ino;
	u32 parent_gen;
} __attribute__((packed));

struct xfs_icwalk {
	__u32 icw_flags;
	kuid_t icw_uid;
	kgid_t icw_gid;
	prid_t icw_prid;
	__u64 icw_min_file_size;
	long int icw_scan_limit;
};

struct fsmap {
	__u32 fmr_device;
	__u32 fmr_flags;
	__u64 fmr_physical;
	__u64 fmr_owner;
	__u64 fmr_offset;
	__u64 fmr_length;
	__u64 fmr_reserved[3];
};

struct fsmap_head {
	__u32 fmh_iflags;
	__u32 fmh_oflags;
	__u32 fmh_count;
	__u32 fmh_entries;
	__u64 fmh_reserved[6];
	struct fsmap fmh_keys[2];
	struct fsmap fmh_recs[0];
};

struct xfs_fsmap {
	dev_t fmr_device;
	uint32_t fmr_flags;
	uint64_t fmr_physical;
	uint64_t fmr_owner;
	xfs_fileoff_t fmr_offset;
	xfs_filblks_t fmr_length;
};

struct xfs_fsmap_head {
	uint32_t fmh_iflags;
	uint32_t fmh_oflags;
	unsigned int fmh_count;
	unsigned int fmh_entries;
	struct xfs_fsmap fmh_keys[2];
};

struct xfs_mru_cache_elem {
	struct list_head list_node;
	long unsigned int key;
};

typedef void (*xfs_mru_cache_free_func_t)(void *, struct xfs_mru_cache_elem *);

struct xfs_mru_cache {
	struct xarray store;
	struct list_head *lists;
	struct list_head reap_list;
	spinlock_t lock;
	unsigned int grp_count;
	unsigned int grp_time;
	unsigned int lru_grp;
	long unsigned int time_zero;
	xfs_mru_cache_free_func_t free_func;
	struct delayed_work work;
	unsigned int queued;
	void *data;
};

typedef uint32_t xfs_dqid_t;

typedef int (*list_cmp_func_t)(void *, const struct list_head *, const struct list_head *);

typedef uint32_t xlog_tid_t;

struct xlog_rec_header {
	__be32 h_magicno;
	__be32 h_cycle;
	__be32 h_version;
	__be32 h_len;
	__be64 h_lsn;
	__be64 h_tail_lsn;
	__le32 h_crc;
	__be32 h_prev_block;
	__be32 h_num_logops;
	__be32 h_cycle_data[64];
	__be32 h_fmt;
	uuid_t h_fs_uuid;
	__be32 h_size;
};

typedef struct xlog_rec_header xlog_rec_header_t;

struct xlog_rec_ext_header {
	__be32 xh_cycle;
	__be32 xh_cycle_data[64];
};

typedef struct xlog_rec_ext_header xlog_rec_ext_header_t;

union xlog_in_core2 {
	xlog_rec_header_t hic_header;
	xlog_rec_ext_header_t hic_xheader;
	char hic_sector[512];
};

typedef union xlog_in_core2 xlog_in_core_2_t;

struct xfs_ail {
	struct xlog *ail_log;
	struct task_struct *ail_task;
	struct list_head ail_head;
	xfs_lsn_t ail_target;
	xfs_lsn_t ail_target_prev;
	struct list_head ail_cursors;
	spinlock_t ail_lock;
	xfs_lsn_t ail_last_pushed_lsn;
	int ail_log_flush;
	struct list_head ail_buf_list;
	wait_queue_head_t ail_empty;
};

struct xlog_grant_head {
	spinlock_t lock;
	struct list_head waiters;
	atomic64_t grant;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct xfs_cil;

struct xlog_in_core;

typedef struct xlog_in_core xlog_in_core_t;

struct xlog {
	struct xfs_mount *l_mp;
	struct xfs_ail *l_ailp;
	struct xfs_cil *l_cilp;
	struct xfs_buftarg *l_targ;
	struct workqueue_struct *l_ioend_workqueue;
	struct delayed_work l_work;
	long int l_opstate;
	uint l_quotaoffs_flag;
	struct list_head *l_buf_cancel_table;
	int l_iclog_hsize;
	int l_iclog_heads;
	uint l_sectBBsize;
	int l_iclog_size;
	int l_iclog_bufs;
	xfs_daddr_t l_logBBstart;
	int l_logsize;
	int l_logBBsize;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	wait_queue_head_t l_flush_wait;
	int l_covered_state;
	xlog_in_core_t *l_iclog;
	spinlock_t l_icloglock;
	int l_curr_cycle;
	int l_prev_cycle;
	int l_curr_block;
	int l_prev_block;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	atomic64_t l_last_sync_lsn;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	atomic64_t l_tail_lsn;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct xlog_grant_head l_reserve_head;
	struct xlog_grant_head l_write_head;
	struct xfs_kobj l_kobj;
	xfs_lsn_t l_recovery_lsn;
	uint32_t l_iclog_roundoff;
	struct rw_semaphore l_incompat_users;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct xfs_busy_extents {
	struct xfs_mount *mount;
	struct list_head extent_list;
	struct work_struct endio_work;
	void *owner;
};

typedef uint64_t xfs_qcnt_t;

typedef uint8_t xfs_dqtype_t;

struct xfs_dquot_res {
	xfs_qcnt_t reserved;
	xfs_qcnt_t count;
	xfs_qcnt_t hardlimit;
	xfs_qcnt_t softlimit;
	time64_t timer;
};

struct xfs_dq_logitem {
	struct xfs_log_item qli_item;
	struct xfs_dquot *qli_dquot;
	xfs_lsn_t qli_flush_lsn;
};

struct xfs_dquot {
	struct list_head q_lru;
	struct xfs_mount *q_mount;
	xfs_dqtype_t q_type;
	uint16_t q_flags;
	xfs_dqid_t q_id;
	uint q_nrefs;
	int q_bufoffset;
	xfs_daddr_t q_blkno;
	xfs_fileoff_t q_fileoffset;
	struct xfs_dquot_res q_blk;
	struct xfs_dquot_res q_ino;
	struct xfs_dquot_res q_rtb;
	struct xfs_dq_logitem q_logitem;
	xfs_qcnt_t q_prealloc_lo_wmark;
	xfs_qcnt_t q_prealloc_hi_wmark;
	int64_t q_low_space[3];
	struct mutex q_qlock;
	struct completion q_flush;
	atomic_t q_pincount;
	struct wait_queue_head q_pinwait;
};

struct xlog_ticket {
	struct list_head t_queue;
	struct task_struct *t_task;
	xlog_tid_t t_tid;
	atomic_t t_ref;
	int t_curr_res;
	int t_unit_res;
	char t_ocnt;
	char t_cnt;
	uint8_t t_flags;
	int t_iclog_hdrs;
};

struct xfs_ail_cursor {
	struct list_head list;
	struct xfs_log_item *item;
};

enum xlog_iclog_state {
	XLOG_STATE_ACTIVE = 0,
	XLOG_STATE_WANT_SYNC = 1,
	XLOG_STATE_SYNCING = 2,
	XLOG_STATE_DONE_SYNC = 3,
	XLOG_STATE_CALLBACK = 4,
	XLOG_STATE_DIRTY = 5,
};

struct xlog_in_core {
	wait_queue_head_t ic_force_wait;
	wait_queue_head_t ic_write_wait;
	struct xlog_in_core *ic_next;
	struct xlog_in_core *ic_prev;
	struct xlog *ic_log;
	u32 ic_size;
	u32 ic_offset;
	enum xlog_iclog_state ic_state;
	unsigned int ic_flags;
	void *ic_datap;
	struct list_head ic_callbacks;
	long: 64;
	long: 64;
	atomic_t ic_refcnt;
	xlog_in_core_2_t *ic_data;
	struct semaphore ic_sema;
	struct work_struct ic_end_io_work;
	struct bio ic_bio;
	struct bio_vec ic_bvec[0];
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct xfs_cil_ctx {
	struct xfs_cil *cil;
	xfs_csn_t sequence;
	xfs_lsn_t start_lsn;
	xfs_lsn_t commit_lsn;
	struct xlog_in_core *commit_iclog;
	struct xlog_ticket *ticket;
	atomic_t space_used;
	struct xfs_busy_extents busy_extents;
	struct list_head log_items;
	struct list_head lv_chain;
	struct list_head iclog_entry;
	struct list_head committing;
	struct work_struct push_work;
	atomic_t order_id;
	struct cpumask cil_pcpmask;
};

struct xfs_cil {
	struct xlog *xc_log;
	long unsigned int xc_flags;
	atomic_t xc_iclog_hdrs;
	struct workqueue_struct *xc_push_wq;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct rw_semaphore xc_ctx_lock;
	struct xfs_cil_ctx *xc_ctx;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	spinlock_t xc_push_lock;
	xfs_csn_t xc_push_seq;
	bool xc_push_commit_stable;
	struct list_head xc_committing;
	wait_queue_head_t xc_commit_wait;
	wait_queue_head_t xc_start_wait;
	xfs_csn_t xc_current_sequence;
	wait_queue_head_t xc_push_wait;
	void *xc_pcp;
};

enum {
	XFS_QLOWSP_1_PCNT = 0,
	XFS_QLOWSP_3_PCNT = 1,
	XFS_QLOWSP_5_PCNT = 2,
	XFS_QLOWSP_MAX = 3,
};

struct xfs_defer_op_type {
	struct xfs_log_item * (*create_intent)(struct xfs_trans *, struct list_head *, unsigned int, bool);
	void (*abort_intent)(struct xfs_log_item *);
	struct xfs_log_item * (*create_done)(struct xfs_trans *, struct xfs_log_item *, unsigned int);
	int (*finish_item)(struct xfs_trans *, struct xfs_log_item *, struct list_head *, struct xfs_btree_cur **);
	void (*finish_cleanup)(struct xfs_trans *, struct xfs_btree_cur *, int);
	void (*cancel_item)(struct list_head *);
	unsigned int max_items;
};

struct xlog_op_header {
	__be32 oh_tid;
	__be32 oh_len;
	__u8 oh_clientid;
	__u8 oh_flags;
	__u16 oh_res2;
};

struct xfs_attri_log_format {
	uint16_t alfi_type;
	uint16_t alfi_size;
	uint32_t __pad;
	uint64_t alfi_id;
	uint64_t alfi_ino;
	uint32_t alfi_op_flags;
	uint32_t alfi_name_len;
	uint32_t alfi_value_len;
	uint32_t alfi_attr_filter;
};

struct xfs_attrd_log_format {
	uint16_t alfd_type;
	uint16_t alfd_size;
	uint32_t __pad;
	uint64_t alfd_alf_id;
};

enum xfs_delattr_state {
	XFS_DAS_UNINIT = 0,
	XFS_DAS_SF_ADD = 1,
	XFS_DAS_SF_REMOVE = 2,
	XFS_DAS_LEAF_ADD = 3,
	XFS_DAS_LEAF_REMOVE = 4,
	XFS_DAS_NODE_ADD = 5,
	XFS_DAS_NODE_REMOVE = 6,
	XFS_DAS_LEAF_SET_RMT = 7,
	XFS_DAS_LEAF_ALLOC_RMT = 8,
	XFS_DAS_LEAF_REPLACE = 9,
	XFS_DAS_LEAF_REMOVE_OLD = 10,
	XFS_DAS_LEAF_REMOVE_RMT = 11,
	XFS_DAS_LEAF_REMOVE_ATTR = 12,
	XFS_DAS_NODE_SET_RMT = 13,
	XFS_DAS_NODE_ALLOC_RMT = 14,
	XFS_DAS_NODE_REPLACE = 15,
	XFS_DAS_NODE_REMOVE_OLD = 16,
	XFS_DAS_NODE_REMOVE_RMT = 17,
	XFS_DAS_NODE_REMOVE_ATTR = 18,
	XFS_DAS_DONE = 19,
};

struct xfs_attri_log_nameval;

struct xfs_attr_intent {
	struct list_head xattri_list;
	struct xfs_da_state *xattri_da_state;
	struct xfs_da_args *xattri_da_args;
	struct xfs_attri_log_nameval *xattri_nameval;
	enum xfs_delattr_state xattri_dela_state;
	unsigned int xattri_op_flags;
	xfs_dablk_t xattri_lblkno;
	int xattri_blkcnt;
	struct xfs_bmbt_irec xattri_map;
};

struct xfs_attri_log_nameval {
	struct xfs_log_iovec name;
	struct xfs_log_iovec value;
	refcount_t refcount;
};

struct xfs_attri_log_item {
	struct xfs_log_item attri_item;
	atomic_t attri_refcount;
	struct xfs_attri_log_nameval *attri_nameval;
	struct xfs_attri_log_format attri_format;
};

struct xfs_attrd_log_item {
	struct xfs_log_item attrd_item;
	struct xfs_attri_log_item *attrd_attrip;
	struct xfs_attrd_log_format attrd_format;
};

enum xlog_recover_reorder {
	XLOG_REORDER_BUFFER_LIST = 0,
	XLOG_REORDER_ITEM_LIST = 1,
	XLOG_REORDER_INODE_BUFFER_LIST = 2,
	XLOG_REORDER_CANCEL_LIST = 3,
};

struct xlog_recover_item;

struct xlog_recover_item_ops {
	uint16_t item_type;
	enum xlog_recover_reorder (*reorder)(struct xlog_recover_item *);
	void (*ra_pass2)(struct xlog *, struct xlog_recover_item *);
	int (*commit_pass1)(struct xlog *, struct xlog_recover_item *);
	int (*commit_pass2)(struct xlog *, struct list_head *, struct xlog_recover_item *, xfs_lsn_t);
};

struct xlog_recover_item {
	struct list_head ri_list;
	int ri_cnt;
	int ri_total;
	struct xfs_log_iovec *ri_buf;
	const struct xlog_recover_item_ops *ri_ops;
};

enum {
	TRACEFS_EVENT_INODE = 2,
	TRACEFS_EVENT_TOP_INODE = 4,
};

struct tracefs_inode {
	long unsigned int flags;
	void *private;
	struct inode vfs_inode;
};

struct eventfs_inode {
	struct list_head e_top_files;
};

struct eventfs_file {
	const char *name;
	struct dentry *d_parent;
	struct dentry *dentry;
	struct list_head list;
	struct eventfs_inode *ei;
	const struct file_operations *fop;
	const struct inode_operations *iop;
	union {
		struct list_head del_list;
		struct callback_head rcu;
		long unsigned int is_freed;
	};
	void *data;
	umode_t mode;
};

struct dentry_list {
	void *cursor;
	struct dentry **dentries;
};

typedef int __kernel_key_t;

typedef int __kernel_ipc_pid_t;

typedef unsigned int __kernel_uid_t;

typedef unsigned int __kernel_gid_t;

typedef __kernel_long_t __kernel_old_time_t;

typedef __kernel_key_t key_t;

struct ipc_perm {
	__kernel_key_t key;
	__kernel_uid_t uid;
	__kernel_gid_t gid;
	__kernel_uid_t cuid;
	__kernel_gid_t cgid;
	__kernel_mode_t mode;
	short unsigned int seq;
};

struct msgbuf;

struct ipc_kludge {
	struct msgbuf *msgp;
	long int msgtyp;
};

struct sembuf {
	short unsigned int sem_num;
	short int sem_op;
	short int sem_flg;
};

struct shmid_ds {
	struct ipc_perm shm_perm;
	int shm_segsz;
	__kernel_old_time_t shm_atime;
	__kernel_old_time_t shm_dtime;
	__kernel_old_time_t shm_ctime;
	__kernel_ipc_pid_t shm_cpid;
	__kernel_ipc_pid_t shm_lpid;
	short unsigned int shm_nattch;
	short unsigned int shm_unused;
	void *shm_unused2;
	void *shm_unused3;
};

struct msqid_ds;

enum key_need_perm {
	KEY_NEED_UNSPECIFIED = 0,
	KEY_NEED_VIEW = 1,
	KEY_NEED_READ = 2,
	KEY_NEED_WRITE = 3,
	KEY_NEED_SEARCH = 4,
	KEY_NEED_LINK = 5,
	KEY_NEED_SETATTR = 6,
	KEY_NEED_UNLINK = 7,
	KEY_SYSADMIN_OVERRIDE = 8,
	KEY_AUTHTOKEN_OVERRIDE = 9,
	KEY_DEFER_PERM_CHECK = 10,
};

struct __key_reference_with_attributes;

typedef struct __key_reference_with_attributes *key_ref_t;

struct key_user {
	struct rb_node node;
	struct mutex cons_lock;
	spinlock_t lock;
	refcount_t usage;
	atomic_t nkeys;
	atomic_t nikeys;
	kuid_t uid;
	int qnkeys;
	int qnbytes;
};

struct key_preparsed_payload {
	const char *orig_description;
	char *description;
	union key_payload payload;
	const void *data;
	size_t datalen;
	size_t quotalen;
	time64_t expiry;
};

struct key_match_data {
	bool (*cmp)(const struct key *, const struct key_match_data *);
	const void *raw_data;
	void *preparsed;
	unsigned int lookup_type;
};

enum kernel_pkey_operation {
	kernel_pkey_encrypt = 0,
	kernel_pkey_decrypt = 1,
	kernel_pkey_sign = 2,
	kernel_pkey_verify = 3,
};

struct kernel_pkey_params {
	struct key *key;
	const char *encoding;
	const char *hash_algo;
	char *info;
	__u32 in_len;
	union {
		__u32 out_len;
		__u32 in2_len;
	};
	enum kernel_pkey_operation op: 8;
};

struct kernel_pkey_query {
	__u32 supported_ops;
	__u32 key_size;
	__u16 max_data_size;
	__u16 max_sig_size;
	__u16 max_enc_size;
	__u16 max_dec_size;
};

enum key_state {
	KEY_IS_UNINSTANTIATED = 0,
	KEY_IS_POSITIVE = 1,
};

struct user_key_payload {
	struct callback_head rcu;
	short unsigned int datalen;
	long: 0;
	char data[0];
};

struct vfs_cap_data {
	__le32 magic_etc;
	struct {
		__le32 permitted;
		__le32 inheritable;
	} data[2];
};

struct vfs_ns_cap_data {
	__le32 magic_etc;
	struct {
		__le32 permitted;
		__le32 inheritable;
	} data[2];
	__le32 rootid;
};

struct cpu_vfs_cap_data {
	__u32 magic_etc;
	kuid_t rootid;
	kernel_cap_t permitted;
	kernel_cap_t inheritable;
};

struct kern_ipc_perm {
	spinlock_t lock;
	bool deleted;
	int id;
	key_t key;
	kuid_t uid;
	kgid_t gid;
	kuid_t cuid;
	kgid_t cgid;
	umode_t mode;
	long unsigned int seq;
	void *security;
	struct rhash_head khtnode;
	struct callback_head rcu;
	refcount_t refcount;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

enum kernel_read_file_id {
	READING_UNKNOWN = 0,
	READING_FIRMWARE = 1,
	READING_MODULE = 2,
	READING_KEXEC_IMAGE = 3,
	READING_KEXEC_INITRAMFS = 4,
	READING_POLICY = 5,
	READING_X509_CERTIFICATE = 6,
	READING_MAX_ID = 7,
};

enum kernel_load_data_id {
	LOADING_UNKNOWN = 0,
	LOADING_FIRMWARE = 1,
	LOADING_MODULE = 2,
	LOADING_KEXEC_IMAGE = 3,
	LOADING_KEXEC_INITRAMFS = 4,
	LOADING_POLICY = 5,
	LOADING_X509_CERTIFICATE = 6,
	LOADING_MAX_ID = 7,
};

struct msg_msg;

struct flowi_common;

struct sctp_association;

union security_list_options {
	int (*binder_set_context_mgr)(const struct cred *);
	int (*binder_transaction)(const struct cred *, const struct cred *);
	int (*binder_transfer_binder)(const struct cred *, const struct cred *);
	int (*binder_transfer_file)(const struct cred *, const struct cred *, const struct file *);
	int (*ptrace_access_check)(struct task_struct *, unsigned int);
	int (*ptrace_traceme)(struct task_struct *);
	int (*capget)(const struct task_struct *, kernel_cap_t *, kernel_cap_t *, kernel_cap_t *);
	int (*capset)(struct cred *, const struct cred *, const kernel_cap_t *, const kernel_cap_t *, const kernel_cap_t *);
	int (*capable)(const struct cred *, struct user_namespace *, int, unsigned int);
	int (*quotactl)(int, int, int, struct super_block *);
	int (*quota_on)(struct dentry *);
	int (*syslog)(int);
	int (*settime)(const struct timespec64 *, const struct timezone *);
	int (*vm_enough_memory)(struct mm_struct *, long int);
	int (*bprm_creds_for_exec)(struct linux_binprm *);
	int (*bprm_creds_from_file)(struct linux_binprm *, struct file *);
	int (*bprm_check_security)(struct linux_binprm *);
	void (*bprm_committing_creds)(struct linux_binprm *);
	void (*bprm_committed_creds)(struct linux_binprm *);
	int (*fs_context_submount)(struct fs_context *, struct super_block *);
	int (*fs_context_dup)(struct fs_context *, struct fs_context *);
	int (*fs_context_parse_param)(struct fs_context *, struct fs_parameter *);
	int (*sb_alloc_security)(struct super_block *);
	void (*sb_delete)(struct super_block *);
	void (*sb_free_security)(struct super_block *);
	void (*sb_free_mnt_opts)(void *);
	int (*sb_eat_lsm_opts)(char *, void **);
	int (*sb_mnt_opts_compat)(struct super_block *, void *);
	int (*sb_remount)(struct super_block *, void *);
	int (*sb_kern_mount)(struct super_block *);
	int (*sb_show_options)(struct seq_file *, struct super_block *);
	int (*sb_statfs)(struct dentry *);
	int (*sb_mount)(const char *, const struct path *, const char *, long unsigned int, void *);
	int (*sb_umount)(struct vfsmount *, int);
	int (*sb_pivotroot)(const struct path *, const struct path *);
	int (*sb_set_mnt_opts)(struct super_block *, void *, long unsigned int, long unsigned int *);
	int (*sb_clone_mnt_opts)(const struct super_block *, struct super_block *, long unsigned int, long unsigned int *);
	int (*move_mount)(const struct path *, const struct path *);
	int (*dentry_init_security)(struct dentry *, int, const struct qstr *, const char **, void **, u32 *);
	int (*dentry_create_files_as)(struct dentry *, int, struct qstr *, const struct cred *, struct cred *);
	int (*path_unlink)(const struct path *, struct dentry *);
	int (*path_mkdir)(const struct path *, struct dentry *, umode_t);
	int (*path_rmdir)(const struct path *, struct dentry *);
	int (*path_mknod)(const struct path *, struct dentry *, umode_t, unsigned int);
	int (*path_truncate)(const struct path *);
	int (*path_symlink)(const struct path *, struct dentry *, const char *);
	int (*path_link)(struct dentry *, const struct path *, struct dentry *);
	int (*path_rename)(const struct path *, struct dentry *, const struct path *, struct dentry *, unsigned int);
	int (*path_chmod)(const struct path *, umode_t);
	int (*path_chown)(const struct path *, kuid_t, kgid_t);
	int (*path_chroot)(const struct path *);
	int (*path_notify)(const struct path *, u64, unsigned int);
	int (*inode_alloc_security)(struct inode *);
	void (*inode_free_security)(struct inode *);
	int (*inode_init_security)(struct inode *, struct inode *, const struct qstr *, struct xattr *, int *);
	int (*inode_init_security_anon)(struct inode *, const struct qstr *, const struct inode *);
	int (*inode_create)(struct inode *, struct dentry *, umode_t);
	int (*inode_link)(struct dentry *, struct inode *, struct dentry *);
	int (*inode_unlink)(struct inode *, struct dentry *);
	int (*inode_symlink)(struct inode *, struct dentry *, const char *);
	int (*inode_mkdir)(struct inode *, struct dentry *, umode_t);
	int (*inode_rmdir)(struct inode *, struct dentry *);
	int (*inode_mknod)(struct inode *, struct dentry *, umode_t, dev_t);
	int (*inode_rename)(struct inode *, struct dentry *, struct inode *, struct dentry *);
	int (*inode_readlink)(struct dentry *);
	int (*inode_follow_link)(struct dentry *, struct inode *, bool);
	int (*inode_permission)(struct inode *, int);
	int (*inode_setattr)(struct dentry *, struct iattr *);
	int (*inode_getattr)(const struct path *);
	int (*inode_setxattr)(struct mnt_idmap *, struct dentry *, const char *, const void *, size_t, int);
	void (*inode_post_setxattr)(struct dentry *, const char *, const void *, size_t, int);
	int (*inode_getxattr)(struct dentry *, const char *);
	int (*inode_listxattr)(struct dentry *);
	int (*inode_removexattr)(struct mnt_idmap *, struct dentry *, const char *);
	int (*inode_set_acl)(struct mnt_idmap *, struct dentry *, const char *, struct posix_acl *);
	int (*inode_get_acl)(struct mnt_idmap *, struct dentry *, const char *);
	int (*inode_remove_acl)(struct mnt_idmap *, struct dentry *, const char *);
	int (*inode_need_killpriv)(struct dentry *);
	int (*inode_killpriv)(struct mnt_idmap *, struct dentry *);
	int (*inode_getsecurity)(struct mnt_idmap *, struct inode *, const char *, void **, bool);
	int (*inode_setsecurity)(struct inode *, const char *, const void *, size_t, int);
	int (*inode_listsecurity)(struct inode *, char *, size_t);
	void (*inode_getsecid)(struct inode *, u32 *);
	int (*inode_copy_up)(struct dentry *, struct cred **);
	int (*inode_copy_up_xattr)(const char *);
	int (*kernfs_init_security)(struct kernfs_node *, struct kernfs_node *);
	int (*file_permission)(struct file *, int);
	int (*file_alloc_security)(struct file *);
	void (*file_free_security)(struct file *);
	int (*file_ioctl)(struct file *, unsigned int, long unsigned int);
	int (*mmap_addr)(long unsigned int);
	int (*mmap_file)(struct file *, long unsigned int, long unsigned int, long unsigned int);
	int (*file_mprotect)(struct vm_area_struct *, long unsigned int, long unsigned int);
	int (*file_lock)(struct file *, unsigned int);
	int (*file_fcntl)(struct file *, unsigned int, long unsigned int);
	void (*file_set_fowner)(struct file *);
	int (*file_send_sigiotask)(struct task_struct *, struct fown_struct *, int);
	int (*file_receive)(struct file *);
	int (*file_open)(struct file *);
	int (*file_truncate)(struct file *);
	int (*task_alloc)(struct task_struct *, long unsigned int);
	void (*task_free)(struct task_struct *);
	int (*cred_alloc_blank)(struct cred *, gfp_t);
	void (*cred_free)(struct cred *);
	int (*cred_prepare)(struct cred *, const struct cred *, gfp_t);
	void (*cred_transfer)(struct cred *, const struct cred *);
	void (*cred_getsecid)(const struct cred *, u32 *);
	int (*kernel_act_as)(struct cred *, u32);
	int (*kernel_create_files_as)(struct cred *, struct inode *);
	int (*kernel_module_request)(char *);
	int (*kernel_load_data)(enum kernel_load_data_id, bool);
	int (*kernel_post_load_data)(char *, loff_t, enum kernel_load_data_id, char *);
	int (*kernel_read_file)(struct file *, enum kernel_read_file_id, bool);
	int (*kernel_post_read_file)(struct file *, char *, loff_t, enum kernel_read_file_id);
	int (*task_fix_setuid)(struct cred *, const struct cred *, int);
	int (*task_fix_setgid)(struct cred *, const struct cred *, int);
	int (*task_fix_setgroups)(struct cred *, const struct cred *);
	int (*task_setpgid)(struct task_struct *, pid_t);
	int (*task_getpgid)(struct task_struct *);
	int (*task_getsid)(struct task_struct *);
	void (*current_getsecid_subj)(u32 *);
	void (*task_getsecid_obj)(struct task_struct *, u32 *);
	int (*task_setnice)(struct task_struct *, int);
	int (*task_setioprio)(struct task_struct *, int);
	int (*task_getioprio)(struct task_struct *);
	int (*task_prlimit)(const struct cred *, const struct cred *, unsigned int);
	int (*task_setrlimit)(struct task_struct *, unsigned int, struct rlimit *);
	int (*task_setscheduler)(struct task_struct *);
	int (*task_getscheduler)(struct task_struct *);
	int (*task_movememory)(struct task_struct *);
	int (*task_kill)(struct task_struct *, struct kernel_siginfo *, int, const struct cred *);
	int (*task_prctl)(int, long unsigned int, long unsigned int, long unsigned int, long unsigned int);
	void (*task_to_inode)(struct task_struct *, struct inode *);
	int (*userns_create)(const struct cred *);
	int (*ipc_permission)(struct kern_ipc_perm *, short int);
	void (*ipc_getsecid)(struct kern_ipc_perm *, u32 *);
	int (*msg_msg_alloc_security)(struct msg_msg *);
	void (*msg_msg_free_security)(struct msg_msg *);
	int (*msg_queue_alloc_security)(struct kern_ipc_perm *);
	void (*msg_queue_free_security)(struct kern_ipc_perm *);
	int (*msg_queue_associate)(struct kern_ipc_perm *, int);
	int (*msg_queue_msgctl)(struct kern_ipc_perm *, int);
	int (*msg_queue_msgsnd)(struct kern_ipc_perm *, struct msg_msg *, int);
	int (*msg_queue_msgrcv)(struct kern_ipc_perm *, struct msg_msg *, struct task_struct *, long int, int);
	int (*shm_alloc_security)(struct kern_ipc_perm *);
	void (*shm_free_security)(struct kern_ipc_perm *);
	int (*shm_associate)(struct kern_ipc_perm *, int);
	int (*shm_shmctl)(struct kern_ipc_perm *, int);
	int (*shm_shmat)(struct kern_ipc_perm *, char *, int);
	int (*sem_alloc_security)(struct kern_ipc_perm *);
	void (*sem_free_security)(struct kern_ipc_perm *);
	int (*sem_associate)(struct kern_ipc_perm *, int);
	int (*sem_semctl)(struct kern_ipc_perm *, int);
	int (*sem_semop)(struct kern_ipc_perm *, struct sembuf *, unsigned int, int);
	int (*netlink_send)(struct sock *, struct sk_buff *);
	void (*d_instantiate)(struct dentry *, struct inode *);
	int (*getprocattr)(struct task_struct *, const char *, char **);
	int (*setprocattr)(const char *, void *, size_t);
	int (*ismaclabel)(const char *);
	int (*secid_to_secctx)(u32, char **, u32 *);
	int (*secctx_to_secid)(const char *, u32, u32 *);
	void (*release_secctx)(char *, u32);
	void (*inode_invalidate_secctx)(struct inode *);
	int (*inode_notifysecctx)(struct inode *, void *, u32);
	int (*inode_setsecctx)(struct dentry *, void *, u32);
	int (*inode_getsecctx)(struct inode *, void **, u32 *);
	int (*unix_stream_connect)(struct sock *, struct sock *, struct sock *);
	int (*unix_may_send)(struct socket *, struct socket *);
	int (*socket_create)(int, int, int, int);
	int (*socket_post_create)(struct socket *, int, int, int, int);
	int (*socket_socketpair)(struct socket *, struct socket *);
	int (*socket_bind)(struct socket *, struct sockaddr *, int);
	int (*socket_connect)(struct socket *, struct sockaddr *, int);
	int (*socket_listen)(struct socket *, int);
	int (*socket_accept)(struct socket *, struct socket *);
	int (*socket_sendmsg)(struct socket *, struct msghdr *, int);
	int (*socket_recvmsg)(struct socket *, struct msghdr *, int, int);
	int (*socket_getsockname)(struct socket *);
	int (*socket_getpeername)(struct socket *);
	int (*socket_getsockopt)(struct socket *, int, int);
	int (*socket_setsockopt)(struct socket *, int, int);
	int (*socket_shutdown)(struct socket *, int);
	int (*socket_sock_rcv_skb)(struct sock *, struct sk_buff *);
	int (*socket_getpeersec_stream)(struct socket *, sockptr_t, sockptr_t, unsigned int);
	int (*socket_getpeersec_dgram)(struct socket *, struct sk_buff *, u32 *);
	int (*sk_alloc_security)(struct sock *, int, gfp_t);
	void (*sk_free_security)(struct sock *);
	void (*sk_clone_security)(const struct sock *, struct sock *);
	void (*sk_getsecid)(const struct sock *, u32 *);
	void (*sock_graft)(struct sock *, struct socket *);
	int (*inet_conn_request)(const struct sock *, struct sk_buff *, struct request_sock *);
	void (*inet_csk_clone)(struct sock *, const struct request_sock *);
	void (*inet_conn_established)(struct sock *, struct sk_buff *);
	int (*secmark_relabel_packet)(u32);
	void (*secmark_refcount_inc)();
	void (*secmark_refcount_dec)();
	void (*req_classify_flow)(const struct request_sock *, struct flowi_common *);
	int (*tun_dev_alloc_security)(void **);
	void (*tun_dev_free_security)(void *);
	int (*tun_dev_create)();
	int (*tun_dev_attach_queue)(void *);
	int (*tun_dev_attach)(struct sock *, void *);
	int (*tun_dev_open)(void *);
	int (*sctp_assoc_request)(struct sctp_association *, struct sk_buff *);
	int (*sctp_bind_connect)(struct sock *, int, struct sockaddr *, int);
	void (*sctp_sk_clone)(struct sctp_association *, struct sock *, struct sock *);
	int (*sctp_assoc_established)(struct sctp_association *, struct sk_buff *);
	int (*mptcp_add_subflow)(struct sock *, struct sock *);
	int (*key_alloc)(struct key *, const struct cred *, long unsigned int);
	void (*key_free)(struct key *);
	int (*key_permission)(key_ref_t, const struct cred *, enum key_need_perm);
	int (*key_getsecurity)(struct key *, char **);
	int (*audit_rule_init)(u32, u32, char *, void **);
	int (*audit_rule_known)(struct audit_krule *);
	int (*audit_rule_match)(u32, u32, u32, void *);
	void (*audit_rule_free)(void *);
	int (*bpf)(int, union bpf_attr *, unsigned int);
	int (*bpf_map)(struct bpf_map *, fmode_t);
	int (*bpf_prog)(struct bpf_prog *);
	int (*bpf_map_alloc_security)(struct bpf_map *);
	void (*bpf_map_free_security)(struct bpf_map *);
	int (*bpf_prog_alloc_security)(struct bpf_prog_aux *);
	void (*bpf_prog_free_security)(struct bpf_prog_aux *);
	int (*locked_down)(enum lockdown_reason);
	int (*perf_event_open)(struct perf_event_attr *, int);
	int (*perf_event_alloc)(struct perf_event *);
	void (*perf_event_free)(struct perf_event *);
	int (*perf_event_read)(struct perf_event *);
	int (*perf_event_write)(struct perf_event *);
	int (*uring_override_creds)(const struct cred *);
	int (*uring_sqpoll)();
	int (*uring_cmd)(struct io_uring_cmd *);
};

struct flowi_tunnel {
	__be64 tun_id;
};

struct flowi_common {
	int flowic_oif;
	int flowic_iif;
	int flowic_l3mdev;
	__u32 flowic_mark;
	__u8 flowic_tos;
	__u8 flowic_scope;
	__u8 flowic_proto;
	__u8 flowic_flags;
	__u32 flowic_secid;
	kuid_t flowic_uid;
	struct flowi_tunnel flowic_tun_key;
	__u32 flowic_multipath_hash;
};

struct security_hook_heads {
	struct hlist_head binder_set_context_mgr;
	struct hlist_head binder_transaction;
	struct hlist_head binder_transfer_binder;
	struct hlist_head binder_transfer_file;
	struct hlist_head ptrace_access_check;
	struct hlist_head ptrace_traceme;
	struct hlist_head capget;
	struct hlist_head capset;
	struct hlist_head capable;
	struct hlist_head quotactl;
	struct hlist_head quota_on;
	struct hlist_head syslog;
	struct hlist_head settime;
	struct hlist_head vm_enough_memory;
	struct hlist_head bprm_creds_for_exec;
	struct hlist_head bprm_creds_from_file;
	struct hlist_head bprm_check_security;
	struct hlist_head bprm_committing_creds;
	struct hlist_head bprm_committed_creds;
	struct hlist_head fs_context_submount;
	struct hlist_head fs_context_dup;
	struct hlist_head fs_context_parse_param;
	struct hlist_head sb_alloc_security;
	struct hlist_head sb_delete;
	struct hlist_head sb_free_security;
	struct hlist_head sb_free_mnt_opts;
	struct hlist_head sb_eat_lsm_opts;
	struct hlist_head sb_mnt_opts_compat;
	struct hlist_head sb_remount;
	struct hlist_head sb_kern_mount;
	struct hlist_head sb_show_options;
	struct hlist_head sb_statfs;
	struct hlist_head sb_mount;
	struct hlist_head sb_umount;
	struct hlist_head sb_pivotroot;
	struct hlist_head sb_set_mnt_opts;
	struct hlist_head sb_clone_mnt_opts;
	struct hlist_head move_mount;
	struct hlist_head dentry_init_security;
	struct hlist_head dentry_create_files_as;
	struct hlist_head path_unlink;
	struct hlist_head path_mkdir;
	struct hlist_head path_rmdir;
	struct hlist_head path_mknod;
	struct hlist_head path_truncate;
	struct hlist_head path_symlink;
	struct hlist_head path_link;
	struct hlist_head path_rename;
	struct hlist_head path_chmod;
	struct hlist_head path_chown;
	struct hlist_head path_chroot;
	struct hlist_head path_notify;
	struct hlist_head inode_alloc_security;
	struct hlist_head inode_free_security;
	struct hlist_head inode_init_security;
	struct hlist_head inode_init_security_anon;
	struct hlist_head inode_create;
	struct hlist_head inode_link;
	struct hlist_head inode_unlink;
	struct hlist_head inode_symlink;
	struct hlist_head inode_mkdir;
	struct hlist_head inode_rmdir;
	struct hlist_head inode_mknod;
	struct hlist_head inode_rename;
	struct hlist_head inode_readlink;
	struct hlist_head inode_follow_link;
	struct hlist_head inode_permission;
	struct hlist_head inode_setattr;
	struct hlist_head inode_getattr;
	struct hlist_head inode_setxattr;
	struct hlist_head inode_post_setxattr;
	struct hlist_head inode_getxattr;
	struct hlist_head inode_listxattr;
	struct hlist_head inode_removexattr;
	struct hlist_head inode_set_acl;
	struct hlist_head inode_get_acl;
	struct hlist_head inode_remove_acl;
	struct hlist_head inode_need_killpriv;
	struct hlist_head inode_killpriv;
	struct hlist_head inode_getsecurity;
	struct hlist_head inode_setsecurity;
	struct hlist_head inode_listsecurity;
	struct hlist_head inode_getsecid;
	struct hlist_head inode_copy_up;
	struct hlist_head inode_copy_up_xattr;
	struct hlist_head kernfs_init_security;
	struct hlist_head file_permission;
	struct hlist_head file_alloc_security;
	struct hlist_head file_free_security;
	struct hlist_head file_ioctl;
	struct hlist_head mmap_addr;
	struct hlist_head mmap_file;
	struct hlist_head file_mprotect;
	struct hlist_head file_lock;
	struct hlist_head file_fcntl;
	struct hlist_head file_set_fowner;
	struct hlist_head file_send_sigiotask;
	struct hlist_head file_receive;
	struct hlist_head file_open;
	struct hlist_head file_truncate;
	struct hlist_head task_alloc;
	struct hlist_head task_free;
	struct hlist_head cred_alloc_blank;
	struct hlist_head cred_free;
	struct hlist_head cred_prepare;
	struct hlist_head cred_transfer;
	struct hlist_head cred_getsecid;
	struct hlist_head kernel_act_as;
	struct hlist_head kernel_create_files_as;
	struct hlist_head kernel_module_request;
	struct hlist_head kernel_load_data;
	struct hlist_head kernel_post_load_data;
	struct hlist_head kernel_read_file;
	struct hlist_head kernel_post_read_file;
	struct hlist_head task_fix_setuid;
	struct hlist_head task_fix_setgid;
	struct hlist_head task_fix_setgroups;
	struct hlist_head task_setpgid;
	struct hlist_head task_getpgid;
	struct hlist_head task_getsid;
	struct hlist_head current_getsecid_subj;
	struct hlist_head task_getsecid_obj;
	struct hlist_head task_setnice;
	struct hlist_head task_setioprio;
	struct hlist_head task_getioprio;
	struct hlist_head task_prlimit;
	struct hlist_head task_setrlimit;
	struct hlist_head task_setscheduler;
	struct hlist_head task_getscheduler;
	struct hlist_head task_movememory;
	struct hlist_head task_kill;
	struct hlist_head task_prctl;
	struct hlist_head task_to_inode;
	struct hlist_head userns_create;
	struct hlist_head ipc_permission;
	struct hlist_head ipc_getsecid;
	struct hlist_head msg_msg_alloc_security;
	struct hlist_head msg_msg_free_security;
	struct hlist_head msg_queue_alloc_security;
	struct hlist_head msg_queue_free_security;
	struct hlist_head msg_queue_associate;
	struct hlist_head msg_queue_msgctl;
	struct hlist_head msg_queue_msgsnd;
	struct hlist_head msg_queue_msgrcv;
	struct hlist_head shm_alloc_security;
	struct hlist_head shm_free_security;
	struct hlist_head shm_associate;
	struct hlist_head shm_shmctl;
	struct hlist_head shm_shmat;
	struct hlist_head sem_alloc_security;
	struct hlist_head sem_free_security;
	struct hlist_head sem_associate;
	struct hlist_head sem_semctl;
	struct hlist_head sem_semop;
	struct hlist_head netlink_send;
	struct hlist_head d_instantiate;
	struct hlist_head getprocattr;
	struct hlist_head setprocattr;
	struct hlist_head ismaclabel;
	struct hlist_head secid_to_secctx;
	struct hlist_head secctx_to_secid;
	struct hlist_head release_secctx;
	struct hlist_head inode_invalidate_secctx;
	struct hlist_head inode_notifysecctx;
	struct hlist_head inode_setsecctx;
	struct hlist_head inode_getsecctx;
	struct hlist_head unix_stream_connect;
	struct hlist_head unix_may_send;
	struct hlist_head socket_create;
	struct hlist_head socket_post_create;
	struct hlist_head socket_socketpair;
	struct hlist_head socket_bind;
	struct hlist_head socket_connect;
	struct hlist_head socket_listen;
	struct hlist_head socket_accept;
	struct hlist_head socket_sendmsg;
	struct hlist_head socket_recvmsg;
	struct hlist_head socket_getsockname;
	struct hlist_head socket_getpeername;
	struct hlist_head socket_getsockopt;
	struct hlist_head socket_setsockopt;
	struct hlist_head socket_shutdown;
	struct hlist_head socket_sock_rcv_skb;
	struct hlist_head socket_getpeersec_stream;
	struct hlist_head socket_getpeersec_dgram;
	struct hlist_head sk_alloc_security;
	struct hlist_head sk_free_security;
	struct hlist_head sk_clone_security;
	struct hlist_head sk_getsecid;
	struct hlist_head sock_graft;
	struct hlist_head inet_conn_request;
	struct hlist_head inet_csk_clone;
	struct hlist_head inet_conn_established;
	struct hlist_head secmark_relabel_packet;
	struct hlist_head secmark_refcount_inc;
	struct hlist_head secmark_refcount_dec;
	struct hlist_head req_classify_flow;
	struct hlist_head tun_dev_alloc_security;
	struct hlist_head tun_dev_free_security;
	struct hlist_head tun_dev_create;
	struct hlist_head tun_dev_attach_queue;
	struct hlist_head tun_dev_attach;
	struct hlist_head tun_dev_open;
	struct hlist_head sctp_assoc_request;
	struct hlist_head sctp_bind_connect;
	struct hlist_head sctp_sk_clone;
	struct hlist_head sctp_assoc_established;
	struct hlist_head mptcp_add_subflow;
	struct hlist_head key_alloc;
	struct hlist_head key_free;
	struct hlist_head key_permission;
	struct hlist_head key_getsecurity;
	struct hlist_head audit_rule_init;
	struct hlist_head audit_rule_known;
	struct hlist_head audit_rule_match;
	struct hlist_head audit_rule_free;
	struct hlist_head bpf;
	struct hlist_head bpf_map;
	struct hlist_head bpf_prog;
	struct hlist_head bpf_map_alloc_security;
	struct hlist_head bpf_map_free_security;
	struct hlist_head bpf_prog_alloc_security;
	struct hlist_head bpf_prog_free_security;
	struct hlist_head locked_down;
	struct hlist_head perf_event_open;
	struct hlist_head perf_event_alloc;
	struct hlist_head perf_event_free;
	struct hlist_head perf_event_read;
	struct hlist_head perf_event_write;
	struct hlist_head uring_override_creds;
	struct hlist_head uring_sqpoll;
	struct hlist_head uring_cmd;
};

struct security_hook_list {
	struct hlist_node list;
	struct hlist_head *head;
	union security_list_options hook;
	const char *lsm;
};

struct lsm_blob_sizes {
	int lbs_cred;
	int lbs_file;
	int lbs_inode;
	int lbs_superblock;
	int lbs_ipc;
	int lbs_msg_msg;
	int lbs_task;
	int lbs_xattr_count;
};

enum lsm_order {
	LSM_ORDER_FIRST = -1,
	LSM_ORDER_MUTABLE = 0,
	LSM_ORDER_LAST = 1,
};

struct lsm_info {
	const char *name;
	enum lsm_order order;
	long unsigned int flags;
	int *enabled;
	int (*init)();
	struct lsm_blob_sizes *blobs;
};

struct ethhdr {
	unsigned char h_dest[6];
	unsigned char h_source[6];
	__be16 h_proto;
};

struct ethtool_drvinfo {
	__u32 cmd;
	char driver[32];
	char version[32];
	char fw_version[32];
	char bus_info[32];
	char erom_version[32];
	char reserved2[12];
	__u32 n_priv_flags;
	__u32 n_stats;
	__u32 testinfo_len;
	__u32 eedump_len;
	__u32 regdump_len;
};

struct ethtool_wolinfo {
	__u32 cmd;
	__u32 supported;
	__u32 wolopts;
	__u8 sopass[6];
};

struct ethtool_tunable {
	__u32 cmd;
	__u32 id;
	__u32 type_id;
	__u32 len;
	void *data[0];
};

struct ethtool_regs {
	__u32 cmd;
	__u32 version;
	__u32 len;
	__u8 data[0];
};

struct ethtool_eeprom {
	__u32 cmd;
	__u32 magic;
	__u32 offset;
	__u32 len;
	__u8 data[0];
};

struct ethtool_eee {
	__u32 cmd;
	__u32 supported;
	__u32 advertised;
	__u32 lp_advertised;
	__u32 eee_active;
	__u32 eee_enabled;
	__u32 tx_lpi_enabled;
	__u32 tx_lpi_timer;
	__u32 reserved[2];
};

struct ethtool_modinfo {
	__u32 cmd;
	__u32 type;
	__u32 eeprom_len;
	__u32 reserved[8];
};

struct ethtool_coalesce {
	__u32 cmd;
	__u32 rx_coalesce_usecs;
	__u32 rx_max_coalesced_frames;
	__u32 rx_coalesce_usecs_irq;
	__u32 rx_max_coalesced_frames_irq;
	__u32 tx_coalesce_usecs;
	__u32 tx_max_coalesced_frames;
	__u32 tx_coalesce_usecs_irq;
	__u32 tx_max_coalesced_frames_irq;
	__u32 stats_block_coalesce_usecs;
	__u32 use_adaptive_rx_coalesce;
	__u32 use_adaptive_tx_coalesce;
	__u32 pkt_rate_low;
	__u32 rx_coalesce_usecs_low;
	__u32 rx_max_coalesced_frames_low;
	__u32 tx_coalesce_usecs_low;
	__u32 tx_max_coalesced_frames_low;
	__u32 pkt_rate_high;
	__u32 rx_coalesce_usecs_high;
	__u32 rx_max_coalesced_frames_high;
	__u32 tx_coalesce_usecs_high;
	__u32 tx_max_coalesced_frames_high;
	__u32 rate_sample_interval;
};

struct ethtool_ringparam {
	__u32 cmd;
	__u32 rx_max_pending;
	__u32 rx_mini_max_pending;
	__u32 rx_jumbo_max_pending;
	__u32 tx_max_pending;
	__u32 rx_pending;
	__u32 rx_mini_pending;
	__u32 rx_jumbo_pending;
	__u32 tx_pending;
};

struct ethtool_channels {
	__u32 cmd;
	__u32 max_rx;
	__u32 max_tx;
	__u32 max_other;
	__u32 max_combined;
	__u32 rx_count;
	__u32 tx_count;
	__u32 other_count;
	__u32 combined_count;
};

struct ethtool_pauseparam {
	__u32 cmd;
	__u32 autoneg;
	__u32 rx_pause;
	__u32 tx_pause;
};

enum ethtool_link_ext_state {
	ETHTOOL_LINK_EXT_STATE_AUTONEG = 0,
	ETHTOOL_LINK_EXT_STATE_LINK_TRAINING_FAILURE = 1,
	ETHTOOL_LINK_EXT_STATE_LINK_LOGICAL_MISMATCH = 2,
	ETHTOOL_LINK_EXT_STATE_BAD_SIGNAL_INTEGRITY = 3,
	ETHTOOL_LINK_EXT_STATE_NO_CABLE = 4,
	ETHTOOL_LINK_EXT_STATE_CABLE_ISSUE = 5,
	ETHTOOL_LINK_EXT_STATE_EEPROM_ISSUE = 6,
	ETHTOOL_LINK_EXT_STATE_CALIBRATION_FAILURE = 7,
	ETHTOOL_LINK_EXT_STATE_POWER_BUDGET_EXCEEDED = 8,
	ETHTOOL_LINK_EXT_STATE_OVERHEAT = 9,
	ETHTOOL_LINK_EXT_STATE_MODULE = 10,
};

enum ethtool_link_ext_substate_autoneg {
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NO_PARTNER_DETECTED = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_ACK_NOT_RECEIVED = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NEXT_PAGE_EXCHANGE_FAILED = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NO_PARTNER_DETECTED_FORCE_MODE = 4,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_FEC_MISMATCH_DURING_OVERRIDE = 5,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NO_HCD = 6,
};

enum ethtool_link_ext_substate_link_training {
	ETHTOOL_LINK_EXT_SUBSTATE_LT_KR_FRAME_LOCK_NOT_ACQUIRED = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_LT_KR_LINK_INHIBIT_TIMEOUT = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_LT_KR_LINK_PARTNER_DID_NOT_SET_RECEIVER_READY = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_LT_REMOTE_FAULT = 4,
};

enum ethtool_link_ext_substate_link_logical_mismatch {
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_PCS_DID_NOT_ACQUIRE_BLOCK_LOCK = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_PCS_DID_NOT_ACQUIRE_AM_LOCK = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_PCS_DID_NOT_GET_ALIGN_STATUS = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_FC_FEC_IS_NOT_LOCKED = 4,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_RS_FEC_IS_NOT_LOCKED = 5,
};

enum ethtool_link_ext_substate_bad_signal_integrity {
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_LARGE_NUMBER_OF_PHYSICAL_ERRORS = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_UNSUPPORTED_RATE = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_SERDES_REFERENCE_CLOCK_LOST = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_SERDES_ALOS = 4,
};

enum ethtool_link_ext_substate_cable_issue {
	ETHTOOL_LINK_EXT_SUBSTATE_CI_UNSUPPORTED_CABLE = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_CI_CABLE_TEST_FAILURE = 2,
};

enum ethtool_link_ext_substate_module {
	ETHTOOL_LINK_EXT_SUBSTATE_MODULE_CMIS_NOT_READY = 1,
};

enum ethtool_mac_stats_src {
	ETHTOOL_MAC_STATS_SRC_AGGREGATE = 0,
	ETHTOOL_MAC_STATS_SRC_EMAC = 1,
	ETHTOOL_MAC_STATS_SRC_PMAC = 2,
};

enum ethtool_module_power_mode_policy {
	ETHTOOL_MODULE_POWER_MODE_POLICY_HIGH = 1,
	ETHTOOL_MODULE_POWER_MODE_POLICY_AUTO = 2,
};

enum ethtool_module_power_mode {
	ETHTOOL_MODULE_POWER_MODE_LOW = 1,
	ETHTOOL_MODULE_POWER_MODE_HIGH = 2,
};

enum ethtool_mm_verify_status {
	ETHTOOL_MM_VERIFY_STATUS_UNKNOWN = 0,
	ETHTOOL_MM_VERIFY_STATUS_INITIAL = 1,
	ETHTOOL_MM_VERIFY_STATUS_VERIFYING = 2,
	ETHTOOL_MM_VERIFY_STATUS_SUCCEEDED = 3,
	ETHTOOL_MM_VERIFY_STATUS_FAILED = 4,
	ETHTOOL_MM_VERIFY_STATUS_DISABLED = 5,
};

struct ethtool_test {
	__u32 cmd;
	__u32 flags;
	__u32 reserved;
	__u32 len;
	__u64 data[0];
};

struct ethtool_stats {
	__u32 cmd;
	__u32 n_stats;
	__u64 data[0];
};

struct ethtool_tcpip4_spec {
	__be32 ip4src;
	__be32 ip4dst;
	__be16 psrc;
	__be16 pdst;
	__u8 tos;
};

struct ethtool_ah_espip4_spec {
	__be32 ip4src;
	__be32 ip4dst;
	__be32 spi;
	__u8 tos;
};

struct ethtool_usrip4_spec {
	__be32 ip4src;
	__be32 ip4dst;
	__be32 l4_4_bytes;
	__u8 tos;
	__u8 ip_ver;
	__u8 proto;
};

struct ethtool_tcpip6_spec {
	__be32 ip6src[4];
	__be32 ip6dst[4];
	__be16 psrc;
	__be16 pdst;
	__u8 tclass;
};

struct ethtool_ah_espip6_spec {
	__be32 ip6src[4];
	__be32 ip6dst[4];
	__be32 spi;
	__u8 tclass;
};

struct ethtool_usrip6_spec {
	__be32 ip6src[4];
	__be32 ip6dst[4];
	__be32 l4_4_bytes;
	__u8 tclass;
	__u8 l4_proto;
};

union ethtool_flow_union {
	struct ethtool_tcpip4_spec tcp_ip4_spec;
	struct ethtool_tcpip4_spec udp_ip4_spec;
	struct ethtool_tcpip4_spec sctp_ip4_spec;
	struct ethtool_ah_espip4_spec ah_ip4_spec;
	struct ethtool_ah_espip4_spec esp_ip4_spec;
	struct ethtool_usrip4_spec usr_ip4_spec;
	struct ethtool_tcpip6_spec tcp_ip6_spec;
	struct ethtool_tcpip6_spec udp_ip6_spec;
	struct ethtool_tcpip6_spec sctp_ip6_spec;
	struct ethtool_ah_espip6_spec ah_ip6_spec;
	struct ethtool_ah_espip6_spec esp_ip6_spec;
	struct ethtool_usrip6_spec usr_ip6_spec;
	struct ethhdr ether_spec;
	__u8 hdata[52];
};

struct ethtool_flow_ext {
	__u8 padding[2];
	unsigned char h_dest[6];
	__be16 vlan_etype;
	__be16 vlan_tci;
	__be32 data[2];
};

struct ethtool_rx_flow_spec {
	__u32 flow_type;
	union ethtool_flow_union h_u;
	struct ethtool_flow_ext h_ext;
	union ethtool_flow_union m_u;
	struct ethtool_flow_ext m_ext;
	__u64 ring_cookie;
	__u32 location;
};

struct ethtool_rxnfc {
	__u32 cmd;
	__u32 flow_type;
	__u64 data;
	struct ethtool_rx_flow_spec fs;
	union {
		__u32 rule_cnt;
		__u32 rss_context;
	};
	__u32 rule_locs[0];
};

struct ethtool_flash {
	__u32 cmd;
	__u32 region;
	char data[128];
};

struct ethtool_dump {
	__u32 cmd;
	__u32 version;
	__u32 flag;
	__u32 len;
	__u8 data[0];
};

struct ethtool_ts_info {
	__u32 cmd;
	__u32 so_timestamping;
	__s32 phc_index;
	__u32 tx_types;
	__u32 tx_reserved[3];
	__u32 rx_filters;
	__u32 rx_reserved[3];
};

struct ethtool_fecparam {
	__u32 cmd;
	__u32 active_fec;
	__u32 fec;
	__u32 reserved;
};

enum ethtool_link_mode_bit_indices {
	ETHTOOL_LINK_MODE_10baseT_Half_BIT = 0,
	ETHTOOL_LINK_MODE_10baseT_Full_BIT = 1,
	ETHTOOL_LINK_MODE_100baseT_Half_BIT = 2,
	ETHTOOL_LINK_MODE_100baseT_Full_BIT = 3,
	ETHTOOL_LINK_MODE_1000baseT_Half_BIT = 4,
	ETHTOOL_LINK_MODE_1000baseT_Full_BIT = 5,
	ETHTOOL_LINK_MODE_Autoneg_BIT = 6,
	ETHTOOL_LINK_MODE_TP_BIT = 7,
	ETHTOOL_LINK_MODE_AUI_BIT = 8,
	ETHTOOL_LINK_MODE_MII_BIT = 9,
	ETHTOOL_LINK_MODE_FIBRE_BIT = 10,
	ETHTOOL_LINK_MODE_BNC_BIT = 11,
	ETHTOOL_LINK_MODE_10000baseT_Full_BIT = 12,
	ETHTOOL_LINK_MODE_Pause_BIT = 13,
	ETHTOOL_LINK_MODE_Asym_Pause_BIT = 14,
	ETHTOOL_LINK_MODE_2500baseX_Full_BIT = 15,
	ETHTOOL_LINK_MODE_Backplane_BIT = 16,
	ETHTOOL_LINK_MODE_1000baseKX_Full_BIT = 17,
	ETHTOOL_LINK_MODE_10000baseKX4_Full_BIT = 18,
	ETHTOOL_LINK_MODE_10000baseKR_Full_BIT = 19,
	ETHTOOL_LINK_MODE_10000baseR_FEC_BIT = 20,
	ETHTOOL_LINK_MODE_20000baseMLD2_Full_BIT = 21,
	ETHTOOL_LINK_MODE_20000baseKR2_Full_BIT = 22,
	ETHTOOL_LINK_MODE_40000baseKR4_Full_BIT = 23,
	ETHTOOL_LINK_MODE_40000baseCR4_Full_BIT = 24,
	ETHTOOL_LINK_MODE_40000baseSR4_Full_BIT = 25,
	ETHTOOL_LINK_MODE_40000baseLR4_Full_BIT = 26,
	ETHTOOL_LINK_MODE_56000baseKR4_Full_BIT = 27,
	ETHTOOL_LINK_MODE_56000baseCR4_Full_BIT = 28,
	ETHTOOL_LINK_MODE_56000baseSR4_Full_BIT = 29,
	ETHTOOL_LINK_MODE_56000baseLR4_Full_BIT = 30,
	ETHTOOL_LINK_MODE_25000baseCR_Full_BIT = 31,
	ETHTOOL_LINK_MODE_25000baseKR_Full_BIT = 32,
	ETHTOOL_LINK_MODE_25000baseSR_Full_BIT = 33,
	ETHTOOL_LINK_MODE_50000baseCR2_Full_BIT = 34,
	ETHTOOL_LINK_MODE_50000baseKR2_Full_BIT = 35,
	ETHTOOL_LINK_MODE_100000baseKR4_Full_BIT = 36,
	ETHTOOL_LINK_MODE_100000baseSR4_Full_BIT = 37,
	ETHTOOL_LINK_MODE_100000baseCR4_Full_BIT = 38,
	ETHTOOL_LINK_MODE_100000baseLR4_ER4_Full_BIT = 39,
	ETHTOOL_LINK_MODE_50000baseSR2_Full_BIT = 40,
	ETHTOOL_LINK_MODE_1000baseX_Full_BIT = 41,
	ETHTOOL_LINK_MODE_10000baseCR_Full_BIT = 42,
	ETHTOOL_LINK_MODE_10000baseSR_Full_BIT = 43,
	ETHTOOL_LINK_MODE_10000baseLR_Full_BIT = 44,
	ETHTOOL_LINK_MODE_10000baseLRM_Full_BIT = 45,
	ETHTOOL_LINK_MODE_10000baseER_Full_BIT = 46,
	ETHTOOL_LINK_MODE_2500baseT_Full_BIT = 47,
	ETHTOOL_LINK_MODE_5000baseT_Full_BIT = 48,
	ETHTOOL_LINK_MODE_FEC_NONE_BIT = 49,
	ETHTOOL_LINK_MODE_FEC_RS_BIT = 50,
	ETHTOOL_LINK_MODE_FEC_BASER_BIT = 51,
	ETHTOOL_LINK_MODE_50000baseKR_Full_BIT = 52,
	ETHTOOL_LINK_MODE_50000baseSR_Full_BIT = 53,
	ETHTOOL_LINK_MODE_50000baseCR_Full_BIT = 54,
	ETHTOOL_LINK_MODE_50000baseLR_ER_FR_Full_BIT = 55,
	ETHTOOL_LINK_MODE_50000baseDR_Full_BIT = 56,
	ETHTOOL_LINK_MODE_100000baseKR2_Full_BIT = 57,
	ETHTOOL_LINK_MODE_100000baseSR2_Full_BIT = 58,
	ETHTOOL_LINK_MODE_100000baseCR2_Full_BIT = 59,
	ETHTOOL_LINK_MODE_100000baseLR2_ER2_FR2_Full_BIT = 60,
	ETHTOOL_LINK_MODE_100000baseDR2_Full_BIT = 61,
	ETHTOOL_LINK_MODE_200000baseKR4_Full_BIT = 62,
	ETHTOOL_LINK_MODE_200000baseSR4_Full_BIT = 63,
	ETHTOOL_LINK_MODE_200000baseLR4_ER4_FR4_Full_BIT = 64,
	ETHTOOL_LINK_MODE_200000baseDR4_Full_BIT = 65,
	ETHTOOL_LINK_MODE_200000baseCR4_Full_BIT = 66,
	ETHTOOL_LINK_MODE_100baseT1_Full_BIT = 67,
	ETHTOOL_LINK_MODE_1000baseT1_Full_BIT = 68,
	ETHTOOL_LINK_MODE_400000baseKR8_Full_BIT = 69,
	ETHTOOL_LINK_MODE_400000baseSR8_Full_BIT = 70,
	ETHTOOL_LINK_MODE_400000baseLR8_ER8_FR8_Full_BIT = 71,
	ETHTOOL_LINK_MODE_400000baseDR8_Full_BIT = 72,
	ETHTOOL_LINK_MODE_400000baseCR8_Full_BIT = 73,
	ETHTOOL_LINK_MODE_FEC_LLRS_BIT = 74,
	ETHTOOL_LINK_MODE_100000baseKR_Full_BIT = 75,
	ETHTOOL_LINK_MODE_100000baseSR_Full_BIT = 76,
	ETHTOOL_LINK_MODE_100000baseLR_ER_FR_Full_BIT = 77,
	ETHTOOL_LINK_MODE_100000baseCR_Full_BIT = 78,
	ETHTOOL_LINK_MODE_100000baseDR_Full_BIT = 79,
	ETHTOOL_LINK_MODE_200000baseKR2_Full_BIT = 80,
	ETHTOOL_LINK_MODE_200000baseSR2_Full_BIT = 81,
	ETHTOOL_LINK_MODE_200000baseLR2_ER2_FR2_Full_BIT = 82,
	ETHTOOL_LINK_MODE_200000baseDR2_Full_BIT = 83,
	ETHTOOL_LINK_MODE_200000baseCR2_Full_BIT = 84,
	ETHTOOL_LINK_MODE_400000baseKR4_Full_BIT = 85,
	ETHTOOL_LINK_MODE_400000baseSR4_Full_BIT = 86,
	ETHTOOL_LINK_MODE_400000baseLR4_ER4_FR4_Full_BIT = 87,
	ETHTOOL_LINK_MODE_400000baseDR4_Full_BIT = 88,
	ETHTOOL_LINK_MODE_400000baseCR4_Full_BIT = 89,
	ETHTOOL_LINK_MODE_100baseFX_Half_BIT = 90,
	ETHTOOL_LINK_MODE_100baseFX_Full_BIT = 91,
	ETHTOOL_LINK_MODE_10baseT1L_Full_BIT = 92,
	ETHTOOL_LINK_MODE_800000baseCR8_Full_BIT = 93,
	ETHTOOL_LINK_MODE_800000baseKR8_Full_BIT = 94,
	ETHTOOL_LINK_MODE_800000baseDR8_Full_BIT = 95,
	ETHTOOL_LINK_MODE_800000baseDR8_2_Full_BIT = 96,
	ETHTOOL_LINK_MODE_800000baseSR8_Full_BIT = 97,
	ETHTOOL_LINK_MODE_800000baseVR8_Full_BIT = 98,
	ETHTOOL_LINK_MODE_10baseT1S_Full_BIT = 99,
	ETHTOOL_LINK_MODE_10baseT1S_Half_BIT = 100,
	ETHTOOL_LINK_MODE_10baseT1S_P2MP_Half_BIT = 101,
	__ETHTOOL_LINK_MODE_MASK_NBITS = 102,
};

struct ethtool_link_settings {
	__u32 cmd;
	__u32 speed;
	__u8 duplex;
	__u8 port;
	__u8 phy_address;
	__u8 autoneg;
	__u8 mdio_support;
	__u8 eth_tp_mdix;
	__u8 eth_tp_mdix_ctrl;
	__s8 link_mode_masks_nwords;
	__u8 transceiver;
	__u8 master_slave_cfg;
	__u8 master_slave_state;
	__u8 rate_matching;
	__u32 reserved[7];
	__u32 link_mode_masks[0];
};

struct kernel_ethtool_ringparam {
	u32 rx_buf_len;
	u8 tcp_data_split;
	u8 tx_push;
	u8 rx_push;
	u32 cqe_size;
	u32 tx_push_buf_len;
	u32 tx_push_buf_max_len;
};

struct ethtool_link_ext_state_info {
	enum ethtool_link_ext_state link_ext_state;
	union {
		enum ethtool_link_ext_substate_autoneg autoneg;
		enum ethtool_link_ext_substate_link_training link_training;
		enum ethtool_link_ext_substate_link_logical_mismatch link_logical_mismatch;
		enum ethtool_link_ext_substate_bad_signal_integrity bad_signal_integrity;
		enum ethtool_link_ext_substate_cable_issue cable_issue;
		enum ethtool_link_ext_substate_module module;
		u32 __link_ext_substate;
	};
};

struct ethtool_link_ext_stats {
	u64 link_down_events;
};

struct ethtool_link_ksettings {
	struct ethtool_link_settings base;
	struct {
		long unsigned int supported[2];
		long unsigned int advertising[2];
		long unsigned int lp_advertising[2];
	} link_modes;
	u32 lanes;
};

struct kernel_ethtool_coalesce {
	u8 use_cqe_mode_tx;
	u8 use_cqe_mode_rx;
	u32 tx_aggr_max_bytes;
	u32 tx_aggr_max_frames;
	u32 tx_aggr_time_usecs;
};

struct ethtool_eth_mac_stats {
	enum ethtool_mac_stats_src src;
	union {
		struct {
			u64 FramesTransmittedOK;
			u64 SingleCollisionFrames;
			u64 MultipleCollisionFrames;
			u64 FramesReceivedOK;
			u64 FrameCheckSequenceErrors;
			u64 AlignmentErrors;
			u64 OctetsTransmittedOK;
			u64 FramesWithDeferredXmissions;
			u64 LateCollisions;
			u64 FramesAbortedDueToXSColls;
			u64 FramesLostDueToIntMACXmitError;
			u64 CarrierSenseErrors;
			u64 OctetsReceivedOK;
			u64 FramesLostDueToIntMACRcvError;
			u64 MulticastFramesXmittedOK;
			u64 BroadcastFramesXmittedOK;
			u64 FramesWithExcessiveDeferral;
			u64 MulticastFramesReceivedOK;
			u64 BroadcastFramesReceivedOK;
			u64 InRangeLengthErrors;
			u64 OutOfRangeLengthField;
			u64 FrameTooLongErrors;
		};
		struct {
			u64 FramesTransmittedOK;
			u64 SingleCollisionFrames;
			u64 MultipleCollisionFrames;
			u64 FramesReceivedOK;
			u64 FrameCheckSequenceErrors;
			u64 AlignmentErrors;
			u64 OctetsTransmittedOK;
			u64 FramesWithDeferredXmissions;
			u64 LateCollisions;
			u64 FramesAbortedDueToXSColls;
			u64 FramesLostDueToIntMACXmitError;
			u64 CarrierSenseErrors;
			u64 OctetsReceivedOK;
			u64 FramesLostDueToIntMACRcvError;
			u64 MulticastFramesXmittedOK;
			u64 BroadcastFramesXmittedOK;
			u64 FramesWithExcessiveDeferral;
			u64 MulticastFramesReceivedOK;
			u64 BroadcastFramesReceivedOK;
			u64 InRangeLengthErrors;
			u64 OutOfRangeLengthField;
			u64 FrameTooLongErrors;
		} stats;
	};
};

struct ethtool_eth_phy_stats {
	enum ethtool_mac_stats_src src;
	union {
		struct {
			u64 SymbolErrorDuringCarrier;
		};
		struct {
			u64 SymbolErrorDuringCarrier;
		} stats;
	};
};

struct ethtool_eth_ctrl_stats {
	enum ethtool_mac_stats_src src;
	union {
		struct {
			u64 MACControlFramesTransmitted;
			u64 MACControlFramesReceived;
			u64 UnsupportedOpcodesReceived;
		};
		struct {
			u64 MACControlFramesTransmitted;
			u64 MACControlFramesReceived;
			u64 UnsupportedOpcodesReceived;
		} stats;
	};
};

struct ethtool_pause_stats {
	enum ethtool_mac_stats_src src;
	union {
		struct {
			u64 tx_pause_frames;
			u64 rx_pause_frames;
		};
		struct {
			u64 tx_pause_frames;
			u64 rx_pause_frames;
		} stats;
	};
};

struct ethtool_fec_stat {
	u64 total;
	u64 lanes[8];
};

struct ethtool_fec_stats {
	struct ethtool_fec_stat corrected_blocks;
	struct ethtool_fec_stat uncorrectable_blocks;
	struct ethtool_fec_stat corrected_bits;
};

struct ethtool_rmon_hist_range {
	u16 low;
	u16 high;
};

struct ethtool_rmon_stats {
	enum ethtool_mac_stats_src src;
	union {
		struct {
			u64 undersize_pkts;
			u64 oversize_pkts;
			u64 fragments;
			u64 jabbers;
			u64 hist[10];
			u64 hist_tx[10];
		};
		struct {
			u64 undersize_pkts;
			u64 oversize_pkts;
			u64 fragments;
			u64 jabbers;
			u64 hist[10];
			u64 hist_tx[10];
		} stats;
	};
};

struct ethtool_module_eeprom {
	u32 offset;
	u32 length;
	u8 page;
	u8 bank;
	u8 i2c_address;
	u8 *data;
};

struct ethtool_module_power_mode_params {
	enum ethtool_module_power_mode_policy policy;
	enum ethtool_module_power_mode mode;
};

struct ethtool_mm_state {
	u32 verify_time;
	u32 max_verify_time;
	enum ethtool_mm_verify_status verify_status;
	bool tx_enabled;
	bool tx_active;
	bool pmac_enabled;
	bool verify_enabled;
	u32 tx_min_frag_size;
	u32 rx_min_frag_size;
};

struct ethtool_mm_cfg {
	u32 verify_time;
	bool verify_enabled;
	bool tx_enabled;
	bool pmac_enabled;
	u32 tx_min_frag_size;
};

struct ethtool_mm_stats {
	u64 MACMergeFrameAssErrorCount;
	u64 MACMergeFrameSmdErrorCount;
	u64 MACMergeFrameAssOkCount;
	u64 MACMergeFragCountRx;
	u64 MACMergeFragCountTx;
	u64 MACMergeHoldCount;
};

enum ib_uverbs_write_cmds {
	IB_USER_VERBS_CMD_GET_CONTEXT = 0,
	IB_USER_VERBS_CMD_QUERY_DEVICE = 1,
	IB_USER_VERBS_CMD_QUERY_PORT = 2,
	IB_USER_VERBS_CMD_ALLOC_PD = 3,
	IB_USER_VERBS_CMD_DEALLOC_PD = 4,
	IB_USER_VERBS_CMD_CREATE_AH = 5,
	IB_USER_VERBS_CMD_MODIFY_AH = 6,
	IB_USER_VERBS_CMD_QUERY_AH = 7,
	IB_USER_VERBS_CMD_DESTROY_AH = 8,
	IB_USER_VERBS_CMD_REG_MR = 9,
	IB_USER_VERBS_CMD_REG_SMR = 10,
	IB_USER_VERBS_CMD_REREG_MR = 11,
	IB_USER_VERBS_CMD_QUERY_MR = 12,
	IB_USER_VERBS_CMD_DEREG_MR = 13,
	IB_USER_VERBS_CMD_ALLOC_MW = 14,
	IB_USER_VERBS_CMD_BIND_MW = 15,
	IB_USER_VERBS_CMD_DEALLOC_MW = 16,
	IB_USER_VERBS_CMD_CREATE_COMP_CHANNEL = 17,
	IB_USER_VERBS_CMD_CREATE_CQ = 18,
	IB_USER_VERBS_CMD_RESIZE_CQ = 19,
	IB_USER_VERBS_CMD_DESTROY_CQ = 20,
	IB_USER_VERBS_CMD_POLL_CQ = 21,
	IB_USER_VERBS_CMD_PEEK_CQ = 22,
	IB_USER_VERBS_CMD_REQ_NOTIFY_CQ = 23,
	IB_USER_VERBS_CMD_CREATE_QP = 24,
	IB_USER_VERBS_CMD_QUERY_QP = 25,
	IB_USER_VERBS_CMD_MODIFY_QP = 26,
	IB_USER_VERBS_CMD_DESTROY_QP = 27,
	IB_USER_VERBS_CMD_POST_SEND = 28,
	IB_USER_VERBS_CMD_POST_RECV = 29,
	IB_USER_VERBS_CMD_ATTACH_MCAST = 30,
	IB_USER_VERBS_CMD_DETACH_MCAST = 31,
	IB_USER_VERBS_CMD_CREATE_SRQ = 32,
	IB_USER_VERBS_CMD_MODIFY_SRQ = 33,
	IB_USER_VERBS_CMD_QUERY_SRQ = 34,
	IB_USER_VERBS_CMD_DESTROY_SRQ = 35,
	IB_USER_VERBS_CMD_POST_SRQ_RECV = 36,
	IB_USER_VERBS_CMD_OPEN_XRCD = 37,
	IB_USER_VERBS_CMD_CLOSE_XRCD = 38,
	IB_USER_VERBS_CMD_CREATE_XSRQ = 39,
	IB_USER_VERBS_CMD_OPEN_QP = 40,
};

enum ib_uverbs_wc_opcode {
	IB_UVERBS_WC_SEND = 0,
	IB_UVERBS_WC_RDMA_WRITE = 1,
	IB_UVERBS_WC_RDMA_READ = 2,
	IB_UVERBS_WC_COMP_SWAP = 3,
	IB_UVERBS_WC_FETCH_ADD = 4,
	IB_UVERBS_WC_BIND_MW = 5,
	IB_UVERBS_WC_LOCAL_INV = 6,
	IB_UVERBS_WC_TSO = 7,
	IB_UVERBS_WC_FLUSH = 8,
	IB_UVERBS_WC_ATOMIC_WRITE = 9,
};

enum ib_uverbs_create_qp_mask {
	IB_UVERBS_CREATE_QP_MASK_IND_TABLE = 1,
};

enum ib_uverbs_wr_opcode {
	IB_UVERBS_WR_RDMA_WRITE = 0,
	IB_UVERBS_WR_RDMA_WRITE_WITH_IMM = 1,
	IB_UVERBS_WR_SEND = 2,
	IB_UVERBS_WR_SEND_WITH_IMM = 3,
	IB_UVERBS_WR_RDMA_READ = 4,
	IB_UVERBS_WR_ATOMIC_CMP_AND_SWP = 5,
	IB_UVERBS_WR_ATOMIC_FETCH_AND_ADD = 6,
	IB_UVERBS_WR_LOCAL_INV = 7,
	IB_UVERBS_WR_BIND_MW = 8,
	IB_UVERBS_WR_SEND_WITH_INV = 9,
	IB_UVERBS_WR_TSO = 10,
	IB_UVERBS_WR_RDMA_READ_WITH_INV = 11,
	IB_UVERBS_WR_MASKED_ATOMIC_CMP_AND_SWP = 12,
	IB_UVERBS_WR_MASKED_ATOMIC_FETCH_AND_ADD = 13,
	IB_UVERBS_WR_FLUSH = 14,
	IB_UVERBS_WR_ATOMIC_WRITE = 15,
};

enum ib_uverbs_device_cap_flags {
	IB_UVERBS_DEVICE_RESIZE_MAX_WR = 1ULL,
	IB_UVERBS_DEVICE_BAD_PKEY_CNTR = 2ULL,
	IB_UVERBS_DEVICE_BAD_QKEY_CNTR = 4ULL,
	IB_UVERBS_DEVICE_RAW_MULTI = 8ULL,
	IB_UVERBS_DEVICE_AUTO_PATH_MIG = 16ULL,
	IB_UVERBS_DEVICE_CHANGE_PHY_PORT = 32ULL,
	IB_UVERBS_DEVICE_UD_AV_PORT_ENFORCE = 64ULL,
	IB_UVERBS_DEVICE_CURR_QP_STATE_MOD = 128ULL,
	IB_UVERBS_DEVICE_SHUTDOWN_PORT = 256ULL,
	IB_UVERBS_DEVICE_PORT_ACTIVE_EVENT = 1024ULL,
	IB_UVERBS_DEVICE_SYS_IMAGE_GUID = 2048ULL,
	IB_UVERBS_DEVICE_RC_RNR_NAK_GEN = 4096ULL,
	IB_UVERBS_DEVICE_SRQ_RESIZE = 8192ULL,
	IB_UVERBS_DEVICE_N_NOTIFY_CQ = 16384ULL,
	IB_UVERBS_DEVICE_MEM_WINDOW = 131072ULL,
	IB_UVERBS_DEVICE_UD_IP_CSUM = 262144ULL,
	IB_UVERBS_DEVICE_XRC = 1048576ULL,
	IB_UVERBS_DEVICE_MEM_MGT_EXTENSIONS = 2097152ULL,
	IB_UVERBS_DEVICE_MEM_WINDOW_TYPE_2A = 8388608ULL,
	IB_UVERBS_DEVICE_MEM_WINDOW_TYPE_2B = 16777216ULL,
	IB_UVERBS_DEVICE_RC_IP_CSUM = 33554432ULL,
	IB_UVERBS_DEVICE_RAW_IP_CSUM = 67108864ULL,
	IB_UVERBS_DEVICE_MANAGED_FLOW_STEERING = 536870912ULL,
	IB_UVERBS_DEVICE_RAW_SCATTER_FCS = 17179869184ULL,
	IB_UVERBS_DEVICE_PCI_WRITE_END_PADDING = 68719476736ULL,
	IB_UVERBS_DEVICE_FLUSH_GLOBAL = 274877906944ULL,
	IB_UVERBS_DEVICE_FLUSH_PERSISTENT = 549755813888ULL,
	IB_UVERBS_DEVICE_ATOMIC_WRITE = 1099511627776ULL,
};

enum ib_uverbs_raw_packet_caps {
	IB_UVERBS_RAW_PACKET_CAP_CVLAN_STRIPPING = 1,
	IB_UVERBS_RAW_PACKET_CAP_SCATTER_FCS = 2,
	IB_UVERBS_RAW_PACKET_CAP_IP_CSUM = 4,
	IB_UVERBS_RAW_PACKET_CAP_DELAY_DROP = 8,
};

enum ib_uverbs_access_flags {
	IB_UVERBS_ACCESS_LOCAL_WRITE = 1,
	IB_UVERBS_ACCESS_REMOTE_WRITE = 2,
	IB_UVERBS_ACCESS_REMOTE_READ = 4,
	IB_UVERBS_ACCESS_REMOTE_ATOMIC = 8,
	IB_UVERBS_ACCESS_MW_BIND = 16,
	IB_UVERBS_ACCESS_ZERO_BASED = 32,
	IB_UVERBS_ACCESS_ON_DEMAND = 64,
	IB_UVERBS_ACCESS_HUGETLB = 128,
	IB_UVERBS_ACCESS_FLUSH_GLOBAL = 256,
	IB_UVERBS_ACCESS_FLUSH_PERSISTENT = 512,
	IB_UVERBS_ACCESS_RELAXED_ORDERING = 1048576,
	IB_UVERBS_ACCESS_OPTIONAL_RANGE = 1072693248,
};

enum ib_uverbs_srq_type {
	IB_UVERBS_SRQT_BASIC = 0,
	IB_UVERBS_SRQT_XRC = 1,
	IB_UVERBS_SRQT_TM = 2,
};

enum ib_uverbs_wq_type {
	IB_UVERBS_WQT_RQ = 0,
};

enum ib_uverbs_wq_flags {
	IB_UVERBS_WQ_FLAGS_CVLAN_STRIPPING = 1,
	IB_UVERBS_WQ_FLAGS_SCATTER_FCS = 2,
	IB_UVERBS_WQ_FLAGS_DELAY_DROP = 4,
	IB_UVERBS_WQ_FLAGS_PCI_WRITE_END_PADDING = 8,
};

enum ib_uverbs_qp_type {
	IB_UVERBS_QPT_RC = 2,
	IB_UVERBS_QPT_UC = 3,
	IB_UVERBS_QPT_UD = 4,
	IB_UVERBS_QPT_RAW_PACKET = 8,
	IB_UVERBS_QPT_XRC_INI = 9,
	IB_UVERBS_QPT_XRC_TGT = 10,
	IB_UVERBS_QPT_DRIVER = 255,
};

enum ib_uverbs_qp_create_flags {
	IB_UVERBS_QP_CREATE_BLOCK_MULTICAST_LOOPBACK = 2,
	IB_UVERBS_QP_CREATE_SCATTER_FCS = 256,
	IB_UVERBS_QP_CREATE_CVLAN_STRIPPING = 512,
	IB_UVERBS_QP_CREATE_PCI_WRITE_END_PADDING = 2048,
	IB_UVERBS_QP_CREATE_SQ_SIG_ALL = 4096,
};

enum ib_uverbs_gid_type {
	IB_UVERBS_GID_TYPE_IB = 0,
	IB_UVERBS_GID_TYPE_ROCE_V1 = 1,
	IB_UVERBS_GID_TYPE_ROCE_V2 = 2,
};

enum ib_poll_context {
	IB_POLL_SOFTIRQ = 0,
	IB_POLL_WORKQUEUE = 1,
	IB_POLL_UNBOUND_WORKQUEUE = 2,
	IB_POLL_LAST_POOL_TYPE = 2,
	IB_POLL_DIRECT = 3,
};

enum {
	POLICYDB_CAP_NETPEER = 0,
	POLICYDB_CAP_OPENPERM = 1,
	POLICYDB_CAP_EXTSOCKCLASS = 2,
	POLICYDB_CAP_ALWAYSNETWORK = 3,
	POLICYDB_CAP_CGROUPSECLABEL = 4,
	POLICYDB_CAP_NNP_NOSUID_TRANSITION = 5,
	POLICYDB_CAP_GENFS_SECLABEL_SYMLINKS = 6,
	POLICYDB_CAP_IOCTL_SKIP_CLOEXEC = 7,
	__POLICYDB_CAP_MAX = 8,
};

struct netnode_security_struct {
	union {
		__be32 ipv4;
		struct in6_addr ipv6;
	} addr;
	u32 sid;
	u16 family;
};

struct sel_netnode_bkt {
	unsigned int size;
	struct list_head list;
};

struct sel_netnode {
	struct netnode_security_struct nsec;
	struct list_head list;
	struct callback_head rcu;
};

enum {
	Audit_equal = 0,
	Audit_not_equal = 1,
	Audit_bitmask = 2,
	Audit_bittest = 3,
	Audit_lt = 4,
	Audit_gt = 5,
	Audit_le = 6,
	Audit_ge = 7,
	Audit_bad = 8,
};

union flowi_uli {
	struct {
		__be16 dport;
		__be16 sport;
	} ports;
	struct {
		__u8 type;
		__u8 code;
	} icmpt;
	__be32 gre_key;
	struct {
		__u8 type;
	} mht;
};

struct flowi4 {
	struct flowi_common __fl_common;
	__be32 saddr;
	__be32 daddr;
	union flowi_uli uli;
};

struct flowi6 {
	struct flowi_common __fl_common;
	struct in6_addr daddr;
	struct in6_addr saddr;
	__be32 flowlabel;
	union flowi_uli uli;
	__u32 mp_hash;
};

struct flowi {
	union {
		struct flowi_common __fl_common;
		struct flowi4 ip4;
		struct flowi6 ip6;
	} u;
};

struct rt6key {
	struct in6_addr addr;
	int plen;
};

struct rtable;

struct fnhe_hash_bucket;

struct fib_nh_common {
	struct net_device *nhc_dev;
	netdevice_tracker nhc_dev_tracker;
	int nhc_oif;
	unsigned char nhc_scope;
	u8 nhc_family;
	u8 nhc_gw_family;
	unsigned char nhc_flags;
	struct lwtunnel_state *nhc_lwtstate;
	union {
		__be32 ipv4;
		struct in6_addr ipv6;
	} nhc_gw;
	int nhc_weight;
	atomic_t nhc_upper_bound;
	struct rtable **nhc_pcpu_rth_output;
	struct rtable *nhc_rth_input;
	struct fnhe_hash_bucket *nhc_exceptions;
};

struct rt6_exception_bucket;

struct fib6_nh {
	struct fib_nh_common nh_common;
	struct rt6_info **rt6i_pcpu;
	struct rt6_exception_bucket *rt6i_exception_bucket;
};

struct fib6_node;

struct dst_metrics;

struct nexthop;

struct fib6_info {
	struct fib6_table *fib6_table;
	struct fib6_info *fib6_next;
	struct fib6_node *fib6_node;
	union {
		struct list_head fib6_siblings;
		struct list_head nh_list;
	};
	unsigned int fib6_nsiblings;
	refcount_t fib6_ref;
	long unsigned int expires;
	struct hlist_node gc_link;
	struct dst_metrics *fib6_metrics;
	struct rt6key fib6_dst;
	u32 fib6_flags;
	struct rt6key fib6_src;
	struct rt6key fib6_prefsrc;
	u32 fib6_metric;
	u8 fib6_protocol;
	u8 fib6_type;
	u8 offload;
	u8 trap;
	u8 offload_failed;
	u8 should_flush: 1;
	u8 dst_nocount: 1;
	u8 dst_nopolicy: 1;
	u8 fib6_destroying: 1;
	u8 unused: 4;
	struct callback_head rcu;
	struct nexthop *nh;
	struct fib6_nh fib6_nh[0];
};

struct rt6_info {
	struct dst_entry dst;
	struct fib6_info *from;
	int sernum;
	struct rt6key rt6i_dst;
	struct rt6key rt6i_src;
	struct in6_addr rt6i_gateway;
	struct inet6_dev *rt6i_idev;
	u32 rt6i_flags;
	short unsigned int rt6i_nfheader_len;
};

struct rt6_statistics {
	__u32 fib_nodes;
	__u32 fib_route_nodes;
	__u32 fib_rt_entries;
	__u32 fib_rt_cache;
	__u32 fib_discarded_routes;
	atomic_t fib_rt_alloc;
};

struct fib6_node {
	struct fib6_node *parent;
	struct fib6_node *left;
	struct fib6_node *right;
	struct fib6_info *leaf;
	__u16 fn_bit;
	__u16 fn_flags;
	int fn_sernum;
	struct fib6_info *rr_ptr;
	struct callback_head rcu;
};

struct fib6_table {
	struct hlist_node tb6_hlist;
	u32 tb6_id;
	spinlock_t tb6_lock;
	struct fib6_node tb6_root;
	struct inet_peer_base tb6_peers;
	unsigned int flags;
	unsigned int fib_seq;
	struct hlist_head tb6_gc_hlist;
};

typedef union {
	__be32 a4;
	__be32 a6[4];
	struct in6_addr in6;
} xfrm_address_t;

struct xfrm_id {
	xfrm_address_t daddr;
	__be32 spi;
	__u8 proto;
};

struct xfrm_sec_ctx {
	__u8 ctx_doi;
	__u8 ctx_alg;
	__u16 ctx_len;
	__u32 ctx_sid;
	char ctx_str[0];
};

struct xfrm_selector {
	xfrm_address_t daddr;
	xfrm_address_t saddr;
	__be16 dport;
	__be16 dport_mask;
	__be16 sport;
	__be16 sport_mask;
	__u16 family;
	__u8 prefixlen_d;
	__u8 prefixlen_s;
	__u8 proto;
	int ifindex;
	__kernel_uid32_t user;
};

struct xfrm_lifetime_cfg {
	__u64 soft_byte_limit;
	__u64 hard_byte_limit;
	__u64 soft_packet_limit;
	__u64 hard_packet_limit;
	__u64 soft_add_expires_seconds;
	__u64 hard_add_expires_seconds;
	__u64 soft_use_expires_seconds;
	__u64 hard_use_expires_seconds;
};

struct xfrm_lifetime_cur {
	__u64 bytes;
	__u64 packets;
	__u64 add_time;
	__u64 use_time;
};

struct xfrm_replay_state {
	__u32 oseq;
	__u32 seq;
	__u32 bitmap;
};

struct xfrm_replay_state_esn {
	unsigned int bmp_len;
	__u32 oseq;
	__u32 seq;
	__u32 oseq_hi;
	__u32 seq_hi;
	__u32 replay_window;
	__u32 bmp[0];
};

struct xfrm_algo {
	char alg_name[64];
	unsigned int alg_key_len;
	char alg_key[0];
};

struct xfrm_algo_auth {
	char alg_name[64];
	unsigned int alg_key_len;
	unsigned int alg_trunc_len;
	char alg_key[0];
};

struct xfrm_algo_aead {
	char alg_name[64];
	unsigned int alg_key_len;
	unsigned int alg_icv_len;
	char alg_key[0];
};

struct xfrm_stats {
	__u32 replay_window;
	__u32 replay;
	__u32 integrity_failed;
};

enum {
	XFRM_POLICY_TYPE_MAIN = 0,
	XFRM_POLICY_TYPE_SUB = 1,
	XFRM_POLICY_TYPE_MAX = 2,
	XFRM_POLICY_TYPE_ANY = 255,
};

enum {
	XFRM_MSG_BASE = 16,
	XFRM_MSG_NEWSA = 16,
	XFRM_MSG_DELSA = 17,
	XFRM_MSG_GETSA = 18,
	XFRM_MSG_NEWPOLICY = 19,
	XFRM_MSG_DELPOLICY = 20,
	XFRM_MSG_GETPOLICY = 21,
	XFRM_MSG_ALLOCSPI = 22,
	XFRM_MSG_ACQUIRE = 23,
	XFRM_MSG_EXPIRE = 24,
	XFRM_MSG_UPDPOLICY = 25,
	XFRM_MSG_UPDSA = 26,
	XFRM_MSG_POLEXPIRE = 27,
	XFRM_MSG_FLUSHSA = 28,
	XFRM_MSG_FLUSHPOLICY = 29,
	XFRM_MSG_NEWAE = 30,
	XFRM_MSG_GETAE = 31,
	XFRM_MSG_REPORT = 32,
	XFRM_MSG_MIGRATE = 33,
	XFRM_MSG_NEWSADINFO = 34,
	XFRM_MSG_GETSADINFO = 35,
	XFRM_MSG_NEWSPDINFO = 36,
	XFRM_MSG_GETSPDINFO = 37,
	XFRM_MSG_MAPPING = 38,
	XFRM_MSG_SETDEFAULT = 39,
	XFRM_MSG_GETDEFAULT = 40,
	__XFRM_MSG_MAX = 41,
};

struct xfrm_encap_tmpl {
	__u16 encap_type;
	__be16 encap_sport;
	__be16 encap_dport;
	xfrm_address_t encap_oa;
};

enum xfrm_attr_type_t {
	XFRMA_UNSPEC = 0,
	XFRMA_ALG_AUTH = 1,
	XFRMA_ALG_CRYPT = 2,
	XFRMA_ALG_COMP = 3,
	XFRMA_ENCAP = 4,
	XFRMA_TMPL = 5,
	XFRMA_SA = 6,
	XFRMA_POLICY = 7,
	XFRMA_SEC_CTX = 8,
	XFRMA_LTIME_VAL = 9,
	XFRMA_REPLAY_VAL = 10,
	XFRMA_REPLAY_THRESH = 11,
	XFRMA_ETIMER_THRESH = 12,
	XFRMA_SRCADDR = 13,
	XFRMA_COADDR = 14,
	XFRMA_LASTUSED = 15,
	XFRMA_POLICY_TYPE = 16,
	XFRMA_MIGRATE = 17,
	XFRMA_ALG_AEAD = 18,
	XFRMA_KMADDRESS = 19,
	XFRMA_ALG_AUTH_TRUNC = 20,
	XFRMA_MARK = 21,
	XFRMA_TFCPAD = 22,
	XFRMA_REPLAY_ESN_VAL = 23,
	XFRMA_SA_EXTRA_FLAGS = 24,
	XFRMA_PROTO = 25,
	XFRMA_ADDRESS_FILTER = 26,
	XFRMA_PAD = 27,
	XFRMA_OFFLOAD_DEV = 28,
	XFRMA_SET_MARK = 29,
	XFRMA_SET_MARK_MASK = 30,
	XFRMA_IF_ID = 31,
	XFRMA_MTIMER_THRESH = 32,
	__XFRMA_MAX = 33,
};

struct xfrm_mark {
	__u32 v;
	__u32 m;
};

struct xfrm_address_filter {
	xfrm_address_t saddr;
	xfrm_address_t daddr;
	__u16 family;
	__u8 splen;
	__u8 dplen;
};

struct xfrm_state_walk {
	struct list_head all;
	u8 state;
	u8 dying;
	u8 proto;
	u32 seq;
	struct xfrm_address_filter *filter;
};

enum xfrm_replay_mode {
	XFRM_REPLAY_MODE_LEGACY = 0,
	XFRM_REPLAY_MODE_BMP = 1,
	XFRM_REPLAY_MODE_ESN = 2,
};

struct xfrm_dev_offload {
	struct net_device *dev;
	netdevice_tracker dev_tracker;
	struct net_device *real_dev;
	long unsigned int offload_handle;
	u8 dir: 2;
	u8 type: 2;
	u8 flags: 2;
};

struct xfrm_mode {
	u8 encap;
	u8 family;
	u8 flags;
};

struct xfrm_type;

struct xfrm_type_offload;

struct xfrm_state {
	possible_net_t xs_net;
	union {
		struct hlist_node gclist;
		struct hlist_node bydst;
	};
	struct hlist_node bysrc;
	struct hlist_node byspi;
	struct hlist_node byseq;
	refcount_t refcnt;
	spinlock_t lock;
	struct xfrm_id id;
	struct xfrm_selector sel;
	struct xfrm_mark mark;
	u32 if_id;
	u32 tfcpad;
	u32 genid;
	struct xfrm_state_walk km;
	struct {
		u32 reqid;
		u8 mode;
		u8 replay_window;
		u8 aalgo;
		u8 ealgo;
		u8 calgo;
		u8 flags;
		u16 family;
		xfrm_address_t saddr;
		int header_len;
		int trailer_len;
		u32 extra_flags;
		struct xfrm_mark smark;
	} props;
	struct xfrm_lifetime_cfg lft;
	struct xfrm_algo_auth *aalg;
	struct xfrm_algo *ealg;
	struct xfrm_algo *calg;
	struct xfrm_algo_aead *aead;
	const char *geniv;
	__be16 new_mapping_sport;
	u32 new_mapping;
	u32 mapping_maxage;
	struct xfrm_encap_tmpl *encap;
	struct sock *encap_sk;
	xfrm_address_t *coaddr;
	struct xfrm_state *tunnel;
	atomic_t tunnel_users;
	struct xfrm_replay_state replay;
	struct xfrm_replay_state_esn *replay_esn;
	struct xfrm_replay_state preplay;
	struct xfrm_replay_state_esn *preplay_esn;
	enum xfrm_replay_mode repl_mode;
	u32 xflags;
	u32 replay_maxage;
	u32 replay_maxdiff;
	struct timer_list rtimer;
	struct xfrm_stats stats;
	struct xfrm_lifetime_cur curlft;
	struct hrtimer mtimer;
	struct xfrm_dev_offload xso;
	long int saved_tmo;
	time64_t lastused;
	struct page_frag xfrag;
	const struct xfrm_type *type;
	struct xfrm_mode inner_mode;
	struct xfrm_mode inner_mode_iaf;
	struct xfrm_mode outer_mode;
	const struct xfrm_type_offload *type_offload;
	struct xfrm_sec_ctx *security;
	void *data;
};

struct dst_metrics {
	u32 metrics[17];
	refcount_t refcnt;
};

struct xfrm_policy_walk_entry {
	struct list_head all;
	u8 dead;
};

struct xfrm_policy_queue {
	struct sk_buff_head hold_queue;
	struct timer_list hold_timer;
	long unsigned int timeout;
};

struct xfrm_tmpl {
	struct xfrm_id id;
	xfrm_address_t saddr;
	short unsigned int encap_family;
	u32 reqid;
	u8 mode;
	u8 share;
	u8 optional;
	u8 allalgs;
	u32 aalgos;
	u32 ealgos;
	u32 calgos;
};

struct xfrm_policy {
	possible_net_t xp_net;
	struct hlist_node bydst;
	struct hlist_node byidx;
	rwlock_t lock;
	refcount_t refcnt;
	u32 pos;
	struct timer_list timer;
	atomic_t genid;
	u32 priority;
	u32 index;
	u32 if_id;
	struct xfrm_mark mark;
	struct xfrm_selector selector;
	struct xfrm_lifetime_cfg lft;
	struct xfrm_lifetime_cur curlft;
	struct xfrm_policy_walk_entry walk;
	struct xfrm_policy_queue polq;
	bool bydst_reinsert;
	u8 type;
	u8 action;
	u8 flags;
	u8 xfrm_nr;
	u16 family;
	struct xfrm_sec_ctx *security;
	struct xfrm_tmpl xfrm_vec[6];
	struct hlist_node bydst_inexact_list;
	struct callback_head rcu;
	struct xfrm_dev_offload xdo;
};

struct fib_nh_exception {
	struct fib_nh_exception *fnhe_next;
	int fnhe_genid;
	__be32 fnhe_daddr;
	u32 fnhe_pmtu;
	bool fnhe_mtu_locked;
	__be32 fnhe_gw;
	long unsigned int fnhe_expires;
	struct rtable *fnhe_rth_input;
	struct rtable *fnhe_rth_output;
	long unsigned int fnhe_stamp;
	struct callback_head rcu;
};

struct rtable {
	struct dst_entry dst;
	int rt_genid;
	unsigned int rt_flags;
	__u16 rt_type;
	__u8 rt_is_input;
	__u8 rt_uses_gateway;
	int rt_iif;
	u8 rt_gw_family;
	union {
		__be32 rt_gw4;
		struct in6_addr rt_gw6;
	};
	u32 rt_mtu_locked: 1;
	u32 rt_pmtu: 31;
};

struct fnhe_hash_bucket {
	struct fib_nh_exception *chain;
};

struct selinux_policy;

struct selinux_state {
	bool enforcing;
	bool initialized;
	bool policycap[8];
	struct page *status_page;
	struct mutex status_lock;
	struct selinux_policy *policy;
	struct mutex policy_mutex;
};

struct hashtab_node;

struct hashtab {
	struct hashtab_node **htable;
	u32 size;
	u32 nel;
};

struct symtab {
	struct hashtab table;
	u32 nprim;
};

struct avtab_node;

struct avtab {
	struct avtab_node **htable;
	u32 nel;
	u32 nslot;
	u32 mask;
};

struct ebitmap_node;

struct ebitmap {
	struct ebitmap_node *node;
	u32 highbit;
};

struct class_datum;

struct role_datum;

struct user_datum;

struct type_datum;

struct cond_bool_datum;

struct cond_node;

struct role_allow;

struct ocontext;

struct genfs;

struct policydb {
	int mls_enabled;
	struct symtab symtab[8];
	char **sym_val_to_name[8];
	struct class_datum **class_val_to_struct;
	struct role_datum **role_val_to_struct;
	struct user_datum **user_val_to_struct;
	struct type_datum **type_val_to_struct;
	struct avtab te_avtab;
	struct hashtab role_tr;
	struct ebitmap filename_trans_ttypes;
	struct hashtab filename_trans;
	u32 compat_filename_trans_count;
	struct cond_bool_datum **bool_val_to_struct;
	struct avtab te_cond_avtab;
	struct cond_node *cond_list;
	u32 cond_list_len;
	struct role_allow *role_allow;
	struct ocontext *ocontexts[9];
	struct genfs *genfs;
	struct hashtab range_tr;
	struct ebitmap *type_attr_map_array;
	struct ebitmap policycaps;
	struct ebitmap permissive_map;
	size_t len;
	unsigned int policyvers;
	unsigned int reject_unknown: 1;
	unsigned int allow_unknown: 1;
	u16 process_class;
	u32 process_trans_perms;
};

struct selinux_mapping;

struct selinux_map {
	struct selinux_mapping *mapping;
	u16 size;
};

struct sidtab;

struct selinux_policy {
	struct sidtab *sidtab;
	struct policydb policydb;
	struct selinux_map map;
	u32 latest_granting;
};

struct selinux_policy_convert_data;

struct selinux_load_state {
	struct selinux_policy *policy;
	struct selinux_policy_convert_data *convert_data;
};

struct convert_context_args {
	struct policydb *oldp;
	struct policydb *newp;
};

struct sidtab_convert_params {
	struct convert_context_args *args;
	struct sidtab *target;
};

struct selinux_policy_convert_data {
	struct convert_context_args args;
	struct sidtab_convert_params sidtab_params;
};

struct av_decision {
	u32 allowed;
	u32 auditallow;
	u32 auditdeny;
	u32 seqno;
	u32 flags;
};

struct extended_perms_data {
	u32 p[8];
};

struct extended_perms_decision {
	u8 used;
	u8 driver;
	struct extended_perms_data *allowed;
	struct extended_perms_data *auditallow;
	struct extended_perms_data *dontaudit;
};

struct extended_perms {
	u16 len;
	struct extended_perms_data drivers;
};

struct security_class_mapping {
	const char *name;
	const char *perms[33];
};

struct ebitmap_node {
	struct ebitmap_node *next;
	long unsigned int maps[6];
	u32 startbit;
};

struct mls_level {
	u32 sens;
	struct ebitmap cat;
};

struct mls_range {
	struct mls_level level[2];
};

struct context {
	u32 user;
	u32 role;
	u32 type;
	u32 len;
	struct mls_range range;
	char *str;
};

struct hashtab_node {
	void *key;
	void *datum;
	struct hashtab_node *next;
};

struct avtab_key {
	u16 source_type;
	u16 target_type;
	u16 target_class;
	u16 specified;
};

struct avtab_extended_perms {
	u8 specified;
	u8 driver;
	struct extended_perms_data perms;
};

struct avtab_datum {
	union {
		u32 data;
		struct avtab_extended_perms *xperms;
	} u;
};

struct avtab_node {
	struct avtab_key key;
	struct avtab_datum datum;
	struct avtab_node *next;
};

struct sidtab_str_cache;

struct sidtab_entry {
	u32 sid;
	u32 hash;
	struct context context;
	struct sidtab_str_cache *cache;
	struct hlist_node list;
};

struct sidtab_node_inner;

struct sidtab_node_leaf;

union sidtab_entry_inner {
	struct sidtab_node_inner *ptr_inner;
	struct sidtab_node_leaf *ptr_leaf;
};

struct sidtab_node_inner {
	union sidtab_entry_inner entries[8192];
};

struct sidtab_node_leaf {
	struct sidtab_entry entries[630];
};

struct sidtab_isid_entry {
	int set;
	struct sidtab_entry entry;
};

struct sidtab {
	union sidtab_entry_inner roots[3];
	u32 count;
	struct sidtab_convert_params *convert;
	bool frozen;
	spinlock_t lock;
	u32 cache_free_slots;
	struct list_head cache_lru_list;
	spinlock_t cache_lock;
	struct sidtab_isid_entry isids[27];
	struct hlist_head context_to_sid[512];
};

struct type_set;

struct constraint_expr {
	u32 expr_type;
	u32 attr;
	u32 op;
	struct ebitmap names;
	struct type_set *type_names;
	struct constraint_expr *next;
};

struct type_set {
	struct ebitmap types;
	struct ebitmap negset;
	u32 flags;
};

struct constraint_node {
	u32 permissions;
	struct constraint_expr *expr;
	struct constraint_node *next;
};

struct perm_datum {
	u32 value;
};

struct common_datum {
	u32 value;
	struct symtab permissions;
};

struct class_datum {
	u32 value;
	char *comkey;
	struct common_datum *comdatum;
	struct symtab permissions;
	struct constraint_node *constraints;
	struct constraint_node *validatetrans;
	char default_user;
	char default_role;
	char default_type;
	char default_range;
};

struct role_datum {
	u32 value;
	u32 bounds;
	struct ebitmap dominates;
	struct ebitmap types;
};

struct role_trans_key {
	u32 role;
	u32 type;
	u32 tclass;
};

struct role_trans_datum {
	u32 new_role;
};

struct filename_trans_key {
	u32 ttype;
	u16 tclass;
	const char *name;
};

struct filename_trans_datum {
	struct ebitmap stypes;
	u32 otype;
	struct filename_trans_datum *next;
};

struct role_allow {
	u32 role;
	u32 new_role;
	struct role_allow *next;
};

struct type_datum {
	u32 value;
	u32 bounds;
	unsigned char primary;
	unsigned char attribute;
};

struct user_datum {
	u32 value;
	u32 bounds;
	struct ebitmap roles;
	struct mls_range range;
	struct mls_level dfltlevel;
};

struct cond_bool_datum {
	__u32 value;
	int state;
};

struct ocontext {
	union {
		char *name;
		struct {
			u8 protocol;
			u16 low_port;
			u16 high_port;
		} port;
		struct {
			u32 addr;
			u32 mask;
		} node;
		struct {
			u32 addr[4];
			u32 mask[4];
		} node6;
		struct {
			u64 subnet_prefix;
			u16 low_pkey;
			u16 high_pkey;
		} ibpkey;
		struct {
			char *dev_name;
			u8 port;
		} ibendport;
	} u;
	union {
		u32 sclass;
		u32 behavior;
	} v;
	struct context context[2];
	u32 sid[2];
	struct ocontext *next;
};

struct genfs {
	char *fstype;
	struct ocontext *head;
	struct genfs *next;
};

struct cond_expr_node;

struct cond_expr {
	struct cond_expr_node *nodes;
	u32 len;
};

struct cond_av_list {
	struct avtab_node **nodes;
	u32 len;
};

struct cond_node {
	int cur_state;
	struct cond_expr expr;
	struct cond_av_list true_list;
	struct cond_av_list false_list;
};

struct policy_file {
	char *data;
	size_t len;
};

struct selinux_mapping {
	u16 value;
	u16 num_perms;
	u32 perms[32];
};

struct cond_expr_node {
	u32 expr_type;
	u32 boolean;
};

struct superblock_security_struct {
	u32 sid;
	u32 def_sid;
	u32 mntpoint_sid;
	short unsigned int behavior;
	short unsigned int flags;
	struct mutex lock;
	struct list_head isec_head;
	spinlock_t isec_lock;
};

enum sctp_msg_flags {
	MSG_NOTIFICATION = 32768,
};

enum sctp_cid {
	SCTP_CID_DATA = 0,
	SCTP_CID_INIT = 1,
	SCTP_CID_INIT_ACK = 2,
	SCTP_CID_SACK = 3,
	SCTP_CID_HEARTBEAT = 4,
	SCTP_CID_HEARTBEAT_ACK = 5,
	SCTP_CID_ABORT = 6,
	SCTP_CID_SHUTDOWN = 7,
	SCTP_CID_SHUTDOWN_ACK = 8,
	SCTP_CID_ERROR = 9,
	SCTP_CID_COOKIE_ECHO = 10,
	SCTP_CID_COOKIE_ACK = 11,
	SCTP_CID_ECN_ECNE = 12,
	SCTP_CID_ECN_CWR = 13,
	SCTP_CID_SHUTDOWN_COMPLETE = 14,
	SCTP_CID_AUTH = 15,
	SCTP_CID_I_DATA = 64,
	SCTP_CID_FWD_TSN = 192,
	SCTP_CID_ASCONF = 193,
	SCTP_CID_I_FWD_TSN = 194,
	SCTP_CID_ASCONF_ACK = 128,
	SCTP_CID_RECONF = 130,
	SCTP_CID_PAD = 132,
};

enum {
	SCTP_MAX_STREAM = 65535,
};

enum sctp_event_timeout {
	SCTP_EVENT_TIMEOUT_NONE = 0,
	SCTP_EVENT_TIMEOUT_T1_COOKIE = 1,
	SCTP_EVENT_TIMEOUT_T1_INIT = 2,
	SCTP_EVENT_TIMEOUT_T2_SHUTDOWN = 3,
	SCTP_EVENT_TIMEOUT_T3_RTX = 4,
	SCTP_EVENT_TIMEOUT_T4_RTO = 5,
	SCTP_EVENT_TIMEOUT_T5_SHUTDOWN_GUARD = 6,
	SCTP_EVENT_TIMEOUT_HEARTBEAT = 7,
	SCTP_EVENT_TIMEOUT_RECONF = 8,
	SCTP_EVENT_TIMEOUT_PROBE = 9,
	SCTP_EVENT_TIMEOUT_SACK = 10,
	SCTP_EVENT_TIMEOUT_AUTOCLOSE = 11,
};

enum {
	SCTP_MAX_DUP_TSNS = 16,
};

enum {
	SCTP_AUTH_HMAC_ID_RESERVED_0 = 0,
	SCTP_AUTH_HMAC_ID_SHA1 = 1,
	SCTP_AUTH_HMAC_ID_RESERVED_2 = 2,
	SCTP_AUTH_HMAC_ID_SHA256 = 3,
	__SCTP_AUTH_HMAC_MAX = 4,
};

struct rt6_exception_bucket {
	struct hlist_head chain;
	int depth;
};

struct xfrm_type {
	struct module *owner;
	u8 proto;
	u8 flags;
	int (*init_state)(struct xfrm_state *, struct netlink_ext_ack *);
	void (*destructor)(struct xfrm_state *);
	int (*input)(struct xfrm_state *, struct sk_buff *);
	int (*output)(struct xfrm_state *, struct sk_buff *);
	int (*reject)(struct xfrm_state *, struct sk_buff *, const struct flowi *);
};

struct xfrm_type_offload {
	struct module *owner;
	u8 proto;
	void (*encap)(struct xfrm_state *, struct sk_buff *);
	int (*input_tail)(struct xfrm_state *, struct sk_buff *);
	int (*xmit)(struct xfrm_state *, struct sk_buff *, netdev_features_t);
};

struct selinux_audit_rule {
	u32 au_seqno;
	struct context au_ctxt;
};

typedef u16 access_mask_t;

struct landlock_hierarchy {
	struct landlock_hierarchy *parent;
	refcount_t usage;
};

struct landlock_ruleset {
	struct rb_root root;
	struct landlock_hierarchy *hierarchy;
	union {
		struct work_struct work_free;
		struct {
			struct mutex lock;
			refcount_t usage;
			u32 num_rules;
			u32 num_layers;
			access_mask_t fs_access_masks[0];
		};
	};
};

struct landlock_cred_security {
	struct landlock_ruleset *domain;
};

struct modsig;

struct hwrng {
	const char *name;
	int (*init)(struct hwrng *);
	void (*cleanup)(struct hwrng *);
	int (*data_present)(struct hwrng *, int);
	int (*data_read)(struct hwrng *, u32 *);
	int (*read)(struct hwrng *, void *, size_t, bool);
	long unsigned int priv;
	short unsigned int quality;
	struct list_head list;
	struct kref ref;
	struct completion cleanup_done;
	struct completion dying;
};

struct tpm_digest {
	u16 alg_id;
	u8 digest[64];
};

struct tpm_bank_info {
	u16 alg_id;
	u16 digest_size;
	u16 crypto_id;
};

struct tpm_chip;

struct tpm_class_ops {
	unsigned int flags;
	const u8 req_complete_mask;
	const u8 req_complete_val;
	bool (*req_canceled)(struct tpm_chip *, u8);
	int (*recv)(struct tpm_chip *, u8 *, size_t);
	int (*send)(struct tpm_chip *, u8 *, size_t);
	void (*cancel)(struct tpm_chip *);
	u8 (*status)(struct tpm_chip *);
	void (*update_timeouts)(struct tpm_chip *, long unsigned int *);
	void (*update_durations)(struct tpm_chip *, long unsigned int *);
	int (*go_idle)(struct tpm_chip *);
	int (*cmd_ready)(struct tpm_chip *);
	int (*request_locality)(struct tpm_chip *, int);
	int (*relinquish_locality)(struct tpm_chip *, int);
	void (*clk_enable)(struct tpm_chip *, bool);
};

struct tpm_bios_log {
	void *bios_event_log;
	void *bios_event_log_end;
};

struct tpm_chip_seqops {
	struct tpm_chip *chip;
	const struct seq_operations *seqops;
};

struct tpm_space {
	u32 context_tbl[3];
	u8 *context_buf;
	u32 session_tbl[3];
	u8 *session_buf;
	u32 buf_size;
};

struct tpm_chip {
	struct device dev;
	struct device devs;
	struct cdev cdev;
	struct cdev cdevs;
	struct rw_semaphore ops_sem;
	const struct tpm_class_ops *ops;
	struct tpm_bios_log log;
	struct tpm_chip_seqops bin_log_seqops;
	struct tpm_chip_seqops ascii_log_seqops;
	unsigned int flags;
	int dev_num;
	long unsigned int is_open;
	char hwrng_name[64];
	struct hwrng hwrng;
	struct mutex tpm_mutex;
	long unsigned int timeout_a;
	long unsigned int timeout_b;
	long unsigned int timeout_c;
	long unsigned int timeout_d;
	bool timeout_adjusted;
	long unsigned int duration[4];
	bool duration_adjusted;
	struct dentry *bios_dir[3];
	const struct attribute_group *groups[8];
	unsigned int groups_cnt;
	u32 nr_allocated_banks;
	struct tpm_bank_info *allocated_banks;
	struct tpm_space work_space;
	u32 last_cc;
	u32 nr_commands;
	u32 *cc_attrs_tbl;
	int locality;
};

enum integrity_status {
	INTEGRITY_PASS = 0,
	INTEGRITY_PASS_IMMUTABLE = 1,
	INTEGRITY_FAIL = 2,
	INTEGRITY_FAIL_IMMUTABLE = 3,
	INTEGRITY_NOLABEL = 4,
	INTEGRITY_NOXATTRS = 5,
	INTEGRITY_UNKNOWN = 6,
};

struct evm_ima_xattr_data {
	u8 type;
	u8 data[0];
};

struct ima_digest_data {
	u8 algo;
	u8 length;
	union {
		struct {
			u8 unused;
			u8 type;
		} sha1;
		struct {
			u8 type;
			u8 algo;
		} ng;
		u8 data[2];
	} xattr;
	u8 digest[0];
};

struct ima_max_digest_data {
	struct ima_digest_data hdr;
	u8 digest[64];
};

struct integrity_iint_cache {
	struct rb_node rb_node;
	struct mutex mutex;
	struct inode *inode;
	u64 version;
	long unsigned int flags;
	long unsigned int measured_pcrs;
	long unsigned int atomic_flags;
	enum integrity_status ima_file_status: 4;
	enum integrity_status ima_mmap_status: 4;
	enum integrity_status ima_bprm_status: 4;
	enum integrity_status ima_read_status: 4;
	enum integrity_status ima_creds_status: 4;
	enum integrity_status evm_status: 4;
	struct ima_digest_data *ima_hash;
};

enum ima_show_type {
	IMA_SHOW_BINARY = 0,
	IMA_SHOW_BINARY_NO_FIELD_LEN = 1,
	IMA_SHOW_BINARY_OLD_STRING_FMT = 2,
	IMA_SHOW_ASCII = 3,
};

struct ima_event_data {
	struct integrity_iint_cache *iint;
	struct file *file;
	const unsigned char *filename;
	struct evm_ima_xattr_data *xattr_value;
	int xattr_len;
	const struct modsig *modsig;
	const char *violation;
	const void *buf;
	int buf_len;
};

struct ima_field_data {
	u8 *data;
	u32 len;
};

struct ima_template_field {
	const char field_id[16];
	int (*field_init)(struct ima_event_data *, struct ima_field_data *);
	void (*field_show)(struct seq_file *, enum ima_show_type, struct ima_field_data *);
};

struct ima_template_desc {
	struct list_head list;
	char *name;
	char *fmt;
	int num_fields;
	const struct ima_template_field **fields;
};

struct ima_template_entry {
	int pcr;
	struct tpm_digest *digests;
	struct ima_template_desc *template_desc;
	u32 template_data_len;
	struct ima_field_data template_data[0];
};

struct module_signature {
	u8 algo;
	u8 hash;
	u8 id_type;
	u8 signer_len;
	u8 key_id_len;
	u8 __pad[3];
	__be32 sig_len;
};

enum hash_algo {
	HASH_ALGO_MD4 = 0,
	HASH_ALGO_MD5 = 1,
	HASH_ALGO_SHA1 = 2,
	HASH_ALGO_RIPE_MD_160 = 3,
	HASH_ALGO_SHA256 = 4,
	HASH_ALGO_SHA384 = 5,
	HASH_ALGO_SHA512 = 6,
	HASH_ALGO_SHA224 = 7,
	HASH_ALGO_RIPE_MD_128 = 8,
	HASH_ALGO_RIPE_MD_256 = 9,
	HASH_ALGO_RIPE_MD_320 = 10,
	HASH_ALGO_WP_256 = 11,
	HASH_ALGO_WP_384 = 12,
	HASH_ALGO_WP_512 = 13,
	HASH_ALGO_TGR_128 = 14,
	HASH_ALGO_TGR_160 = 15,
	HASH_ALGO_TGR_192 = 16,
	HASH_ALGO_SM3_256 = 17,
	HASH_ALGO_STREEBOG_256 = 18,
	HASH_ALGO_STREEBOG_512 = 19,
	HASH_ALGO__LAST = 20,
};

struct pkcs7_message;

struct modsig {
	struct pkcs7_message *pkcs7_msg;
	enum hash_algo hash_algo;
	const u8 *digest;
	u32 digest_size;
	int raw_pkcs7_len;
	u8 raw_pkcs7[0];
};

enum ima_hooks {
	NONE = 0,
	FILE_CHECK = 1,
	MMAP_CHECK = 2,
	MMAP_CHECK_REQPROT = 3,
	BPRM_CHECK = 4,
	CREDS_CHECK = 5,
	POST_SETATTR = 6,
	MODULE_CHECK = 7,
	FIRMWARE_CHECK = 8,
	KEXEC_KERNEL_CHECK = 9,
	KEXEC_INITRAMFS_CHECK = 10,
	POLICY_CHECK = 11,
	KEXEC_CMDLINE = 12,
	KEY_CHECK = 13,
	CRITICAL_DATA = 14,
	SETXATTR_CHECK = 15,
	MAX_CHECK = 16,
};

struct scatter_walk {
	struct scatterlist *sg;
	unsigned int offset;
};

typedef void (*crypto_completion_t)(void *, int);

struct crypto_async_request {
	struct list_head list;
	crypto_completion_t complete;
	void *data;
	struct crypto_tfm *tfm;
	u32 flags;
};

struct crypto_wait {
	struct completion completion;
	int err;
};

struct akcipher_request {
	struct crypto_async_request base;
	struct scatterlist *src;
	struct scatterlist *dst;
	unsigned int src_len;
	unsigned int dst_len;
	void *__ctx[0];
};

struct crypto_akcipher {
	unsigned int reqsize;
	struct crypto_tfm base;
};

struct akcipher_alg {
	int (*sign)(struct akcipher_request *);
	int (*verify)(struct akcipher_request *);
	int (*encrypt)(struct akcipher_request *);
	int (*decrypt)(struct akcipher_request *);
	int (*set_pub_key)(struct crypto_akcipher *, const void *, unsigned int);
	int (*set_priv_key)(struct crypto_akcipher *, const void *, unsigned int);
	unsigned int (*max_size)(struct crypto_akcipher *);
	int (*init)(struct crypto_akcipher *);
	void (*exit)(struct crypto_akcipher *);
	struct crypto_alg base;
};

struct crypto_template;

struct crypto_spawn;

struct crypto_instance {
	struct crypto_alg alg;
	struct crypto_template *tmpl;
	union {
		struct hlist_node list;
		struct crypto_spawn *spawns;
	};
	struct work_struct free_work;
	void *__ctx[0];
};

struct crypto_spawn {
	struct list_head list;
	struct crypto_alg *alg;
	union {
		struct crypto_instance *inst;
		struct crypto_spawn *next;
	};
	const struct crypto_type *frontend;
	u32 mask;
	bool dead;
	bool registered;
};

struct rtattr;

struct crypto_template {
	struct list_head list;
	struct hlist_head instances;
	struct module *module;
	int (*create)(struct crypto_template *, struct rtattr **);
	char name[128];
};

struct crypto_sig {
	struct crypto_tfm base;
};

struct crypto_akcipher_sync_data {
	struct crypto_akcipher *tfm;
	const void *src;
	void *dst;
	unsigned int slen;
	unsigned int dlen;
	struct akcipher_request *req;
	struct crypto_wait cwait;
	struct scatterlist sg;
	u8 *buf;
};

struct hash_alg_common {
	unsigned int digestsize;
	unsigned int statesize;
	struct crypto_alg base;
};

struct shash_alg {
	int (*init)(struct shash_desc *);
	int (*update)(struct shash_desc *, const u8 *, unsigned int);
	int (*final)(struct shash_desc *, u8 *);
	int (*finup)(struct shash_desc *, const u8 *, unsigned int, u8 *);
	int (*digest)(struct shash_desc *, const u8 *, unsigned int, u8 *);
	int (*export)(struct shash_desc *, void *);
	int (*import)(struct shash_desc *, const void *);
	int (*setkey)(struct crypto_shash *, const u8 *, unsigned int);
	int (*init_tfm)(struct crypto_shash *);
	void (*exit_tfm)(struct crypto_shash *);
	int (*clone_tfm)(struct crypto_shash *, struct crypto_shash *);
	unsigned int descsize;
	union {
		struct {
			unsigned int digestsize;
			unsigned int statesize;
			struct crypto_alg base;
		};
		struct hash_alg_common halg;
	};
};

struct shash_instance {
	void (*free)(struct shash_instance *);
	union {
		struct {
			char head[104];
			struct crypto_instance base;
		} s;
		struct shash_alg alg;
	};
};

struct crypto_shash_spawn {
	struct crypto_spawn base;
};

struct hmac_ctx {
	struct crypto_shash *hash;
};

struct crypto_istat_rng {
	atomic64_t generate_cnt;
	atomic64_t generate_tlen;
	atomic64_t seed_cnt;
	atomic64_t err_cnt;
};

struct crypto_rng;

struct rng_alg {
	int (*generate)(struct crypto_rng *, const u8 *, unsigned int, u8 *, unsigned int);
	int (*seed)(struct crypto_rng *, const u8 *, unsigned int);
	void (*set_ent)(struct crypto_rng *, const u8 *, unsigned int);
	unsigned int seedsize;
	struct crypto_alg base;
};

struct crypto_rng {
	struct crypto_tfm base;
};

struct io_cq {
	struct request_queue *q;
	struct io_context *ioc;
	union {
		struct list_head q_node;
		struct kmem_cache *__rcu_icq_cache;
	};
	union {
		struct hlist_node ioc_node;
		struct callback_head __rcu_head;
	};
	unsigned int flags;
};

struct sbitmap_word {
	long unsigned int word;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long unsigned int cleared;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct sbitmap {
	unsigned int depth;
	unsigned int shift;
	unsigned int map_nr;
	bool round_robin;
	struct sbitmap_word *map;
	unsigned int *alloc_hint;
};

struct sbq_wait_state {
	wait_queue_head_t wait;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct sbitmap_queue {
	struct sbitmap sb;
	unsigned int wake_batch;
	atomic_t wake_index;
	struct sbq_wait_state *ws;
	atomic_t ws_active;
	unsigned int min_shallow_depth;
	atomic_t completion_cnt;
	atomic_t wakeup_cnt;
};

enum {
	DISK_EVENT_MEDIA_CHANGE = 1,
	DISK_EVENT_EJECT_REQUEST = 2,
};

enum {
	DISK_EVENT_FLAG_POLL = 1,
	DISK_EVENT_FLAG_UEVENT = 2,
	DISK_EVENT_FLAG_BLOCK_ON_EXCL_WRITE = 4,
};

typedef __u32 req_flags_t;

enum mq_rq_state {
	MQ_RQ_IDLE = 0,
	MQ_RQ_IN_FLIGHT = 1,
	MQ_RQ_COMPLETE = 2,
};

enum rq_end_io_ret {
	RQ_END_IO_NONE = 0,
	RQ_END_IO_FREE = 1,
};

typedef enum rq_end_io_ret rq_end_io_fn(struct request *, blk_status_t);

struct request {
	struct request_queue *q;
	struct blk_mq_ctx *mq_ctx;
	struct blk_mq_hw_ctx *mq_hctx;
	blk_opf_t cmd_flags;
	req_flags_t rq_flags;
	int tag;
	int internal_tag;
	unsigned int timeout;
	unsigned int __data_len;
	sector_t __sector;
	struct bio *bio;
	struct bio *biotail;
	union {
		struct list_head queuelist;
		struct request *rq_next;
	};
	struct block_device *part;
	u64 start_time_ns;
	u64 io_start_time_ns;
	short unsigned int stats_sectors;
	short unsigned int nr_phys_segments;
	short unsigned int ioprio;
	enum mq_rq_state state;
	atomic_t ref;
	long unsigned int deadline;
	union {
		struct hlist_node hash;
		struct llist_node ipi_list;
	};
	union {
		struct rb_node rb_node;
		struct bio_vec special_vec;
	};
	struct {
		struct io_cq *icq;
		void *priv[2];
	} elv;
	struct {
		unsigned int seq;
		rq_end_io_fn *saved_end_io;
	} flush;
	u64 fifo_time;
	rq_end_io_fn *end_io;
	void *end_io_data;
};

struct blk_mq_tags {
	unsigned int nr_tags;
	unsigned int nr_reserved_tags;
	unsigned int active_queues;
	struct sbitmap_queue bitmap_tags;
	struct sbitmap_queue breserved_tags;
	struct request **rqs;
	struct request **static_rqs;
	struct list_head page_list;
	spinlock_t lock;
};

struct blk_flush_queue {
	spinlock_t mq_flush_lock;
	unsigned int flush_pending_idx: 1;
	unsigned int flush_running_idx: 1;
	blk_status_t rq_status;
	long unsigned int flush_pending_since;
	struct list_head flush_queue[2];
	long unsigned int flush_data_in_flight;
	struct request *flush_rq;
};

struct blk_mq_queue_map {
	unsigned int *mq_map;
	unsigned int nr_queues;
	unsigned int queue_offset;
};

struct blk_mq_tag_set {
	const struct blk_mq_ops *ops;
	struct blk_mq_queue_map map[3];
	unsigned int nr_maps;
	unsigned int nr_hw_queues;
	unsigned int queue_depth;
	unsigned int reserved_tags;
	unsigned int cmd_size;
	int numa_node;
	unsigned int timeout;
	unsigned int flags;
	void *driver_data;
	struct blk_mq_tags **tags;
	struct blk_mq_tags *shared_tags;
	struct mutex tag_list_lock;
	struct list_head tag_list;
	struct srcu_struct *srcu;
};

struct blk_mq_hw_ctx {
	struct {
		spinlock_t lock;
		struct list_head dispatch;
		long unsigned int state;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
	};
	struct delayed_work run_work;
	cpumask_var_t cpumask;
	int next_cpu;
	int next_cpu_batch;
	long unsigned int flags;
	void *sched_data;
	struct request_queue *queue;
	struct blk_flush_queue *fq;
	void *driver_data;
	struct sbitmap ctx_map;
	struct blk_mq_ctx *dispatch_from;
	unsigned int dispatch_busy;
	short unsigned int type;
	short unsigned int nr_ctx;
	struct blk_mq_ctx **ctxs;
	spinlock_t dispatch_wait_lock;
	wait_queue_entry_t dispatch_wait;
	atomic_t wait_index;
	struct blk_mq_tags *tags;
	struct blk_mq_tags *sched_tags;
	long unsigned int run;
	unsigned int numa_node;
	unsigned int queue_num;
	atomic_t nr_active;
	struct hlist_node cpuhp_online;
	struct hlist_node cpuhp_dead;
	struct kobject kobj;
	struct dentry *debugfs_dir;
	struct dentry *sched_debugfs_dir;
	struct list_head hctx_list;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct blk_mq_queue_data {
	struct request *rq;
	bool last;
};

struct bdev_inode {
	struct block_device bdev;
	struct inode vfs_inode;
};

enum {
	IOPRIO_CLASS_NONE = 0,
	IOPRIO_CLASS_RT = 1,
	IOPRIO_CLASS_BE = 2,
	IOPRIO_CLASS_IDLE = 3,
	IOPRIO_CLASS_INVALID = 7,
};

enum {
	IOPRIO_HINT_NONE = 0,
	IOPRIO_HINT_DEV_DURATION_LIMIT_1 = 1,
	IOPRIO_HINT_DEV_DURATION_LIMIT_2 = 2,
	IOPRIO_HINT_DEV_DURATION_LIMIT_3 = 3,
	IOPRIO_HINT_DEV_DURATION_LIMIT_4 = 4,
	IOPRIO_HINT_DEV_DURATION_LIMIT_5 = 5,
	IOPRIO_HINT_DEV_DURATION_LIMIT_6 = 6,
	IOPRIO_HINT_DEV_DURATION_LIMIT_7 = 7,
};

typedef __u32 blk_mq_req_flags_t;

struct elevator_type;

struct elevator_queue {
	struct elevator_type *type;
	void *elevator_data;
	struct kobject kobj;
	struct mutex sysfs_lock;
	long unsigned int flags;
	struct hlist_head hash[64];
};

struct blk_mq_ctxs;

struct blk_mq_ctx {
	struct {
		spinlock_t lock;
		struct list_head rq_lists[3];
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
	};
	unsigned int cpu;
	short unsigned int index_hw[3];
	struct blk_mq_hw_ctx *hctxs[3];
	struct request_queue *queue;
	struct blk_mq_ctxs *ctxs;
	struct kobject kobj;
	long: 64;
};

enum hctx_type {
	HCTX_TYPE_DEFAULT = 0,
	HCTX_TYPE_READ = 1,
	HCTX_TYPE_POLL = 2,
	HCTX_MAX_TYPES = 3,
};

struct blk_mq_ctxs {
	struct kobject kobj;
	struct blk_mq_ctx *queue_ctx;
};

typedef unsigned int blk_insert_t;

struct blk_mq_alloc_data {
	struct request_queue *q;
	blk_mq_req_flags_t flags;
	unsigned int shallow_depth;
	blk_opf_t cmd_flags;
	req_flags_t rq_flags;
	unsigned int nr_tags;
	struct request **cached_rq;
	struct blk_mq_ctx *ctx;
	struct blk_mq_hw_ctx *hctx;
};

enum elv_merge {
	ELEVATOR_NO_MERGE = 0,
	ELEVATOR_FRONT_MERGE = 1,
	ELEVATOR_BACK_MERGE = 2,
	ELEVATOR_DISCARD_MERGE = 3,
};

struct elevator_mq_ops {
	int (*init_sched)(struct request_queue *, struct elevator_type *);
	void (*exit_sched)(struct elevator_queue *);
	int (*init_hctx)(struct blk_mq_hw_ctx *, unsigned int);
	void (*exit_hctx)(struct blk_mq_hw_ctx *, unsigned int);
	void (*depth_updated)(struct blk_mq_hw_ctx *);
	bool (*allow_merge)(struct request_queue *, struct request *, struct bio *);
	bool (*bio_merge)(struct request_queue *, struct bio *, unsigned int);
	int (*request_merge)(struct request_queue *, struct request **, struct bio *);
	void (*request_merged)(struct request_queue *, struct request *, enum elv_merge);
	void (*requests_merged)(struct request_queue *, struct request *, struct request *);
	void (*limit_depth)(blk_opf_t, struct blk_mq_alloc_data *);
	void (*prepare_request)(struct request *);
	void (*finish_request)(struct request *);
	void (*insert_requests)(struct blk_mq_hw_ctx *, struct list_head *, blk_insert_t);
	struct request * (*dispatch_request)(struct blk_mq_hw_ctx *);
	bool (*has_work)(struct blk_mq_hw_ctx *);
	void (*completed_request)(struct request *, u64);
	void (*requeue_request)(struct request *);
	struct request * (*former_request)(struct request_queue *, struct request *);
	struct request * (*next_request)(struct request_queue *, struct request *);
	void (*init_icq)(struct io_cq *);
	void (*exit_icq)(struct io_cq *);
};

struct elv_fs_entry;

struct blk_mq_debugfs_attr;

struct elevator_type {
	struct kmem_cache *icq_cache;
	struct elevator_mq_ops ops;
	size_t icq_size;
	size_t icq_align;
	struct elv_fs_entry *elevator_attrs;
	const char *elevator_name;
	const char *elevator_alias;
	const unsigned int elevator_features;
	struct module *elevator_owner;
	const struct blk_mq_debugfs_attr *queue_debugfs_attrs;
	const struct blk_mq_debugfs_attr *hctx_debugfs_attrs;
	char icq_cache_name[22];
	struct list_head list;
};

struct elv_fs_entry {
	struct attribute attr;
	ssize_t (*show)(struct elevator_queue *, char *);
	ssize_t (*store)(struct elevator_queue *, const char *, size_t);
};

struct blk_mq_debugfs_attr {
	const char *name;
	umode_t mode;
	int (*show)(void *, struct seq_file *);
	ssize_t (*write)(void *, const char *, size_t, loff_t *);
	const struct seq_operations *seq_ops;
};

enum req_op {
	REQ_OP_READ = 0,
	REQ_OP_WRITE = 1,
	REQ_OP_FLUSH = 2,
	REQ_OP_DISCARD = 3,
	REQ_OP_SECURE_ERASE = 5,
	REQ_OP_WRITE_ZEROES = 9,
	REQ_OP_ZONE_OPEN = 10,
	REQ_OP_ZONE_CLOSE = 11,
	REQ_OP_ZONE_FINISH = 12,
	REQ_OP_ZONE_APPEND = 13,
	REQ_OP_ZONE_RESET = 15,
	REQ_OP_ZONE_RESET_ALL = 17,
	REQ_OP_DRV_IN = 34,
	REQ_OP_DRV_OUT = 35,
	REQ_OP_LAST = 36,
};

struct blk_rq_stat {
	u64 mean;
	u64 min;
	u64 max;
	u32 nr_samples;
	u64 batch;
};

struct blk_queue_stats {
	struct list_head callbacks;
	spinlock_t lock;
	int accounting;
};

struct blk_stat_callback {
	struct list_head list;
	struct timer_list timer;
	struct blk_rq_stat *cpu_stat;
	int (*bucket_fn)(const struct request *);
	unsigned int buckets;
	struct blk_rq_stat *stat;
	void (*timer_fn)(struct blk_stat_callback *);
	void *data;
	struct callback_head rcu;
};

struct badblocks {
	struct device *dev;
	int count;
	int unacked_exist;
	int shift;
	u64 *page;
	int changed;
	seqlock_t lock;
	sector_t sector;
	sector_t size;
};

enum rq_qos_id {
	RQ_QOS_WBT = 0,
	RQ_QOS_LATENCY = 1,
	RQ_QOS_COST = 2,
};

struct rq_qos_ops;

struct rq_qos {
	const struct rq_qos_ops *ops;
	struct gendisk *disk;
	enum rq_qos_id id;
	struct rq_qos *next;
	struct dentry *debugfs_dir;
};

struct rq_wait {
	wait_queue_head_t wait;
	atomic_t inflight;
};

struct rq_qos_ops {
	void (*throttle)(struct rq_qos *, struct bio *);
	void (*track)(struct rq_qos *, struct request *, struct bio *);
	void (*merge)(struct rq_qos *, struct request *, struct bio *);
	void (*issue)(struct rq_qos *, struct request *);
	void (*requeue)(struct rq_qos *, struct request *);
	void (*done)(struct rq_qos *, struct request *);
	void (*done_bio)(struct rq_qos *, struct bio *);
	void (*cleanup)(struct rq_qos *, struct bio *);
	void (*queue_depth_changed)(struct rq_qos *);
	void (*exit)(struct rq_qos *);
	const struct blk_mq_debugfs_attr *debugfs_attrs;
};

struct rq_depth {
	unsigned int max_depth;
	int scale_step;
	bool scaled_max;
	unsigned int queue_depth;
	unsigned int default_depth;
};

typedef bool acquire_inflight_cb_t(struct rq_wait *, void *);

typedef void cleanup_cb_t(struct rq_wait *, void *);

struct rq_qos_wait_data {
	struct wait_queue_entry wq;
	struct task_struct *task;
	struct rq_wait *rqw;
	acquire_inflight_cb_t *cb;
	void *private_data;
	bool got_token;
};

typedef bool (*sb_for_each_fn)(struct sbitmap *, unsigned int, void *);

struct sbq_wait {
	struct sbitmap_queue *sbq;
	struct wait_queue_entry wait;
};

struct rchan;

struct blk_trace {
	int trace_state;
	struct rchan *rchan;
	long unsigned int *sequence;
	unsigned char *msg_data;
	u16 act_mask;
	u64 start_lba;
	u64 end_lba;
	u32 pid;
	u32 dev;
	struct dentry *dir;
	struct list_head running_list;
	atomic_t dropped;
};

struct rchan_buf {
	void *start;
	void *data;
	size_t offset;
	size_t subbufs_produced;
	size_t subbufs_consumed;
	struct rchan *chan;
	wait_queue_head_t read_wait;
	struct irq_work wakeup_work;
	struct dentry *dentry;
	struct kref kref;
	struct page **page_array;
	unsigned int page_count;
	unsigned int finalized;
	size_t *padding;
	size_t prev_padding;
	size_t bytes_consumed;
	size_t early_bytes;
	unsigned int cpu;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct rchan_callbacks;

struct rchan {
	u32 version;
	size_t subbuf_size;
	size_t n_subbufs;
	size_t alloc_size;
	const struct rchan_callbacks *cb;
	struct kref kref;
	void *private_data;
	size_t last_toobig;
	struct rchan_buf **buf;
	int is_global;
	struct list_head list;
	struct dentry *parent;
	int has_base_filename;
	char base_filename[255];
};

struct rchan_callbacks {
	int (*subbuf_start)(struct rchan_buf *, void *, void *, size_t);
	struct dentry * (*create_buf_file)(const char *, struct dentry *, umode_t, struct rchan_buf *, int *);
	int (*remove_buf_file)(struct dentry *);
};

enum blktrace_act {
	__BLK_TA_QUEUE = 1,
	__BLK_TA_BACKMERGE = 2,
	__BLK_TA_FRONTMERGE = 3,
	__BLK_TA_GETRQ = 4,
	__BLK_TA_SLEEPRQ = 5,
	__BLK_TA_REQUEUE = 6,
	__BLK_TA_ISSUE = 7,
	__BLK_TA_COMPLETE = 8,
	__BLK_TA_PLUG = 9,
	__BLK_TA_UNPLUG_IO = 10,
	__BLK_TA_UNPLUG_TIMER = 11,
	__BLK_TA_INSERT = 12,
	__BLK_TA_SPLIT = 13,
	__BLK_TA_BOUNCE = 14,
	__BLK_TA_REMAP = 15,
	__BLK_TA_ABORT = 16,
	__BLK_TA_DRV_DATA = 17,
	__BLK_TA_CGROUP = 256,
};

struct trace_event_raw_kyber_latency {
	struct trace_entry ent;
	dev_t dev;
	char domain[16];
	char type[8];
	u8 percentile;
	u8 numerator;
	u8 denominator;
	unsigned int samples;
	char __data[0];
};

struct trace_event_raw_kyber_adjust {
	struct trace_entry ent;
	dev_t dev;
	char domain[16];
	unsigned int depth;
	char __data[0];
};

struct trace_event_raw_kyber_throttled {
	struct trace_entry ent;
	dev_t dev;
	char domain[16];
	char __data[0];
};

struct trace_event_data_offsets_kyber_latency {};

struct trace_event_data_offsets_kyber_adjust {};

struct trace_event_data_offsets_kyber_throttled {};

typedef void (*btf_trace_kyber_latency)(void *, dev_t, const char *, const char *, unsigned int, unsigned int, unsigned int, unsigned int);

typedef void (*btf_trace_kyber_adjust)(void *, dev_t, const char *, unsigned int);

typedef void (*btf_trace_kyber_throttled)(void *, dev_t, const char *);

enum {
	KYBER_READ = 0,
	KYBER_WRITE = 1,
	KYBER_DISCARD = 2,
	KYBER_OTHER = 3,
	KYBER_NUM_DOMAINS = 4,
};

enum {
	KYBER_ASYNC_PERCENT = 75,
};

enum {
	KYBER_LATENCY_SHIFT = 2,
	KYBER_GOOD_BUCKETS = 4,
	KYBER_LATENCY_BUCKETS = 8,
};

enum {
	KYBER_TOTAL_LATENCY = 0,
	KYBER_IO_LATENCY = 1,
};

struct kyber_cpu_latency {
	atomic_t buckets[48];
};

struct kyber_ctx_queue {
	spinlock_t lock;
	struct list_head rq_list[4];
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct kyber_queue_data {
	struct request_queue *q;
	dev_t dev;
	struct sbitmap_queue domain_tokens[4];
	unsigned int async_depth;
	struct kyber_cpu_latency *cpu_latency;
	struct timer_list timer;
	unsigned int latency_buckets[48];
	long unsigned int latency_timeout[3];
	int domain_p99[3];
	u64 latency_targets[3];
};

struct kyber_hctx_data {
	spinlock_t lock;
	struct list_head rqs[4];
	unsigned int cur_domain;
	unsigned int batching;
	struct kyber_ctx_queue *kcqs;
	struct sbitmap kcq_map[4];
	struct sbq_wait domain_wait[4];
	struct sbq_wait_state *domain_ws[4];
	atomic_t wait_index[4];
};

struct flush_kcq_data {
	struct kyber_hctx_data *khd;
	unsigned int sched_domain;
	struct list_head *list;
};

struct io_ring_ctx;

struct io_wq;

struct io_uring_task {
	int cached_refs;
	const struct io_ring_ctx *last;
	struct io_wq *io_wq;
	struct file *registered_rings[16];
	struct xarray xa;
	struct wait_queue_head wait;
	atomic_t in_cancel;
	atomic_t inflight_tracked;
	struct percpu_counter inflight;
	long: 64;
	long: 64;
	struct {
		struct llist_head task_list;
		struct callback_head task_work;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
	};
};

struct io_uring_cqe {
	__u64 user_data;
	__s32 res;
	__u32 flags;
	__u64 big_cqe[0];
};

struct io_uring_file_index_range {
	__u32 off;
	__u32 len;
	__u64 resv;
};

enum io_uring_cmd_flags {
	IO_URING_F_COMPLETE_DEFER = 1,
	IO_URING_F_UNLOCKED = 2,
	IO_URING_F_MULTISHOT = 4,
	IO_URING_F_IOWQ = 8,
	IO_URING_F_NONBLOCK = -2147483648,
	IO_URING_F_SQE128 = 256,
	IO_URING_F_CQE32 = 512,
	IO_URING_F_IOPOLL = 1024,
};

enum task_work_notify_mode {
	TWA_NONE = 0,
	TWA_RESUME = 1,
	TWA_SIGNAL = 2,
	TWA_SIGNAL_NO_IPI = 3,
};

struct io_wq_work_node {
	struct io_wq_work_node *next;
};

struct io_wq_work_list {
	struct io_wq_work_node *first;
	struct io_wq_work_node *last;
};

struct io_wq_work {
	struct io_wq_work_node list;
	unsigned int flags;
	int cancel_seq;
};

struct io_fixed_file {
	long unsigned int file_ptr;
};

struct io_file_table {
	struct io_fixed_file *files;
	long unsigned int *bitmap;
	unsigned int alloc_hint;
};

struct io_hash_bucket {
	spinlock_t lock;
	struct hlist_head list;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct io_hash_table {
	struct io_hash_bucket *hbs;
	unsigned int hash_bits;
};

struct io_kiocb;

struct io_submit_link {
	struct io_kiocb *head;
	struct io_kiocb *last;
};

struct io_submit_state {
	struct io_wq_work_node free_list;
	struct io_wq_work_list compl_reqs;
	struct io_submit_link link;
	bool plug_started;
	bool need_plug;
	short unsigned int submit_nr;
	unsigned int cqes_count;
	struct blk_plug plug;
};

struct io_alloc_cache {
	struct io_wq_work_node list;
	unsigned int nr_cached;
	unsigned int max_cached;
	size_t elem_size;
};

struct io_restriction {
	long unsigned int register_op[1];
	long unsigned int sqe_op[1];
	u8 sqe_flags_allowed;
	u8 sqe_flags_required;
	bool registered;
};

struct io_rings;

struct io_rsrc_node;

struct io_mapped_ubuf;

struct io_buffer_list;

struct io_ev_fd;

struct io_sq_data;

struct io_rsrc_data;

struct io_wq_hash;

struct io_ring_ctx {
	struct {
		unsigned int flags;
		unsigned int drain_next: 1;
		unsigned int restricted: 1;
		unsigned int off_timeout_used: 1;
		unsigned int drain_active: 1;
		unsigned int has_evfd: 1;
		unsigned int task_complete: 1;
		unsigned int lockless_cq: 1;
		unsigned int syscall_iopoll: 1;
		unsigned int poll_activated: 1;
		unsigned int drain_disabled: 1;
		unsigned int compat: 1;
		struct task_struct *submitter_task;
		struct io_rings *rings;
		struct percpu_ref refs;
		enum task_work_notify_mode notify_method;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
	};
	struct {
		struct mutex uring_lock;
		u32 *sq_array;
		struct io_uring_sqe *sq_sqes;
		unsigned int cached_sq_head;
		unsigned int sq_entries;
		struct io_rsrc_node *rsrc_node;
		atomic_t cancel_seq;
		struct io_file_table file_table;
		unsigned int nr_user_files;
		unsigned int nr_user_bufs;
		struct io_mapped_ubuf **user_bufs;
		struct io_submit_state submit_state;
		struct io_buffer_list *io_bl;
		struct xarray io_bl_xa;
		struct io_hash_table cancel_table_locked;
		struct io_alloc_cache apoll_cache;
		struct io_alloc_cache netmsg_cache;
		struct io_wq_work_list iopoll_list;
		bool poll_multi_queue;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
	};
	struct {
		struct io_uring_cqe *cqe_cached;
		struct io_uring_cqe *cqe_sentinel;
		unsigned int cached_cq_tail;
		unsigned int cq_entries;
		struct io_ev_fd *io_ev_fd;
		unsigned int cq_extra;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
	};
	struct {
		struct llist_head work_llist;
		long unsigned int check_cq;
		atomic_t cq_wait_nr;
		atomic_t cq_timeouts;
		struct wait_queue_head cq_wait;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
	};
	struct {
		spinlock_t timeout_lock;
		struct list_head timeout_list;
		struct list_head ltimeout_list;
		unsigned int cq_last_tm_flush;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
	};
	struct io_uring_cqe completion_cqes[16];
	spinlock_t completion_lock;
	struct io_wq_work_list locked_free_list;
	unsigned int locked_free_nr;
	struct list_head io_buffers_comp;
	struct list_head cq_overflow_list;
	struct io_hash_table cancel_table;
	const struct cred *sq_creds;
	struct io_sq_data *sq_data;
	struct wait_queue_head sqo_sq_wait;
	struct list_head sqd_list;
	unsigned int file_alloc_start;
	unsigned int file_alloc_end;
	struct xarray personalities;
	u32 pers_next;
	struct list_head io_buffers_cache;
	struct wait_queue_head poll_wq;
	struct io_restriction restrictions;
	struct io_mapped_ubuf *dummy_ubuf;
	struct io_rsrc_data *file_data;
	struct io_rsrc_data *buf_data;
	struct list_head rsrc_ref_list;
	struct io_alloc_cache rsrc_node_cache;
	struct wait_queue_head rsrc_quiesce_wq;
	unsigned int rsrc_quiesce;
	struct list_head io_buffers_pages;
	struct socket *ring_sock;
	struct io_wq_hash *hash_map;
	struct user_struct *user;
	struct mm_struct *mm_account;
	struct llist_head fallback_llist;
	struct delayed_work fallback_work;
	struct work_struct exit_work;
	struct list_head tctx_list;
	struct completion ref_comp;
	u32 iowq_limits[2];
	bool iowq_limits_set;
	struct callback_head poll_wq_task_work;
	struct list_head defer_list;
	unsigned int sq_thread_idle;
	unsigned int evfd_last_cq_tail;
	short unsigned int n_ring_pages;
	short unsigned int n_sqe_pages;
	struct page **ring_pages;
	struct page **sqe_pages;
	long: 64;
};

struct io_uring {
	u32 head;
	u32 tail;
};

struct io_rings {
	struct io_uring sq;
	struct io_uring cq;
	u32 sq_ring_mask;
	u32 cq_ring_mask;
	u32 sq_ring_entries;
	u32 cq_ring_entries;
	u32 sq_dropped;
	atomic_t sq_flags;
	u32 cq_flags;
	u32 cq_overflow;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct io_uring_cqe cqes[0];
};

struct io_cmd_data {
	struct file *file;
	__u8 data[56];
};

struct io_cqe {
	__u64 user_data;
	__s32 res;
	union {
		__u32 flags;
		int fd;
	};
};

struct io_tw_state;

typedef void (*io_req_tw_func_t)(struct io_kiocb *, struct io_tw_state *);

struct io_task_work {
	struct llist_node node;
	io_req_tw_func_t func;
};

struct io_buffer;

struct async_poll;

struct io_kiocb {
	union {
		struct file *file;
		struct io_cmd_data cmd;
	};
	u8 opcode;
	u8 iopoll_completed;
	u16 buf_index;
	unsigned int flags;
	struct io_cqe cqe;
	struct io_ring_ctx *ctx;
	struct task_struct *task;
	struct io_rsrc_node *rsrc_node;
	union {
		struct io_mapped_ubuf *imu;
		struct io_buffer *kbuf;
		struct io_buffer_list *buf_list;
	};
	union {
		struct io_wq_work_node comp_list;
		__poll_t apoll_events;
	};
	atomic_t refs;
	atomic_t poll_refs;
	struct io_task_work io_task_work;
	unsigned int nr_tw;
	struct hlist_node hash_node;
	struct async_poll *apoll;
	void *async_data;
	struct io_kiocb *link;
	const struct cred *creds;
	struct io_wq_work work;
	struct {
		u64 extra1;
		u64 extra2;
	} big_cqe;
};

struct io_ev_fd {
	struct eventfd_ctx *cq_ev_fd;
	unsigned int eventfd_async: 1;
	struct callback_head rcu;
	atomic_t refs;
	atomic_t ops;
};

struct io_cache_entry {
	struct io_wq_work_node node;
};

struct io_rsrc_put {
	u64 tag;
	union {
		void *rsrc;
		struct file *file;
		struct io_mapped_ubuf *buf;
	};
};

struct io_rsrc_node {
	union {
		struct io_cache_entry cache;
		struct io_ring_ctx *ctx;
	};
	int refs;
	bool empty;
	u16 type;
	struct list_head node;
	struct io_rsrc_put item;
};

struct io_mapped_ubuf {
	u64 ubuf;
	u64 ubuf_end;
	unsigned int nr_bvecs;
	long unsigned int acct_pages;
	struct bio_vec bvec[0];
};

struct io_rsrc_data {
	struct io_ring_ctx *ctx;
	u64 **tags;
	unsigned int nr;
	u16 rsrc_type;
	bool quiesce;
};

struct io_wq_hash {
	refcount_t refs;
	long unsigned int map;
	struct wait_queue_head wait;
};

struct io_tw_state {
	bool locked;
};

enum {
	REQ_F_FIXED_FILE_BIT = 0,
	REQ_F_IO_DRAIN_BIT = 1,
	REQ_F_LINK_BIT = 2,
	REQ_F_HARDLINK_BIT = 3,
	REQ_F_FORCE_ASYNC_BIT = 4,
	REQ_F_BUFFER_SELECT_BIT = 5,
	REQ_F_CQE_SKIP_BIT = 6,
	REQ_F_FAIL_BIT = 8,
	REQ_F_INFLIGHT_BIT = 9,
	REQ_F_CUR_POS_BIT = 10,
	REQ_F_NOWAIT_BIT = 11,
	REQ_F_LINK_TIMEOUT_BIT = 12,
	REQ_F_NEED_CLEANUP_BIT = 13,
	REQ_F_POLLED_BIT = 14,
	REQ_F_BUFFER_SELECTED_BIT = 15,
	REQ_F_BUFFER_RING_BIT = 16,
	REQ_F_REISSUE_BIT = 17,
	REQ_F_CREDS_BIT = 18,
	REQ_F_REFCOUNT_BIT = 19,
	REQ_F_ARM_LTIMEOUT_BIT = 20,
	REQ_F_ASYNC_DATA_BIT = 21,
	REQ_F_SKIP_LINK_CQES_BIT = 22,
	REQ_F_SINGLE_POLL_BIT = 23,
	REQ_F_DOUBLE_POLL_BIT = 24,
	REQ_F_PARTIAL_IO_BIT = 25,
	REQ_F_APOLL_MULTISHOT_BIT = 26,
	REQ_F_CLEAR_POLLIN_BIT = 27,
	REQ_F_HASH_LOCKED_BIT = 28,
	REQ_F_SUPPORT_NOWAIT_BIT = 29,
	REQ_F_ISREG_BIT = 30,
	__REQ_F_LAST_BIT = 31,
};

enum io_uring_op {
	IORING_OP_NOP = 0,
	IORING_OP_READV = 1,
	IORING_OP_WRITEV = 2,
	IORING_OP_FSYNC = 3,
	IORING_OP_READ_FIXED = 4,
	IORING_OP_WRITE_FIXED = 5,
	IORING_OP_POLL_ADD = 6,
	IORING_OP_POLL_REMOVE = 7,
	IORING_OP_SYNC_FILE_RANGE = 8,
	IORING_OP_SENDMSG = 9,
	IORING_OP_RECVMSG = 10,
	IORING_OP_TIMEOUT = 11,
	IORING_OP_TIMEOUT_REMOVE = 12,
	IORING_OP_ACCEPT = 13,
	IORING_OP_ASYNC_CANCEL = 14,
	IORING_OP_LINK_TIMEOUT = 15,
	IORING_OP_CONNECT = 16,
	IORING_OP_FALLOCATE = 17,
	IORING_OP_OPENAT = 18,
	IORING_OP_CLOSE = 19,
	IORING_OP_FILES_UPDATE = 20,
	IORING_OP_STATX = 21,
	IORING_OP_READ = 22,
	IORING_OP_WRITE = 23,
	IORING_OP_FADVISE = 24,
	IORING_OP_MADVISE = 25,
	IORING_OP_SEND = 26,
	IORING_OP_RECV = 27,
	IORING_OP_OPENAT2 = 28,
	IORING_OP_EPOLL_CTL = 29,
	IORING_OP_SPLICE = 30,
	IORING_OP_PROVIDE_BUFFERS = 31,
	IORING_OP_REMOVE_BUFFERS = 32,
	IORING_OP_TEE = 33,
	IORING_OP_SHUTDOWN = 34,
	IORING_OP_RENAMEAT = 35,
	IORING_OP_UNLINKAT = 36,
	IORING_OP_MKDIRAT = 37,
	IORING_OP_SYMLINKAT = 38,
	IORING_OP_LINKAT = 39,
	IORING_OP_MSG_RING = 40,
	IORING_OP_FSETXATTR = 41,
	IORING_OP_SETXATTR = 42,
	IORING_OP_FGETXATTR = 43,
	IORING_OP_GETXATTR = 44,
	IORING_OP_SOCKET = 45,
	IORING_OP_URING_CMD = 46,
	IORING_OP_SEND_ZC = 47,
	IORING_OP_SENDMSG_ZC = 48,
	IORING_OP_LAST = 49,
};

enum {
	REQ_F_FIXED_FILE = 1,
	REQ_F_IO_DRAIN = 2,
	REQ_F_LINK = 4,
	REQ_F_HARDLINK = 8,
	REQ_F_FORCE_ASYNC = 16,
	REQ_F_BUFFER_SELECT = 32,
	REQ_F_CQE_SKIP = 64,
	REQ_F_FAIL = 256,
	REQ_F_INFLIGHT = 512,
	REQ_F_CUR_POS = 1024,
	REQ_F_NOWAIT = 2048,
	REQ_F_LINK_TIMEOUT = 4096,
	REQ_F_NEED_CLEANUP = 8192,
	REQ_F_POLLED = 16384,
	REQ_F_BUFFER_SELECTED = 32768,
	REQ_F_BUFFER_RING = 65536,
	REQ_F_REISSUE = 131072,
	REQ_F_SUPPORT_NOWAIT = 536870912,
	REQ_F_ISREG = 1073741824,
	REQ_F_CREDS = 262144,
	REQ_F_REFCOUNT = 524288,
	REQ_F_ARM_LTIMEOUT = 1048576,
	REQ_F_ASYNC_DATA = 2097152,
	REQ_F_SKIP_LINK_CQES = 4194304,
	REQ_F_SINGLE_POLL = 8388608,
	REQ_F_DOUBLE_POLL = 16777216,
	REQ_F_PARTIAL_IO = 33554432,
	REQ_F_APOLL_MULTISHOT = 67108864,
	REQ_F_CLEAR_POLLIN = 134217728,
	REQ_F_HASH_LOCKED = 268435456,
};

enum {
	IOU_OK = 0,
	IOU_ISSUE_SKIP_COMPLETE = -529,
	IOU_STOP_MULTISHOT = -125,
};

struct io_cancel_data {
	struct io_ring_ctx *ctx;
	union {
		u64 data;
		struct file *file;
	};
	u8 opcode;
	u32 flags;
	int seq;
};

struct io_timeout_data {
	struct io_kiocb *req;
	struct hrtimer timer;
	struct timespec64 ts;
	enum hrtimer_mode mode;
	u32 flags;
};

struct io_timeout {
	struct file *file;
	u32 off;
	u32 target_seq;
	u32 repeats;
	struct list_head list;
	struct io_kiocb *head;
	struct io_kiocb *prev;
};

struct io_timeout_rem {
	struct file *file;
	u64 addr;
	struct timespec64 ts;
	u32 flags;
	bool ltimeout;
};

struct io_uring_rsrc_register {
	__u32 nr;
	__u32 flags;
	__u64 resv2;
	__u64 data;
	__u64 tags;
};

struct io_uring_rsrc_update2 {
	__u32 offset;
	__u32 resv;
	__u64 data;
	__u64 tags;
	__u32 nr;
	__u32 resv2;
};

struct scm_fp_list {
	short int count;
	short int max;
	struct user_struct *user;
	struct file *fp[253];
};

struct unix_skb_parms {
	struct pid *pid;
	kuid_t uid;
	kgid_t gid;
	struct scm_fp_list *fp;
	u32 secid;
	u32 consumed;
};

enum {
	IORING_RSRC_FILE = 0,
	IORING_RSRC_BUFFER = 1,
};

struct io_rsrc_update {
	struct file *file;
	u64 arg;
	u32 nr_args;
	u32 offset;
};

enum {
	PERCPU_REF_INIT_ATOMIC = 1,
	PERCPU_REF_INIT_DEAD = 2,
	PERCPU_REF_ALLOW_REINIT = 4,
};

typedef long unsigned int mpi_limb_t;

typedef mpi_limb_t *mpi_ptr_t;

typedef int mpi_size_t;

typedef mpi_limb_t UWtype;

typedef unsigned int UHWtype;

struct gcry_mpi {
	int alloced;
	int nlimbs;
	int nbits;
	int sign;
	unsigned int flags;
	mpi_limb_t *d;
};

typedef struct gcry_mpi *MPI;

struct btree_head {
	long unsigned int *node;
	mempool_t *mempool;
	int height;
};

struct btree_geo {
	int keylen;
	int no_pairs;
	int no_longs;
};

typedef void (*visitor128_t)(void *, long unsigned int, u64, u64, size_t);

typedef void (*visitorl_t)(void *, long unsigned int, long unsigned int, size_t);

typedef void (*visitor32_t)(void *, long unsigned int, u32, size_t);

typedef void (*visitor64_t)(void *, long unsigned int, u64, size_t);

typedef s16 int16_t;

typedef uint8_t BYTE;

typedef uint8_t U8;

typedef uint16_t U16;

typedef int16_t S16;

typedef uint32_t U32;

typedef uint64_t U64;

typedef enum {
	ZSTD_error_no_error = 0,
	ZSTD_error_GENERIC = 1,
	ZSTD_error_prefix_unknown = 10,
	ZSTD_error_version_unsupported = 12,
	ZSTD_error_frameParameter_unsupported = 14,
	ZSTD_error_frameParameter_windowTooLarge = 16,
	ZSTD_error_corruption_detected = 20,
	ZSTD_error_checksum_wrong = 22,
	ZSTD_error_dictionary_corrupted = 30,
	ZSTD_error_dictionary_wrong = 32,
	ZSTD_error_dictionaryCreation_failed = 34,
	ZSTD_error_parameter_unsupported = 40,
	ZSTD_error_parameter_outOfBound = 42,
	ZSTD_error_tableLog_tooLarge = 44,
	ZSTD_error_maxSymbolValue_tooLarge = 46,
	ZSTD_error_maxSymbolValue_tooSmall = 48,
	ZSTD_error_stage_wrong = 60,
	ZSTD_error_init_missing = 62,
	ZSTD_error_memory_allocation = 64,
	ZSTD_error_workSpace_tooSmall = 66,
	ZSTD_error_dstSize_tooSmall = 70,
	ZSTD_error_srcSize_wrong = 72,
	ZSTD_error_dstBuffer_null = 74,
	ZSTD_error_frameIndex_tooLarge = 100,
	ZSTD_error_seekableIO = 102,
	ZSTD_error_dstBuffer_wrong = 104,
	ZSTD_error_srcBuffer_wrong = 105,
	ZSTD_error_maxCode = 120,
} ZSTD_ErrorCode;

typedef U32 HUF_DTable;

struct xxh64_state {
	uint64_t total_len;
	uint64_t v1;
	uint64_t v2;
	uint64_t v3;
	uint64_t v4;
	uint64_t mem64[4];
	uint32_t memsize;
};

typedef struct {
	U16 nextState;
	BYTE nbAdditionalBits;
	BYTE nbBits;
	U32 baseValue;
} ZSTD_seqSymbol;

typedef struct {
	ZSTD_seqSymbol LLTable[513];
	ZSTD_seqSymbol OFTable[257];
	ZSTD_seqSymbol MLTable[513];
	HUF_DTable hufTable[4097];
	U32 rep[3];
	U32 workspace[157];
} ZSTD_entropyDTables_t;

typedef enum {
	ZSTD_frame = 0,
	ZSTD_skippableFrame = 1,
} ZSTD_frameType_e;

typedef struct {
	long long unsigned int frameContentSize;
	long long unsigned int windowSize;
	unsigned int blockSizeMax;
	ZSTD_frameType_e frameType;
	unsigned int headerSize;
	unsigned int dictID;
	unsigned int checksumFlag;
} ZSTD_frameHeader;

typedef enum {
	bt_raw = 0,
	bt_rle = 1,
	bt_compressed = 2,
	bt_reserved = 3,
} blockType_e;

typedef enum {
	ZSTDds_getFrameHeaderSize = 0,
	ZSTDds_decodeFrameHeader = 1,
	ZSTDds_decodeBlockHeader = 2,
	ZSTDds_decompressBlock = 3,
	ZSTDds_decompressLastBlock = 4,
	ZSTDds_checkChecksum = 5,
	ZSTDds_decodeSkippableHeader = 6,
	ZSTDds_skipFrame = 7,
} ZSTD_dStage;

typedef enum {
	ZSTD_f_zstd1 = 0,
	ZSTD_f_zstd1_magicless = 1,
} ZSTD_format_e;

typedef enum {
	ZSTD_d_validateChecksum = 0,
	ZSTD_d_ignoreChecksum = 1,
} ZSTD_forceIgnoreChecksum_e;

typedef void * (*ZSTD_allocFunction)(void *, size_t);

typedef void (*ZSTD_freeFunction)(void *, void *);

typedef struct {
	ZSTD_allocFunction customAlloc;
	ZSTD_freeFunction customFree;
	void *opaque;
} ZSTD_customMem;

typedef enum {
	ZSTD_use_indefinitely = -1,
	ZSTD_dont_use = 0,
	ZSTD_use_once = 1,
} ZSTD_dictUses_e;

struct ZSTD_DDict_s;

typedef struct ZSTD_DDict_s ZSTD_DDict;

typedef struct {
	const ZSTD_DDict **ddictPtrTable;
	size_t ddictPtrTableSize;
	size_t ddictPtrCount;
} ZSTD_DDictHashSet;

typedef enum {
	ZSTD_rmd_refSingleDDict = 0,
	ZSTD_rmd_refMultipleDDicts = 1,
} ZSTD_refMultipleDDicts_e;

typedef enum {
	zdss_init = 0,
	zdss_loadHeader = 1,
	zdss_read = 2,
	zdss_load = 3,
	zdss_flush = 4,
} ZSTD_dStreamStage;

typedef enum {
	ZSTD_bm_buffered = 0,
	ZSTD_bm_stable = 1,
} ZSTD_bufferMode_e;

struct ZSTD_outBuffer_s {
	void *dst;
	size_t size;
	size_t pos;
};

typedef struct ZSTD_outBuffer_s ZSTD_outBuffer;

typedef enum {
	ZSTD_not_in_dst = 0,
	ZSTD_in_dst = 1,
	ZSTD_split = 2,
} ZSTD_litLocation_e;

struct ZSTD_DCtx_s {
	const ZSTD_seqSymbol *LLTptr;
	const ZSTD_seqSymbol *MLTptr;
	const ZSTD_seqSymbol *OFTptr;
	const HUF_DTable *HUFptr;
	ZSTD_entropyDTables_t entropy;
	U32 workspace[640];
	const void *previousDstEnd;
	const void *prefixStart;
	const void *virtualStart;
	const void *dictEnd;
	size_t expected;
	ZSTD_frameHeader fParams;
	U64 processedCSize;
	U64 decodedSize;
	blockType_e bType;
	ZSTD_dStage stage;
	U32 litEntropy;
	U32 fseEntropy;
	struct xxh64_state xxhState;
	size_t headerSize;
	ZSTD_format_e format;
	ZSTD_forceIgnoreChecksum_e forceIgnoreChecksum;
	U32 validateChecksum;
	const BYTE *litPtr;
	ZSTD_customMem customMem;
	size_t litSize;
	size_t rleSize;
	size_t staticSize;
	ZSTD_DDict *ddictLocal;
	const ZSTD_DDict *ddict;
	U32 dictID;
	int ddictIsCold;
	ZSTD_dictUses_e dictUses;
	ZSTD_DDictHashSet *ddictSet;
	ZSTD_refMultipleDDicts_e refMultipleDDicts;
	ZSTD_dStreamStage streamStage;
	char *inBuff;
	size_t inBuffSize;
	size_t inPos;
	size_t maxWindowSize;
	char *outBuff;
	size_t outBuffSize;
	size_t outStart;
	size_t outEnd;
	size_t lhSize;
	U32 hostageByte;
	int noForwardProgress;
	ZSTD_bufferMode_e outBufferMode;
	ZSTD_outBuffer expectedOutBuffer;
	BYTE *litBuffer;
	const BYTE *litBufferEnd;
	ZSTD_litLocation_e litBufferLocation;
	BYTE litExtraBuffer[65568];
	BYTE headerBuffer[18];
	size_t oversizedDuration;
};

typedef struct ZSTD_DCtx_s ZSTD_DCtx;

typedef struct {
	size_t error;
	int lowerBound;
	int upperBound;
} ZSTD_bounds;

typedef enum {
	ZSTD_reset_session_only = 1,
	ZSTD_reset_parameters = 2,
	ZSTD_reset_session_and_parameters = 3,
} ZSTD_ResetDirective;

typedef enum {
	ZSTD_d_windowLogMax = 100,
	ZSTD_d_experimentalParam1 = 1000,
	ZSTD_d_experimentalParam2 = 1001,
	ZSTD_d_experimentalParam3 = 1002,
	ZSTD_d_experimentalParam4 = 1003,
} ZSTD_dParameter;

struct ZSTD_inBuffer_s {
	const void *src;
	size_t size;
	size_t pos;
};

typedef struct ZSTD_inBuffer_s ZSTD_inBuffer;

typedef ZSTD_DCtx ZSTD_DStream;

struct ZSTD_DDict_s {
	void *dictBuffer;
	const void *dictContent;
	size_t dictSize;
	ZSTD_entropyDTables_t entropy;
	U32 dictID;
	U32 entropyPresent;
	ZSTD_customMem cMem;
};

typedef enum {
	ZSTD_dct_auto = 0,
	ZSTD_dct_rawContent = 1,
	ZSTD_dct_fullDict = 2,
} ZSTD_dictContentType_e;

typedef enum {
	ZSTD_dlm_byCopy = 0,
	ZSTD_dlm_byRef = 1,
} ZSTD_dictLoadMethod_e;

typedef enum {
	ZSTDnit_frameHeader = 0,
	ZSTDnit_blockHeader = 1,
	ZSTDnit_block = 2,
	ZSTDnit_lastBlock = 3,
	ZSTDnit_checksum = 4,
	ZSTDnit_skippableFrame = 5,
} ZSTD_nextInputType_e;

typedef struct {
	size_t compressedSize;
	long long unsigned int decompressedBound;
} ZSTD_frameSizeInfo;

typedef struct {
	blockType_e blockType;
	U32 lastBlock;
	U32 origSize;
} blockProperties_t;

typedef enum {
	not_streaming = 0,
	is_streaming = 1,
} streaming_operation;

struct dim_cq_moder {
	u16 usec;
	u16 pkts;
	u16 comps;
	u8 cq_period_mode;
};

struct dim_sample {
	ktime_t time;
	u32 pkt_ctr;
	u32 byte_ctr;
	u16 event_ctr;
	u32 comp_ctr;
};

struct dim_stats {
	int ppms;
	int bpms;
	int epms;
	int cpms;
	int cpe_ratio;
};

struct dim {
	u8 state;
	struct dim_stats prev_stats;
	struct dim_sample start_sample;
	struct dim_sample measuring_sample;
	struct work_struct work;
	void *priv;
	u8 profile_ix;
	u8 mode;
	u8 tune_state;
	u8 steps_right;
	u8 steps_left;
	u8 tired;
};

enum dim_cq_period_mode {
	DIM_CQ_PERIOD_MODE_START_FROM_EQE = 0,
	DIM_CQ_PERIOD_MODE_START_FROM_CQE = 1,
	DIM_CQ_PERIOD_NUM_MODES = 2,
};

enum dim_state {
	DIM_START_MEASURE = 0,
	DIM_MEASURE_IN_PROGRESS = 1,
	DIM_APPLY_NEW_PROFILE = 2,
};

enum dim_tune_state {
	DIM_PARKING_ON_TOP = 0,
	DIM_PARKING_TIRED = 1,
	DIM_GOING_RIGHT = 2,
	DIM_GOING_LEFT = 3,
};

enum dim_stats_state {
	DIM_STATS_WORSE = 0,
	DIM_STATS_SAME = 1,
	DIM_STATS_BETTER = 2,
};

enum dim_step_result {
	DIM_STEPPED = 0,
	DIM_TOO_TIRED = 1,
	DIM_ON_EDGE = 2,
};

struct bus_attribute {
	struct attribute attr;
	ssize_t (*show)(const struct bus_type *, char *);
	ssize_t (*store)(const struct bus_type *, const char *, size_t);
};

typedef void (*dr_release_t)(struct device *, void *);

typedef int (*dr_match_t)(struct device *, void *, void *);

struct dmi_strmatch {
	unsigned char slot: 7;
	unsigned char exact_match: 1;
	char substr[79];
};

struct dmi_system_id {
	int (*callback)(const struct dmi_system_id *);
	const char *ident;
	struct dmi_strmatch matches[4];
	void *driver_data;
};

enum {
	LOGIC_PIO_INDIRECT = 0,
	LOGIC_PIO_CPU_MMIO = 1,
};

struct logic_pio_host_ops;

struct logic_pio_hwaddr {
	struct list_head list;
	struct fwnode_handle *fwnode;
	resource_size_t hw_start;
	resource_size_t io_start;
	resource_size_t size;
	long unsigned int flags;
	void *hostdata;
	const struct logic_pio_host_ops *ops;
};

struct logic_pio_host_ops {
	u32 (*in)(void *, long unsigned int, size_t);
	void (*out)(void *, long unsigned int, u32, size_t);
	u32 (*ins)(void *, long unsigned int, void *, size_t, unsigned int);
	void (*outs)(void *, long unsigned int, const void *, size_t, unsigned int);
};

enum {
	pci_channel_io_normal = 1,
	pci_channel_io_frozen = 2,
	pci_channel_io_perm_failure = 3,
};

enum pcie_reset_state {
	pcie_deassert_reset = 1,
	pcie_warm_reset = 2,
	pcie_hot_reset = 3,
};

enum pci_dev_flags {
	PCI_DEV_FLAGS_MSI_INTX_DISABLE_BUG = 1,
	PCI_DEV_FLAGS_NO_D3 = 2,
	PCI_DEV_FLAGS_ASSIGNED = 4,
	PCI_DEV_FLAGS_ACS_ENABLED_QUIRK = 8,
	PCI_DEV_FLAG_PCIE_BRIDGE_ALIAS = 32,
	PCI_DEV_FLAGS_NO_BUS_RESET = 64,
	PCI_DEV_FLAGS_NO_PM_RESET = 128,
	PCI_DEV_FLAGS_VPD_REF_F0 = 256,
	PCI_DEV_FLAGS_BRIDGE_XLATE_ROOT = 512,
	PCI_DEV_FLAGS_NO_FLR_RESET = 1024,
	PCI_DEV_FLAGS_NO_RELAXED_ORDERING = 2048,
	PCI_DEV_FLAGS_HAS_MSI_MASKING = 4096,
};

enum pci_bus_flags {
	PCI_BUS_FLAGS_NO_MSI = 1,
	PCI_BUS_FLAGS_NO_MMRBC = 2,
	PCI_BUS_FLAGS_NO_AERSID = 4,
	PCI_BUS_FLAGS_NO_EXTCFG = 8,
};

enum pcie_link_width {
	PCIE_LNK_WIDTH_RESRV = 0,
	PCIE_LNK_X1 = 1,
	PCIE_LNK_X2 = 2,
	PCIE_LNK_X4 = 4,
	PCIE_LNK_X8 = 8,
	PCIE_LNK_X12 = 12,
	PCIE_LNK_X16 = 16,
	PCIE_LNK_X32 = 32,
	PCIE_LNK_WIDTH_UNKNOWN = 255,
};

enum pci_bus_speed {
	PCI_SPEED_33MHz = 0,
	PCI_SPEED_66MHz = 1,
	PCI_SPEED_66MHz_PCIX = 2,
	PCI_SPEED_100MHz_PCIX = 3,
	PCI_SPEED_133MHz_PCIX = 4,
	PCI_SPEED_66MHz_PCIX_ECC = 5,
	PCI_SPEED_100MHz_PCIX_ECC = 6,
	PCI_SPEED_133MHz_PCIX_ECC = 7,
	PCI_SPEED_66MHz_PCIX_266 = 9,
	PCI_SPEED_100MHz_PCIX_266 = 10,
	PCI_SPEED_133MHz_PCIX_266 = 11,
	AGP_UNKNOWN = 12,
	AGP_1X = 13,
	AGP_2X = 14,
	AGP_4X = 15,
	AGP_8X = 16,
	PCI_SPEED_66MHz_PCIX_533 = 17,
	PCI_SPEED_100MHz_PCIX_533 = 18,
	PCI_SPEED_133MHz_PCIX_533 = 19,
	PCIE_SPEED_2_5GT = 20,
	PCIE_SPEED_5_0GT = 21,
	PCIE_SPEED_8_0GT = 22,
	PCIE_SPEED_16_0GT = 23,
	PCIE_SPEED_32_0GT = 24,
	PCIE_SPEED_64_0GT = 25,
	PCI_SPEED_UNKNOWN = 255,
};

enum pcie_bus_config_types {
	PCIE_BUS_TUNE_OFF = 0,
	PCIE_BUS_DEFAULT = 1,
	PCIE_BUS_SAFE = 2,
	PCIE_BUS_PERFORMANCE = 3,
	PCIE_BUS_PEER2PEER = 4,
};

typedef int (*arch_set_vga_state_t)(struct pci_dev *, bool, unsigned int, u32);

enum pci_fixup_pass {
	pci_fixup_early = 0,
	pci_fixup_header = 1,
	pci_fixup_final = 2,
	pci_fixup_enable = 3,
	pci_fixup_resume = 4,
	pci_fixup_suspend = 5,
	pci_fixup_resume_early = 6,
	pci_fixup_suspend_late = 7,
};

struct pci_cap_saved_data {
	u16 cap_nr;
	bool cap_extended;
	unsigned int size;
	u32 data[0];
};

struct pci_cap_saved_state {
	struct hlist_node next;
	struct pci_cap_saved_data cap;
};

struct pci_reset_fn_method {
	int (*reset_fn)(struct pci_dev *, bool);
	char *name;
};

struct pci_pme_device {
	struct list_head list;
	struct pci_dev *dev;
};

struct pci_saved_state {
	u32 config_space[16];
	struct pci_cap_saved_data cap[0];
};

struct pci_devres {
	unsigned int enabled: 1;
	unsigned int pinned: 1;
	unsigned int orig_intx: 1;
	unsigned int restore_intx: 1;
	unsigned int mwi: 1;
	u32 region_mask;
};

struct pci_slot_attribute {
	struct attribute attr;
	ssize_t (*show)(struct pci_slot *, char *);
	ssize_t (*store)(struct pci_slot *, const char *, size_t);
};

struct pdev_archdata {
	u64 dma_mask;
	void *priv;
};

struct platform_device_id {
	char name[20];
	kernel_ulong_t driver_data;
};

struct mfd_cell;

struct platform_device {
	const char *name;
	int id;
	bool id_auto;
	struct device dev;
	u64 platform_dma_mask;
	struct device_dma_parameters dma_parms;
	u32 num_resources;
	struct resource *resource;
	const struct platform_device_id *id_entry;
	const char *driver_override;
	struct mfd_cell *mfd_cell;
	struct pdev_archdata archdata;
};

struct aperture_range {
	struct device *dev;
	resource_size_t base;
	resource_size_t size;
	struct list_head lh;
	void (*detach)(struct device *);
};

struct fb_fix_screeninfo {
	char id[16];
	long unsigned int smem_start;
	__u32 smem_len;
	__u32 type;
	__u32 type_aux;
	__u32 visual;
	__u16 xpanstep;
	__u16 ypanstep;
	__u16 ywrapstep;
	__u32 line_length;
	long unsigned int mmio_start;
	__u32 mmio_len;
	__u32 accel;
	__u16 capabilities;
	__u16 reserved[2];
};

struct fb_bitfield {
	__u32 offset;
	__u32 length;
	__u32 msb_right;
};

struct fb_var_screeninfo {
	__u32 xres;
	__u32 yres;
	__u32 xres_virtual;
	__u32 yres_virtual;
	__u32 xoffset;
	__u32 yoffset;
	__u32 bits_per_pixel;
	__u32 grayscale;
	struct fb_bitfield red;
	struct fb_bitfield green;
	struct fb_bitfield blue;
	struct fb_bitfield transp;
	__u32 nonstd;
	__u32 activate;
	__u32 height;
	__u32 width;
	__u32 accel_flags;
	__u32 pixclock;
	__u32 left_margin;
	__u32 right_margin;
	__u32 upper_margin;
	__u32 lower_margin;
	__u32 hsync_len;
	__u32 vsync_len;
	__u32 sync;
	__u32 vmode;
	__u32 rotate;
	__u32 colorspace;
	__u32 reserved[4];
};

struct fb_cmap {
	__u32 start;
	__u32 len;
	__u16 *red;
	__u16 *green;
	__u16 *blue;
	__u16 *transp;
};

struct fb_copyarea {
	__u32 dx;
	__u32 dy;
	__u32 width;
	__u32 height;
	__u32 sx;
	__u32 sy;
};

struct fb_fillrect {
	__u32 dx;
	__u32 dy;
	__u32 width;
	__u32 height;
	__u32 color;
	__u32 rop;
};

struct fb_image {
	__u32 dx;
	__u32 dy;
	__u32 width;
	__u32 height;
	__u32 fg_color;
	__u32 bg_color;
	__u8 depth;
	const char *data;
	struct fb_cmap cmap;
};

struct fbcurpos {
	__u16 x;
	__u16 y;
};

struct fb_cursor {
	__u16 set;
	__u16 enable;
	__u16 rop;
	const char *mask;
	struct fbcurpos hot;
	struct fb_image image;
};

enum backlight_type {
	BACKLIGHT_RAW = 1,
	BACKLIGHT_PLATFORM = 2,
	BACKLIGHT_FIRMWARE = 3,
	BACKLIGHT_TYPE_MAX = 4,
};

enum backlight_scale {
	BACKLIGHT_SCALE_UNKNOWN = 0,
	BACKLIGHT_SCALE_LINEAR = 1,
	BACKLIGHT_SCALE_NON_LINEAR = 2,
};

struct backlight_device;

struct fb_info;

struct backlight_ops {
	unsigned int options;
	int (*update_status)(struct backlight_device *);
	int (*get_brightness)(struct backlight_device *);
	int (*check_fb)(struct backlight_device *, struct fb_info *);
};

struct backlight_properties {
	int brightness;
	int max_brightness;
	int power;
	int fb_blank;
	enum backlight_type type;
	unsigned int state;
	enum backlight_scale scale;
};

struct backlight_device {
	struct backlight_properties props;
	struct mutex update_lock;
	struct mutex ops_lock;
	const struct backlight_ops *ops;
	struct notifier_block fb_notif;
	struct list_head entry;
	struct device dev;
	bool fb_bl_on[32];
	int use_count;
};

struct fb_chroma {
	__u32 redx;
	__u32 greenx;
	__u32 bluex;
	__u32 whitex;
	__u32 redy;
	__u32 greeny;
	__u32 bluey;
	__u32 whitey;
};

struct fb_videomode;

struct fb_monspecs {
	struct fb_chroma chroma;
	struct fb_videomode *modedb;
	__u8 manufacturer[4];
	__u8 monitor[14];
	__u8 serial_no[14];
	__u8 ascii[14];
	__u32 modedb_len;
	__u32 model;
	__u32 serial;
	__u32 year;
	__u32 week;
	__u32 hfmin;
	__u32 hfmax;
	__u32 dclkmin;
	__u32 dclkmax;
	__u16 input;
	__u16 dpms;
	__u16 signal;
	__u16 vfmin;
	__u16 vfmax;
	__u16 gamma;
	__u16 gtf: 1;
	__u16 misc;
	__u8 version;
	__u8 revision;
	__u8 max_x;
	__u8 max_y;
};

struct fb_pixmap {
	u8 *addr;
	u32 size;
	u32 offset;
	u32 buf_align;
	u32 scan_align;
	u32 access_align;
	u32 flags;
	u32 blit_x;
	u32 blit_y;
	void (*writeio)(struct fb_info *, void *, void *, unsigned int);
	void (*readio)(struct fb_info *, void *, void *, unsigned int);
};

struct fb_ops;

struct fb_tile_ops;

struct fb_info {
	refcount_t count;
	int node;
	int flags;
	int fbcon_rotate_hint;
	struct mutex lock;
	struct mutex mm_lock;
	struct fb_var_screeninfo var;
	struct fb_fix_screeninfo fix;
	struct fb_monspecs monspecs;
	struct fb_pixmap pixmap;
	struct fb_pixmap sprite;
	struct fb_cmap cmap;
	struct list_head modelist;
	struct fb_videomode *mode;
	struct backlight_device *bl_dev;
	struct mutex bl_curve_mutex;
	u8 bl_curve[128];
	const struct fb_ops *fbops;
	struct device *device;
	struct device *dev;
	int class_flag;
	struct fb_tile_ops *tileops;
	union {
		char *screen_base;
		char *screen_buffer;
	};
	long unsigned int screen_size;
	void *pseudo_palette;
	u32 state;
	void *fbcon_par;
	void *par;
	bool skip_vt_switch;
};

struct fb_videomode {
	const char *name;
	u32 refresh;
	u32 xres;
	u32 yres;
	u32 pixclock;
	u32 left_margin;
	u32 right_margin;
	u32 upper_margin;
	u32 lower_margin;
	u32 hsync_len;
	u32 vsync_len;
	u32 sync;
	u32 vmode;
	u32 flag;
};

struct fb_blit_caps {
	u32 x;
	u32 y;
	u32 len;
	u32 flags;
};

struct fb_ops {
	struct module *owner;
	int (*fb_open)(struct fb_info *, int);
	int (*fb_release)(struct fb_info *, int);
	ssize_t (*fb_read)(struct fb_info *, char *, size_t, loff_t *);
	ssize_t (*fb_write)(struct fb_info *, const char *, size_t, loff_t *);
	int (*fb_check_var)(struct fb_var_screeninfo *, struct fb_info *);
	int (*fb_set_par)(struct fb_info *);
	int (*fb_setcolreg)(unsigned int, unsigned int, unsigned int, unsigned int, unsigned int, struct fb_info *);
	int (*fb_setcmap)(struct fb_cmap *, struct fb_info *);
	int (*fb_blank)(int, struct fb_info *);
	int (*fb_pan_display)(struct fb_var_screeninfo *, struct fb_info *);
	void (*fb_fillrect)(struct fb_info *, const struct fb_fillrect *);
	void (*fb_copyarea)(struct fb_info *, const struct fb_copyarea *);
	void (*fb_imageblit)(struct fb_info *, const struct fb_image *);
	int (*fb_cursor)(struct fb_info *, struct fb_cursor *);
	int (*fb_sync)(struct fb_info *);
	int (*fb_ioctl)(struct fb_info *, unsigned int, long unsigned int);
	int (*fb_compat_ioctl)(struct fb_info *, unsigned int, long unsigned int);
	int (*fb_mmap)(struct fb_info *, struct vm_area_struct *);
	void (*fb_get_caps)(struct fb_info *, struct fb_blit_caps *, struct fb_var_screeninfo *);
	void (*fb_destroy)(struct fb_info *);
	int (*fb_debug_enter)(struct fb_info *);
	int (*fb_debug_leave)(struct fb_info *);
};

struct fb_tilemap {
	__u32 width;
	__u32 height;
	__u32 depth;
	__u32 length;
	const __u8 *data;
};

struct fb_tilerect {
	__u32 sx;
	__u32 sy;
	__u32 width;
	__u32 height;
	__u32 index;
	__u32 fg;
	__u32 bg;
	__u32 rop;
};

struct fb_tilearea {
	__u32 sx;
	__u32 sy;
	__u32 dx;
	__u32 dy;
	__u32 width;
	__u32 height;
};

struct fb_tileblit {
	__u32 sx;
	__u32 sy;
	__u32 width;
	__u32 height;
	__u32 fg;
	__u32 bg;
	__u32 length;
	__u32 *indices;
};

struct fb_tilecursor {
	__u32 sx;
	__u32 sy;
	__u32 mode;
	__u32 shape;
	__u32 fg;
	__u32 bg;
};

struct fb_tile_ops {
	void (*fb_settile)(struct fb_info *, struct fb_tilemap *);
	void (*fb_tilecopy)(struct fb_info *, struct fb_tilearea *);
	void (*fb_tilefill)(struct fb_info *, struct fb_tilerect *);
	void (*fb_tileblit)(struct fb_info *, struct fb_tileblit *);
	void (*fb_tilecursor)(struct fb_info *, struct fb_tilecursor *);
	int (*fb_get_tilemax)(struct fb_info *);
};

struct dmt_videomode {
	u32 dmt_id;
	u32 std_2byte_code;
	u32 cvt_3byte_code;
	const struct fb_videomode *mode;
};

struct fb_modelist {
	struct list_head list;
	struct fb_videomode mode;
};

enum {
	FB_BLANK_UNBLANK = 0,
	FB_BLANK_NORMAL = 1,
	FB_BLANK_VSYNC_SUSPEND = 2,
	FB_BLANK_HSYNC_SUSPEND = 3,
	FB_BLANK_POWERDOWN = 4,
};

struct fb_cmap_user {
	__u32 start;
	__u32 len;
	__u16 *red;
	__u16 *green;
	__u16 *blue;
	__u16 *transp;
};

typedef u16 u_int16_t;

typedef u32 u_int32_t;

typedef struct {
	void *vaddr;
} vaddr_t;

struct my_timming {
	unsigned int pixclock;
	int mnp;
	unsigned int crtc;
	unsigned int HDisplay;
	unsigned int HSyncStart;
	unsigned int HSyncEnd;
	unsigned int HTotal;
	unsigned int VDisplay;
	unsigned int VSyncStart;
	unsigned int VSyncEnd;
	unsigned int VTotal;
	unsigned int sync;
	int dblscan;
	int interlaced;
	unsigned int delay;
};

struct matrox_pll_cache {
	unsigned int valid;
	struct {
		unsigned int mnp_key;
		unsigned int mnp_value;
	} data[4];
};

struct matrox_pll_limits {
	unsigned int vcomin;
	unsigned int vcomax;
};

struct matrox_pll_features {
	unsigned int vco_freq_min;
	unsigned int ref_freq;
	unsigned int feed_div_min;
	unsigned int feed_div_max;
	unsigned int in_div_min;
	unsigned int in_div_max;
	unsigned int post_shift_max;
};

struct matroxfb_par {
	unsigned int final_bppShift;
	unsigned int cmap_len;
	struct {
		unsigned int bytes;
		unsigned int pixels;
		unsigned int chunks;
	} ydstorg;
};

struct matrox_DAC1064_features {
	u_int8_t xvrefctrl;
	u_int8_t xmiscctrl;
};

struct mavenregs {
	u_int8_t regs[256];
	int mode;
	int vlines;
	int xtal;
	int fv;
	u_int16_t htotal;
	u_int16_t hcorr;
};

struct matrox_crtc2 {
	u_int32_t ctl;
};

struct matrox_hw_state {
	u_int32_t MXoptionReg;
	unsigned char DACclk[6];
	unsigned char DACreg[80];
	unsigned char MiscOutReg;
	unsigned char DACpal[768];
	unsigned char CRTC[25];
	unsigned char CRTCEXT[9];
	unsigned char SEQ[5];
	unsigned char GCTL[9];
	unsigned char ATTR[21];
	struct mavenregs maven;
	struct matrox_crtc2 crtc2;
};

struct matrox_accel_data {
	unsigned char ramdac_rev;
	u_int32_t m_dwg_rect;
	u_int32_t m_opmode;
	u_int32_t m_access;
	u_int32_t m_pitch;
};

struct v4l2_queryctrl;

struct v4l2_control;

struct matrox_altout {
	const char *name;
	int (*compute)(void *, struct my_timming *);
	int (*program)(void *);
	int (*start)(void *);
	int (*verifymode)(void *, u_int32_t);
	int (*getqueryctrl)(void *, struct v4l2_queryctrl *);
	int (*getctrl)(void *, struct v4l2_control *);
	int (*setctrl)(void *, struct v4l2_control *);
};

struct v4l2_queryctrl {
	__u32 id;
	__u32 type;
	__u8 name[32];
	__s32 minimum;
	__s32 maximum;
	__s32 step;
	__s32 default_value;
	__u32 flags;
	__u32 reserved[2];
};

struct v4l2_control {
	__u32 id;
	__s32 value;
};

enum mga_chip {
	MGA_2064 = 0,
	MGA_2164 = 1,
	MGA_1064 = 2,
	MGA_1164 = 3,
	MGA_G100 = 4,
	MGA_G200 = 5,
	MGA_G400 = 6,
	MGA_G450 = 7,
	MGA_G550 = 8,
};

struct matrox_bios {
	unsigned int bios_valid: 1;
	unsigned int pins_len;
	unsigned char pins[128];
	struct {
		unsigned char vMaj;
		unsigned char vMin;
		unsigned char vRev;
	} version;
	struct {
		unsigned char state;
		unsigned char tvout;
	} output;
};

struct matrox_vsync {
	wait_queue_head_t wait;
	unsigned int cnt;
};

struct matroxfb_dh_fb_info;

struct matroxfb_driver;

struct matrox_switch;

struct matrox_fb_info {
	struct fb_info fbcon;
	struct list_head next_fb;
	int dead;
	int initialized;
	unsigned int usecount;
	unsigned int userusecount;
	long unsigned int irq_flags;
	struct matroxfb_par curr;
	struct matrox_hw_state hw;
	struct matrox_accel_data accel;
	struct pci_dev *pcidev;
	struct {
		struct matrox_vsync vsync;
		unsigned int pixclock;
		int mnp;
		int panpos;
	} crtc1;
	struct {
		struct matrox_vsync vsync;
		unsigned int pixclock;
		int mnp;
		struct matroxfb_dh_fb_info *info;
		struct rw_semaphore lock;
	} crtc2;
	struct {
		struct rw_semaphore lock;
		struct {
			int brightness;
			int contrast;
			int saturation;
			int hue;
			int gamma;
			int testout;
			int deflicker;
		} tvo_params;
	} altout;
	struct {
		unsigned int src;
		struct matrox_altout *output;
		void *data;
		unsigned int mode;
		unsigned int default_src;
	} outputs[3];
	struct matroxfb_driver *drivers[5];
	void *drivers_data[5];
	unsigned int drivers_count;
	struct {
		long unsigned int base;
		vaddr_t vbase;
		unsigned int len;
		unsigned int len_usable;
		unsigned int len_maximum;
	} video;
	struct {
		long unsigned int base;
		vaddr_t vbase;
		unsigned int len;
	} mmio;
	unsigned int max_pixel_clock;
	unsigned int max_pixel_clock_panellink;
	struct matrox_switch *hw_switch;
	struct {
		struct matrox_pll_features pll;
		struct matrox_DAC1064_features DAC1064;
	} features;
	struct {
		spinlock_t DAC;
		spinlock_t accel;
	} lock;
	enum mga_chip chip;
	int interleave;
	int millenium;
	int milleniumII;
	struct {
		int cfb4;
		const int *vxres;
		int cross4MB;
		int text;
		int plnwt;
		int srcorg;
	} capable;
	int wc_cookie;
	struct {
		int precise_width;
		int mga_24bpp_fix;
		int novga;
		int nobios;
		int nopciretry;
		int noinit;
		int sgram;
		int support32MB;
		int accelerator;
		int text_type_aux;
		int video64bits;
		int crtc2;
		int maven_capable;
		unsigned int vgastep;
		unsigned int textmode;
		unsigned int textstep;
		unsigned int textvram;
		unsigned int ydstorg;
		int memtype;
		int g450dac;
		int dfp_type;
		int panellink;
		int dualhead;
		unsigned int fbResource;
	} devflags;
	struct fb_ops fbops;
	struct matrox_bios bios;
	struct {
		struct matrox_pll_limits pixel;
		struct matrox_pll_limits system;
		struct matrox_pll_limits video;
	} limits;
	struct {
		struct matrox_pll_cache pixel;
		struct matrox_pll_cache system;
		struct matrox_pll_cache video;
	} cache;
	struct {
		struct {
			unsigned int video;
			unsigned int system;
		} pll;
		struct {
			u_int32_t opt;
			u_int32_t opt2;
			u_int32_t opt3;
			u_int32_t mctlwtst;
			u_int32_t mctlwtst_core;
			u_int32_t memmisc;
			u_int32_t memrdbk;
			u_int32_t maccess;
		} reg;
		struct {
			unsigned int ddr: 1;
			unsigned int emrswen: 1;
			unsigned int dll: 1;
		} memory;
	} values;
	u_int32_t cmap[16];
};

struct matroxfb_driver {
	struct list_head node;
	char *name;
	void * (*probe)(struct matrox_fb_info *);
	void (*remove)(struct matrox_fb_info *, void *);
};

struct matrox_switch {
	int (*preinit)(struct matrox_fb_info *);
	void (*reset)(struct matrox_fb_info *);
	int (*init)(struct matrox_fb_info *, struct my_timming *);
	void (*restore)(struct matrox_fb_info *);
};

enum v4l2_preemphasis {
	V4L2_PREEMPHASIS_DISABLED = 0,
	V4L2_PREEMPHASIS_50_uS = 1,
	V4L2_PREEMPHASIS_75_uS = 2,
};

enum v4l2_av1_segment_feature {
	V4L2_AV1_SEG_LVL_ALT_Q = 0,
	V4L2_AV1_SEG_LVL_ALT_LF_Y_V = 1,
	V4L2_AV1_SEG_LVL_REF_FRAME = 5,
	V4L2_AV1_SEG_LVL_REF_SKIP = 6,
	V4L2_AV1_SEG_LVL_REF_GLOBALMV = 7,
	V4L2_AV1_SEG_LVL_MAX = 8,
};

struct regulator;

struct rt_mutex {
	struct rt_mutex_base rtmutex;
};

struct i2c_msg {
	__u16 addr;
	__u16 flags;
	__u16 len;
	__u8 *buf;
};

union i2c_smbus_data {
	__u8 byte;
	__u16 word;
	__u8 block[34];
};

struct i2c_algorithm;

struct i2c_lock_operations;

struct i2c_bus_recovery_info;

struct i2c_adapter_quirks;

struct i2c_adapter {
	struct module *owner;
	unsigned int class;
	const struct i2c_algorithm *algo;
	void *algo_data;
	const struct i2c_lock_operations *lock_ops;
	struct rt_mutex bus_lock;
	struct rt_mutex mux_lock;
	int timeout;
	int retries;
	struct device dev;
	long unsigned int locked_flags;
	int nr;
	char name[48];
	struct completion dev_released;
	struct mutex userspace_clients_lock;
	struct list_head userspace_clients;
	struct i2c_bus_recovery_info *bus_recovery_info;
	const struct i2c_adapter_quirks *quirks;
	struct irq_domain *host_notify_domain;
	struct regulator *bus_regulator;
};

struct i2c_algorithm {
	int (*master_xfer)(struct i2c_adapter *, struct i2c_msg *, int);
	int (*master_xfer_atomic)(struct i2c_adapter *, struct i2c_msg *, int);
	int (*smbus_xfer)(struct i2c_adapter *, u16, short unsigned int, char, u8, int, union i2c_smbus_data *);
	int (*smbus_xfer_atomic)(struct i2c_adapter *, u16, short unsigned int, char, u8, int, union i2c_smbus_data *);
	u32 (*functionality)(struct i2c_adapter *);
};

struct i2c_lock_operations {
	void (*lock_bus)(struct i2c_adapter *, unsigned int);
	int (*trylock_bus)(struct i2c_adapter *, unsigned int);
	void (*unlock_bus)(struct i2c_adapter *, unsigned int);
};

struct gpio_desc;

struct pinctrl;

struct pinctrl_state;

struct i2c_bus_recovery_info {
	int (*recover_bus)(struct i2c_adapter *);
	int (*get_scl)(struct i2c_adapter *);
	void (*set_scl)(struct i2c_adapter *, int);
	int (*get_sda)(struct i2c_adapter *);
	void (*set_sda)(struct i2c_adapter *, int);
	int (*get_bus_free)(struct i2c_adapter *);
	void (*prepare_recovery)(struct i2c_adapter *);
	void (*unprepare_recovery)(struct i2c_adapter *);
	struct gpio_desc *scl_gpiod;
	struct gpio_desc *sda_gpiod;
	struct pinctrl *pinctrl;
	struct pinctrl_state *pins_default;
	struct pinctrl_state *pins_gpio;
};

struct i2c_adapter_quirks {
	u64 flags;
	int max_num_msgs;
	u16 max_write_len;
	u16 max_read_len;
	u16 max_comb_1st_msg_len;
	u16 max_comb_2nd_msg_len;
};

struct i2c_algo_bit_data {
	void *data;
	void (*setsda)(void *, int);
	void (*setscl)(void *, int);
	int (*getsda)(void *);
	int (*getscl)(void *);
	int (*pre_xfer)(struct i2c_adapter *);
	void (*post_xfer)(struct i2c_adapter *);
	int udelay;
	int timeout;
	bool can_do_atomic;
};

enum radeon_montype {
	MT_NONE = 0,
	MT_CRT = 1,
	MT_LCD = 2,
	MT_DFP = 3,
	MT_CTV = 4,
	MT_STV = 5,
};

struct pll_info {
	int ppll_max;
	int ppll_min;
	int sclk;
	int mclk;
	int ref_div;
	int ref_clk;
};

struct radeon_regs {
	u32 ovr_clr;
	u32 ovr_wid_left_right;
	u32 ovr_wid_top_bottom;
	u32 ov0_scale_cntl;
	u32 mpp_tb_config;
	u32 mpp_gp_config;
	u32 subpic_cntl;
	u32 viph_control;
	u32 i2c_cntl_1;
	u32 gen_int_cntl;
	u32 cap0_trig_cntl;
	u32 cap1_trig_cntl;
	u32 bus_cntl;
	u32 surface_cntl;
	u32 bios_5_scratch;
	u32 dp_datatype;
	u32 rbbm_soft_reset;
	u32 clock_cntl_index;
	u32 amcgpio_en_reg;
	u32 amcgpio_mask;
	u32 surf_lower_bound[8];
	u32 surf_upper_bound[8];
	u32 surf_info[8];
	u32 crtc_gen_cntl;
	u32 crtc_ext_cntl;
	u32 dac_cntl;
	u32 crtc_h_total_disp;
	u32 crtc_h_sync_strt_wid;
	u32 crtc_v_total_disp;
	u32 crtc_v_sync_strt_wid;
	u32 crtc_offset;
	u32 crtc_offset_cntl;
	u32 crtc_pitch;
	u32 disp_merge_cntl;
	u32 grph_buffer_cntl;
	u32 crtc_more_cntl;
	u32 crtc2_gen_cntl;
	u32 dac2_cntl;
	u32 disp_output_cntl;
	u32 disp_hw_debug;
	u32 disp2_merge_cntl;
	u32 grph2_buffer_cntl;
	u32 crtc2_h_total_disp;
	u32 crtc2_h_sync_strt_wid;
	u32 crtc2_v_total_disp;
	u32 crtc2_v_sync_strt_wid;
	u32 crtc2_offset;
	u32 crtc2_offset_cntl;
	u32 crtc2_pitch;
	u32 fp_crtc_h_total_disp;
	u32 fp_crtc_v_total_disp;
	u32 fp_gen_cntl;
	u32 fp2_gen_cntl;
	u32 fp_h_sync_strt_wid;
	u32 fp2_h_sync_strt_wid;
	u32 fp_horz_stretch;
	u32 fp_panel_cntl;
	u32 fp_v_sync_strt_wid;
	u32 fp2_v_sync_strt_wid;
	u32 fp_vert_stretch;
	u32 lvds_gen_cntl;
	u32 lvds_pll_cntl;
	u32 tmds_crc;
	u32 tmds_transmitter_cntl;
	u32 dot_clock_freq;
	int feedback_div;
	int post_div;
	u32 ppll_div_3;
	u32 ppll_ref_div;
	u32 vclk_ecp_cntl;
	u32 clk_cntl_index;
	u32 dot_clock_freq_2;
	int feedback_div_2;
	int post_div_2;
	u32 p2pll_ref_div;
	u32 p2pll_div_0;
	u32 htotal_cntl2;
	int palette_valid;
};

struct panel_info {
	int xres;
	int yres;
	int valid;
	int clock;
	int hOver_plus;
	int hSync_width;
	int hblank;
	int vOver_plus;
	int vSync_width;
	int vblank;
	int hAct_high;
	int vAct_high;
	int interlaced;
	int pwr_delay;
	int use_bios_dividers;
	int ref_divider;
	int post_divider;
	int fbk_divider;
};

struct radeonfb_info;

struct radeon_i2c_chan {
	struct radeonfb_info *rinfo;
	u32 ddc_reg;
	struct i2c_adapter adapter;
	struct i2c_algo_bit_data algo;
};

enum radeon_pm_mode {
	radeon_pm_none = 0,
	radeon_pm_d2 = 1,
	radeon_pm_off = 2,
};

typedef void (*reinit_function_ptr)(struct radeonfb_info *);

struct radeonfb_info {
	struct fb_info *info;
	struct radeon_regs state;
	struct radeon_regs init_state;
	char name[50];
	long unsigned int mmio_base_phys;
	long unsigned int fb_base_phys;
	void *mmio_base;
	void *fb_base;
	long unsigned int fb_local_base;
	struct pci_dev *pdev;
	struct device_node *of_node;
	void *bios_seg;
	int fp_bios_start;
	u32 pseudo_palette[16];
	struct {
		u8 red;
		u8 green;
		u8 blue;
		u8 pad;
	} palette[256];
	int chipset;
	u8 family;
	u8 rev;
	unsigned int errata;
	long unsigned int video_ram;
	long unsigned int mapped_vram;
	int vram_width;
	int vram_ddr;
	int pitch;
	int bpp;
	int depth;
	int has_CRTC2;
	int is_mobility;
	int is_IGP;
	int reversed_DAC;
	int reversed_TMDS;
	struct panel_info panel_info;
	int mon1_type;
	u8 *mon1_EDID;
	struct fb_videomode *mon1_modedb;
	int mon1_dbsize;
	int mon2_type;
	u8 *mon2_EDID;
	u32 dp_gui_master_cntl;
	struct pll_info pll;
	int wc_cookie;
	u32 save_regs[100];
	int asleep;
	int lock_blank;
	int dynclk;
	int no_schedule;
	enum radeon_pm_mode pm_mode;
	reinit_function_ptr reinit_func;
	spinlock_t reg_lock;
	struct timer_list lvds_timer;
	u32 pending_lvds_gen_cntl;
	struct radeon_i2c_chan i2c[4];
};

struct termios {
	tcflag_t c_iflag;
	tcflag_t c_oflag;
	tcflag_t c_cflag;
	tcflag_t c_lflag;
	cc_t c_cc[19];
	cc_t c_line;
	speed_t c_ispeed;
	speed_t c_ospeed;
};

struct sgttyb {
	char sg_ispeed;
	char sg_ospeed;
	char sg_erase;
	char sg_kill;
	short int sg_flags;
};

struct tchars {
	char t_intrc;
	char t_quitc;
	char t_startc;
	char t_stopc;
	char t_eofc;
	char t_brkc;
};

struct ltchars {
	char t_suspc;
	char t_dsuspc;
	char t_rprntc;
	char t_flushc;
	char t_werasc;
	char t_lnextc;
};

struct termio {
	short unsigned int c_iflag;
	short unsigned int c_oflag;
	short unsigned int c_cflag;
	short unsigned int c_lflag;
	unsigned char c_line;
	unsigned char c_cc[10];
};

enum vc_intensity {
	VCI_HALF_BRIGHT = 0,
	VCI_NORMAL = 1,
	VCI_BOLD = 2,
	VCI_MASK = 3,
};

struct vc_state {
	unsigned int x;
	unsigned int y;
	unsigned char color;
	unsigned char Gx_charset[2];
	unsigned int charset: 1;
	enum vc_intensity intensity;
	bool italic;
	bool underline;
	bool blink;
	bool reverse;
};

struct console_font {
	unsigned int width;
	unsigned int height;
	unsigned int charcount;
	unsigned char *data;
};

struct vt_mode {
	char mode;
	char waitv;
	short int relsig;
	short int acqsig;
	short int frsig;
};

struct consw;

struct uni_pagedict;

struct vc_data {
	struct tty_port port;
	struct vc_state state;
	struct vc_state saved_state;
	short unsigned int vc_num;
	unsigned int vc_cols;
	unsigned int vc_rows;
	unsigned int vc_size_row;
	unsigned int vc_scan_lines;
	unsigned int vc_cell_height;
	long unsigned int vc_origin;
	long unsigned int vc_scr_end;
	long unsigned int vc_visible_origin;
	unsigned int vc_top;
	unsigned int vc_bottom;
	const struct consw *vc_sw;
	short unsigned int *vc_screenbuf;
	unsigned int vc_screenbuf_size;
	unsigned char vc_mode;
	unsigned char vc_attr;
	unsigned char vc_def_color;
	unsigned char vc_ulcolor;
	unsigned char vc_itcolor;
	unsigned char vc_halfcolor;
	unsigned int vc_cursor_type;
	short unsigned int vc_complement_mask;
	short unsigned int vc_s_complement_mask;
	long unsigned int vc_pos;
	short unsigned int vc_hi_font_mask;
	struct console_font vc_font;
	short unsigned int vc_video_erase_char;
	unsigned int vc_state;
	unsigned int vc_npar;
	unsigned int vc_par[16];
	struct vt_mode vt_mode;
	struct pid *vt_pid;
	int vt_newvt;
	wait_queue_head_t paste_wait;
	unsigned int vc_disp_ctrl: 1;
	unsigned int vc_toggle_meta: 1;
	unsigned int vc_decscnm: 1;
	unsigned int vc_decom: 1;
	unsigned int vc_decawm: 1;
	unsigned int vc_deccm: 1;
	unsigned int vc_decim: 1;
	unsigned int vc_priv: 3;
	unsigned int vc_need_wrap: 1;
	unsigned int vc_can_do_color: 1;
	unsigned int vc_report_mouse: 2;
	unsigned char vc_utf: 1;
	unsigned char vc_utf_count;
	int vc_utf_char;
	long unsigned int vc_tab_stop[4];
	unsigned char vc_palette[48];
	short unsigned int *vc_translate;
	unsigned int vc_resize_user;
	unsigned int vc_bell_pitch;
	unsigned int vc_bell_duration;
	short unsigned int vc_cur_blink_ms;
	struct vc_data **vc_display_fg;
	struct uni_pagedict *uni_pagedict;
	struct uni_pagedict **uni_pagedict_loc;
	u32 **vc_uni_lines;
};

enum con_scroll {
	SM_UP = 0,
	SM_DOWN = 1,
};

struct consw {
	struct module *owner;
	const char * (*con_startup)();
	void (*con_init)(struct vc_data *, int);
	void (*con_deinit)(struct vc_data *);
	void (*con_clear)(struct vc_data *, int, int, int, int);
	void (*con_putc)(struct vc_data *, int, int, int);
	void (*con_putcs)(struct vc_data *, const short unsigned int *, int, int, int);
	void (*con_cursor)(struct vc_data *, int);
	bool (*con_scroll)(struct vc_data *, unsigned int, unsigned int, enum con_scroll, unsigned int);
	int (*con_switch)(struct vc_data *);
	int (*con_blank)(struct vc_data *, int, int);
	int (*con_font_set)(struct vc_data *, struct console_font *, unsigned int, unsigned int);
	int (*con_font_get)(struct vc_data *, struct console_font *, unsigned int);
	int (*con_font_default)(struct vc_data *, struct console_font *, char *);
	int (*con_resize)(struct vc_data *, unsigned int, unsigned int, unsigned int);
	void (*con_set_palette)(struct vc_data *, const unsigned char *);
	void (*con_scrolldelta)(struct vc_data *, int);
	int (*con_set_origin)(struct vc_data *);
	void (*con_save_screen)(struct vc_data *);
	u8 (*con_build_attr)(struct vc_data *, u8, enum vc_intensity, bool, bool, bool, bool);
	void (*con_invert_region)(struct vc_data *, u16 *, int);
	u16 * (*con_screen_pos)(const struct vc_data *, int);
	long unsigned int (*con_getxy)(struct vc_data *, long unsigned int, int *, int *);
	void (*con_flush_scrollback)(struct vc_data *);
	int (*con_debug_enter)(struct vc_data *);
	int (*con_debug_leave)(struct vc_data *);
};

struct vc {
	struct vc_data *d;
	struct work_struct SAK_work;
};

struct tiocl_selection {
	short unsigned int xs;
	short unsigned int ys;
	short unsigned int xe;
	short unsigned int ye;
	short unsigned int sel_mode;
};

struct vc_selection {
	struct mutex lock;
	struct vc_data *cons;
	char *buffer;
	unsigned int buf_len;
	volatile int start;
	int end;
};

struct platform_driver {
	int (*probe)(struct platform_device *);
	int (*remove)(struct platform_device *);
	void (*remove_new)(struct platform_device *);
	void (*shutdown)(struct platform_device *);
	int (*suspend)(struct platform_device *, pm_message_t);
	int (*resume)(struct platform_device *);
	struct device_driver driver;
	const struct platform_device_id *id_table;
	bool prevent_deferred_probe;
	bool driver_managed_dma;
};

struct hvsi_priv {
	unsigned int inbuf_len;
	unsigned char inbuf[255];
	unsigned int inbuf_cur;
	unsigned int inbuf_pktlen;
	atomic_t seqno;
	unsigned int opened: 1;
	unsigned int established: 1;
	unsigned int is_console: 1;
	unsigned int mctrl_update: 1;
	short unsigned int mctrl;
	struct tty_struct *tty;
	int (*get_chars)(uint32_t, char *, int);
	int (*put_chars)(uint32_t, const char *, int);
	uint32_t termno;
};

enum OpalPendingState {
	OPAL_EVENT_OPAL_INTERNAL = 1,
	OPAL_EVENT_NVRAM = 2,
	OPAL_EVENT_RTC = 4,
	OPAL_EVENT_CONSOLE_OUTPUT = 8,
	OPAL_EVENT_CONSOLE_INPUT = 16,
	OPAL_EVENT_ERROR_LOG_AVAIL = 32,
	OPAL_EVENT_ERROR_LOG = 64,
	OPAL_EVENT_EPOW = 128,
	OPAL_EVENT_LED_STATUS = 256,
	OPAL_EVENT_PCI_ERROR = 512,
	OPAL_EVENT_DUMP_AVAIL = 1024,
	OPAL_EVENT_MSG_PENDING = 2048,
};

struct hv_ops;

struct hvc_struct {
	struct tty_port port;
	spinlock_t lock;
	int index;
	int do_wakeup;
	char *outbuf;
	int outbuf_size;
	int n_outbuf;
	uint32_t vtermno;
	const struct hv_ops *ops;
	int irq_requested;
	int data;
	struct winsize ws;
	struct work_struct tty_resize;
	struct list_head next;
	long unsigned int flags;
};

struct hv_ops {
	int (*get_chars)(uint32_t, char *, int);
	int (*put_chars)(uint32_t, const char *, int);
	int (*flush)(uint32_t, bool);
	int (*notifier_add)(struct hvc_struct *, int);
	void (*notifier_del)(struct hvc_struct *, int);
	void (*notifier_hangup)(struct hvc_struct *, int);
	int (*tiocmget)(struct hvc_struct *);
	int (*tiocmset)(struct hvc_struct *, unsigned int, unsigned int);
	void (*dtr_rts)(struct hvc_struct *, bool);
};

enum hv_protocol {
	HV_PROTOCOL_RAW = 0,
	HV_PROTOCOL_HVSI = 1,
};

typedef enum hv_protocol hv_protocol_t;

struct hvc_opal_priv {
	hv_protocol_t proto;
	struct hvsi_priv hvsi;
};

enum {
	KERNEL_PARAM_FL_UNSAFE = 1,
	KERNEL_PARAM_FL_HWPARAM = 2,
};

enum hwparam_type {
	hwparam_ioport = 0,
	hwparam_iomem = 1,
	hwparam_ioport_or_iomem = 2,
	hwparam_irq = 3,
	hwparam_dma = 4,
	hwparam_dma_addr = 5,
	hwparam_other = 6,
};

struct serial_icounter_struct {
	int cts;
	int dsr;
	int rng;
	int dcd;
	int rx;
	int tx;
	int frame;
	int overrun;
	int parity;
	int brk;
	int buf_overrun;
	int reserved[9];
};

struct serial_struct {
	int type;
	int line;
	unsigned int port;
	int irq;
	int flags;
	int xmit_fifo_size;
	int custom_divisor;
	int baud_base;
	short unsigned int close_delay;
	char io_type;
	char reserved_char[1];
	int hub6;
	short unsigned int closing_wait;
	short unsigned int closing_wait2;
	unsigned char *iomem_base;
	short unsigned int iomem_reg_shift;
	unsigned int port_high;
	long unsigned int iomap_base;
};

struct serial_rs485 {
	__u32 flags;
	__u32 delay_rts_before_send;
	__u32 delay_rts_after_send;
	union {
		__u32 padding[5];
		struct {
			__u8 addr_recv;
			__u8 addr_dest;
			__u8 padding0[2];
			__u32 padding1[4];
		};
	};
};

struct serial_iso7816 {
	__u32 flags;
	__u32 tg;
	__u32 sc_fi;
	__u32 sc_di;
	__u32 clk;
	__u32 reserved[5];
};

struct circ_buf {
	char *buf;
	int head;
	int tail;
};

struct uart_port;

struct uart_ops {
	unsigned int (*tx_empty)(struct uart_port *);
	void (*set_mctrl)(struct uart_port *, unsigned int);
	unsigned int (*get_mctrl)(struct uart_port *);
	void (*stop_tx)(struct uart_port *);
	void (*start_tx)(struct uart_port *);
	void (*throttle)(struct uart_port *);
	void (*unthrottle)(struct uart_port *);
	void (*send_xchar)(struct uart_port *, char);
	void (*stop_rx)(struct uart_port *);
	void (*start_rx)(struct uart_port *);
	void (*enable_ms)(struct uart_port *);
	void (*break_ctl)(struct uart_port *, int);
	int (*startup)(struct uart_port *);
	void (*shutdown)(struct uart_port *);
	void (*flush_buffer)(struct uart_port *);
	void (*set_termios)(struct uart_port *, struct ktermios *, const struct ktermios *);
	void (*set_ldisc)(struct uart_port *, struct ktermios *);
	void (*pm)(struct uart_port *, unsigned int, unsigned int);
	const char * (*type)(struct uart_port *);
	void (*release_port)(struct uart_port *);
	int (*request_port)(struct uart_port *);
	void (*config_port)(struct uart_port *, int);
	int (*verify_port)(struct uart_port *, struct serial_struct *);
	int (*ioctl)(struct uart_port *, unsigned int, long unsigned int);
};

struct uart_icount {
	__u32 cts;
	__u32 dsr;
	__u32 rng;
	__u32 dcd;
	__u32 rx;
	__u32 tx;
	__u32 frame;
	__u32 overrun;
	__u32 parity;
	__u32 brk;
	__u32 buf_overrun;
};

typedef u64 upf_t;

typedef unsigned int upstat_t;

struct uart_state;

struct serial_port_device;

struct uart_port {
	spinlock_t lock;
	long unsigned int iobase;
	unsigned char *membase;
	unsigned int (*serial_in)(struct uart_port *, int);
	void (*serial_out)(struct uart_port *, int, int);
	void (*set_termios)(struct uart_port *, struct ktermios *, const struct ktermios *);
	void (*set_ldisc)(struct uart_port *, struct ktermios *);
	unsigned int (*get_mctrl)(struct uart_port *);
	void (*set_mctrl)(struct uart_port *, unsigned int);
	unsigned int (*get_divisor)(struct uart_port *, unsigned int, unsigned int *);
	void (*set_divisor)(struct uart_port *, unsigned int, unsigned int, unsigned int);
	int (*startup)(struct uart_port *);
	void (*shutdown)(struct uart_port *);
	void (*throttle)(struct uart_port *);
	void (*unthrottle)(struct uart_port *);
	int (*handle_irq)(struct uart_port *);
	void (*pm)(struct uart_port *, unsigned int, unsigned int);
	void (*handle_break)(struct uart_port *);
	int (*rs485_config)(struct uart_port *, struct ktermios *, struct serial_rs485 *);
	int (*iso7816_config)(struct uart_port *, struct serial_iso7816 *);
	unsigned int ctrl_id;
	unsigned int port_id;
	unsigned int irq;
	long unsigned int irqflags;
	unsigned int uartclk;
	unsigned int fifosize;
	unsigned char x_char;
	unsigned char regshift;
	unsigned char iotype;
	unsigned char quirks;
	unsigned int read_status_mask;
	unsigned int ignore_status_mask;
	struct uart_state *state;
	struct uart_icount icount;
	struct console *cons;
	upf_t flags;
	upstat_t status;
	bool hw_stopped;
	unsigned int mctrl;
	unsigned int frame_time;
	unsigned int type;
	const struct uart_ops *ops;
	unsigned int custom_divisor;
	unsigned int line;
	unsigned int minor;
	resource_size_t mapbase;
	resource_size_t mapsize;
	struct device *dev;
	struct serial_port_device *port_dev;
	long unsigned int sysrq;
	u8 sysrq_ch;
	unsigned char has_sysrq;
	unsigned char sysrq_seq;
	unsigned char hub6;
	unsigned char suspended;
	unsigned char console_reinit;
	const char *name;
	struct attribute_group *attr_group;
	const struct attribute_group **tty_groups;
	struct serial_rs485 rs485;
	struct serial_rs485 rs485_supported;
	struct gpio_desc *rs485_term_gpio;
	struct gpio_desc *rs485_rx_during_tx_gpio;
	struct serial_iso7816 iso7816;
	void *private_data;
};

enum uart_pm_state {
	UART_PM_STATE_ON = 0,
	UART_PM_STATE_OFF = 3,
	UART_PM_STATE_UNDEFINED = 4,
};

struct uart_state {
	struct tty_port port;
	enum uart_pm_state pm_state;
	struct circ_buf xmit;
	atomic_t refcount;
	wait_queue_head_t remove_wait;
	struct uart_port *uart_port;
};

struct uart_driver {
	struct module *owner;
	const char *driver_name;
	const char *dev_name;
	int major;
	int minor;
	int nr;
	struct console *cons;
	struct uart_state *state;
	struct tty_driver *tty_driver;
};

struct uart_8250_port;

struct plat_serial8250_port {
	long unsigned int iobase;
	void *membase;
	resource_size_t mapbase;
	resource_size_t mapsize;
	unsigned int uartclk;
	unsigned int irq;
	long unsigned int irqflags;
	void *private_data;
	unsigned char regshift;
	unsigned char iotype;
	unsigned char hub6;
	unsigned char has_sysrq;
	unsigned int type;
	upf_t flags;
	u16 bugs;
	unsigned int (*serial_in)(struct uart_port *, int);
	void (*serial_out)(struct uart_port *, int, int);
	u32 (*dl_read)(struct uart_8250_port *);
	void (*dl_write)(struct uart_8250_port *, u32);
	void (*set_termios)(struct uart_port *, struct ktermios *, const struct ktermios *);
	void (*set_ldisc)(struct uart_port *, struct ktermios *);
	unsigned int (*get_mctrl)(struct uart_port *);
	int (*handle_irq)(struct uart_port *);
	void (*pm)(struct uart_port *, unsigned int, unsigned int);
	void (*handle_break)(struct uart_port *);
};

struct mctrl_gpios;

struct uart_8250_dma;

struct uart_8250_ops;

struct uart_8250_em485;

struct uart_8250_port {
	struct uart_port port;
	struct timer_list timer;
	struct list_head list;
	u32 capabilities;
	u16 bugs;
	unsigned int tx_loadsz;
	unsigned char acr;
	unsigned char fcr;
	unsigned char ier;
	unsigned char lcr;
	unsigned char mcr;
	unsigned char cur_iotype;
	unsigned int rpm_tx_active;
	unsigned char canary;
	unsigned char probe;
	struct mctrl_gpios *gpios;
	u16 lsr_saved_flags;
	u16 lsr_save_mask;
	unsigned char msr_saved_flags;
	struct uart_8250_dma *dma;
	const struct uart_8250_ops *ops;
	u32 (*dl_read)(struct uart_8250_port *);
	void (*dl_write)(struct uart_8250_port *, u32);
	struct uart_8250_em485 *em485;
	void (*rs485_start_tx)(struct uart_8250_port *);
	void (*rs485_stop_tx)(struct uart_8250_port *);
	struct delayed_work overrun_backoff;
	u32 overrun_backoff_time_ms;
};

enum {
	PLAT8250_DEV_LEGACY = -1,
	PLAT8250_DEV_PLATFORM = 0,
	PLAT8250_DEV_PLATFORM1 = 1,
	PLAT8250_DEV_PLATFORM2 = 2,
	PLAT8250_DEV_FOURPORT = 3,
	PLAT8250_DEV_ACCENT = 4,
	PLAT8250_DEV_BOCA = 5,
	PLAT8250_DEV_EXAR_ST16C554 = 6,
	PLAT8250_DEV_HUB6 = 7,
	PLAT8250_DEV_AU1X00 = 8,
	PLAT8250_DEV_SM501 = 9,
};

struct uart_8250_ops {
	int (*setup_irq)(struct uart_8250_port *);
	void (*release_irq)(struct uart_8250_port *);
	void (*setup_timer)(struct uart_8250_port *);
};

struct uart_8250_em485 {
	struct hrtimer start_tx_timer;
	struct hrtimer stop_tx_timer;
	struct hrtimer *active_timer;
	struct uart_8250_port *port;
	unsigned int tx_stopped: 1;
};

struct dma_chan;

typedef bool (*dma_filter_fn)(struct dma_chan *, void *);

enum dma_transfer_direction {
	DMA_MEM_TO_MEM = 0,
	DMA_MEM_TO_DEV = 1,
	DMA_DEV_TO_MEM = 2,
	DMA_DEV_TO_DEV = 3,
	DMA_TRANS_NONE = 4,
};

enum dma_slave_buswidth {
	DMA_SLAVE_BUSWIDTH_UNDEFINED = 0,
	DMA_SLAVE_BUSWIDTH_1_BYTE = 1,
	DMA_SLAVE_BUSWIDTH_2_BYTES = 2,
	DMA_SLAVE_BUSWIDTH_3_BYTES = 3,
	DMA_SLAVE_BUSWIDTH_4_BYTES = 4,
	DMA_SLAVE_BUSWIDTH_8_BYTES = 8,
	DMA_SLAVE_BUSWIDTH_16_BYTES = 16,
	DMA_SLAVE_BUSWIDTH_32_BYTES = 32,
	DMA_SLAVE_BUSWIDTH_64_BYTES = 64,
	DMA_SLAVE_BUSWIDTH_128_BYTES = 128,
};

struct dma_slave_config {
	enum dma_transfer_direction direction;
	phys_addr_t src_addr;
	phys_addr_t dst_addr;
	enum dma_slave_buswidth src_addr_width;
	enum dma_slave_buswidth dst_addr_width;
	u32 src_maxburst;
	u32 dst_maxburst;
	u32 src_port_window_size;
	u32 dst_port_window_size;
	bool device_fc;
	void *peripheral_config;
	size_t peripheral_size;
};

typedef s32 dma_cookie_t;

struct uart_8250_dma {
	int (*tx_dma)(struct uart_8250_port *);
	int (*rx_dma)(struct uart_8250_port *);
	void (*prepare_tx_dma)(struct uart_8250_port *);
	void (*prepare_rx_dma)(struct uart_8250_port *);
	dma_filter_fn fn;
	void *rx_param;
	void *tx_param;
	struct dma_slave_config rxconf;
	struct dma_slave_config txconf;
	struct dma_chan *rxchan;
	struct dma_chan *txchan;
	phys_addr_t rx_dma_addr;
	phys_addr_t tx_dma_addr;
	dma_addr_t rx_addr;
	dma_addr_t tx_addr;
	dma_cookie_t rx_cookie;
	dma_cookie_t tx_cookie;
	void *rx_buf;
	size_t rx_size;
	size_t tx_size;
	unsigned char tx_running;
	unsigned char tx_err;
	unsigned char rx_running;
};

enum dma_status {
	DMA_COMPLETE = 0,
	DMA_IN_PROGRESS = 1,
	DMA_PAUSED = 2,
	DMA_ERROR = 3,
	DMA_OUT_OF_ORDER = 4,
};

enum dma_transaction_type {
	DMA_MEMCPY = 0,
	DMA_XOR = 1,
	DMA_PQ = 2,
	DMA_XOR_VAL = 3,
	DMA_PQ_VAL = 4,
	DMA_MEMSET = 5,
	DMA_MEMSET_SG = 6,
	DMA_INTERRUPT = 7,
	DMA_PRIVATE = 8,
	DMA_ASYNC_TX = 9,
	DMA_SLAVE = 10,
	DMA_CYCLIC = 11,
	DMA_INTERLEAVE = 12,
	DMA_COMPLETION_NO_ORDER = 13,
	DMA_REPEAT = 14,
	DMA_LOAD_EOT = 15,
	DMA_TX_TYPE_END = 16,
};

struct data_chunk {
	size_t size;
	size_t icg;
	size_t dst_icg;
	size_t src_icg;
};

struct dma_interleaved_template {
	dma_addr_t src_start;
	dma_addr_t dst_start;
	enum dma_transfer_direction dir;
	bool src_inc;
	bool dst_inc;
	bool src_sgl;
	bool dst_sgl;
	size_t numf;
	size_t frame_size;
	struct data_chunk sgl[0];
};

enum dma_ctrl_flags {
	DMA_PREP_INTERRUPT = 1,
	DMA_CTRL_ACK = 2,
	DMA_PREP_PQ_DISABLE_P = 4,
	DMA_PREP_PQ_DISABLE_Q = 8,
	DMA_PREP_CONTINUE = 16,
	DMA_PREP_FENCE = 32,
	DMA_CTRL_REUSE = 64,
	DMA_PREP_CMD = 128,
	DMA_PREP_REPEAT = 256,
	DMA_PREP_LOAD_EOT = 512,
};

enum sum_check_bits {
	SUM_CHECK_P = 0,
	SUM_CHECK_Q = 1,
};

enum sum_check_flags {
	SUM_CHECK_P_RESULT = 1,
	SUM_CHECK_Q_RESULT = 2,
};

typedef struct {
	long unsigned int bits[1];
} dma_cap_mask_t;

enum dma_desc_metadata_mode {
	DESC_METADATA_NONE = 0,
	DESC_METADATA_CLIENT = 1,
	DESC_METADATA_ENGINE = 2,
};

struct dma_chan_percpu {
	long unsigned int memcpy_count;
	long unsigned int bytes_transferred;
};

struct dma_router {
	struct device *dev;
	void (*route_free)(struct device *, void *);
};

struct dma_device;

struct dma_chan_dev;

struct dma_chan {
	struct dma_device *device;
	struct device *slave;
	dma_cookie_t cookie;
	dma_cookie_t completed_cookie;
	int chan_id;
	struct dma_chan_dev *dev;
	const char *name;
	char *dbg_client_name;
	struct list_head device_node;
	struct dma_chan_percpu *local;
	int client_count;
	int table_count;
	struct dma_router *router;
	void *route_data;
	void *private;
};

struct dma_slave_map;

struct dma_filter {
	dma_filter_fn fn;
	int mapcnt;
	const struct dma_slave_map *map;
};

enum dmaengine_alignment {
	DMAENGINE_ALIGN_1_BYTE = 0,
	DMAENGINE_ALIGN_2_BYTES = 1,
	DMAENGINE_ALIGN_4_BYTES = 2,
	DMAENGINE_ALIGN_8_BYTES = 3,
	DMAENGINE_ALIGN_16_BYTES = 4,
	DMAENGINE_ALIGN_32_BYTES = 5,
	DMAENGINE_ALIGN_64_BYTES = 6,
	DMAENGINE_ALIGN_128_BYTES = 7,
	DMAENGINE_ALIGN_256_BYTES = 8,
};

enum dma_residue_granularity {
	DMA_RESIDUE_GRANULARITY_DESCRIPTOR = 0,
	DMA_RESIDUE_GRANULARITY_SEGMENT = 1,
	DMA_RESIDUE_GRANULARITY_BURST = 2,
};

struct dma_async_tx_descriptor;

struct dma_slave_caps;

struct dma_tx_state;

struct dma_device {
	struct kref ref;
	unsigned int chancnt;
	unsigned int privatecnt;
	struct list_head channels;
	struct list_head global_node;
	struct dma_filter filter;
	dma_cap_mask_t cap_mask;
	enum dma_desc_metadata_mode desc_metadata_modes;
	short unsigned int max_xor;
	short unsigned int max_pq;
	enum dmaengine_alignment copy_align;
	enum dmaengine_alignment xor_align;
	enum dmaengine_alignment pq_align;
	enum dmaengine_alignment fill_align;
	int dev_id;
	struct device *dev;
	struct module *owner;
	struct ida chan_ida;
	u32 src_addr_widths;
	u32 dst_addr_widths;
	u32 directions;
	u32 min_burst;
	u32 max_burst;
	u32 max_sg_burst;
	bool descriptor_reuse;
	enum dma_residue_granularity residue_granularity;
	int (*device_alloc_chan_resources)(struct dma_chan *);
	int (*device_router_config)(struct dma_chan *);
	void (*device_free_chan_resources)(struct dma_chan *);
	struct dma_async_tx_descriptor * (*device_prep_dma_memcpy)(struct dma_chan *, dma_addr_t, dma_addr_t, size_t, long unsigned int);
	struct dma_async_tx_descriptor * (*device_prep_dma_xor)(struct dma_chan *, dma_addr_t, dma_addr_t *, unsigned int, size_t, long unsigned int);
	struct dma_async_tx_descriptor * (*device_prep_dma_xor_val)(struct dma_chan *, dma_addr_t *, unsigned int, size_t, enum sum_check_flags *, long unsigned int);
	struct dma_async_tx_descriptor * (*device_prep_dma_pq)(struct dma_chan *, dma_addr_t *, dma_addr_t *, unsigned int, const unsigned char *, size_t, long unsigned int);
	struct dma_async_tx_descriptor * (*device_prep_dma_pq_val)(struct dma_chan *, dma_addr_t *, dma_addr_t *, unsigned int, const unsigned char *, size_t, enum sum_check_flags *, long unsigned int);
	struct dma_async_tx_descriptor * (*device_prep_dma_memset)(struct dma_chan *, dma_addr_t, int, size_t, long unsigned int);
	struct dma_async_tx_descriptor * (*device_prep_dma_memset_sg)(struct dma_chan *, struct scatterlist *, unsigned int, int, long unsigned int);
	struct dma_async_tx_descriptor * (*device_prep_dma_interrupt)(struct dma_chan *, long unsigned int);
	struct dma_async_tx_descriptor * (*device_prep_slave_sg)(struct dma_chan *, struct scatterlist *, unsigned int, enum dma_transfer_direction, long unsigned int, void *);
	struct dma_async_tx_descriptor * (*device_prep_dma_cyclic)(struct dma_chan *, dma_addr_t, size_t, size_t, enum dma_transfer_direction, long unsigned int);
	struct dma_async_tx_descriptor * (*device_prep_interleaved_dma)(struct dma_chan *, struct dma_interleaved_template *, long unsigned int);
	struct dma_async_tx_descriptor * (*device_prep_dma_imm_data)(struct dma_chan *, dma_addr_t, u64, long unsigned int);
	void (*device_caps)(struct dma_chan *, struct dma_slave_caps *);
	int (*device_config)(struct dma_chan *, struct dma_slave_config *);
	int (*device_pause)(struct dma_chan *);
	int (*device_resume)(struct dma_chan *);
	int (*device_terminate_all)(struct dma_chan *);
	void (*device_synchronize)(struct dma_chan *);
	enum dma_status (*device_tx_status)(struct dma_chan *, dma_cookie_t, struct dma_tx_state *);
	void (*device_issue_pending)(struct dma_chan *);
	void (*device_release)(struct dma_device *);
	void (*dbg_summary_show)(struct seq_file *, struct dma_device *);
	struct dentry *dbg_dev_root;
};

struct dma_chan_dev {
	struct dma_chan *chan;
	struct device device;
	int dev_id;
	bool chan_dma_dev;
};

struct dma_slave_caps {
	u32 src_addr_widths;
	u32 dst_addr_widths;
	u32 directions;
	u32 min_burst;
	u32 max_burst;
	u32 max_sg_burst;
	bool cmd_pause;
	bool cmd_resume;
	bool cmd_terminate;
	enum dma_residue_granularity residue_granularity;
	bool descriptor_reuse;
};

typedef void (*dma_async_tx_callback)(void *);

enum dmaengine_tx_result {
	DMA_TRANS_NOERROR = 0,
	DMA_TRANS_READ_FAILED = 1,
	DMA_TRANS_WRITE_FAILED = 2,
	DMA_TRANS_ABORTED = 3,
};

struct dmaengine_result {
	enum dmaengine_tx_result result;
	u32 residue;
};

typedef void (*dma_async_tx_callback_result)(void *, const struct dmaengine_result *);

struct dmaengine_unmap_data {
	u8 map_cnt;
	u8 to_cnt;
	u8 from_cnt;
	u8 bidi_cnt;
	struct device *dev;
	struct kref kref;
	size_t len;
	dma_addr_t addr[0];
};

struct dma_descriptor_metadata_ops {
	int (*attach)(struct dma_async_tx_descriptor *, void *, size_t);
	void * (*get_ptr)(struct dma_async_tx_descriptor *, size_t *, size_t *);
	int (*set_len)(struct dma_async_tx_descriptor *, size_t);
};

struct dma_async_tx_descriptor {
	dma_cookie_t cookie;
	enum dma_ctrl_flags flags;
	dma_addr_t phys;
	struct dma_chan *chan;
	dma_cookie_t (*tx_submit)(struct dma_async_tx_descriptor *);
	int (*desc_free)(struct dma_async_tx_descriptor *);
	dma_async_tx_callback callback;
	dma_async_tx_callback_result callback_result;
	void *callback_param;
	struct dmaengine_unmap_data *unmap;
	enum dma_desc_metadata_mode desc_metadata_mode;
	struct dma_descriptor_metadata_ops *metadata_ops;
};

struct dma_tx_state {
	dma_cookie_t last;
	dma_cookie_t used;
	u32 residue;
	u32 in_flight_bytes;
};

struct dma_slave_map {
	const char *devname;
	const char *slave;
	void *param;
};

struct old_serial_port {
	unsigned int uart;
	unsigned int baud_base;
	unsigned int port;
	unsigned int irq;
	upf_t flags;
	unsigned char io_type;
	unsigned char *iomem_base;
	short unsigned int iomem_reg_shift;
};

struct irq_info {
	struct hlist_node node;
	int irq;
	spinlock_t lock;
	struct list_head *head;
};

struct memdev {
	const char *name;
	const struct file_operations *fops;
	fmode_t fmode;
	umode_t mode;
};

enum tpm_algorithms {
	TPM_ALG_ERROR = 0,
	TPM_ALG_SHA1 = 4,
	TPM_ALG_KEYEDHASH = 8,
	TPM_ALG_SHA256 = 11,
	TPM_ALG_SHA384 = 12,
	TPM_ALG_SHA512 = 13,
	TPM_ALG_NULL = 16,
	TPM_ALG_SM3_256 = 18,
};

enum tpm_duration {
	TPM_SHORT = 0,
	TPM_MEDIUM = 1,
	TPM_LONG = 2,
	TPM_LONG_LONG = 3,
	TPM_UNDEFINED = 4,
	TPM_NUM_DURATIONS = 4,
};

enum tpm_chip_flags {
	TPM_CHIP_FLAG_BOOTSTRAPPED = 1,
	TPM_CHIP_FLAG_TPM2 = 2,
	TPM_CHIP_FLAG_IRQ = 4,
	TPM_CHIP_FLAG_VIRTUAL = 8,
	TPM_CHIP_FLAG_HAVE_TIMEOUTS = 16,
	TPM_CHIP_FLAG_ALWAYS_POWERED = 32,
	TPM_CHIP_FLAG_FIRMWARE_POWER_MANAGED = 64,
	TPM_CHIP_FLAG_FIRMWARE_UPGRADE = 128,
	TPM_CHIP_FLAG_SUSPENDED = 256,
	TPM_CHIP_FLAG_HWRNG_DISABLED = 512,
};

struct tpm_header {
	__be16 tag;
	__be32 length;
	union {
		__be32 ordinal;
		__be32 return_code;
	};
} __attribute__((packed));

enum tpm_buf_flags {
	TPM_BUF_OVERFLOW = 1,
};

struct tpm_buf {
	unsigned int flags;
	u8 *data;
};

enum tpm_timeout {
	TPM_TIMEOUT = 5,
	TPM_TIMEOUT_RETRY = 100,
	TPM_TIMEOUT_RANGE_US = 300,
	TPM_TIMEOUT_POLL = 1,
	TPM_TIMEOUT_USECS_MIN = 100,
	TPM_TIMEOUT_USECS_MAX = 500,
};

struct stclear_flags_t {
	__be16 tag;
	u8 deactivated;
	u8 disableForceClear;
	u8 physicalPresence;
	u8 physicalPresenceLock;
	u8 bGlobalLock;
} __attribute__((packed));

struct tpm1_version {
	u8 major;
	u8 minor;
	u8 rev_major;
	u8 rev_minor;
};

struct tpm1_version2 {
	__be16 tag;
	struct tpm1_version version;
};

struct timeout_t {
	__be32 a;
	__be32 b;
	__be32 c;
	__be32 d;
};

struct duration_t {
	__be32 tpm_short;
	__be32 tpm_medium;
	__be32 tpm_long;
};

struct permanent_flags_t {
	__be16 tag;
	u8 disable;
	u8 ownership;
	u8 deactivated;
	u8 readPubek;
	u8 disableOwnerClear;
	u8 allowMaintenance;
	u8 physicalPresenceLifetimeLock;
	u8 physicalPresenceHWEnable;
	u8 physicalPresenceCMDEnable;
	u8 CEKPUsed;
	u8 TPMpost;
	u8 TPMpostLock;
	u8 FIPS;
	u8 operator;
	u8 enableRevokeEK;
	u8 nvLocked;
	u8 readSRKPub;
	u8 tpmEstablished;
	u8 maintenanceDone;
	u8 disableFullDALogicInfo;
};

typedef union {
	struct permanent_flags_t perm_flags;
	struct stclear_flags_t stclear_flags;
	__u8 owned;
	__be32 num_pcrs;
	struct tpm1_version version1;
	struct tpm1_version2 version2;
	__be32 manufacturer_id;
	struct timeout_t timeout;
	struct duration_t duration;
} cap_t;

enum tpm_capabilities {
	TPM_CAP_FLAG = 4,
	TPM_CAP_PROP = 5,
	TPM_CAP_VERSION_1_1 = 6,
	TPM_CAP_VERSION_1_2 = 26,
};

enum tpm_sub_capabilities {
	TPM_CAP_PROP_PCR = 257,
	TPM_CAP_PROP_MANUFACTURER = 259,
	TPM_CAP_FLAG_PERM = 264,
	TPM_CAP_FLAG_VOL = 265,
	TPM_CAP_PROP_OWNER = 273,
	TPM_CAP_PROP_TIS_TIMEOUT = 277,
	TPM_CAP_PROP_TIS_DURATION = 288,
};

struct tpm1_get_random_out {
	__be32 rng_data_len;
	u8 rng_data[128];
};

enum {
	MEMREMAP_WB = 1,
	MEMREMAP_WT = 2,
	MEMREMAP_WC = 4,
	MEMREMAP_ENC = 8,
	MEMREMAP_DEC = 16,
};

struct klist_node;

struct klist {
	spinlock_t k_lock;
	struct list_head k_list;
	void (*get)(struct klist_node *);
	void (*put)(struct klist_node *);
};

struct klist_node {
	void *n_klist;
	struct list_head n_node;
	struct kref n_ref;
};

struct klist_iter {
	struct klist *i_klist;
	struct klist_node *i_cur;
};

struct wake_irq {
	struct device *dev;
	unsigned int status;
	int irq;
	const char *name;
};

enum bus_notifier_event {
	BUS_NOTIFY_ADD_DEVICE = 0,
	BUS_NOTIFY_DEL_DEVICE = 1,
	BUS_NOTIFY_REMOVED_DEVICE = 2,
	BUS_NOTIFY_BIND_DRIVER = 3,
	BUS_NOTIFY_BOUND_DRIVER = 4,
	BUS_NOTIFY_UNBIND_DRIVER = 5,
	BUS_NOTIFY_UNBOUND_DRIVER = 6,
	BUS_NOTIFY_DRIVER_NOT_BOUND = 7,
};

struct subsys_private {
	struct kset subsys;
	struct kset *devices_kset;
	struct list_head interfaces;
	struct mutex mutex;
	struct kset *drivers_kset;
	struct klist klist_devices;
	struct klist klist_drivers;
	struct blocking_notifier_head bus_notifier;
	unsigned int drivers_autoprobe: 1;
	const struct bus_type *bus;
	struct device *dev_root;
	struct kset glue_dirs;
	const struct class *class;
	struct lock_class_key lock_key;
};

struct driver_private {
	struct kobject kobj;
	struct klist klist_devices;
	struct klist_node knode_bus;
	struct module_kobject *mkobj;
	struct device_driver *driver;
};

struct driver_attribute {
	struct attribute attr;
	ssize_t (*show)(struct device_driver *, char *);
	ssize_t (*store)(struct device_driver *, const char *, size_t);
};

struct subsys_interface {
	const char *name;
	struct bus_type *subsys;
	struct list_head node;
	int (*add_dev)(struct device *, struct subsys_interface *);
	void (*remove_dev)(struct device *, struct subsys_interface *);
};

struct device_private {
	struct klist klist_children;
	struct klist_node knode_parent;
	struct klist_node knode_driver;
	struct klist_node knode_bus;
	struct klist_node knode_class;
	struct list_head deferred_probe;
	struct device_driver *async_driver;
	char *deferred_probe_reason;
	struct device *device;
	u8 dead: 1;
};

struct subsys_dev_iter {
	struct klist_iter ki;
	const struct device_type *type;
};

struct cpu {
	int node_id;
	int hotpluggable;
	struct device dev;
};

struct cpu_attr {
	struct device_attribute attr;
	const struct cpumask * const map;
};

struct container_dev {
	struct device dev;
	int (*offline)(struct container_dev *);
};

enum regcache_type {
	REGCACHE_NONE = 0,
	REGCACHE_RBTREE = 1,
	REGCACHE_FLAT = 2,
	REGCACHE_MAPLE = 3,
};

struct reg_default {
	unsigned int reg;
	unsigned int def;
};

struct reg_sequence {
	unsigned int reg;
	unsigned int def;
	unsigned int delay_us;
};

enum regmap_endian {
	REGMAP_ENDIAN_DEFAULT = 0,
	REGMAP_ENDIAN_BIG = 1,
	REGMAP_ENDIAN_LITTLE = 2,
	REGMAP_ENDIAN_NATIVE = 3,
};

struct regmap_range {
	unsigned int range_min;
	unsigned int range_max;
};

struct regmap_access_table {
	const struct regmap_range *yes_ranges;
	unsigned int n_yes_ranges;
	const struct regmap_range *no_ranges;
	unsigned int n_no_ranges;
};

typedef void (*regmap_lock)(void *);

typedef void (*regmap_unlock)(void *);

struct regmap_range_cfg;

struct regmap_config {
	const char *name;
	int reg_bits;
	int reg_stride;
	int reg_shift;
	unsigned int reg_base;
	int pad_bits;
	int val_bits;
	bool (*writeable_reg)(struct device *, unsigned int);
	bool (*readable_reg)(struct device *, unsigned int);
	bool (*volatile_reg)(struct device *, unsigned int);
	bool (*precious_reg)(struct device *, unsigned int);
	bool (*writeable_noinc_reg)(struct device *, unsigned int);
	bool (*readable_noinc_reg)(struct device *, unsigned int);
	bool disable_locking;
	regmap_lock lock;
	regmap_unlock unlock;
	void *lock_arg;
	int (*reg_read)(void *, unsigned int, unsigned int *);
	int (*reg_write)(void *, unsigned int, unsigned int);
	int (*reg_update_bits)(void *, unsigned int, unsigned int, unsigned int);
	int (*read)(void *, const void *, size_t, void *, size_t);
	int (*write)(void *, const void *, size_t);
	size_t max_raw_read;
	size_t max_raw_write;
	bool fast_io;
	bool io_port;
	unsigned int max_register;
	const struct regmap_access_table *wr_table;
	const struct regmap_access_table *rd_table;
	const struct regmap_access_table *volatile_table;
	const struct regmap_access_table *precious_table;
	const struct regmap_access_table *wr_noinc_table;
	const struct regmap_access_table *rd_noinc_table;
	const struct reg_default *reg_defaults;
	unsigned int num_reg_defaults;
	enum regcache_type cache_type;
	const void *reg_defaults_raw;
	unsigned int num_reg_defaults_raw;
	long unsigned int read_flag_mask;
	long unsigned int write_flag_mask;
	bool zero_flag_mask;
	bool use_single_read;
	bool use_single_write;
	bool use_relaxed_mmio;
	bool can_multi_write;
	enum regmap_endian reg_format_endian;
	enum regmap_endian val_format_endian;
	const struct regmap_range_cfg *ranges;
	unsigned int num_ranges;
	bool use_hwlock;
	bool use_raw_spinlock;
	unsigned int hwlock_id;
	unsigned int hwlock_mode;
	bool can_sleep;
};

struct regmap_range_cfg {
	const char *name;
	unsigned int range_min;
	unsigned int range_max;
	unsigned int selector_reg;
	unsigned int selector_mask;
	int selector_shift;
	unsigned int window_start;
	unsigned int window_len;
};

typedef int (*regmap_hw_write)(void *, const void *, size_t);

typedef int (*regmap_hw_gather_write)(void *, const void *, size_t, const void *, size_t);

struct regmap_async;

typedef int (*regmap_hw_async_write)(void *, const void *, size_t, const void *, size_t, struct regmap_async *);

struct regmap;

struct regmap_async {
	struct list_head list;
	struct regmap *map;
	void *work_buf;
};

typedef int (*regmap_hw_read)(void *, const void *, size_t, void *, size_t);

typedef int (*regmap_hw_reg_read)(void *, unsigned int, unsigned int *);

typedef int (*regmap_hw_reg_noinc_read)(void *, unsigned int, void *, size_t);

typedef int (*regmap_hw_reg_write)(void *, unsigned int, unsigned int);

typedef int (*regmap_hw_reg_noinc_write)(void *, unsigned int, const void *, size_t);

typedef int (*regmap_hw_reg_update_bits)(void *, unsigned int, unsigned int, unsigned int);

typedef struct regmap_async * (*regmap_hw_async_alloc)();

typedef void (*regmap_hw_free_context)(void *);

struct regmap_bus {
	bool fast_io;
	bool free_on_exit;
	regmap_hw_write write;
	regmap_hw_gather_write gather_write;
	regmap_hw_async_write async_write;
	regmap_hw_reg_write reg_write;
	regmap_hw_reg_noinc_write reg_noinc_write;
	regmap_hw_reg_update_bits reg_update_bits;
	regmap_hw_read read;
	regmap_hw_reg_read reg_read;
	regmap_hw_reg_noinc_read reg_noinc_read;
	regmap_hw_free_context free_context;
	regmap_hw_async_alloc async_alloc;
	u8 read_flag_mask;
	enum regmap_endian reg_format_endian_default;
	enum regmap_endian val_format_endian_default;
	size_t max_raw_read;
	size_t max_raw_write;
};

struct reg_field {
	unsigned int reg;
	unsigned int lsb;
	unsigned int msb;
	unsigned int id_size;
	unsigned int id_offset;
};

struct regmap_format {
	size_t buf_size;
	size_t reg_bytes;
	size_t pad_bytes;
	size_t val_bytes;
	s8 reg_shift;
	void (*format_write)(struct regmap *, unsigned int, unsigned int);
	void (*format_reg)(void *, unsigned int, unsigned int);
	void (*format_val)(void *, unsigned int, unsigned int);
	unsigned int (*parse_val)(const void *);
	void (*parse_inplace)(void *);
};

struct hwspinlock;

struct regcache_ops;

struct regmap {
	union {
		struct mutex mutex;
		struct {
			spinlock_t spinlock;
			long unsigned int spinlock_flags;
		};
		struct {
			raw_spinlock_t raw_spinlock;
			long unsigned int raw_spinlock_flags;
		};
	};
	regmap_lock lock;
	regmap_unlock unlock;
	void *lock_arg;
	gfp_t alloc_flags;
	unsigned int reg_base;
	struct device *dev;
	void *work_buf;
	struct regmap_format format;
	const struct regmap_bus *bus;
	void *bus_context;
	const char *name;
	bool async;
	spinlock_t async_lock;
	wait_queue_head_t async_waitq;
	struct list_head async_list;
	struct list_head async_free;
	int async_ret;
	bool debugfs_disable;
	struct dentry *debugfs;
	const char *debugfs_name;
	unsigned int debugfs_reg_len;
	unsigned int debugfs_val_len;
	unsigned int debugfs_tot_len;
	struct list_head debugfs_off_cache;
	struct mutex cache_lock;
	unsigned int max_register;
	bool (*writeable_reg)(struct device *, unsigned int);
	bool (*readable_reg)(struct device *, unsigned int);
	bool (*volatile_reg)(struct device *, unsigned int);
	bool (*precious_reg)(struct device *, unsigned int);
	bool (*writeable_noinc_reg)(struct device *, unsigned int);
	bool (*readable_noinc_reg)(struct device *, unsigned int);
	const struct regmap_access_table *wr_table;
	const struct regmap_access_table *rd_table;
	const struct regmap_access_table *volatile_table;
	const struct regmap_access_table *precious_table;
	const struct regmap_access_table *wr_noinc_table;
	const struct regmap_access_table *rd_noinc_table;
	int (*reg_read)(void *, unsigned int, unsigned int *);
	int (*reg_write)(void *, unsigned int, unsigned int);
	int (*reg_update_bits)(void *, unsigned int, unsigned int, unsigned int);
	int (*read)(void *, const void *, size_t, void *, size_t);
	int (*write)(void *, const void *, size_t);
	bool defer_caching;
	long unsigned int read_flag_mask;
	long unsigned int write_flag_mask;
	int reg_shift;
	int reg_stride;
	int reg_stride_order;
	bool force_write_field;
	const struct regcache_ops *cache_ops;
	enum regcache_type cache_type;
	unsigned int cache_size_raw;
	unsigned int cache_word_size;
	unsigned int num_reg_defaults;
	unsigned int num_reg_defaults_raw;
	bool cache_only;
	bool cache_bypass;
	bool cache_free;
	struct reg_default *reg_defaults;
	const void *reg_defaults_raw;
	void *cache;
	bool cache_dirty;
	bool no_sync_defaults;
	struct reg_sequence *patch;
	int patch_regs;
	bool use_single_read;
	bool use_single_write;
	bool can_multi_write;
	size_t max_raw_read;
	size_t max_raw_write;
	struct rb_root range_tree;
	void *selector_work_buf;
	struct hwspinlock *hwlock;
	bool can_sleep;
};

struct regcache_ops {
	const char *name;
	enum regcache_type type;
	int (*init)(struct regmap *);
	int (*exit)(struct regmap *);
	void (*debugfs_init)(struct regmap *);
	int (*read)(struct regmap *, unsigned int, unsigned int *);
	int (*write)(struct regmap *, unsigned int, unsigned int);
	int (*sync)(struct regmap *, unsigned int, unsigned int);
	int (*drop)(struct regmap *, unsigned int, unsigned int);
};

struct regmap_range_node {
	struct rb_node node;
	const char *name;
	struct regmap *map;
	unsigned int range_min;
	unsigned int range_max;
	unsigned int selector_reg;
	unsigned int selector_mask;
	int selector_shift;
	unsigned int window_start;
	unsigned int window_len;
};

struct regmap_field {
	struct regmap *regmap;
	unsigned int mask;
	unsigned int shift;
	unsigned int reg;
	unsigned int id_size;
	unsigned int id_offset;
};

struct trace_event_raw_regmap_reg {
	struct trace_entry ent;
	u32 __data_loc_name;
	unsigned int reg;
	unsigned int val;
	char __data[0];
};

struct trace_event_raw_regmap_bulk {
	struct trace_entry ent;
	u32 __data_loc_name;
	unsigned int reg;
	u32 __data_loc_buf;
	int val_len;
	char __data[0];
};

struct trace_event_raw_regmap_block {
	struct trace_entry ent;
	u32 __data_loc_name;
	unsigned int reg;
	int count;
	char __data[0];
};

struct trace_event_raw_regcache_sync {
	struct trace_entry ent;
	u32 __data_loc_name;
	u32 __data_loc_status;
	u32 __data_loc_type;
	char __data[0];
};

struct trace_event_raw_regmap_bool {
	struct trace_entry ent;
	u32 __data_loc_name;
	int flag;
	char __data[0];
};

struct trace_event_raw_regmap_async {
	struct trace_entry ent;
	u32 __data_loc_name;
	char __data[0];
};

struct trace_event_raw_regcache_drop_region {
	struct trace_entry ent;
	u32 __data_loc_name;
	unsigned int from;
	unsigned int to;
	char __data[0];
};

struct trace_event_data_offsets_regmap_reg {
	u32 name;
};

struct trace_event_data_offsets_regmap_bulk {
	u32 name;
	u32 buf;
};

struct trace_event_data_offsets_regmap_block {
	u32 name;
};

struct trace_event_data_offsets_regcache_sync {
	u32 name;
	u32 status;
	u32 type;
};

struct trace_event_data_offsets_regmap_bool {
	u32 name;
};

struct trace_event_data_offsets_regmap_async {
	u32 name;
};

struct trace_event_data_offsets_regcache_drop_region {
	u32 name;
};

typedef void (*btf_trace_regmap_reg_write)(void *, struct regmap *, unsigned int, unsigned int);

typedef void (*btf_trace_regmap_reg_read)(void *, struct regmap *, unsigned int, unsigned int);

typedef void (*btf_trace_regmap_reg_read_cache)(void *, struct regmap *, unsigned int, unsigned int);

typedef void (*btf_trace_regmap_bulk_write)(void *, struct regmap *, unsigned int, const void *, int);

typedef void (*btf_trace_regmap_bulk_read)(void *, struct regmap *, unsigned int, const void *, int);

typedef void (*btf_trace_regmap_hw_read_start)(void *, struct regmap *, unsigned int, int);

typedef void (*btf_trace_regmap_hw_read_done)(void *, struct regmap *, unsigned int, int);

typedef void (*btf_trace_regmap_hw_write_start)(void *, struct regmap *, unsigned int, int);

typedef void (*btf_trace_regmap_hw_write_done)(void *, struct regmap *, unsigned int, int);

typedef void (*btf_trace_regcache_sync)(void *, struct regmap *, const char *, const char *);

typedef void (*btf_trace_regmap_cache_only)(void *, struct regmap *, bool);

typedef void (*btf_trace_regmap_cache_bypass)(void *, struct regmap *, bool);

typedef void (*btf_trace_regmap_async_write_start)(void *, struct regmap *, unsigned int, int);

typedef void (*btf_trace_regmap_async_io_complete)(void *, struct regmap *);

typedef void (*btf_trace_regmap_async_complete_start)(void *, struct regmap *);

typedef void (*btf_trace_regmap_async_complete_done)(void *, struct regmap *);

typedef void (*btf_trace_regcache_drop_region)(void *, struct regmap *, unsigned int, unsigned int);

struct cxl_irq_ranges {
	irq_hw_number_t offset[4];
	irq_hw_number_t range[4];
};

enum cxl_context_status {
	CLOSED = 0,
	OPENED = 1,
	STARTED = 2,
};

struct cxl_afu;

struct cxl_sste;

struct cxl_process_element;

struct cxl_afu_driver_ops;

struct cxl_context {
	struct cxl_afu *afu;
	phys_addr_t psn_phys;
	u64 psn_size;
	struct address_space *mapping;
	struct mutex mapping_lock;
	struct page *ff_page;
	bool mmio_err_ff;
	bool kernelapi;
	spinlock_t sste_lock;
	struct cxl_sste *sstp;
	u64 sstp0;
	u64 sstp1;
	unsigned int sst_size;
	unsigned int sst_lru;
	wait_queue_head_t wq;
	struct pid *pid;
	spinlock_t lock;
	u64 process_token;
	void *priv;
	long unsigned int *irq_bitmap;
	struct cxl_irq_ranges irqs;
	struct list_head irq_names;
	u64 fault_addr;
	u64 fault_dsisr;
	u64 afu_err;
	enum cxl_context_status status;
	struct mutex status_mutex;
	struct work_struct fault_work;
	u64 dsisr;
	u64 dar;
	struct cxl_process_element *elem;
	int pe;
	int external_pe;
	u32 irq_count;
	bool pe_inserted;
	bool master;
	bool kernel;
	bool pending_irq;
	bool pending_fault;
	bool pending_afu_err;
	struct cxl_afu_driver_ops *afu_driver_ops;
	atomic_t afu_driver_events;
	struct callback_head rcu;
	struct mm_struct *mm;
	u16 tidr;
	bool assign_tidr;
};

struct cxl_event_afu_driver_reserved {
	__u32 data_size;
	__u8 data[0];
};

struct cxl_afu_driver_ops {
	struct cxl_event_afu_driver_reserved * (*fetch_event)(struct cxl_context *);
	void (*event_delivered)(struct cxl_context *, struct cxl_event_afu_driver_reserved *, int);
};

typedef struct {
	const int x;
} cxl_p1_reg_t;

typedef struct {
	const int x;
} cxl_p1n_reg_t;

typedef struct {
	const int x;
} cxl_p2n_reg_t;

enum prefault_modes {
	CXL_PREFAULT_NONE = 0,
	CXL_PREFAULT_WED = 1,
	CXL_PREFAULT_ALL = 2,
};

struct cxl_sste {
	__be64 esid_data;
	__be64 vsid_data;
};

struct cxl_afu_native {
	void *p1n_mmio;
	void *afu_desc_mmio;
	irq_hw_number_t psl_hwirq;
	unsigned int psl_virq;
	struct mutex spa_mutex;
	struct cxl_process_element *spa;
	__be64 *sw_command_status;
	unsigned int spa_size;
	int spa_order;
	int spa_max_procs;
	u64 pp_offset;
};

struct cxl_process_element_common {
	__be32 tid;
	__be32 pid;
	__be64 csrp;
	union {
		struct {
			__be64 aurp0;
			__be64 aurp1;
			__be64 sstp0;
			__be64 sstp1;
		} psl8;
		struct {
			u8 reserved2[8];
			u8 reserved3[8];
			u8 reserved4[8];
			u8 reserved5[8];
		} psl9;
	} u;
	__be64 amr;
	u8 reserved6[4];
	__be64 wed;
} __attribute__((packed));

struct cxl_process_element {
	__be64 sr;
	__be64 SPOffset;
	union {
		__be64 sdr;
		u8 reserved1[8];
	} u;
	__be64 haurp;
	__be32 ctxtime;
	__be16 ivte_offsets[4];
	__be16 ivte_ranges[4];
	__be32 lpid;
	struct cxl_process_element_common common;
	__be32 software_state;
};

struct cxl_afu_guest {
	struct cxl_afu *parent;
	u64 handle;
	phys_addr_t p2n_phys;
	u64 p2n_size;
	int max_ints;
	bool handle_err;
	struct delayed_work work_err;
	int previous_state;
};

struct cxl;

struct cxl_afu {
	struct cxl_afu_native *native;
	struct cxl_afu_guest *guest;
	irq_hw_number_t serr_hwirq;
	unsigned int serr_virq;
	char *psl_irq_name;
	char *err_irq_name;
	void *p2n_mmio;
	phys_addr_t psn_phys;
	u64 pp_size;
	struct cxl *adapter;
	struct device dev;
	struct cdev afu_cdev_s;
	struct cdev afu_cdev_m;
	struct cdev afu_cdev_d;
	struct device *chardev_s;
	struct device *chardev_m;
	struct device *chardev_d;
	struct idr contexts_idr;
	struct dentry *debugfs;
	struct mutex contexts_lock;
	spinlock_t afu_cntl_lock;
	atomic_t configured_state;
	u64 eb_len;
	u64 eb_offset;
	struct bin_attribute attr_eb;
	struct pci_controller *phb;
	int pp_irqs;
	int irqs_max;
	int num_procs;
	int max_procs_virtualised;
	int slice;
	int modes_supported;
	int current_mode;
	int crs_num;
	u64 crs_len;
	u64 crs_offset;
	struct list_head crs;
	enum prefault_modes prefault_mode;
	bool psa;
	bool pp_psa;
	bool enabled;
};

struct cxl_native;

struct cxl_guest;

struct cxl {
	struct cxl_native *native;
	struct cxl_guest *guest;
	spinlock_t afu_list_lock;
	struct cxl_afu *afu[4];
	struct device dev;
	struct dentry *trace;
	struct dentry *psl_err_chk;
	struct dentry *debugfs;
	char *irq_name;
	struct bin_attribute cxl_attr;
	int adapter_num;
	int user_irqs;
	u64 ps_size;
	u16 psl_rev;
	u16 base_image;
	u8 vsec_status;
	u8 caia_major;
	u8 caia_minor;
	u8 slices;
	bool user_image_loaded;
	bool perst_loads_image;
	bool perst_select_user;
	bool perst_same_image;
	bool psl_timebase_synced;
	bool tunneled_ops_supported;
	atomic_t contexts_num;
};

struct irq_avail {
	irq_hw_number_t offset;
	irq_hw_number_t range;
	long unsigned int *bitmap;
};

struct cxl_irq_info;

struct cxl_service_layer_ops {
	int (*adapter_regs_init)(struct cxl *, struct pci_dev *);
	int (*invalidate_all)(struct cxl *);
	int (*afu_regs_init)(struct cxl_afu *);
	int (*sanitise_afu_regs)(struct cxl_afu *);
	int (*register_serr_irq)(struct cxl_afu *);
	void (*release_serr_irq)(struct cxl_afu *);
	irqreturn_t (*handle_interrupt)(int, struct cxl_context *, struct cxl_irq_info *);
	irqreturn_t (*fail_irq)(struct cxl_afu *, struct cxl_irq_info *);
	int (*activate_dedicated_process)(struct cxl_afu *);
	int (*attach_afu_directed)(struct cxl_context *, u64, u64);
	int (*attach_dedicated_process)(struct cxl_context *, u64, u64);
	void (*update_dedicated_ivtes)(struct cxl_context *);
	void (*debugfs_add_adapter_regs)(struct cxl *, struct dentry *);
	void (*debugfs_add_afu_regs)(struct cxl_afu *, struct dentry *);
	void (*psl_irq_dump_registers)(struct cxl_context *);
	void (*err_irq_dump_registers)(struct cxl *);
	void (*debugfs_stop_trace)(struct cxl *);
	void (*write_timebase_ctrl)(struct cxl *);
	u64 (*timebase_read)(struct cxl *);
	int capi_mode;
	bool needs_reset_before_disable;
};

struct cxl_irq_info {
	u64 dsisr;
	u64 dar;
	u64 dsr;
	u64 reserved;
	u64 afu_err;
	u64 errstat;
	u64 proc_handle;
	u64 padding[2];
};

struct cxl_native {
	u64 afu_desc_off;
	u64 afu_desc_size;
	void *p1_mmio;
	void *p2_mmio;
	irq_hw_number_t err_hwirq;
	unsigned int err_virq;
	u64 ps_off;
	bool no_data_cache;
	const struct cxl_service_layer_ops *sl_ops;
};

struct cxl_guest {
	struct platform_device *pdev;
	int irq_nranges;
	struct cdev cdev;
	irq_hw_number_t irq_base_offset;
	struct irq_avail *irq_avail;
	spinlock_t irq_alloc_lock;
	u64 handle;
	char *status;
	u16 vendor;
	u16 device;
	u16 subsystem_vendor;
	u16 subsystem;
};

struct cxl_calls {
	void (*cxl_slbia)(struct mm_struct *);
	struct module *owner;
};

typedef struct {
	__u8 b[16];
} guid_t;

struct nd_cmd_get_config_size {
	__u32 status;
	__u32 config_size;
	__u32 max_xfer;
};

enum nvdimm_event {
	NVDIMM_REVALIDATE_POISON = 0,
	NVDIMM_REVALIDATE_REGION = 1,
};

enum nvdimm_claim_class {
	NVDIMM_CCLASS_NONE = 0,
	NVDIMM_CCLASS_BTT = 1,
	NVDIMM_CCLASS_BTT2 = 2,
	NVDIMM_CCLASS_PFN = 3,
	NVDIMM_CCLASS_DAX = 4,
	NVDIMM_CCLASS_UNKNOWN = 5,
};

struct nd_namespace_common {
	int force_raw;
	struct device dev;
	struct device *claim;
	enum nvdimm_claim_class claim_class;
	int (*rw_bytes)(struct nd_namespace_common *, resource_size_t, void *, size_t, int, long unsigned int);
};

struct badrange {
	struct list_head list;
	spinlock_t lock;
};

enum {
	NDD_UNARMED = 1,
	NDD_LOCKED = 2,
	NDD_SECURITY_OVERWRITE = 3,
	NDD_WORK_PENDING = 4,
	NDD_LABELING = 6,
	NDD_INCOHERENT = 7,
	NDD_REGISTER_SYNC = 8,
	ND_IOCTL_MAX_BUFLEN = 4194304,
	ND_CMD_MAX_ELEM = 5,
	ND_CMD_MAX_ENVELOPE = 256,
	ND_MAX_MAPPINGS = 32,
	ND_REGION_PAGEMAP = 0,
	ND_REGION_PERSIST_CACHE = 1,
	ND_REGION_PERSIST_MEMCTRL = 2,
	ND_REGION_ASYNC = 3,
	ND_REGION_CXL = 4,
	DPA_RESOURCE_ADJUSTED = 1,
};

struct nvdimm_bus_descriptor;

struct nvdimm;

typedef int (*ndctl_fn)(struct nvdimm_bus_descriptor *, struct nvdimm *, unsigned int, void *, unsigned int, int *);

struct nvdimm_bus_fw_ops;

struct nvdimm_bus_descriptor {
	const struct attribute_group **attr_groups;
	long unsigned int cmd_mask;
	long unsigned int dimm_family_mask;
	long unsigned int bus_family_mask;
	struct module *module;
	char *provider_name;
	struct device_node *of_node;
	ndctl_fn ndctl;
	int (*flush_probe)(struct nvdimm_bus_descriptor *);
	int (*clear_to_send)(struct nvdimm_bus_descriptor *, struct nvdimm *, unsigned int, void *);
	const struct nvdimm_bus_fw_ops *fw_ops;
};

struct nvdimm_security_ops;

struct nvdimm_fw_ops;

struct nvdimm {
	long unsigned int flags;
	void *provider_data;
	long unsigned int cmd_mask;
	struct device dev;
	atomic_t busy;
	int id;
	int num_flush;
	struct resource *flush_wpq;
	const char *dimm_id;
	struct {
		const struct nvdimm_security_ops *ops;
		long unsigned int flags;
		long unsigned int ext_flags;
		unsigned int overwrite_tmo;
		struct kernfs_node *overwrite_state;
	} sec;
	struct delayed_work dwork;
	const struct nvdimm_fw_ops *fw_ops;
};

enum nvdimm_fwa_state {
	NVDIMM_FWA_INVALID = 0,
	NVDIMM_FWA_IDLE = 1,
	NVDIMM_FWA_ARMED = 2,
	NVDIMM_FWA_BUSY = 3,
	NVDIMM_FWA_ARM_OVERFLOW = 4,
};

enum nvdimm_fwa_capability {
	NVDIMM_FWA_CAP_INVALID = 0,
	NVDIMM_FWA_CAP_NONE = 1,
	NVDIMM_FWA_CAP_QUIESCE = 2,
	NVDIMM_FWA_CAP_LIVE = 3,
};

struct nvdimm_bus_fw_ops {
	enum nvdimm_fwa_state (*activate_state)(struct nvdimm_bus_descriptor *);
	enum nvdimm_fwa_capability (*capability)(struct nvdimm_bus_descriptor *);
	int (*activate)(struct nvdimm_bus_descriptor *);
};

struct nd_interleave_set {
	u64 cookie1;
	u64 cookie2;
	u64 altcookie;
	guid_t type_guid;
};

struct nd_mapping_desc {
	struct nvdimm *nvdimm;
	u64 start;
	u64 size;
	int position;
};

struct nd_region;

struct nd_region_desc {
	struct resource *res;
	struct nd_mapping_desc *mapping;
	u16 num_mappings;
	const struct attribute_group **attr_groups;
	struct nd_interleave_set *nd_set;
	void *provider_data;
	int num_lanes;
	int numa_node;
	int target_node;
	long unsigned int flags;
	int memregion;
	struct device_node *of_node;
	int (*flush)(struct nd_region *, struct bio *);
};

struct nvdimm_drvdata;

struct nd_mapping {
	struct nvdimm *nvdimm;
	u64 start;
	u64 size;
	int position;
	struct list_head labels;
	struct mutex lock;
	struct nvdimm_drvdata *ndd;
};

struct nd_percpu_lane;

struct nd_region {
	struct device dev;
	struct ida ns_ida;
	struct ida btt_ida;
	struct ida pfn_ida;
	struct ida dax_ida;
	long unsigned int flags;
	struct device *ns_seed;
	struct device *btt_seed;
	struct device *pfn_seed;
	struct device *dax_seed;
	long unsigned int align;
	u16 ndr_mappings;
	u64 ndr_size;
	u64 ndr_start;
	int id;
	int num_lanes;
	int ro;
	int numa_node;
	int target_node;
	void *provider_data;
	struct kernfs_node *bb_state;
	struct badblocks bb;
	struct nd_interleave_set *nd_set;
	struct nd_percpu_lane *lane;
	int (*flush)(struct nd_region *, struct bio *);
	struct nd_mapping mapping[0];
};

struct nvdimm_key_data {
	u8 data[32];
};

enum nvdimm_passphrase_type {
	NVDIMM_USER = 0,
	NVDIMM_MASTER = 1,
};

struct nvdimm_security_ops {
	long unsigned int (*get_flags)(struct nvdimm *, enum nvdimm_passphrase_type);
	int (*freeze)(struct nvdimm *);
	int (*change_key)(struct nvdimm *, const struct nvdimm_key_data *, const struct nvdimm_key_data *, enum nvdimm_passphrase_type);
	int (*unlock)(struct nvdimm *, const struct nvdimm_key_data *);
	int (*disable)(struct nvdimm *, const struct nvdimm_key_data *);
	int (*erase)(struct nvdimm *, const struct nvdimm_key_data *, enum nvdimm_passphrase_type);
	int (*overwrite)(struct nvdimm *, const struct nvdimm_key_data *);
	int (*query_overwrite)(struct nvdimm *);
	int (*disable_master)(struct nvdimm *, const struct nvdimm_key_data *);
};

enum nvdimm_fwa_trigger {
	NVDIMM_FWA_ARM = 0,
	NVDIMM_FWA_DISARM = 1,
};

enum nvdimm_fwa_result {
	NVDIMM_FWA_RESULT_INVALID = 0,
	NVDIMM_FWA_RESULT_NONE = 1,
	NVDIMM_FWA_RESULT_SUCCESS = 2,
	NVDIMM_FWA_RESULT_NOTSTAGED = 3,
	NVDIMM_FWA_RESULT_NEEDRESET = 4,
	NVDIMM_FWA_RESULT_FAIL = 5,
};

struct nvdimm_fw_ops {
	enum nvdimm_fwa_state (*activate_state)(struct nvdimm *);
	enum nvdimm_fwa_result (*activate_result)(struct nvdimm *);
	int (*arm)(struct nvdimm *, enum nvdimm_fwa_trigger);
};

enum {
	NSINDEX_SIG_LEN = 16,
	NSINDEX_ALIGN = 256,
	NSINDEX_SEQ_MASK = 3,
	NSLABEL_UUID_LEN = 16,
	NSLABEL_NAME_LEN = 64,
	NSLABEL_FLAG_ROLABEL = 1,
	NSLABEL_FLAG_LOCAL = 2,
	NSLABEL_FLAG_BTT = 4,
	NSLABEL_FLAG_UPDATING = 8,
	BTT_ALIGN = 4096,
	BTTINFO_SIG_LEN = 16,
	BTTINFO_UUID_LEN = 16,
	BTTINFO_FLAG_ERROR = 1,
	BTTINFO_MAJOR_VERSION = 1,
	ND_LABEL_MIN_SIZE = 1024,
	ND_LABEL_ID_SIZE = 50,
	ND_NSINDEX_INIT = 1,
};

struct nd_namespace_index {
	u8 sig[16];
	u8 flags[3];
	u8 labelsize;
	__le32 seq;
	__le64 myoff;
	__le64 mysize;
	__le64 otheroff;
	__le64 labeloff;
	__le32 nslot;
	__le16 major;
	__le16 minor;
	__le64 checksum;
	u8 free[0];
};

struct nvdimm_efi_label {
	u8 uuid[16];
	u8 name[64];
	__le32 flags;
	__le16 nlabel;
	__le16 position;
	__le64 isetcookie;
	__le64 lbasize;
	__le64 dpa;
	__le64 rawsize;
	__le32 slot;
	u8 align;
	u8 reserved[3];
	guid_t type_guid;
	guid_t abstraction_guid;
	u8 reserved2[88];
	__le64 checksum;
};

struct nvdimm_cxl_label {
	u8 type[16];
	u8 uuid[16];
	u8 name[64];
	__le32 flags;
	__le16 nrange;
	__le16 position;
	__le64 dpa;
	__le64 rawsize;
	__le32 slot;
	__le32 align;
	u8 region_uuid[16];
	u8 abstraction_uuid[16];
	__le16 lbasize;
	u8 reserved[86];
	__le64 checksum;
};

struct nd_namespace_label {
	union {
		struct nvdimm_cxl_label cxl;
		struct nvdimm_efi_label efi;
	};
};

enum {
	ND_MAX_LANES = 256,
	INT_LBASIZE_ALIGNMENT = 64,
	NVDIMM_IO_ATOMIC = 1,
};

struct nvdimm_drvdata {
	struct device *dev;
	int nslabel_size;
	struct nd_cmd_get_config_size nsarea;
	void *data;
	bool cxl;
	int ns_current;
	int ns_next;
	struct resource dpa;
	struct kref kref;
};

struct nd_region_data {
	int ns_count;
	int ns_active;
	unsigned int hints_shift;
	void *flush_wpq[0];
};

struct nd_percpu_lane {
	int count;
	spinlock_t lock;
};

struct nd_label_ent {
	struct list_head list;
	long unsigned int flags;
	struct nd_namespace_label *label;
};

struct btt;

struct nd_btt {
	struct device dev;
	struct nd_namespace_common *ndns;
	struct btt *btt;
	long unsigned int lbasize;
	u64 size;
	uuid_t *uuid;
	int id;
	int initial_offset;
	u16 version_major;
	u16 version_minor;
};

enum nd_pfn_mode {
	PFN_MODE_NONE = 0,
	PFN_MODE_RAM = 1,
	PFN_MODE_PMEM = 2,
};

struct nd_pfn_sb;

struct nd_pfn {
	int id;
	uuid_t *uuid;
	struct device dev;
	long unsigned int align;
	long unsigned int npfns;
	enum nd_pfn_mode mode;
	struct nd_pfn_sb *pfn_sb;
	struct nd_namespace_common *ndns;
};

struct nd_dax {
	struct nd_pfn nd_pfn;
};

enum nd_async_mode {
	ND_SYNC = 0,
	ND_ASYNC = 1,
};

struct nvdimm_bus {
	struct nvdimm_bus_descriptor *nd_desc;
	wait_queue_head_t wait;
	struct list_head list;
	struct device dev;
	int id;
	int probe_active;
	atomic_t ioctl_active;
	struct list_head mapping_list;
	struct mutex reconfig_mutex;
	struct badrange badrange;
};

struct conflict_context {
	struct nd_region *nd_region;
	resource_size_t start;
	resource_size_t size;
};

struct nd_pfn_sb {
	u8 signature[16];
	u8 uuid[16];
	u8 parent_uuid[16];
	__le32 flags;
	__le16 version_major;
	__le16 version_minor;
	__le64 dataoff;
	__le64 npfns;
	__le32 mode;
	__le32 start_pad;
	__le32 end_trunc;
	__le32 align;
	__le32 page_size;
	__le16 page_struct_size;
	u8 padding[3994];
	__le64 checksum;
};

struct dma_fence_ops;

struct dma_fence {
	spinlock_t *lock;
	const struct dma_fence_ops *ops;
	union {
		struct list_head cb_list;
		ktime_t timestamp;
		struct callback_head rcu;
	};
	u64 context;
	u64 seqno;
	long unsigned int flags;
	struct kref refcount;
	int error;
};

struct dma_fence_ops {
	bool use_64bit_seqno;
	const char * (*get_driver_name)(struct dma_fence *);
	const char * (*get_timeline_name)(struct dma_fence *);
	bool (*enable_signaling)(struct dma_fence *);
	bool (*signaled)(struct dma_fence *);
	long int (*wait)(struct dma_fence *, bool, long int);
	void (*release)(struct dma_fence *);
	void (*fence_value_str)(struct dma_fence *, char *, int);
	void (*timeline_value_str)(struct dma_fence *, char *, int);
	void (*set_deadline)(struct dma_fence *, ktime_t);
};

struct dma_fence_cb;

typedef void (*dma_fence_func_t)(struct dma_fence *, struct dma_fence_cb *);

struct dma_fence_cb {
	struct list_head node;
	dma_fence_func_t func;
};

struct dma_fence_array;

struct dma_fence_array_cb {
	struct dma_fence_cb cb;
	struct dma_fence_array *array;
};

struct dma_fence_array {
	struct dma_fence base;
	spinlock_t lock;
	unsigned int num_fences;
	atomic_t num_pending;
	struct dma_fence **fences;
	struct irq_work work;
};

typedef __kernel_clock_t clock_t;

struct cdrom_device_ops;

struct cdrom_device_info {
	const struct cdrom_device_ops *ops;
	struct list_head list;
	struct gendisk *disk;
	void *handle;
	int mask;
	int speed;
	int capacity;
	unsigned int options: 30;
	unsigned int mc_flags: 2;
	unsigned int vfs_events;
	unsigned int ioctl_events;
	int use_count;
	char name[20];
	__u8 sanyo_slot: 2;
	__u8 keeplocked: 1;
	__u8 reserved: 5;
	int cdda_method;
	__u8 last_sense;
	__u8 media_written;
	short unsigned int mmc3_profile;
	int (*exit)(struct cdrom_device_info *);
	int mrw_mode_page;
	bool opened_for_data;
	__s64 last_media_change_ms;
};

enum sam_status {
	SAM_STAT_GOOD = 0,
	SAM_STAT_CHECK_CONDITION = 2,
	SAM_STAT_CONDITION_MET = 4,
	SAM_STAT_BUSY = 8,
	SAM_STAT_INTERMEDIATE = 16,
	SAM_STAT_INTERMEDIATE_CONDITION_MET = 20,
	SAM_STAT_RESERVATION_CONFLICT = 24,
	SAM_STAT_COMMAND_TERMINATED = 34,
	SAM_STAT_TASK_SET_FULL = 40,
	SAM_STAT_ACA_ACTIVE = 48,
	SAM_STAT_TASK_ABORTED = 64,
};

struct scsi_sense_hdr {
	u8 response_code;
	u8 sense_key;
	u8 asc;
	u8 ascq;
	u8 byte4;
	u8 byte5;
	u8 byte6;
	u8 additional_length;
};

struct cdrom_msf0 {
	__u8 minute;
	__u8 second;
	__u8 frame;
};

union cdrom_addr {
	struct cdrom_msf0 msf;
	int lba;
};

struct cdrom_multisession {
	union cdrom_addr addr;
	__u8 xa_flag;
	__u8 addr_format;
};

struct cdrom_mcn {
	__u8 medium_catalog_number[14];
};

struct request_sense;

struct cdrom_generic_command {
	unsigned char cmd[12];
	unsigned char *buffer;
	unsigned int buflen;
	int stat;
	struct request_sense *sense;
	unsigned char data_direction;
	int quiet;
	int timeout;
	union {
		void *reserved[1];
		void *unused;
	};
};

struct request_sense {
	__u8 error_code: 7;
	__u8 valid: 1;
	__u8 segment_number;
	__u8 sense_key: 4;
	__u8 reserved2: 1;
	__u8 ili: 1;
	__u8 reserved1: 2;
	__u8 information[4];
	__u8 add_sense_len;
	__u8 command_info[4];
	__u8 asc;
	__u8 ascq;
	__u8 fruc;
	__u8 sks[3];
	__u8 asb[46];
};

struct packet_command {
	unsigned char cmd[12];
	unsigned char *buffer;
	unsigned int buflen;
	int stat;
	struct scsi_sense_hdr *sshdr;
	unsigned char data_direction;
	int quiet;
	int timeout;
	void *reserved[1];
};

struct cdrom_device_ops {
	int (*open)(struct cdrom_device_info *, int);
	void (*release)(struct cdrom_device_info *);
	int (*drive_status)(struct cdrom_device_info *, int);
	unsigned int (*check_events)(struct cdrom_device_info *, unsigned int, int);
	int (*tray_move)(struct cdrom_device_info *, int);
	int (*lock_door)(struct cdrom_device_info *, int);
	int (*select_speed)(struct cdrom_device_info *, int);
	int (*get_last_session)(struct cdrom_device_info *, struct cdrom_multisession *);
	int (*get_mcn)(struct cdrom_device_info *, struct cdrom_mcn *);
	int (*reset)(struct cdrom_device_info *);
	int (*audio_ioctl)(struct cdrom_device_info *, unsigned int, void *);
	int (*generic_packet)(struct cdrom_device_info *, struct packet_command *);
	int (*read_cdda_bpc)(struct cdrom_device_info *, void *, u32, u32, u8 *);
	const int capability;
};

enum scsi_msg_byte {
	COMMAND_COMPLETE = 0,
	EXTENDED_MESSAGE = 1,
	SAVE_POINTERS = 2,
	RESTORE_POINTERS = 3,
	DISCONNECT = 4,
	INITIATOR_ERROR = 5,
	ABORT_TASK_SET = 6,
	MESSAGE_REJECT = 7,
	NOP = 8,
	MSG_PARITY_ERROR = 9,
	LINKED_CMD_COMPLETE = 10,
	LINKED_FLG_CMD_COMPLETE = 11,
	TARGET_RESET = 12,
	ABORT_TASK = 13,
	CLEAR_TASK_SET = 14,
	INITIATE_RECOVERY = 15,
	RELEASE_RECOVERY = 16,
	TERMINATE_IO_PROC = 17,
	CLEAR_ACA = 22,
	LOGICAL_UNIT_RESET = 23,
	SIMPLE_QUEUE_TAG = 32,
	HEAD_OF_QUEUE_TAG = 33,
	ORDERED_QUEUE_TAG = 34,
	IGNORE_WIDE_RESIDUE = 35,
	ACA = 36,
	QAS_REQUEST = 85,
	BUS_DEVICE_RESET = 12,
	ABORT = 6,
};

struct rq_map_data {
	struct page **pages;
	long unsigned int offset;
	short unsigned int page_order;
	short unsigned int nr_entries;
	bool null_mapped;
	bool from_user;
};

typedef __u64 blist_flags_t;

enum scsi_device_state {
	SDEV_CREATED = 1,
	SDEV_RUNNING = 2,
	SDEV_CANCEL = 3,
	SDEV_DEL = 4,
	SDEV_QUIESCE = 5,
	SDEV_OFFLINE = 6,
	SDEV_TRANSPORT_OFFLINE = 7,
	SDEV_BLOCK = 8,
	SDEV_CREATED_BLOCK = 9,
};

enum scsi_device_event {
	SDEV_EVT_MEDIA_CHANGE = 1,
	SDEV_EVT_INQUIRY_CHANGE_REPORTED = 2,
	SDEV_EVT_CAPACITY_CHANGE_REPORTED = 3,
	SDEV_EVT_SOFT_THRESHOLD_REACHED_REPORTED = 4,
	SDEV_EVT_MODE_PARAMETER_CHANGE_REPORTED = 5,
	SDEV_EVT_LUN_CHANGE_REPORTED = 6,
	SDEV_EVT_ALUA_STATE_CHANGE_REPORTED = 7,
	SDEV_EVT_POWER_ON_RESET_OCCURRED = 8,
	SDEV_EVT_FIRST = 1,
	SDEV_EVT_LAST = 8,
	SDEV_EVT_MAXBITS = 9,
};

struct scsi_vpd {
	struct callback_head rcu;
	int len;
	unsigned char data[0];
};

struct bsg_device;

struct Scsi_Host;

struct scsi_target;

struct scsi_device_handler;

struct scsi_device {
	struct Scsi_Host *host;
	struct request_queue *request_queue;
	struct list_head siblings;
	struct list_head same_target_siblings;
	struct sbitmap budget_map;
	atomic_t device_blocked;
	atomic_t restarts;
	spinlock_t list_lock;
	struct list_head starved_entry;
	short unsigned int queue_depth;
	short unsigned int max_queue_depth;
	short unsigned int last_queue_full_depth;
	short unsigned int last_queue_full_count;
	long unsigned int last_queue_full_time;
	long unsigned int queue_ramp_up_period;
	long unsigned int last_queue_ramp_up;
	unsigned int id;
	unsigned int channel;
	u64 lun;
	unsigned int manufacturer;
	unsigned int sector_size;
	void *hostdata;
	unsigned char type;
	char scsi_level;
	char inq_periph_qual;
	struct mutex inquiry_mutex;
	unsigned char inquiry_len;
	unsigned char *inquiry;
	const char *vendor;
	const char *model;
	const char *rev;
	struct scsi_vpd *vpd_pg0;
	struct scsi_vpd *vpd_pg83;
	struct scsi_vpd *vpd_pg80;
	struct scsi_vpd *vpd_pg89;
	struct scsi_vpd *vpd_pgb0;
	struct scsi_vpd *vpd_pgb1;
	struct scsi_vpd *vpd_pgb2;
	struct scsi_target *sdev_target;
	blist_flags_t sdev_bflags;
	unsigned int eh_timeout;
	bool manage_system_start_stop;
	bool manage_runtime_start_stop;
	bool manage_shutdown;
	unsigned int removable: 1;
	unsigned int changed: 1;
	unsigned int busy: 1;
	unsigned int lockable: 1;
	unsigned int locked: 1;
	unsigned int borken: 1;
	unsigned int disconnect: 1;
	unsigned int soft_reset: 1;
	unsigned int sdtr: 1;
	unsigned int wdtr: 1;
	unsigned int ppr: 1;
	unsigned int tagged_supported: 1;
	unsigned int simple_tags: 1;
	unsigned int was_reset: 1;
	unsigned int expecting_cc_ua: 1;
	unsigned int use_10_for_rw: 1;
	unsigned int use_10_for_ms: 1;
	unsigned int set_dbd_for_ms: 1;
	unsigned int no_report_opcodes: 1;
	unsigned int no_write_same: 1;
	unsigned int use_16_for_rw: 1;
	unsigned int use_16_for_sync: 1;
	unsigned int skip_ms_page_8: 1;
	unsigned int skip_ms_page_3f: 1;
	unsigned int skip_vpd_pages: 1;
	unsigned int try_vpd_pages: 1;
	unsigned int use_192_bytes_for_3f: 1;
	unsigned int no_start_on_add: 1;
	unsigned int allow_restart: 1;
	unsigned int no_start_on_resume: 1;
	unsigned int start_stop_pwr_cond: 1;
	unsigned int no_uld_attach: 1;
	unsigned int select_no_atn: 1;
	unsigned int fix_capacity: 1;
	unsigned int guess_capacity: 1;
	unsigned int retry_hwerror: 1;
	unsigned int last_sector_bug: 1;
	unsigned int no_read_disc_info: 1;
	unsigned int no_read_capacity_16: 1;
	unsigned int try_rc_10_first: 1;
	unsigned int security_supported: 1;
	unsigned int is_visible: 1;
	unsigned int wce_default_on: 1;
	unsigned int no_dif: 1;
	unsigned int broken_fua: 1;
	unsigned int lun_in_cdb: 1;
	unsigned int unmap_limit_for_ws: 1;
	unsigned int rpm_autosuspend: 1;
	unsigned int ignore_media_change: 1;
	unsigned int silence_suspend: 1;
	unsigned int no_vpd_size: 1;
	unsigned int cdl_supported: 1;
	unsigned int cdl_enable: 1;
	unsigned int queue_stopped;
	bool offline_already;
	atomic_t disk_events_disable_depth;
	long unsigned int supported_events[1];
	long unsigned int pending_events[1];
	struct list_head event_list;
	struct work_struct event_work;
	unsigned int max_device_blocked;
	atomic_t iorequest_cnt;
	atomic_t iodone_cnt;
	atomic_t ioerr_cnt;
	atomic_t iotmo_cnt;
	struct device sdev_gendev;
	struct device sdev_dev;
	struct work_struct requeue_work;
	struct scsi_device_handler *handler;
	void *handler_data;
	size_t dma_drain_len;
	void *dma_drain_buf;
	unsigned int sg_timeout;
	unsigned int sg_reserved_size;
	struct bsg_device *bsg_dev;
	unsigned char access_state;
	struct mutex state_mutex;
	enum scsi_device_state sdev_state;
	struct task_struct *quiesced_by;
	long unsigned int sdev_data[0];
};

enum scsi_host_state {
	SHOST_CREATED = 1,
	SHOST_RUNNING = 2,
	SHOST_CANCEL = 3,
	SHOST_DEL = 4,
	SHOST_RECOVERY = 5,
	SHOST_CANCEL_RECOVERY = 6,
	SHOST_DEL_RECOVERY = 7,
};

struct scsi_host_template;

struct scsi_transport_template;

struct Scsi_Host {
	struct list_head __devices;
	struct list_head __targets;
	struct list_head starved_list;
	spinlock_t default_lock;
	spinlock_t *host_lock;
	struct mutex scan_mutex;
	struct list_head eh_abort_list;
	struct list_head eh_cmd_q;
	struct task_struct *ehandler;
	struct completion *eh_action;
	wait_queue_head_t host_wait;
	const struct scsi_host_template *hostt;
	struct scsi_transport_template *transportt;
	struct kref tagset_refcnt;
	struct completion tagset_freed;
	struct blk_mq_tag_set tag_set;
	atomic_t host_blocked;
	unsigned int host_failed;
	unsigned int host_eh_scheduled;
	unsigned int host_no;
	int eh_deadline;
	long unsigned int last_reset;
	unsigned int max_channel;
	unsigned int max_id;
	u64 max_lun;
	unsigned int unique_id;
	short unsigned int max_cmd_len;
	int this_id;
	int can_queue;
	short int cmd_per_lun;
	short unsigned int sg_tablesize;
	short unsigned int sg_prot_tablesize;
	unsigned int max_sectors;
	unsigned int opt_sectors;
	unsigned int max_segment_size;
	long unsigned int dma_boundary;
	long unsigned int virt_boundary_mask;
	unsigned int nr_hw_queues;
	unsigned int nr_maps;
	unsigned int active_mode: 2;
	unsigned int host_self_blocked: 1;
	unsigned int reverse_ordering: 1;
	unsigned int tmf_in_progress: 1;
	unsigned int async_scan: 1;
	unsigned int eh_noresume: 1;
	unsigned int no_write_same: 1;
	unsigned int host_tagset: 1;
	unsigned int queuecommand_may_block: 1;
	unsigned int short_inquiry: 1;
	unsigned int no_scsi2_lun_in_cdb: 1;
	char work_q_name[20];
	struct workqueue_struct *work_q;
	struct workqueue_struct *tmf_work_q;
	unsigned int max_host_blocked;
	unsigned int prot_capabilities;
	unsigned char prot_guard_type;
	long unsigned int base;
	long unsigned int io_port;
	unsigned char n_io_port;
	unsigned char dma_channel;
	unsigned int irq;
	enum scsi_host_state shost_state;
	struct device shost_gendev;
	struct device shost_dev;
	void *shost_data;
	struct device *dma_dev;
	long unsigned int hostdata[0];
};

enum scsi_target_state {
	STARGET_CREATED = 1,
	STARGET_RUNNING = 2,
	STARGET_REMOVE = 3,
	STARGET_CREATED_REMOVE = 4,
	STARGET_DEL = 5,
};

struct scsi_target {
	struct scsi_device *starget_sdev_user;
	struct list_head siblings;
	struct list_head devices;
	struct device dev;
	struct kref reap_ref;
	unsigned int channel;
	unsigned int id;
	unsigned int create: 1;
	unsigned int single_lun: 1;
	unsigned int pdt_1f_for_no_lun: 1;
	unsigned int no_report_luns: 1;
	unsigned int expecting_lun_change: 1;
	atomic_t target_busy;
	atomic_t target_blocked;
	unsigned int can_queue;
	unsigned int max_target_blocked;
	char scsi_level;
	enum scsi_target_state state;
	void *hostdata;
	long unsigned int starget_data[0];
};

struct scsi_exec_args {
	unsigned char *sense;
	unsigned int sense_len;
	struct scsi_sense_hdr *sshdr;
	blk_mq_req_flags_t req_flags;
	int scmd_flags;
	int *resid;
};

struct scsi_data_buffer {
	struct sg_table table;
	unsigned int length;
};

enum scsi_cmnd_submitter {
	SUBMITTED_BY_BLOCK_LAYER = 0,
	SUBMITTED_BY_SCSI_ERROR_HANDLER = 1,
	SUBMITTED_BY_SCSI_RESET_IOCTL = 2,
} __attribute__((mode(byte)));

struct scsi_cmnd {
	struct scsi_device *device;
	struct list_head eh_entry;
	struct delayed_work abort_work;
	struct callback_head rcu;
	int eh_eflags;
	int budget_token;
	long unsigned int jiffies_at_alloc;
	int retries;
	int allowed;
	unsigned char prot_op;
	unsigned char prot_type;
	unsigned char prot_flags;
	enum scsi_cmnd_submitter submitter;
	short unsigned int cmd_len;
	enum dma_data_direction sc_data_direction;
	unsigned char cmnd[32];
	struct scsi_data_buffer sdb;
	struct scsi_data_buffer *prot_sdb;
	unsigned int underflow;
	unsigned int transfersize;
	unsigned int resid_len;
	unsigned int sense_len;
	unsigned char *sense_buffer;
	int flags;
	long unsigned int state;
	unsigned int extra_len;
	unsigned char *host_scribble;
	int result;
};

enum scsi_timeout_action {
	SCSI_EH_DONE = 0,
	SCSI_EH_RESET_TIMER = 1,
	SCSI_EH_NOT_HANDLED = 2,
};

struct scsi_host_template {
	unsigned int cmd_size;
	int (*queuecommand)(struct Scsi_Host *, struct scsi_cmnd *);
	void (*commit_rqs)(struct Scsi_Host *, u16);
	struct module *module;
	const char *name;
	const char * (*info)(struct Scsi_Host *);
	int (*ioctl)(struct scsi_device *, unsigned int, void *);
	int (*init_cmd_priv)(struct Scsi_Host *, struct scsi_cmnd *);
	int (*exit_cmd_priv)(struct Scsi_Host *, struct scsi_cmnd *);
	int (*eh_abort_handler)(struct scsi_cmnd *);
	int (*eh_device_reset_handler)(struct scsi_cmnd *);
	int (*eh_target_reset_handler)(struct scsi_cmnd *);
	int (*eh_bus_reset_handler)(struct scsi_cmnd *);
	int (*eh_host_reset_handler)(struct scsi_cmnd *);
	int (*slave_alloc)(struct scsi_device *);
	int (*slave_configure)(struct scsi_device *);
	void (*slave_destroy)(struct scsi_device *);
	int (*target_alloc)(struct scsi_target *);
	void (*target_destroy)(struct scsi_target *);
	int (*scan_finished)(struct Scsi_Host *, long unsigned int);
	void (*scan_start)(struct Scsi_Host *);
	int (*change_queue_depth)(struct scsi_device *, int);
	void (*map_queues)(struct Scsi_Host *);
	int (*mq_poll)(struct Scsi_Host *, unsigned int);
	bool (*dma_need_drain)(struct request *);
	int (*bios_param)(struct scsi_device *, struct block_device *, sector_t, int *);
	void (*unlock_native_capacity)(struct scsi_device *);
	int (*show_info)(struct seq_file *, struct Scsi_Host *);
	int (*write_info)(struct Scsi_Host *, char *, int);
	enum scsi_timeout_action (*eh_timed_out)(struct scsi_cmnd *);
	bool (*eh_should_retry_cmd)(struct scsi_cmnd *);
	int (*host_reset)(struct Scsi_Host *, int);
	const char *proc_name;
	int can_queue;
	int this_id;
	short unsigned int sg_tablesize;
	short unsigned int sg_prot_tablesize;
	unsigned int max_sectors;
	unsigned int max_segment_size;
	long unsigned int dma_boundary;
	long unsigned int virt_boundary_mask;
	short int cmd_per_lun;
	int tag_alloc_policy;
	unsigned int track_queue_depth: 1;
	unsigned int supported_mode: 2;
	unsigned int emulated: 1;
	unsigned int skip_settle_delay: 1;
	unsigned int no_write_same: 1;
	unsigned int host_tagset: 1;
	unsigned int queuecommand_may_block: 1;
	unsigned int max_host_blocked;
	const struct attribute_group **shost_groups;
	const struct attribute_group **sdev_groups;
	u64 vendor_id;
	int rpm_autosuspend_delay;
};

struct scsi_ioctl_command {
	unsigned int inlen;
	unsigned int outlen;
	unsigned char data[0];
};

struct scsi_idlun {
	__u32 dev_id;
	__u32 host_unique_id;
};

struct sg_io_hdr {
	int interface_id;
	int dxfer_direction;
	unsigned char cmd_len;
	unsigned char mx_sb_len;
	short unsigned int iovec_count;
	unsigned int dxfer_len;
	void *dxferp;
	unsigned char *cmdp;
	void *sbp;
	unsigned int timeout;
	unsigned int flags;
	int pack_id;
	void *usr_ptr;
	unsigned char status;
	unsigned char masked_status;
	unsigned char msg_status;
	unsigned char sb_len_wr;
	short unsigned int host_status;
	short unsigned int driver_status;
	int resid;
	unsigned int duration;
	unsigned int info;
};

enum scsi_devinfo_key {
	SCSI_DEVINFO_GLOBAL = 0,
	SCSI_DEVINFO_SPI = 1,
};

struct scsi_dev_info_list {
	struct list_head dev_info_list;
	char vendor[8];
	char model[16];
	blist_flags_t flags;
	unsigned int compatible;
};

struct scsi_dev_info_list_table {
	struct list_head node;
	struct list_head scsi_dev_info_list;
	const char *name;
	int key;
};

struct double_list {
	struct list_head *top;
	struct list_head *bottom;
};

enum scsi_disposition {
	NEEDS_RETRY = 8193,
	SUCCESS = 8194,
	FAILED = 8195,
	QUEUED = 8196,
	SOFT_ERROR = 8197,
	ADD_TO_MLQUEUE = 8198,
	TIMEOUT_ERROR = 8199,
	SCSI_RETURN_NOT_HANDLED = 8200,
	FAST_IO_FAIL = 8201,
};

typedef void (*activate_complete)(void *, int);

struct scsi_device_handler {
	struct list_head list;
	struct module *module;
	const char *name;
	enum scsi_disposition (*check_sense)(struct scsi_device *, struct scsi_sense_hdr *);
	int (*attach)(struct scsi_device *);
	void (*detach)(struct scsi_device *);
	int (*activate)(struct scsi_device *, activate_complete, void *);
	blk_status_t (*prep_fn)(struct scsi_device *, struct request *);
	int (*set_params)(struct scsi_device *, const char *);
	void (*rescan)(struct scsi_device *);
};

enum {
	SCSI_DH_OK = 0,
	SCSI_DH_DEV_FAILED = 1,
	SCSI_DH_DEV_TEMP_BUSY = 2,
	SCSI_DH_DEV_UNSUPP = 3,
	SCSI_DH_DEVICE_MAX = 4,
	SCSI_DH_NOTCONN = 5,
	SCSI_DH_CONN_FAILURE = 6,
	SCSI_DH_TRANSPORT_MAX = 7,
	SCSI_DH_IO = 8,
	SCSI_DH_INVALID_IO = 9,
	SCSI_DH_RETRY = 10,
	SCSI_DH_IMM_RETRY = 11,
	SCSI_DH_TIMED_OUT = 12,
	SCSI_DH_RES_TEMP_UNAVAIL = 13,
	SCSI_DH_DEV_OFFLINED = 14,
	SCSI_DH_NOMEM = 15,
	SCSI_DH_NOSYS = 16,
	SCSI_DH_DRIVER_MAX = 17,
};

struct scsi_dh_blist {
	const char *vendor;
	const char *model;
	const char *driver;
};

struct ccs_modesel_head {
	__u8 _r1;
	__u8 medium;
	__u8 _r2;
	__u8 block_desc_length;
	__u8 density;
	__u8 number_blocks_hi;
	__u8 number_blocks_med;
	__u8 number_blocks_lo;
	__u8 _r3;
	__u8 block_length_hi;
	__u8 block_length_med;
	__u8 block_length_lo;
};

struct scsi_cd {
	unsigned int capacity;
	struct scsi_device *device;
	unsigned int vendor;
	long unsigned int ms_offset;
	unsigned int writeable: 1;
	unsigned int use: 1;
	unsigned int xa_flag: 1;
	unsigned int readcd_known: 1;
	unsigned int readcd_cdda: 1;
	unsigned int media_present: 1;
	int tur_mismatch;
	bool tur_changed: 1;
	bool get_event_changed: 1;
	bool ignore_get_event: 1;
	struct cdrom_device_info cdi;
	struct mutex lock;
	struct gendisk *disk;
};

typedef struct scsi_cd Scsi_CD;

enum system_states {
	SYSTEM_BOOTING = 0,
	SYSTEM_SCHEDULING = 1,
	SYSTEM_FREEING_INITMEM = 2,
	SYSTEM_RUNNING = 3,
	SYSTEM_HALT = 4,
	SYSTEM_POWER_OFF = 5,
	SYSTEM_RESTART = 6,
	SYSTEM_SUSPEND = 7,
};

enum device_link_state {
	DL_STATE_NONE = -1,
	DL_STATE_DORMANT = 0,
	DL_STATE_AVAILABLE = 1,
	DL_STATE_CONSUMER_PROBE = 2,
	DL_STATE_ACTIVE = 3,
	DL_STATE_SUPPLIER_UNBIND = 4,
};

struct device_link {
	struct device *supplier;
	struct list_head s_node;
	struct device *consumer;
	struct list_head c_node;
	struct device link_dev;
	enum device_link_state status;
	u32 flags;
	refcount_t rpm_active;
	struct kref kref;
	struct work_struct rm_work;
	bool supplier_preactivated;
};

struct hd_geometry {
	unsigned char heads;
	unsigned char sectors;
	short unsigned int cylinders;
	long unsigned int start;
};

struct sg_page_iter {
	struct scatterlist *sg;
	unsigned int sg_pgoffset;
	unsigned int __nents;
	int __pg_advance;
};

struct sg_mapping_iter {
	struct page *page;
	void *addr;
	size_t length;
	size_t consumed;
	struct sg_page_iter piter;
	unsigned int __offset;
	unsigned int __remaining;
	unsigned int __flags;
};

enum scsi_host_status {
	DID_OK = 0,
	DID_NO_CONNECT = 1,
	DID_BUS_BUSY = 2,
	DID_TIME_OUT = 3,
	DID_BAD_TARGET = 4,
	DID_ABORT = 5,
	DID_PARITY = 6,
	DID_ERROR = 7,
	DID_RESET = 8,
	DID_BAD_INTR = 9,
	DID_PASSTHROUGH = 10,
	DID_SOFT_ERROR = 11,
	DID_IMM_RETRY = 12,
	DID_REQUEUE = 13,
	DID_TRANSPORT_DISRUPTED = 14,
	DID_TRANSPORT_FAILFAST = 15,
	DID_TRANSPORT_MARGINAL = 20,
};

struct attribute_container {
	struct list_head node;
	struct klist containers;
	struct class *class;
	const struct attribute_group *grp;
	struct device_attribute **attrs;
	int (*match)(struct attribute_container *, struct device *);
	long unsigned int flags;
};

struct transport_container {
	struct attribute_container ac;
	const struct attribute_group *statistics;
};

struct scsi_transport_template {
	struct transport_container host_attrs;
	struct transport_container target_attrs;
	struct transport_container device_attrs;
	int (*user_scan)(struct Scsi_Host *, uint, uint, u64);
	int device_size;
	int device_private_offset;
	int target_size;
	int target_private_offset;
	int host_size;
	unsigned int create_work_queue: 1;
	void (*eh_strategy_handler)(struct Scsi_Host *);
};

enum {
	ATA_MAX_DEVICES = 2,
	ATA_MAX_PRD = 256,
	ATA_SECT_SIZE = 512,
	ATA_MAX_SECTORS_128 = 128,
	ATA_MAX_SECTORS = 256,
	ATA_MAX_SECTORS_1024 = 1024,
	ATA_MAX_SECTORS_LBA48 = 65535,
	ATA_MAX_SECTORS_TAPE = 65535,
	ATA_MAX_TRIM_RNUM = 64,
	ATA_ID_WORDS = 256,
	ATA_ID_CONFIG = 0,
	ATA_ID_CYLS = 1,
	ATA_ID_HEADS = 3,
	ATA_ID_SECTORS = 6,
	ATA_ID_SERNO = 10,
	ATA_ID_BUF_SIZE = 21,
	ATA_ID_FW_REV = 23,
	ATA_ID_PROD = 27,
	ATA_ID_MAX_MULTSECT = 47,
	ATA_ID_DWORD_IO = 48,
	ATA_ID_TRUSTED = 48,
	ATA_ID_CAPABILITY = 49,
	ATA_ID_OLD_PIO_MODES = 51,
	ATA_ID_OLD_DMA_MODES = 52,
	ATA_ID_FIELD_VALID = 53,
	ATA_ID_CUR_CYLS = 54,
	ATA_ID_CUR_HEADS = 55,
	ATA_ID_CUR_SECTORS = 56,
	ATA_ID_MULTSECT = 59,
	ATA_ID_LBA_CAPACITY = 60,
	ATA_ID_SWDMA_MODES = 62,
	ATA_ID_MWDMA_MODES = 63,
	ATA_ID_PIO_MODES = 64,
	ATA_ID_EIDE_DMA_MIN = 65,
	ATA_ID_EIDE_DMA_TIME = 66,
	ATA_ID_EIDE_PIO = 67,
	ATA_ID_EIDE_PIO_IORDY = 68,
	ATA_ID_ADDITIONAL_SUPP = 69,
	ATA_ID_QUEUE_DEPTH = 75,
	ATA_ID_SATA_CAPABILITY = 76,
	ATA_ID_SATA_CAPABILITY_2 = 77,
	ATA_ID_FEATURE_SUPP = 78,
	ATA_ID_MAJOR_VER = 80,
	ATA_ID_COMMAND_SET_1 = 82,
	ATA_ID_COMMAND_SET_2 = 83,
	ATA_ID_CFSSE = 84,
	ATA_ID_CFS_ENABLE_1 = 85,
	ATA_ID_CFS_ENABLE_2 = 86,
	ATA_ID_CSF_DEFAULT = 87,
	ATA_ID_UDMA_MODES = 88,
	ATA_ID_HW_CONFIG = 93,
	ATA_ID_SPG = 98,
	ATA_ID_LBA_CAPACITY_2 = 100,
	ATA_ID_SECTOR_SIZE = 106,
	ATA_ID_WWN = 108,
	ATA_ID_LOGICAL_SECTOR_SIZE = 117,
	ATA_ID_COMMAND_SET_3 = 119,
	ATA_ID_COMMAND_SET_4 = 120,
	ATA_ID_LAST_LUN = 126,
	ATA_ID_DLF = 128,
	ATA_ID_CSFO = 129,
	ATA_ID_CFA_POWER = 160,
	ATA_ID_CFA_KEY_MGMT = 162,
	ATA_ID_CFA_MODES = 163,
	ATA_ID_DATA_SET_MGMT = 169,
	ATA_ID_SCT_CMD_XPORT = 206,
	ATA_ID_ROT_SPEED = 217,
	ATA_ID_PIO4 = 2,
	ATA_ID_SERNO_LEN = 20,
	ATA_ID_FW_REV_LEN = 8,
	ATA_ID_PROD_LEN = 40,
	ATA_ID_WWN_LEN = 8,
	ATA_PCI_CTL_OFS = 2,
	ATA_PIO0 = 1,
	ATA_PIO1 = 3,
	ATA_PIO2 = 7,
	ATA_PIO3 = 15,
	ATA_PIO4 = 31,
	ATA_PIO5 = 63,
	ATA_PIO6 = 127,
	ATA_PIO4_ONLY = 16,
	ATA_SWDMA0 = 1,
	ATA_SWDMA1 = 3,
	ATA_SWDMA2 = 7,
	ATA_SWDMA2_ONLY = 4,
	ATA_MWDMA0 = 1,
	ATA_MWDMA1 = 3,
	ATA_MWDMA2 = 7,
	ATA_MWDMA3 = 15,
	ATA_MWDMA4 = 31,
	ATA_MWDMA12_ONLY = 6,
	ATA_MWDMA2_ONLY = 4,
	ATA_UDMA0 = 1,
	ATA_UDMA1 = 3,
	ATA_UDMA2 = 7,
	ATA_UDMA3 = 15,
	ATA_UDMA4 = 31,
	ATA_UDMA5 = 63,
	ATA_UDMA6 = 127,
	ATA_UDMA7 = 255,
	ATA_UDMA24_ONLY = 20,
	ATA_UDMA_MASK_40C = 7,
	ATA_PRD_SZ = 8,
	ATA_PRD_TBL_SZ = 2048,
	ATA_PRD_EOT = -2147483648,
	ATA_DMA_TABLE_OFS = 4,
	ATA_DMA_STATUS = 2,
	ATA_DMA_CMD = 0,
	ATA_DMA_WR = 8,
	ATA_DMA_START = 1,
	ATA_DMA_INTR = 4,
	ATA_DMA_ERR = 2,
	ATA_DMA_ACTIVE = 1,
	ATA_HOB = 128,
	ATA_NIEN = 2,
	ATA_LBA = 64,
	ATA_DEV1 = 16,
	ATA_DEVICE_OBS = 160,
	ATA_DEVCTL_OBS = 8,
	ATA_BUSY = 128,
	ATA_DRDY = 64,
	ATA_DF = 32,
	ATA_DSC = 16,
	ATA_DRQ = 8,
	ATA_CORR = 4,
	ATA_SENSE = 2,
	ATA_ERR = 1,
	ATA_SRST = 4,
	ATA_ICRC = 128,
	ATA_BBK = 128,
	ATA_UNC = 64,
	ATA_MC = 32,
	ATA_IDNF = 16,
	ATA_MCR = 8,
	ATA_ABORTED = 4,
	ATA_TRK0NF = 2,
	ATA_AMNF = 1,
	ATAPI_LFS = 240,
	ATAPI_EOM = 2,
	ATAPI_ILI = 1,
	ATAPI_IO = 2,
	ATAPI_COD = 1,
	ATA_REG_DATA = 0,
	ATA_REG_ERR = 1,
	ATA_REG_NSECT = 2,
	ATA_REG_LBAL = 3,
	ATA_REG_LBAM = 4,
	ATA_REG_LBAH = 5,
	ATA_REG_DEVICE = 6,
	ATA_REG_STATUS = 7,
	ATA_REG_FEATURE = 1,
	ATA_REG_CMD = 7,
	ATA_REG_BYTEL = 4,
	ATA_REG_BYTEH = 5,
	ATA_REG_DEVSEL = 6,
	ATA_REG_IRQ = 2,
	ATA_CMD_DEV_RESET = 8,
	ATA_CMD_CHK_POWER = 229,
	ATA_CMD_STANDBY = 226,
	ATA_CMD_IDLE = 227,
	ATA_CMD_EDD = 144,
	ATA_CMD_DOWNLOAD_MICRO = 146,
	ATA_CMD_DOWNLOAD_MICRO_DMA = 147,
	ATA_CMD_NOP = 0,
	ATA_CMD_FLUSH = 231,
	ATA_CMD_FLUSH_EXT = 234,
	ATA_CMD_ID_ATA = 236,
	ATA_CMD_ID_ATAPI = 161,
	ATA_CMD_SERVICE = 162,
	ATA_CMD_READ = 200,
	ATA_CMD_READ_EXT = 37,
	ATA_CMD_READ_QUEUED = 38,
	ATA_CMD_READ_STREAM_EXT = 43,
	ATA_CMD_READ_STREAM_DMA_EXT = 42,
	ATA_CMD_WRITE = 202,
	ATA_CMD_WRITE_EXT = 53,
	ATA_CMD_WRITE_QUEUED = 54,
	ATA_CMD_WRITE_STREAM_EXT = 59,
	ATA_CMD_WRITE_STREAM_DMA_EXT = 58,
	ATA_CMD_WRITE_FUA_EXT = 61,
	ATA_CMD_WRITE_QUEUED_FUA_EXT = 62,
	ATA_CMD_FPDMA_READ = 96,
	ATA_CMD_FPDMA_WRITE = 97,
	ATA_CMD_NCQ_NON_DATA = 99,
	ATA_CMD_FPDMA_SEND = 100,
	ATA_CMD_FPDMA_RECV = 101,
	ATA_CMD_PIO_READ = 32,
	ATA_CMD_PIO_READ_EXT = 36,
	ATA_CMD_PIO_WRITE = 48,
	ATA_CMD_PIO_WRITE_EXT = 52,
	ATA_CMD_READ_MULTI = 196,
	ATA_CMD_READ_MULTI_EXT = 41,
	ATA_CMD_WRITE_MULTI = 197,
	ATA_CMD_WRITE_MULTI_EXT = 57,
	ATA_CMD_WRITE_MULTI_FUA_EXT = 206,
	ATA_CMD_SET_FEATURES = 239,
	ATA_CMD_SET_MULTI = 198,
	ATA_CMD_PACKET = 160,
	ATA_CMD_VERIFY = 64,
	ATA_CMD_VERIFY_EXT = 66,
	ATA_CMD_WRITE_UNCORR_EXT = 69,
	ATA_CMD_STANDBYNOW1 = 224,
	ATA_CMD_IDLEIMMEDIATE = 225,
	ATA_CMD_SLEEP = 230,
	ATA_CMD_INIT_DEV_PARAMS = 145,
	ATA_CMD_READ_NATIVE_MAX = 248,
	ATA_CMD_READ_NATIVE_MAX_EXT = 39,
	ATA_CMD_SET_MAX = 249,
	ATA_CMD_SET_MAX_EXT = 55,
	ATA_CMD_READ_LOG_EXT = 47,
	ATA_CMD_WRITE_LOG_EXT = 63,
	ATA_CMD_READ_LOG_DMA_EXT = 71,
	ATA_CMD_WRITE_LOG_DMA_EXT = 87,
	ATA_CMD_TRUSTED_NONDATA = 91,
	ATA_CMD_TRUSTED_RCV = 92,
	ATA_CMD_TRUSTED_RCV_DMA = 93,
	ATA_CMD_TRUSTED_SND = 94,
	ATA_CMD_TRUSTED_SND_DMA = 95,
	ATA_CMD_PMP_READ = 228,
	ATA_CMD_PMP_READ_DMA = 233,
	ATA_CMD_PMP_WRITE = 232,
	ATA_CMD_PMP_WRITE_DMA = 235,
	ATA_CMD_CONF_OVERLAY = 177,
	ATA_CMD_SEC_SET_PASS = 241,
	ATA_CMD_SEC_UNLOCK = 242,
	ATA_CMD_SEC_ERASE_PREP = 243,
	ATA_CMD_SEC_ERASE_UNIT = 244,
	ATA_CMD_SEC_FREEZE_LOCK = 245,
	ATA_CMD_SEC_DISABLE_PASS = 246,
	ATA_CMD_CONFIG_STREAM = 81,
	ATA_CMD_SMART = 176,
	ATA_CMD_MEDIA_LOCK = 222,
	ATA_CMD_MEDIA_UNLOCK = 223,
	ATA_CMD_DSM = 6,
	ATA_CMD_CHK_MED_CRD_TYP = 209,
	ATA_CMD_CFA_REQ_EXT_ERR = 3,
	ATA_CMD_CFA_WRITE_NE = 56,
	ATA_CMD_CFA_TRANS_SECT = 135,
	ATA_CMD_CFA_ERASE = 192,
	ATA_CMD_CFA_WRITE_MULT_NE = 205,
	ATA_CMD_REQ_SENSE_DATA = 11,
	ATA_CMD_SANITIZE_DEVICE = 180,
	ATA_CMD_ZAC_MGMT_IN = 74,
	ATA_CMD_ZAC_MGMT_OUT = 159,
	ATA_CMD_RESTORE = 16,
	ATA_SUBCMD_FPDMA_RECV_RD_LOG_DMA_EXT = 1,
	ATA_SUBCMD_FPDMA_RECV_ZAC_MGMT_IN = 2,
	ATA_SUBCMD_FPDMA_SEND_DSM = 0,
	ATA_SUBCMD_FPDMA_SEND_WR_LOG_DMA_EXT = 2,
	ATA_SUBCMD_NCQ_NON_DATA_ABORT_QUEUE = 0,
	ATA_SUBCMD_NCQ_NON_DATA_SET_FEATURES = 5,
	ATA_SUBCMD_NCQ_NON_DATA_ZERO_EXT = 6,
	ATA_SUBCMD_NCQ_NON_DATA_ZAC_MGMT_OUT = 7,
	ATA_SUBCMD_ZAC_MGMT_IN_REPORT_ZONES = 0,
	ATA_SUBCMD_ZAC_MGMT_OUT_CLOSE_ZONE = 1,
	ATA_SUBCMD_ZAC_MGMT_OUT_FINISH_ZONE = 2,
	ATA_SUBCMD_ZAC_MGMT_OUT_OPEN_ZONE = 3,
	ATA_SUBCMD_ZAC_MGMT_OUT_RESET_WRITE_POINTER = 4,
	ATA_LOG_DIRECTORY = 0,
	ATA_LOG_SATA_NCQ = 16,
	ATA_LOG_NCQ_NON_DATA = 18,
	ATA_LOG_NCQ_SEND_RECV = 19,
	ATA_LOG_CDL = 24,
	ATA_LOG_CDL_SIZE = 512,
	ATA_LOG_IDENTIFY_DEVICE = 48,
	ATA_LOG_SENSE_NCQ = 15,
	ATA_LOG_SENSE_NCQ_SIZE = 1024,
	ATA_LOG_CONCURRENT_POSITIONING_RANGES = 71,
	ATA_LOG_SUPPORTED_CAPABILITIES = 3,
	ATA_LOG_CURRENT_SETTINGS = 4,
	ATA_LOG_SECURITY = 6,
	ATA_LOG_SATA_SETTINGS = 8,
	ATA_LOG_ZONED_INFORMATION = 9,
	ATA_LOG_DEVSLP_OFFSET = 48,
	ATA_LOG_DEVSLP_SIZE = 8,
	ATA_LOG_DEVSLP_MDAT = 0,
	ATA_LOG_DEVSLP_MDAT_MASK = 31,
	ATA_LOG_DEVSLP_DETO = 1,
	ATA_LOG_DEVSLP_VALID = 7,
	ATA_LOG_DEVSLP_VALID_MASK = 128,
	ATA_LOG_NCQ_PRIO_OFFSET = 9,
	ATA_LOG_NCQ_SEND_RECV_SUBCMDS_OFFSET = 0,
	ATA_LOG_NCQ_SEND_RECV_SUBCMDS_DSM = 1,
	ATA_LOG_NCQ_SEND_RECV_DSM_OFFSET = 4,
	ATA_LOG_NCQ_SEND_RECV_DSM_TRIM = 1,
	ATA_LOG_NCQ_SEND_RECV_RD_LOG_OFFSET = 8,
	ATA_LOG_NCQ_SEND_RECV_RD_LOG_SUPPORTED = 1,
	ATA_LOG_NCQ_SEND_RECV_WR_LOG_OFFSET = 12,
	ATA_LOG_NCQ_SEND_RECV_WR_LOG_SUPPORTED = 1,
	ATA_LOG_NCQ_SEND_RECV_ZAC_MGMT_OFFSET = 16,
	ATA_LOG_NCQ_SEND_RECV_ZAC_MGMT_OUT_SUPPORTED = 1,
	ATA_LOG_NCQ_SEND_RECV_ZAC_MGMT_IN_SUPPORTED = 2,
	ATA_LOG_NCQ_SEND_RECV_SIZE = 20,
	ATA_LOG_NCQ_NON_DATA_SUBCMDS_OFFSET = 0,
	ATA_LOG_NCQ_NON_DATA_ABORT_OFFSET = 0,
	ATA_LOG_NCQ_NON_DATA_ABORT_NCQ = 1,
	ATA_LOG_NCQ_NON_DATA_ABORT_ALL = 2,
	ATA_LOG_NCQ_NON_DATA_ABORT_STREAMING = 4,
	ATA_LOG_NCQ_NON_DATA_ABORT_NON_STREAMING = 8,
	ATA_LOG_NCQ_NON_DATA_ABORT_SELECTED = 16,
	ATA_LOG_NCQ_NON_DATA_ZAC_MGMT_OFFSET = 28,
	ATA_LOG_NCQ_NON_DATA_ZAC_MGMT_OUT = 1,
	ATA_LOG_NCQ_NON_DATA_SIZE = 64,
	ATA_CMD_READ_LONG = 34,
	ATA_CMD_READ_LONG_ONCE = 35,
	ATA_CMD_WRITE_LONG = 50,
	ATA_CMD_WRITE_LONG_ONCE = 51,
	SETFEATURES_XFER = 3,
	XFER_UDMA_7 = 71,
	XFER_UDMA_6 = 70,
	XFER_UDMA_5 = 69,
	XFER_UDMA_4 = 68,
	XFER_UDMA_3 = 67,
	XFER_UDMA_2 = 66,
	XFER_UDMA_1 = 65,
	XFER_UDMA_0 = 64,
	XFER_MW_DMA_4 = 36,
	XFER_MW_DMA_3 = 35,
	XFER_MW_DMA_2 = 34,
	XFER_MW_DMA_1 = 33,
	XFER_MW_DMA_0 = 32,
	XFER_SW_DMA_2 = 18,
	XFER_SW_DMA_1 = 17,
	XFER_SW_DMA_0 = 16,
	XFER_PIO_6 = 14,
	XFER_PIO_5 = 13,
	XFER_PIO_4 = 12,
	XFER_PIO_3 = 11,
	XFER_PIO_2 = 10,
	XFER_PIO_1 = 9,
	XFER_PIO_0 = 8,
	XFER_PIO_SLOW = 0,
	SETFEATURES_WC_ON = 2,
	SETFEATURES_WC_OFF = 130,
	SETFEATURES_RA_ON = 170,
	SETFEATURES_RA_OFF = 85,
	SETFEATURES_AAM_ON = 66,
	SETFEATURES_AAM_OFF = 194,
	SETFEATURES_SPINUP = 7,
	SETFEATURES_SPINUP_TIMEOUT = 30000,
	SETFEATURES_SATA_ENABLE = 16,
	SETFEATURES_SATA_DISABLE = 144,
	SETFEATURES_CDL = 13,
	SATA_FPDMA_OFFSET = 1,
	SATA_FPDMA_AA = 2,
	SATA_DIPM = 3,
	SATA_FPDMA_IN_ORDER = 4,
	SATA_AN = 5,
	SATA_SSP = 6,
	SATA_DEVSLP = 9,
	SETFEATURE_SENSE_DATA = 195,
	SETFEATURE_SENSE_DATA_SUCC_NCQ = 196,
	ATA_SET_MAX_ADDR = 0,
	ATA_SET_MAX_PASSWD = 1,
	ATA_SET_MAX_LOCK = 2,
	ATA_SET_MAX_UNLOCK = 3,
	ATA_SET_MAX_FREEZE_LOCK = 4,
	ATA_SET_MAX_PASSWD_DMA = 5,
	ATA_SET_MAX_UNLOCK_DMA = 6,
	ATA_DCO_RESTORE = 192,
	ATA_DCO_FREEZE_LOCK = 193,
	ATA_DCO_IDENTIFY = 194,
	ATA_DCO_SET = 195,
	ATA_SMART_ENABLE = 216,
	ATA_SMART_READ_VALUES = 208,
	ATA_SMART_READ_THRESHOLDS = 209,
	ATA_DSM_TRIM = 1,
	ATA_SMART_LBAM_PASS = 79,
	ATA_SMART_LBAH_PASS = 194,
	ATAPI_PKT_DMA = 1,
	ATAPI_DMADIR = 4,
	ATAPI_CDB_LEN = 16,
	SATA_PMP_MAX_PORTS = 15,
	SATA_PMP_CTRL_PORT = 15,
	SATA_PMP_GSCR_DWORDS = 128,
	SATA_PMP_GSCR_PROD_ID = 0,
	SATA_PMP_GSCR_REV = 1,
	SATA_PMP_GSCR_PORT_INFO = 2,
	SATA_PMP_GSCR_ERROR = 32,
	SATA_PMP_GSCR_ERROR_EN = 33,
	SATA_PMP_GSCR_FEAT = 64,
	SATA_PMP_GSCR_FEAT_EN = 96,
	SATA_PMP_PSCR_STATUS = 0,
	SATA_PMP_PSCR_ERROR = 1,
	SATA_PMP_PSCR_CONTROL = 2,
	SATA_PMP_FEAT_BIST = 1,
	SATA_PMP_FEAT_PMREQ = 2,
	SATA_PMP_FEAT_DYNSSC = 4,
	SATA_PMP_FEAT_NOTIFY = 8,
	ATA_CBL_NONE = 0,
	ATA_CBL_PATA40 = 1,
	ATA_CBL_PATA80 = 2,
	ATA_CBL_PATA40_SHORT = 3,
	ATA_CBL_PATA_UNK = 4,
	ATA_CBL_PATA_IGN = 5,
	ATA_CBL_SATA = 6,
	SCR_STATUS = 0,
	SCR_ERROR = 1,
	SCR_CONTROL = 2,
	SCR_ACTIVE = 3,
	SCR_NOTIFICATION = 4,
	SERR_DATA_RECOVERED = 1,
	SERR_COMM_RECOVERED = 2,
	SERR_DATA = 256,
	SERR_PERSISTENT = 512,
	SERR_PROTOCOL = 1024,
	SERR_INTERNAL = 2048,
	SERR_PHYRDY_CHG = 65536,
	SERR_PHY_INT_ERR = 131072,
	SERR_COMM_WAKE = 262144,
	SERR_10B_8B_ERR = 524288,
	SERR_DISPARITY = 1048576,
	SERR_CRC = 2097152,
	SERR_HANDSHAKE = 4194304,
	SERR_LINK_SEQ_ERR = 8388608,
	SERR_TRANS_ST_ERROR = 16777216,
	SERR_UNRECOG_FIS = 33554432,
	SERR_DEV_XCHG = 67108864,
};

enum ata_prot_flags {
	ATA_PROT_FLAG_PIO = 1,
	ATA_PROT_FLAG_DMA = 2,
	ATA_PROT_FLAG_NCQ = 4,
	ATA_PROT_FLAG_ATAPI = 8,
	ATA_PROT_UNKNOWN = 255,
	ATA_PROT_NODATA = 0,
	ATA_PROT_PIO = 1,
	ATA_PROT_DMA = 2,
	ATA_PROT_NCQ_NODATA = 4,
	ATA_PROT_NCQ = 6,
	ATAPI_PROT_NODATA = 8,
	ATAPI_PROT_PIO = 9,
	ATAPI_PROT_DMA = 10,
};

struct ata_bmdma_prd {
	__le32 addr;
	__le32 flags_len;
};

typedef u64 async_cookie_t;

enum {
	LIBATA_MAX_PRD = 128,
	LIBATA_DUMB_MAX_PRD = 64,
	ATA_DEF_QUEUE = 1,
	ATA_MAX_QUEUE = 32,
	ATA_TAG_INTERNAL = 32,
	ATA_SHORT_PAUSE = 16,
	ATAPI_MAX_DRAIN = 16384,
	ATA_ALL_DEVICES = 3,
	ATA_SHT_EMULATED = 1,
	ATA_SHT_THIS_ID = -1,
	ATA_TFLAG_LBA48 = 1,
	ATA_TFLAG_ISADDR = 2,
	ATA_TFLAG_DEVICE = 4,
	ATA_TFLAG_WRITE = 8,
	ATA_TFLAG_LBA = 16,
	ATA_TFLAG_FUA = 32,
	ATA_TFLAG_POLLING = 64,
	ATA_DFLAG_LBA = 1,
	ATA_DFLAG_LBA48 = 2,
	ATA_DFLAG_CDB_INTR = 4,
	ATA_DFLAG_NCQ = 8,
	ATA_DFLAG_FLUSH_EXT = 16,
	ATA_DFLAG_ACPI_PENDING = 32,
	ATA_DFLAG_ACPI_FAILED = 64,
	ATA_DFLAG_AN = 128,
	ATA_DFLAG_TRUSTED = 256,
	ATA_DFLAG_FUA = 512,
	ATA_DFLAG_DMADIR = 1024,
	ATA_DFLAG_NCQ_SEND_RECV = 2048,
	ATA_DFLAG_NCQ_PRIO = 4096,
	ATA_DFLAG_CDL = 8192,
	ATA_DFLAG_CFG_MASK = 16383,
	ATA_DFLAG_PIO = 16384,
	ATA_DFLAG_NCQ_OFF = 32768,
	ATA_DFLAG_SLEEPING = 65536,
	ATA_DFLAG_DUBIOUS_XFER = 131072,
	ATA_DFLAG_NO_UNLOAD = 262144,
	ATA_DFLAG_UNLOCK_HPA = 524288,
	ATA_DFLAG_INIT_MASK = 1048575,
	ATA_DFLAG_NCQ_PRIO_ENABLED = 1048576,
	ATA_DFLAG_CDL_ENABLED = 2097152,
	ATA_DFLAG_DETACH = 16777216,
	ATA_DFLAG_DETACHED = 33554432,
	ATA_DFLAG_DA = 67108864,
	ATA_DFLAG_DEVSLP = 134217728,
	ATA_DFLAG_ACPI_DISABLED = 268435456,
	ATA_DFLAG_D_SENSE = 536870912,
	ATA_DFLAG_ZAC = 1073741824,
	ATA_DFLAG_FEATURES_MASK = 201341696,
	ATA_DEV_UNKNOWN = 0,
	ATA_DEV_ATA = 1,
	ATA_DEV_ATA_UNSUP = 2,
	ATA_DEV_ATAPI = 3,
	ATA_DEV_ATAPI_UNSUP = 4,
	ATA_DEV_PMP = 5,
	ATA_DEV_PMP_UNSUP = 6,
	ATA_DEV_SEMB = 7,
	ATA_DEV_SEMB_UNSUP = 8,
	ATA_DEV_ZAC = 9,
	ATA_DEV_ZAC_UNSUP = 10,
	ATA_DEV_NONE = 11,
	ATA_LFLAG_NO_HRST = 2,
	ATA_LFLAG_NO_SRST = 4,
	ATA_LFLAG_ASSUME_ATA = 8,
	ATA_LFLAG_ASSUME_SEMB = 16,
	ATA_LFLAG_ASSUME_CLASS = 24,
	ATA_LFLAG_NO_RETRY = 32,
	ATA_LFLAG_DISABLED = 64,
	ATA_LFLAG_SW_ACTIVITY = 128,
	ATA_LFLAG_NO_LPM = 256,
	ATA_LFLAG_RST_ONCE = 512,
	ATA_LFLAG_CHANGED = 1024,
	ATA_LFLAG_NO_DEBOUNCE_DELAY = 2048,
	ATA_FLAG_SLAVE_POSS = 1,
	ATA_FLAG_SATA = 2,
	ATA_FLAG_NO_LPM = 4,
	ATA_FLAG_NO_LOG_PAGE = 32,
	ATA_FLAG_NO_ATAPI = 64,
	ATA_FLAG_PIO_DMA = 128,
	ATA_FLAG_PIO_LBA48 = 256,
	ATA_FLAG_PIO_POLLING = 512,
	ATA_FLAG_NCQ = 1024,
	ATA_FLAG_NO_POWEROFF_SPINDOWN = 2048,
	ATA_FLAG_NO_HIBERNATE_SPINDOWN = 4096,
	ATA_FLAG_DEBUGMSG = 8192,
	ATA_FLAG_FPDMA_AA = 16384,
	ATA_FLAG_IGN_SIMPLEX = 32768,
	ATA_FLAG_NO_IORDY = 65536,
	ATA_FLAG_ACPI_SATA = 131072,
	ATA_FLAG_AN = 262144,
	ATA_FLAG_PMP = 524288,
	ATA_FLAG_FPDMA_AUX = 1048576,
	ATA_FLAG_EM = 2097152,
	ATA_FLAG_SW_ACTIVITY = 4194304,
	ATA_FLAG_NO_DIPM = 8388608,
	ATA_FLAG_SAS_HOST = 16777216,
	ATA_PFLAG_EH_PENDING = 1,
	ATA_PFLAG_EH_IN_PROGRESS = 2,
	ATA_PFLAG_FROZEN = 4,
	ATA_PFLAG_RECOVERED = 8,
	ATA_PFLAG_LOADING = 16,
	ATA_PFLAG_SCSI_HOTPLUG = 64,
	ATA_PFLAG_INITIALIZING = 128,
	ATA_PFLAG_RESETTING = 256,
	ATA_PFLAG_UNLOADING = 512,
	ATA_PFLAG_UNLOADED = 1024,
	ATA_PFLAG_RESUMING = 65536,
	ATA_PFLAG_SUSPENDED = 131072,
	ATA_PFLAG_PM_PENDING = 262144,
	ATA_PFLAG_INIT_GTM_VALID = 524288,
	ATA_PFLAG_PIO32 = 1048576,
	ATA_PFLAG_PIO32CHANGE = 2097152,
	ATA_PFLAG_EXTERNAL = 4194304,
	ATA_QCFLAG_ACTIVE = 1,
	ATA_QCFLAG_DMAMAP = 2,
	ATA_QCFLAG_RTF_FILLED = 4,
	ATA_QCFLAG_IO = 8,
	ATA_QCFLAG_RESULT_TF = 16,
	ATA_QCFLAG_CLEAR_EXCL = 32,
	ATA_QCFLAG_QUIET = 64,
	ATA_QCFLAG_RETRY = 128,
	ATA_QCFLAG_HAS_CDL = 256,
	ATA_QCFLAG_EH = 65536,
	ATA_QCFLAG_SENSE_VALID = 131072,
	ATA_QCFLAG_EH_SCHEDULED = 262144,
	ATA_QCFLAG_EH_SUCCESS_CMD = 524288,
	ATA_HOST_SIMPLEX = 1,
	ATA_HOST_STARTED = 2,
	ATA_HOST_PARALLEL_SCAN = 4,
	ATA_HOST_IGNORE_ATA = 8,
	ATA_HOST_NO_PART = 16,
	ATA_HOST_NO_SSC = 32,
	ATA_HOST_NO_DEVSLP = 64,
	ATA_TMOUT_BOOT = 30000,
	ATA_TMOUT_BOOT_QUICK = 7000,
	ATA_TMOUT_INTERNAL_QUICK = 5000,
	ATA_TMOUT_MAX_PARK = 30000,
	ATA_TMOUT_FF_WAIT_LONG = 2000,
	ATA_TMOUT_FF_WAIT = 800,
	ATA_WAIT_AFTER_RESET = 150,
	ATA_TMOUT_PMP_SRST_WAIT = 10000,
	ATA_TMOUT_SPURIOUS_PHY = 10000,
	BUS_UNKNOWN = 0,
	BUS_DMA = 1,
	BUS_IDLE = 2,
	BUS_NOINTR = 3,
	BUS_NODATA = 4,
	BUS_TIMER = 5,
	BUS_PIO = 6,
	BUS_EDD = 7,
	BUS_IDENTIFY = 8,
	BUS_PACKET = 9,
	PORT_UNKNOWN = 0,
	PORT_ENABLED = 1,
	PORT_DISABLED = 2,
	ATA_NR_PIO_MODES = 7,
	ATA_NR_MWDMA_MODES = 5,
	ATA_NR_UDMA_MODES = 8,
	ATA_SHIFT_PIO = 0,
	ATA_SHIFT_MWDMA = 7,
	ATA_SHIFT_UDMA = 12,
	ATA_SHIFT_PRIO = 6,
	ATA_PRIO_HIGH = 2,
	ATA_DMA_PAD_SZ = 4,
	ATA_ERING_SIZE = 32,
	ATA_DEFER_LINK = 1,
	ATA_DEFER_PORT = 2,
	ATA_EH_DESC_LEN = 80,
	ATA_EH_REVALIDATE = 1,
	ATA_EH_SOFTRESET = 2,
	ATA_EH_HARDRESET = 4,
	ATA_EH_RESET = 6,
	ATA_EH_ENABLE_LINK = 8,
	ATA_EH_PARK = 32,
	ATA_EH_GET_SUCCESS_SENSE = 64,
	ATA_EH_SET_ACTIVE = 128,
	ATA_EH_PERDEV_MASK = 225,
	ATA_EH_ALL_ACTIONS = 15,
	ATA_EHI_HOTPLUGGED = 1,
	ATA_EHI_NO_AUTOPSY = 4,
	ATA_EHI_QUIET = 8,
	ATA_EHI_NO_RECOVERY = 16,
	ATA_EHI_DID_SOFTRESET = 65536,
	ATA_EHI_DID_HARDRESET = 131072,
	ATA_EHI_PRINTINFO = 262144,
	ATA_EHI_SETMODE = 524288,
	ATA_EHI_POST_SETMODE = 1048576,
	ATA_EHI_DID_RESET = 196608,
	ATA_EHI_TO_SLAVE_MASK = 12,
	ATA_EH_MAX_TRIES = 5,
	ATA_LINK_RESUME_TRIES = 5,
	ATA_EH_DEV_TRIES = 3,
	ATA_EH_PMP_TRIES = 5,
	ATA_EH_PMP_LINK_TRIES = 3,
	SATA_PMP_RW_TIMEOUT = 3000,
	ATA_EH_CMD_TIMEOUT_TABLE_SIZE = 8,
	ATA_HORKAGE_DIAGNOSTIC = 1,
	ATA_HORKAGE_NODMA = 2,
	ATA_HORKAGE_NONCQ = 4,
	ATA_HORKAGE_MAX_SEC_128 = 8,
	ATA_HORKAGE_BROKEN_HPA = 16,
	ATA_HORKAGE_DISABLE = 32,
	ATA_HORKAGE_HPA_SIZE = 64,
	ATA_HORKAGE_IVB = 256,
	ATA_HORKAGE_STUCK_ERR = 512,
	ATA_HORKAGE_BRIDGE_OK = 1024,
	ATA_HORKAGE_ATAPI_MOD16_DMA = 2048,
	ATA_HORKAGE_FIRMWARE_WARN = 4096,
	ATA_HORKAGE_1_5_GBPS = 8192,
	ATA_HORKAGE_NOSETXFER = 16384,
	ATA_HORKAGE_BROKEN_FPDMA_AA = 32768,
	ATA_HORKAGE_DUMP_ID = 65536,
	ATA_HORKAGE_MAX_SEC_LBA48 = 131072,
	ATA_HORKAGE_ATAPI_DMADIR = 262144,
	ATA_HORKAGE_NO_NCQ_TRIM = 524288,
	ATA_HORKAGE_NOLPM = 1048576,
	ATA_HORKAGE_WD_BROKEN_LPM = 2097152,
	ATA_HORKAGE_ZERO_AFTER_TRIM = 4194304,
	ATA_HORKAGE_NO_DMA_LOG = 8388608,
	ATA_HORKAGE_NOTRIM = 16777216,
	ATA_HORKAGE_MAX_SEC_1024 = 33554432,
	ATA_HORKAGE_MAX_TRIM_128M = 67108864,
	ATA_HORKAGE_NO_NCQ_ON_ATI = 134217728,
	ATA_HORKAGE_NO_ID_DEV_LOG = 268435456,
	ATA_HORKAGE_NO_LOG_DIR = 536870912,
	ATA_HORKAGE_NO_FUA = 1073741824,
	ATA_DMA_MASK_ATA = 1,
	ATA_DMA_MASK_ATAPI = 2,
	ATA_DMA_MASK_CFA = 4,
	ATAPI_READ = 0,
	ATAPI_WRITE = 1,
	ATAPI_READ_CD = 2,
	ATAPI_PASS_THRU = 3,
	ATAPI_MISC = 4,
	ATA_TIMING_SETUP = 1,
	ATA_TIMING_ACT8B = 2,
	ATA_TIMING_REC8B = 4,
	ATA_TIMING_CYC8B = 8,
	ATA_TIMING_8BIT = 14,
	ATA_TIMING_ACTIVE = 16,
	ATA_TIMING_RECOVER = 32,
	ATA_TIMING_DMACK_HOLD = 64,
	ATA_TIMING_CYCLE = 128,
	ATA_TIMING_UDMA = 256,
	ATA_TIMING_ALL = 511,
	ATA_ACPI_FILTER_SETXFER = 1,
	ATA_ACPI_FILTER_LOCK = 2,
	ATA_ACPI_FILTER_DIPM = 4,
	ATA_ACPI_FILTER_FPDMA_OFFSET = 8,
	ATA_ACPI_FILTER_FPDMA_AA = 16,
	ATA_ACPI_FILTER_DEFAULT = 7,
};

enum ata_completion_errors {
	AC_ERR_OK = 0,
	AC_ERR_DEV = 1,
	AC_ERR_HSM = 2,
	AC_ERR_TIMEOUT = 4,
	AC_ERR_MEDIA = 8,
	AC_ERR_ATA_BUS = 16,
	AC_ERR_HOST_BUS = 32,
	AC_ERR_SYSTEM = 64,
	AC_ERR_INVALID = 128,
	AC_ERR_OTHER = 256,
	AC_ERR_NODEV_HINT = 512,
	AC_ERR_NCQ = 1024,
};

enum ata_lpm_policy {
	ATA_LPM_UNKNOWN = 0,
	ATA_LPM_MAX_POWER = 1,
	ATA_LPM_MED_POWER = 2,
	ATA_LPM_MED_POWER_WITH_DIPM = 3,
	ATA_LPM_MIN_POWER_WITH_PARTIAL = 4,
	ATA_LPM_MIN_POWER = 5,
};

struct ata_queued_cmd;

typedef void (*ata_qc_cb_t)(struct ata_queued_cmd *);

struct ata_taskfile {
	long unsigned int flags;
	u8 protocol;
	u8 ctl;
	u8 hob_feature;
	u8 hob_nsect;
	u8 hob_lbal;
	u8 hob_lbam;
	u8 hob_lbah;
	union {
		u8 error;
		u8 feature;
	};
	u8 nsect;
	u8 lbal;
	u8 lbam;
	u8 lbah;
	u8 device;
	union {
		u8 status;
		u8 command;
	};
	u32 auxiliary;
};

struct ata_port;

struct ata_device;

struct ata_queued_cmd {
	struct ata_port *ap;
	struct ata_device *dev;
	struct scsi_cmnd *scsicmd;
	void (*scsidone)(struct scsi_cmnd *);
	struct ata_taskfile tf;
	u8 cdb[16];
	long unsigned int flags;
	unsigned int tag;
	unsigned int hw_tag;
	unsigned int n_elem;
	unsigned int orig_n_elem;
	int dma_dir;
	unsigned int sect_size;
	unsigned int nbytes;
	unsigned int extrabytes;
	unsigned int curbytes;
	struct scatterlist sgent;
	struct scatterlist *sg;
	struct scatterlist *cursg;
	unsigned int cursg_ofs;
	unsigned int err_mask;
	struct ata_taskfile result_tf;
	ata_qc_cb_t complete_fn;
	void *private_data;
	void *lldd_task;
};

struct ata_link;

typedef int (*ata_prereset_fn_t)(struct ata_link *, long unsigned int);

struct ata_eh_info {
	struct ata_device *dev;
	u32 serror;
	unsigned int err_mask;
	unsigned int action;
	unsigned int dev_action[2];
	unsigned int flags;
	unsigned int probe_mask;
	char desc[80];
	int desc_len;
};

struct ata_eh_context {
	struct ata_eh_info i;
	int tries[2];
	int cmd_timeout_idx[16];
	unsigned int classes[2];
	unsigned int did_probe_mask;
	unsigned int unloaded_mask;
	unsigned int saved_ncq_enabled;
	u8 saved_xfer_mode[2];
	long unsigned int last_reset;
};

struct ata_ering_entry {
	unsigned int eflags;
	unsigned int err_mask;
	u64 timestamp;
};

struct ata_ering {
	int cursor;
	struct ata_ering_entry ring[32];
};

struct ata_cpr_log;

struct ata_device {
	struct ata_link *link;
	unsigned int devno;
	unsigned int horkage;
	long unsigned int flags;
	struct scsi_device *sdev;
	void *private_data;
	struct device tdev;
	u64 n_sectors;
	u64 n_native_sectors;
	unsigned int class;
	long unsigned int unpark_deadline;
	u8 pio_mode;
	u8 dma_mode;
	u8 xfer_mode;
	unsigned int xfer_shift;
	unsigned int multi_count;
	unsigned int max_sectors;
	unsigned int cdb_len;
	unsigned int pio_mask;
	unsigned int mwdma_mask;
	unsigned int udma_mask;
	u16 cylinders;
	u16 heads;
	u16 sectors;
	union {
		u16 id[256];
		u32 gscr[128];
	};
	u8 devslp_timing[8];
	u8 ncq_send_recv_cmds[20];
	u8 ncq_non_data_cmds[64];
	u32 zac_zoned_cap;
	u32 zac_zones_optimal_open;
	u32 zac_zones_optimal_nonseq;
	u32 zac_zones_max_open;
	struct ata_cpr_log *cpr_log;
	u8 cdl[512];
	int spdn_cnt;
	struct ata_ering ering;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct ata_link {
	struct ata_port *ap;
	int pmp;
	struct device tdev;
	unsigned int active_tag;
	u32 sactive;
	unsigned int flags;
	u32 saved_scontrol;
	unsigned int hw_sata_spd_limit;
	unsigned int sata_spd_limit;
	unsigned int sata_spd;
	enum ata_lpm_policy lpm_policy;
	struct ata_eh_info eh_info;
	struct ata_eh_context eh_context;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct ata_device device[2];
	long unsigned int last_lpm_change;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

typedef int (*ata_reset_fn_t)(struct ata_link *, unsigned int *, long unsigned int);

typedef void (*ata_postreset_fn_t)(struct ata_link *, unsigned int *);

enum sw_activity {
	OFF = 0,
	BLINK_ON = 1,
	BLINK_OFF = 2,
};

struct ata_ioports {
	void *cmd_addr;
	void *data_addr;
	void *error_addr;
	void *feature_addr;
	void *nsect_addr;
	void *lbal_addr;
	void *lbam_addr;
	void *lbah_addr;
	void *device_addr;
	void *status_addr;
	void *command_addr;
	void *altstatus_addr;
	void *ctl_addr;
	void *bmdma_addr;
	void *scr_addr;
};

struct ata_port_operations;

struct ata_host {
	spinlock_t lock;
	struct device *dev;
	void * const *iomap;
	unsigned int n_ports;
	unsigned int n_tags;
	void *private_data;
	struct ata_port_operations *ops;
	long unsigned int flags;
	struct kref kref;
	struct mutex eh_mutex;
	struct task_struct *eh_owner;
	struct ata_port *simplex_claimed;
	struct ata_port *ports[0];
};

struct ata_port_operations {
	int (*qc_defer)(struct ata_queued_cmd *);
	int (*check_atapi_dma)(struct ata_queued_cmd *);
	enum ata_completion_errors (*qc_prep)(struct ata_queued_cmd *);
	unsigned int (*qc_issue)(struct ata_queued_cmd *);
	void (*qc_fill_rtf)(struct ata_queued_cmd *);
	void (*qc_ncq_fill_rtf)(struct ata_port *, u64);
	int (*cable_detect)(struct ata_port *);
	unsigned int (*mode_filter)(struct ata_device *, unsigned int);
	void (*set_piomode)(struct ata_port *, struct ata_device *);
	void (*set_dmamode)(struct ata_port *, struct ata_device *);
	int (*set_mode)(struct ata_link *, struct ata_device **);
	unsigned int (*read_id)(struct ata_device *, struct ata_taskfile *, __le16 *);
	void (*dev_config)(struct ata_device *);
	void (*freeze)(struct ata_port *);
	void (*thaw)(struct ata_port *);
	ata_prereset_fn_t prereset;
	ata_reset_fn_t softreset;
	ata_reset_fn_t hardreset;
	ata_postreset_fn_t postreset;
	ata_prereset_fn_t pmp_prereset;
	ata_reset_fn_t pmp_softreset;
	ata_reset_fn_t pmp_hardreset;
	ata_postreset_fn_t pmp_postreset;
	void (*error_handler)(struct ata_port *);
	void (*lost_interrupt)(struct ata_port *);
	void (*post_internal_cmd)(struct ata_queued_cmd *);
	void (*sched_eh)(struct ata_port *);
	void (*end_eh)(struct ata_port *);
	int (*scr_read)(struct ata_link *, unsigned int, u32 *);
	int (*scr_write)(struct ata_link *, unsigned int, u32);
	void (*pmp_attach)(struct ata_port *);
	void (*pmp_detach)(struct ata_port *);
	int (*set_lpm)(struct ata_link *, enum ata_lpm_policy, unsigned int);
	int (*port_suspend)(struct ata_port *, pm_message_t);
	int (*port_resume)(struct ata_port *);
	int (*port_start)(struct ata_port *);
	void (*port_stop)(struct ata_port *);
	void (*host_stop)(struct ata_host *);
	void (*sff_dev_select)(struct ata_port *, unsigned int);
	void (*sff_set_devctl)(struct ata_port *, u8);
	u8 (*sff_check_status)(struct ata_port *);
	u8 (*sff_check_altstatus)(struct ata_port *);
	void (*sff_tf_load)(struct ata_port *, const struct ata_taskfile *);
	void (*sff_tf_read)(struct ata_port *, struct ata_taskfile *);
	void (*sff_exec_command)(struct ata_port *, const struct ata_taskfile *);
	unsigned int (*sff_data_xfer)(struct ata_queued_cmd *, unsigned char *, unsigned int, int);
	void (*sff_irq_on)(struct ata_port *);
	bool (*sff_irq_check)(struct ata_port *);
	void (*sff_irq_clear)(struct ata_port *);
	void (*sff_drain_fifo)(struct ata_queued_cmd *);
	void (*bmdma_setup)(struct ata_queued_cmd *);
	void (*bmdma_start)(struct ata_queued_cmd *);
	void (*bmdma_stop)(struct ata_queued_cmd *);
	u8 (*bmdma_status)(struct ata_port *);
	ssize_t (*em_show)(struct ata_port *, char *);
	ssize_t (*em_store)(struct ata_port *, const char *, size_t);
	ssize_t (*sw_activity_show)(struct ata_device *, char *);
	ssize_t (*sw_activity_store)(struct ata_device *, enum sw_activity);
	ssize_t (*transmit_led_message)(struct ata_port *, u32, ssize_t);
	const struct ata_port_operations *inherits;
};

struct ata_port_stats {
	long unsigned int unhandled_irq;
	long unsigned int idle_irq;
	long unsigned int rw_reqbuf;
};

struct ata_port {
	struct Scsi_Host *scsi_host;
	struct ata_port_operations *ops;
	spinlock_t *lock;
	long unsigned int flags;
	unsigned int pflags;
	unsigned int print_id;
	unsigned int local_port_no;
	unsigned int port_no;
	struct ata_ioports ioaddr;
	u8 ctl;
	u8 last_ctl;
	struct ata_link *sff_pio_task_link;
	struct delayed_work sff_pio_task;
	struct ata_bmdma_prd *bmdma_prd;
	dma_addr_t bmdma_prd_dma;
	unsigned int pio_mask;
	unsigned int mwdma_mask;
	unsigned int udma_mask;
	unsigned int cbl;
	struct ata_queued_cmd qcmd[33];
	u64 qc_active;
	int nr_active_links;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct ata_link link;
	struct ata_link *slave_link;
	int nr_pmp_links;
	struct ata_link *pmp_link;
	struct ata_link *excl_link;
	struct ata_port_stats stats;
	struct ata_host *host;
	struct device *dev;
	struct device tdev;
	struct mutex scsi_scan_mutex;
	struct delayed_work hotplug_task;
	struct delayed_work scsi_rescan_task;
	unsigned int hsm_task_state;
	struct list_head eh_done_q;
	wait_queue_head_t eh_wait_q;
	int eh_tries;
	struct completion park_req_pending;
	pm_message_t pm_mesg;
	enum ata_lpm_policy target_lpm_policy;
	struct timer_list fastdrain_timer;
	unsigned int fastdrain_cnt;
	async_cookie_t cookie;
	int em_message_type;
	void *private_data;
	u8 *ncq_sense_buf;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	u8 sector_buf[512];
};

struct ata_cpr {
	u8 num;
	u8 num_storage_elements;
	u64 start_lba;
	u64 num_lbas;
};

struct ata_cpr_log {
	u8 nr_cpr;
	struct ata_cpr cpr[0];
};

enum ata_link_iter_mode {
	ATA_LITER_EDGE = 0,
	ATA_LITER_HOST_FIRST = 1,
	ATA_LITER_PMP_FIRST = 2,
};

enum ata_dev_iter_mode {
	ATA_DITER_ENABLED = 0,
	ATA_DITER_ENABLED_REVERSE = 1,
	ATA_DITER_ALL = 2,
	ATA_DITER_ALL_REVERSE = 3,
};

typedef unsigned int (*ata_xlat_func_t)(struct ata_queued_cmd *);

struct ata_scsi_args {
	struct ata_device *dev;
	u16 *id;
	struct scsi_cmnd *cmd;
};

struct module_version_attribute {
	struct module_attribute mattr;
	const char *module_name;
	const char *version;
};

struct phy_configure_opts_dp {
	unsigned int link_rate;
	unsigned int lanes;
	unsigned int voltage[4];
	unsigned int pre[4];
	u8 ssc: 1;
	u8 set_rate: 1;
	u8 set_lanes: 1;
	u8 set_voltages: 1;
};

struct phy_configure_opts_lvds {
	unsigned int bits_per_lane_and_dclk_cycle;
	long unsigned int differential_clk_rate;
	unsigned int lanes;
	bool is_slave;
};

struct phy_configure_opts_mipi_dphy {
	unsigned int clk_miss;
	unsigned int clk_post;
	unsigned int clk_pre;
	unsigned int clk_prepare;
	unsigned int clk_settle;
	unsigned int clk_term_en;
	unsigned int clk_trail;
	unsigned int clk_zero;
	unsigned int d_term_en;
	unsigned int eot;
	unsigned int hs_exit;
	unsigned int hs_prepare;
	unsigned int hs_settle;
	unsigned int hs_skip;
	unsigned int hs_trail;
	unsigned int hs_zero;
	unsigned int init;
	unsigned int lpx;
	unsigned int ta_get;
	unsigned int ta_go;
	unsigned int ta_sure;
	unsigned int wakeup;
	long unsigned int hs_clk_rate;
	long unsigned int lp_clk_rate;
	unsigned char lanes;
};

enum phy_mode {
	PHY_MODE_INVALID = 0,
	PHY_MODE_USB_HOST = 1,
	PHY_MODE_USB_HOST_LS = 2,
	PHY_MODE_USB_HOST_FS = 3,
	PHY_MODE_USB_HOST_HS = 4,
	PHY_MODE_USB_HOST_SS = 5,
	PHY_MODE_USB_DEVICE = 6,
	PHY_MODE_USB_DEVICE_LS = 7,
	PHY_MODE_USB_DEVICE_FS = 8,
	PHY_MODE_USB_DEVICE_HS = 9,
	PHY_MODE_USB_DEVICE_SS = 10,
	PHY_MODE_USB_OTG = 11,
	PHY_MODE_UFS_HS_A = 12,
	PHY_MODE_UFS_HS_B = 13,
	PHY_MODE_PCIE = 14,
	PHY_MODE_ETHERNET = 15,
	PHY_MODE_MIPI_DPHY = 16,
	PHY_MODE_SATA = 17,
	PHY_MODE_LVDS = 18,
	PHY_MODE_DP = 19,
};

enum phy_media {
	PHY_MEDIA_DEFAULT = 0,
	PHY_MEDIA_SR = 1,
	PHY_MEDIA_DAC = 2,
};

union phy_configure_opts {
	struct phy_configure_opts_mipi_dphy mipi_dphy;
	struct phy_configure_opts_dp dp;
	struct phy_configure_opts_lvds lvds;
};

struct phy;

struct phy_ops {
	int (*init)(struct phy *);
	int (*exit)(struct phy *);
	int (*power_on)(struct phy *);
	int (*power_off)(struct phy *);
	int (*set_mode)(struct phy *, enum phy_mode, int);
	int (*set_media)(struct phy *, enum phy_media);
	int (*set_speed)(struct phy *, int);
	int (*configure)(struct phy *, union phy_configure_opts *);
	int (*validate)(struct phy *, enum phy_mode, int, union phy_configure_opts *);
	int (*reset)(struct phy *);
	int (*calibrate)(struct phy *);
	void (*release)(struct phy *);
	struct module *owner;
};

struct phy_attrs {
	u32 bus_width;
	u32 max_link_rate;
	enum phy_mode mode;
};

struct phy {
	struct device dev;
	int id;
	const struct phy_ops *ops;
	struct mutex mutex;
	int init_count;
	int power_count;
	struct phy_attrs attrs;
	struct regulator *pwr;
	struct dentry *debugfs;
};

struct mv_sata_platform_data {
	int n_ports;
};

struct mbus_dram_window {
	u8 cs_index;
	u8 mbus_attr;
	u64 base;
	u64 size;
};

struct mbus_dram_target_info {
	u8 mbus_dram_target_id;
	int num_cs;
	struct mbus_dram_window cs[4];
};

enum hsm_task_states {
	HSM_ST_IDLE = 0,
	HSM_ST_FIRST = 1,
	HSM_ST = 2,
	HSM_ST_LAST = 3,
	HSM_ST_ERR = 4,
};

struct ata_port_info {
	long unsigned int flags;
	long unsigned int link_flags;
	unsigned int pio_mask;
	unsigned int mwdma_mask;
	unsigned int udma_mask;
	struct ata_port_operations *port_ops;
	void *private_data;
};

enum {
	MV_PRIMARY_BAR = 0,
	MV_IO_BAR = 2,
	MV_MISC_BAR = 3,
	MV_MAJOR_REG_AREA_SZ = 65536,
	MV_MINOR_REG_AREA_SZ = 8192,
	COAL_CLOCKS_PER_USEC = 150,
	MAX_COAL_TIME_THRESHOLD = 16777215,
	MAX_COAL_IO_COUNT = 255,
	MV_PCI_REG_BASE = 0,
	COAL_REG_BASE = 98304,
	IRQ_COAL_CAUSE = 98312,
	ALL_PORTS_COAL_IRQ = 16,
	IRQ_COAL_IO_THRESHOLD = 98508,
	IRQ_COAL_TIME_THRESHOLD = 98512,
	TRAN_COAL_CAUSE_LO = 98440,
	TRAN_COAL_CAUSE_HI = 98444,
	SATAHC0_REG_BASE = 131072,
	FLASH_CTL = 66668,
	GPIO_PORT_CTL = 66800,
	RESET_CFG = 98520,
	MV_PCI_REG_SZ = 65536,
	MV_SATAHC_REG_SZ = 65536,
	MV_SATAHC_ARBTR_REG_SZ = 8192,
	MV_PORT_REG_SZ = 8192,
	MV_MAX_Q_DEPTH = 32,
	MV_MAX_Q_DEPTH_MASK = 31,
	MV_CRQB_Q_SZ = 1024,
	MV_CRPB_Q_SZ = 256,
	MV_MAX_SG_CT = 256,
	MV_SG_TBL_SZ = 4096,
	MV_PORT_HC_SHIFT = 2,
	MV_PORTS_PER_HC = 4,
	MV_PORT_MASK = 3,
	MV_FLAG_DUAL_HC = 1073741824,
	MV_COMMON_FLAGS = 514,
	MV_GEN_I_FLAGS = 578,
	MV_GEN_II_FLAGS = 656898,
	MV_GEN_IIE_FLAGS = 919042,
	CRQB_FLAG_READ = 1,
	CRQB_TAG_SHIFT = 1,
	CRQB_IOID_SHIFT = 6,
	CRQB_PMP_SHIFT = 12,
	CRQB_HOSTQ_SHIFT = 17,
	CRQB_CMD_ADDR_SHIFT = 8,
	CRQB_CMD_CS = 4096,
	CRQB_CMD_LAST = 32768,
	CRPB_FLAG_STATUS_SHIFT = 8,
	CRPB_IOID_SHIFT_6 = 5,
	CRPB_IOID_SHIFT_7 = 7,
	EPRD_FLAG_END_OF_TBL = -2147483648,
	MV_PCI_COMMAND = 3072,
	MV_PCI_COMMAND_MWRCOM = 16,
	MV_PCI_COMMAND_MRDTRIG = 128,
	PCI_MAIN_CMD_STS = 3376,
	STOP_PCI_MASTER = 4,
	PCI_MASTER_EMPTY = 8,
	GLOB_SFT_RST = 16,
	MV_PCI_MODE = 3328,
	MV_PCI_MODE_MASK = 48,
	MV_PCI_EXP_ROM_BAR_CTL = 3372,
	MV_PCI_DISC_TIMER = 3332,
	MV_PCI_MSI_TRIGGER = 3128,
	MV_PCI_SERR_MASK = 3112,
	MV_PCI_XBAR_TMOUT = 7428,
	MV_PCI_ERR_LOW_ADDRESS = 7488,
	MV_PCI_ERR_HIGH_ADDRESS = 7492,
	MV_PCI_ERR_ATTRIBUTE = 7496,
	MV_PCI_ERR_COMMAND = 7504,
	PCI_IRQ_CAUSE = 7512,
	PCI_IRQ_MASK = 7516,
	PCI_UNMASK_ALL_IRQS = 8388607,
	PCIE_IRQ_CAUSE = 6400,
	PCIE_IRQ_MASK = 6416,
	PCIE_UNMASK_ALL_IRQS = 1034,
	PCI_HC_MAIN_IRQ_CAUSE = 7520,
	PCI_HC_MAIN_IRQ_MASK = 7524,
	SOC_HC_MAIN_IRQ_CAUSE = 131104,
	SOC_HC_MAIN_IRQ_MASK = 131108,
	ERR_IRQ = 1,
	DONE_IRQ = 2,
	HC0_IRQ_PEND = 511,
	HC_SHIFT = 9,
	DONE_IRQ_0_3 = 170,
	DONE_IRQ_4_7 = 87040,
	PCI_ERR = 262144,
	TRAN_COAL_LO_DONE = 524288,
	TRAN_COAL_HI_DONE = 1048576,
	PORTS_0_3_COAL_DONE = 256,
	PORTS_4_7_COAL_DONE = 131072,
	ALL_PORTS_COAL_DONE = 2097152,
	GPIO_INT = 4194304,
	SELF_INT = 8388608,
	TWSI_INT = 16777216,
	HC_MAIN_RSVD = -33554432,
	HC_MAIN_RSVD_5 = -524288,
	HC_MAIN_RSVD_SOC = -320,
	HC_CFG = 0,
	HC_IRQ_CAUSE = 20,
	DMA_IRQ = 1,
	HC_COAL_IRQ = 16,
	DEV_IRQ = 256,
	HC_IRQ_COAL_IO_THRESHOLD = 12,
	HC_IRQ_COAL_TIME_THRESHOLD = 16,
	SOC_LED_CTRL = 44,
	SOC_LED_CTRL_BLINK = 1,
	SOC_LED_CTRL_ACT_PRESENCE = 4,
	SHD_BLK = 256,
	SHD_CTL_AST = 32,
	SATA_STATUS = 768,
	SATA_ACTIVE = 848,
	FIS_IRQ_CAUSE = 868,
	FIS_IRQ_CAUSE_AN = 512,
	LTMODE = 780,
	LTMODE_BIT8 = 256,
	PHY_MODE2 = 816,
	PHY_MODE3 = 784,
	PHY_MODE4 = 788,
	PHY_MODE4_CFG_MASK = 3,
	PHY_MODE4_CFG_VALUE = 1,
	PHY_MODE4_RSVD_ZEROS = 1575223290,
	PHY_MODE4_RSVD_ONES = 5,
	SATA_IFCTL = 836,
	SATA_TESTCTL = 840,
	SATA_IFSTAT = 844,
	VENDOR_UNIQUE_FIS = 860,
	FISCFG = 864,
	FISCFG_WAIT_DEV_ERR = 256,
	FISCFG_SINGLE_SYNC = 65536,
	PHY_MODE9_GEN2 = 920,
	PHY_MODE9_GEN1 = 924,
	PHYCFG_OFS = 928,
	MV5_PHY_MODE = 116,
	MV5_LTMODE = 48,
	MV5_PHY_CTL = 12,
	SATA_IFCFG = 80,
	LP_PHY_CTL = 88,
	LP_PHY_CTL_PIN_PU_PLL = 1,
	LP_PHY_CTL_PIN_PU_RX = 2,
	LP_PHY_CTL_PIN_PU_TX = 4,
	LP_PHY_CTL_GEN_TX_3G = 32,
	LP_PHY_CTL_GEN_RX_3G = 512,
	MV_M2_PREAMP_MASK = 2016,
	EDMA_CFG = 0,
	EDMA_CFG_Q_DEPTH = 31,
	EDMA_CFG_NCQ = 32,
	EDMA_CFG_NCQ_GO_ON_ERR = 16384,
	EDMA_CFG_RD_BRST_EXT = 2048,
	EDMA_CFG_WR_BUFF_LEN = 8192,
	EDMA_CFG_EDMA_FBS = 65536,
	EDMA_CFG_FBS = 67108864,
	EDMA_ERR_IRQ_CAUSE = 8,
	EDMA_ERR_IRQ_MASK = 12,
	EDMA_ERR_D_PAR = 1,
	EDMA_ERR_PRD_PAR = 2,
	EDMA_ERR_DEV = 4,
	EDMA_ERR_DEV_DCON = 8,
	EDMA_ERR_DEV_CON = 16,
	EDMA_ERR_SERR = 32,
	EDMA_ERR_SELF_DIS = 128,
	EDMA_ERR_SELF_DIS_5 = 256,
	EDMA_ERR_BIST_ASYNC = 256,
	EDMA_ERR_TRANS_IRQ_7 = 256,
	EDMA_ERR_CRQB_PAR = 512,
	EDMA_ERR_CRPB_PAR = 1024,
	EDMA_ERR_INTRL_PAR = 2048,
	EDMA_ERR_IORDY = 4096,
	EDMA_ERR_LNK_CTRL_RX = 122880,
	EDMA_ERR_LNK_CTRL_RX_0 = 8192,
	EDMA_ERR_LNK_CTRL_RX_1 = 16384,
	EDMA_ERR_LNK_CTRL_RX_2 = 32768,
	EDMA_ERR_LNK_CTRL_RX_3 = 65536,
	EDMA_ERR_LNK_DATA_RX = 1966080,
	EDMA_ERR_LNK_CTRL_TX = 65011712,
	EDMA_ERR_LNK_CTRL_TX_0 = 2097152,
	EDMA_ERR_LNK_CTRL_TX_1 = 4194304,
	EDMA_ERR_LNK_CTRL_TX_2 = 8388608,
	EDMA_ERR_LNK_CTRL_TX_3 = 16777216,
	EDMA_ERR_LNK_CTRL_TX_4 = 33554432,
	EDMA_ERR_LNK_DATA_TX = 2080374784,
	EDMA_ERR_TRANS_PROTO = -2147483648,
	EDMA_ERR_OVERRUN_5 = 32,
	EDMA_ERR_UNDERRUN_5 = 64,
	EDMA_ERR_IRQ_TRANSIENT = 65101824,
	EDMA_EH_FREEZE = -65102149,
	EDMA_EH_FREEZE_5 = 8059,
	EDMA_REQ_Q_BASE_HI = 16,
	EDMA_REQ_Q_IN_PTR = 20,
	EDMA_REQ_Q_OUT_PTR = 24,
	EDMA_REQ_Q_PTR_SHIFT = 5,
	EDMA_RSP_Q_BASE_HI = 28,
	EDMA_RSP_Q_IN_PTR = 32,
	EDMA_RSP_Q_OUT_PTR = 36,
	EDMA_RSP_Q_PTR_SHIFT = 3,
	EDMA_CMD = 40,
	EDMA_EN = 1,
	EDMA_DS = 2,
	EDMA_RESET = 4,
	EDMA_STATUS = 48,
	EDMA_STATUS_CACHE_EMPTY = 64,
	EDMA_STATUS_IDLE = 128,
	EDMA_IORDY_TMOUT = 52,
	EDMA_ARB_CFG = 56,
	EDMA_HALTCOND = 96,
	EDMA_UNKNOWN_RSVD = 108,
	BMDMA_CMD = 548,
	BMDMA_STATUS = 552,
	BMDMA_PRD_LOW = 556,
	BMDMA_PRD_HIGH = 560,
	MV_HP_FLAG_MSI = 1,
	MV_HP_ERRATA_50XXB0 = 2,
	MV_HP_ERRATA_50XXB2 = 4,
	MV_HP_ERRATA_60X1B2 = 8,
	MV_HP_ERRATA_60X1C0 = 16,
	MV_HP_GEN_I = 64,
	MV_HP_GEN_II = 128,
	MV_HP_GEN_IIE = 256,
	MV_HP_PCIE = 512,
	MV_HP_CUT_THROUGH = 1024,
	MV_HP_FLAG_SOC = 2048,
	MV_HP_QUIRK_LED_BLINK_EN = 4096,
	MV_HP_FIX_LP_PHY_CTL = 8192,
	MV_PP_FLAG_EDMA_EN = 1,
	MV_PP_FLAG_NCQ_EN = 2,
	MV_PP_FLAG_FBS_EN = 4,
	MV_PP_FLAG_DELAYED_EH = 8,
	MV_PP_FLAG_FAKE_ATA_BUSY = 16,
};

enum {
	MV_DMA_BOUNDARY = 65535,
	EDMA_REQ_Q_BASE_LO_MASK = 4294966272,
	EDMA_RSP_Q_BASE_LO_MASK = 4294967040,
};

enum chip_type {
	chip_504x = 0,
	chip_508x = 1,
	chip_5080 = 2,
	chip_604x = 3,
	chip_608x = 4,
	chip_6042 = 5,
	chip_7042 = 6,
	chip_soc = 7,
};

struct mv_crqb {
	__le32 sg_addr;
	__le32 sg_addr_hi;
	__le16 ctrl_flags;
	__le16 ata_cmd[11];
};

struct mv_crqb_iie {
	__le32 addr;
	__le32 addr_hi;
	__le32 flags;
	__le32 len;
	__le32 ata_cmd[4];
};

struct mv_crpb {
	__le16 id;
	__le16 flags;
	__le32 tmstmp;
};

struct mv_sg {
	__le32 addr;
	__le32 flags_size;
	__le32 addr_hi;
	__le32 reserved;
};

struct mv_cached_regs {
	u32 fiscfg;
	u32 ltmode;
	u32 haltcond;
	u32 unknown_rsvd;
};

struct mv_port_priv {
	struct mv_crqb *crqb;
	dma_addr_t crqb_dma;
	struct mv_crpb *crpb;
	dma_addr_t crpb_dma;
	struct mv_sg *sg_tbl[32];
	dma_addr_t sg_tbl_dma[32];
	unsigned int req_idx;
	unsigned int resp_idx;
	u32 pp_flags;
	struct mv_cached_regs cached;
	unsigned int delayed_eh_pmp_map;
};

struct mv_port_signal {
	u32 amps;
	u32 pre;
};

struct dma_pool;

struct mv_hw_ops;

struct mv_host_priv {
	u32 hp_flags;
	unsigned int board_idx;
	u32 main_irq_mask;
	struct mv_port_signal signal[8];
	const struct mv_hw_ops *ops;
	int n_ports;
	void *base;
	void *main_irq_cause_addr;
	void *main_irq_mask_addr;
	u32 irq_cause_offset;
	u32 irq_mask_offset;
	u32 unmask_all_irqs;
	struct clk *clk;
	struct clk **port_clks;
	struct phy **port_phys;
	struct dma_pool *crqb_pool;
	struct dma_pool *crpb_pool;
	struct dma_pool *sg_tbl_pool;
};

struct mv_hw_ops {
	void (*phy_errata)(struct mv_host_priv *, void *, unsigned int);
	void (*enable_leds)(struct mv_host_priv *, void *);
	void (*read_preamp)(struct mv_host_priv *, int, void *);
	int (*reset_hc)(struct ata_host *, void *, unsigned int);
	void (*reset_flash)(struct mv_host_priv *, void *);
	void (*reset_bus)(struct ata_host *, void *);
};

struct reset_control;

struct mii_bus;

struct mdio_device {
	struct device dev;
	struct mii_bus *bus;
	char modalias[32];
	int (*bus_match)(struct device *, struct device_driver *);
	void (*device_free)(struct mdio_device *);
	void (*device_remove)(struct mdio_device *);
	int addr;
	int flags;
	struct gpio_desc *reset_gpio;
	struct reset_control *reset_ctrl;
	unsigned int reset_assert_delay;
	unsigned int reset_deassert_delay;
};

struct phy_c45_device_ids {
	u32 devices_in_package;
	u32 mmds_present;
	u32 device_ids[32];
};

enum phy_state {
	PHY_DOWN = 0,
	PHY_READY = 1,
	PHY_HALTED = 2,
	PHY_ERROR = 3,
	PHY_UP = 4,
	PHY_RUNNING = 5,
	PHY_NOLINK = 6,
	PHY_CABLETEST = 7,
};

typedef enum {
	PHY_INTERFACE_MODE_NA = 0,
	PHY_INTERFACE_MODE_INTERNAL = 1,
	PHY_INTERFACE_MODE_MII = 2,
	PHY_INTERFACE_MODE_GMII = 3,
	PHY_INTERFACE_MODE_SGMII = 4,
	PHY_INTERFACE_MODE_TBI = 5,
	PHY_INTERFACE_MODE_REVMII = 6,
	PHY_INTERFACE_MODE_RMII = 7,
	PHY_INTERFACE_MODE_REVRMII = 8,
	PHY_INTERFACE_MODE_RGMII = 9,
	PHY_INTERFACE_MODE_RGMII_ID = 10,
	PHY_INTERFACE_MODE_RGMII_RXID = 11,
	PHY_INTERFACE_MODE_RGMII_TXID = 12,
	PHY_INTERFACE_MODE_RTBI = 13,
	PHY_INTERFACE_MODE_SMII = 14,
	PHY_INTERFACE_MODE_XGMII = 15,
	PHY_INTERFACE_MODE_XLGMII = 16,
	PHY_INTERFACE_MODE_MOCA = 17,
	PHY_INTERFACE_MODE_PSGMII = 18,
	PHY_INTERFACE_MODE_QSGMII = 19,
	PHY_INTERFACE_MODE_TRGMII = 20,
	PHY_INTERFACE_MODE_100BASEX = 21,
	PHY_INTERFACE_MODE_1000BASEX = 22,
	PHY_INTERFACE_MODE_2500BASEX = 23,
	PHY_INTERFACE_MODE_5GBASER = 24,
	PHY_INTERFACE_MODE_RXAUI = 25,
	PHY_INTERFACE_MODE_XAUI = 26,
	PHY_INTERFACE_MODE_10GBASER = 27,
	PHY_INTERFACE_MODE_25GBASER = 28,
	PHY_INTERFACE_MODE_USXGMII = 29,
	PHY_INTERFACE_MODE_10GKR = 30,
	PHY_INTERFACE_MODE_QUSGMII = 31,
	PHY_INTERFACE_MODE_1000BASEKX = 32,
	PHY_INTERFACE_MODE_MAX = 33,
} phy_interface_t;

struct phylink;

struct pse_control;

struct phy_driver;

struct phy_package_shared;

struct mii_timestamper;

struct phy_device {
	struct mdio_device mdio;
	struct phy_driver *drv;
	struct device_link *devlink;
	u32 phy_id;
	struct phy_c45_device_ids c45_ids;
	unsigned int is_c45: 1;
	unsigned int is_internal: 1;
	unsigned int is_pseudo_fixed_link: 1;
	unsigned int is_gigabit_capable: 1;
	unsigned int has_fixups: 1;
	unsigned int suspended: 1;
	unsigned int suspended_by_mdio_bus: 1;
	unsigned int sysfs_links: 1;
	unsigned int loopback_enabled: 1;
	unsigned int downshifted_rate: 1;
	unsigned int is_on_sfp_module: 1;
	unsigned int mac_managed_pm: 1;
	unsigned int wol_enabled: 1;
	unsigned int autoneg: 1;
	unsigned int link: 1;
	unsigned int autoneg_complete: 1;
	unsigned int interrupts: 1;
	unsigned int irq_suspended: 1;
	unsigned int irq_rerun: 1;
	int rate_matching;
	enum phy_state state;
	u32 dev_flags;
	phy_interface_t interface;
	int speed;
	int duplex;
	int port;
	int pause;
	int asym_pause;
	u8 master_slave_get;
	u8 master_slave_set;
	u8 master_slave_state;
	long unsigned int supported[2];
	long unsigned int advertising[2];
	long unsigned int lp_advertising[2];
	long unsigned int adv_old[2];
	long unsigned int supported_eee[2];
	long unsigned int advertising_eee[2];
	bool eee_enabled;
	long unsigned int host_interfaces[1];
	u32 eee_broken_modes;
	struct list_head leds;
	int irq;
	void *priv;
	struct phy_package_shared *shared;
	struct sk_buff *skb;
	void *ehdr;
	struct nlattr *nest;
	struct delayed_work state_queue;
	struct mutex lock;
	bool sfp_bus_attached;
	struct sfp_bus *sfp_bus;
	struct phylink *phylink;
	struct net_device *attached_dev;
	struct mii_timestamper *mii_ts;
	struct pse_control *psec;
	u8 mdix;
	u8 mdix_ctrl;
	int pma_extable;
	unsigned int link_down_events;
	void (*phy_link_change)(struct phy_device *, bool);
	void (*adjust_link)(struct net_device *);
};

struct phy_plca_cfg {
	int version;
	int enabled;
	int node_id;
	int node_cnt;
	int to_tmr;
	int burst_cnt;
	int burst_tmr;
};

struct phy_plca_status {
	bool pst;
};

struct phy_tdr_config {
	u32 first;
	u32 last;
	u32 step;
	s8 pair;
};

enum led_brightness {
	LED_OFF = 0,
	LED_ON = 1,
	LED_HALF = 127,
	LED_FULL = 255,
};

struct mdio_bus_stats {
	u64_stats_t transfers;
	u64_stats_t errors;
	u64_stats_t writes;
	u64_stats_t reads;
	struct u64_stats_sync syncp;
};

struct mii_bus {
	struct module *owner;
	const char *name;
	char id[61];
	void *priv;
	int (*read)(struct mii_bus *, int, int);
	int (*write)(struct mii_bus *, int, int, u16);
	int (*read_c45)(struct mii_bus *, int, int, int);
	int (*write_c45)(struct mii_bus *, int, int, int, u16);
	int (*reset)(struct mii_bus *);
	struct mdio_bus_stats stats[32];
	struct mutex mdio_lock;
	struct device *parent;
	enum {
		MDIOBUS_ALLOCATED = 1,
		MDIOBUS_REGISTERED = 2,
		MDIOBUS_UNREGISTERED = 3,
		MDIOBUS_RELEASED = 4,
	} state;
	struct device dev;
	struct mdio_device *mdio_map[32];
	u32 phy_mask;
	u32 phy_ignore_ta_mask;
	int irq[32];
	int reset_delay_us;
	int reset_post_delay_us;
	struct gpio_desc *reset_gpiod;
	struct mutex shared_lock;
	struct phy_package_shared *shared[32];
};

struct mdio_driver_common {
	struct device_driver driver;
	int flags;
};

struct mii_timestamper {
	bool (*rxtstamp)(struct mii_timestamper *, struct sk_buff *, int);
	void (*txtstamp)(struct mii_timestamper *, struct sk_buff *, int);
	int (*hwtstamp)(struct mii_timestamper *, struct ifreq *);
	void (*link_state)(struct mii_timestamper *, struct phy_device *);
	int (*ts_info)(struct mii_timestamper *, struct ethtool_ts_info *);
	struct device *device;
};

struct phy_package_shared {
	int addr;
	refcount_t refcnt;
	long unsigned int flags;
	size_t priv_size;
	void *priv;
};

struct phy_driver {
	struct mdio_driver_common mdiodrv;
	u32 phy_id;
	char *name;
	u32 phy_id_mask;
	const long unsigned int * const features;
	u32 flags;
	const void *driver_data;
	int (*soft_reset)(struct phy_device *);
	int (*config_init)(struct phy_device *);
	int (*probe)(struct phy_device *);
	int (*get_features)(struct phy_device *);
	int (*get_rate_matching)(struct phy_device *, phy_interface_t);
	int (*suspend)(struct phy_device *);
	int (*resume)(struct phy_device *);
	int (*config_aneg)(struct phy_device *);
	int (*aneg_done)(struct phy_device *);
	int (*read_status)(struct phy_device *);
	int (*config_intr)(struct phy_device *);
	irqreturn_t (*handle_interrupt)(struct phy_device *);
	void (*remove)(struct phy_device *);
	int (*match_phy_device)(struct phy_device *);
	int (*set_wol)(struct phy_device *, struct ethtool_wolinfo *);
	void (*get_wol)(struct phy_device *, struct ethtool_wolinfo *);
	void (*link_change_notify)(struct phy_device *);
	int (*read_mmd)(struct phy_device *, int, u16);
	int (*write_mmd)(struct phy_device *, int, u16, u16);
	int (*read_page)(struct phy_device *);
	int (*write_page)(struct phy_device *, int);
	int (*module_info)(struct phy_device *, struct ethtool_modinfo *);
	int (*module_eeprom)(struct phy_device *, struct ethtool_eeprom *, u8 *);
	int (*cable_test_start)(struct phy_device *);
	int (*cable_test_tdr_start)(struct phy_device *, const struct phy_tdr_config *);
	int (*cable_test_get_status)(struct phy_device *, bool *);
	int (*get_sset_count)(struct phy_device *);
	void (*get_strings)(struct phy_device *, u8 *);
	void (*get_stats)(struct phy_device *, struct ethtool_stats *, u64 *);
	int (*get_tunable)(struct phy_device *, struct ethtool_tunable *, void *);
	int (*set_tunable)(struct phy_device *, struct ethtool_tunable *, const void *);
	int (*set_loopback)(struct phy_device *, bool);
	int (*get_sqi)(struct phy_device *);
	int (*get_sqi_max)(struct phy_device *);
	int (*get_plca_cfg)(struct phy_device *, struct phy_plca_cfg *);
	int (*set_plca_cfg)(struct phy_device *, const struct phy_plca_cfg *);
	int (*get_plca_status)(struct phy_device *, struct phy_plca_status *);
	int (*led_brightness_set)(struct phy_device *, u8, enum led_brightness);
	int (*led_blink_set)(struct phy_device *, u8, long unsigned int *, long unsigned int *);
	int (*led_hw_is_supported)(struct phy_device *, u8, long unsigned int);
	int (*led_hw_control_set)(struct phy_device *, u8, long unsigned int);
	int (*led_hw_control_get)(struct phy_device *, u8, long unsigned int *);
};

struct phy_setting {
	u32 speed;
	u8 duplex;
	u8 bit;
};

typedef __u16 __sum16;

enum {
	DUMP_PREFIX_NONE = 0,
	DUMP_PREFIX_ADDRESS = 1,
	DUMP_PREFIX_OFFSET = 2,
};

typedef void (*smp_call_func_t)(void *);

struct __call_single_data {
	struct __call_single_node node;
	smp_call_func_t func;
	void *info;
};

typedef struct __call_single_data call_single_data_t;

enum pci_ers_result {
	PCI_ERS_RESULT_NONE = 1,
	PCI_ERS_RESULT_CAN_RECOVER = 2,
	PCI_ERS_RESULT_NEED_RESET = 3,
	PCI_ERS_RESULT_DISCONNECT = 4,
	PCI_ERS_RESULT_RECOVERED = 5,
	PCI_ERS_RESULT_NO_AER_DRIVER = 6,
};

enum {
	NETIF_F_SG_BIT = 0,
	NETIF_F_IP_CSUM_BIT = 1,
	__UNUSED_NETIF_F_1 = 2,
	NETIF_F_HW_CSUM_BIT = 3,
	NETIF_F_IPV6_CSUM_BIT = 4,
	NETIF_F_HIGHDMA_BIT = 5,
	NETIF_F_FRAGLIST_BIT = 6,
	NETIF_F_HW_VLAN_CTAG_TX_BIT = 7,
	NETIF_F_HW_VLAN_CTAG_RX_BIT = 8,
	NETIF_F_HW_VLAN_CTAG_FILTER_BIT = 9,
	NETIF_F_VLAN_CHALLENGED_BIT = 10,
	NETIF_F_GSO_BIT = 11,
	NETIF_F_LLTX_BIT = 12,
	NETIF_F_NETNS_LOCAL_BIT = 13,
	NETIF_F_GRO_BIT = 14,
	NETIF_F_LRO_BIT = 15,
	NETIF_F_GSO_SHIFT = 16,
	NETIF_F_TSO_BIT = 16,
	NETIF_F_GSO_ROBUST_BIT = 17,
	NETIF_F_TSO_ECN_BIT = 18,
	NETIF_F_TSO_MANGLEID_BIT = 19,
	NETIF_F_TSO6_BIT = 20,
	NETIF_F_FSO_BIT = 21,
	NETIF_F_GSO_GRE_BIT = 22,
	NETIF_F_GSO_GRE_CSUM_BIT = 23,
	NETIF_F_GSO_IPXIP4_BIT = 24,
	NETIF_F_GSO_IPXIP6_BIT = 25,
	NETIF_F_GSO_UDP_TUNNEL_BIT = 26,
	NETIF_F_GSO_UDP_TUNNEL_CSUM_BIT = 27,
	NETIF_F_GSO_PARTIAL_BIT = 28,
	NETIF_F_GSO_TUNNEL_REMCSUM_BIT = 29,
	NETIF_F_GSO_SCTP_BIT = 30,
	NETIF_F_GSO_ESP_BIT = 31,
	NETIF_F_GSO_UDP_BIT = 32,
	NETIF_F_GSO_UDP_L4_BIT = 33,
	NETIF_F_GSO_FRAGLIST_BIT = 34,
	NETIF_F_GSO_LAST = 34,
	NETIF_F_FCOE_CRC_BIT = 35,
	NETIF_F_SCTP_CRC_BIT = 36,
	NETIF_F_FCOE_MTU_BIT = 37,
	NETIF_F_NTUPLE_BIT = 38,
	NETIF_F_RXHASH_BIT = 39,
	NETIF_F_RXCSUM_BIT = 40,
	NETIF_F_NOCACHE_COPY_BIT = 41,
	NETIF_F_LOOPBACK_BIT = 42,
	NETIF_F_RXFCS_BIT = 43,
	NETIF_F_RXALL_BIT = 44,
	NETIF_F_HW_VLAN_STAG_TX_BIT = 45,
	NETIF_F_HW_VLAN_STAG_RX_BIT = 46,
	NETIF_F_HW_VLAN_STAG_FILTER_BIT = 47,
	NETIF_F_HW_L2FW_DOFFLOAD_BIT = 48,
	NETIF_F_HW_TC_BIT = 49,
	NETIF_F_HW_ESP_BIT = 50,
	NETIF_F_HW_ESP_TX_CSUM_BIT = 51,
	NETIF_F_RX_UDP_TUNNEL_PORT_BIT = 52,
	NETIF_F_HW_TLS_TX_BIT = 53,
	NETIF_F_HW_TLS_RX_BIT = 54,
	NETIF_F_GRO_HW_BIT = 55,
	NETIF_F_HW_TLS_RECORD_BIT = 56,
	NETIF_F_GRO_FRAGLIST_BIT = 57,
	NETIF_F_HW_MACSEC_BIT = 58,
	NETIF_F_GRO_UDP_FWD_BIT = 59,
	NETIF_F_HW_HSR_TAG_INS_BIT = 60,
	NETIF_F_HW_HSR_TAG_RM_BIT = 61,
	NETIF_F_HW_HSR_FWD_BIT = 62,
	NETIF_F_HW_HSR_DUP_BIT = 63,
	NETDEV_FEATURE_COUNT = 64,
};

enum {
	SKBTX_HW_TSTAMP = 1,
	SKBTX_SW_TSTAMP = 2,
	SKBTX_IN_PROGRESS = 4,
	SKBTX_HW_TSTAMP_USE_CYCLES = 8,
	SKBTX_WIFI_STATUS = 16,
	SKBTX_HW_TSTAMP_NETDEV = 32,
	SKBTX_SCHED_TSTAMP = 64,
};

enum {
	SKB_GSO_TCPV4 = 1,
	SKB_GSO_DODGY = 2,
	SKB_GSO_TCP_ECN = 4,
	SKB_GSO_TCP_FIXEDID = 8,
	SKB_GSO_TCPV6 = 16,
	SKB_GSO_FCOE = 32,
	SKB_GSO_GRE = 64,
	SKB_GSO_GRE_CSUM = 128,
	SKB_GSO_IPXIP4 = 256,
	SKB_GSO_IPXIP6 = 512,
	SKB_GSO_UDP_TUNNEL = 1024,
	SKB_GSO_UDP_TUNNEL_CSUM = 2048,
	SKB_GSO_PARTIAL = 4096,
	SKB_GSO_TUNNEL_REMCSUM = 8192,
	SKB_GSO_SCTP = 16384,
	SKB_GSO_ESP = 32768,
	SKB_GSO_UDP = 65536,
	SKB_GSO_UDP_L4 = 131072,
	SKB_GSO_FRAGLIST = 262144,
};

struct netdev_hw_addr {
	struct list_head list;
	struct rb_node node;
	unsigned char addr[32];
	unsigned char type;
	bool global_use;
	int sync_cnt;
	int refcount;
	int synced;
	struct callback_head callback_head;
};

enum netdev_state_t {
	__LINK_STATE_START = 0,
	__LINK_STATE_PRESENT = 1,
	__LINK_STATE_NOCARRIER = 2,
	__LINK_STATE_LINKWATCH_PENDING = 3,
	__LINK_STATE_DORMANT = 4,
	__LINK_STATE_TESTING = 5,
};

struct gro_list {
	struct list_head list;
	int count;
};

struct napi_struct {
	struct list_head poll_list;
	long unsigned int state;
	int weight;
	int defer_hard_irqs_count;
	long unsigned int gro_bitmask;
	int (*poll)(struct napi_struct *, int);
	int poll_owner;
	int list_owner;
	struct net_device *dev;
	struct gro_list gro_hash[8];
	struct sk_buff *skb;
	struct list_head rx_list;
	int rx_count;
	unsigned int napi_id;
	struct hrtimer timer;
	struct task_struct *thread;
	struct list_head dev_list;
	struct hlist_node napi_hash_node;
};

enum gro_result {
	GRO_MERGED = 0,
	GRO_MERGED_FREE = 1,
	GRO_HELD = 2,
	GRO_NORMAL = 3,
	GRO_CONSUMED = 4,
};

typedef enum gro_result gro_result_t;

enum netdev_queue_state_t {
	__QUEUE_STATE_DRV_XOFF = 0,
	__QUEUE_STATE_STACK_XOFF = 1,
	__QUEUE_STATE_FROZEN = 2,
};

struct sd_flow_limit;

struct softnet_data {
	struct list_head poll_list;
	struct sk_buff_head process_queue;
	unsigned int processed;
	unsigned int time_squeeze;
	struct softnet_data *rps_ipi_list;
	bool in_net_rx_action;
	bool in_napi_threaded_poll;
	struct sd_flow_limit *flow_limit;
	struct Qdisc *output_queue;
	struct Qdisc **output_queue_tailp;
	struct sk_buff *completion_queue;
	struct {
		u16 recursion;
		u8 more;
		u8 skip_txqueue;
	} xmit;
	long: 64;
	long: 64;
	long: 64;
	unsigned int input_queue_head;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	call_single_data_t csd;
	struct softnet_data *rps_ipi_next;
	unsigned int cpu;
	unsigned int input_queue_tail;
	unsigned int received_rps;
	unsigned int dropped;
	struct sk_buff_head input_pkt_queue;
	struct napi_struct backlog;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	spinlock_t defer_lock;
	int defer_count;
	int defer_ipi_scheduled;
	struct sk_buff *defer_list;
	long: 64;
	call_single_data_t defer_csd;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct iphdr {
	__u8 ihl: 4;
	__u8 version: 4;
	__u8 tos;
	__be16 tot_len;
	__be16 id;
	__be16 frag_off;
	__u8 ttl;
	__u8 protocol;
	__sum16 check;
	union {
		struct {
			__be32 saddr;
			__be32 daddr;
		};
		struct {
			__be32 saddr;
			__be32 daddr;
		} addrs;
	};
};

struct ipv6hdr {
	__u8 priority: 4;
	__u8 version: 4;
	__u8 flow_lbl[3];
	__be16 payload_len;
	__u8 nexthdr;
	__u8 hop_limit;
	union {
		struct {
			struct in6_addr saddr;
			struct in6_addr daddr;
		};
		struct {
			struct in6_addr saddr;
			struct in6_addr daddr;
		} addrs;
	};
};

enum {
	TCA_UNSPEC = 0,
	TCA_KIND = 1,
	TCA_OPTIONS = 2,
	TCA_STATS = 3,
	TCA_XSTATS = 4,
	TCA_RATE = 5,
	TCA_FCNT = 6,
	TCA_STATS2 = 7,
	TCA_STAB = 8,
	TCA_PAD = 9,
	TCA_DUMP_INVISIBLE = 10,
	TCA_CHAIN = 11,
	TCA_HW_OFFLOAD = 12,
	TCA_INGRESS_BLOCK = 13,
	TCA_EGRESS_BLOCK = 14,
	TCA_DUMP_FLAGS = 15,
	TCA_EXT_WARN_MSG = 16,
	__TCA_MAX = 17,
};

struct tcphdr {
	__be16 source;
	__be16 dest;
	__be32 seq;
	__be32 ack_seq;
	__u16 res1: 4;
	__u16 doff: 4;
	__u16 fin: 1;
	__u16 syn: 1;
	__u16 rst: 1;
	__u16 psh: 1;
	__u16 ack: 1;
	__u16 urg: 1;
	__u16 ece: 1;
	__u16 cwr: 1;
	__be16 window;
	__sum16 check;
	__be16 urg_ptr;
};

struct vlan_hdr {
	__be16 h_vlan_TCI;
	__be16 h_vlan_encapsulated_proto;
};

struct qdisc_walker {
	int stop;
	int skip;
	int count;
	int (*fn)(struct Qdisc *, long unsigned int, struct qdisc_walker *);
};

struct mii_ioctl_data {
	__u16 phy_id;
	__u16 reg_num;
	__u16 val_in;
	__u16 val_out;
};

typedef enum {
	e1000_undefined = 0,
	e1000_82542_rev2_0 = 1,
	e1000_82542_rev2_1 = 2,
	e1000_82543 = 3,
	e1000_82544 = 4,
	e1000_82540 = 5,
	e1000_82545 = 6,
	e1000_82545_rev_3 = 7,
	e1000_82546 = 8,
	e1000_ce4100 = 9,
	e1000_82546_rev_3 = 10,
	e1000_82541 = 11,
	e1000_82541_rev_2 = 12,
	e1000_82547 = 13,
	e1000_82547_rev_2 = 14,
	e1000_num_macs = 15,
} e1000_mac_type;

typedef enum {
	e1000_eeprom_uninitialized = 0,
	e1000_eeprom_spi = 1,
	e1000_eeprom_microwire = 2,
	e1000_eeprom_flash = 3,
	e1000_eeprom_none = 4,
	e1000_num_eeprom_types = 5,
} e1000_eeprom_type;

typedef enum {
	e1000_media_type_copper = 0,
	e1000_media_type_fiber = 1,
	e1000_media_type_internal_serdes = 2,
	e1000_num_media_types = 3,
} e1000_media_type;

enum {
	e1000_10_half = 0,
	e1000_10_full = 1,
	e1000_100_half = 2,
	e1000_100_full = 3,
};

typedef enum {
	E1000_FC_NONE = 0,
	E1000_FC_RX_PAUSE = 1,
	E1000_FC_TX_PAUSE = 2,
	E1000_FC_FULL = 3,
	E1000_FC_DEFAULT = 255,
} e1000_fc_type;

struct e1000_shadow_ram {
	u16 eeprom_word;
	bool modified;
};

typedef enum {
	e1000_bus_type_unknown = 0,
	e1000_bus_type_pci = 1,
	e1000_bus_type_pcix = 2,
	e1000_bus_type_reserved = 3,
} e1000_bus_type;

typedef enum {
	e1000_bus_speed_unknown = 0,
	e1000_bus_speed_33 = 1,
	e1000_bus_speed_66 = 2,
	e1000_bus_speed_100 = 3,
	e1000_bus_speed_120 = 4,
	e1000_bus_speed_133 = 5,
	e1000_bus_speed_reserved = 6,
} e1000_bus_speed;

typedef enum {
	e1000_bus_width_unknown = 0,
	e1000_bus_width_32 = 1,
	e1000_bus_width_64 = 2,
	e1000_bus_width_reserved = 3,
} e1000_bus_width;

typedef enum {
	e1000_cable_length_50 = 0,
	e1000_cable_length_50_80 = 1,
	e1000_cable_length_80_110 = 2,
	e1000_cable_length_110_140 = 3,
	e1000_cable_length_140 = 4,
	e1000_cable_length_undefined = 255,
} e1000_cable_length;

typedef enum {
	e1000_10bt_ext_dist_enable_normal = 0,
	e1000_10bt_ext_dist_enable_lower = 1,
	e1000_10bt_ext_dist_enable_undefined = 255,
} e1000_10bt_ext_dist_enable;

typedef enum {
	e1000_rev_polarity_normal = 0,
	e1000_rev_polarity_reversed = 1,
	e1000_rev_polarity_undefined = 255,
} e1000_rev_polarity;

typedef enum {
	e1000_downshift_normal = 0,
	e1000_downshift_activated = 1,
	e1000_downshift_undefined = 255,
} e1000_downshift;

typedef enum {
	e1000_smart_speed_default = 0,
	e1000_smart_speed_on = 1,
	e1000_smart_speed_off = 2,
} e1000_smart_speed;

typedef enum {
	e1000_polarity_reversal_enabled = 0,
	e1000_polarity_reversal_disabled = 1,
	e1000_polarity_reversal_undefined = 255,
} e1000_polarity_reversal;

typedef enum {
	e1000_auto_x_mode_manual_mdi = 0,
	e1000_auto_x_mode_manual_mdix = 1,
	e1000_auto_x_mode_auto1 = 2,
	e1000_auto_x_mode_auto2 = 3,
	e1000_auto_x_mode_undefined = 255,
} e1000_auto_x_mode;

typedef enum {
	e1000_1000t_rx_status_not_ok = 0,
	e1000_1000t_rx_status_ok = 1,
	e1000_1000t_rx_status_undefined = 255,
} e1000_1000t_rx_status;

typedef enum {
	e1000_phy_m88 = 0,
	e1000_phy_igp = 1,
	e1000_phy_8211 = 2,
	e1000_phy_8201 = 3,
	e1000_phy_undefined = 255,
} e1000_phy_type;

typedef enum {
	e1000_ms_hw_default = 0,
	e1000_ms_force_master = 1,
	e1000_ms_force_slave = 2,
	e1000_ms_auto = 3,
} e1000_ms_type;

typedef enum {
	e1000_ffe_config_enabled = 0,
	e1000_ffe_config_active = 1,
	e1000_ffe_config_blocked = 2,
} e1000_ffe_config;

typedef enum {
	e1000_dsp_config_disabled = 0,
	e1000_dsp_config_enabled = 1,
	e1000_dsp_config_activated = 2,
	e1000_dsp_config_undefined = 255,
} e1000_dsp_config;

struct e1000_phy_info {
	e1000_cable_length cable_length;
	e1000_10bt_ext_dist_enable extended_10bt_distance;
	e1000_rev_polarity cable_polarity;
	e1000_downshift downshift;
	e1000_polarity_reversal polarity_correction;
	e1000_auto_x_mode mdix_mode;
	e1000_1000t_rx_status local_rx;
	e1000_1000t_rx_status remote_rx;
};

struct e1000_phy_stats {
	u32 idle_errors;
	u32 receive_errors;
};

struct e1000_eeprom_info {
	e1000_eeprom_type type;
	u16 word_size;
	u16 opcode_bits;
	u16 address_bits;
	u16 delay_usec;
	u16 page_size;
};

struct e1000_host_mng_dhcp_cookie {
	u32 signature;
	u8 status;
	u8 reserved0;
	u16 vlan_id;
	u32 reserved1;
	u16 reserved2;
	u8 reserved3;
	u8 checksum;
};

struct e1000_rx_desc {
	__le64 buffer_addr;
	__le16 length;
	__le16 csum;
	u8 status;
	u8 errors;
	__le16 special;
};

struct e1000_tx_desc {
	__le64 buffer_addr;
	union {
		__le32 data;
		struct {
			__le16 length;
			u8 cso;
			u8 cmd;
		} flags;
	} lower;
	union {
		__le32 data;
		struct {
			u8 status;
			u8 css;
			__le16 special;
		} fields;
	} upper;
};

struct e1000_context_desc {
	union {
		__le32 ip_config;
		struct {
			u8 ipcss;
			u8 ipcso;
			__le16 ipcse;
		} ip_fields;
	} lower_setup;
	union {
		__le32 tcp_config;
		struct {
			u8 tucss;
			u8 tucso;
			__le16 tucse;
		} tcp_fields;
	} upper_setup;
	__le32 cmd_and_length;
	union {
		__le32 data;
		struct {
			u8 status;
			u8 hdr_len;
			__le16 mss;
		} fields;
	} tcp_seg_setup;
};

struct e1000_hw_stats {
	u64 crcerrs;
	u64 algnerrc;
	u64 symerrs;
	u64 rxerrc;
	u64 txerrc;
	u64 mpc;
	u64 scc;
	u64 ecol;
	u64 mcc;
	u64 latecol;
	u64 colc;
	u64 dc;
	u64 tncrs;
	u64 sec;
	u64 cexterr;
	u64 rlec;
	u64 xonrxc;
	u64 xontxc;
	u64 xoffrxc;
	u64 xofftxc;
	u64 fcruc;
	u64 prc64;
	u64 prc127;
	u64 prc255;
	u64 prc511;
	u64 prc1023;
	u64 prc1522;
	u64 gprc;
	u64 bprc;
	u64 mprc;
	u64 gptc;
	u64 gorcl;
	u64 gorch;
	u64 gotcl;
	u64 gotch;
	u64 rnbc;
	u64 ruc;
	u64 rfc;
	u64 roc;
	u64 rlerrc;
	u64 rjc;
	u64 mgprc;
	u64 mgpdc;
	u64 mgptc;
	u64 torl;
	u64 torh;
	u64 totl;
	u64 toth;
	u64 tpr;
	u64 tpt;
	u64 ptc64;
	u64 ptc127;
	u64 ptc255;
	u64 ptc511;
	u64 ptc1023;
	u64 ptc1522;
	u64 mptc;
	u64 bptc;
	u64 tsctc;
	u64 tsctfc;
	u64 iac;
	u64 icrxptc;
	u64 icrxatc;
	u64 ictxptc;
	u64 ictxatc;
	u64 ictxqec;
	u64 ictxqmtc;
	u64 icrxdmtc;
	u64 icrxoc;
};

struct e1000_hw {
	u8 *hw_addr;
	u8 *flash_address;
	void *ce4100_gbe_mdio_base_virt;
	e1000_mac_type mac_type;
	e1000_phy_type phy_type;
	u32 phy_init_script;
	e1000_media_type media_type;
	void *back;
	struct e1000_shadow_ram *eeprom_shadow_ram;
	u32 flash_bank_size;
	u32 flash_base_addr;
	e1000_fc_type fc;
	e1000_bus_speed bus_speed;
	e1000_bus_width bus_width;
	e1000_bus_type bus_type;
	struct e1000_eeprom_info eeprom;
	e1000_ms_type master_slave;
	e1000_ms_type original_master_slave;
	e1000_ffe_config ffe_config_state;
	u32 asf_firmware_present;
	u32 eeprom_semaphore_present;
	long unsigned int io_base;
	u32 phy_id;
	u32 phy_revision;
	u32 phy_addr;
	u32 original_fc;
	u32 txcw;
	u32 autoneg_failed;
	u32 max_frame_size;
	u32 min_frame_size;
	u32 mc_filter_type;
	u32 num_mc_addrs;
	u32 collision_delta;
	u32 tx_packet_delta;
	u32 ledctl_default;
	u32 ledctl_mode1;
	u32 ledctl_mode2;
	bool tx_pkt_filtering;
	struct e1000_host_mng_dhcp_cookie mng_cookie;
	u16 phy_spd_default;
	u16 autoneg_advertised;
	u16 pci_cmd_word;
	u16 fc_high_water;
	u16 fc_low_water;
	u16 fc_pause_time;
	u16 current_ifs_val;
	u16 ifs_min_val;
	u16 ifs_max_val;
	u16 ifs_step_size;
	u16 ifs_ratio;
	u16 device_id;
	u16 vendor_id;
	u16 subsystem_id;
	u16 subsystem_vendor_id;
	u8 revision_id;
	u8 autoneg;
	u8 mdix;
	u8 forced_speed_duplex;
	u8 wait_autoneg_complete;
	u8 dma_fairness;
	u8 mac_addr[6];
	u8 perm_mac_addr[6];
	bool disable_polarity_correction;
	bool speed_downgraded;
	e1000_smart_speed smart_speed;
	e1000_dsp_config dsp_config_state;
	bool get_link_status;
	bool serdes_has_link;
	bool tbi_compatibility_en;
	bool tbi_compatibility_on;
	bool laa_is_present;
	bool phy_reset_disable;
	bool initialize_hw_bits_disable;
	bool fc_send_xon;
	bool fc_strict_ieee;
	bool report_tx_early;
	bool adaptive_ifs;
	bool ifs_params_forced;
	bool in_ifs_mode;
	bool mng_reg_access_disabled;
	bool leave_av_bit_off;
	bool bad_tx_carr_stats_fd;
	bool has_smbus;
};

struct e1000_tx_buffer {
	struct sk_buff *skb;
	dma_addr_t dma;
	long unsigned int time_stamp;
	u16 length;
	u16 next_to_watch;
	bool mapped_as_page;
	short unsigned int segs;
	unsigned int bytecount;
};

struct e1000_rx_buffer {
	union {
		struct page *page;
		u8 *data;
	} rxbuf;
	dma_addr_t dma;
};

struct e1000_tx_ring {
	void *desc;
	dma_addr_t dma;
	unsigned int size;
	unsigned int count;
	unsigned int next_to_use;
	unsigned int next_to_clean;
	struct e1000_tx_buffer *buffer_info;
	u16 tdh;
	u16 tdt;
	bool last_tx_tso;
};

struct e1000_rx_ring {
	void *desc;
	dma_addr_t dma;
	unsigned int size;
	unsigned int count;
	unsigned int next_to_use;
	unsigned int next_to_clean;
	struct e1000_rx_buffer *buffer_info;
	struct sk_buff *rx_skb_top;
	int cpu;
	u16 rdh;
	u16 rdt;
};

struct e1000_adapter {
	long unsigned int active_vlans[64];
	u16 mng_vlan_id;
	u32 bd_number;
	u32 rx_buffer_len;
	u32 wol;
	u32 smartspeed;
	u32 en_mng_pt;
	u16 link_speed;
	u16 link_duplex;
	spinlock_t stats_lock;
	unsigned int total_tx_bytes;
	unsigned int total_tx_packets;
	unsigned int total_rx_bytes;
	unsigned int total_rx_packets;
	u32 itr;
	u32 itr_setting;
	u16 tx_itr;
	u16 rx_itr;
	u8 fc_autoneg;
	struct e1000_tx_ring *tx_ring;
	unsigned int restart_queue;
	u32 txd_cmd;
	u32 tx_int_delay;
	u32 tx_abs_int_delay;
	u32 gotcl;
	u64 gotcl_old;
	u64 tpt_old;
	u64 colc_old;
	u32 tx_timeout_count;
	u32 tx_fifo_head;
	u32 tx_head_addr;
	u32 tx_fifo_size;
	u8 tx_timeout_factor;
	atomic_t tx_fifo_stall;
	bool pcix_82544;
	bool detect_tx_hung;
	bool dump_buffers;
	bool (*clean_rx)(struct e1000_adapter *, struct e1000_rx_ring *, int *, int);
	void (*alloc_rx_buf)(struct e1000_adapter *, struct e1000_rx_ring *, int);
	struct e1000_rx_ring *rx_ring;
	struct napi_struct napi;
	int num_tx_queues;
	int num_rx_queues;
	u64 hw_csum_err;
	u64 hw_csum_good;
	u32 alloc_rx_buff_failed;
	u32 rx_int_delay;
	u32 rx_abs_int_delay;
	bool rx_csum;
	u32 gorcl;
	u64 gorcl_old;
	struct net_device *netdev;
	struct pci_dev *pdev;
	struct e1000_hw hw;
	struct e1000_hw_stats stats;
	struct e1000_phy_info phy_info;
	struct e1000_phy_stats phy_stats;
	u32 test_icr;
	struct e1000_tx_ring test_tx_ring;
	struct e1000_rx_ring test_rx_ring;
	int msg_enable;
	bool tso_force;
	bool smart_power_down;
	bool quad_port_a;
	long unsigned int flags;
	u32 eeprom_wol;
	int bars;
	int need_ioport;
	bool discarding;
	struct work_struct reset_task;
	struct delayed_work watchdog_task;
	struct delayed_work fifo_stall_task;
	struct delayed_work phy_info_task;
};

enum e1000_state_t {
	__E1000_TESTING = 0,
	__E1000_RESETTING = 1,
	__E1000_DOWN = 2,
	__E1000_DISABLED = 3,
};

enum latency_range {
	lowest_latency = 0,
	low_latency = 1,
	bulk_latency = 2,
	latency_invalid = 255,
};

struct my_u {
	__le64 a;
	__le64 b;
};

struct system_device_crosststamp {
	ktime_t device;
	ktime_t sys_realtime;
	ktime_t sys_monoraw;
};

struct msix_entry {
	u32 vector;
	u16 entry;
};

struct cyclecounter {
	u64 (*read)(const struct cyclecounter *);
	u64 mask;
	u32 mult;
	u32 shift;
};

struct timecounter {
	const struct cyclecounter *cc;
	u64 cycle_last;
	u64 nsec;
	u64 mask;
	u64 frac;
};

struct hwtstamp_config {
	int flags;
	int tx_type;
	int rx_filter;
};

struct ptp_clock_time {
	__s64 sec;
	__u32 nsec;
	__u32 reserved;
};

struct ptp_extts_request {
	unsigned int index;
	unsigned int flags;
	unsigned int rsv[2];
};

struct ptp_perout_request {
	union {
		struct ptp_clock_time start;
		struct ptp_clock_time phase;
	};
	struct ptp_clock_time period;
	unsigned int index;
	unsigned int flags;
	union {
		struct ptp_clock_time on;
		unsigned int rsv[4];
	};
};

enum ptp_pin_function {
	PTP_PF_NONE = 0,
	PTP_PF_EXTTS = 1,
	PTP_PF_PEROUT = 2,
	PTP_PF_PHYSYNC = 3,
};

struct ptp_pin_desc {
	char name[64];
	unsigned int index;
	unsigned int func;
	unsigned int chan;
	unsigned int rsv[5];
};

struct ptp_clock_request {
	enum {
		PTP_CLK_REQ_EXTTS = 0,
		PTP_CLK_REQ_PEROUT = 1,
		PTP_CLK_REQ_PPS = 2,
	} type;
	union {
		struct ptp_extts_request extts;
		struct ptp_perout_request perout;
	};
};

struct ptp_system_timestamp {
	struct timespec64 pre_ts;
	struct timespec64 post_ts;
};

struct ptp_clock_info {
	struct module *owner;
	char name[32];
	s32 max_adj;
	int n_alarm;
	int n_ext_ts;
	int n_per_out;
	int n_pins;
	int pps;
	struct ptp_pin_desc *pin_config;
	int (*adjfine)(struct ptp_clock_info *, long int);
	int (*adjphase)(struct ptp_clock_info *, s32);
	s32 (*getmaxphase)(struct ptp_clock_info *);
	int (*adjtime)(struct ptp_clock_info *, s64);
	int (*gettime64)(struct ptp_clock_info *, struct timespec64 *);
	int (*gettimex64)(struct ptp_clock_info *, struct timespec64 *, struct ptp_system_timestamp *);
	int (*getcrosststamp)(struct ptp_clock_info *, struct system_device_crosststamp *);
	int (*settime64)(struct ptp_clock_info *, const struct timespec64 *);
	int (*getcycles64)(struct ptp_clock_info *, struct timespec64 *);
	int (*getcyclesx64)(struct ptp_clock_info *, struct timespec64 *, struct ptp_system_timestamp *);
	int (*getcrosscycles)(struct ptp_clock_info *, struct system_device_crosststamp *);
	int (*enable)(struct ptp_clock_info *, struct ptp_clock_request *, int);
	int (*verify)(struct ptp_clock_info *, unsigned int, enum ptp_pin_function, unsigned int);
	long int (*do_aux_work)(struct ptp_clock_info *);
};

enum e1000_mac_type {
	e1000_82571 = 0,
	e1000_82572 = 1,
	e1000_82573 = 2,
	e1000_82574 = 3,
	e1000_82583 = 4,
	e1000_80003es2lan = 5,
	e1000_ich8lan = 6,
	e1000_ich9lan = 7,
	e1000_ich10lan = 8,
	e1000_pchlan = 9,
	e1000_pch2lan = 10,
	e1000_pch_lpt = 11,
	e1000_pch_spt = 12,
	e1000_pch_cnp = 13,
	e1000_pch_tgp = 14,
	e1000_pch_adp = 15,
	e1000_pch_mtp = 16,
	e1000_pch_lnp = 17,
	e1000_pch_ptp = 18,
	e1000_pch_nvp = 19,
};

enum e1000_media_type {
	e1000_media_type_unknown = 0,
	e1000_media_type_copper___2 = 1,
	e1000_media_type_fiber___2 = 2,
	e1000_media_type_internal_serdes___2 = 3,
	e1000_num_media_types___2 = 4,
};

enum e1000_nvm_type {
	e1000_nvm_unknown = 0,
	e1000_nvm_none = 1,
	e1000_nvm_eeprom_spi = 2,
	e1000_nvm_flash_hw = 3,
	e1000_nvm_flash_sw = 4,
};

enum e1000_nvm_override {
	e1000_nvm_override_none = 0,
	e1000_nvm_override_spi_small = 1,
	e1000_nvm_override_spi_large = 2,
};

enum e1000_phy_type {
	e1000_phy_unknown = 0,
	e1000_phy_none = 1,
	e1000_phy_m88___2 = 2,
	e1000_phy_igp___2 = 3,
	e1000_phy_igp_2 = 4,
	e1000_phy_gg82563 = 5,
	e1000_phy_igp_3 = 6,
	e1000_phy_ife = 7,
	e1000_phy_bm = 8,
	e1000_phy_82578 = 9,
	e1000_phy_82577 = 10,
	e1000_phy_82579 = 11,
	e1000_phy_i217 = 12,
};

enum e1000_bus_width {
	e1000_bus_width_unknown___2 = 0,
	e1000_bus_width_pcie_x1 = 1,
	e1000_bus_width_pcie_x2 = 2,
	e1000_bus_width_pcie_x4 = 4,
	e1000_bus_width_pcie_x8 = 8,
	e1000_bus_width_32___2 = 9,
	e1000_bus_width_64___2 = 10,
	e1000_bus_width_reserved___2 = 11,
};

enum e1000_1000t_rx_status {
	e1000_1000t_rx_status_not_ok___2 = 0,
	e1000_1000t_rx_status_ok___2 = 1,
	e1000_1000t_rx_status_undefined___2 = 255,
};

enum e1000_rev_polarity {
	e1000_rev_polarity_normal___2 = 0,
	e1000_rev_polarity_reversed___2 = 1,
	e1000_rev_polarity_undefined___2 = 255,
};

enum e1000_fc_mode {
	e1000_fc_none = 0,
	e1000_fc_rx_pause = 1,
	e1000_fc_tx_pause = 2,
	e1000_fc_full = 3,
	e1000_fc_default = 255,
};
