// Copyright (c) .NET Foundation. All rights reserved.
// Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.

#nullable enable

using System;
using System.Text.Json.Serialization;

namespace NuGet.Protocol.Model
{
    /// <summary>Represents one page of vulnerability data.</summary>
    /// <remarks>More details at <a href="https://learn.microsoft.com/nuget/api/vulnerability-info-resource">https://learn.microsoft.com/nuget/api/vulnerability-info-resource</a></remarks>
    public sealed class V3VulnerabilityIndexEntry
    {
        /// <summary>A short name </summary>
        /// <remarks>The name must be unique within the vulnerability index. See the server API docs for more information.</remarks>
        [JsonPropertyName("@name")]
        public string Name { get; }

        /// <summary>The URL for the vulnerability data.</summary>
        [JsonPropertyName("@id")]
        public Uri Url { get; }

        /// <summary>A string that can be used to determine if a previously cached value is no longer up-to-date.</summary>
        [JsonPropertyName("@updated")]
        public string Updated { get; }

        /// <summary>Free text that the server administrator can add to the JSON object.</summary>
        [JsonPropertyName("comment")]
        public string? Comment { get; }

        public V3VulnerabilityIndexEntry(string name, Uri url, string updated, string? comment)
        {
            Name = name ?? throw new ArgumentNullException(nameof(name));
            Url = url ?? throw new ArgumentNullException(nameof(url));
            Updated = updated ?? throw new ArgumentNullException(nameof(updated));
            Comment = comment;
        }
    }
}
