package sql

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
)

// EmailAccountAdmins enumerates the values for email account admins.
type EmailAccountAdmins string

const (
	// Disabled specifies the disabled state for email account admins.
	Disabled EmailAccountAdmins = "Disabled"
	// Enabled specifies the enabled state for email account admins.
	Enabled EmailAccountAdmins = "Enabled"
)

// State enumerates the values for state.
type State string

const (
	// StateDisabled specifies the state disabled state for state.
	StateDisabled State = "Disabled"
	// StateEnabled specifies the state enabled state for state.
	StateEnabled State = "Enabled"
	// StateNew specifies the state new state for state.
	StateNew State = "New"
)

// Resource is
type Resource struct {
	ID       *string             `json:"id,omitempty"`
	Name     *string             `json:"name,omitempty"`
	Type     *string             `json:"type,omitempty"`
	Location *string             `json:"location,omitempty"`
	Tags     *map[string]*string `json:"tags,omitempty"`
}

// ServerSecurityAlertPolicy is represents an Azure SQL Server Security Alert
// Policy.
type ServerSecurityAlertPolicy struct {
	autorest.Response `json:"-"`
	ID                *string                              `json:"id,omitempty"`
	Name              *string                              `json:"name,omitempty"`
	Type              *string                              `json:"type,omitempty"`
	Location          *string                              `json:"location,omitempty"`
	Tags              *map[string]*string                  `json:"tags,omitempty"`
	Properties        *ServerSecurityAlertPolicyProperties `json:"properties,omitempty"`
}

// ServerSecurityAlertPolicyCreateOrUpdateParameters is create or update
// server security alert policy parameters.
type ServerSecurityAlertPolicyCreateOrUpdateParameters struct {
	Properties *ServerSecurityAlertPolicyProperties `json:"properties,omitempty"`
}

// ServerSecurityAlertPolicyProperties is represents the properties of an
// Azure SQL Security alert policy.
type ServerSecurityAlertPolicyProperties struct {
	State              State              `json:"state,omitempty"`
	DisabledAlerts     *string            `json:"disabledAlerts,omitempty"`
	EmailAddresses     *string            `json:"emailAddresses,omitempty"`
	EmailAccountAdmins EmailAccountAdmins `json:"emailAccountAdmins,omitempty"`
}
