; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instsimplify -S | FileCheck %s

define i32 @test1(i32 %A) {
; CHECK-LABEL: @test1(
; CHECK-NEXT:    ret i32 [[A:%.*]]
;
  %B = or i32 %A, 0
  ret i32 %B
}

define i32 @all_ones(i32 %A) {
; CHECK-LABEL: @all_ones(
; CHECK-NEXT:    ret i32 -1
;
  %B = or i32 %A, -1
  ret i32 %B
}

define <3 x i8> @all_ones_vec_with_undef_elt(<3 x i8> %A) {
; CHECK-LABEL: @all_ones_vec_with_undef_elt(
; CHECK-NEXT:    ret <3 x i8> <i8 -1, i8 -1, i8 -1>
;
  %B = or <3 x i8> %A, <i8 -1, i8 undef, i8 -1>
  ret <3 x i8> %B
}

define i1 @test3(i1 %A) {
; CHECK-LABEL: @test3(
; CHECK-NEXT:    ret i1 [[A:%.*]]
;
  %B = or i1 %A, false
  ret i1 %B
}

define i1 @test4(i1 %A) {
; CHECK-LABEL: @test4(
; CHECK-NEXT:    ret i1 true
;
  %B = or i1 %A, true
  ret i1 %B
}

define i1 @test5(i1 %A) {
; CHECK-LABEL: @test5(
; CHECK-NEXT:    ret i1 [[A:%.*]]
;
  %B = or i1 %A, %A
  ret i1 %B
}

define i32 @test6(i32 %A) {
; CHECK-LABEL: @test6(
; CHECK-NEXT:    ret i32 [[A:%.*]]
;
  %B = or i32 %A, %A
  ret i32 %B
}

; A | ~A == -1

define i32 @or_not(i32 %A) {
; CHECK-LABEL: @or_not(
; CHECK-NEXT:    ret i32 -1
;
  %NotA = xor i32 %A, -1
  %B = or i32 %A, %NotA
  ret i32 %B
}

define <2 x i4> @or_not_commute_vec_undef(<2 x i4> %A) {
; CHECK-LABEL: @or_not_commute_vec_undef(
; CHECK-NEXT:    ret <2 x i4> <i4 -1, i4 -1>
;
  %NotA = xor <2 x i4> %A, <i4 -1, i4 undef>
  %B = or <2 x i4> %NotA, %A
  ret <2 x i4> %B
}

define i8 @test8(i8 %A) {
; CHECK-LABEL: @test8(
; CHECK-NEXT:    ret i8 -1
;
  %B = or i8 %A, -2
  %C = or i8 %B, 1
  ret i8 %C
}

; Test that (A|c1)|(B|c2) == (A|B)|(c1|c2)
define i8 @test9(i8 %A, i8 %B) {
; CHECK-LABEL: @test9(
; CHECK-NEXT:    ret i8 -1
;
  %C = or i8 %A, 1
  %D = or i8 %B, -2
  %E = or i8 %C, %D
  ret i8 %E
}

; (X & C1) | C2 --> (X | C2) & (C1|C2)
define i8 @test10(i8 %A) {
; CHECK-LABEL: @test10(
; CHECK-NEXT:    ret i8 -2
;
  %B = or i8 %A, 1
  %C = and i8 %B, -2
  %D = or i8 %C, -2
  ret i8 %D
}

; The following two cases only get folded by InstCombine,
; see InstCombine/or-xor.ll.

; (X ^ C1) | C2 --> (X | C2) ^ (C1&~C2)
define i8 @test11(i8 %A) {
; CHECK-LABEL: @test11(
; CHECK-NEXT:    [[B:%.*]] = or i8 [[A:%.*]], -2
; CHECK-NEXT:    [[C:%.*]] = xor i8 [[B]], 13
; CHECK-NEXT:    [[D:%.*]] = or i8 [[C]], 1
; CHECK-NEXT:    [[E:%.*]] = xor i8 [[D]], 12
; CHECK-NEXT:    ret i8 [[E]]
;
  %B = or i8 %A, -2
  %C = xor i8 %B, 13
  %D = or i8 %C, 1
  %E = xor i8 %D, 12
  ret i8 %E
}

define i8 @test11v(<2 x i8> %A) {
; CHECK-LABEL: @test11v(
; CHECK-NEXT:    [[B:%.*]] = or <2 x i8> [[A:%.*]], <i8 -2, i8 0>
; CHECK-NEXT:    [[CV:%.*]] = xor <2 x i8> [[B]], <i8 13, i8 13>
; CHECK-NEXT:    [[C:%.*]] = extractelement <2 x i8> [[CV]], i32 0
; CHECK-NEXT:    [[D:%.*]] = or i8 [[C]], 1
; CHECK-NEXT:    [[E:%.*]] = xor i8 [[D]], 12
; CHECK-NEXT:    ret i8 [[E]]
;
  %B = or <2 x i8> %A, <i8 -2, i8 0>
  %CV = xor <2 x i8> %B, <i8 13, i8 13>
  %C = extractelement <2 x i8> %CV, i32 0
  %D = or i8 %C, 1
  %E = xor i8 %D, 12
  ret i8 %E
}

; Test the case where integer BitWidth <= 64 && BitWidth % 2 != 0.
; If we have: ((V + N) & C1) | (V & C2)
; .. and C2 = ~C1 and C2 is 0+1+ and (N & C2) == 0
; replace with V+N.
define i39 @test1_apint(i39 %V, i39 %M) {
; CHECK-LABEL: @test1_apint(
; CHECK-NEXT:    [[N:%.*]] = and i39 [[M:%.*]], -274877906944
; CHECK-NEXT:    [[A:%.*]] = add i39 [[V:%.*]], [[N]]
; CHECK-NEXT:    ret i39 [[A]]
;
  %C1 = xor i39 274877906943, -1 ;; C2 = 274877906943
  %N = and i39 %M, 274877906944
  %A = add i39 %V, %N
  %B = and i39 %A, %C1
  %D = and i39 %V, 274877906943
  %R = or i39 %B, %D
  ret i39 %R
}

define i7 @test2_apint(i7 %X) {
; CHECK-LABEL: @test2_apint(
; CHECK-NEXT:    ret i7 [[X:%.*]]
;
  %Y = or i7 %X, 0
  ret i7 %Y
}

define i17 @test3_apint(i17 %X) {
; CHECK-LABEL: @test3_apint(
; CHECK-NEXT:    ret i17 -1
;
  %Y = or i17 %X, -1
  ret i17 %Y
}

; Test the case where Integer BitWidth > 64 && BitWidth <= 1024.
; If we have: ((V + N) & C1) | (V & C2)
; .. and C2 = ~C1 and C2 is 0+1+ and (N & C2) == 0
; replace wi