/* Sitronix st2205 picframe decompression and compression lookup tables
 *
 * The st2205 picframe decompression and compression uses 2 fixed
 * lookup tables. These tables are copied from the st2205 firmware.
 *
 * As these are pure lists of fixed numbers, these are believed to not be
 * creative expressions, and as such are believed to not be under copyright.
 */

#include "config.h"

#include "st2205.h"

const st2205_lookup_row st2205_lookup[3][256] = {
	{
		{ -48, -51, -53, -53, -53, -52, -52, -49 },
		{ -57, -57, -55, -50, -35, 2, 27, 29 },
		{ -47, -47, -44, -21, 28, 47, 49, 49 },
		{ -72, -55, 8, 24, 26, 27, 26, 24 },
		{ 76, 76, 76, 76, 75, 72, 70, 67 },
		{ 59, 58, 46, -2, -35, -43, -43, -43 },
		{ -66, -67, -54, 22, 39, 41, 41, 40 },
		{ -20, -19, -14, -1, 28, 56, 65, 66 },
		{ 35, 35, 34, 22, -19, -35, -36, -33 },
		{ 25, 28, 26, 5, -42, -63, -68, -69 },
		{ 64, 65, 59, 34, -5, -22, -27, -29 },
		{ -36, -36, -36, -34, -16, 39, 64, 66 },
		{ 72, 62, -5, -25, -28, -27, -27, -27 },
		{ -34, -37, -38, -39, -39, -38, -39, -38 },
		{ 46, 49, 50, 50, 51, 51, 50, 49 },
		{ 46, 47, 46, 39, -5, -49, -58, -58 },
		{ -56, -29, 38, 37, 22, 9, 1, -2 },
		{ -53, -55, -50, -30, 9, 22, 25, 26 },
		{ -45, -43, -34, 13, 26, 28, 30, 30 },
		{ 36, 38, 37, 34, 17, -26, -43, -43 },
		{ 66, 61, 35, -2, -14, -15, -17, -16 },
		{ -24, -25, -26, -24, -20, 4, 62, 75 },
		{ 33, 35, 36, 36, 36, 36, 37, 37 },
		{ 11, -2, -22, -39, -47, -52, -52, -48 },
		{ 27, -8, -32, -35, -28, 16, 39, 41 },
		{ -22, -21, -21, -21, -9, 29, 45, 48 },
		{ 50, 53, 53, 51, 41, 12, -20, -31 },
		{ 35, 35, 30, 2, -38, -36, -12, 3 },
		{ -9, 2, 26, 46, 55, 58, 60, 59 },
		{ -30, -32, -31, -30, -28, -28, -27, -26 },
		{ 60, 46, -9, -20, -17, -13, -10, -8 },
		{ 21, 23, 23, 23, 20, 1, -54, -71 },
		{ 27, 28, 28, 28, 28, 27, 27, 25 },
		{ -4, 20, 36, 13, -8, -13, -12, -9 },
		{ 46, 49, 44, 31, 7, -5, -7, -6 },
		{ 26, 25, 28, 18, -18, -24, -23, -22 },
		{ -5, -33, -39, 5, 15, 15, 17, 18 },
		{ -29, -31, -30, -21, 15, 32, 36, 37 },
		{ 1, -3, 0, 13, 28, 36, -20, -45 },
		{ -12, -14, -19, -24, -29, -34, -36, -34 },
		{ -16, 13, 16, -14, -12, 13, 10, -14 },
		{ -34, -28, 7, 33, 34, 25, -1, -23 },
		{ 73, 8, -9, -10, -10, -11, -12, -12 },
		{ 16, 17, 18, 17, 14, -4, -37, -46 },
		{ 29, 8, -8, -3, 22, 38, 41, 37 },
		{ -46, -48, -48, -46, -41, -30, -14, 0 },
		{ 25, 28, 29, 28, 27, 18, -22, -51 },
		{ 44, 41, 23, -20, -34, -36, -38, -37 },
		{ -25, -27, -29, -29, -28, -17, 24, 52 },
		{ -44, -41, -34, -25, -15, -8, -3, 0 },
		{ 39, 36, 20, -12, -23, -22, -21, -20 },
		{ 20, 20, 20, 20, 6, -29, -32, -24 },
		{ -10, 12, 30, 35, 34, 35, 36, 34 },
		{ -32, -34, -36, -33, -17, 12, 26, 29 },
		{ 9, 12, 15, 14, 12, 9, -18, -67 },
		{ -28, -27, -25, -24, -23, -20, -15, -10 },
		{ -44, -27, 14, 34, 37, 37, 39, 38 },
		{ -42, -32, -9, 9, 17, 23, 27, 27 },
		{ 24, -12, -16, 24, 17, -18, -9, 25 },
		{ 20, 22, 22, 20, 5, -43, -68, -71 },
		{ -14, -14, -15, -16, -16, -2, 39, 51 },
		{ 40, 21, -15, -26, -27, -17, 9, 28 },
		{ 47, 51, 51, 48, 45, 41, 26, 3 },
		{ -26, -29, -18, 14, 37, 40, 24, -6 },
		{ -20, -20, -19, -15, 4, 24, 30, 32 },
		{ 4, -7, -24, -37, -41, -30, -6, 10 },
		{ 47, 25, -5, -13, -14, -15, -18, -19 },
		{ 18, 16, 11, -6, -32, -43, -45, -42 },
		{ 1, 4, 11, 20, 29, 35, 40, 39 },
		{ -23, -23, -20, 2, 22, 25, 23, 21 },
		{ -13, 7, 32, 33, 8, -20, -27, -26 },
		{ -19, -20, -20, -21, -20, -21, -22, -22 },
		{ -59, -31, 6, 13, 14, 14, 14, 12 },
		{ 1, -24, -39, -33, -9, 6, 11, 10 },
		{ 31, 33, 32, 29, 18, -8, -23, -24 },
		{ 22, 18, 12, 4, -8, -25, -36, -42 },
		{ 9, 9, 7, 1, -15, -24, -3, 28 },
		{ -35, -34, -27, -11, 5, 13, 16, 17 },
		{ 33, 8, -24, -6, 29, 0, -22, -12 },
		{ 43, 22, -17, -31, -33, -32, -33, -32 },
		{ -25, -24, -15, 12, 35, 42, 43, 42 },
		{ -38, -29, -13, 3, 2, -11, -27, -33 },
		{ 32, 32, 32, 31, 29, 22, 8, -10 },
		{ 13, 13, 14, 15, 12, -9, -25, -25 },
		{ -33, -12, 15, 24, 24, 23, 24, 21 },
		{ -24, -27, -30, -32, -30, -18, 0, 15 },
		{ 26, 23, 15, -3, -13, -16, -16, -16 },
		{ -26, -24, -20, -16, -11, -5, -5, -8 },
		{ -10, -10, -11, -12, -10, -6, 12, 59 },
		{ -55, -51, -24, 5, 14, 15, 14, 12 },
		{ -6, 18, 38, 45, 42, 25, -2, -14 },
		{ 47, 5, -6, -7, -7, -8, -8, -7 },
		{ -10, -8, -6, -4, 3, 22, 50, 61 },
		{ -26, -25, -23, -21, -14, 0, 11, 16 },
		{ 30, 31, 20, -4, -16, -2, 19, 25 },
		{ 15, 10, 0, -16, -27, -30, -29, -26 },
		{ -17, -18, -18, -15, 9, 33, 21, 4 },
		{ 21, 19, 6, -25, -35, -22, -2, 7 },
		{ 11, 10, 11, 12, 6, -17, -26, 1 },
		{ 1, -1, -2, -1, 14, 13, -8, -7 },
		{ 19, 21, 21, 21, 22, 22, 22, 21 },
		{ -14, -15, -15, -16, -15, -15, -15, -14 },
		{ 20, 20, 20, 20, 19, 12, -9, -30 },
		{ 37, 26, -1, -10, -10, -7, -6, -3 },
		{ -15, -15, -17, -21, -17, 13, 32, 30 },
		{ -33, -23, -3, 8, 14, 16, 18, 19 },
		{ 2, 30, 0, -16, 18, 30, -12, -4 },
		{ 2, 1, -1, -2, -8, -31, -50, -55 },
		{ -50, -4, 9, 9, 9, 10, 9, 8 },
		{ 8, 7, 1, -12, -21, -10, 26, 41 },
		{ 46, 41, 22, 1, -7, -8, -9, -10 },
		{ 7, 6, 5, 5, 3, -3, -27, -46 },
		{ -16, 10, 21, 22, 21, 21, 20, 17 },
		{ -44, -32, -12, -1, 1, 2, 3, 4 },
		{ 30, 26, 19, 11, 0, -12, -23, -30 },
		{ -4, -4, -2, -2, -3, -3, 3, 33 },
		{ 0, -12, -22, -18, 3, 16, 17, 16 },
		{ 9, 9, 8, 3, -11, -23, -25, -24 },
		{ 31, 30, 27, 21, 15, 11, 10, 13 },
		{ -19, -17, -13, -7, 0, 12, 20, 25 },
		{ -17, 2, 17, 19, 18, 12, -16, -37 },
		{ 7, -10, -21, -23, -18, -9, -3, -2 },
		{ 14, 7, -10, -23, -10, 17, 25, 24 },
		{ -6, -9, 5, 29, 30, 1, -12, -12 },
		{ -13, -11, -2, 10, 21, 28, 30, 29 },
		{ 16, -18, -24, -6, 4, 3, 1, -1 },
		{ 16, 16, 16, 11, -3, -14, -16, -15 },
		{ 11, -12, -26, -28, -27, -26, -26, -24 },
		{ -31, -19, 3, 15, 17, 12, 1, -10 },
		{ -14, -15, -14, -16, -16, -15, 2, 32 },
		{ 28, 27, 25, 20, 11, 1, -6, -10 },
		{ 35, 4, -18, -19, -17, -16, -15, -13 },
		{ -23, -17, 24, 20, -19, -13, 27, 17 },
		{ -19, -26, -27, -8, 23, 18, -8, -17 },
		{ 4, 8, 13, 16, 19, 22, 23, 23 },
		{ 15, 14, 12, 2, -17, -25, -13, 6 },
		{ 7, 7, 8, 8, 8, 4, -16, -27 },
		{ -12, -8, 3, 8, 3, -10, -21, -25 },
		{ -27, -17, -1, 5, 7, 9, 10, 10 },
		{ -10, -10, -10, -10, -10, -11, -11, -12 },
		{ 53, 27, 1, -1, 11, 25, 14, 10 },
		{ -13, -13, -11, -5, 4, 10, 12, 13 },
		{ 6, 7, 15, 25, 30, 32, 22, -2 },
		{ 22, 19, 6, -4, -6, -7, -8, -10 },
		{ -10, -9, -9, -9, -8, -1, 21, 32 },
		{ -22, -22, -18, -9, -1, 3, 5, 7 },
		{ -2, 1, 10, 17, 2, -6, -9, -8 },
		{ 10, 11, 11, 10, 9, 9, -2, -46 },
		{ -11, -10, -9, 1, 18, 19, 8, -2 },
		{ -3, -4, -6, -8, -13, -20, -27, -29 },
		{ 16, 16, 16, 16, 16, 16, 15, 15 },
		{ 5, -21, 7, 15, -6, -11, 7, 14 },
		{ -23, 6, 27, 21, 4, -11, 0, 11 },
		{ 8, 8, 7, 6, 3, -4, -12, -15 },
		{ 28, 4, -3, -4, -3, -4, -4, -3 },
		{ 3, -3, -10, -17, -19, -19, -18, -16 },
		{ -16, -6, 7, 15, 17, 17, 16, 14 },
		{ -20, -24, -14, 6, 12, 13, 13, 12 },
		{ 26, 25, 18, 4, -6, -7, -3, 0 },
		{ 17, 13, -1, -13, -15, -15, -14, -14 },
		{ -5, -5, -6, -8, -4, 10, 19, 19 },
		{ -19, 4, 13, -7, -24, -22, -14, -11 },
		{ 14, 17, 19, 20, 19, 15, 6, -4 },
		{ 8, -6, -15, -20, -21, -8, 14, 23 },
		{ 23, 10, -17, -30, -14, 2, 8, 10 },
		{ 18, 13, 7, 2, -2, -7, -16, -25 },
		{ 10, 11, 11, 12, 12, 13, 12, 12 },
		{ -16, -17, -17, -18, -18, -16, -8, 6 },
		{ 14, 7, -12, -20, -4, 11, 1, -15 },
		{ -14, -10, -2, 3, 6, 7, 8, 8 },
		{ -27, -1, 7, 7, 7, 6, 5, 5 },
		{ 4, 3, 4, 4, 4, 5, -1, -29 },
		{ 19, 16, 12, 10, 7, 1, -7, -14 },
		{ 12, 7, -13, -2, 9, 6, -16, 10 },
		{ -6, -6, -6, -6, 1, 19, 32, 36 },
		{ -27, -13, -3, -1, -1, -1, 1, 2 },
		{ -15, 0, 13, 15, 14, 9, -4, -12 },
		{ 16, -3, -9, -9, -9, -10, -11, -10 },
		{ -11, 1, 11, 2, -18, 8, 15, 5 },
		{ -6, -5, -5, -6, -6, -3, 9, 21 },
		{ -11, -8, -4, 3, 11, 15, 18, 20 },
		{ -12, -12, -12, -11, -9, -7, -4, -2 },
		{ 15, 11, 1, -5, -5, -5, -4, -4 },
		{ -22, -22, -8, 19, 8, -12, -6, 15 },
		{ 22, -3, -23, -2, 18, 19, 16, 13 },
		{ 6, 7, -4, -13, -2, 8, 9, 7 },
		{ 20, 19, 16, 13, 10, 6, 5, 3 },
		{ 6, 5, 3, 0, -2, -2, -2, -2 },
		{ -12, -11, 1, 11, 11, 7, 2, -1 },
		{ 4, 3, 1, -1, -6, -13, -18, -17 },
		{ 15, 12, 10, 6, 4, 12, 24, 32 },
		{ -2, -2, -1, -1, -1, 0, 4, 11 },
		{ 6, 11, 15, 17, 13, 3, -8, -12 },
		{ 11, 11, 8, 1, -7, -10, -10, -9 },
		{ -7, 7, 14, 15, 13, 11, 10, 7 },
		{ -10, -12, -14, -14, -10, -1, 9, 12 },
		{ 23, 15, 3, -1, 4, 9, 9, 5 },
		{ 2, 4, -7, 4, 9, -20, 8, 3 },
		{ 11, 11, 11, 10, 8, 7, 6, 6 },
		{ -15, -16, -11, -1, 6, 3, -8, -14 },
		{ -6, -6, -6, -5, -1, 5, 8, 10 },
		{ 1, -1, -7, -15, -18, -18, -8, 8 },
		{ 3, 4, 4, 4, 4, 3, -2, -14 },
		{ -6, 8, 12, 4, -5, -10, -10, -9 },
		{ 1, 3, 4, 7, 12, 16, 17, 18 },
		{ 0, -2, -5, -8, -10, -11, -11, -11 },
		{ -6, -5, -2, 1, 5, 5, 6, 6 },
		{ 14, -1, -11, -11, -8, -1, 7, 12 },
		{ 15, 15, 12, 8, 1, -3, -4, -3 },
		{ 1, 0, -1, -1, -2, -3, -10, -18 },
		{ 10, 10, 9, 12, 13, 13, 7, -21 },
		{ -13, -12, -9, -5, -1, 1, 3, 4 },
		{ 13, 14, 6, -11, -17, -8, 4, 8 },
		{ 4, -13, -10, 4, 8, 8, 7, 8 },
		{ 6, 7, 7, 7, 8, 9, 9, 8 },
		{ -7, -6, -5, -5, -6, -10, -7, 17 },
		{ 8, 8, 6, 4, 2, -2, -4, -6 },
		{ -6, -6, -6, -6, -6, -6, -6, -6 },
		{ -2, -2, -1, 1, 4, 9, 12, 14 },
		{ -1, -4, -1, 8, 10, 2, -5, -8 },
		{ 14, 2, -3, -2, -1, 0, -1, -1 },
		{ -4, -6, -7, -8, -7, -3, 3, 7 },
		{ -13, -1, 3, 3, 2, 3, 3, 3 },
		{ 6, 1, -5, -9, -9, -6, -3, -1 },
		{ 7, 6, 4, 1, -1, 1, 10, 18 },
		{ -6, -5, -3, -1, 0, 1, 2, 3 },
		{ 9, 9, 9, 9, 9, 7, 2, -5 },
		{ 7, 5, 3, 0, -3, -5, -7, -8 },
		{ -3, -3, -3, -3, 1, 13, 14, -5 },
		{ 5, 4, 3, 4, 1, -10, -9, 4 },
		{ 2, 6, 9, 3, -11, -11, 1, 7 },
		{ -3, -7, -11, -9, 0, 5, 1, -4 },
		{ 2, 2, 2, 2, 1, -1, -4, -5 },
		{ 5, 4, 2, -3, -5, -2, 3, 6 },
		{ -4, 0, 4, 8, 9, 9, 9, 8 },
		{ -11, -7, 0, 3, 2, -3, -7, -8 },
		{ 10, 10, 8, 4, 2, 2, 2, 1 },
		{ -1, -1, 0, 0, 1, 1, 2, 3 },
		{ -4, -2, 0, 3, 4, 3, 1, 0 },
		{ 1, 0, -2, -3, -5, -6, -7, -7 },
		{ 2, 2, 1, 1, 0, 0, 0, -1 },
		{ -4, 1, 6, 5, 1, -2, -2, 0 },
		{ 5, 5, 5, 5, 5, 5, 5, 5 },
		{ -6, -5, -5, -4, -4, -3, -2, -2 },
		{ -2, 4, 8, 9, 8, 5, 1, -2 },
		{ 4, 1, -1, -1, -2, -2, -2, -1 },
		{ 2, -1, -4, -4, 0, 4, 5, 4 },
		{ -1, -2, -2, -2, -3, -3, 0, 4 },
		{ 5, 5, 4, 4, 3, 1, 0, -1 },
		{ -2, -2, -2, -2, -2, -3, -3, -4 },
		{ -1, 0, 2, 3, 4, 5, 5, 6 },
		{ -2, -1, -1, -1, -1, -1, -1, -1 },
		{ 2, 1, 2, 2, 4, 3, 1, -3 },
		{ 0, 0, 0, 0, 0, 0, 0, 0 },
		{ 3, 3, 2, 2, 2, 2, 3, 3 },
		{ 1, 1, 1, 1, 1, 1, 1, 1 },
	} , {
		{ -51, -52, -52, -53, -53, -53, -52, -50 },
		{ -30, -31, -28, -28, -19, 26, 45, 46 },
		{ -39, -41, -42, -42, -43, -42, -42, -40 },
		{ 45, 46, 45, 38, -13, -47, -48, -48 },
		{ 57, 60, 61, 63, 63, 61, 61, 57 },
		{ -41, -42, -40, -13, 32, 39, 39, 38 },
		{ 4, -10, -27, -41, -49, -51, -50, -48 },
		{ 46, 48, 49, 49, 47, 47, 48, 47 },
		{ 21, 23, 23, 23, 21, -3, -52, -60 },
		{ -23, -15, 13, 40, 45, 9, -28, -30 },
		{ -59, -59, -57, -53, -44, -34, -23, 0 },
		{ -32, -32, -32, -32, -32, -33, -32, -32 },
		{ 40, 38, 19, -23, -43, -44, -42, -38 },
		{ -51, -49, -30, 17, 29, 29, 29, 27 },
		{ -13, -13, -14, -10, 4, 44, 61, 60 },
		{ -33, -9, 22, 27, 8, -24, -39, -39 },
		{ -17, -16, -12, 9, 46, 61, 62, 63 },
		{ 36, 37, 34, 35, 37, 38, 39, 39 },
		{ -53, -54, -51, -33, 0, 17, 19, 17 },
		{ -9, -13, -12, 4, 29, 40, 40, 32 },
		{ 6, 8, 6, -2, -21, -43, -53, -54 },
		{ -25, -26, -26, -24, -24, -24, -23, -23 },
		{ 58, 64, 63, 59, 28, -5, -23, -16 },
		{ -20, -19, -9, 25, 45, 45, 22, -10 },
		{ -15, -16, -13, -12, -12, -1, 45, 62 },
		{ 20, 2, -29, -40, -37, -10, 17, 21 },
		{ -12, 9, 42, 51, 49, 52, 50, 41 },
		{ 61, 50, 12, -9, -9, -8, -9, -10 },
		{ -28, -27, -14, 11, 30, 13, -17, -31 },
		{ 10, 9, 9, 11, 11, 1, -30, -47 },
		{ 29, 30, 31, 30, 31, 30, 28, 26 },
		{ -18, -26, -33, -34, -35, -30, -13, 8 },
		{ 49, 51, 46, 26, -5, -18, -22, -22 },
		{ 44, 45, 31, -6, -23, -26, -28, -27 },
		{ -31, -19, 9, 35, 39, 39, 40, 37 },
		{ 8, 32, 45, 47, 28, 1, -11, -11 },
		{ 18, 18, 17, 19, 21, 17, -8, -39 },
		{ 34, 8, -21, -31, -32, -33, -33, -31 },
		{ 20, -6, -32, -26, 8, 30, 32, 28 },
		{ -32, -30, -24, -13, 12, 30, 35, 36 },
		{ 50, 46, 27, 1, -2, 9, 20, 14 },
		{ -5, -4, 10, 38, 35, 2, -7, -5 },
		{ 7, 6, 11, 21, 30, 38, 44, 46 },
		{ -17, -18, -19, -19, -19, -20, -19, -19 },
		{ 52, 51, 49, 48, 43, 36, 16, -5 },
		{ 22, 24, 15, -12, -26, -27, -26, -24 },
		{ -7, -6, -6, -4, 4, 24, 41, 42 },
		{ -55, -37, 7, 19, 19, 19, 20, 21 },
		{ 28, 29, 29, 23, -5, -34, -39, -43 },
		{ 69, 1, -10, -10, -11, -13, -14, -14 },
		{ 1, 23, 42, 50, 52, 44, 18, -8 },
		{ -44, -44, -38, -31, -22, -14, -14, -15 },
		{ 31, 31, 9, -28, -39, -33, -6, 13 },
		{ -24, -20, -8, 3, -14, -25, -25, -23 },
		{ 24, 24, 23, 22, 23, 23, 23, 22 },
		{ -26, -27, -24, -22, -19, -14, -7, 1 },
		{ 32, 32, 31, 32, 22, -8, -26, -30 },
		{ -14, -16, -20, -24, -29, -32, -34, -33 },
		{ -22, -19, -8, 9, 20, 24, 26, 28 },
		{ -14, -15, -17, -13, -11, -6, 9, 52 },
		{ 38, 42, 37, 31, 20, 7, 7, 7 },
		{ 10, 7, 3, 0, -10, -24, -32, -32 },
		{ -10, -10, -8, -10, -1, 31, 30, 8 },
		{ 2, -21, -34, -33, -18, -1, 5, 4 },
		{ 34, 37, 33, 19, 1, -7, -7, -10 },
		{ -6, 24, 43, 29, -7, -21, -22, -24 },
		{ -1, 17, 26, 28, 31, 29, 29, 27 },
		{ -31, -32, -22, 10, 20, 21, 18, 11 },
		{ 24, 25, 25, 16, -13, -24, -22, -18 },
		{ 50, 33, -9, -16, -16, -16, -16, -14 },
		{ 11, -1, -14, -21, -17, -1, 31, 40 },
		{ -40, -42, -42, -39, -33, -9, 20, 27 },
		{ 17, 18, 18, 18, 18, 18, 18, 18 },
		{ 29, 26, 19, 12, 2, -10, -24, -32 },
		{ -10, -3, 19, 36, 42, 35, 13, -2 },
		{ -11, -12, -13, -13, -14, -16, -17, -16 },
		{ 47, 10, -2, 2, 1, -2, -4, -6 },
		{ 37, 32, 19, -2, -12, -16, -16, -16 },
		{ -43, 1, 18, 19, 19, 19, 21, 19 },
		{ 8, 12, -2, -24, -22, 1, 12, 9 },
		{ 24, 24, 24, 22, 19, 6, -8, -13 },
		{ 12, -14, -26, -27, -27, -25, -20, -15 },
		{ 17, 3, 3, 8, 26, 45, 31, 3 },
		{ -54, -46, -21, -2, 2, 3, 6, 7 },
		{ 26, 27, 20, 6, -11, -10, 18, 30 },
		{ 8, 10, 7, -7, -30, -37, -18, 7 },
		{ -17, -17, -18, -17, -8, 15, 30, 33 },
		{ -34, -34, -29, -16, 0, 14, 20, 22 },
		{ 25, 29, 30, 31, 29, 22, 10, -4 },
		{ 3, 0, -6, -18, -26, -30, -29, -27 },
		{ 2, 4, 9, 13, 17, 24, 30, 32 },
		{ -38, -24, -5, 3, 8, 11, 13, 13 },
		{ 22, 19, 3, -10, -3, 19, 28, 28 },
		{ -6, 17, 23, 23, 22, 4, -16, -21 },
		{ -11, -15, -17, -8, 23, 32, 13, -11 },
		{ -18, -21, -22, -18, -3, 3, -12, -20 },
		{ 14, 14, 14, 14, 13, 13, 12, 13 },
		{ 39, -3, -13, -12, -11, -11, -9, -9 },
		{ -4, -4, -3, -1, -1, 1, 18, 48 },
		{ 20, 5, -16, -13, 8, 8, -14, -21 },
		{ 34, 31, 15, 3, -1, -2, -2, -4 },
		{ -10, -11, -10, -8, -2, -11, -31, -41 },
		{ -14, -9, 10, 25, 26, 25, 24, 20 },
		{ -22, -22, -23, -22, -20, -4, 15, 20 },
		{ -13, 0, 34, 36, 4, -7, -7, -3 },
		{ 3, -3, -15, -23, -23, -18, -8, 3 },
		{ -9, -7, -4, -2, -1, 13, 25, 29 },
		{ -35, -24, -8, -3, -5, -5, -4, -5 },
		{ 30, 26, 18, 14, 14, 12, 9, 8 },
		{ 10, 13, 16, 15, 7, -19, -28, -25 },
		{ -2, 32, 36, 21, 0, 12, 40, 48 },
		{ -13, -9, -8, -12, -8, 12, 12, -13 },
		{ -29, -7, 14, 21, 23, 17, 1, -18 },
		{ -13, 4, 20, 6, -12, -17, -19, -19 },
		{ 12, -23, -33, -6, 13, 8, 12, 13 },
		{ 29, 18, -10, -20, -18, -12, -1, 17 },
		{ 4, 28, 30, 3, -11, -10, -6, -7 },
		{ -18, -18, -18, -16, -14, -13, -11, -8 },
		{ -2, -6, -4, 12, 32, 23, 2, -3 },
		{ -15, -17, -16, -16, -17, -17, -5, 24 },
		{ 13, 17, 18, 19, 20, 21, 13, -9 },
		{ 20, 11, -7, -16, -18, -18, -18, -18 },
		{ -18, -20, -19, -8, 9, 17, 21, 20 },
		{ 1, -2, 0, 11, 19, 1, -8, -8 },
		{ 22, 19, 13, 6, -3, -10, -14, -16 },
		{ 11, -1, -17, -18, 0, 12, 15, 14 },
		{ 7, 6, 5, 3, 0, 0, 12, 29 },
		{ -14, -15, -9, 3, 10, -2, -13, -14 },
		{ 32, 6, -6, -3, 1, 4, 14, 18 },
		{ 4, 4, 4, 3, 4, 7, -1, -30 },
		{ -20, -20, -3, 24, 19, 4, 1, 1 },
		{ -21, -23, -17, 0, 9, 7, 6, 7 },
		{ 16, 17, 14, 15, 2, -20, -13, 19 },
		{ 3, 3, 1, -1, -2, -9, -22, -28 },
		{ 20, 13, -1, -1, 13, 20, 9, -4 },
		{ -4, -1, 2, 2, 12, 26, 11, -4 },
		{ 22, 0, -3, -3, -3, -3, -3, -3 },
		{ -15, 1, 7, -14, -20, -6, 5, 2 },
		{ 2, 6, 10, 15, 18, 18, 18, 17 },
		{ -27, -31, -28, -18, -3, 4, 5, 4 },
		{ -6, -7, -9, -12, -13, -8, 19, 29 },
		{ 11, 12, 9, -1, -13, -16, -17, -16 },
		{ -1, 13, 25, 25, 22, 13, 8, 10 },
		{ -12, -9, 7, 23, 11, -10, -19, -19 },
		{ 18, 21, 21, 14, 5, 2, 1, 2 },
		{ 9, -8, -14, -14, -13, -11, -12, -14 },
		{ -24, -14, 1, 9, 12, 13, 14, 14 },
		{ -16, -16, -12, -9, -5, 3, 13, 21 },
		{ 11, 11, 10, 10, 9, 1, -16, -24 },
		{ -11, -11, -11, -11, -11, -10, -9, -9 },
		{ 8, 9, 9, 10, 11, 11, 11, 11 },
		{ -19, -17, -15, -12, -6, -1, 4, 5 },
		{ 30, 23, 3, -9, -13, -12, -12, -10 },
		{ 5, 3, 5, 9, 3, -12, -17, -13 },
		{ -28, 4, 9, 8, 8, 5, 4, 5 },
		{ 3, -10, -11, 7, -2, -14, -9, 5 },
		{ 1, -2, 7, 26, 4, -2, 0, 0 },
		{ -8, 8, 2, -9, -4, 12, -8, -11 },
		{ -16, 1, 22, 17, 0, -10, 11, 25 },
		{ -1, 1, -4, -13, -18, -19, -18, -17 },
		{ 10, 15, 21, 23, 7, -9, -10, -7 },
		{ -4, -5, -4, -5, -5, -4, 0, 26 },
		{ 9, 4, -7, -3, 14, 20, 21, 18 },
		{ -15, -8, 2, 3, -8, -12, -11, -8 },
		{ 15, 14, 13, 12, 10, 4, -5, -11 },
		{ 11, -4, -11, -12, -12, -8, 3, 17 },
		{ -7, -7, -4, 5, 14, 19, 19, 17 },
		{ -5, -6, -7, -9, -9, -11, -12, -12 },
		{ 25, 17, 4, -2, -3, -3, -3, -3 },
		{ 4, 28, 3, -4, -3, -4, -3, -2 },
		{ -11, -1, 11, 15, 14, 13, 13, 11 },
		{ -1, -12, -20, -13, 0, 4, 2, 1 },
		{ -9, 15, 19, 2, 2, 14, 14, 6 },
		{ 16, 10, 1, -3, -6, -9, -11, -13 },
		{ -13, -14, -9, 4, 15, 14, 6, -5 },
		{ -8, -11, -13, -13, -13, -10, -3, 5 },
		{ 15, 16, 10, 3, 0, 4, 10, 13 },
		{ -13, -6, 7, 10, 8, 6, -1, -10 },
		{ 11, 12, 13, 7, -3, -9, -9, -8 },
		{ -2, -2, -4, -2, -3, 5, 29, 2 },
		{ -14, -11, -9, -5, 5, 12, 14, 15 },
		{ 4, 2, -1, -4, -8, -12, -14, -14 },
		{ 9, -6, -10, 2, 10, 7, 6, 5 },
		{ 7, 7, 5, 4, 2, -2, -10, -14 },
		{ -5, 5, 25, 7, -4, -3, -4, -2 },
		{ -21, -14, -1, 3, 2, 2, 3, 3 },
		{ 2, 3, 4, 5, 8, 13, 17, 18 },
		{ 0, 2, 3, -1, -12, -18, -7, 6 },
		{ 13, 13, 11, 1, -15, -14, 3, 11 },
		{ -14, -14, -10, -6, -4, -4, -4, -4 },
		{ -8, -10, -1, 11, 7, 0, 0, 7 },
		{ -6, -8, -13, -15, -11, 8, 16, 12 },
		{ 2, 6, 11, 16, 17, 12, 2, -3 },
		{ -4, -2, -6, -6, 10, -4, -8, 3 },
		{ -2, -3, -3, -3, -2, 4, 15, 18 },
		{ -7, -7, -7, -7, -7, -7, -7, -6 },
		{ 14, 13, 10, 5, 1, -1, -2, -3 },
		{ 11, -2, -7, -7, -7, -7, -7, -7 },
		{ 14, 14, 13, 11, 10, 9, 5, 2 },
		{ -11, -10, -7, -3, 1, 4, 7, 10 },
		{ -3, -2, 0, 1, 2, 2, 2, 1 },
		{ 9, 11, 1, -12, -16, -12, -7, -3 },
		{ 9, 6, 4, 6, 9, -3, -11, 8 },
		{ -10, -9, -8, -7, -7, -3, 3, 7 },
		{ -12, -7, 0, 5, 7, 9, 11, 11 },
		{ -2, -3, -2, -1, 1, -2, -11, -17 },
		{ 15, 10, -7, -13, -8, 4, 4, -5 },
		{ -1, 0, -1, -1, -1, -2, 3, 15 },
		{ -5, 4, 12, 13, 6, -5, -9, -7 },
		{ 1, 1, -2, -5, -7, -8, -8, -7 },
		{ -3, -4, -4, -3, 4, 13, 11, 8 },
		{ -13, -3, 4, 2, 1, 3, 3, 2 },
		{ 11, 9, 2, -2, -4, -5, -5, -4 },
		{ -4, 8, 10, 0, -6, -6, -5, -6 },
		{ 7, 8, 8, 7, 7, 7, 7, 7 },
		{ -2, -5, -7, -6, 0, 19, 0, -8 },
		{ -7, 2, 10, 4, -8, -2, 10, 14 },
		{ -7, -7, -6, -5, -4, -3, -3, -2 },
		{ -4, -3, -1, 6, 11, 11, 5, 0 },
		{ -3, -4, -5, -6, -4, 2, 8, 7 },
		{ 16, 9, 3, 2, 3, 4, 4, 4 },
		{ -1, -2, 0, 3, 7, 3, -3, -5 },
		{ 1, 8, 1, -10, 0, 8, 7, 6 },
		{ 3, 1, -5, -9, -10, -5, 0, 2 },
		{ 4, 5, 7, 6, 7, 8, -1, -13 },
		{ -8, -9, -7, -2, 4, 5, 2, -2 },
		{ -1, 1, 4, 5, 7, 8, 10, 10 },
		{ 4, 2, 1, 0, -1, -3, -6, -7 },
		{ 5, 6, 6, 5, 2, -2, -4, -5 },
		{ -4, -3, -2, -3, -5, -6, -3, 6 },
		{ -5, -4, -2, 0, 3, 5, 6, 7 },
		{ -3, -4, -4, -4, -4, -5, -5, -6 },
		{ 7, 9, 9, 7, 6, 3, 1, 0 },
		{ -1, -4, 1, 6, -8, -6, 7, -4 },
		{ 7, 8, 6, -2, -7, -3, 4, 6 },
		{ 4, -5, -9, -5, 0, 1, -1, -2 },
		{ 5, 4, 5, 5, 5, 6, 6, 6 },
		{ 8, 2, -2, -2, -2, -1, -1, 0 },
		{ -4, 3, 8, 9, 7, 4, 2, 1 },
		{ -5, -5, -4, -3, -2, 0, 1, 2 },
		{ 8, 2, -3, -2, -1, 2, 7, 9 },
		{ 3, 4, 3, -1, -3, -3, -2, -1 },
		{ 7, 6, 4, 1, 1, 1, 0, -1 },
		{ -1, -1, -1, -2, -1, 1, 3, 5 },
		{ 0, 0, 1, 2, 3, 4, 5, 5 },
		{ -7, -3, 1, 3, 1, -2, -5, -5 },
		{ 2, 2, 2, 2, 1, 0, -1, -2 },
		{ 1, 0, 0, -1, -1, -2, -2, -3 },
		{ 4, 4, 4, 4, 3, 3, 3, 3 },
		{ -2, -2, -2, -3, -3, -3, -3, -3 },
		{ 2, 2, -2, -2, 4, 8, 4, -5 },
		{ -2, -2, -1, -1, -1, -1, 0, 0 },
		{ -1, 2, 6, 7, 0, -6, -1, 5 },
		{ 0, 0, 0, 0, 0, 0, 0, 0 },
		{ 2, 2, 2, 2, 2, 2, 2, 2 },
		{ 1, 1, 1, 1, 1, 1, 1, 1 },
	} , {
		{ -33, -33, -33, -33, -11, -11, -11, -11 },
		{ -14, -7, 2, 9, -13, -5, 3, 10 },
		{ 15, 3, -12, -25, 15, 3, -12, -24 },
		{ 7, 2, -4, -10, 8, 3, -4, -10 },
		{ -22, -11, 2, 13, -35, -26, -14, -1 },
		{ -22, -11, 3, 15, -21, -9, 4, 16 },
		{ 23, 12, -2, -14, 21, 9, -5, -17 },
		{ 3, 0, -3, -4, 4, 0, -3, -3 },
		{ 28, 28, 27, 27, 10, 9, 8, 8 },
		{ -5, -8, -12, -15, -20, -23, -26, -28 },
		{ 13, 4, -6, -14, 12, 3, -7, -15 },
		{ -9, -4, 2, 6, -12, -7, -1, 4 },
		{ -15, -2, 12, 24, -11, 2, 16, 27 },
		{ -12, -16, -19, -22, 0, -4, -8, -11 },
		{ 10, 12, 15, 17, 31, 34, 37, 38 },
		{ -6, -4, 1, 7, -6, -4, 0, 6 },
		{ 21, 17, 12, 6, 13, 8, 2, -4 },
		{ -6, -5, -5, -4, -15, -15, -15, -15 },
		{ -12, -4, 7, 16, -11, -2, 8, 16 },
		{ 5, 1, -3, -7, 5, 1, -3, -6 },
		{ -9, -3, 4, 11, -8, -3, 5, 12 },
		{ -4, -4, -3, -2, -10, -10, -9, -8 },
		{ 11, 6, -2, -10, 11, 5, -2, -10 },
		{ -23, -19, -14, -9, -13, -8, -2, 3 },
		{ 15, 11, 4, -2, 11, 5, -1, -7 },
		{ -15, -8, 1, 10, -20, -13, -4, 6 },
		{ 17, 8, -2, -10, 26, 18, 8, -2 },
		{ 2, -3, -8, -13, 5, 1, -4, -9 },
		{ -5, -1, 2, 3, -5, -1, 2, 4 },
		{ 1, -7, -14, -19, 7, 0, -8, -13 },
		{ 12, 13, 14, 14, 4, 5, 6, 7 },
		{ -11, -11, -10, -10, -5, -5, -4, -4 },
		{ -4, 2, 8, 12, 6, 12, 17, 21 },
		{ -17, -13, -8, -2, -11, -6, 0, 5 },
		{ 7, 15, 21, 26, -6, 3, 11, 18 },
		{ 5, -1, -7, -12, -2, -9, -15, -20 },
		{ 7, 8, 9, 9, 2, 3, 4, 4 },
		{ -1, -1, -1, -1, -3, -3, -3, -3 },
		{ -5, -1, 5, 10, -1, 5, 10, 15 },
		{ 2, -1, -4, -7, 4, 1, -2, -6 },
		{ -3, -1, 1, 3, -3, -1, 1, 3 },
		{ 1, 1, 1, 0, -3, -3, -3, -4 },
		{ 8, 5, 1, -3, 13, 10, 7, 2 },
		{ 2, 4, 4, 5, 10, 12, 12, 13 },
		{ 1, -3, -5, -7, -5, -8, -10, -11 },
		{ 3, 1, -1, -3, 4, 1, -1, -3 },
		{ 7, 1, -5, -10, 3, -3, -9, -14 },
		{ -6, -9, -11, -13, 1, -2, -5, -7 },
		{ -5, -5, -5, -5, 0, 0, 0, 0 },
		{ 0, 6, 13, 19, -6, -1, 5, 12 },
		{ -9, -2, 3, 7, -9, -2, 3, 7 },
		{ -8, -8, -8, -7, -2, -2, -2, -2 },
		{ 12, 10, 8, 5, 7, 5, 2, -1 },
		{ -11, -8, -4, 1, -8, -4, 0, 5 },
		{ 10, 7, 4, 2, 19, 17, 16, 14 },
		{ 8, 3, -2, -6, 8, 2, -3, -6 },
		{ -5, -2, 3, 6, -5, -2, 3, 6 },
		{ -4, -3, -3, -2, -6, -6, -6, -5 },
		{ 3, 1, -2, -5, 3, 1, -2, -5 },
		{ -5, -1, 4, 7, -4, 1, 5, 9 },
		{ 1, 0, 0, -1, 1, 0, -1, -1 },
		{ 6, 4, -1, -6, 6, 4, -1, -7 },
		{ 0, 0, 0, -1, -7, -7, -7, -7 },
		{ -1, 0, 0, 0, 4, 4, 5, 5 },
		{ -9, -5, -1, 3, -15, -12, -7, -3 },
		{ -4, -1, 1, 2, -5, -2, 0, 1 },
		{ -3, -3, -3, -3, -1, -1, -1, -1 },
		{ 4, 4, 3, 2, 8, 8, 8, 7 },
		{ -8, -4, 0, 4, -7, -2, 2, 5 },
		{ 9, 6, 1, -3, 7, 3, -1, -5 },
		{ -6, -3, 0, 2, -10, -8, -5, -2 },
		{ -5, -3, -2, -1, -3, -2, 0, 1 },
		{ -3, -3, -3, -2, -2, -2, -1, 0 },
		{ 3, 0, -2, -5, 2, -1, -4, -6 },
		{ -6, -4, -1, 2, -5, -2, 1, 3 },
		{ 0, 2, 4, 5, 4, 7, 9, 10 },
		{ -4, -2, 1, 4, -4, -2, 1, 4 },
		{ 1, -1, -1, -1, 1, -1, -1, -1 },
		{ -2, -1, 0, 0, -2, -1, 0, 0 },
		{ 4, 3, 3, 3, 1, 1, 1, 1 },
		{ 5, 1, -4, -7, 4, -1, -5, -9 },
		{ -3, -1, 2, 5, -3, -1, 2, 5 },
		{ -6, -2, 1, 4, -8, -4, -1, 3 },
		{ 6, 2, -2, -4, 6, 2, -2, -4 },
		{ 0, -3, -7, -9, 3, 0, -3, -6 },
		{ -2, -1, -1, 0, -2, -2, -1, -1 },
		{ -1, -1, -2, -2, 1, 1, 0, 0 },
		{ 2, 0, -2, -5, 2, 1, -1, -4 },
		{ 0, 0, -1, -1, 0, 0, -1, -1 },
		{ 1, 1, 1, 2, 6, 6, 6, 6 },
		{ 3, 0, -3, -6, 0, -4, -7, -10 },
		{ -5, 1, 6, 10, -7, -2, 4, 9 },
		{ 2, 1, -1, -3, 2, 1, -1, -3 },
		{ -2, -1, 2, 4, -1, 1, 4, 6 },
		{ 1, -1, -2, -3, 1, 0, -1, -2 },
		{ -2, -4, -1, 6, -2, -4, -1, 7 },
		{ -6, -6, -5, -4, -4, -3, -2, -1 },
		{ -2, -2, -2, -2, -1, -1, -1, -1 },
		{ -11, -9, -7, -4, -6, -4, -2, 1 },
		{ 2, 2, 2, 2, 1, 1, 1, 1 },
		{ 9, 4, -1, -7, 12, 7, 1, -4 },
		{ 0, 0, -1, -2, 0, 0, -1, -2 },
		{ -1, -1, -1, -1, -1, -1, -2, -2 },
		{ 2, 0, -2, -3, 1, 0, -2, -3 },
		{ -3, 0, 4, 5, -3, 1, 4, 5 },
		{ -1, -1, 1, 4, -1, -1, 1, 4 },
		{ 6, 6, 6, 6, 1, 1, 1, 1 },
		{ 2, 2, 2, 3, 0, 0, 0, 0 },
		{ -2, -3, -5, -7, 1, 0, -2, -4 },
		{ 2, 2, 2, 1, 3, 3, 3, 3 },
		{ -1, -1, -1, -1, -2, -2, -2, -2 },
		{ 0, -1, -1, 0, 0, -1, -1, 0 },
		{ -4, -2, 0, 2, -6, -4, -2, 0 },
		{ 1, 6, 9, 11, -3, 1, 5, 7 },
		{ 3, 2, 0, -2, 3, 2, 0, -3 },
		{ 6, 3, -1, -4, 8, 5, 1, -2 },
		{ 0, 0, 0, 0, -2, -2, -2, -2 },
		{ 0, -1, -2, -2, -2, -3, -4, -5 },
		{ 1, 0, -1, -1, 0, -1, -2, -2 },
		{ -1, -1, 0, 0, -1, -1, 0, 0 },
		{ -4, -6, -7, -8, 0, -2, -3, -4 },
		{ 3, 5, 6, 7, -1, 1, 3, 4 },
		{ -8, -6, -3, -1, -5, -2, 0, 2 },
		{ 5, 3, 1, -2, 9, 7, 5, 2 },
		{ -1, -2, -3, -4, 1, 0, -1, -2 },
		{ -5, -5, -3, 1, -5, -5, -4, 0 },
		{ -3, -2, -2, -1, -2, -1, -1, 0 },
		{ 4, 2, 0, -2, 6, 4, 1, -1 },
		{ -3, -2, 0, 3, -3, -2, 0, 3 },
		{ 2, 0, -2, -4, -1, -3, -5, -7 },
		{ -1, -1, -2, -2, 0, -1, -1, -2 },
		{ 0, -2, -3, -3, -4, -5, -6, -7 },
		{ 2, -3, -4, -2, 1, -4, -5, -1 },
		{ 2, 2, 1, -2, 2, 2, 1, -2 },
		{ 1, -2, -4, -5, 2, 0, -2, -4 },
		{ -1, -1, 1, 2, 0, 1, 2, 3 },
		{ -1, 0, 1, 2, -1, 0, 1, 1 },
		{ 4, 3, 0, -4, 4, 3, 0, -4 },
		{ -3, 0, 3, 6, 0, 3, 6, 8 },
		{ 3, 2, 1, 0, 6, 5, 4, 2 },
		{ -3, -2, -2, -2, 0, 0, 1, 1 },
		{ 1, 0, -1, -3, 0, -1, -3, -5 },
		{ -3, -2, -1, 0, -7, -6, -4, -3 },
		{ -3, 0, 1, 2, -3, 0, 1, 2 },
		{ 0, -1, -2, -2, 0, -1, -2, -2 },
		{ -1, 2, 5, 8, -3, -1, 3, 6 },
		{ -2, -1, 0, 1, -1, 0, 1, 2 },
		{ 6, 4, 1, -1, 4, 2, 0, -2 },
		{ -2, -1, 0, 1, -2, -1, 0, 1 },
		{ -4, -2, -1, 1, -2, -1, 1, 2 },
		{ 5, 5, 5, 5, 3, 3, 3, 3 },
		{ 1, 1, 0, 0, 1, 1, 1, 1 },
		{ 8, 6, 4, 2, 5, 3, 1, -2 },
		{ -1, 0, 0, 0, -1, 0, 0, 0 },
		{ 1, 1, 1, 0, 1, 1, 1, 0 },
		{ 1, 0, -1, -2, 3, 2, 1, -1 },
		{ 3, 3, 3, 3, 4, 5, 5, 5 },
		{ 2, 1, 0, -1, 2, 1, 0, -1 },
		{ 0, 0, 0, 0, 1, 1, 1, 1 },
		{ -4, -4, -5, -5, -1, -2, -3, -3 },
		{ -2, -1, 0, 1, -4, -3, -2, -1 },
		{ -1, 1, 3, 6, -2, -1, 1, 4 },
		{ 1, 0, -1, -2, 1, 0, -1, -2 },
		{ 5, 4, 3, 2, 3, 2, 1, 0 },
		{ -2, 0, 2, 3, -2, 0, 2, 3 },
		{ 3, 2, 0, -1, 2, 0, -1, -2 },
		{ -3, -2, -1, 1, -3, -2, -1, 1 },
		{ 0, 0, 0, 0, 0, 0, 0, 0 },
		{ -1, 1, 3, 4, 2, 4, 6, 6 },
		{ -2, -1, -1, 0, -1, -1, 0, 0 },
		{ -1, -2, -3, -4, 0, -1, -2, -3 },
		{ 0, 0, 0, 1, 0, 0, 0, 1 },
		{ 1, 1, 1, 1, 0, 0, 0, 0 },
		{ 0, 0, 0, 0, 2, 2, 2, 2 },
		{ 3, 4, 4, 4, 2, 2, 2, 2 },
		{ 1, 1, 1, 1, 0, 1, 1, 1 },
		{ 0, 0, 1, 2, 0, 0, 1, 2 },
		{ -3, 2, 3, 0, -3, 2, 2, 0 },
		{ 3, 1, 0, -1, 3, 2, 0, -1 },
		{ 2, 0, 0, 0, 5, 3, 3, 2 },
		{ 0, 0, -1, -2, -1, -2, -3, -3 },
		{ -1, 0, 1, 2, -1, -1, 0, 2 },
		{ 0, 1, 1, 1, 0, 1, 1, 1 },
		{ -1, 0, 2, 3, 1, 2, 3, 5 },
		{ -5, -5, -4, -3, -3, -2, -1, 0 },
		{ 3, 0, -1, -1, 3, 0, -1, -1 },
		{ 0, 0, 0, -1, 0, 0, 0, -1 },
		{ -1, 0, 0, 0, 0, 0, 1, 1 },
		{ -2, -2, -2, -2, -4, -4, -5, -4 },
		{ 3, 3, 4, 6, -1, 0, 1, 2 },
		{ -1, 1, 2, 2, -1, 1, 2, 2 },
		{ 3, 2, 1, -1, 4, 3, 2, 1 },
		{ -1, -1, 1, 1, -3, -2, -1, 0 },
		{ -1, 1, 2, 3, -2, -1, 1, 2 },
		{ 0, 0, 0, 0, -1, -1, -1, -1 },
		{ -1, -1, -2, -2, 0, -1, -1, -1 },
		{ -1, -2, -1, 2, -1, -2, -1, 2 },
		{ 4, 3, 2, 1, 3, 1, 0, -1 },
		{ -1, -1, -1, 0, -2, -2, -2, 0 },
		{ 0, 1, 3, 4, -1, 0, 1, 3 },
		{ 0, -1, -1, -1, -1, -2, -2, -2 },
		{ 1, 2, 0, -4, 1, 2, 0, -5 },
		{ -2, -1, -1, -1, -1, -1, -1, -1 },
		{ -1, -1, 0, 0, -1, -1, -1, -1 },
		{ 2, 2, 1, 0, 2, 1, 1, 0 },
		{ 0, 0, 1, 1, 1, 1, 2, 2 },
		{ 1, -1, -2, -4, 0, -2, -3, -4 },
		{ 0, 0, 0, 1, 1, 1, 1, 2 },
		{ -3, -3, -2, 0, -4, -4, -3, -2 },
		{ 2, -1, -1, 2, 2, -1, -1, 2 },
		{ 2, 1, 0, 0, 2, 1, 0, 0 },
		{ 0, 1, 1, 0, 0, 1, 1, 0 },
		{ -1, -1, -1, -1, 0, 0, 0, 0 },
		{ 2, 2, 1, 1, 1, 1, 1, 0 },
		{ 0, -1, -1, -2, 0, 0, -1, -1 },
		{ 3, 5, 3, -1, 3, 4, 2, -3 },
		{ 1, 1, 1, 1, 1, 0, 0, 0 },
		{ 1, 1, 2, 2, 0, 0, 1, 1 },
		{ -1, -1, -1, -1, -2, -2, -1, -1 },
		{ 0, 1, 1, 2, 0, 0, 0, 1 },
		{ 3, 2, 2, 2, 2, 2, 2, 1 },
		{ 1, 1, 1, 1, 2, 2, 2, 2 },
		{ 2, 1, 1, 0, 1, 0, 0, -1 },
		{ 2, 1, 0, -1, 3, 2, 1, 0 },
		{ 1, 0, 0, 0, 1, 0, 0, 0 },
		{ 1, 1, 2, 2, 3, 3, 4, 4 },
		{ -1, -1, 0, 0, -1, -1, -1, 0 },
		{ 1, 1, 1, 1, 1, 1, 2, 2 },
		{ 1, 0, -1, -1, 1, 1, 0, -1 },
		{ 0, 3, 4, 5, -1, 1, 3, 4 },
		{ -2, -2, -1, 0, -3, -3, -2, -2 },
		{ 1, 1, 1, 2, 1, 1, 1, 1 },
		{ 0, -1, -1, -1, -1, -2, -2, -1 },
		{ 1, 1, 0, -2, 1, 1, 0, -2 },
		{ 0, 0, 1, 1, 0, 0, 1, 1 },
		{ 2, 1, 1, 0, 2, 2, 2, 1 },
		{ -1, -2, -2, -2, 0, -1, -1, -1 },
		{ 2, 1, 1, 1, 2, 1, 1, 1 },
		{ 1, 1, 2, 2, 0, 0, 1, 2 },
		{ 1, 1, 1, 1, 2, 2, 1, 1 },
		{ 2, 2, 3, 3, 0, 1, 2, 2 },
		{ 1, 1, 1, 1, 1, 1, 1, 1 },
		{ 1, 1, 0, 0, 1, 1, 1, 0 },
		{ 2, 3, 3, 1, 1, 2, 2, 1 },
		{ -3, -3, -3, -3, -2, -2, -2, -2 },
		{ 0, 1, 2, 2, 1, 2, 3, 3 },
		{ -1, -2, -2, -2, -2, -3, -3, -3 },
		{ 1, 2, 2, 1, 0, 1, 1, 0 },
		{ -2, -2, -3, -3, -1, -1, -2, -2 },
		{ 1, 1, 1, 1, 1, 1, 1, 2 },
		{ -2, -2, -2, -2, -2, -2, -2, -2 },
		{ 1, 2, 1, 0, 1, 2, 2, 0 },
		{ -1, -1, -1, -1, -1, -1, -1, -1 },
		{ 1, 2, 2, 2, 1, 1, 1, 2 },
		{ -1, -1, -1, -2, -1, -1, -1, -1 },
		{ 0, 1, 1, 1, 1, 2, 2, 1 },
	}
};

const uint8_t st2205_shuffle_data[10360] = {
  0,   0,   0,   8,   8,   0,   0,  16,   8,   8,  16,   0,   0,  24,   8,  16,
 16,   8,  24,   0,   0,  32,   8,  24,  16,  16,  24,   8,  32,   0,   0,  40,
  8,  32,  16,  24,  24,  16,  32,   8,  40,   0,   0,  48,   8,  40,  16,  32,
 24,  24,  32,  16,  40,   8,  48,   0,   0,  56,   8,  48,  16,  40,  24,  32,
 32,  24,  40,  16,  48,   8,  56,   0,   0,  64,   8,  56,  16,  48,  24,  40,
 32,  32,  40,  24,  48,  16,  56,   8,  64,   0,   0,  72,   8,  64,  16,  56,
 24,  48,  32,  40,  40,  32,  48,  24,  56,  16,  64,   8,  72,   0,   0,  80,
  8,  72,  16,  64,  24,  56,  32,  48,  40,  40,  48,  32,  56,  24,  64,  16,
 72,   8,  80,   0,   0,  88,   8,  80,  16,  72,  24,  64,  32,  56,  40,  48,
 48,  40,  56,  32,  64,  24,  72,  16,  80,   8,  88,   0,   0,  96,   8,  88,
 16,  80,  24,  72,  32,  64,  40,  56,  48,  48,  56,  40,  64,  32,  72,  24,
 80,  16,  88,   8,  96,   0,   0, 104,   8,  96,  16,  88,  24,  80,  32,  72,
 40,  64,  48,  56,  56,  48,  64,  40,  72,  32,  80,  24,  88,  16,  96,   8,
104,   0,   0, 112,   8, 104,  16,  96,  24,  88,  32,  80,  40,  72,  48,  64,
 56,  56,  64,  48,  72,  40,  80,  32,  88,  24,  96,  16, 104,   8, 112,   0,
  0, 120,   8, 112,  16, 104,  24,  96,  32,  88,  40,  80,  48,  72,  56,  64,
 64,  56,  72,  48,  80,  40,  88,  32,  96,  24, 104,  16, 112,   8, 120,   0,
  0, 128,   8, 120,  16, 112,  24, 104,  32,  96,  40,  88,  48,  80,  56,  72,
 64,  64,  72,  56,  80,  48,  88,  40,  96,  32, 104,  24, 112,  16, 120,   8,
  0, 136,   8, 128,  16, 120,  24, 112,  32, 104,  40,  96,  48,  88,  56,  80,
 64,  72,  72,  64,  80,  56,  88,  48,  96,  40, 104,  32, 112,  24, 120,  16,
  0, 144,   8, 136,  16, 128,  24, 120,  32, 112,  40, 104,  48,  96,  56,  88,
 64,  80,  72,  72,  80,  64,  88,  56,  96,  48, 104,  40, 112,  32, 120,  24,
  0, 152,   8, 144,  16, 136,  24, 128,  32, 120,  40, 112,  48, 104,  56,  96,
 64,  88,  72,  80,  80,  72,  88,  64,  96,  56, 104,  48, 112,  40, 120,  32,
  8, 152,  16, 144,  24, 136,  32, 128,  40, 120,  48, 112,  56, 104,  64,  96,
 72,  88,  80,  80,  88,  72,  96,  64, 104,  56, 112,  48, 120,  40,  16, 152,
 24, 144,  32, 136,  40, 128,  48, 120,  56, 112,  64, 104,  72,  96,  80,  88,
 88,  80,  96,  72, 104,  64, 112,  56, 120,  48,  24, 152,  32, 144,  40, 136,
 48, 128,  56, 120,  64, 112,  72, 104,  80,  96,  88,  88,  96,  80, 104,  72,
112,  64, 120,  56,  32, 152,  40, 144,  48, 136,  56, 128,  64, 120,  72, 112,
 80, 104,  88,  96,  96,  88, 104,  80, 112,  72, 120,  64,  40, 152,  48, 144,
 56, 136,  64, 128,  72, 120,  80, 112,  88, 104,  96,  96, 104,  88, 112,  80,
120,  72,  48, 152,  56, 144,  64, 136,  72, 128,  80, 120,  88, 112,  96, 104,
104,  96, 112,  88, 120,  80,  56, 152,  64, 144,  72, 136,  80, 128,  88, 120,
 96, 112, 104, 104, 112,  96, 120,  88,  64, 152,  72, 144,  80, 136,  88, 128,
 96, 120, 104, 112, 112, 104, 120,  96,  72, 152,  80, 144,  88, 136,  96, 128,
104, 120, 112, 112, 120, 104,  80, 152,  88, 144,  96, 136, 104, 128, 112, 120,
120, 112,  88, 152,  96, 144, 104, 136, 112, 128, 120, 120,  96, 152, 104, 144,
112, 136, 120, 128, 104, 152, 112, 144, 120, 136, 112, 152, 120, 144, 120, 152,
 56,  80,  64,  80,  64,  72,  56,  72,  48,  72,  48,  80,  48,  88,  56,  88,
 64,  88,  72,  88,  72,  80,  72,  72,  72,  64,  64,  64,  56,  64,  48,  64,
 40,  64,  40,  72,  40,  80,  40,  88,  40,  96,  48,  96,  56,  96,  64,  96,
 72,  96,  80,  96,  80,  88,  80,  80,  80,  72,  80,  64,  80,  56,  72,  56,
 64,  56,  56,  56,  48,  56,  40,  56,  32,  56,  32,  64,  32,  72,  32,  80,
 32,  88,  32,  96,  32, 104,  40, 104,  48, 104,  56, 104,  64, 104,  72, 104,
 80, 104,  88, 104,  88,  96,  88,  88,  88,  80,  88,  72,  88,  64,  88,  56,
 88,  48,  80,  48,  72,  48,  64,  48,  56,  48,  48,  48,  40,  48,  32,  48,
 24,  48,  24,  56,  24,  64,  24,  72,  24,  80,  24,  88,  24,  96,  24, 104,
 24, 112,  32, 112,  40, 112,  48, 112,  56, 112,  64, 112,  72, 112,  80, 112,
 88, 112,  96, 112,  96, 104,  96,  96,  96,  88,  96,  80,  96,  72,  96,  64,
 96,  56,  96,  48,  96,  40,  88,  40,  80,  40,  72,  40,  64,  40,  56,  40,
 48,  40,  40,  40,  32,  40,  24,  40,  16,  40,  16,  48,  16,  56,  16,  64,
 16,  72,  16,  80,  16,  88,  16,  96,  16, 104,  16, 112,  16, 120,  24, 120,
 32, 120,  40, 120,  48, 120,  56, 120,  64, 120,  72, 120,  80, 120,  88, 120,
 96, 120, 104, 120, 104, 112, 104, 104, 104,  96, 104,  88, 104,  80, 104,  72,
104,  64, 104,  56, 104,  48, 104,  40, 104,  32,  96,  32,  88,  32,  80,  32,
 72,  32,  64,  32,  56,  32,  48,  32,  40,  32,  32,  32,  24,  32,  16,  32,
  8,  32,   8,  40,   8,  48,   8,  56,   8,  64,   8,  72,   8,  80,   8,  88,
  8,  96,   8, 104,   8, 112,   8, 120,   8, 128,  16, 128,  24, 128,  32, 128,
 40, 128,  48, 128,  56, 128,  64, 128,  72, 128,  80, 128,  88, 128,  96, 128,
104, 128, 112, 128, 112, 120, 112, 112, 112, 104, 112,  96, 112,  88, 112,  80,
112,  72, 112,  64, 112,  56, 112,  48, 112,  40, 112,  32, 112,  24, 104,  24,
 96,  24,  88,  24,  80,  24,  72,  24,  64,  24,  56,  24,  48,  24,  40,  24,
 32,  24,  24,  24,  16,  24,   8,  24,   0,  24,   0,  32,   0,  40,   0,  48,
  0,  56,   0,  64,   0,  72,   0,  80,   0,  88,   0,  96,   0, 104,   0, 112,
  0, 120,   0, 128,   0, 136,   8, 136,  16, 136,  24, 136,  32, 136,  40, 136,
 48, 136,  56, 136,  64, 136,  72, 136,  80, 136,  88, 136,  96, 136, 104, 136,
112, 136, 120, 136, 120, 128, 120, 120, 120, 112, 120, 104, 120,  96, 120,  88,
120,  80, 120,  72, 120,  64, 120,  56, 120,  48, 120,  40, 120,  32, 120,  24,
120,  16, 112,  16, 104,  16,  96,  16,  88,  16,  80,  16,  72,  16,  64,  16,
 56,  16,  48,  16,  40,  16,  32,  16,  24,  16,  16,  16,   8,  16,   0,  16,
  0, 144,   8, 144,  16, 144,  24, 144,  32, 144,  40, 144,  48, 144,  56, 144,
 64, 144,  72, 144,  80, 144,  88, 144,  96, 144, 104, 144, 112, 144, 120, 144,
120,   8, 112,   8, 104,   8,  96,   8,  88,   8,  80,   8,  72,   8,  64,   8,
 56,   8,  48,   8,  40,   8,  32,   8,  24,   8,  16,   8,   8,   8,   0,   8,
  0, 152,   8, 152,  16, 152,  24, 152,  32, 152,  40, 152,  48, 152,  56, 152,
 64, 152,  72, 152,  80, 152,  88, 152,  96, 152, 104, 152, 112, 152, 120, 152,
120,   0, 112,   0, 104,   0,  96,   0,  88,   0,  80,   0,  72,   0,  64,   0,
 56,   0,  48,   0,  40,   0,  32,   0,  24,   0,  16,   0,   8,   0,   0,   0,
  0,   0,   0,   8,   8,   0,   8,   8,  32,   0,  32,   8,  40,   0,  40,   8,
 64,   0,  64,   8,  72,   0,  72,   8,  96,   0,  96,   8, 104,   0, 104,   8,
 16,  16,  16,  24,  24,  16,  24,  24,  48,  16,  48,  24,  56,  16,  56,  24,
 80,  16,  80,  24,  88,  16,  88,  24, 112,  16, 112,  24, 120,  16, 120,  24,
  0,  32,   0,  40,   8,  32,   8,  40,  32,  32,  32,  40,  40,  32,  40,  40,
 64,  32,  64,  40,  72,  32,  72,  40,  96,  32,  96,  40, 104,  32, 104,  40,
 16,  48,  16,  56,  24,  48,  24,  56,  48,  48,  48,  56,  56,  48,  56,  56,
 80,  48,  80,  56,  88,  48,  88,  56, 112,  48, 112,  56, 120,  48, 120,  56,
  0,  64,   0,  72,   8,  64,   8,  72,  32,  64,  32,  72,  40,  64,  40,  72,
 64,  64,  64,  72,  72,  64,  72,  72,  96,  64,  96,  72, 104,  64, 104,  72,
 16,  80,  16,  88,  24,  80,  24,  88,  48,  80,  48,  88,  56,  80,  56,  88,
 80,  80,  80,  88,  88,  80,  88,  88, 112,  80, 112,  88, 120,  80, 120,  88,
  0,  96,   0, 104,   8,  96,   8, 104,  32,  96,  32, 104,  40,  96,  40, 104,
 64,  96,  64, 104,  72,  96,  72, 104,  96,  96,  96, 104, 104,  96, 104, 104,
 16, 112,  16, 120,  24, 112,  24, 120,  48, 112,  48, 120,  56, 112,  56, 120,
 80, 112,  80, 120,  88, 112,  88, 120, 112, 112, 112, 120, 120, 112, 120, 120,
  0, 128,   0, 136,   8, 128,   8, 136,  32, 128,  32, 136,  40, 128,  40, 136,
 64, 128,  64, 136,  72, 128,  72, 136,  96, 128,  96, 136, 104, 128, 104, 136,
 16, 144,  16, 152,  24, 144,  24, 152,  48, 144,  48, 152,  56, 144,  56, 152,
 80, 144,  80, 152,  88, 144,  88, 152, 112, 144, 112, 152, 120, 144, 120, 152,
 16,   0,  16,   8,  24,   0,  24,   8,  48,   0,  48,   8,  56,   0,  56,   8,
 80,   0,  80,   8,  88,   0,  88,   8, 112,   0, 112,   8, 120,   0, 120,   8,
  0,  16,   0,  24,   8,  16,   8,  24,  32,  16,  32,  24,  40,  16,  40,  24,
 64,  16,  64,  24,  72,  16,  72,  24,  96,  16,  96,  24, 104,  16, 104,  24,
 16,  32,  16,  40,  24,  32,  24,  40,  48,  32,  48,  40,  56,  32,  56,  40,
 80,  32,  80,  40,  88,  32,  88,  40, 112,  32, 112,  40, 120,  32, 120,  40,
  0,  48,   0,  56,   8,  48,   8,  56,  32,  48,  32,  56,  40,  48,  40,  56,
 64,  48,  64,  56,  72,  48,  72,  56,  96,  48,  96,  56, 104,  48, 104,  56,
 16,  64,  16,  72,  24,  64,  24,  72,  48,  64,  48,  72,  56,  64,  56,  72,
 80,  64,  80,  72,  88,  64,  88,  72, 112,  64, 112,  72, 120,  64, 120,  72,
  0,  80,   0,  88,   8,  80,   8,  88,  32,  80,  32,  88,  40,  80,  40,  88,
 64,  80,  64,  88,  72,  80,  72,  88,  96,  80,  96,  88, 104,  80, 104,  88,
 16,  96,  16, 104,  24,  96,  24, 104,  48,  96,  48, 104,  56,  96,  56, 104,
 80,  96,  80, 104,  88,  96,  88, 104, 112,  96, 112, 104, 120,  96, 120, 104,
  0, 112,   0, 120,   8, 112,   8, 120,  32, 112,  32, 120,  40, 112,  40, 120,
 64, 112,  64, 120,  72, 112,  72, 120,  96, 112,  96, 120, 104, 112, 104, 120,
 16, 128,  16, 136,  24, 128,  24, 136,  48, 128,  48, 136,  56, 128,  56, 136,
 80, 128,  80, 136,  88, 128,  88, 136, 112, 128, 112, 136, 120, 128, 120, 136,
  0, 144,   0, 152,   8, 144,   8, 152,  32, 144,  32, 152,  40, 144,  40, 152,
 64, 144,  64, 152,  72, 144,  72, 152,  96, 144,  96, 152, 104, 144, 104, 152,
 72,  56,   8,  72, 104,  88, 104,  72,  32,  80,  72,  96,  64, 128,   0,  24,
  8, 136,  72,  88,  56, 104,  24,   0,  64,  16,  24,  56,  72, 128, 112,  32,
  0, 144,  80, 144,  72,   8,  88,  24,  24, 136,  48, 104,  16,  16,  96,  64,
 56, 128, 112,  40,   8, 152,  48, 120,  16,  24, 112,   0,  40,  88,  40,   0,
 40,  48, 120,  56,  72,  80,  48,  80,  16,  40, 120,  24,  56,  56,  88,  88,
 32,   0,  48,  72,  72,  32,  96, 104,   0,  64,  72,  72, 112, 104, 112,   8,
 80,  56,  24,  48, 120, 120,  56,  48,  64,  88,  72,   0, 112, 112,  32, 128,
120,  80,  48,  24,  40,  56,   0,  80,  56, 136,  56,   0,  24,  32, 104,  96,
 32,  88,  88,  96, 120,  72,  88,  32,  24, 128,  80,   0,   8,  88, 120,   8,
 16,  56, 120, 152,  40,  72,  96,  56, 112,  16,  16,  48,  32,  96,  48, 112,
 80,  72, 112,  72,  88,   8,  16, 128,   8,  32,  16, 104,  56,  40,  80, 120,
 48,  56,  40,  80,  88,  64,  32,   8,   0,  96,   8,  48,   8,   0, 120,  16,
 16,  80,  80, 112, 120, 112,  72,  24, 112,  80,  48,  96,  64,  80, 120,  32,
 48,  48,   0, 112,   8, 128,  64,   8,  56, 112,  96,   0,  72,  64,  56,  88,
112, 144,  88,  56,  80,  48, 104,  40,  56,  72,  96,  96,   0,   0,  64,  56,
 96,  48, 104, 104,  88, 144, 120,  48, 104, 152,  24, 104,  56, 144,   0,  32,
 32,  24,  16,  72, 112, 136,  24, 152, 104,   0,  88, 120,  72, 144,  96, 136,
 96,  40, 112, 128,   0, 152,  80,  96,  56, 120,  72,  48,  88, 112,  24,  96,
 24,  24,   8, 112,  48,   8,  64,  64,  88,  72, 112,  88,  40,  16,  64, 112,
 32,  16, 112,  56,  88,   0,  16, 152,  48,   0,   0,  88,  48,  40, 104, 120,
  0,  16, 104, 144,  24,  16,  80, 128,  32, 152,  24,  80,  96, 128,  24,  40,
 64,  32,  32,  48,  96, 152, 112,  48,   0,  40,  40, 152,  24,  72,  56,  16,
 80,  16,  40,   8,  64,  96, 120, 136,  56,  80,  32,  40, 104,  80,  40,  24,
112, 120,  32, 144,  16,  64,  88, 152,  40, 112, 112,  96,  16,   8,  96,  72,
 64,  40,  64,  24,   0, 128,  16, 112,  48, 152,  40, 136,  16,  88, 120,  64,
 96, 112, 120, 128,   8, 120,  24, 144,  80,  32,   0, 136,  40,  32, 120,   0,
 48, 144, 112, 152,  56,   8,  32,  72,  80,  80,  64, 136,  96, 120,  32, 136,
  8,  16,  40, 128, 120,  40,  48, 136,   8, 144, 120, 104,   8,  24,   0,  56,
120, 144,  96,  32,  80,  24,   8,  96,  48, 128,  16, 136,  88,  48,  24,  64,
 56,  64,  24, 112, 112,  24,   8,  56,  88, 136,  16, 120,  80,  88,  40,  40,
  0,   8,  40, 104,  64,   0,  48,  88,  64, 104,  80, 136,  80, 152,  48,  32,
  0, 120,  40,  96,  16,  96,  40, 144,   8,  40,  80,  40,  32,  56,  56, 152,
  0, 104,  80, 104,  88, 104,  72, 112, 112,  64,   0,  72,  40, 120, 120,  88,
  8,  80,  64,  48,  88,  40,  32,  64,   8, 104, 104,   8,  24,   8,  56,  32,
 40,  64,  56,  96,  72, 136,  88,  16, 104, 128,  72, 104,  88, 128,  48,  64,
 80,   8, 104,  56, 104, 136,  72, 152,  32,  32,  32, 120,  64, 144,  32, 112,
 64, 120,  64,  72, 104,  16, 104,  24, 104, 112,  96,  24,  48,  16,  88,  80,
 56,  24,  72, 120,   0,  48, 104,  64,  16, 144,  96,  88,  96,  16,  32, 104,
 80,  64,  96,  80,  16,   0,  24,  88,  72,  16,  72,  40,   8,   8,   8,  64,
 96, 144,  24, 120, 120,  96, 104,  48,  64, 152, 104,  32,  96,   8,  16,  32,
  0,   0,   8,   0,  16,   0,  24,   0,  32,   0,  40,   0,  48,   0,  56,   0,
 64,   0,  72,   0,  80,   0,  88,   0,  96,   0, 104,   0, 112,   0, 120,   0,
  0,  32,   8,  32,  16,  32,  24,  32,  32,  32,  40,  32,  48,  32,  56,  32,
 64,  32,  72,  32,  80,  32,  88,  32,  96,  32, 104,  32, 112,  32, 120,  32,
  0,  64,   8,  64,  16,  64,  24,  64,  32,  64,  40,  64,  48,  64,  56,  64,
 64,  64,  72,  64,  80,  64,  88,  64,  96,  64, 104,  64, 112,  64, 120,  64,
  0,  96,   8,  96,  16,  96,  24,  96,  32,  96,  40,  96,  48,  96,  56,  96,
 64,  96,  72,  96,  80,  96,  88,  96,  96,  96, 104,  96, 112,  96, 120,  96,
  0, 128,   8, 128,  16, 128,  24, 128,  32, 128,  40, 128,  48, 128,  56, 128,
 64, 128,  72, 128,  80, 128,  88, 128,  96, 128, 104, 128, 112, 128, 120, 128,
  0,   8,   8,   8,  16,   8,  24,   8,  32,   8,  40,   8,  48,   8,  56,   8,
 64,   8,  72,   8,  80,   8,  88,   8,  96,   8, 104,   8, 112,   8, 120,   8,
  0,  40,   8,  40,  16,  40,  24,  40,  32,  40,  40,  40,  48,  40,  56,  40,
 64,  40,  72,  40,  80,  40,  88,  40,  96,  40, 104,  40, 112,  40, 120,  40,
  0,  72,   8,  72,  16,  72,  24,  72,  32,  72,  40,  72,  48,  72,  56,  72,
 64,  72,  72,  72,  80,  72,  88,  72,  96,  72, 104,  72, 112,  72, 120,  72,
  0, 104,   8, 104,  16, 104,  24, 104,  32, 104,  40, 104,  48, 104,  56, 104,
 64, 104,  72, 104,  80, 104,  88, 104,  96, 104, 104, 104, 112, 104, 120, 104,
  0, 136,   8, 136,  16, 136,  24, 136,  32, 136,  40, 136,  48, 136,  56, 136,
 64, 136,  72, 136,  80, 136,  88, 136,  96, 136, 104, 136, 112, 136, 120, 136,
  0,  16,   8,  16,  16,  16,  24,  16,  32,  16,  40,  16,  48,  16,  56,  16,
 64,  16,  72,  16,  80,  16,  88,  16,  96,  16, 104,  16, 112,  16, 120,  16,
  0,  48,   8,  48,  16,  48,  24,  48,  32,  48,  40,  48,  48,  48,  56,  48,
 64,  48,  72,  48,  80,  48,  88,  48,  96,  48, 104,  48, 112,  48, 120,  48,
  0,  80,   8,  80,  16,  80,  24,  80,  32,  80,  40,  80,  48,  80,  56,  80,
 64,  80,  72,  80,  80,  80,  88,  80,  96,  80, 104,  80, 112,  80, 120,  80,
  0, 112,   8, 112,  16, 112,  24, 112,  32, 112,  40, 112,  48, 112,  56, 112,
 64, 112,  72, 112,  80, 112,  88, 112,  96, 112, 104, 112, 112, 112, 120, 112,
  0, 144,   8, 144,  16, 144,  24, 144,  32, 144,  40, 144,  48, 144,  56, 144,
 64, 144,  72, 144,  80, 144,  88, 144,  96, 144, 104, 144, 112, 144, 120, 144,
  0,  24,   8,  24,  16,  24,  24,  24,  32,  24,  40,  24,  48,  24,  56,  24,
 64,  24,  72,  24,  80,  24,  88,  24,  96,  24, 104,  24, 112,  24, 120,  24,
  0,  56,   8,  56,  16,  56,  24,  56,  32,  56,  40,  56,  48,  56,  56,  56,
 64,  56,  72,  56,  80,  56,  88,  56,  96,  56, 104,  56, 112,  56, 120,  56,
  0,  88,   8,  88,  16,  88,  24,  88,  32,  88,  40,  88,  48,  88,  56,  88,
 64,  88,  72,  88,  80,  88,  88,  88,  96,  88, 104,  88, 112,  88, 120,  88,
  0, 120,   8, 120,  16, 120,  24, 120,  32, 120,  40, 120,  48, 120,  56, 120,
 64, 120,  72, 120,  80, 120,  88, 120,  96, 120, 104, 120, 112, 120, 120, 120,
  0, 152,   8, 152,  16, 152,  24, 152,  32, 152,  40, 152,  48, 152,  56, 152,
 64, 152,  72, 152,  80, 152,  88, 152,  96, 152, 104, 152, 112, 152, 120, 152,
  0,   0,   0,   8,   0,  16,   0,  24,   0,  32,   0,  40,   0,  48,   0,  56,
  0,  64,   0,  72,   0,  80,   0,  88,   0,  96,   0, 104,   0, 112,   0, 120,
  0, 128,   0, 136,   0, 144,   0, 152,  32,   0,  32,   8,  32,  16,  32,  24,
 32,  32,  32,  40,  32,  48,  32,  56,  32,  64,  32,  72,  32,  80,  32,  88,
 32,  96,  32, 104,  32, 112,  32, 120,  32, 128,  32, 136,  32, 144,  32, 152,
 64,   0,  64,   8,  64,  16,  64,  24,  64,  32,  64,  40,  64,  48,  64,  56,
 64,  64,  64,  72,  64,  80,  64,  88,  64,  96,  64, 104,  64, 112,  64, 120,
 64, 128,  64, 136,  64, 144,  64, 152,  96,   0,  96,   8,  96,  16,  96,  24,
 96,  32,  96,  40,  96,  48,  96,  56,  96,  64,  96,  72,  96,  80,  96,  88,
 96,  96,  96, 104,  96, 112,  96, 120,  96, 128,  96, 136,  96, 144,  96, 152,
  8,   0,   8,   8,   8,  16,   8,  24,   8,  32,   8,  40,   8,  48,   8,  56,
  8,  64,   8,  72,   8,  80,   8,  88,   8,  96,   8, 104,   8, 112,   8, 120,
  8, 128,   8, 136,   8, 144,   8, 152,  40,   0,  40,   8,  40,  16,  40,  24,
 40,  32,  40,  40,  40,  48,  40,  56,  40,  64,  40,  72,  40,  80,  40,  88,
 40,  96,  40, 104,  40, 112,  40, 120,  40, 128,  40, 136,  40, 144,  40, 152,
 72,   0,  72,   8,  72,  16,  72,  24,  72,  32,  72,  40,  72,  48,  72,  56,
 72,  64,  72,  72,  72,  80,  72,  88,  72,  96,  72, 104,  72, 112,  72, 120,
 72, 128,  72, 136,  72, 144,  72, 152, 104,   0, 104,   8, 104,  16, 104,  24,
104,  32, 104,  40, 104,  48, 104,  56, 104,  64, 104,  72, 104,  80, 104,  88,
104,  96, 104, 104, 104, 112, 104, 120, 104, 128, 104, 136, 104, 144, 104, 152,
 16,   0,  16,   8,  16,  16,  16,  24,  16,  32,  16,  40,  16,  48,  16,  56,
 16,  64,  16,  72,  16,  80,  16,  88,  16,  96,  16, 104,  16, 112,  16, 120,
 16, 128,  16, 136,  16, 144,  16, 152,  48,   0,  48,   8,  48,  16,  48,  24,
 48,  32,  48,  40,  48,  48,  48,  56,  48,  64,  48,  72,  48,  80,  48,  88,
 48,  96,  48, 104,  48, 112,  48, 120,  48, 128,  48, 136,  48, 144,  48, 152,
 80,   0,  80,   8,  80,  16,  80,  24,  80,  32,  80,  40,  80,  48,  80,  56,
 80,  64,  80,  72,  80,  80,  80,  88,  80,  96,  80, 104,  80, 112,  80, 120,
 80, 128,  80, 136,  80, 144,  80, 152, 112,   0, 112,   8, 112,  16, 112,  24,
112,  32, 112,  40, 112,  48, 112,  56, 112,  64, 112,  72, 112,  80, 112,  88,
112,  96, 112, 104, 112, 112, 112, 120, 112, 128, 112, 136, 112, 144, 112, 152,
 24,   0,  24,   8,  24,  16,  24,  24,  24,  32,  24,  40,  24,  48,  24,  56,
 24,  64,  24,  72,  24,  80,  24,  88,  24,  96,  24, 104,  24, 112,  24, 120,
 24, 128,  24, 136,  24, 144,  24, 152,  56,   0,  56,   8,  56,  16,  56,  24,
 56,  32,  56,  40,  56,  48,  56,  56,  56,  64,  56,  72,  56,  80,  56,  88,
 56,  96,  56, 104,  56, 112,  56, 120,  56, 128,  56, 136,  56, 144,  56, 152,
 88,   0,  88,   8,  88,  16,  88,  24,  88,  32,  88,  40,  88,  48,  88,  56,
 88,  64,  88,  72,  88,  80,  88,  88,  88,  96,  88, 104,  88, 112,  88, 120,
 88, 128,  88, 136,  88, 144,  88, 152, 120,   0, 120,   8, 120,  16, 120,  24,
120,  32, 120,  40, 120,  48, 120,  56, 120,  64, 120,  72, 120,  80, 120,  88,
120,  96, 120, 104, 120, 112, 120, 120, 120, 128, 120, 136, 120, 144, 120, 152,
  0,   0,   8,   0,   0,   8,  16,   0,   8,   8,   0,  16,  24,   0,  16,   8,
  8,  16,   0,  24,  32,   0,  24,   8,  16,  16,   8,  24,   0,  32,  40,   0,
 32,   8,  24,  16,  16,  24,   8,  32,   0,  40,  48,   0,  40,   8,  32,  16,
 24,  24,  16,  32,   8,  40,   0,  48,  56,   0,  48,   8,  40,  16,  32,  24,
 24,  32,  16,  40,   8,  48,   0,  56,  64,   0,  56,   8,  48,  16,  40,  24,
 32,  32,  24,  40,  16,  48,   8,  56,   0,  64,  72,   0,  64,   8,  56,  16,
 48,  24,  40,  32,  32,  40,  24,  48,  16,  56,   8,  64,   0,  72,  80,   0,
 72,   8,  64,  16,  56,  24,  48,  32,  40,  40,  32,  48,  24,  56,  16,  64,
  8,  72,   0,  80,  88,   0,  80,   8,  72,  16,  64,  24,  56,  32,  48,  40,
 40,  48,  32,  56,  24,  64,  16,  72,   8,  80,   0,  88,  96,   0,  88,   8,
 80,  16,  72,  24,  64,  32,  56,  40,  48,  48,  40,  56,  32,  64,  24,  72,
 16,  80,   8,  88,   0,  96, 104,   0,  96,   8,  88,  16,  80,  24,  72,  32,
 64,  40,  56,  48,  48,  56,  40,  64,  32,  72,  24,  80,  16,  88,   8,  96,
  0, 104, 112,   0, 104,   8,  96,  16,  88,  24,  80,  32,  72,  40,  64,  48,
 56,  56,  48,  64,  40,  72,  32,  80,  24,  88,  16,  96,   8, 104,   0, 112,
120,   0, 112,   8, 104,  16,  96,  24,  88,  32,  80,  40,  72,  48,  64,  56,
 56,  64,  48,  72,  40,  80,  32,  88,  24,  96,  16, 104,   8, 112,   0, 120,
120,   8, 112,  16, 104,  24,  96,  32,  88,  40,  80,  48,  72,  56,  64,  64,
 56,  72,  48,  80,  40,  88,  32,  96,  24, 104,  16, 112,   8, 120, 120,  16,
112,  24, 104,  32,  96,  40,  88,  48,  80,  56,  72,  64,  64,  72,  56,  80,
 48,  88,  40,  96,  32, 104,  24, 112,  16, 120, 120,  24, 112,  32, 104,  40,
 96,  48,  88,  56,  80,  64,  72,  72,  64,  80,  56,  88,  48,  96,  40, 104,
 32, 112,  24, 120, 120,  32, 112,  40, 104,  48,  96,  56,  88,  64,  80,  72,
 72,  80,  64,  88,  56,  96,  48, 104,  40, 112,  32, 120, 120,  40, 112,  48,
104,  56,  96,  64,  88,  72,  80,  80,  72,  88,  64,  96,  56, 104,  48, 112,
 40, 120, 120,  48, 112,  56, 104,  64,  96,  72,  88,  80,  80,  88,  72,  96,
 64, 104,  56, 112,  48, 120, 120,  56, 112,  64, 104,  72,  96,  80,  88,  88,
 80,  96,  72, 104,  64, 112,  56, 120, 120,  64, 112,  72, 104,  80,  96,  88,
 88,  96,  80, 104,  72, 112,  64, 120, 120,  72, 112,  80, 104,  88,  96,  96,
 88, 104,  80, 112,  72, 120, 120,  80, 112,  88, 104,  96,  96, 104,  88, 112,
 80, 120, 120,  88, 112,  96, 104, 104,  96, 112,  88, 120, 120,  96, 112, 104,
104, 112,  96, 120, 120, 104, 112, 112, 104, 120, 120, 112, 112, 120, 120, 120,
 64,  56,  64,  64,  56,  64,  56,  56,  56,  48,  64,  48,  72,  48,  72,  56,
 72,  64,  72,  72,  64,  72,  56,  72,  48,  72,  48,  64,  48,  56,  48,  48,
 48,  40,  56,  40,  64,  40,  72,  40,  80,  40,  80,  48,  80,  56,  80,  64,
 80,  72,  80,  80,  72,  80,  64,  80,  56,  80,  48,  80,  40,  80,  40,  72,
 40,  64,  40,  56,  40,  48,  40,  40,  40,  32,  48,  32,  56,  32,  64,  32,
 72,  32,  80,  32,  88,  32,  88,  40,  88,  48,  88,  56,  88,  64,  88,  72,
 88,  80,  88,  88,  80,  88,  72,  88,  64,  88,  56,  88,  48,  88,  40,  88,
 32,  88,  32,  80,  32,  72,  32,  64,  32,  56,  32,  48,  32,  40,  32,  32,
 32,  24,  40,  24,  48,  24,  56,  24,  64,  24,  72,  24,  80,  24,  88,  24,
 96,  24,  96,  32,  96,  40,  96,  48,  96,  56,  96,  64,  96,  72,  96,  80,
 96,  88,  96,  96,  88,  96,  80,  96,  72,  96,  64,  96,  56,  96,  48,  96,
 40,  96,  32,  96,  24,  96,  24,  88,  24,  80,  24,  72,  24,  64,  24,  56,
 24,  48,  24,  40,  24,  32,  24,  24,  24,  16,  32,  16,  40,  16,  48,  16,
 56,  16,  64,  16,  72,  16,  80,  16,  88,  16,  96,  16, 104,  16, 104,  24,
104,  32, 104,  40, 104,  48, 104,  56, 104,  64, 104,  72, 104,  80, 104,  88,
104,  96, 104, 104,  96, 104,  88, 104,  80, 104,  72, 104,  64, 104,  56, 104,
 48, 104,  40, 104,  32, 104,  24, 104,  16, 104,  16,  96,  16,  88,  16,  80,
 16,  72,  16,  64,  16,  56,  16,  48,  16,  40,  16,  32,  16,  24,  16,  16,
 16,   8,  24,   8,  32,   8,  40,   8,  48,   8,  56,   8,  64,   8,  72,   8,
 80,   8,  88,   8,  96,   8, 104,   8, 112,   8, 112,  16, 112,  24, 112,  32,
112,  40, 112,  48, 112,  56, 112,  64, 112,  72, 112,  80, 112,  88, 112,  96,
112, 104, 112, 112, 104, 112,  96, 112,  88, 112,  80, 112,  72, 112,  64, 112,
 56, 112,  48, 112,  40, 112,  32, 112,  24, 112,  16, 112,   8, 112,   8, 104,
  8,  96,   8,  88,   8,  80,   8,  72,   8,  64,   8,  56,   8,  48,   8,  40,
  8,  32,   8,  24,   8,  16,   8,   8,   8,   0,  16,   0,  24,   0,  32,   0,
 40,   0,  48,   0,  56,   0,  64,   0,  72,   0,  80,   0,  88,   0,  96,   0,
104,   0, 112,   0, 120,   0, 120,   8, 120,  16, 120,  24, 120,  32, 120,  40,
120,  48, 120,  56, 120,  64, 120,  72, 120,  80, 120,  88, 120,  96, 120, 104,
120, 112, 120, 120, 112, 120, 104, 120,  96, 120,  88, 120,  80, 120,  72, 120,
 64, 120,  56, 120,  48, 120,  40, 120,  32, 120,  24, 120,  16, 120,   8, 120,
  0, 120,   0, 112,   0, 104,   0,  96,   0,  88,   0,  80,   0,  72,   0,  64,
  0,  56,   0,  48,   0,  40,   0,  32,   0,  24,   0,  16,   0,   8,   0,   0,
  0,   0,   8,   0,   0,   8,   8,   8,   0,  32,   8,  32,   0,  40,   8,  40,
  0,  64,   8,  64,   0,  72,   8,  72,   0,  96,   8,  96,   0, 104,   8, 104,
 16,  16,  24,  16,  16,  24,  24,  24,  16,  48,  24,  48,  16,  56,  24,  56,
 16,  80,  24,  80,  16,  88,  24,  88,  16, 112,  24, 112,  16, 120,  24, 120,
 32,   0,  40,   0,  32,   8,  40,   8,  32,  32,  40,  32,  32,  40,  40,  40,
 32,  64,  40,  64,  32,  72,  40,  72,  32,  96,  40,  96,  32, 104,  40, 104,
 48,  16,  56,  16,  48,  24,  56,  24,  48,  48,  56,  48,  48,  56,  56,  56,
 48,  80,  56,  80,  48,  88,  56,  88,  48, 112,  56, 112,  48, 120,  56, 120,
 64,   0,  72,   0,  64,   8,  72,   8,  64,  32,  72,  32,  64,  40,  72,  40,
 64,  64,  72,  64,  64,  72,  72,  72,  64,  96,  72,  96,  64, 104,  72, 104,
 80,  16,  88,  16,  80,  24,  88,  24,  80,  48,  88,  48,  80,  56,  88,  56,
 80,  80,  88,  80,  80,  88,  88,  88,  80, 112,  88, 112,  80, 120,  88, 120,
 96,   0, 104,   0,  96,   8, 104,   8,  96,  32, 104,  32,  96,  40, 104,  40,
 96,  64, 104,  64,  96,  72, 104,  72,  96,  96, 104,  96,  96, 104, 104, 104,
112,  16, 120,  16, 112,  24, 120,  24, 112,  48, 120,  48, 112,  56, 120,  56,
112,  80, 120,  80, 112,  88, 120,  88, 112, 112, 120, 112, 112, 120, 120, 120,
  0,  16,   8,  16,   0,  24,   8,  24,   0,  48,   8,  48,   0,  56,   8,  56,
  0,  80,   8,  80,   0,  88,   8,  88,   0, 112,   8, 112,   0, 120,   8, 120,
 16,   0,  24,   0,  16,   8,  24,   8,  16,  32,  24,  32,  16,  40,  24,  40,
 16,  64,  24,  64,  16,  72,  24,  72,  16,  96,  24,  96,  16, 104,  24, 104,
 32,  16,  40,  16,  32,  24,  40,  24,  32,  48,  40,  48,  32,  56,  40,  56,
 32,  80,  40,  80,  32,  88,  40,  88,  32, 112,  40, 112,  32, 120,  40, 120,
 48,   0,  56,   0,  48,   8,  56,   8,  48,  32,  56,  32,  48,  40,  56,  40,
 48,  64,  56,  64,  48,  72,  56,  72,  48,  96,  56,  96,  48, 104,  56, 104,
 64,  16,  72,  16,  64,  24,  72,  24,  64,  48,  72,  48,  64,  56,  72,  56,
 64,  80,  72,  80,  64,  88,  72,  88,  64, 112,  72, 112,  64, 120,  72, 120,
 80,   0,  88,   0,  80,   8,  88,   8,  80,  32,  88,  32,  80,  40,  88,  40,
 80,  64,  88,  64,  80,  72,  88,  72,  80,  96,  88,  96,  80, 104,  88, 104,
 96,  16, 104,  16,  96,  24, 104,  24,  96,  48, 104,  48,  96,  56, 104,  56,
 96,  80, 104,  80,  96,  88, 104,  88,  96, 112, 104, 112,  96, 120, 104, 120,
112,   0, 120,   0, 112,   8, 120,   8, 112,  32, 120,  32, 112,  40, 120,  40,
112,  64, 120,  64, 112,  72, 120,  72, 112,  96, 120,  96, 112, 104, 120, 104,
  8,  88,  96, 120,  56,  96,  32,  56,  96,  56, 104,   0,  96,  48,  16,   8,
 88,  64,   0,  32,  80, 104,  56,  16,  88,  72,   0,  80,  32,  72, 104,  96,
 80,   0,  16,  72, 112,  96,  40,  56,  48,  56, 120, 112,   0,  56,   0,  64,
 16,  48,  24,  32,  88, 112,  72, 120,   0,  72,   8,  80,  16,  16,  24,  48,
 48,  48,   8,  96, 112,   0,  24,  40, 120,  56,  56,   0,  80,  96,   8,  56,
 40,  16,  96,  16,  24, 104,  88,  88,   0,  24,  96, 104,  56, 120,   0,  40,
 40,  72, 104,  48,  72,  80,  16,   0,  96,  32,  16,  64,  64, 120,  64,  96,
112,  88,  88,  24, 120,  40,  32,   8,  80,  16,  32,  88,  40,  32,  96,   8,
  8,  32,   8,  16,  32, 104,  16,  88,  56,  88, 104,  16, 112,  64, 120,  96,
 88,  80,  64,  64,  16,  80,  24, 112, 120,  32,  32,  64, 104, 104,  96,  96,
 96, 112, 104,  32,  64,   8,  72,  64, 104,  72,  88,  16,  72, 112,  48, 112,
 64,  72,  40,  88,  16,  32,  64,  88, 112, 112,   8,  64,  80,  80,  24,   8,
  0,   0,  24,  16,  48,  80, 104,   8,  56,  48,  32,  96,   8, 104,  72,  72,
 24,  64, 104,  56,  64, 104, 120,  72,  56,  72,  88,  32,   8,  72,  72,  48,
112,  16,   8, 112,  40, 104,  56,  24,  56, 112,  80, 112, 104, 112,  48,  16,
 64,   0,  72,  40,  48,  88, 112,  56,   8,  40,  40,  40,  80,  56,   8,   8,
120,  48, 104,  40,  40,  24,  64,  56,  80,  48,   8,   0,  16, 120,   0, 112,
 16,  56,  32,  32,  72,  16,  24,  56, 112,  24,  80,  72,  48,  40,  16,  24,
 72,   0,  24,   0,  88, 104,  80, 120,  40, 120,  24, 120,  32,  80, 112,  48,
 80,  40,  32, 120,   0,  16,  56,  32,  64, 112,  88,  96,   0,   8,  32,  40,
120, 104,  80,  32,  56,  64, 112,  32,   0, 120,  64,  32,  56,  80,  88,  40,
  8,  24,  64,  16,  48,  96,  80,  64, 112, 120,  56, 104,  64,  48,  64,  40,
 72,  56,  96,   0,  16,  40,   8,  48, 104,  80,   0,  48,  48,   0, 112,  40,
 40,   8, 104, 120, 120,  16,  32, 112,  80,   8,  64,  24,  88, 120,  56,  56,
 72,   8,  88,  48,  48,  72,  24,  80,  48,  32,  48, 120,  72,  24, 120,  64,
 48,  64,  96,  72, 120,  80,  72,  88,   0, 104,  32,   0,  40,  96,  24,  24,
  8, 120,  16, 112, 120,  24, 112,  80, 104,  64,  80,  88,  56,  40,  72,  32,
104,  24,  40,  80,  24,  96,  32,  48, 104,  88,  24,  72,  48, 104,  56,   8,
 96,  24,  40, 112, 112,  72,  40,  48,  40,  64,  24,  88, 120,   0,  96,  88,
  0,  96,  96,  40,  16, 104,  96,  80,  48,   8,  88,   8,  96,  64,  64,  80,
 72, 104,   0,  88, 120,   8, 112,   8, 120,  88,  32,  24, 120, 120,  88,  56,
 48,  24,  40,   0, 112, 104,  88,   0,  72,  96,  80,  24,  32,  16,  16,  96,
  0,   0,   8,   0,  16,   0,  24,   0,  32,   0,  40,   0,  48,   0,  56,   0,
 64,   0,  72,   0,  80,   0,  88,   0,  96,   0, 104,   0, 112,   0, 120,   0,
  0,  32,   8,  32,  16,  32,  24,  32,  32,  32,  40,  32,  48,  32,  56,  32,
 64,  32,  72,  32,  80,  32,  88,  32,  96,  32, 104,  32, 112,  32, 120,  32,
  0,  64,   8,  64,  16,  64,  24,  64,  32,  64,  40,  64,  48,  64,  56,  64,
 64,  64,  72,  64,  80,  64,  88,  64,  96,  64, 104,  64, 112,  64, 120,  64,
  0,  96,   8,  96,  16,  96,  24,  96,  32,  96,  40,  96,  48,  96,  56,  96,
 64,  96,  72,  96,  80,  96,  88,  96,  96,  96, 104,  96, 112,  96, 120,  96,
  0,   8,   8,   8,  16,   8,  24,   8,  32,   8,  40,   8,  48,   8,  56,   8,
 64,   8,  72,   8,  80,   8,  88,   8,  96,   8, 104,   8, 112,   8, 120,   8,
  0,  40,   8,  40,  16,  40,  24,  40,  32,  40,  40,  40,  48,  40,  56,  40,
 64,  40,  72,  40,  80,  40,  88,  40,  96,  40, 104,  40, 112,  40, 120,  40,
  0,  72,   8,  72,  16,  72,  24,  72,  32,  72,  40,  72,  48,  72,  56,  72,
 64,  72,  72,  72,  80,  72,  88,  72,  96,  72, 104,  72, 112,  72, 120,  72,
  0, 104,   8, 104,  16, 104,  24, 104,  32, 104,  40, 104,  48, 104,  56, 104,
 64, 104,  72, 104,  80, 104,  88, 104,  96, 104, 104, 104, 112, 104, 120, 104,
  0,  16,   8,  16,  16,  16,  24,  16,  32,  16,  40,  16,  48,  16,  56,  16,
 64,  16,  72,  16,  80,  16,  88,  16,  96,  16, 104,  16, 112,  16, 120,  16,
  0,  48,   8,  48,  16,  48,  24,  48,  32,  48,  40,  48,  48,  48,  56,  48,
 64,  48,  72,  48,  80,  48,  88,  48,  96,  48, 104,  48, 112,  48, 120,  48,
  0,  80,   8,  80,  16,  80,  24,  80,  32,  80,  40,  80,  48,  80,  56,  80,
 64,  80,  72,  80,  80,  80,  88,  80,  96,  80, 104,  80, 112,  80, 120,  80,
  0, 112,   8, 112,  16, 112,  24, 112,  32, 112,  40, 112,  48, 112,  56, 112,
 64, 112,  72, 112,  80, 112,  88, 112,  96, 112, 104, 112, 112, 112, 120, 112,
  0,  24,   8,  24,  16,  24,  24,  24,  32,  24,  40,  24,  48,  24,  56,  24,
 64,  24,  72,  24,  80,  24,  88,  24,  96,  24, 104,  24, 112,  24, 120,  24,
  0,  56,   8,  56,  16,  56,  24,  56,  32,  56,  40,  56,  48,  56,  56,  56,
 64,  56,  72,  56,  80,  56,  88,  56,  96,  56, 104,  56, 112,  56, 120,  56,
  0,  88,   8,  88,  16,  88,  24,  88,  32,  88,  40,  88,  48,  88,  56,  88,
 64,  88,  72,  88,  80,  88,  88,  88,  96,  88, 104,  88, 112,  88, 120,  88,
  0, 120,   8, 120,  16, 120,  24, 120,  32, 120,  40, 120,  48, 120,  56, 120,
 64, 120,  72, 120,  80, 120,  88, 120,  96, 120, 104, 120, 112, 120, 120, 120,
  0,   0,   8,   0,   0,   8,  16,   0,   8,   8,   0,  16,  24,   0,  16,   8,
  8,  16,   0,  24,  32,   0,  24,   8,  16,  16,   8,  24,   0,  32,  40,   0,
 32,   8,  24,  16,  16,  24,   8,  32,   0,  40,  48,   0,  40,   8,  32,  16,
 24,  24,  16,  32,   8,  40,   0,  48,  56,   0,  48,   8,  40,  16,  32,  24,
 24,  32,  16,  40,   8,  48,   0,  56,  64,   0,  56,   8,  48,  16,  40,  24,
 32,  32,  24,  40,  16,  48,   8,  56,   0,  64,  72,   0,  64,   8,  56,  16,
 48,  24,  40,  32,  32,  40,  24,  48,  16,  56,   8,  64,   0,  72,  80,   0,
 72,   8,  64,  16,  56,  24,  48,  32,  40,  40,  32,  48,  24,  56,  16,  64,
  8,  72,   0,  80,  88,   0,  80,   8,  72,  16,  64,  24,  56,  32,  48,  40,
 40,  48,  32,  56,  24,  64,  16,  72,   8,  80,   0,  88,  96,   0,  88,   8,
 80,  16,  72,  24,  64,  32,  56,  40,  48,  48,  40,  56,  32,  64,  24,  72,
 16,  80,   8,  88,   0,  96, 104,   0,  96,   8,  88,  16,  80,  24,  72,  32,
 64,  40,  56,  48,  48,  56,  40,  64,  32,  72,  24,  80,  16,  88,   8,  96,
  0, 104, 112,   0, 104,   8,  96,  16,  88,  24,  80,  32,  72,  40,  64,  48,
 56,  56,  48,  64,  40,  72,  32,  80,  24,  88,  16,  96,   8, 104,   0, 112,
112,   8, 104,  16,  96,  24,  88,  32,  80,  40,  72,  48,  64,  56,  56,  64,
 48,  72,  40,  80,  32,  88,  24,  96,  16, 104,   8, 112,   0, 120, 112,  16,
104,  24,  96,  32,  88,  40,  80,  48,  72,  56,  64,  64,  56,  72,  48,  80,
 40,  88,  32,  96,  24, 104,  16, 112,   8, 120,   0, 128, 112,  24, 104,  32,
 96,  40,  88,  48,  80,  56,  72,  64,  64,  72,  56,  80,  48,  88,  40,  96,
 32, 104,  24, 112,  16, 120,   8, 128,   0, 136, 112,  32, 104,  40,  96,  48,
 88,  56,  80,  64,  72,  72,  64,  80,  56,  88,  48,  96,  40, 104,  32, 112,
 24, 120,  16, 128,   8, 136,   0, 144, 112,  40, 104,  48,  96,  56,  88,  64,
 80,  72,  72,  80,  64,  88,  56,  96,  48, 104,  40, 112,  32, 120,  24, 128,
 16, 136,   8, 144,   0, 152, 112,  48, 104,  56,  96,  64,  88,  72,  80,  80,
 72,  88,  64,  96,  56, 104,  48, 112,  40, 120,  32, 128,  24, 136,  16, 144,
  8, 152, 112,  56, 104,  64,  96,  72,  88,  80,  80,  88,  72,  96,  64, 104,
 56, 112,  48, 120,  40, 128,  32, 136,  24, 144,  16, 152, 112,  64, 104,  72,
 96,  80,  88,  88,  80,  96,  72, 104,  64, 112,  56, 120,  48, 128,  40, 136,
 32, 144,  24, 152, 112,  72, 104,  80,  96,  88,  88,  96,  80, 104,  72, 112,
 64, 120,  56, 128,  48, 136,  40, 144,  32, 152, 112,  80, 104,  88,  96,  96,
 88, 104,  80, 112,  72, 120,  64, 128,  56, 136,  48, 144,  40, 152, 112,  88,
104,  96,  96, 104,  88, 112,  80, 120,  72, 128,  64, 136,  56, 144,  48, 152,
112,  96, 104, 104,  96, 112,  88, 120,  80, 128,  72, 136,  64, 144,  56, 152,
112, 104, 104, 112,  96, 120,  88, 128,  80, 136,  72, 144,  64, 152, 112, 112,
104, 120,  96, 128,  88, 136,  80, 144,  72, 152, 112, 120, 104, 128,  96, 136,
 88, 144,  80, 152, 112, 128, 104, 136,  96, 144,  88, 152, 112, 136, 104, 144,
 96, 152, 112, 144, 104, 152, 112, 152,  56,  72,  56,  80,  48,  80,  48,  72,
 48,  64,  56,  64,  64,  64,  64,  72,  64,  80,  64,  88,  56,  88,  48,  88,
 40,  88,  40,  80,  40,  72,  40,  64,  40,  56,  48,  56,  56,  56,  64,  56,
 72,  56,  72,  64,  72,  72,  72,  80,  72,  88,  72,  96,  64,  96,  56,  96,
 48,  96,  40,  96,  32,  96,  32,  88,  32,  80,  32,  72,  32,  64,  32,  56,
 32,  48,  40,  48,  48,  48,  56,  48,  64,  48,  72,  48,  80,  48,  80,  56,
 80,  64,  80,  72,  80,  80,  80,  88,  80,  96,  80, 104,  72, 104,  64, 104,
 56, 104,  48, 104,  40, 104,  32, 104,  24, 104,  24,  96,  24,  88,  24,  80,
 24,  72,  24,  64,  24,  56,  24,  48,  24,  40,  32,  40,  40,  40,  48,  40,
 56,  40,  64,  40,  72,  40,  80,  40,  88,  40,  88,  48,  88,  56,  88,  64,
 88,  72,  88,  80,  88,  88,  88,  96,  88, 104,  88, 112,  80, 112,  72, 112,
 64, 112,  56, 112,  48, 112,  40, 112,  32, 112,  24, 112,  16, 112,  16, 104,
 16,  96,  16,  88,  16,  80,  16,  72,  16,  64,  16,  56,  16,  48,  16,  40,
 16,  32,  24,  32,  32,  32,  40,  32,  48,  32,  56,  32,  64,  32,  72,  32,
 80,  32,  88,  32,  96,  32,  96,  40,  96,  48,  96,  56,  96,  64,  96,  72,
 96,  80,  96,  88,  96,  96,  96, 104,  96, 112,  96, 120,  88, 120,  80, 120,
 72, 120,  64, 120,  56, 120,  48, 120,  40, 120,  32, 120,  24, 120,  16, 120,
  8, 120,   8, 112,   8, 104,   8,  96,   8,  88,   8,  80,   8,  72,   8,  64,
  8,  56,   8,  48,   8,  40,   8,  32,   8,  24,  16,  24,  24,  24,  32,  24,
 40,  24,  48,  24,  56,  24,  64,  24,  72,  24,  80,  24,  88,  24,  96,  24,
104,  24, 104,  32, 104,  40, 104,  48, 104,  56, 104,  64, 104,  72, 104,  80,
104,  88, 104,  96, 104, 104, 104, 112, 104, 120, 104, 128,  96, 128,  88, 128,
 80, 128,  72, 128,  64, 128,  56, 128,  48, 128,  40, 128,  32, 128,  24, 128,
 16, 128,   8, 128,   0, 128,   0, 120,   0, 112,   0, 104,   0,  96,   0,  88,
  0,  80,   0,  72,   0,  64,   0,  56,   0,  48,   0,  40,   0,  32,   0,  24,
  0,  16,   8,  16,  16,  16,  24,  16,  32,  16,  40,  16,  48,  16,  56,  16,
 64,  16,  72,  16,  80,  16,  88,  16,  96,  16, 104,  16, 112,  16, 112,  24,
112,  32, 112,  40, 112,  48, 112,  56, 112,  64, 112,  72, 112,  80, 112,  88,
112,  96, 112, 104, 112, 112, 112, 120, 112, 128, 112, 136, 104, 136,  96, 136,
 88, 136,  80, 136,  72, 136,  64, 136,  56, 136,  48, 136,  40, 136,  32, 136,
 24, 136,  16, 136,   8, 136,   0, 136,   0,   8,   8,   8,  16,   8,  24,   8,
 32,   8,  40,   8,  48,   8,  56,   8,  64,   8,  72,   8,  80,   8,  88,   8,
 96,   8, 104,   8, 112,   8, 112, 144, 104, 144,  96, 144,  88, 144,  80, 144,
 72, 144,  64, 144,  56, 144,  48, 144,  40, 144,  32, 144,  24, 144,  16, 144,
  8, 144,   0, 144,   0,   0,   8,   0,  16,   0,  24,   0,  32,   0,  40,   0,
 48,   0,  56,   0,  64,   0,  72,   0,  80,   0,  88,   0,  96,   0, 104,   0,
112,   0, 112, 152, 104, 152,  96, 152,  88, 152,  80, 152,  72, 152,  64, 152,
 56, 152,  48, 152,  40, 152,  32, 152,  24, 152,  16, 152,   8, 152,   0, 152,
  0,   0,   8,   0,  16,   0,   0,   8,   8,   8,  16,   8,   0,  32,   8,  32,
 16,  32,   0,  40,   8,  40,  16,  40,   0,  64,   8,  64,  16,  64,   0,  72,
  8,  72,  16,  72,   0,  96,   8,  96,  16,  96,   0, 104,   8, 104,  16, 104,
  0, 128,   8, 128,  16, 128,   0, 136,   8, 136,  16, 136,  24,  16,  32,  16,
 40,  16,  24,  24,  32,  24,  40,  24,  24,  48,  32,  48,  40,  48,  24,  56,
 32,  56,  40,  56,  24,  80,  32,  80,  40,  80,  24,  88,  32,  88,  40,  88,
 24, 112,  32, 112,  40, 112,  24, 120,  32, 120,  40, 120,  24, 144,  32, 144,
 40, 144,  24, 152,  32, 152,  40, 152,  48,   0,  56,   0,  64,   0,  48,   8,
 56,   8,  64,   8,  48,  32,  56,  32,  64,  32,  48,  40,  56,  40,  64,  40,
 48,  64,  56,  64,  64,  64,  48,  72,  56,  72,  64,  72,  48,  96,  56,  96,
 64,  96,  48, 104,  56, 104,  64, 104,  48, 128,  56, 128,  64, 128,  48, 136,
 56, 136,  64, 136,  72,  16,  80,  16,  88,  16,  72,  24,  80,  24,  88,  24,
 72,  48,  80,  48,  88,  48,  72,  56,  80,  56,  88,  56,  72,  80,  80,  80,
 88,  80,  72,  88,  80,  88,  88,  88,  72, 112,  80, 112,  88, 112,  72, 120,
 80, 120,  88, 120,  72, 144,  80, 144,  88, 144,  72, 152,  80, 152,  88, 152,
 96,   0, 104,   0, 112,   0,  96,   8, 104,   8, 112,   8,  96,  32, 104,  32,
112,  32,  96,  40, 104,  40, 112,  40,  96,  64, 104,  64, 112,  64,  96,  72,
104,  72, 112,  72,  96,  96, 104,  96, 112,  96,  96, 104, 104, 104, 112, 104,
 96, 128, 104, 128, 112, 128,  96, 136, 104, 136, 112, 136,   0,  16,   8,  16,
 16,  16,   0,  24,   8,  24,  16,  24,   0,  48,   8,  48,  16,  48,   0,  56,
  8,  56,  16,  56,   0,  80,   8,  80,  16,  80,   0,  88,   8,  88,  16,  88,
  0, 112,   8, 112,  16, 112,   0, 120,   8, 120,  16, 120,   0, 144,   8, 144,
 16, 144,   0, 152,   8, 152,  16, 152,  24,   0,  32,   0,  40,   0,  24,   8,
 32,   8,  40,   8,  24,  32,  32,  32,  40,  32,  24,  40,  32,  40,  40,  40,
 24,  64,  32,  64,  40,  64,  24,  72,  32,  72,  40,  72,  24,  96,  32,  96,
 40,  96,  24, 104,  32, 104,  40, 104,  24, 128,  32, 128,  40, 128,  24, 136,
 32, 136,  40, 136,  48,  16,  56,  16,  64,  16,  48,  24,  56,  24,  64,  24,
 48,  48,  56,  48,  64,  48,  48,  56,  56,  56,  64,  56,  48,  80,  56,  80,
 64,  80,  48,  88,  56,  88,  64,  88,  48, 112,  56, 112,  64, 112,  48, 120,
 56, 120,  64, 120,  48, 144,  56, 144,  64, 144,  48, 152,  56, 152,  64, 152,
 72,   0,  80,   0,  88,   0,  72,   8,  80,   8,  88,   8,  72,  32,  80,  32,
 88,  32,  72,  40,  80,  40,  88,  40,  72,  64,  80,  64,  88,  64,  72,  72,
 80,  72,  88,  72,  72,  96,  80,  96,  88,  96,  72, 104,  80, 104,  88, 104,
 72, 128,  80, 128,  88, 128,  72, 136,  80, 136,  88, 136,  96,  16, 104,  16,
112,  16,  96,  24, 104,  24, 112,  24,  96,  48, 104,  48, 112,  48,  96,  56,
104,  56, 112,  56,  96,  80, 104,  80, 112,  80,  96,  88, 104,  88, 112,  88,
 96, 112, 104, 112, 112, 112,  96, 120, 104, 120, 112, 120,  96, 144, 104, 144,
112, 144,  96, 152, 104, 152, 112, 152,  48, 152,  40, 128,   8,  16,  16,   0,
112, 112, 104,  72,  16, 144,  16,  88,  24, 144,  40,  80,  32,  64,  88, 136,
 48,  88,  32, 152, 104, 112,  16,  24,  88,  32, 104, 120,  80, 144,  96, 144,
104,  88,  40,  40,  80, 136,  16,   8,  80,  16, 104,  80,  16,  96,  88,  64,
 72, 104, 104, 128, 112, 144,  96,  88,   0,  16,  16, 136,  40,  64,  80, 104,
104,  24,   0,  56,  88, 120,  32,  16,  72,  40, 104,  32,  32,  72,  56, 152,
104, 152,  16,  16, 112,   0,  72,   8,  56, 136,  32,  88,  72,  56, 104, 144,
 80,  40,  96,  48,  72, 120,  32, 112,  32,  80,  64,  96, 104,  56,  64,  56,
 48,  32,  64,  88,  56,   8,   0,  80, 104,  16, 104, 136,  48, 112,  96,  24,
 24, 152,  32,  48,  88,  40,   0, 120,   8,  40,   0,  72,   0,   8, 112,  64,
 96,  80,  24,  80,  56,  80,   8,  24,  88,  56,  96,  64,  64,  24,  80, 128,
 80,   8,  16, 112,  88,   8,   8,  96,  24,  48,  88,  72,  48,  96, 112,   8,
 88, 144,   0,  64,   8, 104,  96, 112,  72,  88,   0, 128,  48,   0,  48,  24,
 88, 152,  64, 112,  72,  64,  72,  24,  96, 152,  32, 144,  56,  56,  64, 144,
 24, 136,  48,  16, 104,  96,  72,  72, 104,  48,  64, 136,   8, 144,  56,  48,
 24,  56,  96,  56,  96, 128,  24,   0,  72, 152,  80,  80,  64,  80,  96,   0,
 40, 152, 112,  32,  72,  32, 104,   0,  48, 120,   0, 152, 112,  72,  24, 120,
 96,  40, 112,  16,  48,  64,  56,  72,  80,  24,  64, 152,  56,  96,  56,  40,
 24,  40,  80,  64,  96,  16,  48,  80,   0,  96,  88,  16,  16, 152,  32,  96,
 16, 104,  24,  96,   8,  80,  80, 120,   8,   8,   0,  88, 112, 120,  24,  32,
 96,  72,  72,  48, 104,  64,  56,  32,   0, 144,  56, 144,   0,  40,  80,  72,
 64,   8,  56,  88,  72,  16,  56,  16,  40,  88,  48, 136,  48, 128,  40,   0,
  8, 120,  24, 104,  64,   0,  80, 152,  96,   8,  16, 128,  88, 112,  64, 120,
 32, 104,  24,  16,  40,  32, 104,   8,  16,  40,  64,  32,  32, 120,   8, 136,
 88,  88, 112,  80,   0, 104,  56,  24,  16,  32,  32, 128,  32,  24,  88,  24,
 16,  48,  80,   0,  72,  80,  72, 112,  64,  48,  40, 120,  64,  64,  24,  88,
 80,  32, 112, 104,  40, 112,  48,  48,  24,  24,  64,  40,  88,   0,  32,  40,
 56, 112,  48,  40,  96, 120,  40,   8,  32,   8,  40,  72,  32, 136,  72, 144,
  0, 136, 112, 152,  80,  48,   8,  72,   0,  48, 112,  96, 104,  40,   8, 152,
 56,  64,  40,  48,   0,  32,  32,  32,  40,  56,  80,  56,  32,   0,  88, 104,
 56,   0,  88, 128,  24, 128,  72, 136,   0,   0,   0,  24,  24,   8,   8,  32,
112, 128,  48, 104,  56, 104,  88,  96,  64,  16,  80,  88, 112,  24,  16,  80,
 96, 136, 112, 136,  72, 128,   8, 112,  48,  72,  32,  56,   8, 128,  96,  32,
 48,  56,  88,  48,  16,  72,  64, 128,  40, 144, 112,  88,  80, 112,   8,  48,
 40,  96,  16,  56,  64,  72,  80,  96, 112,  56,   8,  88,  40, 136,  56, 120,
  8,  56, 112,  48,  48,   8,  16,  64, 112,  40,  40, 104,  96,  96,  24,  64,
 40,  16,   8,   0,  72,   0,  48, 144,  56, 128,  24,  72,  64, 104,  88,  80,
 40,  24,  96, 104,   8,  64,  24, 112,  16, 120,  72,  96,   0, 112, 104, 104,
  0,   0,   8,   0,  16,   0,  24,   0,  32,   0,  40,   0,  48,   0,  56,   0,
 64,   0,  72,   0,  80,   0,  88,   0,  96,   0, 104,   0, 112,   0,   0,  32,
  8,  32,  16,  32,  24,  32,  32,  32,  40,  32,  48,  32,  56,  32,  64,  32,
 72,  32,  80,  32,  88,  32,  96,  32, 104,  32, 112,  32,   0,  64,   8,  64,
 16,  64,  24,  64,  32,  64,  40,  64,  48,  64,  56,  64,  64,  64,  72,  64,
 80,  64,  88,  64,  96,  64, 104,  64, 112,  64,   0,  96,   8,  96,  16,  96,
 24,  96,  32,  96,  40,  96,  48,  96,  56,  96,  64,  96,  72,  96,  80,  96,
 88,  96,  96,  96, 104,  96, 112,  96,   0, 128,   8, 128,  16, 128,  24, 128,
 32, 128,  40, 128,  48, 128,  56, 128,  64, 128,  72, 128,  80, 128,  88, 128,
 96, 128, 104, 128, 112, 128,   0,   8,   8,   8,  16,   8,  24,   8,  32,   8,
 40,   8,  48,   8,  56,   8,  64,   8,  72,   8,  80,   8,  88,   8,  96,   8,
104,   8, 112,   8,   0,  40,   8,  40,  16,  40,  24,  40,  32,  40,  40,  40,
 48,  40,  56,  40,  64,  40,  72,  40,  80,  40,  88,  40,  96,  40, 104,  40,
112,  40,   0,  72,   8,  72,  16,  72,  24,  72,  32,  72,  40,  72,  48,  72,
 56,  72,  64,  72,  72,  72,  80,  72,  88,  72,  96,  72, 104,  72, 112,  72,
  0, 104,   8, 104,  16, 104,  24, 104,  32, 104,  40, 104,  48, 104,  56, 104,
 64, 104,  72, 104,  80, 104,  88, 104,  96, 104, 104, 104, 112, 104,   0, 136,
  8, 136,  16, 136,  24, 136,  32, 136,  40, 136,  48, 136,  56, 136,  64, 136,
 72, 136,  80, 136,  88, 136,  96, 136, 104, 136, 112, 136,   0,  16,   8,  16,
 16,  16,  24,  16,  32,  16,  40,  16,  48,  16,  56,  16,  64,  16,  72,  16,
 80,  16,  88,  16,  96,  16, 104,  16, 112,  16,   0,  48,   8,  48,  16,  48,
 24,  48,  32,  48,  40,  48,  48,  48,  56,  48,  64,  48,  72,  48,  80,  48,
 88,  48,  96,  48, 104,  48, 112,  48,   0,  80,   8,  80,  16,  80,  24,  80,
 32,  80,  40,  80,  48,  80,  56,  80,  64,  80,  72,  80,  80,  80,  88,  80,
 96,  80, 104,  80, 112,  80,   0, 112,   8, 112,  16, 112,  24, 112,  32, 112,
 40, 112,  48, 112,  56, 112,  64, 112,  72, 112,  80, 112,  88, 112,  96, 112,
104, 112, 112, 112,   0, 144,   8, 144,  16, 144,  24, 144,  32, 144,  40, 144,
 48, 144,  56, 144,  64, 144,  72, 144,  80, 144,  88, 144,  96, 144, 104, 144,
112, 144,   0,  24,   8,  24,  16,  24,  24,  24,  32,  24,  40,  24,  48,  24,
 56,  24,  64,  24,  72,  24,  80,  24,  88,  24,  96,  24, 104,  24, 112,  24,
  0,  56,   8,  56,  16,  56,  24,  56,  32,  56,  40,  56,  48,  56,  56,  56,
 64,  56,  72,  56,  80,  56,  88,  56,  96,  56, 104,  56, 112,  56,   0,  88,
  8,  88,  16,  88,  24,  88,  32,  88,  40,  88,  48,  88,  56,  88,  64,  88,
 72,  88,  80,  88,  88,  88,  96,  88, 104,  88, 112,  88,   0, 120,   8, 120,
 16, 120,  24, 120,  32, 120,  40, 120,  48, 120,  56, 120,  64, 120,  72, 120,
 80, 120,  88, 120,  96, 120, 104, 120, 112, 120,   0, 152,   8, 152,  16, 152,
 24, 152,  32, 152,  40, 152,  48, 152,  56, 152,  64, 152,  72, 152,  80, 152,
 88, 152,  96, 152, 104, 152, 112, 152,   0,   0,   8,   0,   0,   8,  16,   0,
  8,   8,   0,  16,  24,   0,  16,   8,   8,  16,   0,  24,  32,   0,  24,   8,
 16,  16,   8,  24,   0,  32,  40,   0,  32,   8,  24,  16,  16,  24,   8,  32,
  0,  40,  48,   0,  40,   8,  32,  16,  24,  24,  16,  32,   8,  40,   0,  48,
 56,   0,  48,   8,  40,  16,  32,  24,  24,  32,  16,  40,   8,  48,   0,  56,
 64,   0,  56,   8,  48,  16,  40,  24,  32,  32,  24,  40,  16,  48,   8,  56,
 72,   0,  64,   8,  56,  16,  48,  24,  40,  32,  32,  40,  24,  48,  16,  56,
 80,   0,  72,   8,  64,  16,  56,  24,  48,  32,  40,  40,  32,  48,  24,  56,
 88,   0,  80,   8,  72,  16,  64,  24,  56,  32,  48,  40,  40,  48,  32,  56,
 88,   8,  80,  16,  72,  24,  64,  32,  56,  40,  48,  48,  40,  56,  88,  16,
 80,  24,  72,  32,  64,  40,  56,  48,  48,  56,  88,  24,  80,  32,  72,  40,
 64,  48,  56,  56,  88,  32,  80,  40,  72,  48,  64,  56,  88,  40,  80,  48,
 72,  56,  88,  48,  80,  56,  88,  56,  48,  24,  48,  32,  40,  32,  40,  24,
 40,  16,  48,  16,  56,  16,  56,  24,  56,  32,  56,  40,  48,  40,  40,  40,
 32,  40,  32,  32,  32,  24,  32,  16,  32,   8,  40,   8,  48,   8,  56,   8,
 64,   8,  64,  16,  64,  24,  64,  32,  64,  40,  64,  48,  56,  48,  48,  48,
 40,  48,  32,  48,  24,  48,  24,  40,  24,  32,  24,  24,  24,  16,  24,   8,
 24,   0,  32,   0,  40,   0,  48,   0,  56,   0,  64,   0,  72,   0,  72,   8,
 72,  16,  72,  24,  72,  32,  72,  40,  72,  48,  72,  56,  64,  56,  56,  56,
 48,  56,  40,  56,  32,  56,  24,  56,  16,  56,  16,  48,  16,  40,  16,  32,
 16,  24,  16,  16,  16,   8,  16,   0,  80,   0,  80,   8,  80,  16,  80,  24,
 80,  32,  80,  40,  80,  48,  80,  56,   8,  56,   8,  48,   8,  40,   8,  32,
  8,  24,   8,  16,   8,   8,   8,   0,  88,   0,  88,   8,  88,  16,  88,  24,
 88,  32,  88,  40,  88,  48,  88,  56,   0,  56,   0,  48,   0,  40,   0,  32,
  0,  24,   0,  16,   0,   8,   0,   0,   0,   0,   8,   0,   0,   8,   8,   8,
  0,  32,   8,  32,   0,  40,   8,  40,  16,  16,  24,  16,  16,  24,  24,  24,
 16,  48,  24,  48,  16,  56,  24,  56,  32,   0,  40,   0,  32,   8,  40,   8,
 32,  32,  40,  32,  32,  40,  40,  40,  48,  16,  56,  16,  48,  24,  56,  24,
 48,  48,  56,  48,  48,  56,  56,  56,  64,   0,  72,   0,  64,   8,  72,   8,
 64,  32,  72,  32,  64,  40,  72,  40,  80,  16,  88,  16,  80,  24,  88,  24,
 80,  48,  88,  48,  80,  56,  88,  56,   0,  16,   8,  16,   0,  24,   8,  24,
  0,  48,   8,  48,   0,  56,   8,  56,  16,   0,  24,   0,  16,   8,  24,   8,
 16,  32,  24,  32,  16,  40,  24,  40,  32,  16,  40,  16,  32,  24,  40,  24,
 32,  48,  40,  48,  32,  56,  40,  56,  48,   0,  56,   0,  48,   8,  56,   8,
 48,  32,  56,  32,  48,  40,  56,  40,  64,  16,  72,  16,  64,  24,  72,  24,
 64,  48,  72,  48,  64,  56,  72,  56,  80,   0,  88,   0,  80,   8,  88,   8,
 80,  32,  88,  32,  80,  40,  88,  40,  32,  56,  16,  40,  64,   8,  40,  40,
 24,  16,  72,  40,  48,  16,  48,   8,   0,   0,  48,  40,   0,  56,  72,  32,
 56,  24,  72,  24,  40,  48,  56,  32,   8,  56,  16,  48,  56,   0,  88,  48,
  0,  40,  32,  24,  72,  16,  72,  56,  16,  56,  16,   0,   0,  48,  16,  24,
 64,   0,  72,   8,  40,  32,  48,  48,   8,  24,  80,   0,  24,  32,  32,  16,
  0,  32,  24,  40,  72,   0,  48,  32,  80,  24,  88,  16,   8,   8,  48,  24,
 80,  32,  40,   8,  88,  32,  80,  56,  64,  24,  64,  48,  24,  56,  88,  24,
 80,  48,   8,  32,  24,  24,  72,  48,  16,  16,  16,   8,  16,  32,  40,   0,
  0,  16,  56,  48,  32,   8,  64,  40,  48,  56,   8,  48,  80,  16,  88,   8,
  0,   8,  56,   8,  32,  48,  88,  40,   8,  16,   8,  40,  88,  56,  24,   0,
 40,  56,  64,  56,  64,  16,  40,  16,  32,   0,  32,  32,  32,  40,  56,  40,
 24,   8,  88,   0,  40,  24,  80,   8,  56,  16,   0,  24,  24,  48,  56,  56,
 48,   0,  64,  32,  80,  40,   8,   0,   0,   0,   8,   0,  16,   0,  24,   0,
 32,   0,  40,   0,  48,   0,  56,   0,  64,   0,  72,   0,  80,   0,  88,   0,
  0,  32,   8,  32,  16,  32,  24,  32,  32,  32,  40,  32,  48,  32,  56,  32,
 64,  32,  72,  32,  80,  32,  88,  32,   0,   8,   8,   8,  16,   8,  24,   8,
 32,   8,  40,   8,  48,   8,  56,   8,  64,   8,  72,   8,  80,   8,  88,   8,
  0,  40,   8,  40,  16,  40,  24,  40,  32,  40,  40,  40,  48,  40,  56,  40,
 64,  40,  72,  40,  80,  40,  88,  40,   0,  16,   8,  16,  16,  16,  24,  16,
 32,  16,  40,  16,  48,  16,  56,  16,  64,  16,  72,  16,  80,  16,  88,  16,
  0,  48,   8,  48,  16,  48,  24,  48,  32,  48,  40,  48,  48,  48,  56,  48,
 64,  48,  72,  48,  80,  48,  88,  48,   0,  24,   8,  24,  16,  24,  24,  24,
 32,  24,  40,  24,  48,  24,  56,  24,  64,  24,  72,  24,  80,  24,  88,  24,
  0,  56,   8,  56,  16,  56,  24,  56,  32,  56,  40,  56,  48,  56,  56,  56,
 64,  56,  72,  56,  80,  56,  88,  56,
};
