/**
 * AUTO-GENERATED - DO NOT EDIT. Source: https://github.com/gpuweb/cts
 **/ import { assert, unreachable } from '../../../../../common/util/util.js';
import { GPUTest } from '../../../../gpu_test.js';
import { checkElementsEqualEither } from '../../../../util/check_contents.js';

export const kAllWriteOps = ['storage', 'b2b-copy', 't2b-copy', 'write-buffer'];

export const kAllReadOps = [
  'input-vertex',
  'input-index',
  'input-indirect',
  'input-indirect-index',
  'input-indirect-dispatch',

  'constant-uniform',

  'storage-read',

  'b2b-copy',
  'b2t-copy',
];

const kOpInfo = {
  'write-buffer': {
    contexts: ['queue'],
  },
  'b2t-copy': {
    contexts: ['command-encoder'],
  },
  'b2b-copy': {
    contexts: ['command-encoder'],
  },
  't2b-copy': {
    contexts: ['command-encoder'],
  },
  storage: {
    contexts: ['compute-pass-encoder', 'render-pass-encoder', 'render-bundle-encoder'],
  },
  'storage-read': {
    contexts: ['compute-pass-encoder', 'render-pass-encoder', 'render-bundle-encoder'],
  },
  'input-vertex': {
    contexts: ['render-pass-encoder', 'render-bundle-encoder'],
  },
  'input-index': {
    contexts: ['render-pass-encoder', 'render-bundle-encoder'],
  },
  'input-indirect': {
    contexts: ['render-pass-encoder', 'render-bundle-encoder'],
  },
  'input-indirect-index': {
    contexts: ['render-pass-encoder', 'render-bundle-encoder'],
  },
  'input-indirect-dispatch': {
    contexts: ['compute-pass-encoder'],
  },
  'constant-uniform': {
    contexts: ['render-pass-encoder', 'render-bundle-encoder'],
  },
};

export function checkOpsValidForContext(ops, context) {
  const valid =
    kOpInfo[ops[0]].contexts.includes(context[0]) && kOpInfo[ops[1]].contexts.includes(context[1]);
  if (!valid) return false;

  if (
    context[0] === 'render-bundle-encoder' ||
    context[0] === 'render-pass-encoder' ||
    context[1] === 'render-bundle-encoder' ||
    context[1] === 'render-pass-encoder'
  ) {
    // In a render pass, it is invalid to use a resource as both writable and another usage.
    // Also, for storage+storage usage, the application is opting into racy behavior.
    // The storage+storage case is also skipped as the results cannot be reliably tested.
    const checkImpl = (op1, op2) => {
      switch (op1) {
        case 'storage':
          switch (op2) {
            case 'storage':
            case 'storage-read':
            case 'input-vertex':
            case 'input-index':
            case 'input-indirect':
            case 'input-indirect-index':
            case 'constant-uniform':
              // Write+other, or racy.
              return false;
            case 'b2t-copy':
            case 't2b-copy':
            case 'b2b-copy':
            case 'write-buffer':
              // These don't occur in a render pass.
              return true;
          }

          break;
        case 'input-vertex':
        case 'input-index':
        case 'input-indirect':
        case 'input-indirect-index':
        case 'constant-uniform':
        case 'b2t-copy':
        case 't2b-copy':
        case 'b2b-copy':
        case 'write-buffer':
          // These are not write usages, or don't occur in a render pass.
          break;
      }

      return true;
    };
    return checkImpl(ops[0], ops[1]) && checkImpl(ops[1], ops[0]);
  }
  return true;
}

const kDummyVertexShader = `
@vertex fn vert_main() -> @builtin(position) vec4<f32> {
  return vec4<f32>(0.5, 0.5, 0.0, 1.0);
}
`;

// Note: If it would be useful to have any of these helpers be separate from the fixture,
// they can be refactored into standalone functions.
export class BufferSyncTest extends GPUTest {
  // Vertex and index buffers used in read render pass

  // Temp buffer and texture with values for buffer/texture copy write op
  // There can be at most 2 write op
  tmpValueBuffers = [undefined, undefined];
  tmpValueTextures = [undefined, undefined];

  // These intermediate buffers/textures are created before any read/write op
  // to avoid extra memory synchronization between ops introduced by await on buffer/