/* tracker-needle.c generated by valac 0.30.0, the Vala compiler
 * generated from tracker-needle.vala, do not modify */

/**/
/* Copyright 2010, Martyn Russell <martyn@lanedo.com>*/
/**/
/* This program is free software; you can redistribute it and/or*/
/* modify it under the terms of the GNU General Public License*/
/* as published by the Free Software Foundation; either version 2*/
/* of the License, or (at your option) any later version.*/
/**/
/* This program is distributed in the hope that it will be useful,*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/* GNU General Public License for more details.*/
/**/
/* You should have received a copy of the GNU General Public License*/
/* along with this program; if not, write to the Free Software*/
/* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA*/
/* 02110-1301, USA.*/
/**/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <atk/atk.h>
#include "config.h"
#include <gobject/gvaluecollector.h>


#define TRACKER_TYPE_NEEDLE (tracker_needle_get_type ())
#define TRACKER_NEEDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_NEEDLE, TrackerNeedle))
#define TRACKER_NEEDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_NEEDLE, TrackerNeedleClass))
#define TRACKER_IS_NEEDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_NEEDLE))
#define TRACKER_IS_NEEDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_NEEDLE))
#define TRACKER_NEEDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_NEEDLE, TrackerNeedleClass))

typedef struct _TrackerNeedle TrackerNeedle;
typedef struct _TrackerNeedleClass TrackerNeedleClass;
typedef struct _TrackerNeedlePrivate TrackerNeedlePrivate;

#define TRACKER_TYPE_HISTORY (tracker_history_get_type ())
#define TRACKER_HISTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_HISTORY, TrackerHistory))
#define TRACKER_HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_HISTORY, TrackerHistoryClass))
#define TRACKER_IS_HISTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_HISTORY))
#define TRACKER_IS_HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_HISTORY))
#define TRACKER_HISTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_HISTORY, TrackerHistoryClass))

typedef struct _TrackerHistory TrackerHistory;
typedef struct _TrackerHistoryClass TrackerHistoryClass;

#define TRACKER_TYPE_VIEW (tracker_view_get_type ())
#define TRACKER_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_VIEW, TrackerView))
#define TRACKER_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_VIEW, TrackerViewClass))
#define TRACKER_IS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_VIEW))
#define TRACKER_IS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_VIEW))
#define TRACKER_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_VIEW, TrackerViewClass))

typedef struct _TrackerView TrackerView;
typedef struct _TrackerViewClass TrackerViewClass;

#define TYPE_TRACKER_TAGS_VIEW (tracker_tags_view_get_type ())
#define TRACKER_TAGS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRACKER_TAGS_VIEW, TrackerTagsView))
#define TRACKER_TAGS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRACKER_TAGS_VIEW, TrackerTagsViewClass))
#define IS_TRACKER_TAGS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRACKER_TAGS_VIEW))
#define IS_TRACKER_TAGS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRACKER_TAGS_VIEW))
#define TRACKER_TAGS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRACKER_TAGS_VIEW, TrackerTagsViewClass))

typedef struct _TrackerTagsView TrackerTagsView;
typedef struct _TrackerTagsViewClass TrackerTagsViewClass;

#define TRACKER_TYPE_RESULT_STORE (tracker_result_store_get_type ())
#define TRACKER_RESULT_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_RESULT_STORE, TrackerResultStore))
#define TRACKER_RESULT_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_RESULT_STORE, TrackerResultStoreClass))
#define TRACKER_IS_RESULT_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_RESULT_STORE))
#define TRACKER_IS_RESULT_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_RESULT_STORE))
#define TRACKER_RESULT_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_RESULT_STORE, TrackerResultStoreClass))

typedef struct _TrackerResultStore TrackerResultStore;
typedef struct _TrackerResultStoreClass TrackerResultStoreClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _tracker_history_unref0(var) ((var == NULL) ? NULL : (var = (tracker_history_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TRACKER_QUERY_TYPE_TYPE (tracker_query_type_get_type ())

#define TRACKER_QUERY_TYPE_MATCH (tracker_query_match_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TRACKER_VIEW_TYPE_DISPLAY (tracker_view_display_get_type ())
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define __g_list_free__gtk_tree_path_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gtk_tree_path_free0_ (var), NULL)))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
typedef struct _Block4Data Block4Data;
#define _tracker_needle_unref0(var) ((var == NULL) ? NULL : (var = (tracker_needle_unref (var), NULL)))

#define TRACKER_TYPE_STATS (tracker_stats_get_type ())
#define TRACKER_STATS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_STATS, TrackerStats))
#define TRACKER_STATS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_STATS, TrackerStatsClass))
#define TRACKER_IS_STATS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_STATS))
#define TRACKER_IS_STATS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_STATS))
#define TRACKER_STATS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_STATS, TrackerStatsClass))

typedef struct _TrackerStats TrackerStats;
typedef struct _TrackerStatsClass TrackerStatsClass;
typedef struct _TrackerParamSpecNeedle TrackerParamSpecNeedle;
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

struct _TrackerNeedle {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerNeedlePrivate * priv;
};

struct _TrackerNeedleClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerNeedle *self);
};

struct _TrackerNeedlePrivate {
	GSettings* settings_needle;
	TrackerHistory* history;
	GtkWindow* window;
	GtkToggleToolButton* view_categories;
	GtkToggleToolButton* view_filelist;
	GtkToggleToolButton* view_icons;
	GtkSeparatorToolItem* separator_secondary;
	GtkToggleToolButton* find_in_contents;
	GtkToggleToolButton* find_in_titles;
	GtkToggleToolButton* find_in_tags;
	GtkToggleToolButton* find_in_all;
	GtkToolItem* search_entry;
	GtkComboBox* search_list;
	GtkEntry* search;
	GtkSpinner* spinner;
	GtkToolItem* spinner_shell;
	GtkToggleToolButton* show_tags;
	GtkToolButton* show_stats;
	GtkBox* view;
	TrackerView* sw_noresults;
	TrackerView* sw_categories;
	TrackerView* sw_filelist;
	TrackerView* sw_icons;
	GtkInfoBar* info_bar;
	GtkLabel* info_bar_label;
	TrackerTagsView* tags_view;
	guint last_search_id;
	gint size_small;
	gint size_medium;
	gint size_big;
	guint limit;
	gint default_view;
	GtkWidget* current_view;
	TrackerResultStore* categories_model;
	TrackerResultStore* files_model;
	TrackerResultStore* files_in_tags_model;
	TrackerResultStore* files_in_title_model;
	TrackerResultStore* images_model;
	TrackerResultStore* images_in_title_model;
};

typedef enum  {
	TRACKER_QUERY_TYPE_ALL,
	TRACKER_QUERY_TYPE_CONTACTS,
	TRACKER_QUERY_TYPE_APPLICATIONS,
	TRACKER_QUERY_TYPE_MUSIC,
	TRACKER_QUERY_TYPE_IMAGES,
	TRACKER_QUERY_TYPE_VIDEOS,
	TRACKER_QUERY_TYPE_DOCUMENTS,
	TRACKER_QUERY_TYPE_MAIL,
	TRACKER_QUERY_TYPE_CALENDAR,
	TRACKER_QUERY_TYPE_FOLDERS,
	TRACKER_QUERY_TYPE_BOOKMARKS
} TrackerQueryType;

typedef enum  {
	TRACKER_QUERY_MATCH_NONE,
	TRACKER_QUERY_MATCH_FTS,
	TRACKER_QUERY_MATCH_FTS_INDIRECT,
	TRACKER_QUERY_MATCH_TITLES,
	TRACKER_QUERY_MATCH_TITLES_INDIRECT,
	TRACKER_QUERY_MATCH_TAGS_ONLY,
	TRACKER_QUERY_MATCH_TAGS_ONLY_INDIRECT
} TrackerQueryMatch;

typedef enum  {
	TRACKER_VIEW_DISPLAY_NO_RESULTS,
	TRACKER_VIEW_DISPLAY_CATEGORIES,
	TRACKER_VIEW_DISPLAY_FILE_LIST,
	TRACKER_VIEW_DISPLAY_FILE_ICONS
} TrackerViewDisplay;

struct _Block4Data {
	int _ref_count_;
	TrackerNeedle* self;
	GtkTreeModel* model;
	GList* uris;
};

struct _TrackerParamSpecNeedle {
	GParamSpec parent_instance;
};


static gpointer tracker_needle_parent_class = NULL;
static gboolean tracker_needle_current_find_in_filelist;
static gboolean tracker_needle_current_find_in_filelist = TRUE;
static gboolean tracker_needle_current_find_in_icons;
static gboolean tracker_needle_current_find_in_icons = TRUE;
extern gboolean print_version;
gboolean print_version = FALSE;
extern gchar** search_criteria;
gchar** search_criteria = NULL;

gpointer tracker_needle_ref (gpointer instance);
void tracker_needle_unref (gpointer instance);
GParamSpec* tracker_param_spec_needle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void tracker_value_set_needle (GValue* value, gpointer v_object);
void tracker_value_take_needle (GValue* value, gpointer v_object);
gpointer tracker_value_get_needle (const GValue* value);
GType tracker_needle_get_type (void) G_GNUC_CONST;
gpointer tracker_history_ref (gpointer instance);
void tracker_history_unref (gpointer instance);
GParamSpec* tracker_param_spec_history (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void tracker_value_set_history (GValue* value, gpointer v_object);
void tracker_value_take_history (GValue* value, gpointer v_object);
gpointer tracker_value_get_history (const GValue* value);
GType tracker_history_get_type (void) G_GNUC_CONST;
GType tracker_view_get_type (void) G_GNUC_CONST;
GType tracker_tags_view_get_type (void) G_GNUC_CONST;
GType tracker_result_store_get_type (void) G_GNUC_CONST;
#define TRACKER_NEEDLE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_TYPE_NEEDLE, TrackerNeedlePrivate))
enum  {
	TRACKER_NEEDLE_DUMMY_PROPERTY
};
#define TRACKER_NEEDLE_UI_FILE "tracker-needle.ui"
static void tracker_needle_result_overflow (TrackerNeedle* self);
void tracker_needle_show_info_message (TrackerNeedle* self, const gchar* message, GtkMessageType type);
static void tracker_needle_create_models (TrackerNeedle* self);
TrackerResultStore* tracker_result_store_new (gint _n_columns);
TrackerResultStore* tracker_result_store_construct (GType object_type, gint _n_columns);
void tracker_result_store_set_limit (TrackerResultStore* self, guint value);
static void _tracker_needle_result_overflow_tracker_result_store_result_overflow (TrackerResultStore* _sender, gpointer self);
GType tracker_query_type_get_type (void) G_GNUC_CONST;
GType tracker_query_match_get_type (void) G_GNUC_CONST;
void tracker_result_store_add_query (TrackerResultStore* self, TrackerQueryType type, TrackerQueryMatch match, ...);
void tracker_result_store_set_icon_size (TrackerResultStore* self, gint value);
TrackerNeedle* tracker_needle_new (void);
TrackerNeedle* tracker_needle_construct (GType object_type);
TrackerHistory* tracker_history_new (void);
TrackerHistory* tracker_history_construct (GType object_type);
static void __lambda8_ (TrackerNeedle* self, const gchar* key);
static void ___lambda8__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
void tracker_needle_show (TrackerNeedle* self);
static void tracker_needle_setup_ui (TrackerNeedle* self);
void tracker_needle_set_search (TrackerNeedle* self, gchar** args, int args_length1);
static void tracker_needle_store_state_changed (TrackerNeedle* self, GObject* object, GParamSpec* p);
gboolean tracker_result_store_get_active (TrackerResultStore* self);
static void tracker_needle_window_closed (TrackerNeedle* self);
static void _tracker_needle_window_closed_gtk_widget_destroy (GtkWidget* _sender, gpointer self);
static gboolean tracker_needle_window_key_press_event (TrackerNeedle* self, GtkWidget* widget, GdkEventKey* event);
static gboolean _tracker_needle_window_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void tracker_needle_info_bar_closed (TrackerNeedle* self, GtkButton* source);
static void _tracker_needle_info_bar_closed_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void tracker_needle_view_toggled (TrackerNeedle* self);
static void _tracker_needle_view_toggled_gtk_toggle_tool_button_toggled (GtkToggleToolButton* _sender, gpointer self);
static void tracker_needle_find_in_toggled (TrackerNeedle* self);
static void _tracker_needle_find_in_toggled_gtk_toggle_tool_button_toggled (GtkToggleToolButton* _sender, gpointer self);
static void tracker_needle_search_changed (TrackerNeedle* self, GtkEditable* editable);
static void _tracker_needle_search_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void tracker_needle_search_activated (TrackerNeedle* self, GtkEntry* entry);
static void _tracker_needle_search_activated_gtk_entry_activate (GtkEntry* _sender, gpointer self);
static gboolean tracker_needle_search_key_press_event (TrackerNeedle* self, GtkWidget* widget, GdkEventKey* event);
static gboolean _tracker_needle_search_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void tracker_needle_search_history_insert (TrackerNeedle* self, gchar** history, int history_length1);
gchar** tracker_history_get (TrackerHistory* self, int* result_length1);
static void tracker_needle_show_tags_clicked (TrackerNeedle* self);
static void _tracker_needle_show_tags_clicked_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void tracker_needle_show_stats_clicked (TrackerNeedle* self);
static void _tracker_needle_show_stats_clicked_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
GType tracker_view_display_get_type (void) G_GNUC_CONST;
TrackerView* tracker_view_new (TrackerViewDisplay* _display, TrackerResultStore* store);
TrackerView* tracker_view_construct (GType object_type, TrackerViewDisplay* _display, TrackerResultStore* store);
TrackerResultStore* tracker_view_get_store (TrackerView* self);
static void _tracker_needle_store_state_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void tracker_needle_view_row_activated (TrackerNeedle* self, GtkTreeView* view, GtkTreePath* path, GtkTreeViewColumn* column);
static void _tracker_needle_view_row_activated_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self);
static void tracker_needle_view_row_selected (TrackerNeedle* self, GtkTreeSelection* selection);
static void _tracker_needle_view_row_selected_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static void tracker_needle_icon_item_activated (TrackerNeedle* self, GtkIconView* view, GtkTreePath* path);
static void _tracker_needle_icon_item_activated_gtk_icon_view_item_activated (GtkIconView* _sender, GtkTreePath* path, gpointer self);
static void tracker_needle_icon_view_selection_changed (TrackerNeedle* self);
static void _tracker_needle_icon_view_selection_changed_gtk_icon_view_selection_changed (GtkIconView* _sender, gpointer self);
TrackerTagsView* tracker_tags_view_new (GList* _files);
TrackerTagsView* tracker_tags_view_construct (GType object_type, GList* _files);
void tracker_tags_view_hide_label (TrackerTagsView* self);
static gboolean tracker_needle_search_run (TrackerNeedle* self);
static gboolean _tracker_needle_search_run_gsource_func (gpointer self);
static void tracker_needle_search_finished (TrackerNeedle* self, TrackerResultStore* store);
gboolean tracker_result_store_has_results (TrackerResultStore* self);
static GtkTreeIter* tracker_needle_search_history_find_or_insert (TrackerNeedle* self, const gchar* criteria, gboolean* add_to_model);
static GtkTreeIter* _gtk_tree_iter_dup (GtkTreeIter* self);
void tracker_history_add (TrackerHistory* self, const gchar* criteria);
void tracker_view_set_store (TrackerView* self, TrackerResultStore* value);
static GPtrArray* tracker_needle_search_tags (TrackerNeedle* self);
void tracker_result_store_set_search_tags (TrackerResultStore* self, GPtrArray* value);
GPtrArray* tracker_result_store_get_search_tags (TrackerResultStore* self);
void tracker_result_store_set_search_term (TrackerResultStore* self, const gchar* value);
void tracker_model_launch_selected (GtkTreeModel* model, GtkTreePath* path, gint col);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
static void _gtk_tree_path_free0_ (gpointer var);
static void _g_list_free__gtk_tree_path_free0_ (GList* self);
void tracker_tags_view_set_files (TrackerTagsView* self, GList* _files);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda9_ (Block4Data* _data4_, GtkIconView* iconview, GtkTreePath* path);
static void ___lambda9__gtk_icon_view_foreach_func (GtkIconView* icon_view, GtkTreePath* path, gpointer self);
GType tracker_stats_get_type (void) G_GNUC_CONST;
TrackerStats* tracker_stats_new (void);
TrackerStats* tracker_stats_construct (GType object_type);
static void tracker_needle_finalize (TrackerNeedle* obj);
gint _vala_main (gchar** args, int args_length1);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

const GOptionEntry options[3] = {{"version", 'V', 0, G_OPTION_ARG_NONE, &print_version, "Print version", NULL}, {"", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &search_criteria, "[SEARCH-CRITERIA]", "[SEARCH-CRITERIA]"}, {NULL}};

static void tracker_needle_result_overflow (TrackerNeedle* self) {
	gchar* str = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 74 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (self != NULL);
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = _ ("Search criteria was too generic");
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp1_ = _ ("Only the first 500 items will be displayed");
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp2_ = g_strdup_printf ("%s\n<small>%s</small>", _tmp0_, _tmp1_);
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	str = _tmp2_;
#line 77 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_needle_show_info_message (self, str, GTK_MESSAGE_INFO);
#line 74 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_free0 (str);
#line 356 "tracker-needle.c"
}


static void _tracker_needle_result_overflow_tracker_result_store_result_overflow (TrackerResultStore* _sender, gpointer self) {
#line 84 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_needle_result_overflow ((TrackerNeedle*) self);
#line 363 "tracker-needle.c"
}


static void tracker_needle_create_models (TrackerNeedle* self) {
	TrackerResultStore* _tmp0_ = NULL;
	TrackerResultStore* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	TrackerResultStore* _tmp3_ = NULL;
	TrackerResultStore* _tmp4_ = NULL;
	TrackerResultStore* _tmp5_ = NULL;
	TrackerResultStore* _tmp6_ = NULL;
	TrackerResultStore* _tmp7_ = NULL;
	TrackerResultStore* _tmp8_ = NULL;
	TrackerResultStore* _tmp9_ = NULL;
	TrackerResultStore* _tmp10_ = NULL;
	TrackerResultStore* _tmp11_ = NULL;
	TrackerResultStore* _tmp12_ = NULL;
	TrackerResultStore* _tmp13_ = NULL;
	guint _tmp14_ = 0U;
	TrackerResultStore* _tmp15_ = NULL;
	TrackerResultStore* _tmp16_ = NULL;
	TrackerResultStore* _tmp17_ = NULL;
	TrackerResultStore* _tmp18_ = NULL;
	guint _tmp19_ = 0U;
	TrackerResultStore* _tmp20_ = NULL;
	TrackerResultStore* _tmp21_ = NULL;
	TrackerResultStore* _tmp22_ = NULL;
	TrackerResultStore* _tmp23_ = NULL;
	guint _tmp24_ = 0U;
	TrackerResultStore* _tmp25_ = NULL;
	TrackerResultStore* _tmp26_ = NULL;
	TrackerResultStore* _tmp27_ = NULL;
	TrackerResultStore* _tmp28_ = NULL;
	guint _tmp29_ = 0U;
	TrackerResultStore* _tmp30_ = NULL;
	TrackerResultStore* _tmp31_ = NULL;
	TrackerResultStore* _tmp32_ = NULL;
	TrackerResultStore* _tmp33_ = NULL;
	TrackerResultStore* _tmp34_ = NULL;
	guint _tmp35_ = 0U;
	TrackerResultStore* _tmp36_ = NULL;
	TrackerResultStore* _tmp37_ = NULL;
	TrackerResultStore* _tmp38_ = NULL;
#line 80 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (self != NULL);
#line 82 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = tracker_result_store_new (6);
#line 82 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->categories_model);
#line 82 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->categories_model = _tmp0_;
#line 83 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp1_ = self->priv->categories_model;
#line 83 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp2_ = self->priv->limit;
#line 83 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_result_store_set_limit (_tmp1_, _tmp2_);
#line 84 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp3_ = self->priv->categories_model;
#line 84 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect (_tmp3_, "result-overflow", (GCallback) _tracker_needle_result_overflow_tracker_result_store_result_overflow, self);
#line 85 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp4_ = self->priv->categories_model;
#line 85 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_result_store_add_query (_tmp4_, TRACKER_QUERY_TYPE_APPLICATIONS, TRACKER_QUERY_MATCH_FTS, "?urn", "tracker:coalesce(nfo:softwareCmdLine(?urn), ?urn)", "tracker:coalesce(nie:title(?urn), nfo:fileName(?urn))", "nie:comment(?urn)", "\"\"", "\"\"", NULL);
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp5_ = self->priv->categories_model;
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_result_store_add_query (_tmp5_, TRACKER_QUERY_TYPE_IMAGES, TRACKER_QUERY_MATCH_FTS, "?urn", "nie:url(?urn)", "tracker:coalesce(nie:title(?urn), nfo:fileName(?urn))", "fn:string-join((nfo:height(?urn), nfo:width(?urn)), \" x \")", "nfo:fileSize(?urn)", "nie:url(?urn)", NULL);
#line 102 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp6_ = self->priv->categories_model;
#line 102 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_result_store_add_query (_tmp6_, TRACKER_QUERY_TYPE_MUSIC, TRACKER_QUERY_MATCH_FTS_INDIRECT, "?urn", "nie:url(?urn)", "tracker:coalesce(nie:title(?urn), nfo:fileName(?urn))", "fn:string-join((?performer, ?album), \" - \")", "nfo:duration(?urn)", "nie:url(?urn)", NULL);
#line 110 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp7_ = self->priv->categories_model;
#line 110 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_result_store_add_query (_tmp7_, TRACKER_QUERY_TYPE_VIDEOS, TRACKER_QUERY_MATCH_FTS, "?urn", "nie:url(?urn)", "tracker:coalesce(fts:snippet(?urn),nie:title(?urn), nfo:fileName(?urn)" \
")", "\"\"", "nfo:duration(?urn)", "nie:url(?urn)", NULL);
#line 118 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp8_ = self->priv->categories_model;
#line 118 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_result_store_add_query (_tmp8_, TRACKER_QUERY_TYPE_DOCUMENTS, TRACKER_QUERY_MATCH_FTS_INDIRECT, "?urn", "nie:url(?urn)", "tracker:coalesce(nie:title(?urn), nfo:fileName(?urn))", "tracker:coalesce(fts:snippet(?urn),nco:fullname(?creator), nco:fullnam" \
"e(?publisher))", "nfo:pageCount(?urn)", "nie:url(?urn)", NULL);
#line 126 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp9_ = self->priv->categories_model;
#line 126 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_result_store_add_query (_tmp9_, TRACKER_QUERY_TYPE_MAIL, TRACKER_QUERY_MATCH_FTS, "?urn", "nie:url(?urn)", "nmo:messageSubject(?urn)", "tracker:coalesce(fts:snippet(?urn),nco:fullname(?sender), nco:nickname" \
"(?sender), nco:emailAddress(?sender))", "nmo:receivedDate(?urn)", "fn:concat(\"To: \", tracker:coalesce(nco:fullname(?to), nco:nickname(?" \
"to), nco:emailAddress(?to)))", NULL);
#line 134 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp10_ = self->priv->categories_model;
#line 134 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_result_store_add_query (_tmp10_, TRACKER_QUERY_TYPE_FOLDERS, TRACKER_QUERY_MATCH_FTS, "?urn", "nie:url(?urn)", "tracker:coalesce(fts:snippet(?urn),nie:title(?urn), nfo:fileName(?urn)" \
")", "nie:url(?parent)", "nfo:fileLastModified(?urn)", "?tooltip", NULL);
#line 142 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp11_ = self->priv->categories_model;
#line 142 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_result_store_add_query (_tmp11_, TRACKER_QUERY_TYPE_BOOKMARKS, TRACKER_QUERY_MATCH_FTS, "?urn", "nie:url(?bookmark)", "nie:title(?urn)", "nie:url(?bookmark)", "nie:contentLastModified(?urn)", "nie:url(?bookmark)", NULL);
#line 152 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp12_ = tracker_result_store_new (7);
#line 152 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->files_model);
#line 152 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->files_model = _tmp12_;
#line 153 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp13_ = self->priv->files_model;
#line 153 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp14_ = self->priv->limit;
#line 153 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_result_store_set_limit (_tmp13_, _tmp14_);
#line 154 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp15_ = self->priv->files_model;
#line 154 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect (_tmp15_, "result-overflow", (GCallback) _tracker_needle_result_overflow_tracker_result_store_result_overflow, self);
#line 155 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp16_ = self->priv->files_model;
#line 155 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_result_store_add_query (_tmp16_, TRACKER_QUERY_TYPE_ALL, TRACKER_QUERY_MATCH_FTS, "?urn", "nie:url(?urn)", "tracker:coalesce(nie:title(?urn), nfo:fileName(?urn))", "nie:url(?urn)", "nfo:fileSize(?urn)", "nfo:fileLastModified(?urn)", "nie:url(?urn)", NULL);
#line 165 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp17_ = tracker_result_store_new (7);
#line 165 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->files_in_title_model);
#line 165 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->files_in_title_model = _tmp17_;
#line 166 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp18_ = self->priv->files_in_title_model;
#line 166 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp19_ = self->priv->limit;
#line 166 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_result_store_set_limit (_tmp18_, _tmp19_);
#line 167 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp20_ = self->priv->files_in_title_model;
#line 167 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect (_tmp20_, "result-overflow", (GCallback) _tracker_needle_result_overflow_tracker_result_store_result_overflow, self);
#line 168 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp21_ = self->priv->files_in_title_model;
#line 168 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_result_store_add_query (_tmp21_, TRACKER_QUERY_TYPE_ALL, TRACKER_QUERY_MATCH_TITLES, "?urn", "nie:url(?urn)", "tracker:coalesce(nie:title(?urn), nfo:fileName(?urn))", "nie:url(?urn)", "nfo:fileSize(?urn)", "nfo:fileLastModified(?urn)", "nie:url(?urn)", NULL);
#line 178 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp22_ = tracker_result_store_new (7);
#line 178 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->files_in_tags_model);
#line 178 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->files_in_tags_model = _tmp22_;
#line 179 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp23_ = self->priv->files_in_tags_model;
#line 179 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp24_ = self->priv->limit;
#line 179 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_result_store_set_limit (_tmp23_, _tmp24_);
#line 180 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp25_ = self->priv->files_in_tags_model;
#line 180 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect (_tmp25_, "result-overflow", (GCallback) _tracker_needle_result_overflow_tracker_result_store_result_overflow, self);
#line 181 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp26_ = self->priv->files_in_tags_model;
#line 181 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_result_store_add_query (_tmp26_, TRACKER_QUERY_TYPE_ALL, TRACKER_QUERY_MATCH_TAGS_ONLY, "?urn", "nie:url(?urn)", "tracker:coalesce(nie:title(?urn), nfo:fileName(?urn))", "nie:url(?urn)", "nfo:fileSize(?urn)", "nfo:fileLastModified(?urn)", "nie:url(?urn)", NULL);
#line 192 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp27_ = tracker_result_store_new (6);
#line 192 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->images_model);
#line 192 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->images_model = _tmp27_;
#line 193 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp28_ = self->priv->images_model;
#line 193 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp29_ = self->priv->limit;
#line 193 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_result_store_set_limit (_tmp28_, _tmp29_);
#line 194 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp30_ = self->priv->images_model;
#line 194 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect (_tmp30_, "result-overflow", (GCallback) _tracker_needle_result_overflow_tracker_result_store_result_overflow, self);
#line 195 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp31_ = self->priv->images_model;
#line 195 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_result_store_set_icon_size (_tmp31_, 128);
#line 196 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp32_ = self->priv->images_model;
#line 196 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_result_store_add_query (_tmp32_, TRACKER_QUERY_TYPE_IMAGES, TRACKER_QUERY_MATCH_NONE, "?urn", "nie:url(?urn)", "tracker:coalesce(nie:title(?urn), nfo:fileName(?urn))", "nfo:fileSize(?urn)", "nfo:fileLastModified(?urn)", "nie:url(?urn)", NULL);
#line 206 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp33_ = tracker_result_store_new (6);
#line 206 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->images_in_title_model);
#line 206 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->images_in_title_model = _tmp33_;
#line 207 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp34_ = self->priv->images_in_title_model;
#line 207 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp35_ = self->priv->limit;
#line 207 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_result_store_set_limit (_tmp34_, _tmp35_);
#line 208 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp36_ = self->priv->images_in_title_model;
#line 208 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect (_tmp36_, "result-overflow", (GCallback) _tracker_needle_result_overflow_tracker_result_store_result_overflow, self);
#line 209 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp37_ = self->priv->images_in_title_model;
#line 209 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_result_store_set_icon_size (_tmp37_, 128);
#line 210 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp38_ = self->priv->images_in_title_model;
#line 210 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_result_store_add_query (_tmp38_, TRACKER_QUERY_TYPE_IMAGES, TRACKER_QUERY_MATCH_TITLES, "?urn", "nie:url(?urn)", "tracker:coalesce(nie:title(?urn), nfo:fileName(?urn))", "nfo:fileSize(?urn)", "nfo:fileLastModified(?urn)", "nie:url(?urn)", NULL);
#line 565 "tracker-needle.c"
}


static void __lambda8_ (TrackerNeedle* self, const gchar* key) {
	const gchar* _tmp0_ = NULL;
#line 227 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (key != NULL);
#line 228 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = key;
#line 228 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_debug ("tracker-needle.vala:228: tracker-needle: Key %s changed\n", _tmp0_);
#line 577 "tracker-needle.c"
}


static void ___lambda8__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
#line 227 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	__lambda8_ ((TrackerNeedle*) self, key);
#line 584 "tracker-needle.c"
}


TrackerNeedle* tracker_needle_construct (GType object_type) {
	TrackerNeedle* self = NULL;
	TrackerHistory* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	GSettings* _tmp2_ = NULL;
#line 220 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self = (TrackerNeedle*) g_type_create_instance (object_type);
#line 221 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_needle_create_models (self);
#line 222 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = tracker_history_new ();
#line 222 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tracker_history_unref0 (self->priv->history);
#line 222 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->history = _tmp0_;
#line 225 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp1_ = g_settings_new ("org.freedesktop.Tracker.Needle");
#line 225 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->settings_needle);
#line 225 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->settings_needle = _tmp1_;
#line 227 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp2_ = self->priv->settings_needle;
#line 227 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect (_tmp2_, "changed", (GCallback) ___lambda8__g_settings_changed, self);
#line 220 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	return self;
#line 615 "tracker-needle.c"
}


TrackerNeedle* tracker_needle_new (void) {
#line 220 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	return tracker_needle_construct (TRACKER_TYPE_NEEDLE);
#line 622 "tracker-needle.c"
}


void tracker_needle_show (TrackerNeedle* self) {
	GtkWindow* _tmp0_ = NULL;
#line 232 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (self != NULL);
#line 233 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_needle_setup_ui (self);
#line 235 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = self->priv->window;
#line 235 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_widget_show ((GtkWidget*) _tmp0_);
#line 636 "tracker-needle.c"
}


void tracker_needle_set_search (TrackerNeedle* self, gchar** args, int args_length1) {
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
#line 238 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (self != NULL);
#line 239 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = args;
#line 239 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0__length1 = args_length1;
#line 239 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp0_ != NULL) {
#line 651 "tracker-needle.c"
		gchar* text = NULL;
		gchar* _tmp1_ = NULL;
		gchar** _tmp2_ = NULL;
		gint _tmp2__length1 = 0;
		const gchar* _tmp12_ = NULL;
		GtkEntry* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
#line 240 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp1_ = g_strdup ("");
#line 240 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		text = _tmp1_;
#line 242 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp2_ = args;
#line 242 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp2__length1 = args_length1;
#line 667 "tracker-needle.c"
		{
			gchar** s_collection = NULL;
			gint s_collection_length1 = 0;
			gint _s_collection_size_ = 0;
			gint s_it = 0;
#line 242 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			s_collection = _tmp2_;
#line 242 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			s_collection_length1 = _tmp2__length1;
#line 242 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			for (s_it = 0; s_it < _tmp2__length1; s_it = s_it + 1) {
#line 679 "tracker-needle.c"
				gchar* _tmp3_ = NULL;
				gchar* s = NULL;
#line 242 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp3_ = g_strdup (s_collection[s_it]);
#line 242 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				s = _tmp3_;
#line 686 "tracker-needle.c"
				{
					const gchar* _tmp4_ = NULL;
					gint _tmp5_ = 0;
					gint _tmp6_ = 0;
					const gchar* _tmp9_ = NULL;
					const gchar* _tmp10_ = NULL;
					gchar* _tmp11_ = NULL;
#line 243 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					_tmp4_ = text;
#line 243 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					_tmp5_ = strlen (_tmp4_);
#line 243 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					_tmp6_ = _tmp5_;
#line 243 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					if (_tmp6_ > 1) {
#line 702 "tracker-needle.c"
						const gchar* _tmp7_ = NULL;
						gchar* _tmp8_ = NULL;
#line 244 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
						_tmp7_ = text;
#line 244 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
						_tmp8_ = g_strconcat (_tmp7_, " ", NULL);
#line 244 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
						_g_free0 (text);
#line 244 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
						text = _tmp8_;
#line 713 "tracker-needle.c"
					}
#line 246 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					_tmp9_ = text;
#line 246 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					_tmp10_ = s;
#line 246 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					_tmp11_ = g_strconcat (_tmp9_, _tmp10_, NULL);
#line 246 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					_g_free0 (text);
#line 246 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					text = _tmp11_;
#line 242 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					_g_free0 (s);
#line 727 "tracker-needle.c"
				}
			}
		}
#line 249 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp12_ = text;
#line 249 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_debug ("tracker-needle.vala:249: Setting search criteria to: '%s'\n", _tmp12_);
#line 250 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp13_ = self->priv->search;
#line 250 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp14_ = text;
#line 250 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_entry_set_text (_tmp13_, _tmp14_);
#line 239 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_free0 (text);
#line 743 "tracker-needle.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 256 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	return self ? g_object_ref (self) : NULL;
#line 751 "tracker-needle.c"
}


static void tracker_needle_store_state_changed (TrackerNeedle* self, GObject* object, GParamSpec* p) {
	TrackerResultStore* store = NULL;
	GObject* _tmp0_ = NULL;
	TrackerResultStore* _tmp1_ = NULL;
	TrackerResultStore* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
#line 254 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (self != NULL);
#line 254 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (object != NULL);
#line 254 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (p != NULL);
#line 256 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = object;
#line 256 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TRACKER_TYPE_RESULT_STORE, TrackerResultStore));
#line 256 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	store = _tmp1_;
#line 258 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp2_ = store;
#line 258 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp3_ = tracker_result_store_get_active (_tmp2_);
#line 258 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp4_ = _tmp3_;
#line 258 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp4_) {
#line 782 "tracker-needle.c"
		GtkToolItem* _tmp5_ = NULL;
		GtkSpinner* _tmp6_ = NULL;
#line 259 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp5_ = self->priv->spinner_shell;
#line 259 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_widget_show_all ((GtkWidget*) _tmp5_);
#line 260 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp6_ = self->priv->spinner;
#line 260 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_spinner_start (_tmp6_);
#line 793 "tracker-needle.c"
	} else {
		GtkToolItem* _tmp7_ = NULL;
		GtkSpinner* _tmp8_ = NULL;
#line 262 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp7_ = self->priv->spinner_shell;
#line 262 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_widget_hide ((GtkWidget*) _tmp7_);
#line 263 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp8_ = self->priv->spinner;
#line 263 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_spinner_stop (_tmp8_);
#line 805 "tracker-needle.c"
	}
#line 254 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (store);
#line 809 "tracker-needle.c"
}


static void _tracker_needle_window_closed_gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
#line 297 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_needle_window_closed ((TrackerNeedle*) self);
#line 816 "tracker-needle.c"
}


static gboolean _tracker_needle_window_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = tracker_needle_window_key_press_event ((TrackerNeedle*) self, _sender, event);
#line 298 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	return result;
#line 825 "tracker-needle.c"
}


static void _tracker_needle_info_bar_closed_gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 306 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_needle_info_bar_closed ((TrackerNeedle*) self, _sender);
#line 832 "tracker-needle.c"
}


static void _tracker_needle_view_toggled_gtk_toggle_tool_button_toggled (GtkToggleToolButton* _sender, gpointer self) {
#line 309 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_needle_view_toggled ((TrackerNeedle*) self);
#line 839 "tracker-needle.c"
}


static void _tracker_needle_find_in_toggled_gtk_toggle_tool_button_toggled (GtkToggleToolButton* _sender, gpointer self) {
#line 326 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_needle_find_in_toggled ((TrackerNeedle*) self);
#line 846 "tracker-needle.c"
}


static void _tracker_needle_search_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self) {
#line 352 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_needle_search_changed ((TrackerNeedle*) self, _sender);
#line 853 "tracker-needle.c"
}


static void _tracker_needle_search_activated_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
#line 353 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_needle_search_activated ((TrackerNeedle*) self, _sender);
#line 860 "tracker-needle.c"
}


static gboolean _tracker_needle_search_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = tracker_needle_search_key_press_event ((TrackerNeedle*) self, _sender, event);
#line 354 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	return result;
#line 869 "tracker-needle.c"
}


static void _tracker_needle_show_tags_clicked_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
#line 362 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_needle_show_tags_clicked ((TrackerNeedle*) self);
#line 876 "tracker-needle.c"
}


static void _tracker_needle_show_stats_clicked_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
#line 367 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_needle_show_stats_clicked ((TrackerNeedle*) self);
#line 883 "tracker-needle.c"
}


static void _tracker_needle_store_state_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 382 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_needle_store_state_changed ((TrackerNeedle*) self, _sender, pspec);
#line 890 "tracker-needle.c"
}


static void _tracker_needle_view_row_activated_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self) {
#line 384 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_needle_view_row_activated ((TrackerNeedle*) self, _sender, path, column);
#line 897 "tracker-needle.c"
}


static void _tracker_needle_view_row_selected_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
#line 386 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_needle_view_row_selected ((TrackerNeedle*) self, _sender);
#line 904 "tracker-needle.c"
}


static void _tracker_needle_icon_item_activated_gtk_icon_view_item_activated (GtkIconView* _sender, GtkTreePath* path, gpointer self) {
#line 398 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_needle_icon_item_activated ((TrackerNeedle*) self, _sender, path);
#line 911 "tracker-needle.c"
}


static void _tracker_needle_icon_view_selection_changed_gtk_icon_view_selection_changed (GtkIconView* _sender, gpointer self) {
#line 399 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_needle_icon_view_selection_changed ((TrackerNeedle*) self);
#line 918 "tracker-needle.c"
}


static void tracker_needle_setup_ui (TrackerNeedle* self) {
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp0_ = NULL;
	GtkButton* info_bar_button = NULL;
	GtkToolbar* toolbar = NULL;
	GtkPaned* paned = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	GObject* _tmp8_ = NULL;
	GtkWindow* _tmp9_ = NULL;
	GtkWindow* _tmp10_ = NULL;
	GtkWindow* _tmp11_ = NULL;
	GObject* _tmp12_ = NULL;
	GtkToolbar* _tmp13_ = NULL;
	GtkToolbar* _tmp14_ = NULL;
	GtkStyleContext* _tmp15_ = NULL;
	GObject* _tmp16_ = NULL;
	GtkInfoBar* _tmp17_ = NULL;
	GObject* _tmp18_ = NULL;
	GtkLabel* _tmp19_ = NULL;
	GObject* _tmp20_ = NULL;
	GtkButton* _tmp21_ = NULL;
	GtkButton* _tmp22_ = NULL;
	GObject* _tmp23_ = NULL;
	GtkToggleToolButton* _tmp24_ = NULL;
	GtkToggleToolButton* _tmp25_ = NULL;
	GtkToggleToolButton* _tmp26_ = NULL;
	AtkObject* _tmp27_ = NULL;
	GtkToggleToolButton* _tmp28_ = NULL;
	GtkWidget* _tmp29_ = NULL;
	AtkObject* _tmp30_ = NULL;
	GObject* _tmp31_ = NULL;
	GtkToggleToolButton* _tmp32_ = NULL;
	GtkToggleToolButton* _tmp33_ = NULL;
	GtkToggleToolButton* _tmp34_ = NULL;
	AtkObject* _tmp35_ = NULL;
	GtkToggleToolButton* _tmp36_ = NULL;
	GtkWidget* _tmp37_ = NULL;
	AtkObject* _tmp38_ = NULL;
	GObject* _tmp39_ = NULL;
	GtkToggleToolButton* _tmp40_ = NULL;
	GtkToggleToolButton* _tmp41_ = NULL;
	GtkToggleToolButton* _tmp42_ = NULL;
	AtkObject* _tmp43_ = NULL;
	GtkToggleToolButton* _tmp44_ = NULL;
	GtkWidget* _tmp45_ = NULL;
	AtkObject* _tmp46_ = NULL;
	GObject* _tmp47_ = NULL;
	GtkSeparatorToolItem* _tmp48_ = NULL;
	GObject* _tmp49_ = NULL;
	GtkToggleToolButton* _tmp50_ = NULL;
	GtkToggleToolButton* _tmp51_ = NULL;
	GtkToggleToolButton* _tmp52_ = NULL;
	AtkObject* _tmp53_ = NULL;
	GtkToggleToolButton* _tmp54_ = NULL;
	GtkWidget* _tmp55_ = NULL;
	AtkObject* _tmp56_ = NULL;
	GObject* _tmp57_ = NULL;
	GtkToggleToolButton* _tmp58_ = NULL;
	GtkToggleToolButton* _tmp59_ = NULL;
	GtkToggleToolButton* _tmp60_ = NULL;
	AtkObject* _tmp61_ = NULL;
	GtkToggleToolButton* _tmp62_ = NULL;
	GtkWidget* _tmp63_ = NULL;
	AtkObject* _tmp64_ = NULL;
	GObject* _tmp65_ = NULL;
	GtkToggleToolButton* _tmp66_ = NULL;
	GtkToggleToolButton* _tmp67_ = NULL;
	GtkToggleToolButton* _tmp68_ = NULL;
	AtkObject* _tmp69_ = NULL;
	GtkToggleToolButton* _tmp70_ = NULL;
	GtkWidget* _tmp71_ = NULL;
	AtkObject* _tmp72_ = NULL;
	GObject* _tmp73_ = NULL;
	GtkToggleToolButton* _tmp74_ = NULL;
	GtkToggleToolButton* _tmp75_ = NULL;
	GtkToggleToolButton* _tmp76_ = NULL;
	AtkObject* _tmp77_ = NULL;
	GtkToggleToolButton* _tmp78_ = NULL;
	GtkWidget* _tmp79_ = NULL;
	AtkObject* _tmp80_ = NULL;
	GObject* _tmp81_ = NULL;
	GtkToolItem* _tmp82_ = NULL;
	GtkToolItem* _tmp83_ = NULL;
	AtkObject* _tmp84_ = NULL;
	GObject* _tmp85_ = NULL;
	GtkComboBox* _tmp86_ = NULL;
	GtkComboBox* _tmp87_ = NULL;
	AtkObject* _tmp88_ = NULL;
	GtkComboBox* _tmp89_ = NULL;
	GtkWidget* _tmp90_ = NULL;
	GtkEntry* _tmp91_ = NULL;
	GtkEntry* _tmp92_ = NULL;
	GtkEntry* _tmp93_ = NULL;
	GtkEntry* _tmp94_ = NULL;
	TrackerHistory* _tmp95_ = NULL;
	gint _tmp96_ = 0;
	gchar** _tmp97_ = NULL;
	gchar** _tmp98_ = NULL;
	gint _tmp98__length1 = 0;
	GtkSpinner* _tmp99_ = NULL;
	GObject* _tmp100_ = NULL;
	GtkToolItem* _tmp101_ = NULL;
	GtkToolItem* _tmp102_ = NULL;
	GtkSpinner* _tmp103_ = NULL;
	GObject* _tmp104_ = NULL;
	GtkToggleToolButton* _tmp105_ = NULL;
	GtkToggleToolButton* _tmp106_ = NULL;
	GtkToggleToolButton* _tmp107_ = NULL;
	AtkObject* _tmp108_ = NULL;
	GtkToggleToolButton* _tmp109_ = NULL;
	GtkWidget* _tmp110_ = NULL;
	AtkObject* _tmp111_ = NULL;
	GObject* _tmp112_ = NULL;
	GtkToolButton* _tmp113_ = NULL;
	GtkToolButton* _tmp114_ = NULL;
	GtkToolButton* _tmp115_ = NULL;
	AtkObject* _tmp116_ = NULL;
	GtkToolButton* _tmp117_ = NULL;
	GtkWidget* _tmp118_ = NULL;
	AtkObject* _tmp119_ = NULL;
	GObject* _tmp120_ = NULL;
	GtkBox* _tmp121_ = NULL;
	GtkTreeView* treeview = NULL;
	GtkIconView* iconview = NULL;
	GtkTreeSelection* treeselection = NULL;
	TrackerViewDisplay _tmp122_ = 0;
	TrackerView* _tmp123_ = NULL;
	GtkBox* _tmp124_ = NULL;
	TrackerView* _tmp125_ = NULL;
	TrackerViewDisplay _tmp126_ = 0;
	TrackerResultStore* _tmp127_ = NULL;
	TrackerView* _tmp128_ = NULL;
	TrackerView* _tmp129_ = NULL;
	TrackerResultStore* _tmp130_ = NULL;
	TrackerResultStore* _tmp131_ = NULL;
	TrackerView* _tmp132_ = NULL;
	GtkWidget* _tmp133_ = NULL;
	GtkTreeView* _tmp134_ = NULL;
	GtkTreeView* _tmp135_ = NULL;
	GtkTreeView* _tmp136_ = NULL;
	GtkTreeSelection* _tmp137_ = NULL;
	GtkTreeSelection* _tmp138_ = NULL;
	GtkTreeSelection* _tmp139_ = NULL;
	GtkBox* _tmp140_ = NULL;
	TrackerView* _tmp141_ = NULL;
	TrackerViewDisplay _tmp142_ = 0;
	TrackerView* _tmp143_ = NULL;
	TrackerView* _tmp144_ = NULL;
	GtkWidget* _tmp145_ = NULL;
	GtkTreeView* _tmp146_ = NULL;
	GtkTreeView* _tmp147_ = NULL;
	GtkTreeView* _tmp148_ = NULL;
	GtkTreeSelection* _tmp149_ = NULL;
	GtkTreeSelection* _tmp150_ = NULL;
	GtkTreeSelection* _tmp151_ = NULL;
	GtkBox* _tmp152_ = NULL;
	TrackerView* _tmp153_ = NULL;
	TrackerViewDisplay _tmp154_ = 0;
	TrackerView* _tmp155_ = NULL;
	TrackerView* _tmp156_ = NULL;
	GtkWidget* _tmp157_ = NULL;
	GtkIconView* _tmp158_ = NULL;
	GtkIconView* _tmp159_ = NULL;
	GtkIconView* _tmp160_ = NULL;
	GtkBox* _tmp161_ = NULL;
	TrackerView* _tmp162_ = NULL;
	GObject* _tmp163_ = NULL;
	GtkPaned* _tmp164_ = NULL;
	TrackerTagsView* _tmp165_ = NULL;
	TrackerTagsView* _tmp166_ = NULL;
	TrackerTagsView* _tmp167_ = NULL;
	GtkPaned* _tmp168_ = NULL;
	TrackerTagsView* _tmp169_ = NULL;
	GtkToggleToolButton* _tmp170_ = NULL;
	GtkToggleToolButton* _tmp171_ = NULL;
	GtkToggleToolButton* _tmp172_ = NULL;
	GSettings* _tmp173_ = NULL;
	gint _tmp174_ = 0;
	gint _tmp175_ = 0;
	GError * _inner_error_ = NULL;
#line 267 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (self != NULL);
#line 268 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = gtk_builder_new ();
#line 268 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	builder = _tmp0_;
#line 1110 "tracker-needle.c"
	{
#line 275 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_builder_add_from_file (builder, SRCDIR TRACKER_NEEDLE_UI_FILE, &_inner_error_);
#line 275 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1116 "tracker-needle.c"
			goto __catch28_g_error;
		}
	}
	goto __finally28;
	__catch28_g_error:
	{
		GError* e = NULL;
#line 273 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		e = _inner_error_;
#line 273 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_inner_error_ = NULL;
#line 1128 "tracker-needle.c"
		{
#line 279 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			gtk_builder_add_from_file (builder, TRACKER_UI_DIR TRACKER_NEEDLE_UI_FILE, &_inner_error_);
#line 279 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1134 "tracker-needle.c"
				goto __catch29_g_error;
			}
		}
		goto __finally29;
		__catch29_g_error:
		{
			GError* e = NULL;
			GtkMessageDialog* msg = NULL;
			GError* _tmp1_ = NULL;
			const gchar* _tmp2_ = NULL;
			GtkMessageDialog* _tmp3_ = NULL;
			GtkMessageDialog* _tmp4_ = NULL;
#line 278 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			e = _inner_error_;
#line 278 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_inner_error_ = NULL;
#line 281 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp1_ = e;
#line 281 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp2_ = _tmp1_->message;
#line 281 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp3_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_CANCEL, "Failed to load UI file, %s\n", _tmp2_);
#line 281 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			g_object_ref_sink (_tmp3_);
#line 281 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			msg = _tmp3_;
#line 287 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp4_ = msg;
#line 287 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			gtk_dialog_run ((GtkDialog*) _tmp4_);
#line 288 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			gtk_main_quit ();
#line 278 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_g_object_unref0 (msg);
#line 278 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_g_error_free0 (e);
#line 1171 "tracker-needle.c"
		}
		__finally29:
#line 278 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 278 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_g_error_free0 (e);
#line 278 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_g_error_free0 (e);
#line 278 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_g_object_unref0 (paned);
#line 278 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_g_object_unref0 (toolbar);
#line 278 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_g_object_unref0 (info_bar_button);
#line 278 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_g_object_unref0 (builder);
#line 278 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 278 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			g_clear_error (&_inner_error_);
#line 278 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			return;
#line 1194 "tracker-needle.c"
		}
#line 273 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_error_free0 (e);
#line 1198 "tracker-needle.c"
	}
	__finally28:
#line 273 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 273 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_object_unref0 (paned);
#line 273 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_object_unref0 (toolbar);
#line 273 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_object_unref0 (info_bar_button);
#line 273 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_object_unref0 (builder);
#line 273 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 273 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_clear_error (&_inner_error_);
#line 273 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		return;
#line 1217 "tracker-needle.c"
	}
#line 292 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_icon_size_lookup (GTK_ICON_SIZE_MENU, &_tmp5_, NULL);
#line 292 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->size_small = _tmp5_;
#line 293 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_icon_size_lookup (GTK_ICON_SIZE_DND, &_tmp6_, NULL);
#line 293 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->size_medium = _tmp6_;
#line 294 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_icon_size_lookup (GTK_ICON_SIZE_DIALOG, &_tmp7_, NULL);
#line 294 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->size_big = _tmp7_;
#line 296 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp8_ = gtk_builder_get_object (builder, "window_needle");
#line 296 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp8_) : NULL);
#line 296 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->window);
#line 296 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->window = _tmp9_;
#line 297 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp10_ = self->priv->window;
#line 297 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect ((GtkWidget*) _tmp10_, "destroy", (GCallback) _tracker_needle_window_closed_gtk_widget_destroy, self);
#line 298 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp11_ = self->priv->window;
#line 298 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect ((GtkWidget*) _tmp11_, "key-press-event", (GCallback) _tracker_needle_window_key_press_event_gtk_widget_key_press_event, self);
#line 300 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp12_ = gtk_builder_get_object (builder, "toolbar_main");
#line 300 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, gtk_toolbar_get_type ()) ? ((GtkToolbar*) _tmp12_) : NULL);
#line 300 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (toolbar);
#line 300 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	toolbar = _tmp13_;
#line 301 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp14_ = toolbar;
#line 301 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp15_ = gtk_widget_get_style_context ((GtkWidget*) _tmp14_);
#line 301 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_style_context_add_class (_tmp15_, GTK_STYLE_CLASS_PRIMARY_TOOLBAR);
#line 303 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp16_ = gtk_builder_get_object (builder, "info_bar");
#line 303 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, gtk_info_bar_get_type ()) ? ((GtkInfoBar*) _tmp16_) : NULL);
#line 303 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->info_bar);
#line 303 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->info_bar = _tmp17_;
#line 304 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp18_ = gtk_builder_get_object (builder, "info_bar_label");
#line 304 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp18_) : NULL);
#line 304 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->info_bar_label);
#line 304 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->info_bar_label = _tmp19_;
#line 305 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp20_ = gtk_builder_get_object (builder, "info_bar_button");
#line 305 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, gtk_button_get_type ()) ? ((GtkButton*) _tmp20_) : NULL);
#line 305 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (info_bar_button);
#line 305 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	info_bar_button = _tmp21_;
#line 306 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp22_ = info_bar_button;
#line 306 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect (_tmp22_, "clicked", (GCallback) _tracker_needle_info_bar_closed_gtk_button_clicked, self);
#line 308 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp23_ = gtk_builder_get_object (builder, "toolbutton_view_filelist");
#line 308 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp24_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, gtk_toggle_tool_button_get_type ()) ? ((GtkToggleToolButton*) _tmp23_) : NULL);
#line 308 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->view_filelist);
#line 308 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->view_filelist = _tmp24_;
#line 309 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp25_ = self->priv->view_filelist;
#line 309 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect (_tmp25_, "toggled", (GCallback) _tracker_needle_view_toggled_gtk_toggle_tool_button_toggled, self);
#line 310 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp26_ = self->priv->view_filelist;
#line 310 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp27_ = gtk_widget_get_accessible ((GtkWidget*) _tmp26_);
#line 310 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	atk_object_set_name (_tmp27_, "View File List");
#line 311 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp28_ = self->priv->view_filelist;
#line 311 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp29_ = gtk_bin_get_child ((GtkBin*) _tmp28_);
#line 311 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp30_ = gtk_widget_get_accessible (_tmp29_);
#line 311 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	atk_object_set_name (_tmp30_, "View File List RadioButton");
#line 313 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp31_ = gtk_builder_get_object (builder, "toolbutton_view_icons");
#line 313 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp32_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, gtk_toggle_tool_button_get_type ()) ? ((GtkToggleToolButton*) _tmp31_) : NULL);
#line 313 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->view_icons);
#line 313 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->view_icons = _tmp32_;
#line 314 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp33_ = self->priv->view_icons;
#line 314 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect (_tmp33_, "toggled", (GCallback) _tracker_needle_view_toggled_gtk_toggle_tool_button_toggled, self);
#line 315 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp34_ = self->priv->view_icons;
#line 315 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp35_ = gtk_widget_get_accessible ((GtkWidget*) _tmp34_);
#line 315 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	atk_object_set_name (_tmp35_, "View Icons");
#line 316 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp36_ = self->priv->view_icons;
#line 316 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp37_ = gtk_bin_get_child ((GtkBin*) _tmp36_);
#line 316 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp38_ = gtk_widget_get_accessible (_tmp37_);
#line 316 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	atk_object_set_name (_tmp38_, "View Icons RadioButton");
#line 318 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp39_ = gtk_builder_get_object (builder, "toolbutton_view_categories");
#line 318 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp40_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp39_, gtk_toggle_tool_button_get_type ()) ? ((GtkToggleToolButton*) _tmp39_) : NULL);
#line 318 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->view_categories);
#line 318 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->view_categories = _tmp40_;
#line 319 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp41_ = self->priv->view_categories;
#line 319 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect (_tmp41_, "toggled", (GCallback) _tracker_needle_view_toggled_gtk_toggle_tool_button_toggled, self);
#line 320 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp42_ = self->priv->view_categories;
#line 320 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp43_ = gtk_widget_get_accessible ((GtkWidget*) _tmp42_);
#line 320 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	atk_object_set_name (_tmp43_, "View Categories");
#line 321 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp44_ = self->priv->view_categories;
#line 321 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp45_ = gtk_bin_get_child ((GtkBin*) _tmp44_);
#line 321 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp46_ = gtk_widget_get_accessible (_tmp45_);
#line 321 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	atk_object_set_name (_tmp46_, "View Categories RadioButton");
#line 323 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp47_ = gtk_builder_get_object (builder, "separator_secondary");
#line 323 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp48_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp47_, gtk_separator_tool_item_get_type ()) ? ((GtkSeparatorToolItem*) _tmp47_) : NULL);
#line 323 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->separator_secondary);
#line 323 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->separator_secondary = _tmp48_;
#line 325 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp49_ = gtk_builder_get_object (builder, "toolbutton_find_in_contents");
#line 325 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp50_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp49_, gtk_toggle_tool_button_get_type ()) ? ((GtkToggleToolButton*) _tmp49_) : NULL);
#line 325 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->find_in_contents);
#line 325 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->find_in_contents = _tmp50_;
#line 326 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp51_ = self->priv->find_in_contents;
#line 326 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect (_tmp51_, "toggled", (GCallback) _tracker_needle_find_in_toggled_gtk_toggle_tool_button_toggled, self);
#line 327 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp52_ = self->priv->find_in_contents;
#line 327 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp53_ = gtk_widget_get_accessible ((GtkWidget*) _tmp52_);
#line 327 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	atk_object_set_name (_tmp53_, "Find in Contents");
#line 328 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp54_ = self->priv->find_in_contents;
#line 328 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp55_ = gtk_bin_get_child ((GtkBin*) _tmp54_);
#line 328 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp56_ = gtk_widget_get_accessible (_tmp55_);
#line 328 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	atk_object_set_name (_tmp56_, "Find in Contents");
#line 330 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp57_ = gtk_builder_get_object (builder, "toolbutton_find_in_titles");
#line 330 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp58_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp57_, gtk_toggle_tool_button_get_type ()) ? ((GtkToggleToolButton*) _tmp57_) : NULL);
#line 330 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->find_in_titles);
#line 330 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->find_in_titles = _tmp58_;
#line 331 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp59_ = self->priv->find_in_titles;
#line 331 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect (_tmp59_, "toggled", (GCallback) _tracker_needle_find_in_toggled_gtk_toggle_tool_button_toggled, self);
#line 332 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp60_ = self->priv->find_in_titles;
#line 332 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp61_ = gtk_widget_get_accessible ((GtkWidget*) _tmp60_);
#line 332 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	atk_object_set_name (_tmp61_, "Find in Titles");
#line 333 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp62_ = self->priv->find_in_titles;
#line 333 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp63_ = gtk_bin_get_child ((GtkBin*) _tmp62_);
#line 333 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp64_ = gtk_widget_get_accessible (_tmp63_);
#line 333 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	atk_object_set_name (_tmp64_, "Find in Titles");
#line 335 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp65_ = gtk_builder_get_object (builder, "toolbutton_find_in_tags");
#line 335 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp66_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp65_, gtk_toggle_tool_button_get_type ()) ? ((GtkToggleToolButton*) _tmp65_) : NULL);
#line 335 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->find_in_tags);
#line 335 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->find_in_tags = _tmp66_;
#line 336 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp67_ = self->priv->find_in_tags;
#line 336 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect (_tmp67_, "toggled", (GCallback) _tracker_needle_find_in_toggled_gtk_toggle_tool_button_toggled, self);
#line 337 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp68_ = self->priv->find_in_tags;
#line 337 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp69_ = gtk_widget_get_accessible ((GtkWidget*) _tmp68_);
#line 337 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	atk_object_set_name (_tmp69_, "Find in Tags");
#line 338 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp70_ = self->priv->find_in_tags;
#line 338 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp71_ = gtk_bin_get_child ((GtkBin*) _tmp70_);
#line 338 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp72_ = gtk_widget_get_accessible (_tmp71_);
#line 338 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	atk_object_set_name (_tmp72_, "Find in Tags");
#line 340 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp73_ = gtk_builder_get_object (builder, "toolbutton_find_in_all");
#line 340 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp74_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp73_, gtk_toggle_tool_button_get_type ()) ? ((GtkToggleToolButton*) _tmp73_) : NULL);
#line 340 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->find_in_all);
#line 340 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->find_in_all = _tmp74_;
#line 341 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp75_ = self->priv->find_in_all;
#line 341 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect (_tmp75_, "toggled", (GCallback) _tracker_needle_find_in_toggled_gtk_toggle_tool_button_toggled, self);
#line 342 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp76_ = self->priv->find_in_all;
#line 342 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp77_ = gtk_widget_get_accessible ((GtkWidget*) _tmp76_);
#line 342 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	atk_object_set_name (_tmp77_, "Find in All");
#line 343 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp78_ = self->priv->find_in_all;
#line 343 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp79_ = gtk_bin_get_child ((GtkBin*) _tmp78_);
#line 343 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp80_ = gtk_widget_get_accessible (_tmp79_);
#line 343 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	atk_object_set_name (_tmp80_, "Find in All");
#line 345 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp81_ = gtk_builder_get_object (builder, "toolitem_search_entry");
#line 345 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp82_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp81_, gtk_tool_item_get_type ()) ? ((GtkToolItem*) _tmp81_) : NULL);
#line 345 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->search_entry);
#line 345 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->search_entry = _tmp82_;
#line 346 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp83_ = self->priv->search_entry;
#line 346 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp84_ = gtk_widget_get_accessible ((GtkWidget*) _tmp83_);
#line 346 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	atk_object_set_name (_tmp84_, "Search Entry");
#line 348 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp85_ = gtk_builder_get_object (builder, "combobox_search");
#line 348 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp86_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp85_, gtk_combo_box_get_type ()) ? ((GtkComboBox*) _tmp85_) : NULL);
#line 348 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->search_list);
#line 348 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->search_list = _tmp86_;
#line 349 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp87_ = self->priv->search_list;
#line 349 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp88_ = gtk_widget_get_accessible ((GtkWidget*) _tmp87_);
#line 349 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	atk_object_set_name (_tmp88_, "Search List");
#line 351 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp89_ = self->priv->search_list;
#line 351 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp90_ = gtk_bin_get_child ((GtkBin*) _tmp89_);
#line 351 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp91_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp90_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp90_) : NULL);
#line 351 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->search);
#line 351 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->search = _tmp91_;
#line 352 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp92_ = self->priv->search;
#line 352 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect ((GtkEditable*) _tmp92_, "changed", (GCallback) _tracker_needle_search_changed_gtk_editable_changed, self);
#line 353 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp93_ = self->priv->search;
#line 353 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect (_tmp93_, "activate", (GCallback) _tracker_needle_search_activated_gtk_entry_activate, self);
#line 354 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp94_ = self->priv->search;
#line 354 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect ((GtkWidget*) _tmp94_, "key-press-event", (GCallback) _tracker_needle_search_key_press_event_gtk_widget_key_press_event, self);
#line 355 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp95_ = self->priv->history;
#line 355 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp97_ = tracker_history_get (_tmp95_, &_tmp96_);
#line 355 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp98_ = _tmp97_;
#line 355 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp98__length1 = _tmp96_;
#line 355 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_needle_search_history_insert (self, _tmp98_, _tmp96_);
#line 355 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp98_ = (_vala_array_free (_tmp98_, _tmp98__length1, (GDestroyNotify) g_free), NULL);
#line 357 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp99_ = (GtkSpinner*) gtk_spinner_new ();
#line 357 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_object_ref_sink (_tmp99_);
#line 357 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->spinner);
#line 357 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->spinner = _tmp99_;
#line 358 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp100_ = gtk_builder_get_object (builder, "toolcustom_spinner");
#line 358 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp101_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp100_, gtk_tool_item_get_type ()) ? ((GtkToolItem*) _tmp100_) : NULL);
#line 358 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->spinner_shell);
#line 358 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->spinner_shell = _tmp101_;
#line 359 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp102_ = self->priv->spinner_shell;
#line 359 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp103_ = self->priv->spinner;
#line 359 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_container_add ((GtkContainer*) _tmp102_, (GtkWidget*) _tmp103_);
#line 361 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp104_ = gtk_builder_get_object (builder, "toolbutton_show_tags");
#line 361 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp105_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp104_, gtk_toggle_tool_button_get_type ()) ? ((GtkToggleToolButton*) _tmp104_) : NULL);
#line 361 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->show_tags);
#line 361 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->show_tags = _tmp105_;
#line 362 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp106_ = self->priv->show_tags;
#line 362 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect ((GtkToolButton*) _tmp106_, "clicked", (GCallback) _tracker_needle_show_tags_clicked_gtk_tool_button_clicked, self);
#line 363 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp107_ = self->priv->show_tags;
#line 363 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp108_ = gtk_widget_get_accessible ((GtkWidget*) _tmp107_);
#line 363 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	atk_object_set_name (_tmp108_, "Show Tags");
#line 364 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp109_ = self->priv->show_tags;
#line 364 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp110_ = gtk_bin_get_child ((GtkBin*) _tmp109_);
#line 364 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp111_ = gtk_widget_get_accessible (_tmp110_);
#line 364 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	atk_object_set_name (_tmp111_, "Show Tags");
#line 366 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp112_ = gtk_builder_get_object (builder, "toolbutton_show_stats");
#line 366 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp113_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp112_, gtk_tool_button_get_type ()) ? ((GtkToolButton*) _tmp112_) : NULL);
#line 366 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->show_stats);
#line 366 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->show_stats = _tmp113_;
#line 367 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp114_ = self->priv->show_stats;
#line 367 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect (_tmp114_, "clicked", (GCallback) _tracker_needle_show_stats_clicked_gtk_tool_button_clicked, self);
#line 368 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp115_ = self->priv->show_stats;
#line 368 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp116_ = gtk_widget_get_accessible ((GtkWidget*) _tmp115_);
#line 368 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	atk_object_set_name (_tmp116_, "Show Stats");
#line 369 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp117_ = self->priv->show_stats;
#line 369 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp118_ = gtk_bin_get_child ((GtkBin*) _tmp117_);
#line 369 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp119_ = gtk_widget_get_accessible (_tmp118_);
#line 369 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	atk_object_set_name (_tmp119_, "Show Stats");
#line 371 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp120_ = gtk_builder_get_object (builder, "hbox_view");
#line 371 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp121_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp120_, gtk_box_get_type ()) ? ((GtkBox*) _tmp120_) : NULL);
#line 371 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->view);
#line 371 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->view = _tmp121_;
#line 378 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp122_ = TRACKER_VIEW_DISPLAY_NO_RESULTS;
#line 378 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp123_ = tracker_view_new (&_tmp122_, NULL);
#line 378 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_object_ref_sink (_tmp123_);
#line 378 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->sw_noresults);
#line 378 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->sw_noresults = _tmp123_;
#line 379 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp124_ = self->priv->view;
#line 379 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp125_ = self->priv->sw_noresults;
#line 379 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_box_pack_start (_tmp124_, (GtkWidget*) _tmp125_, TRUE, TRUE, (guint) 0);
#line 381 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp126_ = TRACKER_VIEW_DISPLAY_CATEGORIES;
#line 381 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp127_ = self->priv->categories_model;
#line 381 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp128_ = tracker_view_new (&_tmp126_, _tmp127_);
#line 381 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_object_ref_sink (_tmp128_);
#line 381 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->sw_categories);
#line 381 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->sw_categories = _tmp128_;
#line 382 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp129_ = self->priv->sw_categories;
#line 382 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp130_ = tracker_view_get_store (_tmp129_);
#line 382 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp131_ = _tmp130_;
#line 382 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect ((GObject*) _tmp131_, "notify::active", (GCallback) _tracker_needle_store_state_changed_g_object_notify, self);
#line 383 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp132_ = self->priv->sw_categories;
#line 383 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp133_ = gtk_bin_get_child ((GtkBin*) _tmp132_);
#line 383 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp134_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp133_, gtk_tree_view_get_type (), GtkTreeView));
#line 383 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (treeview);
#line 383 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	treeview = _tmp134_;
#line 384 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp135_ = treeview;
#line 384 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect (_tmp135_, "row-activated", (GCallback) _tracker_needle_view_row_activated_gtk_tree_view_row_activated, self);
#line 385 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp136_ = treeview;
#line 385 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp137_ = gtk_tree_view_get_selection (_tmp136_);
#line 385 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp138_ = _g_object_ref0 (_tmp137_);
#line 385 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (treeselection);
#line 385 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	treeselection = _tmp138_;
#line 386 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp139_ = treeselection;
#line 386 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect (_tmp139_, "changed", (GCallback) _tracker_needle_view_row_selected_gtk_tree_selection_changed, self);
#line 387 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp140_ = self->priv->view;
#line 387 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp141_ = self->priv->sw_categories;
#line 387 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_box_pack_start (_tmp140_, (GtkWidget*) _tmp141_, TRUE, TRUE, (guint) 0);
#line 389 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp142_ = TRACKER_VIEW_DISPLAY_FILE_LIST;
#line 389 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp143_ = tracker_view_new (&_tmp142_, NULL);
#line 389 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_object_ref_sink (_tmp143_);
#line 389 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->sw_filelist);
#line 389 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->sw_filelist = _tmp143_;
#line 390 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp144_ = self->priv->sw_filelist;
#line 390 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp145_ = gtk_bin_get_child ((GtkBin*) _tmp144_);
#line 390 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp146_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp145_, gtk_tree_view_get_type (), GtkTreeView));
#line 390 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (treeview);
#line 390 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	treeview = _tmp146_;
#line 391 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp147_ = treeview;
#line 391 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect (_tmp147_, "row-activated", (GCallback) _tracker_needle_view_row_activated_gtk_tree_view_row_activated, self);
#line 392 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp148_ = treeview;
#line 392 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp149_ = gtk_tree_view_get_selection (_tmp148_);
#line 392 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp150_ = _g_object_ref0 (_tmp149_);
#line 392 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (treeselection);
#line 392 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	treeselection = _tmp150_;
#line 393 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp151_ = treeselection;
#line 393 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect (_tmp151_, "changed", (GCallback) _tracker_needle_view_row_selected_gtk_tree_selection_changed, self);
#line 394 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp152_ = self->priv->view;
#line 394 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp153_ = self->priv->sw_filelist;
#line 394 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_box_pack_start (_tmp152_, (GtkWidget*) _tmp153_, TRUE, TRUE, (guint) 0);
#line 396 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp154_ = TRACKER_VIEW_DISPLAY_FILE_ICONS;
#line 396 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp155_ = tracker_view_new (&_tmp154_, NULL);
#line 396 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_object_ref_sink (_tmp155_);
#line 396 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->sw_icons);
#line 396 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->sw_icons = _tmp155_;
#line 397 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp156_ = self->priv->sw_icons;
#line 397 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp157_ = gtk_bin_get_child ((GtkBin*) _tmp156_);
#line 397 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp158_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp157_, gtk_icon_view_get_type (), GtkIconView));
#line 397 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (iconview);
#line 397 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	iconview = _tmp158_;
#line 398 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp159_ = iconview;
#line 398 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect (_tmp159_, "item-activated", (GCallback) _tracker_needle_icon_item_activated_gtk_icon_view_item_activated, self);
#line 399 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp160_ = iconview;
#line 399 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect (_tmp160_, "selection-changed", (GCallback) _tracker_needle_icon_view_selection_changed_gtk_icon_view_selection_changed, self);
#line 400 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp161_ = self->priv->view;
#line 400 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp162_ = self->priv->sw_icons;
#line 400 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_box_pack_start (_tmp161_, (GtkWidget*) _tmp162_, TRUE, TRUE, (guint) 0);
#line 403 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp163_ = gtk_builder_get_object (builder, "hpaned");
#line 403 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp164_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp163_, gtk_paned_get_type ()) ? ((GtkPaned*) _tmp163_) : NULL);
#line 403 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (paned);
#line 403 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	paned = _tmp164_;
#line 404 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp165_ = tracker_tags_view_new (NULL);
#line 404 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_object_ref_sink (_tmp165_);
#line 404 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->tags_view);
#line 404 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->tags_view = _tmp165_;
#line 405 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp166_ = self->priv->tags_view;
#line 405 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_widget_hide ((GtkWidget*) _tmp166_);
#line 406 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp167_ = self->priv->tags_view;
#line 406 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_tags_view_hide_label (_tmp167_);
#line 407 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp168_ = paned;
#line 407 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp169_ = self->priv->tags_view;
#line 407 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_paned_pack2 (_tmp168_, (GtkWidget*) _tmp169_, FALSE, FALSE);
#line 410 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp170_ = self->priv->view_categories;
#line 410 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_toggle_tool_button_set_active (_tmp170_, FALSE);
#line 411 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp171_ = self->priv->view_icons;
#line 411 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_toggle_tool_button_set_active (_tmp171_, FALSE);
#line 412 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp172_ = self->priv->view_filelist;
#line 412 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_toggle_tool_button_set_active (_tmp172_, FALSE);
#line 415 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp173_ = self->priv->settings_needle;
#line 415 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp174_ = g_settings_get_int (_tmp173_, "default-view");
#line 415 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->default_view = _tmp174_;
#line 417 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp175_ = self->priv->default_view;
#line 417 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp175_ == 0) {
#line 1823 "tracker-needle.c"
		GtkToggleToolButton* _tmp176_ = NULL;
#line 418 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp176_ = self->priv->view_icons;
#line 418 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_toggle_tool_button_set_active (_tmp176_, TRUE);
#line 1829 "tracker-needle.c"
	} else {
		gint _tmp177_ = 0;
#line 419 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp177_ = self->priv->default_view;
#line 419 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		if (_tmp177_ == 2) {
#line 1836 "tracker-needle.c"
			GtkToggleToolButton* _tmp178_ = NULL;
#line 420 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp178_ = self->priv->view_filelist;
#line 420 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			gtk_toggle_tool_button_set_active (_tmp178_, TRUE);
#line 1842 "tracker-needle.c"
		} else {
			GtkToggleToolButton* _tmp179_ = NULL;
#line 422 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp179_ = self->priv->view_categories;
#line 422 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			gtk_toggle_tool_button_set_active (_tmp179_, TRUE);
#line 1849 "tracker-needle.c"
		}
	}
#line 267 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (treeselection);
#line 267 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (iconview);
#line 267 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (treeview);
#line 267 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (paned);
#line 267 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (toolbar);
#line 267 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (info_bar_button);
#line 267 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (builder);
#line 1866 "tracker-needle.c"
}


static gboolean tracker_needle_window_key_press_event (TrackerNeedle* self, GtkWidget* widget, GdkEventKey* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventKey* _tmp1_ = NULL;
	GdkModifierType _tmp2_ = 0;
#line 426 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 426 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 426 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 428 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp1_ = event;
#line 428 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp2_ = _tmp1_->state;
#line 428 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if ((_tmp2_ & GDK_CONTROL_MASK) == GDK_CONTROL_MASK) {
#line 1887 "tracker-needle.c"
		GdkEventKey* _tmp3_ = NULL;
		guint _tmp4_ = 0U;
		const gchar* _tmp5_ = NULL;
#line 428 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp3_ = event;
#line 428 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp4_ = _tmp3_->keyval;
#line 428 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp5_ = gdk_keyval_name (_tmp4_);
#line 428 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp0_ = g_strcmp0 (_tmp5_, "w") == 0;
#line 1899 "tracker-needle.c"
	} else {
#line 428 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp0_ = FALSE;
#line 1903 "tracker-needle.c"
	}
#line 428 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp0_) {
#line 1907 "tracker-needle.c"
		GtkWidget* _tmp6_ = NULL;
#line 429 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp6_ = widget;
#line 429 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_widget_destroy (_tmp6_);
#line 1913 "tracker-needle.c"
	}
#line 432 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	result = FALSE;
#line 432 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	return result;
#line 1919 "tracker-needle.c"
}


static gboolean tracker_needle_search_key_press_event (TrackerNeedle* self, GtkWidget* widget, GdkEventKey* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventKey* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	const gchar* _tmp3_ = NULL;
#line 435 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 435 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 435 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 436 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp1_ = event;
#line 436 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp2_ = _tmp1_->keyval;
#line 436 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp3_ = gdk_keyval_name (_tmp2_);
#line 436 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (g_strcmp0 (_tmp3_, "Down") == 0) {
#line 436 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp0_ = TRUE;
#line 1945 "tracker-needle.c"
	} else {
		GdkEventKey* _tmp4_ = NULL;
		guint _tmp5_ = 0U;
		const gchar* _tmp6_ = NULL;
#line 437 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp4_ = event;
#line 437 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp5_ = _tmp4_->keyval;
#line 437 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp6_ = gdk_keyval_name (_tmp5_);
#line 437 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp0_ = g_strcmp0 (_tmp6_, "KP_Down") == 0;
#line 1958 "tracker-needle.c"
	}
#line 436 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp0_) {
#line 1962 "tracker-needle.c"
		GtkWidget* child = NULL;
		GtkWidget* _tmp7_ = NULL;
		GtkWidget* _tmp8_ = NULL;
		GtkWidget* _tmp9_ = NULL;
		GtkWidget* _tmp10_ = NULL;
#line 438 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp7_ = self->priv->current_view;
#line 438 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp8_ = gtk_bin_get_child ((GtkBin*) G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_scrolled_window_get_type (), GtkScrolledWindow));
#line 438 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp9_ = _g_object_ref0 (_tmp8_);
#line 438 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		child = _tmp9_;
#line 440 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp10_ = child;
#line 440 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		if (_tmp10_ != NULL) {
#line 1980 "tracker-needle.c"
			GtkWidget* _tmp11_ = NULL;
#line 441 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp11_ = child;
#line 441 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			gtk_widget_grab_focus (_tmp11_);
#line 1986 "tracker-needle.c"
		}
#line 436 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_object_unref0 (child);
#line 1990 "tracker-needle.c"
	}
#line 445 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	result = FALSE;
#line 445 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	return result;
#line 1996 "tracker-needle.c"
}


static gboolean _tracker_needle_search_run_gsource_func (gpointer self) {
	gboolean result;
	result = tracker_needle_search_run ((TrackerNeedle*) self);
#line 453 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	return result;
#line 2005 "tracker-needle.c"
}


static void tracker_needle_search_changed (TrackerNeedle* self, GtkEditable* editable) {
	guint _tmp0_ = 0U;
	guint _tmp2_ = 0U;
#line 448 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (self != NULL);
#line 448 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (editable != NULL);
#line 449 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = self->priv->last_search_id;
#line 449 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp0_ != ((guint) 0)) {
#line 2020 "tracker-needle.c"
		guint _tmp1_ = 0U;
#line 450 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp1_ = self->priv->last_search_id;
#line 450 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_source_remove (_tmp1_);
#line 2026 "tracker-needle.c"
	}
#line 453 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp2_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, _tracker_needle_search_run_gsource_func, tracker_needle_ref (self), tracker_needle_unref);
#line 453 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->last_search_id = _tmp2_;
#line 2032 "tracker-needle.c"
}


static void tracker_needle_search_activated (TrackerNeedle* self, GtkEntry* entry) {
	guint _tmp0_ = 0U;
#line 456 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (self != NULL);
#line 456 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (entry != NULL);
#line 457 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = self->priv->last_search_id;
#line 457 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp0_ != ((guint) 0)) {
#line 2046 "tracker-needle.c"
		guint _tmp1_ = 0U;
#line 458 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp1_ = self->priv->last_search_id;
#line 458 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_source_remove (_tmp1_);
#line 459 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		self->priv->last_search_id = (guint) 0;
#line 2054 "tracker-needle.c"
	}
#line 462 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_needle_search_run (self);
#line 2058 "tracker-needle.c"
}


static void tracker_needle_search_finished (TrackerNeedle* self, TrackerResultStore* store) {
	gboolean _tmp0_ = FALSE;
	TrackerResultStore* _tmp1_ = NULL;
#line 465 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (self != NULL);
#line 467 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp1_ = store;
#line 467 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp1_ == NULL) {
#line 467 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp0_ = TRUE;
#line 2073 "tracker-needle.c"
	} else {
		TrackerResultStore* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 467 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp2_ = store;
#line 467 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp3_ = tracker_result_store_has_results (_tmp2_);
#line 467 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp0_ = !_tmp3_;
#line 2083 "tracker-needle.c"
	}
#line 467 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp0_) {
#line 2087 "tracker-needle.c"
		TrackerView* _tmp4_ = NULL;
		TrackerView* _tmp5_ = NULL;
		TrackerView* _tmp6_ = NULL;
		TrackerView* _tmp7_ = NULL;
#line 468 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp4_ = self->priv->sw_noresults;
#line 468 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_widget_show ((GtkWidget*) _tmp4_);
#line 469 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp5_ = self->priv->sw_icons;
#line 469 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_widget_hide ((GtkWidget*) _tmp5_);
#line 470 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp6_ = self->priv->sw_categories;
#line 470 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_widget_hide ((GtkWidget*) _tmp6_);
#line 471 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp7_ = self->priv->sw_filelist;
#line 471 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_widget_hide ((GtkWidget*) _tmp7_);
#line 2108 "tracker-needle.c"
	}
}


static GtkTreeIter* _gtk_tree_iter_dup (GtkTreeIter* self) {
	GtkTreeIter* dup;
#line 495 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	dup = g_new0 (GtkTreeIter, 1);
#line 495 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	memcpy (dup, self, sizeof (GtkTreeIter));
#line 495 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	return dup;
#line 2121 "tracker-needle.c"
}


static gpointer __gtk_tree_iter_dup0 (gpointer self) {
#line 495 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	return self ? _gtk_tree_iter_dup (self) : NULL;
#line 2128 "tracker-needle.c"
}


static GtkTreeIter* tracker_needle_search_history_find_or_insert (TrackerNeedle* self, const gchar* criteria, gboolean* add_to_model) {
	GtkTreeIter* result = NULL;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GtkComboBox* combo = NULL;
	GtkComboBox* _tmp3_ = NULL;
	GtkComboBox* _tmp4_ = NULL;
	GtkTreeModel* model = NULL;
	GtkComboBox* _tmp5_ = NULL;
	GtkTreeModel* _tmp6_ = NULL;
	GtkTreeModel* _tmp7_ = NULL;
	gchar* criteria_folded = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	GtkTreeIter iter = {0};
	gboolean valid = FALSE;
	GtkTreeModel* _tmp10_ = NULL;
	GtkTreeIter _tmp11_ = {0};
	gboolean _tmp12_ = FALSE;
	gboolean* _tmp23_ = NULL;
#line 475 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 475 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_val_if_fail (criteria != NULL, NULL);
#line 476 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = criteria;
#line 476 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp1_ = strlen (_tmp0_);
#line 476 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp2_ = _tmp1_;
#line 476 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp2_ < 1) {
#line 477 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		result = NULL;
#line 477 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		return result;
#line 2169 "tracker-needle.c"
	}
#line 480 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp3_ = self->priv->search_list;
#line 480 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_combo_box_get_type ()) ? ((GtkComboBox*) _tmp3_) : NULL);
#line 480 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	combo = _tmp4_;
#line 481 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp5_ = combo;
#line 481 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp6_ = gtk_combo_box_get_model (_tmp5_);
#line 481 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp7_ = _g_object_ref0 (_tmp6_);
#line 481 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	model = _tmp7_;
#line 482 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp8_ = criteria;
#line 482 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp9_ = g_utf8_casefold (_tmp8_, (gssize) -1);
#line 482 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	criteria_folded = _tmp9_;
#line 485 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp10_ = model;
#line 485 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp12_ = gtk_tree_model_iter_children (_tmp10_, &_tmp11_, NULL);
#line 485 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	iter = _tmp11_;
#line 485 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	valid = _tmp12_;
#line 487 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	while (TRUE) {
#line 2201 "tracker-needle.c"
		gboolean _tmp13_ = FALSE;
		gchar* text = NULL;
		GtkTreeModel* _tmp14_ = NULL;
		GtkTreeIter _tmp15_ = {0};
		gchar* text_folded = NULL;
		const gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		GtkTreeModel* _tmp21_ = NULL;
		gboolean _tmp22_ = FALSE;
#line 487 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp13_ = valid;
#line 487 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		if (!_tmp13_) {
#line 487 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			break;
#line 2219 "tracker-needle.c"
		}
#line 490 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp14_ = model;
#line 490 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp15_ = iter;
#line 490 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_tree_model_get (_tmp14_, &_tmp15_, 0, &text, -1, -1);
#line 492 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp16_ = text;
#line 492 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp17_ = g_utf8_casefold (_tmp16_, (gssize) -1);
#line 492 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		text_folded = _tmp17_;
#line 494 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp18_ = text_folded;
#line 494 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp19_ = criteria_folded;
#line 494 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		if (g_strcmp0 (_tmp18_, _tmp19_) == 0) {
#line 2239 "tracker-needle.c"
			GtkTreeIter* _tmp20_ = NULL;
#line 495 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp20_ = __gtk_tree_iter_dup0 (&iter);
#line 495 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			result = _tmp20_;
#line 495 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_g_free0 (text_folded);
#line 495 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_g_free0 (text);
#line 495 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_g_free0 (criteria_folded);
#line 495 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_g_object_unref0 (model);
#line 495 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_g_object_unref0 (combo);
#line 495 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			return result;
#line 2257 "tracker-needle.c"
		}
#line 498 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp21_ = model;
#line 498 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp22_ = gtk_tree_model_iter_next (_tmp21_, &iter);
#line 498 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		valid = _tmp22_;
#line 487 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_free0 (text_folded);
#line 487 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_free0 (text);
#line 2269 "tracker-needle.c"
	}
#line 501 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp23_ = add_to_model;
#line 501 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (*_tmp23_) {
#line 2275 "tracker-needle.c"
		GtkTreeIter new_iter = {0};
		GtkListStore* store = NULL;
		GtkTreeModel* _tmp24_ = NULL;
		GtkListStore* _tmp25_ = NULL;
		GtkListStore* _tmp26_ = NULL;
		GtkTreeIter _tmp27_ = {0};
		GtkListStore* _tmp28_ = NULL;
		GtkTreeIter _tmp29_ = {0};
		const gchar* _tmp30_ = NULL;
		TrackerHistory* _tmp31_ = NULL;
		const gchar* _tmp32_ = NULL;
#line 504 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp24_ = model;
#line 504 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp25_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_list_store_get_type (), GtkListStore));
#line 504 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		store = _tmp25_;
#line 505 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp26_ = store;
#line 505 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_list_store_prepend (_tmp26_, &_tmp27_);
#line 505 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		new_iter = _tmp27_;
#line 506 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp28_ = store;
#line 506 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp29_ = new_iter;
#line 506 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp30_ = criteria;
#line 506 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_list_store_set (_tmp28_, &_tmp29_, 0, _tmp30_, -1, -1);
#line 508 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp31_ = self->priv->history;
#line 508 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp32_ = criteria;
#line 508 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		tracker_history_add (_tmp31_, _tmp32_);
#line 501 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_object_unref0 (store);
#line 2315 "tracker-needle.c"
	}
#line 511 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	result = NULL;
#line 511 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_free0 (criteria_folded);
#line 511 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (model);
#line 511 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (combo);
#line 511 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	return result;
#line 2327 "tracker-needle.c"
}


static void tracker_needle_search_history_insert (TrackerNeedle* self, gchar** history, int history_length1) {
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
#line 514 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (self != NULL);
#line 515 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = history;
#line 515 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0__length1 = history_length1;
#line 2340 "tracker-needle.c"
	{
		gchar** criteria_collection = NULL;
		gint criteria_collection_length1 = 0;
		gint _criteria_collection_size_ = 0;
		gint criteria_it = 0;
#line 515 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		criteria_collection = _tmp0_;
#line 515 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		criteria_collection_length1 = _tmp0__length1;
#line 515 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		for (criteria_it = 0; criteria_it < _tmp0__length1; criteria_it = criteria_it + 1) {
#line 2352 "tracker-needle.c"
			gchar* _tmp1_ = NULL;
			gchar* criteria = NULL;
#line 515 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp1_ = g_strdup (criteria_collection[criteria_it]);
#line 515 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			criteria = _tmp1_;
#line 2359 "tracker-needle.c"
			{
				const gchar* _tmp2_ = NULL;
				gboolean _tmp3_ = FALSE;
				GtkTreeIter* _tmp4_ = NULL;
				GtkTreeIter* _tmp5_ = NULL;
#line 516 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp2_ = criteria;
#line 516 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp3_ = TRUE;
#line 516 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp4_ = tracker_needle_search_history_find_or_insert (self, _tmp2_, &_tmp3_);
#line 516 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp5_ = _tmp4_;
#line 516 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_g_free0 (_tmp5_);
#line 515 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_g_free0 (criteria);
#line 2377 "tracker-needle.c"
			}
		}
	}
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 1115 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1116 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1116 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1117 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1117 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	g_strstrip (_tmp1_);
#line 1118 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	result = _result_;
#line 1118 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	return result;
#line 2403 "tracker-needle.c"
}


static gchar* _vala_g_strjoinv (const gchar* separator, gchar** str_array, int str_array_length1) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
#line 964 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp0_ = separator;
#line 964 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp0_ == NULL) {
#line 965 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		separator = "";
#line 2420 "tracker-needle.c"
	}
#line 967 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp3_ = str_array;
#line 967 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp3__length1 = str_array_length1;
#line 967 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 967 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp2_ = TRUE;
#line 2430 "tracker-needle.c"
	} else {
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
#line 967 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp4_ = str_array;
#line 967 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp4__length1 = str_array_length1;
#line 967 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp4__length1 > 0;
#line 2440 "tracker-needle.c"
	}
#line 967 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp2_) {
#line 967 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 2446 "tracker-needle.c"
	} else {
		gboolean _tmp5_ = FALSE;
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
#line 967 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp6_ = str_array;
#line 967 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp6__length1 = str_array_length1;
#line 967 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		if (_tmp6__length1 == -1) {
#line 2457 "tracker-needle.c"
			gchar** _tmp7_ = NULL;
			gint _tmp7__length1 = 0;
			const gchar* _tmp8_ = NULL;
#line 967 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
			_tmp7_ = str_array;
#line 967 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
			_tmp7__length1 = str_array_length1;
#line 967 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
			_tmp8_ = _tmp7_[0];
#line 967 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
			_tmp5_ = _tmp8_ != NULL;
#line 2469 "tracker-needle.c"
		} else {
#line 967 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
			_tmp5_ = FALSE;
#line 2473 "tracker-needle.c"
		}
#line 967 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp1_ = _tmp5_;
#line 2477 "tracker-needle.c"
	}
#line 967 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp1_) {
#line 2481 "tracker-needle.c"
		gint i = 0;
		gsize len = 0UL;
		gint _tmp31_ = 0;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		gsize _tmp35_ = 0UL;
		const gchar* _tmp36_ = NULL;
		gint _tmp37_ = 0;
		gint _tmp38_ = 0;
		gint _tmp39_ = 0;
		const gchar* res = NULL;
		gsize _tmp40_ = 0UL;
		void* _tmp41_ = NULL;
		void* ptr = NULL;
		const gchar* _tmp42_ = NULL;
		gchar** _tmp43_ = NULL;
		gint _tmp43__length1 = 0;
		const gchar* _tmp44_ = NULL;
		void* _tmp45_ = NULL;
		const gchar* _tmp62_ = NULL;
#line 969 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		len = (gsize) 1;
#line 2504 "tracker-needle.c"
		{
			gboolean _tmp9_ = FALSE;
#line 970 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
			i = 0;
#line 970 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
			_tmp9_ = TRUE;
#line 970 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
			while (TRUE) {
#line 2513 "tracker-needle.c"
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gchar** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gint _tmp21_ = 0;
				gchar** _tmp22_ = NULL;
				gint _tmp22__length1 = 0;
				gint _tmp23_ = 0;
				const gchar* _tmp24_ = NULL;
				gsize _tmp30_ = 0UL;
#line 970 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
				if (!_tmp9_) {
#line 2526 "tracker-needle.c"
					gint _tmp10_ = 0;
#line 970 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp10_ = i;
#line 970 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
					i = _tmp10_ + 1;
#line 2532 "tracker-needle.c"
				}
#line 970 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp9_ = FALSE;
#line 970 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp13_ = str_array;
#line 970 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp13__length1 = str_array_length1;
#line 970 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
				if (_tmp13__length1 != -1) {
#line 2542 "tracker-needle.c"
					gint _tmp14_ = 0;
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
#line 970 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp14_ = i;
#line 970 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp15_ = str_array;
#line 970 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp15__length1 = str_array_length1;
#line 970 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp12_ = _tmp14_ < _tmp15__length1;
#line 2554 "tracker-needle.c"
				} else {
#line 970 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp12_ = FALSE;
#line 2558 "tracker-needle.c"
				}
#line 970 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
				if (_tmp12_) {
#line 970 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp11_ = TRUE;
#line 2564 "tracker-needle.c"
				} else {
					gboolean _tmp16_ = FALSE;
					gchar** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
#line 970 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp17_ = str_array;
#line 970 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp17__length1 = str_array_length1;
#line 970 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
					if (_tmp17__length1 == -1) {
#line 2575 "tracker-needle.c"
						gchar** _tmp18_ = NULL;
						gint _tmp18__length1 = 0;
						gint _tmp19_ = 0;
						const gchar* _tmp20_ = NULL;
#line 970 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
						_tmp18_ = str_array;
#line 970 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
						_tmp18__length1 = str_array_length1;
#line 970 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
						_tmp19_ = i;
#line 970 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
						_tmp20_ = _tmp18_[_tmp19_];
#line 970 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
						_tmp16_ = _tmp20_ != NULL;
#line 2590 "tracker-needle.c"
					} else {
#line 970 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
						_tmp16_ = FALSE;
#line 2594 "tracker-needle.c"
					}
#line 970 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp11_ = _tmp16_;
#line 2598 "tracker-needle.c"
				}
#line 970 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
				if (!_tmp11_) {
#line 970 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
					break;
#line 2604 "tracker-needle.c"
				}
#line 971 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp22_ = str_array;
#line 971 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp22__length1 = str_array_length1;
#line 971 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp23_ = i;
#line 971 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp24_ = _tmp22_[_tmp23_];
#line 971 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
				if (_tmp24_ != NULL) {
#line 2616 "tracker-needle.c"
					gchar** _tmp25_ = NULL;
					gint _tmp25__length1 = 0;
					gint _tmp26_ = 0;
					const gchar* _tmp27_ = NULL;
					gint _tmp28_ = 0;
					gint _tmp29_ = 0;
#line 971 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp25_ = str_array;
#line 971 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp25__length1 = str_array_length1;
#line 971 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp26_ = i;
#line 971 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp27_ = _tmp25_[_tmp26_];
#line 971 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp28_ = strlen ((const gchar*) _tmp27_);
#line 971 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp29_ = _tmp28_;
#line 971 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp21_ = _tmp29_;
#line 2637 "tracker-needle.c"
				} else {
#line 971 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp21_ = 0;
#line 2641 "tracker-needle.c"
				}
#line 971 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp30_ = len;
#line 971 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
				len = _tmp30_ + _tmp21_;
#line 2647 "tracker-needle.c"
			}
		}
#line 973 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp31_ = i;
#line 973 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		if (_tmp31_ == 0) {
#line 2654 "tracker-needle.c"
			gchar* _tmp32_ = NULL;
#line 974 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
			_tmp32_ = g_strdup ("");
#line 974 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
			result = _tmp32_;
#line 974 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
			return result;
#line 2662 "tracker-needle.c"
		}
#line 976 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp33_ = i;
#line 976 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		str_array_length1 = _tmp33_;
#line 976 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp34_ = str_array_length1;
#line 977 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp35_ = len;
#line 977 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp36_ = separator;
#line 977 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp37_ = strlen ((const gchar*) _tmp36_);
#line 977 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp38_ = _tmp37_;
#line 977 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp39_ = i;
#line 977 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		len = _tmp35_ + (_tmp38_ * (_tmp39_ - 1));
#line 979 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp40_ = len;
#line 979 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp41_ = g_malloc (_tmp40_);
#line 979 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		res = _tmp41_;
#line 980 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp42_ = res;
#line 980 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp43_ = str_array;
#line 980 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp43__length1 = str_array_length1;
#line 980 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp44_ = _tmp43_[0];
#line 980 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp45_ = g_stpcpy ((void*) _tmp42_, (const gchar*) _tmp44_);
#line 980 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		ptr = _tmp45_;
#line 2700 "tracker-needle.c"
		{
			gboolean _tmp46_ = FALSE;
#line 981 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
			i = 1;
#line 981 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
			_tmp46_ = TRUE;
#line 981 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
			while (TRUE) {
#line 2709 "tracker-needle.c"
				gint _tmp48_ = 0;
				gchar** _tmp49_ = NULL;
				gint _tmp49__length1 = 0;
				void* _tmp50_ = NULL;
				const gchar* _tmp51_ = NULL;
				void* _tmp52_ = NULL;
				const gchar* _tmp53_ = NULL;
				gchar** _tmp54_ = NULL;
				gint _tmp54__length1 = 0;
				gint _tmp55_ = 0;
				const gchar* _tmp56_ = NULL;
				void* _tmp60_ = NULL;
				void* _tmp61_ = NULL;
#line 981 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
				if (!_tmp46_) {
#line 2725 "tracker-needle.c"
					gint _tmp47_ = 0;
#line 981 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp47_ = i;
#line 981 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
					i = _tmp47_ + 1;
#line 2731 "tracker-needle.c"
				}
#line 981 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp46_ = FALSE;
#line 981 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp48_ = i;
#line 981 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp49_ = str_array;
#line 981 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp49__length1 = str_array_length1;
#line 981 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
				if (!(_tmp48_ < _tmp49__length1)) {
#line 981 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
					break;
#line 2745 "tracker-needle.c"
				}
#line 982 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp50_ = ptr;
#line 982 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp51_ = separator;
#line 982 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp52_ = g_stpcpy (_tmp50_, (const gchar*) _tmp51_);
#line 982 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
				ptr = _tmp52_;
#line 983 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp54_ = str_array;
#line 983 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp54__length1 = str_array_length1;
#line 983 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp55_ = i;
#line 983 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp56_ = _tmp54_[_tmp55_];
#line 983 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
				if (_tmp56_ != NULL) {
#line 2765 "tracker-needle.c"
					gchar** _tmp57_ = NULL;
					gint _tmp57__length1 = 0;
					gint _tmp58_ = 0;
					const gchar* _tmp59_ = NULL;
#line 983 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp57_ = str_array;
#line 983 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp57__length1 = str_array_length1;
#line 983 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp58_ = i;
#line 983 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp59_ = _tmp57_[_tmp58_];
#line 983 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp53_ = (const gchar*) _tmp59_;
#line 2780 "tracker-needle.c"
				} else {
#line 983 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
					_tmp53_ = "";
#line 2784 "tracker-needle.c"
				}
#line 983 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp60_ = ptr;
#line 983 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
				_tmp61_ = g_stpcpy (_tmp60_, _tmp53_);
#line 983 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
				ptr = _tmp61_;
#line 2792 "tracker-needle.c"
			}
		}
#line 986 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp62_ = res;
#line 986 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		res = NULL;
#line 986 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		result = (gchar*) _tmp62_;
#line 986 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		return result;
#line 2803 "tracker-needle.c"
	} else {
		gchar* _tmp63_ = NULL;
#line 988 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp63_ = g_strdup ("");
#line 988 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		result = _tmp63_;
#line 988 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		return result;
#line 2812 "tracker-needle.c"
	}
}


static gboolean tracker_needle_search_run (TrackerNeedle* self) {
	gboolean result = FALSE;
	gchar* str = NULL;
	GtkEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* criteria = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	TrackerResultStore* store = NULL;
	GtkToggleToolButton* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	TrackerView* _tmp23_ = NULL;
	TrackerView* _tmp24_ = NULL;
	GtkWidget* _tmp25_ = NULL;
	GtkToggleToolButton* _tmp26_ = NULL;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp28_ = FALSE;
	GtkToggleToolButton* _tmp42_ = NULL;
	gboolean _tmp43_ = FALSE;
	gboolean _tmp44_ = FALSE;
	GtkToggleToolButton* _tmp51_ = NULL;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_ = FALSE;
	TrackerResultStore* _tmp81_ = NULL;
#line 520 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 521 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->last_search_id = (guint) 0;
#line 523 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = self->priv->search;
#line 523 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp1_ = gtk_entry_get_text (_tmp0_);
#line 523 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 523 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	str = _tmp2_;
#line 524 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp3_ = str;
#line 524 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp4_ = string_strip (_tmp3_);
#line 524 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	criteria = _tmp4_;
#line 525 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	store = NULL;
#line 527 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp5_ = self->priv->show_tags;
#line 527 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp6_ = gtk_toggle_tool_button_get_active (_tmp5_);
#line 527 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp7_ = _tmp6_;
#line 527 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (!_tmp7_) {
#line 2871 "tracker-needle.c"
		const gchar* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		const gchar* _tmp19_ = NULL;
		gboolean _tmp20_ = FALSE;
		GtkTreeIter* _tmp21_ = NULL;
		GtkTreeIter* _tmp22_ = NULL;
#line 528 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp8_ = criteria;
#line 528 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp9_ = strlen (_tmp8_);
#line 528 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp10_ = _tmp9_;
#line 528 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		if (_tmp10_ < 3) {
#line 2887 "tracker-needle.c"
			gboolean _tmp11_ = FALSE;
			GtkToggleToolButton* _tmp12_ = NULL;
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_ = FALSE;
#line 530 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp12_ = self->priv->view_icons;
#line 530 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp13_ = gtk_toggle_tool_button_get_active (_tmp12_);
#line 530 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp14_ = _tmp13_;
#line 530 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			if (!_tmp14_) {
#line 530 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp11_ = TRUE;
#line 2902 "tracker-needle.c"
			} else {
				GtkToggleToolButton* _tmp15_ = NULL;
				gboolean _tmp16_ = FALSE;
				gboolean _tmp17_ = FALSE;
#line 530 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp15_ = self->priv->find_in_all;
#line 530 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp16_ = gtk_toggle_tool_button_get_active (_tmp15_);
#line 530 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp17_ = _tmp16_;
#line 530 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp11_ = !_tmp17_;
#line 2915 "tracker-needle.c"
			}
#line 530 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			if (_tmp11_) {
#line 2919 "tracker-needle.c"
				TrackerResultStore* _tmp18_ = NULL;
#line 531 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp18_ = store;
#line 531 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				tracker_needle_search_finished (self, _tmp18_);
#line 532 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				result = FALSE;
#line 532 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_g_object_unref0 (store);
#line 532 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_g_free0 (criteria);
#line 532 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_g_free0 (str);
#line 532 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				return result;
#line 2935 "tracker-needle.c"
			}
		}
#line 536 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp19_ = criteria;
#line 536 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp20_ = TRUE;
#line 536 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp21_ = tracker_needle_search_history_find_or_insert (self, _tmp19_, &_tmp20_);
#line 536 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp22_ = _tmp21_;
#line 536 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_free0 (_tmp22_);
#line 2948 "tracker-needle.c"
	}
#line 540 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp23_ = self->priv->sw_noresults;
#line 540 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_widget_hide ((GtkWidget*) _tmp23_);
#line 541 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp24_ = self->priv->sw_noresults;
#line 541 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp25_ = _g_object_ref0 ((GtkWidget*) _tmp24_);
#line 541 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->current_view);
#line 541 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->current_view = _tmp25_;
#line 543 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp26_ = self->priv->view_icons;
#line 543 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp27_ = gtk_toggle_tool_button_get_active (_tmp26_);
#line 543 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp28_ = _tmp27_;
#line 543 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp28_) {
#line 2970 "tracker-needle.c"
		TrackerView* _tmp29_ = NULL;
		TrackerView* _tmp30_ = NULL;
		GtkWidget* _tmp31_ = NULL;
		GtkToggleToolButton* _tmp32_ = NULL;
		gboolean _tmp33_ = FALSE;
		gboolean _tmp34_ = FALSE;
		TrackerView* _tmp39_ = NULL;
		TrackerResultStore* _tmp40_ = NULL;
#line 544 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp29_ = self->priv->sw_icons;
#line 544 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_widget_show ((GtkWidget*) _tmp29_);
#line 545 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp30_ = self->priv->sw_icons;
#line 545 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp31_ = _g_object_ref0 ((GtkWidget*) _tmp30_);
#line 545 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_object_unref0 (self->priv->current_view);
#line 545 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		self->priv->current_view = _tmp31_;
#line 547 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp32_ = self->priv->find_in_all;
#line 547 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp33_ = gtk_toggle_tool_button_get_active (_tmp32_);
#line 547 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp34_ = _tmp33_;
#line 547 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		if (_tmp34_) {
#line 2999 "tracker-needle.c"
			TrackerResultStore* _tmp35_ = NULL;
			TrackerResultStore* _tmp36_ = NULL;
#line 548 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp35_ = self->priv->images_model;
#line 548 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp36_ = _g_object_ref0 (_tmp35_);
#line 548 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_g_object_unref0 (store);
#line 548 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			store = _tmp36_;
#line 3010 "tracker-needle.c"
		} else {
			TrackerResultStore* _tmp37_ = NULL;
			TrackerResultStore* _tmp38_ = NULL;
#line 550 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp37_ = self->priv->images_in_title_model;
#line 550 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp38_ = _g_object_ref0 (_tmp37_);
#line 550 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_g_object_unref0 (store);
#line 550 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			store = _tmp38_;
#line 3022 "tracker-needle.c"
		}
#line 553 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp39_ = self->priv->sw_icons;
#line 553 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp40_ = store;
#line 553 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		tracker_view_set_store (_tmp39_, _tmp40_);
#line 3030 "tracker-needle.c"
	} else {
		TrackerView* _tmp41_ = NULL;
#line 555 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp41_ = self->priv->sw_icons;
#line 555 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_widget_hide ((GtkWidget*) _tmp41_);
#line 3037 "tracker-needle.c"
	}
#line 558 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp42_ = self->priv->view_categories;
#line 558 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp43_ = gtk_toggle_tool_button_get_active (_tmp42_);
#line 558 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp44_ = _tmp43_;
#line 558 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp44_) {
#line 3047 "tracker-needle.c"
		TrackerView* _tmp45_ = NULL;
		TrackerView* _tmp46_ = NULL;
		GtkWidget* _tmp47_ = NULL;
		TrackerResultStore* _tmp48_ = NULL;
		TrackerResultStore* _tmp49_ = NULL;
#line 559 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp45_ = self->priv->sw_categories;
#line 559 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_widget_show ((GtkWidget*) _tmp45_);
#line 560 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp46_ = self->priv->sw_categories;
#line 560 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp47_ = _g_object_ref0 ((GtkWidget*) _tmp46_);
#line 560 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_object_unref0 (self->priv->current_view);
#line 560 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		self->priv->current_view = _tmp47_;
#line 561 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp48_ = self->priv->categories_model;
#line 561 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp49_ = _g_object_ref0 (_tmp48_);
#line 561 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_object_unref0 (store);
#line 561 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		store = _tmp49_;
#line 3073 "tracker-needle.c"
	} else {
		TrackerView* _tmp50_ = NULL;
#line 563 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp50_ = self->priv->sw_categories;
#line 563 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_widget_hide ((GtkWidget*) _tmp50_);
#line 3080 "tracker-needle.c"
	}
#line 566 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp51_ = self->priv->view_filelist;
#line 566 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp52_ = gtk_toggle_tool_button_get_active (_tmp51_);
#line 566 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp53_ = _tmp52_;
#line 566 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp53_) {
#line 3090 "tracker-needle.c"
		TrackerView* _tmp54_ = NULL;
		TrackerView* _tmp55_ = NULL;
		GtkWidget* _tmp56_ = NULL;
		GtkToggleToolButton* _tmp57_ = NULL;
		gboolean _tmp58_ = FALSE;
		gboolean _tmp59_ = FALSE;
		TrackerView* _tmp78_ = NULL;
		TrackerResultStore* _tmp79_ = NULL;
#line 567 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp54_ = self->priv->sw_filelist;
#line 567 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_widget_show ((GtkWidget*) _tmp54_);
#line 568 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp55_ = self->priv->sw_filelist;
#line 568 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp56_ = _g_object_ref0 ((GtkWidget*) _tmp55_);
#line 568 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_object_unref0 (self->priv->current_view);
#line 568 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		self->priv->current_view = _tmp56_;
#line 570 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp57_ = self->priv->find_in_tags;
#line 570 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp58_ = gtk_toggle_tool_button_get_active (_tmp57_);
#line 570 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp59_ = _tmp58_;
#line 570 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		if (_tmp59_) {
#line 3119 "tracker-needle.c"
			TrackerResultStore* _tmp60_ = NULL;
			TrackerResultStore* _tmp61_ = NULL;
			TrackerResultStore* _tmp62_ = NULL;
			GPtrArray* _tmp63_ = NULL;
			GPtrArray* _tmp64_ = NULL;
			TrackerResultStore* _tmp65_ = NULL;
			GPtrArray* _tmp66_ = NULL;
			GPtrArray* _tmp67_ = NULL;
			gpointer* _tmp68_ = NULL;
			gint _tmp68__length1 = 0;
			gchar* _tmp69_ = NULL;
			gchar* _tmp70_ = NULL;
#line 571 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp60_ = self->priv->files_in_tags_model;
#line 571 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp61_ = _g_object_ref0 (_tmp60_);
#line 571 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_g_object_unref0 (store);
#line 571 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			store = _tmp61_;
#line 572 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp62_ = store;
#line 572 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp63_ = tracker_needle_search_tags (self);
#line 572 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp64_ = _tmp63_;
#line 572 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			tracker_result_store_set_search_tags (_tmp62_, _tmp64_);
#line 572 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_g_ptr_array_unref0 (_tmp64_);
#line 573 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp65_ = store;
#line 573 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp66_ = tracker_result_store_get_search_tags (_tmp65_);
#line 573 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp67_ = _tmp66_;
#line 573 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp68_ = _tmp67_->pdata;
#line 573 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp68__length1 = (gint) _tmp67_->len;
#line 573 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp69_ = _vala_g_strjoinv ("; ", _tmp68_, _tmp68__length1);
#line 573 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp70_ = _tmp69_;
#line 573 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			g_debug ("tracker-needle.vala:573: Tags to look for: %s", _tmp70_);
#line 573 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_g_free0 (_tmp70_);
#line 3168 "tracker-needle.c"
		} else {
			GtkToggleToolButton* _tmp71_ = NULL;
			gboolean _tmp72_ = FALSE;
			gboolean _tmp73_ = FALSE;
#line 574 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp71_ = self->priv->find_in_contents;
#line 574 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp72_ = gtk_toggle_tool_button_get_active (_tmp71_);
#line 574 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp73_ = _tmp72_;
#line 574 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			if (_tmp73_) {
#line 3181 "tracker-needle.c"
				TrackerResultStore* _tmp74_ = NULL;
				TrackerResultStore* _tmp75_ = NULL;
#line 575 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp74_ = self->priv->files_model;
#line 575 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp75_ = _g_object_ref0 (_tmp74_);
#line 575 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_g_object_unref0 (store);
#line 575 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				store = _tmp75_;
#line 3192 "tracker-needle.c"
			} else {
				TrackerResultStore* _tmp76_ = NULL;
				TrackerResultStore* _tmp77_ = NULL;
#line 577 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp76_ = self->priv->files_in_title_model;
#line 577 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp77_ = _g_object_ref0 (_tmp76_);
#line 577 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_g_object_unref0 (store);
#line 577 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				store = _tmp77_;
#line 3204 "tracker-needle.c"
			}
		}
#line 580 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp78_ = self->priv->sw_filelist;
#line 580 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp79_ = store;
#line 580 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		tracker_view_set_store (_tmp78_, _tmp79_);
#line 3213 "tracker-needle.c"
	} else {
		TrackerView* _tmp80_ = NULL;
#line 582 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp80_ = self->priv->sw_filelist;
#line 582 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_widget_hide ((GtkWidget*) _tmp80_);
#line 3220 "tracker-needle.c"
	}
#line 585 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp81_ = store;
#line 585 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp81_ != NULL) {
#line 3226 "tracker-needle.c"
		GtkToggleToolButton* _tmp82_ = NULL;
		gboolean _tmp83_ = FALSE;
		gboolean _tmp84_ = FALSE;
		TrackerResultStore* _tmp86_ = NULL;
		GtkEntry* _tmp87_ = NULL;
		const gchar* _tmp88_ = NULL;
#line 588 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp82_ = self->priv->find_in_tags;
#line 588 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp83_ = gtk_toggle_tool_button_get_active (_tmp82_);
#line 588 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp84_ = _tmp83_;
#line 588 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		if (!_tmp84_) {
#line 3241 "tracker-needle.c"
			TrackerResultStore* _tmp85_ = NULL;
#line 589 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp85_ = store;
#line 589 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			tracker_result_store_set_search_tags (_tmp85_, NULL);
#line 3247 "tracker-needle.c"
		}
#line 591 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp86_ = store;
#line 591 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp87_ = self->priv->search;
#line 591 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp88_ = gtk_entry_get_text (_tmp87_);
#line 591 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		tracker_result_store_set_search_term (_tmp86_, _tmp88_);
#line 3257 "tracker-needle.c"
	}
#line 594 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	result = FALSE;
#line 594 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (store);
#line 594 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_free0 (criteria);
#line 594 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_free0 (str);
#line 594 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	return result;
#line 3269 "tracker-needle.c"
}


static void tracker_needle_window_closed (TrackerNeedle* self) {
	GtkToggleToolButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 597 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (self != NULL);
#line 600 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = self->priv->view_icons;
#line 600 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp1_ = gtk_toggle_tool_button_get_active (_tmp0_);
#line 600 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp2_ = _tmp1_;
#line 600 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp2_) {
#line 3287 "tracker-needle.c"
		GSettings* _tmp3_ = NULL;
#line 601 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp3_ = self->priv->settings_needle;
#line 601 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_settings_set_int (_tmp3_, "default-view", 0);
#line 3293 "tracker-needle.c"
	} else {
		GtkToggleToolButton* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
#line 602 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp4_ = self->priv->view_filelist;
#line 602 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp5_ = gtk_toggle_tool_button_get_active (_tmp4_);
#line 602 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp6_ = _tmp5_;
#line 602 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		if (_tmp6_) {
#line 3306 "tracker-needle.c"
			GSettings* _tmp7_ = NULL;
#line 603 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp7_ = self->priv->settings_needle;
#line 603 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			g_settings_set_int (_tmp7_, "default-view", 2);
#line 3312 "tracker-needle.c"
		} else {
			GSettings* _tmp8_ = NULL;
#line 605 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp8_ = self->priv->settings_needle;
#line 605 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			g_settings_set_int (_tmp8_, "default-view", 1);
#line 3319 "tracker-needle.c"
		}
	}
#line 607 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_main_quit ();
#line 3324 "tracker-needle.c"
}


static void tracker_needle_view_toggled (TrackerNeedle* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GtkToggleToolButton* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp11_ = FALSE;
	GtkToggleToolButton* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	TrackerView* _tmp27_ = NULL;
	TrackerView* _tmp28_ = NULL;
	TrackerView* _tmp29_ = NULL;
	TrackerView* _tmp30_ = NULL;
	gboolean _tmp31_ = FALSE;
	GtkToggleToolButton* _tmp32_ = NULL;
	gboolean _tmp33_ = FALSE;
	gboolean _tmp34_ = FALSE;
	GtkSeparatorToolItem* _tmp38_ = NULL;
	GtkToggleToolButton* _tmp39_ = NULL;
	GtkToggleToolButton* _tmp40_ = NULL;
	gboolean _tmp41_ = FALSE;
	gboolean _tmp42_ = FALSE;
	gboolean _tmp43_ = FALSE;
	GtkToggleToolButton* _tmp44_ = NULL;
	gboolean _tmp45_ = FALSE;
	gboolean _tmp46_ = FALSE;
	GtkToggleToolButton* _tmp50_ = NULL;
	GtkToggleToolButton* _tmp51_ = NULL;
	GtkToggleToolButton* _tmp52_ = NULL;
	gboolean _tmp53_ = FALSE;
	gboolean _tmp54_ = FALSE;
	GtkToggleToolButton* _tmp55_ = NULL;
	GtkToggleToolButton* _tmp56_ = NULL;
	gboolean _tmp57_ = FALSE;
	gboolean _tmp58_ = FALSE;
#line 610 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (self != NULL);
#line 611 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp2_ = self->priv->view_icons;
#line 611 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp3_ = gtk_toggle_tool_button_get_active (_tmp2_);
#line 611 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp4_ = _tmp3_;
#line 611 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (!_tmp4_) {
#line 3374 "tracker-needle.c"
		GtkToggleToolButton* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
#line 612 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp5_ = self->priv->view_filelist;
#line 612 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp6_ = gtk_toggle_tool_button_get_active (_tmp5_);
#line 612 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp7_ = _tmp6_;
#line 612 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp1_ = !_tmp7_;
#line 3386 "tracker-needle.c"
	} else {
#line 611 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp1_ = FALSE;
#line 3390 "tracker-needle.c"
	}
#line 611 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp1_) {
#line 3394 "tracker-needle.c"
		GtkToggleToolButton* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
#line 613 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp8_ = self->priv->view_categories;
#line 613 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp9_ = gtk_toggle_tool_button_get_active (_tmp8_);
#line 613 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp10_ = _tmp9_;
#line 613 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp0_ = !_tmp10_;
#line 3406 "tracker-needle.c"
	} else {
#line 611 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp0_ = FALSE;
#line 3410 "tracker-needle.c"
	}
#line 611 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp0_) {
#line 614 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		return;
#line 3416 "tracker-needle.c"
	}
#line 617 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp12_ = self->priv->view_categories;
#line 617 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp13_ = gtk_toggle_tool_button_get_active (_tmp12_);
#line 617 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp14_ = _tmp13_;
#line 617 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp14_) {
#line 617 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp11_ = TRUE;
#line 3428 "tracker-needle.c"
	} else {
		GtkToggleToolButton* _tmp15_ = NULL;
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_ = FALSE;
#line 617 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp15_ = self->priv->view_filelist;
#line 617 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp16_ = gtk_toggle_tool_button_get_active (_tmp15_);
#line 617 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp17_ = _tmp16_;
#line 617 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp11_ = _tmp17_;
#line 3441 "tracker-needle.c"
	}
#line 617 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp11_) {
#line 3445 "tracker-needle.c"
		gboolean _tmp18_ = FALSE;
#line 618 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp18_ = tracker_needle_current_find_in_filelist;
#line 618 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		if (_tmp18_) {
#line 3451 "tracker-needle.c"
			GtkToggleToolButton* _tmp19_ = NULL;
#line 619 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp19_ = self->priv->find_in_contents;
#line 619 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			gtk_toggle_tool_button_set_active (_tmp19_, TRUE);
#line 3457 "tracker-needle.c"
		} else {
			GtkToggleToolButton* _tmp20_ = NULL;
#line 621 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp20_ = self->priv->find_in_titles;
#line 621 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			gtk_toggle_tool_button_set_active (_tmp20_, TRUE);
#line 3464 "tracker-needle.c"
		}
	} else {
		GtkToggleToolButton* _tmp21_ = NULL;
		gboolean _tmp22_ = FALSE;
		gboolean _tmp23_ = FALSE;
#line 623 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp21_ = self->priv->view_icons;
#line 623 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp22_ = gtk_toggle_tool_button_get_active (_tmp21_);
#line 623 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp23_ = _tmp22_;
#line 623 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		if (_tmp23_) {
#line 3478 "tracker-needle.c"
			gboolean _tmp24_ = FALSE;
#line 624 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp24_ = tracker_needle_current_find_in_icons;
#line 624 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			if (_tmp24_) {
#line 3484 "tracker-needle.c"
				GtkToggleToolButton* _tmp25_ = NULL;
#line 625 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp25_ = self->priv->find_in_titles;
#line 625 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				gtk_toggle_tool_button_set_active (_tmp25_, TRUE);
#line 3490 "tracker-needle.c"
			} else {
				GtkToggleToolButton* _tmp26_ = NULL;
#line 627 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp26_ = self->priv->find_in_all;
#line 627 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				gtk_toggle_tool_button_set_active (_tmp26_, TRUE);
#line 3497 "tracker-needle.c"
			}
		}
	}
#line 632 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp27_ = self->priv->sw_noresults;
#line 632 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_widget_show ((GtkWidget*) _tmp27_);
#line 633 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp28_ = self->priv->sw_icons;
#line 633 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_widget_hide ((GtkWidget*) _tmp28_);
#line 634 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp29_ = self->priv->sw_filelist;
#line 634 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_widget_hide ((GtkWidget*) _tmp29_);
#line 635 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp30_ = self->priv->sw_categories;
#line 635 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_widget_hide ((GtkWidget*) _tmp30_);
#line 638 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp32_ = self->priv->view_filelist;
#line 638 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp33_ = gtk_toggle_tool_button_get_active (_tmp32_);
#line 638 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp34_ = _tmp33_;
#line 638 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp34_) {
#line 638 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp31_ = TRUE;
#line 3527 "tracker-needle.c"
	} else {
		GtkToggleToolButton* _tmp35_ = NULL;
		gboolean _tmp36_ = FALSE;
		gboolean _tmp37_ = FALSE;
#line 638 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp35_ = self->priv->view_icons;
#line 638 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp36_ = gtk_toggle_tool_button_get_active (_tmp35_);
#line 638 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp37_ = _tmp36_;
#line 638 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp31_ = _tmp37_;
#line 3540 "tracker-needle.c"
	}
#line 638 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp38_ = self->priv->separator_secondary;
#line 638 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp38_, _tmp31_);
#line 639 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp39_ = self->priv->find_in_contents;
#line 639 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp40_ = self->priv->view_filelist;
#line 639 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp41_ = gtk_toggle_tool_button_get_active (_tmp40_);
#line 639 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp42_ = _tmp41_;
#line 639 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp39_, _tmp42_);
#line 640 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp44_ = self->priv->view_filelist;
#line 640 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp45_ = gtk_toggle_tool_button_get_active (_tmp44_);
#line 640 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp46_ = _tmp45_;
#line 640 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp46_) {
#line 640 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp43_ = TRUE;
#line 3566 "tracker-needle.c"
	} else {
		GtkToggleToolButton* _tmp47_ = NULL;
		gboolean _tmp48_ = FALSE;
		gboolean _tmp49_ = FALSE;
#line 640 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp47_ = self->priv->view_icons;
#line 640 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp48_ = gtk_toggle_tool_button_get_active (_tmp47_);
#line 640 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp49_ = _tmp48_;
#line 640 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp43_ = _tmp49_;
#line 3579 "tracker-needle.c"
	}
#line 640 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp50_ = self->priv->find_in_titles;
#line 640 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp50_, _tmp43_);
#line 641 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp51_ = self->priv->find_in_tags;
#line 641 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp52_ = self->priv->view_filelist;
#line 641 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp53_ = gtk_toggle_tool_button_get_active (_tmp52_);
#line 641 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp54_ = _tmp53_;
#line 641 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp51_, _tmp54_);
#line 642 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp55_ = self->priv->find_in_all;
#line 642 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp56_ = self->priv->view_icons;
#line 642 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp57_ = gtk_toggle_tool_button_get_active (_tmp56_);
#line 642 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp58_ = _tmp57_;
#line 642 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp55_, _tmp58_);
#line 644 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_needle_search_run (self);
#line 3607 "tracker-needle.c"
}


static void tracker_needle_find_in_toggled (TrackerNeedle* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GtkToggleToolButton* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	GtkToggleToolButton* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	GtkToggleToolButton* _tmp37_ = NULL;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp39_ = FALSE;
#line 648 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (self != NULL);
#line 649 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp3_ = self->priv->find_in_contents;
#line 649 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp4_ = gtk_toggle_tool_button_get_active (_tmp3_);
#line 649 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp5_ = _tmp4_;
#line 649 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (!_tmp5_) {
#line 3634 "tracker-needle.c"
		GtkToggleToolButton* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
#line 650 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp6_ = self->priv->find_in_titles;
#line 650 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp7_ = gtk_toggle_tool_button_get_active (_tmp6_);
#line 650 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp8_ = _tmp7_;
#line 650 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp2_ = !_tmp8_;
#line 3646 "tracker-needle.c"
	} else {
#line 649 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp2_ = FALSE;
#line 3650 "tracker-needle.c"
	}
#line 649 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp2_) {
#line 3654 "tracker-needle.c"
		GtkToggleToolButton* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
#line 651 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp9_ = self->priv->find_in_tags;
#line 651 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp10_ = gtk_toggle_tool_button_get_active (_tmp9_);
#line 651 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp11_ = _tmp10_;
#line 651 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp1_ = !_tmp11_;
#line 3666 "tracker-needle.c"
	} else {
#line 649 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp1_ = FALSE;
#line 3670 "tracker-needle.c"
	}
#line 649 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp1_) {
#line 3674 "tracker-needle.c"
		GtkToggleToolButton* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
#line 652 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp12_ = self->priv->find_in_all;
#line 652 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp13_ = gtk_toggle_tool_button_get_active (_tmp12_);
#line 652 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp14_ = _tmp13_;
#line 652 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp0_ = !_tmp14_;
#line 3686 "tracker-needle.c"
	} else {
#line 649 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp0_ = FALSE;
#line 3690 "tracker-needle.c"
	}
#line 649 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp0_) {
#line 653 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		return;
#line 3696 "tracker-needle.c"
	}
#line 656 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp15_ = self->priv->find_in_contents;
#line 656 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp16_ = gtk_toggle_tool_button_get_active (_tmp15_);
#line 656 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp17_ = _tmp16_;
#line 656 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp17_) {
#line 3706 "tracker-needle.c"
		GtkToggleToolButton* _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
#line 657 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_debug ("tracker-needle.vala:657: Find in toggled to 'contents'");
#line 659 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp18_ = self->priv->show_tags;
#line 659 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp19_ = gtk_toggle_tool_button_get_active (_tmp18_);
#line 659 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp20_ = _tmp19_;
#line 659 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		if (_tmp20_ != TRUE) {
#line 3720 "tracker-needle.c"
			GtkToolItem* _tmp21_ = NULL;
#line 660 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp21_ = self->priv->search_entry;
#line 660 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			gtk_widget_set_sensitive ((GtkWidget*) _tmp21_, TRUE);
#line 3726 "tracker-needle.c"
		}
#line 663 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		tracker_needle_search_run (self);
#line 3730 "tracker-needle.c"
	} else {
		GtkToggleToolButton* _tmp22_ = NULL;
		gboolean _tmp23_ = FALSE;
		gboolean _tmp24_ = FALSE;
#line 664 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp22_ = self->priv->find_in_tags;
#line 664 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp23_ = gtk_toggle_tool_button_get_active (_tmp22_);
#line 664 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp24_ = _tmp23_;
#line 664 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		if (_tmp24_) {
#line 3743 "tracker-needle.c"
			GtkToolItem* _tmp25_ = NULL;
#line 665 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			g_debug ("tracker-needle.vala:665: Find in toggled to 'tags'");
#line 667 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp25_ = self->priv->search_entry;
#line 667 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			gtk_widget_set_sensitive ((GtkWidget*) _tmp25_, TRUE);
#line 668 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			tracker_needle_search_run (self);
#line 3753 "tracker-needle.c"
		} else {
			GtkToggleToolButton* _tmp26_ = NULL;
			gboolean _tmp27_ = FALSE;
			gboolean _tmp28_ = FALSE;
#line 669 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp26_ = self->priv->find_in_titles;
#line 669 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp27_ = gtk_toggle_tool_button_get_active (_tmp26_);
#line 669 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp28_ = _tmp27_;
#line 669 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			if (_tmp28_) {
#line 3766 "tracker-needle.c"
				GtkToggleToolButton* _tmp29_ = NULL;
				gboolean _tmp30_ = FALSE;
				gboolean _tmp31_ = FALSE;
#line 670 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				g_debug ("tracker-needle.vala:670: Find in toggled to 'titles'");
#line 672 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp29_ = self->priv->show_tags;
#line 672 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp30_ = gtk_toggle_tool_button_get_active (_tmp29_);
#line 672 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp31_ = _tmp30_;
#line 672 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				if (_tmp31_ != TRUE) {
#line 3780 "tracker-needle.c"
					GtkToolItem* _tmp32_ = NULL;
#line 673 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					_tmp32_ = self->priv->search_entry;
#line 673 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					gtk_widget_set_sensitive ((GtkWidget*) _tmp32_, TRUE);
#line 3786 "tracker-needle.c"
				}
#line 676 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				tracker_needle_search_run (self);
#line 3790 "tracker-needle.c"
			} else {
				GtkToggleToolButton* _tmp33_ = NULL;
				gboolean _tmp34_ = FALSE;
				gboolean _tmp35_ = FALSE;
#line 677 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp33_ = self->priv->find_in_all;
#line 677 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp34_ = gtk_toggle_tool_button_get_active (_tmp33_);
#line 677 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp35_ = _tmp34_;
#line 677 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				if (_tmp35_) {
#line 3803 "tracker-needle.c"
					GtkToolItem* _tmp36_ = NULL;
#line 678 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					g_debug ("tracker-needle.vala:678: Find in toggled to 'all'");
#line 681 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					_tmp36_ = self->priv->search_entry;
#line 681 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					gtk_widget_set_sensitive ((GtkWidget*) _tmp36_, FALSE);
#line 683 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					tracker_needle_search_run (self);
#line 3813 "tracker-needle.c"
				}
			}
		}
	}
#line 686 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp37_ = self->priv->view_filelist;
#line 686 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp38_ = gtk_toggle_tool_button_get_active (_tmp37_);
#line 686 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp39_ = _tmp38_;
#line 686 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp39_) {
#line 3826 "tracker-needle.c"
		GtkToggleToolButton* _tmp40_ = NULL;
		gboolean _tmp41_ = FALSE;
		gboolean _tmp42_ = FALSE;
#line 687 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp40_ = self->priv->find_in_contents;
#line 687 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp41_ = gtk_toggle_tool_button_get_active (_tmp40_);
#line 687 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp42_ = _tmp41_;
#line 687 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		tracker_needle_current_find_in_filelist = _tmp42_;
#line 3838 "tracker-needle.c"
	} else {
		GtkToggleToolButton* _tmp43_ = NULL;
		gboolean _tmp44_ = FALSE;
		gboolean _tmp45_ = FALSE;
#line 688 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp43_ = self->priv->view_icons;
#line 688 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp44_ = gtk_toggle_tool_button_get_active (_tmp43_);
#line 688 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp45_ = _tmp44_;
#line 688 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		if (_tmp45_) {
#line 3851 "tracker-needle.c"
			GtkToggleToolButton* _tmp46_ = NULL;
			gboolean _tmp47_ = FALSE;
			gboolean _tmp48_ = FALSE;
#line 689 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp46_ = self->priv->find_in_titles;
#line 689 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp47_ = gtk_toggle_tool_button_get_active (_tmp46_);
#line 689 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp48_ = _tmp47_;
#line 689 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			tracker_needle_current_find_in_icons = _tmp48_;
#line 3863 "tracker-needle.c"
		}
	}
}


static void tracker_needle_view_row_activated (TrackerNeedle* self, GtkTreeView* view, GtkTreePath* path, GtkTreeViewColumn* column) {
	GtkTreeModel* model = NULL;
	GtkTreeView* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreePath* _tmp3_ = NULL;
#line 693 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (self != NULL);
#line 693 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (view != NULL);
#line 693 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (path != NULL);
#line 693 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (column != NULL);
#line 694 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = view;
#line 694 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp1_ = gtk_tree_view_get_model (_tmp0_);
#line 694 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 694 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	model = _tmp2_;
#line 695 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp3_ = path;
#line 695 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_model_launch_selected (model, _tmp3_, 1);
#line 693 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (model);
#line 3897 "tracker-needle.c"
}


static void tracker_needle_icon_item_activated (TrackerNeedle* self, GtkIconView* view, GtkTreePath* path) {
	GtkTreeModel* model = NULL;
	GtkIconView* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreePath* _tmp3_ = NULL;
#line 698 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (self != NULL);
#line 698 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (view != NULL);
#line 698 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (path != NULL);
#line 699 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = view;
#line 699 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp1_ = gtk_icon_view_get_model (_tmp0_);
#line 699 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 699 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	model = _tmp2_;
#line 700 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp3_ = path;
#line 700 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_model_launch_selected (model, _tmp3_, 1);
#line 698 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (model);
#line 3927 "tracker-needle.c"
}


static void _g_free0_ (gpointer var) {
#line 712 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	var = (g_free (var), NULL);
#line 3934 "tracker-needle.c"
}


static void _g_list_free__g_free0_ (GList* self) {
#line 712 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
#line 712 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_list_free (self);
#line 3943 "tracker-needle.c"
}


static void _gtk_tree_path_free0_ (gpointer var) {
#line 712 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	(var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL));
#line 3950 "tracker-needle.c"
}


static void _g_list_free__gtk_tree_path_free0_ (GList* self) {
#line 712 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_list_foreach (self, (GFunc) _gtk_tree_path_free0_, NULL);
#line 712 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_list_free (self);
#line 3959 "tracker-needle.c"
}


static gpointer _gtk_tree_path_copy0 (gpointer self) {
#line 715 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	return self ? gtk_tree_path_copy (self) : NULL;
#line 3966 "tracker-needle.c"
}


static void tracker_needle_view_row_selected (TrackerNeedle* self, GtkTreeSelection* selection) {
	GtkTreeIter iter = {0};
	GtkTreeModel* model = NULL;
	GList* rows = NULL;
	GtkTreeSelection* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	GtkTreeModel* _tmp3_ = NULL;
	GList* uris = NULL;
	GList* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	TrackerTagsView* _tmp17_ = NULL;
	GList* _tmp18_ = NULL;
#line 703 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (self != NULL);
#line 703 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (selection != NULL);
#line 705 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	model = NULL;
#line 706 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_debug ("tracker-needle.vala:706: Row selection changed");
#line 708 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = selection;
#line 708 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp2_ = gtk_tree_selection_get_selected_rows (_tmp0_, &_tmp1_);
#line 708 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (model);
#line 708 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp3_ = _g_object_ref0 (_tmp1_);
#line 708 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	model = _tmp3_;
#line 708 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	rows = _tmp2_;
#line 709 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	uris = NULL;
#line 711 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp4_ = rows;
#line 711 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp4_ == NULL) {
#line 712 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		__g_list_free__g_free0_0 (uris);
#line 712 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		__g_list_free__gtk_tree_path_free0_0 (rows);
#line 712 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_object_unref0 (model);
#line 712 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		return;
#line 4017 "tracker-needle.c"
	}
#line 715 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp5_ = rows;
#line 4021 "tracker-needle.c"
	{
		GList* path_collection = NULL;
		GList* path_it = NULL;
#line 715 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		path_collection = _tmp5_;
#line 715 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		for (path_it = path_collection; path_it != NULL; path_it = path_it->next) {
#line 4029 "tracker-needle.c"
			GtkTreePath* _tmp6_ = NULL;
			GtkTreePath* path = NULL;
#line 715 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp6_ = _gtk_tree_path_copy0 ((GtkTreePath*) path_it->data);
#line 715 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			path = _tmp6_;
#line 4036 "tracker-needle.c"
			{
				GtkTreeModel* _tmp7_ = NULL;
				GtkTreePath* _tmp8_ = NULL;
				GtkTreeIter _tmp9_ = {0};
				gboolean _tmp10_ = FALSE;
#line 716 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp7_ = model;
#line 716 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp8_ = path;
#line 716 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp10_ = gtk_tree_model_get_iter (_tmp7_, &_tmp9_, _tmp8_);
#line 716 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				iter = _tmp9_;
#line 716 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				if (_tmp10_) {
#line 4052 "tracker-needle.c"
					gchar* uri = NULL;
					GtkTreeModel* _tmp11_ = NULL;
					GtkTreeIter _tmp12_ = {0};
					const gchar* _tmp13_ = NULL;
					const gchar* _tmp14_ = NULL;
#line 719 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					_tmp11_ = model;
#line 719 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					_tmp12_ = iter;
#line 719 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					gtk_tree_model_get (_tmp11_, &_tmp12_, 1, &uri, -1, -1);
#line 720 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					_tmp13_ = uri;
#line 720 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					g_debug ("tracker-needle.vala:720: --> %s", _tmp13_);
#line 722 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					_tmp14_ = uri;
#line 722 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					if (_tmp14_ != NULL) {
#line 4072 "tracker-needle.c"
						const gchar* _tmp15_ = NULL;
						gchar* _tmp16_ = NULL;
#line 723 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
						_tmp15_ = uri;
#line 723 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
						_tmp16_ = g_strdup (_tmp15_);
#line 723 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
						uris = g_list_prepend (uris, _tmp16_);
#line 4081 "tracker-needle.c"
					}
#line 716 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					_g_free0 (uri);
#line 4085 "tracker-needle.c"
				}
#line 715 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_gtk_tree_path_free0 (path);
#line 4089 "tracker-needle.c"
			}
		}
	}
#line 728 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp17_ = self->priv->tags_view;
#line 728 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp18_ = uris;
#line 728 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_tags_view_set_files (_tmp17_, _tmp18_);
#line 703 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	__g_list_free__g_free0_0 (uris);
#line 703 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	__g_list_free__gtk_tree_path_free0_0 (rows);
#line 703 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (model);
#line 4105 "tracker-needle.c"
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
#line 731 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_atomic_int_inc (&_data4_->_ref_count_);
#line 731 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	return _data4_;
#line 4114 "tracker-needle.c"
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
#line 731 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
#line 4123 "tracker-needle.c"
		TrackerNeedle* self;
#line 731 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		self = _data4_->self;
#line 731 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		__g_list_free__g_free0_0 (_data4_->uris);
#line 731 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_object_unref0 (_data4_->model);
#line 731 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tracker_needle_unref0 (self);
#line 731 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_slice_free (Block4Data, _data4_);
#line 4135 "tracker-needle.c"
	}
}


static void __lambda9_ (Block4Data* _data4_, GtkIconView* iconview, GtkTreePath* path) {
	TrackerNeedle* self;
	GtkTreeIter iter = {0};
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreePath* _tmp1_ = NULL;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
#line 740 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self = _data4_->self;
#line 740 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (iconview != NULL);
#line 740 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (path != NULL);
#line 743 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = _data4_->model;
#line 743 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp1_ = path;
#line 743 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp3_ = gtk_tree_model_get_iter (_tmp0_, &_tmp2_, _tmp1_);
#line 743 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	iter = _tmp2_;
#line 743 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp3_) {
#line 4163 "tracker-needle.c"
		gchar* uri = NULL;
		GtkTreeModel* _tmp4_ = NULL;
		GtkTreeIter _tmp5_ = {0};
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
#line 746 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp4_ = _data4_->model;
#line 746 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp5_ = iter;
#line 746 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_tree_model_get (_tmp4_, &_tmp5_, 1, &uri, -1, -1);
#line 747 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp6_ = uri;
#line 747 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_debug ("tracker-needle.vala:747: --> %s", _tmp6_);
#line 749 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp7_ = uri;
#line 749 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		if (_tmp7_ != NULL) {
#line 4183 "tracker-needle.c"
			const gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
#line 750 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp8_ = uri;
#line 750 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp9_ = g_strdup (_tmp8_);
#line 750 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_data4_->uris = g_list_prepend (_data4_->uris, _tmp9_);
#line 4192 "tracker-needle.c"
		}
#line 743 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_free0 (uri);
#line 4196 "tracker-needle.c"
	}
}


static void ___lambda9__gtk_icon_view_foreach_func (GtkIconView* icon_view, GtkTreePath* path, gpointer self) {
#line 740 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	__lambda9_ (self, icon_view, path);
#line 4204 "tracker-needle.c"
}


static void tracker_needle_icon_view_selection_changed (TrackerNeedle* self) {
	Block4Data* _data4_;
	GtkIconView* iconview = NULL;
	TrackerView* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GtkIconView* _tmp2_ = NULL;
	GtkTreeModel* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	TrackerTagsView* _tmp5_ = NULL;
#line 731 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (self != NULL);
#line 731 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_data4_ = g_slice_new0 (Block4Data);
#line 731 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_data4_->_ref_count_ = 1;
#line 731 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_data4_->self = tracker_needle_ref (self);
#line 733 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_data4_->model = NULL;
#line 734 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_debug ("tracker-needle.vala:734: Icon selection changed");
#line 736 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = self->priv->sw_icons;
#line 736 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp1_ = gtk_bin_get_child ((GtkBin*) _tmp0_);
#line 736 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_icon_view_get_type (), GtkIconView));
#line 736 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (iconview);
#line 736 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	iconview = _tmp2_;
#line 737 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp3_ = gtk_icon_view_get_model (iconview);
#line 737 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 737 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (_data4_->model);
#line 737 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_data4_->model = _tmp4_;
#line 738 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_data4_->uris = NULL;
#line 740 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_icon_view_selected_foreach (iconview, ___lambda9__gtk_icon_view_foreach_func, _data4_);
#line 755 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp5_ = self->priv->tags_view;
#line 755 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_tags_view_set_files (_tmp5_, _data4_->uris);
#line 731 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (iconview);
#line 731 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	block4_data_unref (_data4_);
#line 731 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_data4_ = NULL;
#line 4261 "tracker-needle.c"
}


static void tracker_needle_show_tags_clicked (TrackerNeedle* self) {
	GtkToggleToolButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 758 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (self != NULL);
#line 759 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = self->priv->show_tags;
#line 759 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp1_ = gtk_toggle_tool_button_get_active (_tmp0_);
#line 759 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp2_ = _tmp1_;
#line 759 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp2_) {
#line 4279 "tracker-needle.c"
		TrackerTagsView* _tmp3_ = NULL;
#line 760 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_debug ("tracker-needle.vala:760: Showing tags");
#line 761 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp3_ = self->priv->tags_view;
#line 761 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_widget_show ((GtkWidget*) _tmp3_);
#line 4287 "tracker-needle.c"
	} else {
		TrackerTagsView* _tmp4_ = NULL;
#line 764 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_debug ("tracker-needle.vala:764: Hiding tags");
#line 765 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp4_ = self->priv->tags_view;
#line 765 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_widget_hide ((GtkWidget*) _tmp4_);
#line 4296 "tracker-needle.c"
	}
}


static void tracker_needle_show_stats_clicked (TrackerNeedle* self) {
	TrackerStats* s = NULL;
	TrackerStats* _tmp0_ = NULL;
#line 773 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (self != NULL);
#line 774 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_debug ("tracker-needle.vala:774: Showing stats dialog");
#line 775 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = tracker_stats_new ();
#line 775 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_object_ref_sink (_tmp0_);
#line 775 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	s = _tmp0_;
#line 776 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_widget_show ((GtkWidget*) s);
#line 773 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (s);
#line 4318 "tracker-needle.c"
}


void tracker_needle_show_info_message (TrackerNeedle* self, const gchar* message, GtkMessageType type) {
	GtkInfoBar* _tmp0_ = NULL;
	GtkMessageType _tmp1_ = 0;
	GtkLabel* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GtkInfoBar* _tmp4_ = NULL;
#line 779 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (self != NULL);
#line 779 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (message != NULL);
#line 781 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = self->priv->info_bar;
#line 781 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp1_ = type;
#line 781 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_info_bar_set_message_type (_tmp0_, _tmp1_);
#line 782 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp2_ = self->priv->info_bar_label;
#line 782 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp3_ = message;
#line 782 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_label_set_markup (_tmp2_, _tmp3_);
#line 783 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp4_ = self->priv->info_bar;
#line 783 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_widget_show ((GtkWidget*) _tmp4_);
#line 4348 "tracker-needle.c"
}


static void tracker_needle_info_bar_closed (TrackerNeedle* self, GtkButton* source) {
	GtkInfoBar* _tmp0_ = NULL;
#line 786 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (self != NULL);
#line 786 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (source != NULL);
#line 787 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = self->priv->info_bar;
#line 787 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_widget_hide ((GtkWidget*) _tmp0_);
#line 4362 "tracker-needle.c"
}


static GPtrArray* tracker_needle_search_tags (TrackerNeedle* self) {
	GPtrArray* result = NULL;
	GPtrArray* tagArray = NULL;
	GPtrArray* _tmp0_ = NULL;
	GtkEntry* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
#line 790 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 791 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
#line 791 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tagArray = _tmp0_;
#line 793 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp1_ = self->priv->search;
#line 793 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp2_ = gtk_entry_get_text (_tmp1_);
#line 793 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, ",", 0);
#line 4386 "tracker-needle.c"
	{
		gchar** tag_collection = NULL;
		gint tag_collection_length1 = 0;
		gint _tag_collection_size_ = 0;
		gint tag_it = 0;
#line 793 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		tag_collection = _tmp4_;
#line 793 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		tag_collection_length1 = _vala_array_length (_tmp3_);
#line 793 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		for (tag_it = 0; tag_it < _vala_array_length (_tmp3_); tag_it = tag_it + 1) {
#line 4398 "tracker-needle.c"
			gchar* _tmp5_ = NULL;
			gchar* tag = NULL;
#line 793 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp5_ = g_strdup (tag_collection[tag_it]);
#line 793 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			tag = _tmp5_;
#line 4405 "tracker-needle.c"
			{
				GPtrArray* _tmp6_ = NULL;
				const gchar* _tmp7_ = NULL;
				gchar* _tmp8_ = NULL;
#line 794 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp6_ = tagArray;
#line 794 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp7_ = tag;
#line 794 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp8_ = g_strdup (_tmp7_);
#line 794 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				g_ptr_array_add (_tmp6_, _tmp8_);
#line 793 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_g_free0 (tag);
#line 4420 "tracker-needle.c"
			}
		}
#line 793 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		tag_collection = (_vala_array_free (tag_collection, tag_collection_length1, (GDestroyNotify) g_free), NULL);
#line 4425 "tracker-needle.c"
	}
#line 797 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	result = tagArray;
#line 797 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	return result;
#line 4431 "tracker-needle.c"
}


static void tracker_value_needle_init (GValue* value) {
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	value->data[0].v_pointer = NULL;
#line 4438 "tracker-needle.c"
}


static void tracker_value_needle_free_value (GValue* value) {
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (value->data[0].v_pointer) {
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		tracker_needle_unref (value->data[0].v_pointer);
#line 4447 "tracker-needle.c"
	}
}


static void tracker_value_needle_copy_value (const GValue* src_value, GValue* dest_value) {
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (src_value->data[0].v_pointer) {
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		dest_value->data[0].v_pointer = tracker_needle_ref (src_value->data[0].v_pointer);
#line 4457 "tracker-needle.c"
	} else {
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4461 "tracker-needle.c"
	}
}


static gpointer tracker_value_needle_peek_pointer (const GValue* value) {
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	return value->data[0].v_pointer;
#line 4469 "tracker-needle.c"
}


static gchar* tracker_value_needle_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (collect_values[0].v_pointer) {
#line 4476 "tracker-needle.c"
		TrackerNeedle* object;
		object = collect_values[0].v_pointer;
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		if (object->parent_instance.g_class == NULL) {
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4483 "tracker-needle.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4487 "tracker-needle.c"
		}
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		value->data[0].v_pointer = tracker_needle_ref (object);
#line 4491 "tracker-needle.c"
	} else {
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		value->data[0].v_pointer = NULL;
#line 4495 "tracker-needle.c"
	}
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	return NULL;
#line 4499 "tracker-needle.c"
}


static gchar* tracker_value_needle_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TrackerNeedle** object_p;
	object_p = collect_values[0].v_pointer;
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (!object_p) {
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4510 "tracker-needle.c"
	}
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (!value->data[0].v_pointer) {
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		*object_p = NULL;
#line 4516 "tracker-needle.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		*object_p = value->data[0].v_pointer;
#line 4520 "tracker-needle.c"
	} else {
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		*object_p = tracker_needle_ref (value->data[0].v_pointer);
#line 4524 "tracker-needle.c"
	}
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	return NULL;
#line 4528 "tracker-needle.c"
}


GParamSpec* tracker_param_spec_needle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	TrackerParamSpecNeedle* spec;
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TRACKER_TYPE_NEEDLE), NULL);
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	return G_PARAM_SPEC (spec);
#line 4542 "tracker-needle.c"
}


gpointer tracker_value_get_needle (const GValue* value) {
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_NEEDLE), NULL);
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	return value->data[0].v_pointer;
#line 4551 "tracker-needle.c"
}


void tracker_value_set_needle (GValue* value, gpointer v_object) {
	TrackerNeedle* old;
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_NEEDLE));
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	old = value->data[0].v_pointer;
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (v_object) {
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_NEEDLE));
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		value->data[0].v_pointer = v_object;
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		tracker_needle_ref (value->data[0].v_pointer);
#line 4571 "tracker-needle.c"
	} else {
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		value->data[0].v_pointer = NULL;
#line 4575 "tracker-needle.c"
	}
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (old) {
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		tracker_needle_unref (old);
#line 4581 "tracker-needle.c"
	}
}


void tracker_value_take_needle (GValue* value, gpointer v_object) {
	TrackerNeedle* old;
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_NEEDLE));
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	old = value->data[0].v_pointer;
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (v_object) {
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_NEEDLE));
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		value->data[0].v_pointer = v_object;
#line 4600 "tracker-needle.c"
	} else {
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		value->data[0].v_pointer = NULL;
#line 4604 "tracker-needle.c"
	}
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (old) {
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		tracker_needle_unref (old);
#line 4610 "tracker-needle.c"
	}
}


static void tracker_needle_class_init (TrackerNeedleClass * klass) {
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_needle_parent_class = g_type_class_peek_parent (klass);
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	((TrackerNeedleClass *) klass)->finalize = tracker_needle_finalize;
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_type_class_add_private (klass, sizeof (TrackerNeedlePrivate));
#line 4622 "tracker-needle.c"
}


static void tracker_needle_instance_init (TrackerNeedle * self) {
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv = TRACKER_NEEDLE_GET_PRIVATE (self);
#line 30 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->settings_needle = NULL;
#line 57 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->last_search_id = (guint) 0;
#line 58 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->size_small = 0;
#line 59 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->size_medium = 0;
#line 60 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->size_big = 0;
#line 61 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->limit = (guint) 500;
#line 62 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->default_view = 1;
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->ref_count = 1;
#line 4645 "tracker-needle.c"
}


static void tracker_needle_finalize (TrackerNeedle* obj) {
	TrackerNeedle * self;
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_TYPE_NEEDLE, TrackerNeedle);
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_handlers_destroy (self);
#line 30 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->settings_needle);
#line 32 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tracker_history_unref0 (self->priv->history);
#line 33 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->window);
#line 34 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->view_categories);
#line 35 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->view_filelist);
#line 36 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->view_icons);
#line 37 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->separator_secondary);
#line 38 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->find_in_contents);
#line 39 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->find_in_titles);
#line 40 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->find_in_tags);
#line 41 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->find_in_all);
#line 42 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->search_entry);
#line 43 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->search_list);
#line 44 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->search);
#line 45 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->spinner);
#line 46 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->spinner_shell);
#line 47 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->show_tags);
#line 48 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->show_stats);
#line 49 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->view);
#line 50 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->sw_noresults);
#line 51 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->sw_categories);
#line 52 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->sw_filelist);
#line 53 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->sw_icons);
#line 54 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->info_bar);
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->info_bar_label);
#line 56 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->tags_view);
#line 65 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->current_view);
#line 67 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->categories_model);
#line 68 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->files_model);
#line 69 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->files_in_tags_model);
#line 70 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->files_in_title_model);
#line 71 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->images_model);
#line 72 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->images_in_title_model);
#line 4721 "tracker-needle.c"
}


GType tracker_needle_get_type (void) {
	static volatile gsize tracker_needle_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_needle_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { tracker_value_needle_init, tracker_value_needle_free_value, tracker_value_needle_copy_value, tracker_value_needle_peek_pointer, "p", tracker_value_needle_collect_value, "p", tracker_value_needle_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TrackerNeedleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_needle_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerNeedle), 0, (GInstanceInitFunc) tracker_needle_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tracker_needle_type_id;
		tracker_needle_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerNeedle", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&tracker_needle_type_id__volatile, tracker_needle_type_id);
	}
	return tracker_needle_type_id__volatile;
}


gpointer tracker_needle_ref (gpointer instance) {
	TrackerNeedle* self;
	self = instance;
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_atomic_int_inc (&self->ref_count);
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	return instance;
#line 4746 "tracker-needle.c"
}


void tracker_needle_unref (gpointer instance) {
	TrackerNeedle* self;
	self = instance;
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		TRACKER_NEEDLE_GET_CLASS (self)->finalize (self);
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4759 "tracker-needle.c"
	}
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* context = NULL;
	const gchar* _tmp0_ = NULL;
	GOptionContext* _tmp1_ = NULL;
	gboolean _tmp14_ = FALSE;
	TrackerNeedle* n = NULL;
	TrackerNeedle* _tmp39_ = NULL;
	TrackerNeedle* _tmp40_ = NULL;
	TrackerNeedle* _tmp41_ = NULL;
	gchar** _tmp42_ = NULL;
	gint _tmp42__length1 = 0;
	GError * _inner_error_ = NULL;
#line 824 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = _ ("Desktop Search user interface using Tracker");
#line 824 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp1_ = g_option_context_new (_tmp0_);
#line 824 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	context = _tmp1_;
#line 4783 "tracker-needle.c"
	{
		GOptionContext* _tmp2_ = NULL;
		GOptionContext* _tmp3_ = NULL;
		GOptionContext* _tmp4_ = NULL;
		GOptionGroup* _tmp5_ = NULL;
		GOptionContext* _tmp6_ = NULL;
#line 827 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp2_ = context;
#line 827 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_option_context_set_help_enabled (_tmp2_, TRUE);
#line 828 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp3_ = context;
#line 828 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_option_context_add_main_entries (_tmp3_, options, NULL);
#line 829 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp4_ = context;
#line 829 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp5_ = gtk_get_option_group (TRUE);
#line 829 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_option_context_add_group (_tmp4_, _tmp5_);
#line 830 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp6_ = context;
#line 830 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_option_context_parse (_tmp6_, &args_length1, &args, &_inner_error_);
#line 830 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4810 "tracker-needle.c"
			goto __catch30_g_error;
		}
	}
	goto __finally30;
	__catch30_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		GOptionContext* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
#line 826 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		e = _inner_error_;
#line 826 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_inner_error_ = NULL;
#line 832 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp7_ = e;
#line 832 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp8_ = _tmp7_->message;
#line 832 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp9_ = g_strconcat (_tmp8_, "\n\n", NULL);
#line 832 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp10_ = _tmp9_;
#line 832 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_printerr ("%s", _tmp10_);
#line 832 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_free0 (_tmp10_);
#line 833 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp11_ = context;
#line 833 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp12_ = g_option_context_get_help (_tmp11_, TRUE, NULL);
#line 833 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp13_ = _tmp12_;
#line 833 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_printerr ("%s", _tmp13_);
#line 833 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_free0 (_tmp13_);
#line 834 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		result = 1;
#line 834 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_error_free0 (e);
#line 834 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_option_context_free0 (context);
#line 834 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		return result;
#line 4859 "tracker-needle.c"
	}
	__finally30:
#line 826 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 826 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_option_context_free0 (context);
#line 826 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 826 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_clear_error (&_inner_error_);
#line 826 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		return 0;
#line 4872 "tracker-needle.c"
	}
#line 837 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp14_ = print_version;
#line 837 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp14_) {
#line 4878 "tracker-needle.c"
		gchar* about = NULL;
		gchar* _tmp15_ = NULL;
		gchar* license = NULL;
		gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		const gchar* _tmp34_ = NULL;
		gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
#line 838 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp15_ = g_strdup ("");
#line 838 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		about = _tmp15_;
#line 839 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp16_ = g_strdup ("");
#line 839 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		license = _tmp16_;
#line 841 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp17_ = about;
#line 841 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp18_ = g_strconcat (_tmp17_, "Tracker " PACKAGE_VERSION "\n", NULL);
#line 841 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_free0 (about);
#line 841 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		about = _tmp18_;
#line 843 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp19_ = license;
#line 843 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp20_ = g_strconcat (_tmp19_, "This program is free software and comes without any warranty.\n", NULL);
#line 843 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_free0 (license);
#line 843 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		license = _tmp20_;
#line 844 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp21_ = license;
#line 844 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp22_ = g_strconcat (_tmp21_, "It is licensed under version 2 or later of the General Public ", NULL);
#line 844 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_free0 (license);
#line 844 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		license = _tmp22_;
#line 845 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp23_ = license;
#line 845 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp24_ = g_strconcat (_tmp23_, "License which can be viewed at:\n", NULL);
#line 845 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_free0 (license);
#line 845 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		license = _tmp24_;
#line 846 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp25_ = license;
#line 846 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp26_ = g_strconcat (_tmp25_, "\n", NULL);
#line 846 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_free0 (license);
#line 846 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		license = _tmp26_;
#line 847 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp27_ = license;
#line 847 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp28_ = g_strconcat (_tmp27_, "  http://www.gnu.org/licenses/gpl.txt\n", NULL);
#line 847 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_free0 (license);
#line 847 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		license = _tmp28_;
#line 849 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp29_ = about;
#line 849 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp30_ = g_strconcat ("\n", _tmp29_, NULL);
#line 849 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp31_ = _tmp30_;
#line 849 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp32_ = g_strconcat (_tmp31_, "\n", NULL);
#line 849 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp33_ = _tmp32_;
#line 849 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp34_ = license;
#line 849 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp35_ = g_strconcat (_tmp33_, _tmp34_, NULL);
#line 849 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp36_ = _tmp35_;
#line 849 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp37_ = g_strconcat (_tmp36_, "\n", NULL);
#line 849 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp38_ = _tmp37_;
#line 849 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_print ("%s", _tmp38_);
#line 849 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_free0 (_tmp38_);
#line 849 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_free0 (_tmp36_);
#line 849 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_free0 (_tmp33_);
#line 849 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_free0 (_tmp31_);
#line 850 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		result = 0;
#line 850 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_free0 (license);
#line 850 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_free0 (about);
#line 850 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_option_context_free0 (context);
#line 850 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		return result;
#line 5001 "tracker-needle.c"
	}
#line 853 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_init (&args_length1, &args);
#line 855 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
#line 856 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#line 857 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	textdomain (GETTEXT_PACKAGE);
#line 859 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp39_ = tracker_needle_new ();
#line 859 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	n = _tmp39_;
#line 860 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp40_ = n;
#line 860 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_needle_show (_tmp40_);
#line 862 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp41_ = n;
#line 862 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp42_ = search_criteria;
#line 862 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp42__length1 = _vala_array_length (search_criteria);
#line 862 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_needle_set_search (_tmp41_, _tmp42_, _tmp42__length1);
#line 864 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_main ();
#line 866 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	result = 0;
#line 866 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tracker_needle_unref0 (n);
#line 866 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_option_context_free0 (context);
#line 866 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	return result;
#line 5037 "tracker-needle.c"
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
#line 823 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	return _vala_main (argv, argc);
#line 5047 "tracker-needle.c"
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



