/* valaproperty.c generated by valac, the Vala compiler
 * generated from valaproperty.vala, do not modify */

/* valaproperty.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>


#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;

#define VALA_TYPE_CODE_GENERATOR (vala_code_generator_get_type ())
#define VALA_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGenerator))
#define VALA_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))
#define VALA_IS_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_GENERATOR))
#define VALA_IS_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_GENERATOR))
#define VALA_CODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))

typedef struct _ValaCodeGenerator ValaCodeGenerator;
typedef struct _ValaCodeGeneratorClass ValaCodeGeneratorClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_VARIABLE (vala_variable_get_type ())
#define VALA_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VARIABLE, ValaVariable))
#define VALA_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VARIABLE, ValaVariableClass))
#define VALA_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VARIABLE))
#define VALA_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VARIABLE))
#define VALA_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VARIABLE, ValaVariableClass))

typedef struct _ValaVariable ValaVariable;
typedef struct _ValaVariableClass ValaVariableClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;
typedef struct _ValaSymbolPrivate ValaSymbolPrivate;

#define VALA_TYPE_NAMESPACE (vala_namespace_get_type ())
#define VALA_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NAMESPACE, ValaNamespace))
#define VALA_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NAMESPACE, ValaNamespaceClass))
#define VALA_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NAMESPACE))
#define VALA_IS_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NAMESPACE))
#define VALA_NAMESPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NAMESPACE, ValaNamespaceClass))

typedef struct _ValaNamespace ValaNamespace;
typedef struct _ValaNamespaceClass ValaNamespaceClass;

#define VALA_TYPE_TYPESYMBOL (vala_typesymbol_get_type ())
#define VALA_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))
#define VALA_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))
#define VALA_IS_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPESYMBOL))
#define VALA_IS_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPESYMBOL))
#define VALA_TYPESYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))

typedef struct _ValaTypeSymbol ValaTypeSymbol;
typedef struct _ValaTypeSymbolClass ValaTypeSymbolClass;

#define VALA_TYPE_OBJECT_TYPE_SYMBOL (vala_object_type_symbol_get_type ())
#define VALA_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))
#define VALA_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))
#define VALA_IS_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_IS_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_OBJECT_TYPE_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))

typedef struct _ValaObjectTypeSymbol ValaObjectTypeSymbol;
typedef struct _ValaObjectTypeSymbolClass ValaObjectTypeSymbolClass;

#define VALA_TYPE_CLASS (vala_class_get_type ())
#define VALA_CLASS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CLASS, ValaClass))
#define VALA_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CLASS, ValaClassClass))
#define VALA_IS_CLASS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CLASS))
#define VALA_IS_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CLASS))
#define VALA_CLASS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CLASS, ValaClassClass))

typedef struct _ValaClass ValaClass;
typedef struct _ValaClassClass ValaClassClass;

#define VALA_TYPE_INTERFACE (vala_interface_get_type ())
#define VALA_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTERFACE, ValaInterface))
#define VALA_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTERFACE, ValaInterfaceClass))
#define VALA_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTERFACE))
#define VALA_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTERFACE))
#define VALA_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTERFACE, ValaInterfaceClass))

typedef struct _ValaInterface ValaInterface;
typedef struct _ValaInterfaceClass ValaInterfaceClass;

#define VALA_TYPE_STRUCT (vala_struct_get_type ())
#define VALA_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT, ValaStruct))
#define VALA_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT, ValaStructClass))
#define VALA_IS_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT))
#define VALA_IS_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT))
#define VALA_STRUCT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT, ValaStructClass))

typedef struct _ValaStruct ValaStruct;
typedef struct _ValaStructClass ValaStructClass;

#define VALA_TYPE_ENUM (vala_enum_get_type ())
#define VALA_ENUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ENUM, ValaEnum))
#define VALA_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ENUM, ValaEnumClass))
#define VALA_IS_ENUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ENUM))
#define VALA_IS_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ENUM))
#define VALA_ENUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ENUM, ValaEnumClass))

typedef struct _ValaEnum ValaEnum;
typedef struct _ValaEnumClass ValaEnumClass;

#define VALA_TYPE_ERROR_DOMAIN (vala_error_domain_get_type ())
#define VALA_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain))
#define VALA_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))
#define VALA_IS_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ERROR_DOMAIN))
#define VALA_IS_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ERROR_DOMAIN))
#define VALA_ERROR_DOMAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))

typedef struct _ValaErrorDomain ValaErrorDomain;
typedef struct _ValaErrorDomainClass ValaErrorDomainClass;

#define VALA_TYPE_DELEGATE (vala_delegate_get_type ())
#define VALA_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELEGATE, ValaDelegate))
#define VALA_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELEGATE, ValaDelegateClass))
#define VALA_IS_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELEGATE))
#define VALA_IS_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELEGATE))
#define VALA_DELEGATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELEGATE, ValaDelegateClass))

typedef struct _ValaDelegate ValaDelegate;
typedef struct _ValaDelegateClass ValaDelegateClass;

#define VALA_TYPE_CONSTANT (vala_constant_get_type ())
#define VALA_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTANT, ValaConstant))
#define VALA_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTANT, ValaConstantClass))
#define VALA_IS_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTANT))
#define VALA_IS_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTANT))
#define VALA_CONSTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTANT, ValaConstantClass))

typedef struct _ValaConstant ValaConstant;
typedef struct _ValaConstantClass ValaConstantClass;

#define VALA_TYPE_FIELD (vala_field_get_type ())
#define VALA_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FIELD, ValaField))
#define VALA_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FIELD, ValaFieldClass))
#define VALA_IS_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FIELD))
#define VALA_IS_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FIELD))
#define VALA_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FIELD, ValaFieldClass))

typedef struct _ValaField ValaField;
typedef struct _ValaFieldClass ValaFieldClass;

#define VALA_TYPE_SUBROUTINE (vala_subroutine_get_type ())
#define VALA_SUBROUTINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SUBROUTINE, ValaSubroutine))
#define VALA_SUBROUTINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SUBROUTINE, ValaSubroutineClass))
#define VALA_IS_SUBROUTINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SUBROUTINE))
#define VALA_IS_SUBROUTINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SUBROUTINE))
#define VALA_SUBROUTINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SUBROUTINE, ValaSubroutineClass))

typedef struct _ValaSubroutine ValaSubroutine;
typedef struct _ValaSubroutineClass ValaSubroutineClass;

#define VALA_TYPE_METHOD (vala_method_get_type ())
#define VALA_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD, ValaMethod))
#define VALA_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD, ValaMethodClass))
#define VALA_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD))
#define VALA_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD))
#define VALA_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD, ValaMethodClass))

typedef struct _ValaMethod ValaMethod;
typedef struct _ValaMethodClass ValaMethodClass;

#define VALA_TYPE_PROPERTY (vala_property_get_type ())
#define VALA_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY, ValaProperty))
#define VALA_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY, ValaPropertyClass))
#define VALA_IS_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY))
#define VALA_IS_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY))
#define VALA_PROPERTY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY, ValaPropertyClass))

typedef struct _ValaProperty ValaProperty;
typedef struct _ValaPropertyClass ValaPropertyClass;

#define VALA_TYPE_SIGNAL (vala_signal_get_type ())
#define VALA_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SIGNAL, ValaSignal))
#define VALA_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SIGNAL, ValaSignalClass))
#define VALA_IS_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SIGNAL))
#define VALA_IS_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SIGNAL))
#define VALA_SIGNAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SIGNAL, ValaSignalClass))

typedef struct _ValaSignal ValaSignal;
typedef struct _ValaSignalClass ValaSignalClass;

#define VALA_TYPE_CONSTRUCTOR (vala_constructor_get_type ())
#define VALA_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructor))
#define VALA_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))
#define VALA_IS_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTRUCTOR))
#define VALA_IS_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTRUCTOR))
#define VALA_CONSTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))

typedef struct _ValaConstructor ValaConstructor;
typedef struct _ValaConstructorClass ValaConstructorClass;

#define VALA_TYPE_DESTRUCTOR (vala_destructor_get_type ())
#define VALA_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructor))
#define VALA_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))
#define VALA_IS_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DESTRUCTOR))
#define VALA_IS_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DESTRUCTOR))
#define VALA_DESTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))

typedef struct _ValaDestructor ValaDestructor;
typedef struct _ValaDestructorClass ValaDestructorClass;

#define VALA_TYPE_LOCKABLE (vala_lockable_get_type ())
#define VALA_LOCKABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCKABLE, ValaLockable))
#define VALA_IS_LOCKABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCKABLE))
#define VALA_LOCKABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), VALA_TYPE_LOCKABLE, ValaLockableIface))

typedef struct _ValaLockable ValaLockable;
typedef struct _ValaLockableIface ValaLockableIface;
typedef struct _ValaPropertyPrivate ValaPropertyPrivate;

#define VALA_TYPE_PARAMETER (vala_parameter_get_type ())
#define VALA_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PARAMETER, ValaParameter))
#define VALA_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PARAMETER, ValaParameterClass))
#define VALA_IS_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PARAMETER))
#define VALA_IS_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PARAMETER))
#define VALA_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PARAMETER, ValaParameterClass))

typedef struct _ValaParameter ValaParameter;
typedef struct _ValaParameterClass ValaParameterClass;

#define VALA_TYPE_MEMBER_BINDING (vala_member_binding_get_type ())

#define VALA_TYPE_PROPERTY_ACCESSOR (vala_property_accessor_get_type ())
#define VALA_PROPERTY_ACCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessor))
#define VALA_PROPERTY_ACCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessorClass))
#define VALA_IS_PROPERTY_ACCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY_ACCESSOR))
#define VALA_IS_PROPERTY_ACCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY_ACCESSOR))
#define VALA_PROPERTY_ACCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessorClass))

typedef struct _ValaPropertyAccessor ValaPropertyAccessor;
typedef struct _ValaPropertyAccessorClass ValaPropertyAccessorClass;
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;

#define VALA_TYPE_COMMENT (vala_comment_get_type ())
#define VALA_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMMENT, ValaComment))
#define VALA_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMMENT, ValaCommentClass))
#define VALA_IS_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMMENT))
#define VALA_IS_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMMENT))
#define VALA_COMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMMENT, ValaCommentClass))

typedef struct _ValaComment ValaComment;
typedef struct _ValaCommentClass ValaCommentClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define VALA_TYPE_MEMBER_ACCESS (vala_member_access_get_type ())
#define VALA_MEMBER_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess))
#define VALA_MEMBER_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccessClass))
#define VALA_IS_MEMBER_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_MEMBER_ACCESS))
#define VALA_IS_MEMBER_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_MEMBER_ACCESS))
#define VALA_MEMBER_ACCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccessClass))

typedef struct _ValaMemberAccess ValaMemberAccess;
typedef struct _ValaMemberAccessClass ValaMemberAccessClass;

#define VALA_TYPE_SCOPE (vala_scope_get_type ())
#define VALA_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SCOPE, ValaScope))
#define VALA_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SCOPE, ValaScopeClass))
#define VALA_IS_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SCOPE))
#define VALA_IS_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SCOPE))
#define VALA_SCOPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SCOPE, ValaScopeClass))

typedef struct _ValaScope ValaScope;
typedef struct _ValaScopeClass ValaScopeClass;
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

#define VALA_TYPE_SYMBOL_ACCESSIBILITY (vala_symbol_accessibility_get_type ())

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;

#define VALA_TYPE_SEMANTIC_ANALYZER (vala_semantic_analyzer_get_type ())
#define VALA_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzer))
#define VALA_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))
#define VALA_IS_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_IS_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_SEMANTIC_ANALYZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))

typedef struct _ValaSemanticAnalyzer ValaSemanticAnalyzer;
typedef struct _ValaSemanticAnalyzerClass ValaSemanticAnalyzerClass;

#define VALA_TYPE_VOID_TYPE (vala_void_type_get_type ())
#define VALA_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VOID_TYPE, ValaVoidType))
#define VALA_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))
#define VALA_IS_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VOID_TYPE))
#define VALA_IS_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VOID_TYPE))
#define VALA_VOID_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))

typedef struct _ValaVoidType ValaVoidType;
typedef struct _ValaVoidTypeClass ValaVoidTypeClass;
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaCodeContext* context);
	void (*emit) (ValaCodeNode* self, ValaCodeGenerator* codegen);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	gchar* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, ValaCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, ValaCollection* collection);
};

struct _ValaSymbol {
	ValaCodeNode parent_instance;
	ValaSymbolPrivate * priv;
};

struct _ValaSymbolClass {
	ValaCodeNodeClass parent_class;
	gboolean (*is_instance_member) (ValaSymbol* self);
	gboolean (*is_class_member) (ValaSymbol* self);
	void (*add_namespace) (ValaSymbol* self, ValaNamespace* ns);
	void (*add_class) (ValaSymbol* self, ValaClass* cl);
	void (*add_interface) (ValaSymbol* self, ValaInterface* iface);
	void (*add_struct) (ValaSymbol* self, ValaStruct* st);
	void (*add_enum) (ValaSymbol* self, ValaEnum* en);
	void (*add_error_domain) (ValaSymbol* self, ValaErrorDomain* edomain);
	void (*add_delegate) (ValaSymbol* self, ValaDelegate* d);
	void (*add_constant) (ValaSymbol* self, ValaConstant* constant);
	void (*add_field) (ValaSymbol* self, ValaField* f);
	void (*add_method) (ValaSymbol* self, ValaMethod* m);
	void (*add_property) (ValaSymbol* self, ValaProperty* prop);
	void (*add_signal) (ValaSymbol* self, ValaSignal* sig);
	void (*add_constructor) (ValaSymbol* self, ValaConstructor* c);
	void (*add_destructor) (ValaSymbol* self, ValaDestructor* d);
};

struct _ValaLockableIface {
	GTypeInterface parent_iface;
	gboolean (*get_lock_used) (ValaLockable* self);
	void (*set_lock_used) (ValaLockable* self, gboolean used);
};

struct _ValaProperty {
	ValaSymbol parent_instance;
	ValaPropertyPrivate * priv;
};

struct _ValaPropertyClass {
	ValaSymbolClass parent_class;
};

typedef enum  {
	VALA_MEMBER_BINDING_INSTANCE,
	VALA_MEMBER_BINDING_CLASS,
	VALA_MEMBER_BINDING_STATIC
} ValaMemberBinding;

struct _ValaPropertyPrivate {
	ValaParameter* _this_parameter;
	gboolean _interface_only;
	gboolean _is_abstract;
	gboolean _is_virtual;
	gboolean _overrides;
	ValaField* _field;
	ValaMemberBinding _binding;
	ValaExpression* _initializer;
	gboolean lock_used;
	ValaDataType* _data_type;
	ValaProperty* _base_property;
	ValaProperty* _base_interface_property;
	gboolean base_properties_valid;
	ValaPropertyAccessor* _get_accessor;
	ValaPropertyAccessor* _set_accessor;
};

typedef enum  {
	VALA_SYMBOL_ACCESSIBILITY_PRIVATE,
	VALA_SYMBOL_ACCESSIBILITY_INTERNAL,
	VALA_SYMBOL_ACCESSIBILITY_PROTECTED,
	VALA_SYMBOL_ACCESSIBILITY_PUBLIC
} ValaSymbolAccessibility;


static gpointer vala_property_parent_class = NULL;
static ValaLockableIface* vala_property_vala_lockable_parent_iface = NULL;

gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
void vala_value_take_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void) G_GNUC_CONST;
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
void vala_value_take_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void) G_GNUC_CONST;
gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
void vala_value_take_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void) G_GNUC_CONST;
GType vala_code_generator_get_type (void) G_GNUC_CONST;
GType vala_data_type_get_type (void) G_GNUC_CONST;
GType vala_expression_get_type (void) G_GNUC_CONST;
GType vala_symbol_get_type (void) G_GNUC_CONST;
GType vala_variable_get_type (void) G_GNUC_CONST;
GType vala_attribute_get_type (void) G_GNUC_CONST;
GType vala_namespace_get_type (void) G_GNUC_CONST;
GType vala_typesymbol_get_type (void) G_GNUC_CONST;
GType vala_object_type_symbol_get_type (void) G_GNUC_CONST;
GType vala_class_get_type (void) G_GNUC_CONST;
GType vala_interface_get_type (void) G_GNUC_CONST;
GType vala_struct_get_type (void) G_GNUC_CONST;
GType vala_enum_get_type (void) G_GNUC_CONST;
GType vala_error_domain_get_type (void) G_GNUC_CONST;
GType vala_delegate_get_type (void) G_GNUC_CONST;
GType vala_constant_get_type (void) G_GNUC_CONST;
GType vala_field_get_type (void) G_GNUC_CONST;
GType vala_subroutine_get_type (void) G_GNUC_CONST;
GType vala_method_get_type (void) G_GNUC_CONST;
GType vala_property_get_type (void) G_GNUC_CONST;
GType vala_signal_get_type (void) G_GNUC_CONST;
GType vala_constructor_get_type (void) G_GNUC_CONST;
GType vala_destructor_get_type (void) G_GNUC_CONST;
GType vala_lockable_get_type (void) G_GNUC_CONST;
GType vala_parameter_get_type (void) G_GNUC_CONST;
GType vala_member_binding_get_type (void) G_GNUC_CONST;
GType vala_property_accessor_get_type (void) G_GNUC_CONST;
#define VALA_PROPERTY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_PROPERTY, ValaPropertyPrivate))
enum  {
	VALA_PROPERTY_DUMMY_PROPERTY
};
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
gpointer vala_comment_ref (gpointer instance);
void vala_comment_unref (gpointer instance);
GParamSpec* vala_param_spec_comment (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_comment (GValue* value, gpointer v_object);
void vala_value_take_comment (GValue* value, gpointer v_object);
gpointer vala_value_get_comment (const GValue* value);
GType vala_comment_get_type (void) G_GNUC_CONST;
ValaProperty* vala_property_new (const gchar* name, ValaDataType* property_type, ValaPropertyAccessor* get_accessor, ValaPropertyAccessor* set_accessor, ValaSourceReference* source_reference, ValaComment* comment);
ValaProperty* vala_property_construct (GType object_type, const gchar* name, ValaDataType* property_type, ValaPropertyAccessor* get_accessor, ValaPropertyAccessor* set_accessor, ValaSourceReference* source_reference, ValaComment* comment);
ValaSymbol* vala_symbol_construct (GType object_type, const gchar* name, ValaSourceReference* source_reference, ValaComment* comment);
void vala_property_set_property_type (ValaProperty* self, ValaDataType* value);
void vala_property_set_get_accessor (ValaProperty* self, ValaPropertyAccessor* value);
void vala_property_set_set_accessor (ValaProperty* self, ValaPropertyAccessor* value);
static void vala_property_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
void vala_code_visitor_visit_property (ValaCodeVisitor* self, ValaProperty* prop);
static void vala_property_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
ValaDataType* vala_property_get_property_type (ValaProperty* self);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
ValaPropertyAccessor* vala_property_get_get_accessor (ValaProperty* self);
ValaPropertyAccessor* vala_property_get_set_accessor (ValaProperty* self);
ValaExpression* vala_property_get_initializer (ValaProperty* self);
static gboolean vala_property_real_get_lock_used (ValaLockable* base);
static void vala_property_real_set_lock_used (ValaLockable* base, gboolean used);
gboolean vala_property_compatible (ValaProperty* self, ValaProperty* base_property, gchar** invalid_match);
ValaDataType* vala_semantic_analyzer_get_data_type_for_symbol (ValaTypeSymbol* sym);
ValaSymbol* vala_symbol_get_parent_symbol (ValaSymbol* self);
ValaDataType* vala_property_accessor_get_value_type (ValaPropertyAccessor* self);
GType vala_member_access_get_type (void) G_GNUC_CONST;
ValaDataType* vala_data_type_get_actual_type (ValaDataType* self, ValaDataType* derived_instance_type, ValaMemberAccess* method_access, ValaCodeNode* node_reference);
gboolean vala_data_type_equals (ValaDataType* self, ValaDataType* type2);
gboolean vala_property_accessor_get_writable (ValaPropertyAccessor* self);
gboolean vala_property_accessor_get_construction (ValaPropertyAccessor* self);
static void vala_property_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
static void vala_property_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
void vala_property_set_initializer (ValaProperty* self, ValaExpression* value);
static void vala_property_find_base_properties (ValaProperty* self);
static void vala_property_find_base_interface_property (ValaProperty* self, ValaClass* cl);
gboolean vala_property_get_is_virtual (ValaProperty* self);
gboolean vala_property_get_overrides (ValaProperty* self);
static void vala_property_find_base_class_property (ValaProperty* self, ValaClass* cl);
gboolean vala_property_get_is_abstract (ValaProperty* self);
gpointer vala_scope_ref (gpointer instance);
void vala_scope_unref (gpointer instance);
GParamSpec* vala_param_spec_scope (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_scope (GValue* value, gpointer v_object);
void vala_value_take_scope (GValue* value, gpointer v_object);
gpointer vala_value_get_scope (const GValue* value);
GType vala_scope_get_type (void) G_GNUC_CONST;
ValaScope* vala_symbol_get_scope (ValaSymbol* self);
ValaSymbol* vala_scope_lookup (ValaScope* self, const gchar* name);
const gchar* vala_symbol_get_name (ValaSymbol* self);
void vala_code_node_set_error (ValaCodeNode* self, gboolean value);
void vala_report_error (ValaSourceReference* source, const gchar* message);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
gchar* vala_symbol_get_full_name (ValaSymbol* self);
ValaClass* vala_class_get_base_class (ValaClass* self);
ValaList* vala_class_get_base_types (ValaClass* self);
ValaTypeSymbol* vala_data_type_get_data_type (ValaDataType* self);
static gboolean vala_property_real_check (ValaCodeNode* base, ValaCodeContext* context);
gboolean vala_code_node_get_checked (ValaCodeNode* self);
gboolean vala_code_node_get_error (ValaCodeNode* self);
void vala_code_node_set_checked (ValaCodeNode* self, gboolean value);
gboolean vala_class_get_is_abstract (ValaClass* self);
gboolean vala_class_get_is_compact (ValaClass* self);
GType vala_symbol_accessibility_get_type (void) G_GNUC_CONST;
ValaSymbolAccessibility vala_symbol_get_access (ValaSymbol* self);
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
void vala_value_take_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void) G_GNUC_CONST;
GType vala_semantic_analyzer_get_type (void) G_GNUC_CONST;
ValaSemanticAnalyzer* vala_code_context_get_analyzer (ValaCodeContext* self);
ValaSourceFile* vala_semantic_analyzer_get_current_source_file (ValaSemanticAnalyzer* self);
ValaSymbol* vala_semantic_analyzer_get_current_symbol (ValaSemanticAnalyzer* self);
ValaSourceFile* vala_source_reference_get_file (ValaSourceReference* self);
void vala_semantic_analyzer_set_current_source_file (ValaSemanticAnalyzer* self, ValaSourceFile* value);
void vala_semantic_analyzer_set_current_symbol (ValaSemanticAnalyzer* self, ValaSymbol* value);
GType vala_void_type_get_type (void) G_GNUC_CONST;
gboolean vala_code_node_check (ValaCodeNode* self, ValaCodeContext* context);
gboolean vala_semantic_analyzer_is_type_accessible (ValaSemanticAnalyzer* self, ValaSymbol* sym, ValaDataType* type);
gchar* vala_code_node_to_string (ValaCodeNode* self);
ValaProperty* vala_property_get_base_property (ValaProperty* self);
gboolean vala_symbol_get_external_package (ValaSymbol* self);
gboolean vala_symbol_get_hides (ValaSymbol* self);
ValaSymbol* vala_symbol_get_hidden_member (ValaSymbol* self);
void vala_report_warning (ValaSourceReference* source, const gchar* message);
ValaDataType* vala_expression_get_value_type (ValaExpression* self);
gboolean vala_data_type_compatible (ValaDataType* self, ValaDataType* target_type);
void vala_code_node_set_parent_node (ValaCodeNode* self, ValaCodeNode* value);
void vala_symbol_set_owner (ValaSymbol* self, ValaScope* value);
ValaParameter* vala_property_get_this_parameter (ValaProperty* self);
void vala_property_set_this_parameter (ValaProperty* self, ValaParameter* value);
gboolean vala_property_get_interface_only (ValaProperty* self);
void vala_property_set_interface_only (ValaProperty* self, gboolean value);
void vala_property_set_is_abstract (ValaProperty* self, gboolean value);
void vala_property_set_is_virtual (ValaProperty* self, gboolean value);
void vala_property_set_overrides (ValaProperty* self, gboolean value);
ValaField* vala_property_get_field (ValaProperty* self);
void vala_property_set_field (ValaProperty* self, ValaField* value);
ValaMemberBinding vala_property_get_binding (ValaProperty* self);
void vala_property_set_binding (ValaProperty* self, ValaMemberBinding value);
ValaProperty* vala_property_get_base_interface_property (ValaProperty* self);
static void vala_property_finalize (ValaCodeNode* obj);


/**
 * Creates a new property.
 *
 * @param name         property name
 * @param type         property type
 * @param get_accessor get accessor
 * @param set_accessor set/construct accessor
 * @param source       reference to source code
 * @return             newly created property
 */
ValaProperty* vala_property_construct (GType object_type, const gchar* name, ValaDataType* property_type, ValaPropertyAccessor* get_accessor, ValaPropertyAccessor* set_accessor, ValaSourceReference* source_reference, ValaComment* comment) {
	ValaProperty* self = NULL;
	const gchar* _tmp0_ = NULL;
	ValaSourceReference* _tmp1_ = NULL;
	ValaComment* _tmp2_ = NULL;
	ValaDataType* _tmp3_ = NULL;
	ValaPropertyAccessor* _tmp4_ = NULL;
	ValaPropertyAccessor* _tmp5_ = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = source_reference;
	_tmp2_ = comment;
	self = (ValaProperty*) vala_symbol_construct (object_type, _tmp0_, _tmp1_, _tmp2_);
	_tmp3_ = property_type;
	vala_property_set_property_type (self, _tmp3_);
	_tmp4_ = get_accessor;
	vala_property_set_get_accessor (self, _tmp4_);
	_tmp5_ = set_accessor;
	vala_property_set_set_accessor (self, _tmp5_);
	return self;
}


ValaProperty* vala_property_new (const gchar* name, ValaDataType* property_type, ValaPropertyAccessor* get_accessor, ValaPropertyAccessor* set_accessor, ValaSourceReference* source_reference, ValaComment* comment) {
	return vala_property_construct (VALA_TYPE_PROPERTY, name, property_type, get_accessor, set_accessor, source_reference, comment);
}


static void vala_property_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaProperty * self;
	ValaCodeVisitor* _tmp0_ = NULL;
	self = (ValaProperty*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_property (_tmp0_, self);
}


static void vala_property_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaProperty * self;
	ValaDataType* _tmp0_ = NULL;
	ValaDataType* _tmp1_ = NULL;
	ValaCodeVisitor* _tmp2_ = NULL;
	ValaPropertyAccessor* _tmp3_ = NULL;
	ValaPropertyAccessor* _tmp4_ = NULL;
	ValaPropertyAccessor* _tmp8_ = NULL;
	ValaPropertyAccessor* _tmp9_ = NULL;
	ValaExpression* _tmp13_ = NULL;
	ValaExpression* _tmp14_ = NULL;
	self = (ValaProperty*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_property_get_property_type (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = visitor;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, _tmp2_);
	_tmp3_ = vala_property_get_get_accessor (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != NULL) {
		ValaPropertyAccessor* _tmp5_ = NULL;
		ValaPropertyAccessor* _tmp6_ = NULL;
		ValaCodeVisitor* _tmp7_ = NULL;
		_tmp5_ = vala_property_get_get_accessor (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = visitor;
		vala_code_node_accept ((ValaCodeNode*) _tmp6_, _tmp7_);
	}
	_tmp8_ = vala_property_get_set_accessor (self);
	_tmp9_ = _tmp8_;
	if (_tmp9_ != NULL) {
		ValaPropertyAccessor* _tmp10_ = NULL;
		ValaPropertyAccessor* _tmp11_ = NULL;
		ValaCodeVisitor* _tmp12_ = NULL;
		_tmp10_ = vala_property_get_set_accessor (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = visitor;
		vala_code_node_accept ((ValaCodeNode*) _tmp11_, _tmp12_);
	}
	_tmp13_ = vala_property_get_initializer (self);
	_tmp14_ = _tmp13_;
	if (_tmp14_ != NULL) {
		ValaExpression* _tmp15_ = NULL;
		ValaExpression* _tmp16_ = NULL;
		ValaCodeVisitor* _tmp17_ = NULL;
		_tmp15_ = vala_property_get_initializer (self);
		_tmp16_ = _tmp15_;
		_tmp17_ = visitor;
		vala_code_node_accept ((ValaCodeNode*) _tmp16_, _tmp17_);
	}
}


static gboolean vala_property_real_get_lock_used (ValaLockable* base) {
	ValaProperty * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	self = (ValaProperty*) base;
	_tmp0_ = self->priv->lock_used;
	result = _tmp0_;
	return result;
}


static void vala_property_real_set_lock_used (ValaLockable* base, gboolean used) {
	ValaProperty * self;
	gboolean _tmp0_ = FALSE;
	self = (ValaProperty*) base;
	_tmp0_ = used;
	self->priv->lock_used = _tmp0_;
}


/**
 * Checks whether the accessors of this property are compatible
 * with the specified base property.
 *
 * @param base_property a property
 * @param invalid_match error string about which check failed
 * @return true if the specified property is compatible to this property
 */
gboolean vala_property_compatible (ValaProperty* self, ValaProperty* base_property, gchar** invalid_match) {
	gchar* _vala_invalid_match = NULL;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaPropertyAccessor* _tmp2_ = NULL;
	ValaPropertyAccessor* _tmp3_ = NULL;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	ValaPropertyAccessor* _tmp19_ = NULL;
	ValaPropertyAccessor* _tmp20_ = NULL;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp32_ = FALSE;
	ValaDataType* object_type = NULL;
	ValaSymbol* _tmp34_ = NULL;
	ValaSymbol* _tmp35_ = NULL;
	ValaDataType* _tmp36_ = NULL;
	ValaPropertyAccessor* _tmp37_ = NULL;
	ValaPropertyAccessor* _tmp38_ = NULL;
	ValaPropertyAccessor* _tmp53_ = NULL;
	ValaPropertyAccessor* _tmp54_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (base_property != NULL, FALSE);
	_tmp2_ = vala_property_get_get_accessor (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		ValaProperty* _tmp4_ = NULL;
		ValaPropertyAccessor* _tmp5_ = NULL;
		ValaPropertyAccessor* _tmp6_ = NULL;
		_tmp4_ = base_property;
		_tmp5_ = vala_property_get_get_accessor (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp1_ = _tmp6_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp7_ = _tmp1_;
	if (_tmp7_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp8_ = FALSE;
		ValaPropertyAccessor* _tmp9_ = NULL;
		ValaPropertyAccessor* _tmp10_ = NULL;
		gboolean _tmp14_ = FALSE;
		_tmp9_ = vala_property_get_get_accessor (self);
		_tmp10_ = _tmp9_;
		if (_tmp10_ != NULL) {
			ValaProperty* _tmp11_ = NULL;
			ValaPropertyAccessor* _tmp12_ = NULL;
			ValaPropertyAccessor* _tmp13_ = NULL;
			_tmp11_ = base_property;
			_tmp12_ = vala_property_get_get_accessor (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp8_ = _tmp13_ == NULL;
		} else {
			_tmp8_ = FALSE;
		}
		_tmp14_ = _tmp8_;
		_tmp0_ = _tmp14_;
	}
	_tmp15_ = _tmp0_;
	if (_tmp15_) {
		gchar* _tmp16_ = NULL;
		_tmp16_ = g_strdup ("incompatible get accessor");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp16_;
		result = FALSE;
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp19_ = vala_property_get_set_accessor (self);
	_tmp20_ = _tmp19_;
	if (_tmp20_ == NULL) {
		ValaProperty* _tmp21_ = NULL;
		ValaPropertyAccessor* _tmp22_ = NULL;
		ValaPropertyAccessor* _tmp23_ = NULL;
		_tmp21_ = base_property;
		_tmp22_ = vala_property_get_set_accessor (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp18_ = _tmp23_ != NULL;
	} else {
		_tmp18_ = FALSE;
	}
	_tmp24_ = _tmp18_;
	if (_tmp24_) {
		_tmp17_ = TRUE;
	} else {
		gboolean _tmp25_ = FALSE;
		ValaPropertyAccessor* _tmp26_ = NULL;
		ValaPropertyAccessor* _tmp27_ = NULL;
		gboolean _tmp31_ = FALSE;
		_tmp26_ = vala_property_get_set_accessor (self);
		_tmp27_ = _tmp26_;
		if (_tmp27_ != NULL) {
			ValaProperty* _tmp28_ = NULL;
			ValaPropertyAccessor* _tmp29_ = NULL;
			ValaPropertyAccessor* _tmp30_ = NULL;
			_tmp28_ = base_property;
			_tmp29_ = vala_property_get_set_accessor (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp25_ = _tmp30_ == NULL;
		} else {
			_tmp25_ = FALSE;
		}
		_tmp31_ = _tmp25_;
		_tmp17_ = _tmp31_;
	}
	_tmp32_ = _tmp17_;
	if (_tmp32_) {
		gchar* _tmp33_ = NULL;
		_tmp33_ = g_strdup ("incompatible set accessor");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp33_;
		result = FALSE;
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp34_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp35_ = _tmp34_;
	_tmp36_ = vala_semantic_analyzer_get_data_type_for_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
	object_type = _tmp36_;
	_tmp37_ = vala_property_get_get_accessor (self);
	_tmp38_ = _tmp37_;
	if (_tmp38_ != NULL) {
		ValaDataType* actual_base_type = NULL;
		ValaProperty* _tmp39_ = NULL;
		ValaPropertyAccessor* _tmp40_ = NULL;
		ValaPropertyAccessor* _tmp41_ = NULL;
		ValaDataType* _tmp42_ = NULL;
		ValaDataType* _tmp43_ = NULL;
		ValaDataType* _tmp44_ = NULL;
		ValaDataType* _tmp45_ = NULL;
		ValaDataType* _tmp46_ = NULL;
		ValaPropertyAccessor* _tmp47_ = NULL;
		ValaPropertyAccessor* _tmp48_ = NULL;
		ValaDataType* _tmp49_ = NULL;
		ValaDataType* _tmp50_ = NULL;
		gboolean _tmp51_ = FALSE;
		_tmp39_ = base_property;
		_tmp40_ = vala_property_get_get_accessor (_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_property_accessor_get_value_type (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = object_type;
		_tmp45_ = vala_data_type_get_actual_type (_tmp43_, _tmp44_, NULL, (ValaCodeNode*) self);
		actual_base_type = _tmp45_;
		_tmp46_ = actual_base_type;
		_tmp47_ = vala_property_get_get_accessor (self);
		_tmp48_ = _tmp47_;
		_tmp49_ = vala_property_accessor_get_value_type (_tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = vala_data_type_equals (_tmp46_, _tmp50_);
		if (!_tmp51_) {
			gchar* _tmp52_ = NULL;
			_tmp52_ = g_strdup ("incompatible get accessor type");
			_g_free0 (_vala_invalid_match);
			_vala_invalid_match = _tmp52_;
			result = FALSE;
			_vala_code_node_unref0 (actual_base_type);
			_vala_code_node_unref0 (object_type);
			if (invalid_match) {
				*invalid_match = _vala_invalid_match;
			} else {
				_g_free0 (_vala_invalid_match);
			}
			return result;
		}
		_vala_code_node_unref0 (actual_base_type);
	}
	_tmp53_ = vala_property_get_set_accessor (self);
	_tmp54_ = _tmp53_;
	if (_tmp54_ != NULL) {
		ValaDataType* actual_base_type = NULL;
		ValaProperty* _tmp55_ = NULL;
		ValaPropertyAccessor* _tmp56_ = NULL;
		ValaPropertyAccessor* _tmp57_ = NULL;
		ValaDataType* _tmp58_ = NULL;
		ValaDataType* _tmp59_ = NULL;
		ValaDataType* _tmp60_ = NULL;
		ValaDataType* _tmp61_ = NULL;
		ValaDataType* _tmp62_ = NULL;
		ValaPropertyAccessor* _tmp63_ = NULL;
		ValaPropertyAccessor* _tmp64_ = NULL;
		ValaDataType* _tmp65_ = NULL;
		ValaDataType* _tmp66_ = NULL;
		gboolean _tmp67_ = FALSE;
		ValaPropertyAccessor* _tmp69_ = NULL;
		ValaPropertyAccessor* _tmp70_ = NULL;
		gboolean _tmp71_ = FALSE;
		gboolean _tmp72_ = FALSE;
		ValaProperty* _tmp73_ = NULL;
		ValaPropertyAccessor* _tmp74_ = NULL;
		ValaPropertyAccessor* _tmp75_ = NULL;
		gboolean _tmp76_ = FALSE;
		gboolean _tmp77_ = FALSE;
		ValaPropertyAccessor* _tmp79_ = NULL;
		ValaPropertyAccessor* _tmp80_ = NULL;
		gboolean _tmp81_ = FALSE;
		gboolean _tmp82_ = FALSE;
		ValaProperty* _tmp83_ = NULL;
		ValaPropertyAccessor* _tmp84_ = NULL;
		ValaPropertyAccessor* _tmp85_ = NULL;
		gboolean _tmp86_ = FALSE;
		gboolean _tmp87_ = FALSE;
		_tmp55_ = base_property;
		_tmp56_ = vala_property_get_set_accessor (_tmp55_);
		_tmp57_ = _tmp56_;
		_tmp58_ = vala_property_accessor_get_value_type (_tmp57_);
		_tmp59_ = _tmp58_;
		_tmp60_ = object_type;
		_tmp61_ = vala_data_type_get_actual_type (_tmp59_, _tmp60_, NULL, (ValaCodeNode*) self);
		actual_base_type = _tmp61_;
		_tmp62_ = actual_base_type;
		_tmp63_ = vala_property_get_set_accessor (self);
		_tmp64_ = _tmp63_;
		_tmp65_ = vala_property_accessor_get_value_type (_tmp64_);
		_tmp66_ = _tmp65_;
		_tmp67_ = vala_data_type_equals (_tmp62_, _tmp66_);
		if (!_tmp67_) {
			gchar* _tmp68_ = NULL;
			_tmp68_ = g_strdup ("incompatible set accessor type");
			_g_free0 (_vala_invalid_match);
			_vala_invalid_match = _tmp68_;
			result = FALSE;
			_vala_code_node_unref0 (actual_base_type);
			_vala_code_node_unref0 (object_type);
			if (invalid_match) {
				*invalid_match = _vala_invalid_match;
			} else {
				_g_free0 (_vala_invalid_match);
			}
			return result;
		}
		_tmp69_ = vala_property_get_set_accessor (self);
		_tmp70_ = _tmp69_;
		_tmp71_ = vala_property_accessor_get_writable (_tmp70_);
		_tmp72_ = _tmp71_;
		_tmp73_ = base_property;
		_tmp74_ = vala_property_get_set_accessor (_tmp73_);
		_tmp75_ = _tmp74_;
		_tmp76_ = vala_property_accessor_get_writable (_tmp75_);
		_tmp77_ = _tmp76_;
		if (_tmp72_ != _tmp77_) {
			gchar* _tmp78_ = NULL;
			_tmp78_ = g_strdup ("incompatible set accessor");
			_g_free0 (_vala_invalid_match);
			_vala_invalid_match = _tmp78_;
			result = FALSE;
			_vala_code_node_unref0 (actual_base_type);
			_vala_code_node_unref0 (object_type);
			if (invalid_match) {
				*invalid_match = _vala_invalid_match;
			} else {
				_g_free0 (_vala_invalid_match);
			}
			return result;
		}
		_tmp79_ = vala_property_get_set_accessor (self);
		_tmp80_ = _tmp79_;
		_tmp81_ = vala_property_accessor_get_construction (_tmp80_);
		_tmp82_ = _tmp81_;
		_tmp83_ = base_property;
		_tmp84_ = vala_property_get_set_accessor (_tmp83_);
		_tmp85_ = _tmp84_;
		_tmp86_ = vala_property_accessor_get_construction (_tmp85_);
		_tmp87_ = _tmp86_;
		if (_tmp82_ != _tmp87_) {
			gchar* _tmp88_ = NULL;
			_tmp88_ = g_strdup ("incompatible set accessor");
			_g_free0 (_vala_invalid_match);
			_vala_invalid_match = _tmp88_;
			result = FALSE;
			_vala_code_node_unref0 (actual_base_type);
			_vala_code_node_unref0 (object_type);
			if (invalid_match) {
				*invalid_match = _vala_invalid_match;
			} else {
				_g_free0 (_vala_invalid_match);
			}
			return result;
		}
		_vala_code_node_unref0 (actual_base_type);
	}
	_g_free0 (_vala_invalid_match);
	_vala_invalid_match = NULL;
	result = TRUE;
	_vala_code_node_unref0 (object_type);
	if (invalid_match) {
		*invalid_match = _vala_invalid_match;
	} else {
		_g_free0 (_vala_invalid_match);
	}
	return result;
}


static void vala_property_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaProperty * self;
	ValaDataType* _tmp0_ = NULL;
	ValaDataType* _tmp1_ = NULL;
	ValaDataType* _tmp2_ = NULL;
	self = (ValaProperty*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_property_get_property_type (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = old_type;
	if (_tmp1_ == _tmp2_) {
		ValaDataType* _tmp3_ = NULL;
		_tmp3_ = new_type;
		vala_property_set_property_type (self, _tmp3_);
	}
}


static void vala_property_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaProperty * self;
	ValaExpression* _tmp0_ = NULL;
	ValaExpression* _tmp1_ = NULL;
	ValaExpression* _tmp2_ = NULL;
	self = (ValaProperty*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_property_get_initializer (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = old_node;
	if (_tmp1_ == _tmp2_) {
		ValaExpression* _tmp3_ = NULL;
		_tmp3_ = new_node;
		vala_property_set_initializer (self, _tmp3_);
	}
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static void vala_property_find_base_properties (ValaProperty* self) {
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_ = NULL;
	ValaSymbol* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->base_properties_valid;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALA_TYPE_CLASS)) {
		ValaSymbol* _tmp3_ = NULL;
		ValaSymbol* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp8_ = FALSE;
		_tmp3_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_property_find_base_interface_property (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, VALA_TYPE_CLASS, ValaClass));
		_tmp6_ = self->priv->_is_virtual;
		if (_tmp6_) {
			_tmp5_ = TRUE;
		} else {
			gboolean _tmp7_ = FALSE;
			_tmp7_ = self->priv->_overrides;
			_tmp5_ = _tmp7_;
		}
		_tmp8_ = _tmp5_;
		if (_tmp8_) {
			ValaSymbol* _tmp9_ = NULL;
			ValaSymbol* _tmp10_ = NULL;
			_tmp9_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp10_ = _tmp9_;
			vala_property_find_base_class_property (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, VALA_TYPE_CLASS, ValaClass));
		}
	} else {
		ValaSymbol* _tmp11_ = NULL;
		ValaSymbol* _tmp12_ = NULL;
		_tmp11_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp12_ = _tmp11_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALA_TYPE_INTERFACE)) {
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_ = FALSE;
			gboolean _tmp16_ = FALSE;
			_tmp14_ = self->priv->_is_virtual;
			if (_tmp14_) {
				_tmp13_ = TRUE;
			} else {
				gboolean _tmp15_ = FALSE;
				_tmp15_ = self->priv->_is_abstract;
				_tmp13_ = _tmp15_;
			}
			_tmp16_ = _tmp13_;
			if (_tmp16_) {
				ValaProperty* _tmp17_ = NULL;
				_tmp17_ = _vala_code_node_ref0 (self);
				_vala_code_node_unref0 (self->priv->_base_interface_property);
				self->priv->_base_interface_property = _tmp17_;
			}
		}
	}
	self->priv->base_properties_valid = TRUE;
}


static void vala_property_find_base_class_property (ValaProperty* self, ValaClass* cl) {
	ValaSymbol* sym = NULL;
	ValaClass* _tmp0_ = NULL;
	ValaScope* _tmp1_ = NULL;
	ValaScope* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	ValaSymbol* _tmp5_ = NULL;
	ValaSymbol* _tmp6_ = NULL;
	ValaClass* _tmp29_ = NULL;
	ValaClass* _tmp30_ = NULL;
	ValaClass* _tmp31_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp0_ = cl;
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_scope_lookup (_tmp2_, _tmp4_);
	sym = _tmp5_;
	_tmp6_ = sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, VALA_TYPE_PROPERTY)) {
		ValaProperty* base_property = NULL;
		ValaSymbol* _tmp7_ = NULL;
		ValaProperty* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		ValaProperty* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp14_ = FALSE;
		_tmp7_ = sym;
		_tmp8_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, VALA_TYPE_PROPERTY, ValaProperty));
		base_property = _tmp8_;
		_tmp10_ = base_property;
		_tmp11_ = _tmp10_->priv->_is_abstract;
		if (_tmp11_) {
			_tmp9_ = TRUE;
		} else {
			ValaProperty* _tmp12_ = NULL;
			gboolean _tmp13_ = FALSE;
			_tmp12_ = base_property;
			_tmp13_ = _tmp12_->priv->_is_virtual;
			_tmp9_ = _tmp13_;
		}
		_tmp14_ = _tmp9_;
		if (_tmp14_) {
			gchar* invalid_match = NULL;
			ValaProperty* _tmp15_ = NULL;
			gchar* _tmp16_ = NULL;
			gboolean _tmp17_ = FALSE;
			ValaProperty* _tmp28_ = NULL;
			_tmp15_ = base_property;
			_tmp17_ = vala_property_compatible (self, _tmp15_, &_tmp16_);
			_g_free0 (invalid_match);
			invalid_match = _tmp16_;
			if (!_tmp17_) {
				ValaSourceReference* _tmp18_ = NULL;
				ValaSourceReference* _tmp19_ = NULL;
				gchar* _tmp20_ = NULL;
				gchar* _tmp21_ = NULL;
				ValaProperty* _tmp22_ = NULL;
				gchar* _tmp23_ = NULL;
				gchar* _tmp24_ = NULL;
				const gchar* _tmp25_ = NULL;
				gchar* _tmp26_ = NULL;
				gchar* _tmp27_ = NULL;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp19_ = _tmp18_;
				_tmp20_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp21_ = _tmp20_;
				_tmp22_ = base_property;
				_tmp23_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = invalid_match;
				_tmp26_ = g_strdup_printf ("Type and/or accessors of overriding property `%s' do not match overrid" \
"den property `%s': %s.", _tmp21_, _tmp24_, _tmp25_);
				_tmp27_ = _tmp26_;
				vala_report_error (_tmp19_, _tmp27_);
				_g_free0 (_tmp27_);
				_g_free0 (_tmp24_);
				_g_free0 (_tmp21_);
				_g_free0 (invalid_match);
				_vala_code_node_unref0 (base_property);
				_vala_code_node_unref0 (sym);
				return;
			}
			_tmp28_ = base_property;
			self->priv->_base_property = _tmp28_;
			_g_free0 (invalid_match);
			_vala_code_node_unref0 (base_property);
			_vala_code_node_unref0 (sym);
			return;
		}
		_vala_code_node_unref0 (base_property);
	}
	_tmp29_ = cl;
	_tmp30_ = vala_class_get_base_class (_tmp29_);
	_tmp31_ = _tmp30_;
	if (_tmp31_ != NULL) {
		ValaClass* _tmp32_ = NULL;
		ValaClass* _tmp33_ = NULL;
		ValaClass* _tmp34_ = NULL;
		_tmp32_ = cl;
		_tmp33_ = vala_class_get_base_class (_tmp32_);
		_tmp34_ = _tmp33_;
		vala_property_find_base_class_property (self, _tmp34_);
	}
	_vala_code_node_unref0 (sym);
}


static void vala_property_find_base_interface_property (ValaProperty* self, ValaClass* cl) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	{
		ValaList* _type_list = NULL;
		ValaClass* _tmp0_ = NULL;
		ValaList* _tmp1_ = NULL;
		gint _type_size = 0;
		ValaList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _type_index = 0;
		_tmp0_ = cl;
		_tmp1_ = vala_class_get_base_types (_tmp0_);
		_type_list = _tmp1_;
		_tmp2_ = _type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_type_size = _tmp4_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			ValaDataType* type = NULL;
			ValaList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			ValaDataType* _tmp11_ = NULL;
			ValaTypeSymbol* _tmp12_ = NULL;
			ValaTypeSymbol* _tmp13_ = NULL;
			_tmp5_ = _type_index;
			_type_index = _tmp5_ + 1;
			_tmp6_ = _type_index;
			_tmp7_ = _type_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _type_list;
			_tmp9_ = _type_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			type = (ValaDataType*) _tmp10_;
			_tmp11_ = type;
			_tmp12_ = vala_data_type_get_data_type (_tmp11_);
			_tmp13_ = _tmp12_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, VALA_TYPE_INTERFACE)) {
				ValaSymbol* sym = NULL;
				ValaDataType* _tmp14_ = NULL;
				ValaTypeSymbol* _tmp15_ = NULL;
				ValaTypeSymbol* _tmp16_ = NULL;
				ValaScope* _tmp17_ = NULL;
				ValaScope* _tmp18_ = NULL;
				const gchar* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
				ValaSymbol* _tmp21_ = NULL;
				ValaSymbol* _tmp22_ = NULL;
				_tmp14_ = type;
				_tmp15_ = vala_data_type_get_data_type (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = vala_symbol_get_scope ((ValaSymbol*) _tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = vala_symbol_get_name ((ValaSymbol*) self);
				_tmp20_ = _tmp19_;
				_tmp21_ = vala_scope_lookup (_tmp18_, _tmp20_);
				sym = _tmp21_;
				_tmp22_ = sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, VALA_TYPE_PROPERTY)) {
					ValaProperty* base_property = NULL;
					ValaSymbol* _tmp23_ = NULL;
					ValaProperty* _tmp24_ = NULL;
					gboolean _tmp25_ = FALSE;
					ValaProperty* _tmp26_ = NULL;
					gboolean _tmp27_ = FALSE;
					gboolean _tmp30_ = FALSE;
					_tmp23_ = sym;
					_tmp24_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, VALA_TYPE_PROPERTY, ValaProperty));
					base_property = _tmp24_;
					_tmp26_ = base_property;
					_tmp27_ = _tmp26_->priv->_is_abstract;
					if (_tmp27_) {
						_tmp25_ = TRUE;
					} else {
						ValaProperty* _tmp28_ = NULL;
						gboolean _tmp29_ = FALSE;
						_tmp28_ = base_property;
						_tmp29_ = _tmp28_->priv->_is_virtual;
						_tmp25_ = _tmp29_;
					}
					_tmp30_ = _tmp25_;
					if (_tmp30_) {
						gchar* invalid_match = NULL;
						ValaProperty* _tmp31_ = NULL;
						gchar* _tmp32_ = NULL;
						gboolean _tmp33_ = FALSE;
						ValaProperty* _tmp44_ = NULL;
						ValaProperty* _tmp45_ = NULL;
						_tmp31_ = base_property;
						_tmp33_ = vala_property_compatible (self, _tmp31_, &_tmp32_);
						_g_free0 (invalid_match);
						invalid_match = _tmp32_;
						if (!_tmp33_) {
							ValaSourceReference* _tmp34_ = NULL;
							ValaSourceReference* _tmp35_ = NULL;
							gchar* _tmp36_ = NULL;
							gchar* _tmp37_ = NULL;
							ValaProperty* _tmp38_ = NULL;
							gchar* _tmp39_ = NULL;
							gchar* _tmp40_ = NULL;
							const gchar* _tmp41_ = NULL;
							gchar* _tmp42_ = NULL;
							gchar* _tmp43_ = NULL;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp34_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp35_ = _tmp34_;
							_tmp36_ = vala_symbol_get_full_name ((ValaSymbol*) self);
							_tmp37_ = _tmp36_;
							_tmp38_ = base_property;
							_tmp39_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp38_);
							_tmp40_ = _tmp39_;
							_tmp41_ = invalid_match;
							_tmp42_ = g_strdup_printf ("Type and/or accessors of overriding property `%s' do not match overrid" \
"den property `%s': %s.", _tmp37_, _tmp40_, _tmp41_);
							_tmp43_ = _tmp42_;
							vala_report_error (_tmp35_, _tmp43_);
							_g_free0 (_tmp43_);
							_g_free0 (_tmp40_);
							_g_free0 (_tmp37_);
							_g_free0 (invalid_match);
							_vala_code_node_unref0 (base_property);
							_vala_code_node_unref0 (sym);
							_vala_code_node_unref0 (type);
							_vala_iterable_unref0 (_type_list);
							return;
						}
						_tmp44_ = base_property;
						_tmp45_ = _vala_code_node_ref0 (_tmp44_);
						_vala_code_node_unref0 (self->priv->_base_interface_property);
						self->priv->_base_interface_property = _tmp45_;
						_g_free0 (invalid_match);
						_vala_code_node_unref0 (base_property);
						_vala_code_node_unref0 (sym);
						_vala_code_node_unref0 (type);
						_vala_iterable_unref0 (_type_list);
						return;
					}
					_vala_code_node_unref0 (base_property);
				}
				_vala_code_node_unref0 (sym);
			}
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


static gboolean vala_property_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaProperty * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp4_ = FALSE;
	ValaSourceFile* old_source_file = NULL;
	ValaCodeContext* _tmp53_ = NULL;
	ValaSemanticAnalyzer* _tmp54_ = NULL;
	ValaSemanticAnalyzer* _tmp55_ = NULL;
	ValaSourceFile* _tmp56_ = NULL;
	ValaSourceFile* _tmp57_ = NULL;
	ValaSourceFile* _tmp58_ = NULL;
	ValaSymbol* old_symbol = NULL;
	ValaCodeContext* _tmp59_ = NULL;
	ValaSemanticAnalyzer* _tmp60_ = NULL;
	ValaSemanticAnalyzer* _tmp61_ = NULL;
	ValaSymbol* _tmp62_ = NULL;
	ValaSymbol* _tmp63_ = NULL;
	ValaSymbol* _tmp64_ = NULL;
	ValaSourceReference* _tmp65_ = NULL;
	ValaSourceReference* _tmp66_ = NULL;
	ValaCodeContext* _tmp74_ = NULL;
	ValaSemanticAnalyzer* _tmp75_ = NULL;
	ValaSemanticAnalyzer* _tmp76_ = NULL;
	ValaDataType* _tmp77_ = NULL;
	ValaDataType* _tmp78_ = NULL;
	ValaDataType* _tmp81_ = NULL;
	ValaDataType* _tmp82_ = NULL;
	ValaCodeContext* _tmp83_ = NULL;
	ValaPropertyAccessor* _tmp84_ = NULL;
	ValaPropertyAccessor* _tmp85_ = NULL;
	ValaPropertyAccessor* _tmp89_ = NULL;
	ValaPropertyAccessor* _tmp90_ = NULL;
	ValaExpression* _tmp94_ = NULL;
	ValaExpression* _tmp95_ = NULL;
	ValaCodeContext* _tmp99_ = NULL;
	ValaSemanticAnalyzer* _tmp100_ = NULL;
	ValaSemanticAnalyzer* _tmp101_ = NULL;
	ValaDataType* _tmp102_ = NULL;
	ValaDataType* _tmp103_ = NULL;
	gboolean _tmp104_ = FALSE;
	gboolean _tmp115_ = FALSE;
	gboolean _tmp116_ = FALSE;
	gboolean _tmp119_ = FALSE;
	gboolean _tmp126_ = FALSE;
	gboolean _tmp127_ = FALSE;
	gboolean _tmp128_ = FALSE;
	gboolean _tmp129_ = FALSE;
	gboolean _tmp130_ = FALSE;
	gboolean _tmp132_ = FALSE;
	gboolean _tmp135_ = FALSE;
	gboolean _tmp138_ = FALSE;
	gboolean _tmp149_ = FALSE;
	ValaPropertyAccessor* _tmp150_ = NULL;
	ValaPropertyAccessor* _tmp151_ = NULL;
	gboolean _tmp156_ = FALSE;
	gboolean _tmp165_ = FALSE;
	gboolean _tmp166_ = FALSE;
	gboolean _tmp167_ = FALSE;
	ValaExpression* _tmp168_ = NULL;
	ValaExpression* _tmp169_ = NULL;
	gboolean _tmp174_ = FALSE;
	gboolean _tmp179_ = FALSE;
	gboolean _tmp187_ = FALSE;
	ValaCodeContext* _tmp204_ = NULL;
	ValaSemanticAnalyzer* _tmp205_ = NULL;
	ValaSemanticAnalyzer* _tmp206_ = NULL;
	ValaSourceFile* _tmp207_ = NULL;
	ValaCodeContext* _tmp208_ = NULL;
	ValaSemanticAnalyzer* _tmp209_ = NULL;
	ValaSemanticAnalyzer* _tmp210_ = NULL;
	ValaSymbol* _tmp211_ = NULL;
	gboolean _tmp212_ = FALSE;
	gboolean _tmp213_ = FALSE;
	self = (ValaProperty*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = self->priv->_is_abstract;
	if (_tmp4_) {
		ValaSymbol* _tmp5_ = NULL;
		ValaSymbol* _tmp6_ = NULL;
		_tmp5_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp6_ = _tmp5_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, VALA_TYPE_CLASS)) {
			ValaClass* cl = NULL;
			ValaSymbol* _tmp7_ = NULL;
			ValaSymbol* _tmp8_ = NULL;
			ValaClass* _tmp9_ = NULL;
			ValaClass* _tmp10_ = NULL;
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_ = FALSE;
			_tmp7_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp8_ = _tmp7_;
			_tmp9_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_CLASS, ValaClass));
			cl = _tmp9_;
			_tmp10_ = cl;
			_tmp11_ = vala_class_get_is_abstract (_tmp10_);
			_tmp12_ = _tmp11_;
			if (!_tmp12_) {
				ValaSourceReference* _tmp13_ = NULL;
				ValaSourceReference* _tmp14_ = NULL;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp13_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp14_ = _tmp13_;
				vala_report_error (_tmp14_, "Abstract properties may not be declared in non-abstract classes");
				result = FALSE;
				_vala_code_node_unref0 (cl);
				return result;
			}
			_vala_code_node_unref0 (cl);
		} else {
			ValaSymbol* _tmp15_ = NULL;
			ValaSymbol* _tmp16_ = NULL;
			_tmp15_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp16_ = _tmp15_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_INTERFACE)) {
				ValaSourceReference* _tmp17_ = NULL;
				ValaSourceReference* _tmp18_ = NULL;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp17_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp18_ = _tmp17_;
				vala_report_error (_tmp18_, "Abstract properties may not be declared outside of classes and interfa" \
"ces");
				result = FALSE;
				return result;
			}
		}
	} else {
		gboolean _tmp19_ = FALSE;
		_tmp19_ = self->priv->_is_virtual;
		if (_tmp19_) {
			gboolean _tmp20_ = FALSE;
			ValaSymbol* _tmp21_ = NULL;
			ValaSymbol* _tmp22_ = NULL;
			gboolean _tmp25_ = FALSE;
			ValaSymbol* _tmp28_ = NULL;
			ValaSymbol* _tmp29_ = NULL;
			_tmp21_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp22_ = _tmp21_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, VALA_TYPE_CLASS)) {
				ValaSymbol* _tmp23_ = NULL;
				ValaSymbol* _tmp24_ = NULL;
				_tmp23_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp24_ = _tmp23_;
				_tmp20_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, VALA_TYPE_INTERFACE);
			} else {
				_tmp20_ = FALSE;
			}
			_tmp25_ = _tmp20_;
			if (_tmp25_) {
				ValaSourceReference* _tmp26_ = NULL;
				ValaSourceReference* _tmp27_ = NULL;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp27_ = _tmp26_;
				vala_report_error (_tmp27_, "Virtual properties may not be declared outside of classes and interfac" \
"es");
				result = FALSE;
				return result;
			}
			_tmp28_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp29_ = _tmp28_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, VALA_TYPE_CLASS)) {
				ValaClass* cl = NULL;
				ValaSymbol* _tmp30_ = NULL;
				ValaSymbol* _tmp31_ = NULL;
				ValaClass* _tmp32_ = NULL;
				ValaClass* _tmp33_ = NULL;
				gboolean _tmp34_ = FALSE;
				gboolean _tmp35_ = FALSE;
				_tmp30_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp31_ = _tmp30_;
				_tmp32_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp32_;
				_tmp33_ = cl;
				_tmp34_ = vala_class_get_is_compact (_tmp33_);
				_tmp35_ = _tmp34_;
				if (_tmp35_) {
					ValaSourceReference* _tmp36_ = NULL;
					ValaSourceReference* _tmp37_ = NULL;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp36_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp37_ = _tmp36_;
					vala_report_error (_tmp37_, "Virtual properties may not be declared in compact classes");
					result = FALSE;
					_vala_code_node_unref0 (cl);
					return result;
				}
				_vala_code_node_unref0 (cl);
			}
		} else {
			gboolean _tmp38_ = FALSE;
			_tmp38_ = self->priv->_overrides;
			if (_tmp38_) {
				ValaSymbol* _tmp39_ = NULL;
				ValaSymbol* _tmp40_ = NULL;
				_tmp39_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp40_ = _tmp39_;
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp40_, VALA_TYPE_CLASS)) {
					ValaSourceReference* _tmp41_ = NULL;
					ValaSourceReference* _tmp42_ = NULL;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp41_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp42_ = _tmp41_;
					vala_report_error (_tmp42_, "Properties may not be overridden outside of classes");
					result = FALSE;
					return result;
				}
			} else {
				ValaSymbolAccessibility _tmp43_ = 0;
				ValaSymbolAccessibility _tmp44_ = 0;
				_tmp43_ = vala_symbol_get_access ((ValaSymbol*) self);
				_tmp44_ = _tmp43_;
				if (_tmp44_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
					gboolean _tmp45_ = FALSE;
					ValaSymbol* _tmp46_ = NULL;
					ValaSymbol* _tmp47_ = NULL;
					gboolean _tmp50_ = FALSE;
					_tmp46_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
					_tmp47_ = _tmp46_;
					if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp47_, VALA_TYPE_CLASS)) {
						ValaSymbol* _tmp48_ = NULL;
						ValaSymbol* _tmp49_ = NULL;
						_tmp48_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
						_tmp49_ = _tmp48_;
						_tmp45_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp49_, VALA_TYPE_INTERFACE);
					} else {
						_tmp45_ = FALSE;
					}
					_tmp50_ = _tmp45_;
					if (_tmp50_) {
						ValaSourceReference* _tmp51_ = NULL;
						ValaSourceReference* _tmp52_ = NULL;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp51_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp52_ = _tmp51_;
						vala_report_error (_tmp52_, "Protected properties may not be declared outside of classes and interf" \
"aces");
						result = FALSE;
						return result;
					}
				}
			}
		}
	}
	_tmp53_ = context;
	_tmp54_ = vala_code_context_get_analyzer (_tmp53_);
	_tmp55_ = _tmp54_;
	_tmp56_ = vala_semantic_analyzer_get_current_source_file (_tmp55_);
	_tmp57_ = _tmp56_;
	_tmp58_ = _vala_source_file_ref0 (_tmp57_);
	old_source_file = _tmp58_;
	_tmp59_ = context;
	_tmp60_ = vala_code_context_get_analyzer (_tmp59_);
	_tmp61_ = _tmp60_;
	_tmp62_ = vala_semantic_analyzer_get_current_symbol (_tmp61_);
	_tmp63_ = _tmp62_;
	_tmp64_ = _vala_code_node_ref0 (_tmp63_);
	old_symbol = _tmp64_;
	_tmp65_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp66_ = _tmp65_;
	if (_tmp66_ != NULL) {
		ValaCodeContext* _tmp67_ = NULL;
		ValaSemanticAnalyzer* _tmp68_ = NULL;
		ValaSemanticAnalyzer* _tmp69_ = NULL;
		ValaSourceReference* _tmp70_ = NULL;
		ValaSourceReference* _tmp71_ = NULL;
		ValaSourceFile* _tmp72_ = NULL;
		ValaSourceFile* _tmp73_ = NULL;
		_tmp67_ = context;
		_tmp68_ = vala_code_context_get_analyzer (_tmp67_);
		_tmp69_ = _tmp68_;
		_tmp70_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp71_ = _tmp70_;
		_tmp72_ = vala_source_reference_get_file (_tmp71_);
		_tmp73_ = _tmp72_;
		vala_semantic_analyzer_set_current_source_file (_tmp69_, _tmp73_);
	}
	_tmp74_ = context;
	_tmp75_ = vala_code_context_get_analyzer (_tmp74_);
	_tmp76_ = _tmp75_;
	vala_semantic_analyzer_set_current_symbol (_tmp76_, (ValaSymbol*) self);
	_tmp77_ = vala_property_get_property_type (self);
	_tmp78_ = _tmp77_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp78_, VALA_TYPE_VOID_TYPE)) {
		ValaSourceReference* _tmp79_ = NULL;
		ValaSourceReference* _tmp80_ = NULL;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp79_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp80_ = _tmp79_;
		vala_report_error (_tmp80_, "'void' not supported as property type");
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp81_ = vala_property_get_property_type (self);
	_tmp82_ = _tmp81_;
	_tmp83_ = context;
	vala_code_node_check ((ValaCodeNode*) _tmp82_, _tmp83_);
	_tmp84_ = vala_property_get_get_accessor (self);
	_tmp85_ = _tmp84_;
	if (_tmp85_ != NULL) {
		ValaPropertyAccessor* _tmp86_ = NULL;
		ValaPropertyAccessor* _tmp87_ = NULL;
		ValaCodeContext* _tmp88_ = NULL;
		_tmp86_ = vala_property_get_get_accessor (self);
		_tmp87_ = _tmp86_;
		_tmp88_ = context;
		vala_code_node_check ((ValaCodeNode*) _tmp87_, _tmp88_);
	}
	_tmp89_ = vala_property_get_set_accessor (self);
	_tmp90_ = _tmp89_;
	if (_tmp90_ != NULL) {
		ValaPropertyAccessor* _tmp91_ = NULL;
		ValaPropertyAccessor* _tmp92_ = NULL;
		ValaCodeContext* _tmp93_ = NULL;
		_tmp91_ = vala_property_get_set_accessor (self);
		_tmp92_ = _tmp91_;
		_tmp93_ = context;
		vala_code_node_check ((ValaCodeNode*) _tmp92_, _tmp93_);
	}
	_tmp94_ = vala_property_get_initializer (self);
	_tmp95_ = _tmp94_;
	if (_tmp95_ != NULL) {
		ValaExpression* _tmp96_ = NULL;
		ValaExpression* _tmp97_ = NULL;
		ValaCodeContext* _tmp98_ = NULL;
		_tmp96_ = vala_property_get_initializer (self);
		_tmp97_ = _tmp96_;
		_tmp98_ = context;
		vala_code_node_check ((ValaCodeNode*) _tmp97_, _tmp98_);
	}
	_tmp99_ = context;
	_tmp100_ = vala_code_context_get_analyzer (_tmp99_);
	_tmp101_ = _tmp100_;
	_tmp102_ = vala_property_get_property_type (self);
	_tmp103_ = _tmp102_;
	_tmp104_ = vala_semantic_analyzer_is_type_accessible (_tmp101_, (ValaSymbol*) self, _tmp103_);
	if (!_tmp104_) {
		ValaSourceReference* _tmp105_ = NULL;
		ValaSourceReference* _tmp106_ = NULL;
		ValaDataType* _tmp107_ = NULL;
		ValaDataType* _tmp108_ = NULL;
		gchar* _tmp109_ = NULL;
		gchar* _tmp110_ = NULL;
		gchar* _tmp111_ = NULL;
		gchar* _tmp112_ = NULL;
		gchar* _tmp113_ = NULL;
		gchar* _tmp114_ = NULL;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp105_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp106_ = _tmp105_;
		_tmp107_ = vala_property_get_property_type (self);
		_tmp108_ = _tmp107_;
		_tmp109_ = vala_code_node_to_string ((ValaCodeNode*) _tmp108_);
		_tmp110_ = _tmp109_;
		_tmp111_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp112_ = _tmp111_;
		_tmp113_ = g_strdup_printf ("property type `%s` is less accessible than property `%s`", _tmp110_, _tmp112_);
		_tmp114_ = _tmp113_;
		vala_report_error (_tmp106_, _tmp114_);
		_g_free0 (_tmp114_);
		_g_free0 (_tmp112_);
		_g_free0 (_tmp110_);
	}
	_tmp116_ = self->priv->_overrides;
	if (_tmp116_) {
		ValaProperty* _tmp117_ = NULL;
		ValaProperty* _tmp118_ = NULL;
		_tmp117_ = vala_property_get_base_property (self);
		_tmp118_ = _tmp117_;
		_tmp115_ = _tmp118_ == NULL;
	} else {
		_tmp115_ = FALSE;
	}
	_tmp119_ = _tmp115_;
	if (_tmp119_) {
		ValaSourceReference* _tmp120_ = NULL;
		ValaSourceReference* _tmp121_ = NULL;
		gchar* _tmp122_ = NULL;
		gchar* _tmp123_ = NULL;
		gchar* _tmp124_ = NULL;
		gchar* _tmp125_ = NULL;
		_tmp120_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp121_ = _tmp120_;
		_tmp122_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp123_ = _tmp122_;
		_tmp124_ = g_strdup_printf ("%s: no suitable property found to override", _tmp123_);
		_tmp125_ = _tmp124_;
		vala_report_error (_tmp121_, _tmp125_);
		_g_free0 (_tmp125_);
		_g_free0 (_tmp123_);
	}
	_tmp129_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp130_ = _tmp129_;
	if (!_tmp130_) {
		gboolean _tmp131_ = FALSE;
		_tmp131_ = self->priv->_overrides;
		_tmp128_ = !_tmp131_;
	} else {
		_tmp128_ = FALSE;
	}
	_tmp132_ = _tmp128_;
	if (_tmp132_) {
		gboolean _tmp133_ = FALSE;
		gboolean _tmp134_ = FALSE;
		_tmp133_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp134_ = _tmp133_;
		_tmp127_ = !_tmp134_;
	} else {
		_tmp127_ = FALSE;
	}
	_tmp135_ = _tmp127_;
	if (_tmp135_) {
		ValaSymbol* _tmp136_ = NULL;
		ValaSymbol* _tmp137_ = NULL;
		_tmp136_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp137_ = _tmp136_;
		_tmp126_ = _tmp137_ != NULL;
		_vala_code_node_unref0 (_tmp137_);
	} else {
		_tmp126_ = FALSE;
	}
	_tmp138_ = _tmp126_;
	if (_tmp138_) {
		ValaSourceReference* _tmp139_ = NULL;
		ValaSourceReference* _tmp140_ = NULL;
		gchar* _tmp141_ = NULL;
		gchar* _tmp142_ = NULL;
		ValaSymbol* _tmp143_ = NULL;
		ValaSymbol* _tmp144_ = NULL;
		gchar* _tmp145_ = NULL;
		gchar* _tmp146_ = NULL;
		gchar* _tmp147_ = NULL;
		gchar* _tmp148_ = NULL;
		_tmp139_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp140_ = _tmp139_;
		_tmp141_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp142_ = _tmp141_;
		_tmp143_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp144_ = _tmp143_;
		_tmp145_ = vala_symbol_get_full_name (_tmp144_);
		_tmp146_ = _tmp145_;
		_tmp147_ = g_strdup_printf ("%s hides inherited property `%s'. Use the `new' keyword if hiding was " \
"intentional", _tmp142_, _tmp146_);
		_tmp148_ = _tmp147_;
		vala_report_warning (_tmp140_, _tmp148_);
		_g_free0 (_tmp148_);
		_g_free0 (_tmp146_);
		_vala_code_node_unref0 (_tmp144_);
		_g_free0 (_tmp142_);
	}
	_tmp150_ = vala_property_get_set_accessor (self);
	_tmp151_ = _tmp150_;
	if (_tmp151_ != NULL) {
		ValaPropertyAccessor* _tmp152_ = NULL;
		ValaPropertyAccessor* _tmp153_ = NULL;
		gboolean _tmp154_ = FALSE;
		gboolean _tmp155_ = FALSE;
		_tmp152_ = vala_property_get_set_accessor (self);
		_tmp153_ = _tmp152_;
		_tmp154_ = vala_property_accessor_get_construction (_tmp153_);
		_tmp155_ = _tmp154_;
		_tmp149_ = _tmp155_;
	} else {
		_tmp149_ = FALSE;
	}
	_tmp156_ = _tmp149_;
	if (_tmp156_) {
		ValaSymbolAccessibility _tmp157_ = 0;
		ValaSymbolAccessibility _tmp158_ = 0;
		_tmp157_ = vala_symbol_get_access ((ValaSymbol*) self);
		_tmp158_ = _tmp157_;
		if (_tmp158_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
			ValaSourceReference* _tmp159_ = NULL;
			ValaSourceReference* _tmp160_ = NULL;
			gchar* _tmp161_ = NULL;
			gchar* _tmp162_ = NULL;
			gchar* _tmp163_ = NULL;
			gchar* _tmp164_ = NULL;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp159_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp160_ = _tmp159_;
			_tmp161_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp162_ = _tmp161_;
			_tmp163_ = g_strdup_printf ("%s: construct properties must be public", _tmp162_);
			_tmp164_ = _tmp163_;
			vala_report_error (_tmp160_, _tmp164_);
			_g_free0 (_tmp164_);
			_g_free0 (_tmp162_);
		}
	}
	_tmp168_ = vala_property_get_initializer (self);
	_tmp169_ = _tmp168_;
	if (_tmp169_ != NULL) {
		ValaExpression* _tmp170_ = NULL;
		ValaExpression* _tmp171_ = NULL;
		gboolean _tmp172_ = FALSE;
		gboolean _tmp173_ = FALSE;
		_tmp170_ = vala_property_get_initializer (self);
		_tmp171_ = _tmp170_;
		_tmp172_ = vala_code_node_get_error ((ValaCodeNode*) _tmp171_);
		_tmp173_ = _tmp172_;
		_tmp167_ = !_tmp173_;
	} else {
		_tmp167_ = FALSE;
	}
	_tmp174_ = _tmp167_;
	if (_tmp174_) {
		ValaExpression* _tmp175_ = NULL;
		ValaExpression* _tmp176_ = NULL;
		ValaDataType* _tmp177_ = NULL;
		ValaDataType* _tmp178_ = NULL;
		_tmp175_ = vala_property_get_initializer (self);
		_tmp176_ = _tmp175_;
		_tmp177_ = vala_expression_get_value_type (_tmp176_);
		_tmp178_ = _tmp177_;
		_tmp166_ = _tmp178_ != NULL;
	} else {
		_tmp166_ = FALSE;
	}
	_tmp179_ = _tmp166_;
	if (_tmp179_) {
		ValaExpression* _tmp180_ = NULL;
		ValaExpression* _tmp181_ = NULL;
		ValaDataType* _tmp182_ = NULL;
		ValaDataType* _tmp183_ = NULL;
		ValaDataType* _tmp184_ = NULL;
		ValaDataType* _tmp185_ = NULL;
		gboolean _tmp186_ = FALSE;
		_tmp180_ = vala_property_get_initializer (self);
		_tmp181_ = _tmp180_;
		_tmp182_ = vala_expression_get_value_type (_tmp181_);
		_tmp183_ = _tmp182_;
		_tmp184_ = vala_property_get_property_type (self);
		_tmp185_ = _tmp184_;
		_tmp186_ = vala_data_type_compatible (_tmp183_, _tmp185_);
		_tmp165_ = !_tmp186_;
	} else {
		_tmp165_ = FALSE;
	}
	_tmp187_ = _tmp165_;
	if (_tmp187_) {
		ValaExpression* _tmp188_ = NULL;
		ValaExpression* _tmp189_ = NULL;
		ValaSourceReference* _tmp190_ = NULL;
		ValaSourceReference* _tmp191_ = NULL;
		ValaDataType* _tmp192_ = NULL;
		ValaDataType* _tmp193_ = NULL;
		gchar* _tmp194_ = NULL;
		gchar* _tmp195_ = NULL;
		ValaExpression* _tmp196_ = NULL;
		ValaExpression* _tmp197_ = NULL;
		ValaDataType* _tmp198_ = NULL;
		ValaDataType* _tmp199_ = NULL;
		gchar* _tmp200_ = NULL;
		gchar* _tmp201_ = NULL;
		gchar* _tmp202_ = NULL;
		gchar* _tmp203_ = NULL;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp188_ = vala_property_get_initializer (self);
		_tmp189_ = _tmp188_;
		_tmp190_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp189_);
		_tmp191_ = _tmp190_;
		_tmp192_ = vala_property_get_property_type (self);
		_tmp193_ = _tmp192_;
		_tmp194_ = vala_code_node_to_string ((ValaCodeNode*) _tmp193_);
		_tmp195_ = _tmp194_;
		_tmp196_ = vala_property_get_initializer (self);
		_tmp197_ = _tmp196_;
		_tmp198_ = vala_expression_get_value_type (_tmp197_);
		_tmp199_ = _tmp198_;
		_tmp200_ = vala_code_node_to_string ((ValaCodeNode*) _tmp199_);
		_tmp201_ = _tmp200_;
		_tmp202_ = g_strdup_printf ("Expected initializer of type `%s' but got `%s'", _tmp195_, _tmp201_);
		_tmp203_ = _tmp202_;
		vala_report_error (_tmp191_, _tmp203_);
		_g_free0 (_tmp203_);
		_g_free0 (_tmp201_);
		_g_free0 (_tmp195_);
	}
	_tmp204_ = context;
	_tmp205_ = vala_code_context_get_analyzer (_tmp204_);
	_tmp206_ = _tmp205_;
	_tmp207_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp206_, _tmp207_);
	_tmp208_ = context;
	_tmp209_ = vala_code_context_get_analyzer (_tmp208_);
	_tmp210_ = _tmp209_;
	_tmp211_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp210_, _tmp211_);
	_tmp212_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp213_ = _tmp212_;
	result = !_tmp213_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}


ValaDataType* vala_property_get_property_type (ValaProperty* self) {
	ValaDataType* result;
	ValaDataType* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data_type;
	result = _tmp0_;
	return result;
}


void vala_property_set_property_type (ValaProperty* self, ValaDataType* value) {
	ValaDataType* _tmp0_ = NULL;
	ValaDataType* _tmp1_ = NULL;
	ValaDataType* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_data_type);
	self->priv->_data_type = _tmp1_;
	_tmp2_ = value;
	if (_tmp2_ != NULL) {
		ValaDataType* _tmp3_ = NULL;
		_tmp3_ = self->priv->_data_type;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp3_, (ValaCodeNode*) self);
	}
}


ValaPropertyAccessor* vala_property_get_get_accessor (ValaProperty* self) {
	ValaPropertyAccessor* result;
	ValaPropertyAccessor* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_get_accessor;
	result = _tmp0_;
	return result;
}


void vala_property_set_get_accessor (ValaProperty* self, ValaPropertyAccessor* value) {
	ValaPropertyAccessor* _tmp0_ = NULL;
	ValaPropertyAccessor* _tmp1_ = NULL;
	ValaPropertyAccessor* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_get_accessor);
	self->priv->_get_accessor = _tmp1_;
	_tmp2_ = value;
	if (_tmp2_ != NULL) {
		ValaPropertyAccessor* _tmp3_ = NULL;
		ValaScope* _tmp4_ = NULL;
		ValaScope* _tmp5_ = NULL;
		_tmp3_ = value;
		_tmp4_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp5_ = _tmp4_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp3_, _tmp5_);
	}
}


ValaPropertyAccessor* vala_property_get_set_accessor (ValaProperty* self) {
	ValaPropertyAccessor* result;
	ValaPropertyAccessor* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_set_accessor;
	result = _tmp0_;
	return result;
}


void vala_property_set_set_accessor (ValaProperty* self, ValaPropertyAccessor* value) {
	ValaPropertyAccessor* _tmp0_ = NULL;
	ValaPropertyAccessor* _tmp1_ = NULL;
	ValaPropertyAccessor* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_set_accessor);
	self->priv->_set_accessor = _tmp1_;
	_tmp2_ = value;
	if (_tmp2_ != NULL) {
		ValaPropertyAccessor* _tmp3_ = NULL;
		ValaScope* _tmp4_ = NULL;
		ValaScope* _tmp5_ = NULL;
		_tmp3_ = value;
		_tmp4_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp5_ = _tmp4_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp3_, _tmp5_);
	}
}


ValaParameter* vala_property_get_this_parameter (ValaProperty* self) {
	ValaParameter* result;
	ValaParameter* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_this_parameter;
	result = _tmp0_;
	return result;
}


void vala_property_set_this_parameter (ValaProperty* self, ValaParameter* value) {
	ValaParameter* _tmp0_ = NULL;
	ValaParameter* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_this_parameter);
	self->priv->_this_parameter = _tmp1_;
}


gboolean vala_property_get_interface_only (ValaProperty* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_interface_only;
	result = _tmp0_;
	return result;
}


void vala_property_set_interface_only (ValaProperty* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_interface_only = _tmp0_;
}


gboolean vala_property_get_is_abstract (ValaProperty* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_abstract;
	result = _tmp0_;
	return result;
}


void vala_property_set_is_abstract (ValaProperty* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_is_abstract = _tmp0_;
}


gboolean vala_property_get_is_virtual (ValaProperty* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_virtual;
	result = _tmp0_;
	return result;
}


void vala_property_set_is_virtual (ValaProperty* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_is_virtual = _tmp0_;
}


gboolean vala_property_get_overrides (ValaProperty* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_overrides;
	result = _tmp0_;
	return result;
}


void vala_property_set_overrides (ValaProperty* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_overrides = _tmp0_;
}


ValaField* vala_property_get_field (ValaProperty* self) {
	ValaField* result;
	ValaField* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_field;
	result = _tmp0_;
	return result;
}


void vala_property_set_field (ValaProperty* self, ValaField* value) {
	ValaField* _tmp0_ = NULL;
	ValaField* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_field);
	self->priv->_field = _tmp1_;
}


ValaMemberBinding vala_property_get_binding (ValaProperty* self) {
	ValaMemberBinding result;
	ValaMemberBinding _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_binding;
	result = _tmp0_;
	return result;
}


void vala_property_set_binding (ValaProperty* self, ValaMemberBinding value) {
	ValaMemberBinding _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_binding = _tmp0_;
}


ValaProperty* vala_property_get_base_property (ValaProperty* self) {
	ValaProperty* result;
	ValaProperty* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_property_find_base_properties (self);
	_tmp0_ = self->priv->_base_property;
	result = _tmp0_;
	return result;
}


ValaProperty* vala_property_get_base_interface_property (ValaProperty* self) {
	ValaProperty* result;
	ValaProperty* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_property_find_base_properties (self);
	_tmp0_ = self->priv->_base_interface_property;
	result = _tmp0_;
	return result;
}


ValaExpression* vala_property_get_initializer (ValaProperty* self) {
	ValaExpression* result;
	ValaExpression* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_initializer;
	result = _tmp0_;
	return result;
}


void vala_property_set_initializer (ValaProperty* self, ValaExpression* value) {
	ValaExpression* _tmp0_ = NULL;
	ValaExpression* _tmp1_ = NULL;
	ValaExpression* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_initializer);
	self->priv->_initializer = _tmp1_;
	_tmp2_ = self->priv->_initializer;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
}


static void vala_property_class_init (ValaPropertyClass * klass) {
	vala_property_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_property_finalize;
	g_type_class_add_private (klass, sizeof (ValaPropertyPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_property_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_property_real_accept_children;
	VALA_CODE_NODE_CLASS (klass)->replace_type = vala_property_real_replace_type;
	VALA_CODE_NODE_CLASS (klass)->replace_expression = vala_property_real_replace_expression;
	VALA_CODE_NODE_CLASS (klass)->check = vala_property_real_check;
}


static void vala_property_vala_lockable_interface_init (ValaLockableIface * iface) {
	vala_property_vala_lockable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_lock_used = (gboolean (*)(ValaLockable*)) vala_property_real_get_lock_used;
	iface->set_lock_used = (void (*)(ValaLockable*, gboolean)) vala_property_real_set_lock_used;
}


static void vala_property_instance_init (ValaProperty * self) {
	self->priv = VALA_PROPERTY_GET_PRIVATE (self);
	self->priv->_binding = VALA_MEMBER_BINDING_INSTANCE;
	self->priv->lock_used = FALSE;
}


static void vala_property_finalize (ValaCodeNode* obj) {
	ValaProperty * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_PROPERTY, ValaProperty);
	_vala_code_node_unref0 (self->priv->_this_parameter);
	_vala_code_node_unref0 (self->priv->_field);
	_vala_code_node_unref0 (self->priv->_initializer);
	_vala_code_node_unref0 (self->priv->_data_type);
	_vala_code_node_unref0 (self->priv->_base_interface_property);
	_vala_code_node_unref0 (self->priv->_get_accessor);
	_vala_code_node_unref0 (self->priv->_set_accessor);
	VALA_CODE_NODE_CLASS (vala_property_parent_class)->finalize (obj);
}


/**
 * Represents a property declaration in the source code.
 */
GType vala_property_get_type (void) {
	static volatile gsize vala_property_type_id__volatile = 0;
	if (g_once_init_enter (&vala_property_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaPropertyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_property_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaProperty), 0, (GInstanceInitFunc) vala_property_instance_init, NULL };
		static const GInterfaceInfo vala_lockable_info = { (GInterfaceInitFunc) vala_property_vala_lockable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_property_type_id;
		vala_property_type_id = g_type_register_static (VALA_TYPE_SYMBOL, "ValaProperty", &g_define_type_info, 0);
		g_type_add_interface_static (vala_property_type_id, VALA_TYPE_LOCKABLE, &vala_lockable_info);
		g_once_init_leave (&vala_property_type_id__volatile, vala_property_type_id);
	}
	return vala_property_type_id__volatile;
}



