/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.Controller;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.trans.XPathException;

public class ImplicitResultChecker
extends ProxyReceiver {
    private boolean clean = true;
    private boolean open = false;
    private Controller controller;

    public ImplicitResultChecker(Receiver next, Controller controller) {
        this.setUnderlyingReceiver(next);
        this.controller = controller;
    }

    public void open() throws XPathException {
        super.open();
        this.open = true;
    }

    public void startDocument(int properties) throws XPathException {
        if (!this.open) {
            this.open();
        }
        this.nextReceiver.startDocument(properties);
    }

    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        if (this.clean) {
            this.firstContent();
        }
        this.nextReceiver.startElement(nameCode, typeCode, locationId, properties);
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        if (this.clean) {
            this.firstContent();
        }
        this.nextReceiver.characters(chars, locationId, properties);
    }

    public void processingInstruction(String target, CharSequence data, int locationId, int properties) throws XPathException {
        if (this.clean) {
            this.firstContent();
        }
        this.nextReceiver.processingInstruction(target, data, locationId, properties);
    }

    public void comment(CharSequence chars, int locationId, int properties) throws XPathException {
        if (this.clean) {
            this.firstContent();
        }
        this.nextReceiver.comment(chars, locationId, properties);
    }

    private void firstContent() throws XPathException {
        this.controller.checkImplicitResultTree();
        if (!this.open) {
            this.open();
            this.startDocument(0);
        }
        this.clean = false;
    }

    public void close() throws XPathException {
        if (!this.clean || !this.controller.hasThereBeenAnExplicitResultDocument()) {
            if (!this.open) {
                this.open();
            }
            this.nextReceiver.close();
        }
    }
}

