/*
 * Copyright (C) 2010 The Android Open Source Project
 * Copyright (c) 2011-2012, The Linux Foundation. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef ANDROID_TILE_RENDERER_H
#define ANDROID_TILE_RENDERER_H

#include <utils/Singleton.h>

namespace android {
namespace uirenderer {

class OpenGLRenderer;

class TileRenderer: public Singleton<TileRenderer> {
    public:
    TileRenderer();
    ~TileRenderer();

    void startTileRendering(OpenGLRenderer* renderer, int left, int top, int right, int bottom);
    void endTileRendering(OpenGLRenderer*);

    private:
    bool mIsTiled;
};

}; // namespace uirenderer
}; // namespace android

#endif
