#!/bin/sh
#               addseqs.sh <file of blocks>
#
blocks=""
if [ $# -gt 0 -a -f "$1" ]
then
      blocks=`cat $1`
fi
#  From the <HTML> to </HTML> is ~blocks/www/addseqs.html
#       with the blocks TEXTAREA modified to insert $blocks

cat << EOM
Content-type: text/html


<HTML>
<TITLE>Add Sequences to Blocks</TITLE>
<H1><IMG ALIGN=MIDDLE SRC="/blocks/icons/blocks.xbm">Add Sequences to Blocks</H1>

<FORM METHOD="POST" ACTION="/blocks-bin/addseqs.pl">

<P>

<A HREF="help/about_addseqs.html">Add sequences to blocks</A>
aligns a set of Blocks with one or more protein sequences, saving
the best score only for each alignment. It adds each protein
sequence to the blocks if the best alignments are in the correct
order and non-overlapping, re-weights and re-calibrates each block.
<BR>
You can make blocks from unaligned protein sequences with
<A HREF="blocks/make_blocks.html">Block Maker</A>.<BR>
If you need to convert another multiple alignment to
<A HREF="help/blocks_format.html">BLOCKS format</A>, use the
<A HREF="process_blocks.html">Multiple Alignment Processor</A> or the
<A HREF="block_formatter.html">Block Formatter</A>.<BR>
<P>

Enter your Blocks in 
<A HREF="help/blocks_format.html">BLOCKS format</A>:<BR>
<TEXTAREA NAME="blocks" ROWS=10 COLS=70>$blocks</TEXTAREA>
<P>
Enter your protein sequences in 
<A HREF="http://www.ncbi.nlm.nih.gov/BLAST/fasta.html">FASTA format</A>:<BR>
<TEXTAREA NAME="sequence" ROWS=10 COLS=70></TEXTAREA>

<HR>
<INPUT TYPE=submit VALUE="Add sequences">
<INPUT TYPE=reset>
<BR>

<HR>
<A HREF="/blocks">Blocks home</A>
<HR>
<A HREF="/blocks/contact.html">Contact us</A><P>
Page last modified on <MODIFICATION_DATE>August 2003</MODIFICATION_DATE>
</HTML>


EOM

exit
