/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree;

public class SystemIdMap {
    private int[] sequenceNumbers = new int[4];
    private String[] uris = new String[4];
    private int allocated = 0;

    public void setSystemId(int sequence, String uri) {
        if (this.allocated > 0 && uri.equals(this.uris[this.allocated - 1])) {
            return;
        }
        if (this.sequenceNumbers.length <= this.allocated + 1) {
            int[] s = new int[this.allocated * 2];
            String[] u = new String[this.allocated * 2];
            System.arraycopy(this.sequenceNumbers, 0, s, 0, this.allocated);
            System.arraycopy(this.uris, 0, u, 0, this.allocated);
            this.sequenceNumbers = s;
            this.uris = u;
        }
        this.sequenceNumbers[this.allocated] = sequence;
        this.uris[this.allocated] = uri;
        ++this.allocated;
    }

    public String getSystemId(int sequence) {
        if (this.allocated == 0) {
            return null;
        }
        for (int i = 1; i < this.allocated; ++i) {
            if (this.sequenceNumbers[i] <= sequence) continue;
            return this.uris[i - 1];
        }
        return this.uris[this.allocated - 1];
    }
}

