/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.viewer;

import edu.harvard.hul.ois.jhove.ConfigHandler;
import edu.harvard.hul.ois.jhove.viewer.ConfigWriter;
import edu.harvard.hul.ois.jhove.viewer.MainScreen;
import edu.harvard.hul.ois.jhove.viewer.NumericField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;

public class ConfigWindow
extends JDialog {
    private static final String tempDirDefault = "<Default>";
    private File _configFile;
    private List _modules;
    private List _handlers;
    private int _bufferSize;
    private File _homeDir;
    private File _tempDir;
    private String _encoding;
    private Box _mainBox;
    private JTable _modTable;
    private JTable _hanTable;
    private AbstractTableModel _modTableModel;
    private AbstractTableModel _hanTableModel;
    private JLabel _homeLabel;
    private JLabel _tempDirLabel;
    private NumericField _bufSizeBox;
    private JTextField _encodingBox;
    static final Color _tableColor = new Color(235, 230, 210);
    static final Font _pathFont = new Font("SansSerif", 0, 10);
    static final Font _infoFont = new Font("SansSerif", 0, 12);

    public ConfigWindow(JFrame jFrame, File file, ConfigHandler configHandler) {
        super(jFrame, "Jhove Configuration", true);
        Object object;
        this.setDefaultCloseOperation(2);
        this._configFile = file;
        if (configHandler != null) {
            this._modules = configHandler.getModule();
            this._handlers = configHandler.getHandler();
            this._bufferSize = configHandler.getBufferSize();
            object = configHandler.getJhoveHome();
            if (object != null) {
                this._homeDir = new File((String)object);
            }
            if ((object = configHandler.getTempDir()) != null) {
                this._tempDir = new File((String)object);
            }
            this._encoding = configHandler.getEncoding();
        } else {
            this._modules = new ArrayList(10);
            this._handlers = new ArrayList(5);
            this._bufferSize = -1;
            this._homeDir = null;
            this._tempDir = null;
            this._encoding = null;
        }
        this._mainBox = Box.createVerticalBox();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this._mainBox, "Center");
        this._mainBox.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        object = MainScreen.mainBounds();
        int n = ((Rectangle)object).height - 200;
        if (n > 640) {
            n = 640;
        }
        this._mainBox.setMaximumSize(new Dimension(500, n));
        this._mainBox.setPreferredSize(new Dimension(400, n));
        this.addModuleTable();
        this._mainBox.add(Box.createRigidArea(new Dimension(0, 6)));
        this.addHandlerTable();
        this.addHomeDir();
        this.addTempDir();
        this.addEncoding();
        this.addBufferSize();
        this.addSaveCancel();
        this.pack();
    }

    private void addModuleTable() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this._mainBox.add(jPanel);
        this._modTableModel = new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return ConfigWindow.this._modules.size();
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return true;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                String[] stringArray = (String[])ConfigWindow.this._modules.get(n);
                return stringArray[n2];
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                String[] stringArray = (String[])ConfigWindow.this._modules.get(n);
                stringArray[n2] = (String)object;
            }
        };
        this._modTable = new JTable(this._modTableModel);
        this._modTable.setSelectionMode(0);
        this._modTable.setCellSelectionEnabled(true);
        this._modTable.setBackground(_tableColor);
        JScrollPane jScrollPane = new JScrollPane(this._modTable);
        TableColumnModel tableColumnModel = this._modTable.getColumnModel();
        tableColumnModel.getColumn(0).setHeaderValue("Class");
        tableColumnModel.getColumn(1).setHeaderValue("Init");
        this._modTable.doLayout();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)new JLabel("Modules:"), "West");
        JPanel jPanel3 = new JPanel();
        jPanel2.add((Component)jPanel3, "East");
        JButton jButton = new JButton("Add");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigWindow.this.addModule();
            }
        });
        jPanel3.add(jButton);
        JButton jButton2 = new JButton("Delete");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigWindow.this.deleteModule();
            }
        });
        jButton.setMinimumSize(jButton2.getMinimumSize());
        jButton.setPreferredSize(jButton2.getPreferredSize());
        jPanel3.add(jButton2);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jScrollPane, "Center");
    }

    private void addHandlerTable() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this._mainBox.add(jPanel);
        this._hanTableModel = new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return ConfigWindow.this._handlers.size();
            }

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return true;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                return ConfigWindow.this._handlers.get(n);
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                ConfigWindow.this._handlers.set(n, object);
            }
        };
        this._hanTable = new JTable(this._hanTableModel);
        this._hanTable.setSelectionMode(0);
        this._hanTable.setCellSelectionEnabled(true);
        this._hanTable.setBackground(_tableColor);
        JScrollPane jScrollPane = new JScrollPane(this._hanTable);
        TableColumnModel tableColumnModel = this._hanTable.getColumnModel();
        tableColumnModel.getColumn(0).setHeaderValue("Class");
        this._hanTable.doLayout();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)new JLabel("Handlers:"), "West");
        JPanel jPanel3 = new JPanel();
        jPanel2.add((Component)jPanel3, "East");
        JButton jButton = new JButton("Add");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigWindow.this.addHandler();
            }
        });
        jPanel3.add(jButton);
        JButton jButton2 = new JButton("Delete");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigWindow.this.deleteHandler();
            }
        });
        jButton.setMinimumSize(jButton2.getMinimumSize());
        jButton.setPreferredSize(jButton2.getPreferredSize());
        jPanel3.add(jButton2);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jScrollPane, "Center");
    }

    private void addEncoding() {
        JPanel jPanel = new JPanel();
        this._mainBox.add(jPanel);
        jPanel.add(new JLabel("Default encoding: "));
        this._encodingBox = new JTextField(this._encoding == null ? "" : this._encoding, 14);
        jPanel.add(this._encodingBox);
    }

    private void addBufferSize() {
        JPanel jPanel = new JPanel();
        this._mainBox.add(jPanel);
        jPanel.add(new JLabel("Buffer size (-1 for default): "));
        this._bufSizeBox = new NumericField(this._bufferSize);
        jPanel.add(this._bufSizeBox);
    }

    private void addHomeDir() {
        JPanel jPanel = new JPanel();
        this._mainBox.add(jPanel);
        jPanel.setLayout(new GridLayout(1, 2));
        JButton jButton = new JButton("Home directory...");
        String string = "<none specified>";
        if (this._homeDir != null) {
            string = this._homeDir.getPath();
        }
        this._homeLabel = new JLabel(string);
        this._homeLabel.setFont(_pathFont);
        JPanel jPanel2 = new JPanel();
        jPanel.add(jPanel2);
        jPanel2.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigWindow.this.chooseHomeDir();
            }
        });
        jPanel.add(this._homeLabel);
    }

    private void addTempDir() {
        JPanel jPanel = new JPanel();
        this._mainBox.add(jPanel);
        jPanel.setLayout(new GridLayout(1, 2));
        JButton jButton = new JButton("Temp directory...");
        String string = tempDirDefault;
        if (this._tempDir != null) {
            string = this._tempDir.getPath();
        }
        this._tempDirLabel = new JLabel(string);
        this._tempDirLabel.setFont(_pathFont);
        JPanel jPanel2 = new JPanel();
        jPanel.add(jPanel2);
        jPanel2.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigWindow.this.chooseTempDir();
            }
        });
        jPanel.add(this._tempDirLabel);
    }

    private void addSaveCancel() {
        final ConfigWindow configWindow = this;
        JPanel jPanel = new JPanel();
        this.getContentPane().add((Component)jPanel, "South");
        jPanel.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel("Changes take effect on relaunch");
        jLabel.setFont(_infoFont);
        jPanel.add((Component)jLabel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel.add((Component)jPanel2, "Center");
        jPanel2.setLayout(new GridLayout(1, 3));
        JPanel jPanel3 = new JPanel();
        jPanel2.add(jPanel3);
        jPanel3 = new JPanel();
        JButton jButton = new JButton("OK");
        this.getRootPane().setDefaultButton(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigWindow.this.doSave();
            }
        });
        jPanel3.add(jButton);
        jPanel2.add(jPanel3);
        jPanel3 = new JPanel();
        JButton jButton2 = new JButton("Cancel");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                configWindow.dispose();
            }
        });
        jButton.setMinimumSize(jButton2.getMinimumSize());
        jButton.setPreferredSize(jButton2.getPreferredSize());
        jPanel3.add(jButton2);
        jPanel2.add(jPanel3);
    }

    private void doSave() {
        try {
            try {
                this._bufSizeBox.commitEdit();
            }
            catch (ParseException parseException) {
                return;
            }
            Object object = this._bufSizeBox.getValue();
            this._bufferSize = ((Long)this._bufSizeBox.getValue()).intValue();
            this._encoding = this._encodingBox.getText();
            ConfigWriter configWriter = new ConfigWriter(this._configFile, this);
            configWriter.writeFile(this._modules, this._handlers, this._homeDir, this._tempDir, this._encoding, this._bufferSize);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, iOException.getMessage(), "Can't create config", 0);
        }
        this.dispose();
    }

    private void chooseHomeDir() {
        JFileChooser jFileChooser = new JFileChooser();
        if (this._homeDir != null) {
            jFileChooser.setCurrentDirectory(this._homeDir);
        }
        jFileChooser.setDialogTitle("Select Home Directory");
        jFileChooser.setFileSelectionMode(1);
        if (jFileChooser.showOpenDialog(this) == 0) {
            this._homeDir = jFileChooser.getSelectedFile();
            this._homeLabel.setText(this._homeDir.getPath());
        }
    }

    private void chooseTempDir() {
        final JFileChooser jFileChooser = new JFileChooser();
        if (this._homeDir != null) {
            jFileChooser.setCurrentDirectory(this._tempDir);
        }
        jFileChooser.setDialogTitle("Select Temporary Directory");
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(160, 40));
        JButton jButton = new JButton("System Default");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigWindow.this._tempDir = null;
                ConfigWindow.this._tempDirLabel.setText(ConfigWindow.tempDirDefault);
                jFileChooser.cancelSelection();
            }
        });
        jPanel.add(jButton);
        jFileChooser.setAccessory(jPanel);
        jFileChooser.setFileSelectionMode(1);
        if (jFileChooser.showOpenDialog(this) == 0) {
            this._tempDir = jFileChooser.getSelectedFile();
            this._tempDirLabel.setText(this._tempDir.getPath());
        }
    }

    private void addModule() {
        ListSelectionModel listSelectionModel = this._modTable.getSelectionModel();
        int n = listSelectionModel.getMinSelectionIndex();
        if (n < 0) {
            n = this._modules.size();
        }
        String[] stringArray = new String[]{"", null};
        this._modules.add(n, stringArray);
        this._modTableModel.fireTableRowsInserted(n, n);
    }

    private void deleteModule() {
        ListSelectionModel listSelectionModel = this._modTable.getSelectionModel();
        int n = listSelectionModel.getMinSelectionIndex();
        if (n < 0) {
            return;
        }
        this._modules.remove(n);
        this._modTableModel.fireTableRowsDeleted(n, n);
    }

    private void addHandler() {
        ListSelectionModel listSelectionModel = this._hanTable.getSelectionModel();
        int n = listSelectionModel.getMinSelectionIndex();
        if (n < 0) {
            n = this._handlers.size();
        }
        this._handlers.add(n, "");
        this._hanTableModel.fireTableRowsInserted(n, n);
    }

    private void deleteHandler() {
        ListSelectionModel listSelectionModel = this._hanTable.getSelectionModel();
        int n = listSelectionModel.getMinSelectionIndex();
        if (n < 0) {
            return;
        }
        this._handlers.remove(n);
        this._hanTableModel.fireTableRowsDeleted(n, n);
    }

    private void saveConfig(File file) {
        if (file != null) {
            this._configFile = file;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, iOException.getMessage(), "Error saving config", 0);
        }
    }

    private File doConfigFileDialog() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(1);
        if (jFileChooser.showOpenDialog(this) == 0) {
            return jFileChooser.getSelectedFile();
        }
        return null;
    }
}

