/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.envvar;

import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.internal.core.envvar.ICoreEnvironmentVariableSupplier;
import org.eclipse.cdt.internal.core.settings.model.CConfigurationSpecSettings;
import org.eclipse.cdt.internal.core.settings.model.IInternalCCfgInfo;
import org.eclipse.cdt.utils.envvar.EnvVarOperationProcessor;
import org.eclipse.cdt.utils.envvar.IEnvironmentChangeListener;
import org.eclipse.cdt.utils.envvar.PrefsStorableEnvironment;
import org.eclipse.cdt.utils.envvar.StorableEnvironment;
import org.eclipse.cdt.utils.envvar.StorableEnvironmentLoader;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class UserDefinedEnvironmentSupplier
extends StorableEnvironmentLoader
implements ICoreEnvironmentVariableSupplier {
    public static final String NODENAME = "environment";
    public static final String PREFNAME_WORKSPACE = "workspace";
    public static final String PREFNAME_PROJECT = "project";
    public static final String NODENAME_CFG = "project";
    private PrefsStorableEnvironment fWorkspaceVariables;
    private StorableEnvironment fOverrideVariables = new StorableEnvironment(false);

    public StorableEnvironment getEnvironment(Object context) {
        return this.getEnvironment(context, false);
    }

    protected StorableEnvironment getEnvironment(Object context, boolean forceLoad) {
        StorableEnvironment env = null;
        if (context instanceof IInternalCCfgInfo) {
            try {
                CConfigurationSpecSettings settings = ((IInternalCCfgInfo)context).getSpecSettings();
                env = settings.getEnvironment();
                if (env == null || forceLoad) {
                    env = this.loadEnvironment(context, settings.isReadOnly());
                    settings.setEnvironment(env);
                }
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        } else if (context instanceof IWorkspace || context == null) {
            if (this.fWorkspaceVariables == null || forceLoad) {
                this.fWorkspaceVariables = (PrefsStorableEnvironment)this.loadEnvironment(context, false);
            }
            env = this.fWorkspaceVariables;
        }
        return env;
    }

    @Override
    protected StorableEnvironmentLoader.ISerializeInfo getSerializeInfo(Object context) {
        Preferences prefs;
        StorableEnvironmentLoader.ISerializeInfo serializeInfo = null;
        if (context instanceof ICConfigurationDescription) {
            final ICConfigurationDescription cfg = (ICConfigurationDescription)context;
            final String name = cfg.getId();
            if (name != null) {
                serializeInfo = new StorableEnvironmentLoader.ISerializeInfo(){

                    @Override
                    public Preferences getNode() {
                        return UserDefinedEnvironmentSupplier.this.getConfigurationNode(cfg.getProjectDescription());
                    }

                    @Override
                    public String getPrefName() {
                        return name;
                    }
                };
            }
        } else if ((context == null || context instanceof IWorkspace) && (prefs = this.getWorkspaceNode()) != null) {
            serializeInfo = new StorableEnvironmentLoader.ISerializeInfo(){

                @Override
                public Preferences getNode() {
                    return prefs;
                }

                @Override
                public String getPrefName() {
                    return UserDefinedEnvironmentSupplier.PREFNAME_WORKSPACE;
                }
            };
        }
        return serializeInfo;
    }

    private Preferences getConfigurationNode(ICProjectDescription projDes) {
        Preferences prefNode = this.getProjectNode(projDes);
        if (prefNode == null) {
            return null;
        }
        return prefNode.node("project");
    }

    private Preferences getProjectNode(ICProjectDescription projDes) {
        if (projDes == null) {
            return null;
        }
        IProject project = projDes.getProject();
        if (!project.exists()) {
            return null;
        }
        IEclipsePreferences prefNode = new ProjectScope(project).getNode("org.eclipse.cdt.core");
        if (prefNode == null) {
            return null;
        }
        return prefNode.node(NODENAME);
    }

    private Preferences getWorkspaceNode() {
        IEclipsePreferences prefNode = InstanceScope.INSTANCE.getNode("org.eclipse.cdt.core");
        if (prefNode == null) {
            return null;
        }
        return prefNode.node(NODENAME);
    }

    public void checkInexistentConfigurations(ICProjectDescription projDes) {
        Preferences prefNode = this.getConfigurationNode(projDes);
        if (prefNode == null) {
            return;
        }
        try {
            String[] ids = prefNode.keys();
            boolean found = false;
            String[] stringArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                if (projDes.getConfigurationById(id) == null) {
                    prefNode.remove(id);
                    found = true;
                }
                ++n2;
            }
            if (found) {
                prefNode.flush();
            }
        }
        catch (BackingStoreException backingStoreException) {}
    }

    public void storeWorkspaceEnvironment(boolean force) {
        if (this.fWorkspaceVariables != null) {
            try {
                this.storeEnvironment(this.fWorkspaceVariables, ResourcesPlugin.getWorkspace(), force, true);
            }
            catch (CoreException coreException) {}
        }
    }

    public StorableEnvironment getWorkspaceEnvironmentCopy() {
        StorableEnvironment envVar = this.getEnvironment(null);
        return new StorableEnvironment(envVar, false);
    }

    public boolean setWorkspaceEnvironment(StorableEnvironment env) {
        Object[] oldVariables = this.fWorkspaceVariables.getVariables();
        Object[] newVariables = env.getVariables();
        this.fWorkspaceVariables.deleteAll();
        this.fWorkspaceVariables.setVariales((IEnvironmentVariable[])newVariables);
        this.fWorkspaceVariables.setAppendEnvironment(env.appendEnvironment());
        this.fWorkspaceVariables.setAppendContributedEnvironment(env.appendContributedEnvironment());
        this.storeWorkspaceEnvironment(true);
        return !Arrays.equals(oldVariables, newVariables);
    }

    public void storeProjectEnvironment(ICProjectDescription des, boolean force) {
        ICConfigurationDescription[] cfgs;
        ICConfigurationDescription[] iCConfigurationDescriptionArray = cfgs = des.getConfigurations();
        int n = cfgs.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription cfg = iCConfigurationDescriptionArray[n2];
            this.storeEnvironment(cfg, force, false);
            ++n2;
        }
        Preferences node = this.getProjectNode(des);
        try {
            node.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    private void storeEnvironment(Object context, boolean force, boolean flush) {
        StorableEnvironment env = this.getEnvironment(context, false);
        if (env != null) {
            try {
                this.storeEnvironment(env, context, force, flush);
            }
            catch (CoreException coreException) {}
        }
    }

    @Override
    public IEnvironmentVariable getVariable(String name, Object context) {
        if (this.getValidName(name) == null) {
            return null;
        }
        IEnvironmentVariable var = this.fOverrideVariables.getVariable(name);
        StorableEnvironment env = this.getEnvironment(context);
        if (env == null) {
            return var;
        }
        return EnvVarOperationProcessor.performOperation(env.getVariable(name), var);
    }

    @Override
    public IEnvironmentVariable[] getVariables(Object context) {
        StorableEnvironment env = this.getEnvironment(context);
        if (env == null) {
            return null;
        }
        IEnvironmentVariable[] override = this.filterVariables(this.fOverrideVariables.getVariables());
        IEnvironmentVariable[] normal = this.filterVariables(env.getVariables());
        return this.combineVariables(normal, override);
    }

    private IEnvironmentVariable[] combineVariables(IEnvironmentVariable[] oldVariables, IEnvironmentVariable[] newVariables) {
        IEnvironmentVariable variable;
        HashMap<String, IEnvironmentVariable> vars = new HashMap<String, IEnvironmentVariable>(oldVariables.length + newVariables.length);
        IEnvironmentVariable[] iEnvironmentVariableArray = oldVariables;
        int n = oldVariables.length;
        int n2 = 0;
        while (n2 < n) {
            variable = iEnvironmentVariableArray[n2];
            vars.put(variable.getName(), variable);
            ++n2;
        }
        iEnvironmentVariableArray = newVariables;
        n = newVariables.length;
        n2 = 0;
        while (n2 < n) {
            variable = iEnvironmentVariableArray[n2];
            if (!vars.containsKey(variable.getName())) {
                vars.put(variable.getName(), variable);
            } else {
                vars.put(variable.getName(), EnvVarOperationProcessor.performOperation((IEnvironmentVariable)vars.get(variable.getName()), variable));
            }
            ++n2;
        }
        return vars.values().toArray(new IEnvironmentVariable[vars.size()]);
    }

    public IEnvironmentVariable createOverrideVariable(String name, String value, int op, String delimiter) {
        if (this.getValidName(name) == null) {
            return null;
        }
        return this.fOverrideVariables.createVariable(name, value, op, delimiter);
    }

    public IEnvironmentVariable createVariable(String name, String value, int op, String delimiter, Object context) {
        if (this.getValidName(name) == null) {
            return null;
        }
        StorableEnvironment env = this.getEnvironment(context);
        if (env == null) {
            return null;
        }
        IEnvironmentVariable var = env.createVariable(name, value, op, delimiter);
        if (env.isChanged()) {
            env.setChanged(false);
        }
        return var;
    }

    public IEnvironmentVariable deleteVariable(String name, Object context) {
        StorableEnvironment env = this.getEnvironment(context);
        if (env == null) {
            return null;
        }
        IEnvironmentVariable var = env.deleteVariable(name);
        return var;
    }

    public void deleteAll(Object context) {
        StorableEnvironment env = this.getEnvironment(context);
        if (env == null) {
            return;
        }
        env.deleteAll();
    }

    public void setVariables(IEnvironmentVariable[] vars, Object context) {
        StorableEnvironment env = this.getEnvironment(context);
        if (env == null) {
            return;
        }
        env.setVariales(vars);
        if (env.isChanged()) {
            env.setChanged(false);
        }
    }

    protected String getValidName(String name) {
        if (name == null || (name = name.trim()).length() == 0) {
            return null;
        }
        return name;
    }

    protected IEnvironmentVariable[] filterVariables(IEnvironmentVariable[] variables) {
        return EnvVarOperationProcessor.filterVariables(variables, null);
    }

    @Override
    public boolean appendEnvironment(Object context) {
        StorableEnvironment env = this.getEnvironment(context);
        if (env == null) {
            return true;
        }
        return env.appendEnvironment();
    }

    public boolean appendContributedEnvironment(Object context) {
        StorableEnvironment env = this.getEnvironment(context);
        if (env == null) {
            return true;
        }
        return env.appendContributedEnvironment();
    }

    public void setAppendEnvironment(boolean append, Object context) {
        StorableEnvironment env = this.getEnvironment(context);
        if (env != null) {
            env.setAppendEnvironment(append);
        }
    }

    public void setAppendContributedEnvironment(boolean append, Object context) {
        StorableEnvironment env = this.getEnvironment(context);
        if (env != null) {
            env.setAppendContributedEnvironment(append);
        }
    }

    public void restoreDefaults(Object context) {
        StorableEnvironment env = this.getEnvironment(context);
        if (env != null) {
            env.restoreDefaults();
        }
    }

    public void registerEnvironmentChangeListener(IEnvironmentChangeListener listener) {
        if (this.fWorkspaceVariables == null) {
            this.getEnvironment(null, false);
        }
        if (this.fWorkspaceVariables != null) {
            this.fWorkspaceVariables.registerEnvironmentChangeListener(listener);
        }
    }

    public void unregisterEnvironmentChangeListener(IEnvironmentChangeListener listener) {
        if (this.fWorkspaceVariables != null) {
            this.fWorkspaceVariables.unregisterEnvironmentChangeListener(listener);
        }
    }
}

